<?php

declare(strict_types=1);

namespace Drupal\flowdrop\Routing;

use Drupal\Core\Routing\RouteSubscriberBase;
use Symfony\Component\Routing\RouteCollection;

/**
 * Route subscriber for FlowDrop module.
 *
 * Automatically applies admin theme to all routes under /admin/flowdrop/*.
 */
final class RouteSubscriber extends RouteSubscriberBase {

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection): void {
    // Apply admin theme to all routes under /admin/flowdrop/*.
    foreach ($collection->all() as $route) {
      $path = $route->getPath();

      // Check if the route path starts with /admin/flowdrop.
      if (str_starts_with($path, "/admin/flowdrop")) {
        // Set the _admin_route option to apply admin theme.
        $route->setOption("_admin_route", TRUE);
      }
    }
  }

}
