<?php

declare(strict_types=1);

namespace Drupal\flowdrop_trigger\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines a FlowDrop Event Type plugin attribute.
 *
 * Event type plugins define the different types of events that can
 * trigger workflow execution (e.g., entity.insert, user.login).
 *
 * @see \Drupal\flowdrop_trigger\Service\EventTypePluginManager
 * @see \Drupal\flowdrop_trigger\FlowDropEventTypeInterface
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class FlowDropEventType extends Plugin {

  /**
   * Constructs a FlowDropEventType attribute.
   *
   * @param string $id
   *   The plugin ID (e.g., "entity.insert", "user.login").
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $label
   *   The human-readable label for the event type.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $description
   *   A description of when this event fires.
   * @param string $category
   *   The event category (entity, user, system).
   * @param string $defaultOrchestrator
   *   Default orchestrator type (synchronous, asynchronous).
   * @param string $defaultExecutionMode
   *   Default execution mode (sync, async).
   * @param array $supportedEntityTypes
   *   Supported entity types (empty array = all entity types).
   */
  public function __construct(
    public readonly string $id,
    public readonly TranslatableMarkup $label,
    public readonly TranslatableMarkup $description,
    public readonly string $category = "entity",
    public readonly string $defaultOrchestrator = "asynchronous",
    public readonly string $defaultExecutionMode = "async",
    public readonly array $supportedEntityTypes = [],
  ) {}

}
