<?php

declare(strict_types=1);

namespace Drupal\flowdrop\Plugin\FlowDropNodeProcessor;

use Drupal\flowdrop\DTO\OutputInterface;
use Drupal\flowdrop\DTO\ParameterBagInterface;

/**
 * Interface for node executors.
 *
 * This interface defines the contract for node processors that
 * execute workflow nodes using the Unified Parameter System.
 */
interface NodeExecutorInterface {

  /**
   * Execute a node with resolved parameters.
   *
   * @param \Drupal\flowdrop\DTO\ParameterBagInterface $params
   *   The resolved parameters (merged from config,
   *   workflow values, and inputs).
   *
   * @return \Drupal\flowdrop\DTO\OutputInterface
   *   The execution result.
   *
   * @throws \Exception
   *   When execution fails.
   */
  public function execute(ParameterBagInterface $params): OutputInterface;

}
