var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __typeError = (msg) => {
  throw TypeError(msg);
};
var __defNormalProp = (obj, key2, value) => key2 in obj ? __defProp(obj, key2, { enumerable: true, configurable: true, writable: true, value }) : obj[key2] = value;
var __spreadValues = (a, b2) => {
  for (var prop2 in b2 || (b2 = {}))
    if (__hasOwnProp.call(b2, prop2))
      __defNormalProp(a, prop2, b2[prop2]);
  if (__getOwnPropSymbols)
    for (var prop2 of __getOwnPropSymbols(b2)) {
      if (__propIsEnum.call(b2, prop2))
        __defNormalProp(a, prop2, b2[prop2]);
    }
  return a;
};
var __spreadProps = (a, b2) => __defProps(a, __getOwnPropDescs(b2));
var __objRest = (source2, exclude) => {
  var target = {};
  for (var prop2 in source2)
    if (__hasOwnProp.call(source2, prop2) && exclude.indexOf(prop2) < 0)
      target[prop2] = source2[prop2];
  if (source2 != null && __getOwnPropSymbols)
    for (var prop2 of __getOwnPropSymbols(source2)) {
      if (exclude.indexOf(prop2) < 0 && __propIsEnum.call(source2, prop2))
        target[prop2] = source2[prop2];
    }
  return target;
};
var __publicField = (obj, key2, value) => __defNormalProp(obj, typeof key2 !== "symbol" ? key2 + "" : key2, value);
var __accessCheck = (obj, member, msg) => member.has(obj) || __typeError("Cannot " + msg);
var __privateGet = (obj, member, getter) => (__accessCheck(obj, member, "read from private field"), getter ? getter.call(obj) : member.get(obj));
var __privateAdd = (obj, member, value) => member.has(obj) ? __typeError("Cannot add the same private member more than once") : member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
var __privateSet = (obj, member, value, setter) => (__accessCheck(obj, member, "write to private field"), setter ? setter.call(obj, value) : member.set(obj, value), value);
var __privateMethod = (obj, member, method) => (__accessCheck(obj, member, "access private method"), method);
var __async = (__this, __arguments, generator) => {
  return new Promise((resolve, reject) => {
    var fulfilled = (value) => {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    };
    var rejected = (value) => {
      try {
        step(generator.throw(value));
      } catch (e) {
        reject(e);
      }
    };
    var step = (x) => x.done ? resolve(x.value) : Promise.resolve(x.value).then(fulfilled, rejected);
    step((generator = generator.apply(__this, __arguments)).next());
  });
};
var _a, _b, _c, _listeners, _observer, _options, _ResizeObserverSingleton_instances, getObserver_fn, _fn, _subscribe, _d;
class FlowDropApiClient {
  constructor(baseUrl, apiKey) {
    __publicField(this, "baseUrl");
    __publicField(this, "headers");
    this.baseUrl = baseUrl.replace(/\/$/, "");
    this.headers = {
      "Content-Type": "application/json"
    };
    if (apiKey) {
      this.headers["Authorization"] = `Bearer ${apiKey}`;
    }
  }
  /**
   * Make HTTP request with error handling
   */
  request(_0) {
    return __async(this, arguments, function* (endpoint, options = {}) {
      const url = `${this.baseUrl}${endpoint}`;
      const config = __spreadValues({
        headers: this.headers
      }, options);
      try {
        const response = yield fetch(url, config);
        if (!response.ok) {
          throw new Error(`HTTP ${response.status}: ${response.statusText}`);
        }
        const data = yield response.json();
        return data;
      } catch (error) {
        console.error("API request failed:", error);
        throw new Error(
          `API request failed: ${error instanceof Error ? error.message : "Unknown error"}`
        );
      }
    });
  }
  /**
   * Fetch available node types and their metadata
   */
  getAvailableNodes() {
    return __async(this, null, function* () {
      const response = yield this.request("/api/flowdrop/nodes");
      if (!response.success || !response.data) {
        throw new Error(response.error || "Failed to fetch available nodes");
      }
      return response.data;
    });
  }
  /**
   * Fetch nodes by category
   */
  getNodesByCategory(category) {
    return __async(this, null, function* () {
      const response = yield this.request(
        `/api/nodes?category=${encodeURIComponent(category)}`
      );
      if (!response.success || !response.data) {
        throw new Error(response.error || "Failed to fetch nodes by category");
      }
      return response.data;
    });
  }
  /**
   * Fetch a specific node's metadata
   */
  getNodeMetadata(nodeId) {
    return __async(this, null, function* () {
      const response = yield this.request(
        `/api/nodes/${encodeURIComponent(nodeId)}`
      );
      if (!response.success || !response.data) {
        throw new Error(response.error || "Failed to fetch node metadata");
      }
      return response.data;
    });
  }
  /**
   * Save a workflow
   */
  saveWorkflow(workflow) {
    return __async(this, null, function* () {
      const response = yield this.request("/api/flowdrop/workflows", {
        method: "POST",
        body: JSON.stringify(workflow)
      });
      if (!response.success || !response.data) {
        throw new Error(response.error || "Failed to save workflow");
      }
      return response.data;
    });
  }
  /**
   * Update an existing workflow
   */
  updateWorkflow(workflowId, workflow) {
    return __async(this, null, function* () {
      const response = yield this.request(
        `/api/workflows/${encodeURIComponent(workflowId)}`,
        {
          method: "PUT",
          body: JSON.stringify(workflow)
        }
      );
      if (!response.success || !response.data) {
        throw new Error(response.error || "Failed to update workflow");
      }
      return response.data;
    });
  }
  /**
   * Load a workflow by ID
   */
  loadWorkflow(workflowId) {
    return __async(this, null, function* () {
      const response = yield this.request(
        `/api/workflows/${encodeURIComponent(workflowId)}`
      );
      if (!response.success || !response.data) {
        throw new Error(response.error || "Failed to load workflow");
      }
      return response.data;
    });
  }
  /**
   * List all workflows
   */
  listWorkflows() {
    return __async(this, null, function* () {
      const response = yield this.request("/api/flowdrop/workflows");
      if (!response.success || !response.data) {
        throw new Error(response.error || "Failed to list workflows");
      }
      return response.data;
    });
  }
  /**
   * Delete a workflow
   */
  deleteWorkflow(workflowId) {
    return __async(this, null, function* () {
      const response = yield this.request(
        `/api/workflows/${encodeURIComponent(workflowId)}`,
        {
          method: "DELETE"
        }
      );
      if (!response.success) {
        throw new Error(response.error || "Failed to delete workflow");
      }
    });
  }
  /**
   * Execute a workflow
   */
  executeWorkflow(workflowId, inputs) {
    return __async(this, null, function* () {
      const response = yield this.request(
        `/api/workflows/${encodeURIComponent(workflowId)}/execute`,
        {
          method: "POST",
          body: JSON.stringify({ inputs })
        }
      );
      if (!response.success || !response.data) {
        throw new Error(response.error || "Failed to execute workflow");
      }
      return response.data;
    });
  }
  /**
   * Get execution status
   */
  getExecutionStatus(executionId) {
    return __async(this, null, function* () {
      const response = yield this.request(
        `/api/executions/${encodeURIComponent(executionId)}`
      );
      if (!response.success || !response.data) {
        throw new Error(response.error || "Failed to get execution status");
      }
      return response.data;
    });
  }
  /**
   * Cancel workflow execution
   */
  cancelExecution(executionId) {
    return __async(this, null, function* () {
      const response = yield this.request(
        `/api/executions/${encodeURIComponent(executionId)}/cancel`,
        {
          method: "POST"
        }
      );
      if (!response.success) {
        throw new Error(response.error || "Failed to cancel execution");
      }
    });
  }
  /**
   * Get execution logs
   */
  getExecutionLogs(executionId) {
    return __async(this, null, function* () {
      const response = yield this.request(
        `/api/executions/${encodeURIComponent(executionId)}/logs`
      );
      if (!response.success || !response.data) {
        throw new Error(response.error || "Failed to get execution logs");
      }
      return response.data;
    });
  }
  /**
   * Validate workflow configuration
   */
  validateWorkflow(workflow) {
    return __async(this, null, function* () {
      const response = yield this.request(
        "/api/flowdrop/workflows/validate",
        {
          method: "POST",
          body: JSON.stringify(workflow)
        }
      );
      if (!response.success || !response.data) {
        throw new Error(response.error || "Failed to validate workflow");
      }
      return response.data;
    });
  }
  /**
   * Export workflow as JSON
   */
  exportWorkflow(workflowId) {
    return __async(this, null, function* () {
      const response = yield this.request(
        `/api/workflows/${encodeURIComponent(workflowId)}/export`
      );
      if (!response.success || !response.data) {
        throw new Error(response.error || "Failed to export workflow");
      }
      return response.data;
    });
  }
  /**
   * Import workflow from JSON
   */
  importWorkflow(workflowJson) {
    return __async(this, null, function* () {
      const response = yield this.request("/api/flowdrop/workflows/import", {
        method: "POST",
        body: JSON.stringify({ workflow: workflowJson })
      });
      if (!response.success || !response.data) {
        throw new Error(response.error || "Failed to import workflow");
      }
      return response.data;
    });
  }
  /**
   * Fetch port configuration
   */
  getPortConfig() {
    return __async(this, null, function* () {
      const response = yield this.request("/api/flowdrop/port-config");
      if (!response.success || !response.data) {
        throw new Error(response.error || "Failed to fetch port configuration");
      }
      return response.data;
    });
  }
}
const defaultEndpointConfig = {
  baseUrl: "/api/flowdrop",
  endpoints: {
    nodes: {
      list: "/nodes",
      get: "/nodes/{id}",
      byCategory: "/nodes?category={category}",
      metadata: "/nodes/{id}/metadata"
    },
    portConfig: "/port-config",
    workflows: {
      list: "/workflows",
      get: "/workflows/{id}",
      create: "/workflows",
      update: "/workflows/{id}",
      delete: "/workflows/{id}",
      validate: "/workflows/validate",
      export: "/workflows/{id}/export",
      import: "/workflows/import"
    },
    executions: {
      execute: "/workflows/{id}/execute",
      status: "/executions/{id}",
      cancel: "/executions/{id}/cancel",
      logs: "/executions/{id}/logs",
      history: "/executions"
    },
    templates: {
      list: "/templates",
      get: "/templates/{id}",
      create: "/templates",
      update: "/templates/{id}",
      delete: "/templates/{id}"
    },
    users: {
      profile: "/users/profile",
      preferences: "/users/preferences"
    },
    system: {
      health: "/system/health",
      config: "/system/config",
      version: "/system/version"
    }
  },
  timeout: 3e4,
  retry: {
    enabled: true,
    maxAttempts: 3,
    delay: 1e3,
    backoff: "exponential"
  }
};
function createEndpointConfig(baseUrl, overrides) {
  const config = __spreadValues(__spreadProps(__spreadValues({}, defaultEndpointConfig), {
    baseUrl: baseUrl.replace(/\/$/, "")
  }), overrides);
  return config;
}
function buildEndpointUrl(config, endpointPath, params) {
  let url = endpointPath;
  if (params) {
    Object.entries(params).forEach(([key2, value]) => {
      url = url.replace(`{${key2}}`, encodeURIComponent(value));
    });
  }
  if (!url.startsWith("http") && !url.startsWith("//")) {
    url = `${config.baseUrl}${url.startsWith("/") ? url : `/${url}`}`;
  }
  return url;
}
function getEndpointMethod(config, endpointKey) {
  var _a2;
  return ((_a2 = config.methods) == null ? void 0 : _a2[endpointKey]) || "GET";
}
function getEndpointHeaders(config, endpointKey) {
  var _a2, _b2, _c2, _d2;
  const baseHeaders = {
    "Content-Type": "application/json"
  };
  if (((_a2 = config.auth) == null ? void 0 : _a2.type) === "bearer" && config.auth.token) {
    baseHeaders["Authorization"] = `Bearer ${config.auth.token}`;
  } else if (((_b2 = config.auth) == null ? void 0 : _b2.type) === "api_key" && config.auth.apiKey) {
    baseHeaders["X-API-Key"] = config.auth.apiKey;
  } else if (((_c2 = config.auth) == null ? void 0 : _c2.type) === "custom" && config.auth.headers) {
    Object.assign(baseHeaders, config.auth.headers);
  }
  const endpointHeaders = (_d2 = config.headers) == null ? void 0 : _d2[endpointKey];
  if (endpointHeaders) {
    Object.assign(baseHeaders, endpointHeaders);
  }
  return baseHeaders;
}
const endpoints = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  buildEndpointUrl,
  createEndpointConfig,
  defaultEndpointConfig,
  getEndpointHeaders,
  getEndpointMethod
}, Symbol.toStringTag, { value: "Module" }));
class EnhancedFlowDropApiClient {
  constructor(config) {
    __publicField(this, "config");
    this.config = config;
  }
  /**
   * Make HTTP request with error handling and retry logic
   */
  request(_0, _1, _2) {
    return __async(this, arguments, function* (endpointKey, endpointPath, params, options = {}) {
      var _a2, _b2, _c2;
      const url = buildEndpointUrl(this.config, endpointPath, params);
      const method = getEndpointMethod(this.config, endpointKey);
      const headers = getEndpointHeaders(this.config, endpointKey);
      const config = __spreadValues({
        method,
        headers
      }, options);
      let lastError = null;
      const maxAttempts = ((_a2 = this.config.retry) == null ? void 0 : _a2.enabled) ? this.config.retry.maxAttempts : 1;
      for (let attempt = 1; attempt <= maxAttempts; attempt++) {
        try {
          const response = yield fetch(url, config);
          if (!response.ok) {
            const errorData = yield response.json().catch(() => ({}));
            throw new Error(errorData.error || `HTTP ${response.status}: ${response.statusText}`);
          }
          const data = yield response.json();
          return data;
        } catch (error) {
          lastError = error instanceof Error ? error : new Error(String(error));
          if (attempt === maxAttempts) {
            console.error(`API request failed after ${maxAttempts} attempts:`, lastError);
            throw lastError;
          }
          const delay = ((_b2 = this.config.retry) == null ? void 0 : _b2.delay) || 1e3;
          const backoffDelay = ((_c2 = this.config.retry) == null ? void 0 : _c2.backoff) === "exponential" ? delay * Math.pow(2, attempt - 1) : delay;
          yield new Promise((resolve) => setTimeout(resolve, backoffDelay));
        }
      }
      throw lastError;
    });
  }
  // Node API Methods
  getAvailableNodes() {
    return __async(this, null, function* () {
      const response = yield this.request(
        "nodes.list",
        this.config.endpoints.nodes.list
      );
      if (!response.success || !response.data) {
        throw new Error(response.error || "Failed to fetch available nodes");
      }
      return response.data;
    });
  }
  getNodesByCategory(category) {
    return __async(this, null, function* () {
      const response = yield this.request(
        "nodes.byCategory",
        this.config.endpoints.nodes.byCategory,
        { category }
      );
      if (!response.success || !response.data) {
        throw new Error(response.error || "Failed to fetch nodes by category");
      }
      return response.data;
    });
  }
  getNodeMetadata(nodeId) {
    return __async(this, null, function* () {
      const response = yield this.request(
        "nodes.metadata",
        this.config.endpoints.nodes.metadata,
        { id: nodeId }
      );
      if (!response.success || !response.data) {
        throw new Error(response.error || "Failed to fetch node metadata");
      }
      return response.data;
    });
  }
  // Workflow API Methods
  saveWorkflow(workflow) {
    return __async(this, null, function* () {
      const response = yield this.request(
        "workflows.create",
        this.config.endpoints.workflows.create,
        void 0,
        {
          method: "POST",
          body: JSON.stringify(workflow)
        }
      );
      if (!response.success || !response.data) {
        throw new Error(response.error || "Failed to save workflow");
      }
      return response.data;
    });
  }
  updateWorkflow(workflowId, workflow) {
    return __async(this, null, function* () {
      const response = yield this.request(
        "workflows.update",
        this.config.endpoints.workflows.update,
        { id: workflowId },
        {
          method: "PUT",
          body: JSON.stringify(workflow)
        }
      );
      if (!response.success || !response.data) {
        throw new Error(response.error || "Failed to update workflow");
      }
      return response.data;
    });
  }
  loadWorkflow(workflowId) {
    return __async(this, null, function* () {
      const response = yield this.request(
        "workflows.get",
        this.config.endpoints.workflows.get,
        { id: workflowId }
      );
      if (!response.success || !response.data) {
        throw new Error(response.error || "Failed to load workflow");
      }
      return response.data;
    });
  }
  listWorkflows() {
    return __async(this, null, function* () {
      const response = yield this.request(
        "workflows.list",
        this.config.endpoints.workflows.list
      );
      if (!response.success || !response.data) {
        throw new Error(response.error || "Failed to list workflows");
      }
      return response.data;
    });
  }
  deleteWorkflow(workflowId) {
    return __async(this, null, function* () {
      const response = yield this.request(
        "workflows.delete",
        this.config.endpoints.workflows.delete,
        { id: workflowId },
        { method: "DELETE" }
      );
      if (!response.success) {
        throw new Error(response.error || "Failed to delete workflow");
      }
    });
  }
  validateWorkflow(workflow) {
    return __async(this, null, function* () {
      const response = yield this.request(
        "workflows.validate",
        this.config.endpoints.workflows.validate,
        void 0,
        {
          method: "POST",
          body: JSON.stringify(workflow)
        }
      );
      if (!response.success || !response.data) {
        throw new Error(response.error || "Failed to validate workflow");
      }
      return response.data;
    });
  }
  exportWorkflow(workflowId) {
    return __async(this, null, function* () {
      const response = yield this.request(
        "workflows.export",
        this.config.endpoints.workflows.export,
        { id: workflowId }
      );
      if (!response.success || !response.data) {
        throw new Error(response.error || "Failed to export workflow");
      }
      return response.data;
    });
  }
  importWorkflow(workflowJson) {
    return __async(this, null, function* () {
      const response = yield this.request(
        "workflows.import",
        this.config.endpoints.workflows.import,
        void 0,
        {
          method: "POST",
          body: JSON.stringify({ workflow: workflowJson })
        }
      );
      if (!response.success || !response.data) {
        throw new Error(response.error || "Failed to import workflow");
      }
      return response.data;
    });
  }
  // Execution API Methods
  executeWorkflow(workflowId, inputs) {
    return __async(this, null, function* () {
      const response = yield this.request(
        "executions.execute",
        this.config.endpoints.executions.execute,
        { id: workflowId },
        {
          method: "POST",
          body: JSON.stringify({ inputs })
        }
      );
      if (!response.success || !response.data) {
        throw new Error(response.error || "Failed to execute workflow");
      }
      return response.data;
    });
  }
  getExecutionStatus(executionId) {
    return __async(this, null, function* () {
      const response = yield this.request(
        "executions.status",
        this.config.endpoints.executions.status,
        { id: executionId }
      );
      if (!response.success || !response.data) {
        throw new Error(response.error || "Failed to get execution status");
      }
      return response.data;
    });
  }
  cancelExecution(executionId) {
    return __async(this, null, function* () {
      const response = yield this.request(
        "executions.cancel",
        this.config.endpoints.executions.cancel,
        { id: executionId },
        { method: "POST" }
      );
      if (!response.success) {
        throw new Error(response.error || "Failed to cancel execution");
      }
    });
  }
  getExecutionLogs(executionId) {
    return __async(this, null, function* () {
      const response = yield this.request(
        "executions.logs",
        this.config.endpoints.executions.logs,
        { id: executionId }
      );
      if (!response.success || !response.data) {
        throw new Error(response.error || "Failed to get execution logs");
      }
      return response.data;
    });
  }
  // Template API Methods
  listTemplates() {
    return __async(this, null, function* () {
      const response = yield this.request(
        "templates.list",
        this.config.endpoints.templates.list
      );
      if (!response.success || !response.data) {
        throw new Error(response.error || "Failed to list templates");
      }
      return response.data;
    });
  }
  getTemplate(templateId) {
    return __async(this, null, function* () {
      const response = yield this.request(
        "templates.get",
        this.config.endpoints.templates.get,
        { id: templateId }
      );
      if (!response.success || !response.data) {
        throw new Error(response.error || "Failed to get template");
      }
      return response.data;
    });
  }
  // System API Methods
  getSystemHealth() {
    return __async(this, null, function* () {
      const response = yield this.request(
        "system.health",
        this.config.endpoints.system.health
      );
      if (!response.success || !response.data) {
        throw new Error(response.error || "Failed to get system health");
      }
      return response.data;
    });
  }
  getSystemConfig() {
    return __async(this, null, function* () {
      const response = yield this.request(
        "system.config",
        this.config.endpoints.system.config
      );
      if (!response.success || !response.data) {
        throw new Error(response.error || "Failed to get system config");
      }
      return response.data;
    });
  }
  getSystemVersion() {
    return __async(this, null, function* () {
      const response = yield this.request(
        "system.version",
        this.config.endpoints.system.version
      );
      if (!response.success || !response.data) {
        throw new Error(response.error || "Failed to get system version");
      }
      return response.data;
    });
  }
}
const PUBLIC_VERSION = "5";
if (typeof window !== "undefined") {
  ((_c = (_b = (_a = window.__svelte) != null ? _a : window.__svelte = {}).v) != null ? _c : _b.v = /* @__PURE__ */ new Set()).add(PUBLIC_VERSION);
}
const EACH_ITEM_REACTIVE = 1;
const EACH_INDEX_REACTIVE = 1 << 1;
const EACH_IS_CONTROLLED = 1 << 2;
const EACH_IS_ANIMATED = 1 << 3;
const EACH_ITEM_IMMUTABLE = 1 << 4;
const PROPS_IS_IMMUTABLE = 1;
const PROPS_IS_RUNES = 1 << 1;
const PROPS_IS_UPDATED = 1 << 2;
const PROPS_IS_BINDABLE = 1 << 3;
const PROPS_IS_LAZY_INITIAL = 1 << 4;
const TEMPLATE_FRAGMENT = 1;
const TEMPLATE_USE_IMPORT_NODE = 1 << 1;
const UNINITIALIZED = Symbol();
const NAMESPACE_HTML = "http://www.w3.org/1999/xhtml";
const ATTACHMENT_KEY = "@attach";
const DEV = false;
var is_array = Array.isArray;
var index_of = Array.prototype.indexOf;
var array_from = Array.from;
var define_property = Object.defineProperty;
var get_descriptor = Object.getOwnPropertyDescriptor;
var get_descriptors = Object.getOwnPropertyDescriptors;
var object_prototype = Object.prototype;
var array_prototype = Array.prototype;
var get_prototype_of = Object.getPrototypeOf;
var is_extensible = Object.isExtensible;
function is_function(thing) {
  return typeof thing === "function";
}
const noop$1 = () => {
};
function run(fn) {
  return fn();
}
function run_all(arr) {
  for (var i = 0; i < arr.length; i++) {
    arr[i]();
  }
}
function fallback(value, fallback2, lazy = false) {
  return value === void 0 ? lazy ? (
    /** @type {() => V} */
    fallback2()
  ) : (
    /** @type {V} */
    fallback2
  ) : value;
}
function to_array(value, n) {
  if (Array.isArray(value)) {
    return value;
  }
  if (n === void 0 || !(Symbol.iterator in value)) {
    return Array.from(value);
  }
  const array2 = [];
  for (const element of value) {
    array2.push(element);
    if (array2.length === n) break;
  }
  return array2;
}
const DERIVED = 1 << 1;
const EFFECT = 1 << 2;
const RENDER_EFFECT = 1 << 3;
const BLOCK_EFFECT = 1 << 4;
const BRANCH_EFFECT = 1 << 5;
const ROOT_EFFECT = 1 << 6;
const BOUNDARY_EFFECT = 1 << 7;
const UNOWNED = 1 << 8;
const DISCONNECTED = 1 << 9;
const CLEAN = 1 << 10;
const DIRTY = 1 << 11;
const MAYBE_DIRTY = 1 << 12;
const INERT = 1 << 13;
const DESTROYED = 1 << 14;
const EFFECT_RAN = 1 << 15;
const EFFECT_TRANSPARENT = 1 << 16;
const LEGACY_DERIVED_PROP = 1 << 17;
const INSPECT_EFFECT = 1 << 18;
const HEAD_EFFECT = 1 << 19;
const EFFECT_HAS_DERIVED = 1 << 20;
const EFFECT_IS_UPDATING = 1 << 21;
const STATE_SYMBOL = Symbol("$state");
const LEGACY_PROPS = Symbol("legacy props");
const LOADING_ATTR_SYMBOL = Symbol("");
function equals(value) {
  return value === this.v;
}
function safe_not_equal(a, b2) {
  return a != a ? b2 == b2 : a !== b2 || a !== null && typeof a === "object" || typeof a === "function";
}
function safe_equals(value) {
  return !safe_not_equal(value, this.v);
}
function effect_in_teardown(rune) {
  {
    throw new Error(`https://svelte.dev/e/effect_in_teardown`);
  }
}
function effect_in_unowned_derived() {
  {
    throw new Error(`https://svelte.dev/e/effect_in_unowned_derived`);
  }
}
function effect_orphan(rune) {
  {
    throw new Error(`https://svelte.dev/e/effect_orphan`);
  }
}
function effect_update_depth_exceeded() {
  {
    throw new Error(`https://svelte.dev/e/effect_update_depth_exceeded`);
  }
}
function props_invalid_value(key2) {
  {
    throw new Error(`https://svelte.dev/e/props_invalid_value`);
  }
}
function state_descriptors_fixed() {
  {
    throw new Error(`https://svelte.dev/e/state_descriptors_fixed`);
  }
}
function state_prototype_fixed() {
  {
    throw new Error(`https://svelte.dev/e/state_prototype_fixed`);
  }
}
function state_unsafe_mutation() {
  {
    throw new Error(`https://svelte.dev/e/state_unsafe_mutation`);
  }
}
let legacy_mode_flag = false;
let tracing_mode_flag = false;
function enable_legacy_mode_flag() {
  legacy_mode_flag = true;
}
const empty$1 = [];
function snapshot(value, skip_warning = false) {
  return clone(value, /* @__PURE__ */ new Map(), "", empty$1);
}
function clone(value, cloned, path, paths, original = null) {
  if (typeof value === "object" && value !== null) {
    var unwrapped = cloned.get(value);
    if (unwrapped !== void 0) return unwrapped;
    if (value instanceof Map) return (
      /** @type {Snapshot<T>} */
      new Map(value)
    );
    if (value instanceof Set) return (
      /** @type {Snapshot<T>} */
      new Set(value)
    );
    if (is_array(value)) {
      var copy = (
        /** @type {Snapshot<any>} */
        Array(value.length)
      );
      cloned.set(value, copy);
      if (original !== null) {
        cloned.set(original, copy);
      }
      for (var i = 0; i < value.length; i += 1) {
        var element = value[i];
        if (i in value) {
          copy[i] = clone(element, cloned, path, paths);
        }
      }
      return copy;
    }
    if (get_prototype_of(value) === object_prototype) {
      copy = {};
      cloned.set(value, copy);
      if (original !== null) {
        cloned.set(original, copy);
      }
      for (var key2 in value) {
        copy[key2] = clone(value[key2], cloned, path, paths);
      }
      return copy;
    }
    if (value instanceof Date) {
      return (
        /** @type {Snapshot<T>} */
        structuredClone(value)
      );
    }
    if (typeof /** @type {T & { toJSON?: any } } */
    value.toJSON === "function") {
      return clone(
        /** @type {T & { toJSON(): any } } */
        value.toJSON(),
        cloned,
        path,
        paths,
        // Associate the instance with the toJSON clone
        value
      );
    }
  }
  if (value instanceof EventTarget) {
    return (
      /** @type {Snapshot<T>} */
      value
    );
  }
  try {
    return (
      /** @type {Snapshot<T>} */
      structuredClone(value)
    );
  } catch (e) {
    return (
      /** @type {Snapshot<T>} */
      value
    );
  }
}
function lifecycle_outside_component(name) {
  {
    throw new Error(`https://svelte.dev/e/lifecycle_outside_component`);
  }
}
let component_context = null;
function set_component_context(context) {
  component_context = context;
}
function getContext(key2) {
  const context_map = get_or_init_context_map();
  const result = (
    /** @type {T} */
    context_map.get(key2)
  );
  return result;
}
function setContext(key2, context) {
  const context_map = get_or_init_context_map();
  context_map.set(key2, context);
  return context;
}
function push(props, runes = false, fn) {
  var ctx = component_context = {
    p: component_context,
    c: null,
    d: false,
    e: null,
    m: false,
    s: props,
    x: null,
    l: null
  };
  if (legacy_mode_flag && !runes) {
    component_context.l = {
      s: null,
      u: null,
      r1: [],
      r2: source(false)
    };
  }
  teardown(() => {
    ctx.d = true;
  });
}
function pop(component2) {
  const context_stack_item = component_context;
  if (context_stack_item !== null) {
    const component_effects = context_stack_item.e;
    if (component_effects !== null) {
      var previous_effect = active_effect;
      var previous_reaction = active_reaction;
      context_stack_item.e = null;
      try {
        for (var i = 0; i < component_effects.length; i++) {
          var component_effect = component_effects[i];
          set_active_effect(component_effect.effect);
          set_active_reaction(component_effect.reaction);
          effect(component_effect.fn);
        }
      } finally {
        set_active_effect(previous_effect);
        set_active_reaction(previous_reaction);
      }
    }
    component_context = context_stack_item.p;
    context_stack_item.m = true;
  }
  return (
    /** @type {T} */
    {}
  );
}
function is_runes() {
  return !legacy_mode_flag || component_context !== null && component_context.l === null;
}
function get_or_init_context_map(name) {
  var _a2;
  if (component_context === null) {
    lifecycle_outside_component();
  }
  return (_a2 = component_context.c) != null ? _a2 : component_context.c = new Map(get_parent_context(component_context) || void 0);
}
function get_parent_context(component_context2) {
  let parent = component_context2.p;
  while (parent !== null) {
    const context_map = parent.c;
    if (context_map !== null) {
      return context_map;
    }
    parent = parent.p;
  }
  return null;
}
function proxy(value) {
  if (typeof value !== "object" || value === null || STATE_SYMBOL in value) {
    return value;
  }
  const prototype = get_prototype_of(value);
  if (prototype !== object_prototype && prototype !== array_prototype) {
    return value;
  }
  var sources = /* @__PURE__ */ new Map();
  var is_proxied_array = is_array(value);
  var version = /* @__PURE__ */ state(0);
  var reaction = active_reaction;
  var with_parent = (fn) => {
    var previous_reaction = active_reaction;
    set_active_reaction(reaction);
    var result = fn();
    set_active_reaction(previous_reaction);
    return result;
  };
  if (is_proxied_array) {
    sources.set("length", /* @__PURE__ */ state(
      /** @type {any[]} */
      value.length
    ));
  }
  return new Proxy(
    /** @type {any} */
    value,
    {
      defineProperty(_2, prop2, descriptor) {
        if (!("value" in descriptor) || descriptor.configurable === false || descriptor.enumerable === false || descriptor.writable === false) {
          state_descriptors_fixed();
        }
        var s = sources.get(prop2);
        if (s === void 0) {
          s = with_parent(() => {
            var s2 = /* @__PURE__ */ state(descriptor.value);
            sources.set(prop2, s2);
            return s2;
          });
        } else {
          set$2(s, descriptor.value, true);
        }
        return true;
      },
      deleteProperty(target, prop2) {
        var s = sources.get(prop2);
        if (s === void 0) {
          if (prop2 in target) {
            const s2 = with_parent(() => /* @__PURE__ */ state(UNINITIALIZED));
            sources.set(prop2, s2);
            update_version(version);
          }
        } else {
          if (is_proxied_array && typeof prop2 === "string") {
            var ls = (
              /** @type {Source<number>} */
              sources.get("length")
            );
            var n = Number(prop2);
            if (Number.isInteger(n) && n < ls.v) {
              set$2(ls, n);
            }
          }
          set$2(s, UNINITIALIZED);
          update_version(version);
        }
        return true;
      },
      get(target, prop2, receiver) {
        var _a2;
        if (prop2 === STATE_SYMBOL) {
          return value;
        }
        var s = sources.get(prop2);
        var exists = prop2 in target;
        if (s === void 0 && (!exists || ((_a2 = get_descriptor(target, prop2)) == null ? void 0 : _a2.writable))) {
          s = with_parent(() => {
            var p = proxy(exists ? target[prop2] : UNINITIALIZED);
            var s2 = /* @__PURE__ */ state(p);
            return s2;
          });
          sources.set(prop2, s);
        }
        if (s !== void 0) {
          var v2 = get$3(s);
          return v2 === UNINITIALIZED ? void 0 : v2;
        }
        return Reflect.get(target, prop2, receiver);
      },
      getOwnPropertyDescriptor(target, prop2) {
        var descriptor = Reflect.getOwnPropertyDescriptor(target, prop2);
        if (descriptor && "value" in descriptor) {
          var s = sources.get(prop2);
          if (s) descriptor.value = get$3(s);
        } else if (descriptor === void 0) {
          var source2 = sources.get(prop2);
          var value2 = source2 == null ? void 0 : source2.v;
          if (source2 !== void 0 && value2 !== UNINITIALIZED) {
            return {
              enumerable: true,
              configurable: true,
              value: value2,
              writable: true
            };
          }
        }
        return descriptor;
      },
      has(target, prop2) {
        var _a2;
        if (prop2 === STATE_SYMBOL) {
          return true;
        }
        var s = sources.get(prop2);
        var has = s !== void 0 && s.v !== UNINITIALIZED || Reflect.has(target, prop2);
        if (s !== void 0 || active_effect !== null && (!has || ((_a2 = get_descriptor(target, prop2)) == null ? void 0 : _a2.writable))) {
          if (s === void 0) {
            s = with_parent(() => {
              var p = has ? proxy(target[prop2]) : UNINITIALIZED;
              var s2 = /* @__PURE__ */ state(p);
              return s2;
            });
            sources.set(prop2, s);
          }
          var value2 = get$3(s);
          if (value2 === UNINITIALIZED) {
            return false;
          }
        }
        return has;
      },
      set(target, prop2, value2, receiver) {
        var _a2;
        var s = sources.get(prop2);
        var has = prop2 in target;
        if (is_proxied_array && prop2 === "length") {
          for (var i = value2; i < /** @type {Source<number>} */
          s.v; i += 1) {
            var other_s = sources.get(i + "");
            if (other_s !== void 0) {
              set$2(other_s, UNINITIALIZED);
            } else if (i in target) {
              other_s = with_parent(() => /* @__PURE__ */ state(UNINITIALIZED));
              sources.set(i + "", other_s);
            }
          }
        }
        if (s === void 0) {
          if (!has || ((_a2 = get_descriptor(target, prop2)) == null ? void 0 : _a2.writable)) {
            s = with_parent(() => /* @__PURE__ */ state(void 0));
            set$2(s, proxy(value2));
            sources.set(prop2, s);
          }
        } else {
          has = s.v !== UNINITIALIZED;
          var p = with_parent(() => proxy(value2));
          set$2(s, p);
        }
        var descriptor = Reflect.getOwnPropertyDescriptor(target, prop2);
        if (descriptor == null ? void 0 : descriptor.set) {
          descriptor.set.call(receiver, value2);
        }
        if (!has) {
          if (is_proxied_array && typeof prop2 === "string") {
            var ls = (
              /** @type {Source<number>} */
              sources.get("length")
            );
            var n = Number(prop2);
            if (Number.isInteger(n) && n >= ls.v) {
              set$2(ls, n + 1);
            }
          }
          update_version(version);
        }
        return true;
      },
      ownKeys(target) {
        get$3(version);
        var own_keys = Reflect.ownKeys(target).filter((key3) => {
          var source3 = sources.get(key3);
          return source3 === void 0 || source3.v !== UNINITIALIZED;
        });
        for (var [key2, source2] of sources) {
          if (source2.v !== UNINITIALIZED && !(key2 in target)) {
            own_keys.push(key2);
          }
        }
        return own_keys;
      },
      setPrototypeOf() {
        state_prototype_fixed();
      }
    }
  );
}
function update_version(signal, d2 = 1) {
  set$2(signal, signal.v + d2);
}
function get_proxied_value(value) {
  try {
    if (value !== null && typeof value === "object" && STATE_SYMBOL in value) {
      return value[STATE_SYMBOL];
    }
  } catch (e) {
  }
  return value;
}
function is(a, b2) {
  return Object.is(get_proxied_value(a), get_proxied_value(b2));
}
// @__NO_SIDE_EFFECTS__
function derived$1(fn) {
  var flags = DERIVED | DIRTY;
  var parent_derived = active_reaction !== null && (active_reaction.f & DERIVED) !== 0 ? (
    /** @type {Derived} */
    active_reaction
  ) : null;
  if (active_effect === null || parent_derived !== null && (parent_derived.f & UNOWNED) !== 0) {
    flags |= UNOWNED;
  } else {
    active_effect.f |= EFFECT_HAS_DERIVED;
  }
  const signal = {
    ctx: component_context,
    deps: null,
    effects: null,
    equals,
    f: flags,
    fn,
    reactions: null,
    rv: 0,
    v: (
      /** @type {V} */
      null
    ),
    wv: 0,
    parent: parent_derived != null ? parent_derived : active_effect
  };
  return signal;
}
// @__NO_SIDE_EFFECTS__
function user_derived(fn) {
  const d2 = /* @__PURE__ */ derived$1(fn);
  push_reaction_value(d2);
  return d2;
}
// @__NO_SIDE_EFFECTS__
function derived_safe_equal(fn) {
  const signal = /* @__PURE__ */ derived$1(fn);
  signal.equals = safe_equals;
  return signal;
}
function destroy_derived_effects(derived2) {
  var effects = derived2.effects;
  if (effects !== null) {
    derived2.effects = null;
    for (var i = 0; i < effects.length; i += 1) {
      destroy_effect(
        /** @type {Effect} */
        effects[i]
      );
    }
  }
}
function get_derived_parent_effect(derived2) {
  var parent = derived2.parent;
  while (parent !== null) {
    if ((parent.f & DERIVED) === 0) {
      return (
        /** @type {Effect} */
        parent
      );
    }
    parent = parent.parent;
  }
  return null;
}
function execute_derived(derived2) {
  var value;
  var prev_active_effect = active_effect;
  set_active_effect(get_derived_parent_effect(derived2));
  {
    try {
      destroy_derived_effects(derived2);
      value = update_reaction(derived2);
    } finally {
      set_active_effect(prev_active_effect);
    }
  }
  return value;
}
function update_derived(derived2) {
  var value = execute_derived(derived2);
  if (!derived2.equals(value)) {
    derived2.v = value;
    derived2.wv = increment_write_version();
  }
  if (is_destroying_effect) return;
  var status = (skip_reaction || (derived2.f & UNOWNED) !== 0) && derived2.deps !== null ? MAYBE_DIRTY : CLEAN;
  set_signal_status(derived2, status);
}
const old_values = /* @__PURE__ */ new Map();
function source(v2, stack) {
  var signal = {
    f: 0,
    // TODO ideally we could skip this altogether, but it causes type errors
    v: v2,
    reactions: null,
    equals,
    rv: 0,
    wv: 0
  };
  return signal;
}
// @__NO_SIDE_EFFECTS__
function state(v2, stack) {
  const s = source(v2);
  push_reaction_value(s);
  return s;
}
// @__NO_SIDE_EFFECTS__
function mutable_source(initial_value, immutable = false, trackable = true) {
  var _a2, _b2;
  const s = source(initial_value);
  if (!immutable) {
    s.equals = safe_equals;
  }
  if (legacy_mode_flag && trackable && component_context !== null && component_context.l !== null) {
    ((_b2 = (_a2 = component_context.l).s) != null ? _b2 : _a2.s = []).push(s);
  }
  return s;
}
function set$2(source2, value, should_proxy = false) {
  if (active_reaction !== null && // since we are untracking the function inside `$inspect.with` we need to add this check
  // to ensure we error if state is set inside an inspect effect
  (!untracking || (active_reaction.f & INSPECT_EFFECT) !== 0) && is_runes() && (active_reaction.f & (DERIVED | BLOCK_EFFECT | INSPECT_EFFECT)) !== 0 && !((reaction_sources == null ? void 0 : reaction_sources[1].includes(source2)) && reaction_sources[0] === active_reaction)) {
    state_unsafe_mutation();
  }
  let new_value = should_proxy ? proxy(value) : value;
  return internal_set(source2, new_value);
}
function internal_set(source2, value) {
  if (!source2.equals(value)) {
    var old_value = source2.v;
    if (is_destroying_effect) {
      old_values.set(source2, value);
    } else {
      old_values.set(source2, old_value);
    }
    source2.v = value;
    if ((source2.f & DERIVED) !== 0) {
      if ((source2.f & DIRTY) !== 0) {
        execute_derived(
          /** @type {Derived} */
          source2
        );
      }
      set_signal_status(source2, (source2.f & UNOWNED) === 0 ? CLEAN : MAYBE_DIRTY);
    }
    source2.wv = increment_write_version();
    mark_reactions(source2, DIRTY);
    if (is_runes() && active_effect !== null && (active_effect.f & CLEAN) !== 0 && (active_effect.f & (BRANCH_EFFECT | ROOT_EFFECT)) === 0) {
      if (untracked_writes === null) {
        set_untracked_writes([source2]);
      } else {
        untracked_writes.push(source2);
      }
    }
  }
  return value;
}
function update(source2, d2 = 1) {
  var value = get$3(source2);
  var result = d2 === 1 ? value++ : value--;
  set$2(source2, value);
  return result;
}
function mark_reactions(signal, status) {
  var reactions = signal.reactions;
  if (reactions === null) return;
  var runes = is_runes();
  var length = reactions.length;
  for (var i = 0; i < length; i++) {
    var reaction = reactions[i];
    var flags = reaction.f;
    if ((flags & DIRTY) !== 0) continue;
    if (!runes && reaction === active_effect) continue;
    set_signal_status(reaction, status);
    if ((flags & (CLEAN | UNOWNED)) !== 0) {
      if ((flags & DERIVED) !== 0) {
        mark_reactions(
          /** @type {Derived} */
          reaction,
          MAYBE_DIRTY
        );
      } else {
        schedule_effect(
          /** @type {Effect} */
          reaction
        );
      }
    }
  }
}
function select_multiple_invalid_value() {
  {
    console.warn(`https://svelte.dev/e/select_multiple_invalid_value`);
  }
}
let hydrating = false;
var $window;
var $document;
var is_firefox;
var first_child_getter;
var next_sibling_getter;
function init_operations() {
  if ($window !== void 0) {
    return;
  }
  $window = window;
  $document = document;
  is_firefox = /Firefox/.test(navigator.userAgent);
  var element_prototype = Element.prototype;
  var node_prototype = Node.prototype;
  var text_prototype = Text.prototype;
  first_child_getter = get_descriptor(node_prototype, "firstChild").get;
  next_sibling_getter = get_descriptor(node_prototype, "nextSibling").get;
  if (is_extensible(element_prototype)) {
    element_prototype.__click = void 0;
    element_prototype.__className = void 0;
    element_prototype.__attributes = null;
    element_prototype.__style = void 0;
    element_prototype.__e = void 0;
  }
  if (is_extensible(text_prototype)) {
    text_prototype.__t = void 0;
  }
}
function create_text(value = "") {
  return document.createTextNode(value);
}
// @__NO_SIDE_EFFECTS__
function get_first_child(node) {
  return first_child_getter.call(node);
}
// @__NO_SIDE_EFFECTS__
function get_next_sibling(node) {
  return next_sibling_getter.call(node);
}
function child(node, is_text) {
  {
    return /* @__PURE__ */ get_first_child(node);
  }
}
function first_child(fragment, is_text) {
  {
    var first = (
      /** @type {DocumentFragment} */
      /* @__PURE__ */ get_first_child(
        /** @type {Node} */
        fragment
      )
    );
    if (first instanceof Comment && first.data === "") return /* @__PURE__ */ get_next_sibling(first);
    return first;
  }
}
function sibling(node, count = 1, is_text = false) {
  let next_sibling = node;
  while (count--) {
    next_sibling = /** @type {TemplateNode} */
    /* @__PURE__ */ get_next_sibling(next_sibling);
  }
  {
    return next_sibling;
  }
}
function clear_text_content(node) {
  node.textContent = "";
}
function validate_effect(rune) {
  if (active_effect === null && active_reaction === null) {
    effect_orphan();
  }
  if (active_reaction !== null && (active_reaction.f & UNOWNED) !== 0 && active_effect === null) {
    effect_in_unowned_derived();
  }
  if (is_destroying_effect) {
    effect_in_teardown();
  }
}
function push_effect(effect2, parent_effect) {
  var parent_last = parent_effect.last;
  if (parent_last === null) {
    parent_effect.last = parent_effect.first = effect2;
  } else {
    parent_last.next = effect2;
    effect2.prev = parent_last;
    parent_effect.last = effect2;
  }
}
function create_effect(type, fn, sync, push2 = true) {
  var _a2;
  var parent = active_effect;
  var effect2 = {
    ctx: component_context,
    deps: null,
    nodes_start: null,
    nodes_end: null,
    f: type | DIRTY,
    first: null,
    fn,
    last: null,
    next: null,
    parent,
    prev: null,
    teardown: null,
    transitions: null,
    wv: 0
  };
  if (sync) {
    try {
      update_effect(effect2);
      effect2.f |= EFFECT_RAN;
    } catch (e) {
      destroy_effect(effect2);
      throw e;
    }
  } else if (fn !== null) {
    schedule_effect(effect2);
  }
  var inert = sync && effect2.deps === null && effect2.first === null && effect2.nodes_start === null && effect2.teardown === null && (effect2.f & (EFFECT_HAS_DERIVED | BOUNDARY_EFFECT)) === 0;
  if (!inert && push2) {
    if (parent !== null) {
      push_effect(effect2, parent);
    }
    if (active_reaction !== null && (active_reaction.f & DERIVED) !== 0) {
      var derived2 = (
        /** @type {Derived} */
        active_reaction
      );
      ((_a2 = derived2.effects) != null ? _a2 : derived2.effects = []).push(effect2);
    }
  }
  return effect2;
}
function effect_tracking() {
  return active_reaction !== null && !untracking;
}
function teardown(fn) {
  const effect2 = create_effect(RENDER_EFFECT, null, false);
  set_signal_status(effect2, CLEAN);
  effect2.teardown = fn;
  return effect2;
}
function user_effect(fn) {
  var _a2;
  validate_effect();
  var defer = active_effect !== null && (active_effect.f & BRANCH_EFFECT) !== 0 && component_context !== null && !component_context.m;
  if (defer) {
    var context = (
      /** @type {ComponentContext} */
      component_context
    );
    ((_a2 = context.e) != null ? _a2 : context.e = []).push({
      fn,
      effect: active_effect,
      reaction: active_reaction
    });
  } else {
    var signal = effect(fn);
    return signal;
  }
}
function user_pre_effect(fn) {
  validate_effect();
  return render_effect(fn);
}
function effect_root(fn) {
  const effect2 = create_effect(ROOT_EFFECT, fn, true);
  return () => {
    destroy_effect(effect2);
  };
}
function component_root(fn) {
  const effect2 = create_effect(ROOT_EFFECT, fn, true);
  return (options = {}) => {
    return new Promise((fulfil) => {
      if (options.outro) {
        pause_effect(effect2, () => {
          destroy_effect(effect2);
          fulfil(void 0);
        });
      } else {
        destroy_effect(effect2);
        fulfil(void 0);
      }
    });
  };
}
function effect(fn) {
  return create_effect(EFFECT, fn, false);
}
function render_effect(fn) {
  return create_effect(RENDER_EFFECT, fn, true);
}
function template_effect(fn, thunks = [], d2 = derived$1) {
  const deriveds = thunks.map(d2);
  return block(() => fn(...deriveds.map(get$3)));
}
function block(fn, flags = 0) {
  return create_effect(RENDER_EFFECT | BLOCK_EFFECT | flags, fn, true);
}
function branch(fn, push2 = true) {
  return create_effect(RENDER_EFFECT | BRANCH_EFFECT, fn, true, push2);
}
function execute_effect_teardown(effect2) {
  var teardown2 = effect2.teardown;
  if (teardown2 !== null) {
    const previously_destroying_effect = is_destroying_effect;
    const previous_reaction = active_reaction;
    set_is_destroying_effect(true);
    set_active_reaction(null);
    try {
      teardown2.call(null);
    } finally {
      set_is_destroying_effect(previously_destroying_effect);
      set_active_reaction(previous_reaction);
    }
  }
}
function destroy_effect_children(signal, remove_dom = false) {
  var effect2 = signal.first;
  signal.first = signal.last = null;
  while (effect2 !== null) {
    var next = effect2.next;
    if ((effect2.f & ROOT_EFFECT) !== 0) {
      effect2.parent = null;
    } else {
      destroy_effect(effect2, remove_dom);
    }
    effect2 = next;
  }
}
function destroy_block_effect_children(signal) {
  var effect2 = signal.first;
  while (effect2 !== null) {
    var next = effect2.next;
    if ((effect2.f & BRANCH_EFFECT) === 0) {
      destroy_effect(effect2);
    }
    effect2 = next;
  }
}
function destroy_effect(effect2, remove_dom = true) {
  var removed = false;
  if ((remove_dom || (effect2.f & HEAD_EFFECT) !== 0) && effect2.nodes_start !== null && effect2.nodes_end !== null) {
    remove_effect_dom(
      effect2.nodes_start,
      /** @type {TemplateNode} */
      effect2.nodes_end
    );
    removed = true;
  }
  destroy_effect_children(effect2, remove_dom && !removed);
  remove_reactions(effect2, 0);
  set_signal_status(effect2, DESTROYED);
  var transitions = effect2.transitions;
  if (transitions !== null) {
    for (const transition of transitions) {
      transition.stop();
    }
  }
  execute_effect_teardown(effect2);
  var parent = effect2.parent;
  if (parent !== null && parent.first !== null) {
    unlink_effect(effect2);
  }
  effect2.next = effect2.prev = effect2.teardown = effect2.ctx = effect2.deps = effect2.fn = effect2.nodes_start = effect2.nodes_end = null;
}
function remove_effect_dom(node, end) {
  while (node !== null) {
    var next = node === end ? null : (
      /** @type {TemplateNode} */
      /* @__PURE__ */ get_next_sibling(node)
    );
    node.remove();
    node = next;
  }
}
function unlink_effect(effect2) {
  var parent = effect2.parent;
  var prev = effect2.prev;
  var next = effect2.next;
  if (prev !== null) prev.next = next;
  if (next !== null) next.prev = prev;
  if (parent !== null) {
    if (parent.first === effect2) parent.first = next;
    if (parent.last === effect2) parent.last = prev;
  }
}
function pause_effect(effect2, callback) {
  var transitions = [];
  pause_children(effect2, transitions, true);
  run_out_transitions(transitions, () => {
    destroy_effect(effect2);
    if (callback) callback();
  });
}
function run_out_transitions(transitions, fn) {
  var remaining = transitions.length;
  if (remaining > 0) {
    var check = () => --remaining || fn();
    for (var transition of transitions) {
      transition.out(check);
    }
  } else {
    fn();
  }
}
function pause_children(effect2, transitions, local) {
  if ((effect2.f & INERT) !== 0) return;
  effect2.f ^= INERT;
  if (effect2.transitions !== null) {
    for (const transition of effect2.transitions) {
      if (transition.is_global || local) {
        transitions.push(transition);
      }
    }
  }
  var child2 = effect2.first;
  while (child2 !== null) {
    var sibling2 = child2.next;
    var transparent = (child2.f & EFFECT_TRANSPARENT) !== 0 || (child2.f & BRANCH_EFFECT) !== 0;
    pause_children(child2, transitions, transparent ? local : false);
    child2 = sibling2;
  }
}
function resume_effect(effect2) {
  resume_children(effect2, true);
}
function resume_children(effect2, local) {
  if ((effect2.f & INERT) === 0) return;
  effect2.f ^= INERT;
  var child2 = effect2.first;
  while (child2 !== null) {
    var sibling2 = child2.next;
    var transparent = (child2.f & EFFECT_TRANSPARENT) !== 0 || (child2.f & BRANCH_EFFECT) !== 0;
    resume_children(child2, transparent ? local : false);
    child2 = sibling2;
  }
  if (effect2.transitions !== null) {
    for (const transition of effect2.transitions) {
      if (transition.is_global || local) {
        transition.in();
      }
    }
  }
}
let micro_tasks = [];
let idle_tasks = [];
function run_micro_tasks() {
  var tasks = micro_tasks;
  micro_tasks = [];
  run_all(tasks);
}
function run_idle_tasks() {
  var tasks = idle_tasks;
  idle_tasks = [];
  run_all(tasks);
}
function queue_micro_task(fn) {
  if (micro_tasks.length === 0) {
    queueMicrotask(run_micro_tasks);
  }
  micro_tasks.push(fn);
}
function flush_tasks() {
  if (micro_tasks.length > 0) {
    run_micro_tasks();
  }
  if (idle_tasks.length > 0) {
    run_idle_tasks();
  }
}
function handle_error(error) {
  var effect2 = (
    /** @type {Effect} */
    active_effect
  );
  if ((effect2.f & EFFECT_RAN) === 0) {
    if ((effect2.f & BOUNDARY_EFFECT) === 0) {
      throw error;
    }
    effect2.fn(error);
  } else {
    invoke_error_boundary(error, effect2);
  }
}
function invoke_error_boundary(error, effect2) {
  while (effect2 !== null) {
    if ((effect2.f & BOUNDARY_EFFECT) !== 0) {
      try {
        effect2.fn(error);
        return;
      } catch (e) {
      }
    }
    effect2 = effect2.parent;
  }
  throw error;
}
let is_flushing = false;
let last_scheduled_effect = null;
let is_updating_effect = false;
let is_destroying_effect = false;
function set_is_destroying_effect(value) {
  is_destroying_effect = value;
}
let queued_root_effects = [];
let dev_effect_stack = [];
let active_reaction = null;
let untracking = false;
function set_active_reaction(reaction) {
  active_reaction = reaction;
}
let active_effect = null;
function set_active_effect(effect2) {
  active_effect = effect2;
}
let reaction_sources = null;
function push_reaction_value(value) {
  if (active_reaction !== null && active_reaction.f & EFFECT_IS_UPDATING) {
    if (reaction_sources === null) {
      reaction_sources = [active_reaction, [value]];
    } else {
      reaction_sources[1].push(value);
    }
  }
}
let new_deps = null;
let skipped_deps = 0;
let untracked_writes = null;
function set_untracked_writes(value) {
  untracked_writes = value;
}
let write_version = 1;
let read_version = 0;
let skip_reaction = false;
function increment_write_version() {
  return ++write_version;
}
function check_dirtiness(reaction) {
  var _a2, _b2;
  var flags = reaction.f;
  if ((flags & DIRTY) !== 0) {
    return true;
  }
  if ((flags & MAYBE_DIRTY) !== 0) {
    var dependencies = reaction.deps;
    var is_unowned = (flags & UNOWNED) !== 0;
    if (dependencies !== null) {
      var i;
      var dependency;
      var is_disconnected = (flags & DISCONNECTED) !== 0;
      var is_unowned_connected = is_unowned && active_effect !== null && !skip_reaction;
      var length = dependencies.length;
      if (is_disconnected || is_unowned_connected) {
        var derived2 = (
          /** @type {Derived} */
          reaction
        );
        var parent = derived2.parent;
        for (i = 0; i < length; i++) {
          dependency = dependencies[i];
          if (is_disconnected || !((_a2 = dependency == null ? void 0 : dependency.reactions) == null ? void 0 : _a2.includes(derived2))) {
            ((_b2 = dependency.reactions) != null ? _b2 : dependency.reactions = []).push(derived2);
          }
        }
        if (is_disconnected) {
          derived2.f ^= DISCONNECTED;
        }
        if (is_unowned_connected && parent !== null && (parent.f & UNOWNED) === 0) {
          derived2.f ^= UNOWNED;
        }
      }
      for (i = 0; i < length; i++) {
        dependency = dependencies[i];
        if (check_dirtiness(
          /** @type {Derived} */
          dependency
        )) {
          update_derived(
            /** @type {Derived} */
            dependency
          );
        }
        if (dependency.wv > reaction.wv) {
          return true;
        }
      }
    }
    if (!is_unowned || active_effect !== null && !skip_reaction) {
      set_signal_status(reaction, CLEAN);
    }
  }
  return false;
}
function schedule_possible_effect_self_invalidation(signal, effect2, root2 = true) {
  var reactions = signal.reactions;
  if (reactions === null) return;
  for (var i = 0; i < reactions.length; i++) {
    var reaction = reactions[i];
    if ((reaction_sources == null ? void 0 : reaction_sources[1].includes(signal)) && reaction_sources[0] === active_reaction) continue;
    if ((reaction.f & DERIVED) !== 0) {
      schedule_possible_effect_self_invalidation(
        /** @type {Derived} */
        reaction,
        effect2,
        false
      );
    } else if (effect2 === reaction) {
      if (root2) {
        set_signal_status(reaction, DIRTY);
      } else if ((reaction.f & CLEAN) !== 0) {
        set_signal_status(reaction, MAYBE_DIRTY);
      }
      schedule_effect(
        /** @type {Effect} */
        reaction
      );
    }
  }
}
function update_reaction(reaction) {
  var _a2, _b2;
  var previous_deps = new_deps;
  var previous_skipped_deps = skipped_deps;
  var previous_untracked_writes = untracked_writes;
  var previous_reaction = active_reaction;
  var previous_skip_reaction = skip_reaction;
  var previous_reaction_sources = reaction_sources;
  var previous_component_context = component_context;
  var previous_untracking = untracking;
  var flags = reaction.f;
  new_deps = /** @type {null | Value[]} */
  null;
  skipped_deps = 0;
  untracked_writes = null;
  skip_reaction = (flags & UNOWNED) !== 0 && (untracking || !is_updating_effect || active_reaction === null);
  active_reaction = (flags & (BRANCH_EFFECT | ROOT_EFFECT)) === 0 ? reaction : null;
  reaction_sources = null;
  set_component_context(reaction.ctx);
  untracking = false;
  read_version++;
  reaction.f |= EFFECT_IS_UPDATING;
  try {
    var result = (
      /** @type {Function} */
      (0, reaction.fn)()
    );
    var deps = reaction.deps;
    if (new_deps !== null) {
      var i;
      remove_reactions(reaction, skipped_deps);
      if (deps !== null && skipped_deps > 0) {
        deps.length = skipped_deps + new_deps.length;
        for (i = 0; i < new_deps.length; i++) {
          deps[skipped_deps + i] = new_deps[i];
        }
      } else {
        reaction.deps = deps = new_deps;
      }
      if (!skip_reaction || // Deriveds that already have reactions can cleanup, so we still add them as reactions
      (flags & DERIVED) !== 0 && /** @type {import('#client').Derived} */
      reaction.reactions !== null) {
        for (i = skipped_deps; i < deps.length; i++) {
          ((_b2 = (_a2 = deps[i]).reactions) != null ? _b2 : _a2.reactions = []).push(reaction);
        }
      }
    } else if (deps !== null && skipped_deps < deps.length) {
      remove_reactions(reaction, skipped_deps);
      deps.length = skipped_deps;
    }
    if (is_runes() && untracked_writes !== null && !untracking && deps !== null && (reaction.f & (DERIVED | MAYBE_DIRTY | DIRTY)) === 0) {
      for (i = 0; i < /** @type {Source[]} */
      untracked_writes.length; i++) {
        schedule_possible_effect_self_invalidation(
          untracked_writes[i],
          /** @type {Effect} */
          reaction
        );
      }
    }
    if (previous_reaction !== null && previous_reaction !== reaction) {
      read_version++;
      if (untracked_writes !== null) {
        if (previous_untracked_writes === null) {
          previous_untracked_writes = untracked_writes;
        } else {
          previous_untracked_writes.push(.../** @type {Source[]} */
          untracked_writes);
        }
      }
    }
    return result;
  } catch (error) {
    handle_error(error);
  } finally {
    new_deps = previous_deps;
    skipped_deps = previous_skipped_deps;
    untracked_writes = previous_untracked_writes;
    active_reaction = previous_reaction;
    skip_reaction = previous_skip_reaction;
    reaction_sources = previous_reaction_sources;
    set_component_context(previous_component_context);
    untracking = previous_untracking;
    reaction.f ^= EFFECT_IS_UPDATING;
  }
}
function remove_reaction(signal, dependency) {
  let reactions = dependency.reactions;
  if (reactions !== null) {
    var index2 = index_of.call(reactions, signal);
    if (index2 !== -1) {
      var new_length = reactions.length - 1;
      if (new_length === 0) {
        reactions = dependency.reactions = null;
      } else {
        reactions[index2] = reactions[new_length];
        reactions.pop();
      }
    }
  }
  if (reactions === null && (dependency.f & DERIVED) !== 0 && // Destroying a child effect while updating a parent effect can cause a dependency to appear
  // to be unused, when in fact it is used by the currently-updating parent. Checking `new_deps`
  // allows us to skip the expensive work of disconnecting and immediately reconnecting it
  (new_deps === null || !new_deps.includes(dependency))) {
    set_signal_status(dependency, MAYBE_DIRTY);
    if ((dependency.f & (UNOWNED | DISCONNECTED)) === 0) {
      dependency.f ^= DISCONNECTED;
    }
    destroy_derived_effects(
      /** @type {Derived} **/
      dependency
    );
    remove_reactions(
      /** @type {Derived} **/
      dependency,
      0
    );
  }
}
function remove_reactions(signal, start_index) {
  var dependencies = signal.deps;
  if (dependencies === null) return;
  for (var i = start_index; i < dependencies.length; i++) {
    remove_reaction(signal, dependencies[i]);
  }
}
function update_effect(effect2) {
  var flags = effect2.f;
  if ((flags & DESTROYED) !== 0) {
    return;
  }
  set_signal_status(effect2, CLEAN);
  var previous_effect = active_effect;
  var was_updating_effect = is_updating_effect;
  active_effect = effect2;
  is_updating_effect = true;
  try {
    if ((flags & BLOCK_EFFECT) !== 0) {
      destroy_block_effect_children(effect2);
    } else {
      destroy_effect_children(effect2);
    }
    execute_effect_teardown(effect2);
    var teardown2 = update_reaction(effect2);
    effect2.teardown = typeof teardown2 === "function" ? teardown2 : null;
    effect2.wv = write_version;
    var dep;
    if (DEV && tracing_mode_flag && (effect2.f & DIRTY) !== 0 && effect2.deps !== null) ;
    if (DEV) ;
  } finally {
    is_updating_effect = was_updating_effect;
    active_effect = previous_effect;
  }
}
function infinite_loop_guard() {
  try {
    effect_update_depth_exceeded();
  } catch (error) {
    if (last_scheduled_effect !== null) {
      {
        invoke_error_boundary(error, last_scheduled_effect);
      }
    } else {
      throw error;
    }
  }
}
function flush_queued_root_effects() {
  var was_updating_effect = is_updating_effect;
  try {
    var flush_count = 0;
    is_updating_effect = true;
    while (queued_root_effects.length > 0) {
      if (flush_count++ > 1e3) {
        infinite_loop_guard();
      }
      var root_effects = queued_root_effects;
      var length = root_effects.length;
      queued_root_effects = [];
      for (var i = 0; i < length; i++) {
        var collected_effects = process_effects(root_effects[i]);
        flush_queued_effects(collected_effects);
      }
      old_values.clear();
    }
  } finally {
    is_flushing = false;
    is_updating_effect = was_updating_effect;
    last_scheduled_effect = null;
  }
}
function flush_queued_effects(effects) {
  var length = effects.length;
  if (length === 0) return;
  for (var i = 0; i < length; i++) {
    var effect2 = effects[i];
    if ((effect2.f & (DESTROYED | INERT)) === 0) {
      if (check_dirtiness(effect2)) {
        update_effect(effect2);
        if (effect2.deps === null && effect2.first === null && effect2.nodes_start === null) {
          if (effect2.teardown === null) {
            unlink_effect(effect2);
          } else {
            effect2.fn = null;
          }
        }
      }
    }
  }
}
function schedule_effect(signal) {
  if (!is_flushing) {
    is_flushing = true;
    queueMicrotask(flush_queued_root_effects);
  }
  var effect2 = last_scheduled_effect = signal;
  while (effect2.parent !== null) {
    effect2 = effect2.parent;
    var flags = effect2.f;
    if ((flags & (ROOT_EFFECT | BRANCH_EFFECT)) !== 0) {
      if ((flags & CLEAN) === 0) return;
      effect2.f ^= CLEAN;
    }
  }
  queued_root_effects.push(effect2);
}
function process_effects(root2) {
  var effects = [];
  var effect2 = root2;
  while (effect2 !== null) {
    var flags = effect2.f;
    var is_branch = (flags & (BRANCH_EFFECT | ROOT_EFFECT)) !== 0;
    var is_skippable_branch = is_branch && (flags & CLEAN) !== 0;
    if (!is_skippable_branch && (flags & INERT) === 0) {
      if ((flags & EFFECT) !== 0) {
        effects.push(effect2);
      } else if (is_branch) {
        effect2.f ^= CLEAN;
      } else {
        if (check_dirtiness(effect2)) {
          update_effect(effect2);
        }
      }
      var child2 = effect2.first;
      if (child2 !== null) {
        effect2 = child2;
        continue;
      }
    }
    var parent = effect2.parent;
    effect2 = effect2.next;
    while (effect2 === null && parent !== null) {
      effect2 = parent.next;
      parent = parent.parent;
    }
  }
  return effects;
}
function flushSync(fn) {
  var result;
  while (true) {
    flush_tasks();
    if (queued_root_effects.length === 0) {
      is_flushing = false;
      last_scheduled_effect = null;
      return (
        /** @type {T} */
        result
      );
    }
    is_flushing = true;
    flush_queued_root_effects();
  }
}
function tick() {
  return __async(this, null, function* () {
    yield Promise.resolve();
    flushSync();
  });
}
function get$3(signal) {
  var flags = signal.f;
  var is_derived = (flags & DERIVED) !== 0;
  if (active_reaction !== null && !untracking) {
    if (!(reaction_sources == null ? void 0 : reaction_sources[1].includes(signal)) || reaction_sources[0] !== active_reaction) {
      var deps = active_reaction.deps;
      if (signal.rv < read_version) {
        signal.rv = read_version;
        if (new_deps === null && deps !== null && deps[skipped_deps] === signal) {
          skipped_deps++;
        } else if (new_deps === null) {
          new_deps = [signal];
        } else if (!skip_reaction || !new_deps.includes(signal)) {
          new_deps.push(signal);
        }
      }
    }
  } else if (is_derived && /** @type {Derived} */
  signal.deps === null && /** @type {Derived} */
  signal.effects === null) {
    var derived2 = (
      /** @type {Derived} */
      signal
    );
    var parent = derived2.parent;
    if (parent !== null && (parent.f & UNOWNED) === 0) {
      derived2.f ^= UNOWNED;
    }
  }
  if (is_derived) {
    derived2 = /** @type {Derived} */
    signal;
    if (check_dirtiness(derived2)) {
      update_derived(derived2);
    }
  }
  if (is_destroying_effect && old_values.has(signal)) {
    return old_values.get(signal);
  }
  return signal.v;
}
function untrack(fn) {
  var previous_untracking = untracking;
  try {
    untracking = true;
    return fn();
  } finally {
    untracking = previous_untracking;
  }
}
const STATUS_MASK = -7169;
function set_signal_status(signal, status) {
  signal.f = signal.f & STATUS_MASK | status;
}
function exclude_from_object(obj, keys) {
  var result = {};
  for (var key2 in obj) {
    if (!keys.includes(key2)) {
      result[key2] = obj[key2];
    }
  }
  return result;
}
function deep_read_state(value) {
  if (typeof value !== "object" || !value || value instanceof EventTarget) {
    return;
  }
  if (STATE_SYMBOL in value) {
    deep_read(value);
  } else if (!Array.isArray(value)) {
    for (let key2 in value) {
      const prop2 = value[key2];
      if (typeof prop2 === "object" && prop2 && STATE_SYMBOL in prop2) {
        deep_read(prop2);
      }
    }
  }
}
function deep_read(value, visited = /* @__PURE__ */ new Set()) {
  if (typeof value === "object" && value !== null && // We don't want to traverse DOM elements
  !(value instanceof EventTarget) && !visited.has(value)) {
    visited.add(value);
    if (value instanceof Date) {
      value.getTime();
    }
    for (let key2 in value) {
      try {
        deep_read(value[key2], visited);
      } catch (e) {
      }
    }
    const proto = get_prototype_of(value);
    if (proto !== Object.prototype && proto !== Array.prototype && proto !== Map.prototype && proto !== Set.prototype && proto !== Date.prototype) {
      const descriptors = get_descriptors(proto);
      for (let key2 in descriptors) {
        const get2 = descriptors[key2].get;
        if (get2) {
          try {
            get2.call(value);
          } catch (e) {
          }
        }
      }
    }
  }
}
function autofocus(dom, value) {
  if (value) {
    const body = document.body;
    dom.autofocus = true;
    queue_micro_task(() => {
      if (document.activeElement === body) {
        dom.focus();
      }
    });
  }
}
let listening_to_form_reset = false;
function add_form_reset_listener() {
  if (!listening_to_form_reset) {
    listening_to_form_reset = true;
    document.addEventListener(
      "reset",
      (evt) => {
        Promise.resolve().then(() => {
          var _a2;
          if (!evt.defaultPrevented) {
            for (
              const e of
              /**@type {HTMLFormElement} */
              evt.target.elements
            ) {
              (_a2 = e.__on_r) == null ? void 0 : _a2.call(e);
            }
          }
        });
      },
      // In the capture phase to guarantee we get noticed of it (no possiblity of stopPropagation)
      { capture: true }
    );
  }
}
function without_reactive_context(fn) {
  var previous_reaction = active_reaction;
  var previous_effect = active_effect;
  set_active_reaction(null);
  set_active_effect(null);
  try {
    return fn();
  } finally {
    set_active_reaction(previous_reaction);
    set_active_effect(previous_effect);
  }
}
function listen_to_event_and_reset_event(element, event2, handler, on_reset = handler) {
  element.addEventListener(event2, () => without_reactive_context(handler));
  const prev = element.__on_r;
  if (prev) {
    element.__on_r = () => {
      prev();
      on_reset(true);
    };
  } else {
    element.__on_r = () => on_reset(true);
  }
  add_form_reset_listener();
}
const all_registered_events = /* @__PURE__ */ new Set();
const root_event_handles = /* @__PURE__ */ new Set();
function create_event(event_name, dom, handler, options = {}) {
  function target_handler(event2) {
    if (!options.capture) {
      handle_event_propagation.call(dom, event2);
    }
    if (!event2.cancelBubble) {
      return without_reactive_context(() => {
        return handler == null ? void 0 : handler.call(this, event2);
      });
    }
  }
  if (event_name.startsWith("pointer") || event_name.startsWith("touch") || event_name === "wheel") {
    queue_micro_task(() => {
      dom.addEventListener(event_name, target_handler, options);
    });
  } else {
    dom.addEventListener(event_name, target_handler, options);
  }
  return target_handler;
}
function on(element, type, handler, options = {}) {
  var target_handler = create_event(type, element, handler, options);
  return () => {
    element.removeEventListener(type, target_handler, options);
  };
}
function event(event_name, dom, handler, capture, passive) {
  var options = { capture, passive };
  var target_handler = create_event(event_name, dom, handler, options);
  if (dom === document.body || // @ts-ignore
  dom === window || // @ts-ignore
  dom === document || // Firefox has quirky behavior, it can happen that we still get "canplay" events when the element is already removed
  dom instanceof HTMLMediaElement) {
    teardown(() => {
      dom.removeEventListener(event_name, target_handler, options);
    });
  }
}
function delegate(events) {
  for (var i = 0; i < events.length; i++) {
    all_registered_events.add(events[i]);
  }
  for (var fn of root_event_handles) {
    fn(events);
  }
}
function handle_event_propagation(event2) {
  var _a2;
  var handler_element = this;
  var owner_document = (
    /** @type {Node} */
    handler_element.ownerDocument
  );
  var event_name = event2.type;
  var path = ((_a2 = event2.composedPath) == null ? void 0 : _a2.call(event2)) || [];
  var current_target = (
    /** @type {null | Element} */
    path[0] || event2.target
  );
  var path_idx = 0;
  var handled_at = event2.__root;
  if (handled_at) {
    var at_idx = path.indexOf(handled_at);
    if (at_idx !== -1 && (handler_element === document || handler_element === /** @type {any} */
    window)) {
      event2.__root = handler_element;
      return;
    }
    var handler_idx = path.indexOf(handler_element);
    if (handler_idx === -1) {
      return;
    }
    if (at_idx <= handler_idx) {
      path_idx = at_idx;
    }
  }
  current_target = /** @type {Element} */
  path[path_idx] || event2.target;
  if (current_target === handler_element) return;
  define_property(event2, "currentTarget", {
    configurable: true,
    get() {
      return current_target || owner_document;
    }
  });
  var previous_reaction = active_reaction;
  var previous_effect = active_effect;
  set_active_reaction(null);
  set_active_effect(null);
  try {
    var throw_error;
    var other_errors = [];
    while (current_target !== null) {
      var parent_element = current_target.assignedSlot || current_target.parentNode || /** @type {any} */
      current_target.host || null;
      try {
        var delegated = current_target["__" + event_name];
        if (delegated != null && (!/** @type {any} */
        current_target.disabled || // DOM could've been updated already by the time this is reached, so we check this as well
        // -> the target could not have been disabled because it emits the event in the first place
        event2.target === current_target)) {
          if (is_array(delegated)) {
            var [fn, ...data] = delegated;
            fn.apply(current_target, [event2, ...data]);
          } else {
            delegated.call(current_target, event2);
          }
        }
      } catch (error) {
        if (throw_error) {
          other_errors.push(error);
        } else {
          throw_error = error;
        }
      }
      if (event2.cancelBubble || parent_element === handler_element || parent_element === null) {
        break;
      }
      current_target = parent_element;
    }
    if (throw_error) {
      for (let error of other_errors) {
        queueMicrotask(() => {
          throw error;
        });
      }
      throw throw_error;
    }
  } finally {
    event2.__root = handler_element;
    delete event2.currentTarget;
    set_active_reaction(previous_reaction);
    set_active_effect(previous_effect);
  }
}
function head(render_fn) {
  var anchor;
  {
    anchor = document.head.appendChild(create_text());
  }
  try {
    block(() => render_fn(anchor), HEAD_EFFECT);
  } finally {
  }
}
function create_fragment_from_html(html2) {
  var elem = document.createElement("template");
  elem.innerHTML = html2.replaceAll("<!>", "<!---->");
  return elem.content;
}
function assign_nodes(start2, end) {
  var effect2 = (
    /** @type {Effect} */
    active_effect
  );
  if (effect2.nodes_start === null) {
    effect2.nodes_start = start2;
    effect2.nodes_end = end;
  }
}
// @__NO_SIDE_EFFECTS__
function from_html(content, flags) {
  var is_fragment = (flags & TEMPLATE_FRAGMENT) !== 0;
  var use_import_node = (flags & TEMPLATE_USE_IMPORT_NODE) !== 0;
  var node;
  var has_start = !content.startsWith("<!>");
  return () => {
    if (node === void 0) {
      node = create_fragment_from_html(has_start ? content : "<!>" + content);
      if (!is_fragment) node = /** @type {Node} */
      /* @__PURE__ */ get_first_child(node);
    }
    var clone2 = (
      /** @type {TemplateNode} */
      use_import_node || is_firefox ? document.importNode(node, true) : node.cloneNode(true)
    );
    if (is_fragment) {
      var start2 = (
        /** @type {TemplateNode} */
        /* @__PURE__ */ get_first_child(clone2)
      );
      var end = (
        /** @type {TemplateNode} */
        clone2.lastChild
      );
      assign_nodes(start2, end);
    } else {
      assign_nodes(clone2, clone2);
    }
    return clone2;
  };
}
// @__NO_SIDE_EFFECTS__
function from_namespace(content, flags, ns = "svg") {
  var has_start = !content.startsWith("<!>");
  var is_fragment = (flags & TEMPLATE_FRAGMENT) !== 0;
  var wrapped = `<${ns}>${has_start ? content : "<!>" + content}</${ns}>`;
  var node;
  return () => {
    if (!node) {
      var fragment = (
        /** @type {DocumentFragment} */
        create_fragment_from_html(wrapped)
      );
      var root2 = (
        /** @type {Element} */
        /* @__PURE__ */ get_first_child(fragment)
      );
      if (is_fragment) {
        node = document.createDocumentFragment();
        while (/* @__PURE__ */ get_first_child(root2)) {
          node.appendChild(
            /** @type {Node} */
            /* @__PURE__ */ get_first_child(root2)
          );
        }
      } else {
        node = /** @type {Element} */
        /* @__PURE__ */ get_first_child(root2);
      }
    }
    var clone2 = (
      /** @type {TemplateNode} */
      node.cloneNode(true)
    );
    if (is_fragment) {
      var start2 = (
        /** @type {TemplateNode} */
        /* @__PURE__ */ get_first_child(clone2)
      );
      var end = (
        /** @type {TemplateNode} */
        clone2.lastChild
      );
      assign_nodes(start2, end);
    } else {
      assign_nodes(clone2, clone2);
    }
    return clone2;
  };
}
// @__NO_SIDE_EFFECTS__
function from_svg(content, flags) {
  return /* @__PURE__ */ from_namespace(content, flags, "svg");
}
function text(value = "") {
  {
    var t = create_text(value + "");
    assign_nodes(t, t);
    return t;
  }
}
function comment() {
  var frag = document.createDocumentFragment();
  var start2 = document.createComment("");
  var anchor = create_text();
  frag.append(start2, anchor);
  assign_nodes(start2, anchor);
  return frag;
}
function append(anchor, dom) {
  if (anchor === null) {
    return;
  }
  anchor.before(
    /** @type {Node} */
    dom
  );
}
function is_capture_event(name) {
  return name.endsWith("capture") && name !== "gotpointercapture" && name !== "lostpointercapture";
}
const DELEGATED_EVENTS = [
  "beforeinput",
  "click",
  "change",
  "dblclick",
  "contextmenu",
  "focusin",
  "focusout",
  "input",
  "keydown",
  "keyup",
  "mousedown",
  "mousemove",
  "mouseout",
  "mouseover",
  "mouseup",
  "pointerdown",
  "pointermove",
  "pointerout",
  "pointerover",
  "pointerup",
  "touchend",
  "touchmove",
  "touchstart"
];
function is_delegated(event_name) {
  return DELEGATED_EVENTS.includes(event_name);
}
const ATTRIBUTE_ALIASES = {
  // no `class: 'className'` because we handle that separately
  formnovalidate: "formNoValidate",
  ismap: "isMap",
  nomodule: "noModule",
  playsinline: "playsInline",
  readonly: "readOnly",
  defaultvalue: "defaultValue",
  defaultchecked: "defaultChecked",
  srcobject: "srcObject",
  novalidate: "noValidate",
  allowfullscreen: "allowFullscreen",
  disablepictureinpicture: "disablePictureInPicture",
  disableremoteplayback: "disableRemotePlayback"
};
function normalize_attribute(name) {
  var _a2;
  name = name.toLowerCase();
  return (_a2 = ATTRIBUTE_ALIASES[name]) != null ? _a2 : name;
}
const PASSIVE_EVENTS = ["touchstart", "touchmove"];
function is_passive_event(name) {
  return PASSIVE_EVENTS.includes(name);
}
function set_text(text2, value) {
  var _a2;
  var str = value == null ? "" : typeof value === "object" ? value + "" : value;
  if (str !== ((_a2 = text2.__t) != null ? _a2 : text2.__t = text2.nodeValue)) {
    text2.__t = str;
    text2.nodeValue = str + "";
  }
}
function mount(component2, options) {
  return _mount(component2, options);
}
const document_listeners = /* @__PURE__ */ new Map();
function _mount(Component, { target, anchor, props = {}, events, context, intro = true }) {
  init_operations();
  var registered_events = /* @__PURE__ */ new Set();
  var event_handle = (events2) => {
    for (var i = 0; i < events2.length; i++) {
      var event_name = events2[i];
      if (registered_events.has(event_name)) continue;
      registered_events.add(event_name);
      var passive = is_passive_event(event_name);
      target.addEventListener(event_name, handle_event_propagation, { passive });
      var n = document_listeners.get(event_name);
      if (n === void 0) {
        document.addEventListener(event_name, handle_event_propagation, { passive });
        document_listeners.set(event_name, 1);
      } else {
        document_listeners.set(event_name, n + 1);
      }
    }
  };
  event_handle(array_from(all_registered_events));
  root_event_handles.add(event_handle);
  var component2 = void 0;
  var unmount = component_root(() => {
    var anchor_node = anchor != null ? anchor : target.appendChild(create_text());
    branch(() => {
      if (context) {
        push({});
        var ctx = (
          /** @type {ComponentContext} */
          component_context
        );
        ctx.c = context;
      }
      if (events) {
        props.$$events = events;
      }
      component2 = Component(anchor_node, props) || {};
      if (context) {
        pop();
      }
    });
    return () => {
      var _a2;
      for (var event_name of registered_events) {
        target.removeEventListener(event_name, handle_event_propagation);
        var n = (
          /** @type {number} */
          document_listeners.get(event_name)
        );
        if (--n === 0) {
          document.removeEventListener(event_name, handle_event_propagation);
          document_listeners.delete(event_name);
        } else {
          document_listeners.set(event_name, n);
        }
      }
      root_event_handles.delete(event_handle);
      if (anchor_node !== anchor) {
        (_a2 = anchor_node.parentNode) == null ? void 0 : _a2.removeChild(anchor_node);
      }
    };
  });
  mounted_components.set(component2, unmount);
  return component2;
}
let mounted_components = /* @__PURE__ */ new WeakMap();
function snippet(node, get_snippet, ...args) {
  var anchor = node;
  var snippet2 = noop$1;
  var snippet_effect;
  block(() => {
    if (snippet2 === (snippet2 = get_snippet())) return;
    if (snippet_effect) {
      destroy_effect(snippet_effect);
      snippet_effect = null;
    }
    snippet_effect = branch(() => (
      /** @type {SnippetFn} */
      snippet2(anchor, ...args)
    ));
  }, EFFECT_TRANSPARENT);
}
function onMount(fn) {
  if (component_context === null) {
    lifecycle_outside_component();
  }
  if (legacy_mode_flag && component_context.l !== null) {
    init_update_callbacks(component_context).m.push(fn);
  } else {
    user_effect(() => {
      const cleanup = untrack(fn);
      if (typeof cleanup === "function") return (
        /** @type {() => void} */
        cleanup
      );
    });
  }
}
function onDestroy(fn) {
  if (component_context === null) {
    lifecycle_outside_component();
  }
  onMount(() => () => untrack(fn));
}
function create_custom_event(type, detail, { bubbles = false, cancelable = false } = {}) {
  return new CustomEvent(type, { detail, bubbles, cancelable });
}
function createEventDispatcher() {
  const active_component_context = component_context;
  if (active_component_context === null) {
    lifecycle_outside_component();
  }
  return (type, detail, options) => {
    var _a2;
    const events = (
      /** @type {Record<string, Function | Function[]>} */
      (_a2 = active_component_context.s.$$events) == null ? void 0 : _a2[
        /** @type {any} */
        type
      ]
    );
    if (events) {
      const callbacks = is_array(events) ? events.slice() : [events];
      const event2 = create_custom_event(
        /** @type {string} */
        type,
        detail,
        options
      );
      for (const fn of callbacks) {
        fn.call(active_component_context.x, event2);
      }
      return !event2.defaultPrevented;
    }
    return true;
  };
}
function init_update_callbacks(context) {
  var _a2;
  var l3 = (
    /** @type {ComponentContextLegacy} */
    context.l
  );
  return (_a2 = l3.u) != null ? _a2 : l3.u = { a: [], b: [], m: [] };
}
function if_block(node, fn, [root_index, hydrate_index] = [0, 0]) {
  var anchor = node;
  var consequent_effect = null;
  var alternate_effect = null;
  var condition = UNINITIALIZED;
  var flags = root_index > 0 ? EFFECT_TRANSPARENT : 0;
  var has_branch = false;
  const set_branch = (fn2, flag = true) => {
    has_branch = true;
    update_branch(flag, fn2);
  };
  const update_branch = (new_condition, fn2) => {
    if (condition === (condition = new_condition)) return;
    if (condition) {
      if (consequent_effect) {
        resume_effect(consequent_effect);
      } else if (fn2) {
        consequent_effect = branch(() => fn2(anchor));
      }
      if (alternate_effect) {
        pause_effect(alternate_effect, () => {
          alternate_effect = null;
        });
      }
    } else {
      if (alternate_effect) {
        resume_effect(alternate_effect);
      } else if (fn2) {
        alternate_effect = branch(() => fn2(anchor, [root_index + 1, hydrate_index]));
      }
      if (consequent_effect) {
        pause_effect(consequent_effect, () => {
          consequent_effect = null;
        });
      }
    }
  };
  block(() => {
    has_branch = false;
    fn(set_branch);
    if (!has_branch) {
      update_branch(null, null);
    }
  }, flags);
}
function css_props(element, get_styles) {
  render_effect(() => {
    var styles = get_styles();
    for (var key2 in styles) {
      var value = styles[key2];
      if (value) {
        element.style.setProperty(key2, value);
      } else {
        element.style.removeProperty(key2);
      }
    }
  });
}
function index$1(_2, i) {
  return i;
}
function pause_effects(state2, items, controlled_anchor, items_map) {
  var transitions = [];
  var length = items.length;
  for (var i = 0; i < length; i++) {
    pause_children(items[i].e, transitions, true);
  }
  var is_controlled = length > 0 && transitions.length === 0 && controlled_anchor !== null;
  if (is_controlled) {
    var parent_node = (
      /** @type {Element} */
      /** @type {Element} */
      controlled_anchor.parentNode
    );
    clear_text_content(parent_node);
    parent_node.append(
      /** @type {Element} */
      controlled_anchor
    );
    items_map.clear();
    link(state2, items[0].prev, items[length - 1].next);
  }
  run_out_transitions(transitions, () => {
    for (var i2 = 0; i2 < length; i2++) {
      var item = items[i2];
      if (!is_controlled) {
        items_map.delete(item.k);
        link(state2, item.prev, item.next);
      }
      destroy_effect(item.e, !is_controlled);
    }
  });
}
function each(node, flags, get_collection, get_key, render_fn, fallback_fn = null) {
  var anchor = node;
  var state2 = { flags, items: /* @__PURE__ */ new Map(), first: null };
  var is_controlled = (flags & EACH_IS_CONTROLLED) !== 0;
  if (is_controlled) {
    var parent_node = (
      /** @type {Element} */
      node
    );
    anchor = parent_node.appendChild(create_text());
  }
  var fallback2 = null;
  var was_empty = false;
  var each_array = /* @__PURE__ */ derived_safe_equal(() => {
    var collection = get_collection();
    return is_array(collection) ? collection : collection == null ? [] : array_from(collection);
  });
  block(() => {
    var array2 = get$3(each_array);
    var length = array2.length;
    if (was_empty && length === 0) {
      return;
    }
    was_empty = length === 0;
    {
      reconcile(array2, state2, anchor, render_fn, flags, get_key, get_collection);
    }
    if (fallback_fn !== null) {
      if (length === 0) {
        if (fallback2) {
          resume_effect(fallback2);
        } else {
          fallback2 = branch(() => fallback_fn(anchor));
        }
      } else if (fallback2 !== null) {
        pause_effect(fallback2, () => {
          fallback2 = null;
        });
      }
    }
    get$3(each_array);
  });
}
function reconcile(array2, state2, anchor, render_fn, flags, get_key, get_collection) {
  var _a2, _b2, _c2, _d2;
  var is_animated = (flags & EACH_IS_ANIMATED) !== 0;
  var should_update = (flags & (EACH_ITEM_REACTIVE | EACH_INDEX_REACTIVE)) !== 0;
  var length = array2.length;
  var items = state2.items;
  var first = state2.first;
  var current = first;
  var seen;
  var prev = null;
  var to_animate;
  var matched = [];
  var stashed = [];
  var value;
  var key2;
  var item;
  var i;
  if (is_animated) {
    for (i = 0; i < length; i += 1) {
      value = array2[i];
      key2 = get_key(value, i);
      item = items.get(key2);
      if (item !== void 0) {
        (_a2 = item.a) == null ? void 0 : _a2.measure();
        (to_animate != null ? to_animate : to_animate = /* @__PURE__ */ new Set()).add(item);
      }
    }
  }
  for (i = 0; i < length; i += 1) {
    value = array2[i];
    key2 = get_key(value, i);
    item = items.get(key2);
    if (item === void 0) {
      var child_anchor = current ? (
        /** @type {TemplateNode} */
        current.e.nodes_start
      ) : anchor;
      prev = create_item(
        child_anchor,
        state2,
        prev,
        prev === null ? state2.first : prev.next,
        value,
        key2,
        i,
        render_fn,
        flags,
        get_collection
      );
      items.set(key2, prev);
      matched = [];
      stashed = [];
      current = prev.next;
      continue;
    }
    if (should_update) {
      update_item(item, value, i, flags);
    }
    if ((item.e.f & INERT) !== 0) {
      resume_effect(item.e);
      if (is_animated) {
        (_b2 = item.a) == null ? void 0 : _b2.unfix();
        (to_animate != null ? to_animate : to_animate = /* @__PURE__ */ new Set()).delete(item);
      }
    }
    if (item !== current) {
      if (seen !== void 0 && seen.has(item)) {
        if (matched.length < stashed.length) {
          var start2 = stashed[0];
          var j2;
          prev = start2.prev;
          var a = matched[0];
          var b2 = matched[matched.length - 1];
          for (j2 = 0; j2 < matched.length; j2 += 1) {
            move(matched[j2], start2, anchor);
          }
          for (j2 = 0; j2 < stashed.length; j2 += 1) {
            seen.delete(stashed[j2]);
          }
          link(state2, a.prev, b2.next);
          link(state2, prev, a);
          link(state2, b2, start2);
          current = start2;
          prev = b2;
          i -= 1;
          matched = [];
          stashed = [];
        } else {
          seen.delete(item);
          move(item, current, anchor);
          link(state2, item.prev, item.next);
          link(state2, item, prev === null ? state2.first : prev.next);
          link(state2, prev, item);
          prev = item;
        }
        continue;
      }
      matched = [];
      stashed = [];
      while (current !== null && current.k !== key2) {
        if ((current.e.f & INERT) === 0) {
          (seen != null ? seen : seen = /* @__PURE__ */ new Set()).add(current);
        }
        stashed.push(current);
        current = current.next;
      }
      if (current === null) {
        continue;
      }
      item = current;
    }
    matched.push(item);
    prev = item;
    current = item.next;
  }
  if (current !== null || seen !== void 0) {
    var to_destroy = seen === void 0 ? [] : array_from(seen);
    while (current !== null) {
      if ((current.e.f & INERT) === 0) {
        to_destroy.push(current);
      }
      current = current.next;
    }
    var destroy_length = to_destroy.length;
    if (destroy_length > 0) {
      var controlled_anchor = (flags & EACH_IS_CONTROLLED) !== 0 && length === 0 ? anchor : null;
      if (is_animated) {
        for (i = 0; i < destroy_length; i += 1) {
          (_c2 = to_destroy[i].a) == null ? void 0 : _c2.measure();
        }
        for (i = 0; i < destroy_length; i += 1) {
          (_d2 = to_destroy[i].a) == null ? void 0 : _d2.fix();
        }
      }
      pause_effects(state2, to_destroy, controlled_anchor, items);
    }
  }
  if (is_animated) {
    queue_micro_task(() => {
      var _a3;
      if (to_animate === void 0) return;
      for (item of to_animate) {
        (_a3 = item.a) == null ? void 0 : _a3.apply();
      }
    });
  }
  active_effect.first = state2.first && state2.first.e;
  active_effect.last = prev && prev.e;
}
function update_item(item, value, index2, type) {
  if ((type & EACH_ITEM_REACTIVE) !== 0) {
    internal_set(item.v, value);
  }
  if ((type & EACH_INDEX_REACTIVE) !== 0) {
    internal_set(
      /** @type {Value<number>} */
      item.i,
      index2
    );
  } else {
    item.i = index2;
  }
}
function create_item(anchor, state2, prev, next, value, key2, index2, render_fn, flags, get_collection) {
  var reactive = (flags & EACH_ITEM_REACTIVE) !== 0;
  var mutable = (flags & EACH_ITEM_IMMUTABLE) === 0;
  var v2 = reactive ? mutable ? /* @__PURE__ */ mutable_source(value, false, false) : source(value) : value;
  var i = (flags & EACH_INDEX_REACTIVE) === 0 ? index2 : source(index2);
  var item = {
    i,
    v: v2,
    k: key2,
    a: null,
    // @ts-expect-error
    e: null,
    prev,
    next
  };
  try {
    item.e = branch(() => render_fn(anchor, v2, i, get_collection), hydrating);
    item.e.prev = prev && prev.e;
    item.e.next = next && next.e;
    if (prev === null) {
      state2.first = item;
    } else {
      prev.next = item;
      prev.e.next = item.e;
    }
    if (next !== null) {
      next.prev = item;
      next.e.prev = item.e;
    }
    return item;
  } finally {
  }
}
function move(item, next, anchor) {
  var end = item.next ? (
    /** @type {TemplateNode} */
    item.next.e.nodes_start
  ) : anchor;
  var dest = next ? (
    /** @type {TemplateNode} */
    next.e.nodes_start
  ) : anchor;
  var node = (
    /** @type {TemplateNode} */
    item.e.nodes_start
  );
  while (node !== end) {
    var next_node = (
      /** @type {TemplateNode} */
      /* @__PURE__ */ get_next_sibling(node)
    );
    dest.before(node);
    node = next_node;
  }
}
function link(state2, prev, next) {
  if (prev === null) {
    state2.first = next;
  } else {
    prev.next = next;
    prev.e.next = next && next.e;
  }
  if (next !== null) {
    next.prev = prev;
    next.e.prev = prev && prev.e;
  }
}
function html(node, get_value, svg = false, mathml = false, skip_warning = false) {
  var anchor = node;
  var value = "";
  template_effect(() => {
    var _a2;
    var effect2 = (
      /** @type {Effect} */
      active_effect
    );
    if (value === (value = (_a2 = get_value()) != null ? _a2 : "")) {
      return;
    }
    if (effect2.nodes_start !== null) {
      remove_effect_dom(
        effect2.nodes_start,
        /** @type {TemplateNode} */
        effect2.nodes_end
      );
      effect2.nodes_start = effect2.nodes_end = null;
    }
    if (value === "") return;
    var html2 = value + "";
    if (svg) html2 = `<svg>${html2}</svg>`;
    else if (mathml) html2 = `<math>${html2}</math>`;
    var node2 = create_fragment_from_html(html2);
    if (svg || mathml) {
      node2 = /** @type {Element} */
      /* @__PURE__ */ get_first_child(node2);
    }
    assign_nodes(
      /** @type {TemplateNode} */
      /* @__PURE__ */ get_first_child(node2),
      /** @type {TemplateNode} */
      node2.lastChild
    );
    if (svg || mathml) {
      while (/* @__PURE__ */ get_first_child(node2)) {
        anchor.before(
          /** @type {Node} */
          /* @__PURE__ */ get_first_child(node2)
        );
      }
    } else {
      anchor.before(node2);
    }
  });
}
function component(node, get_component, render_fn) {
  var anchor = node;
  var component2;
  var effect2;
  block(() => {
    if (component2 === (component2 = get_component())) return;
    if (effect2) {
      pause_effect(effect2);
      effect2 = null;
    }
    if (component2) {
      effect2 = branch(() => render_fn(anchor, component2));
    }
  }, EFFECT_TRANSPARENT);
}
function action(dom, action2, get_value) {
  effect(() => {
    var payload = untrack(() => action2(dom, get_value == null ? void 0 : get_value()) || {});
    if (get_value && (payload == null ? void 0 : payload.update)) {
      var inited = false;
      var prev = (
        /** @type {any} */
        {}
      );
      render_effect(() => {
        var value = get_value();
        deep_read_state(value);
        if (inited && safe_not_equal(prev, value)) {
          prev = value;
          payload.update(value);
        }
      });
      inited = true;
    }
    if (payload == null ? void 0 : payload.destroy) {
      return () => (
        /** @type {Function} */
        payload.destroy()
      );
    }
  });
}
function attach(node, get_fn) {
  var fn = void 0;
  var e;
  block(() => {
    if (fn !== (fn = get_fn())) {
      if (e) {
        destroy_effect(e);
        e = null;
      }
      if (fn) {
        e = branch(() => {
          effect(() => (
            /** @type {(node: Element) => void} */
            fn(node)
          ));
        });
      }
    }
  });
}
function r(e) {
  var t, f, n = "";
  if ("string" == typeof e || "number" == typeof e) n += e;
  else if ("object" == typeof e) if (Array.isArray(e)) {
    var o = e.length;
    for (t = 0; t < o; t++) e[t] && (f = r(e[t])) && (n && (n += " "), n += f);
  } else for (f in e) e[f] && (n && (n += " "), n += f);
  return n;
}
function clsx$1() {
  for (var e, t, f = 0, n = "", o = arguments.length; f < o; f++) (e = arguments[f]) && (t = r(e)) && (n && (n += " "), n += t);
  return n;
}
function clsx(value) {
  if (typeof value === "object") {
    return clsx$1(value);
  } else {
    return value != null ? value : "";
  }
}
const whitespace = [..." 	\n\r\f \v\uFEFF"];
function to_class(value, hash, directives) {
  var classname = value == null ? "" : "" + value;
  if (hash) {
    classname = classname ? classname + " " + hash : hash;
  }
  if (directives) {
    for (var key2 in directives) {
      if (directives[key2]) {
        classname = classname ? classname + " " + key2 : key2;
      } else if (classname.length) {
        var len = key2.length;
        var a = 0;
        while ((a = classname.indexOf(key2, a)) >= 0) {
          var b2 = a + len;
          if ((a === 0 || whitespace.includes(classname[a - 1])) && (b2 === classname.length || whitespace.includes(classname[b2]))) {
            classname = (a === 0 ? "" : classname.substring(0, a)) + classname.substring(b2 + 1);
          } else {
            a = b2;
          }
        }
      }
    }
  }
  return classname === "" ? null : classname;
}
function append_styles(styles, important = false) {
  var separator2 = important ? " !important;" : ";";
  var css = "";
  for (var key2 in styles) {
    var value = styles[key2];
    if (value != null && value !== "") {
      css += " " + key2 + ": " + value + separator2;
    }
  }
  return css;
}
function to_css_name(name) {
  if (name[0] !== "-" || name[1] !== "-") {
    return name.toLowerCase();
  }
  return name;
}
function to_style(value, styles) {
  if (styles) {
    var new_style = "";
    var normal_styles;
    var important_styles;
    if (Array.isArray(styles)) {
      normal_styles = styles[0];
      important_styles = styles[1];
    } else {
      normal_styles = styles;
    }
    if (value) {
      value = String(value).replaceAll(/\s*\/\*.*?\*\/\s*/g, "").trim();
      var in_str = false;
      var in_apo = 0;
      var in_comment = false;
      var reserved_names = [];
      if (normal_styles) {
        reserved_names.push(...Object.keys(normal_styles).map(to_css_name));
      }
      if (important_styles) {
        reserved_names.push(...Object.keys(important_styles).map(to_css_name));
      }
      var start_index = 0;
      var name_index = -1;
      const len = value.length;
      for (var i = 0; i < len; i++) {
        var c = value[i];
        if (in_comment) {
          if (c === "/" && value[i - 1] === "*") {
            in_comment = false;
          }
        } else if (in_str) {
          if (in_str === c) {
            in_str = false;
          }
        } else if (c === "/" && value[i + 1] === "*") {
          in_comment = true;
        } else if (c === '"' || c === "'") {
          in_str = c;
        } else if (c === "(") {
          in_apo++;
        } else if (c === ")") {
          in_apo--;
        }
        if (!in_comment && in_str === false && in_apo === 0) {
          if (c === ":" && name_index === -1) {
            name_index = i;
          } else if (c === ";" || i === len - 1) {
            if (name_index !== -1) {
              var name = to_css_name(value.substring(start_index, name_index).trim());
              if (!reserved_names.includes(name)) {
                if (c !== ";") {
                  i++;
                }
                var property = value.substring(start_index, i).trim();
                new_style += " " + property + ";";
              }
            }
            start_index = i + 1;
            name_index = -1;
          }
        }
      }
    }
    if (normal_styles) {
      new_style += append_styles(normal_styles);
    }
    if (important_styles) {
      new_style += append_styles(important_styles, true);
    }
    new_style = new_style.trim();
    return new_style === "" ? null : new_style;
  }
  return value == null ? null : String(value);
}
function set_class(dom, is_html, value, hash, prev_classes, next_classes) {
  var prev = dom.__className;
  if (prev !== value || prev === void 0) {
    var next_class_name = to_class(value, hash, next_classes);
    {
      if (next_class_name == null) {
        dom.removeAttribute("class");
      } else if (is_html) {
        dom.className = next_class_name;
      } else {
        dom.setAttribute("class", next_class_name);
      }
    }
    dom.__className = value;
  } else if (next_classes && prev_classes !== next_classes) {
    for (var key2 in next_classes) {
      var is_present = !!next_classes[key2];
      if (prev_classes == null || is_present !== !!prev_classes[key2]) {
        dom.classList.toggle(key2, is_present);
      }
    }
  }
  return next_classes;
}
function update_styles(dom, prev = {}, next, priority) {
  for (var key2 in next) {
    var value = next[key2];
    if (prev[key2] !== value) {
      if (next[key2] == null) {
        dom.style.removeProperty(key2);
      } else {
        dom.style.setProperty(key2, value, priority);
      }
    }
  }
}
function set_style(dom, value, prev_styles, next_styles) {
  var prev = dom.__style;
  if (prev !== value) {
    var next_style_attr = to_style(value, next_styles);
    {
      if (next_style_attr == null) {
        dom.removeAttribute("style");
      } else {
        dom.style.cssText = next_style_attr;
      }
    }
    dom.__style = value;
  } else if (next_styles) {
    if (Array.isArray(next_styles)) {
      update_styles(dom, prev_styles == null ? void 0 : prev_styles[0], next_styles[0]);
      update_styles(dom, prev_styles == null ? void 0 : prev_styles[1], next_styles[1], "important");
    } else {
      update_styles(dom, prev_styles, next_styles);
    }
  }
  return next_styles;
}
function select_option(select2, value, mounting) {
  if (select2.multiple) {
    if (value == void 0) {
      return;
    }
    if (!is_array(value)) {
      return select_multiple_invalid_value();
    }
    for (var option of select2.options) {
      option.selected = value.includes(get_option_value(option));
    }
    return;
  }
  for (option of select2.options) {
    var option_value = get_option_value(option);
    if (is(option_value, value)) {
      option.selected = true;
      return;
    }
  }
  if (!mounting || value !== void 0) {
    select2.selectedIndex = -1;
  }
}
function init_select(select2) {
  var observer = new MutationObserver(() => {
    select_option(select2, select2.__value);
  });
  observer.observe(select2, {
    // Listen to option element changes
    childList: true,
    subtree: true,
    // because of <optgroup>
    // Listen to option element value attribute changes
    // (doesn't get notified of select value changes,
    // because that property is not reflected as an attribute)
    attributes: true,
    attributeFilter: ["value"]
  });
  teardown(() => {
    observer.disconnect();
  });
}
function bind_select_value(select2, get2, set2 = get2) {
  var mounting = true;
  listen_to_event_and_reset_event(select2, "change", (is_reset) => {
    var _a2;
    var query = is_reset ? "[selected]" : ":checked";
    var value;
    if (select2.multiple) {
      value = [].map.call(select2.querySelectorAll(query), get_option_value);
    } else {
      var selected_option = (_a2 = select2.querySelector(query)) != null ? _a2 : (
        // will fall back to first non-disabled option if no option is selected
        select2.querySelector("option:not([disabled])")
      );
      value = selected_option && get_option_value(selected_option);
    }
    set2(value);
  });
  effect(() => {
    var value = get2();
    select_option(select2, value, mounting);
    if (mounting && value === void 0) {
      var selected_option = select2.querySelector(":checked");
      if (selected_option !== null) {
        value = get_option_value(selected_option);
        set2(value);
      }
    }
    select2.__value = value;
    mounting = false;
  });
  init_select(select2);
}
function get_option_value(option) {
  if ("__value" in option) {
    return option.__value;
  } else {
    return option.value;
  }
}
const CLASS = Symbol("class");
const STYLE = Symbol("style");
const IS_CUSTOM_ELEMENT = Symbol("is custom element");
const IS_HTML = Symbol("is html");
function set_value(element, value) {
  var attributes = get_attributes(element);
  if (attributes.value === (attributes.value = // treat null and undefined the same for the initial value
  value != null ? value : void 0) || // @ts-expect-error
  // `progress` elements always need their value set when it's `0`
  element.value === value && (value !== 0 || element.nodeName !== "PROGRESS")) {
    return;
  }
  element.value = value != null ? value : "";
}
function set_checked(element, checked) {
  var attributes = get_attributes(element);
  if (attributes.checked === (attributes.checked = // treat null and undefined the same for the initial value
  checked != null ? checked : void 0)) {
    return;
  }
  element.checked = checked;
}
function set_selected(element, selected) {
  if (selected) {
    if (!element.hasAttribute("selected")) {
      element.setAttribute("selected", "");
    }
  } else {
    element.removeAttribute("selected");
  }
}
function set_attribute(element, attribute, value, skip_warning) {
  var attributes = get_attributes(element);
  if (attributes[attribute] === (attributes[attribute] = value)) return;
  if (attribute === "loading") {
    element[LOADING_ATTR_SYMBOL] = value;
  }
  if (value == null) {
    element.removeAttribute(attribute);
  } else if (typeof value !== "string" && get_setters(element).includes(attribute)) {
    element[attribute] = value;
  } else {
    element.setAttribute(attribute, value);
  }
}
function set_attributes(element, prev, next, css_hash, skip_warning = false) {
  var _a2;
  var attributes = get_attributes(element);
  var is_custom_element = attributes[IS_CUSTOM_ELEMENT];
  var preserve_attribute_case = !attributes[IS_HTML];
  var current = prev || {};
  var is_option_element = element.tagName === "OPTION";
  for (var key2 in prev) {
    if (!(key2 in next)) {
      next[key2] = null;
    }
  }
  if (next.class) {
    next.class = clsx(next.class);
  } else if (css_hash || next[CLASS]) {
    next.class = null;
  }
  if (next[STYLE]) {
    (_a2 = next.style) != null ? _a2 : next.style = null;
  }
  var setters = get_setters(element);
  for (const key3 in next) {
    let value = next[key3];
    if (is_option_element && key3 === "value" && value == null) {
      element.value = element.__value = "";
      current[key3] = value;
      continue;
    }
    if (key3 === "class") {
      var is_html = element.namespaceURI === "http://www.w3.org/1999/xhtml";
      set_class(element, is_html, value, css_hash, prev == null ? void 0 : prev[CLASS], next[CLASS]);
      current[key3] = value;
      current[CLASS] = next[CLASS];
      continue;
    }
    if (key3 === "style") {
      set_style(element, value, prev == null ? void 0 : prev[STYLE], next[STYLE]);
      current[key3] = value;
      current[STYLE] = next[STYLE];
      continue;
    }
    var prev_value = current[key3];
    if (value === prev_value && !(value === void 0 && element.hasAttribute(key3))) {
      continue;
    }
    current[key3] = value;
    var prefix = key3[0] + key3[1];
    if (prefix === "$$") continue;
    if (prefix === "on") {
      const opts = {};
      const event_handle_key = "$$" + key3;
      let event_name = key3.slice(2);
      var delegated = is_delegated(event_name);
      if (is_capture_event(event_name)) {
        event_name = event_name.slice(0, -7);
        opts.capture = true;
      }
      if (!delegated && prev_value) {
        if (value != null) continue;
        element.removeEventListener(event_name, current[event_handle_key], opts);
        current[event_handle_key] = null;
      }
      if (value != null) {
        if (!delegated) {
          let handle = function(evt) {
            current[key3].call(this, evt);
          };
          current[event_handle_key] = create_event(event_name, element, handle, opts);
        } else {
          element[`__${event_name}`] = value;
          delegate([event_name]);
        }
      } else if (delegated) {
        element[`__${event_name}`] = void 0;
      }
    } else if (key3 === "style") {
      set_attribute(element, key3, value);
    } else if (key3 === "autofocus") {
      autofocus(
        /** @type {HTMLElement} */
        element,
        Boolean(value)
      );
    } else if (!is_custom_element && (key3 === "__value" || key3 === "value" && value != null)) {
      element.value = element.__value = value;
    } else if (key3 === "selected" && is_option_element) {
      set_selected(
        /** @type {HTMLOptionElement} */
        element,
        value
      );
    } else {
      var name = key3;
      if (!preserve_attribute_case) {
        name = normalize_attribute(name);
      }
      var is_default = name === "defaultValue" || name === "defaultChecked";
      if (value == null && !is_custom_element && !is_default) {
        attributes[key3] = null;
        if (name === "value" || name === "checked") {
          let input = (
            /** @type {HTMLInputElement} */
            element
          );
          const use_default = prev === void 0;
          if (name === "value") {
            let previous = input.defaultValue;
            input.removeAttribute(name);
            input.defaultValue = previous;
            input.value = input.__value = use_default ? previous : null;
          } else {
            let previous = input.defaultChecked;
            input.removeAttribute(name);
            input.defaultChecked = previous;
            input.checked = use_default ? previous : false;
          }
        } else {
          element.removeAttribute(key3);
        }
      } else if (is_default || setters.includes(name) && (is_custom_element || typeof value !== "string")) {
        element[name] = value;
      } else if (typeof value !== "function") {
        set_attribute(element, name, value);
      }
    }
  }
  return current;
}
function attribute_effect(element, fn, thunks = [], css_hash, skip_warning = false, d2 = derived$1) {
  const deriveds = thunks.map(d2);
  var prev = void 0;
  var effects = {};
  var is_select = element.nodeName === "SELECT";
  var inited = false;
  block(() => {
    var next = fn(...deriveds.map(get$3));
    var current = set_attributes(element, prev, next, css_hash, skip_warning);
    if (inited && is_select && "value" in next) {
      select_option(
        /** @type {HTMLSelectElement} */
        element,
        next.value,
        false
      );
    }
    for (let symbol of Object.getOwnPropertySymbols(effects)) {
      if (!next[symbol]) destroy_effect(effects[symbol]);
    }
    for (let symbol of Object.getOwnPropertySymbols(next)) {
      var n = next[symbol];
      if (symbol.description === ATTACHMENT_KEY && (!prev || n !== prev[symbol])) {
        if (effects[symbol]) destroy_effect(effects[symbol]);
        effects[symbol] = branch(() => attach(element, () => n));
      }
      current[symbol] = n;
    }
    prev = current;
  });
  if (is_select) {
    var select2 = (
      /** @type {HTMLSelectElement} */
      element
    );
    effect(() => {
      select_option(
        select2,
        /** @type {Record<string | symbol, any>} */
        prev.value
      );
      init_select(select2);
    });
  }
  inited = true;
}
function get_attributes(element) {
  var _a2;
  return (
    /** @type {Record<string | symbol, unknown>} **/
    // @ts-expect-error
    (_a2 = element.__attributes) != null ? _a2 : element.__attributes = {
      [IS_CUSTOM_ELEMENT]: element.nodeName.includes("-"),
      [IS_HTML]: element.namespaceURI === NAMESPACE_HTML
    }
  );
}
var setters_cache = /* @__PURE__ */ new Map();
function get_setters(element) {
  var setters = setters_cache.get(element.nodeName);
  if (setters) return setters;
  setters_cache.set(element.nodeName, setters = []);
  var descriptors;
  var proto = element;
  var element_proto = Element.prototype;
  while (element_proto !== proto) {
    descriptors = get_descriptors(proto);
    for (var key2 in descriptors) {
      if (descriptors[key2].set) {
        setters.push(key2);
      }
    }
    proto = get_prototype_of(proto);
  }
  return setters;
}
function bind_value(input, get2, set2 = get2) {
  var runes = is_runes();
  listen_to_event_and_reset_event(input, "input", (is_reset) => {
    var value = is_reset ? input.defaultValue : input.value;
    value = is_numberlike_input(input) ? to_number(value) : value;
    set2(value);
    if (runes && value !== (value = get2())) {
      var start2 = input.selectionStart;
      var end = input.selectionEnd;
      input.value = value != null ? value : "";
      if (end !== null) {
        input.selectionStart = start2;
        input.selectionEnd = Math.min(end, input.value.length);
      }
    }
  });
  if (
    // If we are hydrating and the value has since changed,
    // then use the updated value from the input instead.
    // If defaultValue is set, then value == defaultValue
    // TODO Svelte 6: remove input.value check and set to empty string?
    untrack(get2) == null && input.value
  ) {
    set2(is_numberlike_input(input) ? to_number(input.value) : input.value);
  }
  render_effect(() => {
    var value = get2();
    if (is_numberlike_input(input) && value === to_number(input.value)) {
      return;
    }
    if (input.type === "date" && !value && !input.value) {
      return;
    }
    if (value !== input.value) {
      input.value = value != null ? value : "";
    }
  });
}
function is_numberlike_input(input) {
  var type = input.type;
  return type === "number" || type === "range";
}
function to_number(value) {
  return value === "" ? null : +value;
}
const _ResizeObserverSingleton = class _ResizeObserverSingleton {
  /** @param {ResizeObserverOptions} options */
  constructor(options) {
    __privateAdd(this, _ResizeObserverSingleton_instances);
    /** */
    __privateAdd(this, _listeners, /* @__PURE__ */ new WeakMap());
    /** @type {ResizeObserver | undefined} */
    __privateAdd(this, _observer);
    /** @type {ResizeObserverOptions} */
    __privateAdd(this, _options);
    __privateSet(this, _options, options);
  }
  /**
   * @param {Element} element
   * @param {(entry: ResizeObserverEntry) => any} listener
   */
  observe(element, listener) {
    var listeners = __privateGet(this, _listeners).get(element) || /* @__PURE__ */ new Set();
    listeners.add(listener);
    __privateGet(this, _listeners).set(element, listeners);
    __privateMethod(this, _ResizeObserverSingleton_instances, getObserver_fn).call(this).observe(element, __privateGet(this, _options));
    return () => {
      var listeners2 = __privateGet(this, _listeners).get(element);
      listeners2.delete(listener);
      if (listeners2.size === 0) {
        __privateGet(this, _listeners).delete(element);
        __privateGet(this, _observer).unobserve(element);
      }
    };
  }
};
_listeners = new WeakMap();
_observer = new WeakMap();
_options = new WeakMap();
_ResizeObserverSingleton_instances = new WeakSet();
getObserver_fn = function() {
  var _a2;
  return (_a2 = __privateGet(this, _observer)) != null ? _a2 : __privateSet(this, _observer, new ResizeObserver(
    /** @param {any} entries */
    (entries) => {
      for (var entry of entries) {
        _ResizeObserverSingleton.entries.set(entry.target, entry);
        for (var listener of __privateGet(this, _listeners).get(entry.target) || []) {
          listener(entry);
        }
      }
    }
  ));
};
/** @static */
__publicField(_ResizeObserverSingleton, "entries", /* @__PURE__ */ new WeakMap());
let ResizeObserverSingleton = _ResizeObserverSingleton;
var resize_observer_border_box = /* @__PURE__ */ new ResizeObserverSingleton({
  box: "border-box"
});
function bind_element_size(element, type, set2) {
  var unsub = resize_observer_border_box.observe(element, () => set2(element[type]));
  effect(() => {
    untrack(() => set2(element[type]));
    return unsub;
  });
}
function is_bound_this(bound_value, element_or_component) {
  return bound_value === element_or_component || (bound_value == null ? void 0 : bound_value[STATE_SYMBOL]) === element_or_component;
}
function bind_this(element_or_component = {}, update2, get_value, get_parts) {
  effect(() => {
    var old_parts;
    var parts;
    render_effect(() => {
      old_parts = parts;
      parts = [];
      untrack(() => {
        if (element_or_component !== get_value(...parts)) {
          update2(element_or_component, ...parts);
          if (old_parts && is_bound_this(get_value(...old_parts), element_or_component)) {
            update2(null, ...old_parts);
          }
        }
      });
    });
    return () => {
      queue_micro_task(() => {
        if (parts && is_bound_this(get_value(...parts), element_or_component)) {
          update2(null, ...parts);
        }
      });
    };
  });
  return element_or_component;
}
function init$1(immutable = false) {
  const context = (
    /** @type {ComponentContextLegacy} */
    component_context
  );
  const callbacks = context.l.u;
  if (!callbacks) return;
  let props = () => deep_read_state(context.s);
  if (immutable) {
    let version = 0;
    let prev = (
      /** @type {Record<string, any>} */
      {}
    );
    const d2 = /* @__PURE__ */ derived$1(() => {
      let changed = false;
      const props2 = context.s;
      for (const key2 in props2) {
        if (props2[key2] !== prev[key2]) {
          prev[key2] = props2[key2];
          changed = true;
        }
      }
      if (changed) version++;
      return version;
    });
    props = () => get$3(d2);
  }
  if (callbacks.b.length) {
    user_pre_effect(() => {
      observe_all(context, props);
      run_all(callbacks.b);
    });
  }
  user_effect(() => {
    const fns = untrack(() => callbacks.m.map(run));
    return () => {
      for (const fn of fns) {
        if (typeof fn === "function") {
          fn();
        }
      }
    };
  });
  if (callbacks.a.length) {
    user_effect(() => {
      observe_all(context, props);
      run_all(callbacks.a);
    });
  }
}
function observe_all(context, props) {
  if (context.l.s) {
    for (const signal of context.l.s) get$3(signal);
  }
  props();
}
function subscribe_to_store(store, run2, invalidate) {
  if (store == null) {
    run2(void 0);
    if (invalidate) invalidate(void 0);
    return noop$1;
  }
  const unsub = untrack(
    () => store.subscribe(
      run2,
      // @ts-expect-error
      invalidate
    )
  );
  return unsub.unsubscribe ? () => unsub.unsubscribe() : unsub;
}
const subscriber_queue = [];
function readable(value, start2) {
  return {
    subscribe: writable(value, start2).subscribe
  };
}
function writable(value, start2 = noop$1) {
  let stop = null;
  const subscribers = /* @__PURE__ */ new Set();
  function set2(new_value) {
    if (safe_not_equal(value, new_value)) {
      value = new_value;
      if (stop) {
        const run_queue = !subscriber_queue.length;
        for (const subscriber of subscribers) {
          subscriber[1]();
          subscriber_queue.push(subscriber, value);
        }
        if (run_queue) {
          for (let i = 0; i < subscriber_queue.length; i += 2) {
            subscriber_queue[i][0](subscriber_queue[i + 1]);
          }
          subscriber_queue.length = 0;
        }
      }
    }
  }
  function update2(fn) {
    set2(fn(
      /** @type {T} */
      value
    ));
  }
  function subscribe(run2, invalidate = noop$1) {
    const subscriber = [run2, invalidate];
    subscribers.add(subscriber);
    if (subscribers.size === 1) {
      stop = start2(set2, update2) || noop$1;
    }
    run2(
      /** @type {T} */
      value
    );
    return () => {
      subscribers.delete(subscriber);
      if (subscribers.size === 0 && stop) {
        stop();
        stop = null;
      }
    };
  }
  return { set: set2, update: update2, subscribe };
}
function derived(stores, fn, initial_value) {
  const single = !Array.isArray(stores);
  const stores_array = single ? [stores] : stores;
  if (!stores_array.every(Boolean)) {
    throw new Error("derived() expects stores as input, got a falsy value");
  }
  const auto = fn.length < 2;
  return readable(initial_value, (set2, update2) => {
    let started = false;
    const values = [];
    let pending = 0;
    let cleanup = noop$1;
    const sync = () => {
      if (pending) {
        return;
      }
      cleanup();
      const result = fn(single ? values[0] : values, set2, update2);
      if (auto) {
        set2(result);
      } else {
        cleanup = typeof result === "function" ? result : noop$1;
      }
    };
    const unsubscribers = stores_array.map(
      (store, i) => subscribe_to_store(
        store,
        (value) => {
          values[i] = value;
          pending &= ~(1 << i);
          if (started) {
            sync();
          }
        },
        () => {
          pending |= 1 << i;
        }
      )
    );
    started = true;
    sync();
    return function stop() {
      run_all(unsubscribers);
      cleanup();
      started = false;
    };
  });
}
function get$2(store) {
  let value;
  subscribe_to_store(store, (_2) => value = _2)();
  return value;
}
let is_store_binding = false;
let IS_UNMOUNTED = Symbol();
function store_get(store, store_name, stores) {
  var _a2;
  const entry = (_a2 = stores[store_name]) != null ? _a2 : stores[store_name] = {
    store: null,
    source: /* @__PURE__ */ mutable_source(void 0),
    unsubscribe: noop$1
  };
  if (entry.store !== store && !(IS_UNMOUNTED in stores)) {
    entry.unsubscribe();
    entry.store = store != null ? store : null;
    if (store == null) {
      entry.source.v = void 0;
      entry.unsubscribe = noop$1;
    } else {
      var is_synchronous_callback = true;
      entry.unsubscribe = subscribe_to_store(store, (v2) => {
        if (is_synchronous_callback) {
          entry.source.v = v2;
        } else {
          set$2(entry.source, v2);
        }
      });
      is_synchronous_callback = false;
    }
  }
  if (store && IS_UNMOUNTED in stores) {
    return get$2(store);
  }
  return get$3(entry.source);
}
function setup_stores() {
  const stores = {};
  function cleanup() {
    teardown(() => {
      for (var store_name in stores) {
        const ref = stores[store_name];
        ref.unsubscribe();
      }
      define_property(stores, IS_UNMOUNTED, {
        enumerable: false,
        value: true
      });
    });
  }
  return [stores, cleanup];
}
function capture_store_binding(fn) {
  var previous_is_store_binding = is_store_binding;
  try {
    is_store_binding = false;
    return [fn(), is_store_binding];
  } finally {
    is_store_binding = previous_is_store_binding;
  }
}
const rest_props_handler = {
  get(target, key2) {
    if (target.exclude.includes(key2)) return;
    return target.props[key2];
  },
  set(target, key2) {
    return false;
  },
  getOwnPropertyDescriptor(target, key2) {
    if (target.exclude.includes(key2)) return;
    if (key2 in target.props) {
      return {
        enumerable: true,
        configurable: true,
        value: target.props[key2]
      };
    }
  },
  has(target, key2) {
    if (target.exclude.includes(key2)) return false;
    return key2 in target.props;
  },
  ownKeys(target) {
    return Reflect.ownKeys(target.props).filter((key2) => !target.exclude.includes(key2));
  }
};
// @__NO_SIDE_EFFECTS__
function rest_props(props, exclude, name) {
  return new Proxy(
    { props, exclude },
    rest_props_handler
  );
}
const spread_props_handler = {
  get(target, key2) {
    let i = target.props.length;
    while (i--) {
      let p = target.props[i];
      if (is_function(p)) p = p();
      if (typeof p === "object" && p !== null && key2 in p) return p[key2];
    }
  },
  set(target, key2, value) {
    let i = target.props.length;
    while (i--) {
      let p = target.props[i];
      if (is_function(p)) p = p();
      const desc = get_descriptor(p, key2);
      if (desc && desc.set) {
        desc.set(value);
        return true;
      }
    }
    return false;
  },
  getOwnPropertyDescriptor(target, key2) {
    let i = target.props.length;
    while (i--) {
      let p = target.props[i];
      if (is_function(p)) p = p();
      if (typeof p === "object" && p !== null && key2 in p) {
        const descriptor = get_descriptor(p, key2);
        if (descriptor && !descriptor.configurable) {
          descriptor.configurable = true;
        }
        return descriptor;
      }
    }
  },
  has(target, key2) {
    if (key2 === STATE_SYMBOL || key2 === LEGACY_PROPS) return false;
    for (let p of target.props) {
      if (is_function(p)) p = p();
      if (p != null && key2 in p) return true;
    }
    return false;
  },
  ownKeys(target) {
    const keys = [];
    for (let p of target.props) {
      if (is_function(p)) p = p();
      if (!p) continue;
      for (const key2 in p) {
        if (!keys.includes(key2)) keys.push(key2);
      }
      for (const key2 of Object.getOwnPropertySymbols(p)) {
        if (!keys.includes(key2)) keys.push(key2);
      }
    }
    return keys;
  }
};
function spread_props(...props) {
  return new Proxy({ props }, spread_props_handler);
}
function has_destroyed_component_ctx(current_value) {
  var _a2, _b2;
  return (_b2 = (_a2 = current_value.ctx) == null ? void 0 : _a2.d) != null ? _b2 : false;
}
function prop(props, key2, flags, fallback2) {
  var _a2, _b2;
  var immutable = (flags & PROPS_IS_IMMUTABLE) !== 0;
  var runes = !legacy_mode_flag || (flags & PROPS_IS_RUNES) !== 0;
  var bindable = (flags & PROPS_IS_BINDABLE) !== 0;
  var lazy = (flags & PROPS_IS_LAZY_INITIAL) !== 0;
  var is_store_sub = false;
  var prop_value;
  if (bindable) {
    [prop_value, is_store_sub] = capture_store_binding(() => (
      /** @type {V} */
      props[key2]
    ));
  } else {
    prop_value = /** @type {V} */
    props[key2];
  }
  var is_entry_props = STATE_SYMBOL in props || LEGACY_PROPS in props;
  var setter = bindable && ((_b2 = (_a2 = get_descriptor(props, key2)) == null ? void 0 : _a2.set) != null ? _b2 : is_entry_props && key2 in props && ((v2) => props[key2] = v2)) || void 0;
  var fallback_value = (
    /** @type {V} */
    fallback2
  );
  var fallback_dirty = true;
  var fallback_used = false;
  var get_fallback = () => {
    fallback_used = true;
    if (fallback_dirty) {
      fallback_dirty = false;
      if (lazy) {
        fallback_value = untrack(
          /** @type {() => V} */
          fallback2
        );
      } else {
        fallback_value = /** @type {V} */
        fallback2;
      }
    }
    return fallback_value;
  };
  if (prop_value === void 0 && fallback2 !== void 0) {
    if (setter && runes) {
      props_invalid_value();
    }
    prop_value = get_fallback();
    if (setter) setter(prop_value);
  }
  var getter;
  if (runes) {
    getter = () => {
      var value = (
        /** @type {V} */
        props[key2]
      );
      if (value === void 0) return get_fallback();
      fallback_dirty = true;
      fallback_used = false;
      return value;
    };
  } else {
    var derived_getter = (immutable ? derived$1 : derived_safe_equal)(
      () => (
        /** @type {V} */
        props[key2]
      )
    );
    derived_getter.f |= LEGACY_DERIVED_PROP;
    getter = () => {
      var value = get$3(derived_getter);
      if (value !== void 0) fallback_value = /** @type {V} */
      void 0;
      return value === void 0 ? fallback_value : value;
    };
  }
  if ((flags & PROPS_IS_UPDATED) === 0 && runes) {
    return getter;
  }
  if (setter) {
    var legacy_parent = props.$$legacy;
    return function(value, mutation) {
      if (arguments.length > 0) {
        if (!runes || !mutation || legacy_parent || is_store_sub) {
          setter(mutation ? getter() : value);
        }
        return value;
      } else {
        return getter();
      }
    };
  }
  var from_child = false;
  var inner_current_value = /* @__PURE__ */ mutable_source(prop_value);
  var current_value = /* @__PURE__ */ derived$1(() => {
    var parent_value = getter();
    var child_value = get$3(inner_current_value);
    if (from_child) {
      from_child = false;
      return child_value;
    }
    return inner_current_value.v = parent_value;
  });
  if (bindable) {
    get$3(current_value);
  }
  if (!immutable) current_value.equals = safe_equals;
  return function(value, mutation) {
    if (arguments.length > 0) {
      const new_value = mutation ? get$3(current_value) : runes && bindable ? proxy(value) : value;
      if (!current_value.equals(new_value)) {
        from_child = true;
        set$2(inner_current_value, new_value);
        if (fallback_used && fallback_value !== void 0) {
          fallback_value = new_value;
        }
        if (has_destroyed_component_ctx(current_value)) {
          return value;
        }
        untrack(() => get$3(current_value));
      }
      return value;
    }
    if (has_destroyed_component_ctx(current_value)) {
      return current_value.v;
    }
    return get$3(current_value);
  };
}
var noop = { value: () => {
} };
function dispatch() {
  for (var i = 0, n = arguments.length, _2 = {}, t; i < n; ++i) {
    if (!(t = arguments[i] + "") || t in _2 || /[\s.]/.test(t)) throw new Error("illegal type: " + t);
    _2[t] = [];
  }
  return new Dispatch(_2);
}
function Dispatch(_2) {
  this._ = _2;
}
function parseTypenames$1(typenames, types) {
  return typenames.trim().split(/^|\s+/).map(function(t) {
    var name = "", i = t.indexOf(".");
    if (i >= 0) name = t.slice(i + 1), t = t.slice(0, i);
    if (t && !types.hasOwnProperty(t)) throw new Error("unknown type: " + t);
    return { type: t, name };
  });
}
Dispatch.prototype = dispatch.prototype = {
  constructor: Dispatch,
  on: function(typename, callback) {
    var _2 = this._, T = parseTypenames$1(typename + "", _2), t, i = -1, n = T.length;
    if (arguments.length < 2) {
      while (++i < n) if ((t = (typename = T[i]).type) && (t = get$1(_2[t], typename.name))) return t;
      return;
    }
    if (callback != null && typeof callback !== "function") throw new Error("invalid callback: " + callback);
    while (++i < n) {
      if (t = (typename = T[i]).type) _2[t] = set$1(_2[t], typename.name, callback);
      else if (callback == null) for (t in _2) _2[t] = set$1(_2[t], typename.name, null);
    }
    return this;
  },
  copy: function() {
    var copy = {}, _2 = this._;
    for (var t in _2) copy[t] = _2[t].slice();
    return new Dispatch(copy);
  },
  call: function(type, that) {
    if ((n = arguments.length - 2) > 0) for (var args = new Array(n), i = 0, n, t; i < n; ++i) args[i] = arguments[i + 2];
    if (!this._.hasOwnProperty(type)) throw new Error("unknown type: " + type);
    for (t = this._[type], i = 0, n = t.length; i < n; ++i) t[i].value.apply(that, args);
  },
  apply: function(type, that, args) {
    if (!this._.hasOwnProperty(type)) throw new Error("unknown type: " + type);
    for (var t = this._[type], i = 0, n = t.length; i < n; ++i) t[i].value.apply(that, args);
  }
};
function get$1(type, name) {
  for (var i = 0, n = type.length, c; i < n; ++i) {
    if ((c = type[i]).name === name) {
      return c.value;
    }
  }
}
function set$1(type, name, callback) {
  for (var i = 0, n = type.length; i < n; ++i) {
    if (type[i].name === name) {
      type[i] = noop, type = type.slice(0, i).concat(type.slice(i + 1));
      break;
    }
  }
  if (callback != null) type.push({ name, value: callback });
  return type;
}
var xhtml = "http://www.w3.org/1999/xhtml";
const namespaces = {
  svg: "http://www.w3.org/2000/svg",
  xhtml,
  xlink: "http://www.w3.org/1999/xlink",
  xml: "http://www.w3.org/XML/1998/namespace",
  xmlns: "http://www.w3.org/2000/xmlns/"
};
function namespace(name) {
  var prefix = name += "", i = prefix.indexOf(":");
  if (i >= 0 && (prefix = name.slice(0, i)) !== "xmlns") name = name.slice(i + 1);
  return namespaces.hasOwnProperty(prefix) ? { space: namespaces[prefix], local: name } : name;
}
function creatorInherit(name) {
  return function() {
    var document2 = this.ownerDocument, uri = this.namespaceURI;
    return uri === xhtml && document2.documentElement.namespaceURI === xhtml ? document2.createElement(name) : document2.createElementNS(uri, name);
  };
}
function creatorFixed(fullname) {
  return function() {
    return this.ownerDocument.createElementNS(fullname.space, fullname.local);
  };
}
function creator(name) {
  var fullname = namespace(name);
  return (fullname.local ? creatorFixed : creatorInherit)(fullname);
}
function none() {
}
function selector(selector2) {
  return selector2 == null ? none : function() {
    return this.querySelector(selector2);
  };
}
function selection_select(select2) {
  if (typeof select2 !== "function") select2 = selector(select2);
  for (var groups = this._groups, m2 = groups.length, subgroups = new Array(m2), j2 = 0; j2 < m2; ++j2) {
    for (var group = groups[j2], n = group.length, subgroup = subgroups[j2] = new Array(n), node, subnode, i = 0; i < n; ++i) {
      if ((node = group[i]) && (subnode = select2.call(node, node.__data__, i, group))) {
        if ("__data__" in node) subnode.__data__ = node.__data__;
        subgroup[i] = subnode;
      }
    }
  }
  return new Selection$2(subgroups, this._parents);
}
function array(x) {
  return x == null ? [] : Array.isArray(x) ? x : Array.from(x);
}
function empty() {
  return [];
}
function selectorAll(selector2) {
  return selector2 == null ? empty : function() {
    return this.querySelectorAll(selector2);
  };
}
function arrayAll(select2) {
  return function() {
    return array(select2.apply(this, arguments));
  };
}
function selection_selectAll(select2) {
  if (typeof select2 === "function") select2 = arrayAll(select2);
  else select2 = selectorAll(select2);
  for (var groups = this._groups, m2 = groups.length, subgroups = [], parents = [], j2 = 0; j2 < m2; ++j2) {
    for (var group = groups[j2], n = group.length, node, i = 0; i < n; ++i) {
      if (node = group[i]) {
        subgroups.push(select2.call(node, node.__data__, i, group));
        parents.push(node);
      }
    }
  }
  return new Selection$2(subgroups, parents);
}
function matcher(selector2) {
  return function() {
    return this.matches(selector2);
  };
}
function childMatcher(selector2) {
  return function(node) {
    return node.matches(selector2);
  };
}
var find = Array.prototype.find;
function childFind(match) {
  return function() {
    return find.call(this.children, match);
  };
}
function childFirst() {
  return this.firstElementChild;
}
function selection_selectChild(match) {
  return this.select(match == null ? childFirst : childFind(typeof match === "function" ? match : childMatcher(match)));
}
var filter = Array.prototype.filter;
function children() {
  return Array.from(this.children);
}
function childrenFilter(match) {
  return function() {
    return filter.call(this.children, match);
  };
}
function selection_selectChildren(match) {
  return this.selectAll(match == null ? children : childrenFilter(typeof match === "function" ? match : childMatcher(match)));
}
function selection_filter(match) {
  if (typeof match !== "function") match = matcher(match);
  for (var groups = this._groups, m2 = groups.length, subgroups = new Array(m2), j2 = 0; j2 < m2; ++j2) {
    for (var group = groups[j2], n = group.length, subgroup = subgroups[j2] = [], node, i = 0; i < n; ++i) {
      if ((node = group[i]) && match.call(node, node.__data__, i, group)) {
        subgroup.push(node);
      }
    }
  }
  return new Selection$2(subgroups, this._parents);
}
function sparse(update2) {
  return new Array(update2.length);
}
function selection_enter() {
  return new Selection$2(this._enter || this._groups.map(sparse), this._parents);
}
function EnterNode(parent, datum2) {
  this.ownerDocument = parent.ownerDocument;
  this.namespaceURI = parent.namespaceURI;
  this._next = null;
  this._parent = parent;
  this.__data__ = datum2;
}
EnterNode.prototype = {
  constructor: EnterNode,
  appendChild: function(child2) {
    return this._parent.insertBefore(child2, this._next);
  },
  insertBefore: function(child2, next) {
    return this._parent.insertBefore(child2, next);
  },
  querySelector: function(selector2) {
    return this._parent.querySelector(selector2);
  },
  querySelectorAll: function(selector2) {
    return this._parent.querySelectorAll(selector2);
  }
};
function constant$3(x) {
  return function() {
    return x;
  };
}
function bindIndex(parent, group, enter, update2, exit, data) {
  var i = 0, node, groupLength = group.length, dataLength = data.length;
  for (; i < dataLength; ++i) {
    if (node = group[i]) {
      node.__data__ = data[i];
      update2[i] = node;
    } else {
      enter[i] = new EnterNode(parent, data[i]);
    }
  }
  for (; i < groupLength; ++i) {
    if (node = group[i]) {
      exit[i] = node;
    }
  }
}
function bindKey(parent, group, enter, update2, exit, data, key2) {
  var i, node, nodeByKeyValue = /* @__PURE__ */ new Map(), groupLength = group.length, dataLength = data.length, keyValues = new Array(groupLength), keyValue;
  for (i = 0; i < groupLength; ++i) {
    if (node = group[i]) {
      keyValues[i] = keyValue = key2.call(node, node.__data__, i, group) + "";
      if (nodeByKeyValue.has(keyValue)) {
        exit[i] = node;
      } else {
        nodeByKeyValue.set(keyValue, node);
      }
    }
  }
  for (i = 0; i < dataLength; ++i) {
    keyValue = key2.call(parent, data[i], i, data) + "";
    if (node = nodeByKeyValue.get(keyValue)) {
      update2[i] = node;
      node.__data__ = data[i];
      nodeByKeyValue.delete(keyValue);
    } else {
      enter[i] = new EnterNode(parent, data[i]);
    }
  }
  for (i = 0; i < groupLength; ++i) {
    if ((node = group[i]) && nodeByKeyValue.get(keyValues[i]) === node) {
      exit[i] = node;
    }
  }
}
function datum(node) {
  return node.__data__;
}
function selection_data(value, key2) {
  if (!arguments.length) return Array.from(this, datum);
  var bind = key2 ? bindKey : bindIndex, parents = this._parents, groups = this._groups;
  if (typeof value !== "function") value = constant$3(value);
  for (var m2 = groups.length, update2 = new Array(m2), enter = new Array(m2), exit = new Array(m2), j2 = 0; j2 < m2; ++j2) {
    var parent = parents[j2], group = groups[j2], groupLength = group.length, data = arraylike(value.call(parent, parent && parent.__data__, j2, parents)), dataLength = data.length, enterGroup = enter[j2] = new Array(dataLength), updateGroup = update2[j2] = new Array(dataLength), exitGroup = exit[j2] = new Array(groupLength);
    bind(parent, group, enterGroup, updateGroup, exitGroup, data, key2);
    for (var i0 = 0, i1 = 0, previous, next; i0 < dataLength; ++i0) {
      if (previous = enterGroup[i0]) {
        if (i0 >= i1) i1 = i0 + 1;
        while (!(next = updateGroup[i1]) && ++i1 < dataLength) ;
        previous._next = next || null;
      }
    }
  }
  update2 = new Selection$2(update2, parents);
  update2._enter = enter;
  update2._exit = exit;
  return update2;
}
function arraylike(data) {
  return typeof data === "object" && "length" in data ? data : Array.from(data);
}
function selection_exit() {
  return new Selection$2(this._exit || this._groups.map(sparse), this._parents);
}
function selection_join(onenter, onupdate, onexit) {
  var enter = this.enter(), update2 = this, exit = this.exit();
  if (typeof onenter === "function") {
    enter = onenter(enter);
    if (enter) enter = enter.selection();
  } else {
    enter = enter.append(onenter + "");
  }
  if (onupdate != null) {
    update2 = onupdate(update2);
    if (update2) update2 = update2.selection();
  }
  if (onexit == null) exit.remove();
  else onexit(exit);
  return enter && update2 ? enter.merge(update2).order() : update2;
}
function selection_merge(context) {
  var selection2 = context.selection ? context.selection() : context;
  for (var groups0 = this._groups, groups1 = selection2._groups, m0 = groups0.length, m1 = groups1.length, m2 = Math.min(m0, m1), merges = new Array(m0), j2 = 0; j2 < m2; ++j2) {
    for (var group0 = groups0[j2], group1 = groups1[j2], n = group0.length, merge = merges[j2] = new Array(n), node, i = 0; i < n; ++i) {
      if (node = group0[i] || group1[i]) {
        merge[i] = node;
      }
    }
  }
  for (; j2 < m0; ++j2) {
    merges[j2] = groups0[j2];
  }
  return new Selection$2(merges, this._parents);
}
function selection_order() {
  for (var groups = this._groups, j2 = -1, m2 = groups.length; ++j2 < m2; ) {
    for (var group = groups[j2], i = group.length - 1, next = group[i], node; --i >= 0; ) {
      if (node = group[i]) {
        if (next && node.compareDocumentPosition(next) ^ 4) next.parentNode.insertBefore(node, next);
        next = node;
      }
    }
  }
  return this;
}
function selection_sort(compare) {
  if (!compare) compare = ascending;
  function compareNode(a, b2) {
    return a && b2 ? compare(a.__data__, b2.__data__) : !a - !b2;
  }
  for (var groups = this._groups, m2 = groups.length, sortgroups = new Array(m2), j2 = 0; j2 < m2; ++j2) {
    for (var group = groups[j2], n = group.length, sortgroup = sortgroups[j2] = new Array(n), node, i = 0; i < n; ++i) {
      if (node = group[i]) {
        sortgroup[i] = node;
      }
    }
    sortgroup.sort(compareNode);
  }
  return new Selection$2(sortgroups, this._parents).order();
}
function ascending(a, b2) {
  return a < b2 ? -1 : a > b2 ? 1 : a >= b2 ? 0 : NaN;
}
function selection_call() {
  var callback = arguments[0];
  arguments[0] = this;
  callback.apply(null, arguments);
  return this;
}
function selection_nodes() {
  return Array.from(this);
}
function selection_node() {
  for (var groups = this._groups, j2 = 0, m2 = groups.length; j2 < m2; ++j2) {
    for (var group = groups[j2], i = 0, n = group.length; i < n; ++i) {
      var node = group[i];
      if (node) return node;
    }
  }
  return null;
}
function selection_size() {
  let size = 0;
  for (const node of this) ++size;
  return size;
}
function selection_empty() {
  return !this.node();
}
function selection_each(callback) {
  for (var groups = this._groups, j2 = 0, m2 = groups.length; j2 < m2; ++j2) {
    for (var group = groups[j2], i = 0, n = group.length, node; i < n; ++i) {
      if (node = group[i]) callback.call(node, node.__data__, i, group);
    }
  }
  return this;
}
function attrRemove$1(name) {
  return function() {
    this.removeAttribute(name);
  };
}
function attrRemoveNS$1(fullname) {
  return function() {
    this.removeAttributeNS(fullname.space, fullname.local);
  };
}
function attrConstant$1(name, value) {
  return function() {
    this.setAttribute(name, value);
  };
}
function attrConstantNS$1(fullname, value) {
  return function() {
    this.setAttributeNS(fullname.space, fullname.local, value);
  };
}
function attrFunction$1(name, value) {
  return function() {
    var v2 = value.apply(this, arguments);
    if (v2 == null) this.removeAttribute(name);
    else this.setAttribute(name, v2);
  };
}
function attrFunctionNS$1(fullname, value) {
  return function() {
    var v2 = value.apply(this, arguments);
    if (v2 == null) this.removeAttributeNS(fullname.space, fullname.local);
    else this.setAttributeNS(fullname.space, fullname.local, v2);
  };
}
function selection_attr(name, value) {
  var fullname = namespace(name);
  if (arguments.length < 2) {
    var node = this.node();
    return fullname.local ? node.getAttributeNS(fullname.space, fullname.local) : node.getAttribute(fullname);
  }
  return this.each((value == null ? fullname.local ? attrRemoveNS$1 : attrRemove$1 : typeof value === "function" ? fullname.local ? attrFunctionNS$1 : attrFunction$1 : fullname.local ? attrConstantNS$1 : attrConstant$1)(fullname, value));
}
function defaultView(node) {
  return node.ownerDocument && node.ownerDocument.defaultView || node.document && node || node.defaultView;
}
function styleRemove$1(name) {
  return function() {
    this.style.removeProperty(name);
  };
}
function styleConstant$1(name, value, priority) {
  return function() {
    this.style.setProperty(name, value, priority);
  };
}
function styleFunction$1(name, value, priority) {
  return function() {
    var v2 = value.apply(this, arguments);
    if (v2 == null) this.style.removeProperty(name);
    else this.style.setProperty(name, v2, priority);
  };
}
function selection_style(name, value, priority) {
  return arguments.length > 1 ? this.each((value == null ? styleRemove$1 : typeof value === "function" ? styleFunction$1 : styleConstant$1)(name, value, priority == null ? "" : priority)) : styleValue(this.node(), name);
}
function styleValue(node, name) {
  return node.style.getPropertyValue(name) || defaultView(node).getComputedStyle(node, null).getPropertyValue(name);
}
function propertyRemove(name) {
  return function() {
    delete this[name];
  };
}
function propertyConstant(name, value) {
  return function() {
    this[name] = value;
  };
}
function propertyFunction(name, value) {
  return function() {
    var v2 = value.apply(this, arguments);
    if (v2 == null) delete this[name];
    else this[name] = v2;
  };
}
function selection_property(name, value) {
  return arguments.length > 1 ? this.each((value == null ? propertyRemove : typeof value === "function" ? propertyFunction : propertyConstant)(name, value)) : this.node()[name];
}
function classArray(string) {
  return string.trim().split(/^|\s+/);
}
function classList(node) {
  return node.classList || new ClassList(node);
}
function ClassList(node) {
  this._node = node;
  this._names = classArray(node.getAttribute("class") || "");
}
ClassList.prototype = {
  add: function(name) {
    var i = this._names.indexOf(name);
    if (i < 0) {
      this._names.push(name);
      this._node.setAttribute("class", this._names.join(" "));
    }
  },
  remove: function(name) {
    var i = this._names.indexOf(name);
    if (i >= 0) {
      this._names.splice(i, 1);
      this._node.setAttribute("class", this._names.join(" "));
    }
  },
  contains: function(name) {
    return this._names.indexOf(name) >= 0;
  }
};
function classedAdd(node, names) {
  var list = classList(node), i = -1, n = names.length;
  while (++i < n) list.add(names[i]);
}
function classedRemove(node, names) {
  var list = classList(node), i = -1, n = names.length;
  while (++i < n) list.remove(names[i]);
}
function classedTrue(names) {
  return function() {
    classedAdd(this, names);
  };
}
function classedFalse(names) {
  return function() {
    classedRemove(this, names);
  };
}
function classedFunction(names, value) {
  return function() {
    (value.apply(this, arguments) ? classedAdd : classedRemove)(this, names);
  };
}
function selection_classed(name, value) {
  var names = classArray(name + "");
  if (arguments.length < 2) {
    var list = classList(this.node()), i = -1, n = names.length;
    while (++i < n) if (!list.contains(names[i])) return false;
    return true;
  }
  return this.each((typeof value === "function" ? classedFunction : value ? classedTrue : classedFalse)(names, value));
}
function textRemove() {
  this.textContent = "";
}
function textConstant$1(value) {
  return function() {
    this.textContent = value;
  };
}
function textFunction$1(value) {
  return function() {
    var v2 = value.apply(this, arguments);
    this.textContent = v2 == null ? "" : v2;
  };
}
function selection_text(value) {
  return arguments.length ? this.each(value == null ? textRemove : (typeof value === "function" ? textFunction$1 : textConstant$1)(value)) : this.node().textContent;
}
function htmlRemove() {
  this.innerHTML = "";
}
function htmlConstant(value) {
  return function() {
    this.innerHTML = value;
  };
}
function htmlFunction(value) {
  return function() {
    var v2 = value.apply(this, arguments);
    this.innerHTML = v2 == null ? "" : v2;
  };
}
function selection_html(value) {
  return arguments.length ? this.each(value == null ? htmlRemove : (typeof value === "function" ? htmlFunction : htmlConstant)(value)) : this.node().innerHTML;
}
function raise() {
  if (this.nextSibling) this.parentNode.appendChild(this);
}
function selection_raise() {
  return this.each(raise);
}
function lower() {
  if (this.previousSibling) this.parentNode.insertBefore(this, this.parentNode.firstChild);
}
function selection_lower() {
  return this.each(lower);
}
function selection_append(name) {
  var create2 = typeof name === "function" ? name : creator(name);
  return this.select(function() {
    return this.appendChild(create2.apply(this, arguments));
  });
}
function constantNull() {
  return null;
}
function selection_insert(name, before) {
  var create2 = typeof name === "function" ? name : creator(name), select2 = before == null ? constantNull : typeof before === "function" ? before : selector(before);
  return this.select(function() {
    return this.insertBefore(create2.apply(this, arguments), select2.apply(this, arguments) || null);
  });
}
function remove() {
  var parent = this.parentNode;
  if (parent) parent.removeChild(this);
}
function selection_remove() {
  return this.each(remove);
}
function selection_cloneShallow() {
  var clone2 = this.cloneNode(false), parent = this.parentNode;
  return parent ? parent.insertBefore(clone2, this.nextSibling) : clone2;
}
function selection_cloneDeep() {
  var clone2 = this.cloneNode(true), parent = this.parentNode;
  return parent ? parent.insertBefore(clone2, this.nextSibling) : clone2;
}
function selection_clone(deep) {
  return this.select(deep ? selection_cloneDeep : selection_cloneShallow);
}
function selection_datum(value) {
  return arguments.length ? this.property("__data__", value) : this.node().__data__;
}
function contextListener(listener) {
  return function(event2) {
    listener.call(this, event2, this.__data__);
  };
}
function parseTypenames(typenames) {
  return typenames.trim().split(/^|\s+/).map(function(t) {
    var name = "", i = t.indexOf(".");
    if (i >= 0) name = t.slice(i + 1), t = t.slice(0, i);
    return { type: t, name };
  });
}
function onRemove(typename) {
  return function() {
    var on2 = this.__on;
    if (!on2) return;
    for (var j2 = 0, i = -1, m2 = on2.length, o; j2 < m2; ++j2) {
      if (o = on2[j2], (!typename.type || o.type === typename.type) && o.name === typename.name) {
        this.removeEventListener(o.type, o.listener, o.options);
      } else {
        on2[++i] = o;
      }
    }
    if (++i) on2.length = i;
    else delete this.__on;
  };
}
function onAdd(typename, value, options) {
  return function() {
    var on2 = this.__on, o, listener = contextListener(value);
    if (on2) for (var j2 = 0, m2 = on2.length; j2 < m2; ++j2) {
      if ((o = on2[j2]).type === typename.type && o.name === typename.name) {
        this.removeEventListener(o.type, o.listener, o.options);
        this.addEventListener(o.type, o.listener = listener, o.options = options);
        o.value = value;
        return;
      }
    }
    this.addEventListener(typename.type, listener, options);
    o = { type: typename.type, name: typename.name, value, listener, options };
    if (!on2) this.__on = [o];
    else on2.push(o);
  };
}
function selection_on(typename, value, options) {
  var typenames = parseTypenames(typename + ""), i, n = typenames.length, t;
  if (arguments.length < 2) {
    var on2 = this.node().__on;
    if (on2) for (var j2 = 0, m2 = on2.length, o; j2 < m2; ++j2) {
      for (i = 0, o = on2[j2]; i < n; ++i) {
        if ((t = typenames[i]).type === o.type && t.name === o.name) {
          return o.value;
        }
      }
    }
    return;
  }
  on2 = value ? onAdd : onRemove;
  for (i = 0; i < n; ++i) this.each(on2(typenames[i], value, options));
  return this;
}
function dispatchEvent(node, type, params) {
  var window2 = defaultView(node), event2 = window2.CustomEvent;
  if (typeof event2 === "function") {
    event2 = new event2(type, params);
  } else {
    event2 = window2.document.createEvent("Event");
    if (params) event2.initEvent(type, params.bubbles, params.cancelable), event2.detail = params.detail;
    else event2.initEvent(type, false, false);
  }
  node.dispatchEvent(event2);
}
function dispatchConstant(type, params) {
  return function() {
    return dispatchEvent(this, type, params);
  };
}
function dispatchFunction(type, params) {
  return function() {
    return dispatchEvent(this, type, params.apply(this, arguments));
  };
}
function selection_dispatch(type, params) {
  return this.each((typeof params === "function" ? dispatchFunction : dispatchConstant)(type, params));
}
function* selection_iterator() {
  for (var groups = this._groups, j2 = 0, m2 = groups.length; j2 < m2; ++j2) {
    for (var group = groups[j2], i = 0, n = group.length, node; i < n; ++i) {
      if (node = group[i]) yield node;
    }
  }
}
var root$D = [null];
function Selection$2(groups, parents) {
  this._groups = groups;
  this._parents = parents;
}
function selection() {
  return new Selection$2([[document.documentElement]], root$D);
}
function selection_selection() {
  return this;
}
Selection$2.prototype = selection.prototype = {
  constructor: Selection$2,
  select: selection_select,
  selectAll: selection_selectAll,
  selectChild: selection_selectChild,
  selectChildren: selection_selectChildren,
  filter: selection_filter,
  data: selection_data,
  enter: selection_enter,
  exit: selection_exit,
  join: selection_join,
  merge: selection_merge,
  selection: selection_selection,
  order: selection_order,
  sort: selection_sort,
  call: selection_call,
  nodes: selection_nodes,
  node: selection_node,
  size: selection_size,
  empty: selection_empty,
  each: selection_each,
  attr: selection_attr,
  style: selection_style,
  property: selection_property,
  classed: selection_classed,
  text: selection_text,
  html: selection_html,
  raise: selection_raise,
  lower: selection_lower,
  append: selection_append,
  insert: selection_insert,
  remove: selection_remove,
  clone: selection_clone,
  datum: selection_datum,
  on: selection_on,
  dispatch: selection_dispatch,
  [Symbol.iterator]: selection_iterator
};
function select(selector2) {
  return typeof selector2 === "string" ? new Selection$2([[document.querySelector(selector2)]], [document.documentElement]) : new Selection$2([[selector2]], root$D);
}
function sourceEvent(event2) {
  let sourceEvent2;
  while (sourceEvent2 = event2.sourceEvent) event2 = sourceEvent2;
  return event2;
}
function pointer(event2, node) {
  event2 = sourceEvent(event2);
  if (node === void 0) node = event2.currentTarget;
  if (node) {
    var svg = node.ownerSVGElement || node;
    if (svg.createSVGPoint) {
      var point = svg.createSVGPoint();
      point.x = event2.clientX, point.y = event2.clientY;
      point = point.matrixTransform(node.getScreenCTM().inverse());
      return [point.x, point.y];
    }
    if (node.getBoundingClientRect) {
      var rect = node.getBoundingClientRect();
      return [event2.clientX - rect.left - node.clientLeft, event2.clientY - rect.top - node.clientTop];
    }
  }
  return [event2.pageX, event2.pageY];
}
const nonpassive = { passive: false };
const nonpassivecapture = { capture: true, passive: false };
function nopropagation$1(event2) {
  event2.stopImmediatePropagation();
}
function noevent$1(event2) {
  event2.preventDefault();
  event2.stopImmediatePropagation();
}
function dragDisable(view) {
  var root2 = view.document.documentElement, selection2 = select(view).on("dragstart.drag", noevent$1, nonpassivecapture);
  if ("onselectstart" in root2) {
    selection2.on("selectstart.drag", noevent$1, nonpassivecapture);
  } else {
    root2.__noselect = root2.style.MozUserSelect;
    root2.style.MozUserSelect = "none";
  }
}
function yesdrag(view, noclick) {
  var root2 = view.document.documentElement, selection2 = select(view).on("dragstart.drag", null);
  if (noclick) {
    selection2.on("click.drag", noevent$1, nonpassivecapture);
    setTimeout(function() {
      selection2.on("click.drag", null);
    }, 0);
  }
  if ("onselectstart" in root2) {
    selection2.on("selectstart.drag", null);
  } else {
    root2.style.MozUserSelect = root2.__noselect;
    delete root2.__noselect;
  }
}
const constant$2 = (x) => () => x;
function DragEvent(type, {
  sourceEvent: sourceEvent2,
  subject,
  target,
  identifier,
  active,
  x,
  y: y2,
  dx,
  dy,
  dispatch: dispatch2
}) {
  Object.defineProperties(this, {
    type: { value: type, enumerable: true, configurable: true },
    sourceEvent: { value: sourceEvent2, enumerable: true, configurable: true },
    subject: { value: subject, enumerable: true, configurable: true },
    target: { value: target, enumerable: true, configurable: true },
    identifier: { value: identifier, enumerable: true, configurable: true },
    active: { value: active, enumerable: true, configurable: true },
    x: { value: x, enumerable: true, configurable: true },
    y: { value: y2, enumerable: true, configurable: true },
    dx: { value: dx, enumerable: true, configurable: true },
    dy: { value: dy, enumerable: true, configurable: true },
    _: { value: dispatch2 }
  });
}
DragEvent.prototype.on = function() {
  var value = this._.on.apply(this._, arguments);
  return value === this._ ? this : value;
};
function defaultFilter$1(event2) {
  return !event2.ctrlKey && !event2.button;
}
function defaultContainer() {
  return this.parentNode;
}
function defaultSubject(event2, d2) {
  return d2 == null ? { x: event2.x, y: event2.y } : d2;
}
function defaultTouchable$1() {
  return navigator.maxTouchPoints || "ontouchstart" in this;
}
function drag$1() {
  var filter2 = defaultFilter$1, container = defaultContainer, subject = defaultSubject, touchable = defaultTouchable$1, gestures = {}, listeners = dispatch("start", "drag", "end"), active = 0, mousedownx, mousedowny, mousemoving, touchending, clickDistance2 = 0;
  function drag2(selection2) {
    selection2.on("mousedown.drag", mousedowned).filter(touchable).on("touchstart.drag", touchstarted).on("touchmove.drag", touchmoved, nonpassive).on("touchend.drag touchcancel.drag", touchended).style("touch-action", "none").style("-webkit-tap-highlight-color", "rgba(0,0,0,0)");
  }
  function mousedowned(event2, d2) {
    if (touchending || !filter2.call(this, event2, d2)) return;
    var gesture = beforestart(this, container.call(this, event2, d2), event2, d2, "mouse");
    if (!gesture) return;
    select(event2.view).on("mousemove.drag", mousemoved, nonpassivecapture).on("mouseup.drag", mouseupped, nonpassivecapture);
    dragDisable(event2.view);
    nopropagation$1(event2);
    mousemoving = false;
    mousedownx = event2.clientX;
    mousedowny = event2.clientY;
    gesture("start", event2);
  }
  function mousemoved(event2) {
    noevent$1(event2);
    if (!mousemoving) {
      var dx = event2.clientX - mousedownx, dy = event2.clientY - mousedowny;
      mousemoving = dx * dx + dy * dy > clickDistance2;
    }
    gestures.mouse("drag", event2);
  }
  function mouseupped(event2) {
    select(event2.view).on("mousemove.drag mouseup.drag", null);
    yesdrag(event2.view, mousemoving);
    noevent$1(event2);
    gestures.mouse("end", event2);
  }
  function touchstarted(event2, d2) {
    if (!filter2.call(this, event2, d2)) return;
    var touches = event2.changedTouches, c = container.call(this, event2, d2), n = touches.length, i, gesture;
    for (i = 0; i < n; ++i) {
      if (gesture = beforestart(this, c, event2, d2, touches[i].identifier, touches[i])) {
        nopropagation$1(event2);
        gesture("start", event2, touches[i]);
      }
    }
  }
  function touchmoved(event2) {
    var touches = event2.changedTouches, n = touches.length, i, gesture;
    for (i = 0; i < n; ++i) {
      if (gesture = gestures[touches[i].identifier]) {
        noevent$1(event2);
        gesture("drag", event2, touches[i]);
      }
    }
  }
  function touchended(event2) {
    var touches = event2.changedTouches, n = touches.length, i, gesture;
    if (touchending) clearTimeout(touchending);
    touchending = setTimeout(function() {
      touchending = null;
    }, 500);
    for (i = 0; i < n; ++i) {
      if (gesture = gestures[touches[i].identifier]) {
        nopropagation$1(event2);
        gesture("end", event2, touches[i]);
      }
    }
  }
  function beforestart(that, container2, event2, d2, identifier, touch) {
    var dispatch2 = listeners.copy(), p = pointer(touch || event2, container2), dx, dy, s;
    if ((s = subject.call(that, new DragEvent("beforestart", {
      sourceEvent: event2,
      target: drag2,
      identifier,
      active,
      x: p[0],
      y: p[1],
      dx: 0,
      dy: 0,
      dispatch: dispatch2
    }), d2)) == null) return;
    dx = s.x - p[0] || 0;
    dy = s.y - p[1] || 0;
    return function gesture(type, event3, touch2) {
      var p0 = p, n;
      switch (type) {
        case "start":
          gestures[identifier] = gesture, n = active++;
          break;
        case "end":
          delete gestures[identifier], --active;
        // falls through
        case "drag":
          p = pointer(touch2 || event3, container2), n = active;
          break;
      }
      dispatch2.call(
        type,
        that,
        new DragEvent(type, {
          sourceEvent: event3,
          subject: s,
          target: drag2,
          identifier,
          active: n,
          x: p[0] + dx,
          y: p[1] + dy,
          dx: p[0] - p0[0],
          dy: p[1] - p0[1],
          dispatch: dispatch2
        }),
        d2
      );
    };
  }
  drag2.filter = function(_2) {
    return arguments.length ? (filter2 = typeof _2 === "function" ? _2 : constant$2(!!_2), drag2) : filter2;
  };
  drag2.container = function(_2) {
    return arguments.length ? (container = typeof _2 === "function" ? _2 : constant$2(_2), drag2) : container;
  };
  drag2.subject = function(_2) {
    return arguments.length ? (subject = typeof _2 === "function" ? _2 : constant$2(_2), drag2) : subject;
  };
  drag2.touchable = function(_2) {
    return arguments.length ? (touchable = typeof _2 === "function" ? _2 : constant$2(!!_2), drag2) : touchable;
  };
  drag2.on = function() {
    var value = listeners.on.apply(listeners, arguments);
    return value === listeners ? drag2 : value;
  };
  drag2.clickDistance = function(_2) {
    return arguments.length ? (clickDistance2 = (_2 = +_2) * _2, drag2) : Math.sqrt(clickDistance2);
  };
  return drag2;
}
function define(constructor, factory, prototype) {
  constructor.prototype = factory.prototype = prototype;
  prototype.constructor = constructor;
}
function extend(parent, definition) {
  var prototype = Object.create(parent.prototype);
  for (var key2 in definition) prototype[key2] = definition[key2];
  return prototype;
}
function Color() {
}
var darker = 0.7;
var brighter = 1 / darker;
var reI = "\\s*([+-]?\\d+)\\s*", reN = "\\s*([+-]?(?:\\d*\\.)?\\d+(?:[eE][+-]?\\d+)?)\\s*", reP = "\\s*([+-]?(?:\\d*\\.)?\\d+(?:[eE][+-]?\\d+)?)%\\s*", reHex = /^#([0-9a-f]{3,8})$/, reRgbInteger = new RegExp(`^rgb\\(${reI},${reI},${reI}\\)$`), reRgbPercent = new RegExp(`^rgb\\(${reP},${reP},${reP}\\)$`), reRgbaInteger = new RegExp(`^rgba\\(${reI},${reI},${reI},${reN}\\)$`), reRgbaPercent = new RegExp(`^rgba\\(${reP},${reP},${reP},${reN}\\)$`), reHslPercent = new RegExp(`^hsl\\(${reN},${reP},${reP}\\)$`), reHslaPercent = new RegExp(`^hsla\\(${reN},${reP},${reP},${reN}\\)$`);
var named = {
  aliceblue: 15792383,
  antiquewhite: 16444375,
  aqua: 65535,
  aquamarine: 8388564,
  azure: 15794175,
  beige: 16119260,
  bisque: 16770244,
  black: 0,
  blanchedalmond: 16772045,
  blue: 255,
  blueviolet: 9055202,
  brown: 10824234,
  burlywood: 14596231,
  cadetblue: 6266528,
  chartreuse: 8388352,
  chocolate: 13789470,
  coral: 16744272,
  cornflowerblue: 6591981,
  cornsilk: 16775388,
  crimson: 14423100,
  cyan: 65535,
  darkblue: 139,
  darkcyan: 35723,
  darkgoldenrod: 12092939,
  darkgray: 11119017,
  darkgreen: 25600,
  darkgrey: 11119017,
  darkkhaki: 12433259,
  darkmagenta: 9109643,
  darkolivegreen: 5597999,
  darkorange: 16747520,
  darkorchid: 10040012,
  darkred: 9109504,
  darksalmon: 15308410,
  darkseagreen: 9419919,
  darkslateblue: 4734347,
  darkslategray: 3100495,
  darkslategrey: 3100495,
  darkturquoise: 52945,
  darkviolet: 9699539,
  deeppink: 16716947,
  deepskyblue: 49151,
  dimgray: 6908265,
  dimgrey: 6908265,
  dodgerblue: 2003199,
  firebrick: 11674146,
  floralwhite: 16775920,
  forestgreen: 2263842,
  fuchsia: 16711935,
  gainsboro: 14474460,
  ghostwhite: 16316671,
  gold: 16766720,
  goldenrod: 14329120,
  gray: 8421504,
  green: 32768,
  greenyellow: 11403055,
  grey: 8421504,
  honeydew: 15794160,
  hotpink: 16738740,
  indianred: 13458524,
  indigo: 4915330,
  ivory: 16777200,
  khaki: 15787660,
  lavender: 15132410,
  lavenderblush: 16773365,
  lawngreen: 8190976,
  lemonchiffon: 16775885,
  lightblue: 11393254,
  lightcoral: 15761536,
  lightcyan: 14745599,
  lightgoldenrodyellow: 16448210,
  lightgray: 13882323,
  lightgreen: 9498256,
  lightgrey: 13882323,
  lightpink: 16758465,
  lightsalmon: 16752762,
  lightseagreen: 2142890,
  lightskyblue: 8900346,
  lightslategray: 7833753,
  lightslategrey: 7833753,
  lightsteelblue: 11584734,
  lightyellow: 16777184,
  lime: 65280,
  limegreen: 3329330,
  linen: 16445670,
  magenta: 16711935,
  maroon: 8388608,
  mediumaquamarine: 6737322,
  mediumblue: 205,
  mediumorchid: 12211667,
  mediumpurple: 9662683,
  mediumseagreen: 3978097,
  mediumslateblue: 8087790,
  mediumspringgreen: 64154,
  mediumturquoise: 4772300,
  mediumvioletred: 13047173,
  midnightblue: 1644912,
  mintcream: 16121850,
  mistyrose: 16770273,
  moccasin: 16770229,
  navajowhite: 16768685,
  navy: 128,
  oldlace: 16643558,
  olive: 8421376,
  olivedrab: 7048739,
  orange: 16753920,
  orangered: 16729344,
  orchid: 14315734,
  palegoldenrod: 15657130,
  palegreen: 10025880,
  paleturquoise: 11529966,
  palevioletred: 14381203,
  papayawhip: 16773077,
  peachpuff: 16767673,
  peru: 13468991,
  pink: 16761035,
  plum: 14524637,
  powderblue: 11591910,
  purple: 8388736,
  rebeccapurple: 6697881,
  red: 16711680,
  rosybrown: 12357519,
  royalblue: 4286945,
  saddlebrown: 9127187,
  salmon: 16416882,
  sandybrown: 16032864,
  seagreen: 3050327,
  seashell: 16774638,
  sienna: 10506797,
  silver: 12632256,
  skyblue: 8900331,
  slateblue: 6970061,
  slategray: 7372944,
  slategrey: 7372944,
  snow: 16775930,
  springgreen: 65407,
  steelblue: 4620980,
  tan: 13808780,
  teal: 32896,
  thistle: 14204888,
  tomato: 16737095,
  turquoise: 4251856,
  violet: 15631086,
  wheat: 16113331,
  white: 16777215,
  whitesmoke: 16119285,
  yellow: 16776960,
  yellowgreen: 10145074
};
define(Color, color, {
  copy(channels) {
    return Object.assign(new this.constructor(), this, channels);
  },
  displayable() {
    return this.rgb().displayable();
  },
  hex: color_formatHex,
  // Deprecated! Use color.formatHex.
  formatHex: color_formatHex,
  formatHex8: color_formatHex8,
  formatHsl: color_formatHsl,
  formatRgb: color_formatRgb,
  toString: color_formatRgb
});
function color_formatHex() {
  return this.rgb().formatHex();
}
function color_formatHex8() {
  return this.rgb().formatHex8();
}
function color_formatHsl() {
  return hslConvert(this).formatHsl();
}
function color_formatRgb() {
  return this.rgb().formatRgb();
}
function color(format) {
  var m2, l3;
  format = (format + "").trim().toLowerCase();
  return (m2 = reHex.exec(format)) ? (l3 = m2[1].length, m2 = parseInt(m2[1], 16), l3 === 6 ? rgbn(m2) : l3 === 3 ? new Rgb(m2 >> 8 & 15 | m2 >> 4 & 240, m2 >> 4 & 15 | m2 & 240, (m2 & 15) << 4 | m2 & 15, 1) : l3 === 8 ? rgba(m2 >> 24 & 255, m2 >> 16 & 255, m2 >> 8 & 255, (m2 & 255) / 255) : l3 === 4 ? rgba(m2 >> 12 & 15 | m2 >> 8 & 240, m2 >> 8 & 15 | m2 >> 4 & 240, m2 >> 4 & 15 | m2 & 240, ((m2 & 15) << 4 | m2 & 15) / 255) : null) : (m2 = reRgbInteger.exec(format)) ? new Rgb(m2[1], m2[2], m2[3], 1) : (m2 = reRgbPercent.exec(format)) ? new Rgb(m2[1] * 255 / 100, m2[2] * 255 / 100, m2[3] * 255 / 100, 1) : (m2 = reRgbaInteger.exec(format)) ? rgba(m2[1], m2[2], m2[3], m2[4]) : (m2 = reRgbaPercent.exec(format)) ? rgba(m2[1] * 255 / 100, m2[2] * 255 / 100, m2[3] * 255 / 100, m2[4]) : (m2 = reHslPercent.exec(format)) ? hsla(m2[1], m2[2] / 100, m2[3] / 100, 1) : (m2 = reHslaPercent.exec(format)) ? hsla(m2[1], m2[2] / 100, m2[3] / 100, m2[4]) : named.hasOwnProperty(format) ? rgbn(named[format]) : format === "transparent" ? new Rgb(NaN, NaN, NaN, 0) : null;
}
function rgbn(n) {
  return new Rgb(n >> 16 & 255, n >> 8 & 255, n & 255, 1);
}
function rgba(r2, g, b2, a) {
  if (a <= 0) r2 = g = b2 = NaN;
  return new Rgb(r2, g, b2, a);
}
function rgbConvert(o) {
  if (!(o instanceof Color)) o = color(o);
  if (!o) return new Rgb();
  o = o.rgb();
  return new Rgb(o.r, o.g, o.b, o.opacity);
}
function rgb(r2, g, b2, opacity) {
  return arguments.length === 1 ? rgbConvert(r2) : new Rgb(r2, g, b2, opacity == null ? 1 : opacity);
}
function Rgb(r2, g, b2, opacity) {
  this.r = +r2;
  this.g = +g;
  this.b = +b2;
  this.opacity = +opacity;
}
define(Rgb, rgb, extend(Color, {
  brighter(k) {
    k = k == null ? brighter : Math.pow(brighter, k);
    return new Rgb(this.r * k, this.g * k, this.b * k, this.opacity);
  },
  darker(k) {
    k = k == null ? darker : Math.pow(darker, k);
    return new Rgb(this.r * k, this.g * k, this.b * k, this.opacity);
  },
  rgb() {
    return this;
  },
  clamp() {
    return new Rgb(clampi(this.r), clampi(this.g), clampi(this.b), clampa(this.opacity));
  },
  displayable() {
    return -0.5 <= this.r && this.r < 255.5 && (-0.5 <= this.g && this.g < 255.5) && (-0.5 <= this.b && this.b < 255.5) && (0 <= this.opacity && this.opacity <= 1);
  },
  hex: rgb_formatHex,
  // Deprecated! Use color.formatHex.
  formatHex: rgb_formatHex,
  formatHex8: rgb_formatHex8,
  formatRgb: rgb_formatRgb,
  toString: rgb_formatRgb
}));
function rgb_formatHex() {
  return `#${hex(this.r)}${hex(this.g)}${hex(this.b)}`;
}
function rgb_formatHex8() {
  return `#${hex(this.r)}${hex(this.g)}${hex(this.b)}${hex((isNaN(this.opacity) ? 1 : this.opacity) * 255)}`;
}
function rgb_formatRgb() {
  const a = clampa(this.opacity);
  return `${a === 1 ? "rgb(" : "rgba("}${clampi(this.r)}, ${clampi(this.g)}, ${clampi(this.b)}${a === 1 ? ")" : `, ${a})`}`;
}
function clampa(opacity) {
  return isNaN(opacity) ? 1 : Math.max(0, Math.min(1, opacity));
}
function clampi(value) {
  return Math.max(0, Math.min(255, Math.round(value) || 0));
}
function hex(value) {
  value = clampi(value);
  return (value < 16 ? "0" : "") + value.toString(16);
}
function hsla(h2, s, l3, a) {
  if (a <= 0) h2 = s = l3 = NaN;
  else if (l3 <= 0 || l3 >= 1) h2 = s = NaN;
  else if (s <= 0) h2 = NaN;
  return new Hsl(h2, s, l3, a);
}
function hslConvert(o) {
  if (o instanceof Hsl) return new Hsl(o.h, o.s, o.l, o.opacity);
  if (!(o instanceof Color)) o = color(o);
  if (!o) return new Hsl();
  if (o instanceof Hsl) return o;
  o = o.rgb();
  var r2 = o.r / 255, g = o.g / 255, b2 = o.b / 255, min = Math.min(r2, g, b2), max = Math.max(r2, g, b2), h2 = NaN, s = max - min, l3 = (max + min) / 2;
  if (s) {
    if (r2 === max) h2 = (g - b2) / s + (g < b2) * 6;
    else if (g === max) h2 = (b2 - r2) / s + 2;
    else h2 = (r2 - g) / s + 4;
    s /= l3 < 0.5 ? max + min : 2 - max - min;
    h2 *= 60;
  } else {
    s = l3 > 0 && l3 < 1 ? 0 : h2;
  }
  return new Hsl(h2, s, l3, o.opacity);
}
function hsl(h2, s, l3, opacity) {
  return arguments.length === 1 ? hslConvert(h2) : new Hsl(h2, s, l3, opacity == null ? 1 : opacity);
}
function Hsl(h2, s, l3, opacity) {
  this.h = +h2;
  this.s = +s;
  this.l = +l3;
  this.opacity = +opacity;
}
define(Hsl, hsl, extend(Color, {
  brighter(k) {
    k = k == null ? brighter : Math.pow(brighter, k);
    return new Hsl(this.h, this.s, this.l * k, this.opacity);
  },
  darker(k) {
    k = k == null ? darker : Math.pow(darker, k);
    return new Hsl(this.h, this.s, this.l * k, this.opacity);
  },
  rgb() {
    var h2 = this.h % 360 + (this.h < 0) * 360, s = isNaN(h2) || isNaN(this.s) ? 0 : this.s, l3 = this.l, m2 = l3 + (l3 < 0.5 ? l3 : 1 - l3) * s, m1 = 2 * l3 - m2;
    return new Rgb(
      hsl2rgb(h2 >= 240 ? h2 - 240 : h2 + 120, m1, m2),
      hsl2rgb(h2, m1, m2),
      hsl2rgb(h2 < 120 ? h2 + 240 : h2 - 120, m1, m2),
      this.opacity
    );
  },
  clamp() {
    return new Hsl(clamph(this.h), clampt(this.s), clampt(this.l), clampa(this.opacity));
  },
  displayable() {
    return (0 <= this.s && this.s <= 1 || isNaN(this.s)) && (0 <= this.l && this.l <= 1) && (0 <= this.opacity && this.opacity <= 1);
  },
  formatHsl() {
    const a = clampa(this.opacity);
    return `${a === 1 ? "hsl(" : "hsla("}${clamph(this.h)}, ${clampt(this.s) * 100}%, ${clampt(this.l) * 100}%${a === 1 ? ")" : `, ${a})`}`;
  }
}));
function clamph(value) {
  value = (value || 0) % 360;
  return value < 0 ? value + 360 : value;
}
function clampt(value) {
  return Math.max(0, Math.min(1, value || 0));
}
function hsl2rgb(h2, m1, m2) {
  return (h2 < 60 ? m1 + (m2 - m1) * h2 / 60 : h2 < 180 ? m2 : h2 < 240 ? m1 + (m2 - m1) * (240 - h2) / 60 : m1) * 255;
}
const constant$1 = (x) => () => x;
function linear(a, d2) {
  return function(t) {
    return a + t * d2;
  };
}
function exponential(a, b2, y2) {
  return a = Math.pow(a, y2), b2 = Math.pow(b2, y2) - a, y2 = 1 / y2, function(t) {
    return Math.pow(a + t * b2, y2);
  };
}
function gamma(y2) {
  return (y2 = +y2) === 1 ? nogamma : function(a, b2) {
    return b2 - a ? exponential(a, b2, y2) : constant$1(isNaN(a) ? b2 : a);
  };
}
function nogamma(a, b2) {
  var d2 = b2 - a;
  return d2 ? linear(a, d2) : constant$1(isNaN(a) ? b2 : a);
}
const interpolateRgb = function rgbGamma(y2) {
  var color2 = gamma(y2);
  function rgb$1(start2, end) {
    var r2 = color2((start2 = rgb(start2)).r, (end = rgb(end)).r), g = color2(start2.g, end.g), b2 = color2(start2.b, end.b), opacity = nogamma(start2.opacity, end.opacity);
    return function(t) {
      start2.r = r2(t);
      start2.g = g(t);
      start2.b = b2(t);
      start2.opacity = opacity(t);
      return start2 + "";
    };
  }
  rgb$1.gamma = rgbGamma;
  return rgb$1;
}(1);
function numberArray(a, b2) {
  if (!b2) b2 = [];
  var n = a ? Math.min(b2.length, a.length) : 0, c = b2.slice(), i;
  return function(t) {
    for (i = 0; i < n; ++i) c[i] = a[i] * (1 - t) + b2[i] * t;
    return c;
  };
}
function isNumberArray(x) {
  return ArrayBuffer.isView(x) && !(x instanceof DataView);
}
function genericArray(a, b2) {
  var nb = b2 ? b2.length : 0, na = a ? Math.min(nb, a.length) : 0, x = new Array(na), c = new Array(nb), i;
  for (i = 0; i < na; ++i) x[i] = interpolate$1(a[i], b2[i]);
  for (; i < nb; ++i) c[i] = b2[i];
  return function(t) {
    for (i = 0; i < na; ++i) c[i] = x[i](t);
    return c;
  };
}
function date(a, b2) {
  var d2 = /* @__PURE__ */ new Date();
  return a = +a, b2 = +b2, function(t) {
    return d2.setTime(a * (1 - t) + b2 * t), d2;
  };
}
function interpolateNumber(a, b2) {
  return a = +a, b2 = +b2, function(t) {
    return a * (1 - t) + b2 * t;
  };
}
function object(a, b2) {
  var i = {}, c = {}, k;
  if (a === null || typeof a !== "object") a = {};
  if (b2 === null || typeof b2 !== "object") b2 = {};
  for (k in b2) {
    if (k in a) {
      i[k] = interpolate$1(a[k], b2[k]);
    } else {
      c[k] = b2[k];
    }
  }
  return function(t) {
    for (k in i) c[k] = i[k](t);
    return c;
  };
}
var reA = /[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g, reB = new RegExp(reA.source, "g");
function zero(b2) {
  return function() {
    return b2;
  };
}
function one(b2) {
  return function(t) {
    return b2(t) + "";
  };
}
function interpolateString(a, b2) {
  var bi = reA.lastIndex = reB.lastIndex = 0, am, bm, bs, i = -1, s = [], q2 = [];
  a = a + "", b2 = b2 + "";
  while ((am = reA.exec(a)) && (bm = reB.exec(b2))) {
    if ((bs = bm.index) > bi) {
      bs = b2.slice(bi, bs);
      if (s[i]) s[i] += bs;
      else s[++i] = bs;
    }
    if ((am = am[0]) === (bm = bm[0])) {
      if (s[i]) s[i] += bm;
      else s[++i] = bm;
    } else {
      s[++i] = null;
      q2.push({ i, x: interpolateNumber(am, bm) });
    }
    bi = reB.lastIndex;
  }
  if (bi < b2.length) {
    bs = b2.slice(bi);
    if (s[i]) s[i] += bs;
    else s[++i] = bs;
  }
  return s.length < 2 ? q2[0] ? one(q2[0].x) : zero(b2) : (b2 = q2.length, function(t) {
    for (var i2 = 0, o; i2 < b2; ++i2) s[(o = q2[i2]).i] = o.x(t);
    return s.join("");
  });
}
function interpolate$1(a, b2) {
  var t = typeof b2, c;
  return b2 == null || t === "boolean" ? constant$1(b2) : (t === "number" ? interpolateNumber : t === "string" ? (c = color(b2)) ? (b2 = c, interpolateRgb) : interpolateString : b2 instanceof color ? interpolateRgb : b2 instanceof Date ? date : isNumberArray(b2) ? numberArray : Array.isArray(b2) ? genericArray : typeof b2.valueOf !== "function" && typeof b2.toString !== "function" || isNaN(b2) ? object : interpolateNumber)(a, b2);
}
var degrees = 180 / Math.PI;
var identity$1 = {
  translateX: 0,
  translateY: 0,
  rotate: 0,
  skewX: 0,
  scaleX: 1,
  scaleY: 1
};
function decompose(a, b2, c, d2, e, f) {
  var scaleX, scaleY, skewX;
  if (scaleX = Math.sqrt(a * a + b2 * b2)) a /= scaleX, b2 /= scaleX;
  if (skewX = a * c + b2 * d2) c -= a * skewX, d2 -= b2 * skewX;
  if (scaleY = Math.sqrt(c * c + d2 * d2)) c /= scaleY, d2 /= scaleY, skewX /= scaleY;
  if (a * d2 < b2 * c) a = -a, b2 = -b2, skewX = -skewX, scaleX = -scaleX;
  return {
    translateX: e,
    translateY: f,
    rotate: Math.atan2(b2, a) * degrees,
    skewX: Math.atan(skewX) * degrees,
    scaleX,
    scaleY
  };
}
var svgNode;
function parseCss(value) {
  const m2 = new (typeof DOMMatrix === "function" ? DOMMatrix : WebKitCSSMatrix)(value + "");
  return m2.isIdentity ? identity$1 : decompose(m2.a, m2.b, m2.c, m2.d, m2.e, m2.f);
}
function parseSvg(value) {
  if (value == null) return identity$1;
  if (!svgNode) svgNode = document.createElementNS("http://www.w3.org/2000/svg", "g");
  svgNode.setAttribute("transform", value);
  if (!(value = svgNode.transform.baseVal.consolidate())) return identity$1;
  value = value.matrix;
  return decompose(value.a, value.b, value.c, value.d, value.e, value.f);
}
function interpolateTransform(parse, pxComma, pxParen, degParen) {
  function pop2(s) {
    return s.length ? s.pop() + " " : "";
  }
  function translate(xa, ya, xb, yb, s, q2) {
    if (xa !== xb || ya !== yb) {
      var i = s.push("translate(", null, pxComma, null, pxParen);
      q2.push({ i: i - 4, x: interpolateNumber(xa, xb) }, { i: i - 2, x: interpolateNumber(ya, yb) });
    } else if (xb || yb) {
      s.push("translate(" + xb + pxComma + yb + pxParen);
    }
  }
  function rotate(a, b2, s, q2) {
    if (a !== b2) {
      if (a - b2 > 180) b2 += 360;
      else if (b2 - a > 180) a += 360;
      q2.push({ i: s.push(pop2(s) + "rotate(", null, degParen) - 2, x: interpolateNumber(a, b2) });
    } else if (b2) {
      s.push(pop2(s) + "rotate(" + b2 + degParen);
    }
  }
  function skewX(a, b2, s, q2) {
    if (a !== b2) {
      q2.push({ i: s.push(pop2(s) + "skewX(", null, degParen) - 2, x: interpolateNumber(a, b2) });
    } else if (b2) {
      s.push(pop2(s) + "skewX(" + b2 + degParen);
    }
  }
  function scale(xa, ya, xb, yb, s, q2) {
    if (xa !== xb || ya !== yb) {
      var i = s.push(pop2(s) + "scale(", null, ",", null, ")");
      q2.push({ i: i - 4, x: interpolateNumber(xa, xb) }, { i: i - 2, x: interpolateNumber(ya, yb) });
    } else if (xb !== 1 || yb !== 1) {
      s.push(pop2(s) + "scale(" + xb + "," + yb + ")");
    }
  }
  return function(a, b2) {
    var s = [], q2 = [];
    a = parse(a), b2 = parse(b2);
    translate(a.translateX, a.translateY, b2.translateX, b2.translateY, s, q2);
    rotate(a.rotate, b2.rotate, s, q2);
    skewX(a.skewX, b2.skewX, s, q2);
    scale(a.scaleX, a.scaleY, b2.scaleX, b2.scaleY, s, q2);
    a = b2 = null;
    return function(t) {
      var i = -1, n = q2.length, o;
      while (++i < n) s[(o = q2[i]).i] = o.x(t);
      return s.join("");
    };
  };
}
var interpolateTransformCss = interpolateTransform(parseCss, "px, ", "px)", "deg)");
var interpolateTransformSvg = interpolateTransform(parseSvg, ", ", ")", ")");
var epsilon2 = 1e-12;
function cosh(x) {
  return ((x = Math.exp(x)) + 1 / x) / 2;
}
function sinh(x) {
  return ((x = Math.exp(x)) - 1 / x) / 2;
}
function tanh(x) {
  return ((x = Math.exp(2 * x)) - 1) / (x + 1);
}
const interpolateZoom = function zoomRho(rho, rho2, rho4) {
  function zoom2(p0, p1) {
    var ux0 = p0[0], uy0 = p0[1], w0 = p0[2], ux1 = p1[0], uy1 = p1[1], w1 = p1[2], dx = ux1 - ux0, dy = uy1 - uy0, d2 = dx * dx + dy * dy, i, S2;
    if (d2 < epsilon2) {
      S2 = Math.log(w1 / w0) / rho;
      i = function(t) {
        return [
          ux0 + t * dx,
          uy0 + t * dy,
          w0 * Math.exp(rho * t * S2)
        ];
      };
    } else {
      var d1 = Math.sqrt(d2), b0 = (w1 * w1 - w0 * w0 + rho4 * d2) / (2 * w0 * rho2 * d1), b1 = (w1 * w1 - w0 * w0 - rho4 * d2) / (2 * w1 * rho2 * d1), r0 = Math.log(Math.sqrt(b0 * b0 + 1) - b0), r1 = Math.log(Math.sqrt(b1 * b1 + 1) - b1);
      S2 = (r1 - r0) / rho;
      i = function(t) {
        var s = t * S2, coshr0 = cosh(r0), u = w0 / (rho2 * d1) * (coshr0 * tanh(rho * s + r0) - sinh(r0));
        return [
          ux0 + u * dx,
          uy0 + u * dy,
          w0 * coshr0 / cosh(rho * s + r0)
        ];
      };
    }
    i.duration = S2 * 1e3 * rho / Math.SQRT2;
    return i;
  }
  zoom2.rho = function(_2) {
    var _1 = Math.max(1e-3, +_2), _22 = _1 * _1, _4 = _22 * _22;
    return zoomRho(_1, _22, _4);
  };
  return zoom2;
}(Math.SQRT2, 2, 4);
var frame = 0, timeout$1 = 0, interval = 0, pokeDelay = 1e3, taskHead, taskTail, clockLast = 0, clockNow = 0, clockSkew = 0, clock = typeof performance === "object" && performance.now ? performance : Date, setFrame = typeof window === "object" && window.requestAnimationFrame ? window.requestAnimationFrame.bind(window) : function(f) {
  setTimeout(f, 17);
};
function now() {
  return clockNow || (setFrame(clearNow), clockNow = clock.now() + clockSkew);
}
function clearNow() {
  clockNow = 0;
}
function Timer() {
  this._call = this._time = this._next = null;
}
Timer.prototype = timer.prototype = {
  constructor: Timer,
  restart: function(callback, delay, time) {
    if (typeof callback !== "function") throw new TypeError("callback is not a function");
    time = (time == null ? now() : +time) + (delay == null ? 0 : +delay);
    if (!this._next && taskTail !== this) {
      if (taskTail) taskTail._next = this;
      else taskHead = this;
      taskTail = this;
    }
    this._call = callback;
    this._time = time;
    sleep();
  },
  stop: function() {
    if (this._call) {
      this._call = null;
      this._time = Infinity;
      sleep();
    }
  }
};
function timer(callback, delay, time) {
  var t = new Timer();
  t.restart(callback, delay, time);
  return t;
}
function timerFlush() {
  now();
  ++frame;
  var t = taskHead, e;
  while (t) {
    if ((e = clockNow - t._time) >= 0) t._call.call(void 0, e);
    t = t._next;
  }
  --frame;
}
function wake() {
  clockNow = (clockLast = clock.now()) + clockSkew;
  frame = timeout$1 = 0;
  try {
    timerFlush();
  } finally {
    frame = 0;
    nap();
    clockNow = 0;
  }
}
function poke() {
  var now2 = clock.now(), delay = now2 - clockLast;
  if (delay > pokeDelay) clockSkew -= delay, clockLast = now2;
}
function nap() {
  var t0, t1 = taskHead, t2, time = Infinity;
  while (t1) {
    if (t1._call) {
      if (time > t1._time) time = t1._time;
      t0 = t1, t1 = t1._next;
    } else {
      t2 = t1._next, t1._next = null;
      t1 = t0 ? t0._next = t2 : taskHead = t2;
    }
  }
  taskTail = t0;
  sleep(time);
}
function sleep(time) {
  if (frame) return;
  if (timeout$1) timeout$1 = clearTimeout(timeout$1);
  var delay = time - clockNow;
  if (delay > 24) {
    if (time < Infinity) timeout$1 = setTimeout(wake, time - clock.now() - clockSkew);
    if (interval) interval = clearInterval(interval);
  } else {
    if (!interval) clockLast = clock.now(), interval = setInterval(poke, pokeDelay);
    frame = 1, setFrame(wake);
  }
}
function timeout(callback, delay, time) {
  var t = new Timer();
  delay = delay == null ? 0 : +delay;
  t.restart((elapsed) => {
    t.stop();
    callback(elapsed + delay);
  }, delay, time);
  return t;
}
var emptyOn = dispatch("start", "end", "cancel", "interrupt");
var emptyTween = [];
var CREATED = 0;
var SCHEDULED = 1;
var STARTING = 2;
var STARTED = 3;
var RUNNING = 4;
var ENDING = 5;
var ENDED = 6;
function schedule(node, name, id2, index2, group, timing) {
  var schedules = node.__transition;
  if (!schedules) node.__transition = {};
  else if (id2 in schedules) return;
  create(node, id2, {
    name,
    index: index2,
    // For context during callback.
    group,
    // For context during callback.
    on: emptyOn,
    tween: emptyTween,
    time: timing.time,
    delay: timing.delay,
    duration: timing.duration,
    ease: timing.ease,
    timer: null,
    state: CREATED
  });
}
function init(node, id2) {
  var schedule2 = get(node, id2);
  if (schedule2.state > CREATED) throw new Error("too late; already scheduled");
  return schedule2;
}
function set(node, id2) {
  var schedule2 = get(node, id2);
  if (schedule2.state > STARTED) throw new Error("too late; already running");
  return schedule2;
}
function get(node, id2) {
  var schedule2 = node.__transition;
  if (!schedule2 || !(schedule2 = schedule2[id2])) throw new Error("transition not found");
  return schedule2;
}
function create(node, id2, self) {
  var schedules = node.__transition, tween;
  schedules[id2] = self;
  self.timer = timer(schedule2, 0, self.time);
  function schedule2(elapsed) {
    self.state = SCHEDULED;
    self.timer.restart(start2, self.delay, self.time);
    if (self.delay <= elapsed) start2(elapsed - self.delay);
  }
  function start2(elapsed) {
    var i, j2, n, o;
    if (self.state !== SCHEDULED) return stop();
    for (i in schedules) {
      o = schedules[i];
      if (o.name !== self.name) continue;
      if (o.state === STARTED) return timeout(start2);
      if (o.state === RUNNING) {
        o.state = ENDED;
        o.timer.stop();
        o.on.call("interrupt", node, node.__data__, o.index, o.group);
        delete schedules[i];
      } else if (+i < id2) {
        o.state = ENDED;
        o.timer.stop();
        o.on.call("cancel", node, node.__data__, o.index, o.group);
        delete schedules[i];
      }
    }
    timeout(function() {
      if (self.state === STARTED) {
        self.state = RUNNING;
        self.timer.restart(tick2, self.delay, self.time);
        tick2(elapsed);
      }
    });
    self.state = STARTING;
    self.on.call("start", node, node.__data__, self.index, self.group);
    if (self.state !== STARTING) return;
    self.state = STARTED;
    tween = new Array(n = self.tween.length);
    for (i = 0, j2 = -1; i < n; ++i) {
      if (o = self.tween[i].value.call(node, node.__data__, self.index, self.group)) {
        tween[++j2] = o;
      }
    }
    tween.length = j2 + 1;
  }
  function tick2(elapsed) {
    var t = elapsed < self.duration ? self.ease.call(null, elapsed / self.duration) : (self.timer.restart(stop), self.state = ENDING, 1), i = -1, n = tween.length;
    while (++i < n) {
      tween[i].call(node, t);
    }
    if (self.state === ENDING) {
      self.on.call("end", node, node.__data__, self.index, self.group);
      stop();
    }
  }
  function stop() {
    self.state = ENDED;
    self.timer.stop();
    delete schedules[id2];
    for (var i in schedules) return;
    delete node.__transition;
  }
}
function interrupt(node, name) {
  var schedules = node.__transition, schedule2, active, empty2 = true, i;
  if (!schedules) return;
  name = name == null ? null : name + "";
  for (i in schedules) {
    if ((schedule2 = schedules[i]).name !== name) {
      empty2 = false;
      continue;
    }
    active = schedule2.state > STARTING && schedule2.state < ENDING;
    schedule2.state = ENDED;
    schedule2.timer.stop();
    schedule2.on.call(active ? "interrupt" : "cancel", node, node.__data__, schedule2.index, schedule2.group);
    delete schedules[i];
  }
  if (empty2) delete node.__transition;
}
function selection_interrupt(name) {
  return this.each(function() {
    interrupt(this, name);
  });
}
function tweenRemove(id2, name) {
  var tween0, tween1;
  return function() {
    var schedule2 = set(this, id2), tween = schedule2.tween;
    if (tween !== tween0) {
      tween1 = tween0 = tween;
      for (var i = 0, n = tween1.length; i < n; ++i) {
        if (tween1[i].name === name) {
          tween1 = tween1.slice();
          tween1.splice(i, 1);
          break;
        }
      }
    }
    schedule2.tween = tween1;
  };
}
function tweenFunction(id2, name, value) {
  var tween0, tween1;
  if (typeof value !== "function") throw new Error();
  return function() {
    var schedule2 = set(this, id2), tween = schedule2.tween;
    if (tween !== tween0) {
      tween1 = (tween0 = tween).slice();
      for (var t = { name, value }, i = 0, n = tween1.length; i < n; ++i) {
        if (tween1[i].name === name) {
          tween1[i] = t;
          break;
        }
      }
      if (i === n) tween1.push(t);
    }
    schedule2.tween = tween1;
  };
}
function transition_tween(name, value) {
  var id2 = this._id;
  name += "";
  if (arguments.length < 2) {
    var tween = get(this.node(), id2).tween;
    for (var i = 0, n = tween.length, t; i < n; ++i) {
      if ((t = tween[i]).name === name) {
        return t.value;
      }
    }
    return null;
  }
  return this.each((value == null ? tweenRemove : tweenFunction)(id2, name, value));
}
function tweenValue(transition, name, value) {
  var id2 = transition._id;
  transition.each(function() {
    var schedule2 = set(this, id2);
    (schedule2.value || (schedule2.value = {}))[name] = value.apply(this, arguments);
  });
  return function(node) {
    return get(node, id2).value[name];
  };
}
function interpolate(a, b2) {
  var c;
  return (typeof b2 === "number" ? interpolateNumber : b2 instanceof color ? interpolateRgb : (c = color(b2)) ? (b2 = c, interpolateRgb) : interpolateString)(a, b2);
}
function attrRemove(name) {
  return function() {
    this.removeAttribute(name);
  };
}
function attrRemoveNS(fullname) {
  return function() {
    this.removeAttributeNS(fullname.space, fullname.local);
  };
}
function attrConstant(name, interpolate2, value1) {
  var string00, string1 = value1 + "", interpolate0;
  return function() {
    var string0 = this.getAttribute(name);
    return string0 === string1 ? null : string0 === string00 ? interpolate0 : interpolate0 = interpolate2(string00 = string0, value1);
  };
}
function attrConstantNS(fullname, interpolate2, value1) {
  var string00, string1 = value1 + "", interpolate0;
  return function() {
    var string0 = this.getAttributeNS(fullname.space, fullname.local);
    return string0 === string1 ? null : string0 === string00 ? interpolate0 : interpolate0 = interpolate2(string00 = string0, value1);
  };
}
function attrFunction(name, interpolate2, value) {
  var string00, string10, interpolate0;
  return function() {
    var string0, value1 = value(this), string1;
    if (value1 == null) return void this.removeAttribute(name);
    string0 = this.getAttribute(name);
    string1 = value1 + "";
    return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : (string10 = string1, interpolate0 = interpolate2(string00 = string0, value1));
  };
}
function attrFunctionNS(fullname, interpolate2, value) {
  var string00, string10, interpolate0;
  return function() {
    var string0, value1 = value(this), string1;
    if (value1 == null) return void this.removeAttributeNS(fullname.space, fullname.local);
    string0 = this.getAttributeNS(fullname.space, fullname.local);
    string1 = value1 + "";
    return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : (string10 = string1, interpolate0 = interpolate2(string00 = string0, value1));
  };
}
function transition_attr(name, value) {
  var fullname = namespace(name), i = fullname === "transform" ? interpolateTransformSvg : interpolate;
  return this.attrTween(name, typeof value === "function" ? (fullname.local ? attrFunctionNS : attrFunction)(fullname, i, tweenValue(this, "attr." + name, value)) : value == null ? (fullname.local ? attrRemoveNS : attrRemove)(fullname) : (fullname.local ? attrConstantNS : attrConstant)(fullname, i, value));
}
function attrInterpolate(name, i) {
  return function(t) {
    this.setAttribute(name, i.call(this, t));
  };
}
function attrInterpolateNS(fullname, i) {
  return function(t) {
    this.setAttributeNS(fullname.space, fullname.local, i.call(this, t));
  };
}
function attrTweenNS(fullname, value) {
  var t0, i0;
  function tween() {
    var i = value.apply(this, arguments);
    if (i !== i0) t0 = (i0 = i) && attrInterpolateNS(fullname, i);
    return t0;
  }
  tween._value = value;
  return tween;
}
function attrTween(name, value) {
  var t0, i0;
  function tween() {
    var i = value.apply(this, arguments);
    if (i !== i0) t0 = (i0 = i) && attrInterpolate(name, i);
    return t0;
  }
  tween._value = value;
  return tween;
}
function transition_attrTween(name, value) {
  var key2 = "attr." + name;
  if (arguments.length < 2) return (key2 = this.tween(key2)) && key2._value;
  if (value == null) return this.tween(key2, null);
  if (typeof value !== "function") throw new Error();
  var fullname = namespace(name);
  return this.tween(key2, (fullname.local ? attrTweenNS : attrTween)(fullname, value));
}
function delayFunction(id2, value) {
  return function() {
    init(this, id2).delay = +value.apply(this, arguments);
  };
}
function delayConstant(id2, value) {
  return value = +value, function() {
    init(this, id2).delay = value;
  };
}
function transition_delay(value) {
  var id2 = this._id;
  return arguments.length ? this.each((typeof value === "function" ? delayFunction : delayConstant)(id2, value)) : get(this.node(), id2).delay;
}
function durationFunction(id2, value) {
  return function() {
    set(this, id2).duration = +value.apply(this, arguments);
  };
}
function durationConstant(id2, value) {
  return value = +value, function() {
    set(this, id2).duration = value;
  };
}
function transition_duration(value) {
  var id2 = this._id;
  return arguments.length ? this.each((typeof value === "function" ? durationFunction : durationConstant)(id2, value)) : get(this.node(), id2).duration;
}
function easeConstant(id2, value) {
  if (typeof value !== "function") throw new Error();
  return function() {
    set(this, id2).ease = value;
  };
}
function transition_ease(value) {
  var id2 = this._id;
  return arguments.length ? this.each(easeConstant(id2, value)) : get(this.node(), id2).ease;
}
function easeVarying(id2, value) {
  return function() {
    var v2 = value.apply(this, arguments);
    if (typeof v2 !== "function") throw new Error();
    set(this, id2).ease = v2;
  };
}
function transition_easeVarying(value) {
  if (typeof value !== "function") throw new Error();
  return this.each(easeVarying(this._id, value));
}
function transition_filter(match) {
  if (typeof match !== "function") match = matcher(match);
  for (var groups = this._groups, m2 = groups.length, subgroups = new Array(m2), j2 = 0; j2 < m2; ++j2) {
    for (var group = groups[j2], n = group.length, subgroup = subgroups[j2] = [], node, i = 0; i < n; ++i) {
      if ((node = group[i]) && match.call(node, node.__data__, i, group)) {
        subgroup.push(node);
      }
    }
  }
  return new Transition(subgroups, this._parents, this._name, this._id);
}
function transition_merge(transition) {
  if (transition._id !== this._id) throw new Error();
  for (var groups0 = this._groups, groups1 = transition._groups, m0 = groups0.length, m1 = groups1.length, m2 = Math.min(m0, m1), merges = new Array(m0), j2 = 0; j2 < m2; ++j2) {
    for (var group0 = groups0[j2], group1 = groups1[j2], n = group0.length, merge = merges[j2] = new Array(n), node, i = 0; i < n; ++i) {
      if (node = group0[i] || group1[i]) {
        merge[i] = node;
      }
    }
  }
  for (; j2 < m0; ++j2) {
    merges[j2] = groups0[j2];
  }
  return new Transition(merges, this._parents, this._name, this._id);
}
function start(name) {
  return (name + "").trim().split(/^|\s+/).every(function(t) {
    var i = t.indexOf(".");
    if (i >= 0) t = t.slice(0, i);
    return !t || t === "start";
  });
}
function onFunction(id2, name, listener) {
  var on0, on1, sit = start(name) ? init : set;
  return function() {
    var schedule2 = sit(this, id2), on2 = schedule2.on;
    if (on2 !== on0) (on1 = (on0 = on2).copy()).on(name, listener);
    schedule2.on = on1;
  };
}
function transition_on(name, listener) {
  var id2 = this._id;
  return arguments.length < 2 ? get(this.node(), id2).on.on(name) : this.each(onFunction(id2, name, listener));
}
function removeFunction(id2) {
  return function() {
    var parent = this.parentNode;
    for (var i in this.__transition) if (+i !== id2) return;
    if (parent) parent.removeChild(this);
  };
}
function transition_remove() {
  return this.on("end.remove", removeFunction(this._id));
}
function transition_select(select2) {
  var name = this._name, id2 = this._id;
  if (typeof select2 !== "function") select2 = selector(select2);
  for (var groups = this._groups, m2 = groups.length, subgroups = new Array(m2), j2 = 0; j2 < m2; ++j2) {
    for (var group = groups[j2], n = group.length, subgroup = subgroups[j2] = new Array(n), node, subnode, i = 0; i < n; ++i) {
      if ((node = group[i]) && (subnode = select2.call(node, node.__data__, i, group))) {
        if ("__data__" in node) subnode.__data__ = node.__data__;
        subgroup[i] = subnode;
        schedule(subgroup[i], name, id2, i, subgroup, get(node, id2));
      }
    }
  }
  return new Transition(subgroups, this._parents, name, id2);
}
function transition_selectAll(select2) {
  var name = this._name, id2 = this._id;
  if (typeof select2 !== "function") select2 = selectorAll(select2);
  for (var groups = this._groups, m2 = groups.length, subgroups = [], parents = [], j2 = 0; j2 < m2; ++j2) {
    for (var group = groups[j2], n = group.length, node, i = 0; i < n; ++i) {
      if (node = group[i]) {
        for (var children2 = select2.call(node, node.__data__, i, group), child2, inherit2 = get(node, id2), k = 0, l3 = children2.length; k < l3; ++k) {
          if (child2 = children2[k]) {
            schedule(child2, name, id2, k, children2, inherit2);
          }
        }
        subgroups.push(children2);
        parents.push(node);
      }
    }
  }
  return new Transition(subgroups, parents, name, id2);
}
var Selection$1 = selection.prototype.constructor;
function transition_selection() {
  return new Selection$1(this._groups, this._parents);
}
function styleNull(name, interpolate2) {
  var string00, string10, interpolate0;
  return function() {
    var string0 = styleValue(this, name), string1 = (this.style.removeProperty(name), styleValue(this, name));
    return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : interpolate0 = interpolate2(string00 = string0, string10 = string1);
  };
}
function styleRemove(name) {
  return function() {
    this.style.removeProperty(name);
  };
}
function styleConstant(name, interpolate2, value1) {
  var string00, string1 = value1 + "", interpolate0;
  return function() {
    var string0 = styleValue(this, name);
    return string0 === string1 ? null : string0 === string00 ? interpolate0 : interpolate0 = interpolate2(string00 = string0, value1);
  };
}
function styleFunction(name, interpolate2, value) {
  var string00, string10, interpolate0;
  return function() {
    var string0 = styleValue(this, name), value1 = value(this), string1 = value1 + "";
    if (value1 == null) string1 = value1 = (this.style.removeProperty(name), styleValue(this, name));
    return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : (string10 = string1, interpolate0 = interpolate2(string00 = string0, value1));
  };
}
function styleMaybeRemove(id2, name) {
  var on0, on1, listener0, key2 = "style." + name, event2 = "end." + key2, remove2;
  return function() {
    var schedule2 = set(this, id2), on2 = schedule2.on, listener = schedule2.value[key2] == null ? remove2 || (remove2 = styleRemove(name)) : void 0;
    if (on2 !== on0 || listener0 !== listener) (on1 = (on0 = on2).copy()).on(event2, listener0 = listener);
    schedule2.on = on1;
  };
}
function transition_style(name, value, priority) {
  var i = (name += "") === "transform" ? interpolateTransformCss : interpolate;
  return value == null ? this.styleTween(name, styleNull(name, i)).on("end.style." + name, styleRemove(name)) : typeof value === "function" ? this.styleTween(name, styleFunction(name, i, tweenValue(this, "style." + name, value))).each(styleMaybeRemove(this._id, name)) : this.styleTween(name, styleConstant(name, i, value), priority).on("end.style." + name, null);
}
function styleInterpolate(name, i, priority) {
  return function(t) {
    this.style.setProperty(name, i.call(this, t), priority);
  };
}
function styleTween(name, value, priority) {
  var t, i0;
  function tween() {
    var i = value.apply(this, arguments);
    if (i !== i0) t = (i0 = i) && styleInterpolate(name, i, priority);
    return t;
  }
  tween._value = value;
  return tween;
}
function transition_styleTween(name, value, priority) {
  var key2 = "style." + (name += "");
  if (arguments.length < 2) return (key2 = this.tween(key2)) && key2._value;
  if (value == null) return this.tween(key2, null);
  if (typeof value !== "function") throw new Error();
  return this.tween(key2, styleTween(name, value, priority == null ? "" : priority));
}
function textConstant(value) {
  return function() {
    this.textContent = value;
  };
}
function textFunction(value) {
  return function() {
    var value1 = value(this);
    this.textContent = value1 == null ? "" : value1;
  };
}
function transition_text(value) {
  return this.tween("text", typeof value === "function" ? textFunction(tweenValue(this, "text", value)) : textConstant(value == null ? "" : value + ""));
}
function textInterpolate(i) {
  return function(t) {
    this.textContent = i.call(this, t);
  };
}
function textTween(value) {
  var t0, i0;
  function tween() {
    var i = value.apply(this, arguments);
    if (i !== i0) t0 = (i0 = i) && textInterpolate(i);
    return t0;
  }
  tween._value = value;
  return tween;
}
function transition_textTween(value) {
  var key2 = "text";
  if (arguments.length < 1) return (key2 = this.tween(key2)) && key2._value;
  if (value == null) return this.tween(key2, null);
  if (typeof value !== "function") throw new Error();
  return this.tween(key2, textTween(value));
}
function transition_transition() {
  var name = this._name, id0 = this._id, id1 = newId();
  for (var groups = this._groups, m2 = groups.length, j2 = 0; j2 < m2; ++j2) {
    for (var group = groups[j2], n = group.length, node, i = 0; i < n; ++i) {
      if (node = group[i]) {
        var inherit2 = get(node, id0);
        schedule(node, name, id1, i, group, {
          time: inherit2.time + inherit2.delay + inherit2.duration,
          delay: 0,
          duration: inherit2.duration,
          ease: inherit2.ease
        });
      }
    }
  }
  return new Transition(groups, this._parents, name, id1);
}
function transition_end() {
  var on0, on1, that = this, id2 = that._id, size = that.size();
  return new Promise(function(resolve, reject) {
    var cancel = { value: reject }, end = { value: function() {
      if (--size === 0) resolve();
    } };
    that.each(function() {
      var schedule2 = set(this, id2), on2 = schedule2.on;
      if (on2 !== on0) {
        on1 = (on0 = on2).copy();
        on1._.cancel.push(cancel);
        on1._.interrupt.push(cancel);
        on1._.end.push(end);
      }
      schedule2.on = on1;
    });
    if (size === 0) resolve();
  });
}
var id = 0;
function Transition(groups, parents, name, id2) {
  this._groups = groups;
  this._parents = parents;
  this._name = name;
  this._id = id2;
}
function newId() {
  return ++id;
}
var selection_prototype = selection.prototype;
Transition.prototype = {
  constructor: Transition,
  select: transition_select,
  selectAll: transition_selectAll,
  selectChild: selection_prototype.selectChild,
  selectChildren: selection_prototype.selectChildren,
  filter: transition_filter,
  merge: transition_merge,
  selection: transition_selection,
  transition: transition_transition,
  call: selection_prototype.call,
  nodes: selection_prototype.nodes,
  node: selection_prototype.node,
  size: selection_prototype.size,
  empty: selection_prototype.empty,
  each: selection_prototype.each,
  on: transition_on,
  attr: transition_attr,
  attrTween: transition_attrTween,
  style: transition_style,
  styleTween: transition_styleTween,
  text: transition_text,
  textTween: transition_textTween,
  remove: transition_remove,
  tween: transition_tween,
  delay: transition_delay,
  duration: transition_duration,
  ease: transition_ease,
  easeVarying: transition_easeVarying,
  end: transition_end,
  [Symbol.iterator]: selection_prototype[Symbol.iterator]
};
function cubicInOut(t) {
  return ((t *= 2) <= 1 ? t * t * t : (t -= 2) * t * t + 2) / 2;
}
var defaultTiming = {
  time: null,
  // Set on use.
  delay: 0,
  duration: 250,
  ease: cubicInOut
};
function inherit(node, id2) {
  var timing;
  while (!(timing = node.__transition) || !(timing = timing[id2])) {
    if (!(node = node.parentNode)) {
      throw new Error(`transition ${id2} not found`);
    }
  }
  return timing;
}
function selection_transition(name) {
  var id2, timing;
  if (name instanceof Transition) {
    id2 = name._id, name = name._name;
  } else {
    id2 = newId(), (timing = defaultTiming).time = now(), name = name == null ? null : name + "";
  }
  for (var groups = this._groups, m2 = groups.length, j2 = 0; j2 < m2; ++j2) {
    for (var group = groups[j2], n = group.length, node, i = 0; i < n; ++i) {
      if (node = group[i]) {
        schedule(node, name, id2, i, group, timing || inherit(node, id2));
      }
    }
  }
  return new Transition(groups, this._parents, name, id2);
}
selection.prototype.interrupt = selection_interrupt;
selection.prototype.transition = selection_transition;
const constant = (x) => () => x;
function ZoomEvent(type, {
  sourceEvent: sourceEvent2,
  target,
  transform: transform2,
  dispatch: dispatch2
}) {
  Object.defineProperties(this, {
    type: { value: type, enumerable: true, configurable: true },
    sourceEvent: { value: sourceEvent2, enumerable: true, configurable: true },
    target: { value: target, enumerable: true, configurable: true },
    transform: { value: transform2, enumerable: true, configurable: true },
    _: { value: dispatch2 }
  });
}
function Transform(k, x, y2) {
  this.k = k;
  this.x = x;
  this.y = y2;
}
Transform.prototype = {
  constructor: Transform,
  scale: function(k) {
    return k === 1 ? this : new Transform(this.k * k, this.x, this.y);
  },
  translate: function(x, y2) {
    return x === 0 & y2 === 0 ? this : new Transform(this.k, this.x + this.k * x, this.y + this.k * y2);
  },
  apply: function(point) {
    return [point[0] * this.k + this.x, point[1] * this.k + this.y];
  },
  applyX: function(x) {
    return x * this.k + this.x;
  },
  applyY: function(y2) {
    return y2 * this.k + this.y;
  },
  invert: function(location) {
    return [(location[0] - this.x) / this.k, (location[1] - this.y) / this.k];
  },
  invertX: function(x) {
    return (x - this.x) / this.k;
  },
  invertY: function(y2) {
    return (y2 - this.y) / this.k;
  },
  rescaleX: function(x) {
    return x.copy().domain(x.range().map(this.invertX, this).map(x.invert, x));
  },
  rescaleY: function(y2) {
    return y2.copy().domain(y2.range().map(this.invertY, this).map(y2.invert, y2));
  },
  toString: function() {
    return "translate(" + this.x + "," + this.y + ") scale(" + this.k + ")";
  }
};
var identity = new Transform(1, 0, 0);
transform.prototype = Transform.prototype;
function transform(node) {
  while (!node.__zoom) if (!(node = node.parentNode)) return identity;
  return node.__zoom;
}
function nopropagation(event2) {
  event2.stopImmediatePropagation();
}
function noevent(event2) {
  event2.preventDefault();
  event2.stopImmediatePropagation();
}
function defaultFilter(event2) {
  return (!event2.ctrlKey || event2.type === "wheel") && !event2.button;
}
function defaultExtent() {
  var e = this;
  if (e instanceof SVGElement) {
    e = e.ownerSVGElement || e;
    if (e.hasAttribute("viewBox")) {
      e = e.viewBox.baseVal;
      return [[e.x, e.y], [e.x + e.width, e.y + e.height]];
    }
    return [[0, 0], [e.width.baseVal.value, e.height.baseVal.value]];
  }
  return [[0, 0], [e.clientWidth, e.clientHeight]];
}
function defaultTransform() {
  return this.__zoom || identity;
}
function defaultWheelDelta(event2) {
  return -event2.deltaY * (event2.deltaMode === 1 ? 0.05 : event2.deltaMode ? 1 : 2e-3) * (event2.ctrlKey ? 10 : 1);
}
function defaultTouchable() {
  return navigator.maxTouchPoints || "ontouchstart" in this;
}
function defaultConstrain(transform2, extent, translateExtent) {
  var dx0 = transform2.invertX(extent[0][0]) - translateExtent[0][0], dx1 = transform2.invertX(extent[1][0]) - translateExtent[1][0], dy0 = transform2.invertY(extent[0][1]) - translateExtent[0][1], dy1 = transform2.invertY(extent[1][1]) - translateExtent[1][1];
  return transform2.translate(
    dx1 > dx0 ? (dx0 + dx1) / 2 : Math.min(0, dx0) || Math.max(0, dx1),
    dy1 > dy0 ? (dy0 + dy1) / 2 : Math.min(0, dy0) || Math.max(0, dy1)
  );
}
function zoom$1() {
  var filter2 = defaultFilter, extent = defaultExtent, constrain = defaultConstrain, wheelDelta2 = defaultWheelDelta, touchable = defaultTouchable, scaleExtent = [0, Infinity], translateExtent = [[-Infinity, -Infinity], [Infinity, Infinity]], duration = 250, interpolate2 = interpolateZoom, listeners = dispatch("start", "zoom", "end"), touchstarting, touchfirst, touchending, touchDelay = 500, wheelDelay = 150, clickDistance2 = 0, tapDistance = 10;
  function zoom2(selection2) {
    selection2.property("__zoom", defaultTransform).on("wheel.zoom", wheeled, { passive: false }).on("mousedown.zoom", mousedowned).on("dblclick.zoom", dblclicked).filter(touchable).on("touchstart.zoom", touchstarted).on("touchmove.zoom", touchmoved).on("touchend.zoom touchcancel.zoom", touchended).style("-webkit-tap-highlight-color", "rgba(0,0,0,0)");
  }
  zoom2.transform = function(collection, transform2, point, event2) {
    var selection2 = collection.selection ? collection.selection() : collection;
    selection2.property("__zoom", defaultTransform);
    if (collection !== selection2) {
      schedule2(collection, transform2, point, event2);
    } else {
      selection2.interrupt().each(function() {
        gesture(this, arguments).event(event2).start().zoom(null, typeof transform2 === "function" ? transform2.apply(this, arguments) : transform2).end();
      });
    }
  };
  zoom2.scaleBy = function(selection2, k, p, event2) {
    zoom2.scaleTo(selection2, function() {
      var k0 = this.__zoom.k, k1 = typeof k === "function" ? k.apply(this, arguments) : k;
      return k0 * k1;
    }, p, event2);
  };
  zoom2.scaleTo = function(selection2, k, p, event2) {
    zoom2.transform(selection2, function() {
      var e = extent.apply(this, arguments), t0 = this.__zoom, p0 = p == null ? centroid(e) : typeof p === "function" ? p.apply(this, arguments) : p, p1 = t0.invert(p0), k1 = typeof k === "function" ? k.apply(this, arguments) : k;
      return constrain(translate(scale(t0, k1), p0, p1), e, translateExtent);
    }, p, event2);
  };
  zoom2.translateBy = function(selection2, x, y2, event2) {
    zoom2.transform(selection2, function() {
      return constrain(this.__zoom.translate(
        typeof x === "function" ? x.apply(this, arguments) : x,
        typeof y2 === "function" ? y2.apply(this, arguments) : y2
      ), extent.apply(this, arguments), translateExtent);
    }, null, event2);
  };
  zoom2.translateTo = function(selection2, x, y2, p, event2) {
    zoom2.transform(selection2, function() {
      var e = extent.apply(this, arguments), t = this.__zoom, p0 = p == null ? centroid(e) : typeof p === "function" ? p.apply(this, arguments) : p;
      return constrain(identity.translate(p0[0], p0[1]).scale(t.k).translate(
        typeof x === "function" ? -x.apply(this, arguments) : -x,
        typeof y2 === "function" ? -y2.apply(this, arguments) : -y2
      ), e, translateExtent);
    }, p, event2);
  };
  function scale(transform2, k) {
    k = Math.max(scaleExtent[0], Math.min(scaleExtent[1], k));
    return k === transform2.k ? transform2 : new Transform(k, transform2.x, transform2.y);
  }
  function translate(transform2, p0, p1) {
    var x = p0[0] - p1[0] * transform2.k, y2 = p0[1] - p1[1] * transform2.k;
    return x === transform2.x && y2 === transform2.y ? transform2 : new Transform(transform2.k, x, y2);
  }
  function centroid(extent2) {
    return [(+extent2[0][0] + +extent2[1][0]) / 2, (+extent2[0][1] + +extent2[1][1]) / 2];
  }
  function schedule2(transition, transform2, point, event2) {
    transition.on("start.zoom", function() {
      gesture(this, arguments).event(event2).start();
    }).on("interrupt.zoom end.zoom", function() {
      gesture(this, arguments).event(event2).end();
    }).tween("zoom", function() {
      var that = this, args = arguments, g = gesture(that, args).event(event2), e = extent.apply(that, args), p = point == null ? centroid(e) : typeof point === "function" ? point.apply(that, args) : point, w2 = Math.max(e[1][0] - e[0][0], e[1][1] - e[0][1]), a = that.__zoom, b2 = typeof transform2 === "function" ? transform2.apply(that, args) : transform2, i = interpolate2(a.invert(p).concat(w2 / a.k), b2.invert(p).concat(w2 / b2.k));
      return function(t) {
        if (t === 1) t = b2;
        else {
          var l3 = i(t), k = w2 / l3[2];
          t = new Transform(k, p[0] - l3[0] * k, p[1] - l3[1] * k);
        }
        g.zoom(null, t);
      };
    });
  }
  function gesture(that, args, clean) {
    return !clean && that.__zooming || new Gesture(that, args);
  }
  function Gesture(that, args) {
    this.that = that;
    this.args = args;
    this.active = 0;
    this.sourceEvent = null;
    this.extent = extent.apply(that, args);
    this.taps = 0;
  }
  Gesture.prototype = {
    event: function(event2) {
      if (event2) this.sourceEvent = event2;
      return this;
    },
    start: function() {
      if (++this.active === 1) {
        this.that.__zooming = this;
        this.emit("start");
      }
      return this;
    },
    zoom: function(key2, transform2) {
      if (this.mouse && key2 !== "mouse") this.mouse[1] = transform2.invert(this.mouse[0]);
      if (this.touch0 && key2 !== "touch") this.touch0[1] = transform2.invert(this.touch0[0]);
      if (this.touch1 && key2 !== "touch") this.touch1[1] = transform2.invert(this.touch1[0]);
      this.that.__zoom = transform2;
      this.emit("zoom");
      return this;
    },
    end: function() {
      if (--this.active === 0) {
        delete this.that.__zooming;
        this.emit("end");
      }
      return this;
    },
    emit: function(type) {
      var d2 = select(this.that).datum();
      listeners.call(
        type,
        this.that,
        new ZoomEvent(type, {
          sourceEvent: this.sourceEvent,
          target: zoom2,
          transform: this.that.__zoom,
          dispatch: listeners
        }),
        d2
      );
    }
  };
  function wheeled(event2, ...args) {
    if (!filter2.apply(this, arguments)) return;
    var g = gesture(this, args).event(event2), t = this.__zoom, k = Math.max(scaleExtent[0], Math.min(scaleExtent[1], t.k * Math.pow(2, wheelDelta2.apply(this, arguments)))), p = pointer(event2);
    if (g.wheel) {
      if (g.mouse[0][0] !== p[0] || g.mouse[0][1] !== p[1]) {
        g.mouse[1] = t.invert(g.mouse[0] = p);
      }
      clearTimeout(g.wheel);
    } else if (t.k === k) return;
    else {
      g.mouse = [p, t.invert(p)];
      interrupt(this);
      g.start();
    }
    noevent(event2);
    g.wheel = setTimeout(wheelidled, wheelDelay);
    g.zoom("mouse", constrain(translate(scale(t, k), g.mouse[0], g.mouse[1]), g.extent, translateExtent));
    function wheelidled() {
      g.wheel = null;
      g.end();
    }
  }
  function mousedowned(event2, ...args) {
    if (touchending || !filter2.apply(this, arguments)) return;
    var currentTarget = event2.currentTarget, g = gesture(this, args, true).event(event2), v2 = select(event2.view).on("mousemove.zoom", mousemoved, true).on("mouseup.zoom", mouseupped, true), p = pointer(event2, currentTarget), x0 = event2.clientX, y0 = event2.clientY;
    dragDisable(event2.view);
    nopropagation(event2);
    g.mouse = [p, this.__zoom.invert(p)];
    interrupt(this);
    g.start();
    function mousemoved(event3) {
      noevent(event3);
      if (!g.moved) {
        var dx = event3.clientX - x0, dy = event3.clientY - y0;
        g.moved = dx * dx + dy * dy > clickDistance2;
      }
      g.event(event3).zoom("mouse", constrain(translate(g.that.__zoom, g.mouse[0] = pointer(event3, currentTarget), g.mouse[1]), g.extent, translateExtent));
    }
    function mouseupped(event3) {
      v2.on("mousemove.zoom mouseup.zoom", null);
      yesdrag(event3.view, g.moved);
      noevent(event3);
      g.event(event3).end();
    }
  }
  function dblclicked(event2, ...args) {
    if (!filter2.apply(this, arguments)) return;
    var t0 = this.__zoom, p0 = pointer(event2.changedTouches ? event2.changedTouches[0] : event2, this), p1 = t0.invert(p0), k1 = t0.k * (event2.shiftKey ? 0.5 : 2), t1 = constrain(translate(scale(t0, k1), p0, p1), extent.apply(this, args), translateExtent);
    noevent(event2);
    if (duration > 0) select(this).transition().duration(duration).call(schedule2, t1, p0, event2);
    else select(this).call(zoom2.transform, t1, p0, event2);
  }
  function touchstarted(event2, ...args) {
    if (!filter2.apply(this, arguments)) return;
    var touches = event2.touches, n = touches.length, g = gesture(this, args, event2.changedTouches.length === n).event(event2), started, i, t, p;
    nopropagation(event2);
    for (i = 0; i < n; ++i) {
      t = touches[i], p = pointer(t, this);
      p = [p, this.__zoom.invert(p), t.identifier];
      if (!g.touch0) g.touch0 = p, started = true, g.taps = 1 + !!touchstarting;
      else if (!g.touch1 && g.touch0[2] !== p[2]) g.touch1 = p, g.taps = 0;
    }
    if (touchstarting) touchstarting = clearTimeout(touchstarting);
    if (started) {
      if (g.taps < 2) touchfirst = p[0], touchstarting = setTimeout(function() {
        touchstarting = null;
      }, touchDelay);
      interrupt(this);
      g.start();
    }
  }
  function touchmoved(event2, ...args) {
    if (!this.__zooming) return;
    var g = gesture(this, args).event(event2), touches = event2.changedTouches, n = touches.length, i, t, p, l3;
    noevent(event2);
    for (i = 0; i < n; ++i) {
      t = touches[i], p = pointer(t, this);
      if (g.touch0 && g.touch0[2] === t.identifier) g.touch0[0] = p;
      else if (g.touch1 && g.touch1[2] === t.identifier) g.touch1[0] = p;
    }
    t = g.that.__zoom;
    if (g.touch1) {
      var p0 = g.touch0[0], l0 = g.touch0[1], p1 = g.touch1[0], l1 = g.touch1[1], dp = (dp = p1[0] - p0[0]) * dp + (dp = p1[1] - p0[1]) * dp, dl = (dl = l1[0] - l0[0]) * dl + (dl = l1[1] - l0[1]) * dl;
      t = scale(t, Math.sqrt(dp / dl));
      p = [(p0[0] + p1[0]) / 2, (p0[1] + p1[1]) / 2];
      l3 = [(l0[0] + l1[0]) / 2, (l0[1] + l1[1]) / 2];
    } else if (g.touch0) p = g.touch0[0], l3 = g.touch0[1];
    else return;
    g.zoom("touch", constrain(translate(t, p, l3), g.extent, translateExtent));
  }
  function touchended(event2, ...args) {
    if (!this.__zooming) return;
    var g = gesture(this, args).event(event2), touches = event2.changedTouches, n = touches.length, i, t;
    nopropagation(event2);
    if (touchending) clearTimeout(touchending);
    touchending = setTimeout(function() {
      touchending = null;
    }, touchDelay);
    for (i = 0; i < n; ++i) {
      t = touches[i];
      if (g.touch0 && g.touch0[2] === t.identifier) delete g.touch0;
      else if (g.touch1 && g.touch1[2] === t.identifier) delete g.touch1;
    }
    if (g.touch1 && !g.touch0) g.touch0 = g.touch1, delete g.touch1;
    if (g.touch0) g.touch0[1] = this.__zoom.invert(g.touch0[0]);
    else {
      g.end();
      if (g.taps === 2) {
        t = pointer(t, this);
        if (Math.hypot(touchfirst[0] - t[0], touchfirst[1] - t[1]) < tapDistance) {
          var p = select(this).on("dblclick.zoom");
          if (p) p.apply(this, arguments);
        }
      }
    }
  }
  zoom2.wheelDelta = function(_2) {
    return arguments.length ? (wheelDelta2 = typeof _2 === "function" ? _2 : constant(+_2), zoom2) : wheelDelta2;
  };
  zoom2.filter = function(_2) {
    return arguments.length ? (filter2 = typeof _2 === "function" ? _2 : constant(!!_2), zoom2) : filter2;
  };
  zoom2.touchable = function(_2) {
    return arguments.length ? (touchable = typeof _2 === "function" ? _2 : constant(!!_2), zoom2) : touchable;
  };
  zoom2.extent = function(_2) {
    return arguments.length ? (extent = typeof _2 === "function" ? _2 : constant([[+_2[0][0], +_2[0][1]], [+_2[1][0], +_2[1][1]]]), zoom2) : extent;
  };
  zoom2.scaleExtent = function(_2) {
    return arguments.length ? (scaleExtent[0] = +_2[0], scaleExtent[1] = +_2[1], zoom2) : [scaleExtent[0], scaleExtent[1]];
  };
  zoom2.translateExtent = function(_2) {
    return arguments.length ? (translateExtent[0][0] = +_2[0][0], translateExtent[1][0] = +_2[1][0], translateExtent[0][1] = +_2[0][1], translateExtent[1][1] = +_2[1][1], zoom2) : [[translateExtent[0][0], translateExtent[0][1]], [translateExtent[1][0], translateExtent[1][1]]];
  };
  zoom2.constrain = function(_2) {
    return arguments.length ? (constrain = _2, zoom2) : constrain;
  };
  zoom2.duration = function(_2) {
    return arguments.length ? (duration = +_2, zoom2) : duration;
  };
  zoom2.interpolate = function(_2) {
    return arguments.length ? (interpolate2 = _2, zoom2) : interpolate2;
  };
  zoom2.on = function() {
    var value = listeners.on.apply(listeners, arguments);
    return value === listeners ? zoom2 : value;
  };
  zoom2.clickDistance = function(_2) {
    return arguments.length ? (clickDistance2 = (_2 = +_2) * _2, zoom2) : Math.sqrt(clickDistance2);
  };
  zoom2.tapDistance = function(_2) {
    return arguments.length ? (tapDistance = +_2, zoom2) : tapDistance;
  };
  return zoom2;
}
const errorMessages = {
  error001: () => "[React Flow]: Seems like you have not used zustand provider as an ancestor. Help: https://reactflow.dev/error#001",
  error002: () => "It looks like you've created a new nodeTypes or edgeTypes object. If this wasn't on purpose please define the nodeTypes/edgeTypes outside of the component or memoize them.",
  error003: (nodeType) => `Node type "${nodeType}" not found. Using fallback type "default".`,
  error004: () => "The React Flow parent container needs a width and a height to render the graph.",
  error005: () => "Only child nodes can use a parent extent.",
  error006: () => "Can't create edge. An edge needs a source and a target.",
  error007: (id2) => `The old edge with id=${id2} does not exist.`,
  error009: (type) => `Marker type "${type}" doesn't exist.`,
  error008: (handleType, { id: id2, sourceHandle, targetHandle }) => `Couldn't create edge for ${handleType} handle id: "${handleType === "source" ? sourceHandle : targetHandle}", edge id: ${id2}.`,
  error010: () => "Handle: No node id found. Make sure to only use a Handle inside a custom Node.",
  error011: (edgeType) => `Edge type "${edgeType}" not found. Using fallback type "default".`,
  error012: (id2) => `Node with id "${id2}" does not exist, it may have been removed. This can happen when a node is deleted before the "onNodeClick" handler is called.`,
  error013: (lib = "react") => `It seems that you haven't loaded the styles. Please import '@xyflow/${lib}/dist/style.css' or base.css to make sure everything is working properly.`,
  error014: () => "useNodeConnections: No node ID found. Call useNodeConnections inside a custom Node or provide a node ID.",
  error015: () => "It seems that you are trying to drag a node that is not initialized. Please use onNodesChange as explained in the docs."
};
const infiniteExtent = [
  [Number.NEGATIVE_INFINITY, Number.NEGATIVE_INFINITY],
  [Number.POSITIVE_INFINITY, Number.POSITIVE_INFINITY]
];
const elementSelectionKeys = ["Enter", " ", "Escape"];
const defaultAriaLabelConfig = {
  "node.a11yDescription.default": "Press enter or space to select a node. Press delete to remove it and escape to cancel.",
  "node.a11yDescription.keyboardDisabled": "Press enter or space to select a node. You can then use the arrow keys to move the node around. Press delete to remove it and escape to cancel.",
  "node.a11yDescription.ariaLiveMessage": ({ direction, x, y: y2 }) => `Moved selected node ${direction}. New position, x: ${x}, y: ${y2}`,
  "edge.a11yDescription.default": "Press enter or space to select an edge. You can then press delete to remove it or escape to cancel.",
  // Control elements
  "controls.ariaLabel": "Control Panel",
  "controls.zoomIn.ariaLabel": "Zoom In",
  "controls.zoomOut.ariaLabel": "Zoom Out",
  "controls.fitView.ariaLabel": "Fit View",
  "controls.interactive.ariaLabel": "Toggle Interactivity",
  // Mini map
  "minimap.ariaLabel": "Mini Map",
  // Handle
  "handle.ariaLabel": "Handle"
};
var ConnectionMode;
(function(ConnectionMode2) {
  ConnectionMode2["Strict"] = "strict";
  ConnectionMode2["Loose"] = "loose";
})(ConnectionMode || (ConnectionMode = {}));
var PanOnScrollMode;
(function(PanOnScrollMode2) {
  PanOnScrollMode2["Free"] = "free";
  PanOnScrollMode2["Vertical"] = "vertical";
  PanOnScrollMode2["Horizontal"] = "horizontal";
})(PanOnScrollMode || (PanOnScrollMode = {}));
var SelectionMode;
(function(SelectionMode2) {
  SelectionMode2["Partial"] = "partial";
  SelectionMode2["Full"] = "full";
})(SelectionMode || (SelectionMode = {}));
const initialConnection = {
  inProgress: false,
  isValid: null,
  from: null,
  fromHandle: null,
  fromPosition: null,
  fromNode: null,
  to: null,
  toHandle: null,
  toPosition: null,
  toNode: null
};
var ConnectionLineType;
(function(ConnectionLineType2) {
  ConnectionLineType2["Bezier"] = "default";
  ConnectionLineType2["Straight"] = "straight";
  ConnectionLineType2["Step"] = "step";
  ConnectionLineType2["SmoothStep"] = "smoothstep";
  ConnectionLineType2["SimpleBezier"] = "simplebezier";
})(ConnectionLineType || (ConnectionLineType = {}));
var MarkerType;
(function(MarkerType2) {
  MarkerType2["Arrow"] = "arrow";
  MarkerType2["ArrowClosed"] = "arrowclosed";
})(MarkerType || (MarkerType = {}));
var Position;
(function(Position2) {
  Position2["Left"] = "left";
  Position2["Top"] = "top";
  Position2["Right"] = "right";
  Position2["Bottom"] = "bottom";
})(Position || (Position = {}));
const oppositePosition = {
  [Position.Left]: Position.Right,
  [Position.Right]: Position.Left,
  [Position.Top]: Position.Bottom,
  [Position.Bottom]: Position.Top
};
function areConnectionMapsEqual(a, b2) {
  if (!a && !b2) {
    return true;
  }
  if (!a || !b2 || a.size !== b2.size) {
    return false;
  }
  if (!a.size && !b2.size) {
    return true;
  }
  for (const key2 of a.keys()) {
    if (!b2.has(key2)) {
      return false;
    }
  }
  return true;
}
function handleConnectionChange(a, b2, cb) {
  if (!cb) {
    return;
  }
  const diff = [];
  a.forEach((connection, key2) => {
    if (!(b2 == null ? void 0 : b2.has(key2))) {
      diff.push(connection);
    }
  });
  if (diff.length) {
    cb(diff);
  }
}
function getConnectionStatus(isValid) {
  return isValid === null ? null : isValid ? "valid" : "invalid";
}
const isEdgeBase = (element) => "id" in element && "source" in element && "target" in element;
const isNodeBase = (element) => "id" in element && "position" in element && !("source" in element) && !("target" in element);
const isInternalNodeBase = (element) => "id" in element && "internals" in element && !("source" in element) && !("target" in element);
const getNodePositionWithOrigin = (node, nodeOrigin = [0, 0]) => {
  var _a2;
  const { width, height } = getNodeDimensions(node);
  const origin = (_a2 = node.origin) != null ? _a2 : nodeOrigin;
  const offsetX = width * origin[0];
  const offsetY = height * origin[1];
  return {
    x: node.position.x - offsetX,
    y: node.position.y - offsetY
  };
};
const getNodesBounds = (nodes, params = { nodeOrigin: [0, 0] }) => {
  if (nodes.length === 0) {
    return { x: 0, y: 0, width: 0, height: 0 };
  }
  const box = nodes.reduce((currBox, nodeOrId) => {
    const isId = typeof nodeOrId === "string";
    let currentNode = !params.nodeLookup && !isId ? nodeOrId : void 0;
    if (params.nodeLookup) {
      currentNode = isId ? params.nodeLookup.get(nodeOrId) : !isInternalNodeBase(nodeOrId) ? params.nodeLookup.get(nodeOrId.id) : nodeOrId;
    }
    const nodeBox = currentNode ? nodeToBox(currentNode, params.nodeOrigin) : { x: 0, y: 0, x2: 0, y2: 0 };
    return getBoundsOfBoxes(currBox, nodeBox);
  }, { x: Infinity, y: Infinity, x2: -Infinity, y2: -Infinity });
  return boxToRect(box);
};
const getInternalNodesBounds = (nodeLookup, params = {}) => {
  if (nodeLookup.size === 0) {
    return { x: 0, y: 0, width: 0, height: 0 };
  }
  let box = { x: Infinity, y: Infinity, x2: -Infinity, y2: -Infinity };
  nodeLookup.forEach((node) => {
    if (params.filter === void 0 || params.filter(node)) {
      const nodeBox = nodeToBox(node);
      box = getBoundsOfBoxes(box, nodeBox);
    }
  });
  return boxToRect(box);
};
const getNodesInside = (nodes, rect, [tx, ty, tScale] = [0, 0, 1], partially = false, excludeNonSelectableNodes = false) => {
  var _a2, _b2, _c2, _d2, _e2, _f;
  const paneRect = __spreadProps(__spreadValues({}, pointToRendererPoint(rect, [tx, ty, tScale])), {
    width: rect.width / tScale,
    height: rect.height / tScale
  });
  const visibleNodes = [];
  for (const node of nodes.values()) {
    const { measured, selectable = true, hidden = false } = node;
    if (excludeNonSelectableNodes && !selectable || hidden) {
      continue;
    }
    const width = (_c2 = (_b2 = (_a2 = measured.width) != null ? _a2 : node.width) != null ? _b2 : node.initialWidth) != null ? _c2 : null;
    const height = (_f = (_e2 = (_d2 = measured.height) != null ? _d2 : node.height) != null ? _e2 : node.initialHeight) != null ? _f : null;
    const overlappingArea = getOverlappingArea(paneRect, nodeToRect(node));
    const area = (width != null ? width : 0) * (height != null ? height : 0);
    const partiallyVisible = partially && overlappingArea > 0;
    const forceInitialRender = !node.internals.handleBounds;
    const isVisible = forceInitialRender || partiallyVisible || overlappingArea >= area;
    if (isVisible || node.dragging) {
      visibleNodes.push(node);
    }
  }
  return visibleNodes;
};
const getConnectedEdges = (nodes, edges) => {
  const nodeIds = /* @__PURE__ */ new Set();
  nodes.forEach((node) => {
    nodeIds.add(node.id);
  });
  return edges.filter((edge) => nodeIds.has(edge.source) || nodeIds.has(edge.target));
};
function getFitViewNodes(nodeLookup, options) {
  const fitViewNodes = /* @__PURE__ */ new Map();
  const optionNodeIds = (options == null ? void 0 : options.nodes) ? new Set(options.nodes.map((node) => node.id)) : null;
  nodeLookup.forEach((n) => {
    const isVisible = n.measured.width && n.measured.height && ((options == null ? void 0 : options.includeHiddenNodes) || !n.hidden);
    if (isVisible && (!optionNodeIds || optionNodeIds.has(n.id))) {
      fitViewNodes.set(n.id, n);
    }
  });
  return fitViewNodes;
}
function fitViewport(_0, _1) {
  return __async(this, arguments, function* ({ nodes, width, height, panZoom, minZoom, maxZoom }, options) {
    var _a2, _b2, _c2;
    if (nodes.size === 0) {
      return Promise.resolve(true);
    }
    const nodesToFit = getFitViewNodes(nodes, options);
    const bounds = getInternalNodesBounds(nodesToFit);
    const viewport = getViewportForBounds(bounds, width, height, (_a2 = options == null ? void 0 : options.minZoom) != null ? _a2 : minZoom, (_b2 = options == null ? void 0 : options.maxZoom) != null ? _b2 : maxZoom, (_c2 = options == null ? void 0 : options.padding) != null ? _c2 : 0.1);
    yield panZoom.setViewport(viewport, {
      duration: options == null ? void 0 : options.duration,
      ease: options == null ? void 0 : options.ease,
      interpolate: options == null ? void 0 : options.interpolate
    });
    return Promise.resolve(true);
  });
}
function calculateNodePosition({ nodeId, nextPosition, nodeLookup, nodeOrigin = [0, 0], nodeExtent, onError }) {
  var _a2, _b2, _c2;
  const node = nodeLookup.get(nodeId);
  const parentNode = node.parentId ? nodeLookup.get(node.parentId) : void 0;
  const { x: parentX, y: parentY } = parentNode ? parentNode.internals.positionAbsolute : { x: 0, y: 0 };
  const origin = (_a2 = node.origin) != null ? _a2 : nodeOrigin;
  let extent = nodeExtent;
  if (node.extent === "parent" && !node.expandParent) {
    if (!parentNode) {
      onError == null ? void 0 : onError("005", errorMessages["error005"]());
    } else {
      const parentWidth = parentNode.measured.width;
      const parentHeight = parentNode.measured.height;
      if (parentWidth && parentHeight) {
        extent = [
          [parentX, parentY],
          [parentX + parentWidth, parentY + parentHeight]
        ];
      }
    }
  } else if (parentNode && isCoordinateExtent(node.extent)) {
    extent = [
      [node.extent[0][0] + parentX, node.extent[0][1] + parentY],
      [node.extent[1][0] + parentX, node.extent[1][1] + parentY]
    ];
  }
  const positionAbsolute = isCoordinateExtent(extent) ? clampPosition(nextPosition, extent, node.measured) : nextPosition;
  if (node.measured.width === void 0 || node.measured.height === void 0) {
    onError == null ? void 0 : onError("015", errorMessages["error015"]());
  }
  return {
    position: {
      x: positionAbsolute.x - parentX + ((_b2 = node.measured.width) != null ? _b2 : 0) * origin[0],
      y: positionAbsolute.y - parentY + ((_c2 = node.measured.height) != null ? _c2 : 0) * origin[1]
    },
    positionAbsolute
  };
}
function getElementsToRemove(_0) {
  return __async(this, arguments, function* ({ nodesToRemove = [], edgesToRemove = [], nodes, edges, onBeforeDelete }) {
    const nodeIds = new Set(nodesToRemove.map((node) => node.id));
    const matchingNodes = [];
    for (const node of nodes) {
      if (node.deletable === false) {
        continue;
      }
      const isIncluded = nodeIds.has(node.id);
      const parentHit = !isIncluded && node.parentId && matchingNodes.find((n) => n.id === node.parentId);
      if (isIncluded || parentHit) {
        matchingNodes.push(node);
      }
    }
    const edgeIds = new Set(edgesToRemove.map((edge) => edge.id));
    const deletableEdges = edges.filter((edge) => edge.deletable !== false);
    const connectedEdges = getConnectedEdges(matchingNodes, deletableEdges);
    const matchingEdges = connectedEdges;
    for (const edge of deletableEdges) {
      const isIncluded = edgeIds.has(edge.id);
      if (isIncluded && !matchingEdges.find((e) => e.id === edge.id)) {
        matchingEdges.push(edge);
      }
    }
    if (!onBeforeDelete) {
      return {
        edges: matchingEdges,
        nodes: matchingNodes
      };
    }
    const onBeforeDeleteResult = yield onBeforeDelete({
      nodes: matchingNodes,
      edges: matchingEdges
    });
    if (typeof onBeforeDeleteResult === "boolean") {
      return onBeforeDeleteResult ? { edges: matchingEdges, nodes: matchingNodes } : { edges: [], nodes: [] };
    }
    return onBeforeDeleteResult;
  });
}
const clamp = (val, min = 0, max = 1) => Math.min(Math.max(val, min), max);
const clampPosition = (position = { x: 0, y: 0 }, extent, dimensions) => {
  var _a2, _b2;
  return {
    x: clamp(position.x, extent[0][0], extent[1][0] - ((_a2 = dimensions == null ? void 0 : dimensions.width) != null ? _a2 : 0)),
    y: clamp(position.y, extent[0][1], extent[1][1] - ((_b2 = dimensions == null ? void 0 : dimensions.height) != null ? _b2 : 0))
  };
};
function clampPositionToParent(childPosition, childDimensions, parent) {
  const { width: parentWidth, height: parentHeight } = getNodeDimensions(parent);
  const { x: parentX, y: parentY } = parent.internals.positionAbsolute;
  return clampPosition(childPosition, [
    [parentX, parentY],
    [parentX + parentWidth, parentY + parentHeight]
  ], childDimensions);
}
const calcAutoPanVelocity = (value, min, max) => {
  if (value < min) {
    return clamp(Math.abs(value - min), 1, min) / min;
  } else if (value > max) {
    return -clamp(Math.abs(value - max), 1, min) / min;
  }
  return 0;
};
const calcAutoPan = (pos, bounds, speed = 15, distance2 = 40) => {
  const xMovement = calcAutoPanVelocity(pos.x, distance2, bounds.width - distance2) * speed;
  const yMovement = calcAutoPanVelocity(pos.y, distance2, bounds.height - distance2) * speed;
  return [xMovement, yMovement];
};
const getBoundsOfBoxes = (box1, box2) => ({
  x: Math.min(box1.x, box2.x),
  y: Math.min(box1.y, box2.y),
  x2: Math.max(box1.x2, box2.x2),
  y2: Math.max(box1.y2, box2.y2)
});
const rectToBox = ({ x, y: y2, width, height }) => ({
  x,
  y: y2,
  x2: x + width,
  y2: y2 + height
});
const boxToRect = ({ x, y: y2, x2, y2: y22 }) => ({
  x,
  y: y2,
  width: x2 - x,
  height: y22 - y2
});
const nodeToRect = (node, nodeOrigin = [0, 0]) => {
  var _a2, _b2, _c2, _d2, _e2, _f, _g, _h;
  const { x, y: y2 } = isInternalNodeBase(node) ? node.internals.positionAbsolute : getNodePositionWithOrigin(node, nodeOrigin);
  return {
    x,
    y: y2,
    width: (_d2 = (_c2 = (_b2 = (_a2 = node.measured) == null ? void 0 : _a2.width) != null ? _b2 : node.width) != null ? _c2 : node.initialWidth) != null ? _d2 : 0,
    height: (_h = (_g = (_f = (_e2 = node.measured) == null ? void 0 : _e2.height) != null ? _f : node.height) != null ? _g : node.initialHeight) != null ? _h : 0
  };
};
const nodeToBox = (node, nodeOrigin = [0, 0]) => {
  var _a2, _b2, _c2, _d2, _e2, _f, _g, _h;
  const { x, y: y2 } = isInternalNodeBase(node) ? node.internals.positionAbsolute : getNodePositionWithOrigin(node, nodeOrigin);
  return {
    x,
    y: y2,
    x2: x + ((_d2 = (_c2 = (_b2 = (_a2 = node.measured) == null ? void 0 : _a2.width) != null ? _b2 : node.width) != null ? _c2 : node.initialWidth) != null ? _d2 : 0),
    y2: y2 + ((_h = (_g = (_f = (_e2 = node.measured) == null ? void 0 : _e2.height) != null ? _f : node.height) != null ? _g : node.initialHeight) != null ? _h : 0)
  };
};
const getBoundsOfRects = (rect1, rect2) => boxToRect(getBoundsOfBoxes(rectToBox(rect1), rectToBox(rect2)));
const getOverlappingArea = (rectA, rectB) => {
  const xOverlap = Math.max(0, Math.min(rectA.x + rectA.width, rectB.x + rectB.width) - Math.max(rectA.x, rectB.x));
  const yOverlap = Math.max(0, Math.min(rectA.y + rectA.height, rectB.y + rectB.height) - Math.max(rectA.y, rectB.y));
  return Math.ceil(xOverlap * yOverlap);
};
const isRectObject = (obj) => isNumeric(obj.width) && isNumeric(obj.height) && isNumeric(obj.x) && isNumeric(obj.y);
const isNumeric = (n) => !isNaN(n) && isFinite(n);
const devWarn = (id2, message) => {
};
const snapPosition = (position, snapGrid = [1, 1]) => {
  return {
    x: snapGrid[0] * Math.round(position.x / snapGrid[0]),
    y: snapGrid[1] * Math.round(position.y / snapGrid[1])
  };
};
const pointToRendererPoint = ({ x, y: y2 }, [tx, ty, tScale], snapToGrid = false, snapGrid = [1, 1]) => {
  const position = {
    x: (x - tx) / tScale,
    y: (y2 - ty) / tScale
  };
  return snapToGrid ? snapPosition(position, snapGrid) : position;
};
const rendererPointToPoint = ({ x, y: y2 }, [tx, ty, tScale]) => {
  return {
    x: x * tScale + tx,
    y: y2 * tScale + ty
  };
};
function parsePadding(padding, viewport) {
  if (typeof padding === "number") {
    return Math.floor((viewport - viewport / (1 + padding)) * 0.5);
  }
  if (typeof padding === "string" && padding.endsWith("px")) {
    const paddingValue = parseFloat(padding);
    if (!Number.isNaN(paddingValue)) {
      return Math.floor(paddingValue);
    }
  }
  if (typeof padding === "string" && padding.endsWith("%")) {
    const paddingValue = parseFloat(padding);
    if (!Number.isNaN(paddingValue)) {
      return Math.floor(viewport * paddingValue * 0.01);
    }
  }
  console.error(`[React Flow] The padding value "${padding}" is invalid. Please provide a number or a string with a valid unit (px or %).`);
  return 0;
}
function parsePaddings(padding, width, height) {
  var _a2, _b2, _c2, _d2, _e2, _f, _g, _h;
  if (typeof padding === "string" || typeof padding === "number") {
    const paddingY = parsePadding(padding, height);
    const paddingX = parsePadding(padding, width);
    return {
      top: paddingY,
      right: paddingX,
      bottom: paddingY,
      left: paddingX,
      x: paddingX * 2,
      y: paddingY * 2
    };
  }
  if (typeof padding === "object") {
    const top = parsePadding((_b2 = (_a2 = padding.top) != null ? _a2 : padding.y) != null ? _b2 : 0, height);
    const bottom = parsePadding((_d2 = (_c2 = padding.bottom) != null ? _c2 : padding.y) != null ? _d2 : 0, height);
    const left = parsePadding((_f = (_e2 = padding.left) != null ? _e2 : padding.x) != null ? _f : 0, width);
    const right = parsePadding((_h = (_g = padding.right) != null ? _g : padding.x) != null ? _h : 0, width);
    return { top, right, bottom, left, x: left + right, y: top + bottom };
  }
  return { top: 0, right: 0, bottom: 0, left: 0, x: 0, y: 0 };
}
function calculateAppliedPaddings(bounds, x, y2, zoom2, width, height) {
  const { x: left, y: top } = rendererPointToPoint(bounds, [x, y2, zoom2]);
  const { x: boundRight, y: boundBottom } = rendererPointToPoint({ x: bounds.x + bounds.width, y: bounds.y + bounds.height }, [x, y2, zoom2]);
  const right = width - boundRight;
  const bottom = height - boundBottom;
  return {
    left: Math.floor(left),
    top: Math.floor(top),
    right: Math.floor(right),
    bottom: Math.floor(bottom)
  };
}
const getViewportForBounds = (bounds, width, height, minZoom, maxZoom, padding) => {
  const p = parsePaddings(padding, width, height);
  const xZoom = (width - p.x) / bounds.width;
  const yZoom = (height - p.y) / bounds.height;
  const zoom2 = Math.min(xZoom, yZoom);
  const clampedZoom = clamp(zoom2, minZoom, maxZoom);
  const boundsCenterX = bounds.x + bounds.width / 2;
  const boundsCenterY = bounds.y + bounds.height / 2;
  const x = width / 2 - boundsCenterX * clampedZoom;
  const y2 = height / 2 - boundsCenterY * clampedZoom;
  const newPadding = calculateAppliedPaddings(bounds, x, y2, clampedZoom, width, height);
  const offset = {
    left: Math.min(newPadding.left - p.left, 0),
    top: Math.min(newPadding.top - p.top, 0),
    right: Math.min(newPadding.right - p.right, 0),
    bottom: Math.min(newPadding.bottom - p.bottom, 0)
  };
  return {
    x: x - offset.left + offset.right,
    y: y2 - offset.top + offset.bottom,
    zoom: clampedZoom
  };
};
const isMacOs = () => {
  var _a2;
  return typeof navigator !== "undefined" && ((_a2 = navigator == null ? void 0 : navigator.userAgent) == null ? void 0 : _a2.indexOf("Mac")) >= 0;
};
function isCoordinateExtent(extent) {
  return extent !== void 0 && extent !== "parent";
}
function getNodeDimensions(node) {
  var _a2, _b2, _c2, _d2, _e2, _f, _g, _h;
  return {
    width: (_d2 = (_c2 = (_b2 = (_a2 = node.measured) == null ? void 0 : _a2.width) != null ? _b2 : node.width) != null ? _c2 : node.initialWidth) != null ? _d2 : 0,
    height: (_h = (_g = (_f = (_e2 = node.measured) == null ? void 0 : _e2.height) != null ? _f : node.height) != null ? _g : node.initialHeight) != null ? _h : 0
  };
}
function nodeHasDimensions(node) {
  var _a2, _b2, _c2, _d2, _e2, _f;
  return ((_c2 = (_b2 = (_a2 = node.measured) == null ? void 0 : _a2.width) != null ? _b2 : node.width) != null ? _c2 : node.initialWidth) !== void 0 && ((_f = (_e2 = (_d2 = node.measured) == null ? void 0 : _d2.height) != null ? _e2 : node.height) != null ? _f : node.initialHeight) !== void 0;
}
function evaluateAbsolutePosition(position, dimensions = { width: 0, height: 0 }, parentId, nodeLookup, nodeOrigin) {
  var _a2, _b2;
  const positionAbsolute = __spreadValues({}, position);
  const parent = nodeLookup.get(parentId);
  if (parent) {
    const origin = parent.origin || nodeOrigin;
    positionAbsolute.x += parent.internals.positionAbsolute.x - ((_a2 = dimensions.width) != null ? _a2 : 0) * origin[0];
    positionAbsolute.y += parent.internals.positionAbsolute.y - ((_b2 = dimensions.height) != null ? _b2 : 0) * origin[1];
  }
  return positionAbsolute;
}
function mergeAriaLabelConfig(partial) {
  return __spreadValues(__spreadValues({}, defaultAriaLabelConfig), partial || {});
}
function getPointerPosition(event2, { snapGrid = [0, 0], snapToGrid = false, transform: transform2, containerBounds }) {
  var _a2, _b2;
  const { x, y: y2 } = getEventPosition(event2);
  const pointerPos = pointToRendererPoint({ x: x - ((_a2 = containerBounds == null ? void 0 : containerBounds.left) != null ? _a2 : 0), y: y2 - ((_b2 = containerBounds == null ? void 0 : containerBounds.top) != null ? _b2 : 0) }, transform2);
  const { x: xSnapped, y: ySnapped } = snapToGrid ? snapPosition(pointerPos, snapGrid) : pointerPos;
  return __spreadValues({
    xSnapped,
    ySnapped
  }, pointerPos);
}
const getDimensions = (node) => ({
  width: node.offsetWidth,
  height: node.offsetHeight
});
const getHostForElement = (element) => {
  var _a2;
  return ((_a2 = element == null ? void 0 : element.getRootNode) == null ? void 0 : _a2.call(element)) || (window == null ? void 0 : window.document);
};
const inputTags = ["INPUT", "SELECT", "TEXTAREA"];
function isInputDOMNode(event2) {
  var _a2, _b2;
  const target = ((_b2 = (_a2 = event2.composedPath) == null ? void 0 : _a2.call(event2)) == null ? void 0 : _b2[0]) || event2.target;
  if ((target == null ? void 0 : target.nodeType) !== 1)
    return false;
  const isInput = inputTags.includes(target.nodeName) || target.hasAttribute("contenteditable");
  return isInput || !!target.closest(".nokey");
}
const isMouseEvent = (event2) => "clientX" in event2;
const getEventPosition = (event2, bounds) => {
  var _a2, _b2, _c2, _d2;
  const isMouse = isMouseEvent(event2);
  const evtX = isMouse ? event2.clientX : (_a2 = event2.touches) == null ? void 0 : _a2[0].clientX;
  const evtY = isMouse ? event2.clientY : (_b2 = event2.touches) == null ? void 0 : _b2[0].clientY;
  return {
    x: evtX - ((_c2 = bounds == null ? void 0 : bounds.left) != null ? _c2 : 0),
    y: evtY - ((_d2 = bounds == null ? void 0 : bounds.top) != null ? _d2 : 0)
  };
};
const getHandleBounds = (type, nodeElement, nodeBounds, zoom2, nodeId) => {
  const handles = nodeElement.querySelectorAll(`.${type}`);
  if (!handles || !handles.length) {
    return null;
  }
  return Array.from(handles).map((handle) => {
    const handleBounds = handle.getBoundingClientRect();
    return __spreadValues({
      id: handle.getAttribute("data-handleid"),
      type,
      nodeId,
      position: handle.getAttribute("data-handlepos"),
      x: (handleBounds.left - nodeBounds.left) / zoom2,
      y: (handleBounds.top - nodeBounds.top) / zoom2
    }, getDimensions(handle));
  });
};
function getBezierEdgeCenter({ sourceX, sourceY, targetX, targetY, sourceControlX, sourceControlY, targetControlX, targetControlY }) {
  const centerX = sourceX * 0.125 + sourceControlX * 0.375 + targetControlX * 0.375 + targetX * 0.125;
  const centerY = sourceY * 0.125 + sourceControlY * 0.375 + targetControlY * 0.375 + targetY * 0.125;
  const offsetX = Math.abs(centerX - sourceX);
  const offsetY = Math.abs(centerY - sourceY);
  return [centerX, centerY, offsetX, offsetY];
}
function calculateControlOffset(distance2, curvature) {
  if (distance2 >= 0) {
    return 0.5 * distance2;
  }
  return curvature * 25 * Math.sqrt(-distance2);
}
function getControlWithCurvature({ pos, x1, y1, x2, y2, c }) {
  switch (pos) {
    case Position.Left:
      return [x1 - calculateControlOffset(x1 - x2, c), y1];
    case Position.Right:
      return [x1 + calculateControlOffset(x2 - x1, c), y1];
    case Position.Top:
      return [x1, y1 - calculateControlOffset(y1 - y2, c)];
    case Position.Bottom:
      return [x1, y1 + calculateControlOffset(y2 - y1, c)];
  }
}
function getBezierPath({ sourceX, sourceY, sourcePosition = Position.Bottom, targetX, targetY, targetPosition = Position.Top, curvature = 0.25 }) {
  const [sourceControlX, sourceControlY] = getControlWithCurvature({
    pos: sourcePosition,
    x1: sourceX,
    y1: sourceY,
    x2: targetX,
    y2: targetY,
    c: curvature
  });
  const [targetControlX, targetControlY] = getControlWithCurvature({
    pos: targetPosition,
    x1: targetX,
    y1: targetY,
    x2: sourceX,
    y2: sourceY,
    c: curvature
  });
  const [labelX, labelY, offsetX, offsetY] = getBezierEdgeCenter({
    sourceX,
    sourceY,
    targetX,
    targetY,
    sourceControlX,
    sourceControlY,
    targetControlX,
    targetControlY
  });
  return [
    `M${sourceX},${sourceY} C${sourceControlX},${sourceControlY} ${targetControlX},${targetControlY} ${targetX},${targetY}`,
    labelX,
    labelY,
    offsetX,
    offsetY
  ];
}
function getEdgeCenter({ sourceX, sourceY, targetX, targetY }) {
  const xOffset = Math.abs(targetX - sourceX) / 2;
  const centerX = targetX < sourceX ? targetX + xOffset : targetX - xOffset;
  const yOffset = Math.abs(targetY - sourceY) / 2;
  const centerY = targetY < sourceY ? targetY + yOffset : targetY - yOffset;
  return [centerX, centerY, xOffset, yOffset];
}
function getElevatedEdgeZIndex({ sourceNode, targetNode, selected = false, zIndex, elevateOnSelect = false }) {
  if (zIndex !== void 0) {
    return zIndex;
  }
  const edgeZ = elevateOnSelect && selected ? 1e3 : 0;
  const nodeZ = Math.max(sourceNode.parentId ? sourceNode.internals.z : 0, targetNode.parentId ? targetNode.internals.z : 0);
  return edgeZ + nodeZ;
}
function isEdgeVisible({ sourceNode, targetNode, width, height, transform: transform2 }) {
  const edgeBox = getBoundsOfBoxes(nodeToBox(sourceNode), nodeToBox(targetNode));
  if (edgeBox.x === edgeBox.x2) {
    edgeBox.x2 += 1;
  }
  if (edgeBox.y === edgeBox.y2) {
    edgeBox.y2 += 1;
  }
  const viewRect = {
    x: -transform2[0] / transform2[2],
    y: -transform2[1] / transform2[2],
    width: width / transform2[2],
    height: height / transform2[2]
  };
  return getOverlappingArea(viewRect, boxToRect(edgeBox)) > 0;
}
const getEdgeId = ({ source: source2, sourceHandle, target, targetHandle }) => `xy-edge__${source2}${sourceHandle || ""}-${target}${targetHandle || ""}`;
const connectionExists = (edge, edges) => {
  return edges.some((el) => el.source === edge.source && el.target === edge.target && (el.sourceHandle === edge.sourceHandle || !el.sourceHandle && !edge.sourceHandle) && (el.targetHandle === edge.targetHandle || !el.targetHandle && !edge.targetHandle));
};
const addEdge = (edgeParams, edges) => {
  if (!edgeParams.source || !edgeParams.target) {
    return edges;
  }
  let edge;
  if (isEdgeBase(edgeParams)) {
    edge = __spreadValues({}, edgeParams);
  } else {
    edge = __spreadProps(__spreadValues({}, edgeParams), {
      id: getEdgeId(edgeParams)
    });
  }
  if (connectionExists(edge, edges)) {
    return edges;
  }
  if (edge.sourceHandle === null) {
    delete edge.sourceHandle;
  }
  if (edge.targetHandle === null) {
    delete edge.targetHandle;
  }
  return edges.concat(edge);
};
function getStraightPath({ sourceX, sourceY, targetX, targetY }) {
  const [labelX, labelY, offsetX, offsetY] = getEdgeCenter({
    sourceX,
    sourceY,
    targetX,
    targetY
  });
  return [`M ${sourceX},${sourceY}L ${targetX},${targetY}`, labelX, labelY, offsetX, offsetY];
}
const handleDirections = {
  [Position.Left]: { x: -1, y: 0 },
  [Position.Right]: { x: 1, y: 0 },
  [Position.Top]: { x: 0, y: -1 },
  [Position.Bottom]: { x: 0, y: 1 }
};
const getDirection = ({ source: source2, sourcePosition = Position.Bottom, target }) => {
  if (sourcePosition === Position.Left || sourcePosition === Position.Right) {
    return source2.x < target.x ? { x: 1, y: 0 } : { x: -1, y: 0 };
  }
  return source2.y < target.y ? { x: 0, y: 1 } : { x: 0, y: -1 };
};
const distance = (a, b2) => Math.sqrt(Math.pow(b2.x - a.x, 2) + Math.pow(b2.y - a.y, 2));
function getPoints({ source: source2, sourcePosition = Position.Bottom, target, targetPosition = Position.Top, center, offset }) {
  var _a2, _b2;
  const sourceDir = handleDirections[sourcePosition];
  const targetDir = handleDirections[targetPosition];
  const sourceGapped = { x: source2.x + sourceDir.x * offset, y: source2.y + sourceDir.y * offset };
  const targetGapped = { x: target.x + targetDir.x * offset, y: target.y + targetDir.y * offset };
  const dir = getDirection({
    source: sourceGapped,
    sourcePosition,
    target: targetGapped
  });
  const dirAccessor = dir.x !== 0 ? "x" : "y";
  const currDir = dir[dirAccessor];
  let points = [];
  let centerX, centerY;
  const sourceGapOffset = { x: 0, y: 0 };
  const targetGapOffset = { x: 0, y: 0 };
  const [defaultCenterX, defaultCenterY, defaultOffsetX, defaultOffsetY] = getEdgeCenter({
    sourceX: source2.x,
    sourceY: source2.y,
    targetX: target.x,
    targetY: target.y
  });
  if (sourceDir[dirAccessor] * targetDir[dirAccessor] === -1) {
    centerX = (_a2 = center.x) != null ? _a2 : defaultCenterX;
    centerY = (_b2 = center.y) != null ? _b2 : defaultCenterY;
    const verticalSplit = [
      { x: centerX, y: sourceGapped.y },
      { x: centerX, y: targetGapped.y }
    ];
    const horizontalSplit = [
      { x: sourceGapped.x, y: centerY },
      { x: targetGapped.x, y: centerY }
    ];
    if (sourceDir[dirAccessor] === currDir) {
      points = dirAccessor === "x" ? verticalSplit : horizontalSplit;
    } else {
      points = dirAccessor === "x" ? horizontalSplit : verticalSplit;
    }
  } else {
    const sourceTarget = [{ x: sourceGapped.x, y: targetGapped.y }];
    const targetSource = [{ x: targetGapped.x, y: sourceGapped.y }];
    if (dirAccessor === "x") {
      points = sourceDir.x === currDir ? targetSource : sourceTarget;
    } else {
      points = sourceDir.y === currDir ? sourceTarget : targetSource;
    }
    if (sourcePosition === targetPosition) {
      const diff = Math.abs(source2[dirAccessor] - target[dirAccessor]);
      if (diff <= offset) {
        const gapOffset = Math.min(offset - 1, offset - diff);
        if (sourceDir[dirAccessor] === currDir) {
          sourceGapOffset[dirAccessor] = (sourceGapped[dirAccessor] > source2[dirAccessor] ? -1 : 1) * gapOffset;
        } else {
          targetGapOffset[dirAccessor] = (targetGapped[dirAccessor] > target[dirAccessor] ? -1 : 1) * gapOffset;
        }
      }
    }
    if (sourcePosition !== targetPosition) {
      const dirAccessorOpposite = dirAccessor === "x" ? "y" : "x";
      const isSameDir = sourceDir[dirAccessor] === targetDir[dirAccessorOpposite];
      const sourceGtTargetOppo = sourceGapped[dirAccessorOpposite] > targetGapped[dirAccessorOpposite];
      const sourceLtTargetOppo = sourceGapped[dirAccessorOpposite] < targetGapped[dirAccessorOpposite];
      const flipSourceTarget = sourceDir[dirAccessor] === 1 && (!isSameDir && sourceGtTargetOppo || isSameDir && sourceLtTargetOppo) || sourceDir[dirAccessor] !== 1 && (!isSameDir && sourceLtTargetOppo || isSameDir && sourceGtTargetOppo);
      if (flipSourceTarget) {
        points = dirAccessor === "x" ? sourceTarget : targetSource;
      }
    }
    const sourceGapPoint = { x: sourceGapped.x + sourceGapOffset.x, y: sourceGapped.y + sourceGapOffset.y };
    const targetGapPoint = { x: targetGapped.x + targetGapOffset.x, y: targetGapped.y + targetGapOffset.y };
    const maxXDistance = Math.max(Math.abs(sourceGapPoint.x - points[0].x), Math.abs(targetGapPoint.x - points[0].x));
    const maxYDistance = Math.max(Math.abs(sourceGapPoint.y - points[0].y), Math.abs(targetGapPoint.y - points[0].y));
    if (maxXDistance >= maxYDistance) {
      centerX = (sourceGapPoint.x + targetGapPoint.x) / 2;
      centerY = points[0].y;
    } else {
      centerX = points[0].x;
      centerY = (sourceGapPoint.y + targetGapPoint.y) / 2;
    }
  }
  const pathPoints = [
    source2,
    { x: sourceGapped.x + sourceGapOffset.x, y: sourceGapped.y + sourceGapOffset.y },
    ...points,
    { x: targetGapped.x + targetGapOffset.x, y: targetGapped.y + targetGapOffset.y },
    target
  ];
  return [pathPoints, centerX, centerY, defaultOffsetX, defaultOffsetY];
}
function getBend(a, b2, c, size) {
  const bendSize = Math.min(distance(a, b2) / 2, distance(b2, c) / 2, size);
  const { x, y: y2 } = b2;
  if (a.x === x && x === c.x || a.y === y2 && y2 === c.y) {
    return `L${x} ${y2}`;
  }
  if (a.y === y2) {
    const xDir2 = a.x < c.x ? -1 : 1;
    const yDir2 = a.y < c.y ? 1 : -1;
    return `L ${x + bendSize * xDir2},${y2}Q ${x},${y2} ${x},${y2 + bendSize * yDir2}`;
  }
  const xDir = a.x < c.x ? 1 : -1;
  const yDir = a.y < c.y ? -1 : 1;
  return `L ${x},${y2 + bendSize * yDir}Q ${x},${y2} ${x + bendSize * xDir},${y2}`;
}
function getSmoothStepPath({ sourceX, sourceY, sourcePosition = Position.Bottom, targetX, targetY, targetPosition = Position.Top, borderRadius = 5, centerX, centerY, offset = 20 }) {
  const [points, labelX, labelY, offsetX, offsetY] = getPoints({
    source: { x: sourceX, y: sourceY },
    sourcePosition,
    target: { x: targetX, y: targetY },
    targetPosition,
    center: { x: centerX, y: centerY },
    offset
  });
  const path = points.reduce((res, p, i) => {
    let segment = "";
    if (i > 0 && i < points.length - 1) {
      segment = getBend(points[i - 1], p, points[i + 1], borderRadius);
    } else {
      segment = `${i === 0 ? "M" : "L"}${p.x} ${p.y}`;
    }
    res += segment;
    return res;
  }, "");
  return [path, labelX, labelY, offsetX, offsetY];
}
function isNodeInitialized(node) {
  var _a2;
  return node && !!(node.internals.handleBounds || ((_a2 = node.handles) == null ? void 0 : _a2.length)) && !!(node.measured.width || node.width || node.initialWidth);
}
function getEdgePosition(params) {
  var _a2, _b2, _c2, _d2, _e2;
  const { sourceNode, targetNode } = params;
  if (!isNodeInitialized(sourceNode) || !isNodeInitialized(targetNode)) {
    return null;
  }
  const sourceHandleBounds = sourceNode.internals.handleBounds || toHandleBounds(sourceNode.handles);
  const targetHandleBounds = targetNode.internals.handleBounds || toHandleBounds(targetNode.handles);
  const sourceHandle = getHandle$1((_a2 = sourceHandleBounds == null ? void 0 : sourceHandleBounds.source) != null ? _a2 : [], params.sourceHandle);
  const targetHandle = getHandle$1(
    // when connection type is loose we can define all handles as sources and connect source -> source
    params.connectionMode === ConnectionMode.Strict ? (_b2 = targetHandleBounds == null ? void 0 : targetHandleBounds.target) != null ? _b2 : [] : ((_c2 = targetHandleBounds == null ? void 0 : targetHandleBounds.target) != null ? _c2 : []).concat((_d2 = targetHandleBounds == null ? void 0 : targetHandleBounds.source) != null ? _d2 : []),
    params.targetHandle
  );
  if (!sourceHandle || !targetHandle) {
    (_e2 = params.onError) == null ? void 0 : _e2.call(params, "008", errorMessages["error008"](!sourceHandle ? "source" : "target", {
      id: params.id,
      sourceHandle: params.sourceHandle,
      targetHandle: params.targetHandle
    }));
    return null;
  }
  const sourcePosition = (sourceHandle == null ? void 0 : sourceHandle.position) || Position.Bottom;
  const targetPosition = (targetHandle == null ? void 0 : targetHandle.position) || Position.Top;
  const source2 = getHandlePosition(sourceNode, sourceHandle, sourcePosition);
  const target = getHandlePosition(targetNode, targetHandle, targetPosition);
  return {
    sourceX: source2.x,
    sourceY: source2.y,
    targetX: target.x,
    targetY: target.y,
    sourcePosition,
    targetPosition
  };
}
function toHandleBounds(handles) {
  var _a2, _b2;
  if (!handles) {
    return null;
  }
  const source2 = [];
  const target = [];
  for (const handle of handles) {
    handle.width = (_a2 = handle.width) != null ? _a2 : 1;
    handle.height = (_b2 = handle.height) != null ? _b2 : 1;
    if (handle.type === "source") {
      source2.push(handle);
    } else if (handle.type === "target") {
      target.push(handle);
    }
  }
  return {
    source: source2,
    target
  };
}
function getHandlePosition(node, handle, fallbackPosition = Position.Left, center = false) {
  var _a2, _b2, _c2;
  const x = ((_a2 = handle == null ? void 0 : handle.x) != null ? _a2 : 0) + node.internals.positionAbsolute.x;
  const y2 = ((_b2 = handle == null ? void 0 : handle.y) != null ? _b2 : 0) + node.internals.positionAbsolute.y;
  const { width, height } = handle != null ? handle : getNodeDimensions(node);
  if (center) {
    return { x: x + width / 2, y: y2 + height / 2 };
  }
  const position = (_c2 = handle == null ? void 0 : handle.position) != null ? _c2 : fallbackPosition;
  switch (position) {
    case Position.Top:
      return { x: x + width / 2, y: y2 };
    case Position.Right:
      return { x: x + width, y: y2 + height / 2 };
    case Position.Bottom:
      return { x: x + width / 2, y: y2 + height };
    case Position.Left:
      return { x, y: y2 + height / 2 };
  }
}
function getHandle$1(bounds, handleId) {
  if (!bounds) {
    return null;
  }
  return (!handleId ? bounds[0] : bounds.find((d2) => d2.id === handleId)) || null;
}
function getMarkerId(marker, id2) {
  if (!marker) {
    return "";
  }
  if (typeof marker === "string") {
    return marker;
  }
  const idPrefix = id2 ? `${id2}__` : "";
  return `${idPrefix}${Object.keys(marker).sort().map((key2) => `${key2}=${marker[key2]}`).join("&")}`;
}
function createMarkerIds(edges, { id: id2, defaultColor, defaultMarkerStart, defaultMarkerEnd }) {
  const ids = /* @__PURE__ */ new Set();
  return edges.reduce((markers, edge) => {
    [edge.markerStart || defaultMarkerStart, edge.markerEnd || defaultMarkerEnd].forEach((marker) => {
      if (marker && typeof marker === "object") {
        const markerId = getMarkerId(marker, id2);
        if (!ids.has(markerId)) {
          markers.push(__spreadValues({ id: markerId, color: marker.color || defaultColor }, marker));
          ids.add(markerId);
        }
      }
    });
    return markers;
  }, []).sort((a, b2) => a.id.localeCompare(b2.id));
}
const defaultOptions = {
  nodeOrigin: [0, 0],
  nodeExtent: infiniteExtent,
  elevateNodesOnSelect: true,
  defaults: {}
};
const adoptUserNodesDefaultOptions = __spreadProps(__spreadValues({}, defaultOptions), {
  checkEquality: true
});
function mergeObjects(base, incoming) {
  const result = __spreadValues({}, base);
  for (const key2 in incoming) {
    if (incoming[key2] !== void 0) {
      result[key2] = incoming[key2];
    }
  }
  return result;
}
function updateAbsolutePositions(nodeLookup, parentLookup, options) {
  const _options2 = mergeObjects(defaultOptions, options);
  for (const node of nodeLookup.values()) {
    if (node.parentId) {
      updateChildNode(node, nodeLookup, parentLookup, _options2);
    } else {
      const positionWithOrigin = getNodePositionWithOrigin(node, _options2.nodeOrigin);
      const extent = isCoordinateExtent(node.extent) ? node.extent : _options2.nodeExtent;
      const clampedPosition = clampPosition(positionWithOrigin, extent, getNodeDimensions(node));
      node.internals.positionAbsolute = clampedPosition;
    }
  }
}
function adoptUserNodes(nodes, nodeLookup, parentLookup, options) {
  var _a2, _b2;
  const _options2 = mergeObjects(adoptUserNodesDefaultOptions, options);
  let nodesInitialized = nodes.length > 0;
  const tmpLookup = new Map(nodeLookup);
  const selectedNodeZ = (_options2 == null ? void 0 : _options2.elevateNodesOnSelect) ? 1e3 : 0;
  nodeLookup.clear();
  parentLookup.clear();
  for (const userNode of nodes) {
    let internalNode = tmpLookup.get(userNode.id);
    if (_options2.checkEquality && userNode === (internalNode == null ? void 0 : internalNode.internals.userNode)) {
      nodeLookup.set(userNode.id, internalNode);
    } else {
      const positionWithOrigin = getNodePositionWithOrigin(userNode, _options2.nodeOrigin);
      const extent = isCoordinateExtent(userNode.extent) ? userNode.extent : _options2.nodeExtent;
      const clampedPosition = clampPosition(positionWithOrigin, extent, getNodeDimensions(userNode));
      internalNode = __spreadProps(__spreadValues(__spreadValues({}, _options2.defaults), userNode), {
        measured: {
          width: (_a2 = userNode.measured) == null ? void 0 : _a2.width,
          height: (_b2 = userNode.measured) == null ? void 0 : _b2.height
        },
        internals: {
          positionAbsolute: clampedPosition,
          // if user re-initializes the node or removes `measured` for whatever reason, we reset the handleBounds so that the node gets re-measured
          handleBounds: !userNode.measured ? void 0 : internalNode == null ? void 0 : internalNode.internals.handleBounds,
          z: calculateZ(userNode, selectedNodeZ),
          userNode
        }
      });
      nodeLookup.set(userNode.id, internalNode);
    }
    if ((internalNode.measured === void 0 || internalNode.measured.width === void 0 || internalNode.measured.height === void 0) && !internalNode.hidden) {
      nodesInitialized = false;
    }
    if (userNode.parentId) {
      updateChildNode(internalNode, nodeLookup, parentLookup, options);
    }
  }
  return nodesInitialized;
}
function updateParentLookup(node, parentLookup) {
  if (!node.parentId) {
    return;
  }
  const childNodes = parentLookup.get(node.parentId);
  if (childNodes) {
    childNodes.set(node.id, node);
  } else {
    parentLookup.set(node.parentId, /* @__PURE__ */ new Map([[node.id, node]]));
  }
}
function updateChildNode(node, nodeLookup, parentLookup, options) {
  const { elevateNodesOnSelect, nodeOrigin, nodeExtent } = mergeObjects(defaultOptions, options);
  const parentId = node.parentId;
  const parentNode = nodeLookup.get(parentId);
  if (!parentNode) {
    console.warn(`Parent node ${parentId} not found. Please make sure that parent nodes are in front of their child nodes in the nodes array.`);
    return;
  }
  updateParentLookup(node, parentLookup);
  const selectedNodeZ = elevateNodesOnSelect ? 1e3 : 0;
  const { x, y: y2, z: z2 } = calculateChildXYZ(node, parentNode, nodeOrigin, nodeExtent, selectedNodeZ);
  const { positionAbsolute } = node.internals;
  const positionChanged = x !== positionAbsolute.x || y2 !== positionAbsolute.y;
  if (positionChanged || z2 !== node.internals.z) {
    nodeLookup.set(node.id, __spreadProps(__spreadValues({}, node), {
      internals: __spreadProps(__spreadValues({}, node.internals), {
        positionAbsolute: positionChanged ? { x, y: y2 } : positionAbsolute,
        z: z2
      })
    }));
  }
}
function calculateZ(node, selectedNodeZ) {
  return (isNumeric(node.zIndex) ? node.zIndex : 0) + (node.selected ? selectedNodeZ : 0);
}
function calculateChildXYZ(childNode, parentNode, nodeOrigin, nodeExtent, selectedNodeZ) {
  var _a2;
  const { x: parentX, y: parentY } = parentNode.internals.positionAbsolute;
  const childDimensions = getNodeDimensions(childNode);
  const positionWithOrigin = getNodePositionWithOrigin(childNode, nodeOrigin);
  const clampedPosition = isCoordinateExtent(childNode.extent) ? clampPosition(positionWithOrigin, childNode.extent, childDimensions) : positionWithOrigin;
  let absolutePosition = clampPosition({ x: parentX + clampedPosition.x, y: parentY + clampedPosition.y }, nodeExtent, childDimensions);
  if (childNode.extent === "parent") {
    absolutePosition = clampPositionToParent(absolutePosition, childDimensions, parentNode);
  }
  const childZ = calculateZ(childNode, selectedNodeZ);
  const parentZ = (_a2 = parentNode.internals.z) != null ? _a2 : 0;
  return {
    x: absolutePosition.x,
    y: absolutePosition.y,
    z: parentZ >= childZ ? parentZ + 1 : childZ
  };
}
function handleExpandParent(children2, nodeLookup, parentLookup, nodeOrigin = [0, 0]) {
  var _a2, _b2;
  const changes = [];
  const parentExpansions = /* @__PURE__ */ new Map();
  for (const child2 of children2) {
    const parent = nodeLookup.get(child2.parentId);
    if (!parent) {
      continue;
    }
    const parentRect = (_b2 = (_a2 = parentExpansions.get(child2.parentId)) == null ? void 0 : _a2.expandedRect) != null ? _b2 : nodeToRect(parent);
    const expandedRect = getBoundsOfRects(parentRect, child2.rect);
    parentExpansions.set(child2.parentId, { expandedRect, parent });
  }
  if (parentExpansions.size > 0) {
    parentExpansions.forEach(({ expandedRect, parent }, parentId) => {
      var _a3, _b3;
      const positionAbsolute = parent.internals.positionAbsolute;
      const dimensions = getNodeDimensions(parent);
      const origin = (_a3 = parent.origin) != null ? _a3 : nodeOrigin;
      const xChange = expandedRect.x < positionAbsolute.x ? Math.round(Math.abs(positionAbsolute.x - expandedRect.x)) : 0;
      const yChange = expandedRect.y < positionAbsolute.y ? Math.round(Math.abs(positionAbsolute.y - expandedRect.y)) : 0;
      const newWidth = Math.max(dimensions.width, Math.round(expandedRect.width));
      const newHeight = Math.max(dimensions.height, Math.round(expandedRect.height));
      const widthChange = (newWidth - dimensions.width) * origin[0];
      const heightChange = (newHeight - dimensions.height) * origin[1];
      if (xChange > 0 || yChange > 0 || widthChange || heightChange) {
        changes.push({
          id: parentId,
          type: "position",
          position: {
            x: parent.position.x - xChange + widthChange,
            y: parent.position.y - yChange + heightChange
          }
        });
        (_b3 = parentLookup.get(parentId)) == null ? void 0 : _b3.forEach((childNode) => {
          if (!children2.some((child2) => child2.id === childNode.id)) {
            changes.push({
              id: childNode.id,
              type: "position",
              position: {
                x: childNode.position.x + xChange,
                y: childNode.position.y + yChange
              }
            });
          }
        });
      }
      if (dimensions.width < expandedRect.width || dimensions.height < expandedRect.height || xChange || yChange) {
        changes.push({
          id: parentId,
          type: "dimensions",
          setAttributes: true,
          dimensions: {
            width: newWidth + (xChange ? origin[0] * xChange - widthChange : 0),
            height: newHeight + (yChange ? origin[1] * yChange - heightChange : 0)
          }
        });
      }
    });
  }
  return changes;
}
function updateNodeInternals(updates, nodeLookup, parentLookup, domNode, nodeOrigin, nodeExtent) {
  const viewportNode = domNode == null ? void 0 : domNode.querySelector(".xyflow__viewport");
  let updatedInternals = false;
  if (!viewportNode) {
    return { changes: [], updatedInternals };
  }
  const changes = [];
  const style = window.getComputedStyle(viewportNode);
  const { m22: zoom2 } = new window.DOMMatrixReadOnly(style.transform);
  const parentExpandChildren = [];
  for (const update2 of updates.values()) {
    const node = nodeLookup.get(update2.id);
    if (!node) {
      continue;
    }
    if (node.hidden) {
      nodeLookup.set(node.id, __spreadProps(__spreadValues({}, node), {
        internals: __spreadProps(__spreadValues({}, node.internals), {
          handleBounds: void 0
        })
      }));
      updatedInternals = true;
      continue;
    }
    const dimensions = getDimensions(update2.nodeElement);
    const dimensionChanged = node.measured.width !== dimensions.width || node.measured.height !== dimensions.height;
    const doUpdate = !!(dimensions.width && dimensions.height && (dimensionChanged || !node.internals.handleBounds || update2.force));
    if (doUpdate) {
      const nodeBounds = update2.nodeElement.getBoundingClientRect();
      const extent = isCoordinateExtent(node.extent) ? node.extent : nodeExtent;
      let { positionAbsolute } = node.internals;
      if (node.parentId && node.extent === "parent") {
        positionAbsolute = clampPositionToParent(positionAbsolute, dimensions, nodeLookup.get(node.parentId));
      } else if (extent) {
        positionAbsolute = clampPosition(positionAbsolute, extent, dimensions);
      }
      const newNode = __spreadProps(__spreadValues({}, node), {
        measured: dimensions,
        internals: __spreadProps(__spreadValues({}, node.internals), {
          positionAbsolute,
          handleBounds: {
            source: getHandleBounds("source", update2.nodeElement, nodeBounds, zoom2, node.id),
            target: getHandleBounds("target", update2.nodeElement, nodeBounds, zoom2, node.id)
          }
        })
      });
      nodeLookup.set(node.id, newNode);
      if (node.parentId) {
        updateChildNode(newNode, nodeLookup, parentLookup, { nodeOrigin });
      }
      updatedInternals = true;
      if (dimensionChanged) {
        changes.push({
          id: node.id,
          type: "dimensions",
          dimensions
        });
        if (node.expandParent && node.parentId) {
          parentExpandChildren.push({
            id: node.id,
            parentId: node.parentId,
            rect: nodeToRect(newNode, nodeOrigin)
          });
        }
      }
    }
  }
  if (parentExpandChildren.length > 0) {
    const parentExpandChanges = handleExpandParent(parentExpandChildren, nodeLookup, parentLookup, nodeOrigin);
    changes.push(...parentExpandChanges);
  }
  return { changes, updatedInternals };
}
function panBy(_0) {
  return __async(this, arguments, function* ({ delta, panZoom, transform: transform2, translateExtent, width, height }) {
    if (!panZoom || !delta.x && !delta.y) {
      return Promise.resolve(false);
    }
    const nextViewport = yield panZoom.setViewportConstrained({
      x: transform2[0] + delta.x,
      y: transform2[1] + delta.y,
      zoom: transform2[2]
    }, [
      [0, 0],
      [width, height]
    ], translateExtent);
    const transformChanged = !!nextViewport && (nextViewport.x !== transform2[0] || nextViewport.y !== transform2[1] || nextViewport.k !== transform2[2]);
    return Promise.resolve(transformChanged);
  });
}
function addConnectionToLookup(type, connection, connectionKey, connectionLookup, nodeId, handleId) {
  let key2 = nodeId;
  const nodeMap = connectionLookup.get(key2) || /* @__PURE__ */ new Map();
  connectionLookup.set(key2, nodeMap.set(connectionKey, connection));
  key2 = `${nodeId}-${type}`;
  const typeMap = connectionLookup.get(key2) || /* @__PURE__ */ new Map();
  connectionLookup.set(key2, typeMap.set(connectionKey, connection));
  if (handleId) {
    key2 = `${nodeId}-${type}-${handleId}`;
    const handleMap = connectionLookup.get(key2) || /* @__PURE__ */ new Map();
    connectionLookup.set(key2, handleMap.set(connectionKey, connection));
  }
}
function updateConnectionLookup(connectionLookup, edgeLookup, edges) {
  connectionLookup.clear();
  edgeLookup.clear();
  for (const edge of edges) {
    const { source: sourceNode, target: targetNode, sourceHandle = null, targetHandle = null } = edge;
    const connection = { edgeId: edge.id, source: sourceNode, target: targetNode, sourceHandle, targetHandle };
    const sourceKey = `${sourceNode}-${sourceHandle}--${targetNode}-${targetHandle}`;
    const targetKey = `${targetNode}-${targetHandle}--${sourceNode}-${sourceHandle}`;
    addConnectionToLookup("source", connection, targetKey, connectionLookup, sourceNode, sourceHandle);
    addConnectionToLookup("target", connection, sourceKey, connectionLookup, targetNode, targetHandle);
    edgeLookup.set(edge.id, edge);
  }
}
function isParentSelected(node, nodeLookup) {
  if (!node.parentId) {
    return false;
  }
  const parentNode = nodeLookup.get(node.parentId);
  if (!parentNode) {
    return false;
  }
  if (parentNode.selected) {
    return true;
  }
  return isParentSelected(parentNode, nodeLookup);
}
function hasSelector(target, selector2, domNode) {
  var _a2;
  let current = target;
  do {
    if ((_a2 = current == null ? void 0 : current.matches) == null ? void 0 : _a2.call(current, selector2))
      return true;
    if (current === domNode)
      return false;
    current = current == null ? void 0 : current.parentElement;
  } while (current);
  return false;
}
function getDragItems(nodeLookup, nodesDraggable, mousePos, nodeId) {
  var _a2, _b2;
  const dragItems = /* @__PURE__ */ new Map();
  for (const [id2, node] of nodeLookup) {
    if ((node.selected || node.id === nodeId) && (!node.parentId || !isParentSelected(node, nodeLookup)) && (node.draggable || nodesDraggable && typeof node.draggable === "undefined")) {
      const internalNode = nodeLookup.get(id2);
      if (internalNode) {
        dragItems.set(id2, {
          id: id2,
          position: internalNode.position || { x: 0, y: 0 },
          distance: {
            x: mousePos.x - internalNode.internals.positionAbsolute.x,
            y: mousePos.y - internalNode.internals.positionAbsolute.y
          },
          extent: internalNode.extent,
          parentId: internalNode.parentId,
          origin: internalNode.origin,
          expandParent: internalNode.expandParent,
          internals: {
            positionAbsolute: internalNode.internals.positionAbsolute || { x: 0, y: 0 }
          },
          measured: {
            width: (_a2 = internalNode.measured.width) != null ? _a2 : 0,
            height: (_b2 = internalNode.measured.height) != null ? _b2 : 0
          }
        });
      }
    }
  }
  return dragItems;
}
function getEventHandlerParams({ nodeId, dragItems, nodeLookup, dragging = true }) {
  var _a2, _b2, _c2;
  const nodesFromDragItems = [];
  for (const [id2, dragItem] of dragItems) {
    const node2 = (_a2 = nodeLookup.get(id2)) == null ? void 0 : _a2.internals.userNode;
    if (node2) {
      nodesFromDragItems.push(__spreadProps(__spreadValues({}, node2), {
        position: dragItem.position,
        dragging
      }));
    }
  }
  if (!nodeId) {
    return [nodesFromDragItems[0], nodesFromDragItems];
  }
  const node = (_b2 = nodeLookup.get(nodeId)) == null ? void 0 : _b2.internals.userNode;
  return [
    !node ? nodesFromDragItems[0] : __spreadProps(__spreadValues({}, node), {
      position: ((_c2 = dragItems.get(nodeId)) == null ? void 0 : _c2.position) || node.position,
      dragging
    }),
    nodesFromDragItems
  ];
}
function XYDrag({ onNodeMouseDown, getStoreItems, onDragStart, onDrag, onDragStop }) {
  let lastPos = { x: null, y: null };
  let autoPanId = 0;
  let dragItems = /* @__PURE__ */ new Map();
  let autoPanStarted = false;
  let mousePosition = { x: 0, y: 0 };
  let containerBounds = null;
  let dragStarted = false;
  let d3Selection = null;
  let abortDrag = false;
  let nodePositionsChanged = false;
  function update2({ noDragClassName, handleSelector, domNode, isSelectable, nodeId, nodeClickDistance = 0 }) {
    d3Selection = select(domNode);
    function updateNodes({ x, y: y2 }, dragEvent) {
      const { nodeLookup, nodeExtent, snapGrid, snapToGrid, nodeOrigin, onNodeDrag, onSelectionDrag, onError, updateNodePositions } = getStoreItems();
      lastPos = { x, y: y2 };
      let hasChange = false;
      let nodesBox = { x: 0, y: 0, x2: 0, y2: 0 };
      if (dragItems.size > 1 && nodeExtent) {
        const rect = getInternalNodesBounds(dragItems);
        nodesBox = rectToBox(rect);
      }
      for (const [id2, dragItem] of dragItems) {
        if (!nodeLookup.has(id2)) {
          continue;
        }
        let nextPosition = { x: x - dragItem.distance.x, y: y2 - dragItem.distance.y };
        if (snapToGrid) {
          nextPosition = snapPosition(nextPosition, snapGrid);
        }
        let adjustedNodeExtent = [
          [nodeExtent[0][0], nodeExtent[0][1]],
          [nodeExtent[1][0], nodeExtent[1][1]]
        ];
        if (dragItems.size > 1 && nodeExtent && !dragItem.extent) {
          const { positionAbsolute: positionAbsolute2 } = dragItem.internals;
          const x1 = positionAbsolute2.x - nodesBox.x + nodeExtent[0][0];
          const x2 = positionAbsolute2.x + dragItem.measured.width - nodesBox.x2 + nodeExtent[1][0];
          const y1 = positionAbsolute2.y - nodesBox.y + nodeExtent[0][1];
          const y22 = positionAbsolute2.y + dragItem.measured.height - nodesBox.y2 + nodeExtent[1][1];
          adjustedNodeExtent = [
            [x1, y1],
            [x2, y22]
          ];
        }
        const { position, positionAbsolute } = calculateNodePosition({
          nodeId: id2,
          nextPosition,
          nodeLookup,
          nodeExtent: adjustedNodeExtent,
          nodeOrigin,
          onError
        });
        hasChange = hasChange || dragItem.position.x !== position.x || dragItem.position.y !== position.y;
        dragItem.position = position;
        dragItem.internals.positionAbsolute = positionAbsolute;
      }
      nodePositionsChanged = nodePositionsChanged || hasChange;
      if (!hasChange) {
        return;
      }
      updateNodePositions(dragItems, true);
      if (dragEvent && (onDrag || onNodeDrag || !nodeId && onSelectionDrag)) {
        const [currentNode, currentNodes] = getEventHandlerParams({
          nodeId,
          dragItems,
          nodeLookup
        });
        onDrag == null ? void 0 : onDrag(dragEvent, dragItems, currentNode, currentNodes);
        onNodeDrag == null ? void 0 : onNodeDrag(dragEvent, currentNode, currentNodes);
        if (!nodeId) {
          onSelectionDrag == null ? void 0 : onSelectionDrag(dragEvent, currentNodes);
        }
      }
    }
    function autoPan() {
      return __async(this, null, function* () {
        var _a2, _b2;
        if (!containerBounds) {
          return;
        }
        const { transform: transform2, panBy: panBy2, autoPanSpeed, autoPanOnNodeDrag } = getStoreItems();
        if (!autoPanOnNodeDrag) {
          autoPanStarted = false;
          cancelAnimationFrame(autoPanId);
          return;
        }
        const [xMovement, yMovement] = calcAutoPan(mousePosition, containerBounds, autoPanSpeed);
        if (xMovement !== 0 || yMovement !== 0) {
          lastPos.x = ((_a2 = lastPos.x) != null ? _a2 : 0) - xMovement / transform2[2];
          lastPos.y = ((_b2 = lastPos.y) != null ? _b2 : 0) - yMovement / transform2[2];
          if (yield panBy2({ x: xMovement, y: yMovement })) {
            updateNodes(lastPos, null);
          }
        }
        autoPanId = requestAnimationFrame(autoPan);
      });
    }
    function startDrag(event2) {
      var _a2;
      const { nodeLookup, multiSelectionActive, nodesDraggable, transform: transform2, snapGrid, snapToGrid, selectNodesOnDrag, onNodeDragStart, onSelectionDragStart, unselectNodesAndEdges } = getStoreItems();
      dragStarted = true;
      if ((!selectNodesOnDrag || !isSelectable) && !multiSelectionActive && nodeId) {
        if (!((_a2 = nodeLookup.get(nodeId)) == null ? void 0 : _a2.selected)) {
          unselectNodesAndEdges();
        }
      }
      if (isSelectable && selectNodesOnDrag && nodeId) {
        onNodeMouseDown == null ? void 0 : onNodeMouseDown(nodeId);
      }
      const pointerPos = getPointerPosition(event2.sourceEvent, { transform: transform2, snapGrid, snapToGrid, containerBounds });
      lastPos = pointerPos;
      dragItems = getDragItems(nodeLookup, nodesDraggable, pointerPos, nodeId);
      if (dragItems.size > 0 && (onDragStart || onNodeDragStart || !nodeId && onSelectionDragStart)) {
        const [currentNode, currentNodes] = getEventHandlerParams({
          nodeId,
          dragItems,
          nodeLookup
        });
        onDragStart == null ? void 0 : onDragStart(event2.sourceEvent, dragItems, currentNode, currentNodes);
        onNodeDragStart == null ? void 0 : onNodeDragStart(event2.sourceEvent, currentNode, currentNodes);
        if (!nodeId) {
          onSelectionDragStart == null ? void 0 : onSelectionDragStart(event2.sourceEvent, currentNodes);
        }
      }
    }
    const d3DragInstance = drag$1().clickDistance(nodeClickDistance).on("start", (event2) => {
      const { domNode: domNode2, nodeDragThreshold, transform: transform2, snapGrid, snapToGrid } = getStoreItems();
      containerBounds = (domNode2 == null ? void 0 : domNode2.getBoundingClientRect()) || null;
      abortDrag = false;
      nodePositionsChanged = false;
      if (nodeDragThreshold === 0) {
        startDrag(event2);
      }
      const pointerPos = getPointerPosition(event2.sourceEvent, { transform: transform2, snapGrid, snapToGrid, containerBounds });
      lastPos = pointerPos;
      mousePosition = getEventPosition(event2.sourceEvent, containerBounds);
    }).on("drag", (event2) => {
      var _a2, _b2;
      const { autoPanOnNodeDrag, transform: transform2, snapGrid, snapToGrid, nodeDragThreshold, nodeLookup } = getStoreItems();
      const pointerPos = getPointerPosition(event2.sourceEvent, { transform: transform2, snapGrid, snapToGrid, containerBounds });
      if (event2.sourceEvent.type === "touchmove" && event2.sourceEvent.touches.length > 1 || // if user deletes a node while dragging, we need to abort the drag to prevent errors
      nodeId && !nodeLookup.has(nodeId)) {
        abortDrag = true;
      }
      if (abortDrag) {
        return;
      }
      if (!autoPanStarted && autoPanOnNodeDrag && dragStarted) {
        autoPanStarted = true;
        autoPan();
      }
      if (!dragStarted) {
        const x = pointerPos.xSnapped - ((_a2 = lastPos.x) != null ? _a2 : 0);
        const y2 = pointerPos.ySnapped - ((_b2 = lastPos.y) != null ? _b2 : 0);
        const distance2 = Math.sqrt(x * x + y2 * y2);
        if (distance2 > nodeDragThreshold) {
          startDrag(event2);
        }
      }
      if ((lastPos.x !== pointerPos.xSnapped || lastPos.y !== pointerPos.ySnapped) && dragItems && dragStarted) {
        mousePosition = getEventPosition(event2.sourceEvent, containerBounds);
        updateNodes(pointerPos, event2.sourceEvent);
      }
    }).on("end", (event2) => {
      if (!dragStarted || abortDrag) {
        return;
      }
      autoPanStarted = false;
      dragStarted = false;
      cancelAnimationFrame(autoPanId);
      if (dragItems.size > 0) {
        const { nodeLookup, updateNodePositions, onNodeDragStop, onSelectionDragStop } = getStoreItems();
        if (nodePositionsChanged) {
          updateNodePositions(dragItems, false);
          nodePositionsChanged = false;
        }
        if (onDragStop || onNodeDragStop || !nodeId && onSelectionDragStop) {
          const [currentNode, currentNodes] = getEventHandlerParams({
            nodeId,
            dragItems,
            nodeLookup,
            dragging: false
          });
          onDragStop == null ? void 0 : onDragStop(event2.sourceEvent, dragItems, currentNode, currentNodes);
          onNodeDragStop == null ? void 0 : onNodeDragStop(event2.sourceEvent, currentNode, currentNodes);
          if (!nodeId) {
            onSelectionDragStop == null ? void 0 : onSelectionDragStop(event2.sourceEvent, currentNodes);
          }
        }
      }
    }).filter((event2) => {
      const target = event2.target;
      const isDraggable = !event2.button && (!noDragClassName || !hasSelector(target, `.${noDragClassName}`, domNode)) && (!handleSelector || hasSelector(target, handleSelector, domNode));
      return isDraggable;
    });
    d3Selection.call(d3DragInstance);
  }
  function destroy() {
    d3Selection == null ? void 0 : d3Selection.on(".drag", null);
  }
  return {
    update: update2,
    destroy
  };
}
function getNodesWithinDistance(position, nodeLookup, distance2) {
  const nodes = [];
  const rect = {
    x: position.x - distance2,
    y: position.y - distance2,
    width: distance2 * 2,
    height: distance2 * 2
  };
  for (const node of nodeLookup.values()) {
    if (getOverlappingArea(rect, nodeToRect(node)) > 0) {
      nodes.push(node);
    }
  }
  return nodes;
}
const ADDITIONAL_DISTANCE = 250;
function getClosestHandle(position, connectionRadius, nodeLookup, fromHandle) {
  var _a2, _b2, _c2, _d2, _e2;
  let closestHandles = [];
  let minDistance = Infinity;
  const closeNodes = getNodesWithinDistance(position, nodeLookup, connectionRadius + ADDITIONAL_DISTANCE);
  for (const node of closeNodes) {
    const allHandles = [...(_b2 = (_a2 = node.internals.handleBounds) == null ? void 0 : _a2.source) != null ? _b2 : [], ...(_d2 = (_c2 = node.internals.handleBounds) == null ? void 0 : _c2.target) != null ? _d2 : []];
    for (const handle of allHandles) {
      if (fromHandle.nodeId === handle.nodeId && fromHandle.type === handle.type && fromHandle.id === handle.id) {
        continue;
      }
      const { x, y: y2 } = getHandlePosition(node, handle, handle.position, true);
      const distance2 = Math.sqrt(Math.pow(x - position.x, 2) + Math.pow(y2 - position.y, 2));
      if (distance2 > connectionRadius) {
        continue;
      }
      if (distance2 < minDistance) {
        closestHandles = [__spreadProps(__spreadValues({}, handle), { x, y: y2 })];
        minDistance = distance2;
      } else if (distance2 === minDistance) {
        closestHandles.push(__spreadProps(__spreadValues({}, handle), { x, y: y2 }));
      }
    }
  }
  if (!closestHandles.length) {
    return null;
  }
  if (closestHandles.length > 1) {
    const oppositeHandleType = fromHandle.type === "source" ? "target" : "source";
    return (_e2 = closestHandles.find((handle) => handle.type === oppositeHandleType)) != null ? _e2 : closestHandles[0];
  }
  return closestHandles[0];
}
function getHandle(nodeId, handleType, handleId, nodeLookup, connectionMode, withAbsolutePosition = false) {
  var _a2, _b2, _c2, _d2, _e2, _f;
  const node = nodeLookup.get(nodeId);
  if (!node) {
    return null;
  }
  const handles = connectionMode === "strict" ? (_a2 = node.internals.handleBounds) == null ? void 0 : _a2[handleType] : [...(_c2 = (_b2 = node.internals.handleBounds) == null ? void 0 : _b2.source) != null ? _c2 : [], ...(_e2 = (_d2 = node.internals.handleBounds) == null ? void 0 : _d2.target) != null ? _e2 : []];
  const handle = (_f = handleId ? handles == null ? void 0 : handles.find((h2) => h2.id === handleId) : handles == null ? void 0 : handles[0]) != null ? _f : null;
  return handle && withAbsolutePosition ? __spreadValues(__spreadValues({}, handle), getHandlePosition(node, handle, handle.position, true)) : handle;
}
function getHandleType(edgeUpdaterType, handleDomNode) {
  if (edgeUpdaterType) {
    return edgeUpdaterType;
  } else if (handleDomNode == null ? void 0 : handleDomNode.classList.contains("target")) {
    return "target";
  } else if (handleDomNode == null ? void 0 : handleDomNode.classList.contains("source")) {
    return "source";
  }
  return null;
}
function isConnectionValid(isInsideConnectionRadius, isHandleValid) {
  let isValid = null;
  if (isHandleValid) {
    isValid = true;
  } else if (isInsideConnectionRadius && !isHandleValid) {
    isValid = false;
  }
  return isValid;
}
const alwaysValid = () => true;
function onPointerDown(event2, { connectionMode, connectionRadius, handleId, nodeId, edgeUpdaterType, isTarget, domNode, nodeLookup, lib, autoPanOnConnect, flowId, panBy: panBy2, cancelConnection, onConnectStart, onConnect, onConnectEnd, isValidConnection = alwaysValid, onReconnectEnd, updateConnection, getTransform, getFromHandle, autoPanSpeed, dragThreshold = 1 }) {
  const doc = getHostForElement(event2.target);
  let autoPanId = 0;
  let closestHandle;
  const { x, y: y2 } = getEventPosition(event2);
  const clickedHandle = doc == null ? void 0 : doc.elementFromPoint(x, y2);
  const handleType = getHandleType(edgeUpdaterType, clickedHandle);
  const containerBounds = domNode == null ? void 0 : domNode.getBoundingClientRect();
  let connectionStarted = false;
  if (!containerBounds || !handleType) {
    return;
  }
  const fromHandleInternal = getHandle(nodeId, handleType, handleId, nodeLookup, connectionMode);
  if (!fromHandleInternal) {
    return;
  }
  let position = getEventPosition(event2, containerBounds);
  let autoPanStarted = false;
  let connection = null;
  let isValid = false;
  let handleDomNode = null;
  function autoPan() {
    if (!autoPanOnConnect || !containerBounds) {
      return;
    }
    const [x2, y22] = calcAutoPan(position, containerBounds, autoPanSpeed);
    panBy2({ x: x2, y: y22 });
    autoPanId = requestAnimationFrame(autoPan);
  }
  const fromHandle = __spreadProps(__spreadValues({}, fromHandleInternal), {
    nodeId,
    type: handleType,
    position: fromHandleInternal.position
  });
  const fromNodeInternal = nodeLookup.get(nodeId);
  const from = getHandlePosition(fromNodeInternal, fromHandle, Position.Left, true);
  let previousConnection = {
    inProgress: true,
    isValid: null,
    from,
    fromHandle,
    fromPosition: fromHandle.position,
    fromNode: fromNodeInternal,
    to: position,
    toHandle: null,
    toPosition: oppositePosition[fromHandle.position],
    toNode: null
  };
  function startConnection() {
    connectionStarted = true;
    updateConnection(previousConnection);
    onConnectStart == null ? void 0 : onConnectStart(event2, { nodeId, handleId, handleType });
  }
  if (dragThreshold === 0) {
    startConnection();
  }
  function onPointerMove(event22) {
    if (!connectionStarted) {
      const { x: evtX, y: evtY } = getEventPosition(event22);
      const dx = evtX - x;
      const dy = evtY - y2;
      const nextConnectionStarted = dx * dx + dy * dy > dragThreshold * dragThreshold;
      if (!nextConnectionStarted) {
        return;
      }
      startConnection();
    }
    if (!getFromHandle() || !fromHandle) {
      onPointerUp(event22);
      return;
    }
    const transform2 = getTransform();
    position = getEventPosition(event22, containerBounds);
    closestHandle = getClosestHandle(pointToRendererPoint(position, transform2, false, [1, 1]), connectionRadius, nodeLookup, fromHandle);
    if (!autoPanStarted) {
      autoPan();
      autoPanStarted = true;
    }
    const result = isValidHandle(event22, {
      handle: closestHandle,
      connectionMode,
      fromNodeId: nodeId,
      fromHandleId: handleId,
      fromType: isTarget ? "target" : "source",
      isValidConnection,
      doc,
      lib,
      flowId,
      nodeLookup
    });
    handleDomNode = result.handleDomNode;
    connection = result.connection;
    isValid = isConnectionValid(!!closestHandle, result.isValid);
    const newConnection = __spreadProps(__spreadValues({}, previousConnection), {
      isValid,
      to: result.toHandle && isValid ? rendererPointToPoint({ x: result.toHandle.x, y: result.toHandle.y }, transform2) : position,
      toHandle: result.toHandle,
      toPosition: isValid && result.toHandle ? result.toHandle.position : oppositePosition[fromHandle.position],
      toNode: result.toHandle ? nodeLookup.get(result.toHandle.nodeId) : null
    });
    if (isValid && closestHandle && previousConnection.toHandle && newConnection.toHandle && previousConnection.toHandle.type === newConnection.toHandle.type && previousConnection.toHandle.nodeId === newConnection.toHandle.nodeId && previousConnection.toHandle.id === newConnection.toHandle.id && previousConnection.to.x === newConnection.to.x && previousConnection.to.y === newConnection.to.y) {
      return;
    }
    updateConnection(newConnection);
    previousConnection = newConnection;
  }
  function onPointerUp(event22) {
    if (connectionStarted) {
      if ((closestHandle || handleDomNode) && connection && isValid) {
        onConnect == null ? void 0 : onConnect(connection);
      }
      const _a2 = previousConnection, { inProgress } = _a2, connectionState = __objRest(_a2, ["inProgress"]);
      const finalConnectionState = __spreadProps(__spreadValues({}, connectionState), {
        toPosition: previousConnection.toHandle ? previousConnection.toPosition : null
      });
      onConnectEnd == null ? void 0 : onConnectEnd(event22, finalConnectionState);
      if (edgeUpdaterType) {
        onReconnectEnd == null ? void 0 : onReconnectEnd(event22, finalConnectionState);
      }
    }
    cancelConnection();
    cancelAnimationFrame(autoPanId);
    autoPanStarted = false;
    isValid = false;
    connection = null;
    handleDomNode = null;
    doc.removeEventListener("mousemove", onPointerMove);
    doc.removeEventListener("mouseup", onPointerUp);
    doc.removeEventListener("touchmove", onPointerMove);
    doc.removeEventListener("touchend", onPointerUp);
  }
  doc.addEventListener("mousemove", onPointerMove);
  doc.addEventListener("mouseup", onPointerUp);
  doc.addEventListener("touchmove", onPointerMove);
  doc.addEventListener("touchend", onPointerUp);
}
function isValidHandle(event2, { handle, connectionMode, fromNodeId, fromHandleId, fromType, doc, lib, flowId, isValidConnection = alwaysValid, nodeLookup }) {
  const isTarget = fromType === "target";
  const handleDomNode = handle ? doc.querySelector(`.${lib}-flow__handle[data-id="${flowId}-${handle == null ? void 0 : handle.nodeId}-${handle == null ? void 0 : handle.id}-${handle == null ? void 0 : handle.type}"]`) : null;
  const { x, y: y2 } = getEventPosition(event2);
  const handleBelow = doc.elementFromPoint(x, y2);
  const handleToCheck = (handleBelow == null ? void 0 : handleBelow.classList.contains(`${lib}-flow__handle`)) ? handleBelow : handleDomNode;
  const result = {
    handleDomNode: handleToCheck,
    isValid: false,
    connection: null,
    toHandle: null
  };
  if (handleToCheck) {
    const handleType = getHandleType(void 0, handleToCheck);
    const handleNodeId = handleToCheck.getAttribute("data-nodeid");
    const handleId = handleToCheck.getAttribute("data-handleid");
    const connectable = handleToCheck.classList.contains("connectable");
    const connectableEnd = handleToCheck.classList.contains("connectableend");
    if (!handleNodeId || !handleType) {
      return result;
    }
    const connection = {
      source: isTarget ? handleNodeId : fromNodeId,
      sourceHandle: isTarget ? handleId : fromHandleId,
      target: isTarget ? fromNodeId : handleNodeId,
      targetHandle: isTarget ? fromHandleId : handleId
    };
    result.connection = connection;
    const isConnectable = connectable && connectableEnd;
    const isValid = isConnectable && (connectionMode === ConnectionMode.Strict ? isTarget && handleType === "source" || !isTarget && handleType === "target" : handleNodeId !== fromNodeId || handleId !== fromHandleId);
    result.isValid = isValid && isValidConnection(connection);
    result.toHandle = getHandle(handleNodeId, handleType, handleId, nodeLookup, connectionMode, true);
  }
  return result;
}
const XYHandle = {
  onPointerDown,
  isValid: isValidHandle
};
function XYMinimap({ domNode, panZoom, getTransform, getViewScale }) {
  const selection2 = select(domNode);
  function update2({ translateExtent, width, height, zoomStep = 10, pannable = true, zoomable = true, inversePan = false }) {
    const zoomHandler = (event2) => {
      const transform2 = getTransform();
      if (event2.sourceEvent.type !== "wheel" || !panZoom) {
        return;
      }
      const pinchDelta = -event2.sourceEvent.deltaY * (event2.sourceEvent.deltaMode === 1 ? 0.05 : event2.sourceEvent.deltaMode ? 1 : 2e-3) * zoomStep;
      const nextZoom = transform2[2] * Math.pow(2, pinchDelta);
      panZoom.scaleTo(nextZoom);
    };
    let panStart = [0, 0];
    const panStartHandler = (event2) => {
      var _a2, _b2;
      if (event2.sourceEvent.type === "mousedown" || event2.sourceEvent.type === "touchstart") {
        panStart = [
          (_a2 = event2.sourceEvent.clientX) != null ? _a2 : event2.sourceEvent.touches[0].clientX,
          (_b2 = event2.sourceEvent.clientY) != null ? _b2 : event2.sourceEvent.touches[0].clientY
        ];
      }
    };
    const panHandler = (event2) => {
      var _a2, _b2;
      const transform2 = getTransform();
      if (event2.sourceEvent.type !== "mousemove" && event2.sourceEvent.type !== "touchmove" || !panZoom) {
        return;
      }
      const panCurrent = [
        (_a2 = event2.sourceEvent.clientX) != null ? _a2 : event2.sourceEvent.touches[0].clientX,
        (_b2 = event2.sourceEvent.clientY) != null ? _b2 : event2.sourceEvent.touches[0].clientY
      ];
      const panDelta = [panCurrent[0] - panStart[0], panCurrent[1] - panStart[1]];
      panStart = panCurrent;
      const moveScale = getViewScale() * Math.max(transform2[2], Math.log(transform2[2])) * (inversePan ? -1 : 1);
      const position = {
        x: transform2[0] - panDelta[0] * moveScale,
        y: transform2[1] - panDelta[1] * moveScale
      };
      const extent = [
        [0, 0],
        [width, height]
      ];
      panZoom.setViewportConstrained({
        x: position.x,
        y: position.y,
        zoom: transform2[2]
      }, extent, translateExtent);
    };
    const zoomAndPanHandler = zoom$1().on("start", panStartHandler).on("zoom", pannable ? panHandler : null).on("zoom.wheel", zoomable ? zoomHandler : null);
    selection2.call(zoomAndPanHandler, {});
  }
  function destroy() {
    selection2.on("zoom", null);
  }
  return {
    update: update2,
    destroy,
    pointer
  };
}
const viewChanged = (prevViewport, eventViewport) => prevViewport.x !== eventViewport.x || prevViewport.y !== eventViewport.y || prevViewport.zoom !== eventViewport.k;
const transformToViewport = (transform2) => ({
  x: transform2.x,
  y: transform2.y,
  zoom: transform2.k
});
const viewportToTransform = ({ x, y: y2, zoom: zoom2 }) => identity.translate(x, y2).scale(zoom2);
const isWrappedWithClass = (event2, className) => event2.target.closest(`.${className}`);
const isRightClickPan = (panOnDrag, usedButton) => usedButton === 2 && Array.isArray(panOnDrag) && panOnDrag.includes(2);
const defaultEase = (t) => ((t *= 2) <= 1 ? t * t * t : (t -= 2) * t * t + 2) / 2;
const getD3Transition = (selection2, duration = 0, ease = defaultEase, onEnd = () => {
}) => {
  const hasDuration = typeof duration === "number" && duration > 0;
  if (!hasDuration) {
    onEnd();
  }
  return hasDuration ? selection2.transition().duration(duration).ease(ease).on("end", onEnd) : selection2;
};
const wheelDelta = (event2) => {
  const factor = event2.ctrlKey && isMacOs() ? 10 : 1;
  return -event2.deltaY * (event2.deltaMode === 1 ? 0.05 : event2.deltaMode ? 1 : 2e-3) * factor;
};
function createPanOnScrollHandler({ zoomPanValues, noWheelClassName, d3Selection, d3Zoom, panOnScrollMode, panOnScrollSpeed, zoomOnPinch, onPanZoomStart, onPanZoom, onPanZoomEnd }) {
  return (event2) => {
    if (isWrappedWithClass(event2, noWheelClassName)) {
      return false;
    }
    event2.preventDefault();
    event2.stopImmediatePropagation();
    const currentZoom = d3Selection.property("__zoom").k || 1;
    if (event2.ctrlKey && zoomOnPinch) {
      const point = pointer(event2);
      const pinchDelta = wheelDelta(event2);
      const zoom2 = currentZoom * Math.pow(2, pinchDelta);
      d3Zoom.scaleTo(d3Selection, zoom2, point, event2);
      return;
    }
    const deltaNormalize = event2.deltaMode === 1 ? 20 : 1;
    let deltaX = panOnScrollMode === PanOnScrollMode.Vertical ? 0 : event2.deltaX * deltaNormalize;
    let deltaY = panOnScrollMode === PanOnScrollMode.Horizontal ? 0 : event2.deltaY * deltaNormalize;
    if (!isMacOs() && event2.shiftKey && panOnScrollMode !== PanOnScrollMode.Vertical) {
      deltaX = event2.deltaY * deltaNormalize;
      deltaY = 0;
    }
    d3Zoom.translateBy(
      d3Selection,
      -(deltaX / currentZoom) * panOnScrollSpeed,
      -(deltaY / currentZoom) * panOnScrollSpeed,
      // @ts-ignore
      { internal: true }
    );
    const nextViewport = transformToViewport(d3Selection.property("__zoom"));
    clearTimeout(zoomPanValues.panScrollTimeout);
    if (!zoomPanValues.isPanScrolling) {
      zoomPanValues.isPanScrolling = true;
      onPanZoomStart == null ? void 0 : onPanZoomStart(event2, nextViewport);
    }
    if (zoomPanValues.isPanScrolling) {
      onPanZoom == null ? void 0 : onPanZoom(event2, nextViewport);
      zoomPanValues.panScrollTimeout = setTimeout(() => {
        onPanZoomEnd == null ? void 0 : onPanZoomEnd(event2, nextViewport);
        zoomPanValues.isPanScrolling = false;
      }, 150);
    }
  };
}
function createZoomOnScrollHandler({ noWheelClassName, preventScrolling, d3ZoomHandler }) {
  return function(event2, d2) {
    const isWheel = event2.type === "wheel";
    const preventZoom = !preventScrolling && isWheel && !event2.ctrlKey;
    const hasNoWheelClass = isWrappedWithClass(event2, noWheelClassName);
    if (event2.ctrlKey && isWheel && hasNoWheelClass) {
      event2.preventDefault();
    }
    if (preventZoom || hasNoWheelClass) {
      return null;
    }
    event2.preventDefault();
    d3ZoomHandler.call(this, event2, d2);
  };
}
function createPanZoomStartHandler({ zoomPanValues, onDraggingChange, onPanZoomStart }) {
  return (event2) => {
    var _a2, _b2, _c2;
    if ((_a2 = event2.sourceEvent) == null ? void 0 : _a2.internal) {
      return;
    }
    const viewport = transformToViewport(event2.transform);
    zoomPanValues.mouseButton = ((_b2 = event2.sourceEvent) == null ? void 0 : _b2.button) || 0;
    zoomPanValues.isZoomingOrPanning = true;
    zoomPanValues.prevViewport = viewport;
    if (((_c2 = event2.sourceEvent) == null ? void 0 : _c2.type) === "mousedown") {
      onDraggingChange(true);
    }
    if (onPanZoomStart) {
      onPanZoomStart == null ? void 0 : onPanZoomStart(event2.sourceEvent, viewport);
    }
  };
}
function createPanZoomHandler({ zoomPanValues, panOnDrag, onPaneContextMenu, onTransformChange, onPanZoom }) {
  return (event2) => {
    var _a2, _b2, _c2;
    zoomPanValues.usedRightMouseButton = !!(onPaneContextMenu && isRightClickPan(panOnDrag, (_a2 = zoomPanValues.mouseButton) != null ? _a2 : 0));
    if (!((_b2 = event2.sourceEvent) == null ? void 0 : _b2.sync)) {
      onTransformChange([event2.transform.x, event2.transform.y, event2.transform.k]);
    }
    if (onPanZoom && !((_c2 = event2.sourceEvent) == null ? void 0 : _c2.internal)) {
      onPanZoom == null ? void 0 : onPanZoom(event2.sourceEvent, transformToViewport(event2.transform));
    }
  };
}
function createPanZoomEndHandler({ zoomPanValues, panOnDrag, panOnScroll, onDraggingChange, onPanZoomEnd, onPaneContextMenu }) {
  return (event2) => {
    var _a2, _b2;
    if ((_a2 = event2.sourceEvent) == null ? void 0 : _a2.internal) {
      return;
    }
    zoomPanValues.isZoomingOrPanning = false;
    if (onPaneContextMenu && isRightClickPan(panOnDrag, (_b2 = zoomPanValues.mouseButton) != null ? _b2 : 0) && !zoomPanValues.usedRightMouseButton && event2.sourceEvent) {
      onPaneContextMenu(event2.sourceEvent);
    }
    zoomPanValues.usedRightMouseButton = false;
    onDraggingChange(false);
    if (onPanZoomEnd && viewChanged(zoomPanValues.prevViewport, event2.transform)) {
      const viewport = transformToViewport(event2.transform);
      zoomPanValues.prevViewport = viewport;
      clearTimeout(zoomPanValues.timerId);
      zoomPanValues.timerId = setTimeout(
        () => {
          onPanZoomEnd == null ? void 0 : onPanZoomEnd(event2.sourceEvent, viewport);
        },
        // we need a setTimeout for panOnScroll to supress multiple end events fired during scroll
        panOnScroll ? 150 : 0
      );
    }
  };
}
function createFilter({ zoomActivationKeyPressed, zoomOnScroll, zoomOnPinch, panOnDrag, panOnScroll, zoomOnDoubleClick, userSelectionActive, noWheelClassName, noPanClassName, lib }) {
  return (event2) => {
    var _a2;
    const zoomScroll = zoomActivationKeyPressed || zoomOnScroll;
    const pinchZoom = zoomOnPinch && event2.ctrlKey;
    if (event2.button === 1 && event2.type === "mousedown" && (isWrappedWithClass(event2, `${lib}-flow__node`) || isWrappedWithClass(event2, `${lib}-flow__edge`))) {
      return true;
    }
    if (!panOnDrag && !zoomScroll && !panOnScroll && !zoomOnDoubleClick && !zoomOnPinch) {
      return false;
    }
    if (userSelectionActive) {
      return false;
    }
    if (isWrappedWithClass(event2, noWheelClassName) && event2.type === "wheel") {
      return false;
    }
    if (isWrappedWithClass(event2, noPanClassName) && (event2.type !== "wheel" || panOnScroll && event2.type === "wheel" && !zoomActivationKeyPressed)) {
      return false;
    }
    if (!zoomOnPinch && event2.ctrlKey && event2.type === "wheel") {
      return false;
    }
    if (!zoomOnPinch && event2.type === "touchstart" && ((_a2 = event2.touches) == null ? void 0 : _a2.length) > 1) {
      event2.preventDefault();
      return false;
    }
    if (!zoomScroll && !panOnScroll && !pinchZoom && event2.type === "wheel") {
      return false;
    }
    if (!panOnDrag && (event2.type === "mousedown" || event2.type === "touchstart")) {
      return false;
    }
    if (Array.isArray(panOnDrag) && !panOnDrag.includes(event2.button) && event2.type === "mousedown") {
      return false;
    }
    const buttonAllowed = Array.isArray(panOnDrag) && panOnDrag.includes(event2.button) || !event2.button || event2.button <= 1;
    return (!event2.ctrlKey || event2.type === "wheel") && buttonAllowed;
  };
}
function XYPanZoom({ domNode, minZoom, maxZoom, paneClickDistance, translateExtent, viewport, onPanZoom, onPanZoomStart, onPanZoomEnd, onDraggingChange }) {
  const zoomPanValues = {
    isZoomingOrPanning: false,
    usedRightMouseButton: false,
    prevViewport: { x: 0, y: 0, zoom: 0 },
    mouseButton: 0,
    timerId: void 0,
    panScrollTimeout: void 0,
    isPanScrolling: false
  };
  const bbox = domNode.getBoundingClientRect();
  const d3ZoomInstance = zoom$1().clickDistance(!isNumeric(paneClickDistance) || paneClickDistance < 0 ? 0 : paneClickDistance).scaleExtent([minZoom, maxZoom]).translateExtent(translateExtent);
  const d3Selection = select(domNode).call(d3ZoomInstance);
  setViewportConstrained({
    x: viewport.x,
    y: viewport.y,
    zoom: clamp(viewport.zoom, minZoom, maxZoom)
  }, [
    [0, 0],
    [bbox.width, bbox.height]
  ], translateExtent);
  const d3ZoomHandler = d3Selection.on("wheel.zoom");
  const d3DblClickZoomHandler = d3Selection.on("dblclick.zoom");
  d3ZoomInstance.wheelDelta(wheelDelta);
  function setTransform(transform2, options) {
    if (d3Selection) {
      return new Promise((resolve) => {
        d3ZoomInstance == null ? void 0 : d3ZoomInstance.interpolate((options == null ? void 0 : options.interpolate) === "linear" ? interpolate$1 : interpolateZoom).transform(getD3Transition(d3Selection, options == null ? void 0 : options.duration, options == null ? void 0 : options.ease, () => resolve(true)), transform2);
      });
    }
    return Promise.resolve(false);
  }
  function update2({ noWheelClassName, noPanClassName, onPaneContextMenu, userSelectionActive, panOnScroll, panOnDrag, panOnScrollMode, panOnScrollSpeed, preventScrolling, zoomOnPinch, zoomOnScroll, zoomOnDoubleClick, zoomActivationKeyPressed, lib, onTransformChange }) {
    if (userSelectionActive && !zoomPanValues.isZoomingOrPanning) {
      destroy();
    }
    const isPanOnScroll = panOnScroll && !zoomActivationKeyPressed && !userSelectionActive;
    const wheelHandler = isPanOnScroll ? createPanOnScrollHandler({
      zoomPanValues,
      noWheelClassName,
      d3Selection,
      d3Zoom: d3ZoomInstance,
      panOnScrollMode,
      panOnScrollSpeed,
      zoomOnPinch,
      onPanZoomStart,
      onPanZoom,
      onPanZoomEnd
    }) : createZoomOnScrollHandler({
      noWheelClassName,
      preventScrolling,
      d3ZoomHandler
    });
    d3Selection.on("wheel.zoom", wheelHandler, { passive: false });
    if (!userSelectionActive) {
      const startHandler = createPanZoomStartHandler({
        zoomPanValues,
        onDraggingChange,
        onPanZoomStart
      });
      d3ZoomInstance.on("start", startHandler);
      const panZoomHandler = createPanZoomHandler({
        zoomPanValues,
        panOnDrag,
        onPaneContextMenu: !!onPaneContextMenu,
        onPanZoom,
        onTransformChange
      });
      d3ZoomInstance.on("zoom", panZoomHandler);
      const panZoomEndHandler = createPanZoomEndHandler({
        zoomPanValues,
        panOnDrag,
        panOnScroll,
        onPaneContextMenu,
        onPanZoomEnd,
        onDraggingChange
      });
      d3ZoomInstance.on("end", panZoomEndHandler);
    }
    const filter2 = createFilter({
      zoomActivationKeyPressed,
      panOnDrag,
      zoomOnScroll,
      panOnScroll,
      zoomOnDoubleClick,
      zoomOnPinch,
      userSelectionActive,
      noPanClassName,
      noWheelClassName,
      lib
    });
    d3ZoomInstance.filter(filter2);
    if (zoomOnDoubleClick) {
      d3Selection.on("dblclick.zoom", d3DblClickZoomHandler);
    } else {
      d3Selection.on("dblclick.zoom", null);
    }
  }
  function destroy() {
    d3ZoomInstance.on("zoom", null);
  }
  function setViewportConstrained(viewport2, extent, translateExtent2) {
    return __async(this, null, function* () {
      const nextTransform = viewportToTransform(viewport2);
      const contrainedTransform = d3ZoomInstance == null ? void 0 : d3ZoomInstance.constrain()(nextTransform, extent, translateExtent2);
      if (contrainedTransform) {
        yield setTransform(contrainedTransform);
      }
      return new Promise((resolve) => resolve(contrainedTransform));
    });
  }
  function setViewport(viewport2, options) {
    return __async(this, null, function* () {
      const nextTransform = viewportToTransform(viewport2);
      yield setTransform(nextTransform, options);
      return new Promise((resolve) => resolve(nextTransform));
    });
  }
  function syncViewport(viewport2) {
    if (d3Selection) {
      const nextTransform = viewportToTransform(viewport2);
      const currentTransform = d3Selection.property("__zoom");
      if (currentTransform.k !== viewport2.zoom || currentTransform.x !== viewport2.x || currentTransform.y !== viewport2.y) {
        d3ZoomInstance == null ? void 0 : d3ZoomInstance.transform(d3Selection, nextTransform, null, { sync: true });
      }
    }
  }
  function getViewport() {
    const transform$1 = d3Selection ? transform(d3Selection.node()) : { x: 0, y: 0, k: 1 };
    return { x: transform$1.x, y: transform$1.y, zoom: transform$1.k };
  }
  function scaleTo(zoom2, options) {
    if (d3Selection) {
      return new Promise((resolve) => {
        d3ZoomInstance == null ? void 0 : d3ZoomInstance.interpolate((options == null ? void 0 : options.interpolate) === "linear" ? interpolate$1 : interpolateZoom).scaleTo(getD3Transition(d3Selection, options == null ? void 0 : options.duration, options == null ? void 0 : options.ease, () => resolve(true)), zoom2);
      });
    }
    return Promise.resolve(false);
  }
  function scaleBy(factor, options) {
    if (d3Selection) {
      return new Promise((resolve) => {
        d3ZoomInstance == null ? void 0 : d3ZoomInstance.interpolate((options == null ? void 0 : options.interpolate) === "linear" ? interpolate$1 : interpolateZoom).scaleBy(getD3Transition(d3Selection, options == null ? void 0 : options.duration, options == null ? void 0 : options.ease, () => resolve(true)), factor);
      });
    }
    return Promise.resolve(false);
  }
  function setScaleExtent(scaleExtent) {
    d3ZoomInstance == null ? void 0 : d3ZoomInstance.scaleExtent(scaleExtent);
  }
  function setTranslateExtent(translateExtent2) {
    d3ZoomInstance == null ? void 0 : d3ZoomInstance.translateExtent(translateExtent2);
  }
  function setClickDistance(distance2) {
    const validDistance = !isNumeric(distance2) || distance2 < 0 ? 0 : distance2;
    d3ZoomInstance == null ? void 0 : d3ZoomInstance.clickDistance(validDistance);
  }
  return {
    update: update2,
    destroy,
    setViewport,
    setViewportConstrained,
    getViewport,
    scaleTo,
    scaleBy,
    setScaleExtent,
    setTranslateExtent,
    syncViewport,
    setClickDistance
  };
}
var ResizeControlVariant;
(function(ResizeControlVariant2) {
  ResizeControlVariant2["Line"] = "line";
  ResizeControlVariant2["Handle"] = "handle";
})(ResizeControlVariant || (ResizeControlVariant = {}));
var root$C = /* @__PURE__ */ from_html(`<div><!></div>`);
function Handle($$anchor, $$props) {
  push($$props, true);
  let handleId = prop($$props, "id", 3, null), type = prop($$props, "type", 3, "source"), position = prop($$props, "position", 19, () => Position.Top), isConnectableStart = prop($$props, "isConnectableStart", 3, true), isConnectableEnd = prop($$props, "isConnectableEnd", 3, true), rest = /* @__PURE__ */ rest_props($$props, [
    "$$slots",
    "$$events",
    "$$legacy",
    "id",
    "type",
    "position",
    "style",
    "class",
    "isConnectable",
    "isConnectableStart",
    "isConnectableEnd",
    "isValidConnection",
    "onconnect",
    "ondisconnect",
    "children"
  ]);
  const nodeId = getContext("svelteflow__node_id");
  const isConnectableContext = getContext("svelteflow__node_connectable");
  let isTarget = /* @__PURE__ */ user_derived(() => type() === "target");
  let isConnectable = /* @__PURE__ */ user_derived(() => $$props.isConnectable !== void 0 ? $$props.isConnectable : isConnectableContext.value);
  let store = useStore();
  let ariaLabelConfig = /* @__PURE__ */ user_derived(() => store.ariaLabelConfig);
  let prevConnections = null;
  user_pre_effect(() => {
    if ($$props.onconnect || $$props.ondisconnect) {
      store.edges;
      let connections = store.connectionLookup.get(`${nodeId}-${type()}${handleId() ? `-${handleId()}` : ""}`);
      if (prevConnections && !areConnectionMapsEqual(connections, prevConnections)) {
        const _connections = connections != null ? connections : /* @__PURE__ */ new Map();
        handleConnectionChange(prevConnections, _connections, $$props.ondisconnect);
        handleConnectionChange(_connections, prevConnections, $$props.onconnect);
      }
      prevConnections = new Map(connections);
    }
  });
  let $$d = /* @__PURE__ */ user_derived(() => {
    if (!store.connection.inProgress) {
      return [false, false, false, false, null];
    }
    const { fromHandle, toHandle, isValid } = store.connection;
    const connectingFrom2 = fromHandle && fromHandle.nodeId === nodeId && fromHandle.type === type() && fromHandle.id === handleId();
    const connectingTo2 = toHandle && toHandle.nodeId === nodeId && toHandle.type === type() && toHandle.id === handleId();
    const isPossibleTargetHandle2 = store.connectionMode === ConnectionMode.Strict ? (fromHandle == null ? void 0 : fromHandle.type) !== type() : nodeId !== (fromHandle == null ? void 0 : fromHandle.nodeId) || handleId() !== (fromHandle == null ? void 0 : fromHandle.id);
    const valid2 = connectingTo2 && isValid;
    return [
      true,
      connectingFrom2,
      connectingTo2,
      isPossibleTargetHandle2,
      valid2
    ];
  }), $$array = /* @__PURE__ */ user_derived(() => to_array(get$3($$d), 5)), connectionInProgress = /* @__PURE__ */ user_derived(() => get$3($$array)[0]), connectingFrom = /* @__PURE__ */ user_derived(() => get$3($$array)[1]), connectingTo = /* @__PURE__ */ user_derived(() => get$3($$array)[2]), isPossibleTargetHandle = /* @__PURE__ */ user_derived(() => get$3($$array)[3]), valid = /* @__PURE__ */ user_derived(() => get$3($$array)[4]);
  function onConnectExtended(connection) {
    var _a2, _b2, _c2;
    const edge = (_b2 = (_a2 = store.onbeforeconnect) == null ? void 0 : _a2.call(store, connection)) != null ? _b2 : connection;
    if (!edge) {
      return;
    }
    store.addEdge(edge);
    (_c2 = store.onconnect) == null ? void 0 : _c2.call(store, connection);
  }
  function onpointerdown(event2) {
    var _a2;
    const isMouseTriggered = isMouseEvent(event2);
    if (isMouseTriggered && event2.button === 0 || !isMouseTriggered) {
      XYHandle.onPointerDown(event2, {
        handleId: handleId(),
        nodeId,
        isTarget: get$3(isTarget),
        connectionRadius: store.connectionRadius,
        domNode: store.domNode,
        nodeLookup: store.nodeLookup,
        connectionMode: store.connectionMode,
        lib: "svelte",
        autoPanOnConnect: store.autoPanOnConnect,
        flowId: store.flowId,
        isValidConnection: (_a2 = $$props.isValidConnection) != null ? _a2 : store.isValidConnection,
        updateConnection: store.updateConnection,
        cancelConnection: store.cancelConnection,
        panBy: store.panBy,
        onConnect: onConnectExtended,
        onConnectStart: (event3, startParams) => {
          var _a3;
          (_a3 = store.onconnectstart) == null ? void 0 : _a3.call(store, event3, {
            nodeId: startParams.nodeId,
            handleId: startParams.handleId,
            handleType: startParams.handleType
          });
        },
        onConnectEnd: (event3, connectionState) => {
          var _a3;
          (_a3 = store.onconnectend) == null ? void 0 : _a3.call(store, event3, connectionState);
        },
        getTransform: () => [
          store.viewport.x,
          store.viewport.y,
          store.viewport.zoom
        ],
        getFromHandle: () => store.connection.fromHandle,
        dragThreshold: store.connectionDragThreshold
      });
    }
  }
  function onclick2(event2) {
    var _a2, _b2, _c2, _d2;
    if (!nodeId || !store.clickConnectStartHandle && !isConnectableStart()) {
      return;
    }
    if (!store.clickConnectStartHandle) {
      (_a2 = store.onclickconnectstart) == null ? void 0 : _a2.call(store, event2, {
        nodeId,
        handleId: handleId(),
        handleType: type()
      });
      store.clickConnectStartHandle = { nodeId, type: type(), id: handleId() };
      return;
    }
    const doc = getHostForElement(event2.target);
    const isValidConnectionHandler = (_b2 = $$props.isValidConnection) != null ? _b2 : store.isValidConnection;
    const {
      connectionMode,
      clickConnectStartHandle,
      flowId,
      nodeLookup
    } = store;
    const { connection, isValid } = XYHandle.isValid(event2, {
      handle: { nodeId, id: handleId(), type: type() },
      connectionMode,
      fromNodeId: clickConnectStartHandle.nodeId,
      fromHandleId: (_c2 = clickConnectStartHandle.id) != null ? _c2 : null,
      fromType: clickConnectStartHandle.type,
      isValidConnection: isValidConnectionHandler,
      flowId,
      doc,
      lib: "svelte",
      nodeLookup
    });
    if (isValid && connection) {
      onConnectExtended(connection);
    }
    const connectionClone = structuredClone(snapshot(store.connection));
    delete connectionClone.inProgress;
    connectionClone.toPosition = connectionClone.toHandle ? connectionClone.toHandle.position : null;
    (_d2 = store.onclickconnectend) == null ? void 0 : _d2.call(store, event2, connectionClone);
    store.clickConnectStartHandle = null;
  }
  var div = root$C();
  var event_handler = () => {
  };
  attribute_effect(
    div,
    ($0) => {
      var _a2, _b2, _c2, _d2;
      return __spreadProps(__spreadValues({
        "data-handleid": handleId(),
        "data-nodeid": nodeId,
        "data-handlepos": position(),
        "data-id": `${(_a2 = store.flowId) != null ? _a2 : ""}-${nodeId != null ? nodeId : ""}-${(_c2 = (_b2 = handleId()) != null ? _b2 : "null") != null ? _c2 : ""}-${(_d2 = type()) != null ? _d2 : ""}`,
        class: [
          "svelte-flow__handle",
          `svelte-flow__handle-${position()}`,
          store.noDragClass,
          store.noPanClass,
          position(),
          $$props.class
        ],
        onmousedown: onpointerdown,
        ontouchstart: onpointerdown,
        onclick: store.clickConnect ? onclick2 : void 0,
        onkeypress: event_handler,
        style: $$props.style,
        role: "button",
        "aria-label": get$3(ariaLabelConfig)[`handle.ariaLabel`],
        tabindex: "-1"
      }, rest), {
        [CLASS]: $0
      });
    },
    [
      () => ({
        valid: get$3(valid),
        connectingto: get$3(connectingTo),
        connectingfrom: get$3(connectingFrom),
        source: !get$3(isTarget),
        target: get$3(isTarget),
        connectablestart: isConnectableStart(),
        connectableend: isConnectableEnd(),
        connectable: get$3(isConnectable),
        connectionindicator: get$3(isConnectable) && (!get$3(connectionInProgress) || get$3(isPossibleTargetHandle)) && (get$3(connectionInProgress) || store.clickConnectStartHandle ? isConnectableEnd() : isConnectableStart())
      })
    ]
  );
  var node = child(div);
  snippet(node, () => {
    var _a2;
    return (_a2 = $$props.children) != null ? _a2 : noop$1;
  });
  append($$anchor, div);
  pop();
}
var root$B = /* @__PURE__ */ from_html(`<!> <!>`, 1);
function DefaultNode($$anchor, $$props) {
  push($$props, true);
  let targetPosition = prop($$props, "targetPosition", 19, () => Position.Top), sourcePosition = prop($$props, "sourcePosition", 19, () => Position.Bottom);
  var fragment = root$B();
  var node = first_child(fragment);
  Handle(node, {
    type: "target",
    get position() {
      return targetPosition();
    }
  });
  var text2 = sibling(node);
  var node_1 = sibling(text2);
  Handle(node_1, {
    type: "source",
    get position() {
      return sourcePosition();
    }
  });
  template_effect(() => {
    var _a2, _b2;
    return set_text(text2, ` ${(_b2 = (_a2 = $$props.data) == null ? void 0 : _a2.label) != null ? _b2 : ""} `);
  });
  append($$anchor, fragment);
  pop();
}
var root$A = /* @__PURE__ */ from_html(` <!>`, 1);
function InputNode($$anchor, $$props) {
  push($$props, true);
  let data = prop($$props, "data", 19, () => ({ label: "Node" })), sourcePosition = prop($$props, "sourcePosition", 19, () => Position.Bottom);
  var fragment = root$A();
  var text2 = first_child(fragment);
  var node = sibling(text2);
  Handle(node, {
    type: "source",
    get position() {
      return sourcePosition();
    }
  });
  template_effect(() => {
    var _a2, _b2;
    return set_text(text2, `${(_b2 = (_a2 = data()) == null ? void 0 : _a2.label) != null ? _b2 : ""} `);
  });
  append($$anchor, fragment);
  pop();
}
var root$z = /* @__PURE__ */ from_html(` <!>`, 1);
function OutputNode($$anchor, $$props) {
  push($$props, true);
  let data = prop($$props, "data", 19, () => ({ label: "Node" })), targetPosition = prop($$props, "targetPosition", 19, () => Position.Top);
  var fragment = root$z();
  var text2 = first_child(fragment);
  var node = sibling(text2);
  Handle(node, {
    type: "target",
    get position() {
      return targetPosition();
    }
  });
  template_effect(() => {
    var _a2, _b2;
    return set_text(text2, `${(_b2 = (_a2 = data()) == null ? void 0 : _a2.label) != null ? _b2 : ""} `);
  });
  append($$anchor, fragment);
  pop();
}
function GroupNode($$anchor, $$props) {
}
function tryToMount(node, domNode, target) {
  if (!target || !domNode) {
    return;
  }
  const targetEl = target === "root" ? domNode : domNode.querySelector(`.svelte-flow__${target}`);
  if (targetEl) {
    targetEl.appendChild(node);
  }
}
function portal(node, target) {
  const $$d = /* @__PURE__ */ user_derived(useStore), domNode = /* @__PURE__ */ user_derived(() => get$3($$d).domNode);
  let destroyEffect;
  if (get$3(domNode)) {
    tryToMount(node, get$3(domNode), target);
  } else {
    destroyEffect = effect_root(() => {
      user_effect(() => {
        tryToMount(node, get$3(domNode), target);
        destroyEffect == null ? void 0 : destroyEffect();
      });
    });
  }
  return {
    update(target2) {
      return __async(this, null, function* () {
        tryToMount(node, get$3(domNode), target2);
      });
    },
    destroy() {
      if (node.parentNode) {
        node.parentNode.removeChild(node);
      }
      destroyEffect == null ? void 0 : destroyEffect();
    }
  };
}
function hideOnSSR() {
  let hide = /* @__PURE__ */ state(typeof window === "undefined");
  if (get$3(hide)) {
    const destroyEffect = effect_root(() => {
      user_effect(() => {
        set$2(hide, false);
        destroyEffect == null ? void 0 : destroyEffect();
      });
    });
  }
  return {
    get value() {
      return get$3(hide);
    }
  };
}
const isNode = (element) => isNodeBase(element);
const isEdge = (element) => isEdgeBase(element);
function toPxString(value) {
  return value === void 0 ? void 0 : `${value}px`;
}
const arrowKeyDiffs = {
  ArrowUp: { x: 0, y: -1 },
  ArrowDown: { x: 0, y: 1 },
  ArrowLeft: { x: -1, y: 0 },
  ArrowRight: { x: 1, y: 0 }
};
var root$y = /* @__PURE__ */ from_html(`<div><!></div>`);
function EdgeLabel($$anchor, $$props) {
  push($$props, true);
  let x = prop($$props, "x", 3, 0), y2 = prop($$props, "y", 3, 0), selectEdgeOnClick = prop($$props, "selectEdgeOnClick", 3, false), transparent = prop($$props, "transparent", 3, false), rest = /* @__PURE__ */ rest_props($$props, [
    "$$slots",
    "$$events",
    "$$legacy",
    "x",
    "y",
    "width",
    "height",
    "selectEdgeOnClick",
    "transparent",
    "class",
    "children"
  ]);
  const store = useStore();
  const id2 = getContext("svelteflow__edge_id");
  let z2 = /* @__PURE__ */ user_derived(() => {
    var _a2;
    return (_a2 = store.visible.edges.get(id2)) == null ? void 0 : _a2.zIndex;
  });
  var div = root$y();
  var event_handler = () => {
    if (selectEdgeOnClick() && id2) store.handleEdgeSelection(id2);
  };
  attribute_effect(
    div,
    ($0, $1, $2) => {
      var _a2, _b2;
      return __spreadProps(__spreadValues({
        class: [
          "svelte-flow__edge-label",
          { transparent: transparent() },
          $$props.class
        ],
        tabindex: "-1",
        onclick: event_handler
      }, rest), {
        [STYLE]: {
          display: $0,
          cursor: selectEdgeOnClick() ? "pointer" : void 0,
          transform: `translate(-50%, -50%) translate(${(_a2 = x()) != null ? _a2 : ""}px,${(_b2 = y2()) != null ? _b2 : ""}px)`,
          "pointer-events": "all",
          width: $1,
          height: $2,
          "z-index": get$3(z2)
        }
      });
    },
    [
      () => hideOnSSR().value ? "none" : void 0,
      () => toPxString($$props.width),
      () => toPxString($$props.height)
    ],
    "svelte-w2n27y"
  );
  var node = child(div);
  snippet(node, () => {
    var _a2;
    return (_a2 = $$props.children) != null ? _a2 : noop$1;
  });
  action(div, ($$node, $$action_arg) => portal == null ? void 0 : portal($$node, $$action_arg), () => "edge-labels");
  append($$anchor, div);
  pop();
}
var root_1$h = /* @__PURE__ */ from_svg(`<path></path>`);
var root$x = /* @__PURE__ */ from_svg(`<path fill="none"></path><!><!>`, 1);
function BaseEdge($$anchor, $$props) {
  let interactionWidth = prop($$props, "interactionWidth", 3, 20), rest = /* @__PURE__ */ rest_props($$props, [
    "$$slots",
    "$$events",
    "$$legacy",
    "id",
    "path",
    "label",
    "labelX",
    "labelY",
    "labelStyle",
    "markerStart",
    "markerEnd",
    "style",
    "interactionWidth",
    "class"
  ]);
  var fragment = root$x();
  var path_1 = first_child(fragment);
  var node = sibling(path_1);
  {
    var consequent = ($$anchor2) => {
      var path_2 = root_1$h();
      attribute_effect(path_2, () => __spreadValues({
        d: $$props.path,
        "stroke-opacity": 0,
        "stroke-width": interactionWidth(),
        fill: "none",
        class: "svelte-flow__edge-interaction"
      }, rest));
      append($$anchor2, path_2);
    };
    if_block(node, ($$render) => {
      if (interactionWidth() > 0) $$render(consequent);
    });
  }
  var node_1 = sibling(node);
  {
    var consequent_1 = ($$anchor2) => {
      EdgeLabel($$anchor2, {
        get x() {
          return $$props.labelX;
        },
        get y() {
          return $$props.labelY;
        },
        get style() {
          return $$props.labelStyle;
        },
        selectEdgeOnClick: true,
        children: ($$anchor3, $$slotProps) => {
          var text$1 = text();
          template_effect(() => set_text(text$1, $$props.label));
          append($$anchor3, text$1);
        },
        $$slots: { default: true }
      });
    };
    if_block(node_1, ($$render) => {
      if ($$props.label) $$render(consequent_1);
    });
  }
  template_effect(() => {
    set_attribute(path_1, "id", $$props.id);
    set_attribute(path_1, "d", $$props.path);
    set_class(path_1, 0, clsx(["svelte-flow__edge-path", $$props.class]));
    set_attribute(path_1, "marker-start", $$props.markerStart);
    set_attribute(path_1, "marker-end", $$props.markerEnd);
    set_style(path_1, $$props.style);
  });
  append($$anchor, fragment);
}
function BezierEdge($$anchor, $$props) {
  push($$props, true);
  let $$d = /* @__PURE__ */ user_derived(() => {
    var _a2;
    return getBezierPath({
      sourceX: $$props.sourceX,
      sourceY: $$props.sourceY,
      targetX: $$props.targetX,
      targetY: $$props.targetY,
      sourcePosition: $$props.sourcePosition,
      targetPosition: $$props.targetPosition,
      curvature: (_a2 = $$props.pathOptions) == null ? void 0 : _a2.curvature
    });
  }), $$array = /* @__PURE__ */ user_derived(() => to_array(get$3($$d), 3)), path = /* @__PURE__ */ user_derived(() => get$3($$array)[0]), labelX = /* @__PURE__ */ user_derived(() => get$3($$array)[1]), labelY = /* @__PURE__ */ user_derived(() => get$3($$array)[2]);
  BaseEdge($$anchor, {
    get id() {
      return $$props.id;
    },
    get path() {
      return get$3(path);
    },
    get labelX() {
      return get$3(labelX);
    },
    get labelY() {
      return get$3(labelY);
    },
    get label() {
      return $$props.label;
    },
    get labelStyle() {
      return $$props.labelStyle;
    },
    get markerStart() {
      return $$props.markerStart;
    },
    get markerEnd() {
      return $$props.markerEnd;
    },
    get interactionWidth() {
      return $$props.interactionWidth;
    },
    get style() {
      return $$props.style;
    }
  });
  pop();
}
function SmoothStepEdgeInternal($$anchor, $$props) {
  push($$props, true);
  let $$d = /* @__PURE__ */ user_derived(() => getSmoothStepPath({
    sourceX: $$props.sourceX,
    sourceY: $$props.sourceY,
    targetX: $$props.targetX,
    targetY: $$props.targetY,
    sourcePosition: $$props.sourcePosition,
    targetPosition: $$props.targetPosition
  })), $$array = /* @__PURE__ */ user_derived(() => to_array(get$3($$d), 3)), path = /* @__PURE__ */ user_derived(() => get$3($$array)[0]), labelX = /* @__PURE__ */ user_derived(() => get$3($$array)[1]), labelY = /* @__PURE__ */ user_derived(() => get$3($$array)[2]);
  BaseEdge($$anchor, {
    get path() {
      return get$3(path);
    },
    get labelX() {
      return get$3(labelX);
    },
    get labelY() {
      return get$3(labelY);
    },
    get label() {
      return $$props.label;
    },
    get labelStyle() {
      return $$props.labelStyle;
    },
    get markerStart() {
      return $$props.markerStart;
    },
    get markerEnd() {
      return $$props.markerEnd;
    },
    get interactionWidth() {
      return $$props.interactionWidth;
    },
    get style() {
      return $$props.style;
    }
  });
  pop();
}
function StraightEdgeInternal($$anchor, $$props) {
  push($$props, true);
  let $$d = /* @__PURE__ */ user_derived(() => getStraightPath({
    sourceX: $$props.sourceX,
    sourceY: $$props.sourceY,
    targetX: $$props.targetX,
    targetY: $$props.targetY
  })), $$array = /* @__PURE__ */ user_derived(() => to_array(get$3($$d), 3)), path = /* @__PURE__ */ user_derived(() => get$3($$array)[0]), labelX = /* @__PURE__ */ user_derived(() => get$3($$array)[1]), labelY = /* @__PURE__ */ user_derived(() => get$3($$array)[2]);
  BaseEdge($$anchor, {
    get path() {
      return get$3(path);
    },
    get labelX() {
      return get$3(labelX);
    },
    get labelY() {
      return get$3(labelY);
    },
    get label() {
      return $$props.label;
    },
    get labelStyle() {
      return $$props.labelStyle;
    },
    get markerStart() {
      return $$props.markerStart;
    },
    get markerEnd() {
      return $$props.markerEnd;
    },
    get interactionWidth() {
      return $$props.interactionWidth;
    },
    get style() {
      return $$props.style;
    }
  });
  pop();
}
function StepEdgeInternal($$anchor, $$props) {
  push($$props, true);
  let $$d = /* @__PURE__ */ user_derived(() => getSmoothStepPath({
    sourceX: $$props.sourceX,
    sourceY: $$props.sourceY,
    targetX: $$props.targetX,
    targetY: $$props.targetY,
    sourcePosition: $$props.sourcePosition,
    targetPosition: $$props.targetPosition,
    borderRadius: 0
  })), $$array = /* @__PURE__ */ user_derived(() => to_array(get$3($$d), 3)), path = /* @__PURE__ */ user_derived(() => get$3($$array)[0]), labelX = /* @__PURE__ */ user_derived(() => get$3($$array)[1]), labelY = /* @__PURE__ */ user_derived(() => get$3($$array)[2]);
  BaseEdge($$anchor, {
    get path() {
      return get$3(path);
    },
    get labelX() {
      return get$3(labelX);
    },
    get labelY() {
      return get$3(labelY);
    },
    get label() {
      return $$props.label;
    },
    get labelStyle() {
      return $$props.labelStyle;
    },
    get markerStart() {
      return $$props.markerStart;
    },
    get markerEnd() {
      return $$props.markerEnd;
    },
    get interactionWidth() {
      return $$props.interactionWidth;
    },
    get style() {
      return $$props.style;
    }
  });
  pop();
}
function increment(source2) {
  set$2(source2, source2.v + 1);
}
function createSubscriber(start2) {
  let subscribers = 0;
  let version = source(0);
  let stop;
  return () => {
    if (effect_tracking()) {
      get$3(version);
      render_effect(() => {
        if (subscribers === 0) {
          stop = untrack(() => start2(() => increment(version)));
        }
        subscribers += 1;
        return () => {
          tick().then(() => {
            subscribers -= 1;
            if (subscribers === 0) {
              stop == null ? void 0 : stop();
              stop = void 0;
            }
          });
        };
      });
    }
  };
}
class ReactiveValue {
  /**
   *
   * @param {() => T} fn
   * @param {(update: () => void) => void} onsubscribe
   */
  constructor(fn, onsubscribe) {
    __privateAdd(this, _fn);
    __privateAdd(this, _subscribe);
    __privateSet(this, _fn, fn);
    __privateSet(this, _subscribe, createSubscriber(onsubscribe));
  }
  get current() {
    __privateGet(this, _subscribe).call(this);
    return __privateGet(this, _fn).call(this);
  }
}
_fn = new WeakMap();
_subscribe = new WeakMap();
const parenthesis_regex = /\(.+\)/;
const non_parenthesized_keywords = /* @__PURE__ */ new Set(["all", "print", "screen", "and", "or", "not", "only"]);
class MediaQuery extends ReactiveValue {
  /**
   * @param {string} query A media query string
   * @param {boolean} [fallback] Fallback value for the server
   */
  constructor(query, fallback2) {
    let final_query = parenthesis_regex.test(query) || // we need to use `some` here because technically this `window.matchMedia('random,screen')` still returns true
    query.split(/[\s,]+/).some((keyword) => non_parenthesized_keywords.has(keyword.trim())) ? query : `(${query})`;
    const q2 = window.matchMedia(final_query);
    super(
      () => q2.matches,
      (update2) => on(q2, "change", update2)
    );
  }
}
function getVisibleNodes(nodeLookup, transform2, width, height) {
  const visibleNodes = /* @__PURE__ */ new Map();
  getNodesInside(nodeLookup, { x: 0, y: 0, width, height }, transform2, true).forEach((node) => {
    visibleNodes.set(node.id, node);
  });
  return visibleNodes;
}
function getLayoutedEdges(options) {
  var _a2;
  const { edges, defaultEdgeOptions, nodeLookup, previousEdges, connectionMode, onerror, onlyRenderVisible, elevateEdgesOnSelect } = options;
  const layoutedEdges = /* @__PURE__ */ new Map();
  for (const edge of edges) {
    const sourceNode = nodeLookup.get(edge.source);
    const targetNode = nodeLookup.get(edge.target);
    if (!sourceNode || !targetNode) {
      continue;
    }
    if (onlyRenderVisible) {
      const { visibleNodes, transform: transform2, width, height } = options;
      if (isEdgeVisible({
        sourceNode,
        targetNode,
        width,
        height,
        transform: transform2
      })) {
        visibleNodes.set(sourceNode.id, sourceNode);
        visibleNodes.set(targetNode.id, targetNode);
      } else {
        continue;
      }
    }
    const previous = previousEdges.get(edge.id);
    if (previous && edge === previous.edge && sourceNode == previous.sourceNode && targetNode == previous.targetNode) {
      layoutedEdges.set(edge.id, previous);
      continue;
    }
    const edgePosition = getEdgePosition({
      id: edge.id,
      sourceNode,
      targetNode,
      sourceHandle: edge.sourceHandle || null,
      targetHandle: edge.targetHandle || null,
      connectionMode,
      onError: onerror
    });
    if (edgePosition) {
      layoutedEdges.set(edge.id, __spreadProps(__spreadValues(__spreadValues(__spreadValues({}, defaultEdgeOptions), edge), edgePosition), {
        zIndex: getElevatedEdgeZIndex({
          selected: edge.selected,
          zIndex: (_a2 = edge.zIndex) != null ? _a2 : defaultEdgeOptions.zIndex,
          sourceNode,
          targetNode,
          elevateOnSelect: elevateEdgesOnSelect
        }),
        sourceNode,
        targetNode,
        edge
      }));
    }
  }
  return layoutedEdges;
}
const initialNodeTypes = {
  input: InputNode,
  output: OutputNode,
  default: DefaultNode,
  group: GroupNode
};
const initialEdgeTypes = {
  straight: StraightEdgeInternal,
  smoothstep: SmoothStepEdgeInternal,
  default: BezierEdge,
  step: StepEdgeInternal
};
function getInitialViewport(_nodesInitialized, fitView, initialViewport, width, height, nodeLookup) {
  if (fitView && !initialViewport && width && height) {
    const bounds = getInternalNodesBounds(nodeLookup, {
      filter: (node) => !!((node.width || node.initialWidth) && (node.height || node.initialHeight))
    });
    return getViewportForBounds(bounds, width, height, 0.5, 2, 0.1);
  } else {
    return initialViewport != null ? initialViewport : { x: 0, y: 0, zoom: 1 };
  }
}
function getInitialStore(signals) {
  var _a2, _b2, _c2, _flowId, _domNode, _panZoom, _width, _height, _nodesInitialized, _viewportInitialized, __edges, _selectedNodes, _selectedEdges, _visible, _nodesDraggable, _nodesConnectable, _elementsSelectable, _nodesFocusable, _edgesFocusable, _disableKeyboardA11y, _minZoom, _maxZoom, _nodeOrigin, _nodeExtent, _translateExtent, _defaultEdgeOptions, _nodeDragThreshold, _autoPanOnNodeDrag, _autoPanOnConnect, _autoPanOnNodeFocus, _connectionDragThreshold, _snapGrid, _dragging, _selectionRect, _selectionKeyPressed, _multiselectionKeyPressed, _deleteKeyPressed, _panActivationKeyPressed, _zoomActivationKeyPressed, _selectionRectMode, _ariaLiveMessage, _selectionMode, _nodeTypes, _edgeTypes, _noPanClass, _noDragClass, _noWheelClass, _ariaLabelConfig, __viewport, __connection, _connection, _connectionMode, _connectionRadius, _isValidConnection, _selectNodesOnDrag, _defaultMarkerColor, _markers, _onlyRenderVisibleElements, _onerror, _ondelete, _onbeforedelete, _onbeforeconnect, _onconnect, _onconnectstart, _onconnectend, _onbeforereconnect, _onreconnect, _onreconnectstart, _onreconnectend, _clickConnect, _onclickconnectstart, _onclickconnectend, _clickConnectStartHandle, _onselectiondrag, _onselectiondragstart, _onselectiondragstop, _colorMode;
  class SvelteFlowStore {
    constructor() {
      __privateAdd(this, _flowId, /* @__PURE__ */ user_derived(() => {
        var _a3;
        return (_a3 = signals.props.id) != null ? _a3 : "1";
      }));
      __privateAdd(this, _domNode, /* @__PURE__ */ state(null));
      __privateAdd(this, _panZoom, /* @__PURE__ */ state(null));
      __privateAdd(this, _width, /* @__PURE__ */ state((_a2 = signals.width) != null ? _a2 : 0));
      __privateAdd(this, _height, /* @__PURE__ */ state((_b2 = signals.height) != null ? _b2 : 0));
      __privateAdd(this, _nodesInitialized, /* @__PURE__ */ user_derived(() => {
        var _a3, _b3;
        const nodesInitialized = adoptUserNodes(signals.nodes, this.nodeLookup, this.parentLookup, {
          nodeExtent: this.nodeExtent,
          nodeOrigin: this.nodeOrigin,
          elevateNodesOnSelect: (_a3 = signals.props.elevateNodesOnSelect) != null ? _a3 : true,
          checkEquality: true
        });
        if (this.fitViewQueued && nodesInitialized) {
          if ((_b3 = this.fitViewOptions) == null ? void 0 : _b3.duration) {
            this.resolveFitView();
          } else {
            queueMicrotask(() => {
              this.resolveFitView();
            });
          }
        }
        return nodesInitialized;
      }));
      __privateAdd(this, _viewportInitialized, /* @__PURE__ */ user_derived(() => this.panZoom !== null));
      __privateAdd(this, __edges, /* @__PURE__ */ user_derived(() => {
        updateConnectionLookup(this.connectionLookup, this.edgeLookup, signals.edges);
        return signals.edges;
      }));
      __publicField(this, "_prevSelectedNodes", []);
      __publicField(this, "_prevSelectedNodeIds", /* @__PURE__ */ new Set());
      __privateAdd(this, _selectedNodes, /* @__PURE__ */ user_derived(() => {
        const selectedNodesCount = this._prevSelectedNodeIds.size;
        const selectedNodeIds = /* @__PURE__ */ new Set();
        const selectedNodes = this.nodes.filter((node) => {
          if (node.selected) {
            selectedNodeIds.add(node.id);
            this._prevSelectedNodeIds.delete(node.id);
          }
          return node.selected;
        });
        if (selectedNodesCount !== selectedNodeIds.size || this._prevSelectedNodeIds.size > 0) {
          this._prevSelectedNodes = selectedNodes;
        }
        this._prevSelectedNodeIds = selectedNodeIds;
        return this._prevSelectedNodes;
      }));
      __publicField(this, "_prevSelectedEdges", []);
      __publicField(this, "_prevSelectedEdgeIds", /* @__PURE__ */ new Set());
      __privateAdd(this, _selectedEdges, /* @__PURE__ */ user_derived(() => {
        const selectedEdgesCount = this._prevSelectedEdgeIds.size;
        const selectedEdgeIds = /* @__PURE__ */ new Set();
        const selectedEdges = this.edges.filter((edge) => {
          if (edge.selected) {
            selectedEdgeIds.add(edge.id);
            this._prevSelectedEdgeIds.delete(edge.id);
          }
          return edge.selected;
        });
        if (selectedEdgesCount !== selectedEdgeIds.size || this._prevSelectedEdgeIds.size > 0) {
          this._prevSelectedEdges = selectedEdges;
        }
        this._prevSelectedEdgeIds = selectedEdgeIds;
        return this._prevSelectedEdges;
      }));
      __publicField(this, "selectionChangeHandlers", /* @__PURE__ */ new Map());
      __publicField(this, "nodeLookup", /* @__PURE__ */ new Map());
      __publicField(this, "parentLookup", /* @__PURE__ */ new Map());
      __publicField(this, "connectionLookup", /* @__PURE__ */ new Map());
      __publicField(this, "edgeLookup", /* @__PURE__ */ new Map());
      __publicField(this, "_prevVisibleEdges", /* @__PURE__ */ new Map());
      __privateAdd(this, _visible, /* @__PURE__ */ user_derived(() => {
        var _a3;
        const {
          // We need to access this._nodes to trigger on changes
          // eslint-disable-next-line @typescript-eslint/no-unused-vars
          nodes,
          _edges: edges,
          _prevVisibleEdges: previousEdges,
          nodeLookup,
          connectionMode,
          onerror,
          onlyRenderVisibleElements,
          defaultEdgeOptions
        } = this;
        let visibleNodes;
        let visibleEdges;
        const options = {
          edges,
          defaultEdgeOptions,
          previousEdges,
          nodeLookup,
          connectionMode,
          elevateEdgesOnSelect: (_a3 = signals.props.elevateEdgesOnSelect) != null ? _a3 : true,
          onerror
        };
        if (onlyRenderVisibleElements) {
          const { viewport, width, height } = this;
          const transform2 = [viewport.x, viewport.y, viewport.zoom];
          visibleNodes = getVisibleNodes(nodeLookup, transform2, width, height);
          visibleEdges = getLayoutedEdges(__spreadProps(__spreadValues({}, options), {
            onlyRenderVisible: true,
            visibleNodes,
            transform: transform2,
            width,
            height
          }));
        } else {
          visibleNodes = this.nodeLookup;
          visibleEdges = getLayoutedEdges(options);
        }
        return { nodes: visibleNodes, edges: visibleEdges };
      }));
      __privateAdd(this, _nodesDraggable, /* @__PURE__ */ user_derived(() => {
        var _a3;
        return (_a3 = signals.props.nodesDraggable) != null ? _a3 : true;
      }));
      __privateAdd(this, _nodesConnectable, /* @__PURE__ */ user_derived(() => {
        var _a3;
        return (_a3 = signals.props.nodesConnectable) != null ? _a3 : true;
      }));
      __privateAdd(this, _elementsSelectable, /* @__PURE__ */ user_derived(() => {
        var _a3;
        return (_a3 = signals.props.elementsSelectable) != null ? _a3 : true;
      }));
      __privateAdd(this, _nodesFocusable, /* @__PURE__ */ user_derived(() => {
        var _a3;
        return (_a3 = signals.props.nodesFocusable) != null ? _a3 : true;
      }));
      __privateAdd(this, _edgesFocusable, /* @__PURE__ */ user_derived(() => {
        var _a3;
        return (_a3 = signals.props.edgesFocusable) != null ? _a3 : true;
      }));
      __privateAdd(this, _disableKeyboardA11y, /* @__PURE__ */ user_derived(() => {
        var _a3;
        return (_a3 = signals.props.disableKeyboardA11y) != null ? _a3 : false;
      }));
      __privateAdd(this, _minZoom, /* @__PURE__ */ user_derived(() => {
        var _a3;
        return (_a3 = signals.props.minZoom) != null ? _a3 : 0.5;
      }));
      __privateAdd(this, _maxZoom, /* @__PURE__ */ user_derived(() => {
        var _a3;
        return (_a3 = signals.props.maxZoom) != null ? _a3 : 2;
      }));
      __privateAdd(this, _nodeOrigin, /* @__PURE__ */ user_derived(() => {
        var _a3;
        return (_a3 = signals.props.nodeOrigin) != null ? _a3 : [0, 0];
      }));
      __privateAdd(this, _nodeExtent, /* @__PURE__ */ user_derived(() => {
        var _a3;
        return (_a3 = signals.props.nodeExtent) != null ? _a3 : infiniteExtent;
      }));
      __privateAdd(this, _translateExtent, /* @__PURE__ */ user_derived(() => {
        var _a3;
        return (_a3 = signals.props.translateExtent) != null ? _a3 : infiniteExtent;
      }));
      __privateAdd(this, _defaultEdgeOptions, /* @__PURE__ */ user_derived(() => {
        var _a3;
        return (_a3 = signals.props.defaultEdgeOptions) != null ? _a3 : {};
      }));
      __privateAdd(this, _nodeDragThreshold, /* @__PURE__ */ user_derived(() => {
        var _a3;
        return (_a3 = signals.props.nodeDragThreshold) != null ? _a3 : 1;
      }));
      __privateAdd(this, _autoPanOnNodeDrag, /* @__PURE__ */ user_derived(() => {
        var _a3;
        return (_a3 = signals.props.autoPanOnNodeDrag) != null ? _a3 : true;
      }));
      __privateAdd(this, _autoPanOnConnect, /* @__PURE__ */ user_derived(() => {
        var _a3;
        return (_a3 = signals.props.autoPanOnConnect) != null ? _a3 : true;
      }));
      __privateAdd(this, _autoPanOnNodeFocus, /* @__PURE__ */ user_derived(() => {
        var _a3;
        return (_a3 = signals.props.autoPanOnNodeFocus) != null ? _a3 : true;
      }));
      __privateAdd(this, _connectionDragThreshold, /* @__PURE__ */ user_derived(() => {
        var _a3;
        return (_a3 = signals.props.connectionDragThreshold) != null ? _a3 : 1;
      }));
      __publicField(this, "fitViewQueued", (_c2 = signals.props.fitView) != null ? _c2 : false);
      __publicField(this, "fitViewOptions", signals.props.fitViewOptions);
      __publicField(this, "fitViewResolver", null);
      __privateAdd(this, _snapGrid, /* @__PURE__ */ user_derived(() => {
        var _a3;
        return (_a3 = signals.props.snapGrid) != null ? _a3 : null;
      }));
      __privateAdd(this, _dragging, /* @__PURE__ */ state(false));
      __privateAdd(this, _selectionRect, /* @__PURE__ */ state(null));
      __privateAdd(this, _selectionKeyPressed, /* @__PURE__ */ state(false));
      __privateAdd(this, _multiselectionKeyPressed, /* @__PURE__ */ state(false));
      __privateAdd(this, _deleteKeyPressed, /* @__PURE__ */ state(false));
      __privateAdd(this, _panActivationKeyPressed, /* @__PURE__ */ state(false));
      __privateAdd(this, _zoomActivationKeyPressed, /* @__PURE__ */ state(false));
      __privateAdd(this, _selectionRectMode, /* @__PURE__ */ state(null));
      __privateAdd(this, _ariaLiveMessage, /* @__PURE__ */ state(""));
      __privateAdd(this, _selectionMode, /* @__PURE__ */ user_derived(() => {
        var _a3;
        return (_a3 = signals.props.selectionMode) != null ? _a3 : SelectionMode.Partial;
      }));
      __privateAdd(this, _nodeTypes, /* @__PURE__ */ user_derived(() => __spreadValues(__spreadValues({}, initialNodeTypes), signals.props.nodeTypes)));
      __privateAdd(this, _edgeTypes, /* @__PURE__ */ user_derived(() => __spreadValues(__spreadValues({}, initialEdgeTypes), signals.props.edgeTypes)));
      __privateAdd(this, _noPanClass, /* @__PURE__ */ user_derived(() => {
        var _a3;
        return (_a3 = signals.props.noPanClass) != null ? _a3 : "nopan";
      }));
      __privateAdd(this, _noDragClass, /* @__PURE__ */ user_derived(() => {
        var _a3;
        return (_a3 = signals.props.noDragClass) != null ? _a3 : "nodrag";
      }));
      __privateAdd(this, _noWheelClass, /* @__PURE__ */ user_derived(() => {
        var _a3;
        return (_a3 = signals.props.noWheelClass) != null ? _a3 : "nowheel";
      }));
      __privateAdd(this, _ariaLabelConfig, /* @__PURE__ */ user_derived(() => mergeAriaLabelConfig(signals.props.ariaLabelConfig)));
      __privateAdd(this, __viewport, /* @__PURE__ */ state(getInitialViewport(this.nodesInitialized, signals.props.fitView, signals.props.initialViewport, this.width, this.height, this.nodeLookup)));
      __privateAdd(this, __connection, /* @__PURE__ */ state(initialConnection));
      __privateAdd(this, _connection, /* @__PURE__ */ user_derived(() => {
        if (!this._connection.inProgress) {
          return this._connection;
        }
        return __spreadProps(__spreadValues({}, this._connection), {
          to: pointToRendererPoint(this._connection.to, [
            this.viewport.x,
            this.viewport.y,
            this.viewport.zoom
          ])
        });
      }));
      __privateAdd(this, _connectionMode, /* @__PURE__ */ user_derived(() => {
        var _a3;
        return (_a3 = signals.props.connectionMode) != null ? _a3 : ConnectionMode.Strict;
      }));
      __privateAdd(this, _connectionRadius, /* @__PURE__ */ user_derived(() => {
        var _a3;
        return (_a3 = signals.props.connectionRadius) != null ? _a3 : 20;
      }));
      __privateAdd(this, _isValidConnection, /* @__PURE__ */ user_derived(() => {
        var _a3;
        return (_a3 = signals.props.isValidConnection) != null ? _a3 : () => true;
      }));
      __privateAdd(this, _selectNodesOnDrag, /* @__PURE__ */ user_derived(() => {
        var _a3;
        return (_a3 = signals.props.selectNodesOnDrag) != null ? _a3 : true;
      }));
      __privateAdd(this, _defaultMarkerColor, /* @__PURE__ */ user_derived(() => {
        var _a3;
        return (_a3 = signals.props.defaultMarkerColor) != null ? _a3 : "#b1b1b7";
      }));
      __privateAdd(this, _markers, /* @__PURE__ */ user_derived(() => {
        return createMarkerIds(signals.edges, {
          defaultColor: this.defaultMarkerColor,
          id: this.flowId,
          defaultMarkerStart: this.defaultEdgeOptions.markerStart,
          defaultMarkerEnd: this.defaultEdgeOptions.markerEnd
        });
      }));
      __privateAdd(this, _onlyRenderVisibleElements, /* @__PURE__ */ user_derived(() => {
        var _a3;
        return (_a3 = signals.props.onlyRenderVisibleElements) != null ? _a3 : false;
      }));
      __privateAdd(this, _onerror, /* @__PURE__ */ user_derived(() => {
        var _a3;
        return (_a3 = signals.props.onflowerror) != null ? _a3 : devWarn;
      }));
      __privateAdd(this, _ondelete, /* @__PURE__ */ user_derived(() => signals.props.ondelete));
      __privateAdd(this, _onbeforedelete, /* @__PURE__ */ user_derived(() => signals.props.onbeforedelete));
      __privateAdd(this, _onbeforeconnect, /* @__PURE__ */ user_derived(() => signals.props.onbeforeconnect));
      __privateAdd(this, _onconnect, /* @__PURE__ */ user_derived(() => signals.props.onconnect));
      __privateAdd(this, _onconnectstart, /* @__PURE__ */ user_derived(() => signals.props.onconnectstart));
      __privateAdd(this, _onconnectend, /* @__PURE__ */ user_derived(() => signals.props.onconnectend));
      __privateAdd(this, _onbeforereconnect, /* @__PURE__ */ user_derived(() => signals.props.onbeforereconnect));
      __privateAdd(this, _onreconnect, /* @__PURE__ */ user_derived(() => signals.props.onreconnect));
      __privateAdd(this, _onreconnectstart, /* @__PURE__ */ user_derived(() => signals.props.onreconnectstart));
      __privateAdd(this, _onreconnectend, /* @__PURE__ */ user_derived(() => signals.props.onreconnectend));
      __privateAdd(this, _clickConnect, /* @__PURE__ */ user_derived(() => {
        var _a3;
        return (_a3 = signals.props.clickConnect) != null ? _a3 : true;
      }));
      __privateAdd(this, _onclickconnectstart, /* @__PURE__ */ user_derived(() => signals.props.onclickconnectstart));
      __privateAdd(this, _onclickconnectend, /* @__PURE__ */ user_derived(() => signals.props.onclickconnectend));
      __privateAdd(this, _clickConnectStartHandle, /* @__PURE__ */ state(null));
      __privateAdd(this, _onselectiondrag, /* @__PURE__ */ user_derived(() => signals.props.onselectiondrag));
      __privateAdd(this, _onselectiondragstart, /* @__PURE__ */ user_derived(() => signals.props.onselectiondragstart));
      __privateAdd(this, _onselectiondragstop, /* @__PURE__ */ user_derived(() => signals.props.onselectiondragstop));
      __publicField(this, "resolveFitView", () => __async(this, null, function* () {
        var _a3;
        if (!this.panZoom) {
          return;
        }
        yield fitViewport(
          {
            nodes: this.nodeLookup,
            width: this.width,
            height: this.height,
            panZoom: this.panZoom,
            minZoom: this.minZoom,
            maxZoom: this.maxZoom
          },
          this.fitViewOptions
        );
        (_a3 = this.fitViewResolver) == null ? void 0 : _a3.resolve(true);
        this.fitViewQueued = false;
        this.fitViewOptions = void 0;
        this.fitViewResolver = null;
      }));
      __publicField(this, "_prefersDark", new MediaQuery("(prefers-color-scheme: dark)", signals.props.colorModeSSR === "dark"));
      __privateAdd(this, _colorMode, /* @__PURE__ */ user_derived(() => {
        var _a3;
        return signals.props.colorMode === "system" ? this._prefersDark.current ? "dark" : "light" : (_a3 = signals.props.colorMode) != null ? _a3 : "light";
      }));
    }
    get flowId() {
      return get$3(__privateGet(this, _flowId));
    }
    set flowId(value) {
      set$2(__privateGet(this, _flowId), value);
    }
    get domNode() {
      return get$3(__privateGet(this, _domNode));
    }
    set domNode(value) {
      set$2(__privateGet(this, _domNode), value);
    }
    get panZoom() {
      return get$3(__privateGet(this, _panZoom));
    }
    set panZoom(value) {
      set$2(__privateGet(this, _panZoom), value);
    }
    get width() {
      return get$3(__privateGet(this, _width));
    }
    set width(value) {
      set$2(__privateGet(this, _width), value);
    }
    get height() {
      return get$3(__privateGet(this, _height));
    }
    set height(value) {
      set$2(__privateGet(this, _height), value);
    }
    get nodesInitialized() {
      return get$3(__privateGet(this, _nodesInitialized));
    }
    set nodesInitialized(value) {
      set$2(__privateGet(this, _nodesInitialized), value);
    }
    get viewportInitialized() {
      return get$3(__privateGet(this, _viewportInitialized));
    }
    set viewportInitialized(value) {
      set$2(__privateGet(this, _viewportInitialized), value);
    }
    get _edges() {
      return get$3(__privateGet(this, __edges));
    }
    set _edges(value) {
      set$2(__privateGet(this, __edges), value);
    }
    get nodes() {
      this.nodesInitialized;
      return signals.nodes;
    }
    set nodes(nodes) {
      signals.nodes = nodes;
    }
    get edges() {
      return this._edges;
    }
    set edges(edges) {
      signals.edges = edges;
    }
    get selectedNodes() {
      return get$3(__privateGet(this, _selectedNodes));
    }
    set selectedNodes(value) {
      set$2(__privateGet(this, _selectedNodes), value);
    }
    get selectedEdges() {
      return get$3(__privateGet(this, _selectedEdges));
    }
    set selectedEdges(value) {
      set$2(__privateGet(this, _selectedEdges), value);
    }
    get visible() {
      return get$3(__privateGet(this, _visible));
    }
    set visible(value) {
      set$2(__privateGet(this, _visible), value);
    }
    get nodesDraggable() {
      return get$3(__privateGet(this, _nodesDraggable));
    }
    set nodesDraggable(value) {
      set$2(__privateGet(this, _nodesDraggable), value);
    }
    get nodesConnectable() {
      return get$3(__privateGet(this, _nodesConnectable));
    }
    set nodesConnectable(value) {
      set$2(__privateGet(this, _nodesConnectable), value);
    }
    get elementsSelectable() {
      return get$3(__privateGet(this, _elementsSelectable));
    }
    set elementsSelectable(value) {
      set$2(__privateGet(this, _elementsSelectable), value);
    }
    get nodesFocusable() {
      return get$3(__privateGet(this, _nodesFocusable));
    }
    set nodesFocusable(value) {
      set$2(__privateGet(this, _nodesFocusable), value);
    }
    get edgesFocusable() {
      return get$3(__privateGet(this, _edgesFocusable));
    }
    set edgesFocusable(value) {
      set$2(__privateGet(this, _edgesFocusable), value);
    }
    get disableKeyboardA11y() {
      return get$3(__privateGet(this, _disableKeyboardA11y));
    }
    set disableKeyboardA11y(value) {
      set$2(__privateGet(this, _disableKeyboardA11y), value);
    }
    get minZoom() {
      return get$3(__privateGet(this, _minZoom));
    }
    set minZoom(value) {
      set$2(__privateGet(this, _minZoom), value);
    }
    get maxZoom() {
      return get$3(__privateGet(this, _maxZoom));
    }
    set maxZoom(value) {
      set$2(__privateGet(this, _maxZoom), value);
    }
    get nodeOrigin() {
      return get$3(__privateGet(this, _nodeOrigin));
    }
    set nodeOrigin(value) {
      set$2(__privateGet(this, _nodeOrigin), value);
    }
    get nodeExtent() {
      return get$3(__privateGet(this, _nodeExtent));
    }
    set nodeExtent(value) {
      set$2(__privateGet(this, _nodeExtent), value);
    }
    get translateExtent() {
      return get$3(__privateGet(this, _translateExtent));
    }
    set translateExtent(value) {
      set$2(__privateGet(this, _translateExtent), value);
    }
    get defaultEdgeOptions() {
      return get$3(__privateGet(this, _defaultEdgeOptions));
    }
    set defaultEdgeOptions(value) {
      set$2(__privateGet(this, _defaultEdgeOptions), value);
    }
    get nodeDragThreshold() {
      return get$3(__privateGet(this, _nodeDragThreshold));
    }
    set nodeDragThreshold(value) {
      set$2(__privateGet(this, _nodeDragThreshold), value);
    }
    get autoPanOnNodeDrag() {
      return get$3(__privateGet(this, _autoPanOnNodeDrag));
    }
    set autoPanOnNodeDrag(value) {
      set$2(__privateGet(this, _autoPanOnNodeDrag), value);
    }
    get autoPanOnConnect() {
      return get$3(__privateGet(this, _autoPanOnConnect));
    }
    set autoPanOnConnect(value) {
      set$2(__privateGet(this, _autoPanOnConnect), value);
    }
    get autoPanOnNodeFocus() {
      return get$3(__privateGet(this, _autoPanOnNodeFocus));
    }
    set autoPanOnNodeFocus(value) {
      set$2(__privateGet(this, _autoPanOnNodeFocus), value);
    }
    get connectionDragThreshold() {
      return get$3(__privateGet(this, _connectionDragThreshold));
    }
    set connectionDragThreshold(value) {
      set$2(__privateGet(this, _connectionDragThreshold), value);
    }
    get snapGrid() {
      return get$3(__privateGet(this, _snapGrid));
    }
    set snapGrid(value) {
      set$2(__privateGet(this, _snapGrid), value);
    }
    get dragging() {
      return get$3(__privateGet(this, _dragging));
    }
    set dragging(value) {
      set$2(__privateGet(this, _dragging), value);
    }
    get selectionRect() {
      return get$3(__privateGet(this, _selectionRect));
    }
    set selectionRect(value) {
      set$2(__privateGet(this, _selectionRect), value);
    }
    get selectionKeyPressed() {
      return get$3(__privateGet(this, _selectionKeyPressed));
    }
    set selectionKeyPressed(value) {
      set$2(__privateGet(this, _selectionKeyPressed), value);
    }
    get multiselectionKeyPressed() {
      return get$3(__privateGet(this, _multiselectionKeyPressed));
    }
    set multiselectionKeyPressed(value) {
      set$2(__privateGet(this, _multiselectionKeyPressed), value);
    }
    get deleteKeyPressed() {
      return get$3(__privateGet(this, _deleteKeyPressed));
    }
    set deleteKeyPressed(value) {
      set$2(__privateGet(this, _deleteKeyPressed), value);
    }
    get panActivationKeyPressed() {
      return get$3(__privateGet(this, _panActivationKeyPressed));
    }
    set panActivationKeyPressed(value) {
      set$2(__privateGet(this, _panActivationKeyPressed), value);
    }
    get zoomActivationKeyPressed() {
      return get$3(__privateGet(this, _zoomActivationKeyPressed));
    }
    set zoomActivationKeyPressed(value) {
      set$2(__privateGet(this, _zoomActivationKeyPressed), value);
    }
    get selectionRectMode() {
      return get$3(__privateGet(this, _selectionRectMode));
    }
    set selectionRectMode(value) {
      set$2(__privateGet(this, _selectionRectMode), value);
    }
    get ariaLiveMessage() {
      return get$3(__privateGet(this, _ariaLiveMessage));
    }
    set ariaLiveMessage(value) {
      set$2(__privateGet(this, _ariaLiveMessage), value);
    }
    get selectionMode() {
      return get$3(__privateGet(this, _selectionMode));
    }
    set selectionMode(value) {
      set$2(__privateGet(this, _selectionMode), value);
    }
    get nodeTypes() {
      return get$3(__privateGet(this, _nodeTypes));
    }
    set nodeTypes(value) {
      set$2(__privateGet(this, _nodeTypes), value);
    }
    get edgeTypes() {
      return get$3(__privateGet(this, _edgeTypes));
    }
    set edgeTypes(value) {
      set$2(__privateGet(this, _edgeTypes), value);
    }
    get noPanClass() {
      return get$3(__privateGet(this, _noPanClass));
    }
    set noPanClass(value) {
      set$2(__privateGet(this, _noPanClass), value);
    }
    get noDragClass() {
      return get$3(__privateGet(this, _noDragClass));
    }
    set noDragClass(value) {
      set$2(__privateGet(this, _noDragClass), value);
    }
    get noWheelClass() {
      return get$3(__privateGet(this, _noWheelClass));
    }
    set noWheelClass(value) {
      set$2(__privateGet(this, _noWheelClass), value);
    }
    get ariaLabelConfig() {
      return get$3(__privateGet(this, _ariaLabelConfig));
    }
    set ariaLabelConfig(value) {
      set$2(__privateGet(this, _ariaLabelConfig), value);
    }
    get _viewport() {
      return get$3(__privateGet(this, __viewport));
    }
    set _viewport(value) {
      set$2(__privateGet(this, __viewport), value);
    }
    get viewport() {
      var _a3;
      return (_a3 = signals.viewport) != null ? _a3 : this._viewport;
    }
    set viewport(newViewport) {
      if (signals.viewport) {
        signals.viewport = newViewport;
      }
      this._viewport = newViewport;
    }
    get _connection() {
      return get$3(__privateGet(this, __connection));
    }
    set _connection(value) {
      set$2(__privateGet(this, __connection), value);
    }
    get connection() {
      return get$3(__privateGet(this, _connection));
    }
    set connection(value) {
      set$2(__privateGet(this, _connection), value);
    }
    get connectionMode() {
      return get$3(__privateGet(this, _connectionMode));
    }
    set connectionMode(value) {
      set$2(__privateGet(this, _connectionMode), value);
    }
    get connectionRadius() {
      return get$3(__privateGet(this, _connectionRadius));
    }
    set connectionRadius(value) {
      set$2(__privateGet(this, _connectionRadius), value);
    }
    get isValidConnection() {
      return get$3(__privateGet(this, _isValidConnection));
    }
    set isValidConnection(value) {
      set$2(__privateGet(this, _isValidConnection), value);
    }
    get selectNodesOnDrag() {
      return get$3(__privateGet(this, _selectNodesOnDrag));
    }
    set selectNodesOnDrag(value) {
      set$2(__privateGet(this, _selectNodesOnDrag), value);
    }
    get defaultMarkerColor() {
      return get$3(__privateGet(this, _defaultMarkerColor));
    }
    set defaultMarkerColor(value) {
      set$2(__privateGet(this, _defaultMarkerColor), value);
    }
    get markers() {
      return get$3(__privateGet(this, _markers));
    }
    set markers(value) {
      set$2(__privateGet(this, _markers), value);
    }
    get onlyRenderVisibleElements() {
      return get$3(__privateGet(this, _onlyRenderVisibleElements));
    }
    set onlyRenderVisibleElements(value) {
      set$2(__privateGet(this, _onlyRenderVisibleElements), value);
    }
    get onerror() {
      return get$3(__privateGet(this, _onerror));
    }
    set onerror(value) {
      set$2(__privateGet(this, _onerror), value);
    }
    get ondelete() {
      return get$3(__privateGet(this, _ondelete));
    }
    set ondelete(value) {
      set$2(__privateGet(this, _ondelete), value);
    }
    get onbeforedelete() {
      return get$3(__privateGet(this, _onbeforedelete));
    }
    set onbeforedelete(value) {
      set$2(__privateGet(this, _onbeforedelete), value);
    }
    get onbeforeconnect() {
      return get$3(__privateGet(this, _onbeforeconnect));
    }
    set onbeforeconnect(value) {
      set$2(__privateGet(this, _onbeforeconnect), value);
    }
    get onconnect() {
      return get$3(__privateGet(this, _onconnect));
    }
    set onconnect(value) {
      set$2(__privateGet(this, _onconnect), value);
    }
    get onconnectstart() {
      return get$3(__privateGet(this, _onconnectstart));
    }
    set onconnectstart(value) {
      set$2(__privateGet(this, _onconnectstart), value);
    }
    get onconnectend() {
      return get$3(__privateGet(this, _onconnectend));
    }
    set onconnectend(value) {
      set$2(__privateGet(this, _onconnectend), value);
    }
    get onbeforereconnect() {
      return get$3(__privateGet(this, _onbeforereconnect));
    }
    set onbeforereconnect(value) {
      set$2(__privateGet(this, _onbeforereconnect), value);
    }
    get onreconnect() {
      return get$3(__privateGet(this, _onreconnect));
    }
    set onreconnect(value) {
      set$2(__privateGet(this, _onreconnect), value);
    }
    get onreconnectstart() {
      return get$3(__privateGet(this, _onreconnectstart));
    }
    set onreconnectstart(value) {
      set$2(__privateGet(this, _onreconnectstart), value);
    }
    get onreconnectend() {
      return get$3(__privateGet(this, _onreconnectend));
    }
    set onreconnectend(value) {
      set$2(__privateGet(this, _onreconnectend), value);
    }
    get clickConnect() {
      return get$3(__privateGet(this, _clickConnect));
    }
    set clickConnect(value) {
      set$2(__privateGet(this, _clickConnect), value);
    }
    get onclickconnectstart() {
      return get$3(__privateGet(this, _onclickconnectstart));
    }
    set onclickconnectstart(value) {
      set$2(__privateGet(this, _onclickconnectstart), value);
    }
    get onclickconnectend() {
      return get$3(__privateGet(this, _onclickconnectend));
    }
    set onclickconnectend(value) {
      set$2(__privateGet(this, _onclickconnectend), value);
    }
    get clickConnectStartHandle() {
      return get$3(__privateGet(this, _clickConnectStartHandle));
    }
    set clickConnectStartHandle(value) {
      set$2(__privateGet(this, _clickConnectStartHandle), value);
    }
    get onselectiondrag() {
      return get$3(__privateGet(this, _onselectiondrag));
    }
    set onselectiondrag(value) {
      set$2(__privateGet(this, _onselectiondrag), value);
    }
    get onselectiondragstart() {
      return get$3(__privateGet(this, _onselectiondragstart));
    }
    set onselectiondragstart(value) {
      set$2(__privateGet(this, _onselectiondragstart), value);
    }
    get onselectiondragstop() {
      return get$3(__privateGet(this, _onselectiondragstop));
    }
    set onselectiondragstop(value) {
      set$2(__privateGet(this, _onselectiondragstop), value);
    }
    get colorMode() {
      return get$3(__privateGet(this, _colorMode));
    }
    set colorMode(value) {
      set$2(__privateGet(this, _colorMode), value);
    }
    resetStoreValues() {
      var _a3;
      this.dragging = false;
      this.selectionRect = null;
      this.selectionRectMode = null;
      this.selectionKeyPressed = false;
      this.multiselectionKeyPressed = false;
      this.deleteKeyPressed = false;
      this.panActivationKeyPressed = false;
      this.zoomActivationKeyPressed = false;
      this._connection = initialConnection;
      this.clickConnectStartHandle = null;
      this.viewport = (_a3 = signals.props.initialViewport) != null ? _a3 : { x: 0, y: 0, zoom: 1 };
      this.ariaLiveMessage = "";
    }
  }
  _flowId = new WeakMap();
  _domNode = new WeakMap();
  _panZoom = new WeakMap();
  _width = new WeakMap();
  _height = new WeakMap();
  _nodesInitialized = new WeakMap();
  _viewportInitialized = new WeakMap();
  __edges = new WeakMap();
  _selectedNodes = new WeakMap();
  _selectedEdges = new WeakMap();
  _visible = new WeakMap();
  _nodesDraggable = new WeakMap();
  _nodesConnectable = new WeakMap();
  _elementsSelectable = new WeakMap();
  _nodesFocusable = new WeakMap();
  _edgesFocusable = new WeakMap();
  _disableKeyboardA11y = new WeakMap();
  _minZoom = new WeakMap();
  _maxZoom = new WeakMap();
  _nodeOrigin = new WeakMap();
  _nodeExtent = new WeakMap();
  _translateExtent = new WeakMap();
  _defaultEdgeOptions = new WeakMap();
  _nodeDragThreshold = new WeakMap();
  _autoPanOnNodeDrag = new WeakMap();
  _autoPanOnConnect = new WeakMap();
  _autoPanOnNodeFocus = new WeakMap();
  _connectionDragThreshold = new WeakMap();
  _snapGrid = new WeakMap();
  _dragging = new WeakMap();
  _selectionRect = new WeakMap();
  _selectionKeyPressed = new WeakMap();
  _multiselectionKeyPressed = new WeakMap();
  _deleteKeyPressed = new WeakMap();
  _panActivationKeyPressed = new WeakMap();
  _zoomActivationKeyPressed = new WeakMap();
  _selectionRectMode = new WeakMap();
  _ariaLiveMessage = new WeakMap();
  _selectionMode = new WeakMap();
  _nodeTypes = new WeakMap();
  _edgeTypes = new WeakMap();
  _noPanClass = new WeakMap();
  _noDragClass = new WeakMap();
  _noWheelClass = new WeakMap();
  _ariaLabelConfig = new WeakMap();
  __viewport = new WeakMap();
  __connection = new WeakMap();
  _connection = new WeakMap();
  _connectionMode = new WeakMap();
  _connectionRadius = new WeakMap();
  _isValidConnection = new WeakMap();
  _selectNodesOnDrag = new WeakMap();
  _defaultMarkerColor = new WeakMap();
  _markers = new WeakMap();
  _onlyRenderVisibleElements = new WeakMap();
  _onerror = new WeakMap();
  _ondelete = new WeakMap();
  _onbeforedelete = new WeakMap();
  _onbeforeconnect = new WeakMap();
  _onconnect = new WeakMap();
  _onconnectstart = new WeakMap();
  _onconnectend = new WeakMap();
  _onbeforereconnect = new WeakMap();
  _onreconnect = new WeakMap();
  _onreconnectstart = new WeakMap();
  _onreconnectend = new WeakMap();
  _clickConnect = new WeakMap();
  _onclickconnectstart = new WeakMap();
  _onclickconnectend = new WeakMap();
  _clickConnectStartHandle = new WeakMap();
  _onselectiondrag = new WeakMap();
  _onselectiondragstart = new WeakMap();
  _onselectiondragstop = new WeakMap();
  _colorMode = new WeakMap();
  return new SvelteFlowStore();
}
function useStore() {
  const storeContext = getContext(key);
  if (!storeContext) {
    throw new Error("To call useStore outside of <SvelteFlow /> you need to wrap your component in a <SvelteFlowProvider />");
  }
  return storeContext.getStore();
}
const key = Symbol();
function createStore(signals) {
  const store = getInitialStore(signals);
  function setNodeTypes(nodeTypes) {
    store.nodeTypes = __spreadValues(__spreadValues({}, initialNodeTypes), nodeTypes);
  }
  function setEdgeTypes(edgeTypes) {
    store.edgeTypes = __spreadValues(__spreadValues({}, initialEdgeTypes), edgeTypes);
  }
  function addEdge$1(edgeParams) {
    store.edges = addEdge(edgeParams, store.edges);
  }
  const updateNodePositions = (nodeDragItems, dragging = false) => {
    store.nodes = store.nodes.map((node) => {
      const dragItem = nodeDragItems.get(node.id);
      return dragItem ? __spreadProps(__spreadValues({}, node), { position: dragItem.position, dragging }) : node;
    });
  };
  function updateNodeInternals$1(updates) {
    var _a2, _b2, _c2, _d2, _e2, _f;
    const { changes, updatedInternals } = updateNodeInternals(updates, store.nodeLookup, store.parentLookup, store.domNode, store.nodeOrigin);
    if (!updatedInternals) {
      return;
    }
    updateAbsolutePositions(store.nodeLookup, store.parentLookup, {
      nodeOrigin: store.nodeOrigin,
      nodeExtent: store.nodeExtent
    });
    if (store.fitViewQueued) {
      store.resolveFitView();
    }
    const newNodes = /* @__PURE__ */ new Map();
    for (const change of changes) {
      const userNode = (_a2 = store.nodeLookup.get(change.id)) == null ? void 0 : _a2.internals.userNode;
      if (!userNode) {
        continue;
      }
      const node = __spreadValues({}, userNode);
      switch (change.type) {
        case "dimensions": {
          const measured = __spreadValues(__spreadValues({}, node.measured), change.dimensions);
          if (change.setAttributes) {
            node.width = (_c2 = (_b2 = change.dimensions) == null ? void 0 : _b2.width) != null ? _c2 : node.width;
            node.height = (_e2 = (_d2 = change.dimensions) == null ? void 0 : _d2.height) != null ? _e2 : node.height;
          }
          node.measured = measured;
          break;
        }
        case "position":
          node.position = (_f = change.position) != null ? _f : node.position;
          break;
      }
      newNodes.set(change.id, node);
    }
    store.nodes = store.nodes.map((node) => {
      var _a3;
      return (_a3 = newNodes.get(node.id)) != null ? _a3 : node;
    });
  }
  function fitView(options) {
    var _a2;
    const fitViewResolver = (_a2 = store.fitViewResolver) != null ? _a2 : Promise.withResolvers();
    store.fitViewQueued = true;
    store.fitViewOptions = options;
    store.fitViewResolver = fitViewResolver;
    store.nodes = [...store.nodes];
    return fitViewResolver.promise;
  }
  function setCenter(x, y2, options) {
    return __async(this, null, function* () {
      const nextZoom = typeof (options == null ? void 0 : options.zoom) !== "undefined" ? options.zoom : store.maxZoom;
      const currentPanZoom = store.panZoom;
      if (!currentPanZoom) {
        return Promise.resolve(false);
      }
      yield currentPanZoom.setViewport({
        x: store.width / 2 - x * nextZoom,
        y: store.height / 2 - y2 * nextZoom,
        zoom: nextZoom
      }, { duration: options == null ? void 0 : options.duration, ease: options == null ? void 0 : options.ease, interpolate: options == null ? void 0 : options.interpolate });
      return Promise.resolve(true);
    });
  }
  function zoomBy(factor, options) {
    const panZoom = store.panZoom;
    if (!panZoom) {
      return Promise.resolve(false);
    }
    return panZoom.scaleBy(factor, options);
  }
  function zoomIn(options) {
    return zoomBy(1.2, options);
  }
  function zoomOut(options) {
    return zoomBy(1 / 1.2, options);
  }
  function setMinZoom(minZoom) {
    const panZoom = store.panZoom;
    if (panZoom) {
      panZoom.setScaleExtent([minZoom, store.maxZoom]);
      store.minZoom = minZoom;
    }
  }
  function setMaxZoom(maxZoom) {
    const panZoom = store.panZoom;
    if (panZoom) {
      panZoom.setScaleExtent([store.minZoom, maxZoom]);
      store.maxZoom = maxZoom;
    }
  }
  function setTranslateExtent(extent) {
    const panZoom = store.panZoom;
    if (panZoom) {
      panZoom.setTranslateExtent(extent);
      store.translateExtent = extent;
    }
  }
  function setPaneClickDistance(distance2) {
    var _a2;
    (_a2 = store.panZoom) == null ? void 0 : _a2.setClickDistance(distance2);
  }
  function deselect(elements, elementsToDeselect = null) {
    let deselected = false;
    const newElements = elements.map((element) => {
      const shouldDeselect = elementsToDeselect ? elementsToDeselect.has(element.id) : true;
      if (shouldDeselect && element.selected) {
        deselected = true;
        return __spreadProps(__spreadValues({}, element), { selected: false });
      }
      return element;
    });
    return [deselected, newElements];
  }
  function unselectNodesAndEdges(params) {
    const nodesToDeselect = (params == null ? void 0 : params.nodes) ? new Set(params.nodes.map((node) => node.id)) : null;
    const [nodesDeselected, newNodes] = deselect(store.nodes, nodesToDeselect);
    if (nodesDeselected) {
      store.nodes = newNodes;
    }
    const edgesToDeselect = (params == null ? void 0 : params.edges) ? new Set(params.edges.map((node) => node.id)) : null;
    const [edgesDeselected, newEdges] = deselect(store.edges, edgesToDeselect);
    if (edgesDeselected) {
      store.edges = newEdges;
    }
  }
  function addSelectedNodes(ids) {
    const isMultiSelection = store.multiselectionKeyPressed;
    store.nodes = store.nodes.map((node) => {
      const nodeWillBeSelected = ids.includes(node.id);
      const selected = isMultiSelection ? node.selected || nodeWillBeSelected : nodeWillBeSelected;
      if (node.selected !== selected) {
        const internalNode = store.nodeLookup.get(node.id);
        if (internalNode)
          internalNode.selected = selected;
        node.selected = selected;
        return __spreadValues({}, node);
      }
      return node;
    });
    if (!isMultiSelection) {
      unselectNodesAndEdges({ nodes: [] });
    }
  }
  function addSelectedEdges(ids) {
    const isMultiSelection = store.multiselectionKeyPressed;
    store.edges = store.edges.map((edge) => {
      const edgeWillBeSelected = ids.includes(edge.id);
      const selected = isMultiSelection ? edge.selected || edgeWillBeSelected : edgeWillBeSelected;
      if (edge.selected !== selected) {
        return __spreadProps(__spreadValues({}, edge), { selected });
      }
      return edge;
    });
    if (!isMultiSelection) {
      unselectNodesAndEdges({ edges: [] });
    }
  }
  function handleNodeSelection(id2, unselect, nodeRef) {
    const node = store.nodeLookup.get(id2);
    if (!node) {
      console.warn("012", errorMessages["error012"](id2));
      return;
    }
    store.selectionRect = null;
    store.selectionRectMode = null;
    if (!node.selected) {
      addSelectedNodes([id2]);
    } else if (unselect || node.selected && store.multiselectionKeyPressed) {
      unselectNodesAndEdges({ nodes: [node], edges: [] });
      requestAnimationFrame(() => nodeRef == null ? void 0 : nodeRef.blur());
    }
  }
  function handleEdgeSelection(id2) {
    const edge = store.edgeLookup.get(id2);
    if (!edge) {
      console.warn("012", errorMessages["error012"](id2));
      return;
    }
    const selectable = edge.selectable || store.elementsSelectable && typeof edge.selectable === "undefined";
    if (selectable) {
      store.selectionRect = null;
      store.selectionRectMode = null;
      if (!edge.selected) {
        addSelectedEdges([id2]);
      } else if (edge.selected && store.multiselectionKeyPressed) {
        unselectNodesAndEdges({ nodes: [], edges: [edge] });
      }
    }
  }
  function moveSelectedNodes(direction, factor) {
    var _a2, _b2;
    const { nodeExtent, snapGrid, nodeOrigin, nodeLookup, nodesDraggable, onerror } = store;
    const nodeUpdates = /* @__PURE__ */ new Map();
    const xVelo = (_a2 = snapGrid == null ? void 0 : snapGrid[0]) != null ? _a2 : 5;
    const yVelo = (_b2 = snapGrid == null ? void 0 : snapGrid[1]) != null ? _b2 : 5;
    const xDiff = direction.x * xVelo * factor;
    const yDiff = direction.y * yVelo * factor;
    for (const node of nodeLookup.values()) {
      const isSelected = node.selected && (node.draggable || nodesDraggable && typeof node.draggable === "undefined");
      if (!isSelected) {
        continue;
      }
      let nextPosition = {
        x: node.internals.positionAbsolute.x + xDiff,
        y: node.internals.positionAbsolute.y + yDiff
      };
      if (snapGrid) {
        nextPosition = snapPosition(nextPosition, snapGrid);
      }
      const { position, positionAbsolute } = calculateNodePosition({
        nodeId: node.id,
        nextPosition,
        nodeLookup,
        nodeExtent,
        nodeOrigin,
        onError: onerror
      });
      node.position = position;
      node.internals.positionAbsolute = positionAbsolute;
      nodeUpdates.set(node.id, node);
    }
    updateNodePositions(nodeUpdates);
  }
  function panBy$1(delta) {
    return panBy({
      delta,
      panZoom: store.panZoom,
      transform: [store.viewport.x, store.viewport.y, store.viewport.zoom],
      translateExtent: store.translateExtent,
      width: store.width,
      height: store.height
    });
  }
  const updateConnection = (newConnection) => {
    store._connection = __spreadValues({}, newConnection);
  };
  function cancelConnection() {
    store._connection = initialConnection;
  }
  function reset() {
    store.resetStoreValues();
    unselectNodesAndEdges();
  }
  const storeWithActions = Object.assign(store, {
    setNodeTypes,
    setEdgeTypes,
    addEdge: addEdge$1,
    updateNodePositions,
    updateNodeInternals: updateNodeInternals$1,
    zoomIn,
    zoomOut,
    fitView,
    setCenter,
    setMinZoom,
    setMaxZoom,
    setTranslateExtent,
    setPaneClickDistance,
    unselectNodesAndEdges,
    addSelectedNodes,
    addSelectedEdges,
    handleNodeSelection,
    handleEdgeSelection,
    moveSelectedNodes,
    panBy: panBy$1,
    updateConnection,
    cancelConnection,
    reset
  });
  return storeWithActions;
}
function zoom(domNode, params) {
  const { minZoom, maxZoom, initialViewport, onPanZoomStart, onPanZoom, onPanZoomEnd, translateExtent, paneClickDistance, setPanZoomInstance, onDraggingChange, onTransformChange } = params;
  const panZoomInstance = XYPanZoom({
    domNode,
    minZoom,
    maxZoom,
    translateExtent,
    viewport: initialViewport,
    paneClickDistance,
    onPanZoom,
    onPanZoomStart,
    onPanZoomEnd,
    onDraggingChange
  });
  const viewport = panZoomInstance.getViewport();
  if (initialViewport.x !== viewport.x || initialViewport.y !== viewport.y || initialViewport.zoom !== viewport.zoom) {
    onTransformChange([viewport.x, viewport.y, viewport.zoom]);
  }
  setPanZoomInstance(panZoomInstance);
  panZoomInstance.update(params);
  return {
    update(params2) {
      panZoomInstance.update(params2);
    }
  };
}
var root$w = /* @__PURE__ */ from_html(`<div class="svelte-flow__zoom svelte-flow__container"><!></div>`);
function Zoom($$anchor, $$props) {
  push($$props, true);
  let store = prop($$props, "store", 15), panOnScrollMode = prop($$props, "panOnScrollMode", 19, () => PanOnScrollMode.Free), preventScrolling = prop($$props, "preventScrolling", 3, true), zoomOnScroll = prop($$props, "zoomOnScroll", 3, true), zoomOnDoubleClick = prop($$props, "zoomOnDoubleClick", 3, true), zoomOnPinch = prop($$props, "zoomOnPinch", 3, true), panOnDrag = prop($$props, "panOnDrag", 3, true), panOnScroll = prop($$props, "panOnScroll", 3, false), paneClickDistance = prop($$props, "paneClickDistance", 3, 1);
  let panOnDragActive = /* @__PURE__ */ user_derived(() => store().panActivationKeyPressed || panOnDrag());
  let panOnScrollActive = /* @__PURE__ */ user_derived(() => store().panActivationKeyPressed || panOnScroll());
  const { viewport: initialViewport } = store();
  let onInitCalled = false;
  user_effect(() => {
    var _a2;
    if (!onInitCalled && store().viewportInitialized) {
      (_a2 = $$props.oninit) == null ? void 0 : _a2.call($$props);
      onInitCalled = true;
    }
  });
  var div = root$w();
  var node = child(div);
  snippet(node, () => $$props.children);
  action(div, ($$node, $$action_arg) => zoom == null ? void 0 : zoom($$node, $$action_arg), () => ({
    viewport: store().viewport,
    minZoom: store().minZoom,
    maxZoom: store().maxZoom,
    initialViewport,
    onDraggingChange: (dragging) => {
      store(store().dragging = dragging, true);
    },
    setPanZoomInstance: (instance) => {
      store(store().panZoom = instance, true);
    },
    onPanZoomStart: $$props.onmovestart,
    onPanZoom: $$props.onmove,
    onPanZoomEnd: $$props.onmoveend,
    zoomOnScroll: zoomOnScroll(),
    zoomOnDoubleClick: zoomOnDoubleClick(),
    zoomOnPinch: zoomOnPinch(),
    panOnScroll: get$3(panOnScrollActive),
    panOnDrag: get$3(panOnDragActive),
    panOnScrollSpeed: 0.5,
    panOnScrollMode: panOnScrollMode() || PanOnScrollMode.Free,
    zoomActivationKeyPressed: store().zoomActivationKeyPressed,
    preventScrolling: typeof preventScrolling() === "boolean" ? preventScrolling() : true,
    noPanClassName: store().noPanClass,
    noWheelClassName: store().noWheelClass,
    userSelectionActive: !!store().selectionRect,
    translateExtent: store().translateExtent,
    lib: "svelte",
    paneClickDistance: paneClickDistance(),
    onTransformChange: (transform2) => {
      store(
        store().viewport = {
          x: transform2[0],
          y: transform2[1],
          zoom: transform2[2]
        },
        true
      );
    }
  }));
  append($$anchor, div);
  pop();
}
function wrapHandler(handler, container) {
  return (event2) => {
    if (event2.target !== container) {
      return;
    }
    handler == null ? void 0 : handler(event2);
  };
}
function toggleSelected(ids) {
  return (item) => {
    const isSelected = ids.has(item.id);
    if (!!item.selected !== isSelected) {
      return __spreadProps(__spreadValues({}, item), { selected: isSelected });
    }
    return item;
  };
}
function isSetEqual(a, b2) {
  if (a.size !== b2.size) {
    return false;
  }
  for (const item of a) {
    if (!b2.has(item)) {
      return false;
    }
  }
  return true;
}
var root$v = /* @__PURE__ */ from_html(`<div><!></div>`);
function Pane($$anchor, $$props) {
  push($$props, true);
  let store = prop($$props, "store", 15), panOnDrag = prop($$props, "panOnDrag", 3, true);
  let container;
  let containerBounds = null;
  let selectedNodeIds = /* @__PURE__ */ new Set();
  let selectedEdgeIds = /* @__PURE__ */ new Set();
  let panOnDragActive = /* @__PURE__ */ user_derived(() => store().panActivationKeyPressed || panOnDrag());
  let isSelecting = /* @__PURE__ */ user_derived(() => store().selectionKeyPressed || store().selectionRect || $$props.selectionOnDrag && get$3(panOnDragActive) !== true);
  let hasActiveSelection = /* @__PURE__ */ user_derived(() => store().elementsSelectable && (get$3(isSelecting) || store().selectionRectMode === "user"));
  let selectionInProgress = false;
  function onClick(event2) {
    var _a2;
    if (selectionInProgress || store().connection.inProgress) {
      selectionInProgress = false;
      return;
    }
    (_a2 = $$props.onpaneclick) == null ? void 0 : _a2.call($$props, { event: event2 });
    store().unselectNodesAndEdges();
    store(store().selectionRectMode = null, true);
  }
  function onPointerDown2(event2) {
    var _a2, _b2, _c2;
    containerBounds = container == null ? void 0 : container.getBoundingClientRect();
    if (!store().elementsSelectable || !get$3(isSelecting) || event2.button !== 0 || event2.target !== container || !containerBounds) {
      return;
    }
    (_b2 = (_a2 = event2.target) == null ? void 0 : _a2.setPointerCapture) == null ? void 0 : _b2.call(_a2, event2.pointerId);
    const { x, y: y2 } = getEventPosition(event2, containerBounds);
    store().unselectNodesAndEdges();
    store(
      store().selectionRect = {
        width: 0,
        height: 0,
        startX: x,
        startY: y2,
        x,
        y: y2
      },
      true
    );
    (_c2 = $$props.onselectionstart) == null ? void 0 : _c2.call($$props, event2);
  }
  function onPointerMove(event2) {
    var _a2, _b2;
    if (!get$3(isSelecting) || !containerBounds || !store().selectionRect) {
      return;
    }
    selectionInProgress = true;
    const mousePos = getEventPosition(event2, containerBounds);
    const { startX = 0, startY = 0 } = store().selectionRect;
    const nextUserSelectRect = __spreadProps(__spreadValues({}, store().selectionRect), {
      x: mousePos.x < startX ? mousePos.x : startX,
      y: mousePos.y < startY ? mousePos.y : startY,
      width: Math.abs(mousePos.x - startX),
      height: Math.abs(mousePos.y - startY)
    });
    const prevSelectedNodeIds = selectedNodeIds;
    const prevSelectedEdgeIds = selectedEdgeIds;
    selectedNodeIds = new Set(getNodesInside(
      store().nodeLookup,
      nextUserSelectRect,
      [
        store().viewport.x,
        store().viewport.y,
        store().viewport.zoom
      ],
      store().selectionMode === SelectionMode.Partial,
      true
    ).map((n) => n.id));
    const edgesSelectable = (_a2 = store().defaultEdgeOptions.selectable) != null ? _a2 : true;
    selectedEdgeIds = /* @__PURE__ */ new Set();
    for (const nodeId of selectedNodeIds) {
      const connections = store().connectionLookup.get(nodeId);
      if (!connections) continue;
      for (const { edgeId } of connections.values()) {
        const edge = store().edgeLookup.get(edgeId);
        if (edge && ((_b2 = edge.selectable) != null ? _b2 : edgesSelectable)) {
          selectedEdgeIds.add(edgeId);
        }
      }
    }
    if (!isSetEqual(prevSelectedNodeIds, selectedNodeIds)) {
      store(store().nodes = store().nodes.map(toggleSelected(selectedNodeIds)), true);
    }
    if (!isSetEqual(prevSelectedEdgeIds, selectedEdgeIds)) {
      store(store().edges = store().edges.map(toggleSelected(selectedEdgeIds)), true);
    }
    store(store().selectionRectMode = "user", true);
    store(store().selectionRect = nextUserSelectRect, true);
  }
  function onPointerUp(event2) {
    var _a2, _b2, _c2;
    if (event2.button !== 0) {
      return;
    }
    (_b2 = (_a2 = event2.target) == null ? void 0 : _a2.releasePointerCapture) == null ? void 0 : _b2.call(_a2, event2.pointerId);
    if (!get$3(isSelecting) && store().selectionRectMode === "user" && event2.target === container) {
      onClick == null ? void 0 : onClick(event2);
    }
    store(store().selectionRect = null, true);
    if (selectedNodeIds.size > 0) {
      store(store().selectionRectMode = "nodes", true);
    }
    if (store().selectionKeyPressed) {
      selectionInProgress = false;
    }
    (_c2 = $$props.onselectionend) == null ? void 0 : _c2.call($$props, event2);
  }
  const onContextMenu = (event2) => {
    var _a2;
    if (Array.isArray(get$3(panOnDragActive)) && get$3(panOnDragActive).includes(2)) {
      event2.preventDefault();
      return;
    }
    (_a2 = $$props.onpanecontextmenu) == null ? void 0 : _a2.call($$props, { event: event2 });
  };
  var div = root$v();
  let classes;
  var event_handler = /* @__PURE__ */ user_derived(() => get$3(hasActiveSelection) ? void 0 : wrapHandler(onClick, container));
  div.__click = function(...$$args) {
    var _a2;
    (_a2 = get$3(event_handler)) == null ? void 0 : _a2.apply(this, $$args);
  };
  div.__pointerdown = function(...$$args) {
    var _a2;
    (_a2 = get$3(hasActiveSelection) ? onPointerDown2 : void 0) == null ? void 0 : _a2.apply(this, $$args);
  };
  div.__pointermove = function(...$$args) {
    var _a2;
    (_a2 = get$3(hasActiveSelection) ? onPointerMove : void 0) == null ? void 0 : _a2.apply(this, $$args);
  };
  div.__pointerup = function(...$$args) {
    var _a2;
    (_a2 = get$3(hasActiveSelection) ? onPointerUp : void 0) == null ? void 0 : _a2.apply(this, $$args);
  };
  var event_handler_1 = /* @__PURE__ */ user_derived(() => wrapHandler(onContextMenu, container));
  div.__contextmenu = function(...$$args) {
    var _a2;
    (_a2 = get$3(event_handler_1)) == null ? void 0 : _a2.apply(this, $$args);
  };
  var node = child(div);
  snippet(node, () => $$props.children);
  bind_this(div, ($$value) => container = $$value, () => container);
  template_effect(($0) => classes = set_class(div, 1, "svelte-flow__pane svelte-flow__container", null, classes, $0), [
    () => ({
      draggable: panOnDrag() === true || Array.isArray(panOnDrag()) && panOnDrag().includes(0),
      dragging: store().dragging,
      selection: get$3(isSelecting)
    })
  ]);
  append($$anchor, div);
  pop();
}
delegate([
  "click",
  "pointerdown",
  "pointermove",
  "pointerup",
  "contextmenu"
]);
var root$u = /* @__PURE__ */ from_html(`<div class="svelte-flow__viewport xyflow__viewport svelte-flow__container"><!></div>`);
function Viewport($$anchor, $$props) {
  push($$props, true);
  var div = root$u();
  let styles;
  var node = child(div);
  snippet(node, () => $$props.children);
  template_effect(() => {
    var _a2, _b2, _c2;
    return styles = set_style(div, "", styles, {
      transform: `translate(${(_a2 = $$props.store.viewport.x) != null ? _a2 : ""}px, ${(_b2 = $$props.store.viewport.y) != null ? _b2 : ""}px) scale(${(_c2 = $$props.store.viewport.zoom) != null ? _c2 : ""})`
    });
  });
  append($$anchor, div);
  pop();
}
function drag(domNode, params) {
  const { store, onDrag, onDragStart, onDragStop, onNodeMouseDown } = params;
  const dragInstance = XYDrag({
    onDrag,
    onDragStart,
    onDragStop,
    onNodeMouseDown,
    getStoreItems: () => {
      const { snapGrid, viewport } = store;
      return {
        nodes: store.nodes,
        nodeLookup: store.nodeLookup,
        edges: store.edges,
        nodeExtent: store.nodeExtent,
        snapGrid: snapGrid ? snapGrid : [0, 0],
        snapToGrid: !!snapGrid,
        nodeOrigin: store.nodeOrigin,
        multiSelectionActive: store.multiselectionKeyPressed,
        domNode: store.domNode,
        transform: [viewport.x, viewport.y, viewport.zoom],
        autoPanOnNodeDrag: store.autoPanOnNodeDrag,
        nodesDraggable: store.nodesDraggable,
        selectNodesOnDrag: store.selectNodesOnDrag,
        nodeDragThreshold: store.nodeDragThreshold,
        unselectNodesAndEdges: store.unselectNodesAndEdges,
        updateNodePositions: store.updateNodePositions,
        onSelectionDrag: store.onselectiondrag,
        onSelectionDragStart: store.onselectiondragstart,
        onSelectionDragStop: store.onselectiondragstop,
        panBy: store.panBy
      };
    }
  });
  function updateDrag(domNode2, params2) {
    if (params2.disabled) {
      dragInstance.destroy();
      return;
    }
    dragInstance.update({
      domNode: domNode2,
      noDragClassName: params2.noDragClass,
      handleSelector: params2.handleSelector,
      nodeId: params2.nodeId,
      isSelectable: params2.isSelectable,
      nodeClickDistance: params2.nodeClickDistance
    });
  }
  updateDrag(domNode, params);
  return {
    update(params2) {
      updateDrag(domNode, params2);
    },
    destroy() {
      dragInstance.destroy();
    }
  };
}
var root_1$g = /* @__PURE__ */ from_html(`<div aria-live="assertive" aria-atomic="true" class="a11y-live-msg svelte-62ze0y"> </div>`);
var root$t = /* @__PURE__ */ from_html(`<div class="a11y-hidden svelte-62ze0y"> </div> <div class="a11y-hidden svelte-62ze0y"> </div> <!>`, 1);
function A11yDescriptions($$anchor, $$props) {
  push($$props, true);
  var fragment = root$t();
  var div = first_child(fragment);
  var text2 = child(div);
  var div_1 = sibling(div, 2);
  var text_1 = child(div_1);
  var node = sibling(div_1, 2);
  {
    var consequent = ($$anchor2) => {
      var div_2 = root_1$g();
      var text_2 = child(div_2);
      template_effect(() => {
        set_attribute(div_2, "id", `${ARIA_LIVE_MESSAGE}-${$$props.store.flowId}`);
        set_text(text_2, $$props.store.ariaLiveMessage);
      });
      append($$anchor2, div_2);
    };
    if_block(node, ($$render) => {
      if (!$$props.store.disableKeyboardA11y) $$render(consequent);
    });
  }
  template_effect(() => {
    set_attribute(div, "id", `${ARIA_NODE_DESC_KEY}-${$$props.store.flowId}`);
    set_text(text2, $$props.store.disableKeyboardA11y ? $$props.store.ariaLabelConfig["node.a11yDescription.default"] : $$props.store.ariaLabelConfig["node.a11yDescription.keyboardDisabled"]);
    set_attribute(div_1, "id", `${ARIA_EDGE_DESC_KEY}-${$$props.store.flowId}`);
    set_text(text_1, $$props.store.ariaLabelConfig["edge.a11yDescription.default"]);
  });
  append($$anchor, fragment);
  pop();
}
const ARIA_NODE_DESC_KEY = "svelte-flow__node-desc";
const ARIA_EDGE_DESC_KEY = "svelte-flow__edge-desc";
const ARIA_LIVE_MESSAGE = "svelte-flow__aria-live";
var root_1$f = /* @__PURE__ */ from_html(`<div><!></div>`);
function NodeWrapper($$anchor, $$props) {
  push($$props, true);
  let store = prop($$props, "store", 15);
  let data = /* @__PURE__ */ user_derived(() => fallback($$props.node.data, () => ({}), true)), selected = /* @__PURE__ */ user_derived(() => fallback($$props.node.selected, false)), _draggable = /* @__PURE__ */ user_derived(() => $$props.node.draggable), _selectable = /* @__PURE__ */ user_derived(() => $$props.node.selectable), deletable = /* @__PURE__ */ user_derived(() => fallback($$props.node.deletable, true)), _connectable = /* @__PURE__ */ user_derived(() => $$props.node.connectable), _focusable = /* @__PURE__ */ user_derived(() => $$props.node.focusable), hidden = /* @__PURE__ */ user_derived(() => fallback($$props.node.hidden, false)), dragging = /* @__PURE__ */ user_derived(() => fallback($$props.node.dragging, false)), style = /* @__PURE__ */ user_derived(() => fallback($$props.node.style, "")), className = /* @__PURE__ */ user_derived(() => $$props.node.class), type = /* @__PURE__ */ user_derived(() => fallback($$props.node.type, "default")), parentId = /* @__PURE__ */ user_derived(() => $$props.node.parentId), sourcePosition = /* @__PURE__ */ user_derived(() => $$props.node.sourcePosition), targetPosition = /* @__PURE__ */ user_derived(() => $$props.node.targetPosition), measuredWidth = /* @__PURE__ */ user_derived(() => fallback($$props.node.measured, () => ({ width: 0, height: 0 }), true).width), measuredHeight = /* @__PURE__ */ user_derived(() => fallback($$props.node.measured, () => ({ width: 0, height: 0 }), true).height), initialWidth = /* @__PURE__ */ user_derived(() => $$props.node.initialWidth), initialHeight = /* @__PURE__ */ user_derived(() => $$props.node.initialHeight), width = /* @__PURE__ */ user_derived(() => $$props.node.width), height = /* @__PURE__ */ user_derived(() => $$props.node.height), dragHandle = /* @__PURE__ */ user_derived(() => $$props.node.dragHandle), zIndex = /* @__PURE__ */ user_derived(() => fallback($$props.node.internals.z, 0)), positionX = /* @__PURE__ */ user_derived(() => $$props.node.internals.positionAbsolute.x), positionY = /* @__PURE__ */ user_derived(() => $$props.node.internals.positionAbsolute.y), userNode = /* @__PURE__ */ user_derived(() => $$props.node.internals.userNode);
  let { id: id2 } = $$props.node;
  let draggable = /* @__PURE__ */ user_derived(() => {
    var _a2;
    return (_a2 = get$3(_draggable)) != null ? _a2 : store().nodesDraggable;
  });
  let selectable = /* @__PURE__ */ user_derived(() => {
    var _a2;
    return (_a2 = get$3(_selectable)) != null ? _a2 : store().elementsSelectable;
  });
  let connectable = /* @__PURE__ */ user_derived(() => {
    var _a2;
    return (_a2 = get$3(_connectable)) != null ? _a2 : store().nodesConnectable;
  });
  let hasDimensions = /* @__PURE__ */ user_derived(() => nodeHasDimensions($$props.node));
  let hasHandleBounds = /* @__PURE__ */ user_derived(() => !!$$props.node.internals.handleBounds);
  let isInitialized = /* @__PURE__ */ user_derived(() => get$3(hasDimensions) && get$3(hasHandleBounds));
  let focusable = /* @__PURE__ */ user_derived(() => {
    var _a2;
    return (_a2 = get$3(_focusable)) != null ? _a2 : store().nodesFocusable;
  });
  function isInParentLookup(id22) {
    return store().parentLookup.has(id22);
  }
  let isParent = /* @__PURE__ */ user_derived(() => isInParentLookup(id2));
  let nodeRef = /* @__PURE__ */ state(null);
  let prevNodeRef = null;
  let prevType = get$3(type);
  let prevSourcePosition = get$3(sourcePosition);
  let prevTargetPosition = get$3(targetPosition);
  let NodeComponent = /* @__PURE__ */ user_derived(() => {
    var _a2;
    return (_a2 = store().nodeTypes[get$3(type)]) != null ? _a2 : DefaultNode;
  });
  let ariaLabelConfig = /* @__PURE__ */ user_derived(() => store().ariaLabelConfig);
  let connectableContext = {
    get value() {
      return get$3(connectable);
    }
  };
  setContext("svelteflow__node_connectable", connectableContext);
  setContext("svelteflow__node_id", id2);
  let nodeStyle = /* @__PURE__ */ user_derived(() => {
    var _a2, _b2;
    const w2 = get$3(measuredWidth) === void 0 ? (_a2 = get$3(width)) != null ? _a2 : get$3(initialWidth) : get$3(width);
    const h2 = get$3(measuredHeight) === void 0 ? (_b2 = get$3(height)) != null ? _b2 : get$3(initialHeight) : get$3(height);
    if (w2 === void 0 && h2 === void 0 && get$3(style) === void 0) {
      return void 0;
    }
    return `${get$3(style)};${w2 ? `width:${toPxString(w2)};` : ""}${h2 ? `height:${toPxString(h2)};` : ""}`;
  });
  user_effect(() => {
    const doUpdate = get$3(type) !== prevType || get$3(sourcePosition) !== prevSourcePosition || get$3(targetPosition) !== prevTargetPosition;
    if (doUpdate && get$3(nodeRef) !== null) {
      requestAnimationFrame(() => {
        if (get$3(nodeRef) !== null) {
          store().updateNodeInternals(/* @__PURE__ */ new Map([
            [
              id2,
              {
                id: id2,
                nodeElement: get$3(nodeRef),
                force: true
              }
            ]
          ]));
        }
      });
    }
    prevType = get$3(type);
    prevSourcePosition = get$3(sourcePosition);
    prevTargetPosition = get$3(targetPosition);
  });
  user_effect(() => {
    if ($$props.resizeObserver && (!get$3(isInitialized) || get$3(nodeRef) !== prevNodeRef)) {
      prevNodeRef && $$props.resizeObserver.unobserve(prevNodeRef);
      get$3(nodeRef) && $$props.resizeObserver.observe(get$3(nodeRef));
      prevNodeRef = get$3(nodeRef);
    }
  });
  onDestroy(() => {
    var _a2;
    if (prevNodeRef) {
      (_a2 = $$props.resizeObserver) == null ? void 0 : _a2.unobserve(prevNodeRef);
    }
  });
  function onSelectNodeHandler(event2) {
    var _a2;
    if (get$3(selectable) && (!store().selectNodesOnDrag || !get$3(draggable) || store().nodeDragThreshold > 0)) {
      store().handleNodeSelection(id2);
    }
    (_a2 = $$props.onnodeclick) == null ? void 0 : _a2.call($$props, { node: get$3(userNode), event: event2 });
  }
  function onKeyDown(event2) {
    if (isInputDOMNode(event2) || store().disableKeyboardA11y) {
      return;
    }
    if (elementSelectionKeys.includes(event2.key) && get$3(selectable)) {
      const unselect = event2.key === "Escape";
      store().handleNodeSelection(id2, unselect, get$3(nodeRef));
    } else if (get$3(draggable) && $$props.node.selected && Object.prototype.hasOwnProperty.call(arrowKeyDiffs, event2.key)) {
      event2.preventDefault();
      store(
        store().ariaLiveMessage = get$3(ariaLabelConfig)["node.a11yDescription.ariaLiveMessage"]({
          direction: event2.key.replace("Arrow", "").toLowerCase(),
          x: ~~$$props.node.internals.positionAbsolute.x,
          y: ~~$$props.node.internals.positionAbsolute.y
        }),
        true
      );
      store().moveSelectedNodes(arrowKeyDiffs[event2.key], event2.shiftKey ? 4 : 1);
    }
  }
  const onFocus = () => {
    var _a2, _b2, _c2;
    if (store().disableKeyboardA11y || !store().autoPanOnNodeFocus || !((_a2 = get$3(nodeRef)) == null ? void 0 : _a2.matches(":focus-visible"))) {
      return;
    }
    const { width: width2, height: height2, viewport } = store();
    const withinViewport = getNodesInside(/* @__PURE__ */ new Map([[id2, $$props.node]]), { x: 0, y: 0, width: width2, height: height2 }, [viewport.x, viewport.y, viewport.zoom], true).length > 0;
    if (!withinViewport) {
      store().setCenter($$props.node.position.x + ((_b2 = $$props.node.measured.width) != null ? _b2 : 0) / 2, $$props.node.position.y + ((_c2 = $$props.node.measured.height) != null ? _c2 : 0) / 2, { zoom: viewport.zoom });
    }
  };
  var fragment = comment();
  var node_1 = first_child(fragment);
  {
    var consequent = ($$anchor2) => {
      var div = root_1$f();
      attribute_effect(
        div,
        ($0) => {
          var _a2, _b2, _c2;
          return __spreadProps(__spreadValues({
            "data-id": id2,
            class: [
              "svelte-flow__node",
              `svelte-flow__node-${get$3(type)}`,
              get$3(className)
            ],
            style: get$3(nodeStyle),
            onclick: onSelectNodeHandler,
            onpointerenter: $$props.onnodepointerenter ? (event2) => $$props.onnodepointerenter({ node: get$3(userNode), event: event2 }) : void 0,
            onpointerleave: $$props.onnodepointerleave ? (event2) => $$props.onnodepointerleave({ node: get$3(userNode), event: event2 }) : void 0,
            onpointermove: $$props.onnodepointermove ? (event2) => $$props.onnodepointermove({ node: get$3(userNode), event: event2 }) : void 0,
            oncontextmenu: $$props.onnodecontextmenu ? (event2) => $$props.onnodecontextmenu({ node: get$3(userNode), event: event2 }) : void 0,
            onkeydown: get$3(focusable) ? onKeyDown : void 0,
            onfocus: get$3(focusable) ? onFocus : void 0,
            tabIndex: get$3(focusable) ? 0 : void 0,
            role: (_a2 = $$props.node.ariaRole) != null ? _a2 : get$3(focusable) ? "group" : void 0,
            "aria-roledescription": "node",
            "aria-describedby": store().disableKeyboardA11y ? void 0 : `${ARIA_NODE_DESC_KEY}-${store().flowId}`
          }, $$props.node.domAttributes), {
            [CLASS]: $0,
            [STYLE]: {
              "z-index": get$3(zIndex),
              transform: `translate(${(_b2 = get$3(positionX)) != null ? _b2 : ""}px, ${(_c2 = get$3(positionY)) != null ? _c2 : ""}px)`,
              visibility: get$3(hasDimensions) ? "visible" : "hidden"
            }
          });
        },
        [
          () => ({
            dragging: get$3(dragging),
            selected: get$3(selected),
            draggable: get$3(draggable),
            connectable: get$3(connectable),
            selectable: get$3(selectable),
            nopan: get$3(draggable),
            parent: get$3(isParent)
          })
        ]
      );
      var node_2 = child(div);
      component(node_2, () => get$3(NodeComponent), ($$anchor3, NodeComponent_1) => {
        NodeComponent_1($$anchor3, {
          get data() {
            return get$3(data);
          },
          get id() {
            return id2;
          },
          get selected() {
            return get$3(selected);
          },
          get selectable() {
            return get$3(selectable);
          },
          get deletable() {
            return get$3(deletable);
          },
          get sourcePosition() {
            return get$3(sourcePosition);
          },
          get targetPosition() {
            return get$3(targetPosition);
          },
          get zIndex() {
            return get$3(zIndex);
          },
          get dragging() {
            return get$3(dragging);
          },
          get draggable() {
            return get$3(draggable);
          },
          get dragHandle() {
            return get$3(dragHandle);
          },
          get parentId() {
            return get$3(parentId);
          },
          get type() {
            return get$3(type);
          },
          get isConnectable() {
            return get$3(connectable);
          },
          get positionAbsoluteX() {
            return get$3(positionX);
          },
          get positionAbsoluteY() {
            return get$3(positionY);
          },
          get width() {
            return get$3(width);
          },
          get height() {
            return get$3(height);
          }
        });
      });
      action(div, ($$node, $$action_arg) => drag == null ? void 0 : drag($$node, $$action_arg), () => ({
        nodeId: id2,
        isSelectable: get$3(selectable),
        disabled: !get$3(draggable),
        handleSelector: get$3(dragHandle),
        noDragClass: store().noDragClass,
        nodeClickDistance: $$props.nodeClickDistance,
        onNodeMouseDown: store().handleNodeSelection,
        onDrag: (event2, _2, targetNode, nodes) => {
          var _a2;
          (_a2 = $$props.onnodedrag) == null ? void 0 : _a2.call($$props, { event: event2, targetNode, nodes });
        },
        onDragStart: (event2, _2, targetNode, nodes) => {
          var _a2;
          (_a2 = $$props.onnodedragstart) == null ? void 0 : _a2.call($$props, { event: event2, targetNode, nodes });
        },
        onDragStop: (event2, _2, targetNode, nodes) => {
          var _a2;
          (_a2 = $$props.onnodedragstop) == null ? void 0 : _a2.call($$props, { event: event2, targetNode, nodes });
        },
        store: store()
      }));
      bind_this(div, ($$value) => set$2(nodeRef, $$value), () => get$3(nodeRef));
      append($$anchor2, div);
    };
    if_block(node_1, ($$render) => {
      if (!get$3(hidden)) $$render(consequent);
    });
  }
  append($$anchor, fragment);
  pop();
}
var root$s = /* @__PURE__ */ from_html(`<div class="svelte-flow__nodes"></div>`);
function NodeRenderer($$anchor, $$props) {
  push($$props, true);
  let store = prop($$props, "store", 15);
  const resizeObserver = typeof ResizeObserver === "undefined" ? null : new ResizeObserver((entries) => {
    const updates = /* @__PURE__ */ new Map();
    entries.forEach((entry) => {
      const id2 = entry.target.getAttribute("data-id");
      updates.set(id2, { id: id2, nodeElement: entry.target, force: true });
    });
    store().updateNodeInternals(updates);
  });
  onDestroy(() => {
    resizeObserver == null ? void 0 : resizeObserver.disconnect();
  });
  var div = root$s();
  each(div, 21, () => store().visible.nodes.values(), (node) => node.id, ($$anchor2, node) => {
    NodeWrapper($$anchor2, {
      get node() {
        return get$3(node);
      },
      get resizeObserver() {
        return resizeObserver;
      },
      get nodeClickDistance() {
        return $$props.nodeClickDistance;
      },
      get onnodeclick() {
        return $$props.onnodeclick;
      },
      get onnodepointerenter() {
        return $$props.onnodepointerenter;
      },
      get onnodepointermove() {
        return $$props.onnodepointermove;
      },
      get onnodepointerleave() {
        return $$props.onnodepointerleave;
      },
      get onnodedrag() {
        return $$props.onnodedrag;
      },
      get onnodedragstart() {
        return $$props.onnodedragstart;
      },
      get onnodedragstop() {
        return $$props.onnodedragstop;
      },
      get onnodecontextmenu() {
        return $$props.onnodecontextmenu;
      },
      get store() {
        return store();
      },
      set store($$value) {
        store($$value);
      }
    });
  });
  append($$anchor, div);
  pop();
}
var root_1$e = /* @__PURE__ */ from_svg(`<svg class="svelte-flow__edge-wrapper"><g><!></g></svg>`);
function EdgeWrapper($$anchor, $$props) {
  push($$props, true);
  let source2 = /* @__PURE__ */ user_derived(() => $$props.edge.source), target = /* @__PURE__ */ user_derived(() => $$props.edge.target), sourceX = /* @__PURE__ */ user_derived(() => $$props.edge.sourceX), sourceY = /* @__PURE__ */ user_derived(() => $$props.edge.sourceY), targetX = /* @__PURE__ */ user_derived(() => $$props.edge.targetX), targetY = /* @__PURE__ */ user_derived(() => $$props.edge.targetY), sourcePosition = /* @__PURE__ */ user_derived(() => $$props.edge.sourcePosition), targetPosition = /* @__PURE__ */ user_derived(() => $$props.edge.targetPosition), animated = /* @__PURE__ */ user_derived(() => fallback($$props.edge.animated, false)), selected = /* @__PURE__ */ user_derived(() => fallback($$props.edge.selected, false)), label = /* @__PURE__ */ user_derived(() => $$props.edge.label), labelStyle = /* @__PURE__ */ user_derived(() => $$props.edge.labelStyle), data = /* @__PURE__ */ user_derived(() => fallback($$props.edge.data, () => ({}), true)), style = /* @__PURE__ */ user_derived(() => $$props.edge.style), interactionWidth = /* @__PURE__ */ user_derived(() => $$props.edge.interactionWidth), type = /* @__PURE__ */ user_derived(() => fallback($$props.edge.type, "default")), sourceHandle = /* @__PURE__ */ user_derived(() => $$props.edge.sourceHandle), targetHandle = /* @__PURE__ */ user_derived(() => $$props.edge.targetHandle), markerStart = /* @__PURE__ */ user_derived(() => $$props.edge.markerStart), markerEnd = /* @__PURE__ */ user_derived(() => $$props.edge.markerEnd), _selectable = /* @__PURE__ */ user_derived(() => $$props.edge.selectable), _focusable = /* @__PURE__ */ user_derived(() => $$props.edge.focusable), deletable = /* @__PURE__ */ user_derived(() => fallback($$props.edge.deletable, true)), hidden = /* @__PURE__ */ user_derived(() => $$props.edge.hidden), zIndex = /* @__PURE__ */ user_derived(() => $$props.edge.zIndex), className = /* @__PURE__ */ user_derived(() => $$props.edge.class), ariaLabel = /* @__PURE__ */ user_derived(() => $$props.edge.ariaLabel);
  let edgeRef = null;
  const { id: id2 } = $$props.edge;
  setContext("svelteflow__edge_id", id2);
  let selectable = /* @__PURE__ */ user_derived(() => {
    var _a2;
    return (_a2 = get$3(_selectable)) != null ? _a2 : $$props.store.elementsSelectable;
  });
  let focusable = /* @__PURE__ */ user_derived(() => {
    var _a2;
    return (_a2 = get$3(_focusable)) != null ? _a2 : $$props.store.edgesFocusable;
  });
  let EdgeComponent = /* @__PURE__ */ user_derived(() => {
    var _a2;
    return (_a2 = $$props.store.edgeTypes[get$3(type)]) != null ? _a2 : BezierEdge;
  });
  let markerStartUrl = /* @__PURE__ */ user_derived(() => get$3(markerStart) ? `url('#${getMarkerId(get$3(markerStart), $$props.store.flowId)}')` : void 0);
  let markerEndUrl = /* @__PURE__ */ user_derived(() => get$3(markerEnd) ? `url('#${getMarkerId(get$3(markerEnd), $$props.store.flowId)}')` : void 0);
  function onclick2(event2) {
    var _a2;
    const edge = $$props.store.edgeLookup.get(id2);
    if (edge) {
      if (get$3(selectable)) $$props.store.handleEdgeSelection(id2);
      (_a2 = $$props.onedgeclick) == null ? void 0 : _a2.call($$props, { event: event2, edge });
    }
  }
  function onmouseevent(event2, callback) {
    const edge = $$props.store.edgeLookup.get(id2);
    if (edge) {
      callback({ event: event2, edge });
    }
  }
  function onkeydown(event2) {
    if (!$$props.store.disableKeyboardA11y && elementSelectionKeys.includes(event2.key) && get$3(selectable)) {
      const { unselectNodesAndEdges, addSelectedEdges } = $$props.store;
      const unselect = event2.key === "Escape";
      if (unselect) {
        edgeRef == null ? void 0 : edgeRef.blur();
        unselectNodesAndEdges({ edges: [$$props.edge] });
      } else {
        addSelectedEdges([id2]);
      }
    }
  }
  var fragment = comment();
  var node = first_child(fragment);
  {
    var consequent = ($$anchor2) => {
      var svg = root_1$e();
      let styles;
      var g = child(svg);
      attribute_effect(
        g,
        ($0) => {
          var _a2;
          return __spreadProps(__spreadValues({
            class: ["svelte-flow__edge", get$3(className)],
            "data-id": id2,
            onclick: onclick2,
            oncontextmenu: $$props.onedgecontextmenu ? (e) => {
              onmouseevent(e, $$props.onedgecontextmenu);
            } : void 0,
            onpointerenter: $$props.onedgepointerenter ? (e) => {
              onmouseevent(e, $$props.onedgepointerenter);
            } : void 0,
            onpointerleave: $$props.onedgepointerleave ? (e) => {
              onmouseevent(e, $$props.onedgepointerleave);
            } : void 0,
            "aria-label": get$3(ariaLabel) === null ? void 0 : get$3(ariaLabel) ? get$3(ariaLabel) : `Edge from ${get$3(source2)} to ${get$3(target)}`,
            "aria-describedby": get$3(focusable) ? `${ARIA_EDGE_DESC_KEY}-${$$props.store.flowId}` : void 0,
            role: (_a2 = $$props.edge.ariaRole) != null ? _a2 : get$3(focusable) ? "group" : "img",
            "aria-roledescription": "edge",
            onkeydown: get$3(focusable) ? onkeydown : void 0,
            tabindex: get$3(focusable) ? 0 : void 0
          }, $$props.edge.domAttributes), {
            [CLASS]: $0
          });
        },
        [
          () => ({
            animated: get$3(animated),
            selected: get$3(selected),
            selectable: get$3(selectable)
          })
        ]
      );
      var node_1 = child(g);
      component(node_1, () => get$3(EdgeComponent), ($$anchor3, EdgeComponent_1) => {
        EdgeComponent_1($$anchor3, {
          get id() {
            return id2;
          },
          get source() {
            return get$3(source2);
          },
          get target() {
            return get$3(target);
          },
          get sourceX() {
            return get$3(sourceX);
          },
          get sourceY() {
            return get$3(sourceY);
          },
          get targetX() {
            return get$3(targetX);
          },
          get targetY() {
            return get$3(targetY);
          },
          get sourcePosition() {
            return get$3(sourcePosition);
          },
          get targetPosition() {
            return get$3(targetPosition);
          },
          get animated() {
            return get$3(animated);
          },
          get selected() {
            return get$3(selected);
          },
          get label() {
            return get$3(label);
          },
          get labelStyle() {
            return get$3(labelStyle);
          },
          get data() {
            return get$3(data);
          },
          get style() {
            return get$3(style);
          },
          get interactionWidth() {
            return get$3(interactionWidth);
          },
          get selectable() {
            return get$3(selectable);
          },
          get deletable() {
            return get$3(deletable);
          },
          get type() {
            return get$3(type);
          },
          get sourceHandleId() {
            return get$3(sourceHandle);
          },
          get targetHandleId() {
            return get$3(targetHandle);
          },
          get markerStart() {
            return get$3(markerStartUrl);
          },
          get markerEnd() {
            return get$3(markerEndUrl);
          }
        });
      });
      bind_this(g, ($$value) => edgeRef = $$value, () => edgeRef);
      template_effect(() => styles = set_style(svg, "", styles, { "z-index": get$3(zIndex) }));
      append($$anchor2, svg);
    };
    if_block(node, ($$render) => {
      if (!get$3(hidden)) $$render(consequent);
    });
  }
  append($$anchor, fragment);
  pop();
}
enable_legacy_mode_flag();
var root$r = /* @__PURE__ */ from_svg(`<defs></defs>`);
function MarkerDefinition($$anchor, $$props) {
  push($$props, false);
  const store = useStore();
  init$1();
  var defs = root$r();
  each(defs, 5, () => store.markers, (marker) => marker.id, ($$anchor2, marker) => {
    Marker($$anchor2, spread_props(() => get$3(marker)));
  });
  append($$anchor, defs);
  pop();
}
var root_1$d = /* @__PURE__ */ from_svg(`<polyline stroke-linecap="round" stroke-linejoin="round" fill="none" points="-5,-4 0,0 -5,4"></polyline>`);
var root_3$e = /* @__PURE__ */ from_svg(`<polyline stroke-linecap="round" stroke-linejoin="round" points="-5,-4 0,0 -5,4 -5,-4"></polyline>`);
var root$q = /* @__PURE__ */ from_svg(`<marker class="svelte-flow__arrowhead" viewBox="-10 -10 20 20" refX="0" refY="0"><!></marker>`);
function Marker($$anchor, $$props) {
  push($$props, true);
  let width = prop($$props, "width", 3, 12.5), height = prop($$props, "height", 3, 12.5), markerUnits = prop($$props, "markerUnits", 3, "strokeWidth"), orient = prop($$props, "orient", 3, "auto-start-reverse");
  var marker = root$q();
  var node = child(marker);
  {
    var consequent = ($$anchor2) => {
      var polyline = root_1$d();
      template_effect(() => {
        set_attribute(polyline, "stroke", $$props.color);
        set_attribute(polyline, "stroke-width", $$props.strokeWidth);
      });
      append($$anchor2, polyline);
    };
    var alternate = ($$anchor2, $$elseif) => {
      {
        var consequent_1 = ($$anchor3) => {
          var polyline_1 = root_3$e();
          template_effect(() => {
            set_attribute(polyline_1, "stroke", $$props.color);
            set_attribute(polyline_1, "stroke-width", $$props.strokeWidth);
            set_attribute(polyline_1, "fill", $$props.color);
          });
          append($$anchor3, polyline_1);
        };
        if_block(
          $$anchor2,
          ($$render) => {
            if ($$props.type === MarkerType.ArrowClosed) $$render(consequent_1);
          },
          $$elseif
        );
      }
    };
    if_block(node, ($$render) => {
      if ($$props.type === MarkerType.Arrow) $$render(consequent);
      else $$render(alternate, false);
    });
  }
  template_effect(() => {
    set_attribute(marker, "id", $$props.id);
    set_attribute(marker, "markerWidth", `${width()}`);
    set_attribute(marker, "markerHeight", `${height()}`);
    set_attribute(marker, "markerUnits", markerUnits());
    set_attribute(marker, "orient", orient());
  });
  append($$anchor, marker);
  pop();
}
var root$p = /* @__PURE__ */ from_html(`<div class="svelte-flow__edges"><svg class="svelte-flow__marker"><!></svg> <!></div>`);
function EdgeRenderer($$anchor, $$props) {
  push($$props, true);
  let store = prop($$props, "store", 15);
  var div = root$p();
  var svg = child(div);
  var node = child(svg);
  MarkerDefinition(node, {});
  var node_1 = sibling(svg, 2);
  each(node_1, 17, () => store().visible.edges.values(), (edge) => edge.id, ($$anchor2, edge) => {
    EdgeWrapper($$anchor2, {
      get edge() {
        return get$3(edge);
      },
      get onedgeclick() {
        return $$props.onedgeclick;
      },
      get onedgecontextmenu() {
        return $$props.onedgecontextmenu;
      },
      get onedgepointerenter() {
        return $$props.onedgepointerenter;
      },
      get onedgepointerleave() {
        return $$props.onedgepointerleave;
      },
      get store() {
        return store();
      },
      set store($$value) {
        store($$value);
      }
    });
  });
  append($$anchor, div);
  pop();
}
var root_1$c = /* @__PURE__ */ from_html(`<div class="svelte-flow__selection svelte-1iugwpu"></div>`);
function Selection($$anchor, $$props) {
  push($$props, true);
  let x = prop($$props, "x", 3, 0), y2 = prop($$props, "y", 3, 0), width = prop($$props, "width", 3, 0), height = prop($$props, "height", 3, 0), isVisible = prop($$props, "isVisible", 3, true);
  var fragment = comment();
  var node = first_child(fragment);
  {
    var consequent = ($$anchor2) => {
      var div = root_1$c();
      let styles;
      template_effect(
        ($0, $1) => styles = set_style(div, "", styles, {
          width: $0,
          height: $1,
          transform: `translate(${x()}px, ${y2()}px)`
        }),
        [
          () => typeof width() === "string" ? width() : toPxString(width()),
          () => typeof height() === "string" ? height() : toPxString(height())
        ]
      );
      append($$anchor2, div);
    };
    if_block(node, ($$render) => {
      if (isVisible()) $$render(consequent);
    });
  }
  append($$anchor, fragment);
  pop();
}
function oncontextmenu(event2, $$props) {
  var _a2;
  const selectedNodes = $$props.store.nodes.filter((n) => n.selected);
  (_a2 = $$props.onselectioncontextmenu) == null ? void 0 : _a2.call($$props, { nodes: selectedNodes, event: event2 });
}
function onclick(event2, $$props) {
  var _a2;
  const selectedNodes = $$props.store.nodes.filter((n) => n.selected);
  (_a2 = $$props.onselectionclick) == null ? void 0 : _a2.call($$props, { nodes: selectedNodes, event: event2 });
}
var root_1$b = /* @__PURE__ */ from_html(`<div><!></div>`);
function NodeSelection($$anchor, $$props) {
  push($$props, true);
  let ref = /* @__PURE__ */ state(void 0);
  user_effect(() => {
    var _a2;
    if (!$$props.store.disableKeyboardA11y) {
      (_a2 = get$3(ref)) == null ? void 0 : _a2.focus({ preventScroll: true });
    }
  });
  let bounds = /* @__PURE__ */ user_derived(() => {
    if ($$props.store.selectionRectMode === "nodes") {
      $$props.store.nodes;
      return getInternalNodesBounds($$props.store.nodeLookup, { filter: (node) => !!node.selected });
    }
    return null;
  });
  function onkeydown(event2) {
    if (Object.prototype.hasOwnProperty.call(arrowKeyDiffs, event2.key)) {
      event2.preventDefault();
      $$props.store.moveSelectedNodes(arrowKeyDiffs[event2.key], event2.shiftKey ? 4 : 1);
    }
  }
  var fragment = comment();
  var node_1 = first_child(fragment);
  {
    var consequent = ($$anchor2) => {
      var div = root_1$b();
      div.__contextmenu = [oncontextmenu, $$props];
      div.__click = [onclick, $$props];
      div.__keydown = function(...$$args) {
        var _a2;
        (_a2 = $$props.store.disableKeyboardA11y ? void 0 : onkeydown) == null ? void 0 : _a2.apply(this, $$args);
      };
      let styles;
      var node_2 = child(div);
      Selection(node_2, { width: "100%", height: "100%", x: 0, y: 0 });
      action(div, ($$node, $$action_arg) => drag == null ? void 0 : drag($$node, $$action_arg), () => ({
        disabled: false,
        store: $$props.store,
        onDrag: (event2, _2, __, nodes) => {
          var _a2;
          (_a2 = $$props.onnodedrag) == null ? void 0 : _a2.call($$props, { event: event2, targetNode: null, nodes });
        },
        onDragStart: (event2, _2, __, nodes) => {
          var _a2;
          (_a2 = $$props.onnodedragstart) == null ? void 0 : _a2.call($$props, { event: event2, targetNode: null, nodes });
        },
        onDragStop: (event2, _2, __, nodes) => {
          var _a2;
          (_a2 = $$props.onnodedragstop) == null ? void 0 : _a2.call($$props, { event: event2, targetNode: null, nodes });
        }
      }));
      bind_this(div, ($$value) => set$2(ref, $$value), () => get$3(ref));
      template_effect(
        ($0, $1) => {
          var _a2, _b2;
          set_class(
            div,
            1,
            clsx([
              "svelte-flow__selection-wrapper",
              $$props.store.noPanClass
            ]),
            "svelte-16qgzgd"
          );
          set_attribute(div, "role", $$props.store.disableKeyboardA11y ? void 0 : "button");
          set_attribute(div, "tabindex", $$props.store.disableKeyboardA11y ? void 0 : -1);
          styles = set_style(div, "", styles, {
            width: $0,
            height: $1,
            transform: `translate(${(_a2 = get$3(bounds).x) != null ? _a2 : ""}px, ${(_b2 = get$3(bounds).y) != null ? _b2 : ""}px)`
          });
        },
        [
          () => toPxString(get$3(bounds).width),
          () => toPxString(get$3(bounds).height)
        ]
      );
      append($$anchor2, div);
    };
    if_block(node_1, ($$render) => {
      if ($$props.store.selectionRectMode === "nodes" && get$3(bounds) && isNumeric(get$3(bounds).x) && isNumeric(get$3(bounds).y)) $$render(consequent);
    });
  }
  append($$anchor, fragment);
  pop();
}
delegate(["contextmenu", "click", "keydown"]);
function mapModifierToBitMask(def) {
  switch (def) {
    case "ctrl":
      return 8;
    case "shift":
      return 4;
    case "alt":
      return 2;
    case "meta":
      return 1;
  }
}
function shortcut(node, param) {
  let { enabled = true, trigger, type = "keydown" } = param;
  function handler(event2) {
    var _a2;
    const normalizedTriggers = Array.isArray(trigger) ? trigger : [trigger];
    const modifierMask = [event2.metaKey, event2.altKey, event2.shiftKey, event2.ctrlKey].reduce(
      (acc, value, index2) => {
        if (value) {
          return acc | 1 << index2;
        }
        return acc;
      },
      0
    );
    for (const trigger2 of normalizedTriggers) {
      const mergedTrigger = __spreadValues({
        preventDefault: false,
        enabled: true
      }, trigger2);
      const { modifier, key: key2, callback, preventDefault, enabled: triggerEnabled } = mergedTrigger;
      if (triggerEnabled) {
        if (event2.key !== key2) continue;
        if (modifier === null || modifier === false) {
          if (modifierMask !== 0) continue;
        } else if (modifier !== void 0 && ((_a2 = modifier == null ? void 0 : modifier[0]) == null ? void 0 : _a2.length) > 0) {
          const orDefs = Array.isArray(modifier) ? modifier : [modifier];
          let modified = false;
          for (const orDef of orDefs) {
            const mask = (Array.isArray(orDef) ? orDef : [orDef]).reduce(
              (acc, def) => acc | mapModifierToBitMask(def),
              0
            );
            if (mask === modifierMask) {
              modified = true;
              break;
            }
          }
          if (!modified) continue;
        }
        if (preventDefault) event2.preventDefault();
        const detail = {
          node,
          trigger: mergedTrigger,
          originalEvent: event2
        };
        node.dispatchEvent(new CustomEvent("shortcut", { detail }));
        callback == null ? void 0 : callback(detail);
      }
    }
  }
  let off;
  if (enabled) {
    off = on(node, type, handler);
  }
  return {
    update: (update2) => {
      const { enabled: newEnabled = true, type: newType = "keydown" } = update2;
      if (enabled && (!newEnabled || type !== newType)) {
        off == null ? void 0 : off();
      } else if (!enabled && newEnabled) {
        off = on(node, newType, handler);
      }
      enabled = newEnabled;
      type = newType;
      trigger = update2.trigger;
    },
    destroy: () => {
      off == null ? void 0 : off();
    }
  };
}
function useSvelteFlow() {
  const store = /* @__PURE__ */ user_derived(useStore);
  const getNodeRect = (node) => {
    var _a2, _b2, _c2, _d2;
    const nodeToUse = isNode(node) ? node : get$3(store).nodeLookup.get(node.id);
    const position = nodeToUse.parentId ? evaluateAbsolutePosition(nodeToUse.position, nodeToUse.measured, nodeToUse.parentId, get$3(store).nodeLookup, get$3(store).nodeOrigin) : nodeToUse.position;
    const nodeWithPosition = __spreadProps(__spreadValues({}, nodeToUse), {
      position,
      width: (_b2 = (_a2 = nodeToUse.measured) == null ? void 0 : _a2.width) != null ? _b2 : nodeToUse.width,
      height: (_d2 = (_c2 = nodeToUse.measured) == null ? void 0 : _c2.height) != null ? _d2 : nodeToUse.height
    });
    return nodeToRect(nodeWithPosition);
  };
  function updateNode(id2, nodeUpdate, options = { replace: false }) {
    get$3(store).nodes = untrack(() => get$3(store).nodes).map((node) => {
      if (node.id === id2) {
        const nextNode = typeof nodeUpdate === "function" ? nodeUpdate(node) : nodeUpdate;
        return (options == null ? void 0 : options.replace) && isNode(nextNode) ? nextNode : __spreadValues(__spreadValues({}, node), nextNode);
      }
      return node;
    });
  }
  function updateEdge(id2, edgeUpdate, options = { replace: false }) {
    get$3(store).edges = untrack(() => get$3(store).edges).map((edge) => {
      if (edge.id === id2) {
        const nextEdge = typeof edgeUpdate === "function" ? edgeUpdate(edge) : edgeUpdate;
        return options.replace && isEdge(nextEdge) ? nextEdge : __spreadValues(__spreadValues({}, edge), nextEdge);
      }
      return edge;
    });
  }
  const getInternalNode = (id2) => get$3(store).nodeLookup.get(id2);
  return {
    zoomIn: get$3(store).zoomIn,
    zoomOut: get$3(store).zoomOut,
    getInternalNode,
    getNode: (id2) => {
      var _a2;
      return (_a2 = getInternalNode(id2)) == null ? void 0 : _a2.internals.userNode;
    },
    getNodes: (ids) => ids === void 0 ? get$3(store).nodes : getElements(get$3(store).nodeLookup, ids),
    getEdge: (id2) => get$3(store).edgeLookup.get(id2),
    getEdges: (ids) => ids === void 0 ? get$3(store).edges : getElements(get$3(store).edgeLookup, ids),
    setZoom: (zoomLevel, options) => {
      const panZoom = get$3(store).panZoom;
      return panZoom ? panZoom.scaleTo(zoomLevel, { duration: options == null ? void 0 : options.duration }) : Promise.resolve(false);
    },
    getZoom: () => get$3(store).viewport.zoom,
    setViewport: (nextViewport, options) => __async(null, null, function* () {
      var _a2, _b2, _c2;
      const currentViewport = get$3(store).viewport;
      if (!get$3(store).panZoom) {
        return Promise.resolve(false);
      }
      yield get$3(store).panZoom.setViewport(
        {
          x: (_a2 = nextViewport.x) != null ? _a2 : currentViewport.x,
          y: (_b2 = nextViewport.y) != null ? _b2 : currentViewport.y,
          zoom: (_c2 = nextViewport.zoom) != null ? _c2 : currentViewport.zoom
        },
        options
      );
      return Promise.resolve(true);
    }),
    getViewport: () => snapshot(get$3(store).viewport),
    setCenter: (x, y2, options) => __async(null, null, function* () {
      return get$3(store).setCenter(x, y2, options);
    }),
    fitView: (options) => get$3(store).fitView(options),
    fitBounds: (bounds, options) => __async(null, null, function* () {
      var _a2;
      if (!get$3(store).panZoom) {
        return Promise.resolve(false);
      }
      const viewport = getViewportForBounds(bounds, get$3(store).width, get$3(store).height, get$3(store).minZoom, get$3(store).maxZoom, (_a2 = options == null ? void 0 : options.padding) != null ? _a2 : 0.1);
      yield get$3(store).panZoom.setViewport(viewport, {
        duration: options == null ? void 0 : options.duration,
        ease: options == null ? void 0 : options.ease,
        interpolate: options == null ? void 0 : options.interpolate
      });
      return Promise.resolve(true);
    }),
    getIntersectingNodes: (nodeOrRect, partially = true, nodesToIntersect) => {
      const isRect = isRectObject(nodeOrRect);
      const nodeRect = isRect ? nodeOrRect : getNodeRect(nodeOrRect);
      if (!nodeRect) {
        return [];
      }
      return (nodesToIntersect || get$3(store).nodes).filter((n) => {
        const internalNode = get$3(store).nodeLookup.get(n.id);
        if (!internalNode || !isRect && n.id === nodeOrRect.id) {
          return false;
        }
        const currNodeRect = nodeToRect(internalNode);
        const overlappingArea = getOverlappingArea(currNodeRect, nodeRect);
        const partiallyVisible = partially && overlappingArea > 0;
        return partiallyVisible || overlappingArea >= nodeRect.width * nodeRect.height;
      });
    },
    isNodeIntersecting: (nodeOrRect, area, partially = true) => {
      const isRect = isRectObject(nodeOrRect);
      const nodeRect = isRect ? nodeOrRect : getNodeRect(nodeOrRect);
      if (!nodeRect) {
        return false;
      }
      const overlappingArea = getOverlappingArea(nodeRect, area);
      const partiallyVisible = partially && overlappingArea > 0;
      return partiallyVisible || overlappingArea >= nodeRect.width * nodeRect.height;
    },
    deleteElements: (_0) => __async(null, [_0], function* ({
      nodes: nodesToRemove = [],
      edges: edgesToRemove = []
    }) {
      const { nodes: matchingNodes, edges: matchingEdges } = yield getElementsToRemove({
        nodesToRemove,
        edgesToRemove,
        nodes: get$3(store).nodes,
        edges: get$3(store).edges,
        onBeforeDelete: get$3(store).onbeforedelete
      });
      if (matchingNodes) {
        get$3(store).nodes = untrack(() => get$3(store).nodes).filter((node) => !matchingNodes.some(({ id: id2 }) => id2 === node.id));
      }
      if (matchingEdges) {
        get$3(store).edges = untrack(() => get$3(store).edges).filter((edge) => !matchingEdges.some(({ id: id2 }) => id2 === edge.id));
      }
      return {
        deletedNodes: matchingNodes,
        deletedEdges: matchingEdges
      };
    }),
    screenToFlowPosition: (position, options = { snapToGrid: true }) => {
      if (!get$3(store).domNode) {
        return position;
      }
      const _snapGrid = options.snapToGrid ? get$3(store).snapGrid : false;
      const { x, y: y2, zoom: zoom2 } = get$3(store).viewport;
      const { x: domX, y: domY } = get$3(store).domNode.getBoundingClientRect();
      const correctedPosition = { x: position.x - domX, y: position.y - domY };
      return pointToRendererPoint(correctedPosition, [x, y2, zoom2], _snapGrid !== null, _snapGrid || [1, 1]);
    },
    /**
     *
     * @param position
     * @returns
     */
    flowToScreenPosition: (position) => {
      if (!get$3(store).domNode) {
        return position;
      }
      const { x, y: y2, zoom: zoom2 } = get$3(store).viewport;
      const { x: domX, y: domY } = get$3(store).domNode.getBoundingClientRect();
      const rendererPosition = rendererPointToPoint(position, [x, y2, zoom2]);
      return {
        x: rendererPosition.x + domX,
        y: rendererPosition.y + domY
      };
    },
    toObject: () => {
      return structuredClone({
        nodes: [...get$3(store).nodes],
        edges: [...get$3(store).edges],
        viewport: __spreadValues({}, get$3(store).viewport)
      });
    },
    updateNode,
    updateNodeData: (id2, dataUpdate, options) => {
      var _a2;
      const node = (_a2 = get$3(store).nodeLookup.get(id2)) == null ? void 0 : _a2.internals.userNode;
      if (!node) {
        return;
      }
      const nextData = typeof dataUpdate === "function" ? dataUpdate(node) : dataUpdate;
      updateNode(id2, (node2) => __spreadProps(__spreadValues({}, node2), {
        data: (options == null ? void 0 : options.replace) ? nextData : __spreadValues(__spreadValues({}, node2.data), nextData)
      }));
    },
    updateEdge,
    getNodesBounds: (nodes) => {
      return getNodesBounds(nodes, {
        nodeLookup: get$3(store).nodeLookup,
        nodeOrigin: get$3(store).nodeOrigin
      });
    },
    getHandleConnections: ({ type, id: id2, nodeId }) => {
      var _a2, _b2;
      return Array.from((_b2 = (_a2 = get$3(store).connectionLookup.get(`${nodeId}-${type}-${id2 != null ? id2 : null}`)) == null ? void 0 : _a2.values()) != null ? _b2 : []);
    }
  };
}
function getElements(lookup, ids) {
  var _a2;
  const result = [];
  for (const id2 of ids) {
    const item = lookup.get(id2);
    if (item) {
      const element = "internals" in item ? (_a2 = item.internals) == null ? void 0 : _a2.userNode : item;
      result.push(element);
    }
  }
  return result;
}
function KeyHandler($$anchor, $$props) {
  push($$props, true);
  let store = prop($$props, "store", 15), selectionKey = prop($$props, "selectionKey", 3, "Shift"), multiSelectionKey = prop($$props, "multiSelectionKey", 19, () => isMacOs() ? "Meta" : "Control"), deleteKey = prop($$props, "deleteKey", 3, "Backspace"), panActivationKey = prop($$props, "panActivationKey", 3, " "), zoomActivationKey = prop($$props, "zoomActivationKey", 19, () => isMacOs() ? "Meta" : "Control");
  let { deleteElements } = useSvelteFlow();
  function isKeyObject(key2) {
    return key2 !== null && typeof key2 === "object";
  }
  function getModifier(key2) {
    return isKeyObject(key2) ? key2.modifier || [] : [];
  }
  function getKeyString(key2) {
    if (key2 === null || key2 === void 0) {
      return "";
    }
    return isKeyObject(key2) ? key2.key : key2;
  }
  function getShortcutTrigger(key2, callback) {
    const keys = Array.isArray(key2) ? key2 : [key2];
    return keys.map((_key) => {
      const keyString = getKeyString(_key);
      return {
        key: keyString,
        modifier: getModifier(_key),
        enabled: keyString !== null,
        callback
      };
    });
  }
  function resetKeysAndSelection() {
    store(store().selectionRect = null, true);
    store(store().selectionKeyPressed = false, true);
    store(store().multiselectionKeyPressed = false, true);
    store(store().deleteKeyPressed = false, true);
    store(store().panActivationKeyPressed = false, true);
    store(store().zoomActivationKeyPressed = false, true);
  }
  function handleDelete() {
    return __async(this, null, function* () {
      var _a2, _b2;
      const selectedNodes = store().nodes.filter((node) => node.selected);
      const selectedEdges = store().edges.filter((edge) => edge.selected);
      const { deletedNodes, deletedEdges } = yield deleteElements({ nodes: selectedNodes, edges: selectedEdges });
      if (deletedNodes.length > 0 || deletedEdges.length > 0) {
        (_b2 = (_a2 = store()).ondelete) == null ? void 0 : _b2.call(_a2, { nodes: deletedNodes, edges: deletedEdges });
      }
    });
  }
  event("blur", $window, resetKeysAndSelection);
  event("contextmenu", $window, resetKeysAndSelection);
  action($window, ($$node, $$action_arg) => shortcut == null ? void 0 : shortcut($$node, $$action_arg), () => ({
    trigger: getShortcutTrigger(selectionKey(), () => store(store().selectionKeyPressed = true, true)),
    type: "keydown"
  }));
  action($window, ($$node, $$action_arg) => shortcut == null ? void 0 : shortcut($$node, $$action_arg), () => ({
    trigger: getShortcutTrigger(selectionKey(), () => store(store().selectionKeyPressed = false, true)),
    type: "keyup"
  }));
  action($window, ($$node, $$action_arg) => shortcut == null ? void 0 : shortcut($$node, $$action_arg), () => ({
    trigger: getShortcutTrigger(multiSelectionKey(), () => {
      store(store().multiselectionKeyPressed = true, true);
    }),
    type: "keydown"
  }));
  action($window, ($$node, $$action_arg) => shortcut == null ? void 0 : shortcut($$node, $$action_arg), () => ({
    trigger: getShortcutTrigger(multiSelectionKey(), () => store(store().multiselectionKeyPressed = false, true)),
    type: "keyup"
  }));
  action($window, ($$node, $$action_arg) => shortcut == null ? void 0 : shortcut($$node, $$action_arg), () => ({
    trigger: getShortcutTrigger(deleteKey(), (detail) => {
      const isModifierKey = detail.originalEvent.ctrlKey || detail.originalEvent.metaKey || detail.originalEvent.shiftKey;
      if (!isModifierKey && !isInputDOMNode(detail.originalEvent)) {
        store(store().deleteKeyPressed = true, true);
        handleDelete();
      }
    }),
    type: "keydown"
  }));
  action($window, ($$node, $$action_arg) => shortcut == null ? void 0 : shortcut($$node, $$action_arg), () => ({
    trigger: getShortcutTrigger(deleteKey(), () => store(store().deleteKeyPressed = false, true)),
    type: "keyup"
  }));
  action($window, ($$node, $$action_arg) => shortcut == null ? void 0 : shortcut($$node, $$action_arg), () => ({
    trigger: getShortcutTrigger(panActivationKey(), () => store(store().panActivationKeyPressed = true, true)),
    type: "keydown"
  }));
  action($window, ($$node, $$action_arg) => shortcut == null ? void 0 : shortcut($$node, $$action_arg), () => ({
    trigger: getShortcutTrigger(panActivationKey(), () => store(store().panActivationKeyPressed = false, true)),
    type: "keyup"
  }));
  action($window, ($$node, $$action_arg) => shortcut == null ? void 0 : shortcut($$node, $$action_arg), () => ({
    trigger: getShortcutTrigger(zoomActivationKey(), () => store(store().zoomActivationKeyPressed = true, true)),
    type: "keydown"
  }));
  action($window, ($$node, $$action_arg) => shortcut == null ? void 0 : shortcut($$node, $$action_arg), () => ({
    trigger: getShortcutTrigger(zoomActivationKey(), () => store(store().zoomActivationKeyPressed = false, true)),
    type: "keyup"
  }));
  pop();
}
var root_3$d = /* @__PURE__ */ from_svg(`<path fill="none" class="svelte-flow__connection-path"></path>`);
var root_1$a = /* @__PURE__ */ from_svg(`<svg class="svelte-flow__connectionline"><g><!></g></svg>`);
function ConnectionLine$1($$anchor, $$props) {
  push($$props, true);
  let path = /* @__PURE__ */ user_derived(() => {
    if (!$$props.store.connection.inProgress) {
      return "";
    }
    const pathParams = {
      sourceX: $$props.store.connection.from.x,
      sourceY: $$props.store.connection.from.y,
      sourcePosition: $$props.store.connection.fromPosition,
      targetX: $$props.store.connection.to.x,
      targetY: $$props.store.connection.to.y,
      targetPosition: $$props.store.connection.toPosition
    };
    switch ($$props.type) {
      case ConnectionLineType.Bezier: {
        const [path2] = getBezierPath(pathParams);
        return path2;
      }
      case ConnectionLineType.Straight: {
        const [path2] = getStraightPath(pathParams);
        return path2;
      }
      case ConnectionLineType.Step:
      case ConnectionLineType.SmoothStep: {
        const [path2] = getSmoothStepPath(__spreadProps(__spreadValues({}, pathParams), {
          borderRadius: $$props.type === ConnectionLineType.Step ? 0 : void 0
        }));
        return path2;
      }
    }
  });
  var fragment = comment();
  var node = first_child(fragment);
  {
    var consequent_1 = ($$anchor2) => {
      var svg = root_1$a();
      var g = child(svg);
      var node_1 = child(g);
      {
        var consequent = ($$anchor3) => {
          var fragment_1 = comment();
          var node_2 = first_child(fragment_1);
          component(node_2, () => $$props.LineComponent, ($$anchor4, LineComponent_1) => {
            LineComponent_1($$anchor4, {});
          });
          append($$anchor3, fragment_1);
        };
        var alternate = ($$anchor3) => {
          var path_1 = root_3$d();
          template_effect(() => {
            set_attribute(path_1, "d", get$3(path));
            set_style(path_1, $$props.style);
          });
          append($$anchor3, path_1);
        };
        if_block(node_1, ($$render) => {
          if ($$props.LineComponent) $$render(consequent);
          else $$render(alternate, false);
        });
      }
      template_effect(
        ($0) => {
          set_attribute(svg, "width", $$props.store.width);
          set_attribute(svg, "height", $$props.store.height);
          set_style(svg, $$props.containerStyle);
          set_class(g, 0, $0);
        },
        [
          () => clsx([
            "svelte-flow__connection",
            getConnectionStatus($$props.store.connection.isValid)
          ])
        ]
      );
      append($$anchor2, svg);
    };
    if_block(node, ($$render) => {
      if ($$props.store.connection.inProgress) $$render(consequent_1);
    });
  }
  append($$anchor, fragment);
  pop();
}
var root$o = /* @__PURE__ */ from_html(`<div><!></div>`);
function Panel($$anchor, $$props) {
  push($$props, true);
  let position = prop($$props, "position", 3, "top-right"), rest = /* @__PURE__ */ rest_props($$props, [
    "$$slots",
    "$$events",
    "$$legacy",
    "position",
    "style",
    "class",
    "children"
  ]);
  let positionClasses = /* @__PURE__ */ user_derived(() => `${position()}`.split("-"));
  var div = root$o();
  attribute_effect(div, ($0) => __spreadValues({ class: $0, style: $$props.style }, rest), [
    () => [
      "svelte-flow__panel",
      $$props.class,
      ...get$3(positionClasses)
    ]
  ]);
  var node = child(div);
  snippet(node, () => {
    var _a2;
    return (_a2 = $$props.children) != null ? _a2 : noop$1;
  });
  append($$anchor, div);
  pop();
}
var root_2$8 = /* @__PURE__ */ from_html(`<a href="https://svelteflow.dev" target="_blank" rel="noopener noreferrer" aria-label="Svelte Flow attribution">Svelte Flow</a>`);
function Attribution($$anchor, $$props) {
  push($$props, true);
  let position = prop($$props, "position", 3, "bottom-right");
  var fragment = comment();
  var node = first_child(fragment);
  {
    var consequent = ($$anchor2) => {
      Panel($$anchor2, {
        get position() {
          return position();
        },
        class: "svelte-flow__attribution",
        "data-message": "Feel free to remove the attribution or check out how you could support us: https://svelteflow.dev/support-us",
        children: ($$anchor3, $$slotProps) => {
          var a = root_2$8();
          append($$anchor3, a);
        },
        $$slots: { default: true }
      });
    };
    if_block(node, ($$render) => {
      var _a2;
      if (!((_a2 = $$props.proOptions) == null ? void 0 : _a2.hideAttribution)) $$render(consequent);
    });
  }
  append($$anchor, fragment);
  pop();
}
var root$n = /* @__PURE__ */ from_html(`<div><!></div>`);
function Wrapper($$anchor, $$props) {
  push($$props, true);
  let domNode = prop($$props, "domNode", 15), clientWidth = prop($$props, "clientWidth", 15), clientHeight = prop($$props, "clientHeight", 15);
  let className = /* @__PURE__ */ user_derived(() => $$props.rest.class), divAttributes = /* @__PURE__ */ user_derived(() => exclude_from_object($$props.rest, [
    "id",
    "class",
    "nodeTypes",
    "edgeTypes",
    "colorMode",
    "isValidConnection",
    "onmove",
    "onmovestart",
    "onmoveend",
    "onflowerror",
    "ondelete",
    "onbeforedelete",
    "onbeforeconnect",
    "onconnect",
    "onconnectstart",
    "onconnectend",
    "onbeforereconnect",
    "onreconnect",
    "onreconnectstart",
    "onreconnectend",
    "onclickconnectstart",
    "onclickconnectend",
    "oninit",
    "onselectionchange",
    "onselectiondragstart",
    "onselectiondrag",
    "onselectiondragstop",
    "onselectionstart",
    "onselectionend",
    "clickConnect",
    "fitView",
    "fitViewOptions",
    "nodeOrigin",
    "nodeDragThreshold",
    "connectionDragThreshold",
    "minZoom",
    "maxZoom",
    "initialViewport",
    "connectionRadius",
    "connectionMode",
    "selectionMode",
    "selectNodesOnDrag",
    "snapGrid",
    "defaultMarkerColor",
    "translateExtent",
    "nodeExtent",
    "onlyRenderVisibleElements",
    "autoPanOnConnect",
    "autoPanOnNodeDrag",
    "colorModeSSR",
    "style",
    "defaultEdgeOptions",
    "elevateNodesOnSelect",
    "elevateEdgesOnSelect",
    "nodesDraggable",
    "autoPanOnNodeFocus",
    "nodesConnectable",
    "elementsSelectable",
    "nodesFocusable",
    "edgesFocusable",
    "disableKeyboardA11y",
    "noDragClass",
    "noPanClass",
    "noWheelClass",
    "ariaLabelConfig"
  ]));
  function wrapperOnScroll(e) {
    e.currentTarget.scrollTo({ top: 0, left: 0, behavior: "auto" });
    if ($$props.rest.onscroll) {
      $$props.rest.onscroll(e);
    }
  }
  var div = root$n();
  attribute_effect(
    div,
    ($0, $1) => __spreadProps(__spreadValues({
      class: [
        "svelte-flow",
        "svelte-flow__container",
        get$3(className),
        $$props.colorMode
      ],
      "data-testid": "svelte-flow__wrapper",
      role: "application",
      onscroll: wrapperOnScroll
    }, get$3(divAttributes)), {
      [STYLE]: { width: $0, height: $1 }
    }),
    [
      () => toPxString($$props.width),
      () => toPxString($$props.height)
    ],
    "svelte-12wlba6"
  );
  var node = child(div);
  snippet(node, () => {
    var _a2;
    return (_a2 = $$props.children) != null ? _a2 : noop$1;
  });
  bind_this(div, ($$value) => domNode($$value), () => domNode());
  bind_element_size(div, "clientHeight", clientHeight);
  bind_element_size(div, "clientWidth", clientWidth);
  append($$anchor, div);
  pop();
}
var root_4$5 = /* @__PURE__ */ from_html(`<div class="svelte-flow__viewport-back svelte-flow__container"></div> <!> <div class="svelte-flow__edge-labels svelte-flow__container"></div> <!> <!> <!> <div class="svelte-flow__viewport-front svelte-flow__container"></div>`, 1);
var root_3$c = /* @__PURE__ */ from_html(`<!> <!>`, 1);
var root_1$9 = /* @__PURE__ */ from_html(`<!> <!> <!> <!> <!>`, 1);
function SvelteFlow($$anchor, $$props) {
  push($$props, true);
  let paneClickDistance = prop($$props, "paneClickDistance", 3, 1), nodeClickDistance = prop($$props, "nodeClickDistance", 3, 1), panOnScrollMode = prop($$props, "panOnScrollMode", 19, () => PanOnScrollMode.Free), preventScrolling = prop($$props, "preventScrolling", 3, true), zoomOnScroll = prop($$props, "zoomOnScroll", 3, true), zoomOnDoubleClick = prop($$props, "zoomOnDoubleClick", 3, true), zoomOnPinch = prop($$props, "zoomOnPinch", 3, true), panOnScroll = prop($$props, "panOnScroll", 3, false), panOnDrag = prop($$props, "panOnDrag", 3, true), selectionOnDrag = prop($$props, "selectionOnDrag", 3, true), connectionLineType = prop($$props, "connectionLineType", 19, () => ConnectionLineType.Bezier), nodes = prop($$props, "nodes", 31, () => proxy([])), edges = prop($$props, "edges", 31, () => proxy([])), viewport = prop($$props, "viewport", 15, void 0), props = /* @__PURE__ */ rest_props($$props, [
    "$$slots",
    "$$events",
    "$$legacy",
    "width",
    "height",
    "proOptions",
    "selectionKey",
    "deleteKey",
    "panActivationKey",
    "multiSelectionKey",
    "zoomActivationKey",
    "paneClickDistance",
    "nodeClickDistance",
    "onmovestart",
    "onmoveend",
    "onmove",
    "oninit",
    "onnodeclick",
    "onnodecontextmenu",
    "onnodedrag",
    "onnodedragstart",
    "onnodedragstop",
    "onnodepointerenter",
    "onnodepointermove",
    "onnodepointerleave",
    "onselectionclick",
    "onselectioncontextmenu",
    "onselectionstart",
    "onselectionend",
    "onedgeclick",
    "onedgecontextmenu",
    "onedgepointerenter",
    "onedgepointerleave",
    "onpaneclick",
    "onpanecontextmenu",
    "panOnScrollMode",
    "preventScrolling",
    "zoomOnScroll",
    "zoomOnDoubleClick",
    "zoomOnPinch",
    "panOnScroll",
    "panOnDrag",
    "selectionOnDrag",
    "connectionLineComponent",
    "connectionLineStyle",
    "connectionLineContainerStyle",
    "connectionLineType",
    "attributionPosition",
    "children",
    "nodes",
    "edges",
    "viewport"
  ]);
  let store = createStore({
    props,
    width: $$props.width,
    height: $$props.height,
    get nodes() {
      return nodes();
    },
    set nodes(newNodes) {
      nodes(newNodes);
    },
    get edges() {
      return edges();
    },
    set edges(newEdges) {
      edges(newEdges);
    },
    get viewport() {
      return viewport();
    },
    set viewport(newViewport) {
      viewport(newViewport);
    }
  });
  const providerContext = getContext(key);
  if (providerContext && providerContext.setStore) {
    providerContext.setStore(store);
  }
  setContext(key, {
    provider: false,
    getStore() {
      return store;
    }
  });
  user_effect(() => {
    var _a2;
    const params = {
      nodes: store.selectedNodes,
      edges: store.selectedEdges
    };
    (_a2 = untrack(() => $$props.onselectionchange)) == null ? void 0 : _a2(params);
    for (const handler of store.selectionChangeHandlers.values()) {
      handler(params);
    }
  });
  onDestroy(() => {
    store.reset();
  });
  Wrapper($$anchor, {
    get colorMode() {
      return store.colorMode;
    },
    get width() {
      return $$props.width;
    },
    get height() {
      return $$props.height;
    },
    get rest() {
      return props;
    },
    get domNode() {
      return store.domNode;
    },
    set domNode($$value) {
      store.domNode = $$value;
    },
    get clientWidth() {
      return store.width;
    },
    set clientWidth($$value) {
      store.width = $$value;
    },
    get clientHeight() {
      return store.height;
    },
    set clientHeight($$value) {
      store.height = $$value;
    },
    children: ($$anchor2, $$slotProps) => {
      var fragment_1 = root_1$9();
      var node = first_child(fragment_1);
      KeyHandler(node, {
        get selectionKey() {
          return $$props.selectionKey;
        },
        get deleteKey() {
          return $$props.deleteKey;
        },
        get panActivationKey() {
          return $$props.panActivationKey;
        },
        get multiSelectionKey() {
          return $$props.multiSelectionKey;
        },
        get zoomActivationKey() {
          return $$props.zoomActivationKey;
        },
        get store() {
          return store;
        },
        set store($$value) {
          store = $$value;
        }
      });
      var node_1 = sibling(node, 2);
      Zoom(node_1, {
        get panOnScrollMode() {
          return panOnScrollMode();
        },
        get preventScrolling() {
          return preventScrolling();
        },
        get zoomOnScroll() {
          return zoomOnScroll();
        },
        get zoomOnDoubleClick() {
          return zoomOnDoubleClick();
        },
        get zoomOnPinch() {
          return zoomOnPinch();
        },
        get panOnScroll() {
          return panOnScroll();
        },
        get panOnDrag() {
          return panOnDrag();
        },
        get paneClickDistance() {
          return paneClickDistance();
        },
        get onmovestart() {
          return $$props.onmovestart;
        },
        get onmove() {
          return $$props.onmove;
        },
        get onmoveend() {
          return $$props.onmoveend;
        },
        get oninit() {
          return $$props.oninit;
        },
        get store() {
          return store;
        },
        set store($$value) {
          store = $$value;
        },
        children: ($$anchor3, $$slotProps2) => {
          Pane($$anchor3, {
            get onpaneclick() {
              return $$props.onpaneclick;
            },
            get onpanecontextmenu() {
              return $$props.onpanecontextmenu;
            },
            get onselectionstart() {
              return $$props.onselectionstart;
            },
            get onselectionend() {
              return $$props.onselectionend;
            },
            get panOnDrag() {
              return panOnDrag();
            },
            get selectionOnDrag() {
              return selectionOnDrag();
            },
            get store() {
              return store;
            },
            set store($$value) {
              store = $$value;
            },
            children: ($$anchor4, $$slotProps3) => {
              var fragment_3 = root_3$c();
              var node_2 = first_child(fragment_3);
              Viewport(node_2, {
                get store() {
                  return store;
                },
                set store($$value) {
                  store = $$value;
                },
                children: ($$anchor5, $$slotProps4) => {
                  var fragment_4 = root_4$5();
                  var node_3 = sibling(first_child(fragment_4), 2);
                  EdgeRenderer(node_3, {
                    get onedgeclick() {
                      return $$props.onedgeclick;
                    },
                    get onedgecontextmenu() {
                      return $$props.onedgecontextmenu;
                    },
                    get onedgepointerenter() {
                      return $$props.onedgepointerenter;
                    },
                    get onedgepointerleave() {
                      return $$props.onedgepointerleave;
                    },
                    get store() {
                      return store;
                    },
                    set store($$value) {
                      store = $$value;
                    }
                  });
                  var node_4 = sibling(node_3, 4);
                  ConnectionLine$1(node_4, {
                    get type() {
                      return connectionLineType();
                    },
                    get LineComponent() {
                      return $$props.connectionLineComponent;
                    },
                    get containerStyle() {
                      return $$props.connectionLineContainerStyle;
                    },
                    get style() {
                      return $$props.connectionLineStyle;
                    },
                    get store() {
                      return store;
                    },
                    set store($$value) {
                      store = $$value;
                    }
                  });
                  var node_5 = sibling(node_4, 2);
                  NodeRenderer(node_5, {
                    get nodeClickDistance() {
                      return nodeClickDistance();
                    },
                    get onnodeclick() {
                      return $$props.onnodeclick;
                    },
                    get onnodecontextmenu() {
                      return $$props.onnodecontextmenu;
                    },
                    get onnodepointerenter() {
                      return $$props.onnodepointerenter;
                    },
                    get onnodepointermove() {
                      return $$props.onnodepointermove;
                    },
                    get onnodepointerleave() {
                      return $$props.onnodepointerleave;
                    },
                    get onnodedrag() {
                      return $$props.onnodedrag;
                    },
                    get onnodedragstart() {
                      return $$props.onnodedragstart;
                    },
                    get onnodedragstop() {
                      return $$props.onnodedragstop;
                    },
                    get store() {
                      return store;
                    },
                    set store($$value) {
                      store = $$value;
                    }
                  });
                  var node_6 = sibling(node_5, 2);
                  NodeSelection(node_6, {
                    get onselectionclick() {
                      return $$props.onselectionclick;
                    },
                    get onselectioncontextmenu() {
                      return $$props.onselectioncontextmenu;
                    },
                    get onnodedrag() {
                      return $$props.onnodedrag;
                    },
                    get onnodedragstart() {
                      return $$props.onnodedragstart;
                    },
                    get onnodedragstop() {
                      return $$props.onnodedragstop;
                    },
                    get store() {
                      return store;
                    },
                    set store($$value) {
                      store = $$value;
                    }
                  });
                  append($$anchor5, fragment_4);
                },
                $$slots: { default: true }
              });
              var node_7 = sibling(node_2, 2);
              const expression = /* @__PURE__ */ user_derived(() => !!(store.selectionRect && store.selectionRectMode === "user"));
              const expression_1 = /* @__PURE__ */ user_derived(() => {
                var _a2;
                return (_a2 = store.selectionRect) == null ? void 0 : _a2.width;
              });
              const expression_2 = /* @__PURE__ */ user_derived(() => {
                var _a2;
                return (_a2 = store.selectionRect) == null ? void 0 : _a2.height;
              });
              const expression_3 = /* @__PURE__ */ user_derived(() => {
                var _a2;
                return (_a2 = store.selectionRect) == null ? void 0 : _a2.x;
              });
              const expression_4 = /* @__PURE__ */ user_derived(() => {
                var _a2;
                return (_a2 = store.selectionRect) == null ? void 0 : _a2.y;
              });
              Selection(node_7, {
                get isVisible() {
                  return get$3(expression);
                },
                get width() {
                  return get$3(expression_1);
                },
                get height() {
                  return get$3(expression_2);
                },
                get x() {
                  return get$3(expression_3);
                },
                get y() {
                  return get$3(expression_4);
                }
              });
              append($$anchor4, fragment_3);
            },
            $$slots: { default: true }
          });
        },
        $$slots: { default: true }
      });
      var node_8 = sibling(node_1, 2);
      Attribution(node_8, {
        get proOptions() {
          return $$props.proOptions;
        },
        get position() {
          return $$props.attributionPosition;
        }
      });
      var node_9 = sibling(node_8, 2);
      A11yDescriptions(node_9, {
        get store() {
          return store;
        }
      });
      var node_10 = sibling(node_9, 2);
      snippet(node_10, () => {
        var _a2;
        return (_a2 = $$props.children) != null ? _a2 : noop$1;
      });
      append($$anchor2, fragment_1);
    },
    $$slots: { default: true }
  });
  pop();
}
function SvelteFlowProvider($$anchor, $$props) {
  push($$props, true);
  let store = /* @__PURE__ */ state(createStore({ props: {}, nodes: [], edges: [] }));
  setContext(key, {
    provider: true,
    getStore() {
      return get$3(store);
    },
    setStore: (newStore) => {
      set$2(store, newStore);
    }
  });
  onDestroy(() => {
    get$3(store).reset();
  });
  var fragment = comment();
  var node = first_child(fragment);
  snippet(node, () => {
    var _a2;
    return (_a2 = $$props.children) != null ? _a2 : noop$1;
  });
  append($$anchor, fragment);
  pop();
}
var root$m = /* @__PURE__ */ from_html(`<button><!></button>`);
function ControlButton($$anchor, $$props) {
  let restProps = /* @__PURE__ */ rest_props($$props, [
    "$$slots",
    "$$events",
    "$$legacy",
    "class",
    "bgColor",
    "bgColorHover",
    "color",
    "colorHover",
    "borderColor",
    "onclick",
    "children"
  ]);
  var button = root$m();
  attribute_effect(button, () => __spreadProps(__spreadValues({
    type: "button",
    onclick: $$props.onclick,
    class: ["svelte-flow__controls-button", $$props.class]
  }, restProps), {
    [STYLE]: {
      "--xy-controls-button-background-color-props": $$props.bgColor,
      "--xy-controls-button-background-color-hover-props": $$props.bgColorHover,
      "--xy-controls-button-color-props": $$props.color,
      "--xy-controls-button-color-hover-props": $$props.colorHover,
      "--xy-controls-button-border-color-props": $$props.borderColor
    }
  }));
  var node = child(button);
  snippet(node, () => {
    var _a2;
    return (_a2 = $$props.children) != null ? _a2 : noop$1;
  });
  append($$anchor, button);
}
var root$l = /* @__PURE__ */ from_svg(`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32"><path d="M32 18.133H18.133V32h-4.266V18.133H0v-4.266h13.867V0h4.266v13.867H32z"></path></svg>`);
function Plus($$anchor) {
  var svg = root$l();
  append($$anchor, svg);
}
var root$k = /* @__PURE__ */ from_svg(`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 5"><path d="M0 0h32v4.2H0z"></path></svg>`);
function Minus($$anchor) {
  var svg = root$k();
  append($$anchor, svg);
}
var root$j = /* @__PURE__ */ from_svg(`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 30"><path d="M3.692 4.63c0-.53.4-.938.939-.938h5.215V0H4.708C2.13 0 0 2.054 0 4.63v5.216h3.692V4.631zM27.354 0h-5.2v3.692h5.17c.53 0 .984.4.984.939v5.215H32V4.631A4.624 4.624 0 0027.354 0zm.954 24.83c0 .532-.4.94-.939.94h-5.215v3.768h5.215c2.577 0 4.631-2.13 4.631-4.707v-5.139h-3.692v5.139zm-23.677.94c-.531 0-.939-.4-.939-.94v-5.138H0v5.139c0 2.577 2.13 4.707 4.708 4.707h5.138V25.77H4.631z"></path></svg>`);
function Fit($$anchor) {
  var svg = root$j();
  append($$anchor, svg);
}
var root$i = /* @__PURE__ */ from_svg(`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 32"><path d="M21.333 10.667H19.81V7.619C19.81 3.429 16.38 0 12.19 0 8 0 4.571 3.429 4.571 7.619v3.048H3.048A3.056 3.056 0 000 13.714v15.238A3.056 3.056 0 003.048 32h18.285a3.056 3.056 0 003.048-3.048V13.714a3.056 3.056 0 00-3.048-3.047zM12.19 24.533a3.056 3.056 0 01-3.047-3.047 3.056 3.056 0 013.047-3.048 3.056 3.056 0 013.048 3.048 3.056 3.056 0 01-3.048 3.047zm4.724-13.866H7.467V7.619c0-2.59 2.133-4.724 4.723-4.724 2.591 0 4.724 2.133 4.724 4.724v3.048z"></path></svg>`);
function Lock($$anchor) {
  var svg = root$i();
  append($$anchor, svg);
}
var root$h = /* @__PURE__ */ from_svg(`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 32"><path d="M21.333 10.667H19.81V7.619C19.81 3.429 16.38 0 12.19 0c-4.114 1.828-1.37 2.133.305 2.438 1.676.305 4.42 2.59 4.42 5.181v3.048H3.047A3.056 3.056 0 000 13.714v15.238A3.056 3.056 0 003.048 32h18.285a3.056 3.056 0 003.048-3.048V13.714a3.056 3.056 0 00-3.048-3.047zM12.19 24.533a3.056 3.056 0 01-3.047-3.047 3.056 3.056 0 013.047-3.048 3.056 3.056 0 013.048 3.048 3.056 3.056 0 01-3.048 3.047z"></path></svg>`);
function Unlock($$anchor) {
  var svg = root$h();
  append($$anchor, svg);
}
var root_3$b = /* @__PURE__ */ from_html(`<!> <!>`, 1);
var root_1$8 = /* @__PURE__ */ from_html(`<!> <!> <!> <!> <!> <!>`, 1);
function Controls($$anchor, $$props) {
  push($$props, true);
  let position = prop($$props, "position", 3, "bottom-left"), orientation = prop($$props, "orientation", 3, "vertical"), showZoom = prop($$props, "showZoom", 3, true), showFitView = prop($$props, "showFitView", 3, true), showLock = prop($$props, "showLock", 3, true), rest = /* @__PURE__ */ rest_props($$props, [
    "$$slots",
    "$$events",
    "$$legacy",
    "position",
    "orientation",
    "showZoom",
    "showFitView",
    "showLock",
    "style",
    "class",
    "buttonBgColor",
    "buttonBgColorHover",
    "buttonColor",
    "buttonColorHover",
    "buttonBorderColor",
    "fitViewOptions",
    "children",
    "before",
    "after"
  ]);
  let store = /* @__PURE__ */ user_derived(useStore);
  const buttonProps = {
    bgColor: $$props.buttonBgColor,
    bgColorHover: $$props.buttonBgColorHover,
    color: $$props.buttonColor,
    colorHover: $$props.buttonColorHover,
    borderColor: $$props.buttonBorderColor
  };
  let isInteractive = /* @__PURE__ */ user_derived(() => get$3(store).nodesDraggable || get$3(store).nodesConnectable || get$3(store).elementsSelectable);
  let minZoomReached = /* @__PURE__ */ user_derived(() => get$3(store).viewport.zoom <= get$3(store).minZoom);
  let maxZoomReached = /* @__PURE__ */ user_derived(() => get$3(store).viewport.zoom >= get$3(store).maxZoom);
  let ariaLabelConfig = /* @__PURE__ */ user_derived(() => get$3(store).ariaLabelConfig);
  let orientationClass = /* @__PURE__ */ user_derived(() => orientation() === "horizontal" ? "horizontal" : "vertical");
  const onZoomInHandler = () => {
    get$3(store).zoomIn();
  };
  const onZoomOutHandler = () => {
    get$3(store).zoomOut();
  };
  const onFitViewHandler = () => {
    get$3(store).fitView($$props.fitViewOptions);
  };
  const onToggleInteractivity = () => {
    let interactive2 = !get$3(isInteractive);
    get$3(store).nodesDraggable = interactive2;
    get$3(store).nodesConnectable = interactive2;
    get$3(store).elementsSelectable = interactive2;
  };
  const expression = /* @__PURE__ */ user_derived(() => [
    "svelte-flow__controls",
    get$3(orientationClass),
    $$props.class
  ]);
  Panel($$anchor, spread_props(
    {
      get class() {
        return get$3(expression);
      },
      get position() {
        return position();
      },
      "data-testid": "svelte-flow__controls",
      get "aria-label"() {
        return get$3(ariaLabelConfig)["controls.ariaLabel"];
      },
      get style() {
        return $$props.style;
      }
    },
    () => rest,
    {
      children: ($$anchor2, $$slotProps) => {
        var fragment_1 = root_1$8();
        var node = first_child(fragment_1);
        {
          var consequent = ($$anchor3) => {
            var fragment_2 = comment();
            var node_1 = first_child(fragment_2);
            snippet(node_1, () => $$props.before);
            append($$anchor3, fragment_2);
          };
          if_block(node, ($$render) => {
            if ($$props.before) $$render(consequent);
          });
        }
        var node_2 = sibling(node, 2);
        {
          var consequent_1 = ($$anchor3) => {
            var fragment_3 = root_3$b();
            var node_3 = first_child(fragment_3);
            ControlButton(node_3, spread_props(
              {
                onclick: onZoomInHandler,
                class: "svelte-flow__controls-zoomin",
                get title() {
                  return get$3(ariaLabelConfig)["controls.zoomIn.ariaLabel"];
                },
                get "aria-label"() {
                  return get$3(ariaLabelConfig)["controls.zoomIn.ariaLabel"];
                },
                get disabled() {
                  return get$3(maxZoomReached);
                }
              },
              () => buttonProps,
              {
                children: ($$anchor4, $$slotProps2) => {
                  Plus($$anchor4);
                },
                $$slots: { default: true }
              }
            ));
            var node_4 = sibling(node_3, 2);
            ControlButton(node_4, spread_props(
              {
                onclick: onZoomOutHandler,
                class: "svelte-flow__controls-zoomout",
                get title() {
                  return get$3(ariaLabelConfig)["controls.zoomOut.ariaLabel"];
                },
                get "aria-label"() {
                  return get$3(ariaLabelConfig)["controls.zoomOut.ariaLabel"];
                },
                get disabled() {
                  return get$3(minZoomReached);
                }
              },
              () => buttonProps,
              {
                children: ($$anchor4, $$slotProps2) => {
                  Minus($$anchor4);
                },
                $$slots: { default: true }
              }
            ));
            append($$anchor3, fragment_3);
          };
          if_block(node_2, ($$render) => {
            if (showZoom()) $$render(consequent_1);
          });
        }
        var node_5 = sibling(node_2, 2);
        {
          var consequent_2 = ($$anchor3) => {
            ControlButton($$anchor3, spread_props(
              {
                class: "svelte-flow__controls-fitview",
                onclick: onFitViewHandler,
                get title() {
                  return get$3(ariaLabelConfig)["controls.fitView.ariaLabel"];
                },
                get "aria-label"() {
                  return get$3(ariaLabelConfig)["controls.fitView.ariaLabel"];
                }
              },
              () => buttonProps,
              {
                children: ($$anchor4, $$slotProps2) => {
                  Fit($$anchor4);
                },
                $$slots: { default: true }
              }
            ));
          };
          if_block(node_5, ($$render) => {
            if (showFitView()) $$render(consequent_2);
          });
        }
        var node_6 = sibling(node_5, 2);
        {
          var consequent_4 = ($$anchor3) => {
            ControlButton($$anchor3, spread_props(
              {
                class: "svelte-flow__controls-interactive",
                onclick: onToggleInteractivity,
                get title() {
                  return get$3(ariaLabelConfig)["controls.interactive.ariaLabel"];
                },
                get "aria-label"() {
                  return get$3(ariaLabelConfig)["controls.interactive.ariaLabel"];
                }
              },
              () => buttonProps,
              {
                children: ($$anchor4, $$slotProps2) => {
                  var fragment_9 = comment();
                  var node_7 = first_child(fragment_9);
                  {
                    var consequent_3 = ($$anchor5) => {
                      Unlock($$anchor5);
                    };
                    var alternate = ($$anchor5) => {
                      Lock($$anchor5);
                    };
                    if_block(node_7, ($$render) => {
                      if (get$3(isInteractive)) $$render(consequent_3);
                      else $$render(alternate, false);
                    });
                  }
                  append($$anchor4, fragment_9);
                },
                $$slots: { default: true }
              }
            ));
          };
          if_block(node_6, ($$render) => {
            if (showLock()) $$render(consequent_4);
          });
        }
        var node_8 = sibling(node_6, 2);
        {
          var consequent_5 = ($$anchor3) => {
            var fragment_12 = comment();
            var node_9 = first_child(fragment_12);
            snippet(node_9, () => $$props.children);
            append($$anchor3, fragment_12);
          };
          if_block(node_8, ($$render) => {
            if ($$props.children) $$render(consequent_5);
          });
        }
        var node_10 = sibling(node_8, 2);
        {
          var consequent_6 = ($$anchor3) => {
            var fragment_13 = comment();
            var node_11 = first_child(fragment_13);
            snippet(node_11, () => $$props.after);
            append($$anchor3, fragment_13);
          };
          if_block(node_10, ($$render) => {
            if ($$props.after) $$render(consequent_6);
          });
        }
        append($$anchor2, fragment_1);
      },
      $$slots: { default: true }
    }
  ));
  pop();
}
var BackgroundVariant;
(function(BackgroundVariant2) {
  BackgroundVariant2["Lines"] = "lines";
  BackgroundVariant2["Dots"] = "dots";
  BackgroundVariant2["Cross"] = "cross";
})(BackgroundVariant || (BackgroundVariant = {}));
var root$g = /* @__PURE__ */ from_svg(`<circle></circle>`);
function DotPattern($$anchor, $$props) {
  var circle = root$g();
  template_effect(() => {
    set_attribute(circle, "cx", $$props.radius);
    set_attribute(circle, "cy", $$props.radius);
    set_attribute(circle, "r", $$props.radius);
    set_class(circle, 0, clsx([
      "svelte-flow__background-pattern",
      "dots",
      $$props.class
    ]));
  });
  append($$anchor, circle);
}
var root$f = /* @__PURE__ */ from_svg(`<path></path>`);
function LinePattern($$anchor, $$props) {
  push($$props, true);
  var path = root$f();
  template_effect(() => {
    set_attribute(path, "stroke-width", $$props.lineWidth);
    set_attribute(path, "d", `M${$$props.dimensions[0] / 2} 0 V${$$props.dimensions[1]} M0 ${$$props.dimensions[1] / 2} H${$$props.dimensions[0]}`);
    set_class(path, 0, clsx([
      "svelte-flow__background-pattern",
      $$props.variant,
      $$props.class
    ]));
  });
  append($$anchor, path);
  pop();
}
const defaultSize = {
  [BackgroundVariant.Dots]: 1,
  [BackgroundVariant.Lines]: 1,
  [BackgroundVariant.Cross]: 6
};
var root$e = /* @__PURE__ */ from_svg(`<svg data-testid="svelte-flow__background"><pattern patternUnits="userSpaceOnUse"><!></pattern><rect x="0" y="0" width="100%" height="100%"></rect></svg>`);
function Background($$anchor, $$props) {
  push($$props, true);
  let variant = prop($$props, "variant", 19, () => BackgroundVariant.Dots), gap = prop($$props, "gap", 3, 20), lineWidth = prop($$props, "lineWidth", 3, 1);
  let store = /* @__PURE__ */ user_derived(useStore);
  let isDots = /* @__PURE__ */ user_derived(() => variant() === BackgroundVariant.Dots);
  let isCross = /* @__PURE__ */ user_derived(() => variant() === BackgroundVariant.Cross);
  let gapXY = /* @__PURE__ */ user_derived(() => Array.isArray(gap()) ? gap() : [gap(), gap()]);
  let patternId = /* @__PURE__ */ user_derived(() => {
    var _a2;
    return `background-pattern-${get$3(store).flowId}-${(_a2 = $$props.id) != null ? _a2 : ""}`;
  });
  let scaledGap = /* @__PURE__ */ user_derived(() => [
    get$3(gapXY)[0] * get$3(store).viewport.zoom || 1,
    get$3(gapXY)[1] * get$3(store).viewport.zoom || 1
  ]);
  let scaledSize = /* @__PURE__ */ user_derived(() => {
    var _a2;
    return ((_a2 = $$props.size) != null ? _a2 : defaultSize[variant()]) * get$3(store).viewport.zoom;
  });
  let patternDimensions = /* @__PURE__ */ user_derived(() => get$3(isCross) ? [get$3(scaledSize), get$3(scaledSize)] : get$3(scaledGap));
  let patternOffset = /* @__PURE__ */ user_derived(() => get$3(isDots) ? [
    get$3(scaledSize) / 2,
    get$3(scaledSize) / 2
  ] : [
    get$3(patternDimensions)[0] / 2,
    get$3(patternDimensions)[1] / 2
  ]);
  var svg = root$e();
  let styles;
  var pattern = child(svg);
  var node = child(pattern);
  {
    var consequent = ($$anchor2) => {
      const expression = /* @__PURE__ */ user_derived(() => get$3(scaledSize) / 2);
      DotPattern($$anchor2, {
        get radius() {
          return get$3(expression);
        },
        get class() {
          return $$props.patternClass;
        }
      });
    };
    var alternate = ($$anchor2) => {
      LinePattern($$anchor2, {
        get dimensions() {
          return get$3(patternDimensions);
        },
        get variant() {
          return variant();
        },
        get lineWidth() {
          return lineWidth();
        },
        get class() {
          return $$props.patternClass;
        }
      });
    };
    if_block(node, ($$render) => {
      if (get$3(isDots)) $$render(consequent);
      else $$render(alternate, false);
    });
  }
  var rect = sibling(pattern);
  template_effect(() => {
    set_class(svg, 0, clsx([
      "svelte-flow__background",
      "svelte-flow__container",
      $$props.class
    ]));
    styles = set_style(svg, "", styles, {
      "--xy-background-color-props": $$props.bgColor,
      "--xy-background-pattern-color-props": $$props.patternColor
    });
    set_attribute(pattern, "id", get$3(patternId));
    set_attribute(pattern, "x", get$3(store).viewport.x % get$3(scaledGap)[0]);
    set_attribute(pattern, "y", get$3(store).viewport.y % get$3(scaledGap)[1]);
    set_attribute(pattern, "width", get$3(scaledGap)[0]);
    set_attribute(pattern, "height", get$3(scaledGap)[1]);
    set_attribute(pattern, "patternTransform", `translate(-${get$3(patternOffset)[0]},-${get$3(patternOffset)[1]})`);
    set_attribute(rect, "fill", `url(#${get$3(patternId)})`);
  });
  append($$anchor, svg);
  pop();
}
var root$d = /* @__PURE__ */ from_svg(`<rect></rect>`);
function MinimapNode($$anchor, $$props) {
  let borderRadius = prop($$props, "borderRadius", 3, 5), strokeWidth = prop($$props, "strokeWidth", 3, 2);
  var rect = root$d();
  let classes;
  let styles;
  template_effect(
    ($0) => {
      classes = set_class(rect, 0, clsx(["svelte-flow__minimap-node", $$props.class]), null, classes, $0);
      set_attribute(rect, "x", $$props.x);
      set_attribute(rect, "y", $$props.y);
      set_attribute(rect, "rx", borderRadius());
      set_attribute(rect, "ry", borderRadius());
      set_attribute(rect, "width", $$props.width);
      set_attribute(rect, "height", $$props.height);
      set_attribute(rect, "shape-rendering", $$props.shapeRendering);
      styles = set_style(rect, "", styles, {
        fill: $$props.color,
        stroke: $$props.strokeColor,
        "stroke-width": strokeWidth()
      });
    },
    [() => ({ selected: $$props.selected })]
  );
  append($$anchor, rect);
}
function interactive(domNode, params) {
  const minimap = XYMinimap({
    domNode,
    panZoom: params.panZoom,
    getTransform: () => {
      const { viewport } = params.store;
      return [viewport.x, viewport.y, viewport.zoom];
    },
    getViewScale: params.getViewScale
  });
  minimap.update({
    translateExtent: params.translateExtent,
    width: params.width,
    height: params.height,
    inversePan: params.inversePan,
    zoomStep: params.zoomStep,
    pannable: params.pannable,
    zoomable: params.zoomable
  });
  function update2(params2) {
    minimap.update({
      translateExtent: params2.translateExtent,
      width: params2.width,
      height: params2.height,
      inversePan: params2.inversePan,
      zoomStep: params2.zoomStep,
      pannable: params2.pannable,
      zoomable: params2.zoomable
    });
  }
  return {
    update: update2,
    destroy() {
      minimap.destroy();
    }
  };
}
const getAttrFunction = (func) => func instanceof Function ? func : () => func;
var root_3$a = /* @__PURE__ */ from_svg(`<title> </title>`);
var root_2$7 = /* @__PURE__ */ from_svg(`<svg class="svelte-flow__minimap-svg" role="img"><!><!><path class="svelte-flow__minimap-mask" fill-rule="evenodd" pointer-events="none"></path></svg>`);
var root$c = /* @__PURE__ */ from_html(`<svelte-css-wrapper style="display: contents"><!></svelte-css-wrapper>`, 1);
function Minimap($$anchor, $$props) {
  push($$props, true);
  let position = prop($$props, "position", 3, "bottom-right"), nodeStrokeColor = prop($$props, "nodeStrokeColor", 3, "transparent"), nodeClass = prop($$props, "nodeClass", 3, ""), nodeBorderRadius = prop($$props, "nodeBorderRadius", 3, 5), nodeStrokeWidth = prop($$props, "nodeStrokeWidth", 3, 2), width = prop($$props, "width", 3, 200), height = prop($$props, "height", 3, 150), pannable = prop($$props, "pannable", 3, true), zoomable = prop($$props, "zoomable", 3, true), rest = /* @__PURE__ */ rest_props($$props, [
    "$$slots",
    "$$events",
    "$$legacy",
    "position",
    "ariaLabel",
    "nodeStrokeColor",
    "nodeColor",
    "nodeClass",
    "nodeBorderRadius",
    "nodeStrokeWidth",
    "bgColor",
    "maskColor",
    "maskStrokeColor",
    "maskStrokeWidth",
    "width",
    "height",
    "pannable",
    "zoomable",
    "inversePan",
    "zoomStep",
    "class"
  ]);
  let store = /* @__PURE__ */ user_derived(useStore);
  let ariaLabelConfig = /* @__PURE__ */ user_derived(() => get$3(store).ariaLabelConfig);
  const nodeColorFunc = $$props.nodeColor === void 0 ? void 0 : getAttrFunction($$props.nodeColor);
  const nodeStrokeColorFunc = getAttrFunction(nodeStrokeColor());
  const nodeClassFunc = getAttrFunction(nodeClass());
  const shapeRendering = (
    // @ts-expect-error - TS doesn't know about chrome
    typeof window === "undefined" || !!window.chrome ? "crispEdges" : "geometricPrecision"
  );
  let labelledBy = /* @__PURE__ */ user_derived(() => `svelte-flow__minimap-desc-${get$3(store).flowId}`);
  let viewBB = /* @__PURE__ */ user_derived(() => ({
    x: -get$3(store).viewport.x / get$3(store).viewport.zoom,
    y: -get$3(store).viewport.y / get$3(store).viewport.zoom,
    width: get$3(store).width / get$3(store).viewport.zoom,
    height: get$3(store).height / get$3(store).viewport.zoom
  }));
  let boundingRect = /* @__PURE__ */ user_derived(() => get$3(store).nodeLookup.size > 0 ? getBoundsOfRects(getInternalNodesBounds(get$3(store).nodeLookup, { filter: (n) => !n.hidden }), get$3(viewBB)) : get$3(viewBB));
  let scaledWidth = /* @__PURE__ */ user_derived(() => get$3(boundingRect).width / width());
  let scaledHeight = /* @__PURE__ */ user_derived(() => get$3(boundingRect).height / height());
  let viewScale = /* @__PURE__ */ user_derived(() => Math.max(get$3(scaledWidth), get$3(scaledHeight)));
  let viewWidth = /* @__PURE__ */ user_derived(() => get$3(viewScale) * width());
  let viewHeight = /* @__PURE__ */ user_derived(() => get$3(viewScale) * height());
  let offset = /* @__PURE__ */ user_derived(() => 5 * get$3(viewScale));
  let x = /* @__PURE__ */ user_derived(() => get$3(boundingRect).x - (get$3(viewWidth) - get$3(boundingRect).width) / 2 - get$3(offset));
  let y2 = /* @__PURE__ */ user_derived(() => get$3(boundingRect).y - (get$3(viewHeight) - get$3(boundingRect).height) / 2 - get$3(offset));
  let viewboxWidth = /* @__PURE__ */ user_derived(() => get$3(viewWidth) + get$3(offset) * 2);
  let viewboxHeight = /* @__PURE__ */ user_derived(() => get$3(viewHeight) + get$3(offset) * 2);
  const getViewScale = () => get$3(viewScale);
  var fragment = root$c();
  var node_1 = first_child(fragment);
  const expression = /* @__PURE__ */ user_derived(() => ["svelte-flow__minimap", $$props.class]);
  {
    css_props(node_1, () => ({
      "--xy-minimap-background-color-props": $$props.bgColor
    }));
    Panel(node_1.lastChild, spread_props(
      {
        get position() {
          return position();
        },
        get class() {
          return get$3(expression);
        },
        "data-testid": "svelte-flow__minimap"
      },
      () => rest,
      {
        children: ($$anchor2, $$slotProps) => {
          var fragment_1 = comment();
          var node_2 = first_child(fragment_1);
          {
            var consequent_2 = ($$anchor3) => {
              var svg = root_2$7();
              let styles;
              var node_3 = child(svg);
              {
                var consequent = ($$anchor4) => {
                  var title = root_3$a();
                  var text2 = child(title);
                  template_effect(() => {
                    var _a2;
                    set_attribute(title, "id", get$3(labelledBy));
                    set_text(text2, (_a2 = $$props.ariaLabel) != null ? _a2 : get$3(ariaLabelConfig)["minimap.ariaLabel"]);
                  });
                  append($$anchor4, title);
                };
                if_block(node_3, ($$render) => {
                  var _a2;
                  if ((_a2 = $$props.ariaLabel) != null ? _a2 : get$3(ariaLabelConfig)["minimap.ariaLabel"]) $$render(consequent);
                });
              }
              var node_4 = sibling(node_3);
              each(node_4, 17, () => get$3(store).nodes, (userNode) => userNode.id, ($$anchor4, userNode) => {
                var fragment_2 = comment();
                const node = /* @__PURE__ */ user_derived(() => get$3(store).nodeLookup.get(get$3(userNode).id));
                var node_5 = first_child(fragment_2);
                {
                  var consequent_1 = ($$anchor5) => {
                    const nodeDimesions = /* @__PURE__ */ user_derived(() => getNodeDimensions(get$3(node)));
                    const expression_1 = /* @__PURE__ */ user_derived(() => nodeColorFunc == null ? void 0 : nodeColorFunc(get$3(node)));
                    const expression_2 = /* @__PURE__ */ user_derived(() => nodeStrokeColorFunc(get$3(node)));
                    const expression_3 = /* @__PURE__ */ user_derived(() => nodeClassFunc(get$3(node)));
                    MinimapNode($$anchor5, spread_props(
                      {
                        get x() {
                          return get$3(node).internals.positionAbsolute.x;
                        },
                        get y() {
                          return get$3(node).internals.positionAbsolute.y;
                        }
                      },
                      () => get$3(nodeDimesions),
                      {
                        get selected() {
                          return get$3(node).selected;
                        },
                        get color() {
                          return get$3(expression_1);
                        },
                        get borderRadius() {
                          return nodeBorderRadius();
                        },
                        get strokeColor() {
                          return get$3(expression_2);
                        },
                        get strokeWidth() {
                          return nodeStrokeWidth();
                        },
                        get shapeRendering() {
                          return shapeRendering;
                        },
                        get class() {
                          return get$3(expression_3);
                        }
                      }
                    ));
                  };
                  if_block(node_5, ($$render) => {
                    if (get$3(node) && nodeHasDimensions(get$3(node))) $$render(consequent_1);
                  });
                }
                append($$anchor4, fragment_2);
              });
              var path = sibling(node_4);
              action(svg, ($$node, $$action_arg) => interactive == null ? void 0 : interactive($$node, $$action_arg), () => ({
                store: get$3(store),
                panZoom: get$3(store).panZoom,
                getViewScale,
                translateExtent: get$3(store).translateExtent,
                width: get$3(store).width,
                height: get$3(store).height,
                inversePan: $$props.inversePan,
                zoomStep: $$props.zoomStep,
                pannable: pannable(),
                zoomable: zoomable()
              }));
              template_effect(() => {
                var _a2, _b2, _c2, _d2, _e2, _f, _g, _h;
                set_attribute(svg, "width", width());
                set_attribute(svg, "height", height());
                set_attribute(svg, "viewBox", `${(_a2 = get$3(x)) != null ? _a2 : ""} ${(_b2 = get$3(y2)) != null ? _b2 : ""} ${(_c2 = get$3(viewboxWidth)) != null ? _c2 : ""} ${(_d2 = get$3(viewboxHeight)) != null ? _d2 : ""}`);
                set_attribute(svg, "aria-labelledby", get$3(labelledBy));
                styles = set_style(svg, "", styles, {
                  "--xy-minimap-mask-background-color-props": $$props.maskColor,
                  "--xy-minimap-mask-stroke-color-props": $$props.maskStrokeColor,
                  "--xy-minimap-mask-stroke-width-props": $$props.maskStrokeWidth ? $$props.maskStrokeWidth * get$3(viewScale) : void 0
                });
                set_attribute(path, "d", `M${get$3(x) - get$3(offset)},${get$3(y2) - get$3(offset)}h${get$3(viewboxWidth) + get$3(offset) * 2}v${get$3(viewboxHeight) + get$3(offset) * 2}h${-get$3(viewboxWidth) - get$3(offset) * 2}z
      M${(_e2 = get$3(viewBB).x) != null ? _e2 : ""},${(_f = get$3(viewBB).y) != null ? _f : ""}h${(_g = get$3(viewBB).width) != null ? _g : ""}v${(_h = get$3(viewBB).height) != null ? _h : ""}h${-get$3(viewBB).width}z`);
              });
              append($$anchor3, svg);
            };
            if_block(node_2, ($$render) => {
              if (get$3(store).panZoom) $$render(consequent_2);
            });
          }
          append($$anchor2, fragment_1);
        },
        $$slots: { default: true }
      }
    ));
  }
  append($$anchor, fragment);
  pop();
}
function useConnection() {
  const $$d = /* @__PURE__ */ user_derived(useStore), connection = /* @__PURE__ */ user_derived(() => get$3($$d).connection);
  return {
    get current() {
      return get$3(connection);
    }
  };
}
const matchIconName = /^[a-z0-9]+(-[a-z0-9]+)*$/;
const stringToIcon = (value, validate, allowSimpleName, provider = "") => {
  const colonSeparated = value.split(":");
  if (value.slice(0, 1) === "@") {
    if (colonSeparated.length < 2 || colonSeparated.length > 3) {
      return null;
    }
    provider = colonSeparated.shift().slice(1);
  }
  if (colonSeparated.length > 3 || !colonSeparated.length) {
    return null;
  }
  if (colonSeparated.length > 1) {
    const name2 = colonSeparated.pop();
    const prefix = colonSeparated.pop();
    const result = {
      // Allow provider without '@': "provider:prefix:name"
      provider: colonSeparated.length > 0 ? colonSeparated[0] : provider,
      prefix,
      name: name2
    };
    return validate && !validateIconName(result) ? null : result;
  }
  const name = colonSeparated[0];
  const dashSeparated = name.split("-");
  if (dashSeparated.length > 1) {
    const result = {
      provider,
      prefix: dashSeparated.shift(),
      name: dashSeparated.join("-")
    };
    return validate && !validateIconName(result) ? null : result;
  }
  if (allowSimpleName && provider === "") {
    const result = {
      provider,
      prefix: "",
      name
    };
    return validate && !validateIconName(result, allowSimpleName) ? null : result;
  }
  return null;
};
const validateIconName = (icon, allowSimpleName) => {
  if (!icon) {
    return false;
  }
  return !!// Check prefix: cannot be empty, unless allowSimpleName is enabled
  // Check name: cannot be empty
  ((allowSimpleName && icon.prefix === "" || !!icon.prefix) && !!icon.name);
};
const defaultIconDimensions = Object.freeze(
  {
    left: 0,
    top: 0,
    width: 16,
    height: 16
  }
);
const defaultIconTransformations = Object.freeze({
  rotate: 0,
  vFlip: false,
  hFlip: false
});
const defaultIconProps = Object.freeze(__spreadValues(__spreadValues({}, defaultIconDimensions), defaultIconTransformations));
const defaultExtendedIconProps = Object.freeze(__spreadProps(__spreadValues({}, defaultIconProps), {
  body: "",
  hidden: false
}));
function mergeIconTransformations(obj1, obj2) {
  const result = {};
  if (!obj1.hFlip !== !obj2.hFlip) {
    result.hFlip = true;
  }
  if (!obj1.vFlip !== !obj2.vFlip) {
    result.vFlip = true;
  }
  const rotate = ((obj1.rotate || 0) + (obj2.rotate || 0)) % 4;
  if (rotate) {
    result.rotate = rotate;
  }
  return result;
}
function mergeIconData(parent, child2) {
  const result = mergeIconTransformations(parent, child2);
  for (const key2 in defaultExtendedIconProps) {
    if (key2 in defaultIconTransformations) {
      if (key2 in parent && !(key2 in result)) {
        result[key2] = defaultIconTransformations[key2];
      }
    } else if (key2 in child2) {
      result[key2] = child2[key2];
    } else if (key2 in parent) {
      result[key2] = parent[key2];
    }
  }
  return result;
}
function getIconsTree(data, names) {
  const icons = data.icons;
  const aliases = data.aliases || /* @__PURE__ */ Object.create(null);
  const resolved = /* @__PURE__ */ Object.create(null);
  function resolve(name) {
    if (icons[name]) {
      return resolved[name] = [];
    }
    if (!(name in resolved)) {
      resolved[name] = null;
      const parent = aliases[name] && aliases[name].parent;
      const value = parent && resolve(parent);
      if (value) {
        resolved[name] = [parent].concat(value);
      }
    }
    return resolved[name];
  }
  Object.keys(icons).concat(Object.keys(aliases)).forEach(resolve);
  return resolved;
}
function internalGetIconData(data, name, tree) {
  const icons = data.icons;
  const aliases = data.aliases || /* @__PURE__ */ Object.create(null);
  let currentProps = {};
  function parse(name2) {
    currentProps = mergeIconData(
      icons[name2] || aliases[name2],
      currentProps
    );
  }
  parse(name);
  tree.forEach(parse);
  return mergeIconData(data, currentProps);
}
function parseIconSet(data, callback) {
  const names = [];
  if (typeof data !== "object" || typeof data.icons !== "object") {
    return names;
  }
  if (data.not_found instanceof Array) {
    data.not_found.forEach((name) => {
      callback(name, null);
      names.push(name);
    });
  }
  const tree = getIconsTree(data);
  for (const name in tree) {
    const item = tree[name];
    if (item) {
      callback(name, internalGetIconData(data, name, item));
      names.push(name);
    }
  }
  return names;
}
const optionalPropertyDefaults = __spreadValues({
  provider: "",
  aliases: {},
  not_found: {}
}, defaultIconDimensions);
function checkOptionalProps(item, defaults) {
  for (const prop2 in defaults) {
    if (prop2 in item && typeof item[prop2] !== typeof defaults[prop2]) {
      return false;
    }
  }
  return true;
}
function quicklyValidateIconSet(obj) {
  if (typeof obj !== "object" || obj === null) {
    return null;
  }
  const data = obj;
  if (typeof data.prefix !== "string" || !obj.icons || typeof obj.icons !== "object") {
    return null;
  }
  if (!checkOptionalProps(obj, optionalPropertyDefaults)) {
    return null;
  }
  const icons = data.icons;
  for (const name in icons) {
    const icon = icons[name];
    if (
      // Name cannot be empty
      !name || // Must have body
      typeof icon.body !== "string" || // Check other props
      !checkOptionalProps(
        icon,
        defaultExtendedIconProps
      )
    ) {
      return null;
    }
  }
  const aliases = data.aliases || /* @__PURE__ */ Object.create(null);
  for (const name in aliases) {
    const icon = aliases[name];
    const parent = icon.parent;
    if (
      // Name cannot be empty
      !name || // Parent must be set and point to existing icon
      typeof parent !== "string" || !icons[parent] && !aliases[parent] || // Check other props
      !checkOptionalProps(
        icon,
        defaultExtendedIconProps
      )
    ) {
      return null;
    }
  }
  return data;
}
const dataStorage = /* @__PURE__ */ Object.create(null);
function newStorage(provider, prefix) {
  return {
    provider,
    prefix,
    icons: /* @__PURE__ */ Object.create(null),
    missing: /* @__PURE__ */ new Set()
  };
}
function getStorage(provider, prefix) {
  const providerStorage = dataStorage[provider] || (dataStorage[provider] = /* @__PURE__ */ Object.create(null));
  return providerStorage[prefix] || (providerStorage[prefix] = newStorage(provider, prefix));
}
function addIconSet(storage2, data) {
  if (!quicklyValidateIconSet(data)) {
    return [];
  }
  return parseIconSet(data, (name, icon) => {
    if (icon) {
      storage2.icons[name] = icon;
    } else {
      storage2.missing.add(name);
    }
  });
}
function addIconToStorage(storage2, name, icon) {
  try {
    if (typeof icon.body === "string") {
      storage2.icons[name] = __spreadValues({}, icon);
      return true;
    }
  } catch (err) {
  }
  return false;
}
let simpleNames = false;
function allowSimpleNames(allow) {
  if (typeof allow === "boolean") {
    simpleNames = allow;
  }
  return simpleNames;
}
function getIconData(name) {
  const icon = typeof name === "string" ? stringToIcon(name, true, simpleNames) : name;
  if (icon) {
    const storage2 = getStorage(icon.provider, icon.prefix);
    const iconName = icon.name;
    return storage2.icons[iconName] || (storage2.missing.has(iconName) ? null : void 0);
  }
}
function addIcon(name, data) {
  const icon = stringToIcon(name, true, simpleNames);
  if (!icon) {
    return false;
  }
  const storage2 = getStorage(icon.provider, icon.prefix);
  if (data) {
    return addIconToStorage(storage2, icon.name, data);
  } else {
    storage2.missing.add(icon.name);
    return true;
  }
}
function addCollection(data, provider) {
  if (typeof data !== "object") {
    return false;
  }
  if (typeof provider !== "string") {
    provider = data.provider || "";
  }
  if (simpleNames && !provider && !data.prefix) {
    let added = false;
    if (quicklyValidateIconSet(data)) {
      data.prefix = "";
      parseIconSet(data, (name, icon) => {
        if (addIcon(name, icon)) {
          added = true;
        }
      });
    }
    return added;
  }
  const prefix = data.prefix;
  if (!validateIconName({
    prefix,
    name: "a"
  })) {
    return false;
  }
  const storage2 = getStorage(provider, prefix);
  return !!addIconSet(storage2, data);
}
const defaultIconSizeCustomisations = Object.freeze({
  width: null,
  height: null
});
const defaultIconCustomisations = Object.freeze(__spreadValues(__spreadValues({}, defaultIconSizeCustomisations), defaultIconTransformations));
const unitsSplit = /(-?[0-9.]*[0-9]+[0-9.]*)/g;
const unitsTest = /^-?[0-9.]*[0-9]+[0-9.]*$/g;
function calculateSize(size, ratio, precision) {
  if (ratio === 1) {
    return size;
  }
  precision = precision || 100;
  if (typeof size === "number") {
    return Math.ceil(size * ratio * precision) / precision;
  }
  if (typeof size !== "string") {
    return size;
  }
  const oldParts = size.split(unitsSplit);
  if (oldParts === null || !oldParts.length) {
    return size;
  }
  const newParts = [];
  let code = oldParts.shift();
  let isNumber = unitsTest.test(code);
  while (true) {
    if (isNumber) {
      const num = parseFloat(code);
      if (isNaN(num)) {
        newParts.push(code);
      } else {
        newParts.push(Math.ceil(num * ratio * precision) / precision);
      }
    } else {
      newParts.push(code);
    }
    code = oldParts.shift();
    if (code === void 0) {
      return newParts.join("");
    }
    isNumber = !isNumber;
  }
}
function splitSVGDefs(content, tag = "defs") {
  let defs = "";
  const index2 = content.indexOf("<" + tag);
  while (index2 >= 0) {
    const start2 = content.indexOf(">", index2);
    const end = content.indexOf("</" + tag);
    if (start2 === -1 || end === -1) {
      break;
    }
    const endEnd = content.indexOf(">", end);
    if (endEnd === -1) {
      break;
    }
    defs += content.slice(start2 + 1, end).trim();
    content = content.slice(0, index2).trim() + content.slice(endEnd + 1);
  }
  return {
    defs,
    content
  };
}
function mergeDefsAndContent(defs, content) {
  return defs ? "<defs>" + defs + "</defs>" + content : content;
}
function wrapSVGContent(body, start2, end) {
  const split = splitSVGDefs(body);
  return mergeDefsAndContent(split.defs, start2 + split.content + end);
}
const isUnsetKeyword = (value) => value === "unset" || value === "undefined" || value === "none";
function iconToSVG(icon, customisations) {
  const fullIcon = __spreadValues(__spreadValues({}, defaultIconProps), icon);
  const fullCustomisations = __spreadValues(__spreadValues({}, defaultIconCustomisations), customisations);
  const box = {
    left: fullIcon.left,
    top: fullIcon.top,
    width: fullIcon.width,
    height: fullIcon.height
  };
  let body = fullIcon.body;
  [fullIcon, fullCustomisations].forEach((props) => {
    const transformations = [];
    const hFlip = props.hFlip;
    const vFlip = props.vFlip;
    let rotation = props.rotate;
    if (hFlip) {
      if (vFlip) {
        rotation += 2;
      } else {
        transformations.push(
          "translate(" + (box.width + box.left).toString() + " " + (0 - box.top).toString() + ")"
        );
        transformations.push("scale(-1 1)");
        box.top = box.left = 0;
      }
    } else if (vFlip) {
      transformations.push(
        "translate(" + (0 - box.left).toString() + " " + (box.height + box.top).toString() + ")"
      );
      transformations.push("scale(1 -1)");
      box.top = box.left = 0;
    }
    let tempValue;
    if (rotation < 0) {
      rotation -= Math.floor(rotation / 4) * 4;
    }
    rotation = rotation % 4;
    switch (rotation) {
      case 1:
        tempValue = box.height / 2 + box.top;
        transformations.unshift(
          "rotate(90 " + tempValue.toString() + " " + tempValue.toString() + ")"
        );
        break;
      case 2:
        transformations.unshift(
          "rotate(180 " + (box.width / 2 + box.left).toString() + " " + (box.height / 2 + box.top).toString() + ")"
        );
        break;
      case 3:
        tempValue = box.width / 2 + box.left;
        transformations.unshift(
          "rotate(-90 " + tempValue.toString() + " " + tempValue.toString() + ")"
        );
        break;
    }
    if (rotation % 2 === 1) {
      if (box.left !== box.top) {
        tempValue = box.left;
        box.left = box.top;
        box.top = tempValue;
      }
      if (box.width !== box.height) {
        tempValue = box.width;
        box.width = box.height;
        box.height = tempValue;
      }
    }
    if (transformations.length) {
      body = wrapSVGContent(
        body,
        '<g transform="' + transformations.join(" ") + '">',
        "</g>"
      );
    }
  });
  const customisationsWidth = fullCustomisations.width;
  const customisationsHeight = fullCustomisations.height;
  const boxWidth = box.width;
  const boxHeight = box.height;
  let width;
  let height;
  if (customisationsWidth === null) {
    height = customisationsHeight === null ? "1em" : customisationsHeight === "auto" ? boxHeight : customisationsHeight;
    width = calculateSize(height, boxWidth / boxHeight);
  } else {
    width = customisationsWidth === "auto" ? boxWidth : customisationsWidth;
    height = customisationsHeight === null ? calculateSize(width, boxHeight / boxWidth) : customisationsHeight === "auto" ? boxHeight : customisationsHeight;
  }
  const attributes = {};
  const setAttr = (prop2, value) => {
    if (!isUnsetKeyword(value)) {
      attributes[prop2] = value.toString();
    }
  };
  setAttr("width", width);
  setAttr("height", height);
  const viewBox = [box.left, box.top, boxWidth, boxHeight];
  attributes.viewBox = viewBox.join(" ");
  return {
    attributes,
    viewBox,
    body
  };
}
const regex = /\sid="(\S+)"/g;
const randomPrefix = "IconifyId" + Date.now().toString(16) + (Math.random() * 16777216 | 0).toString(16);
let counter = 0;
function replaceIDs(body, prefix = randomPrefix) {
  const ids = [];
  let match;
  while (match = regex.exec(body)) {
    ids.push(match[1]);
  }
  if (!ids.length) {
    return body;
  }
  const suffix = "suffix" + (Math.random() * 16777216 | Date.now()).toString(16);
  ids.forEach((id2) => {
    const newID = typeof prefix === "function" ? prefix(id2) : prefix + (counter++).toString();
    const escapedID = id2.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
    body = body.replace(
      // Allowed characters before id: [#;"]
      // Allowed characters after id: [)"], .[a-z]
      new RegExp('([#;"])(' + escapedID + ')([")]|\\.[a-z])', "g"),
      "$1" + newID + suffix + "$3"
    );
  });
  body = body.replace(new RegExp(suffix, "g"), "");
  return body;
}
const storage = /* @__PURE__ */ Object.create(null);
function setAPIModule(provider, item) {
  storage[provider] = item;
}
function getAPIModule(provider) {
  return storage[provider] || storage[""];
}
function createAPIConfig(source2) {
  let resources;
  if (typeof source2.resources === "string") {
    resources = [source2.resources];
  } else {
    resources = source2.resources;
    if (!(resources instanceof Array) || !resources.length) {
      return null;
    }
  }
  const result = {
    // API hosts
    resources,
    // Root path
    path: source2.path || "/",
    // URL length limit
    maxURL: source2.maxURL || 500,
    // Timeout before next host is used.
    rotate: source2.rotate || 750,
    // Timeout before failing query.
    timeout: source2.timeout || 5e3,
    // Randomise default API end point.
    random: source2.random === true,
    // Start index
    index: source2.index || 0,
    // Receive data after time out (used if time out kicks in first, then API module sends data anyway).
    dataAfterTimeout: source2.dataAfterTimeout !== false
  };
  return result;
}
const configStorage = /* @__PURE__ */ Object.create(null);
const fallBackAPISources = [
  "https://api.simplesvg.com",
  "https://api.unisvg.com"
];
const fallBackAPI = [];
while (fallBackAPISources.length > 0) {
  if (fallBackAPISources.length === 1) {
    fallBackAPI.push(fallBackAPISources.shift());
  } else {
    if (Math.random() > 0.5) {
      fallBackAPI.push(fallBackAPISources.shift());
    } else {
      fallBackAPI.push(fallBackAPISources.pop());
    }
  }
}
configStorage[""] = createAPIConfig({
  resources: ["https://api.iconify.design"].concat(fallBackAPI)
});
function addAPIProvider(provider, customConfig) {
  const config = createAPIConfig(customConfig);
  if (config === null) {
    return false;
  }
  configStorage[provider] = config;
  return true;
}
function getAPIConfig(provider) {
  return configStorage[provider];
}
const detectFetch = () => {
  let callback;
  try {
    callback = fetch;
    if (typeof callback === "function") {
      return callback;
    }
  } catch (err) {
  }
};
let fetchModule = detectFetch();
function calculateMaxLength(provider, prefix) {
  const config = getAPIConfig(provider);
  if (!config) {
    return 0;
  }
  let result;
  if (!config.maxURL) {
    result = 0;
  } else {
    let maxHostLength = 0;
    config.resources.forEach((item) => {
      const host = item;
      maxHostLength = Math.max(maxHostLength, host.length);
    });
    const url = prefix + ".json?icons=";
    result = config.maxURL - maxHostLength - config.path.length - url.length;
  }
  return result;
}
function shouldAbort(status) {
  return status === 404;
}
const prepare = (provider, prefix, icons) => {
  const results = [];
  const maxLength = calculateMaxLength(provider, prefix);
  const type = "icons";
  let item = {
    type,
    provider,
    prefix,
    icons: []
  };
  let length = 0;
  icons.forEach((name, index2) => {
    length += name.length + 1;
    if (length >= maxLength && index2 > 0) {
      results.push(item);
      item = {
        type,
        provider,
        prefix,
        icons: []
      };
      length = name.length;
    }
    item.icons.push(name);
  });
  results.push(item);
  return results;
};
function getPath(provider) {
  if (typeof provider === "string") {
    const config = getAPIConfig(provider);
    if (config) {
      return config.path;
    }
  }
  return "/";
}
const send = (host, params, callback) => {
  if (!fetchModule) {
    callback("abort", 424);
    return;
  }
  let path = getPath(params.provider);
  switch (params.type) {
    case "icons": {
      const prefix = params.prefix;
      const icons = params.icons;
      const iconsList = icons.join(",");
      const urlParams = new URLSearchParams({
        icons: iconsList
      });
      path += prefix + ".json?" + urlParams.toString();
      break;
    }
    case "custom": {
      const uri = params.uri;
      path += uri.slice(0, 1) === "/" ? uri.slice(1) : uri;
      break;
    }
    default:
      callback("abort", 400);
      return;
  }
  let defaultError = 503;
  fetchModule(host + path).then((response) => {
    const status = response.status;
    if (status !== 200) {
      setTimeout(() => {
        callback(shouldAbort(status) ? "abort" : "next", status);
      });
      return;
    }
    defaultError = 501;
    return response.json();
  }).then((data) => {
    if (typeof data !== "object" || data === null) {
      setTimeout(() => {
        if (data === 404) {
          callback("abort", data);
        } else {
          callback("next", defaultError);
        }
      });
      return;
    }
    setTimeout(() => {
      callback("success", data);
    });
  }).catch(() => {
    callback("next", defaultError);
  });
};
const fetchAPIModule = {
  prepare,
  send
};
function sortIcons(icons) {
  const result = {
    loaded: [],
    missing: [],
    pending: []
  };
  const storage2 = /* @__PURE__ */ Object.create(null);
  icons.sort((a, b2) => {
    if (a.provider !== b2.provider) {
      return a.provider.localeCompare(b2.provider);
    }
    if (a.prefix !== b2.prefix) {
      return a.prefix.localeCompare(b2.prefix);
    }
    return a.name.localeCompare(b2.name);
  });
  let lastIcon = {
    provider: "",
    prefix: "",
    name: ""
  };
  icons.forEach((icon) => {
    if (lastIcon.name === icon.name && lastIcon.prefix === icon.prefix && lastIcon.provider === icon.provider) {
      return;
    }
    lastIcon = icon;
    const provider = icon.provider;
    const prefix = icon.prefix;
    const name = icon.name;
    const providerStorage = storage2[provider] || (storage2[provider] = /* @__PURE__ */ Object.create(null));
    const localStorage = providerStorage[prefix] || (providerStorage[prefix] = getStorage(provider, prefix));
    let list;
    if (name in localStorage.icons) {
      list = result.loaded;
    } else if (prefix === "" || localStorage.missing.has(name)) {
      list = result.missing;
    } else {
      list = result.pending;
    }
    const item = {
      provider,
      prefix,
      name
    };
    list.push(item);
  });
  return result;
}
function removeCallback(storages, id2) {
  storages.forEach((storage2) => {
    const items = storage2.loaderCallbacks;
    if (items) {
      storage2.loaderCallbacks = items.filter((row) => row.id !== id2);
    }
  });
}
function updateCallbacks(storage2) {
  if (!storage2.pendingCallbacksFlag) {
    storage2.pendingCallbacksFlag = true;
    setTimeout(() => {
      storage2.pendingCallbacksFlag = false;
      const items = storage2.loaderCallbacks ? storage2.loaderCallbacks.slice(0) : [];
      if (!items.length) {
        return;
      }
      let hasPending = false;
      const provider = storage2.provider;
      const prefix = storage2.prefix;
      items.forEach((item) => {
        const icons = item.icons;
        const oldLength = icons.pending.length;
        icons.pending = icons.pending.filter((icon) => {
          if (icon.prefix !== prefix) {
            return true;
          }
          const name = icon.name;
          if (storage2.icons[name]) {
            icons.loaded.push({
              provider,
              prefix,
              name
            });
          } else if (storage2.missing.has(name)) {
            icons.missing.push({
              provider,
              prefix,
              name
            });
          } else {
            hasPending = true;
            return true;
          }
          return false;
        });
        if (icons.pending.length !== oldLength) {
          if (!hasPending) {
            removeCallback([storage2], item.id);
          }
          item.callback(
            icons.loaded.slice(0),
            icons.missing.slice(0),
            icons.pending.slice(0),
            item.abort
          );
        }
      });
    });
  }
}
let idCounter = 0;
function storeCallback(callback, icons, pendingSources) {
  const id2 = idCounter++;
  const abort = removeCallback.bind(null, pendingSources, id2);
  if (!icons.pending.length) {
    return abort;
  }
  const item = {
    id: id2,
    icons,
    callback,
    abort
  };
  pendingSources.forEach((storage2) => {
    (storage2.loaderCallbacks || (storage2.loaderCallbacks = [])).push(item);
  });
  return abort;
}
function listToIcons(list, validate = true, simpleNames2 = false) {
  const result = [];
  list.forEach((item) => {
    const icon = typeof item === "string" ? stringToIcon(item, validate, simpleNames2) : item;
    if (icon) {
      result.push(icon);
    }
  });
  return result;
}
var defaultConfig = {
  resources: [],
  index: 0,
  timeout: 2e3,
  rotate: 750,
  random: false,
  dataAfterTimeout: false
};
function sendQuery(config, payload, query, done) {
  const resourcesCount = config.resources.length;
  const startIndex = config.random ? Math.floor(Math.random() * resourcesCount) : config.index;
  let resources;
  if (config.random) {
    let list = config.resources.slice(0);
    resources = [];
    while (list.length > 1) {
      const nextIndex = Math.floor(Math.random() * list.length);
      resources.push(list[nextIndex]);
      list = list.slice(0, nextIndex).concat(list.slice(nextIndex + 1));
    }
    resources = resources.concat(list);
  } else {
    resources = config.resources.slice(startIndex).concat(config.resources.slice(0, startIndex));
  }
  const startTime = Date.now();
  let status = "pending";
  let queriesSent = 0;
  let lastError;
  let timer2 = null;
  let queue = [];
  let doneCallbacks = [];
  if (typeof done === "function") {
    doneCallbacks.push(done);
  }
  function resetTimer() {
    if (timer2) {
      clearTimeout(timer2);
      timer2 = null;
    }
  }
  function abort() {
    if (status === "pending") {
      status = "aborted";
    }
    resetTimer();
    queue.forEach((item) => {
      if (item.status === "pending") {
        item.status = "aborted";
      }
    });
    queue = [];
  }
  function subscribe(callback, overwrite) {
    if (overwrite) {
      doneCallbacks = [];
    }
    if (typeof callback === "function") {
      doneCallbacks.push(callback);
    }
  }
  function getQueryStatus() {
    return {
      startTime,
      payload,
      status,
      queriesSent,
      queriesPending: queue.length,
      subscribe,
      abort
    };
  }
  function failQuery() {
    status = "failed";
    doneCallbacks.forEach((callback) => {
      callback(void 0, lastError);
    });
  }
  function clearQueue() {
    queue.forEach((item) => {
      if (item.status === "pending") {
        item.status = "aborted";
      }
    });
    queue = [];
  }
  function moduleResponse(item, response, data) {
    const isError = response !== "success";
    queue = queue.filter((queued) => queued !== item);
    switch (status) {
      case "pending":
        break;
      case "failed":
        if (isError || !config.dataAfterTimeout) {
          return;
        }
        break;
      default:
        return;
    }
    if (response === "abort") {
      lastError = data;
      failQuery();
      return;
    }
    if (isError) {
      lastError = data;
      if (!queue.length) {
        if (!resources.length) {
          failQuery();
        } else {
          execNext();
        }
      }
      return;
    }
    resetTimer();
    clearQueue();
    if (!config.random) {
      const index2 = config.resources.indexOf(item.resource);
      if (index2 !== -1 && index2 !== config.index) {
        config.index = index2;
      }
    }
    status = "completed";
    doneCallbacks.forEach((callback) => {
      callback(data);
    });
  }
  function execNext() {
    if (status !== "pending") {
      return;
    }
    resetTimer();
    const resource = resources.shift();
    if (resource === void 0) {
      if (queue.length) {
        timer2 = setTimeout(() => {
          resetTimer();
          if (status === "pending") {
            clearQueue();
            failQuery();
          }
        }, config.timeout);
        return;
      }
      failQuery();
      return;
    }
    const item = {
      status: "pending",
      resource,
      callback: (status2, data) => {
        moduleResponse(item, status2, data);
      }
    };
    queue.push(item);
    queriesSent++;
    timer2 = setTimeout(execNext, config.rotate);
    query(resource, payload, item.callback);
  }
  setTimeout(execNext);
  return getQueryStatus;
}
function initRedundancy(cfg) {
  const config = __spreadValues(__spreadValues({}, defaultConfig), cfg);
  let queries = [];
  function cleanup() {
    queries = queries.filter((item) => item().status === "pending");
  }
  function query(payload, queryCallback, doneCallback) {
    const query2 = sendQuery(
      config,
      payload,
      queryCallback,
      (data, error) => {
        cleanup();
        if (doneCallback) {
          doneCallback(data, error);
        }
      }
    );
    queries.push(query2);
    return query2;
  }
  function find2(callback) {
    return queries.find((value) => {
      return callback(value);
    }) || null;
  }
  const instance = {
    query,
    find: find2,
    setIndex: (index2) => {
      config.index = index2;
    },
    getIndex: () => config.index,
    cleanup
  };
  return instance;
}
function emptyCallback$1() {
}
const redundancyCache = /* @__PURE__ */ Object.create(null);
function getRedundancyCache(provider) {
  if (!redundancyCache[provider]) {
    const config = getAPIConfig(provider);
    if (!config) {
      return;
    }
    const redundancy = initRedundancy(config);
    const cachedReundancy = {
      config,
      redundancy
    };
    redundancyCache[provider] = cachedReundancy;
  }
  return redundancyCache[provider];
}
function sendAPIQuery(target, query, callback) {
  let redundancy;
  let send2;
  if (typeof target === "string") {
    const api2 = getAPIModule(target);
    if (!api2) {
      callback(void 0, 424);
      return emptyCallback$1;
    }
    send2 = api2.send;
    const cached = getRedundancyCache(target);
    if (cached) {
      redundancy = cached.redundancy;
    }
  } else {
    const config = createAPIConfig(target);
    if (config) {
      redundancy = initRedundancy(config);
      const moduleKey = target.resources ? target.resources[0] : "";
      const api2 = getAPIModule(moduleKey);
      if (api2) {
        send2 = api2.send;
      }
    }
  }
  if (!redundancy || !send2) {
    callback(void 0, 424);
    return emptyCallback$1;
  }
  return redundancy.query(query, send2, callback)().abort;
}
function emptyCallback() {
}
function loadedNewIcons(storage2) {
  if (!storage2.iconsLoaderFlag) {
    storage2.iconsLoaderFlag = true;
    setTimeout(() => {
      storage2.iconsLoaderFlag = false;
      updateCallbacks(storage2);
    });
  }
}
function checkIconNamesForAPI(icons) {
  const valid = [];
  const invalid = [];
  icons.forEach((name) => {
    (name.match(matchIconName) ? valid : invalid).push(name);
  });
  return {
    valid,
    invalid
  };
}
function parseLoaderResponse(storage2, icons, data) {
  function checkMissing() {
    const pending = storage2.pendingIcons;
    icons.forEach((name) => {
      if (pending) {
        pending.delete(name);
      }
      if (!storage2.icons[name]) {
        storage2.missing.add(name);
      }
    });
  }
  if (data && typeof data === "object") {
    try {
      const parsed = addIconSet(storage2, data);
      if (!parsed.length) {
        checkMissing();
        return;
      }
    } catch (err) {
      console.error(err);
    }
  }
  checkMissing();
  loadedNewIcons(storage2);
}
function parsePossiblyAsyncResponse(response, callback) {
  if (response instanceof Promise) {
    response.then((data) => {
      callback(data);
    }).catch(() => {
      callback(null);
    });
  } else {
    callback(response);
  }
}
function loadNewIcons(storage2, icons) {
  if (!storage2.iconsToLoad) {
    storage2.iconsToLoad = icons;
  } else {
    storage2.iconsToLoad = storage2.iconsToLoad.concat(icons).sort();
  }
  if (!storage2.iconsQueueFlag) {
    storage2.iconsQueueFlag = true;
    setTimeout(() => {
      storage2.iconsQueueFlag = false;
      const { provider, prefix } = storage2;
      const icons2 = storage2.iconsToLoad;
      delete storage2.iconsToLoad;
      if (!icons2 || !icons2.length) {
        return;
      }
      const customIconLoader = storage2.loadIcon;
      if (storage2.loadIcons && (icons2.length > 1 || !customIconLoader)) {
        parsePossiblyAsyncResponse(
          storage2.loadIcons(icons2, prefix, provider),
          (data) => {
            parseLoaderResponse(storage2, icons2, data);
          }
        );
        return;
      }
      if (customIconLoader) {
        icons2.forEach((name) => {
          const response = customIconLoader(name, prefix, provider);
          parsePossiblyAsyncResponse(response, (data) => {
            const iconSet = data ? {
              prefix,
              icons: {
                [name]: data
              }
            } : null;
            parseLoaderResponse(storage2, [name], iconSet);
          });
        });
        return;
      }
      const { valid, invalid } = checkIconNamesForAPI(icons2);
      if (invalid.length) {
        parseLoaderResponse(storage2, invalid, null);
      }
      if (!valid.length) {
        return;
      }
      const api2 = prefix.match(matchIconName) ? getAPIModule(provider) : null;
      if (!api2) {
        parseLoaderResponse(storage2, valid, null);
        return;
      }
      const params = api2.prepare(provider, prefix, valid);
      params.forEach((item) => {
        sendAPIQuery(provider, item, (data) => {
          parseLoaderResponse(storage2, item.icons, data);
        });
      });
    });
  }
}
const loadIcons = (icons, callback) => {
  const cleanedIcons = listToIcons(icons, true, allowSimpleNames());
  const sortedIcons = sortIcons(cleanedIcons);
  if (!sortedIcons.pending.length) {
    let callCallback = true;
    if (callback) {
      setTimeout(() => {
        if (callCallback) {
          callback(
            sortedIcons.loaded,
            sortedIcons.missing,
            sortedIcons.pending,
            emptyCallback
          );
        }
      });
    }
    return () => {
      callCallback = false;
    };
  }
  const newIcons = /* @__PURE__ */ Object.create(null);
  const sources = [];
  let lastProvider, lastPrefix;
  sortedIcons.pending.forEach((icon) => {
    const { provider, prefix } = icon;
    if (prefix === lastPrefix && provider === lastProvider) {
      return;
    }
    lastProvider = provider;
    lastPrefix = prefix;
    sources.push(getStorage(provider, prefix));
    const providerNewIcons = newIcons[provider] || (newIcons[provider] = /* @__PURE__ */ Object.create(null));
    if (!providerNewIcons[prefix]) {
      providerNewIcons[prefix] = [];
    }
  });
  sortedIcons.pending.forEach((icon) => {
    const { provider, prefix, name } = icon;
    const storage2 = getStorage(provider, prefix);
    const pendingQueue = storage2.pendingIcons || (storage2.pendingIcons = /* @__PURE__ */ new Set());
    if (!pendingQueue.has(name)) {
      pendingQueue.add(name);
      newIcons[provider][prefix].push(name);
    }
  });
  sources.forEach((storage2) => {
    const list = newIcons[storage2.provider][storage2.prefix];
    if (list.length) {
      loadNewIcons(storage2, list);
    }
  });
  return callback ? storeCallback(callback, sortedIcons, sources) : emptyCallback;
};
function mergeCustomisations(defaults, item) {
  const result = __spreadValues({}, defaults);
  for (const key2 in item) {
    const value = item[key2];
    const valueType = typeof value;
    if (key2 in defaultIconSizeCustomisations) {
      if (value === null || value && (valueType === "string" || valueType === "number")) {
        result[key2] = value;
      }
    } else if (valueType === typeof result[key2]) {
      result[key2] = key2 === "rotate" ? value % 4 : value;
    }
  }
  return result;
}
const separator = /[\s,]+/;
function flipFromString(custom, flip) {
  flip.split(separator).forEach((str) => {
    const value = str.trim();
    switch (value) {
      case "horizontal":
        custom.hFlip = true;
        break;
      case "vertical":
        custom.vFlip = true;
        break;
    }
  });
}
function rotateFromString(value, defaultValue = 0) {
  const units = value.replace(/^-?[0-9.]*/, "");
  function cleanup(value2) {
    while (value2 < 0) {
      value2 += 4;
    }
    return value2 % 4;
  }
  if (units === "") {
    const num = parseInt(value);
    return isNaN(num) ? 0 : cleanup(num);
  } else if (units !== value) {
    let split = 0;
    switch (units) {
      case "%":
        split = 25;
        break;
      case "deg":
        split = 90;
    }
    if (split) {
      let num = parseFloat(value.slice(0, value.length - units.length));
      if (isNaN(num)) {
        return 0;
      }
      num = num / split;
      return num % 1 === 0 ? cleanup(num) : 0;
    }
  }
  return defaultValue;
}
function iconToHTML(body, attributes) {
  let renderAttribsHTML = body.indexOf("xlink:") === -1 ? "" : ' xmlns:xlink="http://www.w3.org/1999/xlink"';
  for (const attr in attributes) {
    renderAttribsHTML += " " + attr + '="' + attributes[attr] + '"';
  }
  return '<svg xmlns="http://www.w3.org/2000/svg"' + renderAttribsHTML + ">" + body + "</svg>";
}
function encodeSVGforURL(svg) {
  return svg.replace(/"/g, "'").replace(/%/g, "%25").replace(/#/g, "%23").replace(/</g, "%3C").replace(/>/g, "%3E").replace(/\s+/g, " ");
}
function svgToData(svg) {
  return "data:image/svg+xml," + encodeSVGforURL(svg);
}
function svgToURL(svg) {
  return 'url("' + svgToData(svg) + '")';
}
const defaultExtendedIconCustomisations = __spreadProps(__spreadValues({}, defaultIconCustomisations), {
  inline: false
});
const svgDefaults = {
  "xmlns": "http://www.w3.org/2000/svg",
  "xmlns:xlink": "http://www.w3.org/1999/xlink",
  "aria-hidden": true,
  "role": "img"
};
const commonProps = {
  display: "inline-block"
};
const monotoneProps = {
  "background-color": "currentColor"
};
const coloredProps = {
  "background-color": "transparent"
};
const propsToAdd = {
  image: "var(--svg)",
  repeat: "no-repeat",
  size: "100% 100%"
};
const propsToAddTo = {
  "-webkit-mask": monotoneProps,
  "mask": monotoneProps,
  "background": coloredProps
};
for (const prefix in propsToAddTo) {
  const list = propsToAddTo[prefix];
  for (const prop2 in propsToAdd) {
    list[prefix + "-" + prop2] = propsToAdd[prop2];
  }
}
function fixSize(value) {
  return value + (value.match(/^[-0-9.]+$/) ? "px" : "");
}
function render(icon, props) {
  const customisations = mergeCustomisations(defaultExtendedIconCustomisations, props);
  const mode = props.mode || "svg";
  const componentProps = mode === "svg" ? __spreadValues({}, svgDefaults) : {};
  if (icon.body.indexOf("xlink:") === -1) {
    delete componentProps["xmlns:xlink"];
  }
  let style = typeof props.style === "string" ? props.style : "";
  for (let key2 in props) {
    const value = props[key2];
    if (value === void 0) {
      continue;
    }
    switch (key2) {
      // Properties to ignore
      case "icon":
      case "style":
      case "onLoad":
      case "mode":
      case "ssr":
        break;
      // Boolean attributes
      case "inline":
      case "hFlip":
      case "vFlip":
        customisations[key2] = value === true || value === "true" || value === 1;
        break;
      // Flip as string: 'horizontal,vertical'
      case "flip":
        if (typeof value === "string") {
          flipFromString(customisations, value);
        }
        break;
      // Color: copy to style, add extra ';' in case style is missing it
      case "color":
        style = style + (style.length > 0 && style.trim().slice(-1) !== ";" ? ";" : "") + "color: " + value + "; ";
        break;
      // Rotation as string
      case "rotate":
        if (typeof value === "string") {
          customisations[key2] = rotateFromString(value);
        } else if (typeof value === "number") {
          customisations[key2] = value;
        }
        break;
      // Remove aria-hidden
      case "ariaHidden":
      case "aria-hidden":
        if (value !== true && value !== "true") {
          delete componentProps["aria-hidden"];
        }
        break;
      default:
        if (key2.slice(0, 3) === "on:") {
          break;
        }
        if (defaultExtendedIconCustomisations[key2] === void 0) {
          componentProps[key2] = value;
        }
    }
  }
  const item = iconToSVG(icon, customisations);
  const renderAttribs = item.attributes;
  if (customisations.inline) {
    style = "vertical-align: -0.125em; " + style;
  }
  if (mode === "svg") {
    Object.assign(componentProps, renderAttribs);
    if (style !== "") {
      componentProps.style = style;
    }
    let localCounter = 0;
    let id2 = props.id;
    if (typeof id2 === "string") {
      id2 = id2.replace(/-/g, "_");
    }
    return {
      svg: true,
      attributes: componentProps,
      body: replaceIDs(item.body, id2 ? () => id2 + "ID" + localCounter++ : "iconifySvelte")
    };
  }
  const { body, width, height } = icon;
  const useMask = mode === "mask" || (mode === "bg" ? false : body.indexOf("currentColor") !== -1);
  const html2 = iconToHTML(body, __spreadProps(__spreadValues({}, renderAttribs), {
    width: width + "",
    height: height + ""
  }));
  const url = svgToURL(html2);
  const styles = {
    "--svg": url
  };
  const size = (prop2) => {
    const value = renderAttribs[prop2];
    if (value) {
      styles[prop2] = fixSize(value);
    }
  };
  size("width");
  size("height");
  Object.assign(styles, commonProps, useMask ? monotoneProps : coloredProps);
  let customStyle = "";
  for (const key2 in styles) {
    customStyle += key2 + ": " + styles[key2] + ";";
  }
  componentProps.style = customStyle + style;
  return {
    svg: false,
    attributes: componentProps
  };
}
allowSimpleNames(true);
setAPIModule("", fetchAPIModule);
if (typeof document !== "undefined" && typeof window !== "undefined") {
  const _window = window;
  if (_window.IconifyPreload !== void 0) {
    const preload = _window.IconifyPreload;
    const err = "Invalid IconifyPreload syntax.";
    if (typeof preload === "object" && preload !== null) {
      (preload instanceof Array ? preload : [preload]).forEach((item) => {
        try {
          if (
            // Check if item is an object and not null/array
            typeof item !== "object" || item === null || item instanceof Array || // Check for 'icons' and 'prefix'
            typeof item.icons !== "object" || typeof item.prefix !== "string" || // Add icon set
            !addCollection(item)
          ) {
            console.error(err);
          }
        } catch (e) {
          console.error(err);
        }
      });
    }
  }
  if (_window.IconifyProviders !== void 0) {
    const providers = _window.IconifyProviders;
    if (typeof providers === "object" && providers !== null) {
      for (let key2 in providers) {
        const err = "IconifyProviders[" + key2 + "] is invalid.";
        try {
          const value = providers[key2];
          if (typeof value !== "object" || !value || value.resources === void 0) {
            continue;
          }
          if (!addAPIProvider(key2, value)) {
            console.error(err);
          }
        } catch (e) {
          console.error(err);
        }
      }
    }
  }
}
function checkIconState(icon, state2, mounted, callback, onload) {
  function abortLoading() {
    if (state2.loading) {
      state2.loading.abort();
      state2.loading = null;
    }
  }
  if (typeof icon === "object" && icon !== null && typeof icon.body === "string") {
    state2.name = "";
    abortLoading();
    return { data: __spreadValues(__spreadValues({}, defaultIconProps), icon) };
  }
  let iconName;
  if (typeof icon !== "string" || (iconName = stringToIcon(icon, false, true)) === null) {
    abortLoading();
    return null;
  }
  const data = getIconData(iconName);
  if (!data) {
    if (mounted && (!state2.loading || state2.loading.name !== icon)) {
      abortLoading();
      state2.name = "";
      state2.loading = {
        name: icon,
        abort: loadIcons([iconName], callback)
      };
    }
    return null;
  }
  abortLoading();
  if (state2.name !== icon) {
    state2.name = icon;
    if (onload && !state2.destroyed) {
      onload(icon);
    }
  }
  const classes = ["iconify"];
  if (iconName.prefix !== "") {
    classes.push("iconify--" + iconName.prefix);
  }
  if (iconName.provider !== "") {
    classes.push("iconify--" + iconName.provider);
  }
  return { data, classes };
}
function generateIcon(icon, props) {
  return icon ? render(__spreadValues(__spreadValues({}, defaultIconProps), icon), props) : null;
}
var root_2$6 = /* @__PURE__ */ from_svg(`<svg><!></svg>`);
var root_3$9 = /* @__PURE__ */ from_html(`<span></span>`);
function Icon($$anchor, $$props) {
  push($$props, true);
  const iconState = {
    // Last icon name
    name: "",
    // Loading status
    loading: null,
    // Destroyed status
    destroyed: false
  };
  const props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]);
  let mounted = /* @__PURE__ */ state(false);
  let counter2 = /* @__PURE__ */ state(0);
  let data = /* @__PURE__ */ state(null);
  user_effect(() => {
    get$3(counter2);
    const isMounted = !!$$props.ssr || get$3(mounted);
    const iconData = checkIconState($$props.icon, iconState, isMounted, loaded, $$props.onload);
    const generatedData = iconData ? generateIcon(iconData.data, props) : null;
    if (generatedData && iconData.classes) {
      generatedData.attributes["class"] = (typeof props["class"] === "string" ? props["class"] + " " : "") + iconData.classes.join(" ");
    }
    set$2(data, generatedData, true);
  });
  function loaded() {
    update(counter2);
  }
  onMount(() => {
    set$2(mounted, true);
  });
  onDestroy(() => {
    iconState.destroyed = true;
    if (iconState.loading) {
      iconState.loading.abort();
      iconState.loading = null;
    }
  });
  var fragment = comment();
  var node = first_child(fragment);
  {
    var consequent_1 = ($$anchor2) => {
      var fragment_1 = comment();
      var node_1 = first_child(fragment_1);
      {
        var consequent = ($$anchor3) => {
          var svg = root_2$6();
          attribute_effect(svg, () => __spreadValues({}, get$3(data).attributes));
          var node_2 = child(svg);
          html(node_2, () => get$3(data).body, true);
          append($$anchor3, svg);
        };
        var alternate = ($$anchor3) => {
          var span = root_3$9();
          attribute_effect(span, () => __spreadValues({}, get$3(data).attributes));
          append($$anchor3, span);
        };
        if_block(node_1, ($$render) => {
          if (get$3(data).svg) $$render(consequent);
          else $$render(alternate, false);
        });
      }
      append($$anchor2, fragment_1);
    };
    if_block(node, ($$render) => {
      if (get$3(data)) $$render(consequent_1);
    });
  }
  append($$anchor, fragment);
  pop();
}
const DEFAULT_ICONS = {
  // Node fallback icons
  NODE: "mdi:cube",
  CATEGORY: "mdi:folder",
  // UI action icons
  ADD: "mdi:plus",
  REMOVE: "mdi:minus",
  EDIT: "mdi:pencil",
  SAVE: "mdi:content-save",
  LOAD: "mdi:folder-open",
  EXPORT: "mdi:download",
  IMPORT: "mdi:upload",
  SEARCH: "mdi:magnify",
  CLOSE: "mdi:close",
  SETTINGS: "mdi:cog",
  HELP: "mdi:help-circle",
  // Status icons
  SUCCESS: "mdi:check-circle",
  ERROR: "mdi:alert-circle",
  WARNING: "mdi:alert",
  INFO: "mdi:information",
  LOADING: "mdi:loading",
  // Navigation icons
  HOME: "mdi:home",
  BACK: "mdi:arrow-left",
  FORWARD: "mdi:arrow-right",
  UP: "mdi:arrow-up",
  DOWN: "mdi:arrow-down",
  // Workflow icons
  WORKFLOW: "mdi:graph",
  NODE_ADD: "mdi:plus-circle",
  NODE_DELETE: "mdi:minus-circle",
  CONNECTION: "mdi:connection",
  // Data icons
  DATA: "mdi:database",
  FILE: "mdi:file",
  TEXT: "mdi:text",
  JSON: "mdi:code-json",
  // Model and processing icons
  MODEL: "mdi:chip",
  BRAIN: "mdi:brain",
  VECTOR: "mdi:vector-point",
  ROBOT: "mdi:robot",
  // Tool icons
  TOOL: "mdi:wrench",
  CALCULATOR: "mdi:calculator",
  CLOCK: "mdi:clock",
  // Communication icons
  CHAT: "mdi:chat",
  MESSAGE: "mdi:message",
  EMAIL: "mdi:email",
  WEBHOOK: "mdi:webhook",
  // Storage icons
  STORAGE: "mdi:database",
  MEMORY: "mdi:memory",
  CACHE: "mdi:cached",
  // Processing icons
  PROCESS: "mdi:cog",
  FILTER: "mdi:filter",
  SORT: "mdi:sort",
  TRANSFORM: "mdi:transform",
  // Logic icons
  LOGIC: "mdi:git-branch",
  CONDITION: "mdi:source-fork",
  LOOP: "mdi:loop",
  // Integration icons
  API: "mdi:api",
  LINK: "mdi:link",
  PLUGIN: "mdi:puzzle",
  BUNDLE: "mdi:package-variant"
};
const CATEGORY_ICONS = {
  inputs: "mdi:arrow-down-circle",
  outputs: "mdi:arrow-up-circle",
  prompts: "mdi:message-text",
  models: "mdi:robot",
  processing: "mdi:cog",
  logic: "mdi:git-branch",
  data: "mdi:database",
  helpers: "mdi:help-circle",
  tools: "mdi:wrench",
  "vector stores": "mdi:vector-square",
  embeddings: "mdi:vector-point",
  memories: "mdi:brain",
  agents: "mdi:account-cog",
  bundles: "mdi:package-variant"
};
function getNodeIcon(nodeIcon, category) {
  if (nodeIcon) {
    return nodeIcon;
  }
  if (category && CATEGORY_ICONS[category]) {
    return CATEGORY_ICONS[category];
  }
  return DEFAULT_ICONS.NODE;
}
function getCategoryIcon(category) {
  return CATEGORY_ICONS[category] || DEFAULT_ICONS.CATEGORY;
}
function getDefaultIcon(key2) {
  return DEFAULT_ICONS[key2];
}
function isValidIcon(icon) {
  return /^[a-z-]+:[a-z-]+$/.test(icon);
}
function getValidIcon(icon, fallback2 = DEFAULT_ICONS.NODE) {
  return isValidIcon(icon) ? icon : fallback2;
}
class PortCompatibilityChecker {
  constructor(portConfig) {
    __publicField(this, "portConfig");
    __publicField(this, "compatibilityMap");
    this.portConfig = portConfig;
    this.compatibilityMap = /* @__PURE__ */ new Map();
    this.buildCompatibilityMap();
  }
  /**
   * Build the compatibility map from configuration rules
   */
  buildCompatibilityMap() {
    this.compatibilityMap.clear();
    for (const dataType of this.portConfig.dataTypes) {
      if (!this.compatibilityMap.has(dataType.id)) {
        this.compatibilityMap.set(dataType.id, /* @__PURE__ */ new Set());
      }
      this.compatibilityMap.get(dataType.id).add(dataType.id);
    }
    for (const rule of this.portConfig.compatibilityRules) {
      if (!this.compatibilityMap.has(rule.from)) {
        this.compatibilityMap.set(rule.from, /* @__PURE__ */ new Set());
      }
      this.compatibilityMap.get(rule.from).add(rule.to);
    }
    for (const dataType of this.portConfig.dataTypes) {
      if (dataType.aliases) {
        for (const alias of dataType.aliases) {
          const mainCompatibility = this.compatibilityMap.get(dataType.id);
          if (mainCompatibility) {
            this.compatibilityMap.set(alias, new Set(mainCompatibility));
            mainCompatibility.add(alias);
          }
        }
      }
    }
  }
  /**
   * Check if two data types are compatible for connection
   */
  areDataTypesCompatible(outputType, inputType) {
    const compatibleTypes = this.compatibilityMap.get(outputType);
    return compatibleTypes ? compatibleTypes.has(inputType) : false;
  }
  /**
   * Get all compatible target types for a source type
   */
  getCompatibleTypes(sourceType) {
    const compatibleTypes = this.compatibilityMap.get(sourceType);
    return compatibleTypes ? Array.from(compatibleTypes) : [];
  }
  /**
   * Get data type configuration by ID
   */
  getDataTypeConfig(dataTypeId) {
    return this.portConfig.dataTypes.find(
      (dt) => {
        var _a2;
        return dt.id === dataTypeId || ((_a2 = dt.aliases) == null ? void 0 : _a2.includes(dataTypeId));
      }
    );
  }
  /**
   * Get all enabled data types
   */
  getEnabledDataTypes() {
    return this.portConfig.dataTypes.filter((dt) => dt.enabled !== false);
  }
}
let globalCompatibilityChecker = null;
function initializePortCompatibility(portConfig) {
  globalCompatibilityChecker = new PortCompatibilityChecker(portConfig);
}
function getPortCompatibilityChecker() {
  if (!globalCompatibilityChecker) {
    throw new Error(
      "Port compatibility checker not initialized. Call initializePortCompatibility() first."
    );
  }
  return globalCompatibilityChecker;
}
function areDataTypesCompatible(outputType, inputType) {
  if (!globalCompatibilityChecker) {
    return outputType === inputType;
  }
  return globalCompatibilityChecker.areDataTypesCompatible(outputType, inputType);
}
function getPossibleConnections(sourceNode, targetNodes, nodeTypes) {
  const sourceMetadata = nodeTypes.find((nt) => nt.id === sourceNode.data.metadata.id);
  if (!sourceMetadata) return [];
  const possibleConnections = [];
  const sourceOutputs = sourceMetadata.outputs;
  for (const targetNode of targetNodes) {
    if (targetNode.id === sourceNode.id) continue;
    const targetMetadata = nodeTypes.find((nt) => nt.id === targetNode.data.metadata.id);
    if (!targetMetadata) continue;
    const targetInputs = targetMetadata.inputs;
    for (const sourcePort of sourceOutputs) {
      for (const targetPort of targetInputs) {
        const compatible = areDataTypesCompatible(sourcePort.dataType, targetPort.dataType);
        possibleConnections.push({
          sourceNodeId: sourceNode.id,
          sourcePortId: sourcePort.id,
          sourcePort,
          targetNodeId: targetNode.id,
          targetPortId: targetPort.id,
          targetPort,
          compatible
        });
      }
    }
  }
  return possibleConnections;
}
function validateConnection(sourceNodeId, sourcePortId, targetNodeId, targetPortId, nodes, nodeTypes) {
  const sourceNode = nodes.find((n) => n.id === sourceNodeId);
  const targetNode = nodes.find((n) => n.id === targetNodeId);
  if (!sourceNode) {
    return { valid: false, error: "Source node not found" };
  }
  if (!targetNode) {
    return { valid: false, error: "Target node not found" };
  }
  if (sourceNodeId === targetNodeId) {
    return { valid: false, error: "Cannot connect node to itself" };
  }
  const sourceMetadata = nodeTypes.find((nt) => nt.id === sourceNode.data.metadata.id);
  const targetMetadata = nodeTypes.find((nt) => nt.id === targetNode.data.metadata.id);
  if (!sourceMetadata || !targetMetadata) {
    console.log("Metadata lookup failed:", {
      sourceNodeId,
      targetNodeId,
      sourceMetadataId: sourceNode.data.metadata.id,
      targetMetadataId: targetNode.data.metadata.id,
      availableNodeTypes: nodeTypes.map((nt) => nt.id)
    });
    return { valid: false, error: "Node metadata not found" };
  }
  const sourcePort = sourceMetadata.outputs.find((p) => p.id === sourcePortId);
  const targetPort = targetMetadata.inputs.find((p) => p.id === targetPortId);
  if (!sourcePort) {
    return { valid: false, error: "Source port not found" };
  }
  if (!targetPort) {
    return { valid: false, error: "Target port not found" };
  }
  if (!areDataTypesCompatible(sourcePort.dataType, targetPort.dataType)) {
    return {
      valid: false,
      error: `Incompatible data types: ${sourcePort.dataType} cannot connect to ${targetPort.dataType}`
    };
  }
  return { valid: true };
}
function getConnectionSuggestions(nodeId, nodes, nodeTypes) {
  const node = nodes.find((n) => n.id === nodeId);
  if (!node) return [];
  const metadata = nodeTypes.find((nt) => nt.id === node.data.metadata.id);
  if (!metadata) return [];
  const suggestions = [];
  const otherNodes = nodes.filter((n) => n.id !== nodeId);
  for (const otherNode of otherNodes) {
    const otherMetadata = nodeTypes.find((nt) => nt.id === otherNode.data.metadata.id);
    if (!otherMetadata) continue;
    for (const output of otherMetadata.outputs) {
      for (const input of metadata.inputs) {
        const compatible = areDataTypesCompatible(output.dataType, input.dataType);
        suggestions.push({
          nodeId: otherNode.id,
          nodeName: otherNode.data.label,
          portId: output.id,
          portName: output.name,
          portType: "output",
          dataType: output.dataType,
          compatible
        });
      }
    }
    for (const output of metadata.outputs) {
      for (const input of otherMetadata.inputs) {
        const compatible = areDataTypesCompatible(output.dataType, input.dataType);
        suggestions.push({
          nodeId: otherNode.id,
          nodeName: otherNode.data.label,
          portId: input.id,
          portName: input.name,
          portType: "input",
          dataType: input.dataType,
          compatible
        });
      }
    }
  }
  return suggestions;
}
function hasCycles(nodes, edges) {
  const visited = /* @__PURE__ */ new Set();
  const recursionStack = /* @__PURE__ */ new Set();
  function hasCycleUtil(nodeId) {
    if (recursionStack.has(nodeId)) return true;
    if (visited.has(nodeId)) return false;
    visited.add(nodeId);
    recursionStack.add(nodeId);
    const outgoingEdges = edges.filter((e) => e.source === nodeId);
    for (const edge of outgoingEdges) {
      if (hasCycleUtil(edge.target)) return true;
    }
    recursionStack.delete(nodeId);
    return false;
  }
  for (const node of nodes) {
    if (!visited.has(node.id)) {
      if (hasCycleUtil(node.id)) return true;
    }
  }
  return false;
}
function getExecutionOrder(nodes, edges) {
  const inDegree = /* @__PURE__ */ new Map();
  const graph = /* @__PURE__ */ new Map();
  for (const node of nodes) {
    inDegree.set(node.id, 0);
    graph.set(node.id, []);
  }
  for (const edge of edges) {
    const current = inDegree.get(edge.target) || 0;
    inDegree.set(edge.target, current + 1);
    const neighbors = graph.get(edge.source) || [];
    neighbors.push(edge.target);
    graph.set(edge.source, neighbors);
  }
  const queue = [];
  const result = [];
  for (const [nodeId, degree] of inDegree) {
    if (degree === 0) {
      queue.push(nodeId);
    }
  }
  while (queue.length > 0) {
    const nodeId = queue.shift();
    result.push(nodeId);
    const neighbors = graph.get(nodeId) || [];
    for (const neighbor of neighbors) {
      const degree = inDegree.get(neighbor) - 1;
      inDegree.set(neighbor, degree);
      if (degree === 0) {
        queue.push(neighbor);
      }
    }
  }
  return result;
}
const CATEGORY_COLOR_TOKENS = {
  inputs: "var(--color-ref-emerald-500)",
  outputs: "var(--color-ref-blue-600)",
  prompts: "var(--color-ref-amber-500)",
  models: "var(--color-ref-indigo-500)",
  processing: "var(--color-ref-teal-500)",
  logic: "var(--color-ref-purple-600)",
  data: "var(--color-ref-orange-500)",
  helpers: "var(--color-ref-slate-500)",
  tools: "var(--color-ref-amber-500)",
  "vector stores": "var(--color-ref-emerald-500)",
  embeddings: "var(--color-ref-indigo-500)",
  memories: "var(--color-ref-blue-600)",
  agents: "var(--color-ref-teal-500)",
  bundles: "var(--color-ref-slate-500)"
};
const DATA_TYPE_COLOR_TOKENS = {
  string: "var(--color-ref-emerald-500)",
  text: "var(--color-ref-emerald-500)",
  number: "var(--color-ref-blue-600)",
  integer: "var(--color-ref-blue-600)",
  float: "var(--color-ref-blue-600)",
  boolean: "var(--color-ref-purple-600)",
  array: "var(--color-ref-amber-500)",
  list: "var(--color-ref-amber-500)",
  object: "var(--color-ref-orange-500)",
  json: "var(--color-ref-orange-500)",
  file: "var(--color-ref-red-500)",
  document: "var(--color-ref-red-500)",
  image: "var(--color-ref-pink-500)",
  picture: "var(--color-ref-pink-500)",
  audio: "var(--color-ref-indigo-500)",
  sound: "var(--color-ref-indigo-500)",
  video: "var(--color-ref-teal-500)",
  movie: "var(--color-ref-teal-500)",
  url: "var(--color-ref-cyan-500)",
  email: "var(--color-ref-cyan-500)",
  date: "var(--color-ref-lime-500)",
  datetime: "var(--color-ref-lime-500)",
  time: "var(--color-ref-lime-500)",
  tool: "var(--color-ref-amber-500)"
};
function getCategoryColorToken(category) {
  return CATEGORY_COLOR_TOKENS[category] || "var(--color-ref-slate-500)";
}
function getDataTypeColorToken(dataType) {
  try {
    const checker = getPortCompatibilityChecker();
    const config = checker.getDataTypeConfig(dataType);
    if (config == null ? void 0 : config.color) {
      return config.color;
    }
  } catch (e) {
  }
  return DATA_TYPE_COLOR_TOKENS[dataType.toLowerCase()] || "var(--color-ref-slate-500)";
}
function getDataTypeConfig(dataType) {
  try {
    const checker = getPortCompatibilityChecker();
    return checker.getDataTypeConfig(dataType);
  } catch (error) {
    console.warn("Port compatibility checker not initialized:", error);
    return void 0;
  }
}
function getAvailableDataTypes() {
  try {
    const checker = getPortCompatibilityChecker();
    return checker.getEnabledDataTypes();
  } catch (error) {
    console.warn("Port compatibility checker not initialized:", error);
    return [];
  }
}
const DEFAULT_COLORS = {
  background: "flowdrop-color--base-light",
  accent: "flowdrop-color--neutral",
  text: "flowdrop-color--base-text",
  border: "flowdrop-color--base-border"
};
function getCategoryColors(category) {
  return CATEGORY_COLOR_TOKENS[category] || "var(--color-ref-slate-500)";
}
function getCategoryBackground(category) {
  return getCategoryColors(category);
}
function getCategoryAccent(category) {
  return getCategoryColors(category);
}
function getCategoryText(category) {
  return getCategoryColors(category);
}
function getCategoryBorder(category) {
  return getCategoryColors(category);
}
function getNodeColors(category, isError = false, isProcessing = false, isSelected = false) {
  const baseColor = getCategoryColors(category);
  if (isError) {
    return {
      background: "var(--color-ref-red-50)",
      accent: "var(--color-ref-red-500)",
      text: "var(--color-ref-red-900)",
      border: "var(--color-ref-red-200)"
    };
  }
  if (isProcessing) {
    return {
      background: "var(--color-ref-blue-50)",
      accent: "var(--color-ref-blue-500)",
      text: "var(--color-ref-blue-900)",
      border: "var(--color-ref-blue-200)"
    };
  }
  if (isSelected) {
    return {
      background: "var(--color-ref-indigo-50)",
      accent: "var(--color-ref-indigo-500)",
      text: "var(--color-ref-indigo-900)",
      border: "var(--color-ref-indigo-200)"
    };
  }
  return {
    background: baseColor,
    accent: baseColor,
    text: "var(--color-ref-slate-900)",
    border: baseColor
  };
}
function getNodeBackground(category, isError = false, isProcessing = false, isSelected = false) {
  return getNodeColors(category, isError, isProcessing, isSelected).background;
}
function getNodeAccent(category, isError = false, isProcessing = false, isSelected = false) {
  return getNodeColors(category, isError, isProcessing, isSelected).accent;
}
function getNodeText(category, isError = false, isProcessing = false, isSelected = false) {
  return getNodeColors(category, isError, isProcessing, isSelected).text;
}
function getNodeBorder(category, isError = false, isProcessing = false, isSelected = false) {
  return getNodeColors(category, isError, isProcessing, isSelected).border;
}
function getDataTypeColor(dataType) {
  return getDataTypeColorToken(dataType);
}
function parseDataTypeDisplay(dataType) {
  const isArray = dataType.endsWith("[]");
  if (isArray) {
    const elementType = dataType.slice(0, -2);
    const config = getDataTypeConfig(dataType);
    return {
      baseType: dataType,
      isArray: true,
      displayName: (config == null ? void 0 : config.name) || `${elementType}[]`,
      elementType
    };
  } else {
    const config = getDataTypeConfig(dataType);
    return {
      baseType: dataType,
      isArray: false,
      displayName: (config == null ? void 0 : config.name) || dataType
    };
  }
}
function getDataTypeDisplayText(dataType) {
  const parsed = parseDataTypeDisplay(dataType);
  return parsed.displayName;
}
function isArrayDataType(dataType) {
  return dataType.endsWith("[]") || dataType === "array" || dataType === "list";
}
function getArrayElementType(arrayDataType) {
  if (arrayDataType.endsWith("[]")) {
    return arrayDataType.slice(0, -2);
  }
  return null;
}
function handleNodeClick$1() {
}
var on_mouseup = (_2, isHandleInteraction) => {
  set$2(isHandleInteraction, false);
};
var on_keydown$2 = (e, handleDoubleClick2) => {
  if (e.key === "Enter" || e.key === " ") {
    e.preventDefault();
    handleDoubleClick2();
  }
};
var root_1$7 = /* @__PURE__ */ from_html(`<div class="flowdrop-workflow-node__status flowdrop-workflow-node__status--processing svelte-1wukpij" title="Processing"></div>`);
var root_2$5 = /* @__PURE__ */ from_html(`<div class="flowdrop-workflow-node__status flowdrop-workflow-node__status--error svelte-1wukpij" title="Error"></div>`);
var root_5$4 = /* @__PURE__ */ from_html(`<span class="flowdrop-badge flowdrop-badge--error flowdrop-badge--sm svelte-1wukpij">Required</span>`);
var root_6$2 = /* @__PURE__ */ from_html(`<p class="flowdrop-text--xs flowdrop-text--gray flowdrop-truncate svelte-1wukpij"> </p>`);
var root_4$4 = /* @__PURE__ */ from_html(`<div class="flowdrop-workflow-node__port svelte-1wukpij"><!> <div class="flowdrop-flex--1 flowdrop-min-w--0 svelte-1wukpij"><div class="flowdrop-flex flowdrop-gap--2 svelte-1wukpij"><span class="flowdrop-text--xs flowdrop-font--medium svelte-1wukpij"> </span> <span class="flowdrop-badge flowdrop-badge--sm svelte-1wukpij"> </span> <!></div> <!></div></div>`);
var root_3$8 = /* @__PURE__ */ from_html(`<div class="flowdrop-workflow-node__ports svelte-1wukpij"><div class="flowdrop-workflow-node__ports-header svelte-1wukpij"><h5 class="flowdrop-workflow-node__ports-title svelte-1wukpij">Inputs</h5></div> <div class="flowdrop-workflow-node__ports-list svelte-1wukpij"></div></div>`);
var root_9$1 = /* @__PURE__ */ from_html(`<p class="flowdrop-text--xs flowdrop-text--gray flowdrop-truncate svelte-1wukpij"> </p>`);
var root_8$1 = /* @__PURE__ */ from_html(`<div class="flowdrop-workflow-node__port svelte-1wukpij"><div class="flowdrop-flex--1 flowdrop-min-w--0 flowdrop-text--right svelte-1wukpij"><div class="flowdrop-flex flowdrop-gap--2 flowdrop-justify--end svelte-1wukpij"><span class="flowdrop-text--xs flowdrop-font--medium svelte-1wukpij"> </span> <span class="flowdrop-badge flowdrop-badge--sm svelte-1wukpij"> </span></div> <!></div> <!></div>`);
var root_7$1 = /* @__PURE__ */ from_html(`<div class="flowdrop-workflow-node__ports svelte-1wukpij"><div class="flowdrop-workflow-node__ports-header svelte-1wukpij"><h5 class="flowdrop-workflow-node__ports-title svelte-1wukpij">Outputs</h5></div> <div class="flowdrop-workflow-node__ports-list svelte-1wukpij"></div></div>`);
var root$b = /* @__PURE__ */ from_html(`<div role="button" tabindex="0"><div class="flowdrop-workflow-node__header svelte-1wukpij"><div class="flowdrop-flex flowdrop-gap--3 flowdrop-items--center svelte-1wukpij"><div class="flowdrop-workflow-node__icon svelte-1wukpij"><!></div> <h3 class="flowdrop-text--sm flowdrop-font--medium flowdrop-truncate flowdrop-flex--1 svelte-1wukpij"> </h3> <div class="flowdrop-flex flowdrop-gap--2 svelte-1wukpij"><!> <!></div></div> <p class="flowdrop-text--xs flowdrop-text--gray flowdrop-truncate flowdrop-mt--1 svelte-1wukpij"> </p></div> <!> <!> <button class="flowdrop-workflow-node__config-btn svelte-1wukpij" title="Configure node"><!></button></div>`);
function WorkflowNode($$anchor, $$props) {
  push($$props, true);
  let isHandleInteraction = /* @__PURE__ */ state(false);
  function handleDoubleClick2() {
    openConfigSidebar();
  }
  function openConfigSidebar() {
    if ($$props.data.onConfigOpen) {
      const nodeForConfig = {
        id: $$props.data.nodeId || "unknown",
        type: "workflowNode",
        data: $$props.data
      };
      $$props.data.onConfigOpen(nodeForConfig);
    }
  }
  var div = root$b();
  let classes;
  div.__click = [handleNodeClick$1];
  div.__dblclick = handleDoubleClick2;
  div.__mouseup = [on_mouseup, isHandleInteraction];
  div.__keydown = [on_keydown$2, handleDoubleClick2];
  var div_1 = child(div);
  var div_2 = child(div_1);
  var div_3 = child(div_2);
  var node = child(div_3);
  const expression = /* @__PURE__ */ user_derived(() => getNodeIcon($$props.data.metadata.icon, $$props.data.metadata.category));
  Icon(node, {
    get icon() {
      return get$3(expression);
    }
  });
  var h3 = sibling(div_3, 2);
  var text2 = child(h3);
  var div_4 = sibling(h3, 2);
  var node_1 = child(div_4);
  {
    var consequent = ($$anchor2) => {
      var div_5 = root_1$7();
      append($$anchor2, div_5);
    };
    if_block(node_1, ($$render) => {
      if ($$props.data.isProcessing) $$render(consequent);
    });
  }
  var node_2 = sibling(node_1, 2);
  {
    var consequent_1 = ($$anchor2) => {
      var div_6 = root_2$5();
      append($$anchor2, div_6);
    };
    if_block(node_2, ($$render) => {
      if ($$props.data.error) $$render(consequent_1);
    });
  }
  var p = sibling(div_2, 2);
  var text_1 = child(p);
  var node_3 = sibling(div_1, 2);
  {
    var consequent_4 = ($$anchor2) => {
      var div_7 = root_3$8();
      var div_8 = sibling(child(div_7), 2);
      each(div_8, 21, () => $$props.data.metadata.inputs, (port) => port.id, ($$anchor3, port) => {
        var div_9 = root_4$4();
        var node_4 = child(div_9);
        const expression_1 = /* @__PURE__ */ user_derived(() => `${$$props.data.nodeId}-input-${get$3(port).id}`);
        const expression_2 = /* @__PURE__ */ user_derived(() => getDataTypeColorToken(get$3(port).dataType));
        Handle(node_4, {
          type: "target",
          get position() {
            return Position.Left;
          },
          get id() {
            return get$3(expression_1);
          },
          class: "flowdrop-workflow-node__handle",
          get style() {
            var _a2;
            return `top: 50%; transform: translateY(-50%); margin-left: -32px; background-color: ${(_a2 = get$3(expression_2)) != null ? _a2 : ""}; border-color: '#ffffff';`;
          },
          role: "button",
          tabindex: 0,
          get "aria-label"() {
            var _a2;
            return `Connect to ${(_a2 = get$3(port).name) != null ? _a2 : ""} input port`;
          }
        });
        var div_10 = sibling(node_4, 2);
        var div_11 = child(div_10);
        var span = child(div_11);
        var text_2 = child(span);
        var span_1 = sibling(span, 2);
        var text_3 = child(span_1);
        var node_5 = sibling(span_1, 2);
        {
          var consequent_2 = ($$anchor4) => {
            var span_2 = root_5$4();
            append($$anchor4, span_2);
          };
          if_block(node_5, ($$render) => {
            if (get$3(port).required) $$render(consequent_2);
          });
        }
        var node_6 = sibling(div_11, 2);
        {
          var consequent_3 = ($$anchor4) => {
            var p_1 = root_6$2();
            var text_4 = child(p_1);
            template_effect(() => set_text(text_4, get$3(port).description));
            append($$anchor4, p_1);
          };
          if_block(node_6, ($$render) => {
            if (get$3(port).description) $$render(consequent_3);
          });
        }
        template_effect(
          ($0) => {
            set_text(text_2, get$3(port).name);
            set_style(span_1, `background-color: ${$0 != null ? $0 : ""}; color: #fff;`);
            set_text(text_3, get$3(port).dataType);
          },
          [
            () => getDataTypeColorToken(get$3(port).dataType)
          ]
        );
        append($$anchor3, div_9);
      });
      append($$anchor2, div_7);
    };
    if_block(node_3, ($$render) => {
      if ($$props.data.metadata.inputs.length > 0) $$render(consequent_4);
    });
  }
  var node_7 = sibling(node_3, 2);
  {
    var consequent_6 = ($$anchor2) => {
      var div_12 = root_7$1();
      var div_13 = sibling(child(div_12), 2);
      each(div_13, 21, () => $$props.data.metadata.outputs, (port) => port.id, ($$anchor3, port) => {
        var div_14 = root_8$1();
        var div_15 = child(div_14);
        var div_16 = child(div_15);
        var span_3 = child(div_16);
        var text_5 = child(span_3);
        var span_4 = sibling(span_3, 2);
        var text_6 = child(span_4);
        var node_8 = sibling(div_16, 2);
        {
          var consequent_5 = ($$anchor4) => {
            var p_2 = root_9$1();
            var text_7 = child(p_2);
            template_effect(() => set_text(text_7, get$3(port).description));
            append($$anchor4, p_2);
          };
          if_block(node_8, ($$render) => {
            if (get$3(port).description) $$render(consequent_5);
          });
        }
        var node_9 = sibling(div_15, 2);
        const expression_3 = /* @__PURE__ */ user_derived(() => `${$$props.data.nodeId}-output-${get$3(port).id}`);
        const expression_4 = /* @__PURE__ */ user_derived(() => getDataTypeColorToken(get$3(port).dataType));
        Handle(node_9, {
          type: "source",
          get position() {
            return Position.Right;
          },
          get id() {
            return get$3(expression_3);
          },
          class: "flowdrop-workflow-node__handle",
          get style() {
            var _a2;
            return `top: 50%; transform: translateY(-50%); margin-right: -32px; background-color: ${(_a2 = get$3(expression_4)) != null ? _a2 : ""}; border-color: '#ffffff';`;
          },
          role: "button",
          tabindex: 0,
          get "aria-label"() {
            var _a2;
            return `Connect from ${(_a2 = get$3(port).name) != null ? _a2 : ""} output port`;
          }
        });
        template_effect(
          ($0) => {
            set_text(text_5, get$3(port).name);
            set_style(span_4, `background-color: ${$0 != null ? $0 : ""}; color: #fff;`);
            set_text(text_6, get$3(port).dataType);
          },
          [
            () => getDataTypeColorToken(get$3(port).dataType)
          ]
        );
        append($$anchor3, div_14);
      });
      append($$anchor2, div_12);
    };
    if_block(node_7, ($$render) => {
      if ($$props.data.metadata.outputs.length > 0) $$render(consequent_6);
    });
  }
  var button = sibling(node_7, 2);
  button.__click = openConfigSidebar;
  var node_10 = child(button);
  Icon(node_10, { icon: "mdi:cog" });
  template_effect(
    ($0, $1) => {
      var _a2;
      classes = set_class(div, 1, "flowdrop-workflow-node svelte-1wukpij", null, classes, $0);
      set_attribute(div, "data-handle-interaction", get$3(isHandleInteraction));
      set_attribute(div, "aria-label", `Workflow node: ${(_a2 = $$props.data.metadata.name) != null ? _a2 : ""}`);
      set_attribute(div, "aria-describedby", `node-description-${$$props.data.nodeId || "unknown"}`);
      set_style(div_3, `background-color: ${$1 != null ? $1 : ""}`);
      set_text(text2, $$props.data.label);
      set_attribute(p, "id", `node-description-${$$props.data.nodeId || "unknown"}`);
      set_text(text_1, $$props.data.metadata.description);
    },
    [
      () => ({
        "flowdrop-workflow-node--selected": $$props.selected
      }),
      () => getCategoryColorToken($$props.data.metadata.category)
    ]
  );
  append($$anchor, div);
  pop();
}
delegate(["click", "dblclick", "mouseup", "keydown"]);
function L() {
  return { async: false, breaks: false, extensions: null, gfm: true, hooks: null, pedantic: false, renderer: null, silent: false, tokenizer: null, walkTokens: null };
}
var O = L();
function H(l3) {
  O = l3;
}
var E = { exec: () => null };
function h(l3, e = "") {
  let t = typeof l3 == "string" ? l3 : l3.source, n = { replace: (r2, i) => {
    let s = typeof i == "string" ? i : i.source;
    return s = s.replace(m.caret, "$1"), t = t.replace(r2, s), n;
  }, getRegex: () => new RegExp(t, e) };
  return n;
}
var m = { codeRemoveIndent: /^(?: {1,4}| {0,3}\t)/gm, outputLinkReplace: /\\([\[\]])/g, indentCodeCompensation: /^(\s+)(?:```)/, beginningSpace: /^\s+/, endingHash: /#$/, startingSpaceChar: /^ /, endingSpaceChar: / $/, nonSpaceChar: /[^ ]/, newLineCharGlobal: /\n/g, tabCharGlobal: /\t/g, multipleSpaceGlobal: /\s+/g, blankLine: /^[ \t]*$/, doubleBlankLine: /\n[ \t]*\n[ \t]*$/, blockquoteStart: /^ {0,3}>/, blockquoteSetextReplace: /\n {0,3}((?:=+|-+) *)(?=\n|$)/g, blockquoteSetextReplace2: /^ {0,3}>[ \t]?/gm, listReplaceTabs: /^\t+/, listReplaceNesting: /^ {1,4}(?=( {4})*[^ ])/g, listIsTask: /^\[[ xX]\] /, listReplaceTask: /^\[[ xX]\] +/, anyLine: /\n.*\n/, hrefBrackets: /^<(.*)>$/, tableDelimiter: /[:|]/, tableAlignChars: /^\||\| *$/g, tableRowBlankLine: /\n[ \t]*$/, tableAlignRight: /^ *-+: *$/, tableAlignCenter: /^ *:-+: *$/, tableAlignLeft: /^ *:-+ *$/, startATag: /^<a /i, endATag: /^<\/a>/i, startPreScriptTag: /^<(pre|code|kbd|script)(\s|>)/i, endPreScriptTag: /^<\/(pre|code|kbd|script)(\s|>)/i, startAngleBracket: /^</, endAngleBracket: />$/, pedanticHrefTitle: /^([^'"]*[^\s])\s+(['"])(.*)\2/, unicodeAlphaNumeric: /[\p{L}\p{N}]/u, escapeTest: /[&<>"']/, escapeReplace: /[&<>"']/g, escapeTestNoEncode: /[<>"']|&(?!(#\d{1,7}|#[Xx][a-fA-F0-9]{1,6}|\w+);)/, escapeReplaceNoEncode: /[<>"']|&(?!(#\d{1,7}|#[Xx][a-fA-F0-9]{1,6}|\w+);)/g, unescapeTest: /&(#(?:\d+)|(?:#x[0-9A-Fa-f]+)|(?:\w+));?/ig, caret: /(^|[^\[])\^/g, percentDecode: /%25/g, findPipe: /\|/g, splitPipe: / \|/, slashPipe: /\\\|/g, carriageReturn: /\r\n|\r/g, spaceLine: /^ +$/gm, notSpaceStart: /^\S*/, endingNewline: /\n$/, listItemRegex: (l3) => new RegExp(`^( {0,3}${l3})((?:[	 ][^\\n]*)?(?:\\n|$))`), nextBulletRegex: (l3) => new RegExp(`^ {0,${Math.min(3, l3 - 1)}}(?:[*+-]|\\d{1,9}[.)])((?:[ 	][^\\n]*)?(?:\\n|$))`), hrRegex: (l3) => new RegExp(`^ {0,${Math.min(3, l3 - 1)}}((?:- *){3,}|(?:_ *){3,}|(?:\\* *){3,})(?:\\n+|$)`), fencesBeginRegex: (l3) => new RegExp(`^ {0,${Math.min(3, l3 - 1)}}(?:\`\`\`|~~~)`), headingBeginRegex: (l3) => new RegExp(`^ {0,${Math.min(3, l3 - 1)}}#`), htmlBeginRegex: (l3) => new RegExp(`^ {0,${Math.min(3, l3 - 1)}}<(?:[a-z].*>|!--)`, "i") }, xe = /^(?:[ \t]*(?:\n|$))+/, be = /^((?: {4}| {0,3}\t)[^\n]+(?:\n(?:[ \t]*(?:\n|$))*)?)+/, Re = /^ {0,3}(`{3,}(?=[^`\n]*(?:\n|$))|~{3,})([^\n]*)(?:\n|$)(?:|([\s\S]*?)(?:\n|$))(?: {0,3}\1[~`]* *(?=\n|$)|$)/, C = /^ {0,3}((?:-[\t ]*){3,}|(?:_[ \t]*){3,}|(?:\*[ \t]*){3,})(?:\n+|$)/, Oe = /^ {0,3}(#{1,6})(?=\s|$)(.*)(?:\n+|$)/, j = /(?:[*+-]|\d{1,9}[.)])/, se = /^(?!bull |blockCode|fences|blockquote|heading|html|table)((?:.|\n(?!\s*?\n|bull |blockCode|fences|blockquote|heading|html|table))+?)\n {0,3}(=+|-+) *(?:\n+|$)/, ie = h(se).replace(/bull/g, j).replace(/blockCode/g, /(?: {4}| {0,3}\t)/).replace(/fences/g, / {0,3}(?:`{3,}|~{3,})/).replace(/blockquote/g, / {0,3}>/).replace(/heading/g, / {0,3}#{1,6}/).replace(/html/g, / {0,3}<[^\n>]+>\n/).replace(/\|table/g, "").getRegex(), Te = h(se).replace(/bull/g, j).replace(/blockCode/g, /(?: {4}| {0,3}\t)/).replace(/fences/g, / {0,3}(?:`{3,}|~{3,})/).replace(/blockquote/g, / {0,3}>/).replace(/heading/g, / {0,3}#{1,6}/).replace(/html/g, / {0,3}<[^\n>]+>\n/).replace(/table/g, / {0,3}\|?(?:[:\- ]*\|)+[\:\- ]*\n/).getRegex(), F = /^([^\n]+(?:\n(?!hr|heading|lheading|blockquote|fences|list|html|table| +\n)[^\n]+)*)/, we = /^[^\n]+/, Q = /(?!\s*\])(?:\\.|[^\[\]\\])+/, ye = h(/^ {0,3}\[(label)\]: *(?:\n[ \t]*)?([^<\s][^\s]*|<.*?>)(?:(?: +(?:\n[ \t]*)?| *\n[ \t]*)(title))? *(?:\n+|$)/).replace("label", Q).replace("title", /(?:"(?:\\"?|[^"\\])*"|'[^'\n]*(?:\n[^'\n]+)*\n?'|\([^()]*\))/).getRegex(), Pe = h(/^( {0,3}bull)([ \t][^\n]+?)?(?:\n|$)/).replace(/bull/g, j).getRegex(), v = "address|article|aside|base|basefont|blockquote|body|caption|center|col|colgroup|dd|details|dialog|dir|div|dl|dt|fieldset|figcaption|figure|footer|form|frame|frameset|h[1-6]|head|header|hr|html|iframe|legend|li|link|main|menu|menuitem|meta|nav|noframes|ol|optgroup|option|p|param|search|section|summary|table|tbody|td|tfoot|th|thead|title|tr|track|ul", U = /<!--(?:-?>|[\s\S]*?(?:-->|$))/, Se = h("^ {0,3}(?:<(script|pre|style|textarea)[\\s>][\\s\\S]*?(?:</\\1>[^\\n]*\\n+|$)|comment[^\\n]*(\\n+|$)|<\\?[\\s\\S]*?(?:\\?>\\n*|$)|<![A-Z][\\s\\S]*?(?:>\\n*|$)|<!\\[CDATA\\[[\\s\\S]*?(?:\\]\\]>\\n*|$)|</?(tag)(?: +|\\n|/?>)[\\s\\S]*?(?:(?:\\n[ 	]*)+\\n|$)|<(?!script|pre|style|textarea)([a-z][\\w-]*)(?:attribute)*? */?>(?=[ \\t]*(?:\\n|$))[\\s\\S]*?(?:(?:\\n[ 	]*)+\\n|$)|</(?!script|pre|style|textarea)[a-z][\\w-]*\\s*>(?=[ \\t]*(?:\\n|$))[\\s\\S]*?(?:(?:\\n[ 	]*)+\\n|$))", "i").replace("comment", U).replace("tag", v).replace("attribute", / +[a-zA-Z:_][\w.:-]*(?: *= *"[^"\n]*"| *= *'[^'\n]*'| *= *[^\s"'=<>`]+)?/).getRegex(), oe = h(F).replace("hr", C).replace("heading", " {0,3}#{1,6}(?:\\s|$)").replace("|lheading", "").replace("|table", "").replace("blockquote", " {0,3}>").replace("fences", " {0,3}(?:`{3,}(?=[^`\\n]*\\n)|~{3,})[^\\n]*\\n").replace("list", " {0,3}(?:[*+-]|1[.)]) ").replace("html", "</?(?:tag)(?: +|\\n|/?>)|<(?:script|pre|style|textarea|!--)").replace("tag", v).getRegex(), $e = h(/^( {0,3}> ?(paragraph|[^\n]*)(?:\n|$))+/).replace("paragraph", oe).getRegex(), K = { blockquote: $e, code: be, def: ye, fences: Re, heading: Oe, hr: C, html: Se, lheading: ie, list: Pe, newline: xe, paragraph: oe, table: E, text: we }, re = h("^ *([^\\n ].*)\\n {0,3}((?:\\| *)?:?-+:? *(?:\\| *:?-+:? *)*(?:\\| *)?)(?:\\n((?:(?! *\\n|hr|heading|blockquote|code|fences|list|html).*(?:\\n|$))*)\\n*|$)").replace("hr", C).replace("heading", " {0,3}#{1,6}(?:\\s|$)").replace("blockquote", " {0,3}>").replace("code", "(?: {4}| {0,3}	)[^\\n]").replace("fences", " {0,3}(?:`{3,}(?=[^`\\n]*\\n)|~{3,})[^\\n]*\\n").replace("list", " {0,3}(?:[*+-]|1[.)]) ").replace("html", "</?(?:tag)(?: +|\\n|/?>)|<(?:script|pre|style|textarea|!--)").replace("tag", v).getRegex(), _e = __spreadProps(__spreadValues({}, K), { lheading: Te, table: re, paragraph: h(F).replace("hr", C).replace("heading", " {0,3}#{1,6}(?:\\s|$)").replace("|lheading", "").replace("table", re).replace("blockquote", " {0,3}>").replace("fences", " {0,3}(?:`{3,}(?=[^`\\n]*\\n)|~{3,})[^\\n]*\\n").replace("list", " {0,3}(?:[*+-]|1[.)]) ").replace("html", "</?(?:tag)(?: +|\\n|/?>)|<(?:script|pre|style|textarea|!--)").replace("tag", v).getRegex() }), Le = __spreadProps(__spreadValues({}, K), { html: h(`^ *(?:comment *(?:\\n|\\s*$)|<(tag)[\\s\\S]+?</\\1> *(?:\\n{2,}|\\s*$)|<tag(?:"[^"]*"|'[^']*'|\\s[^'"/>\\s]*)*?/?> *(?:\\n{2,}|\\s*$))`).replace("comment", U).replace(/tag/g, "(?!(?:a|em|strong|small|s|cite|q|dfn|abbr|data|time|code|var|samp|kbd|sub|sup|i|b|u|mark|ruby|rt|rp|bdi|bdo|span|br|wbr|ins|del|img)\\b)\\w+(?!:|[^\\w\\s@]*@)\\b").getRegex(), def: /^ *\[([^\]]+)\]: *<?([^\s>]+)>?(?: +(["(][^\n]+[")]))? *(?:\n+|$)/, heading: /^(#{1,6})(.*)(?:\n+|$)/, fences: E, lheading: /^(.+?)\n {0,3}(=+|-+) *(?:\n+|$)/, paragraph: h(F).replace("hr", C).replace("heading", ` *#{1,6} *[^
]`).replace("lheading", ie).replace("|table", "").replace("blockquote", " {0,3}>").replace("|fences", "").replace("|list", "").replace("|html", "").replace("|tag", "").getRegex() }), Me = /^\\([!"#$%&'()*+,\-./:;<=>?@\[\]\\^_`{|}~])/, ze = /^(`+)([^`]|[^`][\s\S]*?[^`])\1(?!`)/, ae = /^( {2,}|\\)\n(?!\s*$)/, Ae = /^(`+|[^`])(?:(?= {2,}\n)|[\s\S]*?(?:(?=[\\<!\[`*_]|\b_|$)|[^ ](?= {2,}\n)))/, D = /[\p{P}\p{S}]/u, W = /[\s\p{P}\p{S}]/u, le = /[^\s\p{P}\p{S}]/u, Ee = h(/^((?![*_])punctSpace)/, "u").replace(/punctSpace/g, W).getRegex(), ue = /(?!~)[\p{P}\p{S}]/u, Ce = /(?!~)[\s\p{P}\p{S}]/u, Ie = /(?:[^\s\p{P}\p{S}]|~)/u, Be = /\[[^[\]]*?\]\((?:\\.|[^\\\(\)]|\((?:\\.|[^\\\(\)])*\))*\)|`[^`]*?`|<(?! )[^<>]*?>/g, pe = /^(?:\*+(?:((?!\*)punct)|[^\s*]))|^_+(?:((?!_)punct)|([^\s_]))/, qe = h(pe, "u").replace(/punct/g, D).getRegex(), ve = h(pe, "u").replace(/punct/g, ue).getRegex(), ce = "^[^_*]*?__[^_*]*?\\*[^_*]*?(?=__)|[^*]+(?=[^*])|(?!\\*)punct(\\*+)(?=[\\s]|$)|notPunctSpace(\\*+)(?!\\*)(?=punctSpace|$)|(?!\\*)punctSpace(\\*+)(?=notPunctSpace)|[\\s](\\*+)(?!\\*)(?=punct)|(?!\\*)punct(\\*+)(?!\\*)(?=punct)|notPunctSpace(\\*+)(?=notPunctSpace)", De = h(ce, "gu").replace(/notPunctSpace/g, le).replace(/punctSpace/g, W).replace(/punct/g, D).getRegex(), Ze = h(ce, "gu").replace(/notPunctSpace/g, Ie).replace(/punctSpace/g, Ce).replace(/punct/g, ue).getRegex(), Ge = h("^[^_*]*?\\*\\*[^_*]*?_[^_*]*?(?=\\*\\*)|[^_]+(?=[^_])|(?!_)punct(_+)(?=[\\s]|$)|notPunctSpace(_+)(?!_)(?=punctSpace|$)|(?!_)punctSpace(_+)(?=notPunctSpace)|[\\s](_+)(?!_)(?=punct)|(?!_)punct(_+)(?!_)(?=punct)", "gu").replace(/notPunctSpace/g, le).replace(/punctSpace/g, W).replace(/punct/g, D).getRegex(), He = h(/\\(punct)/, "gu").replace(/punct/g, D).getRegex(), Ne = h(/^<(scheme:[^\s\x00-\x1f<>]*|email)>/).replace("scheme", /[a-zA-Z][a-zA-Z0-9+.-]{1,31}/).replace("email", /[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+(@)[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)+(?![-_])/).getRegex(), je = h(U).replace("(?:-->|$)", "-->").getRegex(), Fe = h("^comment|^</[a-zA-Z][\\w:-]*\\s*>|^<[a-zA-Z][\\w-]*(?:attribute)*?\\s*/?>|^<\\?[\\s\\S]*?\\?>|^<![a-zA-Z]+\\s[\\s\\S]*?>|^<!\\[CDATA\\[[\\s\\S]*?\\]\\]>").replace("comment", je).replace("attribute", /\s+[a-zA-Z:_][\w.:-]*(?:\s*=\s*"[^"]*"|\s*=\s*'[^']*'|\s*=\s*[^\s"'=<>`]+)?/).getRegex(), q = /(?:\[(?:\\.|[^\[\]\\])*\]|\\.|`[^`]*`|[^\[\]\\`])*?/, Qe = h(/^!?\[(label)\]\(\s*(href)(?:(?:[ \t]*(?:\n[ \t]*)?)(title))?\s*\)/).replace("label", q).replace("href", /<(?:\\.|[^\n<>\\])+>|[^ \t\n\x00-\x1f]*/).replace("title", /"(?:\\"?|[^"\\])*"|'(?:\\'?|[^'\\])*'|\((?:\\\)?|[^)\\])*\)/).getRegex(), he = h(/^!?\[(label)\]\[(ref)\]/).replace("label", q).replace("ref", Q).getRegex(), de = h(/^!?\[(ref)\](?:\[\])?/).replace("ref", Q).getRegex(), Ue = h("reflink|nolink(?!\\()", "g").replace("reflink", he).replace("nolink", de).getRegex(), X = { _backpedal: E, anyPunctuation: He, autolink: Ne, blockSkip: Be, br: ae, code: ze, del: E, emStrongLDelim: qe, emStrongRDelimAst: De, emStrongRDelimUnd: Ge, escape: Me, link: Qe, nolink: de, punctuation: Ee, reflink: he, reflinkSearch: Ue, tag: Fe, text: Ae, url: E }, Ke = __spreadProps(__spreadValues({}, X), { link: h(/^!?\[(label)\]\((.*?)\)/).replace("label", q).getRegex(), reflink: h(/^!?\[(label)\]\s*\[([^\]]*)\]/).replace("label", q).getRegex() }), N = __spreadProps(__spreadValues({}, X), { emStrongRDelimAst: Ze, emStrongLDelim: ve, url: h(/^((?:ftp|https?):\/\/|www\.)(?:[a-zA-Z0-9\-]+\.?)+[^\s<]*|^email/, "i").replace("email", /[A-Za-z0-9._+-]+(@)[a-zA-Z0-9-_]+(?:\.[a-zA-Z0-9-_]*[a-zA-Z0-9])+(?![-_])/).getRegex(), _backpedal: /(?:[^?!.,:;*_'"~()&]+|\([^)]*\)|&(?![a-zA-Z0-9]+;$)|[?!.,:;*_'"~)]+(?!$))+/, del: /^(~~?)(?=[^\s~])((?:\\.|[^\\])*?(?:\\.|[^\s~\\]))\1(?=[^~]|$)/, text: /^([`~]+|[^`~])(?:(?= {2,}\n)|(?=[a-zA-Z0-9.!#$%&'*+\/=?_`{\|}~-]+@)|[\s\S]*?(?:(?=[\\<!\[`*~_]|\b_|https?:\/\/|ftp:\/\/|www\.|$)|[^ ](?= {2,}\n)|[^a-zA-Z0-9.!#$%&'*+\/=?_`{\|}~-](?=[a-zA-Z0-9.!#$%&'*+\/=?_`{\|}~-]+@)))/ }), We = __spreadProps(__spreadValues({}, N), { br: h(ae).replace("{2,}", "*").getRegex(), text: h(N.text).replace("\\b_", "\\b_| {2,}\\n").replace(/\{2,\}/g, "*").getRegex() }), I = { normal: K, gfm: _e, pedantic: Le }, M = { normal: X, gfm: N, breaks: We, pedantic: Ke };
var Xe = { "&": "&amp;", "<": "&lt;", ">": "&gt;", '"': "&quot;", "'": "&#39;" }, ke = (l3) => Xe[l3];
function w(l3, e) {
  if (e) {
    if (m.escapeTest.test(l3)) return l3.replace(m.escapeReplace, ke);
  } else if (m.escapeTestNoEncode.test(l3)) return l3.replace(m.escapeReplaceNoEncode, ke);
  return l3;
}
function J(l3) {
  try {
    l3 = encodeURI(l3).replace(m.percentDecode, "%");
  } catch (e) {
    return null;
  }
  return l3;
}
function V(l3, e) {
  var _a2;
  let t = l3.replace(m.findPipe, (i, s, o) => {
    let a = false, u = s;
    for (; --u >= 0 && o[u] === "\\"; ) a = !a;
    return a ? "|" : " |";
  }), n = t.split(m.splitPipe), r2 = 0;
  if (n[0].trim() || n.shift(), n.length > 0 && !((_a2 = n.at(-1)) == null ? void 0 : _a2.trim()) && n.pop(), e) if (n.length > e) n.splice(e);
  else for (; n.length < e; ) n.push("");
  for (; r2 < n.length; r2++) n[r2] = n[r2].trim().replace(m.slashPipe, "|");
  return n;
}
function z(l3, e, t) {
  let n = l3.length;
  if (n === 0) return "";
  let r2 = 0;
  for (; r2 < n; ) {
    let i = l3.charAt(n - r2 - 1);
    if (i === e && true) r2++;
    else break;
  }
  return l3.slice(0, n - r2);
}
function ge(l3, e) {
  if (l3.indexOf(e[1]) === -1) return -1;
  let t = 0;
  for (let n = 0; n < l3.length; n++) if (l3[n] === "\\") n++;
  else if (l3[n] === e[0]) t++;
  else if (l3[n] === e[1] && (t--, t < 0)) return n;
  return t > 0 ? -2 : -1;
}
function fe(l3, e, t, n, r2) {
  let i = e.href, s = e.title || null, o = l3[1].replace(r2.other.outputLinkReplace, "$1");
  n.state.inLink = true;
  let a = { type: l3[0].charAt(0) === "!" ? "image" : "link", raw: t, href: i, title: s, text: o, tokens: n.inlineTokens(o) };
  return n.state.inLink = false, a;
}
function Je(l3, e, t) {
  let n = l3.match(t.other.indentCodeCompensation);
  if (n === null) return e;
  let r2 = n[1];
  return e.split(`
`).map((i) => {
    let s = i.match(t.other.beginningSpace);
    if (s === null) return i;
    let [o] = s;
    return o.length >= r2.length ? i.slice(r2.length) : i;
  }).join(`
`);
}
var y = class {
  constructor(e) {
    __publicField(this, "options");
    __publicField(this, "rules");
    __publicField(this, "lexer");
    this.options = e || O;
  }
  space(e) {
    let t = this.rules.block.newline.exec(e);
    if (t && t[0].length > 0) return { type: "space", raw: t[0] };
  }
  code(e) {
    let t = this.rules.block.code.exec(e);
    if (t) {
      let n = t[0].replace(this.rules.other.codeRemoveIndent, "");
      return { type: "code", raw: t[0], codeBlockStyle: "indented", text: this.options.pedantic ? n : z(n, `
`) };
    }
  }
  fences(e) {
    let t = this.rules.block.fences.exec(e);
    if (t) {
      let n = t[0], r2 = Je(n, t[3] || "", this.rules);
      return { type: "code", raw: n, lang: t[2] ? t[2].trim().replace(this.rules.inline.anyPunctuation, "$1") : t[2], text: r2 };
    }
  }
  heading(e) {
    let t = this.rules.block.heading.exec(e);
    if (t) {
      let n = t[2].trim();
      if (this.rules.other.endingHash.test(n)) {
        let r2 = z(n, "#");
        (this.options.pedantic || !r2 || this.rules.other.endingSpaceChar.test(r2)) && (n = r2.trim());
      }
      return { type: "heading", raw: t[0], depth: t[1].length, text: n, tokens: this.lexer.inline(n) };
    }
  }
  hr(e) {
    let t = this.rules.block.hr.exec(e);
    if (t) return { type: "hr", raw: z(t[0], `
`) };
  }
  blockquote(e) {
    let t = this.rules.block.blockquote.exec(e);
    if (t) {
      let n = z(t[0], `
`).split(`
`), r2 = "", i = "", s = [];
      for (; n.length > 0; ) {
        let o = false, a = [], u;
        for (u = 0; u < n.length; u++) if (this.rules.other.blockquoteStart.test(n[u])) a.push(n[u]), o = true;
        else if (!o) a.push(n[u]);
        else break;
        n = n.slice(u);
        let p = a.join(`
`), c = p.replace(this.rules.other.blockquoteSetextReplace, `
    $1`).replace(this.rules.other.blockquoteSetextReplace2, "");
        r2 = r2 ? `${r2}
${p}` : p, i = i ? `${i}
${c}` : c;
        let f = this.lexer.state.top;
        if (this.lexer.state.top = true, this.lexer.blockTokens(c, s, true), this.lexer.state.top = f, n.length === 0) break;
        let k = s.at(-1);
        if ((k == null ? void 0 : k.type) === "code") break;
        if ((k == null ? void 0 : k.type) === "blockquote") {
          let x = k, g = x.raw + `
` + n.join(`
`), T = this.blockquote(g);
          s[s.length - 1] = T, r2 = r2.substring(0, r2.length - x.raw.length) + T.raw, i = i.substring(0, i.length - x.text.length) + T.text;
          break;
        } else if ((k == null ? void 0 : k.type) === "list") {
          let x = k, g = x.raw + `
` + n.join(`
`), T = this.list(g);
          s[s.length - 1] = T, r2 = r2.substring(0, r2.length - k.raw.length) + T.raw, i = i.substring(0, i.length - x.raw.length) + T.raw, n = g.substring(s.at(-1).raw.length).split(`
`);
          continue;
        }
      }
      return { type: "blockquote", raw: r2, tokens: s, text: i };
    }
  }
  list(e) {
    let t = this.rules.block.list.exec(e);
    if (t) {
      let n = t[1].trim(), r2 = n.length > 1, i = { type: "list", raw: "", ordered: r2, start: r2 ? +n.slice(0, -1) : "", loose: false, items: [] };
      n = r2 ? `\\d{1,9}\\${n.slice(-1)}` : `\\${n}`, this.options.pedantic && (n = r2 ? n : "[*+-]");
      let s = this.rules.other.listItemRegex(n), o = false;
      for (; e; ) {
        let u = false, p = "", c = "";
        if (!(t = s.exec(e)) || this.rules.block.hr.test(e)) break;
        p = t[0], e = e.substring(p.length);
        let f = t[2].split(`
`, 1)[0].replace(this.rules.other.listReplaceTabs, (Z) => " ".repeat(3 * Z.length)), k = e.split(`
`, 1)[0], x = !f.trim(), g = 0;
        if (this.options.pedantic ? (g = 2, c = f.trimStart()) : x ? g = t[1].length + 1 : (g = t[2].search(this.rules.other.nonSpaceChar), g = g > 4 ? 1 : g, c = f.slice(g), g += t[1].length), x && this.rules.other.blankLine.test(k) && (p += k + `
`, e = e.substring(k.length + 1), u = true), !u) {
          let Z = this.rules.other.nextBulletRegex(g), ee = this.rules.other.hrRegex(g), te = this.rules.other.fencesBeginRegex(g), ne = this.rules.other.headingBeginRegex(g), me = this.rules.other.htmlBeginRegex(g);
          for (; e; ) {
            let G = e.split(`
`, 1)[0], A;
            if (k = G, this.options.pedantic ? (k = k.replace(this.rules.other.listReplaceNesting, "  "), A = k) : A = k.replace(this.rules.other.tabCharGlobal, "    "), te.test(k) || ne.test(k) || me.test(k) || Z.test(k) || ee.test(k)) break;
            if (A.search(this.rules.other.nonSpaceChar) >= g || !k.trim()) c += `
` + A.slice(g);
            else {
              if (x || f.replace(this.rules.other.tabCharGlobal, "    ").search(this.rules.other.nonSpaceChar) >= 4 || te.test(f) || ne.test(f) || ee.test(f)) break;
              c += `
` + k;
            }
            !x && !k.trim() && (x = true), p += G + `
`, e = e.substring(G.length + 1), f = A.slice(g);
          }
        }
        i.loose || (o ? i.loose = true : this.rules.other.doubleBlankLine.test(p) && (o = true));
        let T = null, Y;
        this.options.gfm && (T = this.rules.other.listIsTask.exec(c), T && (Y = T[0] !== "[ ] ", c = c.replace(this.rules.other.listReplaceTask, ""))), i.items.push({ type: "list_item", raw: p, task: !!T, checked: Y, loose: false, text: c, tokens: [] }), i.raw += p;
      }
      let a = i.items.at(-1);
      if (a) a.raw = a.raw.trimEnd(), a.text = a.text.trimEnd();
      else return;
      i.raw = i.raw.trimEnd();
      for (let u = 0; u < i.items.length; u++) if (this.lexer.state.top = false, i.items[u].tokens = this.lexer.blockTokens(i.items[u].text, []), !i.loose) {
        let p = i.items[u].tokens.filter((f) => f.type === "space"), c = p.length > 0 && p.some((f) => this.rules.other.anyLine.test(f.raw));
        i.loose = c;
      }
      if (i.loose) for (let u = 0; u < i.items.length; u++) i.items[u].loose = true;
      return i;
    }
  }
  html(e) {
    let t = this.rules.block.html.exec(e);
    if (t) return { type: "html", block: true, raw: t[0], pre: t[1] === "pre" || t[1] === "script" || t[1] === "style", text: t[0] };
  }
  def(e) {
    let t = this.rules.block.def.exec(e);
    if (t) {
      let n = t[1].toLowerCase().replace(this.rules.other.multipleSpaceGlobal, " "), r2 = t[2] ? t[2].replace(this.rules.other.hrefBrackets, "$1").replace(this.rules.inline.anyPunctuation, "$1") : "", i = t[3] ? t[3].substring(1, t[3].length - 1).replace(this.rules.inline.anyPunctuation, "$1") : t[3];
      return { type: "def", tag: n, raw: t[0], href: r2, title: i };
    }
  }
  table(e) {
    var _a2;
    let t = this.rules.block.table.exec(e);
    if (!t || !this.rules.other.tableDelimiter.test(t[2])) return;
    let n = V(t[1]), r2 = t[2].replace(this.rules.other.tableAlignChars, "").split("|"), i = ((_a2 = t[3]) == null ? void 0 : _a2.trim()) ? t[3].replace(this.rules.other.tableRowBlankLine, "").split(`
`) : [], s = { type: "table", raw: t[0], header: [], align: [], rows: [] };
    if (n.length === r2.length) {
      for (let o of r2) this.rules.other.tableAlignRight.test(o) ? s.align.push("right") : this.rules.other.tableAlignCenter.test(o) ? s.align.push("center") : this.rules.other.tableAlignLeft.test(o) ? s.align.push("left") : s.align.push(null);
      for (let o = 0; o < n.length; o++) s.header.push({ text: n[o], tokens: this.lexer.inline(n[o]), header: true, align: s.align[o] });
      for (let o of i) s.rows.push(V(o, s.header.length).map((a, u) => ({ text: a, tokens: this.lexer.inline(a), header: false, align: s.align[u] })));
      return s;
    }
  }
  lheading(e) {
    let t = this.rules.block.lheading.exec(e);
    if (t) return { type: "heading", raw: t[0], depth: t[2].charAt(0) === "=" ? 1 : 2, text: t[1], tokens: this.lexer.inline(t[1]) };
  }
  paragraph(e) {
    let t = this.rules.block.paragraph.exec(e);
    if (t) {
      let n = t[1].charAt(t[1].length - 1) === `
` ? t[1].slice(0, -1) : t[1];
      return { type: "paragraph", raw: t[0], text: n, tokens: this.lexer.inline(n) };
    }
  }
  text(e) {
    let t = this.rules.block.text.exec(e);
    if (t) return { type: "text", raw: t[0], text: t[0], tokens: this.lexer.inline(t[0]) };
  }
  escape(e) {
    let t = this.rules.inline.escape.exec(e);
    if (t) return { type: "escape", raw: t[0], text: t[1] };
  }
  tag(e) {
    let t = this.rules.inline.tag.exec(e);
    if (t) return !this.lexer.state.inLink && this.rules.other.startATag.test(t[0]) ? this.lexer.state.inLink = true : this.lexer.state.inLink && this.rules.other.endATag.test(t[0]) && (this.lexer.state.inLink = false), !this.lexer.state.inRawBlock && this.rules.other.startPreScriptTag.test(t[0]) ? this.lexer.state.inRawBlock = true : this.lexer.state.inRawBlock && this.rules.other.endPreScriptTag.test(t[0]) && (this.lexer.state.inRawBlock = false), { type: "html", raw: t[0], inLink: this.lexer.state.inLink, inRawBlock: this.lexer.state.inRawBlock, block: false, text: t[0] };
  }
  link(e) {
    let t = this.rules.inline.link.exec(e);
    if (t) {
      let n = t[2].trim();
      if (!this.options.pedantic && this.rules.other.startAngleBracket.test(n)) {
        if (!this.rules.other.endAngleBracket.test(n)) return;
        let s = z(n.slice(0, -1), "\\");
        if ((n.length - s.length) % 2 === 0) return;
      } else {
        let s = ge(t[2], "()");
        if (s === -2) return;
        if (s > -1) {
          let a = (t[0].indexOf("!") === 0 ? 5 : 4) + t[1].length + s;
          t[2] = t[2].substring(0, s), t[0] = t[0].substring(0, a).trim(), t[3] = "";
        }
      }
      let r2 = t[2], i = "";
      if (this.options.pedantic) {
        let s = this.rules.other.pedanticHrefTitle.exec(r2);
        s && (r2 = s[1], i = s[3]);
      } else i = t[3] ? t[3].slice(1, -1) : "";
      return r2 = r2.trim(), this.rules.other.startAngleBracket.test(r2) && (this.options.pedantic && !this.rules.other.endAngleBracket.test(n) ? r2 = r2.slice(1) : r2 = r2.slice(1, -1)), fe(t, { href: r2 && r2.replace(this.rules.inline.anyPunctuation, "$1"), title: i && i.replace(this.rules.inline.anyPunctuation, "$1") }, t[0], this.lexer, this.rules);
    }
  }
  reflink(e, t) {
    let n;
    if ((n = this.rules.inline.reflink.exec(e)) || (n = this.rules.inline.nolink.exec(e))) {
      let r2 = (n[2] || n[1]).replace(this.rules.other.multipleSpaceGlobal, " "), i = t[r2.toLowerCase()];
      if (!i) {
        let s = n[0].charAt(0);
        return { type: "text", raw: s, text: s };
      }
      return fe(n, i, n[0], this.lexer, this.rules);
    }
  }
  emStrong(e, t, n = "") {
    let r2 = this.rules.inline.emStrongLDelim.exec(e);
    if (!r2 || r2[3] && n.match(this.rules.other.unicodeAlphaNumeric)) return;
    if (!(r2[1] || r2[2] || "") || !n || this.rules.inline.punctuation.exec(n)) {
      let s = [...r2[0]].length - 1, o, a, u = s, p = 0, c = r2[0][0] === "*" ? this.rules.inline.emStrongRDelimAst : this.rules.inline.emStrongRDelimUnd;
      for (c.lastIndex = 0, t = t.slice(-1 * e.length + s); (r2 = c.exec(t)) != null; ) {
        if (o = r2[1] || r2[2] || r2[3] || r2[4] || r2[5] || r2[6], !o) continue;
        if (a = [...o].length, r2[3] || r2[4]) {
          u += a;
          continue;
        } else if ((r2[5] || r2[6]) && s % 3 && !((s + a) % 3)) {
          p += a;
          continue;
        }
        if (u -= a, u > 0) continue;
        a = Math.min(a, a + u + p);
        let f = [...r2[0]][0].length, k = e.slice(0, s + r2.index + f + a);
        if (Math.min(s, a) % 2) {
          let g = k.slice(1, -1);
          return { type: "em", raw: k, text: g, tokens: this.lexer.inlineTokens(g) };
        }
        let x = k.slice(2, -2);
        return { type: "strong", raw: k, text: x, tokens: this.lexer.inlineTokens(x) };
      }
    }
  }
  codespan(e) {
    let t = this.rules.inline.code.exec(e);
    if (t) {
      let n = t[2].replace(this.rules.other.newLineCharGlobal, " "), r2 = this.rules.other.nonSpaceChar.test(n), i = this.rules.other.startingSpaceChar.test(n) && this.rules.other.endingSpaceChar.test(n);
      return r2 && i && (n = n.substring(1, n.length - 1)), { type: "codespan", raw: t[0], text: n };
    }
  }
  br(e) {
    let t = this.rules.inline.br.exec(e);
    if (t) return { type: "br", raw: t[0] };
  }
  del(e) {
    let t = this.rules.inline.del.exec(e);
    if (t) return { type: "del", raw: t[0], text: t[2], tokens: this.lexer.inlineTokens(t[2]) };
  }
  autolink(e) {
    let t = this.rules.inline.autolink.exec(e);
    if (t) {
      let n, r2;
      return t[2] === "@" ? (n = t[1], r2 = "mailto:" + n) : (n = t[1], r2 = n), { type: "link", raw: t[0], text: n, href: r2, tokens: [{ type: "text", raw: n, text: n }] };
    }
  }
  url(e) {
    var _a2, _b2;
    let t;
    if (t = this.rules.inline.url.exec(e)) {
      let n, r2;
      if (t[2] === "@") n = t[0], r2 = "mailto:" + n;
      else {
        let i;
        do
          i = t[0], t[0] = (_b2 = (_a2 = this.rules.inline._backpedal.exec(t[0])) == null ? void 0 : _a2[0]) != null ? _b2 : "";
        while (i !== t[0]);
        n = t[0], t[1] === "www." ? r2 = "http://" + t[0] : r2 = t[0];
      }
      return { type: "link", raw: t[0], text: n, href: r2, tokens: [{ type: "text", raw: n, text: n }] };
    }
  }
  inlineText(e) {
    let t = this.rules.inline.text.exec(e);
    if (t) {
      let n = this.lexer.state.inRawBlock;
      return { type: "text", raw: t[0], text: t[0], escaped: n };
    }
  }
};
var b = class l {
  constructor(e) {
    __publicField(this, "tokens");
    __publicField(this, "options");
    __publicField(this, "state");
    __publicField(this, "tokenizer");
    __publicField(this, "inlineQueue");
    this.tokens = [], this.tokens.links = /* @__PURE__ */ Object.create(null), this.options = e || O, this.options.tokenizer = this.options.tokenizer || new y(), this.tokenizer = this.options.tokenizer, this.tokenizer.options = this.options, this.tokenizer.lexer = this, this.inlineQueue = [], this.state = { inLink: false, inRawBlock: false, top: true };
    let t = { other: m, block: I.normal, inline: M.normal };
    this.options.pedantic ? (t.block = I.pedantic, t.inline = M.pedantic) : this.options.gfm && (t.block = I.gfm, this.options.breaks ? t.inline = M.breaks : t.inline = M.gfm), this.tokenizer.rules = t;
  }
  static get rules() {
    return { block: I, inline: M };
  }
  static lex(e, t) {
    return new l(t).lex(e);
  }
  static lexInline(e, t) {
    return new l(t).inlineTokens(e);
  }
  lex(e) {
    e = e.replace(m.carriageReturn, `
`), this.blockTokens(e, this.tokens);
    for (let t = 0; t < this.inlineQueue.length; t++) {
      let n = this.inlineQueue[t];
      this.inlineTokens(n.src, n.tokens);
    }
    return this.inlineQueue = [], this.tokens;
  }
  blockTokens(e, t = [], n = false) {
    var _a2, _b2, _c2;
    for (this.options.pedantic && (e = e.replace(m.tabCharGlobal, "    ").replace(m.spaceLine, "")); e; ) {
      let r2;
      if ((_b2 = (_a2 = this.options.extensions) == null ? void 0 : _a2.block) == null ? void 0 : _b2.some((s) => (r2 = s.call({ lexer: this }, e, t)) ? (e = e.substring(r2.raw.length), t.push(r2), true) : false)) continue;
      if (r2 = this.tokenizer.space(e)) {
        e = e.substring(r2.raw.length);
        let s = t.at(-1);
        r2.raw.length === 1 && s !== void 0 ? s.raw += `
` : t.push(r2);
        continue;
      }
      if (r2 = this.tokenizer.code(e)) {
        e = e.substring(r2.raw.length);
        let s = t.at(-1);
        (s == null ? void 0 : s.type) === "paragraph" || (s == null ? void 0 : s.type) === "text" ? (s.raw += (s.raw.endsWith(`
`) ? "" : `
`) + r2.raw, s.text += `
` + r2.text, this.inlineQueue.at(-1).src = s.text) : t.push(r2);
        continue;
      }
      if (r2 = this.tokenizer.fences(e)) {
        e = e.substring(r2.raw.length), t.push(r2);
        continue;
      }
      if (r2 = this.tokenizer.heading(e)) {
        e = e.substring(r2.raw.length), t.push(r2);
        continue;
      }
      if (r2 = this.tokenizer.hr(e)) {
        e = e.substring(r2.raw.length), t.push(r2);
        continue;
      }
      if (r2 = this.tokenizer.blockquote(e)) {
        e = e.substring(r2.raw.length), t.push(r2);
        continue;
      }
      if (r2 = this.tokenizer.list(e)) {
        e = e.substring(r2.raw.length), t.push(r2);
        continue;
      }
      if (r2 = this.tokenizer.html(e)) {
        e = e.substring(r2.raw.length), t.push(r2);
        continue;
      }
      if (r2 = this.tokenizer.def(e)) {
        e = e.substring(r2.raw.length);
        let s = t.at(-1);
        (s == null ? void 0 : s.type) === "paragraph" || (s == null ? void 0 : s.type) === "text" ? (s.raw += (s.raw.endsWith(`
`) ? "" : `
`) + r2.raw, s.text += `
` + r2.raw, this.inlineQueue.at(-1).src = s.text) : this.tokens.links[r2.tag] || (this.tokens.links[r2.tag] = { href: r2.href, title: r2.title });
        continue;
      }
      if (r2 = this.tokenizer.table(e)) {
        e = e.substring(r2.raw.length), t.push(r2);
        continue;
      }
      if (r2 = this.tokenizer.lheading(e)) {
        e = e.substring(r2.raw.length), t.push(r2);
        continue;
      }
      let i = e;
      if ((_c2 = this.options.extensions) == null ? void 0 : _c2.startBlock) {
        let s = 1 / 0, o = e.slice(1), a;
        this.options.extensions.startBlock.forEach((u) => {
          a = u.call({ lexer: this }, o), typeof a == "number" && a >= 0 && (s = Math.min(s, a));
        }), s < 1 / 0 && s >= 0 && (i = e.substring(0, s + 1));
      }
      if (this.state.top && (r2 = this.tokenizer.paragraph(i))) {
        let s = t.at(-1);
        n && (s == null ? void 0 : s.type) === "paragraph" ? (s.raw += (s.raw.endsWith(`
`) ? "" : `
`) + r2.raw, s.text += `
` + r2.text, this.inlineQueue.pop(), this.inlineQueue.at(-1).src = s.text) : t.push(r2), n = i.length !== e.length, e = e.substring(r2.raw.length);
        continue;
      }
      if (r2 = this.tokenizer.text(e)) {
        e = e.substring(r2.raw.length);
        let s = t.at(-1);
        (s == null ? void 0 : s.type) === "text" ? (s.raw += (s.raw.endsWith(`
`) ? "" : `
`) + r2.raw, s.text += `
` + r2.text, this.inlineQueue.pop(), this.inlineQueue.at(-1).src = s.text) : t.push(r2);
        continue;
      }
      if (e) {
        let s = "Infinite loop on byte: " + e.charCodeAt(0);
        if (this.options.silent) {
          console.error(s);
          break;
        } else throw new Error(s);
      }
    }
    return this.state.top = true, t;
  }
  inline(e, t = []) {
    return this.inlineQueue.push({ src: e, tokens: t }), t;
  }
  inlineTokens(e, t = []) {
    var _a2, _b2, _c2;
    let n = e, r2 = null;
    if (this.tokens.links) {
      let o = Object.keys(this.tokens.links);
      if (o.length > 0) for (; (r2 = this.tokenizer.rules.inline.reflinkSearch.exec(n)) != null; ) o.includes(r2[0].slice(r2[0].lastIndexOf("[") + 1, -1)) && (n = n.slice(0, r2.index) + "[" + "a".repeat(r2[0].length - 2) + "]" + n.slice(this.tokenizer.rules.inline.reflinkSearch.lastIndex));
    }
    for (; (r2 = this.tokenizer.rules.inline.anyPunctuation.exec(n)) != null; ) n = n.slice(0, r2.index) + "++" + n.slice(this.tokenizer.rules.inline.anyPunctuation.lastIndex);
    for (; (r2 = this.tokenizer.rules.inline.blockSkip.exec(n)) != null; ) n = n.slice(0, r2.index) + "[" + "a".repeat(r2[0].length - 2) + "]" + n.slice(this.tokenizer.rules.inline.blockSkip.lastIndex);
    let i = false, s = "";
    for (; e; ) {
      i || (s = ""), i = false;
      let o;
      if ((_b2 = (_a2 = this.options.extensions) == null ? void 0 : _a2.inline) == null ? void 0 : _b2.some((u) => (o = u.call({ lexer: this }, e, t)) ? (e = e.substring(o.raw.length), t.push(o), true) : false)) continue;
      if (o = this.tokenizer.escape(e)) {
        e = e.substring(o.raw.length), t.push(o);
        continue;
      }
      if (o = this.tokenizer.tag(e)) {
        e = e.substring(o.raw.length), t.push(o);
        continue;
      }
      if (o = this.tokenizer.link(e)) {
        e = e.substring(o.raw.length), t.push(o);
        continue;
      }
      if (o = this.tokenizer.reflink(e, this.tokens.links)) {
        e = e.substring(o.raw.length);
        let u = t.at(-1);
        o.type === "text" && (u == null ? void 0 : u.type) === "text" ? (u.raw += o.raw, u.text += o.text) : t.push(o);
        continue;
      }
      if (o = this.tokenizer.emStrong(e, n, s)) {
        e = e.substring(o.raw.length), t.push(o);
        continue;
      }
      if (o = this.tokenizer.codespan(e)) {
        e = e.substring(o.raw.length), t.push(o);
        continue;
      }
      if (o = this.tokenizer.br(e)) {
        e = e.substring(o.raw.length), t.push(o);
        continue;
      }
      if (o = this.tokenizer.del(e)) {
        e = e.substring(o.raw.length), t.push(o);
        continue;
      }
      if (o = this.tokenizer.autolink(e)) {
        e = e.substring(o.raw.length), t.push(o);
        continue;
      }
      if (!this.state.inLink && (o = this.tokenizer.url(e))) {
        e = e.substring(o.raw.length), t.push(o);
        continue;
      }
      let a = e;
      if ((_c2 = this.options.extensions) == null ? void 0 : _c2.startInline) {
        let u = 1 / 0, p = e.slice(1), c;
        this.options.extensions.startInline.forEach((f) => {
          c = f.call({ lexer: this }, p), typeof c == "number" && c >= 0 && (u = Math.min(u, c));
        }), u < 1 / 0 && u >= 0 && (a = e.substring(0, u + 1));
      }
      if (o = this.tokenizer.inlineText(a)) {
        e = e.substring(o.raw.length), o.raw.slice(-1) !== "_" && (s = o.raw.slice(-1)), i = true;
        let u = t.at(-1);
        (u == null ? void 0 : u.type) === "text" ? (u.raw += o.raw, u.text += o.text) : t.push(o);
        continue;
      }
      if (e) {
        let u = "Infinite loop on byte: " + e.charCodeAt(0);
        if (this.options.silent) {
          console.error(u);
          break;
        } else throw new Error(u);
      }
    }
    return t;
  }
};
var P = class {
  constructor(e) {
    __publicField(this, "options");
    __publicField(this, "parser");
    this.options = e || O;
  }
  space(e) {
    return "";
  }
  code({ text: e, lang: t, escaped: n }) {
    var _a2;
    let r2 = (_a2 = (t || "").match(m.notSpaceStart)) == null ? void 0 : _a2[0], i = e.replace(m.endingNewline, "") + `
`;
    return r2 ? '<pre><code class="language-' + w(r2) + '">' + (n ? i : w(i, true)) + `</code></pre>
` : "<pre><code>" + (n ? i : w(i, true)) + `</code></pre>
`;
  }
  blockquote({ tokens: e }) {
    return `<blockquote>
${this.parser.parse(e)}</blockquote>
`;
  }
  html({ text: e }) {
    return e;
  }
  heading({ tokens: e, depth: t }) {
    return `<h${t}>${this.parser.parseInline(e)}</h${t}>
`;
  }
  hr(e) {
    return `<hr>
`;
  }
  list(e) {
    let t = e.ordered, n = e.start, r2 = "";
    for (let o = 0; o < e.items.length; o++) {
      let a = e.items[o];
      r2 += this.listitem(a);
    }
    let i = t ? "ol" : "ul", s = t && n !== 1 ? ' start="' + n + '"' : "";
    return "<" + i + s + `>
` + r2 + "</" + i + `>
`;
  }
  listitem(e) {
    var _a2;
    let t = "";
    if (e.task) {
      let n = this.checkbox({ checked: !!e.checked });
      e.loose ? ((_a2 = e.tokens[0]) == null ? void 0 : _a2.type) === "paragraph" ? (e.tokens[0].text = n + " " + e.tokens[0].text, e.tokens[0].tokens && e.tokens[0].tokens.length > 0 && e.tokens[0].tokens[0].type === "text" && (e.tokens[0].tokens[0].text = n + " " + w(e.tokens[0].tokens[0].text), e.tokens[0].tokens[0].escaped = true)) : e.tokens.unshift({ type: "text", raw: n + " ", text: n + " ", escaped: true }) : t += n + " ";
    }
    return t += this.parser.parse(e.tokens, !!e.loose), `<li>${t}</li>
`;
  }
  checkbox({ checked: e }) {
    return "<input " + (e ? 'checked="" ' : "") + 'disabled="" type="checkbox">';
  }
  paragraph({ tokens: e }) {
    return `<p>${this.parser.parseInline(e)}</p>
`;
  }
  table(e) {
    let t = "", n = "";
    for (let i = 0; i < e.header.length; i++) n += this.tablecell(e.header[i]);
    t += this.tablerow({ text: n });
    let r2 = "";
    for (let i = 0; i < e.rows.length; i++) {
      let s = e.rows[i];
      n = "";
      for (let o = 0; o < s.length; o++) n += this.tablecell(s[o]);
      r2 += this.tablerow({ text: n });
    }
    return r2 && (r2 = `<tbody>${r2}</tbody>`), `<table>
<thead>
` + t + `</thead>
` + r2 + `</table>
`;
  }
  tablerow({ text: e }) {
    return `<tr>
${e}</tr>
`;
  }
  tablecell(e) {
    let t = this.parser.parseInline(e.tokens), n = e.header ? "th" : "td";
    return (e.align ? `<${n} align="${e.align}">` : `<${n}>`) + t + `</${n}>
`;
  }
  strong({ tokens: e }) {
    return `<strong>${this.parser.parseInline(e)}</strong>`;
  }
  em({ tokens: e }) {
    return `<em>${this.parser.parseInline(e)}</em>`;
  }
  codespan({ text: e }) {
    return `<code>${w(e, true)}</code>`;
  }
  br(e) {
    return "<br>";
  }
  del({ tokens: e }) {
    return `<del>${this.parser.parseInline(e)}</del>`;
  }
  link({ href: e, title: t, tokens: n }) {
    let r2 = this.parser.parseInline(n), i = J(e);
    if (i === null) return r2;
    e = i;
    let s = '<a href="' + e + '"';
    return t && (s += ' title="' + w(t) + '"'), s += ">" + r2 + "</a>", s;
  }
  image({ href: e, title: t, text: n, tokens: r2 }) {
    r2 && (n = this.parser.parseInline(r2, this.parser.textRenderer));
    let i = J(e);
    if (i === null) return w(n);
    e = i;
    let s = `<img src="${e}" alt="${n}"`;
    return t && (s += ` title="${w(t)}"`), s += ">", s;
  }
  text(e) {
    return "tokens" in e && e.tokens ? this.parser.parseInline(e.tokens) : "escaped" in e && e.escaped ? e.text : w(e.text);
  }
};
var S = class {
  strong({ text: e }) {
    return e;
  }
  em({ text: e }) {
    return e;
  }
  codespan({ text: e }) {
    return e;
  }
  del({ text: e }) {
    return e;
  }
  html({ text: e }) {
    return e;
  }
  text({ text: e }) {
    return e;
  }
  link({ text: e }) {
    return "" + e;
  }
  image({ text: e }) {
    return "" + e;
  }
  br() {
    return "";
  }
};
var R = class l2 {
  constructor(e) {
    __publicField(this, "options");
    __publicField(this, "renderer");
    __publicField(this, "textRenderer");
    this.options = e || O, this.options.renderer = this.options.renderer || new P(), this.renderer = this.options.renderer, this.renderer.options = this.options, this.renderer.parser = this, this.textRenderer = new S();
  }
  static parse(e, t) {
    return new l2(t).parse(e);
  }
  static parseInline(e, t) {
    return new l2(t).parseInline(e);
  }
  parse(e, t = true) {
    var _a2, _b2;
    let n = "";
    for (let r2 = 0; r2 < e.length; r2++) {
      let i = e[r2];
      if ((_b2 = (_a2 = this.options.extensions) == null ? void 0 : _a2.renderers) == null ? void 0 : _b2[i.type]) {
        let o = i, a = this.options.extensions.renderers[o.type].call({ parser: this }, o);
        if (a !== false || !["space", "hr", "heading", "code", "table", "blockquote", "list", "html", "paragraph", "text"].includes(o.type)) {
          n += a || "";
          continue;
        }
      }
      let s = i;
      switch (s.type) {
        case "space": {
          n += this.renderer.space(s);
          continue;
        }
        case "hr": {
          n += this.renderer.hr(s);
          continue;
        }
        case "heading": {
          n += this.renderer.heading(s);
          continue;
        }
        case "code": {
          n += this.renderer.code(s);
          continue;
        }
        case "table": {
          n += this.renderer.table(s);
          continue;
        }
        case "blockquote": {
          n += this.renderer.blockquote(s);
          continue;
        }
        case "list": {
          n += this.renderer.list(s);
          continue;
        }
        case "html": {
          n += this.renderer.html(s);
          continue;
        }
        case "paragraph": {
          n += this.renderer.paragraph(s);
          continue;
        }
        case "text": {
          let o = s, a = this.renderer.text(o);
          for (; r2 + 1 < e.length && e[r2 + 1].type === "text"; ) o = e[++r2], a += `
` + this.renderer.text(o);
          t ? n += this.renderer.paragraph({ type: "paragraph", raw: a, text: a, tokens: [{ type: "text", raw: a, text: a, escaped: true }] }) : n += a;
          continue;
        }
        default: {
          let o = 'Token with "' + s.type + '" type was not found.';
          if (this.options.silent) return console.error(o), "";
          throw new Error(o);
        }
      }
    }
    return n;
  }
  parseInline(e, t = this.renderer) {
    var _a2, _b2;
    let n = "";
    for (let r2 = 0; r2 < e.length; r2++) {
      let i = e[r2];
      if ((_b2 = (_a2 = this.options.extensions) == null ? void 0 : _a2.renderers) == null ? void 0 : _b2[i.type]) {
        let o = this.options.extensions.renderers[i.type].call({ parser: this }, i);
        if (o !== false || !["escape", "html", "link", "image", "strong", "em", "codespan", "br", "del", "text"].includes(i.type)) {
          n += o || "";
          continue;
        }
      }
      let s = i;
      switch (s.type) {
        case "escape": {
          n += t.text(s);
          break;
        }
        case "html": {
          n += t.html(s);
          break;
        }
        case "link": {
          n += t.link(s);
          break;
        }
        case "image": {
          n += t.image(s);
          break;
        }
        case "strong": {
          n += t.strong(s);
          break;
        }
        case "em": {
          n += t.em(s);
          break;
        }
        case "codespan": {
          n += t.codespan(s);
          break;
        }
        case "br": {
          n += t.br(s);
          break;
        }
        case "del": {
          n += t.del(s);
          break;
        }
        case "text": {
          n += t.text(s);
          break;
        }
        default: {
          let o = 'Token with "' + s.type + '" type was not found.';
          if (this.options.silent) return console.error(o), "";
          throw new Error(o);
        }
      }
    }
    return n;
  }
};
var $ = (_d = class {
  constructor(e) {
    __publicField(this, "options");
    __publicField(this, "block");
    this.options = e || O;
  }
  preprocess(e) {
    return e;
  }
  postprocess(e) {
    return e;
  }
  processAllTokens(e) {
    return e;
  }
  provideLexer() {
    return this.block ? b.lex : b.lexInline;
  }
  provideParser() {
    return this.block ? R.parse : R.parseInline;
  }
}, __publicField(_d, "passThroughHooks", /* @__PURE__ */ new Set(["preprocess", "postprocess", "processAllTokens"])), _d);
var B = class {
  constructor(...e) {
    __publicField(this, "defaults", L());
    __publicField(this, "options", this.setOptions);
    __publicField(this, "parse", this.parseMarkdown(true));
    __publicField(this, "parseInline", this.parseMarkdown(false));
    __publicField(this, "Parser", R);
    __publicField(this, "Renderer", P);
    __publicField(this, "TextRenderer", S);
    __publicField(this, "Lexer", b);
    __publicField(this, "Tokenizer", y);
    __publicField(this, "Hooks", $);
    this.use(...e);
  }
  walkTokens(e, t) {
    var _a2, _b2;
    let n = [];
    for (let r2 of e) switch (n = n.concat(t.call(this, r2)), r2.type) {
      case "table": {
        let i = r2;
        for (let s of i.header) n = n.concat(this.walkTokens(s.tokens, t));
        for (let s of i.rows) for (let o of s) n = n.concat(this.walkTokens(o.tokens, t));
        break;
      }
      case "list": {
        let i = r2;
        n = n.concat(this.walkTokens(i.items, t));
        break;
      }
      default: {
        let i = r2;
        ((_b2 = (_a2 = this.defaults.extensions) == null ? void 0 : _a2.childTokens) == null ? void 0 : _b2[i.type]) ? this.defaults.extensions.childTokens[i.type].forEach((s) => {
          let o = i[s].flat(1 / 0);
          n = n.concat(this.walkTokens(o, t));
        }) : i.tokens && (n = n.concat(this.walkTokens(i.tokens, t)));
      }
    }
    return n;
  }
  use(...e) {
    let t = this.defaults.extensions || { renderers: {}, childTokens: {} };
    return e.forEach((n) => {
      let r2 = __spreadValues({}, n);
      if (r2.async = this.defaults.async || r2.async || false, n.extensions && (n.extensions.forEach((i) => {
        if (!i.name) throw new Error("extension name required");
        if ("renderer" in i) {
          let s = t.renderers[i.name];
          s ? t.renderers[i.name] = function(...o) {
            let a = i.renderer.apply(this, o);
            return a === false && (a = s.apply(this, o)), a;
          } : t.renderers[i.name] = i.renderer;
        }
        if ("tokenizer" in i) {
          if (!i.level || i.level !== "block" && i.level !== "inline") throw new Error("extension level must be 'block' or 'inline'");
          let s = t[i.level];
          s ? s.unshift(i.tokenizer) : t[i.level] = [i.tokenizer], i.start && (i.level === "block" ? t.startBlock ? t.startBlock.push(i.start) : t.startBlock = [i.start] : i.level === "inline" && (t.startInline ? t.startInline.push(i.start) : t.startInline = [i.start]));
        }
        "childTokens" in i && i.childTokens && (t.childTokens[i.name] = i.childTokens);
      }), r2.extensions = t), n.renderer) {
        let i = this.defaults.renderer || new P(this.defaults);
        for (let s in n.renderer) {
          if (!(s in i)) throw new Error(`renderer '${s}' does not exist`);
          if (["options", "parser"].includes(s)) continue;
          let o = s, a = n.renderer[o], u = i[o];
          i[o] = (...p) => {
            let c = a.apply(i, p);
            return c === false && (c = u.apply(i, p)), c || "";
          };
        }
        r2.renderer = i;
      }
      if (n.tokenizer) {
        let i = this.defaults.tokenizer || new y(this.defaults);
        for (let s in n.tokenizer) {
          if (!(s in i)) throw new Error(`tokenizer '${s}' does not exist`);
          if (["options", "rules", "lexer"].includes(s)) continue;
          let o = s, a = n.tokenizer[o], u = i[o];
          i[o] = (...p) => {
            let c = a.apply(i, p);
            return c === false && (c = u.apply(i, p)), c;
          };
        }
        r2.tokenizer = i;
      }
      if (n.hooks) {
        let i = this.defaults.hooks || new $();
        for (let s in n.hooks) {
          if (!(s in i)) throw new Error(`hook '${s}' does not exist`);
          if (["options", "block"].includes(s)) continue;
          let o = s, a = n.hooks[o], u = i[o];
          $.passThroughHooks.has(s) ? i[o] = (p) => {
            if (this.defaults.async) return Promise.resolve(a.call(i, p)).then((f) => u.call(i, f));
            let c = a.call(i, p);
            return u.call(i, c);
          } : i[o] = (...p) => {
            let c = a.apply(i, p);
            return c === false && (c = u.apply(i, p)), c;
          };
        }
        r2.hooks = i;
      }
      if (n.walkTokens) {
        let i = this.defaults.walkTokens, s = n.walkTokens;
        r2.walkTokens = function(o) {
          let a = [];
          return a.push(s.call(this, o)), i && (a = a.concat(i.call(this, o))), a;
        };
      }
      this.defaults = __spreadValues(__spreadValues({}, this.defaults), r2);
    }), this;
  }
  setOptions(e) {
    return this.defaults = __spreadValues(__spreadValues({}, this.defaults), e), this;
  }
  lexer(e, t) {
    return b.lex(e, t != null ? t : this.defaults);
  }
  parser(e, t) {
    return R.parse(e, t != null ? t : this.defaults);
  }
  parseMarkdown(e) {
    return (n, r2) => {
      let i = __spreadValues({}, r2), s = __spreadValues(__spreadValues({}, this.defaults), i), o = this.onError(!!s.silent, !!s.async);
      if (this.defaults.async === true && i.async === false) return o(new Error("marked(): The async option was set to true by an extension. Remove async: false from the parse options object to return a Promise."));
      if (typeof n > "u" || n === null) return o(new Error("marked(): input parameter is undefined or null"));
      if (typeof n != "string") return o(new Error("marked(): input parameter is of type " + Object.prototype.toString.call(n) + ", string expected"));
      s.hooks && (s.hooks.options = s, s.hooks.block = e);
      let a = s.hooks ? s.hooks.provideLexer() : e ? b.lex : b.lexInline, u = s.hooks ? s.hooks.provideParser() : e ? R.parse : R.parseInline;
      if (s.async) return Promise.resolve(s.hooks ? s.hooks.preprocess(n) : n).then((p) => a(p, s)).then((p) => s.hooks ? s.hooks.processAllTokens(p) : p).then((p) => s.walkTokens ? Promise.all(this.walkTokens(p, s.walkTokens)).then(() => p) : p).then((p) => u(p, s)).then((p) => s.hooks ? s.hooks.postprocess(p) : p).catch(o);
      try {
        s.hooks && (n = s.hooks.preprocess(n));
        let p = a(n, s);
        s.hooks && (p = s.hooks.processAllTokens(p)), s.walkTokens && this.walkTokens(p, s.walkTokens);
        let c = u(p, s);
        return s.hooks && (c = s.hooks.postprocess(c)), c;
      } catch (p) {
        return o(p);
      }
    };
  }
  onError(e, t) {
    return (n) => {
      if (n.message += `
Please report this to https://github.com/markedjs/marked.`, e) {
        let r2 = "<p>An error occurred:</p><pre>" + w(n.message + "", true) + "</pre>";
        return t ? Promise.resolve(r2) : r2;
      }
      if (t) return Promise.reject(n);
      throw n;
    };
  }
};
var _ = new B();
function d(l3, e) {
  return _.parse(l3, e);
}
d.options = d.setOptions = function(l3) {
  return _.setOptions(l3), d.defaults = _.defaults, H(d.defaults), d;
};
d.getDefaults = L;
d.defaults = O;
d.use = function(...l3) {
  return _.use(...l3), d.defaults = _.defaults, H(d.defaults), d;
};
d.walkTokens = function(l3, e) {
  return _.walkTokens(l3, e);
};
d.parseInline = _.parseInline;
d.Parser = R;
d.parser = R.parse;
d.Renderer = P;
d.TextRenderer = S;
d.Lexer = b;
d.lexer = b.lex;
d.Tokenizer = y;
d.Hooks = $;
d.parse = d;
d.options;
d.setOptions;
d.use;
d.walkTokens;
d.parseInline;
R.parse;
b.lex;
var root$a = /* @__PURE__ */ from_html(`<div><!></div>`);
function MarkdownDisplay($$anchor, $$props) {
  push($$props, true);
  let renderedContent = /* @__PURE__ */ user_derived(() => d.parse($$props.content || ""));
  let displayClass = /* @__PURE__ */ user_derived(() => $$props.className || "markdown-display");
  var div = root$a();
  var node = child(div);
  html(node, () => get$3(renderedContent));
  template_effect(() => set_class(div, 1, clsx(get$3(displayClass))));
  append($$anchor, div);
  pop();
}
function handleContentChange(event2, noteContent, props, $$props, dispatch2) {
  const target = event2.target;
  set$2(noteContent, target.value, true);
  if ($$props.data.config) {
    $$props.data.config.content = target.value;
    dispatch2("configChange", { config: $$props.data.config });
  }
}
function handleTypeChange(event2, noteType, props, $$props, dispatch2) {
  const target = event2.target;
  set$2(noteType, target.value, true);
  if ($$props.data.config) {
    $$props.data.config.noteType = target.value;
    dispatch2("configChange", { config: $$props.data.config });
  }
}
function toggleEditMode(_2, isInternalEditing, dispatch2) {
  set$2(isInternalEditing, !get$3(isInternalEditing));
  dispatch2("editModeChange", { isEditing: get$3(isInternalEditing) });
}
function handleNodeClick() {
}
function handleKeydown$3(event2, handleDoubleClick2) {
  if (event2.key === "Enter" || event2.key === " ") {
    event2.preventDefault();
    handleDoubleClick2();
  }
}
var root_2$4 = /* @__PURE__ */ from_html(`<option> </option>`);
var root_1$6 = /* @__PURE__ */ from_html(`<div class="flowdrop-notes-node__edit svelte-18deed4"><div class="flowdrop-notes-node__type-selector svelte-18deed4"><label for="note-type" class="flowdrop-notes-node__label svelte-18deed4">Note Type:</label> <select id="note-type" class="flowdrop-notes-node__select svelte-18deed4"></select></div> <div class="flowdrop-notes-node__textarea-container svelte-18deed4"><label for="note-content" class="flowdrop-notes-node__label svelte-18deed4">Content (Markdown):</label> <textarea id="note-content" class="flowdrop-notes-node__textarea svelte-18deed4" placeholder="Write your note in Markdown..."></textarea></div> <div class="flowdrop-notes-node__edit-actions svelte-18deed4"><button class="flowdrop-notes-node__btn flowdrop-notes-node__btn--save svelte-18deed4"><!> Save</button> <button class="flowdrop-notes-node__btn flowdrop-notes-node__btn--cancel svelte-18deed4"><!> Cancel</button></div></div>`);
var root_4$3 = /* @__PURE__ */ from_html(`<div class="flowdrop-notes-node__processing svelte-18deed4"><div class="flowdrop-notes-node__spinner svelte-18deed4"></div> <span>Processing...</span></div>`);
var root_5$3 = /* @__PURE__ */ from_html(`<div class="flowdrop-notes-node__error svelte-18deed4"><!> <span>Error occurred</span></div>`);
var root_3$7 = /* @__PURE__ */ from_html(`<div><div class="flowdrop-notes-node__header svelte-18deed4"><div class="flowdrop-notes-node__header-left svelte-18deed4"><!> <span class="flowdrop-notes-node__type svelte-18deed4"> </span></div> <button class="flowdrop-notes-node__edit-btn svelte-18deed4" title="Edit note"><!></button></div> <div class="flowdrop-notes-node__body svelte-18deed4"><!></div> <!> <!></div>`);
var root$9 = /* @__PURE__ */ from_html(`<div role="button" tabindex="0"><!> <button class="flowdrop-notes-node__config-btn svelte-18deed4" title="Configure note"><!></button></div>`);
function NotesNode($$anchor, $$props) {
  var _a2, _b2;
  push($$props, true);
  const dispatch2 = createEventDispatcher();
  const props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]);
  let isInternalEditing = /* @__PURE__ */ state(false);
  let noteContent = /* @__PURE__ */ state(proxy(((_a2 = $$props.data.config) == null ? void 0 : _a2.content) || "Add your notes here..."));
  let noteType = /* @__PURE__ */ state(proxy(((_b2 = $$props.data.config) == null ? void 0 : _b2.noteType) || "info"));
  user_effect(() => {
    var _a3, _b3;
    const newContent = ((_a3 = $$props.data.config) == null ? void 0 : _a3.content) || "Add your notes here...";
    const newType = ((_b3 = $$props.data.config) == null ? void 0 : _b3.noteType) || "info";
    if (get$3(noteContent) !== newContent) {
      set$2(noteContent, newContent, true);
    }
    if (get$3(noteType) !== newType) {
      set$2(noteType, newType, true);
    }
  });
  const noteTypes = {
    info: {
      name: "Info",
      bgColor: "bg-blue-50",
      borderColor: "border-blue-200",
      textColor: "text-blue-800",
      iconColor: "text-blue-500",
      icon: "mdi:information"
    },
    warning: {
      name: "Warning",
      bgColor: "bg-yellow-50",
      borderColor: "border-yellow-200",
      textColor: "text-yellow-800",
      iconColor: "text-yellow-500",
      icon: "mdi:alert"
    },
    success: {
      name: "Success",
      bgColor: "bg-green-50",
      borderColor: "border-green-200",
      textColor: "text-green-800",
      iconColor: "text-green-500",
      icon: "mdi:check-circle"
    },
    error: {
      name: "Error",
      bgColor: "bg-red-50",
      borderColor: "border-red-200",
      textColor: "text-red-800",
      iconColor: "text-red-500",
      icon: "mdi:close-circle"
    },
    note: {
      name: "Note",
      bgColor: "bg-gray-50",
      borderColor: "border-gray-200",
      textColor: "text-gray-800",
      iconColor: "text-gray-500",
      icon: "mdi:note-text"
    }
  };
  let currentType = /* @__PURE__ */ user_derived(() => noteTypes[get$3(noteType)] || noteTypes.info);
  function openConfigSidebar() {
    if ($$props.data.onConfigOpen) {
      const nodeForConfig = {
        id: $$props.data.nodeId || "unknown",
        type: "note",
        data: $$props.data
      };
      $$props.data.onConfigOpen(nodeForConfig);
    }
  }
  function handleDoubleClick2() {
    openConfigSidebar();
  }
  var div = root$9();
  let classes;
  div.__click = [handleNodeClick];
  div.__dblclick = handleDoubleClick2;
  div.__keydown = [handleKeydown$3, handleDoubleClick2];
  var node = child(div);
  {
    var consequent = ($$anchor2) => {
      var div_1 = root_1$6();
      var div_2 = child(div_1);
      var select2 = sibling(child(div_2), 2);
      select2.__change = [
        handleTypeChange,
        noteType,
        props,
        $$props,
        dispatch2
      ];
      each(select2, 21, () => Object.entries(noteTypes), ([key2, type]) => key2, ($$anchor3, $$item) => {
        var $$array = /* @__PURE__ */ user_derived(() => to_array(get$3($$item), 2));
        let key2 = () => get$3($$array)[0];
        let type = () => get$3($$array)[1];
        var option = root_2$4();
        var text2 = child(option);
        var option_value = {};
        template_effect(() => {
          var _a3;
          set_text(text2, type().name);
          if (option_value !== (option_value = key2())) {
            option.value = (_a3 = option.__value = key2()) != null ? _a3 : "";
          }
        });
        append($$anchor3, option);
      });
      var select_value;
      init_select(select2);
      var div_3 = sibling(div_2, 2);
      var textarea = sibling(child(div_3), 2);
      textarea.__input = [
        handleContentChange,
        noteContent,
        props,
        $$props,
        dispatch2
      ];
      var div_4 = sibling(div_3, 2);
      var button = child(div_4);
      button.__click = [toggleEditMode, isInternalEditing, dispatch2];
      var node_1 = child(button);
      Icon(node_1, { icon: "mdi:check" });
      var button_1 = sibling(button, 2);
      button_1.__click = [toggleEditMode, isInternalEditing, dispatch2];
      var node_2 = child(button_1);
      Icon(node_2, { icon: "mdi:close" });
      template_effect(() => {
        var _a3;
        if (select_value !== (select_value = get$3(noteType))) {
          select2.value = (_a3 = select2.__value = get$3(noteType)) != null ? _a3 : "", select_option(select2, get$3(noteType));
        }
        set_value(textarea, get$3(noteContent));
      });
      append($$anchor2, div_1);
    };
    var alternate = ($$anchor2) => {
      var div_5 = root_3$7();
      var div_6 = child(div_5);
      var div_7 = child(div_6);
      var node_3 = child(div_7);
      Icon(node_3, {
        get icon() {
          return get$3(currentType).icon;
        },
        get class() {
          var _a3;
          return `flowdrop-notes-node__icon ${(_a3 = get$3(currentType).iconColor) != null ? _a3 : ""}`;
        }
      });
      var span = sibling(node_3, 2);
      var text_1 = child(span);
      var button_2 = sibling(div_7, 2);
      button_2.__click = [toggleEditMode, isInternalEditing, dispatch2];
      var node_4 = child(button_2);
      Icon(node_4, { icon: "mdi:pencil" });
      var div_8 = sibling(div_6, 2);
      var node_5 = child(div_8);
      MarkdownDisplay(node_5, {
        get content() {
          return get$3(noteContent);
        },
        className: "flowdrop-notes-node__markdown"
      });
      var node_6 = sibling(div_8, 2);
      {
        var consequent_1 = ($$anchor3) => {
          var div_9 = root_4$3();
          append($$anchor3, div_9);
        };
        if_block(node_6, ($$render) => {
          if ($$props.isProcessing) $$render(consequent_1);
        });
      }
      var node_7 = sibling(node_6, 2);
      {
        var consequent_2 = ($$anchor3) => {
          var div_10 = root_5$3();
          var node_8 = child(div_10);
          Icon(node_8, {
            icon: "mdi:alert-circle",
            class: "flowdrop-notes-node__error-icon"
          });
          append($$anchor3, div_10);
        };
        if_block(node_7, ($$render) => {
          if ($$props.isError) $$render(consequent_2);
        });
      }
      template_effect(() => {
        var _a3, _b3;
        set_class(div_5, 1, `flowdrop-notes-node__content ${(_a3 = get$3(currentType).borderColor) != null ? _a3 : ""} ${(_b3 = get$3(currentType).textColor) != null ? _b3 : ""}`, "svelte-18deed4");
        set_text(text_1, get$3(currentType).name);
      });
      append($$anchor2, div_5);
    };
    if_block(node, ($$render) => {
      if (get$3(isInternalEditing) || $$props.isEditing) $$render(consequent);
      else $$render(alternate, false);
    });
  }
  var button_3 = sibling(node, 2);
  button_3.__click = openConfigSidebar;
  var node_9 = child(button_3);
  Icon(node_9, { icon: "mdi:cog" });
  template_effect(($0) => {
    var _a3;
    return classes = set_class(div, 1, `flowdrop-notes-node ${(_a3 = get$3(currentType).bgColor) != null ? _a3 : ""}`, "svelte-18deed4", classes, $0);
  }, [
    () => ({
      "flowdrop-notes-node--selected": $$props.selected,
      "flowdrop-notes-node--processing": $$props.isProcessing,
      "flowdrop-notes-node--error": $$props.isError
    })
  ]);
  append($$anchor, div);
  pop();
}
delegate([
  "click",
  "dblclick",
  "keydown",
  "change",
  "input"
]);
function handleClick$2() {
}
function handleKeydown$2(event2, handleDoubleClick2) {
  if (event2.key === "Enter" || event2.key === " ") {
    event2.preventDefault();
    handleDoubleClick2();
  }
}
var root_2$3 = /* @__PURE__ */ from_html(`<div class="flowdrop-simple-node__compact-content svelte-h9lyqy"><!></div>`);
var root_3$6 = /* @__PURE__ */ from_html(`<div class="flowdrop-simple-node__header svelte-h9lyqy"><div class="flowdrop-simple-node__header-content svelte-h9lyqy"><div class="flowdrop-simple-node__icon-container svelte-h9lyqy"><!></div> <h3 class="flowdrop-simple-node__title svelte-h9lyqy"> </h3></div> <p class="flowdrop-simple-node__description svelte-h9lyqy"> </p></div>`);
var root_4$2 = /* @__PURE__ */ from_html(`<div class="flowdrop-simple-node__processing svelte-h9lyqy"><div class="flowdrop-simple-node__spinner svelte-h9lyqy"></div></div>`);
var root_5$2 = /* @__PURE__ */ from_html(`<div class="flowdrop-simple-node__error svelte-h9lyqy"><!></div>`);
var root$8 = /* @__PURE__ */ from_html(`<!> <div role="button" tabindex="0"><!> <!> <!> <button class="flowdrop-simple-node__config-btn svelte-h9lyqy" title="Configure node"><!></button></div> <!>`, 1);
function SimpleNode($$anchor, $$props) {
  push($$props, true);
  let nodeIcon = /* @__PURE__ */ user_derived(() => {
    var _a2, _b2;
    return ((_a2 = $$props.data.metadata) == null ? void 0 : _a2.icon) || ((_b2 = $$props.data.config) == null ? void 0 : _b2.icon) || "mdi:square";
  });
  let nodeColor = /* @__PURE__ */ user_derived(() => {
    var _a2, _b2;
    return ((_a2 = $$props.data.metadata) == null ? void 0 : _a2.color) || ((_b2 = $$props.data.config) == null ? void 0 : _b2.color) || "#6366f1";
  });
  let nodeLayout = /* @__PURE__ */ user_derived(() => {
    var _a2;
    return ((_a2 = $$props.data.config) == null ? void 0 : _a2.layout) || "normal";
  });
  const layoutConfig = {
    compact: {
      width: "80px",
      height: "80px",
      iconSize: "2rem",
      showHeader: false
    },
    normal: {
      width: "18rem",
      height: "auto",
      iconSize: "1rem",
      showHeader: true
    }
  };
  let currentLayout = /* @__PURE__ */ user_derived(() => layoutConfig[get$3(nodeLayout)] || layoutConfig.normal);
  let isCompact = /* @__PURE__ */ user_derived(() => get$3(nodeLayout) === "compact");
  function openConfigSidebar() {
    if ($$props.data.onConfigOpen) {
      const nodeForConfig = {
        id: $$props.data.nodeId || "unknown",
        type: "simple",
        data: $$props.data
      };
      $$props.data.onConfigOpen(nodeForConfig);
    }
  }
  function handleDoubleClick2() {
    openConfigSidebar();
  }
  let firstInputPort = /* @__PURE__ */ user_derived(() => {
    var _a2, _b2;
    return (_b2 = (_a2 = $$props.data.metadata) == null ? void 0 : _a2.inputs) == null ? void 0 : _b2[0];
  });
  let firstOutputPort = /* @__PURE__ */ user_derived(() => {
    var _a2, _b2;
    return (_b2 = (_a2 = $$props.data.metadata) == null ? void 0 : _a2.outputs) == null ? void 0 : _b2[0];
  });
  let hasInput = /* @__PURE__ */ user_derived(() => !!get$3(firstInputPort));
  let hasOutput = /* @__PURE__ */ user_derived(() => !!get$3(firstOutputPort));
  var fragment = root$8();
  var node = first_child(fragment);
  {
    var consequent = ($$anchor2) => {
      const expression = /* @__PURE__ */ user_derived(() => getDataTypeColor(get$3(firstInputPort).dataType));
      const expression_1 = /* @__PURE__ */ user_derived(() => `${$$props.data.nodeId}-input-${get$3(firstInputPort).id}`);
      Handle($$anchor2, {
        type: "target",
        get position() {
          return Position.Left;
        },
        get style() {
          var _a2;
          return `background-color: ${(_a2 = get$3(expression)) != null ? _a2 : ""}; border-color: '#ffffff';`;
        },
        get id() {
          return get$3(expression_1);
        }
      });
    };
    if_block(node, ($$render) => {
      if (get$3(hasInput) && get$3(firstInputPort)) $$render(consequent);
    });
  }
  var div = sibling(node, 2);
  let classes;
  div.__click = [handleClick$2];
  div.__dblclick = handleDoubleClick2;
  div.__keydown = [handleKeydown$2, handleDoubleClick2];
  var node_1 = child(div);
  {
    var consequent_1 = ($$anchor2) => {
      var div_1 = root_2$3();
      var node_2 = child(div_1);
      Icon(node_2, {
        get icon() {
          return get$3(nodeIcon);
        },
        class: "flowdrop-simple-node__compact-icon",
        get style() {
          var _a2, _b2;
          return `color: ${(_a2 = get$3(nodeColor)) != null ? _a2 : ""}; font-size: ${(_b2 = get$3(currentLayout).iconSize) != null ? _b2 : ""};`;
        }
      });
      append($$anchor2, div_1);
    };
    var alternate = ($$anchor2) => {
      var div_2 = root_3$6();
      var div_3 = child(div_2);
      var div_4 = child(div_3);
      var node_3 = child(div_4);
      Icon(node_3, {
        get icon() {
          return get$3(nodeIcon);
        },
        class: "flowdrop-simple-node__icon"
      });
      var h3 = sibling(div_4, 2);
      var text2 = child(h3);
      var p = sibling(div_3, 2);
      var text_1 = child(p);
      template_effect(() => {
        var _a2, _b2;
        set_style(div_4, `background-color: ${(_a2 = get$3(nodeColor)) != null ? _a2 : ""}`);
        set_text(text2, $$props.data.label);
        set_text(text_1, ((_b2 = $$props.data.metadata) == null ? void 0 : _b2.description) || "A configurable simple node");
      });
      append($$anchor2, div_2);
    };
    if_block(node_1, ($$render) => {
      if (get$3(isCompact)) $$render(consequent_1);
      else $$render(alternate, false);
    });
  }
  var node_4 = sibling(node_1, 2);
  {
    var consequent_2 = ($$anchor2) => {
      var div_5 = root_4$2();
      append($$anchor2, div_5);
    };
    if_block(node_4, ($$render) => {
      if ($$props.isProcessing) $$render(consequent_2);
    });
  }
  var node_5 = sibling(node_4, 2);
  {
    var consequent_3 = ($$anchor2) => {
      var div_6 = root_5$2();
      var node_6 = child(div_6);
      Icon(node_6, {
        icon: "mdi:alert-circle",
        class: "flowdrop-simple-node__error-icon"
      });
      append($$anchor2, div_6);
    };
    if_block(node_5, ($$render) => {
      if ($$props.isError) $$render(consequent_3);
    });
  }
  var button = sibling(node_5, 2);
  button.__click = openConfigSidebar;
  var node_7 = child(button);
  Icon(node_7, { icon: "mdi:cog" });
  var node_8 = sibling(div, 2);
  {
    var consequent_4 = ($$anchor2) => {
      const expression_2 = /* @__PURE__ */ user_derived(() => `${$$props.data.nodeId}-output-${get$3(firstOutputPort).id}`);
      const expression_3 = /* @__PURE__ */ user_derived(() => getDataTypeColor(get$3(firstOutputPort).dataType));
      Handle($$anchor2, {
        type: "source",
        get position() {
          return Position.Right;
        },
        get id() {
          return get$3(expression_2);
        },
        get style() {
          var _a2;
          return `background-color: ${(_a2 = get$3(expression_3)) != null ? _a2 : ""}; border-color: '#ffffff';`;
        }
      });
    };
    if_block(node_8, ($$render) => {
      if (get$3(hasOutput) && get$3(firstOutputPort)) $$render(consequent_4);
    });
  }
  template_effect(($0) => classes = set_class(div, 1, "flowdrop-simple-node svelte-h9lyqy", null, classes, $0), [
    () => ({
      "flowdrop-simple-node--compact": get$3(isCompact),
      "flowdrop-simple-node--normal": !get$3(isCompact),
      "flowdrop-simple-node--selected": $$props.selected,
      "flowdrop-simple-node--processing": $$props.isProcessing,
      "flowdrop-simple-node--error": $$props.isError
    })
  ]);
  append($$anchor, fragment);
  pop();
}
delegate(["click", "dblclick", "keydown"]);
function handleDoubleClick(_2, openConfigSidebar) {
  openConfigSidebar();
}
function handleClick$1(__1, openConfigSidebar) {
  openConfigSidebar();
}
function handleKeydown$1(event2, openConfigSidebar) {
  if (event2.key === "Enter" || event2.key === " ") {
    event2.preventDefault();
    openConfigSidebar();
  }
}
var root_2$2 = /* @__PURE__ */ from_html(`<div class="flowdrop-square-node__processing svelte-12p0ws8"><div class="flowdrop-square-node__spinner svelte-12p0ws8"></div></div>`);
var root_3$5 = /* @__PURE__ */ from_html(`<div class="flowdrop-square-node__error svelte-12p0ws8"><!></div>`);
var root$7 = /* @__PURE__ */ from_html(`<!> <div role="button" tabindex="0"><div class="flowdrop-square-node__compact-content svelte-12p0ws8"><!></div> <!> <!> <button class="flowdrop-square-node__config-btn svelte-12p0ws8" title="Configure node"><!></button></div> <!>`, 1);
function SquareNode($$anchor, $$props) {
  push($$props, true);
  let squareIcon = /* @__PURE__ */ user_derived(() => {
    var _a2, _b2;
    return ((_a2 = $$props.data.metadata) == null ? void 0 : _a2.icon) || ((_b2 = $$props.data.config) == null ? void 0 : _b2.icon) || "mdi:square";
  });
  let squareColor = /* @__PURE__ */ user_derived(() => {
    var _a2, _b2;
    return ((_a2 = $$props.data.metadata) == null ? void 0 : _a2.color) || ((_b2 = $$props.data.config) == null ? void 0 : _b2.color) || "#6366f1";
  });
  const currentLayout = {
    iconSize: "2rem"
  };
  function openConfigSidebar() {
    if ($$props.data.onConfigOpen) {
      const nodeForConfig = {
        id: $$props.data.nodeId || "unknown",
        type: "square",
        data: $$props.data
      };
      $$props.data.onConfigOpen(nodeForConfig);
    }
  }
  let firstInputPort = /* @__PURE__ */ user_derived(() => {
    var _a2, _b2;
    return (_b2 = (_a2 = $$props.data.metadata) == null ? void 0 : _a2.inputs) == null ? void 0 : _b2[0];
  });
  let firstOutputPort = /* @__PURE__ */ user_derived(() => {
    var _a2, _b2;
    return (_b2 = (_a2 = $$props.data.metadata) == null ? void 0 : _a2.outputs) == null ? void 0 : _b2[0];
  });
  let hasInput = /* @__PURE__ */ user_derived(() => !!get$3(firstInputPort));
  let hasOutput = /* @__PURE__ */ user_derived(() => !!get$3(firstOutputPort));
  var fragment = root$7();
  var node = first_child(fragment);
  {
    var consequent = ($$anchor2) => {
      const expression = /* @__PURE__ */ user_derived(() => getDataTypeColor(get$3(firstInputPort).dataType));
      const expression_1 = /* @__PURE__ */ user_derived(() => `${$$props.data.nodeId}-input-${get$3(firstInputPort).id}`);
      Handle($$anchor2, {
        type: "target",
        get position() {
          return Position.Left;
        },
        get style() {
          var _a2;
          return `background-color: ${(_a2 = get$3(expression)) != null ? _a2 : ""}; border-color: '#ffffff';`;
        },
        get id() {
          return get$3(expression_1);
        }
      });
    };
    if_block(node, ($$render) => {
      if (get$3(hasInput) && get$3(firstInputPort)) $$render(consequent);
    });
  }
  var div = sibling(node, 2);
  let classes;
  div.__click = [handleClick$1, openConfigSidebar];
  div.__dblclick = [handleDoubleClick, openConfigSidebar];
  div.__keydown = [handleKeydown$1, openConfigSidebar];
  var div_1 = child(div);
  var node_1 = child(div_1);
  Icon(node_1, {
    get icon() {
      return get$3(squareIcon);
    },
    class: "flowdrop-square-node__compact-icon",
    get style() {
      var _a2;
      return `color: ${(_a2 = get$3(squareColor)) != null ? _a2 : ""}; font-size: ${currentLayout.iconSize};`;
    }
  });
  var node_2 = sibling(div_1, 2);
  {
    var consequent_1 = ($$anchor2) => {
      var div_2 = root_2$2();
      append($$anchor2, div_2);
    };
    if_block(node_2, ($$render) => {
      if ($$props.isProcessing) $$render(consequent_1);
    });
  }
  var node_3 = sibling(node_2, 2);
  {
    var consequent_2 = ($$anchor2) => {
      var div_3 = root_3$5();
      var node_4 = child(div_3);
      Icon(node_4, {
        icon: "mdi:alert-circle",
        class: "flowdrop-square-node__error-icon"
      });
      append($$anchor2, div_3);
    };
    if_block(node_3, ($$render) => {
      if ($$props.isError) $$render(consequent_2);
    });
  }
  var button = sibling(node_3, 2);
  button.__click = openConfigSidebar;
  var node_5 = child(button);
  Icon(node_5, { icon: "mdi:cog" });
  var node_6 = sibling(div, 2);
  {
    var consequent_3 = ($$anchor2) => {
      const expression_2 = /* @__PURE__ */ user_derived(() => getDataTypeColor(get$3(firstOutputPort).dataType));
      const expression_3 = /* @__PURE__ */ user_derived(() => `${$$props.data.nodeId}-output-${get$3(firstOutputPort).id}`);
      Handle($$anchor2, {
        type: "source",
        get position() {
          return Position.Right;
        },
        get style() {
          var _a2;
          return `background-color: ${(_a2 = get$3(expression_2)) != null ? _a2 : ""}; border-color: '#ffffff';`;
        },
        get id() {
          return get$3(expression_3);
        }
      });
    };
    if_block(node_6, ($$render) => {
      if (get$3(hasOutput) && get$3(firstOutputPort)) $$render(consequent_3);
    });
  }
  template_effect(($0) => classes = set_class(div, 1, "flowdrop-square-node flowdrop-square-node--compact svelte-12p0ws8", null, classes, $0), [
    () => ({
      "flowdrop-square-node--selected": $$props.selected,
      "flowdrop-square-node--processing": $$props.isProcessing,
      "flowdrop-square-node--error": $$props.isError
    })
  ]);
  append($$anchor, fragment);
  pop();
}
delegate(["click", "dblclick", "keydown"]);
function handleClick() {
}
function handleKeydown(event2, handleDoubleClick2) {
  if (event2.key === "Enter" || event2.key === " ") {
    event2.preventDefault();
    handleDoubleClick2();
  }
}
var root_2$1 = /* @__PURE__ */ from_html(`<div class="flowdrop-tool-node__processing svelte-dvg1f6"><div class="flowdrop-tool-node__spinner svelte-dvg1f6"></div></div>`);
var root_3$4 = /* @__PURE__ */ from_html(`<div class="flowdrop-tool-node__error svelte-dvg1f6"><!></div>`);
var root$6 = /* @__PURE__ */ from_html(`<!> <div role="button" tabindex="0"><div class="flowdrop-tool-node__header svelte-dvg1f6"><div class="flowdrop-tool-node__header-content svelte-dvg1f6"><div class="flowdrop-tool-node__icon-container svelte-dvg1f6"><!></div> <div class="flowdrop-tool-node__info svelte-dvg1f6"><h3 class="flowdrop-tool-node__title svelte-dvg1f6"> </h3> <div class="flowdrop-tool-node__version svelte-dvg1f6"> </div></div> <div class="flowdrop-tool-node__badge svelte-dvg1f6">TOOL</div></div> <p class="flowdrop-tool-node__description svelte-dvg1f6"> </p></div> <!> <!> <button class="flowdrop-tool-node__config-btn svelte-dvg1f6" title="Configure tool"><!></button></div> <!>`, 1);
function ToolNode($$anchor, $$props) {
  push($$props, true);
  let toolIcon = /* @__PURE__ */ user_derived(() => {
    var _a2, _b2;
    return ((_a2 = $$props.data.metadata) == null ? void 0 : _a2.icon) || ((_b2 = $$props.data.config) == null ? void 0 : _b2.icon) || "mdi:tools";
  });
  let toolColor = /* @__PURE__ */ user_derived(() => {
    var _a2, _b2;
    return ((_a2 = $$props.data.metadata) == null ? void 0 : _a2.color) || ((_b2 = $$props.data.config) == null ? void 0 : _b2.color) || "#f59e0b";
  });
  let toolName = /* @__PURE__ */ user_derived(() => {
    var _a2, _b2;
    return ((_a2 = $$props.data.metadata) == null ? void 0 : _a2.name) || ((_b2 = $$props.data.config) == null ? void 0 : _b2.toolName) || $$props.data.label || "Tool";
  });
  let toolDescription = /* @__PURE__ */ user_derived(() => {
    var _a2, _b2;
    return ((_a2 = $$props.data.metadata) == null ? void 0 : _a2.description) || ((_b2 = $$props.data.config) == null ? void 0 : _b2.toolDescription) || "A configurable tool for agents";
  });
  let toolVersion = /* @__PURE__ */ user_derived(() => {
    var _a2, _b2;
    return ((_a2 = $$props.data.metadata) == null ? void 0 : _a2.version) || ((_b2 = $$props.data.config) == null ? void 0 : _b2.toolVersion) || "1.0.0";
  });
  let hasToolInputPort = /* @__PURE__ */ user_derived(() => {
    var _a2, _b2;
    return ((_b2 = (_a2 = $$props.data.metadata) == null ? void 0 : _a2.inputs) == null ? void 0 : _b2.some((port) => port.dataType === "tool")) || false;
  });
  let hasToolOutputPort = /* @__PURE__ */ user_derived(() => {
    var _a2, _b2;
    return ((_b2 = (_a2 = $$props.data.metadata) == null ? void 0 : _a2.outputs) == null ? void 0 : _b2.some((port) => port.dataType === "tool")) || false;
  });
  let toolInputPort = /* @__PURE__ */ user_derived(() => {
    var _a2, _b2;
    return (_b2 = (_a2 = $$props.data.metadata) == null ? void 0 : _a2.inputs) == null ? void 0 : _b2.find((port) => port.dataType === "tool");
  });
  let toolOutputPort = /* @__PURE__ */ user_derived(() => {
    var _a2, _b2;
    return (_b2 = (_a2 = $$props.data.metadata) == null ? void 0 : _a2.outputs) == null ? void 0 : _b2.find((port) => port.dataType === "tool");
  });
  function openConfigSidebar() {
    if ($$props.data.onConfigOpen) {
      const nodeForConfig = {
        id: $$props.data.nodeId || "unknown",
        type: "tool",
        data: $$props.data
      };
      $$props.data.onConfigOpen(nodeForConfig);
    }
  }
  function handleDoubleClick2() {
    openConfigSidebar();
  }
  var fragment = root$6();
  var node = first_child(fragment);
  {
    var consequent = ($$anchor2) => {
      const expression = /* @__PURE__ */ user_derived(() => `${$$props.data.nodeId}-input-${get$3(toolInputPort).id}`);
      const expression_1 = /* @__PURE__ */ user_derived(() => getDataTypeColor("tool"));
      Handle($$anchor2, {
        type: "target",
        get position() {
          return Position.Left;
        },
        get id() {
          return get$3(expression);
        },
        get style() {
          var _a2;
          return `background-color: ${(_a2 = get$3(expression_1)) != null ? _a2 : ""}; border-color: '#ffffff';`;
        }
      });
    };
    if_block(node, ($$render) => {
      if (get$3(hasToolInputPort) && get$3(toolInputPort)) $$render(consequent);
    });
  }
  var div = sibling(node, 2);
  let classes;
  div.__click = [handleClick];
  div.__dblclick = handleDoubleClick2;
  div.__keydown = [handleKeydown, handleDoubleClick2];
  var div_1 = child(div);
  var div_2 = child(div_1);
  var div_3 = child(div_2);
  var node_1 = child(div_3);
  Icon(node_1, {
    get icon() {
      return get$3(toolIcon);
    },
    class: "flowdrop-tool-node__icon"
  });
  var div_4 = sibling(div_3, 2);
  var h3 = child(div_4);
  var text2 = child(h3);
  var div_5 = sibling(h3, 2);
  var text_1 = child(div_5);
  var p = sibling(div_2, 2);
  var text_2 = child(p);
  var node_2 = sibling(div_1, 2);
  {
    var consequent_1 = ($$anchor2) => {
      var div_6 = root_2$1();
      append($$anchor2, div_6);
    };
    if_block(node_2, ($$render) => {
      if ($$props.isProcessing) $$render(consequent_1);
    });
  }
  var node_3 = sibling(node_2, 2);
  {
    var consequent_2 = ($$anchor2) => {
      var div_7 = root_3$4();
      var node_4 = child(div_7);
      Icon(node_4, {
        icon: "mdi:alert-circle",
        class: "flowdrop-tool-node__error-icon"
      });
      append($$anchor2, div_7);
    };
    if_block(node_3, ($$render) => {
      if ($$props.isError) $$render(consequent_2);
    });
  }
  var button = sibling(node_3, 2);
  button.__click = openConfigSidebar;
  var node_5 = child(button);
  Icon(node_5, { icon: "mdi:cog" });
  var node_6 = sibling(div, 2);
  {
    var consequent_3 = ($$anchor2) => {
      const expression_2 = /* @__PURE__ */ user_derived(() => `${$$props.data.nodeId}-output-${get$3(toolOutputPort).id}`);
      const expression_3 = /* @__PURE__ */ user_derived(() => getDataTypeColor("tool"));
      Handle($$anchor2, {
        type: "source",
        get position() {
          return Position.Right;
        },
        get id() {
          return get$3(expression_2);
        },
        get style() {
          var _a2;
          return `background-color: ${(_a2 = get$3(expression_3)) != null ? _a2 : ""}; border-color: '#ffffff';`;
        }
      });
    };
    if_block(node_6, ($$render) => {
      if (get$3(hasToolOutputPort) && get$3(toolOutputPort)) $$render(consequent_3);
    });
  }
  template_effect(
    ($0) => {
      var _a2, _b2;
      classes = set_class(div, 1, "flowdrop-tool-node svelte-dvg1f6", null, classes, $0);
      set_style(div_3, `background-color: ${(_a2 = get$3(toolColor)) != null ? _a2 : ""}`);
      set_text(text2, get$3(toolName));
      set_text(text_1, `v${(_b2 = get$3(toolVersion)) != null ? _b2 : ""}`);
      set_text(text_2, get$3(toolDescription));
    },
    [
      () => ({
        "flowdrop-tool-node--selected": $$props.selected,
        "flowdrop-tool-node--processing": $$props.isProcessing,
        "flowdrop-tool-node--error": $$props.isError
      })
    ]
  );
  append($$anchor, fragment);
  pop();
}
delegate(["click", "dblclick", "keydown"]);
var root$5 = /* @__PURE__ */ from_html(`<div class="flowdrop-canvas-banner svelte-t5onfc"><div class="flowdrop-card"><div class="flowdrop-card__body flowdrop-text--center"><div class="flowdrop-canvas-banner__icon svelte-t5onfc"><!></div> <h3 class="flowdrop-canvas-banner__title svelte-t5onfc"> </h3> <p class="flowdrop-canvas-banner__description svelte-t5onfc"> </p></div></div></div>`);
function CanvasBanner($$anchor, $$props) {
  let title = prop($$props, "title", 8);
  let description = prop($$props, "description", 8);
  let iconName = prop($$props, "iconName", 8);
  var div = root$5();
  var div_1 = child(div);
  var div_2 = child(div_1);
  var div_3 = child(div_2);
  var node = child(div_3);
  {
    var consequent = ($$anchor2) => {
      Icon($$anchor2, {
        get icon() {
          return iconName();
        },
        class: "flowdrop-canvas-banner__icon-svg"
      });
    };
    if_block(node, ($$render) => {
      if (iconName()) $$render(consequent);
    });
  }
  var h3 = sibling(div_3, 2);
  var text2 = child(h3);
  var p = sibling(h3, 2);
  var text_1 = child(p);
  template_effect(() => {
    set_text(text2, title());
    set_text(text_1, description());
  });
  append($$anchor, div);
}
let endpointConfig = null;
function setEndpointConfig(config) {
  endpointConfig = config;
}
function getEndpointConfig() {
  return endpointConfig;
}
function setApiBaseUrl(url) {
  console.warn("⚠️ setApiBaseUrl() is deprecated. Use setEndpointConfig() with a full EndpointConfig object instead.");
  if (!endpointConfig) {
    Promise.resolve().then(() => endpoints).then(({ createEndpointConfig: createEndpointConfig2 }) => {
      endpointConfig = createEndpointConfig2(url);
    }).catch((error) => {
    });
  } else {
    endpointConfig.baseUrl = url.replace(/\/$/, "");
  }
}
function apiRequest(_0, _1, _2) {
  return __async(this, arguments, function* (endpointKey, endpointPath, params, options = {}) {
    if (!endpointConfig) {
      throw new Error("Endpoint configuration not set. Call setEndpointConfig() first.");
    }
    try {
      const url = buildEndpointUrl(endpointConfig, endpointPath, params);
      const method = getEndpointMethod(endpointConfig, endpointKey);
      const headers = getEndpointHeaders(endpointConfig, endpointKey);
      const response = yield fetch(url, __spreadValues({
        method,
        headers
      }, options));
      const data = yield response.json();
      if (!response.ok) {
        throw new Error(data.error || `HTTP ${response.status}: ${response.statusText}`);
      }
      return data;
    } catch (error) {
      throw error;
    }
  });
}
const nodeApi = {
  /**
   * Get all node types with optional filtering
   */
  getNodes(options) {
    return __async(this, null, function* () {
      if (!endpointConfig) {
        throw new Error("Endpoint configuration not set");
      }
      const params = new URLSearchParams();
      if (options == null ? void 0 : options.category) params.append("category", options.category);
      if (options == null ? void 0 : options.search) params.append("search", options.search);
      if (options == null ? void 0 : options.limit) params.append("limit", options.limit.toString());
      if (options == null ? void 0 : options.offset) params.append("offset", options.offset.toString());
      const response = yield apiRequest(
        "nodes.list",
        endpointConfig.endpoints.nodes.list + "?" + params.toString()
      );
      return response.data || [];
    });
  },
  /**
   * Get a specific node type by ID
   */
  getNode(id2) {
    return __async(this, null, function* () {
      if (!endpointConfig) {
        throw new Error("Endpoint configuration not set");
      }
      const response = yield apiRequest(
        "nodes.get",
        endpointConfig.endpoints.nodes.get,
        { id: id2 }
      );
      if (!response.data) {
        throw new Error("Node not found");
      }
      return response.data;
    });
  }
};
const workflowApi = {
  /**
   * Get all workflows with optional filtering
   */
  getWorkflows(options) {
    return __async(this, null, function* () {
      if (!endpointConfig) {
        throw new Error("Endpoint configuration not set");
      }
      const params = new URLSearchParams();
      if (options == null ? void 0 : options.search) params.append("search", options.search);
      if (options == null ? void 0 : options.limit) params.append("limit", options.limit.toString());
      if (options == null ? void 0 : options.offset) params.append("offset", options.offset.toString());
      const response = yield apiRequest(
        "workflows.list",
        endpointConfig.endpoints.workflows.list + "?" + params.toString()
      );
      return response.data || [];
    });
  },
  /**
   * Get a specific workflow by ID
   */
  getWorkflow(id2) {
    return __async(this, null, function* () {
      if (!endpointConfig) {
        throw new Error("Endpoint configuration not set");
      }
      const response = yield apiRequest(
        "workflows.get",
        endpointConfig.endpoints.workflows.get,
        { id: id2 }
      );
      if (!response.data) {
        throw new Error("Workflow not found");
      }
      return response.data;
    });
  },
  /**
   * Create a new workflow
   */
  createWorkflow(workflow) {
    return __async(this, null, function* () {
      if (!endpointConfig) {
        throw new Error("Endpoint configuration not set");
      }
      const response = yield apiRequest(
        "workflows.create",
        endpointConfig.endpoints.workflows.create,
        void 0,
        {
          method: "POST",
          body: JSON.stringify(workflow)
        }
      );
      if (!response.data) {
        throw new Error("Failed to create workflow");
      }
      return response.data;
    });
  },
  /**
   * Update an existing workflow
   */
  updateWorkflow(id2, workflow) {
    return __async(this, null, function* () {
      if (!endpointConfig) {
        throw new Error("Endpoint configuration not set");
      }
      const response = yield apiRequest(
        "workflows.update",
        endpointConfig.endpoints.workflows.update,
        { id: id2 },
        {
          method: "PUT",
          body: JSON.stringify(workflow)
        }
      );
      if (!response.data) {
        throw new Error("Failed to update workflow");
      }
      return response.data;
    });
  },
  /**
   * Delete a workflow
   */
  deleteWorkflow(id2) {
    return __async(this, null, function* () {
      if (!endpointConfig) {
        throw new Error("Endpoint configuration not set");
      }
      yield apiRequest(
        "workflows.delete",
        endpointConfig.endpoints.workflows.delete,
        { id: id2 },
        { method: "DELETE" }
      );
    });
  },
  /**
   * Save workflow (create or update)
   */
  saveWorkflow(workflow) {
    return __async(this, null, function* () {
      const isExistingWorkflow = workflow.id && workflow.id.length > 0 && !workflow.id.match(/^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$/i);
      if (isExistingWorkflow) {
        return this.updateWorkflow(workflow.id, workflow);
      } else {
        const _a2 = workflow, { id: id2 } = _a2, workflowData = __objRest(_a2, ["id"]);
        return this.createWorkflow(workflowData);
      }
    });
  }
};
const api = {
  nodes: nodeApi,
  workflows: workflowApi
};
const api$1 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  api,
  getEndpointConfig,
  nodeApi,
  setApiBaseUrl,
  setEndpointConfig,
  workflowApi
}, Symbol.toStringTag, { value: "Module" }));
const byteToHex = [];
for (let i = 0; i < 256; ++i) {
  byteToHex.push((i + 256).toString(16).slice(1));
}
function unsafeStringify(arr, offset = 0) {
  return (byteToHex[arr[offset + 0]] + byteToHex[arr[offset + 1]] + byteToHex[arr[offset + 2]] + byteToHex[arr[offset + 3]] + "-" + byteToHex[arr[offset + 4]] + byteToHex[arr[offset + 5]] + "-" + byteToHex[arr[offset + 6]] + byteToHex[arr[offset + 7]] + "-" + byteToHex[arr[offset + 8]] + byteToHex[arr[offset + 9]] + "-" + byteToHex[arr[offset + 10]] + byteToHex[arr[offset + 11]] + byteToHex[arr[offset + 12]] + byteToHex[arr[offset + 13]] + byteToHex[arr[offset + 14]] + byteToHex[arr[offset + 15]]).toLowerCase();
}
let getRandomValues;
const rnds8 = new Uint8Array(16);
function rng() {
  if (!getRandomValues) {
    if (typeof crypto === "undefined" || !crypto.getRandomValues) {
      throw new Error("crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported");
    }
    getRandomValues = crypto.getRandomValues.bind(crypto);
  }
  return getRandomValues(rnds8);
}
const randomUUID = typeof crypto !== "undefined" && crypto.randomUUID && crypto.randomUUID.bind(crypto);
const native = { randomUUID };
function v4(options, buf, offset) {
  var _a2, _b2, _c2;
  if (native.randomUUID && !buf && !options) {
    return native.randomUUID();
  }
  options = options || {};
  const rnds = (_c2 = (_b2 = options.random) != null ? _b2 : (_a2 = options.rng) == null ? void 0 : _a2.call(options)) != null ? _c2 : rng();
  if (rnds.length < 16) {
    throw new Error("Random bytes length must be >= 16");
  }
  rnds[6] = rnds[6] & 15 | 64;
  rnds[8] = rnds[8] & 63 | 128;
  if (buf) {
    offset = offset || 0;
    if (offset < 0 || offset + 16 > buf.length) {
      throw new RangeError(`UUID byte range ${offset}:${offset + 15} is out of buffer bounds`);
    }
    for (let i = 0; i < 16; ++i) {
      buf[offset + i] = rnds[i];
    }
    return buf;
  }
  return unsafeStringify(rnds);
}
const index = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  v4
}, Symbol.toStringTag, { value: "Module" }));
var root_1$5 = /* @__PURE__ */ from_svg(`<path fill="none" class="animated"></path><circle fill="#fff"></circle>`, 1);
function ConnectionLine($$anchor, $$props) {
  push($$props, true);
  const connection = useConnection();
  let path = /* @__PURE__ */ user_derived(() => {
    if (connection.current.inProgress) {
      const { from, to } = connection.current;
      return `M${from.x},${from.y} C ${from.x} ${to.y} ${from.x} ${to.y} ${to.x},${to.y}`;
    }
    return null;
  });
  var fragment = comment();
  var node = first_child(fragment);
  {
    var consequent = ($$anchor2) => {
      var fragment_1 = root_1$5();
      var path_1 = first_child(fragment_1);
      set_attribute(path_1, "stroke-width", 1.5);
      var circle = sibling(path_1);
      set_attribute(circle, "r", 3);
      set_attribute(circle, "stroke-width", 1.5);
      template_effect(
        ($0, $1) => {
          set_attribute(path_1, "stroke", $0);
          set_attribute(path_1, "d", get$3(path));
          set_attribute(circle, "cx", connection.current.to.x);
          set_attribute(circle, "cy", connection.current.to.y);
          set_attribute(circle, "stroke", $1);
        },
        [
          () => getDataTypeColor(connection.current.fromHandle.id),
          () => getDataTypeColor(connection.current.fromHandle.id)
        ]
      );
      append($$anchor2, fragment_1);
    };
    if_block(node, ($$render) => {
      if (connection.current.inProgress) $$render(consequent);
    });
  }
  append($$anchor, fragment);
  pop();
}
const NODE_TYPE_TO_COMPONENT_MAP = {
  note: "note",
  simple: "simple",
  square: "square",
  tool: "tool",
  default: "workflowNode"
};
function getComponentNameForNodeType(nodeType) {
  return NODE_TYPE_TO_COMPONENT_MAP[nodeType] || "workflowNode";
}
function getAvailableNodeTypes(metadata) {
  if (metadata.supportedTypes && metadata.supportedTypes.length > 0) {
    return metadata.supportedTypes;
  }
  if (metadata.type) {
    return [metadata.type];
  }
  return ["default"];
}
function getPrimaryNodeType(metadata) {
  const availableTypes = getAvailableNodeTypes(metadata);
  return availableTypes[0];
}
function resolveNodeType(metadata, configNodeType) {
  const availableTypes = getAvailableNodeTypes(metadata);
  if (configNodeType && availableTypes.includes(configNodeType)) {
    return configNodeType;
  }
  return getPrimaryNodeType(metadata);
}
function resolveComponentName(metadata, configNodeType) {
  const nodeType = resolveNodeType(metadata, configNodeType);
  return getComponentNameForNodeType(nodeType);
}
function isNodeTypeSupported(metadata, nodeType) {
  const availableTypes = getAvailableNodeTypes(metadata);
  return availableTypes.includes(nodeType);
}
function getNodeTypeEnumOptions(metadata) {
  const availableTypes = getAvailableNodeTypes(metadata);
  const typeDisplayNames = {
    note: "Note (sticky note style)",
    simple: "Simple (compact layout)",
    tool: "Tool (specialized for agent tools)",
    default: "Default (standard workflow node)"
  };
  return {
    enum: availableTypes,
    enumNames: availableTypes.map((type) => typeDisplayNames[type] || type)
  };
}
function createNodeTypeConfigProperty(metadata, defaultType) {
  const { enum: enumValues, enumNames } = getNodeTypeEnumOptions(metadata);
  const primaryType = defaultType || getPrimaryNodeType(metadata);
  return {
    type: "string",
    title: "Node Type",
    description: "Choose the visual representation for this node",
    default: primaryType,
    enum: enumValues,
    enumNames
  };
}
const workflowStore = writable(null);
derived(workflowStore, ($workflow) => ($workflow == null ? void 0 : $workflow.id) || null);
const workflowName = derived(workflowStore, ($workflow) => ($workflow == null ? void 0 : $workflow.name) || "Untitled Workflow");
const workflowNodes = derived(workflowStore, ($workflow) => ($workflow == null ? void 0 : $workflow.nodes) || []);
const workflowEdges = derived(workflowStore, ($workflow) => ($workflow == null ? void 0 : $workflow.edges) || []);
const workflowMetadata = derived(workflowStore, ($workflow) => ($workflow == null ? void 0 : $workflow.metadata) || {
  version: "1.0.0",
  createdAt: (/* @__PURE__ */ new Date()).toISOString(),
  updatedAt: (/* @__PURE__ */ new Date()).toISOString(),
  versionId: `${Date.now()}-${Math.random().toString(36).substr(2, 9)}`,
  updateNumber: 0
});
function hasWorkflowDataChanged(currentWorkflow, newNodes, newEdges) {
  if (!currentWorkflow) return true;
  if (currentWorkflow.nodes.length !== newNodes.length) return true;
  for (let i = 0; i < newNodes.length; i++) {
    const currentNode = currentWorkflow.nodes[i];
    const newNode = newNodes[i];
    if (!currentNode || !newNode) return true;
    if (currentNode.id !== newNode.id) return true;
    if (currentNode.position.x !== newNode.position.x || currentNode.position.y !== newNode.position.y) return true;
    if (JSON.stringify(currentNode.data) !== JSON.stringify(newNode.data)) return true;
  }
  if (currentWorkflow.edges.length !== newEdges.length) return true;
  for (let i = 0; i < newEdges.length; i++) {
    const currentEdge = currentWorkflow.edges[i];
    const newEdge = newEdges[i];
    if (!currentEdge || !newEdge) return true;
    if (currentEdge.id !== newEdge.id) return true;
    if (currentEdge.source !== newEdge.source || currentEdge.target !== newEdge.target) return true;
  }
  return false;
}
const workflowActions = {
  // Initialize workflow
  initialize: (workflow) => {
    console.log("🔍 Debug: initialize called with:", workflow);
    workflowStore.set(workflow);
    console.log("🔍 Debug: workflow store initialized");
  },
  // Update the entire workflow
  updateWorkflow: (workflow) => {
    console.log("🔍 Debug: updateWorkflow called with:", workflow);
    workflowStore.set(workflow);
    console.log("🔍 Debug: workflow store updated");
  },
  // Update nodes
  updateNodes: (nodes) => {
    workflowStore.update(($workflow) => {
      var _a2;
      if (!$workflow) return null;
      if (!hasWorkflowDataChanged($workflow, nodes, $workflow.edges)) {
        console.log("🔍 Debug: Nodes unchanged, skipping update to prevent infinite loop");
        return $workflow;
      }
      const versionId = `${Date.now()}-${Math.random().toString(36).substr(2, 9)}`;
      console.log("🔍 Debug: Updating nodes with versionId:", versionId);
      console.log("🔍 Debug: Node position changes detected:", nodes.map((node) => ({
        id: node.id,
        position: node.position
      })));
      return __spreadProps(__spreadValues({}, $workflow), {
        nodes,
        metadata: __spreadProps(__spreadValues({}, $workflow.metadata), {
          updatedAt: (/* @__PURE__ */ new Date()).toISOString(),
          versionId,
          updateNumber: (((_a2 = $workflow.metadata) == null ? void 0 : _a2.updateNumber) || 0) + 1
        })
      });
    });
  },
  // Update edges
  updateEdges: (edges) => {
    workflowStore.update(($workflow) => {
      var _a2;
      if (!$workflow) return null;
      if (!hasWorkflowDataChanged($workflow, $workflow.nodes, edges)) {
        console.log("🔍 Debug: Edges unchanged, skipping update to prevent infinite loop");
        return $workflow;
      }
      const versionId = `${Date.now()}-${Math.random().toString(36).substr(2, 9)}`;
      console.log("🔍 Debug: Updating edges with versionId:", versionId);
      return __spreadProps(__spreadValues({}, $workflow), {
        edges,
        metadata: __spreadProps(__spreadValues({}, $workflow.metadata), {
          updatedAt: (/* @__PURE__ */ new Date()).toISOString(),
          versionId,
          updateNumber: (((_a2 = $workflow.metadata) == null ? void 0 : _a2.updateNumber) || 0) + 1
        })
      });
    });
  },
  // Update workflow name
  updateName: (name) => {
    workflowStore.update(($workflow) => {
      if (!$workflow) return null;
      return __spreadProps(__spreadValues({}, $workflow), {
        name,
        metadata: __spreadProps(__spreadValues({}, $workflow.metadata), {
          updatedAt: (/* @__PURE__ */ new Date()).toISOString()
        })
      });
    });
  },
  // Add a node
  addNode: (node) => {
    workflowStore.update(($workflow) => {
      if (!$workflow) return null;
      return __spreadProps(__spreadValues({}, $workflow), {
        nodes: [...$workflow.nodes, node],
        metadata: __spreadProps(__spreadValues({}, $workflow.metadata), {
          updatedAt: (/* @__PURE__ */ new Date()).toISOString()
        })
      });
    });
  },
  // Remove a node
  removeNode: (nodeId) => {
    workflowStore.update(($workflow) => {
      if (!$workflow) return null;
      return __spreadProps(__spreadValues({}, $workflow), {
        nodes: $workflow.nodes.filter((node) => node.id !== nodeId),
        edges: $workflow.edges.filter((edge) => edge.source !== nodeId && edge.target !== nodeId),
        metadata: __spreadProps(__spreadValues({}, $workflow.metadata), {
          updatedAt: (/* @__PURE__ */ new Date()).toISOString()
        })
      });
    });
  },
  // Add an edge
  addEdge: (edge) => {
    workflowStore.update(($workflow) => {
      if (!$workflow) return null;
      return __spreadProps(__spreadValues({}, $workflow), {
        edges: [...$workflow.edges, edge],
        metadata: __spreadProps(__spreadValues({}, $workflow.metadata), {
          updatedAt: (/* @__PURE__ */ new Date()).toISOString()
        })
      });
    });
  },
  // Remove an edge
  removeEdge: (edgeId) => {
    workflowStore.update(($workflow) => {
      if (!$workflow) return null;
      return __spreadProps(__spreadValues({}, $workflow), {
        edges: $workflow.edges.filter((edge) => edge.id !== edgeId),
        metadata: __spreadProps(__spreadValues({}, $workflow.metadata), {
          updatedAt: (/* @__PURE__ */ new Date()).toISOString()
        })
      });
    });
  },
  // Update a specific node
  updateNode: (nodeId, updates) => {
    workflowStore.update(($workflow) => {
      if (!$workflow) return null;
      return __spreadProps(__spreadValues({}, $workflow), {
        nodes: $workflow.nodes.map(
          (node) => node.id === nodeId ? __spreadValues(__spreadValues({}, node), updates) : node
        ),
        metadata: __spreadProps(__spreadValues({}, $workflow.metadata), {
          updatedAt: (/* @__PURE__ */ new Date()).toISOString()
        })
      });
    });
  },
  // Clear the workflow
  clear: () => {
    workflowStore.set(null);
  },
  // Update workflow metadata
  updateMetadata: (metadata) => {
    workflowStore.update(($workflow) => {
      if (!$workflow) return null;
      return __spreadProps(__spreadValues({}, $workflow), {
        metadata: __spreadProps(__spreadValues(__spreadValues({}, $workflow.metadata), metadata), {
          updatedAt: (/* @__PURE__ */ new Date()).toISOString()
        })
      });
    });
  },
  // Batch update nodes and edges (useful for complex operations)
  batchUpdate: (updates) => {
    workflowStore.update(($workflow) => {
      if (!$workflow) return null;
      return __spreadProps(__spreadValues(__spreadValues(__spreadValues(__spreadValues({}, $workflow), updates.nodes && { nodes: updates.nodes }), updates.edges && { edges: updates.edges }), updates.name && { name: updates.name }), {
        metadata: __spreadProps(__spreadValues(__spreadValues({}, $workflow.metadata), updates.metadata && __spreadValues({}, updates.metadata)), {
          updatedAt: (/* @__PURE__ */ new Date()).toISOString()
        })
      });
    });
  }
};
derived(
  [workflowNodes, workflowEdges, workflowName],
  ([nodes, edges, name]) => ({ nodes, edges, name })
);
derived(
  [workflowNodes, workflowEdges],
  ([nodes, edges]) => ({
    hasNodes: nodes.length > 0,
    hasEdges: edges.length > 0,
    nodeCount: nodes.length,
    edgeCount: edges.length,
    isValid: nodes.length > 0 && edges.length >= 0
  })
);
derived(
  workflowMetadata,
  (metadata) => ({
    createdAt: metadata.createdAt,
    updatedAt: metadata.updatedAt,
    version: metadata.version || "1.0.0"
  })
);
var root_3$3 = /* @__PURE__ */ from_html(`<span class="flowdrop-text--xs flowdrop-text--gray">•</span> <span class="flowdrop-text--xs flowdrop-font--medium flowdrop-text--error svelte-1ymkuc9">⚠️ Cycles detected</span>`, 1);
var root_1$4 = /* @__PURE__ */ from_html(`<div class="flowdrop-workflow-editor svelte-1ymkuc9"><div class="flowdrop-workflow-editor__main svelte-1ymkuc9"><div class="flowdrop-canvas svelte-1ymkuc9" role="application" aria-label="Workflow canvas"><!> <!> <!> <!> <!></div> <div class="flowdrop-status-bar svelte-1ymkuc9"><div class="flowdrop-status-bar__content svelte-1ymkuc9"><div class="flowdrop-flex flowdrop-gap--4"><span class="flowdrop-text--xs flowdrop-text--gray"> </span> <span class="flowdrop-text--xs flowdrop-text--gray">•</span> <span class="flowdrop-text--xs flowdrop-text--gray"> </span> <!></div></div></div></div></div>`);
function WorkflowEditor($$anchor, $$props) {
  push($$props, true);
  const [$$stores, $$cleanup] = setup_stores();
  const $workflowStore = () => store_get(workflowStore, "$workflowStore", $$stores);
  let props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]);
  user_effect(() => {
    var _a2;
    console.log("🔧 WorkflowEditor: Props received:", {
      hasOpenConfigSidebar: !!$$props.openConfigSidebar,
      hasCloseConfigSidebar: !!$$props.closeConfigSidebar,
      selectedNodeForConfig: (_a2 = $$props.selectedNodeForConfig) == null ? void 0 : _a2.id,
      isConfigSidebarOpen: $$props.isConfigSidebarOpen
    });
  });
  let availableNodes = /* @__PURE__ */ state(proxy([]));
  let currentWorkflow = /* @__PURE__ */ state(null);
  user_effect(() => {
    if ($workflowStore()) {
      set$2(currentWorkflow, $workflowStore(), true);
    }
  });
  let flowNodes = /* @__PURE__ */ state(proxy([]));
  let flowEdges = /* @__PURE__ */ state(proxy([]));
  user_effect(() => {
    if (get$3(currentWorkflow)) {
      set$2(
        flowNodes,
        get$3(currentWorkflow).nodes.map((node) => __spreadProps(__spreadValues({}, node), {
          data: __spreadProps(__spreadValues({}, node.data), {
            onConfigOpen: $$props.openConfigSidebar
          })
        })),
        true
      );
      set$2(flowEdges, get$3(currentWorkflow).edges, true);
    }
  });
  function updateGlobalStore() {
    var _a2, _b2;
    if (get$3(currentWorkflow)) {
      console.log("🔍 WorkflowEditor: Updating global store from currentWorkflow:", {
        nodeCount: get$3(currentWorkflow).nodes.length,
        edgeCount: get$3(currentWorkflow).edges.length,
        nodePositions: get$3(currentWorkflow).nodes.map((node) => ({ id: node.id, position: node.position })),
        workflowName: get$3(currentWorkflow).name,
        versionId: (_a2 = get$3(currentWorkflow).metadata) == null ? void 0 : _a2.versionId,
        updateNumber: (_b2 = get$3(currentWorkflow).metadata) == null ? void 0 : _b2.updateNumber
      });
      workflowActions.updateWorkflow(get$3(currentWorkflow));
    }
  }
  function updateCurrentWorkflowFromSvelteFlow() {
    var _a2;
    if (get$3(currentWorkflow)) {
      set$2(
        currentWorkflow,
        __spreadProps(__spreadValues({}, get$3(currentWorkflow)), {
          nodes: get$3(flowNodes),
          edges: get$3(flowEdges),
          metadata: __spreadProps(__spreadValues({}, get$3(currentWorkflow).metadata), {
            updatedAt: (/* @__PURE__ */ new Date()).toISOString(),
            versionId: `${Date.now()}-${Math.random().toString(36).substr(2, 9)}`,
            updateNumber: (((_a2 = get$3(currentWorkflow).metadata) == null ? void 0 : _a2.updateNumber) || 0) + 1
          })
        }),
        true
      );
      updateGlobalStore();
    }
  }
  let previousNodes = /* @__PURE__ */ state(proxy([]));
  let previousEdges = /* @__PURE__ */ state(proxy([]));
  user_effect(() => {
    const nodesChanged = JSON.stringify(get$3(flowNodes)) !== JSON.stringify(get$3(previousNodes));
    const edgesChanged = JSON.stringify(get$3(flowEdges)) !== JSON.stringify(get$3(previousEdges));
    if ((nodesChanged || edgesChanged) && get$3(currentWorkflow)) {
      console.log("🔍 WorkflowEditor: SvelteFlow changed nodes/edges, updating currentWorkflow");
      updateCurrentWorkflowFromSvelteFlow();
      set$2(previousNodes, JSON.parse(JSON.stringify(get$3(flowNodes))), true);
      set$2(previousEdges, JSON.parse(JSON.stringify(get$3(flowEdges))), true);
    }
  });
  const nodeTypes = {
    workflowNode: WorkflowNode,
    note: NotesNode,
    simple: SimpleNode,
    square: SquareNode,
    tool: ToolNode
  };
  const defaultEdgeOptions = {};
  function handleConnect(connection) {
    return __async(this, null, function* () {
      console.log("Connection created:", connection);
      yield tick();
      updateExistingEdgeStyles();
      if (get$3(currentWorkflow)) {
        updateCurrentWorkflowFromSvelteFlow();
      }
    });
  }
  function applyConnectionStyling(edge, sourceNode, targetNode) {
    const isToolNode = sourceNode.type === "tool";
    if (isToolNode) {
      edge.style = "stroke-dasharray: 0 4 0; stroke: amber !important;";
      edge.class = "flowdrop--edge--tool";
    } else {
      edge.style = "stroke: grey;";
    }
    edge.data = __spreadProps(__spreadValues({}, edge.data), {
      isToolConnection: isToolNode,
      targetNodeType: targetNode.type,
      targetCategory: targetNode.data.metadata.category
    });
    if (!isToolNode) {
      edge.markerEnd = {
        type: MarkerType.ArrowClosed,
        width: 16,
        height: 16,
        color: "grey"
      };
    }
  }
  function updateExistingEdgeStyles() {
    return __async(this, null, function* () {
      var _a2;
      yield tick();
      const updatedEdges = get$3(flowEdges).map((edge) => {
        const sourceNode = get$3(flowNodes).find((node) => node.id === edge.source);
        const targetNode = get$3(flowNodes).find((node) => node.id === edge.target);
        if (!sourceNode || !targetNode) {
          console.warn("Could not find nodes for edge:", edge.id);
          return edge;
        }
        const updatedEdge = __spreadValues({}, edge);
        applyConnectionStyling(updatedEdge, sourceNode, targetNode);
        return updatedEdge;
      });
      if (get$3(currentWorkflow)) {
        set$2(
          currentWorkflow,
          __spreadProps(__spreadValues({}, get$3(currentWorkflow)), {
            edges: updatedEdges,
            metadata: __spreadProps(__spreadValues({}, get$3(currentWorkflow).metadata), {
              updatedAt: (/* @__PURE__ */ new Date()).toISOString(),
              versionId: `${Date.now()}-${Math.random().toString(36).substr(2, 9)}`,
              updateNumber: (((_a2 = get$3(currentWorkflow).metadata) == null ? void 0 : _a2.updateNumber) || 0) + 1
            })
          }),
          true
        );
        updateGlobalStore();
      }
    });
  }
  user_effect(() => {
    if ($$props.endpointConfig) {
      setEndpointConfig($$props.endpointConfig);
      loadNodesFromApi();
    } else if ($$props.nodes) {
      set$2(availableNodes, props.nodes, true);
    }
  });
  function loadNodesFromApi() {
    return __async(this, null, function* () {
      if ($$props.nodes && $$props.nodes.length > 0) {
        set$2(availableNodes, props.nodes, true);
        return;
      }
      try {
        const fetchedNodes = yield nodeApi.getNodes();
        set$2(availableNodes, fetchedNodes, true);
      } catch (error) {
        console.error("❌ Failed to load nodes from API:", error);
        set$2(
          availableNodes,
          [
            {
              id: "text-input",
              name: "Text Input",
              category: "inputs",
              description: "Simple text input field",
              version: "1.0.0",
              icon: "mdi:text-box",
              inputs: [],
              outputs: [
                {
                  id: "text",
                  name: "text",
                  type: "output",
                  dataType: "string"
                }
              ]
            },
            {
              id: "text-output",
              name: "Text Output",
              category: "outputs",
              description: "Display text output",
              version: "1.0.0",
              icon: "mdi:text-box-outline",
              inputs: [
                {
                  id: "text",
                  name: "text",
                  type: "input",
                  dataType: "string"
                }
              ],
              outputs: []
            }
          ],
          true
        );
      }
    });
  }
  function checkWorkflowCycles() {
    return hasCycles(get$3(flowNodes), get$3(flowEdges));
  }
  SvelteFlowProvider($$anchor, {
    children: ($$anchor2, $$slotProps) => {
      var div = root_1$4();
      var div_1 = child(div);
      var div_2 = child(div_1);
      var node_1 = child(div_2);
      SvelteFlow(node_1, {
        get nodeTypes() {
          return nodeTypes;
        },
        get defaultEdgeOptions() {
          return defaultEdgeOptions;
        },
        onconnect: handleConnect,
        minZoom: 0.2,
        maxZoom: 3,
        clickConnect: true,
        elevateEdgesOnSelect: true,
        get connectionLineType() {
          return ConnectionLineType.Bezier;
        },
        get connectionLineComponent() {
          return ConnectionLine;
        },
        snapGrid: [10, 10],
        fitView: true,
        get nodes() {
          return get$3(flowNodes);
        },
        set nodes($$value) {
          set$2(flowNodes, $$value, true);
        },
        get edges() {
          return get$3(flowEdges);
        },
        set edges($$value) {
          set$2(flowEdges, $$value, true);
        }
      });
      var node_2 = sibling(node_1, 2);
      Controls(node_2, {});
      var node_3 = sibling(node_2, 2);
      Background(node_3, { gap: 10 });
      var node_4 = sibling(node_3, 2);
      Minimap(node_4, {});
      var node_5 = sibling(node_4, 2);
      {
        var consequent = ($$anchor3) => {
          CanvasBanner($$anchor3, {
            title: "Drag components here to start building",
            description: "Use the sidebar to add components to your workflow",
            iconName: "mdi:graph"
          });
        };
        if_block(node_5, ($$render) => {
          if (get$3(flowNodes).length === 0) $$render(consequent);
        });
      }
      var div_3 = sibling(div_2, 2);
      var div_4 = child(div_3);
      var div_5 = child(div_4);
      var span = child(div_5);
      var text2 = child(span);
      var span_1 = sibling(span, 4);
      var text_1 = child(span_1);
      var node_6 = sibling(span_1, 2);
      {
        var consequent_1 = ($$anchor3) => {
          var fragment_2 = root_3$3();
          append($$anchor3, fragment_2);
        };
        if_block(node_6, ($$render) => {
          if (checkWorkflowCycles()) $$render(consequent_1);
        });
      }
      template_effect(() => {
        var _a2, _b2, _c2, _d2;
        set_style(div, `height: ${(_a2 = typeof $$props.height === "number" ? `${$$props.height}px` : $$props.height || "100%") != null ? _a2 : ""}; width: ${(_b2 = typeof $$props.width === "number" ? `${$$props.width}px` : $$props.width || "100%") != null ? _b2 : ""};`);
        set_text(text2, `${(_c2 = get$3(flowNodes).length) != null ? _c2 : ""} nodes`);
        set_text(text_1, `${(_d2 = get$3(flowEdges).length) != null ? _d2 : ""} connections`);
      });
      event("dragover", div_2, (e) => {
        e.preventDefault();
        e.dataTransfer.dropEffect = "copy";
      });
      event("drop", div_2, (e) => __async(null, null, function* () {
        var _a2, _b2, _c2;
        e.preventDefault();
        const nodeTypeData = (_a2 = e.dataTransfer) == null ? void 0 : _a2.getData("application/json");
        if (nodeTypeData) {
          const rect = e.currentTarget.getBoundingClientRect();
          const position = {
            x: e.clientX - rect.left,
            y: e.clientY - rect.top
          };
          try {
            const parsedData = JSON.parse(nodeTypeData);
            let nodeType;
            let nodeData;
            if (parsedData.type === "node") {
              nodeType = parsedData.nodeData.metadata;
              nodeData = parsedData.nodeData;
            } else {
              nodeType = parsedData;
              let initialConfig = {};
              if (nodeType.configSchema && typeof nodeType.configSchema === "object") {
                if (nodeType.configSchema.properties) {
                  Object.entries(nodeType.configSchema.properties).forEach(([key2, prop2]) => {
                    if (prop2 && typeof prop2 === "object" && "default" in prop2) {
                      initialConfig[key2] = prop2.default;
                    }
                  });
                } else {
                  initialConfig = __spreadValues({}, nodeType.configSchema);
                }
              }
              nodeData = {
                label: nodeType.name,
                config: initialConfig,
                metadata: nodeType
              };
            }
            const newNodeId = v4();
            const svelteFlowNodeType = resolveComponentName(nodeData.metadata, ((_b2 = nodeData.config) == null ? void 0 : _b2.nodeType) || "default");
            const newNode = {
              id: newNodeId,
              type: svelteFlowNodeType,
              position,
              // Use the position calculated from the drop event
              deletable: true,
              data: __spreadProps(__spreadValues({}, nodeData), {
                nodeId: newNodeId
                // Use the same ID
              })
            };
            if (get$3(currentWorkflow)) {
              console.log("🔧 WorkflowEditor: Adding new node to currentWorkflow:", newNode.id);
              set$2(
                currentWorkflow,
                __spreadProps(__spreadValues({}, get$3(currentWorkflow)), {
                  nodes: [...get$3(currentWorkflow).nodes, newNode],
                  metadata: __spreadProps(__spreadValues({}, get$3(currentWorkflow).metadata), {
                    updatedAt: (/* @__PURE__ */ new Date()).toISOString(),
                    versionId: `${Date.now()}-${Math.random().toString(36).substr(2, 9)}`,
                    updateNumber: (((_c2 = get$3(currentWorkflow).metadata) == null ? void 0 : _c2.updateNumber) || 0) + 1
                  })
                }),
                true
              );
              console.log("🔧 WorkflowEditor: Updated currentWorkflow with new node, calling updateGlobalStore");
              updateGlobalStore();
            } else {
              console.warn("⚠️ WorkflowEditor: No currentWorkflow available for new node");
            }
            yield tick();
          } catch (error) {
            console.error("Error parsing node data:", error);
          }
        }
      }));
      append($$anchor2, div);
    },
    $$slots: { default: true }
  });
  pop();
  $$cleanup();
}
var root_1$3 = /* @__PURE__ */ from_html(`<p class="flowdrop-text--xs flowdrop-text--gray"> </p>`);
var root$4 = /* @__PURE__ */ from_html(`<div class="flowdrop-loading svelte-1gwtto3"><div></div> <!></div>`);
function LoadingSpinner($$anchor, $$props) {
  push($$props, true);
  let size = /* @__PURE__ */ user_derived(() => $$props.size || "md");
  let text2 = /* @__PURE__ */ user_derived(() => $$props.text || "Loading...");
  let showText = /* @__PURE__ */ user_derived(() => $$props.showText !== false);
  var div = root$4();
  var div_1 = child(div);
  var node = sibling(div_1, 2);
  {
    var consequent = ($$anchor2) => {
      var p = root_1$3();
      var text_1 = child(p);
      template_effect(() => set_text(text_1, get$3(text2)));
      append($$anchor2, p);
    };
    if_block(node, ($$render) => {
      if (get$3(showText)) $$render(consequent);
    });
  }
  template_effect(() => {
    var _a2;
    return set_class(div_1, 1, `flowdrop-spinner flowdrop-spinner--${(_a2 = get$3(size)) != null ? _a2 : ""}`, "svelte-1gwtto3");
  });
  append($$anchor, div);
  pop();
}
function handleSearchChange() {
}
var root_1$2 = /* @__PURE__ */ from_html(`<div class="flowdrop-hero"><div class="flowdrop-hero__content"><div class="flowdrop-hero__icon">📦</div> <h3 class="flowdrop-hero__title">No node types available</h3> <p class="flowdrop-hero__description">Node type definitions will appear here</p> <div class="flowdrop-mb--4"><!></div></div></div>`);
var root_5$1 = /* @__PURE__ */ from_html(`<div class="flowdrop-mb--4"><!></div>`);
var root_4$1 = /* @__PURE__ */ from_html(`<div class="flowdrop-hero"><div class="flowdrop-hero__content"><div class="flowdrop-hero__icon">🔍</div> <h3 class="flowdrop-hero__title">No components found</h3> <p class="flowdrop-hero__description">Try adjusting your search</p> <!></div></div>`);
var root_7 = /* @__PURE__ */ from_html(`<div class="flowdrop-card flowdrop-card--compact flowdrop-node-item svelte-1xzgmpr" draggable="true" role="button" tabindex="0"><div class="flowdrop-card__body flowdrop-p--1 flowdrop-py--1 svelte-1xzgmpr"><div class="flowdrop-flex flowdrop-gap--2 flowdrop-items--center svelte-1xzgmpr"><div class="flowdrop-node-icon svelte-1xzgmpr"><!></div> <h4 class="flowdrop-text--sm flowdrop-font--medium flowdrop-truncate flowdrop-flex--1 svelte-1xzgmpr"> </h4></div> <p class="flowdrop-text--xs flowdrop-text--gray flowdrop-truncate flowdrop-mt--1 flowdrop-ml--0 svelte-1xzgmpr"> </p></div></div>`);
var root_6$1 = /* @__PURE__ */ from_html(`<div class="flowdrop-node-list svelte-1xzgmpr"></div>`);
var root_3$2 = /* @__PURE__ */ from_html(`<div class="flowdrop-p--4 svelte-1xzgmpr"><div class="flowdrop-divider"><h3 class="flowdrop-divider__text">Search Results</h3></div> <!></div>`);
var on_click$1 = (_2, handleNodeClick2, nodeType) => handleNodeClick2(get$3(nodeType));
var on_keydown$1 = (e, handleNodeClick2, nodeType) => {
  if (e.key === "Enter" || e.key === " ") {
    e.preventDefault();
    handleNodeClick2(get$3(nodeType));
  }
};
var root_11 = /* @__PURE__ */ from_html(`<div class="flowdrop-card flowdrop-card--compact flowdrop-node-item svelte-1xzgmpr" draggable="true" role="button" tabindex="0"><div class="flowdrop-card__body flowdrop-p--1 flowdrop-py--1 svelte-1xzgmpr"><div class="flowdrop-flex flowdrop-gap--2 flowdrop-items--center svelte-1xzgmpr"><div class="flowdrop-node-icon svelte-1xzgmpr"><!></div> <h4 class="flowdrop-text--sm flowdrop-font--medium flowdrop-truncate flowdrop-flex--1 svelte-1xzgmpr"> </h4></div> <p class="flowdrop-text--xs flowdrop-text--gray flowdrop-truncate flowdrop-mt--1 flowdrop-ml--0 svelte-1xzgmpr"> </p></div></div>`);
var root_10$1 = /* @__PURE__ */ from_html(`<details class="flowdrop-details"><summary class="flowdrop-details__summary"><div class="flowdrop-flex flowdrop-gap--2 flowdrop-items--center svelte-1xzgmpr"><span class="flowdrop-node-icon svelte-1xzgmpr"><!></span> <span> </span></div> <div class="flowdrop-badge flowdrop-badge--secondary"> </div></summary> <div class="flowdrop-details__content"><div class="flowdrop-node-list svelte-1xzgmpr"></div></div></details>`);
var root_8 = /* @__PURE__ */ from_html(`<div class="flowdrop-p--4 svelte-1xzgmpr"><div class="flowdrop-category-list svelte-1xzgmpr"></div></div>`);
var root_12$1 = /* @__PURE__ */ from_html(`<span class="flowdrop-text--xs flowdrop-text--gray">Loading components...</span>`);
var root_13 = /* @__PURE__ */ from_html(`<span class="flowdrop-text--xs flowdrop-text--gray"> </span> <span class="flowdrop-text--xs flowdrop-text--gray"> </span>`, 1);
var root$3 = /* @__PURE__ */ from_html(`<div class="flowdrop-sidebar flowdrop-sidebar--container svelte-1xzgmpr" role="complementary" aria-label="Components sidebar"><div class="flowdrop-sidebar__header svelte-1xzgmpr"><div class="flowdrop-sidebar__title svelte-1xzgmpr"><h2 class="flowdrop-text--lg flowdrop-font--bold svelte-1xzgmpr">Components</h2></div></div> <div class="flowdrop-sidebar__search svelte-1xzgmpr"><div class="flowdrop-join flowdrop-w--full svelte-1xzgmpr"><div class="flowdrop-join__item flowdrop-flex--1 svelte-1xzgmpr"><input type="text" placeholder="Search components..." class="flowdrop-input flowdrop-join__item flowdrop-w--full svelte-1xzgmpr"/></div> <button class="flowdrop-btn flowdrop-join__item svelte-1xzgmpr" aria-label="Search components"><!></button></div></div> <div class="flowdrop-sidebar__content svelte-1xzgmpr"><!></div> <div class="flowdrop-sidebar__footer svelte-1xzgmpr"><div class="flowdrop-flex flowdrop-gap--4"><div class="flowdrop-flex flowdrop-gap--4"><!></div></div></div></div>`);
function NodeSidebar($$anchor, $$props) {
  push($$props, true);
  let searchInput = /* @__PURE__ */ state("");
  let selectedCategory = proxy($$props.selectedCategory || "all");
  let filteredNodes = /* @__PURE__ */ user_derived(getFilteredNodes);
  let categories = /* @__PURE__ */ user_derived(getCategories);
  function getCategories() {
    const nodes = $$props.nodes || [];
    if (nodes.length === 0) return [];
    const categories2 = /* @__PURE__ */ new Set();
    nodes.forEach((node) => categories2.add(node.category));
    return Array.from(categories2).sort();
  }
  function getFilteredNodes() {
    let filtered = $$props.nodes || [];
    if (selectedCategory !== "all") {
      filtered = filtered.filter((node) => node.category === selectedCategory);
    }
    if (get$3(searchInput).trim()) {
      const query = get$3(searchInput).toLowerCase();
      filtered = filtered.filter((node) => {
        var _a2;
        return node.name.toLowerCase().includes(query) || node.description.toLowerCase().includes(query) || ((_a2 = node.tags) == null ? void 0 : _a2.some((tag) => tag.toLowerCase().includes(query)));
      });
    }
    return [...filtered].sort((a, b2) => a.name.localeCompare(b2.name));
  }
  function handleNodeDragStart(event2, nodeType) {
    if (!event2.dataTransfer) return;
    let initialConfig = {};
    if (nodeType.configSchema && typeof nodeType.configSchema === "object" && nodeType.configSchema.properties && typeof nodeType.configSchema.properties === "object") {
      Object.entries(nodeType.configSchema.properties).forEach(([key2, prop2]) => {
        if (prop2 && typeof prop2 === "object" && "default" in prop2) {
          initialConfig[key2] = prop2.default;
        }
      });
    }
    const newNodeData = {
      type: "node",
      nodeType: nodeType.id,
      nodeData: {
        label: nodeType.name,
        config: initialConfig,
        metadata: nodeType
      }
    };
    const jsonData = JSON.stringify(newNodeData);
    event2.dataTransfer.setData("application/json", jsonData);
    event2.dataTransfer.setData("text/plain", nodeType.name);
    event2.dataTransfer.effectAllowed = "copy";
    if (event2.target) {
      const rect = event2.target.getBoundingClientRect();
      event2.dataTransfer.setDragImage(event2.target, rect.width / 2, rect.height / 2);
    }
  }
  function handleNodeClick2(nodeType) {
    console.log("Node clicked:", nodeType.name);
  }
  function getCategoryDisplayName(category) {
    const names = {
      inputs: "Inputs",
      outputs: "Outputs",
      prompts: "Prompts",
      models: "Models",
      processing: "Processing",
      logic: "Logic",
      data: "Data",
      tools: "Tools",
      helpers: "Helpers",
      "vector stores": "Vector Stores",
      embeddings: "Embeddings",
      memories: "Memories",
      agents: "Agents",
      bundles: "Bundles"
    };
    return names[category] || category;
  }
  function getNodesForCategory(category) {
    const nodes = $$props.nodes || [];
    return [...nodes].filter((node) => node.category === category).sort((a, b2) => a.name.localeCompare(b2.name));
  }
  function getFilteredNodesForCategory(category) {
    let nodes = getNodesForCategory(category);
    if (get$3(searchInput).trim()) {
      const query = get$3(searchInput).toLowerCase();
      nodes = nodes.filter((node) => {
        var _a2;
        return node.name.toLowerCase().includes(query) || node.description.toLowerCase().includes(query) || ((_a2 = node.tags) == null ? void 0 : _a2.some((tag) => tag.toLowerCase().includes(query)));
      });
    }
    return nodes;
  }
  var div = root$3();
  var div_1 = sibling(child(div), 2);
  var div_2 = child(div_1);
  var div_3 = child(div_2);
  var input = child(div_3);
  input.__input = [handleSearchChange];
  var button = sibling(div_3, 2);
  var node_1 = child(button);
  Icon(node_1, { icon: "mdi:magnify", class: "flowdrop-icon" });
  var div_4 = sibling(div_1, 2);
  var node_2 = child(div_4);
  {
    var consequent = ($$anchor2) => {
      var div_5 = root_1$2();
      var div_6 = child(div_5);
      var div_7 = sibling(child(div_6), 6);
      var node_3 = child(div_7);
      LoadingSpinner(node_3, { size: "md", text: "Loading from server..." });
      append($$anchor2, div_5);
    };
    var alternate = ($$anchor2, $$elseif) => {
      {
        var consequent_3 = ($$anchor3) => {
          var div_8 = root_3$2();
          var node_4 = sibling(child(div_8), 2);
          {
            var consequent_2 = ($$anchor4) => {
              var div_9 = root_4$1();
              var div_10 = child(div_9);
              var node_5 = sibling(child(div_10), 6);
              {
                var consequent_1 = ($$anchor5) => {
                  var div_11 = root_5$1();
                  var node_6 = child(div_11);
                  LoadingSpinner(node_6, { size: "sm", text: "Loading components..." });
                  append($$anchor5, div_11);
                };
                if_block(node_5, ($$render) => {
                  var _a2;
                  if (((_a2 = $$props.nodes) == null ? void 0 : _a2.length) === 0) $$render(consequent_1);
                });
              }
              append($$anchor4, div_9);
            };
            var alternate_1 = ($$anchor4) => {
              var div_12 = root_6$1();
              each(div_12, 21, () => get$3(filteredNodes), (nodeType) => nodeType.id, ($$anchor5, nodeType) => {
                var div_13 = root_7();
                var div_14 = child(div_13);
                var div_15 = child(div_14);
                var div_16 = child(div_15);
                var node_7 = child(div_16);
                const expression = /* @__PURE__ */ user_derived(() => getNodeIcon(get$3(nodeType).icon, get$3(nodeType).category));
                Icon(node_7, {
                  get icon() {
                    return get$3(expression);
                  }
                });
                var h4 = sibling(div_16, 2);
                var text2 = child(h4);
                var p = sibling(div_15, 2);
                var text_1 = child(p);
                template_effect(
                  ($0) => {
                    set_style(div_16, `background-color: ${$0 != null ? $0 : ""}`);
                    set_text(text2, get$3(nodeType).name);
                    set_text(text_1, get$3(nodeType).description);
                  },
                  [
                    () => getCategoryColorToken(get$3(nodeType).category)
                  ]
                );
                event("dragstart", div_13, (e) => handleNodeDragStart(e, get$3(nodeType)));
                append($$anchor5, div_13);
              });
              append($$anchor4, div_12);
            };
            if_block(node_4, ($$render) => {
              if (get$3(filteredNodes).length === 0) $$render(consequent_2);
              else $$render(alternate_1, false);
            });
          }
          append($$anchor3, div_8);
        };
        var alternate_2 = ($$anchor3) => {
          var div_17 = root_8();
          var div_18 = child(div_17);
          each(div_18, 20, () => get$3(categories), (category) => category, ($$anchor4, category) => {
            var fragment = comment();
            const categoryNodes = /* @__PURE__ */ user_derived(() => getFilteredNodesForCategory(category));
            var node_8 = first_child(fragment);
            {
              var consequent_4 = ($$anchor5) => {
                var details = root_10$1();
                var summary = child(details);
                var div_19 = child(summary);
                var span = child(div_19);
                var node_9 = child(span);
                const expression_1 = /* @__PURE__ */ user_derived(() => getCategoryIcon(category));
                Icon(node_9, {
                  get icon() {
                    return get$3(expression_1);
                  }
                });
                var span_1 = sibling(span, 2);
                var text_2 = child(span_1);
                var div_20 = sibling(div_19, 2);
                var text_3 = child(div_20);
                var div_21 = sibling(summary, 2);
                var div_22 = child(div_21);
                each(div_22, 21, () => get$3(categoryNodes), (nodeType) => nodeType.id, ($$anchor6, nodeType) => {
                  var div_23 = root_11();
                  div_23.__click = [on_click$1, handleNodeClick2, nodeType];
                  div_23.__keydown = [on_keydown$1, handleNodeClick2, nodeType];
                  var div_24 = child(div_23);
                  var div_25 = child(div_24);
                  var div_26 = child(div_25);
                  var node_10 = child(div_26);
                  const expression_2 = /* @__PURE__ */ user_derived(() => getNodeIcon(get$3(nodeType).icon, get$3(nodeType).category));
                  Icon(node_10, {
                    get icon() {
                      return get$3(expression_2);
                    }
                  });
                  var h4_1 = sibling(div_26, 2);
                  var text_4 = child(h4_1);
                  var p_1 = sibling(div_25, 2);
                  var text_5 = child(p_1);
                  template_effect(
                    ($0) => {
                      set_style(div_26, `background-color: ${$0 != null ? $0 : ""}`);
                      set_text(text_4, get$3(nodeType).name);
                      set_text(text_5, get$3(nodeType).description);
                    },
                    [
                      () => getCategoryColorToken(get$3(nodeType).category)
                    ]
                  );
                  event("dragstart", div_23, (e) => handleNodeDragStart(e, get$3(nodeType)));
                  append($$anchor6, div_23);
                });
                template_effect(
                  ($0, $1) => {
                    set_style(span, `background-color: ${$0 != null ? $0 : ""}`);
                    set_text(text_2, $1);
                    set_text(text_3, get$3(categoryNodes).length);
                  },
                  [
                    () => getCategoryColorToken(category),
                    () => getCategoryDisplayName(category)
                  ]
                );
                append($$anchor5, details);
              };
              if_block(node_8, ($$render) => {
                if (get$3(categoryNodes).length > 0) $$render(consequent_4);
              });
            }
            append($$anchor4, fragment);
          });
          append($$anchor3, div_17);
        };
        if_block(
          $$anchor2,
          ($$render) => {
            if (get$3(searchInput).trim()) $$render(consequent_3);
            else $$render(alternate_2, false);
          },
          $$elseif
        );
      }
    };
    if_block(node_2, ($$render) => {
      var _a2;
      if (((_a2 = $$props.nodes) == null ? void 0 : _a2.length) === 0) $$render(consequent);
      else $$render(alternate, false);
    });
  }
  var div_27 = sibling(div_4, 2);
  var div_28 = child(div_27);
  var div_29 = child(div_28);
  var node_11 = child(div_29);
  {
    var consequent_5 = ($$anchor2) => {
      var span_2 = root_12$1();
      append($$anchor2, span_2);
    };
    var alternate_3 = ($$anchor2) => {
      var fragment_1 = root_13();
      var span_3 = first_child(fragment_1);
      var text_6 = child(span_3);
      var span_4 = sibling(span_3, 2);
      var text_7 = child(span_4);
      template_effect(() => {
        var _a2, _b2, _c2;
        set_text(text_6, `Total: ${(_b2 = ((_a2 = $$props.nodes) == null ? void 0 : _a2.length) || 0) != null ? _b2 : ""} components`);
        set_text(text_7, `Showing: ${(_c2 = get$3(filteredNodes).length) != null ? _c2 : ""}`);
      });
      append($$anchor2, fragment_1);
    };
    if_block(node_11, ($$render) => {
      var _a2;
      if (((_a2 = $$props.nodes) == null ? void 0 : _a2.length) === 0) $$render(consequent_5);
      else $$render(alternate_3, false);
    });
  }
  bind_value(input, () => get$3(searchInput), ($$value) => set$2(searchInput, $$value));
  append($$anchor, div);
  pop();
}
delegate(["input", "click", "keydown"]);
const sampleNodes = [
  // ===== INPUTS CATEGORY =====
  {
    id: "sample-text-input",
    name: "Text Input",
    type: "simple",
    supportedTypes: ["simple", "default"],
    version: "1.0.0",
    description: "User text input field",
    category: "inputs",
    icon: "mdi:text-box",
    color: "#10b981",
    inputs: [],
    outputs: [
      {
        id: "text",
        name: "Text",
        type: "output",
        dataType: "string",
        description: "User entered text"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        nodeType: {
          type: "string",
          title: "Node Type",
          description: "Choose the visual representation for this node",
          default: "simple",
          enum: ["simple", "square", "default"],
          enumNames: [
            "Simple (compact layout)",
            "Square (square layout)",
            "Default (standard workflow node)"
          ]
        },
        placeholder: {
          type: "string",
          title: "Placeholder",
          description: "Placeholder text for the input field",
          default: "Enter text..."
        },
        defaultValue: {
          type: "string",
          title: "Default Value",
          description: "Default text value",
          default: ""
        }
      }
    },
    tags: ["input", "text", "user"]
  },
  {
    id: "sample-file-upload",
    name: "File Upload",
    type: "simple",
    supportedTypes: ["simple", "default"],
    version: "1.0.0",
    description: "File upload input with drag and drop support",
    category: "inputs",
    icon: "mdi:file-upload",
    color: "#f59e0b",
    inputs: [],
    outputs: [
      {
        id: "file",
        name: "File",
        type: "output",
        dataType: "file",
        description: "Uploaded file data"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        nodeType: {
          type: "string",
          title: "Node Type",
          description: "Choose the visual representation for this node",
          default: "simple",
          enum: ["simple", "square", "default"],
          enumNames: [
            "Simple (compact layout)",
            "Square (square layout)",
            "Default (standard workflow node)"
          ]
        },
        accept: {
          type: "string",
          title: "Accepted File Types",
          description: "Comma-separated list of accepted file types",
          default: "*"
        },
        maxSize: {
          type: "number",
          title: "Maximum File Size (MB)",
          description: "Maximum file size in megabytes",
          default: 10
        }
      }
    },
    tags: ["input", "file", "upload"]
  },
  {
    id: "sample-webhook",
    name: "Webhook",
    type: "simple",
    supportedTypes: ["simple", "default"],
    version: "1.0.0",
    description: "Receive data from external webhooks",
    category: "inputs",
    icon: "mdi:webhook",
    color: "#8b5cf6",
    inputs: [],
    outputs: [
      {
        id: "data",
        name: "Data",
        type: "output",
        dataType: "json",
        description: "Webhook payload data"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        nodeType: {
          type: "string",
          title: "Node Type",
          description: "Choose the visual representation for this node",
          default: "simple",
          enum: ["simple", "square", "default"],
          enumNames: [
            "Simple (compact layout)",
            "Square (square layout)",
            "Default (standard workflow node)"
          ]
        },
        endpoint: {
          type: "string",
          title: "Endpoint",
          description: "Webhook endpoint URL",
          default: ""
        },
        method: {
          type: "string",
          title: "HTTP Method",
          description: "HTTP method for the webhook",
          default: "POST",
          enum: ["GET", "POST", "PUT", "DELETE"]
        }
      }
    },
    tags: ["input", "webhook", "external"]
  },
  // ===== OUTPUTS CATEGORY =====
  {
    id: "sample-chat-output",
    name: "Chat Output",
    type: "simple",
    supportedTypes: ["simple", "default"],
    version: "1.0.0",
    description: "Display chat-style output with formatting",
    category: "outputs",
    icon: "mdi:chat",
    color: "#8b5cf6",
    inputs: [
      {
        id: "message",
        name: "Message",
        type: "input",
        dataType: "string",
        required: true,
        description: "Message to display"
      }
    ],
    outputs: [],
    configSchema: {
      type: "object",
      properties: {
        nodeType: {
          type: "string",
          title: "Node Type",
          description: "Choose the visual representation for this node",
          default: "simple",
          enum: ["simple", "square", "default"],
          enumNames: [
            "Simple (compact layout)",
            "Square (square layout)",
            "Default (standard workflow node)"
          ]
        },
        showTimestamp: {
          type: "boolean",
          title: "Show Timestamp",
          description: "Display timestamp with messages",
          default: true
        },
        maxLength: {
          type: "number",
          title: "Maximum Length",
          description: "Maximum message length",
          default: 2e3
        },
        markdown: {
          type: "boolean",
          title: "Markdown Support",
          description: "Enable markdown formatting",
          default: true
        }
      }
    },
    tags: ["output", "chat", "display"]
  },
  {
    id: "sample-text-output",
    name: "Text Output",
    type: "simple",
    supportedTypes: ["simple", "default"],
    version: "1.0.0",
    description: "Display plain text output",
    category: "outputs",
    icon: "mdi:text-box",
    color: "#10b981",
    inputs: [
      {
        id: "text",
        name: "Text",
        type: "input",
        dataType: "string",
        required: true,
        description: "Text to display"
      }
    ],
    outputs: [],
    configSchema: {
      type: "object",
      properties: {
        nodeType: {
          type: "string",
          title: "Node Type",
          description: "Choose the visual representation for this node",
          default: "simple",
          enum: ["simple", "square", "default"],
          enumNames: [
            "Simple (compact layout)",
            "Square (square layout)",
            "Default (standard workflow node)"
          ]
        },
        showTimestamp: {
          type: "boolean",
          title: "Show Timestamp",
          description: "Display timestamp with output",
          default: false
        },
        maxLength: {
          type: "number",
          title: "Maximum Length",
          description: "Maximum text length",
          default: 1e3
        }
      }
    },
    tags: ["output", "text", "display"]
  },
  // ===== PROMPTS CATEGORY =====
  {
    id: "sample-prompt",
    name: "Prompt",
    type: "simple",
    supportedTypes: ["simple", "default"],
    version: "1.0.0",
    description: "Template-based prompt with variables",
    category: "prompts",
    icon: "mdi:message-text",
    color: "#f59e0b",
    inputs: [
      {
        id: "variables",
        name: "Variables",
        type: "input",
        dataType: "json",
        required: false,
        description: "Variables to inject into template"
      }
    ],
    outputs: [
      {
        id: "prompt",
        name: "Prompt",
        type: "output",
        dataType: "string",
        description: "Formatted prompt text"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        nodeType: {
          type: "string",
          title: "Node Type",
          description: "Choose the visual representation for this node",
          default: "simple",
          enum: ["simple", "square", "default"],
          enumNames: [
            "Simple (compact layout)",
            "Square (square layout)",
            "Default (standard workflow node)"
          ]
        },
        template: {
          type: "string",
          title: "Template",
          description: "Prompt template with variables",
          default: "You are a helpful assistant. {input}"
        },
        variables: {
          type: "array",
          title: "Variables",
          description: "List of available variables",
          default: []
        }
      }
    },
    tags: ["prompt", "template", "variables"]
  },
  {
    id: "sample-structured-output",
    name: "Structured Output",
    type: "default",
    supportedTypes: ["default"],
    version: "1.0.0",
    description: "Generate structured output from models",
    category: "prompts",
    icon: "mdi:table",
    color: "#6366f1",
    inputs: [
      {
        id: "model",
        name: "Model",
        type: "input",
        dataType: "json",
        required: true,
        description: "Model to use"
      },
      {
        id: "message",
        name: "Message",
        type: "input",
        dataType: "string",
        required: true,
        description: "Input message"
      }
    ],
    outputs: [
      {
        id: "dataframe",
        name: "DataFrame",
        type: "output",
        dataType: "json",
        description: "Structured output as DataFrame"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        schema: {
          type: "object",
          title: "Schema",
          description: "JSON schema for structured output",
          default: {}
        },
        outputType: {
          type: "string",
          title: "Output Type",
          description: "Type of structured output",
          default: "json",
          enum: ["json", "xml", "yaml"]
        }
      }
    },
    tags: ["prompt", "structured", "output", "schema"]
  },
  // ===== MODELS CATEGORY =====
  {
    id: "sample-openai",
    name: "OpenAI",
    type: "default",
    supportedTypes: ["default"],
    version: "1.0.0",
    description: "OpenAI GPT models for text generation",
    category: "models",
    icon: "mdi:robot",
    color: "#10a37f",
    inputs: [
      {
        id: "prompt",
        name: "Prompt",
        type: "input",
        dataType: "string",
        required: true,
        description: "Input prompt for the model"
      },
      {
        id: "system_message",
        name: "System Message",
        type: "input",
        dataType: "string",
        required: false,
        description: "System message to set behavior"
      }
    ],
    outputs: [
      {
        id: "response",
        name: "Response",
        type: "output",
        dataType: "string",
        description: "Model response"
      },
      {
        id: "usage",
        name: "Usage",
        type: "output",
        dataType: "json",
        description: "Token usage information"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        model: {
          type: "string",
          title: "Model",
          description: "OpenAI model to use",
          default: "gpt-3.5-turbo",
          enum: ["gpt-3.5-turbo", "gpt-4", "gpt-4-turbo"]
        },
        temperature: {
          type: "number",
          title: "Temperature",
          description: "Creativity level (0-2)",
          default: 0.7,
          minimum: 0,
          maximum: 2
        },
        maxTokens: {
          type: "number",
          title: "Max Tokens",
          description: "Maximum tokens to generate",
          default: 1e3,
          minimum: 1,
          maximum: 4e3
        },
        apiKey: {
          type: "string",
          title: "API Key",
          description: "OpenAI API key",
          default: ""
        }
      }
    },
    tags: ["model", "openai", "gpt", "chat"]
  },
  {
    id: "sample-anthropic",
    name: "Anthropic",
    type: "default",
    supportedTypes: ["default"],
    version: "1.0.0",
    description: "Anthropic Claude models for text generation",
    category: "models",
    icon: "mdi:brain",
    color: "#7c3aed",
    inputs: [
      {
        id: "prompt",
        name: "Prompt",
        type: "input",
        dataType: "string",
        required: true,
        description: "Input prompt for the model"
      }
    ],
    outputs: [
      {
        id: "response",
        name: "Response",
        type: "output",
        dataType: "string",
        description: "Model response"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        model: {
          type: "string",
          title: "Model",
          description: "Anthropic model to use",
          default: "claude-3-sonnet-20240229",
          enum: ["claude-3-sonnet-20240229", "claude-3-opus-20240229", "claude-3-haiku-20240307"]
        },
        temperature: {
          type: "number",
          title: "Temperature",
          description: "Creativity level (0-1)",
          default: 0.7,
          minimum: 0,
          maximum: 1
        },
        maxTokens: {
          type: "number",
          title: "Max Tokens",
          description: "Maximum tokens to generate",
          default: 1e3,
          minimum: 1,
          maximum: 4e3
        },
        apiKey: {
          type: "string",
          title: "API Key",
          description: "Anthropic API key",
          default: ""
        }
      }
    },
    tags: ["model", "anthropic", "claude"]
  },
  {
    id: "sample-groq",
    name: "Groq",
    type: "default",
    supportedTypes: ["default"],
    version: "1.0.0",
    description: "Groq fast inference models",
    category: "models",
    icon: "mdi:lightning-bolt",
    color: "#f97316",
    inputs: [
      {
        id: "prompt",
        name: "Prompt",
        type: "input",
        dataType: "string",
        required: true,
        description: "Input prompt for the model"
      }
    ],
    outputs: [
      {
        id: "response",
        name: "Response",
        type: "output",
        dataType: "string",
        description: "Model response"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        model: {
          type: "string",
          title: "Model",
          description: "Groq model to use",
          default: "llama-3.1-8b-instant",
          enum: ["llama-3.1-8b-instant", "llama-3.1-70b-versatile", "mixtral-8x7b-32768"]
        },
        temperature: {
          type: "number",
          title: "Temperature",
          description: "Creativity level (0-1)",
          default: 0.7,
          minimum: 0,
          maximum: 1
        },
        maxTokens: {
          type: "number",
          title: "Max Tokens",
          description: "Maximum tokens to generate",
          default: 1e3,
          minimum: 1,
          maximum: 4e3
        },
        apiKey: {
          type: "string",
          title: "API Key",
          description: "Groq API key",
          default: ""
        }
      }
    },
    tags: ["model", "groq", "fast", "inference"]
  },
  // ===== PROCESSING CATEGORY =====
  {
    id: "sample-split-text",
    name: "Split Text",
    type: "default",
    supportedTypes: ["default"],
    version: "1.0.0",
    description: "Split text into chunks for processing",
    category: "processing",
    icon: "mdi:content-cut",
    color: "#f59e0b",
    inputs: [
      {
        id: "text",
        name: "Text",
        type: "input",
        dataType: "string",
        required: true,
        description: "Text to split"
      }
    ],
    outputs: [
      {
        id: "chunks",
        name: "Chunks",
        type: "output",
        dataType: "string[]",
        description: "Split text chunks"
      },
      {
        id: "dataframe",
        name: "DataFrame",
        type: "output",
        dataType: "json",
        description: "Chunks as structured data"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        chunkSize: {
          type: "number",
          title: "Chunk Size",
          description: "Size of each text chunk",
          default: 1e3,
          minimum: 1,
          maximum: 1e4
        },
        chunkOverlap: {
          type: "number",
          title: "Chunk Overlap",
          description: "Overlap between chunks",
          default: 200,
          minimum: 0,
          maximum: 1e3
        },
        separator: {
          type: "string",
          title: "Separator",
          description: "Text separator for splitting",
          default: "\n"
        }
      }
    },
    tags: ["processing", "text", "split", "chunking"]
  },
  {
    id: "sample-data-operations",
    name: "Data Operations",
    version: "1.0.0",
    description: "Perform operations on Data objects",
    category: "processing",
    icon: "mdi:database-cog",
    color: "#6366f1",
    inputs: [
      {
        id: "data",
        name: "Data",
        type: "input",
        dataType: "json",
        required: true,
        description: "Data to operate on"
      }
    ],
    outputs: [
      {
        id: "result",
        name: "Result",
        type: "output",
        dataType: "json",
        description: "Processed data result"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        operation: {
          type: "string",
          title: "Operation",
          description: "Data operation to perform",
          default: "select_keys",
          enum: ["select_keys", "filter", "sort", "group"]
        },
        keys: {
          type: "array",
          title: "Keys",
          description: "Keys to select or filter by",
          default: []
        },
        filterKey: {
          type: "string",
          title: "Filter Key",
          description: "Key to filter by",
          default: ""
        },
        filterValue: {
          type: "string",
          title: "Filter Value",
          description: "Value to filter by",
          default: ""
        }
      }
    },
    tags: ["processing", "data", "operations"]
  },
  {
    id: "sample-dataframe-operations",
    name: "DataFrame Operations",
    version: "1.0.0",
    description: "Perform operations on DataFrames",
    category: "processing",
    icon: "mdi:table-cog",
    color: "#84cc16",
    inputs: [
      {
        id: "dataframe",
        name: "DataFrame",
        type: "input",
        dataType: "json",
        required: true,
        description: "DataFrame to operate on"
      }
    ],
    outputs: [
      {
        id: "result",
        name: "Result",
        type: "output",
        dataType: "json",
        description: "Processed DataFrame"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        operation: {
          type: "string",
          title: "Operation",
          description: "DataFrame operation to perform",
          default: "filter",
          enum: ["filter", "sort", "group", "aggregate"]
        },
        columnName: {
          type: "string",
          title: "Column Name",
          description: "Column to operate on",
          default: ""
        },
        filterValue: {
          type: "string",
          title: "Filter Value",
          description: "Value to filter by",
          default: ""
        },
        ascending: {
          type: "boolean",
          title: "Ascending",
          description: "Sort in ascending order",
          default: true
        }
      }
    },
    tags: ["processing", "dataframe", "table", "operations"]
  },
  {
    id: "sample-regex-extractor",
    name: "Regex Extractor",
    version: "1.0.0",
    description: "Extract patterns using regular expressions",
    category: "processing",
    icon: "mdi:regex",
    color: "#ec4899",
    inputs: [
      {
        id: "text",
        name: "Text",
        type: "input",
        dataType: "string",
        required: true,
        description: "Text to extract from"
      }
    ],
    outputs: [
      {
        id: "matches",
        name: "Matches",
        type: "output",
        dataType: "string[]",
        description: "Extracted matches"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        pattern: {
          type: "string",
          title: "Pattern",
          description: "Regular expression pattern",
          default: ""
        },
        flags: {
          type: "string",
          title: "Flags",
          description: "Regex flags",
          default: "g",
          enum: ["g", "i", "m", "gi", "gm", "im", "gim"]
        }
      }
    },
    tags: ["processing", "regex", "extract", "pattern"]
  },
  {
    id: "sample-smart-function",
    name: "Smart Function",
    version: "1.0.0",
    description: "Use models to generate data processing functions",
    category: "processing",
    icon: "mdi:function-variant",
    color: "#06b6d4",
    inputs: [
      {
        id: "data",
        name: "Data",
        type: "input",
        dataType: "json",
        required: true,
        description: "Data to process"
      },
      {
        id: "model",
        name: "Model",
        type: "input",
        dataType: "json",
        required: true,
        description: "Model for function generation"
      }
    ],
    outputs: [
      {
        id: "filtered_data",
        name: "Filtered Data",
        type: "output",
        dataType: "json",
        description: "Processed data"
      },
      {
        id: "dataframe",
        name: "DataFrame",
        type: "output",
        dataType: "json",
        description: "Processed data as DataFrame"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        filter_instruction: {
          type: "string",
          title: "Filter Instruction",
          description: "Instruction for filtering data",
          default: ""
        },
        sample_size: {
          type: "number",
          title: "Sample Size",
          description: "Number of samples to process",
          default: 1e3,
          minimum: 1,
          maximum: 1e4
        },
        max_size: {
          type: "number",
          title: "Max Size",
          description: "Maximum size of filtered data",
          default: 1e4,
          minimum: 1,
          maximum: 1e5
        }
      }
    },
    tags: ["processing", "smart", "function", "model"]
  },
  // ===== LOGIC CATEGORY =====
  {
    id: "sample-if-else",
    name: "If-Else",
    version: "1.0.0",
    description: "Conditional routing based on text comparison",
    category: "logic",
    icon: "mdi:git-branch",
    color: "#06b6d4",
    inputs: [
      {
        id: "input_text",
        name: "Input Text",
        type: "input",
        dataType: "string",
        required: true,
        description: "Text to evaluate"
      },
      {
        id: "match_text",
        name: "Match Text",
        type: "input",
        dataType: "string",
        required: true,
        description: "Text to compare against"
      }
    ],
    outputs: [
      {
        id: "true_result",
        name: "True",
        type: "output",
        dataType: "string",
        description: "Output when condition is true"
      },
      {
        id: "false_result",
        name: "False",
        type: "output",
        dataType: "string",
        description: "Output when condition is false"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        operator: {
          type: "string",
          title: "Operator",
          description: "Comparison operator",
          default: "equals",
          enum: ["equals", "not_equals", "greater_than", "less_than", "contains"]
        },
        caseSensitive: {
          type: "boolean",
          title: "Case Sensitive",
          description: "Whether comparison is case sensitive",
          default: false
        }
      }
    },
    tags: ["conditional", "logic", "routing", "if-else"]
  },
  {
    id: "sample-loop",
    name: "Loop",
    version: "1.0.0",
    description: "Iterate over data items",
    category: "logic",
    icon: "mdi:loop",
    color: "#8b5cf6",
    inputs: [
      {
        id: "data",
        name: "Data",
        type: "input",
        dataType: "json[]",
        required: true,
        description: "Data to iterate over"
      }
    ],
    outputs: [
      {
        id: "item",
        name: "Item",
        type: "output",
        dataType: "json",
        description: "Current item in iteration"
      },
      {
        id: "done",
        name: "Done",
        type: "output",
        dataType: "json",
        description: "Aggregated results when complete"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        maxIterations: {
          type: "number",
          title: "Max Iterations",
          description: "Maximum number of loop iterations",
          default: 100,
          minimum: 1,
          maximum: 1e3
        }
      }
    },
    tags: ["conditional", "logic", "loop", "iteration"]
  },
  // ===== DATA CATEGORY =====
  {
    id: "sample-data-to-dataframe",
    name: "Data to DataFrame",
    version: "1.0.0",
    description: "Convert Data objects to DataFrame",
    category: "data",
    icon: "mdi:table-plus",
    color: "#10b981",
    inputs: [
      {
        id: "data_list",
        name: "Data List",
        type: "input",
        dataType: "json[]",
        required: true,
        description: "List of Data objects to convert"
      }
    ],
    outputs: [
      {
        id: "dataframe",
        name: "DataFrame",
        type: "output",
        dataType: "json",
        description: "Converted DataFrame"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        includeText: {
          type: "boolean",
          title: "Include Text",
          description: "Include text in DataFrame conversion",
          default: true
        }
      }
    },
    tags: ["data", "dataframe", "convert", "table"]
  },
  {
    id: "sample-message-to-data",
    name: "Message to Data",
    version: "1.0.0",
    description: "Convert Message objects to Data objects",
    category: "data",
    icon: "mdi:message-arrow-right",
    color: "#f59e0b",
    inputs: [
      {
        id: "message",
        name: "Message",
        type: "input",
        dataType: "string",
        required: true,
        description: "Message to convert"
      }
    ],
    outputs: [
      {
        id: "data",
        name: "Data",
        type: "output",
        dataType: "json",
        description: "Converted Data object"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        format: {
          type: "string",
          title: "Format",
          description: "Input data format",
          default: "auto",
          enum: ["auto", "json", "csv", "xml"]
        }
      }
    },
    tags: ["data", "message", "convert"]
  },
  {
    id: "sample-save-to-file",
    name: "Save to File",
    version: "1.0.0",
    description: "Save data to various file formats",
    category: "data",
    icon: "mdi:content-save",
    color: "#ef4444",
    inputs: [
      {
        id: "data",
        name: "Data",
        type: "input",
        dataType: "json",
        required: true,
        description: "Data to save"
      }
    ],
    outputs: [
      {
        id: "confirmation",
        name: "Confirmation",
        type: "output",
        dataType: "string",
        description: "Save confirmation message"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        fileFormat: {
          type: "string",
          title: "File Format",
          description: "Output file format",
          default: "json",
          enum: ["json", "csv", "txt", "xml"]
        },
        filePath: {
          type: "string",
          title: "File Path",
          description: "Output file path",
          default: "./output/data.json"
        }
      }
    },
    tags: ["data", "save", "file", "export"]
  },
  // ===== TOOLS CATEGORY =====
  {
    id: "sample-http-request",
    name: "HTTP Request",
    type: "tool",
    supportedTypes: ["tool", "default"],
    version: "1.0.0",
    description: "Advanced HTTP client with full request/response handling, similar to n8n",
    category: "tools",
    icon: "mdi:web",
    color: "#3b82f6",
    inputs: [
      {
        id: "url",
        name: "URL",
        type: "input",
        dataType: "string",
        required: false,
        description: "Request URL (can be set in config or via input)"
      },
      {
        id: "headers",
        name: "Headers",
        type: "input",
        dataType: "json",
        required: false,
        description: "Additional HTTP headers as JSON object"
      },
      {
        id: "body",
        name: "Body",
        type: "input",
        dataType: "mixed",
        required: false,
        description: "Request body (JSON, string, or form data)"
      },
      {
        id: "query_params",
        name: "Query Parameters",
        type: "input",
        dataType: "json",
        required: false,
        description: "URL query parameters as JSON object"
      }
    ],
    outputs: [
      {
        id: "response",
        name: "Response",
        type: "output",
        dataType: "json",
        description: "Complete HTTP response object"
      },
      {
        id: "body",
        name: "Body",
        type: "output",
        dataType: "mixed",
        description: "Response body (parsed JSON or raw text)"
      },
      {
        id: "headers",
        name: "Headers",
        type: "output",
        dataType: "json",
        description: "Response headers as JSON object"
      },
      {
        id: "status_code",
        name: "Status Code",
        type: "output",
        dataType: "number",
        description: "HTTP status code"
      },
      {
        id: "status_text",
        name: "Status Text",
        type: "output",
        dataType: "string",
        description: "HTTP status text"
      },
      {
        id: "tool",
        name: "Tool Interface",
        type: "output",
        dataType: "tool",
        description: "Tool interface for agent connections - provides tool metadata and callable interface"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        nodeType: {
          type: "string",
          title: "Node Type",
          description: "Choose the visual representation for this node",
          default: "tool",
          enum: ["tool", "default"],
          enumNames: ["Tool Node (with metadata port)", "Default Node (standard ports)"]
        },
        method: {
          type: "string",
          title: "HTTP Method",
          description: "HTTP request method",
          default: "GET",
          enum: ["GET", "POST", "PUT", "PATCH", "DELETE", "HEAD", "OPTIONS"]
        },
        url: {
          type: "string",
          title: "URL",
          description: "Request URL (overridden by input if provided)",
          default: "https://api.example.com/endpoint"
        },
        authentication: {
          type: "string",
          title: "Authentication",
          description: "Authentication method",
          default: "none",
          enum: ["none", "basic", "bearer", "api_key", "oauth2"]
        },
        auth_username: {
          type: "string",
          title: "Username",
          description: "Username for basic authentication",
          default: ""
        },
        auth_password: {
          type: "string",
          title: "Password",
          description: "Password for basic authentication",
          default: "",
          format: "password"
        },
        auth_token: {
          type: "string",
          title: "Bearer Token",
          description: "Bearer token for authentication",
          default: "",
          format: "password"
        },
        api_key_header: {
          type: "string",
          title: "API Key Header",
          description: "Header name for API key authentication",
          default: "X-API-Key"
        },
        api_key_value: {
          type: "string",
          title: "API Key Value",
          description: "API key value",
          default: "",
          format: "password"
        },
        content_type: {
          type: "string",
          title: "Content Type",
          description: "Request content type",
          default: "application/json",
          enum: [
            "application/json",
            "application/x-www-form-urlencoded",
            "multipart/form-data",
            "text/plain",
            "text/xml",
            "application/xml"
          ]
        },
        timeout: {
          type: "integer",
          title: "Timeout (seconds)",
          description: "Request timeout in seconds",
          default: 30,
          minimum: 1,
          maximum: 300
        },
        follow_redirects: {
          type: "boolean",
          title: "Follow Redirects",
          description: "Automatically follow HTTP redirects",
          default: true
        },
        ssl_verify: {
          type: "boolean",
          title: "Verify SSL",
          description: "Verify SSL certificates",
          default: true
        },
        retry_attempts: {
          type: "integer",
          title: "Retry Attempts",
          description: "Number of retry attempts on failure",
          default: 0,
          minimum: 0,
          maximum: 5
        },
        retry_delay: {
          type: "integer",
          title: "Retry Delay (ms)",
          description: "Delay between retry attempts in milliseconds",
          default: 1e3,
          minimum: 100,
          maximum: 1e4
        },
        response_format: {
          type: "string",
          title: "Response Format",
          description: "How to parse the response body",
          default: "auto",
          enum: ["auto", "json", "text", "binary", "xml"]
        },
        include_response_headers: {
          type: "boolean",
          title: "Include Response Headers",
          description: "Include response headers in output",
          default: true
        },
        custom_headers: {
          type: "string",
          title: "Custom Headers (JSON)",
          description: "Custom headers as JSON string",
          default: "{}",
          format: "multiline"
        },
        user_agent: {
          type: "string",
          title: "User Agent",
          description: "Custom User-Agent header",
          default: "FlowDrop-HTTP-Client/1.0"
        },
        proxy_url: {
          type: "string",
          title: "Proxy URL",
          description: "HTTP proxy URL (optional)",
          default: ""
        },
        ignore_ssl_issues: {
          type: "boolean",
          title: "Ignore SSL Issues",
          description: "Ignore SSL certificate errors (not recommended for production)",
          default: false
        }
      }
    },
    tags: ["tools", "http", "api", "request", "n8n", "automation", "integration"]
  },
  {
    id: "sample-json",
    name: "JSON",
    type: "tool",
    supportedTypes: ["tool", "default"],
    version: "1.0.0",
    description: "Parse, manipulate, and transform JSON data like n8n's JSON node",
    category: "tools",
    icon: "mdi:code-json",
    color: "#f59e0b",
    inputs: [
      {
        id: "json_input",
        name: "JSON Input",
        type: "input",
        dataType: "mixed",
        required: false,
        description: "JSON data to process"
      }
    ],
    outputs: [
      {
        id: "json_output",
        name: "JSON Output",
        type: "output",
        dataType: "json",
        description: "Processed JSON data"
      },
      {
        id: "tool",
        name: "Tool Interface",
        type: "output",
        dataType: "tool",
        description: "Tool interface for agent connections - provides tool metadata and callable interface"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        nodeType: {
          type: "string",
          title: "Node Type",
          description: "Choose the visual representation for this node",
          default: "tool",
          enum: ["tool", "default"],
          enumNames: ["Tool Node (with metadata port)", "Default Node (standard ports)"]
        },
        operation: {
          type: "string",
          title: "Operation",
          description: "JSON operation to perform",
          default: "parse",
          enum: ["parse", "stringify", "extract", "merge", "filter", "transform", "validate"]
        },
        json_path: {
          type: "string",
          title: "JSON Path",
          description: "JSONPath expression for extraction (e.g., $.data.items[*].name)",
          default: "$"
        },
        merge_strategy: {
          type: "string",
          title: "Merge Strategy",
          description: "How to merge JSON objects",
          default: "deep",
          enum: ["shallow", "deep", "overwrite"]
        },
        filter_expression: {
          type: "string",
          title: "Filter Expression",
          description: "JavaScript expression for filtering (e.g., item.price > 100)",
          default: ""
        },
        transform_expression: {
          type: "string",
          title: "Transform Expression",
          description: "JavaScript expression for transformation",
          default: "",
          format: "multiline"
        },
        pretty_print: {
          type: "boolean",
          title: "Pretty Print",
          description: "Format JSON output with indentation",
          default: true
        },
        validate_schema: {
          type: "string",
          title: "JSON Schema",
          description: "JSON Schema for validation (optional)",
          default: "",
          format: "multiline"
        }
      }
    },
    tags: ["tools", "json", "data", "transform", "n8n", "parse"]
  },
  {
    id: "sample-set",
    name: "Set",
    type: "tool",
    supportedTypes: ["tool", "default"],
    version: "1.0.0",
    description: "Set and manipulate data values like n8n's Set node",
    category: "tools",
    icon: "mdi:variable",
    color: "#10b981",
    inputs: [
      {
        id: "input_data",
        name: "Input Data",
        type: "input",
        dataType: "mixed",
        required: false,
        description: "Input data to process"
      }
    ],
    outputs: [
      {
        id: "output_data",
        name: "Output Data",
        type: "output",
        dataType: "json",
        description: "Processed output data"
      },
      {
        id: "tool",
        name: "Tool Interface",
        type: "output",
        dataType: "tool",
        description: "Tool interface for agent connections - provides tool metadata and callable interface"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        nodeType: {
          type: "string",
          title: "Node Type",
          description: "Choose the visual representation for this node",
          default: "tool",
          enum: ["tool", "default"],
          enumNames: ["Tool Node (with metadata port)", "Default Node (standard ports)"]
        },
        operation: {
          type: "string",
          title: "Operation",
          description: "Set operation to perform",
          default: "set",
          enum: ["set", "append", "prepend", "remove", "rename", "copy", "move"]
        },
        keep_only_set: {
          type: "boolean",
          title: "Keep Only Set Fields",
          description: "Only keep the fields that are being set",
          default: false
        },
        values: {
          type: "string",
          title: "Values (JSON)",
          description: "Values to set as JSON object",
          default: '{\n  "key1": "value1",\n  "key2": "{{ $json.input_field }}",\n  "timestamp": "{{ new Date().toISOString() }}"\n}',
          format: "multiline"
        },
        include_binary_data: {
          type: "boolean",
          title: "Include Binary Data",
          description: "Include binary data in output",
          default: false
        },
        dot_notation: {
          type: "boolean",
          title: "Use Dot Notation",
          description: "Support dot notation for nested properties (e.g., user.name)",
          default: true
        }
      }
    },
    tags: ["tools", "set", "data", "transform", "n8n", "variables"]
  },
  {
    id: "sample-calculator",
    name: "Calculator",
    type: "tool",
    supportedTypes: ["tool", "default"],
    version: "1.0.0",
    description: "Perform mathematical calculations",
    category: "tools",
    icon: "mdi:calculator",
    color: "#6366f1",
    inputs: [
      {
        id: "expression",
        name: "Expression",
        type: "input",
        dataType: "string",
        required: true,
        description: "Mathematical expression to evaluate"
      }
    ],
    outputs: [
      {
        id: "result",
        name: "Result",
        type: "output",
        dataType: "number",
        description: "Calculation result"
      },
      {
        id: "tool",
        name: "Tool Interface",
        type: "output",
        dataType: "tool",
        description: "Tool interface for agent connections - provides tool metadata and callable interface"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        nodeType: {
          type: "string",
          title: "Node Type",
          description: "Choose the visual representation for this node",
          default: "tool",
          enum: ["tool", "default"],
          enumNames: ["Tool Node (with metadata port)", "Default Node (standard ports)"]
        },
        operation: {
          type: "string",
          title: "Operation",
          description: "Mathematical operation to perform",
          default: "add",
          enum: [
            "add",
            "subtract",
            "multiply",
            "divide",
            "power",
            "sqrt",
            "average",
            "min",
            "max",
            "median",
            "mode"
          ]
        },
        precision: {
          type: "integer",
          title: "Precision",
          description: "Number of decimal places",
          default: 2,
          minimum: 0,
          maximum: 10
        }
      }
    },
    tags: ["tools", "calculator", "math", "compute"]
  },
  {
    id: "sample-date-time",
    name: "Date & Time",
    type: "tool",
    supportedTypes: ["tool", "default"],
    version: "1.0.0",
    description: "Handle date and time operations",
    category: "tools",
    icon: "mdi:calendar-clock",
    color: "#84cc16",
    inputs: [
      {
        id: "date",
        name: "Date",
        type: "input",
        dataType: "string",
        required: false,
        description: "Input date string"
      }
    ],
    outputs: [
      {
        id: "formatted_date",
        name: "Formatted Date",
        type: "output",
        dataType: "string",
        description: "Formatted date string"
      },
      {
        id: "timestamp",
        name: "Timestamp",
        type: "output",
        dataType: "number",
        description: "Unix timestamp"
      },
      {
        id: "tool",
        name: "Tool Interface",
        type: "output",
        dataType: "tool",
        description: "Tool interface for agent connections - provides tool metadata and callable interface"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        nodeType: {
          type: "string",
          title: "Node Type",
          description: "Choose the visual representation for this node",
          default: "tool",
          enum: ["tool", "default"],
          enumNames: ["Tool Node (with metadata port)", "Default Node (standard ports)"]
        },
        format: {
          type: "string",
          title: "Format",
          description: "Date/time format",
          default: "YYYY-MM-DD"
        },
        timezone: {
          type: "string",
          title: "Timezone",
          description: "Timezone for date operations",
          default: "UTC"
        }
      }
    },
    tags: ["tools", "date", "time", "format"]
  },
  {
    id: "sample-notes",
    name: "Notes",
    type: "note",
    supportedTypes: ["note"],
    version: "1.0.0",
    description: "Add documentation and comments to your workflow with Markdown support",
    category: "tools",
    icon: "mdi:note-text",
    color: "#fbbf24",
    inputs: [],
    outputs: [],
    configSchema: {
      type: "object",
      properties: {
        content: {
          type: "string",
          title: "Note Content",
          description: "Documentation or comment text (supports Markdown)",
          default: "# Workflow Notes\n\nAdd your documentation here using **Markdown** formatting.\n\n## Features\n- Supports **bold** and *italic* text\n- Create lists and code blocks\n- Add links and more!"
        },
        noteType: {
          type: "string",
          title: "Note Type",
          description: "Visual style and color of the note",
          default: "info",
          enum: ["info", "warning", "success", "error", "note"]
        }
      }
    },
    tags: ["tools", "notes", "documentation", "comments", "markdown"]
  },
  {
    id: "sample-simple-node",
    name: "Simple Node",
    type: "tool",
    supportedTypes: ["tool", "default"],
    version: "1.0.0",
    description: "A simple node with optional input and output ports",
    category: "tools",
    icon: "mdi:square",
    color: "#6366f1",
    inputs: [
      {
        id: "input",
        name: "Input",
        type: "input",
        dataType: "mixed",
        required: false,
        description: "Optional input data"
      }
    ],
    outputs: [
      {
        id: "output",
        name: "Output",
        type: "output",
        dataType: "mixed",
        description: "Optional output data"
      },
      {
        id: "tool",
        name: "Tool Interface",
        type: "output",
        dataType: "tool",
        description: "Tool interface for agent connections - provides tool metadata and callable interface"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        nodeType: {
          type: "string",
          title: "Node Type",
          description: "Choose the visual representation for this node",
          default: "tool",
          enum: ["tool", "default"],
          enumNames: ["Tool (specialized for agent tools)", "Default (standard workflow node)"]
        },
        icon: {
          type: "string",
          title: "Icon",
          description: "Icon to display in the node (Iconify icon name)",
          default: "mdi:square"
        },
        color: {
          type: "string",
          title: "Color",
          description: "Background color of the node",
          default: "#6366f1"
        },
        layout: {
          type: "string",
          title: "Layout",
          description: "Layout style of the simple node",
          default: "normal",
          enum: ["compact", "normal"]
        },
        label: {
          type: "string",
          title: "Label",
          description: "Custom label for the node",
          default: "Simple Node"
        },
        description: {
          type: "string",
          title: "Description",
          description: "Description of what this simple node does",
          default: "",
          format: "multiline"
        }
      }
    },
    tags: ["tools", "simple", "custom", "visual", "node"]
  },
  // ===== EMBEDDINGS CATEGORY =====
  {
    id: "sample-openai-embeddings",
    name: "OpenAI Embeddings",
    version: "1.0.0",
    description: "Generate embeddings using OpenAI models",
    category: "embeddings",
    icon: "mdi:vector-point",
    color: "#10a37f",
    inputs: [
      {
        id: "text",
        name: "Text",
        type: "input",
        dataType: "string",
        required: true,
        description: "Text to embed"
      }
    ],
    outputs: [
      {
        id: "embeddings",
        name: "Embeddings",
        type: "output",
        dataType: "number[]",
        description: "Generated embeddings"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        model: {
          type: "string",
          title: "Model",
          description: "OpenAI embedding model",
          default: "text-embedding-3-small",
          enum: ["text-embedding-3-small", "text-embedding-3-large"]
        },
        apiKey: {
          type: "string",
          title: "API Key",
          description: "OpenAI API key",
          default: ""
        }
      }
    },
    tags: ["embeddings", "openai", "vector"]
  },
  {
    id: "sample-huggingface-embeddings",
    name: "HuggingFace Embeddings",
    version: "1.0.0",
    description: "Generate embeddings using HuggingFace models",
    category: "embeddings",
    icon: "mdi:vector-square",
    color: "#f59e0b",
    inputs: [
      {
        id: "text",
        name: "Text",
        type: "input",
        dataType: "string",
        required: true,
        description: "Text to embed"
      }
    ],
    outputs: [
      {
        id: "embeddings",
        name: "Embeddings",
        type: "output",
        dataType: "number[]",
        description: "Generated embeddings"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        model: {
          type: "string",
          title: "Model",
          description: "HuggingFace model name",
          default: "sentence-transformers/all-MiniLM-L6-v2"
        },
        apiToken: {
          type: "string",
          title: "API Token",
          description: "HuggingFace API token",
          default: ""
        }
      }
    },
    tags: ["embeddings", "huggingface", "vector"]
  },
  // ===== MEMORIES CATEGORY =====
  {
    id: "sample-conversation-buffer",
    name: "Conversation Buffer",
    version: "1.0.0",
    description: "Store conversation history",
    category: "memories",
    icon: "mdi:chat-history",
    color: "#8b5cf6",
    inputs: [
      {
        id: "message",
        name: "Message",
        type: "input",
        dataType: "string",
        required: true,
        description: "Message to add to buffer"
      }
    ],
    outputs: [
      {
        id: "history",
        name: "History",
        type: "output",
        dataType: "string[]",
        description: "Conversation history"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        maxTokens: {
          type: "number",
          title: "Max Tokens",
          description: "Maximum tokens in buffer",
          default: 2e3,
          minimum: 100,
          maximum: 1e4
        },
        returnMessages: {
          type: "boolean",
          title: "Return Messages",
          description: "Return messages in response",
          default: true
        }
      }
    },
    tags: ["memory", "conversation", "history", "buffer"]
  },
  // ===== AGENTS CATEGORY =====
  {
    id: "sample-simple-agent",
    name: "Simple Agent",
    version: "1.0.0",
    description: "Agent for tool orchestration",
    category: "agents",
    icon: "mdi:account-cog",
    color: "#06b6d4",
    type: "default",
    supportedTypes: ["default", "tool"],
    inputs: [
      {
        id: "message",
        name: "Message",
        type: "input",
        dataType: "string",
        required: true,
        description: "User message for agent"
      },
      {
        id: "tools",
        name: "Tools",
        type: "input",
        dataType: "tool",
        required: false,
        description: "Tool interfaces available to agent - connect to tool output ports"
      }
    ],
    outputs: [
      {
        id: "response",
        name: "Response",
        type: "output",
        dataType: "string",
        description: "Agent response"
      },
      {
        id: "tools",
        name: "Tools",
        type: "input",
        dataType: "tool",
        required: false,
        description: "Tool interfaces available to agent - connect to tool output ports"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        nodeType: {
          type: "string",
          title: "Node Type",
          description: "Choose the visual representation for this node",
          default: "default",
          enum: ["tool", "default"],
          enumNames: ["Tool Node (with metadata port)", "Default Node (standard ports)"]
        },
        model: {
          type: "string",
          title: "Model",
          description: "Chat model to use",
          default: "gpt-3.5-turbo",
          enum: ["gpt-3.5-turbo", "gpt-4", "claude-3-sonnet"]
        },
        temperature: {
          type: "number",
          title: "Temperature",
          description: "Creativity level (0-1)",
          default: 0.7,
          minimum: 0,
          maximum: 1
        },
        maxIterations: {
          type: "number",
          title: "Max Iterations",
          description: "Maximum agent iterations",
          default: 5,
          minimum: 1,
          maximum: 20
        }
      }
    },
    tags: ["agent", "orchestration", "tools"]
  },
  // ===== VECTOR STORES CATEGORY =====
  {
    id: "sample-chroma-vector-store",
    name: "Chroma Vector Store",
    version: "1.0.0",
    description: "Store and retrieve vectors using Chroma",
    category: "vector stores",
    icon: "mdi:database",
    color: "#84cc16",
    inputs: [
      {
        id: "embeddings",
        name: "Embeddings",
        type: "input",
        dataType: "number[]",
        required: true,
        description: "Embeddings to store"
      },
      {
        id: "query",
        name: "Query",
        type: "input",
        dataType: "string",
        required: false,
        description: "Query for similarity search"
      }
    ],
    outputs: [
      {
        id: "results",
        name: "Results",
        type: "output",
        dataType: "json[]",
        description: "Search results"
      },
      {
        id: "metadata",
        name: "Metadata",
        type: "output",
        dataType: "json",
        description: "Vector store metadata"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        collectionName: {
          type: "string",
          title: "Collection Name",
          description: "Chroma collection name",
          default: "default"
        },
        persistDirectory: {
          type: "string",
          title: "Persist Directory",
          description: "Directory to persist data",
          default: "./chroma_db"
        },
        distanceFunction: {
          type: "string",
          title: "Distance Function",
          description: "Distance function for similarity",
          default: "cosine",
          enum: ["cosine", "euclidean", "manhattan"]
        }
      }
    },
    tags: ["integration", "vector-store", "chroma", "embeddings"]
  },
  {
    id: "sample-pinecone-vector-store",
    name: "Pinecone Vector Store",
    version: "1.0.0",
    description: "Store and retrieve vectors using Pinecone",
    category: "vector stores",
    icon: "mdi:database-search",
    color: "#f59e0b",
    inputs: [
      {
        id: "embeddings",
        name: "Embeddings",
        type: "input",
        dataType: "number[]",
        required: true,
        description: "Embeddings to store"
      },
      {
        id: "query",
        name: "Query",
        type: "input",
        dataType: "string",
        required: false,
        description: "Query for similarity search"
      }
    ],
    outputs: [
      {
        id: "results",
        name: "Results",
        type: "output",
        dataType: "json[]",
        description: "Search results"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        indexName: {
          type: "string",
          title: "Index Name",
          description: "Pinecone index name",
          default: "default"
        },
        apiKey: {
          type: "string",
          title: "API Key",
          description: "Pinecone API key",
          default: ""
        },
        environment: {
          type: "string",
          title: "Environment",
          description: "Pinecone environment",
          default: "us-west1-gcp"
        }
      }
    },
    tags: ["integration", "vector-store", "pinecone", "embeddings"]
  },
  // ===== DEMO: AI-POWERED CONTENT MANAGEMENT NODES =====
  {
    id: "demo-chat-input",
    name: "Chat Input",
    type: "simple",
    supportedTypes: ["simple", "default"],
    version: "1.0.0",
    description: "Accept chat instructions from content managers about what content changes to make",
    category: "inputs",
    icon: "mdi:message-text-outline",
    color: "#10b981",
    inputs: [],
    outputs: [
      {
        id: "user_message",
        name: "User Message",
        type: "output",
        dataType: "string",
        description: "Content manager's instructions for content review"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        nodeType: {
          type: "string",
          title: "Node Type",
          description: "Choose the visual representation for this node",
          default: "simple",
          enum: ["simple", "default"],
          enumNames: ["Simple (compact layout)", "Default (standard workflow node)"]
        },
        placeholder: {
          type: "string",
          title: "Placeholder Text",
          description: "Placeholder text shown in the chat input",
          default: "Enter your content management instructions..."
        },
        welcomeMessage: {
          type: "string",
          title: "Welcome Message",
          description: "Initial message shown to content managers",
          default: "Hi! I can help you review and update your Drupal content. What would you like me to do?"
        },
        maxLength: {
          type: "number",
          title: "Maximum Message Length",
          description: "Maximum characters allowed in a single message",
          default: 1e3,
          minimum: 100,
          maximum: 5e3
        }
      }
    },
    tags: ["demo", "content-management", "input", "chat", "drupal"]
  },
  {
    id: "demo-drupal-search-rag",
    name: "Drupal Search API RAG",
    type: "tool",
    supportedTypes: ["tool", "default"],
    version: "1.0.0",
    description: "Search and retrieve content from Drupal using Search API with AI-powered relevance",
    category: "tools",
    icon: "mdi:database-search-outline",
    color: "#0678be",
    inputs: [
      {
        id: "search_query",
        name: "Search Query",
        type: "input",
        dataType: "string",
        required: true,
        description: "Search terms to find relevant content"
      },
      {
        id: "content_types",
        name: "Content Types",
        type: "input",
        dataType: "json",
        required: false,
        description: "Array of content types to search (e.g., ['article', 'page', 'blog'])"
      }
    ],
    outputs: [
      {
        id: "content_results",
        name: "Content Results",
        type: "output",
        dataType: "json",
        description: "Array of matching content items with metadata"
      },
      {
        id: "search_metadata",
        name: "Search Metadata",
        type: "output",
        dataType: "json",
        description: "Search statistics and relevance information"
      },
      {
        id: "tool",
        name: "Tool Interface",
        type: "output",
        dataType: "tool",
        description: "Tool interface for agent connections - provides tool metadata and callable interface"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        nodeType: {
          type: "string",
          title: "Node Type",
          description: "Choose the visual representation for this node",
          default: "tool",
          enum: ["tool", "default"],
          enumNames: ["Tool Node (with metadata port)", "Default Node (standard ports)"]
        },
        searchIndex: {
          type: "string",
          title: "Search API Index",
          description: "Name of the Drupal Search API index to query",
          default: "content_index"
        },
        maxResults: {
          type: "number",
          title: "Maximum Results",
          description: "Maximum number of content items to return",
          default: 10,
          minimum: 1,
          maximum: 100
        },
        includeFields: {
          type: "array",
          title: "Include Fields",
          description: "Content fields to include in results",
          default: ["title", "body", "field_tags", "created", "changed"]
        },
        useAiRanking: {
          type: "boolean",
          title: "Use AI-Powered Ranking",
          description: "Use AI to improve search result relevance",
          default: true
        },
        contentStatus: {
          type: "string",
          title: "Content Status",
          description: "Filter by publication status",
          default: "published",
          enum: ["published", "unpublished", "all"]
        }
      }
    },
    tags: ["demo", "content-management", "drupal", "search", "rag", "ai"]
  },
  {
    id: "demo-ai-content-analyzer",
    name: "AI Content Analyzer",
    type: "default",
    supportedTypes: ["default", "tool"],
    version: "1.0.0",
    description: "Analyze content for issues like acronym misuse, formatting problems, or content quality",
    category: "agents",
    icon: "mdi:text-search",
    color: "#7c3aed",
    inputs: [
      {
        id: "content",
        name: "Content",
        type: "input",
        dataType: "json",
        required: true,
        description: "Content to analyze"
      },
      {
        id: "analysis_prompt",
        name: "Analysis Instructions",
        type: "input",
        dataType: "string",
        required: true,
        description: "Instructions for what to analyze in the content"
      },
      {
        id: "tools",
        name: "Tools",
        type: "input",
        dataType: "tool",
        required: false,
        description: "Tools available to agent"
      }
    ],
    outputs: [
      {
        id: "analysis_results",
        name: "Analysis Results",
        type: "output",
        dataType: "json",
        description: "Detailed analysis findings with recommendations"
      },
      {
        id: "issues_found",
        name: "Issues Found",
        type: "output",
        dataType: "json",
        description: "Array of specific issues identified"
      },
      {
        id: "confidence_score",
        name: "Confidence Score",
        type: "output",
        dataType: "number",
        description: "AI confidence in the analysis (0-1)"
      },
      {
        id: "tools",
        name: "Tools",
        type: "input",
        dataType: "tool",
        required: false,
        description: "Tools available to agent"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        nodeType: {
          type: "string",
          title: "Node Type",
          description: "Choose the visual representation for this node",
          default: "default",
          enum: ["tool", "default"],
          enumNames: ["Tool Node (with metadata port)", "Default Node (standard ports)"]
        },
        model: {
          type: "string",
          title: "AI Model",
          description: "AI model to use for content analysis",
          default: "gpt-4",
          enum: ["gpt-3.5-turbo", "gpt-4", "claude-3-sonnet", "claude-3-haiku"]
        },
        analysisType: {
          type: "string",
          title: "Analysis Type",
          description: "Type of content analysis to perform",
          default: "comprehensive",
          enum: ["acronym_detection", "grammar_check", "style_review", "comprehensive"]
        },
        strictness: {
          type: "string",
          title: "Analysis Strictness",
          description: "How strict should the analysis be",
          default: "balanced",
          enum: ["lenient", "balanced", "strict"]
        },
        includeExamples: {
          type: "boolean",
          title: "Include Examples",
          description: "Include specific examples in analysis results",
          default: true
        },
        customRules: {
          type: "string",
          title: "Custom Analysis Rules",
          description: "Custom rules or guidelines for content analysis",
          default: "",
          format: "multiline"
        }
      }
    },
    tags: ["demo", "content-management", "ai", "analysis", "quality-control"]
  },
  {
    id: "demo-ai-content-editor",
    name: "AI Content Editor",
    type: "default",
    supportedTypes: ["default", "tool"],
    version: "1.0.0",
    description: "Make AI-powered edits to content based on analysis results and user instructions",
    category: "agents",
    icon: "mdi:file-edit-outline",
    color: "#f59e0b",
    inputs: [
      {
        id: "original_content",
        name: "Original Content",
        type: "input",
        dataType: "json",
        required: true,
        description: "Original content to be edited"
      },
      {
        id: "analysis_results",
        name: "Analysis Results",
        type: "input",
        dataType: "json",
        required: true,
        description: "Issues and recommendations from content analysis"
      },
      {
        id: "edit_instructions",
        name: "Edit Instructions",
        type: "input",
        dataType: "string",
        required: true,
        description: "Specific instructions for how to edit the content"
      },
      {
        id: "tools",
        name: "Tools",
        type: "input",
        dataType: "tool",
        required: false,
        description: "Tools available to agent"
      }
    ],
    outputs: [
      {
        id: "edited_content",
        name: "Edited Content",
        type: "output",
        dataType: "json",
        description: "Content with AI-suggested edits applied"
      },
      {
        id: "edit_summary",
        name: "Edit Summary",
        type: "output",
        dataType: "json",
        description: "Summary of changes made with explanations"
      },
      {
        id: "change_log",
        name: "Change Log",
        type: "output",
        dataType: "json",
        description: "Detailed log of all changes made"
      },
      {
        id: "tools",
        name: "Tools",
        type: "input",
        dataType: "tool",
        required: false,
        description: "Tools available to agent"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        nodeType: {
          type: "string",
          title: "Node Type",
          description: "Choose the visual representation for this node",
          default: "default",
          enum: ["tool", "default"],
          enumNames: ["Tool Node (with metadata port)", "Default Node (standard ports)"]
        },
        model: {
          type: "string",
          title: "AI Model",
          description: "AI model to use for content editing",
          default: "gpt-4",
          enum: ["gpt-3.5-turbo", "gpt-4", "claude-3-sonnet", "claude-3-haiku"]
        },
        editingStyle: {
          type: "string",
          title: "Editing Style",
          description: "Style of editing to apply",
          default: "conservative",
          enum: ["minimal", "conservative", "moderate", "comprehensive"]
        },
        preserveFormatting: {
          type: "boolean",
          title: "Preserve HTML Formatting",
          description: "Maintain existing HTML tags and formatting",
          default: true
        },
        requireApproval: {
          type: "boolean",
          title: "Require Human Approval",
          description: "Flag all changes for human review before applying",
          default: true
        },
        trackChanges: {
          type: "boolean",
          title: "Track Changes",
          description: "Create detailed tracking of all modifications",
          default: true
        }
      }
    },
    tags: ["demo", "content-management", "ai", "editing", "automation"]
  },
  {
    id: "demo-draft-creator",
    name: "Draft Creator",
    type: "tool",
    supportedTypes: ["tool", "default"],
    version: "1.0.0",
    description: "Create draft versions of edited content in Drupal for human review and approval",
    category: "tools",
    icon: "mdi:file-document-edit-outline",
    color: "#10b981",
    inputs: [
      {
        id: "edited_content",
        name: "Edited Content",
        type: "input",
        dataType: "json",
        required: true,
        description: "Content with AI edits to save as draft"
      },
      {
        id: "edit_summary",
        name: "Edit Summary",
        type: "input",
        dataType: "json",
        required: true,
        description: "Summary of changes made"
      },
      {
        id: "original_node_id",
        name: "Original Node ID",
        type: "input",
        dataType: "number",
        required: true,
        description: "Drupal node ID of the original content"
      }
    ],
    outputs: [
      {
        id: "draft_node_id",
        name: "Draft Node ID",
        type: "output",
        dataType: "number",
        description: "Node ID of the created draft"
      },
      {
        id: "draft_url",
        name: "Draft URL",
        type: "output",
        dataType: "string",
        description: "URL to view the draft content"
      },
      {
        id: "review_url",
        name: "Review URL",
        type: "output",
        dataType: "string",
        description: "URL for content reviewers to approve/reject changes"
      },
      {
        id: "tool",
        name: "Tool Interface",
        type: "output",
        dataType: "tool",
        description: "Tool interface for agent connections - provides tool metadata and callable interface"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        nodeType: {
          type: "string",
          title: "Node Type",
          description: "Choose the visual representation for this node",
          default: "tool",
          enum: ["tool", "default"],
          enumNames: ["Tool Node (with metadata port)", "Default Node (standard ports)"]
        },
        draftWorkflow: {
          type: "string",
          title: "Draft Workflow",
          description: "Drupal workflow to use for draft content",
          default: "editorial",
          enum: ["editorial", "simple", "custom"]
        },
        assignReviewer: {
          type: "boolean",
          title: "Auto-assign Reviewer",
          description: "Automatically assign a content reviewer",
          default: true
        },
        reviewerRole: {
          type: "string",
          title: "Reviewer Role",
          description: "User role to assign for content review",
          default: "editor",
          enum: ["editor", "content_manager", "administrator"]
        },
        notifyReviewer: {
          type: "boolean",
          title: "Notify Reviewer",
          description: "Send email notification to assigned reviewer",
          default: true
        },
        retainOriginal: {
          type: "boolean",
          title: "Retain Original",
          description: "Keep original content unchanged until draft is approved",
          default: true
        },
        addRevisionLog: {
          type: "boolean",
          title: "Add Revision Log",
          description: "Add detailed revision log entry",
          default: true
        }
      }
    },
    tags: ["demo", "content-management", "drupal", "draft", "workflow", "review"]
  },
  {
    id: "demo-date-format-converter",
    name: "Date Format Converter",
    type: "tool",
    supportedTypes: ["tool", "default"],
    version: "1.0.0",
    description: "Extract and convert dates in content to new formats (demo review step)",
    category: "tools",
    icon: "mdi:calendar-edit",
    color: "#84cc16",
    inputs: [
      {
        id: "content",
        name: "Content",
        type: "input",
        dataType: "json",
        required: true,
        description: "Content containing dates to convert"
      }
    ],
    outputs: [
      {
        id: "converted_content",
        name: "Converted Content",
        type: "output",
        dataType: "json",
        description: "Content with dates converted to new format"
      },
      {
        id: "dates_found",
        name: "Dates Found",
        type: "output",
        dataType: "json",
        description: "Array of dates found and their conversions"
      },
      {
        id: "conversion_log",
        name: "Conversion Log",
        type: "output",
        dataType: "json",
        description: "Log of all date conversions performed"
      },
      {
        id: "tool",
        name: "Tool Interface",
        type: "output",
        dataType: "tool",
        description: "Tool interface for agent connections - provides tool metadata and callable interface"
      }
    ],
    configSchema: {
      type: "object",
      properties: {
        nodeType: {
          type: "string",
          title: "Node Type",
          description: "Choose the visual representation for this node",
          default: "tool",
          enum: ["tool", "default"],
          enumNames: ["Tool Node (with metadata port)", "Default Node (standard ports)"]
        },
        inputFormat: {
          type: "string",
          title: "Input Date Format",
          description: "Expected format of dates in content",
          default: "MM/dd/yyyy",
          enum: ["MM/dd/yyyy", "dd/MM/yyyy", "yyyy-MM-dd", "auto-detect"]
        },
        outputFormat: {
          type: "string",
          title: "Output Date Format",
          description: "Desired format for converted dates",
          default: "MMMM d, yyyy",
          enum: ["MMMM d, yyyy", "dd/MM/yyyy", "yyyy-MM-dd", "MMM d, yyyy", "d MMMM yyyy"]
        },
        includeTime: {
          type: "boolean",
          title: "Include Time",
          description: "Include time information in conversions",
          default: false
        },
        timezone: {
          type: "string",
          title: "Timezone",
          description: "Timezone for date conversions",
          default: "UTC",
          enum: [
            "UTC",
            "America/New_York",
            "America/Chicago",
            "America/Denver",
            "America/Los_Angeles",
            "Europe/London"
          ]
        },
        onlyFutureDates: {
          type: "boolean",
          title: "Only Future Dates",
          description: "Only convert dates that are in the future",
          default: false
        }
      }
    },
    tags: ["demo", "content-management", "dates", "formatting", "conversion", "review-tool"]
  },
  {
    id: "demo-chat-response",
    name: "Chat Response",
    type: "simple",
    supportedTypes: ["simple", "default"],
    version: "1.0.0",
    description: "Display chat-style responses with workflow results and next steps for content managers",
    category: "outputs",
    icon: "mdi:message-reply-text",
    color: "#8b5cf6",
    inputs: [
      {
        id: "workflow_results",
        name: "Workflow Results",
        type: "input",
        dataType: "json",
        required: true,
        description: "Results from the content management workflow"
      },
      {
        id: "summary_message",
        name: "Summary Message",
        type: "input",
        dataType: "string",
        required: true,
        description: "Human-readable summary of what was accomplished"
      }
    ],
    outputs: [],
    configSchema: {
      type: "object",
      properties: {
        nodeType: {
          type: "string",
          title: "Node Type",
          description: "Choose the visual representation for this node",
          default: "simple",
          enum: ["simple", "default"],
          enumNames: ["Simple (compact layout)", "Default (standard workflow node)"]
        },
        showTimestamp: {
          type: "boolean",
          title: "Show Timestamp",
          description: "Display timestamp with responses",
          default: true
        },
        includeActionButtons: {
          type: "boolean",
          title: "Include Action Buttons",
          description: "Show action buttons for next steps",
          default: true
        },
        responseStyle: {
          type: "string",
          title: "Response Style",
          description: "Style of the chat response",
          default: "professional",
          enum: ["casual", "professional", "technical", "friendly"]
        },
        showWorkflowSummary: {
          type: "boolean",
          title: "Show Workflow Summary",
          description: "Include a summary of workflow steps completed",
          default: true
        },
        enableMarkdown: {
          type: "boolean",
          title: "Enable Markdown",
          description: "Allow markdown formatting in responses",
          default: true
        }
      }
    },
    tags: ["demo", "content-management", "output", "chat", "response", "summary"]
  }
];
const sampleWorkflow = {
  id: "sample-simple-chat-workflow",
  name: "Simple Chat Workflow",
  description: "A basic workflow demonstrating direct text input to AI model response",
  nodes: [
    {
      id: "sample-workflow-text-input",
      type: "text-input",
      position: { x: 100, y: 100 },
      data: {
        label: "Text Input",
        config: {
          placeholder: "Enter your question...",
          defaultValue: "Hello, how are you?"
        },
        metadata: sampleNodes.find((n) => n.name === "Text Input")
      }
    },
    {
      id: "sample-workflow-split-text",
      type: "split-text",
      position: { x: 300, y: 100 },
      data: {
        label: "Split Text",
        config: {
          chunkSize: 500,
          chunkOverlap: 100,
          separator: "\n"
        },
        metadata: sampleNodes.find((n) => n.name === "Split Text")
      }
    },
    {
      id: "sample-workflow-openai",
      type: "openai",
      position: { x: 500, y: 100 },
      data: {
        label: "OpenAI",
        config: {
          model: "gpt-3.5-turbo",
          temperature: 0.7,
          maxTokens: 1e3
        },
        metadata: sampleNodes.find((n) => n.name === "OpenAI")
      }
    },
    {
      id: "sample-workflow-note",
      type: "note",
      position: { x: 500, y: 300 },
      data: {
        label: "Workflow Notes",
        config: {
          content: "# Simple Chat Workflow\n\nThis workflow demonstrates a basic chat interaction:\n\n1. **Text Input** - User enters a question\n2. **OpenAI** - Processes the input and generates a response\n3. **Chat Output** - Displays the final response\n\n## Port Types Used\n- **string** - Text data flows between all nodes\n- Only compatible types can connect (string → string)\n\n## Usage\n- Drag a Notes node to add documentation\n- Double-click to edit in Markdown\n- Choose from 5 different note types",
          noteType: "info"
        },
        metadata: sampleNodes.find((n) => n.name === "Notes")
      }
    },
    {
      id: "sample-workflow-chat-output",
      type: "chat-output",
      position: { x: 700, y: 100 },
      data: {
        label: "Chat Output",
        config: {
          showTimestamp: true,
          maxLength: 2e3,
          markdown: true
        },
        metadata: sampleNodes.find((n) => n.name === "Chat Output")
      }
    }
  ],
  edges: [
    {
      id: "sample-workflow-edge-1",
      source: "sample-workflow-text-input",
      target: "sample-workflow-openai",
      sourceHandle: "text",
      targetHandle: "prompt"
    },
    {
      id: "sample-workflow-edge-2",
      source: "sample-workflow-openai",
      target: "sample-workflow-chat-output",
      sourceHandle: "response",
      targetHandle: "message"
    }
  ],
  metadata: {
    version: "1.0.0",
    createdAt: (/* @__PURE__ */ new Date()).toISOString(),
    updatedAt: (/* @__PURE__ */ new Date()).toISOString(),
    author: "FlowDrop",
    tags: ["sample", "chat", "demo", "langflow-style"]
  }
};
function createDefaultFeatures() {
  return {
    dragAndDrop: true,
    nodeEditing: true,
    execution: true,
    saveWorkflow: true,
    loadWorkflow: true,
    undoRedo: true,
    nodeSearch: true,
    nodeCategories: true,
    nodeValidation: true,
    collaboration: false,
    templates: false,
    importExport: false
  };
}
function createDefaultUIConfig() {
  return {
    showSidebar: true,
    showToolbar: true,
    showMinimap: true,
    showGrid: true,
    gridSize: 20,
    nodeSpacing: 100,
    canvasPadding: 50,
    navbarHeight: 60,
    // Default navbar height in pixels (current demo height)
    zoom: {
      min: 0.1,
      max: 2,
      default: 1
    },
    colors: {
      primary: "#3b82f6",
      secondary: "#64748b",
      accent: "#f59e0b",
      background: "#ffffff",
      text: "#1f2937"
    },
    cssClasses: {}
  };
}
function createDefaultAPIConfig() {
  return {
    endpoints: createEndpointConfig("/api/flowdrop"),
    timeout: 3e4,
    retry: {
      enabled: true,
      maxAttempts: 3,
      delay: 1e3
    },
    auth: {
      type: "none"
    },
    headers: {
      "Content-Type": "application/json"
    }
  };
}
function createDefaultExecutionConfig() {
  return {
    realTimeUpdates: true,
    timeout: 300,
    maxConcurrent: 5,
    showProgress: true,
    autoSaveState: true,
    caching: {
      enabled: true,
      ttl: 3600
    }
  };
}
function createDefaultStorageConfig() {
  return {
    type: "api",
    autoSaveInterval: 5e3,
    maxUndoSteps: 50,
    keyPrefix: "flowdrop_"
  };
}
function createDefaultConfig(endpointConfig2) {
  return {
    theme: "auto",
    features: createDefaultFeatures(),
    ui: createDefaultUIConfig(),
    api: __spreadProps(__spreadValues({}, createDefaultAPIConfig()), {
      endpoints: endpointConfig2 || createEndpointConfig("/api/flowdrop")
    }),
    ports: {
      dataTypes: [],
      compatibilityRules: [],
      defaultDataType: "mixed"
    },
    execution: createDefaultExecutionConfig(),
    storage: createDefaultStorageConfig()
  };
}
function mergeConfig(userConfig, defaultConfig2) {
  var _a2, _b2, _c2, _d2, _e2, _f, _g, _h;
  return __spreadProps(__spreadValues(__spreadValues({}, defaultConfig2), userConfig), {
    features: __spreadValues(__spreadValues({}, defaultConfig2.features), userConfig.features),
    ui: __spreadProps(__spreadValues(__spreadValues({}, defaultConfig2.ui), userConfig.ui), {
      zoom: __spreadValues(__spreadValues({}, defaultConfig2.ui.zoom), (_a2 = userConfig.ui) == null ? void 0 : _a2.zoom),
      colors: __spreadValues(__spreadValues({}, defaultConfig2.ui.colors), (_b2 = userConfig.ui) == null ? void 0 : _b2.colors),
      cssClasses: __spreadValues(__spreadValues({}, defaultConfig2.ui.cssClasses), (_c2 = userConfig.ui) == null ? void 0 : _c2.cssClasses)
    }),
    api: __spreadProps(__spreadValues(__spreadValues({}, defaultConfig2.api), userConfig.api), {
      retry: __spreadValues(__spreadValues({}, defaultConfig2.api.retry), (_d2 = userConfig.api) == null ? void 0 : _d2.retry),
      auth: __spreadValues(__spreadValues({}, defaultConfig2.api.auth), (_e2 = userConfig.api) == null ? void 0 : _e2.auth),
      headers: __spreadValues(__spreadValues({}, defaultConfig2.api.headers), (_f = userConfig.api) == null ? void 0 : _f.headers),
      endpoints: __spreadValues(__spreadValues({}, defaultConfig2.api.endpoints), (_g = userConfig.api) == null ? void 0 : _g.endpoints)
    }),
    execution: __spreadProps(__spreadValues(__spreadValues({}, defaultConfig2.execution), userConfig.execution), {
      caching: __spreadValues(__spreadValues({}, defaultConfig2.execution.caching), (_h = userConfig.execution) == null ? void 0 : _h.caching)
    }),
    storage: __spreadValues(__spreadValues({}, defaultConfig2.storage), userConfig.storage)
  });
}
function validateConfig(config) {
  const errors = [];
  if (!config.features) {
    errors.push("features configuration is required");
  }
  if (!config.ui) {
    errors.push("ui configuration is required");
  }
  if (!config.api) {
    errors.push("api configuration is required");
  }
  if (!config.execution) {
    errors.push("execution configuration is required");
  }
  if (!config.storage) {
    errors.push("storage configuration is required");
  }
  if (config.api.timeout <= 0) {
    errors.push("API timeout must be greater than 0");
  }
  if (config.api.retry.maxAttempts < 0) {
    errors.push("Retry max attempts must be non-negative");
  }
  if (config.execution.timeout <= 0) {
    errors.push("Execution timeout must be greater than 0");
  }
  if (config.execution.maxConcurrent <= 0) {
    errors.push("Max concurrent executions must be greater than 0");
  }
  if (config.ui.gridSize <= 0) {
    errors.push("Grid size must be greater than 0");
  }
  if (config.ui.nodeSpacing <= 0) {
    errors.push("Node spacing must be greater than 0");
  }
  if (config.ui.zoom.min >= config.ui.zoom.max) {
    errors.push("Zoom min must be less than zoom max");
  }
  return errors;
}
function createConfigFromEnv() {
  const apiBaseUrl = "/api/flowdrop";
  const endpointConfig2 = createEndpointConfig(apiBaseUrl);
  const config = createDefaultConfig(endpointConfig2);
  return config;
}
class WorkflowAdapter {
  constructor(nodeTypes = []) {
    __publicField(this, "nodeTypes", []);
    this.nodeTypes = nodeTypes;
  }
  /**
   * Create a new workflow
   */
  createWorkflow(name, description) {
    return {
      id: v4(),
      name,
      description,
      nodes: [],
      edges: [],
      metadata: {
        version: "1.0.0",
        createdAt: (/* @__PURE__ */ new Date()).toISOString(),
        updatedAt: (/* @__PURE__ */ new Date()).toISOString()
      }
    };
  }
  /**
   * Add a node to a workflow
   */
  addNode(workflow, nodeType, position, config) {
    const metadata = this.nodeTypes.find((nt) => nt.id === nodeType);
    if (!metadata) {
      throw new Error(`Node type '${nodeType}' not found`);
    }
    const node = {
      id: v4(),
      type: nodeType,
      position,
      data: {
        label: metadata.name,
        config: config || {},
        metadata
      }
    };
    workflow.nodes.push(node);
    workflow.metadata.updatedAt = (/* @__PURE__ */ new Date()).toISOString();
    return node;
  }
  /**
   * Remove a node from a workflow
   */
  removeNode(workflow, nodeId) {
    const nodeIndex = workflow.nodes.findIndex((n) => n.id === nodeId);
    if (nodeIndex === -1) return false;
    workflow.nodes.splice(nodeIndex, 1);
    workflow.edges = workflow.edges.filter(
      (edge) => edge.source !== nodeId && edge.target !== nodeId
    );
    workflow.metadata.updatedAt = (/* @__PURE__ */ new Date()).toISOString();
    return true;
  }
  /**
   * Update node position
   */
  updateNodePosition(workflow, nodeId, position) {
    const node = workflow.nodes.find((n) => n.id === nodeId);
    if (!node) return false;
    node.position = position;
    workflow.metadata.updatedAt = (/* @__PURE__ */ new Date()).toISOString();
    return true;
  }
  /**
   * Update node configuration
   */
  updateNodeConfig(workflow, nodeId, config) {
    const node = workflow.nodes.find((n) => n.id === nodeId);
    if (!node) return false;
    node.data.config = __spreadValues(__spreadValues({}, node.data.config), config);
    workflow.metadata.updatedAt = (/* @__PURE__ */ new Date()).toISOString();
    return true;
  }
  /**
   * Add an edge between nodes
   */
  addEdge(workflow, sourceNodeId, targetNodeId, sourceHandle, targetHandle) {
    const edge = {
      id: v4(),
      source: sourceNodeId,
      target: targetNodeId,
      sourceHandle,
      targetHandle
    };
    workflow.edges.push(edge);
    workflow.metadata.updatedAt = (/* @__PURE__ */ new Date()).toISOString();
    return edge;
  }
  /**
   * Remove an edge from a workflow
   */
  removeEdge(workflow, edgeId) {
    const edgeIndex = workflow.edges.findIndex((e) => e.id === edgeId);
    if (edgeIndex === -1) return false;
    workflow.edges.splice(edgeIndex, 1);
    workflow.metadata.updatedAt = (/* @__PURE__ */ new Date()).toISOString();
    return true;
  }
  /**
   * Get all nodes of a specific type
   */
  getNodesByType(workflow, nodeType) {
    return workflow.nodes.filter((node) => node.type === nodeType);
  }
  /**
   * Get all edges connected to a node
   */
  getNodeEdges(workflow, nodeId) {
    return workflow.edges.filter((edge) => edge.source === nodeId || edge.target === nodeId);
  }
  /**
   * Get connected nodes (both incoming and outgoing)
   */
  getConnectedNodes(workflow, nodeId) {
    const connectedNodeIds = /* @__PURE__ */ new Set();
    workflow.edges.forEach((edge) => {
      if (edge.source === nodeId) {
        connectedNodeIds.add(edge.target);
      } else if (edge.target === nodeId) {
        connectedNodeIds.add(edge.source);
      }
    });
    return workflow.nodes.filter((node) => connectedNodeIds.has(node.id));
  }
  /**
   * Validate workflow structure
   */
  validateWorkflow(workflow) {
    const errors = [];
    const warnings = [];
    if (workflow.nodes.length === 0) {
      warnings.push("Workflow has no nodes");
    }
    const nodeIds = new Set(workflow.nodes.map((n) => n.id));
    workflow.edges.forEach((edge) => {
      if (!nodeIds.has(edge.source)) {
        errors.push(`Edge ${edge.id} references non-existent source node ${edge.source}`);
      }
      if (!nodeIds.has(edge.target)) {
        errors.push(`Edge ${edge.id} references non-existent target node ${edge.target}`);
      }
    });
    workflow.edges.forEach((edge) => {
      if (edge.source === edge.target) {
        errors.push(`Node ${edge.source} cannot connect to itself`);
      }
    });
    const nodeIdCounts = /* @__PURE__ */ new Map();
    workflow.nodes.forEach((node) => {
      nodeIdCounts.set(node.id, (nodeIdCounts.get(node.id) || 0) + 1);
    });
    nodeIdCounts.forEach((count, id2) => {
      if (count > 1) {
        errors.push(`Duplicate node ID: ${id2}`);
      }
    });
    const edgeIdCounts = /* @__PURE__ */ new Map();
    workflow.edges.forEach((edge) => {
      edgeIdCounts.set(edge.id, (edgeIdCounts.get(edge.id) || 0) + 1);
    });
    edgeIdCounts.forEach((count, id2) => {
      if (count > 1) {
        errors.push(`Duplicate edge ID: ${id2}`);
      }
    });
    return {
      valid: errors.length === 0,
      errors,
      warnings
    };
  }
  /**
   * Export workflow to JSON
   */
  exportWorkflow(workflow) {
    return JSON.stringify(workflow, null, 2);
  }
  /**
   * Import workflow from JSON
   */
  importWorkflow(json) {
    var _a2, _b2, _c2, _d2;
    try {
      const workflow = JSON.parse(json);
      const validation = this.validateWorkflow(workflow);
      if (!validation.valid) {
        throw new Error(`Invalid workflow: ${validation.errors.join(", ")}`);
      }
      workflow.metadata = {
        version: ((_a2 = workflow.metadata) == null ? void 0 : _a2.version) || "1.0.0",
        createdAt: ((_b2 = workflow.metadata) == null ? void 0 : _b2.createdAt) || (/* @__PURE__ */ new Date()).toISOString(),
        updatedAt: (/* @__PURE__ */ new Date()).toISOString(),
        author: (_c2 = workflow.metadata) == null ? void 0 : _c2.author,
        tags: (_d2 = workflow.metadata) == null ? void 0 : _d2.tags
      };
      return workflow;
    } catch (error) {
      throw new Error(
        `Failed to import workflow: ${error instanceof Error ? error.message : "Unknown error"}`
      );
    }
  }
  /**
   * Convert SvelteFlow workflow to standard format
   */
  fromSvelteFlow(svelteFlowWorkflow) {
    return {
      id: svelteFlowWorkflow.id,
      name: svelteFlowWorkflow.name,
      description: svelteFlowWorkflow.description,
      nodes: svelteFlowWorkflow.nodes.map((node) => ({
        id: node.id,
        type: node.data.metadata.id,
        position: node.position,
        data: {
          label: node.data.label,
          config: node.data.config,
          metadata: node.data.metadata
        }
      })),
      edges: svelteFlowWorkflow.edges.map((edge) => ({
        id: edge.id,
        source: edge.source,
        target: edge.target,
        sourceHandle: edge.sourceHandle,
        targetHandle: edge.targetHandle
      })),
      metadata: svelteFlowWorkflow.metadata
    };
  }
  /**
   * Convert standard workflow to SvelteFlow format
   */
  toSvelteFlow(workflow) {
    return {
      id: workflow.id,
      name: workflow.name,
      description: workflow.description,
      nodes: workflow.nodes.map((node) => ({
        id: node.id,
        type: "workflowNode",
        position: node.position,
        deletable: true,
        data: {
          label: node.data.label,
          config: node.data.config,
          metadata: node.data.metadata,
          nodeId: node.id
        }
      })),
      edges: workflow.edges.map((edge) => ({
        id: edge.id,
        source: edge.source,
        target: edge.target,
        sourceHandle: edge.sourceHandle,
        targetHandle: edge.targetHandle
      })),
      metadata: workflow.metadata
    };
  }
  /**
   * Get workflow statistics
   */
  getWorkflowStats(workflow) {
    var _a2;
    const nodeTypeCounts = /* @__PURE__ */ new Map();
    workflow.nodes.forEach((node) => {
      nodeTypeCounts.set(node.type, (nodeTypeCounts.get(node.type) || 0) + 1);
    });
    return {
      totalNodes: workflow.nodes.length,
      totalEdges: workflow.edges.length,
      nodeTypeCounts: Object.fromEntries(nodeTypeCounts),
      lastModified: (_a2 = workflow.metadata) == null ? void 0 : _a2.updatedAt
    };
  }
  /**
   * Clone a workflow
   */
  cloneWorkflow(workflow, newName) {
    var _a2, _b2, _c2;
    const cloned = JSON.parse(JSON.stringify(workflow));
    const idMapping = /* @__PURE__ */ new Map();
    cloned.nodes.forEach((node) => {
      const oldId = node.id;
      node.id = v4();
      idMapping.set(oldId, node.id);
    });
    cloned.edges.forEach((edge) => {
      edge.id = v4();
      edge.source = idMapping.get(edge.source) || edge.source;
      edge.target = idMapping.get(edge.target) || edge.target;
    });
    cloned.id = v4();
    cloned.name = newName || `${workflow.name} (Copy)`;
    cloned.metadata = {
      version: ((_a2 = cloned.metadata) == null ? void 0 : _a2.version) || "1.0.0",
      createdAt: (/* @__PURE__ */ new Date()).toISOString(),
      updatedAt: (/* @__PURE__ */ new Date()).toISOString(),
      author: (_b2 = cloned.metadata) == null ? void 0 : _b2.author,
      tags: (_c2 = cloned.metadata) == null ? void 0 : _c2.tags
    };
    return cloned;
  }
}
class ApiClient {
  constructor(config) {
    __publicField(this, "config");
    __publicField(this, "defaultHeaders");
    this.config = __spreadValues({
      timeout: 3e4
    }, config);
    this.defaultHeaders = __spreadValues({
      "Content-Type": "application/json"
    }, config.headers);
    if (config.apiKey) {
      this.defaultHeaders.Authorization = `Bearer ${config.apiKey}`;
    }
  }
  /**
   * Make an HTTP request
   */
  request(_0, _1, _2) {
    return __async(this, arguments, function* (method, path, data, options = {}) {
      const url = `${this.config.baseUrl}${path}`;
      const headers = __spreadValues(__spreadValues({}, this.defaultHeaders), options.headers);
      const timeout2 = options.timeout || this.config.timeout;
      const controller = new AbortController();
      const timeoutId = setTimeout(() => controller.abort(), timeout2);
      try {
        const response = yield fetch(url, {
          method,
          headers,
          body: data ? JSON.stringify(data) : void 0,
          signal: controller.signal
        });
        clearTimeout(timeoutId);
        if (!response.ok) {
          const errorData = yield response.json().catch(() => ({}));
          throw new ApiError(
            response.status,
            errorData.error || `HTTP ${response.status}`,
            errorData.code,
            errorData.details
          );
        }
        return yield response.json();
      } catch (error) {
        clearTimeout(timeoutId);
        if (error instanceof ApiError) {
          throw error;
        }
        if (error instanceof Error && error.name === "AbortError") {
          throw new ApiError(408, "Request timeout", "TIMEOUT");
        }
        throw new ApiError(
          500,
          error instanceof Error ? error.message : "Network error",
          "NETWORK_ERROR"
        );
      }
    });
  }
  // ===== HEALTH CHECK =====
  /**
   * Check API health
   */
  healthCheck() {
    return __async(this, null, function* () {
      return this.request("GET", "/health");
    });
  }
  // ===== NODE TYPES =====
  /**
   * Get all node types
   */
  getNodeTypes(query) {
    return __async(this, null, function* () {
      const params = new URLSearchParams();
      if (query == null ? void 0 : query.category) params.append("category", query.category);
      if (query == null ? void 0 : query.search) params.append("search", query.search);
      if (query == null ? void 0 : query.limit) params.append("limit", query.limit.toString());
      if (query == null ? void 0 : query.offset) params.append("offset", query.offset.toString());
      const path = `/nodes${params.toString() ? `?${params.toString()}` : ""}`;
      return this.request("GET", path);
    });
  }
  /**
   * Get node type by ID
   */
  getNodeType(id2) {
    return __async(this, null, function* () {
      return this.request("GET", `/nodes/${id2}`);
    });
  }
  // ===== WORKFLOWS =====
  /**
   * Get all workflows
   */
  getWorkflows(query) {
    return __async(this, null, function* () {
      const params = new URLSearchParams();
      if (query == null ? void 0 : query.search) params.append("search", query.search);
      if (query == null ? void 0 : query.tags) params.append("tags", query.tags);
      if (query == null ? void 0 : query.limit) params.append("limit", query.limit.toString());
      if (query == null ? void 0 : query.offset) params.append("offset", query.offset.toString());
      if (query == null ? void 0 : query.sort) params.append("sort", query.sort);
      if (query == null ? void 0 : query.order) params.append("order", query.order);
      const path = `/workflows${params.toString() ? `?${params.toString()}` : ""}`;
      return this.request("GET", path);
    });
  }
  /**
   * Get workflow by ID
   */
  getWorkflow(id2) {
    return __async(this, null, function* () {
      return this.request("GET", `/workflows/${id2}`);
    });
  }
  /**
   * Create a new workflow
   */
  createWorkflow(data) {
    return __async(this, null, function* () {
      return this.request("POST", "/workflows", data);
    });
  }
  /**
   * Update workflow
   */
  updateWorkflow(id2, data) {
    return __async(this, null, function* () {
      return this.request("PUT", `/workflows/${id2}`, data);
    });
  }
  /**
   * Delete workflow
   */
  deleteWorkflow(id2) {
    return __async(this, null, function* () {
      return this.request("DELETE", `/workflows/${id2}`);
    });
  }
  // ===== WORKFLOW EXECUTION =====
  /**
   * Execute workflow
   */
  executeWorkflow(id2, data) {
    return __async(this, null, function* () {
      return this.request("POST", `/workflows/${id2}/execute`, data);
    });
  }
  /**
   * Get execution status
   */
  getExecutionStatus(id2) {
    return __async(this, null, function* () {
      return this.request("GET", `/executions/${id2}`);
    });
  }
  /**
   * Cancel execution
   */
  cancelExecution(id2) {
    return __async(this, null, function* () {
      return this.request("POST", `/executions/${id2}/cancel`);
    });
  }
  // ===== IMPORT/EXPORT =====
  /**
   * Export workflow
   */
  exportWorkflow(id2, format = "json") {
    return __async(this, null, function* () {
      return this.request("GET", `/workflows/${id2}/export?format=${format}`);
    });
  }
  /**
   * Import workflow
   */
  importWorkflow(workflow) {
    return __async(this, null, function* () {
      return this.request("POST", "/workflows/import", workflow);
    });
  }
  // ===== VALIDATION =====
  /**
   * Validate workflow
   */
  validateWorkflow(workflow) {
    return __async(this, null, function* () {
      return this.request("POST", "/workflows/validate", workflow);
    });
  }
  // ===== UTILITY METHODS =====
  /**
   * Wait for execution completion
   */
  waitForExecution(id2, pollInterval = 1e3) {
    return __async(this, null, function* () {
      var _a2, _b2, _c2;
      while (true) {
        const status = yield this.getExecutionStatus(id2);
        if (((_a2 = status.data) == null ? void 0 : _a2.status) === "completed" || ((_b2 = status.data) == null ? void 0 : _b2.status) === "failed" || ((_c2 = status.data) == null ? void 0 : _c2.status) === "cancelled") {
          return status;
        }
        yield new Promise((resolve) => setTimeout(resolve, pollInterval));
      }
    });
  }
  /**
   * Get workflows by tag
   */
  getWorkflowsByTag(tag, query) {
    return __async(this, null, function* () {
      return this.getWorkflows(__spreadProps(__spreadValues({}, query), { tags: tag }));
    });
  }
  /**
   * Get node types by category
   */
  getNodeTypesByCategory(category, query) {
    return __async(this, null, function* () {
      return this.getNodeTypes(__spreadProps(__spreadValues({}, query), { category }));
    });
  }
}
class ApiError extends Error {
  constructor(status, message, code, details) {
    super(message);
    this.status = status;
    this.code = code;
    this.details = details;
    this.name = "ApiError";
  }
}
delegate(["keydown", "click", "change", "input"]);
var root$2 = /* @__PURE__ */ from_html(`<div class="flowdrop-logo svelte-of05x7"><svg viewBox="0 0 500 499.99999" version="1.1" id="svg47" width="500" height="500" xmlns="http://www.w3.org/2000/svg"><defs id="defs2"></defs><g id="g6669-7-7-3-3" transform="translate(472.2413,571.30469)"><rect style="fill:#f9f9f9;stroke:#000000;stroke-width:10px" x="-462.2413" y="-561.30469" width="480" height="480" rx="20" ry="20" id="rect15-5-0-8-9-7"></rect><g id="g6893-4-9-5-2" transform="matrix(1.2053353,0,0,1.2053353,-1246.7763,-599.46548)"><path style="fill:#000000;stroke-width:10;stroke-dasharray:none" d="M 850,120 V 310 Z" id="path1152-1-7-1-4"></path><path style="fill:#000000;stroke:#000000;stroke-width:8.29645;stroke-dasharray:none;stroke-opacity:1" d="M 850,110 V 310" id="path1160-08-5-7-1"></path><path style="fill:none;stroke:#000000;stroke-width:7.49273;stroke-dasharray:none;stroke-opacity:1" d="m 850,158.973 v 36.70355 8.15635 c 0,0 1.19184,39.5038 -36.01255,65.25076 -29.46481,20.39086 -52.3819,16.31269 -55.65576,65.25076 v 44.8599" id="path6610-14-5-4-8"></path><path style="fill:none;stroke:#000000;stroke-width:7.5253;stroke-dasharray:none;stroke-opacity:1" d="m 850,158.973 v 37.02335 8.22741 c 0,0 -1.19184,39.84799 36.01255,65.81929 29.46481,20.56853 52.3819,16.45482 55.65576,65.81929 v 45.25076" id="path6610-14-7-2-5-2"></path><path d="m 849.41763,64.456369 25.36824,31.087262 c 6.23336,6.364119 10.06921,15.063569 10.06921,24.656839 0,19.50109 -15.85132,35.30988 -35.42373,35.30988 -19.57241,0 -35.43242,-15.80879 -35.43242,-35.30988 0,-9.49405 3.75813,-18.11351 9.87536,-24.458879 z" style="fill:#009cde;stroke:#000000;stroke-width:8.29645;stroke-dasharray:none;paint-order:fill" id="path21-6-4-4-1-6"></path><circle style="fill:#f46351;stroke:#000000;stroke-width:8.29645;stroke-dasharray:none" cx="849.427" cy="326.5929" id="ellipse23-6-57-9-4-0" r="30"></circle><ellipse style="fill:#ccbaf4;stroke:#000000;stroke-width:8.29645;stroke-dasharray:none" cx="759.99994" cy="369.44669" id="ellipse25-7-9-4-6-3" rx="29.999952" ry="30.000004"></ellipse><ellipse style="fill:#ffc423;stroke:#000000;stroke-width:8.29645;stroke-dasharray:none" cx="939.99963" cy="369.44669" id="ellipse27-8-8-4-0-9" rx="29.999952" ry="30.000004"></ellipse></g></g><g id="g6663-4" transform="matrix(0.87890795,0,0,0.87890795,3770.6486,2734.4692)"></g></svg></div>`);
function Logo($$anchor) {
  var div = root$2();
  append($$anchor, div);
}
var root_3$1 = /* @__PURE__ */ from_html(`<span class="flowdrop-navbar__action-icon svelte-1qh46ob"><!></span>`);
var root_2 = /* @__PURE__ */ from_html(`<a><!> <span class="flowdrop-navbar__action-label svelte-1qh46ob"> </span></a>`);
var root_1$1 = /* @__PURE__ */ from_html(`<div class="flowdrop-navbar__actions svelte-1qh46ob"></div>`);
var root_4 = /* @__PURE__ */ from_html(`<div class="flowdrop-api-status svelte-1qh46ob"><div class="flowdrop-api-status__indicator flowdrop-api-status__indicator--connected svelte-1qh46ob"></div> <span class="flowdrop-text--xs flowdrop-text--gray svelte-1qh46ob">API Connected</span></div>`);
var root$1 = /* @__PURE__ */ from_html(`<div class="flowdrop-navbar svelte-1qh46ob"><div class="flowdrop-navbar__start svelte-1qh46ob"><a href="/" class="flowdrop-logo--container svelte-1qh46ob"><div class="flowdrop-flex flowdrop-gap--3 svelte-1qh46ob"><div class="flowdrop-logo--header svelte-1qh46ob"><!></div> <div><h1 class="flowdrop-text--logo flowdrop-font--bold svelte-1qh46ob">FlowDrop</h1> <p class="flowdrop-text--tagline flowdrop-text--gray svelte-1qh46ob">Visual Workflow Manager</p></div></div></a></div> <div class="flowdrop-navbar__center svelte-1qh46ob"><!></div> <div class="flowdrop-navbar__end svelte-1qh46ob"><!></div></div>`);
function Navbar($$anchor, $$props) {
  push($$props, true);
  let primaryActions = prop($$props, "primaryActions", 19, () => []), showStatus = prop($$props, "showStatus", 3, true);
  let currentPath = proxy(typeof window !== "undefined" ? window.location.pathname : "/");
  function isActive(href) {
    if (href === "/") {
      return currentPath === "/";
    }
    return currentPath.startsWith(href);
  }
  var div = root$1();
  var div_1 = child(div);
  var a = child(div_1);
  var div_2 = child(a);
  var div_3 = child(div_2);
  var node = child(div_3);
  Logo(node);
  var div_4 = sibling(div_1, 2);
  var node_1 = child(div_4);
  {
    var consequent_1 = ($$anchor2) => {
      var div_5 = root_1$1();
      each(div_5, 21, primaryActions, (action2) => action2.label, ($$anchor3, action2) => {
        var a_1 = root_2();
        a_1.__click = function(...$$args) {
          var _a2;
          (_a2 = get$3(action2).onclick) == null ? void 0 : _a2.apply(this, $$args);
        };
        var node_2 = child(a_1);
        {
          var consequent = ($$anchor4) => {
            var span = root_3$1();
            var node_3 = child(span);
            Icon(node_3, {
              get icon() {
                return get$3(action2).icon;
              },
              class: "w-4 h-4"
            });
            append($$anchor4, span);
          };
          if_block(node_2, ($$render) => {
            if (get$3(action2).icon) $$render(consequent);
          });
        }
        var span_1 = sibling(node_2, 2);
        var text2 = child(span_1);
        template_effect(
          ($0) => {
            set_attribute(a_1, "href", get$3(action2).href);
            set_class(a_1, 1, `flowdrop-navbar__action flowdrop-navbar__action--${get$3(action2).variant || "primary"} ${$0 != null ? $0 : ""}`, "svelte-1qh46ob");
            set_text(text2, get$3(action2).label);
          },
          [
            () => isActive(get$3(action2).href) ? "flowdrop-navbar__action--active" : ""
          ]
        );
        append($$anchor3, a_1);
      });
      append($$anchor2, div_5);
    };
    if_block(node_1, ($$render) => {
      if (primaryActions().length > 0) $$render(consequent_1);
    });
  }
  var div_6 = sibling(div_4, 2);
  var node_4 = child(div_6);
  {
    var consequent_2 = ($$anchor2) => {
      var div_7 = root_4();
      append($$anchor2, div_7);
    };
    if_block(node_4, ($$render) => {
      if (showStatus()) $$render(consequent_2);
    });
  }
  append($$anchor, div);
  pop();
}
delegate(["click"]);
function retryLoad(_2, fetchNodeTypes) {
  fetchNodeTypes();
}
function testApiConnection() {
  return __async(this, null, function* () {
    try {
      const testUrl = "/api/flowdrop/nodes";
      const response = yield fetch(testUrl);
      const data = yield response.json();
      if (response.ok && data.success) {
      } else {
      }
    } catch (err) {
    }
  });
}
function handleCanvasClick(event2, isConfigSidebarOpen, closeConfigSidebar) {
  const rightSidebar = document.querySelector(".flowdrop-sidebar--right");
  if (rightSidebar && !rightSidebar.contains(event2.target)) {
    if (get$3(isConfigSidebarOpen)) {
      closeConfigSidebar();
    }
  }
}
var root_1 = /* @__PURE__ */ from_html(`<meta name="description" content="A modern drag-and-drop workflow editor for LLM applications" class="svelte-14tth8q"/>`);
var root_3 = /* @__PURE__ */ from_html(`<div class="flowdrop-status flowdrop-status--loading svelte-14tth8q"><div class="flowdrop-status__content svelte-14tth8q"><div class="flowdrop-flex flowdrop-gap--3 svelte-14tth8q"><div class="flowdrop-spinner svelte-14tth8q"></div> <span class="flowdrop-text--sm flowdrop-font--medium svelte-14tth8q">Loading node types...</span></div></div></div>`);
var on_click = (__1, nodes, error) => {
  set$2(nodes, sampleNodes, true);
  set$2(error, null);
};
var on_click_1 = (__2, fetchNodeTypes) => {
  const defaultUrl = "/api/flowdrop";
  const newUrl = prompt("Enter Drupal API URL:", defaultUrl);
  if (newUrl) {
    const endpointConfig2 = createEndpointConfig(newUrl);
    setEndpointConfig(endpointConfig2);
    fetchNodeTypes();
  }
};
var on_click_2 = (__3, error) => set$2(error, null);
var root_5 = /* @__PURE__ */ from_html(`<div class="flowdrop-status flowdrop-status--error svelte-14tth8q"><div class="flowdrop-status__content svelte-14tth8q"><div class="flowdrop-flex flowdrop-gap--3 svelte-14tth8q"><div class="flowdrop-status__indicator flowdrop-status__indicator--error svelte-14tth8q"></div> <span class="flowdrop-text--sm flowdrop-font--medium svelte-14tth8q"> </span></div> <div class="flowdrop-flex flowdrop-gap--2 svelte-14tth8q"><button class="flowdrop-btn flowdrop-btn--sm flowdrop-btn--outline svelte-14tth8q" type="button">Retry</button> <button class="flowdrop-btn flowdrop-btn--sm flowdrop-btn--primary svelte-14tth8q" type="button">Use Sample Data</button> <button class="flowdrop-btn flowdrop-btn--sm flowdrop-btn--outline svelte-14tth8q" type="button">Set API URL</button> <button class="flowdrop-btn flowdrop-btn--sm flowdrop-btn--outline svelte-14tth8q" type="button">Test API</button> <button class="flowdrop-btn flowdrop-btn--ghost flowdrop-btn--sm svelte-14tth8q" type="button">✕</button></div></div></div>`);
var on_keydown = (e, closeConfigSidebar) => e.key === "Escape" && closeConfigSidebar();
var root_10 = /* @__PURE__ */ from_html(`<input type="text" class="flowdrop-config-sidebar__input svelte-14tth8q"/>`);
var root_12 = /* @__PURE__ */ from_html(`<input type="number" class="flowdrop-config-sidebar__input svelte-14tth8q"/>`);
var on_change = (e, configValues, key2) => {
  get$3(configValues)[key2()] = e.currentTarget.checked;
};
var root_14 = /* @__PURE__ */ from_html(`<input type="checkbox" class="flowdrop-config-sidebar__checkbox svelte-14tth8q"/>`);
var root_18 = /* @__PURE__ */ from_html(`<option class="svelte-14tth8q"> </option>`);
var root_21 = /* @__PURE__ */ from_html(`<option class="svelte-14tth8q"> </option>`);
var root_16 = /* @__PURE__ */ from_html(`<select class="flowdrop-config-sidebar__select svelte-14tth8q"><!></select>`);
var root_22 = /* @__PURE__ */ from_html(`<input type="text" class="flowdrop-config-sidebar__input svelte-14tth8q"/>`);
var root_23 = /* @__PURE__ */ from_html(`<p class="flowdrop-config-sidebar__field-description svelte-14tth8q"> </p>`);
var root_9 = /* @__PURE__ */ from_html(`<div class="flowdrop-config-sidebar__field svelte-14tth8q"><label class="flowdrop-config-sidebar__field-label svelte-14tth8q"> </label> <!> <!></div>`);
var root_24 = /* @__PURE__ */ from_html(`<div class="flowdrop-config-sidebar__debug svelte-14tth8q"><p class="svelte-14tth8q"><strong class="svelte-14tth8q">Debug - Config Schema:</strong></p> <pre class="svelte-14tth8q"> </pre></div>`);
var root_25 = /* @__PURE__ */ from_html(`<p class="flowdrop-config-sidebar__no-config svelte-14tth8q">No configuration options available for this node.</p>`);
var on_click_3 = (__4, selectedNodeForConfig, selectedNodeId, closeConfigSidebar) => {
  const currentNode = get$3(selectedNodeForConfig)();
  if (get$3(selectedNodeId) && currentNode) {
    const form = document.querySelector(".flowdrop-config-sidebar__form");
    const updatedConfig = {};
    if (form) {
      const inputs = form.querySelectorAll("input, select, textarea");
      inputs.forEach((input) => {
        if (input.id) {
          if (input.type === "checkbox") {
            updatedConfig[input.id] = input.checked;
          } else if (input.type === "number") {
            updatedConfig[input.id] = input.value ? Number(input.value) : input.value;
          } else {
            updatedConfig[input.id] = input.value;
          }
        }
      });
    }
    workflowActions.updateNode(get$3(selectedNodeId), {
      data: __spreadProps(__spreadValues({}, currentNode.data), { config: updatedConfig })
    });
  }
  closeConfigSidebar();
};
var root_6 = /* @__PURE__ */ from_html(`<div class="flowdrop-sidebar flowdrop-sidebar--right svelte-14tth8q"><div class="flowdrop-config-sidebar svelte-14tth8q"><div class="flowdrop-config-sidebar__header svelte-14tth8q"><h2 class="flowdrop-config-sidebar__title svelte-14tth8q"> </h2> <button class="flowdrop-config-sidebar__close svelte-14tth8q" aria-label="Close configuration sidebar">×</button></div> <div class="flowdrop-config-sidebar__content svelte-14tth8q"><div class="flowdrop-config-sidebar__section svelte-14tth8q"><h3 class="flowdrop-config-sidebar__section-title svelte-14tth8q">Node Details</h3> <div class="flowdrop-config-sidebar__details svelte-14tth8q"><div class="flowdrop-config-sidebar__detail svelte-14tth8q"><span class="flowdrop-config-sidebar__detail-label svelte-14tth8q">Type:</span> <span class="flowdrop-config-sidebar__detail-value svelte-14tth8q"> </span></div> <div class="flowdrop-config-sidebar__detail svelte-14tth8q"><span class="flowdrop-config-sidebar__detail-label svelte-14tth8q">Category:</span> <span class="flowdrop-config-sidebar__detail-value svelte-14tth8q"> </span></div> <div class="flowdrop-config-sidebar__detail svelte-14tth8q"><span class="flowdrop-config-sidebar__detail-label svelte-14tth8q">Description:</span> <p class="flowdrop-config-sidebar__detail-description svelte-14tth8q"> </p></div></div></div> <div class="flowdrop-config-sidebar__section svelte-14tth8q"><h3 class="flowdrop-config-sidebar__section-title svelte-14tth8q">Configuration</h3> <div class="flowdrop-config-sidebar__form svelte-14tth8q"><!></div></div></div> <div class="flowdrop-config-sidebar__footer svelte-14tth8q"><button class="flowdrop-config-sidebar__button flowdrop-config-sidebar__button--secondary svelte-14tth8q">Cancel</button> <button class="flowdrop-config-sidebar__button flowdrop-config-sidebar__button--primary svelte-14tth8q">Save Changes</button></div></div></div>`);
var root = /* @__PURE__ */ from_html(`<div class="flowdrop-app svelte-14tth8q"><!> <main class="flowdrop-main svelte-14tth8q"><!> <div class="flowdrop-editor-container svelte-14tth8q"><div class="flowdrop-sidebar flowdrop-sidebar--left svelte-14tth8q"><!></div> <div class="flowdrop-editor-main svelte-14tth8q" role="button" tabindex="0" aria-label="Workflow canvas - click to close sidebar"><!></div> <!></div></main></div>`);
function App($$anchor, $$props) {
  push($$props, true);
  const [$$stores, $$cleanup] = setup_stores();
  const $workflowStore = () => store_get(workflowStore, "$workflowStore", $$stores);
  let height = prop($$props, "height", 3, "100vh"), width = prop($$props, "width", 3, "100%"), showNavbar = prop($$props, "showNavbar", 3, false);
  let nodes = /* @__PURE__ */ state(proxy([]));
  let error = /* @__PURE__ */ state(null);
  let loading = /* @__PURE__ */ state(true);
  let endpointConfig2 = /* @__PURE__ */ state(null);
  let isConfigSidebarOpen = /* @__PURE__ */ state(false);
  let selectedNodeId = /* @__PURE__ */ state(null);
  let selectedNodeForConfig = /* @__PURE__ */ user_derived(() => () => {
    if (!get$3(selectedNodeId) || !$workflowStore()) return null;
    return $workflowStore().nodes.find((node) => node.id === get$3(selectedNodeId)) || null;
  });
  let workflowEditorRef = null;
  function fetchNodeTypes() {
    return __async(this, null, function* () {
      try {
        set$2(loading, true);
        set$2(error, null);
        const fetchedNodes = yield api.nodes.getNodes();
        set$2(nodes, fetchedNodes, true);
        set$2(error, null);
      } catch (err) {
        set$2(error, `API Error: ${err instanceof Error ? err.message : "Unknown error"}. Using sample data.`);
        set$2(nodes, sampleNodes, true);
      } finally {
        set$2(loading, false);
      }
    });
  }
  function initializeApiEndpoints() {
    return __async(this, null, function* () {
      const apiBaseUrl = "/api/flowdrop";
      const config = createEndpointConfig(apiBaseUrl, {
        auth: {
          type: "none"
          // No authentication for now
        },
        timeout: 1e4,
        // 10 second timeout
        retry: {
          enabled: true,
          maxAttempts: 2,
          delay: 1e3,
          backoff: "exponential"
        }
      });
      setEndpointConfig(config);
      set$2(endpointConfig2, config, true);
    });
  }
  function openConfigSidebar(node) {
    if (get$3(isConfigSidebarOpen) && get$3(selectedNodeId) === node.id) {
      closeConfigSidebar();
      return;
    }
    set$2(selectedNodeId, node.id, true);
    set$2(isConfigSidebarOpen, true);
  }
  function closeConfigSidebar() {
    set$2(isConfigSidebarOpen, false);
    set$2(selectedNodeId, null);
  }
  function saveWorkflow() {
    return __async(this, null, function* () {
      var _a2;
      try {
        yield tick();
        const { workflowApi: workflowApi2 } = yield Promise.resolve().then(() => api$1);
        const { v4: uuidv4 } = yield Promise.resolve().then(() => index);
        const workflowToSave = $workflowStore();
        if (!workflowToSave) {
          return;
        }
        let workflowId;
        if (workflowToSave.id) {
          workflowId = workflowToSave.id;
        } else {
          workflowId = uuidv4();
        }
        const finalWorkflow = {
          id: workflowId,
          name: workflowToSave.name || "Untitled Workflow",
          nodes: workflowToSave.nodes || [],
          edges: workflowToSave.edges || [],
          metadata: {
            version: "1.0.0",
            createdAt: ((_a2 = workflowToSave.metadata) == null ? void 0 : _a2.createdAt) || (/* @__PURE__ */ new Date()).toISOString(),
            updatedAt: (/* @__PURE__ */ new Date()).toISOString()
          }
        };
        const savedWorkflow = yield workflowApi2.saveWorkflow(finalWorkflow);
        if (savedWorkflow.id && savedWorkflow.id !== finalWorkflow.id) {
          workflowActions.batchUpdate({
            nodes: finalWorkflow.nodes,
            edges: finalWorkflow.edges,
            name: finalWorkflow.name,
            metadata: __spreadValues(__spreadValues({}, finalWorkflow.metadata), savedWorkflow.metadata)
          });
        }
      } catch (error2) {
        throw error2;
      }
    });
  }
  function exportWorkflow() {
    return __async(this, null, function* () {
      var _a2;
      try {
        yield tick();
        const workflowToExport = $workflowStore();
        if (!workflowToExport) {
          return;
        }
        const finalWorkflow = {
          id: workflowToExport.id || "untitled-workflow",
          name: workflowToExport.name || "Untitled Workflow",
          nodes: workflowToExport.nodes || [],
          edges: workflowToExport.edges || [],
          metadata: {
            version: "1.0.0",
            createdAt: ((_a2 = workflowToExport.metadata) == null ? void 0 : _a2.createdAt) || (/* @__PURE__ */ new Date()).toISOString(),
            updatedAt: (/* @__PURE__ */ new Date()).toISOString()
          }
        };
        const dataStr = JSON.stringify(finalWorkflow, null, 2);
        const dataBlob = new Blob([dataStr], { type: "application/json" });
        const url = URL.createObjectURL(dataBlob);
        const link2 = document.createElement("a");
        link2.href = url;
        link2.download = `${finalWorkflow.name}.json`;
        link2.click();
        URL.revokeObjectURL(url);
      } catch (error2) {
      }
    });
  }
  if (typeof window !== "undefined") {
    window.flowdropSave = saveWorkflow;
    window.flowdropExport = exportWorkflow;
  }
  onMount(() => __async(null, null, function* () {
    yield initializeApiEndpoints();
    yield fetchNodeTypes();
    if ($$props.workflow) {
      workflowActions.initialize($$props.workflow);
    }
  }));
  user_effect(() => {
    $workflowStore();
  });
  var div = root();
  head(($$anchor2) => {
    var meta = root_1();
    $document.title = "FlowDrop - Visual Workflow Manager";
    append($$anchor2, meta);
  });
  var node_1 = child(div);
  {
    var consequent = ($$anchor2) => {
      Navbar($$anchor2, {
        primaryActions: [
          {
            label: "Save",
            href: "#save",
            icon: "heroicons:document-arrow-down",
            variant: "primary",
            onclick: (e) => {
              e.preventDefault();
              saveWorkflow();
            }
          },
          {
            label: "Export",
            href: "#export",
            icon: "heroicons:arrow-down-tray",
            variant: "outline",
            onclick: (e) => {
              e.preventDefault();
              exportWorkflow();
            }
          }
        ],
        showStatus: true
      });
    };
    if_block(node_1, ($$render) => {
      if (showNavbar()) $$render(consequent);
    });
  }
  var main = sibling(node_1, 2);
  var node_2 = child(main);
  {
    var consequent_1 = ($$anchor2) => {
      var div_1 = root_3();
      append($$anchor2, div_1);
    };
    var alternate = ($$anchor2, $$elseif) => {
      {
        var consequent_2 = ($$anchor3) => {
          var div_2 = root_5();
          var div_3 = child(div_2);
          var div_4 = child(div_3);
          var span = sibling(child(div_4), 2);
          var text2 = child(span);
          var div_5 = sibling(div_4, 2);
          var button = child(div_5);
          button.__click = [retryLoad, fetchNodeTypes];
          var button_1 = sibling(button, 2);
          button_1.__click = [on_click, nodes, error];
          var button_2 = sibling(button_1, 2);
          button_2.__click = [on_click_1, fetchNodeTypes];
          var button_3 = sibling(button_2, 2);
          button_3.__click = [testApiConnection];
          var button_4 = sibling(button_3, 2);
          button_4.__click = [on_click_2, error];
          template_effect(() => {
            var _a2;
            return set_text(text2, `Error: ${(_a2 = get$3(error)) != null ? _a2 : ""}`);
          });
          append($$anchor3, div_2);
        };
        if_block(
          $$anchor2,
          ($$render) => {
            if (get$3(error)) $$render(consequent_2);
          },
          $$elseif
        );
      }
    };
    if_block(node_2, ($$render) => {
      if (get$3(loading)) $$render(consequent_1);
      else $$render(alternate, false);
    });
  }
  var div_6 = sibling(node_2, 2);
  var div_7 = child(div_6);
  var node_3 = child(div_7);
  NodeSidebar(node_3, {
    get nodes() {
      return get$3(nodes);
    }
  });
  var div_8 = sibling(div_7, 2);
  div_8.__click = [
    handleCanvasClick,
    isConfigSidebarOpen,
    closeConfigSidebar
  ];
  div_8.__keydown = [on_keydown, closeConfigSidebar];
  var node_4 = child(div_8);
  const expression = /* @__PURE__ */ user_derived(() => get$3(selectedNodeForConfig)());
  bind_this(
    WorkflowEditor(node_4, {
      get nodes() {
        return get$3(nodes);
      },
      get height() {
        return height();
      },
      get width() {
        return width();
      },
      get endpointConfig() {
        return get$3(endpointConfig2);
      },
      get isConfigSidebarOpen() {
        return get$3(isConfigSidebarOpen);
      },
      get selectedNodeForConfig() {
        return get$3(expression);
      },
      openConfigSidebar,
      closeConfigSidebar
    }),
    ($$value) => workflowEditorRef = $$value,
    () => workflowEditorRef
  );
  var node_5 = sibling(div_8, 2);
  {
    var consequent_12 = ($$anchor2) => {
      var div_9 = root_6();
      var div_10 = child(div_9);
      var div_11 = child(div_10);
      var h2 = child(div_11);
      var text_1 = child(h2);
      var button_5 = sibling(h2, 2);
      button_5.__click = closeConfigSidebar;
      var div_12 = sibling(div_11, 2);
      var div_13 = child(div_12);
      var div_14 = sibling(child(div_13), 2);
      var div_15 = child(div_14);
      var span_1 = sibling(child(div_15), 2);
      var text_2 = child(span_1);
      var div_16 = sibling(div_15, 2);
      var span_2 = sibling(child(div_16), 2);
      var text_3 = child(span_2);
      var div_17 = sibling(div_16, 2);
      var p = sibling(child(div_17), 2);
      var text_4 = child(p);
      var div_18 = sibling(div_13, 2);
      var div_19 = sibling(child(div_18), 2);
      var node_6 = child(div_19);
      {
        var consequent_11 = ($$anchor3) => {
          var fragment_1 = comment();
          const configSchema = /* @__PURE__ */ user_derived(() => get$3(selectedNodeForConfig)().data.metadata.configSchema);
          const nodeConfig = /* @__PURE__ */ user_derived(() => get$3(selectedNodeForConfig)().data.config || {});
          const configValues = /* @__PURE__ */ user_derived(() => (() => {
            const mergedConfig = {};
            if (get$3(configSchema).properties) {
              Object.entries(get$3(configSchema).properties).forEach(([key2, field]) => {
                const fieldConfig = field;
                mergedConfig[key2] = get$3(nodeConfig)[key2] !== void 0 ? get$3(nodeConfig)[key2] : fieldConfig.default;
              });
            }
            return mergedConfig;
          })());
          var node_7 = first_child(fragment_1);
          {
            var consequent_10 = ($$anchor4) => {
              var fragment_2 = comment();
              var node_8 = first_child(fragment_2);
              each(node_8, 17, () => Object.entries(get$3(configSchema).properties), index$1, ($$anchor5, $$item) => {
                var $$array = /* @__PURE__ */ user_derived(() => to_array(get$3($$item), 2));
                let key2 = () => get$3($$array)[0];
                let field = () => get$3($$array)[1];
                var div_20 = root_9();
                const fieldConfig = /* @__PURE__ */ user_derived(field);
                var label = child(div_20);
                var text_5 = child(label);
                var node_9 = sibling(label, 2);
                {
                  var consequent_3 = ($$anchor6) => {
                    var input_1 = root_10();
                    template_effect(
                      ($0) => {
                        set_attribute(input_1, "id", key2());
                        set_attribute(input_1, "placeholder", $0);
                      },
                      [
                        () => String(get$3(fieldConfig).placeholder || "")
                      ]
                    );
                    bind_value(input_1, () => get$3(configValues)[key2()], ($$value) => get$3(configValues)[key2()] = $$value);
                    append($$anchor6, input_1);
                  };
                  var alternate_1 = ($$anchor6, $$elseif) => {
                    {
                      var consequent_4 = ($$anchor7) => {
                        var input_2 = root_12();
                        template_effect(
                          ($0) => {
                            set_attribute(input_2, "id", key2());
                            set_attribute(input_2, "placeholder", $0);
                          },
                          [
                            () => String(get$3(fieldConfig).placeholder || "")
                          ]
                        );
                        bind_value(input_2, () => get$3(configValues)[key2()], ($$value) => get$3(configValues)[key2()] = $$value);
                        append($$anchor7, input_2);
                      };
                      var alternate_2 = ($$anchor7, $$elseif2) => {
                        {
                          var consequent_5 = ($$anchor8) => {
                            var input_3 = root_14();
                            input_3.__change = [on_change, configValues, key2];
                            template_effect(
                              ($0) => {
                                set_attribute(input_3, "id", key2());
                                set_checked(input_3, $0);
                              },
                              [
                                () => Boolean(get$3(configValues)[key2()] || get$3(fieldConfig).default || false)
                              ]
                            );
                            append($$anchor8, input_3);
                          };
                          var alternate_3 = ($$anchor8, $$elseif3) => {
                            {
                              var consequent_8 = ($$anchor9) => {
                                var select2 = root_16();
                                var node_10 = child(select2);
                                {
                                  var consequent_6 = ($$anchor10) => {
                                    var fragment_3 = comment();
                                    var node_11 = first_child(fragment_3);
                                    each(node_11, 17, () => get$3(fieldConfig).enum, index$1, ($$anchor11, option) => {
                                      var option_1 = root_18();
                                      var text_6 = child(option_1);
                                      var option_1_value = {};
                                      template_effect(
                                        ($0, $1) => {
                                          var _a2;
                                          set_text(text_6, $0);
                                          if (option_1_value !== (option_1_value = $1)) {
                                            option_1.value = (_a2 = option_1.__value = $1) != null ? _a2 : "";
                                          }
                                        },
                                        [
                                          () => String(get$3(option)),
                                          () => String(get$3(option))
                                        ]
                                      );
                                      append($$anchor11, option_1);
                                    });
                                    append($$anchor10, fragment_3);
                                  };
                                  var alternate_4 = ($$anchor10, $$elseif4) => {
                                    {
                                      var consequent_7 = ($$anchor11) => {
                                        var fragment_4 = comment();
                                        var node_12 = first_child(fragment_4);
                                        each(node_12, 17, () => get$3(fieldConfig).options, index$1, ($$anchor12, option) => {
                                          var option_2 = root_21();
                                          const optionConfig = /* @__PURE__ */ user_derived(() => get$3(option));
                                          var text_7 = child(option_2);
                                          var option_2_value = {};
                                          template_effect(
                                            ($0, $1) => {
                                              var _a2;
                                              set_text(text_7, $0);
                                              if (option_2_value !== (option_2_value = $1)) {
                                                option_2.value = (_a2 = option_2.__value = $1) != null ? _a2 : "";
                                              }
                                            },
                                            [
                                              () => String(get$3(optionConfig).label),
                                              () => String(get$3(optionConfig).value)
                                            ]
                                          );
                                          append($$anchor12, option_2);
                                        });
                                        append($$anchor11, fragment_4);
                                      };
                                      if_block(
                                        $$anchor10,
                                        ($$render) => {
                                          if (get$3(fieldConfig).options) $$render(consequent_7);
                                        },
                                        $$elseif4
                                      );
                                    }
                                  };
                                  if_block(node_10, ($$render) => {
                                    if (get$3(fieldConfig).enum) $$render(consequent_6);
                                    else $$render(alternate_4, false);
                                  });
                                }
                                template_effect(() => set_attribute(select2, "id", key2()));
                                bind_select_value(select2, () => get$3(configValues)[key2()], ($$value) => get$3(configValues)[key2()] = $$value);
                                append($$anchor9, select2);
                              };
                              var alternate_5 = ($$anchor9) => {
                                var input_4 = root_22();
                                template_effect(
                                  ($0) => {
                                    set_attribute(input_4, "id", key2());
                                    set_attribute(input_4, "placeholder", $0);
                                  },
                                  [
                                    () => String(get$3(fieldConfig).placeholder || "")
                                  ]
                                );
                                bind_value(input_4, () => get$3(configValues)[key2()], ($$value) => get$3(configValues)[key2()] = $$value);
                                append($$anchor9, input_4);
                              };
                              if_block(
                                $$anchor8,
                                ($$render) => {
                                  if (get$3(fieldConfig).type === "select" || get$3(fieldConfig).enum) $$render(consequent_8);
                                  else $$render(alternate_5, false);
                                },
                                $$elseif3
                              );
                            }
                          };
                          if_block(
                            $$anchor7,
                            ($$render) => {
                              if (get$3(fieldConfig).type === "boolean") $$render(consequent_5);
                              else $$render(alternate_3, false);
                            },
                            $$elseif2
                          );
                        }
                      };
                      if_block(
                        $$anchor6,
                        ($$render) => {
                          if (get$3(fieldConfig).type === "number") $$render(consequent_4);
                          else $$render(alternate_2, false);
                        },
                        $$elseif
                      );
                    }
                  };
                  if_block(node_9, ($$render) => {
                    if (get$3(fieldConfig).type === "string") $$render(consequent_3);
                    else $$render(alternate_1, false);
                  });
                }
                var node_13 = sibling(node_9, 2);
                {
                  var consequent_9 = ($$anchor6) => {
                    var p_1 = root_23();
                    var text_8 = child(p_1);
                    template_effect(($0) => set_text(text_8, $0), [
                      () => String(get$3(fieldConfig).description)
                    ]);
                    append($$anchor6, p_1);
                  };
                  if_block(node_13, ($$render) => {
                    if (get$3(fieldConfig).description) $$render(consequent_9);
                  });
                }
                template_effect(() => {
                  set_attribute(label, "for", key2());
                  set_text(text_5, get$3(fieldConfig).title || get$3(fieldConfig).description || key2());
                });
                append($$anchor5, div_20);
              });
              append($$anchor4, fragment_2);
            };
            var alternate_6 = ($$anchor4) => {
              var div_21 = root_24();
              var pre = sibling(child(div_21), 2);
              var text_9 = child(pre);
              template_effect(($0) => set_text(text_9, $0), [
                () => JSON.stringify(get$3(configSchema), null, 2)
              ]);
              append($$anchor4, div_21);
            };
            if_block(node_7, ($$render) => {
              if (get$3(configSchema).properties) $$render(consequent_10);
              else $$render(alternate_6, false);
            });
          }
          append($$anchor3, fragment_1);
        };
        var alternate_7 = ($$anchor3) => {
          var p_2 = root_25();
          append($$anchor3, p_2);
        };
        if_block(node_6, ($$render) => {
          var _a2;
          if ((_a2 = get$3(selectedNodeForConfig)().data.metadata) == null ? void 0 : _a2.configSchema) $$render(consequent_11);
          else $$render(alternate_7, false);
        });
      }
      var div_22 = sibling(div_12, 2);
      var button_6 = child(div_22);
      button_6.__click = closeConfigSidebar;
      var button_7 = sibling(button_6, 2);
      button_7.__click = [
        on_click_3,
        selectedNodeForConfig,
        selectedNodeId,
        closeConfigSidebar
      ];
      template_effect(
        ($0, $1, $2, $3) => {
          set_text(text_1, $0);
          set_text(text_2, $1);
          set_text(text_3, $2);
          set_text(text_4, $3);
        },
        [
          () => get$3(selectedNodeForConfig)().data.label,
          () => {
            var _a2;
            return ((_a2 = get$3(selectedNodeForConfig)().data.metadata) == null ? void 0 : _a2.type) || get$3(selectedNodeForConfig)().type;
          },
          () => {
            var _a2;
            return ((_a2 = get$3(selectedNodeForConfig)().data.metadata) == null ? void 0 : _a2.category) || "general";
          },
          () => {
            var _a2;
            return ((_a2 = get$3(selectedNodeForConfig)().data.metadata) == null ? void 0 : _a2.description) || "Node configuration";
          }
        ]
      );
      append($$anchor2, div_9);
    };
    if_block(node_5, ($$render) => {
      if (get$3(selectedNodeForConfig)()) $$render(consequent_12);
    });
  }
  template_effect(() => {
    var _a2, _b2;
    return set_style(div, `height: ${(_a2 = typeof height() === "number" ? `${height()}px` : height()) != null ? _a2 : ""}; width: ${(_b2 = typeof width() === "number" ? `${width()}px` : width()) != null ? _b2 : ""};`);
  });
  append($$anchor, div);
  pop();
  $$cleanup();
}
delegate(["click", "keydown", "change"]);
const DEFAULT_PORT_CONFIG = {
  version: "1.0.0",
  defaultDataType: "string",
  dataTypes: [
    // Text and basic types
    {
      id: "string",
      name: "String",
      description: "Text data",
      color: "var(--color-ref-emerald-500)",
      category: "basic",
      enabled: true
    },
    // Numeric types
    {
      id: "number",
      name: "Number",
      description: "Numeric data",
      color: "var(--color-ref-blue-600)",
      category: "numeric",
      enabled: true
    },
    // Boolean types
    {
      id: "boolean",
      name: "Boolean",
      description: "True/false values",
      color: "var(--color-ref-purple-600)",
      category: "logical",
      enabled: true
    },
    // Collection types
    {
      id: "array",
      name: "Array",
      description: "Ordered list of items",
      color: "var(--color-ref-amber-500)",
      category: "collection",
      enabled: true
    },
    // Typed arrays
    {
      id: "string[]",
      name: "String Array",
      description: "Array of strings",
      color: "var(--color-ref-emerald-400)",
      category: "collection",
      enabled: true
    },
    {
      id: "number[]",
      name: "Number Array",
      description: "Array of numbers",
      color: "var(--color-ref-blue-400)",
      category: "collection",
      enabled: true
    },
    {
      id: "boolean[]",
      name: "Boolean Array",
      description: "Array of true/false values",
      color: "var(--color-ref-purple-400)",
      category: "collection",
      enabled: true
    },
    {
      id: "json[]",
      name: "JSON Array",
      description: "Array of JSON objects",
      color: "var(--color-ref-orange-400)",
      category: "collection",
      enabled: true
    },
    {
      id: "file[]",
      name: "File Array",
      description: "Array of files",
      color: "var(--color-ref-red-400)",
      category: "collection",
      enabled: true
    },
    {
      id: "image[]",
      name: "Image Array",
      description: "Array of images",
      color: "var(--color-ref-pink-400)",
      category: "collection",
      enabled: true
    },
    // Complex types
    {
      id: "json",
      name: "JSON",
      description: "JSON structured data",
      color: "var(--color-ref-orange-500)",
      category: "complex",
      enabled: true
    },
    // File types
    {
      id: "file",
      name: "File",
      description: "File data",
      color: "var(--color-ref-red-500)",
      category: "file",
      enabled: true
    },
    // Media types
    {
      id: "image",
      name: "Image",
      description: "Image data",
      color: "var(--color-ref-pink-500)",
      category: "media",
      enabled: true
    },
    {
      id: "audio",
      name: "Audio",
      description: "Audio data",
      color: "var(--color-ref-indigo-500)",
      category: "media",
      enabled: true
    },
    {
      id: "video",
      name: "Video",
      description: "Video data",
      color: "var(--color-ref-teal-500)",
      category: "media",
      enabled: true
    },
    // Special types
    {
      id: "url",
      name: "URL",
      description: "Web address",
      color: "var(--color-ref-cyan-500)",
      category: "special",
      enabled: true
    },
    {
      id: "email",
      name: "Email",
      description: "Email address",
      color: "var(--color-ref-cyan-500)",
      category: "special",
      enabled: true
    },
    {
      id: "date",
      name: "Date",
      description: "Date value",
      color: "var(--color-ref-lime-500)",
      category: "temporal",
      enabled: true
    },
    {
      id: "datetime",
      name: "DateTime",
      description: "Date and time value",
      color: "var(--color-ref-lime-500)",
      category: "temporal",
      enabled: true
    },
    {
      id: "time",
      name: "Time",
      description: "Time value",
      color: "var(--color-ref-lime-500)",
      category: "temporal",
      enabled: true
    }
  ],
  compatibilityRules: [
    // Pure same-type compatibility: string connects to string, number to number, etc.
    // No additional rules needed - the system handles same-type connections automatically
  ]
};
function fetchPortConfig(endpointConfig2) {
  return __async(this, null, function* () {
    var _a2;
    try {
      const url = buildEndpointUrl(endpointConfig2, endpointConfig2.endpoints.portConfig);
      console.log("📡 Fetching port configuration from:", url);
      const client = new FlowDropApiClient(endpointConfig2.baseUrl);
      const portConfig = yield client.getPortConfig();
      if (!portConfig.dataTypes || !Array.isArray(portConfig.dataTypes)) {
        console.warn("⚠️ Invalid port config received from API, using default");
        return DEFAULT_PORT_CONFIG;
      }
      console.log("✅ Port configuration loaded successfully:", {
        version: portConfig.version,
        dataTypesCount: portConfig.dataTypes.length,
        rulesCount: ((_a2 = portConfig.compatibilityRules) == null ? void 0 : _a2.length) || 0,
        defaultType: portConfig.defaultDataType
      });
      return portConfig;
    } catch (error) {
      console.error("❌ Error fetching port configuration:", error);
      console.log("🔄 Falling back to default port configuration");
      return DEFAULT_PORT_CONFIG;
    }
  });
}
function mountFlowDropApp(_0) {
  return __async(this, arguments, function* (container, options = {}) {
    const { workflow, nodes = [], endpointConfig: endpointConfig2, portConfig, height = "100vh", width = "100%", showNavbar = false } = options;
    let config;
    if (endpointConfig2) {
      const { defaultEndpointConfig: defaultEndpointConfig2 } = yield Promise.resolve().then(() => endpoints);
      config = __spreadProps(__spreadValues(__spreadValues({}, defaultEndpointConfig2), endpointConfig2), {
        endpoints: __spreadValues(__spreadValues({}, defaultEndpointConfig2.endpoints), endpointConfig2.endpoints)
      });
    } else {
      const { defaultEndpointConfig: defaultEndpointConfig2 } = yield Promise.resolve().then(() => endpoints);
      config = defaultEndpointConfig2;
    }
    let finalPortConfig = portConfig;
    if (!finalPortConfig && config) {
      try {
        finalPortConfig = yield fetchPortConfig(config);
      } catch (error) {
        console.warn("Failed to fetch port config from API, using default:", error);
        finalPortConfig = DEFAULT_PORT_CONFIG;
      }
    } else if (!finalPortConfig) {
      finalPortConfig = DEFAULT_PORT_CONFIG;
    }
    initializePortCompatibility(finalPortConfig);
    const app = mount(App, {
      target: container,
      props: {
        workflow,
        height,
        width,
        showNavbar
      }
    });
    app.save = () => __async(null, null, function* () {
      if (typeof window !== "undefined" && window.flowdropSave) {
        yield window.flowdropSave();
      } else {
        console.warn("⚠️ Save functionality not available");
      }
    });
    app.export = () => {
      if (typeof window !== "undefined" && window.flowdropExport) {
        window.flowdropExport();
      } else {
        console.warn("⚠️ Export functionality not available");
      }
    };
    return app;
  });
}
function mountWorkflowEditor(_0) {
  return __async(this, arguments, function* (container, options = {}) {
    const { workflow, nodes = [], endpointConfig: endpointConfig2, portConfig } = options;
    let config;
    if (endpointConfig2) {
      const { defaultEndpointConfig: defaultEndpointConfig2 } = yield Promise.resolve().then(() => endpoints);
      config = __spreadProps(__spreadValues(__spreadValues({}, defaultEndpointConfig2), endpointConfig2), {
        endpoints: __spreadValues(__spreadValues({}, defaultEndpointConfig2.endpoints), endpointConfig2.endpoints)
      });
    } else {
      const { defaultEndpointConfig: defaultEndpointConfig2 } = yield Promise.resolve().then(() => endpoints);
      config = defaultEndpointConfig2;
    }
    let finalPortConfig = portConfig;
    if (!finalPortConfig && config) {
      try {
        finalPortConfig = yield fetchPortConfig(config);
      } catch (error) {
        console.warn("Failed to fetch port config from API, using default:", error);
        finalPortConfig = DEFAULT_PORT_CONFIG;
      }
    } else if (!finalPortConfig) {
      finalPortConfig = DEFAULT_PORT_CONFIG;
    }
    initializePortCompatibility(finalPortConfig);
    const app = mount(WorkflowEditor, {
      target: container,
      props: {
        workflow,
        nodes,
        endpointConfig: config
      }
    });
    return app;
  });
}
function unmountFlowDropApp(app) {
  if (app && typeof app.destroy === "function") {
    app.destroy();
  }
}
function unmountWorkflowEditor(app) {
  unmountFlowDropApp(app);
}
export {
  ApiClient,
  ApiError,
  CATEGORY_COLOR_TOKENS,
  CATEGORY_ICONS,
  CanvasBanner,
  DATA_TYPE_COLOR_TOKENS,
  DEFAULT_COLORS,
  DEFAULT_ICONS,
  EnhancedFlowDropApiClient,
  FlowDropApiClient,
  NodeSidebar,
  NotesNode as NotesNodeComponent,
  PortCompatibilityChecker,
  SimpleNode as SimpleNodeComponent,
  ToolNode as ToolNodeComponent,
  WorkflowAdapter,
  WorkflowEditor,
  WorkflowNode as WorkflowNodeComponent,
  api,
  areDataTypesCompatible,
  buildEndpointUrl,
  createConfigFromEnv,
  createDefaultAPIConfig,
  createDefaultConfig,
  createDefaultExecutionConfig,
  createDefaultFeatures,
  createDefaultStorageConfig,
  createDefaultUIConfig,
  createEndpointConfig,
  createNodeTypeConfigProperty,
  defaultEndpointConfig,
  getArrayElementType,
  getAvailableDataTypes,
  getAvailableNodeTypes,
  getCategoryAccent,
  getCategoryBackground,
  getCategoryBorder,
  getCategoryColorToken,
  getCategoryColors,
  getCategoryIcon,
  getCategoryText,
  getComponentNameForNodeType,
  getConnectionSuggestions,
  getDataTypeColor,
  getDataTypeColorToken,
  getDataTypeConfig,
  getDataTypeDisplayText,
  getDefaultIcon,
  getEndpointConfig,
  getEndpointHeaders,
  getEndpointMethod,
  getExecutionOrder,
  getNodeAccent,
  getNodeBackground,
  getNodeBorder,
  getNodeColors,
  getNodeIcon,
  getNodeText,
  getNodeTypeEnumOptions,
  getPortCompatibilityChecker,
  getPossibleConnections,
  getPrimaryNodeType,
  getValidIcon,
  hasCycles,
  initializePortCompatibility,
  isArrayDataType,
  isNodeTypeSupported,
  isValidIcon,
  mergeConfig,
  mountFlowDropApp,
  mountWorkflowEditor,
  nodeApi,
  parseDataTypeDisplay,
  resolveComponentName,
  resolveNodeType,
  sampleNodes,
  sampleWorkflow,
  setApiBaseUrl,
  setEndpointConfig,
  unmountFlowDropApp,
  unmountWorkflowEditor,
  validateConfig,
  validateConnection,
  workflowApi
};
//# sourceMappingURL=flowdrop.es.js.map
