# FlowDrop AI Provider

Provides AI provider integration for FlowDrop workflows, enabling conversational
AI capabilities through the Drupal AI module.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/flowdrop_ai_provider).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/flowdrop_ai_provider).


## Table of contents

- Requirements
- Installation
- Configuration
- Features
- Maintainers


## Requirements

This module requires the following modules:

- [Drupal AI](https://www.drupal.org/project/ai) (^1.0)
- [AI Agents](https://www.drupal.org/project/ai_agents) (^1.0)
- [FlowDrop](https://www.drupal.org/project/flowdrop) (^1.0)
- [FlowDrop Node Type](https://www.drupal.org/project/flowdrop) (^1.0)

PHP 8.1 or higher is required.


## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).


## Configuration

The module provides AI model configurations out of the box. No additional
configuration is required after installation.


## Features

### FlowDrop Node Processors

#### Chat Model Processor
Executes AI chat requests with support for multiple AI providers.

#### Chat Output Processor
Formats and displays AI responses with multiple output formats.


## Maintainers

- David Galeano - [gxleano](https://www.drupal.org/u/gxleano)
