/**
 * FlowDrop IIFE Wrapper
 * This module re-exports the @d34dman/flowdrop library for IIFE consumption
 *
 * @description
 * This wrapper allows the FlowDrop library to be consumed as an IIFE (Immediately Invoked Function Expression)
 * for use in browser environments, Drupal integrations, and other contexts where ES modules are not ideal.
 *
 * All exports from @d34dman/flowdrop are re-exported here without modification,
 * preserving the full API surface and functionality.
 *
 * @example
 * // Include in HTML
 * <link rel="stylesheet" href="flowdrop.css">
 * <script src="flowdrop.iife.js"></script>
 * <script>
 *   const { WorkflowEditor, mountWorkflowEditor } = window.FlowDrop;
 *   mountWorkflowEditor('#app', { apiEndpoint: '/api' });
 * </script>
 */

/**
 * Import base CSS styles from the FlowDrop package
 * This ensures styles are bundled with the IIFE output
 */
import "@d34dman/flowdrop/styles/base.css";

/**
 * Re-export all types from main entry point
 * Includes types from: core, form, display, playground, editor
 */
export type * from "@d34dman/flowdrop";

/**
 * Re-export all runtime exports from main entry point
 * Includes utilities, components, and services from: core, form, display, playground, editor
 */
export * from "@d34dman/flowdrop";

/**
 * Re-export from form/code sub-module
 * Provides CodeMirror-based code/JSON editor support for SchemaForm
 * Includes: FormCodeEditor, FormTemplateEditor, registerCodeEditorField, etc.
 */
export * from "@d34dman/flowdrop/form/code";

/**
 * Re-export from form/markdown sub-module
 * Provides EasyMDE-based markdown editor support for SchemaForm
 * Includes: FormMarkdownEditor, registerMarkdownEditorField, etc.
 */
export * from "@d34dman/flowdrop/form/markdown";

/**
 * Re-export from form/full sub-module
 * Provides convenience functions to initialize all form field types at once
 * Includes: initializeAllFieldTypes, areAllFieldTypesInitialized, etc.
 */
export {
    initializeAllFieldTypes,
    areAllFieldTypesInitialized,
    resetFieldTypeInitialization
} from "@d34dman/flowdrop/form/full";
