var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __typeError = (msg) => {
  throw TypeError(msg);
};
var __defNormalProp = (obj, key2, value) => key2 in obj ? __defProp(obj, key2, { enumerable: true, configurable: true, writable: true, value }) : obj[key2] = value;
var __spreadValues = (a, b2) => {
  for (var prop2 in b2 || (b2 = {}))
    if (__hasOwnProp.call(b2, prop2))
      __defNormalProp(a, prop2, b2[prop2]);
  if (__getOwnPropSymbols)
    for (var prop2 of __getOwnPropSymbols(b2)) {
      if (__propIsEnum.call(b2, prop2))
        __defNormalProp(a, prop2, b2[prop2]);
    }
  return a;
};
var __spreadProps = (a, b2) => __defProps(a, __getOwnPropDescs(b2));
var __objRest = (source2, exclude) => {
  var target = {};
  for (var prop2 in source2)
    if (__hasOwnProp.call(source2, prop2) && exclude.indexOf(prop2) < 0)
      target[prop2] = source2[prop2];
  if (source2 != null && __getOwnPropSymbols)
    for (var prop2 of __getOwnPropSymbols(source2)) {
      if (exclude.indexOf(prop2) < 0 && __propIsEnum.call(source2, prop2))
        target[prop2] = source2[prop2];
    }
  return target;
};
var __publicField = (obj, key2, value) => __defNormalProp(obj, typeof key2 !== "symbol" ? key2 + "" : key2, value);
var __accessCheck = (obj, member, msg) => member.has(obj) || __typeError("Cannot " + msg);
var __privateGet = (obj, member, getter) => (__accessCheck(obj, member, "read from private field"), getter ? getter.call(obj) : member.get(obj));
var __privateAdd = (obj, member, value) => member.has(obj) ? __typeError("Cannot add the same private member more than once") : member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
var __privateSet = (obj, member, value, setter) => (__accessCheck(obj, member, "write to private field"), setter ? setter.call(obj, value) : member.set(obj, value), value);
var __privateMethod = (obj, member, method) => (__accessCheck(obj, member, "access private method"), method);
var __async = (__this, __arguments, generator) => {
  return new Promise((resolve, reject) => {
    var fulfilled = (value) => {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    };
    var rejected = (value) => {
      try {
        step(generator.throw(value));
      } catch (e) {
        reject(e);
      }
    };
    var step = (x2) => x2.done ? resolve(x2.value) : Promise.resolve(x2.value).then(fulfilled, rejected);
    step((generator = generator.apply(__this, __arguments)).next());
  });
};
var _a2, _b, _c, _d, _e2, _previous, _callbacks, _pending, _blocking_pending, _deferred, _dirty_effects, _maybe_dirty_effects, _Batch_instances, traverse_effect_tree_fn, defer_effects_fn, resolve_fn, commit_fn, _pending2, _anchor, _hydrate_open, _props, _children, _effect, _main_effect, _pending_effect, _failed_effect, _offscreen_fragment, _local_pending_count, _pending_count, _is_creating_fallback, _effect_pending, _effect_pending_update, _effect_pending_subscriber, _Boundary_instances, hydrate_resolved_content_fn, hydrate_pending_content_fn, run_fn, show_pending_snippet_fn, update_pending_count_fn, _batches, _onscreen, _offscreen, _transition, _commit, _listeners, _observer, _options, _ResizeObserverSingleton_instances, getObserver_fn, _sources, _version, _size, _update_version, _SvelteSet_instances, source_fn, init_fn, _fn, _subscribe, _f;
function _mergeNamespaces(n, m2) {
  for (var i = 0; i < m2.length; i++) {
    const e = m2[i];
    if (typeof e !== "string" && !Array.isArray(e)) {
      for (const k2 in e) {
        if (k2 !== "default" && !(k2 in n)) {
          const d = Object.getOwnPropertyDescriptor(e, k2);
          if (d) {
            Object.defineProperty(n, k2, d.get ? d : {
              enumerable: true,
              get: () => e[k2]
            });
          }
        }
      }
    }
  }
  return Object.freeze(Object.defineProperty(n, Symbol.toStringTag, { value: "Module" }));
}
const CHAT_INPUT_PATTERNS = [
  "chat_input",
  "text_input",
  "user_input",
  "message_input",
  "prompt_input"
];
function isChatInputNode(nodeTypeId) {
  const normalizedId = nodeTypeId.toLowerCase();
  return CHAT_INPUT_PATTERNS.some((pattern) => normalizedId.includes(pattern));
}
class StaticAuthProvider {
  /**
   * Create a new StaticAuthProvider
   *
   * @param config - Static authentication configuration
   */
  constructor(config) {
    /** Cached authentication headers */
    __publicField(this, "headers");
    this.headers = {};
    switch (config.type) {
      case "bearer":
        if (config.token) {
          this.headers["Authorization"] = `Bearer ${config.token}`;
        }
        break;
      case "api_key":
        if (config.apiKey) {
          this.headers["X-API-Key"] = config.apiKey;
        }
        break;
      case "custom":
        if (config.headers) {
          this.headers = __spreadValues({}, config.headers);
        }
        break;
    }
  }
  /**
   * Get authentication headers
   *
   * Returns the statically configured headers.
   *
   * @returns Promise resolving to authentication headers
   */
  getAuthHeaders() {
    return __async(this, null, function* () {
      return this.headers;
    });
  }
  /**
   * Check if authenticated
   *
   * Returns true if any auth headers are configured.
   *
   * @returns true if headers are configured
   */
  isAuthenticated() {
    return Object.keys(this.headers).length > 0;
  }
  /**
   * Handle unauthorized response
   *
   * Static provider cannot refresh tokens, so always returns false.
   *
   * @returns Promise resolving to false (cannot refresh)
   */
  onUnauthorized() {
    return __async(this, null, function* () {
      return false;
    });
  }
  /**
   * Handle forbidden response
   *
   * Static provider has no special handling for 403.
   */
  onForbidden() {
    return __async(this, null, function* () {
    });
  }
}
class CallbackAuthProvider {
  /**
   * Create a new CallbackAuthProvider
   *
   * @param config - Callback authentication configuration
   */
  constructor(config) {
    /** Function to get the current token */
    __publicField(this, "getToken");
    /** Optional unauthorized callback */
    __publicField(this, "onUnauthorizedCallback");
    /** Optional forbidden callback */
    __publicField(this, "onForbiddenCallback");
    this.getToken = config.getToken;
    this.onUnauthorizedCallback = config.onUnauthorized;
    this.onForbiddenCallback = config.onForbidden;
  }
  /**
   * Get authentication headers
   *
   * Calls the getToken callback to retrieve the current token.
   *
   * @returns Promise resolving to authentication headers
   */
  getAuthHeaders() {
    return __async(this, null, function* () {
      const token = yield this.getToken();
      if (token) {
        return { Authorization: `Bearer ${token}` };
      }
      return {};
    });
  }
  /**
   * Check if authenticated
   *
   * For callback-based auth, we assume authenticated if getToken exists.
   * The actual token validity is checked when making requests.
   *
   * @returns true (assumes authenticated, actual check happens on request)
   */
  isAuthenticated() {
    return true;
  }
  /**
   * Handle unauthorized response
   *
   * Calls the onUnauthorized callback if provided.
   *
   * @returns Promise resolving to true if auth was refreshed
   */
  onUnauthorized() {
    return __async(this, null, function* () {
      if (this.onUnauthorizedCallback) {
        return this.onUnauthorizedCallback();
      }
      return false;
    });
  }
  /**
   * Handle forbidden response
   *
   * Calls the onForbidden callback if provided.
   */
  onForbidden() {
    return __async(this, null, function* () {
      if (this.onForbiddenCallback) {
        yield this.onForbiddenCallback();
      }
    });
  }
}
class NoAuthProvider {
  /**
   * Get authentication headers
   *
   * Returns empty headers (no auth).
   *
   * @returns Promise resolving to empty object
   */
  getAuthHeaders() {
    return __async(this, null, function* () {
      return {};
    });
  }
  /**
   * Check if authenticated
   *
   * Always returns false (no auth configured).
   *
   * @returns false
   */
  isAuthenticated() {
    return false;
  }
}
const DEFAULT_FEATURES = {
  autoSaveDraft: true,
  autoSaveDraftInterval: 3e4,
  showToasts: true
};
function mergeFeatures(features) {
  return __spreadValues(__spreadValues({}, DEFAULT_FEATURES), features);
}
function getStatusColor(status) {
  const statusColors = {
    idle: "#6b7280",
    // gray
    pending: "#f59e0b",
    // amber
    running: "#3b82f6",
    // blue
    completed: "#10b981",
    // emerald
    failed: "#ef4444",
    // red
    cancelled: "#6b7280",
    // gray
    skipped: "#8b5cf6"
    // violet
  };
  return statusColors[status] || statusColors.idle;
}
function getStatusIcon(status) {
  const statusIcons = {
    idle: "mdi:circle-outline",
    pending: "mdi:clock-outline",
    running: "mdi:loading",
    completed: "mdi:check-circle",
    failed: "mdi:alert-circle",
    cancelled: "mdi:cancel",
    skipped: "mdi:skip-next"
  };
  return statusIcons[status] || statusIcons.idle;
}
function getStatusLabel(status) {
  const statusLabels = {
    idle: "Idle",
    pending: "Pending",
    running: "Running",
    completed: "Completed",
    failed: "Failed",
    cancelled: "Cancelled",
    skipped: "Skipped"
  };
  return statusLabels[status] || statusLabels.idle;
}
function getStatusBackgroundColor(status) {
  const statusBackgroundColors = {
    idle: "#f9fafb",
    // light gray
    pending: "#fef3c7",
    // light amber
    running: "#dbeafe",
    // light blue
    completed: "#d1fae5",
    // light emerald
    failed: "#fee2e2",
    // light red
    cancelled: "#f3f4f6",
    // light gray
    skipped: "#ede9fe"
    // light violet
  };
  return statusBackgroundColors[status] || statusBackgroundColors.idle;
}
function getStatusTextColor(status) {
  const statusTextColors = {
    idle: "#6b7280",
    // gray
    pending: "#d97706",
    // amber
    running: "#1d4ed8",
    // blue
    completed: "#059669",
    // emerald
    failed: "#dc2626",
    // red
    cancelled: "#6b7280",
    // gray
    skipped: "#7c3aed"
    // violet
  };
  return statusTextColors[status] || statusTextColors.idle;
}
function createDefaultExecutionInfo() {
  return {
    status: "idle",
    executionCount: 0,
    isExecuting: false
  };
}
function updateExecutionStart(executionInfo) {
  return __spreadProps(__spreadValues({}, executionInfo), {
    status: "running",
    isExecuting: true
  });
}
function updateExecutionComplete(executionInfo, duration) {
  return __spreadProps(__spreadValues({}, executionInfo), {
    status: "completed",
    executionCount: executionInfo.executionCount + 1,
    lastExecuted: (/* @__PURE__ */ new Date()).toISOString(),
    lastExecutionDuration: duration,
    isExecuting: false,
    lastError: void 0
    // Clear any previous error
  });
}
function updateExecutionFailed(executionInfo, error2, duration) {
  return __spreadProps(__spreadValues({}, executionInfo), {
    status: "failed",
    executionCount: executionInfo.executionCount + 1,
    lastExecuted: (/* @__PURE__ */ new Date()).toISOString(),
    lastExecutionDuration: duration,
    isExecuting: false,
    lastError: error2
  });
}
function resetExecutionInfo(executionInfo) {
  return __spreadProps(__spreadValues({}, executionInfo), {
    status: "idle",
    isExecuting: false,
    lastError: void 0
  });
}
function formatExecutionDuration(duration) {
  if (!duration)
    return "N/A";
  if (duration < 1e3) {
    return `${Math.round(duration)}ms`;
  } else if (duration < 6e4) {
    return `${(duration / 1e3).toFixed(1)}s`;
  } else {
    const minutes = Math.floor(duration / 6e4);
    const seconds = Math.floor(duration % 6e4 / 1e3);
    return `${minutes}m ${seconds}s`;
  }
}
function formatLastExecuted(timestamp) {
  if (!timestamp)
    return "Never";
  const date2 = new Date(timestamp);
  const now2 = /* @__PURE__ */ new Date();
  const diffMs = now2.getTime() - date2.getTime();
  if (diffMs < 6e4) {
    return "Just now";
  } else if (diffMs < 36e5) {
    const minutes = Math.floor(diffMs / 6e4);
    return `${minutes}m ago`;
  } else if (diffMs < 864e5) {
    const hours = Math.floor(diffMs / 36e5);
    return `${hours}h ago`;
  } else {
    return date2.toLocaleDateString();
  }
}
const DEFAULT_NODE_STATUS_CONFIG = {
  position: "top-right",
  size: "md",
  showDetails: true
};
function createNodeWrapperConfig(nodeId, executionInfo, config = {}) {
  var _a3;
  return {
    nodeId,
    executionInfo,
    statusPosition: config.position || DEFAULT_NODE_STATUS_CONFIG.position,
    statusSize: config.size || DEFAULT_NODE_STATUS_CONFIG.size,
    showStatusDetails: (_a3 = config.showDetails) != null ? _a3 : DEFAULT_NODE_STATUS_CONFIG.showDetails
  };
}
function shouldShowNodeStatus(executionInfo) {
  if (!executionInfo)
    return false;
  return executionInfo.status !== "idle" || executionInfo.executionCount > 0 || executionInfo.isExecuting;
}
function getOptimalStatusPosition(nodeType) {
  switch (nodeType) {
    case "tool":
      return "top-left";
    case "note":
      return "bottom-right";
    case "simple":
    case "square":
    default:
      return "top-right";
  }
}
function getOptimalStatusSize(nodeType) {
  switch (nodeType) {
    case "tool":
      return "sm";
    case "note":
      return "sm";
    case "simple":
    case "square":
    default:
      return "md";
  }
}
const LOOPBACK_PORT_NAME = "loop_back";
function isLoopbackEdge(edge) {
  var _a3;
  const targetHandle = (_a3 = edge.targetHandle) != null ? _a3 : "";
  return targetHandle.includes(`-input-${LOOPBACK_PORT_NAME}`);
}
function isValidLoopbackCycle(cycleEdges) {
  return cycleEdges.every((edge) => isLoopbackEdge(edge));
}
class PortCompatibilityChecker {
  constructor(portConfig) {
    __publicField(this, "portConfig");
    __publicField(this, "compatibilityMap");
    this.portConfig = portConfig;
    this.compatibilityMap = /* @__PURE__ */ new Map();
    this.buildCompatibilityMap();
  }
  /**
   * Build the compatibility map from configuration rules
   */
  buildCompatibilityMap() {
    this.compatibilityMap.clear();
    for (const dataType of this.portConfig.dataTypes) {
      if (!this.compatibilityMap.has(dataType.id)) {
        this.compatibilityMap.set(dataType.id, /* @__PURE__ */ new Set());
      }
      this.compatibilityMap.get(dataType.id).add(dataType.id);
    }
    for (const rule of this.portConfig.compatibilityRules) {
      if (!this.compatibilityMap.has(rule.from)) {
        this.compatibilityMap.set(rule.from, /* @__PURE__ */ new Set());
      }
      this.compatibilityMap.get(rule.from).add(rule.to);
    }
    for (const dataType of this.portConfig.dataTypes) {
      if (dataType.aliases) {
        for (const alias of dataType.aliases) {
          const mainCompatibility = this.compatibilityMap.get(dataType.id);
          if (mainCompatibility) {
            this.compatibilityMap.set(alias, new Set(mainCompatibility));
            mainCompatibility.add(alias);
          }
        }
      }
    }
  }
  /**
   * Check if two data types are compatible for connection
   */
  areDataTypesCompatible(outputType, inputType) {
    const compatibleTypes = this.compatibilityMap.get(outputType);
    return compatibleTypes ? compatibleTypes.has(inputType) : false;
  }
  /**
   * Get all compatible target types for a source type
   */
  getCompatibleTypes(sourceType) {
    const compatibleTypes = this.compatibilityMap.get(sourceType);
    return compatibleTypes ? Array.from(compatibleTypes) : [];
  }
  /**
   * Get data type configuration by ID
   */
  getDataTypeConfig(dataTypeId) {
    return this.portConfig.dataTypes.find((dt) => {
      var _a3;
      return dt.id === dataTypeId || ((_a3 = dt.aliases) == null ? void 0 : _a3.includes(dataTypeId));
    });
  }
  /**
   * Get all enabled data types
   */
  getEnabledDataTypes() {
    return this.portConfig.dataTypes.filter((dt) => dt.enabled !== false);
  }
}
let globalCompatibilityChecker = null;
function initializePortCompatibility(portConfig) {
  globalCompatibilityChecker = new PortCompatibilityChecker(portConfig);
}
function getPortCompatibilityChecker() {
  if (!globalCompatibilityChecker) {
    throw new Error("Port compatibility checker not initialized. Call initializePortCompatibility() first.");
  }
  return globalCompatibilityChecker;
}
function getPossibleConnections(sourceNode, targetNodes, nodeTypes) {
  const sourceMetadata = nodeTypes.find((nt) => nt.id === sourceNode.data.metadata.id);
  if (!sourceMetadata)
    return [];
  const possibleConnections = [];
  const sourceOutputs = sourceMetadata.outputs;
  const checker = getPortCompatibilityChecker();
  for (const targetNode of targetNodes) {
    if (targetNode.id === sourceNode.id)
      continue;
    const targetMetadata = nodeTypes.find((nt) => nt.id === targetNode.data.metadata.id);
    if (!targetMetadata)
      continue;
    const targetInputs = targetMetadata.inputs;
    for (const sourcePort of sourceOutputs) {
      for (const targetPort of targetInputs) {
        const compatible = checker.areDataTypesCompatible(sourcePort.dataType, targetPort.dataType);
        possibleConnections.push({
          sourceNodeId: sourceNode.id,
          sourcePortId: sourcePort.id,
          sourcePort,
          targetNodeId: targetNode.id,
          targetPortId: targetPort.id,
          targetPort,
          compatible
        });
      }
    }
  }
  return possibleConnections;
}
function validateConnection(sourceNodeId, sourcePortId, targetNodeId, targetPortId, nodes, nodeTypes) {
  const sourceNode = nodes.find((n) => n.id === sourceNodeId);
  const targetNode = nodes.find((n) => n.id === targetNodeId);
  if (!sourceNode) {
    return { valid: false, error: "Source node not found" };
  }
  if (!targetNode) {
    return { valid: false, error: "Target node not found" };
  }
  if (sourceNodeId === targetNodeId) {
    return { valid: false, error: "Cannot connect node to itself" };
  }
  const sourceMetadata = nodeTypes.find((nt) => nt.id === sourceNode.data.metadata.id);
  const targetMetadata = nodeTypes.find((nt) => nt.id === targetNode.data.metadata.id);
  if (!sourceMetadata || !targetMetadata) {
    return { valid: false, error: "Node metadata not found" };
  }
  const sourcePort = sourceMetadata.outputs.find((p) => p.id === sourcePortId);
  const targetPort = targetMetadata.inputs.find((p) => p.id === targetPortId);
  if (!sourcePort) {
    return { valid: false, error: "Source port not found" };
  }
  if (!targetPort) {
    return { valid: false, error: "Target port not found" };
  }
  const checker = getPortCompatibilityChecker();
  if (!checker.areDataTypesCompatible(sourcePort.dataType, targetPort.dataType)) {
    return {
      valid: false,
      error: `Incompatible data types: ${sourcePort.dataType} cannot connect to ${targetPort.dataType}`
    };
  }
  return { valid: true };
}
function getConnectionSuggestions(nodeId, nodes, nodeTypes) {
  const node = nodes.find((n) => n.id === nodeId);
  if (!node)
    return [];
  const metadata = nodeTypes.find((nt) => nt.id === node.data.metadata.id);
  if (!metadata)
    return [];
  const suggestions = [];
  const otherNodes = nodes.filter((n) => n.id !== nodeId);
  const checker = getPortCompatibilityChecker();
  for (const otherNode of otherNodes) {
    const otherMetadata = nodeTypes.find((nt) => nt.id === otherNode.data.metadata.id);
    if (!otherMetadata)
      continue;
    for (const output of otherMetadata.outputs) {
      for (const input of metadata.inputs) {
        const compatible = checker.areDataTypesCompatible(output.dataType, input.dataType);
        suggestions.push({
          nodeId: otherNode.id,
          nodeName: otherNode.data.label,
          portId: output.id,
          portName: output.name,
          portType: "output",
          dataType: output.dataType,
          compatible
        });
      }
    }
    for (const output of metadata.outputs) {
      for (const input of otherMetadata.inputs) {
        const compatible = checker.areDataTypesCompatible(output.dataType, input.dataType);
        suggestions.push({
          nodeId: otherNode.id,
          nodeName: otherNode.data.label,
          portId: input.id,
          portName: input.name,
          portType: "input",
          dataType: input.dataType,
          compatible
        });
      }
    }
  }
  return suggestions;
}
function hasCycles(nodes, edges) {
  const visited = /* @__PURE__ */ new Set();
  const recursionStack = /* @__PURE__ */ new Set();
  function hasCycleUtil(nodeId) {
    if (recursionStack.has(nodeId))
      return true;
    if (visited.has(nodeId))
      return false;
    visited.add(nodeId);
    recursionStack.add(nodeId);
    const outgoingEdges = edges.filter((e) => e.source === nodeId);
    for (const edge of outgoingEdges) {
      if (hasCycleUtil(edge.target))
        return true;
    }
    recursionStack.delete(nodeId);
    return false;
  }
  for (const node of nodes) {
    if (!visited.has(node.id)) {
      if (hasCycleUtil(node.id))
        return true;
    }
  }
  return false;
}
function hasInvalidCycles(nodes, edges) {
  const nonLoopbackEdges = edges.filter((edge) => !isLoopbackEdge(edge));
  const visited = /* @__PURE__ */ new Set();
  const recursionStack = /* @__PURE__ */ new Set();
  function hasCycleUtil(nodeId) {
    if (recursionStack.has(nodeId))
      return true;
    if (visited.has(nodeId))
      return false;
    visited.add(nodeId);
    recursionStack.add(nodeId);
    const outgoingEdges = nonLoopbackEdges.filter((e) => e.source === nodeId);
    for (const edge of outgoingEdges) {
      if (hasCycleUtil(edge.target))
        return true;
    }
    recursionStack.delete(nodeId);
    return false;
  }
  for (const node of nodes) {
    if (!visited.has(node.id)) {
      if (hasCycleUtil(node.id))
        return true;
    }
  }
  return false;
}
function getExecutionOrder(nodes, edges) {
  const inDegree = /* @__PURE__ */ new Map();
  const graph = /* @__PURE__ */ new Map();
  for (const node of nodes) {
    inDegree.set(node.id, 0);
    graph.set(node.id, []);
  }
  for (const edge of edges) {
    const current = inDegree.get(edge.target) || 0;
    inDegree.set(edge.target, current + 1);
    const neighbors = graph.get(edge.source) || [];
    neighbors.push(edge.target);
    graph.set(edge.source, neighbors);
  }
  const queue = [];
  const result = [];
  for (const [nodeId, degree] of inDegree) {
    if (degree === 0) {
      queue.push(nodeId);
    }
  }
  while (queue.length > 0) {
    const nodeId = queue.shift();
    result.push(nodeId);
    const neighbors = graph.get(nodeId) || [];
    for (const neighbor of neighbors) {
      const degree = inDegree.get(neighbor) - 1;
      inDegree.set(neighbor, degree);
      if (degree === 0) {
        queue.push(neighbor);
      }
    }
  }
  return result;
}
const CATEGORY_COLOR_TOKENS = {
  triggers: "var(--color-ref-cyan-500)",
  inputs: "var(--color-ref-emerald-500)",
  outputs: "var(--color-ref-blue-600)",
  prompts: "var(--color-ref-amber-500)",
  models: "var(--color-ref-indigo-500)",
  processing: "var(--color-ref-teal-500)",
  logic: "var(--color-ref-purple-600)",
  data: "var(--color-ref-orange-500)",
  helpers: "var(--color-ref-slate-500)",
  tools: "var(--color-ref-amber-500)",
  "vector stores": "var(--color-ref-emerald-500)",
  embeddings: "var(--color-ref-indigo-500)",
  memories: "var(--color-ref-blue-600)",
  agents: "var(--color-ref-teal-500)",
  ai: "var(--color-ref-purple-500)",
  bundles: "var(--color-ref-slate-500)"
};
const DEFAULT_DATA_TYPE_COLORS = {
  string: "var(--color-ref-emerald-500)",
  text: "var(--color-ref-emerald-500)",
  number: "var(--color-ref-blue-600)",
  integer: "var(--color-ref-blue-600)",
  float: "var(--color-ref-blue-600)",
  boolean: "var(--color-ref-purple-600)",
  array: "var(--color-ref-amber-500)",
  list: "var(--color-ref-amber-500)",
  object: "var(--color-ref-orange-500)",
  json: "var(--color-ref-orange-500)",
  mixed: "var(--color-ref-orange-500)",
  file: "var(--color-ref-red-500)",
  document: "var(--color-ref-red-500)",
  image: "var(--color-ref-pink-500)",
  picture: "var(--color-ref-pink-500)",
  audio: "var(--color-ref-indigo-500)",
  sound: "var(--color-ref-indigo-500)",
  video: "var(--color-ref-teal-500)",
  movie: "var(--color-ref-teal-500)",
  url: "var(--color-ref-cyan-500)",
  email: "var(--color-ref-cyan-500)",
  date: "var(--color-ref-lime-500)",
  datetime: "var(--color-ref-lime-500)",
  time: "var(--color-ref-lime-500)",
  tool: "var(--color-ref-amber-500)",
  trigger: "var(--color-ref-gray-950)",
  branch: "var(--color-ref-purple-500)"
};
function getCategoryColorToken(category) {
  return CATEGORY_COLOR_TOKENS[category] || "var(--color-ref-slate-500)";
}
function getDataTypeColorToken(dataType) {
  try {
    const checker = getPortCompatibilityChecker();
    const config = checker.getDataTypeConfig(dataType);
    if (config == null ? void 0 : config.color) {
      return config.color;
    }
  } catch (e) {
  }
  return DEFAULT_DATA_TYPE_COLORS[dataType.toLowerCase()] || "var(--color-ref-slate-500)";
}
function getDataTypeConfig(dataType) {
  try {
    const checker = getPortCompatibilityChecker();
    return checker.getDataTypeConfig(dataType);
  } catch (error2) {
    console.warn("Port compatibility checker not initialized:", error2);
    return void 0;
  }
}
function getAvailableDataTypes() {
  try {
    const checker = getPortCompatibilityChecker();
    return checker.getEnabledDataTypes();
  } catch (error2) {
    console.warn("Port compatibility checker not initialized:", error2);
    return [];
  }
}
const DEFAULT_COLORS = {
  background: "flowdrop-color--base-light",
  accent: "flowdrop-color--neutral",
  text: "flowdrop-color--base-text",
  border: "flowdrop-color--base-border"
};
function getCategoryColors(category) {
  return CATEGORY_COLOR_TOKENS[category] || "var(--color-ref-slate-500)";
}
function getCategoryBackground(category) {
  return getCategoryColors(category);
}
function getCategoryAccent(category) {
  return getCategoryColors(category);
}
function getCategoryText(category) {
  return getCategoryColors(category);
}
function getCategoryBorder(category) {
  return getCategoryColors(category);
}
function getNodeColors(category, isError = false, isProcessing = false, isSelected = false) {
  const baseColor = getCategoryColors(category);
  if (isError) {
    return {
      background: "var(--color-ref-red-50)",
      accent: "var(--color-ref-red-500)",
      text: "var(--color-ref-red-900)",
      border: "var(--color-ref-red-200)"
    };
  }
  if (isProcessing) {
    return {
      background: "var(--color-ref-blue-50)",
      accent: "var(--color-ref-blue-500)",
      text: "var(--color-ref-blue-900)",
      border: "var(--color-ref-blue-200)"
    };
  }
  if (isSelected) {
    return {
      background: "var(--color-ref-indigo-50)",
      accent: "var(--color-ref-indigo-500)",
      text: "var(--color-ref-indigo-900)",
      border: "var(--color-ref-indigo-200)"
    };
  }
  return {
    background: baseColor,
    accent: baseColor,
    text: "var(--color-ref-slate-900)",
    border: baseColor
  };
}
function getNodeBackground(category, isError = false, isProcessing = false, isSelected = false) {
  return getNodeColors(category, isError, isProcessing, isSelected).background;
}
function getNodeAccent(category, isError = false, isProcessing = false, isSelected = false) {
  return getNodeColors(category, isError, isProcessing, isSelected).accent;
}
function getNodeText(category, isError = false, isProcessing = false, isSelected = false) {
  return getNodeColors(category, isError, isProcessing, isSelected).text;
}
function getNodeBorder(category, isError = false, isProcessing = false, isSelected = false) {
  return getNodeColors(category, isError, isProcessing, isSelected).border;
}
function getDataTypeColor(dataType) {
  return getDataTypeColorToken(dataType);
}
function parseDataTypeDisplay(dataType) {
  const isArray = dataType.endsWith("[]");
  if (isArray) {
    const elementType = dataType.slice(0, -2);
    const config = getDataTypeConfig(dataType);
    return {
      baseType: dataType,
      isArray: true,
      displayName: (config == null ? void 0 : config.name) || `${elementType}[]`,
      elementType
    };
  } else {
    const config = getDataTypeConfig(dataType);
    return {
      baseType: dataType,
      isArray: false,
      displayName: (config == null ? void 0 : config.name) || dataType
    };
  }
}
function getDataTypeDisplayText(dataType) {
  const parsed = parseDataTypeDisplay(dataType);
  return parsed.displayName;
}
function isArrayDataType(dataType) {
  return dataType.endsWith("[]") || dataType === "array" || dataType === "list";
}
function getArrayElementType(arrayDataType) {
  if (arrayDataType.endsWith("[]")) {
    return arrayDataType.slice(0, -2);
  }
  return null;
}
function hexToRgb(hex2) {
  const cleanHex = hex2.replace(/^#/, "");
  if (!/^[0-9A-Fa-f]{6}$/.test(cleanHex)) {
    return null;
  }
  const r2 = parseInt(cleanHex.substring(0, 2), 16);
  const g = parseInt(cleanHex.substring(2, 4), 16);
  const b2 = parseInt(cleanHex.substring(4, 6), 16);
  return { r: r2, g, b: b2 };
}
function rgbToHex(r2, g, b2) {
  const toHex = (value) => {
    const clamped = Math.max(0, Math.min(255, Math.round(value)));
    return clamped.toString(16).padStart(2, "0");
  };
  return `#${toHex(r2)}${toHex(g)}${toHex(b2)}`;
}
function getLightTint(hex2) {
  const rgb2 = hexToRgb(hex2);
  if (!rgb2) {
    return "#fffbeb";
  }
  const mixRatio = 0.95;
  const r2 = rgb2.r + (255 - rgb2.r) * mixRatio;
  const g = rgb2.g + (255 - rgb2.g) * mixRatio;
  const b2 = rgb2.b + (255 - rgb2.b) * mixRatio;
  return rgbToHex(r2, g, b2);
}
function getBorderTint(hex2) {
  const rgb2 = hexToRgb(hex2);
  if (!rgb2) {
    return "#fcd34d";
  }
  const mixRatio = 0.6;
  const r2 = rgb2.r + (255 - rgb2.r) * mixRatio;
  const g = rgb2.g + (255 - rgb2.g) * mixRatio;
  const b2 = rgb2.b + (255 - rgb2.b) * mixRatio;
  return rgbToHex(r2, g, b2);
}
function getColorVariants(baseColor) {
  return {
    base: baseColor,
    light: getLightTint(baseColor),
    border: getBorderTint(baseColor)
  };
}
const DEFAULT_ICONS = {
  // Node fallback icons
  NODE: "mdi:cube",
  CATEGORY: "mdi:folder",
  // UI action icons
  ADD: "mdi:plus",
  REMOVE: "mdi:minus",
  EDIT: "mdi:pencil",
  SAVE: "mdi:content-save",
  LOAD: "mdi:folder-open",
  EXPORT: "mdi:download",
  IMPORT: "mdi:upload",
  SEARCH: "mdi:magnify",
  CLOSE: "mdi:close",
  SETTINGS: "mdi:cog",
  HELP: "mdi:help-circle",
  // Status icons
  SUCCESS: "mdi:check-circle",
  ERROR: "mdi:alert-circle",
  WARNING: "mdi:alert",
  INFO: "mdi:information",
  LOADING: "mdi:loading",
  // Navigation icons
  HOME: "mdi:home",
  BACK: "mdi:arrow-left",
  FORWARD: "mdi:arrow-right",
  UP: "mdi:arrow-up",
  DOWN: "mdi:arrow-down",
  // Workflow icons
  WORKFLOW: "mdi:graph",
  NODE_ADD: "mdi:plus-circle",
  NODE_DELETE: "mdi:minus-circle",
  CONNECTION: "mdi:connection",
  // Data icons
  DATA: "mdi:database",
  FILE: "mdi:file",
  TEXT: "mdi:text",
  JSON: "mdi:code-json",
  // Model and processing icons
  MODEL: "mdi:chip",
  BRAIN: "mdi:brain",
  VECTOR: "mdi:vector-point",
  ROBOT: "mdi:robot",
  // Tool icons
  TOOL: "mdi:wrench",
  CALCULATOR: "mdi:calculator",
  CLOCK: "mdi:clock",
  // Communication icons
  CHAT: "mdi:chat",
  MESSAGE: "mdi:message",
  EMAIL: "mdi:email",
  WEBHOOK: "mdi:webhook",
  // Storage icons
  STORAGE: "mdi:database",
  MEMORY: "mdi:memory",
  CACHE: "mdi:cached",
  // Processing icons
  PROCESS: "mdi:cog",
  FILTER: "mdi:filter",
  SORT: "mdi:sort",
  TRANSFORM: "mdi:transform",
  // Logic icons
  LOGIC: "mdi:git-branch",
  CONDITION: "mdi:source-fork",
  LOOP: "mdi:loop",
  // Integration icons
  API: "mdi:api",
  LINK: "mdi:link",
  PLUGIN: "mdi:puzzle",
  BUNDLE: "mdi:package-variant"
};
const CATEGORY_ICONS = {
  triggers: "mdi:lightning-bolt",
  inputs: "mdi:arrow-down-circle",
  outputs: "mdi:arrow-up-circle",
  prompts: "mdi:message-text",
  models: "mdi:robot",
  processing: "mdi:cog",
  logic: "mdi:source-branch",
  data: "mdi:database",
  helpers: "mdi:help-circle",
  tools: "mdi:wrench",
  "vector stores": "mdi:vector-square",
  embeddings: "mdi:vector-polygon",
  memories: "mdi:brain",
  agents: "mdi:account-cog",
  ai: "mdi:shimmer",
  bundles: "mdi:package-variant"
};
function getNodeIcon(nodeIcon, category) {
  if (nodeIcon) {
    return nodeIcon;
  }
  if (category && CATEGORY_ICONS[category]) {
    return CATEGORY_ICONS[category];
  }
  return DEFAULT_ICONS.NODE;
}
function getCategoryIcon(category) {
  return CATEGORY_ICONS[category] || DEFAULT_ICONS.CATEGORY;
}
function getDefaultIcon(key2) {
  return DEFAULT_ICONS[key2];
}
function isValidIcon(icon) {
  return /^[a-z-]+:[a-z-]+$/.test(icon);
}
function getValidIcon(icon, fallback2 = DEFAULT_ICONS.NODE) {
  return isValidIcon(icon) ? icon : fallback2;
}
const defaultEndpointConfig = {
  baseUrl: "/api/flowdrop",
  endpoints: {
    nodes: {
      list: "/nodes",
      get: "/nodes/{id}",
      byCategory: "/nodes?category={category}",
      metadata: "/nodes/{id}/metadata"
    },
    portConfig: "/port-config",
    workflows: {
      list: "/workflows",
      get: "/workflows/{id}",
      create: "/workflows",
      update: "/workflows/{id}",
      delete: "/workflows/{id}",
      validate: "/workflows/validate",
      export: "/workflows/{id}/export",
      import: "/workflows/import"
    },
    executions: {
      execute: "/workflows/{id}/execute",
      status: "/executions/{id}",
      cancel: "/executions/{id}/cancel",
      logs: "/executions/{id}/logs",
      history: "/executions"
    },
    pipelines: {
      list: "/workflow/{workflow_id}/pipelines",
      get: "/pipeline/{id}",
      create: "/pipeline",
      update: "/pipeline/{id}",
      delete: "/pipeline/{id}",
      status: "/pipeline/{id}/status",
      logs: "/pipeline/{id}/logs",
      execute: "/pipeline/{id}/execute",
      stop: "/pipeline/{id}/stop"
    },
    playground: {
      listSessions: "/workflows/{id}/playground/sessions",
      createSession: "/workflows/{id}/playground/sessions",
      getSession: "/playground/sessions/{sessionId}",
      deleteSession: "/playground/sessions/{sessionId}",
      getMessages: "/playground/sessions/{sessionId}/messages",
      sendMessage: "/playground/sessions/{sessionId}/messages",
      stopExecution: "/playground/sessions/{sessionId}/stop"
    },
    interrupts: {
      get: "/interrupts/{interruptId}",
      resolve: "/interrupts/{interruptId}",
      cancel: "/interrupts/{interruptId}/cancel",
      listBySession: "/playground/sessions/{sessionId}/interrupts",
      listByPipeline: "/pipelines/{pipelineId}/interrupts"
    },
    templates: {
      list: "/templates",
      get: "/templates/{id}",
      create: "/templates",
      update: "/templates/{id}",
      delete: "/templates/{id}"
    },
    users: {
      profile: "/users/profile",
      preferences: "/users/preferences"
    },
    system: {
      health: "/system/health",
      config: "/system/config",
      version: "/system/version"
    }
  },
  timeout: 3e4,
  retry: {
    enabled: true,
    maxAttempts: 3,
    delay: 1e3,
    backoff: "exponential"
  }
};
function createEndpointConfig(baseUrl, overrides2) {
  const config = __spreadValues(__spreadProps(__spreadValues({}, defaultEndpointConfig), {
    baseUrl: baseUrl.replace(/\/$/, "")
  }), overrides2);
  return config;
}
function buildEndpointUrl(config, endpointPath, params) {
  let url = endpointPath;
  if (params) {
    Object.entries(params).forEach(([key2, value]) => {
      url = url.replace(`{${key2}}`, encodeURIComponent(value));
    });
  }
  if (!url.startsWith("http") && !url.startsWith("//")) {
    url = `${config.baseUrl}${url.startsWith("/") ? url : `/${url}`}`;
  }
  return url;
}
function getEndpointMethod(config, endpointKey) {
  var _a3;
  return ((_a3 = config.methods) == null ? void 0 : _a3[endpointKey]) || "GET";
}
function getEndpointHeaders(config, endpointKey) {
  var _a3, _b2, _c2, _d2;
  const baseHeaders = {
    "Content-Type": "application/json"
  };
  if (((_a3 = config.auth) == null ? void 0 : _a3.type) === "bearer" && config.auth.token) {
    baseHeaders["Authorization"] = `Bearer ${config.auth.token}`;
  } else if (((_b2 = config.auth) == null ? void 0 : _b2.type) === "api_key" && config.auth.apiKey) {
    baseHeaders["X-API-Key"] = config.auth.apiKey;
  } else if (((_c2 = config.auth) == null ? void 0 : _c2.type) === "custom" && config.auth.headers) {
    Object.assign(baseHeaders, config.auth.headers);
  }
  const endpointHeaders = (_d2 = config.headers) == null ? void 0 : _d2[endpointKey];
  if (endpointHeaders) {
    Object.assign(baseHeaders, endpointHeaders);
  }
  return baseHeaders;
}
const endpoints = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  buildEndpointUrl,
  createEndpointConfig,
  defaultEndpointConfig,
  getEndpointHeaders,
  getEndpointMethod
}, Symbol.toStringTag, { value: "Module" }));
function createDefaultFeatures() {
  return {
    dragAndDrop: true,
    nodeEditing: true,
    execution: true,
    saveWorkflow: true,
    loadWorkflow: true,
    undoRedo: true,
    nodeSearch: true,
    nodeCategories: true,
    nodeValidation: true,
    collaboration: false,
    templates: false,
    importExport: false
  };
}
function createDefaultUIConfig() {
  return {
    showSidebar: true,
    showToolbar: true,
    showMinimap: true,
    showGrid: true,
    gridSize: 20,
    nodeSpacing: 100,
    canvasPadding: 50,
    navbarHeight: 60,
    // Default navbar height in pixels (current demo height)
    zoom: {
      min: 0.1,
      max: 2,
      default: 1
    },
    colors: {
      primary: "#3b82f6",
      secondary: "#64748b",
      accent: "#f59e0b",
      background: "#ffffff",
      text: "#1f2937"
    },
    cssClasses: {}
  };
}
function createDefaultAPIConfig() {
  return {
    endpoints: createEndpointConfig("/api/flowdrop"),
    timeout: 3e4,
    retry: {
      enabled: true,
      maxAttempts: 3,
      delay: 1e3
    },
    auth: {
      type: "none"
    },
    headers: {
      "Content-Type": "application/json"
    }
  };
}
function createDefaultExecutionConfig() {
  return {
    realTimeUpdates: true,
    timeout: 300,
    maxConcurrent: 5,
    showProgress: true,
    autoSaveState: true,
    caching: {
      enabled: true,
      ttl: 3600
    }
  };
}
function createDefaultStorageConfig() {
  return {
    type: "api",
    autoSaveInterval: 5e3,
    maxUndoSteps: 50,
    keyPrefix: "flowdrop_"
  };
}
function createDefaultConfig(endpointConfig2) {
  return {
    theme: "auto",
    features: createDefaultFeatures(),
    ui: createDefaultUIConfig(),
    api: __spreadProps(__spreadValues({}, createDefaultAPIConfig()), {
      endpoints: endpointConfig2 || createEndpointConfig("/api/flowdrop")
    }),
    ports: {
      dataTypes: [],
      compatibilityRules: [],
      defaultDataType: "mixed"
    },
    execution: createDefaultExecutionConfig(),
    storage: createDefaultStorageConfig()
  };
}
function mergeConfig(userConfig, defaultConfig2) {
  var _a3, _b2, _c2, _d2, _e3, _f2, _g, _h;
  return __spreadProps(__spreadValues(__spreadValues({}, defaultConfig2), userConfig), {
    features: __spreadValues(__spreadValues({}, defaultConfig2.features), userConfig.features),
    ui: __spreadProps(__spreadValues(__spreadValues({}, defaultConfig2.ui), userConfig.ui), {
      zoom: __spreadValues(__spreadValues({}, defaultConfig2.ui.zoom), (_a3 = userConfig.ui) == null ? void 0 : _a3.zoom),
      colors: __spreadValues(__spreadValues({}, defaultConfig2.ui.colors), (_b2 = userConfig.ui) == null ? void 0 : _b2.colors),
      cssClasses: __spreadValues(__spreadValues({}, defaultConfig2.ui.cssClasses), (_c2 = userConfig.ui) == null ? void 0 : _c2.cssClasses)
    }),
    api: __spreadProps(__spreadValues(__spreadValues({}, defaultConfig2.api), userConfig.api), {
      retry: __spreadValues(__spreadValues({}, defaultConfig2.api.retry), (_d2 = userConfig.api) == null ? void 0 : _d2.retry),
      auth: __spreadValues(__spreadValues({}, defaultConfig2.api.auth), (_e3 = userConfig.api) == null ? void 0 : _e3.auth),
      headers: __spreadValues(__spreadValues({}, defaultConfig2.api.headers), (_f2 = userConfig.api) == null ? void 0 : _f2.headers),
      endpoints: __spreadValues(__spreadValues({}, defaultConfig2.api.endpoints), (_g = userConfig.api) == null ? void 0 : _g.endpoints)
    }),
    execution: __spreadProps(__spreadValues(__spreadValues({}, defaultConfig2.execution), userConfig.execution), {
      caching: __spreadValues(__spreadValues({}, defaultConfig2.execution.caching), (_h = userConfig.execution) == null ? void 0 : _h.caching)
    }),
    storage: __spreadValues(__spreadValues({}, defaultConfig2.storage), userConfig.storage)
  });
}
function validateConfig(config) {
  const errors = [];
  if (!config.features) {
    errors.push("features configuration is required");
  }
  if (!config.ui) {
    errors.push("ui configuration is required");
  }
  if (!config.api) {
    errors.push("api configuration is required");
  }
  if (!config.execution) {
    errors.push("execution configuration is required");
  }
  if (!config.storage) {
    errors.push("storage configuration is required");
  }
  if (config.api.timeout <= 0) {
    errors.push("API timeout must be greater than 0");
  }
  if (config.api.retry.maxAttempts < 0) {
    errors.push("Retry max attempts must be non-negative");
  }
  if (config.execution.timeout <= 0) {
    errors.push("Execution timeout must be greater than 0");
  }
  if (config.execution.maxConcurrent <= 0) {
    errors.push("Max concurrent executions must be greater than 0");
  }
  if (config.ui.gridSize <= 0) {
    errors.push("Grid size must be greater than 0");
  }
  if (config.ui.nodeSpacing <= 0) {
    errors.push("Node spacing must be greater than 0");
  }
  if (config.ui.zoom.min >= config.ui.zoom.max) {
    errors.push("Zoom min must be less than zoom max");
  }
  return errors;
}
class NodeComponentRegistry {
  constructor() {
    /** Map of type -> registration */
    __publicField(this, "components", /* @__PURE__ */ new Map());
    /** Default type to use when requested type is not found */
    __publicField(this, "defaultType", "workflowNode");
    /** Listeners for registry changes */
    __publicField(this, "listeners", /* @__PURE__ */ new Set());
  }
  /**
   * Register a node component type.
   *
   * @param registration - The component registration details
   * @param overwrite - If true, allows overwriting existing registrations
   * @throws Error if type already registered and overwrite is false
   *
   * @example
   * ```typescript
   * nodeComponentRegistry.register({
   *     type: "fancy",
   *     displayName: "Fancy Node",
   *     component: FancyNode,
   *     icon: "mdi:sparkles"
   * });
   * ```
   */
  register(registration, overwrite = false) {
    if (this.components.has(registration.type) && !overwrite) {
      throw new Error(`Node type "${registration.type}" is already registered. Use overwrite: true to replace it, or use a namespaced type like "mylib:${registration.type}".`);
    }
    this.components.set(registration.type, registration);
    this.notifyListeners();
  }
  /**
   * Register multiple components at once.
   * Useful for libraries registering multiple node types.
   *
   * @param registrations - Array of registrations to add
   * @param overwrite - If true, allows overwriting existing registrations
   */
  registerAll(registrations, overwrite = false) {
    for (const registration of registrations) {
      this.register(registration, overwrite);
    }
  }
  /**
   * Unregister a node component type.
   *
   * @param type - The type identifier to remove
   * @returns true if the type was found and removed, false otherwise
   */
  unregister(type) {
    const result = this.components.delete(type);
    if (result) {
      this.notifyListeners();
    }
    return result;
  }
  /**
   * Get a registration by type.
   *
   * @param type - The type identifier to look up
   * @returns The registration if found, undefined otherwise
   */
  get(type) {
    return this.components.get(type);
  }
  /**
   * Get the component for a type, with fallback to default.
   *
   * @param type - The type identifier to look up
   * @returns The component if found, or the default component
   */
  getComponent(type) {
    var _a3;
    const registration = (_a3 = this.components.get(type)) != null ? _a3 : this.components.get(this.defaultType);
    return registration == null ? void 0 : registration.component;
  }
  /**
   * Check if a type is registered.
   *
   * @param type - The type identifier to check
   * @returns true if the type is registered
   */
  has(type) {
    return this.components.has(type);
  }
  /**
   * Get all registered type identifiers.
   *
   * @returns Array of registered type strings
   */
  getTypes() {
    return Array.from(this.components.keys());
  }
  /**
   * Get all registrations.
   *
   * @returns Array of all registered node component metadata
   */
  getAll() {
    return Array.from(this.components.values());
  }
  /**
   * Get registrations filtered by criteria.
   *
   * @param filter - Filter options
   * @returns Filtered array of registrations
   *
   * @example
   * ```typescript
   * // Get all visual nodes
   * const visualNodes = nodeComponentRegistry.filter({ category: "visual" });
   *
   * // Get nodes from a specific library
   * const libNodes = nodeComponentRegistry.filter({ source: "mylib" });
   * ```
   */
  filter(filter2) {
    return this.getAll().filter((reg) => {
      if (filter2.category && reg.category !== filter2.category) {
        return false;
      }
      if (filter2.source && reg.source !== filter2.source) {
        return false;
      }
      if (filter2.predicate && !filter2.predicate(reg)) {
        return false;
      }
      return true;
    });
  }
  /**
   * Get registrations filtered by category.
   *
   * @param category - The category to filter by
   * @returns Array of registrations in that category
   */
  getByCategory(category) {
    return this.filter({ category });
  }
  /**
   * Get registrations filtered by source.
   *
   * @param source - The source identifier to filter by (e.g., "flowdrop", "mylib")
   * @returns Array of registrations from that source
   */
  getBySource(source2) {
    return this.filter({ source: source2 });
  }
  /**
   * Set the default fallback type.
   *
   * @param type - The type to use as default when requested type is not found
   * @throws Error if the type is not registered
   */
  setDefaultType(type) {
    if (!this.components.has(type)) {
      throw new Error(`Cannot set default to unregistered type: ${type}`);
    }
    this.defaultType = type;
  }
  /**
   * Get the current default type.
   *
   * @returns The default type identifier
   */
  getDefaultType() {
    return this.defaultType;
  }
  /**
   * Subscribe to registry changes.
   * Called whenever components are registered or unregistered.
   *
   * @param listener - Callback to invoke on changes
   * @returns Unsubscribe function
   */
  subscribe(listener) {
    this.listeners.add(listener);
    return () => this.listeners.delete(listener);
  }
  /**
   * Notify all listeners of a change.
   */
  notifyListeners() {
    for (const listener of this.listeners) {
      listener();
    }
  }
  /**
   * Get enum options for config forms.
   * Returns arrays suitable for JSON Schema enum/enumNames.
   *
   * @param filterFn - Optional filter function to limit which types are included
   * @returns Object with enum (type values) and enumNames (display names)
   *
   * @example
   * ```typescript
   * const { enum: types, enumNames } = nodeComponentRegistry.getEnumOptions();
   * // Use in configSchema: { type: "string", enum: types, enumNames }
   * ```
   */
  getEnumOptions(filterFn) {
    const registrations = filterFn ? this.getAll().filter(filterFn) : this.getAll();
    return {
      enum: registrations.map((r2) => r2.type),
      enumNames: registrations.map((r2) => r2.displayName)
    };
  }
  /**
   * Get the status position for a node type.
   *
   * @param type - The node type
   * @returns The status position, or default "top-right"
   */
  getStatusPosition(type) {
    var _a3, _b2;
    return (_b2 = (_a3 = this.components.get(type)) == null ? void 0 : _a3.statusPosition) != null ? _b2 : "top-right";
  }
  /**
   * Get the status size for a node type.
   *
   * @param type - The node type
   * @returns The status size, or default "md"
   */
  getStatusSize(type) {
    var _a3, _b2;
    return (_b2 = (_a3 = this.components.get(type)) == null ? void 0 : _a3.statusSize) != null ? _b2 : "md";
  }
  /**
   * Clear all registrations.
   * Primarily useful for testing.
   */
  clear() {
    this.components.clear();
    this.notifyListeners();
  }
  /**
   * Get the count of registered components.
   *
   * @returns Number of registered node types
   */
  get size() {
    return this.components.size;
  }
}
const nodeComponentRegistry = new NodeComponentRegistry();
function createNamespacedType(namespace2, type) {
  return `${namespace2}:${type}`;
}
function parseNamespacedType(namespacedType) {
  const colonIndex = namespacedType.indexOf(":");
  if (colonIndex === -1) {
    return null;
  }
  return {
    namespace: namespacedType.slice(0, colonIndex),
    type: namespacedType.slice(colonIndex + 1)
  };
}
const PUBLIC_VERSION = "5";
if (typeof window !== "undefined") {
  ((_c = (_b = (_a2 = window.__svelte) != null ? _a2 : window.__svelte = {}).v) != null ? _c : _b.v = /* @__PURE__ */ new Set()).add(PUBLIC_VERSION);
}
const EACH_ITEM_REACTIVE = 1;
const EACH_INDEX_REACTIVE = 1 << 1;
const EACH_IS_CONTROLLED = 1 << 2;
const EACH_IS_ANIMATED = 1 << 3;
const EACH_ITEM_IMMUTABLE = 1 << 4;
const PROPS_IS_IMMUTABLE = 1;
const PROPS_IS_UPDATED = 1 << 2;
const PROPS_IS_BINDABLE = 1 << 3;
const PROPS_IS_LAZY_INITIAL = 1 << 4;
const TRANSITION_GLOBAL = 1 << 2;
const TEMPLATE_FRAGMENT = 1;
const TEMPLATE_USE_IMPORT_NODE = 1 << 1;
const UNINITIALIZED = Symbol();
const FILENAME = Symbol("filename");
const NAMESPACE_HTML = "http://www.w3.org/1999/xhtml";
const ATTACHMENT_KEY = "@attach";
const node_env = (_e2 = (_d = globalThis.process) == null ? void 0 : _d.env) == null ? void 0 : _e2.NODE_ENV;
const DEV = node_env && !node_env.toLowerCase().startsWith("prod");
var is_array = Array.isArray;
var index_of = Array.prototype.indexOf;
var array_from = Array.from;
var define_property = Object.defineProperty;
var get_descriptor = Object.getOwnPropertyDescriptor;
var get_descriptors = Object.getOwnPropertyDescriptors;
var object_prototype = Object.prototype;
var array_prototype = Array.prototype;
var get_prototype_of = Object.getPrototypeOf;
var is_extensible = Object.isExtensible;
function is_function(thing) {
  return typeof thing === "function";
}
const noop$1 = () => {
};
function run_all(arr) {
  for (var i = 0; i < arr.length; i++) {
    arr[i]();
  }
}
function deferred() {
  var resolve;
  var reject;
  var promise = new Promise((res, rej) => {
    resolve = res;
    reject = rej;
  });
  return { promise, resolve, reject };
}
function fallback(value, fallback2, lazy = false) {
  return value === void 0 ? lazy ? (
    /** @type {() => V} */
    fallback2()
  ) : (
    /** @type {V} */
    fallback2
  ) : value;
}
function to_array(value, n) {
  if (Array.isArray(value)) {
    return value;
  }
  if (n === void 0 || !(Symbol.iterator in value)) {
    return Array.from(value);
  }
  const array2 = [];
  for (const element of value) {
    array2.push(element);
    if (array2.length === n) break;
  }
  return array2;
}
const DERIVED = 1 << 1;
const EFFECT = 1 << 2;
const RENDER_EFFECT = 1 << 3;
const BLOCK_EFFECT = 1 << 4;
const BRANCH_EFFECT = 1 << 5;
const ROOT_EFFECT = 1 << 6;
const BOUNDARY_EFFECT = 1 << 7;
const CLEAN = 1 << 10;
const DIRTY = 1 << 11;
const MAYBE_DIRTY = 1 << 12;
const INERT = 1 << 13;
const DESTROYED = 1 << 14;
const EFFECT_RAN = 1 << 15;
const EFFECT_TRANSPARENT = 1 << 16;
const INSPECT_EFFECT = 1 << 17;
const HEAD_EFFECT = 1 << 18;
const EFFECT_PRESERVED = 1 << 19;
const USER_EFFECT = 1 << 20;
const UNOWNED = 1 << 8;
const DISCONNECTED = 1 << 9;
const WAS_MARKED = 1 << 15;
const REACTION_IS_UPDATING = 1 << 21;
const ASYNC = 1 << 22;
const ERROR_VALUE = 1 << 23;
const STATE_SYMBOL = Symbol("$state");
const LEGACY_PROPS = Symbol("legacy props");
const LOADING_ATTR_SYMBOL = Symbol("");
const PROXY_PATH_SYMBOL = Symbol("proxy path");
const STALE_REACTION = new class StaleReactionError extends Error {
  constructor() {
    super(...arguments);
    __publicField(this, "name", "StaleReactionError");
    __publicField(this, "message", "The reaction that called `getAbortSignal()` was re-run or destroyed");
  }
}();
function lifecycle_outside_component(name2) {
  if (DEV) {
    const error2 = new Error(`lifecycle_outside_component
\`${name2}(...)\` can only be used during component initialisation
https://svelte.dev/e/lifecycle_outside_component`);
    error2.name = "Svelte error";
    throw error2;
  } else {
    throw new Error(`https://svelte.dev/e/lifecycle_outside_component`);
  }
}
function async_derived_orphan() {
  if (DEV) {
    const error2 = new Error(`async_derived_orphan
Cannot create a \`$derived(...)\` with an \`await\` expression outside of an effect tree
https://svelte.dev/e/async_derived_orphan`);
    error2.name = "Svelte error";
    throw error2;
  } else {
    throw new Error(`https://svelte.dev/e/async_derived_orphan`);
  }
}
function bind_invalid_checkbox_value() {
  if (DEV) {
    const error2 = new Error(`bind_invalid_checkbox_value
Using \`bind:value\` together with a checkbox input is not allowed. Use \`bind:checked\` instead
https://svelte.dev/e/bind_invalid_checkbox_value`);
    error2.name = "Svelte error";
    throw error2;
  } else {
    throw new Error(`https://svelte.dev/e/bind_invalid_checkbox_value`);
  }
}
function derived_references_self() {
  if (DEV) {
    const error2 = new Error(`derived_references_self
A derived value cannot reference itself recursively
https://svelte.dev/e/derived_references_self`);
    error2.name = "Svelte error";
    throw error2;
  } else {
    throw new Error(`https://svelte.dev/e/derived_references_self`);
  }
}
function effect_in_teardown(rune) {
  if (DEV) {
    const error2 = new Error(`effect_in_teardown
\`${rune}\` cannot be used inside an effect cleanup function
https://svelte.dev/e/effect_in_teardown`);
    error2.name = "Svelte error";
    throw error2;
  } else {
    throw new Error(`https://svelte.dev/e/effect_in_teardown`);
  }
}
function effect_in_unowned_derived() {
  if (DEV) {
    const error2 = new Error(`effect_in_unowned_derived
Effect cannot be created inside a \`$derived\` value that was not itself created inside an effect
https://svelte.dev/e/effect_in_unowned_derived`);
    error2.name = "Svelte error";
    throw error2;
  } else {
    throw new Error(`https://svelte.dev/e/effect_in_unowned_derived`);
  }
}
function effect_orphan(rune) {
  if (DEV) {
    const error2 = new Error(`effect_orphan
\`${rune}\` can only be used inside an effect (e.g. during component initialisation)
https://svelte.dev/e/effect_orphan`);
    error2.name = "Svelte error";
    throw error2;
  } else {
    throw new Error(`https://svelte.dev/e/effect_orphan`);
  }
}
function effect_update_depth_exceeded() {
  if (DEV) {
    const error2 = new Error(`effect_update_depth_exceeded
Maximum update depth exceeded. This typically indicates that an effect reads and writes the same piece of state
https://svelte.dev/e/effect_update_depth_exceeded`);
    error2.name = "Svelte error";
    throw error2;
  } else {
    throw new Error(`https://svelte.dev/e/effect_update_depth_exceeded`);
  }
}
function invalid_snippet() {
  if (DEV) {
    const error2 = new Error(`invalid_snippet
Could not \`{@render}\` snippet due to the expression being \`null\` or \`undefined\`. Consider using optional chaining \`{@render snippet?.()}\`
https://svelte.dev/e/invalid_snippet`);
    error2.name = "Svelte error";
    throw error2;
  } else {
    throw new Error(`https://svelte.dev/e/invalid_snippet`);
  }
}
function props_invalid_value(key2) {
  if (DEV) {
    const error2 = new Error(`props_invalid_value
Cannot do \`bind:${key2}={undefined}\` when \`${key2}\` has a fallback value
https://svelte.dev/e/props_invalid_value`);
    error2.name = "Svelte error";
    throw error2;
  } else {
    throw new Error(`https://svelte.dev/e/props_invalid_value`);
  }
}
function props_rest_readonly(property) {
  if (DEV) {
    const error2 = new Error(`props_rest_readonly
Rest element properties of \`$props()\` such as \`${property}\` are readonly
https://svelte.dev/e/props_rest_readonly`);
    error2.name = "Svelte error";
    throw error2;
  } else {
    throw new Error(`https://svelte.dev/e/props_rest_readonly`);
  }
}
function rune_outside_svelte(rune) {
  if (DEV) {
    const error2 = new Error(`rune_outside_svelte
The \`${rune}\` rune is only available inside \`.svelte\` and \`.svelte.js/ts\` files
https://svelte.dev/e/rune_outside_svelte`);
    error2.name = "Svelte error";
    throw error2;
  } else {
    throw new Error(`https://svelte.dev/e/rune_outside_svelte`);
  }
}
function state_descriptors_fixed() {
  if (DEV) {
    const error2 = new Error(`state_descriptors_fixed
Property descriptors defined on \`$state\` objects must contain \`value\` and always be \`enumerable\`, \`configurable\` and \`writable\`.
https://svelte.dev/e/state_descriptors_fixed`);
    error2.name = "Svelte error";
    throw error2;
  } else {
    throw new Error(`https://svelte.dev/e/state_descriptors_fixed`);
  }
}
function state_prototype_fixed() {
  if (DEV) {
    const error2 = new Error(`state_prototype_fixed
Cannot set prototype of \`$state\` object
https://svelte.dev/e/state_prototype_fixed`);
    error2.name = "Svelte error";
    throw error2;
  } else {
    throw new Error(`https://svelte.dev/e/state_prototype_fixed`);
  }
}
function state_unsafe_mutation() {
  if (DEV) {
    const error2 = new Error(`state_unsafe_mutation
Updating state inside \`$derived(...)\`, \`$inspect(...)\` or a template expression is forbidden. If the value should not be reactive, declare it without \`$state\`
https://svelte.dev/e/state_unsafe_mutation`);
    error2.name = "Svelte error";
    throw error2;
  } else {
    throw new Error(`https://svelte.dev/e/state_unsafe_mutation`);
  }
}
function svelte_boundary_reset_onerror() {
  if (DEV) {
    const error2 = new Error(`svelte_boundary_reset_onerror
A \`<svelte:boundary>\` \`reset\` function cannot be called while an error is still being handled
https://svelte.dev/e/svelte_boundary_reset_onerror`);
    error2.name = "Svelte error";
    throw error2;
  } else {
    throw new Error(`https://svelte.dev/e/svelte_boundary_reset_onerror`);
  }
}
var bold$1 = "font-weight: bold";
var normal$1 = "font-weight: normal";
function await_reactivity_loss(name2) {
  if (DEV) {
    console.warn(`%c[svelte] await_reactivity_loss
%cDetected reactivity loss when reading \`${name2}\`. This happens when state is read in an async function after an earlier \`await\`
https://svelte.dev/e/await_reactivity_loss`, bold$1, normal$1);
  } else {
    console.warn(`https://svelte.dev/e/await_reactivity_loss`);
  }
}
function lifecycle_double_unmount() {
  if (DEV) {
    console.warn(`%c[svelte] lifecycle_double_unmount
%cTried to unmount a component that was not mounted
https://svelte.dev/e/lifecycle_double_unmount`, bold$1, normal$1);
  } else {
    console.warn(`https://svelte.dev/e/lifecycle_double_unmount`);
  }
}
function select_multiple_invalid_value() {
  if (DEV) {
    console.warn(`%c[svelte] select_multiple_invalid_value
%cThe \`value\` property of a \`<select multiple>\` element should be an array, but it received a non-array value. The selection will be kept as is.
https://svelte.dev/e/select_multiple_invalid_value`, bold$1, normal$1);
  } else {
    console.warn(`https://svelte.dev/e/select_multiple_invalid_value`);
  }
}
function state_proxy_equality_mismatch(operator2) {
  if (DEV) {
    console.warn(`%c[svelte] state_proxy_equality_mismatch
%cReactive \`$state(...)\` proxies and the values they proxy have different identities. Because of this, comparisons with \`${operator2}\` will produce unexpected results
https://svelte.dev/e/state_proxy_equality_mismatch`, bold$1, normal$1);
  } else {
    console.warn(`https://svelte.dev/e/state_proxy_equality_mismatch`);
  }
}
function state_proxy_unmount() {
  if (DEV) {
    console.warn(`%c[svelte] state_proxy_unmount
%cTried to unmount a state proxy, rather than a component
https://svelte.dev/e/state_proxy_unmount`, bold$1, normal$1);
  } else {
    console.warn(`https://svelte.dev/e/state_proxy_unmount`);
  }
}
function svelte_boundary_reset_noop() {
  if (DEV) {
    console.warn(`%c[svelte] svelte_boundary_reset_noop
%cA \`<svelte:boundary>\` \`reset\` function only resets the boundary the first time it is called
https://svelte.dev/e/svelte_boundary_reset_noop`, bold$1, normal$1);
  } else {
    console.warn(`https://svelte.dev/e/svelte_boundary_reset_noop`);
  }
}
function transition_slide_display(value) {
  if (DEV) {
    console.warn(`%c[svelte] transition_slide_display
%cThe \`slide\` transition does not work correctly for elements with \`display: ${value}\`
https://svelte.dev/e/transition_slide_display`, bold$1, normal$1);
  } else {
    console.warn(`https://svelte.dev/e/transition_slide_display`);
  }
}
let hydrating = false;
function equals(value) {
  return value === this.v;
}
function safe_not_equal(a, b2) {
  return a != a ? b2 == b2 : a !== b2 || a !== null && typeof a === "object" || typeof a === "function";
}
function safe_equals(value) {
  return !safe_not_equal(value, this.v);
}
let tracing_mode_flag = false;
var bold = "font-weight: bold";
var normal = "font-weight: normal";
function state_snapshot_uncloneable(properties) {
  if (DEV) {
    console.warn(
      `%c[svelte] state_snapshot_uncloneable
%c${properties ? `The following properties cannot be cloned with \`$state.snapshot\` — the return value contains the originals:

${properties}` : "Value cannot be cloned with `$state.snapshot` — the original value was returned"}
https://svelte.dev/e/state_snapshot_uncloneable`,
      bold,
      normal
    );
  } else {
    console.warn(`https://svelte.dev/e/state_snapshot_uncloneable`);
  }
}
const empty$1 = [];
function snapshot(value, skip_warning = false, no_tojson = false) {
  if (DEV && !skip_warning) {
    const paths = [];
    const copy = clone(value, /* @__PURE__ */ new Map(), "", paths, null, no_tojson);
    if (paths.length === 1 && paths[0] === "") {
      state_snapshot_uncloneable();
    } else if (paths.length > 0) {
      const slice = paths.length > 10 ? paths.slice(0, 7) : paths.slice(0, 10);
      const excess = paths.length - slice.length;
      let uncloned = slice.map((path) => `- <value>${path}`).join("\n");
      if (excess > 0) uncloned += `
- ...and ${excess} more`;
      state_snapshot_uncloneable(uncloned);
    }
    return copy;
  }
  return clone(value, /* @__PURE__ */ new Map(), "", empty$1, null, no_tojson);
}
function clone(value, cloned, path, paths, original = null, no_tojson = false) {
  if (typeof value === "object" && value !== null) {
    var unwrapped = cloned.get(value);
    if (unwrapped !== void 0) return unwrapped;
    if (value instanceof Map) return (
      /** @type {Snapshot<T>} */
      new Map(value)
    );
    if (value instanceof Set) return (
      /** @type {Snapshot<T>} */
      new Set(value)
    );
    if (is_array(value)) {
      var copy = (
        /** @type {Snapshot<any>} */
        Array(value.length)
      );
      cloned.set(value, copy);
      if (original !== null) {
        cloned.set(original, copy);
      }
      for (var i = 0; i < value.length; i += 1) {
        var element = value[i];
        if (i in value) {
          copy[i] = clone(element, cloned, DEV ? `${path}[${i}]` : path, paths, null, no_tojson);
        }
      }
      return copy;
    }
    if (get_prototype_of(value) === object_prototype) {
      copy = {};
      cloned.set(value, copy);
      if (original !== null) {
        cloned.set(original, copy);
      }
      for (var key2 in value) {
        copy[key2] = clone(
          // @ts-expect-error
          value[key2],
          cloned,
          DEV ? `${path}.${key2}` : path,
          paths,
          null,
          no_tojson
        );
      }
      return copy;
    }
    if (value instanceof Date) {
      return (
        /** @type {Snapshot<T>} */
        structuredClone(value)
      );
    }
    if (typeof /** @type {T & { toJSON?: any } } */
    value.toJSON === "function" && !no_tojson) {
      return clone(
        /** @type {T & { toJSON(): any } } */
        value.toJSON(),
        cloned,
        DEV ? `${path}.toJSON()` : path,
        paths,
        // Associate the instance with the toJSON clone
        value
      );
    }
  }
  if (value instanceof EventTarget) {
    return (
      /** @type {Snapshot<T>} */
      value
    );
  }
  try {
    return (
      /** @type {Snapshot<T>} */
      structuredClone(value)
    );
  } catch (e) {
    if (DEV) {
      paths.push(path);
    }
    return (
      /** @type {Snapshot<T>} */
      value
    );
  }
}
function get_stack(label2) {
  const limit = Error.stackTraceLimit;
  Error.stackTraceLimit = Infinity;
  let error2 = Error();
  Error.stackTraceLimit = limit;
  const stack2 = error2.stack;
  if (!stack2) return null;
  const lines = stack2.split("\n");
  const new_lines = ["\n"];
  for (let i = 0; i < lines.length; i++) {
    const line = lines[i];
    const posixified = line.replaceAll("\\", "/");
    if (line === "Error") {
      continue;
    }
    if (line.includes("validate_each_keys")) {
      return null;
    }
    if (posixified.includes("svelte/src/internal") || posixified.includes("node_modules/.vite")) {
      continue;
    }
    new_lines.push(line);
  }
  if (new_lines.length === 1) {
    return null;
  }
  define_property(error2, "stack", {
    value: new_lines.join("\n")
  });
  define_property(error2, "name", {
    // 'Error' suffix is required for stack traces to be rendered properly
    value: `${label2}Error`
  });
  return (
    /** @type {Error & { stack: string }} */
    error2
  );
}
function tag(source2, label2) {
  source2.label = label2;
  tag_proxy(source2.v, label2);
  return source2;
}
function tag_proxy(value, label2) {
  var _a3;
  (_a3 = value == null ? void 0 : value[PROXY_PATH_SYMBOL]) == null ? void 0 : _a3.call(value, label2);
  return value;
}
function label(value) {
  if (typeof value === "symbol") return `Symbol(${value.description})`;
  if (typeof value === "function") return "<function>";
  if (typeof value === "object" && value) return "<object>";
  return String(value);
}
let component_context = null;
function set_component_context(context) {
  component_context = context;
}
let dev_stack = null;
function set_dev_stack(stack2) {
  dev_stack = stack2;
}
let dev_current_component_function = null;
function set_dev_current_component_function(fn) {
  dev_current_component_function = fn;
}
function getContext(key2) {
  const context_map = get_or_init_context_map("getContext");
  const result = (
    /** @type {T} */
    context_map.get(key2)
  );
  return result;
}
function setContext(key2, context) {
  const context_map = get_or_init_context_map("setContext");
  context_map.set(key2, context);
  return context;
}
function push(props, runes = false, fn) {
  component_context = {
    p: component_context,
    c: null,
    e: null,
    s: props,
    x: null,
    l: null
  };
  if (DEV) {
    component_context.function = fn;
    dev_current_component_function = fn;
  }
}
function pop(component2) {
  var _a3;
  var context = (
    /** @type {ComponentContext} */
    component_context
  );
  var effects = context.e;
  if (effects !== null) {
    context.e = null;
    for (var fn of effects) {
      create_user_effect(fn);
    }
  }
  if (component2 !== void 0) {
    context.x = component2;
  }
  component_context = context.p;
  if (DEV) {
    dev_current_component_function = (_a3 = component_context == null ? void 0 : component_context.function) != null ? _a3 : null;
  }
  return component2 != null ? component2 : (
    /** @type {T} */
    {}
  );
}
function is_runes() {
  return true;
}
function get_or_init_context_map(name2) {
  var _a3;
  if (component_context === null) {
    lifecycle_outside_component(name2);
  }
  return (_a3 = component_context.c) != null ? _a3 : component_context.c = new Map(get_parent_context(component_context) || void 0);
}
function get_parent_context(component_context2) {
  let parent = component_context2.p;
  while (parent !== null) {
    const context_map = parent.c;
    if (context_map !== null) {
      return context_map;
    }
    parent = parent.p;
  }
  return null;
}
let micro_tasks = [];
function run_micro_tasks() {
  var tasks = micro_tasks;
  micro_tasks = [];
  run_all(tasks);
}
function queue_micro_task(fn) {
  if (micro_tasks.length === 0 && !is_flushing_sync) {
    var tasks = micro_tasks;
    queueMicrotask(() => {
      if (tasks === micro_tasks) run_micro_tasks();
    });
  }
  micro_tasks.push(fn);
}
function flush_tasks() {
  while (micro_tasks.length > 0) {
    run_micro_tasks();
  }
}
const adjustments = /* @__PURE__ */ new WeakMap();
function handle_error(error2) {
  var effect2 = active_effect;
  if (effect2 === null) {
    active_reaction.f |= ERROR_VALUE;
    return error2;
  }
  if (DEV && error2 instanceof Error && !adjustments.has(error2)) {
    adjustments.set(error2, get_adjustments(error2, effect2));
  }
  if ((effect2.f & EFFECT_RAN) === 0) {
    if ((effect2.f & BOUNDARY_EFFECT) === 0) {
      if (!effect2.parent && error2 instanceof Error) {
        apply_adjustments(error2);
      }
      throw error2;
    }
    effect2.b.error(error2);
  } else {
    invoke_error_boundary(error2, effect2);
  }
}
function invoke_error_boundary(error2, effect2) {
  while (effect2 !== null) {
    if ((effect2.f & BOUNDARY_EFFECT) !== 0) {
      try {
        effect2.b.error(error2);
        return;
      } catch (e) {
        error2 = e;
      }
    }
    effect2 = effect2.parent;
  }
  if (error2 instanceof Error) {
    apply_adjustments(error2);
  }
  throw error2;
}
function get_adjustments(error2, effect2) {
  var _a3, _b2, _c2;
  const message_descriptor = get_descriptor(error2, "message");
  if (message_descriptor && !message_descriptor.configurable) return;
  var indent = is_firefox ? "  " : "	";
  var component_stack = `
${indent}in ${((_a3 = effect2.fn) == null ? void 0 : _a3.name) || "<unknown>"}`;
  var context = effect2.ctx;
  while (context !== null) {
    component_stack += `
${indent}in ${(_b2 = context.function) == null ? void 0 : _b2[FILENAME].split("/").pop()}`;
    context = context.p;
  }
  return {
    message: error2.message + `
${component_stack}
`,
    stack: (_c2 = error2.stack) == null ? void 0 : _c2.split("\n").filter((line) => !line.includes("svelte/src/internal")).join("\n")
  };
}
function apply_adjustments(error2) {
  const adjusted = adjustments.get(error2);
  if (adjusted) {
    define_property(error2, "message", {
      value: adjusted.message
    });
    define_property(error2, "stack", {
      value: adjusted.stack
    });
  }
}
const batches = /* @__PURE__ */ new Set();
let current_batch = null;
let previous_batch = null;
let batch_values = null;
let effect_pending_updates = /* @__PURE__ */ new Set();
let queued_root_effects = [];
let last_scheduled_effect = null;
let is_flushing = false;
let is_flushing_sync = false;
const _Batch = class _Batch {
  constructor() {
    __privateAdd(this, _Batch_instances);
    __publicField(this, "committed", false);
    /**
     * The current values of any sources that are updated in this batch
     * They keys of this map are identical to `this.#previous`
     * @type {Map<Source, any>}
     */
    __publicField(this, "current", /* @__PURE__ */ new Map());
    /**
     * The values of any sources that are updated in this batch _before_ those updates took place.
     * They keys of this map are identical to `this.#current`
     * @type {Map<Source, any>}
     */
    __privateAdd(this, _previous, /* @__PURE__ */ new Map());
    /**
     * When the batch is committed (and the DOM is updated), we need to remove old branches
     * and append new ones by calling the functions added inside (if/each/key/etc) blocks
     * @type {Set<() => void>}
     */
    __privateAdd(this, _callbacks, /* @__PURE__ */ new Set());
    /**
     * The number of async effects that are currently in flight
     */
    __privateAdd(this, _pending, 0);
    /**
     * The number of async effects that are currently in flight, _not_ inside a pending boundary
     */
    __privateAdd(this, _blocking_pending, 0);
    /**
     * A deferred that resolves when the batch is committed, used with `settled()`
     * TODO replace with Promise.withResolvers once supported widely enough
     * @type {{ promise: Promise<void>, resolve: (value?: any) => void, reject: (reason: unknown) => void } | null}
     */
    __privateAdd(this, _deferred, null);
    /**
     * Deferred effects (which run after async work has completed) that are DIRTY
     * @type {Effect[]}
     */
    __privateAdd(this, _dirty_effects, []);
    /**
     * Deferred effects that are MAYBE_DIRTY
     * @type {Effect[]}
     */
    __privateAdd(this, _maybe_dirty_effects, []);
    /**
     * A set of branches that still exist, but will be destroyed when this batch
     * is committed — we skip over these during `process`
     * @type {Set<Effect>}
     */
    __publicField(this, "skipped_effects", /* @__PURE__ */ new Set());
  }
  /**
   *
   * @param {Effect[]} root_effects
   */
  process(root_effects) {
    queued_root_effects = [];
    previous_batch = null;
    this.apply();
    var target = {
      parent: null,
      effect: null,
      effects: [],
      render_effects: [],
      block_effects: []
    };
    for (const root2 of root_effects) {
      __privateMethod(this, _Batch_instances, traverse_effect_tree_fn).call(this, root2, target);
    }
    __privateMethod(this, _Batch_instances, resolve_fn).call(this);
    if (__privateGet(this, _blocking_pending) > 0) {
      __privateMethod(this, _Batch_instances, defer_effects_fn).call(this, target.effects);
      __privateMethod(this, _Batch_instances, defer_effects_fn).call(this, target.render_effects);
      __privateMethod(this, _Batch_instances, defer_effects_fn).call(this, target.block_effects);
    } else {
      previous_batch = this;
      current_batch = null;
      flush_queued_effects(target.render_effects);
      flush_queued_effects(target.effects);
      previous_batch = null;
    }
    batch_values = null;
  }
  /**
   * Associate a change to a given source with the current
   * batch, noting its previous and current values
   * @param {Source} source
   * @param {any} value
   */
  capture(source2, value) {
    if (!__privateGet(this, _previous).has(source2)) {
      __privateGet(this, _previous).set(source2, value);
    }
    this.current.set(source2, source2.v);
    batch_values == null ? void 0 : batch_values.set(source2, source2.v);
  }
  activate() {
    current_batch = this;
  }
  deactivate() {
    current_batch = null;
    batch_values = null;
  }
  flush() {
    if (queued_root_effects.length > 0) {
      this.activate();
      flush_effects();
      if (current_batch !== null && current_batch !== this) {
        return;
      }
    } else {
      __privateMethod(this, _Batch_instances, resolve_fn).call(this);
    }
    this.deactivate();
    for (const update2 of effect_pending_updates) {
      effect_pending_updates.delete(update2);
      update2();
      if (current_batch !== null) {
        break;
      }
    }
  }
  /**
   *
   * @param {boolean} blocking
   */
  increment(blocking) {
    __privateSet(this, _pending, __privateGet(this, _pending) + 1);
    if (blocking) __privateSet(this, _blocking_pending, __privateGet(this, _blocking_pending) + 1);
  }
  /**
   *
   * @param {boolean} blocking
   */
  decrement(blocking) {
    __privateSet(this, _pending, __privateGet(this, _pending) - 1);
    if (blocking) __privateSet(this, _blocking_pending, __privateGet(this, _blocking_pending) - 1);
    for (const e of __privateGet(this, _dirty_effects)) {
      set_signal_status(e, DIRTY);
      schedule_effect(e);
    }
    for (const e of __privateGet(this, _maybe_dirty_effects)) {
      set_signal_status(e, MAYBE_DIRTY);
      schedule_effect(e);
    }
    __privateSet(this, _dirty_effects, []);
    __privateSet(this, _maybe_dirty_effects, []);
    this.flush();
  }
  /** @param {() => void} fn */
  add_callback(fn) {
    __privateGet(this, _callbacks).add(fn);
  }
  settled() {
    var _a3;
    return ((_a3 = __privateGet(this, _deferred)) != null ? _a3 : __privateSet(this, _deferred, deferred())).promise;
  }
  static ensure() {
    if (current_batch === null) {
      const batch = current_batch = new _Batch();
      batches.add(current_batch);
      if (!is_flushing_sync) {
        _Batch.enqueue(() => {
          if (current_batch !== batch) {
            return;
          }
          batch.flush();
        });
      }
    }
    return current_batch;
  }
  /** @param {() => void} task */
  static enqueue(task) {
    queue_micro_task(task);
  }
  apply() {
    return;
  }
};
_previous = new WeakMap();
_callbacks = new WeakMap();
_pending = new WeakMap();
_blocking_pending = new WeakMap();
_deferred = new WeakMap();
_dirty_effects = new WeakMap();
_maybe_dirty_effects = new WeakMap();
_Batch_instances = new WeakSet();
/**
 * Traverse the effect tree, executing effects or stashing
 * them for later execution as appropriate
 * @param {Effect} root
 * @param {EffectTarget} target
 */
traverse_effect_tree_fn = function(root2, target) {
  var _a3;
  root2.f ^= CLEAN;
  var effect2 = root2.first;
  while (effect2 !== null) {
    var flags2 = effect2.f;
    var is_branch = (flags2 & (BRANCH_EFFECT | ROOT_EFFECT)) !== 0;
    var is_skippable_branch = is_branch && (flags2 & CLEAN) !== 0;
    var skip = is_skippable_branch || (flags2 & INERT) !== 0 || this.skipped_effects.has(effect2);
    if ((effect2.f & BOUNDARY_EFFECT) !== 0 && ((_a3 = effect2.b) == null ? void 0 : _a3.is_pending())) {
      target = {
        parent: target,
        effect: effect2,
        effects: [],
        render_effects: [],
        block_effects: []
      };
    }
    if (!skip && effect2.fn !== null) {
      if (is_branch) {
        effect2.f ^= CLEAN;
      } else if ((flags2 & EFFECT) !== 0) {
        target.effects.push(effect2);
      } else if (is_dirty(effect2)) {
        if ((effect2.f & BLOCK_EFFECT) !== 0) target.block_effects.push(effect2);
        update_effect(effect2);
      }
      var child2 = effect2.first;
      if (child2 !== null) {
        effect2 = child2;
        continue;
      }
    }
    var parent = effect2.parent;
    effect2 = effect2.next;
    while (effect2 === null && parent !== null) {
      if (parent === target.effect) {
        __privateMethod(this, _Batch_instances, defer_effects_fn).call(this, target.effects);
        __privateMethod(this, _Batch_instances, defer_effects_fn).call(this, target.render_effects);
        __privateMethod(this, _Batch_instances, defer_effects_fn).call(this, target.block_effects);
        target = /** @type {EffectTarget} */
        target.parent;
      }
      effect2 = parent.next;
      parent = parent.parent;
    }
  }
};
/**
 * @param {Effect[]} effects
 */
defer_effects_fn = function(effects) {
  for (const e of effects) {
    const target = (e.f & DIRTY) !== 0 ? __privateGet(this, _dirty_effects) : __privateGet(this, _maybe_dirty_effects);
    target.push(e);
    set_signal_status(e, CLEAN);
  }
};
resolve_fn = function() {
  if (__privateGet(this, _blocking_pending) === 0) {
    for (const fn of __privateGet(this, _callbacks)) fn();
    __privateGet(this, _callbacks).clear();
  }
  if (__privateGet(this, _pending) === 0) {
    __privateMethod(this, _Batch_instances, commit_fn).call(this);
  }
};
commit_fn = function() {
  var _a3, _b2;
  if (batches.size > 1) {
    __privateGet(this, _previous).clear();
    var previous_batch_values = batch_values;
    var is_earlier = true;
    var dummy_target = {
      parent: null,
      effect: null,
      effects: [],
      render_effects: [],
      block_effects: []
    };
    for (const batch of batches) {
      if (batch === this) {
        is_earlier = false;
        continue;
      }
      const sources = [];
      for (const [source2, value] of this.current) {
        if (batch.current.has(source2)) {
          if (is_earlier && value !== batch.current.get(source2)) {
            batch.current.set(source2, value);
          } else {
            continue;
          }
        }
        sources.push(source2);
      }
      if (sources.length === 0) {
        continue;
      }
      const others = [...batch.current.keys()].filter((s) => !this.current.has(s));
      if (others.length > 0) {
        const marked2 = /* @__PURE__ */ new Set();
        const checked = /* @__PURE__ */ new Map();
        for (const source2 of sources) {
          mark_effects(source2, others, marked2, checked);
        }
        if (queued_root_effects.length > 0) {
          current_batch = batch;
          batch.apply();
          for (const root2 of queued_root_effects) {
            __privateMethod(_a3 = batch, _Batch_instances, traverse_effect_tree_fn).call(_a3, root2, dummy_target);
          }
          queued_root_effects = [];
          batch.deactivate();
        }
      }
    }
    current_batch = null;
    batch_values = previous_batch_values;
  }
  this.committed = true;
  batches.delete(this);
  (_b2 = __privateGet(this, _deferred)) == null ? void 0 : _b2.resolve();
};
let Batch = _Batch;
function flushSync(fn) {
  var was_flushing_sync = is_flushing_sync;
  is_flushing_sync = true;
  try {
    var result;
    if (fn) ;
    while (true) {
      flush_tasks();
      if (queued_root_effects.length === 0) {
        current_batch == null ? void 0 : current_batch.flush();
        if (queued_root_effects.length === 0) {
          last_scheduled_effect = null;
          return (
            /** @type {T} */
            result
          );
        }
      }
      flush_effects();
    }
  } finally {
    is_flushing_sync = was_flushing_sync;
  }
}
function flush_effects() {
  var _a3;
  var was_updating_effect = is_updating_effect;
  is_flushing = true;
  try {
    var flush_count = 0;
    set_is_updating_effect(true);
    while (queued_root_effects.length > 0) {
      var batch = Batch.ensure();
      if (flush_count++ > 1e3) {
        if (DEV) {
          var updates = /* @__PURE__ */ new Map();
          for (const source2 of batch.current.keys()) {
            for (const [stack2, update2] of (_a3 = source2.updated) != null ? _a3 : []) {
              var entry = updates.get(stack2);
              if (!entry) {
                entry = { error: update2.error, count: 0 };
                updates.set(stack2, entry);
              }
              entry.count += update2.count;
            }
          }
          for (const update2 of updates.values()) {
            console.error(update2.error);
          }
        }
        infinite_loop_guard();
      }
      batch.process(queued_root_effects);
      old_values.clear();
    }
  } finally {
    is_flushing = false;
    set_is_updating_effect(was_updating_effect);
    last_scheduled_effect = null;
  }
}
function infinite_loop_guard() {
  try {
    effect_update_depth_exceeded();
  } catch (error2) {
    if (DEV) {
      define_property(error2, "stack", { value: "" });
    }
    invoke_error_boundary(error2, last_scheduled_effect);
  }
}
let eager_block_effects = null;
function flush_queued_effects(effects) {
  var length = effects.length;
  if (length === 0) return;
  var i = 0;
  while (i < length) {
    var effect2 = effects[i++];
    if ((effect2.f & (DESTROYED | INERT)) === 0 && is_dirty(effect2)) {
      eager_block_effects = /* @__PURE__ */ new Set();
      update_effect(effect2);
      if (effect2.deps === null && effect2.first === null && effect2.nodes_start === null) {
        if (effect2.teardown === null && effect2.ac === null) {
          unlink_effect(effect2);
        } else {
          effect2.fn = null;
        }
      }
      if ((eager_block_effects == null ? void 0 : eager_block_effects.size) > 0) {
        old_values.clear();
        for (const e of eager_block_effects) {
          if ((e.f & (DESTROYED | INERT)) !== 0) continue;
          const ordered_effects = [e];
          let ancestor = e.parent;
          while (ancestor !== null) {
            if (eager_block_effects.has(ancestor)) {
              eager_block_effects.delete(ancestor);
              ordered_effects.push(ancestor);
            }
            ancestor = ancestor.parent;
          }
          for (let j2 = ordered_effects.length - 1; j2 >= 0; j2--) {
            const e2 = ordered_effects[j2];
            if ((e2.f & (DESTROYED | INERT)) !== 0) continue;
            update_effect(e2);
          }
        }
        eager_block_effects.clear();
      }
    }
  }
  eager_block_effects = null;
}
function mark_effects(value, sources, marked2, checked) {
  if (marked2.has(value)) return;
  marked2.add(value);
  if (value.reactions !== null) {
    for (const reaction of value.reactions) {
      const flags2 = reaction.f;
      if ((flags2 & DERIVED) !== 0) {
        mark_effects(
          /** @type {Derived} */
          reaction,
          sources,
          marked2,
          checked
        );
      } else if ((flags2 & (ASYNC | BLOCK_EFFECT)) !== 0 && (flags2 & DIRTY) === 0 && // we may have scheduled this one already
      depends_on(reaction, sources, checked)) {
        set_signal_status(reaction, DIRTY);
        schedule_effect(
          /** @type {Effect} */
          reaction
        );
      }
    }
  }
}
function depends_on(reaction, sources, checked) {
  const depends = checked.get(reaction);
  if (depends !== void 0) return depends;
  if (reaction.deps !== null) {
    for (const dep of reaction.deps) {
      if (sources.includes(dep)) {
        return true;
      }
      if ((dep.f & DERIVED) !== 0 && depends_on(
        /** @type {Derived} */
        dep,
        sources,
        checked
      )) {
        checked.set(
          /** @type {Derived} */
          dep,
          true
        );
        return true;
      }
    }
  }
  checked.set(reaction, false);
  return false;
}
function schedule_effect(signal) {
  var effect2 = last_scheduled_effect = signal;
  while (effect2.parent !== null) {
    effect2 = effect2.parent;
    var flags2 = effect2.f;
    if (is_flushing && effect2 === active_effect && (flags2 & BLOCK_EFFECT) !== 0) {
      return;
    }
    if ((flags2 & (ROOT_EFFECT | BRANCH_EFFECT)) !== 0) {
      if ((flags2 & CLEAN) === 0) return;
      effect2.f ^= CLEAN;
    }
  }
  queued_root_effects.push(effect2);
}
function createSubscriber(start2) {
  let subscribers = 0;
  let version = source(0);
  let stop;
  if (DEV) {
    tag(version, "createSubscriber version");
  }
  return () => {
    if (effect_tracking()) {
      get$3(version);
      render_effect(() => {
        if (subscribers === 0) {
          stop = untrack(() => start2(() => increment(version)));
        }
        subscribers += 1;
        return () => {
          queue_micro_task(() => {
            subscribers -= 1;
            if (subscribers === 0) {
              stop == null ? void 0 : stop();
              stop = void 0;
              increment(version);
            }
          });
        };
      });
    }
  };
}
var flags = EFFECT_TRANSPARENT | EFFECT_PRESERVED | BOUNDARY_EFFECT;
function boundary(node, props, children2) {
  new Boundary(node, props, children2);
}
class Boundary {
  /**
   * @param {TemplateNode} node
   * @param {BoundaryProps} props
   * @param {((anchor: Node) => void)} children
   */
  constructor(node, props, children2) {
    __privateAdd(this, _Boundary_instances);
    /** @type {Boundary | null} */
    __publicField(this, "parent");
    __privateAdd(this, _pending2, false);
    /** @type {TemplateNode} */
    __privateAdd(this, _anchor);
    /** @type {TemplateNode | null} */
    __privateAdd(this, _hydrate_open, null);
    /** @type {BoundaryProps} */
    __privateAdd(this, _props);
    /** @type {((anchor: Node) => void)} */
    __privateAdd(this, _children);
    /** @type {Effect} */
    __privateAdd(this, _effect);
    /** @type {Effect | null} */
    __privateAdd(this, _main_effect, null);
    /** @type {Effect | null} */
    __privateAdd(this, _pending_effect, null);
    /** @type {Effect | null} */
    __privateAdd(this, _failed_effect, null);
    /** @type {DocumentFragment | null} */
    __privateAdd(this, _offscreen_fragment, null);
    __privateAdd(this, _local_pending_count, 0);
    __privateAdd(this, _pending_count, 0);
    __privateAdd(this, _is_creating_fallback, false);
    /**
     * A source containing the number of pending async deriveds/expressions.
     * Only created if `$effect.pending()` is used inside the boundary,
     * otherwise updating the source results in needless `Batch.ensure()`
     * calls followed by no-op flushes
     * @type {Source<number> | null}
     */
    __privateAdd(this, _effect_pending, null);
    __privateAdd(this, _effect_pending_update, () => {
      if (__privateGet(this, _effect_pending)) {
        internal_set(__privateGet(this, _effect_pending), __privateGet(this, _local_pending_count));
      }
    });
    __privateAdd(this, _effect_pending_subscriber, createSubscriber(() => {
      __privateSet(this, _effect_pending, source(__privateGet(this, _local_pending_count)));
      if (DEV) {
        tag(__privateGet(this, _effect_pending), "$effect.pending()");
      }
      return () => {
        __privateSet(this, _effect_pending, null);
      };
    }));
    __privateSet(this, _anchor, node);
    __privateSet(this, _props, props);
    __privateSet(this, _children, children2);
    this.parent = /** @type {Effect} */
    active_effect.b;
    __privateSet(this, _pending2, !!__privateGet(this, _props).pending);
    __privateSet(this, _effect, block$1(() => {
      active_effect.b = this;
      {
        try {
          __privateSet(this, _main_effect, branch(() => children2(__privateGet(this, _anchor))));
        } catch (error2) {
          this.error(error2);
        }
        if (__privateGet(this, _pending_count) > 0) {
          __privateMethod(this, _Boundary_instances, show_pending_snippet_fn).call(this);
        } else {
          __privateSet(this, _pending2, false);
        }
      }
    }, flags));
  }
  /**
   * Returns `true` if the effect exists inside a boundary whose pending snippet is shown
   * @returns {boolean}
   */
  is_pending() {
    return __privateGet(this, _pending2) || !!this.parent && this.parent.is_pending();
  }
  has_pending_snippet() {
    return !!__privateGet(this, _props).pending;
  }
  /**
   * Update the source that powers `$effect.pending()` inside this boundary,
   * and controls when the current `pending` snippet (if any) is removed.
   * Do not call from inside the class
   * @param {1 | -1} d
   */
  update_pending_count(d) {
    __privateMethod(this, _Boundary_instances, update_pending_count_fn).call(this, d);
    __privateSet(this, _local_pending_count, __privateGet(this, _local_pending_count) + d);
    effect_pending_updates.add(__privateGet(this, _effect_pending_update));
  }
  get_effect_pending() {
    __privateGet(this, _effect_pending_subscriber).call(this);
    return get$3(
      /** @type {Source<number>} */
      __privateGet(this, _effect_pending)
    );
  }
  /** @param {unknown} error */
  error(error2) {
    var onerror = __privateGet(this, _props).onerror;
    let failed = __privateGet(this, _props).failed;
    if (__privateGet(this, _is_creating_fallback) || !onerror && !failed) {
      throw error2;
    }
    if (__privateGet(this, _main_effect)) {
      destroy_effect(__privateGet(this, _main_effect));
      __privateSet(this, _main_effect, null);
    }
    if (__privateGet(this, _pending_effect)) {
      destroy_effect(__privateGet(this, _pending_effect));
      __privateSet(this, _pending_effect, null);
    }
    if (__privateGet(this, _failed_effect)) {
      destroy_effect(__privateGet(this, _failed_effect));
      __privateSet(this, _failed_effect, null);
    }
    var did_reset = false;
    var calling_on_error = false;
    const reset = () => {
      if (did_reset) {
        svelte_boundary_reset_noop();
        return;
      }
      did_reset = true;
      if (calling_on_error) {
        svelte_boundary_reset_onerror();
      }
      Batch.ensure();
      __privateSet(this, _local_pending_count, 0);
      if (__privateGet(this, _failed_effect) !== null) {
        pause_effect(__privateGet(this, _failed_effect), () => {
          __privateSet(this, _failed_effect, null);
        });
      }
      __privateSet(this, _pending2, this.has_pending_snippet());
      __privateSet(this, _main_effect, __privateMethod(this, _Boundary_instances, run_fn).call(this, () => {
        __privateSet(this, _is_creating_fallback, false);
        return branch(() => __privateGet(this, _children).call(this, __privateGet(this, _anchor)));
      }));
      if (__privateGet(this, _pending_count) > 0) {
        __privateMethod(this, _Boundary_instances, show_pending_snippet_fn).call(this);
      } else {
        __privateSet(this, _pending2, false);
      }
    };
    var previous_reaction = active_reaction;
    try {
      set_active_reaction(null);
      calling_on_error = true;
      onerror == null ? void 0 : onerror(error2, reset);
      calling_on_error = false;
    } catch (error3) {
      invoke_error_boundary(error3, __privateGet(this, _effect) && __privateGet(this, _effect).parent);
    } finally {
      set_active_reaction(previous_reaction);
    }
    if (failed) {
      queue_micro_task(() => {
        __privateSet(this, _failed_effect, __privateMethod(this, _Boundary_instances, run_fn).call(this, () => {
          __privateSet(this, _is_creating_fallback, true);
          try {
            return branch(() => {
              failed(
                __privateGet(this, _anchor),
                () => error2,
                () => reset
              );
            });
          } catch (error3) {
            invoke_error_boundary(
              error3,
              /** @type {Effect} */
              __privateGet(this, _effect).parent
            );
            return null;
          } finally {
            __privateSet(this, _is_creating_fallback, false);
          }
        }));
      });
    }
  }
}
_pending2 = new WeakMap();
_anchor = new WeakMap();
_hydrate_open = new WeakMap();
_props = new WeakMap();
_children = new WeakMap();
_effect = new WeakMap();
_main_effect = new WeakMap();
_pending_effect = new WeakMap();
_failed_effect = new WeakMap();
_offscreen_fragment = new WeakMap();
_local_pending_count = new WeakMap();
_pending_count = new WeakMap();
_is_creating_fallback = new WeakMap();
_effect_pending = new WeakMap();
_effect_pending_update = new WeakMap();
_effect_pending_subscriber = new WeakMap();
_Boundary_instances = new WeakSet();
hydrate_resolved_content_fn = function() {
  try {
    __privateSet(this, _main_effect, branch(() => __privateGet(this, _children).call(this, __privateGet(this, _anchor))));
  } catch (error2) {
    this.error(error2);
  }
  __privateSet(this, _pending2, false);
};
hydrate_pending_content_fn = function() {
  const pending = __privateGet(this, _props).pending;
  if (!pending) {
    return;
  }
  __privateSet(this, _pending_effect, branch(() => pending(__privateGet(this, _anchor))));
  Batch.enqueue(() => {
    __privateSet(this, _main_effect, __privateMethod(this, _Boundary_instances, run_fn).call(this, () => {
      Batch.ensure();
      return branch(() => __privateGet(this, _children).call(this, __privateGet(this, _anchor)));
    }));
    if (__privateGet(this, _pending_count) > 0) {
      __privateMethod(this, _Boundary_instances, show_pending_snippet_fn).call(this);
    } else {
      pause_effect(
        /** @type {Effect} */
        __privateGet(this, _pending_effect),
        () => {
          __privateSet(this, _pending_effect, null);
        }
      );
      __privateSet(this, _pending2, false);
    }
  });
};
/**
 * @param {() => Effect | null} fn
 */
run_fn = function(fn) {
  var previous_effect = active_effect;
  var previous_reaction = active_reaction;
  var previous_ctx = component_context;
  set_active_effect(__privateGet(this, _effect));
  set_active_reaction(__privateGet(this, _effect));
  set_component_context(__privateGet(this, _effect).ctx);
  try {
    return fn();
  } catch (e) {
    handle_error(e);
    return null;
  } finally {
    set_active_effect(previous_effect);
    set_active_reaction(previous_reaction);
    set_component_context(previous_ctx);
  }
};
show_pending_snippet_fn = function() {
  const pending = (
    /** @type {(anchor: Node) => void} */
    __privateGet(this, _props).pending
  );
  if (__privateGet(this, _main_effect) !== null) {
    __privateSet(this, _offscreen_fragment, document.createDocumentFragment());
    move_effect(__privateGet(this, _main_effect), __privateGet(this, _offscreen_fragment));
  }
  if (__privateGet(this, _pending_effect) === null) {
    __privateSet(this, _pending_effect, branch(() => pending(__privateGet(this, _anchor))));
  }
};
/**
 * Updates the pending count associated with the currently visible pending snippet,
 * if any, such that we can replace the snippet with content once work is done
 * @param {1 | -1} d
 */
update_pending_count_fn = function(d) {
  var _a3;
  if (!this.has_pending_snippet()) {
    if (this.parent) {
      __privateMethod(_a3 = this.parent, _Boundary_instances, update_pending_count_fn).call(_a3, d);
    }
    return;
  }
  __privateSet(this, _pending_count, __privateGet(this, _pending_count) + d);
  if (__privateGet(this, _pending_count) === 0) {
    __privateSet(this, _pending2, false);
    if (__privateGet(this, _pending_effect)) {
      pause_effect(__privateGet(this, _pending_effect), () => {
        __privateSet(this, _pending_effect, null);
      });
    }
    if (__privateGet(this, _offscreen_fragment)) {
      __privateGet(this, _anchor).before(__privateGet(this, _offscreen_fragment));
      __privateSet(this, _offscreen_fragment, null);
    }
  }
};
function flatten$1(sync, async, fn) {
  const d = derived$1;
  if (async.length === 0) {
    fn(sync.map(d));
    return;
  }
  var batch = current_batch;
  var parent = (
    /** @type {Effect} */
    active_effect
  );
  var restore = capture();
  Promise.all(async.map((expression) => /* @__PURE__ */ async_derived(expression))).then((result) => {
    restore();
    try {
      fn([...sync.map(d), ...result]);
    } catch (error2) {
      if ((parent.f & DESTROYED) === 0) {
        invoke_error_boundary(error2, parent);
      }
    }
    batch == null ? void 0 : batch.deactivate();
    unset_context();
  }).catch((error2) => {
    invoke_error_boundary(error2, parent);
  });
}
function capture() {
  var previous_effect = active_effect;
  var previous_reaction = active_reaction;
  var previous_component_context = component_context;
  var previous_batch2 = current_batch;
  if (DEV) {
    var previous_dev_stack = dev_stack;
  }
  return function restore() {
    set_active_effect(previous_effect);
    set_active_reaction(previous_reaction);
    set_component_context(previous_component_context);
    previous_batch2 == null ? void 0 : previous_batch2.activate();
    if (DEV) {
      set_from_async_derived(null);
      set_dev_stack(previous_dev_stack);
    }
  };
}
function unset_context() {
  set_active_effect(null);
  set_active_reaction(null);
  set_component_context(null);
  if (DEV) {
    set_from_async_derived(null);
    set_dev_stack(null);
  }
}
let current_async_effect = null;
function set_from_async_derived(v2) {
  current_async_effect = v2;
}
const recent_async_deriveds = /* @__PURE__ */ new Set();
// @__NO_SIDE_EFFECTS__
function derived$1(fn) {
  var flags2 = DERIVED | DIRTY;
  var parent_derived = active_reaction !== null && (active_reaction.f & DERIVED) !== 0 ? (
    /** @type {Derived} */
    active_reaction
  ) : null;
  if (active_effect === null || parent_derived !== null && (parent_derived.f & UNOWNED) !== 0) {
    flags2 |= UNOWNED;
  } else {
    active_effect.f |= EFFECT_PRESERVED;
  }
  const signal = {
    ctx: component_context,
    deps: null,
    effects: null,
    equals,
    f: flags2,
    fn,
    reactions: null,
    rv: 0,
    v: (
      /** @type {V} */
      UNINITIALIZED
    ),
    wv: 0,
    parent: parent_derived != null ? parent_derived : active_effect,
    ac: null
  };
  return signal;
}
// @__NO_SIDE_EFFECTS__
function async_derived(fn, location) {
  let parent = (
    /** @type {Effect | null} */
    active_effect
  );
  if (parent === null) {
    async_derived_orphan();
  }
  var boundary2 = (
    /** @type {Boundary} */
    parent.b
  );
  var promise = (
    /** @type {Promise<V>} */
    /** @type {unknown} */
    void 0
  );
  var signal = source(
    /** @type {V} */
    UNINITIALIZED
  );
  var should_suspend = !active_reaction;
  var deferreds = /* @__PURE__ */ new Map();
  async_effect(() => {
    var _a3;
    if (DEV) current_async_effect = active_effect;
    var d = deferred();
    promise = d.promise;
    try {
      Promise.resolve(fn()).then(d.resolve, d.reject).then(() => {
        if (batch === current_batch && batch.committed) {
          batch.deactivate();
        }
        unset_context();
      });
    } catch (error2) {
      d.reject(error2);
      unset_context();
    }
    if (DEV) current_async_effect = null;
    var batch = (
      /** @type {Batch} */
      current_batch
    );
    if (should_suspend) {
      var blocking = !boundary2.is_pending();
      boundary2.update_pending_count(1);
      batch.increment(blocking);
      (_a3 = deferreds.get(batch)) == null ? void 0 : _a3.reject(STALE_REACTION);
      deferreds.delete(batch);
      deferreds.set(batch, d);
    }
    const handler = (value, error2 = void 0) => {
      current_async_effect = null;
      batch.activate();
      if (error2) {
        if (error2 !== STALE_REACTION) {
          signal.f |= ERROR_VALUE;
          internal_set(signal, error2);
        }
      } else {
        if ((signal.f & ERROR_VALUE) !== 0) {
          signal.f ^= ERROR_VALUE;
        }
        internal_set(signal, value);
        for (const [b2, d2] of deferreds) {
          deferreds.delete(b2);
          if (b2 === batch) break;
          d2.reject(STALE_REACTION);
        }
      }
      if (should_suspend) {
        boundary2.update_pending_count(-1);
        batch.decrement(blocking);
      }
    };
    d.promise.then(handler, (e) => handler(null, e || "unknown"));
  });
  teardown(() => {
    for (const d of deferreds.values()) {
      d.reject(STALE_REACTION);
    }
  });
  if (DEV) {
    signal.f |= ASYNC;
  }
  return new Promise((fulfil) => {
    function next(p) {
      function go() {
        if (p === promise) {
          fulfil(signal);
        } else {
          next(promise);
        }
      }
      p.then(go, go);
    }
    next(promise);
  });
}
// @__NO_SIDE_EFFECTS__
function user_derived(fn) {
  const d = /* @__PURE__ */ derived$1(fn);
  push_reaction_value(d);
  return d;
}
// @__NO_SIDE_EFFECTS__
function derived_safe_equal(fn) {
  const signal = /* @__PURE__ */ derived$1(fn);
  signal.equals = safe_equals;
  return signal;
}
function destroy_derived_effects(derived2) {
  var effects = derived2.effects;
  if (effects !== null) {
    derived2.effects = null;
    for (var i = 0; i < effects.length; i += 1) {
      destroy_effect(
        /** @type {Effect} */
        effects[i]
      );
    }
  }
}
let stack = [];
function get_derived_parent_effect(derived2) {
  var parent = derived2.parent;
  while (parent !== null) {
    if ((parent.f & DERIVED) === 0) {
      return (
        /** @type {Effect} */
        parent
      );
    }
    parent = parent.parent;
  }
  return null;
}
function execute_derived(derived2) {
  var value;
  var prev_active_effect = active_effect;
  set_active_effect(get_derived_parent_effect(derived2));
  if (DEV) {
    let prev_inspect_effects = inspect_effects;
    set_inspect_effects(/* @__PURE__ */ new Set());
    try {
      if (stack.includes(derived2)) {
        derived_references_self();
      }
      stack.push(derived2);
      derived2.f &= ~WAS_MARKED;
      destroy_derived_effects(derived2);
      value = update_reaction(derived2);
    } finally {
      set_active_effect(prev_active_effect);
      set_inspect_effects(prev_inspect_effects);
      stack.pop();
    }
  } else {
    try {
      derived2.f &= ~WAS_MARKED;
      destroy_derived_effects(derived2);
      value = update_reaction(derived2);
    } finally {
      set_active_effect(prev_active_effect);
    }
  }
  return value;
}
function update_derived(derived2) {
  var value = execute_derived(derived2);
  if (!derived2.equals(value)) {
    derived2.v = value;
    derived2.wv = increment_write_version();
  }
  if (is_destroying_effect) {
    return;
  }
  if (batch_values !== null) {
    batch_values.set(derived2, derived2.v);
  } else {
    var status = (skip_reaction || (derived2.f & UNOWNED) !== 0) && derived2.deps !== null ? MAYBE_DIRTY : CLEAN;
    set_signal_status(derived2, status);
  }
}
let inspect_effects = /* @__PURE__ */ new Set();
const old_values = /* @__PURE__ */ new Map();
function set_inspect_effects(v2) {
  inspect_effects = v2;
}
let inspect_effects_deferred = false;
function set_inspect_effects_deferred() {
  inspect_effects_deferred = true;
}
function source(v2, stack2) {
  var signal = {
    f: 0,
    // TODO ideally we could skip this altogether, but it causes type errors
    v: v2,
    reactions: null,
    equals,
    rv: 0,
    wv: 0
  };
  return signal;
}
// @__NO_SIDE_EFFECTS__
function state(v2, stack2) {
  const s = source(v2);
  push_reaction_value(s);
  return s;
}
// @__NO_SIDE_EFFECTS__
function mutable_source(initial_value, immutable = false, trackable = true) {
  const s = source(initial_value);
  if (!immutable) {
    s.equals = safe_equals;
  }
  return s;
}
function set$2(source2, value, should_proxy = false) {
  if (active_reaction !== null && // since we are untracking the function inside `$inspect.with` we need to add this check
  // to ensure we error if state is set inside an inspect effect
  (!untracking || (active_reaction.f & INSPECT_EFFECT) !== 0) && is_runes() && (active_reaction.f & (DERIVED | BLOCK_EFFECT | ASYNC | INSPECT_EFFECT)) !== 0 && !(current_sources == null ? void 0 : current_sources.includes(source2))) {
    state_unsafe_mutation();
  }
  let new_value = should_proxy ? proxy(value) : value;
  if (DEV) {
    tag_proxy(
      new_value,
      /** @type {string} */
      source2.label
    );
  }
  return internal_set(source2, new_value);
}
function internal_set(source2, value) {
  var _a3;
  if (!source2.equals(value)) {
    var old_value = source2.v;
    if (is_destroying_effect) {
      old_values.set(source2, value);
    } else {
      old_values.set(source2, old_value);
    }
    source2.v = value;
    var batch = Batch.ensure();
    batch.capture(source2, old_value);
    if (DEV) {
      if (active_effect !== null) {
        const error2 = get_stack("UpdatedAt");
        if (error2 !== null) {
          (_a3 = source2.updated) != null ? _a3 : source2.updated = /* @__PURE__ */ new Map();
          let entry = source2.updated.get(error2.stack);
          if (!entry) {
            entry = { error: error2, count: 0 };
            source2.updated.set(error2.stack, entry);
          }
          entry.count++;
        }
      }
      if (active_effect !== null) {
        source2.set_during_effect = true;
      }
    }
    if ((source2.f & DERIVED) !== 0) {
      if ((source2.f & DIRTY) !== 0) {
        execute_derived(
          /** @type {Derived} */
          source2
        );
      }
      set_signal_status(source2, (source2.f & UNOWNED) === 0 ? CLEAN : MAYBE_DIRTY);
    }
    source2.wv = increment_write_version();
    mark_reactions(source2, DIRTY);
    if (active_effect !== null && (active_effect.f & CLEAN) !== 0 && (active_effect.f & (BRANCH_EFFECT | ROOT_EFFECT)) === 0) {
      if (untracked_writes === null) {
        set_untracked_writes([source2]);
      } else {
        untracked_writes.push(source2);
      }
    }
    if (DEV && inspect_effects.size > 0 && !inspect_effects_deferred) {
      flush_inspect_effects();
    }
  }
  return value;
}
function flush_inspect_effects() {
  inspect_effects_deferred = false;
  const inspects = Array.from(inspect_effects);
  for (const effect2 of inspects) {
    if ((effect2.f & CLEAN) !== 0) {
      set_signal_status(effect2, MAYBE_DIRTY);
    }
    if (is_dirty(effect2)) {
      update_effect(effect2);
    }
  }
  inspect_effects.clear();
}
function update$1(source2, d = 1) {
  var value = get$3(source2);
  var result = d === 1 ? value++ : value--;
  set$2(source2, value);
  return result;
}
function increment(source2) {
  set$2(source2, source2.v + 1);
}
function mark_reactions(signal, status) {
  var reactions = signal.reactions;
  if (reactions === null) return;
  var length = reactions.length;
  for (var i = 0; i < length; i++) {
    var reaction = reactions[i];
    var flags2 = reaction.f;
    if (DEV && (flags2 & INSPECT_EFFECT) !== 0) {
      inspect_effects.add(reaction);
      continue;
    }
    var not_dirty = (flags2 & DIRTY) === 0;
    if (not_dirty) {
      set_signal_status(reaction, status);
    }
    if ((flags2 & DERIVED) !== 0) {
      if ((flags2 & WAS_MARKED) === 0) {
        reaction.f |= WAS_MARKED;
        mark_reactions(
          /** @type {Derived} */
          reaction,
          MAYBE_DIRTY
        );
      }
    } else if (not_dirty) {
      if ((flags2 & BLOCK_EFFECT) !== 0) {
        if (eager_block_effects !== null) {
          eager_block_effects.add(
            /** @type {Effect} */
            reaction
          );
        }
      }
      schedule_effect(
        /** @type {Effect} */
        reaction
      );
    }
  }
}
const regex_is_valid_identifier = /^[a-zA-Z_$][a-zA-Z_$0-9]*$/;
function proxy(value) {
  if (typeof value !== "object" || value === null || STATE_SYMBOL in value) {
    return value;
  }
  const prototype = get_prototype_of(value);
  if (prototype !== object_prototype && prototype !== array_prototype) {
    return value;
  }
  var sources = /* @__PURE__ */ new Map();
  var is_proxied_array = is_array(value);
  var version = /* @__PURE__ */ state(0);
  var parent_version = update_version;
  var with_parent = (fn) => {
    if (update_version === parent_version) {
      return fn();
    }
    var reaction = active_reaction;
    var version2 = update_version;
    set_active_reaction(null);
    set_update_version(parent_version);
    var result = fn();
    set_active_reaction(reaction);
    set_update_version(version2);
    return result;
  };
  if (is_proxied_array) {
    sources.set("length", /* @__PURE__ */ state(
      /** @type {any[]} */
      value.length
    ));
    if (DEV) {
      value = /** @type {any} */
      inspectable_array(
        /** @type {any[]} */
        value
      );
    }
  }
  var path = "";
  let updating = false;
  function update_path(new_path) {
    if (updating) return;
    updating = true;
    path = new_path;
    tag(version, `${path} version`);
    for (const [prop2, source2] of sources) {
      tag(source2, get_label(path, prop2));
    }
    updating = false;
  }
  return new Proxy(
    /** @type {any} */
    value,
    {
      defineProperty(_2, prop2, descriptor) {
        if (!("value" in descriptor) || descriptor.configurable === false || descriptor.enumerable === false || descriptor.writable === false) {
          state_descriptors_fixed();
        }
        var s = sources.get(prop2);
        if (s === void 0) {
          s = with_parent(() => {
            var s2 = /* @__PURE__ */ state(descriptor.value);
            sources.set(prop2, s2);
            if (DEV && typeof prop2 === "string") {
              tag(s2, get_label(path, prop2));
            }
            return s2;
          });
        } else {
          set$2(s, descriptor.value, true);
        }
        return true;
      },
      deleteProperty(target, prop2) {
        var s = sources.get(prop2);
        if (s === void 0) {
          if (prop2 in target) {
            const s2 = with_parent(() => /* @__PURE__ */ state(UNINITIALIZED));
            sources.set(prop2, s2);
            increment(version);
            if (DEV) {
              tag(s2, get_label(path, prop2));
            }
          }
        } else {
          set$2(s, UNINITIALIZED);
          increment(version);
        }
        return true;
      },
      get(target, prop2, receiver) {
        var _a3;
        if (prop2 === STATE_SYMBOL) {
          return value;
        }
        if (DEV && prop2 === PROXY_PATH_SYMBOL) {
          return update_path;
        }
        var s = sources.get(prop2);
        var exists = prop2 in target;
        if (s === void 0 && (!exists || ((_a3 = get_descriptor(target, prop2)) == null ? void 0 : _a3.writable))) {
          s = with_parent(() => {
            var p = proxy(exists ? target[prop2] : UNINITIALIZED);
            var s2 = /* @__PURE__ */ state(p);
            if (DEV) {
              tag(s2, get_label(path, prop2));
            }
            return s2;
          });
          sources.set(prop2, s);
        }
        if (s !== void 0) {
          var v2 = get$3(s);
          return v2 === UNINITIALIZED ? void 0 : v2;
        }
        return Reflect.get(target, prop2, receiver);
      },
      getOwnPropertyDescriptor(target, prop2) {
        var descriptor = Reflect.getOwnPropertyDescriptor(target, prop2);
        if (descriptor && "value" in descriptor) {
          var s = sources.get(prop2);
          if (s) descriptor.value = get$3(s);
        } else if (descriptor === void 0) {
          var source2 = sources.get(prop2);
          var value2 = source2 == null ? void 0 : source2.v;
          if (source2 !== void 0 && value2 !== UNINITIALIZED) {
            return {
              enumerable: true,
              configurable: true,
              value: value2,
              writable: true
            };
          }
        }
        return descriptor;
      },
      has(target, prop2) {
        var _a3;
        if (prop2 === STATE_SYMBOL) {
          return true;
        }
        var s = sources.get(prop2);
        var has = s !== void 0 && s.v !== UNINITIALIZED || Reflect.has(target, prop2);
        if (s !== void 0 || active_effect !== null && (!has || ((_a3 = get_descriptor(target, prop2)) == null ? void 0 : _a3.writable))) {
          if (s === void 0) {
            s = with_parent(() => {
              var p = has ? proxy(target[prop2]) : UNINITIALIZED;
              var s2 = /* @__PURE__ */ state(p);
              if (DEV) {
                tag(s2, get_label(path, prop2));
              }
              return s2;
            });
            sources.set(prop2, s);
          }
          var value2 = get$3(s);
          if (value2 === UNINITIALIZED) {
            return false;
          }
        }
        return has;
      },
      set(target, prop2, value2, receiver) {
        var _a3;
        var s = sources.get(prop2);
        var has = prop2 in target;
        if (is_proxied_array && prop2 === "length") {
          for (var i = value2; i < /** @type {Source<number>} */
          s.v; i += 1) {
            var other_s = sources.get(i + "");
            if (other_s !== void 0) {
              set$2(other_s, UNINITIALIZED);
            } else if (i in target) {
              other_s = with_parent(() => /* @__PURE__ */ state(UNINITIALIZED));
              sources.set(i + "", other_s);
              if (DEV) {
                tag(other_s, get_label(path, i));
              }
            }
          }
        }
        if (s === void 0) {
          if (!has || ((_a3 = get_descriptor(target, prop2)) == null ? void 0 : _a3.writable)) {
            s = with_parent(() => /* @__PURE__ */ state(void 0));
            if (DEV) {
              tag(s, get_label(path, prop2));
            }
            set$2(s, proxy(value2));
            sources.set(prop2, s);
          }
        } else {
          has = s.v !== UNINITIALIZED;
          var p = with_parent(() => proxy(value2));
          set$2(s, p);
        }
        var descriptor = Reflect.getOwnPropertyDescriptor(target, prop2);
        if (descriptor == null ? void 0 : descriptor.set) {
          descriptor.set.call(receiver, value2);
        }
        if (!has) {
          if (is_proxied_array && typeof prop2 === "string") {
            var ls = (
              /** @type {Source<number>} */
              sources.get("length")
            );
            var n = Number(prop2);
            if (Number.isInteger(n) && n >= ls.v) {
              set$2(ls, n + 1);
            }
          }
          increment(version);
        }
        return true;
      },
      ownKeys(target) {
        get$3(version);
        var own_keys = Reflect.ownKeys(target).filter((key3) => {
          var source3 = sources.get(key3);
          return source3 === void 0 || source3.v !== UNINITIALIZED;
        });
        for (var [key2, source2] of sources) {
          if (source2.v !== UNINITIALIZED && !(key2 in target)) {
            own_keys.push(key2);
          }
        }
        return own_keys;
      },
      setPrototypeOf() {
        state_prototype_fixed();
      }
    }
  );
}
function get_label(path, prop2) {
  var _a3;
  if (typeof prop2 === "symbol") return `${path}[Symbol(${(_a3 = prop2.description) != null ? _a3 : ""})]`;
  if (regex_is_valid_identifier.test(prop2)) return `${path}.${prop2}`;
  return /^\d+$/.test(prop2) ? `${path}[${prop2}]` : `${path}['${prop2}']`;
}
function get_proxied_value(value) {
  try {
    if (value !== null && typeof value === "object" && STATE_SYMBOL in value) {
      return value[STATE_SYMBOL];
    }
  } catch (e) {
  }
  return value;
}
function is(a, b2) {
  return Object.is(get_proxied_value(a), get_proxied_value(b2));
}
const ARRAY_MUTATING_METHODS = /* @__PURE__ */ new Set([
  "copyWithin",
  "fill",
  "pop",
  "push",
  "reverse",
  "shift",
  "sort",
  "splice",
  "unshift"
]);
function inspectable_array(array2) {
  return new Proxy(array2, {
    get(target, prop2, receiver) {
      var value = Reflect.get(target, prop2, receiver);
      if (!ARRAY_MUTATING_METHODS.has(
        /** @type {string} */
        prop2
      )) {
        return value;
      }
      return function(...args) {
        set_inspect_effects_deferred();
        var result = value.apply(this, args);
        flush_inspect_effects();
        return result;
      };
    }
  });
}
function init_array_prototype_warnings() {
  const array_prototype2 = Array.prototype;
  const cleanup = Array.__svelte_cleanup;
  if (cleanup) {
    cleanup();
  }
  const { indexOf, lastIndexOf, includes } = array_prototype2;
  array_prototype2.indexOf = function(item, from_index) {
    const index2 = indexOf.call(this, item, from_index);
    if (index2 === -1) {
      for (let i = from_index != null ? from_index : 0; i < this.length; i += 1) {
        if (get_proxied_value(this[i]) === item) {
          state_proxy_equality_mismatch("array.indexOf(...)");
          break;
        }
      }
    }
    return index2;
  };
  array_prototype2.lastIndexOf = function(item, from_index) {
    const index2 = lastIndexOf.call(this, item, from_index != null ? from_index : this.length - 1);
    if (index2 === -1) {
      for (let i = 0; i <= (from_index != null ? from_index : this.length - 1); i += 1) {
        if (get_proxied_value(this[i]) === item) {
          state_proxy_equality_mismatch("array.lastIndexOf(...)");
          break;
        }
      }
    }
    return index2;
  };
  array_prototype2.includes = function(item, from_index) {
    const has = includes.call(this, item, from_index);
    if (!has) {
      for (let i = 0; i < this.length; i += 1) {
        if (get_proxied_value(this[i]) === item) {
          state_proxy_equality_mismatch("array.includes(...)");
          break;
        }
      }
    }
    return has;
  };
  Array.__svelte_cleanup = () => {
    array_prototype2.indexOf = indexOf;
    array_prototype2.lastIndexOf = lastIndexOf;
    array_prototype2.includes = includes;
  };
}
var $window;
var $document;
var is_firefox;
var first_child_getter;
var next_sibling_getter;
function init_operations() {
  if ($window !== void 0) {
    return;
  }
  $window = window;
  $document = document;
  is_firefox = /Firefox/.test(navigator.userAgent);
  var element_prototype = Element.prototype;
  var node_prototype = Node.prototype;
  var text_prototype = Text.prototype;
  first_child_getter = get_descriptor(node_prototype, "firstChild").get;
  next_sibling_getter = get_descriptor(node_prototype, "nextSibling").get;
  if (is_extensible(element_prototype)) {
    element_prototype.__click = void 0;
    element_prototype.__className = void 0;
    element_prototype.__attributes = null;
    element_prototype.__style = void 0;
    element_prototype.__e = void 0;
  }
  if (is_extensible(text_prototype)) {
    text_prototype.__t = void 0;
  }
  if (DEV) {
    element_prototype.__svelte_meta = null;
    init_array_prototype_warnings();
  }
}
function create_text(value = "") {
  return document.createTextNode(value);
}
// @__NO_SIDE_EFFECTS__
function get_first_child(node) {
  return first_child_getter.call(node);
}
// @__NO_SIDE_EFFECTS__
function get_next_sibling(node) {
  return next_sibling_getter.call(node);
}
function child(node, is_text) {
  {
    return /* @__PURE__ */ get_first_child(node);
  }
}
function first_child(fragment, is_text = false) {
  {
    var first = (
      /** @type {DocumentFragment} */
      /* @__PURE__ */ get_first_child(
        /** @type {Node} */
        fragment
      )
    );
    if (first instanceof Comment && first.data === "") return /* @__PURE__ */ get_next_sibling(first);
    return first;
  }
}
function sibling(node, count = 1, is_text = false) {
  let next_sibling = node;
  while (count--) {
    next_sibling = /** @type {TemplateNode} */
    /* @__PURE__ */ get_next_sibling(next_sibling);
  }
  {
    return next_sibling;
  }
}
function clear_text_content(node) {
  node.textContent = "";
}
function should_defer_append() {
  return false;
}
function autofocus(dom, value) {
  if (value) {
    const body = document.body;
    dom.autofocus = true;
    queue_micro_task(() => {
      if (document.activeElement === body) {
        dom.focus();
      }
    });
  }
}
let listening_to_form_reset = false;
function add_form_reset_listener() {
  if (!listening_to_form_reset) {
    listening_to_form_reset = true;
    document.addEventListener(
      "reset",
      (evt) => {
        Promise.resolve().then(() => {
          var _a3;
          if (!evt.defaultPrevented) {
            for (
              const e of
              /**@type {HTMLFormElement} */
              evt.target.elements
            ) {
              (_a3 = e.__on_r) == null ? void 0 : _a3.call(e);
            }
          }
        });
      },
      // In the capture phase to guarantee we get noticed of it (no possiblity of stopPropagation)
      { capture: true }
    );
  }
}
function without_reactive_context(fn) {
  var previous_reaction = active_reaction;
  var previous_effect = active_effect;
  set_active_reaction(null);
  set_active_effect(null);
  try {
    return fn();
  } finally {
    set_active_reaction(previous_reaction);
    set_active_effect(previous_effect);
  }
}
function listen_to_event_and_reset_event(element, event2, handler, on_reset = handler) {
  element.addEventListener(event2, () => without_reactive_context(handler));
  const prev = element.__on_r;
  if (prev) {
    element.__on_r = () => {
      prev();
      on_reset(true);
    };
  } else {
    element.__on_r = () => on_reset(true);
  }
  add_form_reset_listener();
}
function validate_effect(rune) {
  if (active_effect === null && active_reaction === null) {
    effect_orphan(rune);
  }
  if (active_reaction !== null && (active_reaction.f & UNOWNED) !== 0 && active_effect === null) {
    effect_in_unowned_derived();
  }
  if (is_destroying_effect) {
    effect_in_teardown(rune);
  }
}
function push_effect(effect2, parent_effect) {
  var parent_last = parent_effect.last;
  if (parent_last === null) {
    parent_effect.last = parent_effect.first = effect2;
  } else {
    parent_last.next = effect2;
    effect2.prev = parent_last;
    parent_effect.last = effect2;
  }
}
function create_effect(type, fn, sync, push2 = true) {
  var _a3;
  var parent = active_effect;
  if (DEV) {
    while (parent !== null && (parent.f & INSPECT_EFFECT) !== 0) {
      parent = parent.parent;
    }
  }
  if (parent !== null && (parent.f & INERT) !== 0) {
    type |= INERT;
  }
  var effect2 = {
    ctx: component_context,
    deps: null,
    nodes_start: null,
    nodes_end: null,
    f: type | DIRTY,
    first: null,
    fn,
    last: null,
    next: null,
    parent,
    b: parent && parent.b,
    prev: null,
    teardown: null,
    transitions: null,
    wv: 0,
    ac: null
  };
  if (DEV) {
    effect2.component_function = dev_current_component_function;
  }
  if (sync) {
    try {
      update_effect(effect2);
      effect2.f |= EFFECT_RAN;
    } catch (e2) {
      destroy_effect(effect2);
      throw e2;
    }
  } else if (fn !== null) {
    schedule_effect(effect2);
  }
  if (push2) {
    var e = effect2;
    if (sync && e.deps === null && e.teardown === null && e.nodes_start === null && e.first === e.last && // either `null`, or a singular child
    (e.f & EFFECT_PRESERVED) === 0) {
      e = e.first;
    }
    if (e !== null) {
      e.parent = parent;
      if (parent !== null) {
        push_effect(e, parent);
      }
      if (active_reaction !== null && (active_reaction.f & DERIVED) !== 0 && (type & ROOT_EFFECT) === 0) {
        var derived2 = (
          /** @type {Derived} */
          active_reaction
        );
        ((_a3 = derived2.effects) != null ? _a3 : derived2.effects = []).push(e);
      }
    }
  }
  return effect2;
}
function effect_tracking() {
  return active_reaction !== null && !untracking;
}
function teardown(fn) {
  const effect2 = create_effect(RENDER_EFFECT, null, false);
  set_signal_status(effect2, CLEAN);
  effect2.teardown = fn;
  return effect2;
}
function user_effect(fn) {
  var _a3;
  validate_effect("$effect");
  if (DEV) {
    define_property(fn, "name", {
      value: "$effect"
    });
  }
  var flags2 = (
    /** @type {Effect} */
    active_effect.f
  );
  var defer = !active_reaction && (flags2 & BRANCH_EFFECT) !== 0 && (flags2 & EFFECT_RAN) === 0;
  if (defer) {
    var context = (
      /** @type {ComponentContext} */
      component_context
    );
    ((_a3 = context.e) != null ? _a3 : context.e = []).push(fn);
  } else {
    return create_user_effect(fn);
  }
}
function create_user_effect(fn) {
  return create_effect(EFFECT | USER_EFFECT, fn, false);
}
function user_pre_effect(fn) {
  validate_effect("$effect.pre");
  if (DEV) {
    define_property(fn, "name", {
      value: "$effect.pre"
    });
  }
  return create_effect(RENDER_EFFECT | USER_EFFECT, fn, true);
}
function effect_root(fn) {
  Batch.ensure();
  const effect2 = create_effect(ROOT_EFFECT | EFFECT_PRESERVED, fn, true);
  return () => {
    destroy_effect(effect2);
  };
}
function component_root(fn) {
  Batch.ensure();
  const effect2 = create_effect(ROOT_EFFECT | EFFECT_PRESERVED, fn, true);
  return (options2 = {}) => {
    return new Promise((fulfil) => {
      if (options2.outro) {
        pause_effect(effect2, () => {
          destroy_effect(effect2);
          fulfil(void 0);
        });
      } else {
        destroy_effect(effect2);
        fulfil(void 0);
      }
    });
  };
}
function effect(fn) {
  return create_effect(EFFECT, fn, false);
}
function async_effect(fn) {
  return create_effect(ASYNC | EFFECT_PRESERVED, fn, true);
}
function render_effect(fn, flags2 = 0) {
  return create_effect(RENDER_EFFECT | flags2, fn, true);
}
function template_effect(fn, sync = [], async = []) {
  flatten$1(sync, async, (values) => {
    create_effect(RENDER_EFFECT, () => fn(...values.map(get$3)), true);
  });
}
function block$1(fn, flags2 = 0) {
  var effect2 = create_effect(BLOCK_EFFECT | flags2, fn, true);
  if (DEV) {
    effect2.dev_stack = dev_stack;
  }
  return effect2;
}
function branch(fn, push2 = true) {
  return create_effect(BRANCH_EFFECT | EFFECT_PRESERVED, fn, true, push2);
}
function execute_effect_teardown(effect2) {
  var teardown2 = effect2.teardown;
  if (teardown2 !== null) {
    const previously_destroying_effect = is_destroying_effect;
    const previous_reaction = active_reaction;
    set_is_destroying_effect(true);
    set_active_reaction(null);
    try {
      teardown2.call(null);
    } finally {
      set_is_destroying_effect(previously_destroying_effect);
      set_active_reaction(previous_reaction);
    }
  }
}
function destroy_effect_children(signal, remove_dom = false) {
  var effect2 = signal.first;
  signal.first = signal.last = null;
  while (effect2 !== null) {
    const controller = effect2.ac;
    if (controller !== null) {
      without_reactive_context(() => {
        controller.abort(STALE_REACTION);
      });
    }
    var next = effect2.next;
    if ((effect2.f & ROOT_EFFECT) !== 0) {
      effect2.parent = null;
    } else {
      destroy_effect(effect2, remove_dom);
    }
    effect2 = next;
  }
}
function destroy_block_effect_children(signal) {
  var effect2 = signal.first;
  while (effect2 !== null) {
    var next = effect2.next;
    if ((effect2.f & BRANCH_EFFECT) === 0) {
      destroy_effect(effect2);
    }
    effect2 = next;
  }
}
function destroy_effect(effect2, remove_dom = true) {
  var removed = false;
  if ((remove_dom || (effect2.f & HEAD_EFFECT) !== 0) && effect2.nodes_start !== null && effect2.nodes_end !== null) {
    remove_effect_dom(
      effect2.nodes_start,
      /** @type {TemplateNode} */
      effect2.nodes_end
    );
    removed = true;
  }
  destroy_effect_children(effect2, remove_dom && !removed);
  remove_reactions(effect2, 0);
  set_signal_status(effect2, DESTROYED);
  var transitions = effect2.transitions;
  if (transitions !== null) {
    for (const transition2 of transitions) {
      transition2.stop();
    }
  }
  execute_effect_teardown(effect2);
  var parent = effect2.parent;
  if (parent !== null && parent.first !== null) {
    unlink_effect(effect2);
  }
  if (DEV) {
    effect2.component_function = null;
  }
  effect2.next = effect2.prev = effect2.teardown = effect2.ctx = effect2.deps = effect2.fn = effect2.nodes_start = effect2.nodes_end = effect2.ac = null;
}
function remove_effect_dom(node, end) {
  while (node !== null) {
    var next = node === end ? null : (
      /** @type {TemplateNode} */
      /* @__PURE__ */ get_next_sibling(node)
    );
    node.remove();
    node = next;
  }
}
function unlink_effect(effect2) {
  var parent = effect2.parent;
  var prev = effect2.prev;
  var next = effect2.next;
  if (prev !== null) prev.next = next;
  if (next !== null) next.prev = prev;
  if (parent !== null) {
    if (parent.first === effect2) parent.first = next;
    if (parent.last === effect2) parent.last = prev;
  }
}
function pause_effect(effect2, callback, destroy = true) {
  var transitions = [];
  pause_children(effect2, transitions, true);
  run_out_transitions(transitions, () => {
    if (destroy) destroy_effect(effect2);
    if (callback) callback();
  });
}
function run_out_transitions(transitions, fn) {
  var remaining = transitions.length;
  if (remaining > 0) {
    var check = () => --remaining || fn();
    for (var transition2 of transitions) {
      transition2.out(check);
    }
  } else {
    fn();
  }
}
function pause_children(effect2, transitions, local) {
  if ((effect2.f & INERT) !== 0) return;
  effect2.f ^= INERT;
  if (effect2.transitions !== null) {
    for (const transition2 of effect2.transitions) {
      if (transition2.is_global || local) {
        transitions.push(transition2);
      }
    }
  }
  var child2 = effect2.first;
  while (child2 !== null) {
    var sibling2 = child2.next;
    var transparent = (child2.f & EFFECT_TRANSPARENT) !== 0 || (child2.f & BRANCH_EFFECT) !== 0;
    pause_children(child2, transitions, transparent ? local : false);
    child2 = sibling2;
  }
}
function resume_effect(effect2) {
  resume_children(effect2, true);
}
function resume_children(effect2, local) {
  if ((effect2.f & INERT) === 0) return;
  effect2.f ^= INERT;
  if ((effect2.f & CLEAN) === 0) {
    set_signal_status(effect2, DIRTY);
    schedule_effect(effect2);
  }
  var child2 = effect2.first;
  while (child2 !== null) {
    var sibling2 = child2.next;
    var transparent = (child2.f & EFFECT_TRANSPARENT) !== 0 || (child2.f & BRANCH_EFFECT) !== 0;
    resume_children(child2, transparent ? local : false);
    child2 = sibling2;
  }
  if (effect2.transitions !== null) {
    for (const transition2 of effect2.transitions) {
      if (transition2.is_global || local) {
        transition2.in();
      }
    }
  }
}
function move_effect(effect2, fragment) {
  var node = effect2.nodes_start;
  var end = effect2.nodes_end;
  while (node !== null) {
    var next = node === end ? null : (
      /** @type {TemplateNode} */
      /* @__PURE__ */ get_next_sibling(node)
    );
    fragment.append(node);
    node = next;
  }
}
let is_updating_effect = false;
function set_is_updating_effect(value) {
  is_updating_effect = value;
}
let is_destroying_effect = false;
function set_is_destroying_effect(value) {
  is_destroying_effect = value;
}
let active_reaction = null;
let untracking = false;
function set_active_reaction(reaction) {
  active_reaction = reaction;
}
let active_effect = null;
function set_active_effect(effect2) {
  active_effect = effect2;
}
let current_sources = null;
function push_reaction_value(value) {
  if (active_reaction !== null && true) {
    if (current_sources === null) {
      current_sources = [value];
    } else {
      current_sources.push(value);
    }
  }
}
let new_deps = null;
let skipped_deps = 0;
let untracked_writes = null;
function set_untracked_writes(value) {
  untracked_writes = value;
}
let write_version = 1;
let read_version = 0;
let update_version = read_version;
function set_update_version(value) {
  update_version = value;
}
let skip_reaction = false;
function increment_write_version() {
  return ++write_version;
}
function is_dirty(reaction) {
  var _a3, _b2;
  var flags2 = reaction.f;
  if ((flags2 & DIRTY) !== 0) {
    return true;
  }
  if ((flags2 & MAYBE_DIRTY) !== 0) {
    var dependencies = reaction.deps;
    var is_unowned = (flags2 & UNOWNED) !== 0;
    if (flags2 & DERIVED) {
      reaction.f &= ~WAS_MARKED;
    }
    if (dependencies !== null) {
      var i;
      var dependency;
      var is_disconnected = (flags2 & DISCONNECTED) !== 0;
      var is_unowned_connected = is_unowned && active_effect !== null && !skip_reaction;
      var length = dependencies.length;
      if ((is_disconnected || is_unowned_connected) && (active_effect === null || (active_effect.f & DESTROYED) === 0)) {
        var derived2 = (
          /** @type {Derived} */
          reaction
        );
        var parent = derived2.parent;
        for (i = 0; i < length; i++) {
          dependency = dependencies[i];
          if (is_disconnected || !((_a3 = dependency == null ? void 0 : dependency.reactions) == null ? void 0 : _a3.includes(derived2))) {
            ((_b2 = dependency.reactions) != null ? _b2 : dependency.reactions = []).push(derived2);
          }
        }
        if (is_disconnected) {
          derived2.f ^= DISCONNECTED;
        }
        if (is_unowned_connected && parent !== null && (parent.f & UNOWNED) === 0) {
          derived2.f ^= UNOWNED;
        }
      }
      for (i = 0; i < length; i++) {
        dependency = dependencies[i];
        if (is_dirty(
          /** @type {Derived} */
          dependency
        )) {
          update_derived(
            /** @type {Derived} */
            dependency
          );
        }
        if (dependency.wv > reaction.wv) {
          return true;
        }
      }
    }
    if (!is_unowned || active_effect !== null && !skip_reaction) {
      set_signal_status(reaction, CLEAN);
    }
  }
  return false;
}
function schedule_possible_effect_self_invalidation(signal, effect2, root2 = true) {
  var reactions = signal.reactions;
  if (reactions === null) return;
  if (current_sources == null ? void 0 : current_sources.includes(signal)) {
    return;
  }
  for (var i = 0; i < reactions.length; i++) {
    var reaction = reactions[i];
    if ((reaction.f & DERIVED) !== 0) {
      schedule_possible_effect_self_invalidation(
        /** @type {Derived} */
        reaction,
        effect2,
        false
      );
    } else if (effect2 === reaction) {
      if (root2) {
        set_signal_status(reaction, DIRTY);
      } else if ((reaction.f & CLEAN) !== 0) {
        set_signal_status(reaction, MAYBE_DIRTY);
      }
      schedule_effect(
        /** @type {Effect} */
        reaction
      );
    }
  }
}
function update_reaction(reaction) {
  var _a3, _b2;
  var previous_deps = new_deps;
  var previous_skipped_deps = skipped_deps;
  var previous_untracked_writes = untracked_writes;
  var previous_reaction = active_reaction;
  var previous_skip_reaction = skip_reaction;
  var previous_sources = current_sources;
  var previous_component_context = component_context;
  var previous_untracking = untracking;
  var previous_update_version = update_version;
  var flags2 = reaction.f;
  new_deps = /** @type {null | Value[]} */
  null;
  skipped_deps = 0;
  untracked_writes = null;
  skip_reaction = (flags2 & UNOWNED) !== 0 && (untracking || !is_updating_effect || active_reaction === null);
  active_reaction = (flags2 & (BRANCH_EFFECT | ROOT_EFFECT)) === 0 ? reaction : null;
  current_sources = null;
  set_component_context(reaction.ctx);
  untracking = false;
  update_version = ++read_version;
  if (reaction.ac !== null) {
    without_reactive_context(() => {
      reaction.ac.abort(STALE_REACTION);
    });
    reaction.ac = null;
  }
  try {
    reaction.f |= REACTION_IS_UPDATING;
    var fn = (
      /** @type {Function} */
      reaction.fn
    );
    var result = fn();
    var deps = reaction.deps;
    if (new_deps !== null) {
      var i;
      remove_reactions(reaction, skipped_deps);
      if (deps !== null && skipped_deps > 0) {
        deps.length = skipped_deps + new_deps.length;
        for (i = 0; i < new_deps.length; i++) {
          deps[skipped_deps + i] = new_deps[i];
        }
      } else {
        reaction.deps = deps = new_deps;
      }
      if (!skip_reaction || // Deriveds that already have reactions can cleanup, so we still add them as reactions
      (flags2 & DERIVED) !== 0 && /** @type {import('#client').Derived} */
      reaction.reactions !== null) {
        for (i = skipped_deps; i < deps.length; i++) {
          ((_b2 = (_a3 = deps[i]).reactions) != null ? _b2 : _a3.reactions = []).push(reaction);
        }
      }
    } else if (deps !== null && skipped_deps < deps.length) {
      remove_reactions(reaction, skipped_deps);
      deps.length = skipped_deps;
    }
    if (is_runes() && untracked_writes !== null && !untracking && deps !== null && (reaction.f & (DERIVED | MAYBE_DIRTY | DIRTY)) === 0) {
      for (i = 0; i < /** @type {Source[]} */
      untracked_writes.length; i++) {
        schedule_possible_effect_self_invalidation(
          untracked_writes[i],
          /** @type {Effect} */
          reaction
        );
      }
    }
    if (previous_reaction !== null && previous_reaction !== reaction) {
      read_version++;
      if (untracked_writes !== null) {
        if (previous_untracked_writes === null) {
          previous_untracked_writes = untracked_writes;
        } else {
          previous_untracked_writes.push(.../** @type {Source[]} */
          untracked_writes);
        }
      }
    }
    if ((reaction.f & ERROR_VALUE) !== 0) {
      reaction.f ^= ERROR_VALUE;
    }
    return result;
  } catch (error2) {
    return handle_error(error2);
  } finally {
    reaction.f ^= REACTION_IS_UPDATING;
    new_deps = previous_deps;
    skipped_deps = previous_skipped_deps;
    untracked_writes = previous_untracked_writes;
    active_reaction = previous_reaction;
    skip_reaction = previous_skip_reaction;
    current_sources = previous_sources;
    set_component_context(previous_component_context);
    untracking = previous_untracking;
    update_version = previous_update_version;
  }
}
function remove_reaction(signal, dependency) {
  let reactions = dependency.reactions;
  if (reactions !== null) {
    var index2 = index_of.call(reactions, signal);
    if (index2 !== -1) {
      var new_length = reactions.length - 1;
      if (new_length === 0) {
        reactions = dependency.reactions = null;
      } else {
        reactions[index2] = reactions[new_length];
        reactions.pop();
      }
    }
  }
  if (reactions === null && (dependency.f & DERIVED) !== 0 && // Destroying a child effect while updating a parent effect can cause a dependency to appear
  // to be unused, when in fact it is used by the currently-updating parent. Checking `new_deps`
  // allows us to skip the expensive work of disconnecting and immediately reconnecting it
  (new_deps === null || !new_deps.includes(dependency))) {
    set_signal_status(dependency, MAYBE_DIRTY);
    if ((dependency.f & (UNOWNED | DISCONNECTED)) === 0) {
      dependency.f ^= DISCONNECTED;
    }
    destroy_derived_effects(
      /** @type {Derived} **/
      dependency
    );
    remove_reactions(
      /** @type {Derived} **/
      dependency,
      0
    );
  }
}
function remove_reactions(signal, start_index) {
  var dependencies = signal.deps;
  if (dependencies === null) return;
  for (var i = start_index; i < dependencies.length; i++) {
    remove_reaction(signal, dependencies[i]);
  }
}
function update_effect(effect2) {
  var _a3;
  var flags2 = effect2.f;
  if ((flags2 & DESTROYED) !== 0) {
    return;
  }
  set_signal_status(effect2, CLEAN);
  var previous_effect = active_effect;
  var was_updating_effect = is_updating_effect;
  active_effect = effect2;
  is_updating_effect = true;
  if (DEV) {
    var previous_component_fn = dev_current_component_function;
    set_dev_current_component_function(effect2.component_function);
    var previous_stack = (
      /** @type {any} */
      dev_stack
    );
    set_dev_stack((_a3 = effect2.dev_stack) != null ? _a3 : dev_stack);
  }
  try {
    if ((flags2 & BLOCK_EFFECT) !== 0) {
      destroy_block_effect_children(effect2);
    } else {
      destroy_effect_children(effect2);
    }
    execute_effect_teardown(effect2);
    var teardown2 = update_reaction(effect2);
    effect2.teardown = typeof teardown2 === "function" ? teardown2 : null;
    effect2.wv = write_version;
    var dep;
    if (DEV && tracing_mode_flag && (effect2.f & DIRTY) !== 0 && effect2.deps !== null) ;
  } finally {
    is_updating_effect = was_updating_effect;
    active_effect = previous_effect;
    if (DEV) {
      set_dev_current_component_function(previous_component_fn);
      set_dev_stack(previous_stack);
    }
  }
}
function tick() {
  return __async(this, null, function* () {
    yield Promise.resolve();
    flushSync();
  });
}
function get$3(signal) {
  var _a3, _b2;
  var flags2 = signal.f;
  var is_derived = (flags2 & DERIVED) !== 0;
  if (active_reaction !== null && !untracking) {
    var destroyed = active_effect !== null && (active_effect.f & DESTROYED) !== 0;
    if (!destroyed && !(current_sources == null ? void 0 : current_sources.includes(signal))) {
      var deps = active_reaction.deps;
      if ((active_reaction.f & REACTION_IS_UPDATING) !== 0) {
        if (signal.rv < read_version) {
          signal.rv = read_version;
          if (new_deps === null && deps !== null && deps[skipped_deps] === signal) {
            skipped_deps++;
          } else if (new_deps === null) {
            new_deps = [signal];
          } else if (!skip_reaction || !new_deps.includes(signal)) {
            new_deps.push(signal);
          }
        }
      } else {
        ((_a3 = active_reaction.deps) != null ? _a3 : active_reaction.deps = []).push(signal);
        var reactions = signal.reactions;
        if (reactions === null) {
          signal.reactions = [active_reaction];
        } else if (!reactions.includes(active_reaction)) {
          reactions.push(active_reaction);
        }
      }
    }
  } else if (is_derived && /** @type {Derived} */
  signal.deps === null && /** @type {Derived} */
  signal.effects === null) {
    var derived2 = (
      /** @type {Derived} */
      signal
    );
    var parent = derived2.parent;
    if (parent !== null && (parent.f & UNOWNED) === 0) {
      derived2.f ^= UNOWNED;
    }
  }
  if (DEV) {
    if (current_async_effect) {
      var tracking = (current_async_effect.f & REACTION_IS_UPDATING) !== 0;
      var was_read = (_b2 = current_async_effect.deps) == null ? void 0 : _b2.includes(signal);
      if (!tracking && !untracking && !was_read) {
        await_reactivity_loss(
          /** @type {string} */
          signal.label
        );
        var trace = get_stack("TracedAt");
        if (trace) console.warn(trace);
      }
    }
    recent_async_deriveds.delete(signal);
  }
  if (is_destroying_effect) {
    if (old_values.has(signal)) {
      return old_values.get(signal);
    }
    if (is_derived) {
      derived2 = /** @type {Derived} */
      signal;
      var value = derived2.v;
      if ((derived2.f & CLEAN) === 0 && derived2.reactions !== null || depends_on_old_values(derived2)) {
        value = execute_derived(derived2);
      }
      old_values.set(derived2, value);
      return value;
    }
  } else if (is_derived) {
    derived2 = /** @type {Derived} */
    signal;
    if (batch_values == null ? void 0 : batch_values.has(derived2)) {
      return batch_values.get(derived2);
    }
    if (is_dirty(derived2)) {
      update_derived(derived2);
    }
  }
  if (batch_values == null ? void 0 : batch_values.has(signal)) {
    return batch_values.get(signal);
  }
  if ((signal.f & ERROR_VALUE) !== 0) {
    throw signal.v;
  }
  return signal.v;
}
function depends_on_old_values(derived2) {
  if (derived2.v === UNINITIALIZED) return true;
  if (derived2.deps === null) return false;
  for (const dep of derived2.deps) {
    if (old_values.has(dep)) {
      return true;
    }
    if ((dep.f & DERIVED) !== 0 && depends_on_old_values(
      /** @type {Derived} */
      dep
    )) {
      return true;
    }
  }
  return false;
}
function untrack(fn) {
  var previous_untracking = untracking;
  try {
    untracking = true;
    return fn();
  } finally {
    untracking = previous_untracking;
  }
}
const STATUS_MASK = -7169;
function set_signal_status(signal, status) {
  signal.f = signal.f & STATUS_MASK | status;
}
function exclude_from_object(obj, keys) {
  var result = {};
  for (var key2 in obj) {
    if (!keys.includes(key2)) {
      result[key2] = obj[key2];
    }
  }
  return result;
}
function deep_read_state(value) {
  if (typeof value !== "object" || !value || value instanceof EventTarget) {
    return;
  }
  if (STATE_SYMBOL in value) {
    deep_read(value);
  } else if (!Array.isArray(value)) {
    for (let key2 in value) {
      const prop2 = value[key2];
      if (typeof prop2 === "object" && prop2 && STATE_SYMBOL in prop2) {
        deep_read(prop2);
      }
    }
  }
}
function deep_read(value, visited = /* @__PURE__ */ new Set()) {
  if (typeof value === "object" && value !== null && // We don't want to traverse DOM elements
  !(value instanceof EventTarget) && !visited.has(value)) {
    visited.add(value);
    if (value instanceof Date) {
      value.getTime();
    }
    for (let key2 in value) {
      try {
        deep_read(value[key2], visited);
      } catch (e) {
      }
    }
    const proto = get_prototype_of(value);
    if (proto !== Object.prototype && proto !== Array.prototype && proto !== Map.prototype && proto !== Set.prototype && proto !== Date.prototype) {
      const descriptors = get_descriptors(proto);
      for (let key2 in descriptors) {
        const get2 = descriptors[key2].get;
        if (get2) {
          try {
            get2.call(value);
          } catch (e) {
          }
        }
      }
    }
  }
}
const all_registered_events = /* @__PURE__ */ new Set();
const root_event_handles = /* @__PURE__ */ new Set();
function create_event(event_name, dom, handler, options2 = {}) {
  function target_handler(event2) {
    if (!options2.capture) {
      handle_event_propagation.call(dom, event2);
    }
    if (!event2.cancelBubble) {
      return without_reactive_context(() => {
        return handler == null ? void 0 : handler.call(this, event2);
      });
    }
  }
  if (event_name.startsWith("pointer") || event_name.startsWith("touch") || event_name === "wheel") {
    queue_micro_task(() => {
      dom.addEventListener(event_name, target_handler, options2);
    });
  } else {
    dom.addEventListener(event_name, target_handler, options2);
  }
  return target_handler;
}
function on(element, type, handler, options2 = {}) {
  var target_handler = create_event(type, element, handler, options2);
  return () => {
    element.removeEventListener(type, target_handler, options2);
  };
}
function event(event_name, dom, handler, capture2, passive) {
  var options2 = { capture: capture2, passive };
  var target_handler = create_event(event_name, dom, handler, options2);
  if (dom === document.body || // @ts-ignore
  dom === window || // @ts-ignore
  dom === document || // Firefox has quirky behavior, it can happen that we still get "canplay" events when the element is already removed
  dom instanceof HTMLMediaElement) {
    teardown(() => {
      dom.removeEventListener(event_name, target_handler, options2);
    });
  }
}
function delegate(events) {
  for (var i = 0; i < events.length; i++) {
    all_registered_events.add(events[i]);
  }
  for (var fn of root_event_handles) {
    fn(events);
  }
}
let last_propagated_event = null;
function handle_event_propagation(event2) {
  var _a3;
  var handler_element = this;
  var owner_document = (
    /** @type {Node} */
    handler_element.ownerDocument
  );
  var event_name = event2.type;
  var path = ((_a3 = event2.composedPath) == null ? void 0 : _a3.call(event2)) || [];
  var current_target = (
    /** @type {null | Element} */
    path[0] || event2.target
  );
  last_propagated_event = event2;
  var path_idx = 0;
  var handled_at = last_propagated_event === event2 && event2.__root;
  if (handled_at) {
    var at_idx = path.indexOf(handled_at);
    if (at_idx !== -1 && (handler_element === document || handler_element === /** @type {any} */
    window)) {
      event2.__root = handler_element;
      return;
    }
    var handler_idx = path.indexOf(handler_element);
    if (handler_idx === -1) {
      return;
    }
    if (at_idx <= handler_idx) {
      path_idx = at_idx;
    }
  }
  current_target = /** @type {Element} */
  path[path_idx] || event2.target;
  if (current_target === handler_element) return;
  define_property(event2, "currentTarget", {
    configurable: true,
    get() {
      return current_target || owner_document;
    }
  });
  var previous_reaction = active_reaction;
  var previous_effect = active_effect;
  set_active_reaction(null);
  set_active_effect(null);
  try {
    var throw_error;
    var other_errors = [];
    while (current_target !== null) {
      var parent_element = current_target.assignedSlot || current_target.parentNode || /** @type {any} */
      current_target.host || null;
      try {
        var delegated = current_target["__" + event_name];
        if (delegated != null && (!/** @type {any} */
        current_target.disabled || // DOM could've been updated already by the time this is reached, so we check this as well
        // -> the target could not have been disabled because it emits the event in the first place
        event2.target === current_target)) {
          if (is_array(delegated)) {
            var [fn, ...data] = delegated;
            fn.apply(current_target, [event2, ...data]);
          } else {
            delegated.call(current_target, event2);
          }
        }
      } catch (error2) {
        if (throw_error) {
          other_errors.push(error2);
        } else {
          throw_error = error2;
        }
      }
      if (event2.cancelBubble || parent_element === handler_element || parent_element === null) {
        break;
      }
      current_target = parent_element;
    }
    if (throw_error) {
      for (let error2 of other_errors) {
        queueMicrotask(() => {
          throw error2;
        });
      }
      throw throw_error;
    }
  } finally {
    event2.__root = handler_element;
    delete event2.currentTarget;
    set_active_reaction(previous_reaction);
    set_active_effect(previous_effect);
  }
}
function head(render_fn) {
  var anchor;
  {
    anchor = document.head.appendChild(create_text());
  }
  try {
    block$1(() => render_fn(anchor), HEAD_EFFECT);
  } finally {
  }
}
function create_fragment_from_html(html2) {
  var elem = document.createElement("template");
  elem.innerHTML = html2.replaceAll("<!>", "<!---->");
  return elem.content;
}
function assign_nodes(start2, end) {
  var effect2 = (
    /** @type {Effect} */
    active_effect
  );
  if (effect2.nodes_start === null) {
    effect2.nodes_start = start2;
    effect2.nodes_end = end;
  }
}
// @__NO_SIDE_EFFECTS__
function from_html(content2, flags2) {
  var is_fragment = (flags2 & TEMPLATE_FRAGMENT) !== 0;
  var use_import_node = (flags2 & TEMPLATE_USE_IMPORT_NODE) !== 0;
  var node;
  var has_start = !content2.startsWith("<!>");
  return () => {
    if (node === void 0) {
      node = create_fragment_from_html(has_start ? content2 : "<!>" + content2);
      if (!is_fragment) node = /** @type {Node} */
      /* @__PURE__ */ get_first_child(node);
    }
    var clone2 = (
      /** @type {TemplateNode} */
      use_import_node || is_firefox ? document.importNode(node, true) : node.cloneNode(true)
    );
    if (is_fragment) {
      var start2 = (
        /** @type {TemplateNode} */
        /* @__PURE__ */ get_first_child(clone2)
      );
      var end = (
        /** @type {TemplateNode} */
        clone2.lastChild
      );
      assign_nodes(start2, end);
    } else {
      assign_nodes(clone2, clone2);
    }
    return clone2;
  };
}
// @__NO_SIDE_EFFECTS__
function from_namespace(content2, flags2, ns = "svg") {
  var has_start = !content2.startsWith("<!>");
  var is_fragment = (flags2 & TEMPLATE_FRAGMENT) !== 0;
  var wrapped = `<${ns}>${has_start ? content2 : "<!>" + content2}</${ns}>`;
  var node;
  return () => {
    if (!node) {
      var fragment = (
        /** @type {DocumentFragment} */
        create_fragment_from_html(wrapped)
      );
      var root2 = (
        /** @type {Element} */
        /* @__PURE__ */ get_first_child(fragment)
      );
      if (is_fragment) {
        node = document.createDocumentFragment();
        while (/* @__PURE__ */ get_first_child(root2)) {
          node.appendChild(
            /** @type {Node} */
            /* @__PURE__ */ get_first_child(root2)
          );
        }
      } else {
        node = /** @type {Element} */
        /* @__PURE__ */ get_first_child(root2);
      }
    }
    var clone2 = (
      /** @type {TemplateNode} */
      node.cloneNode(true)
    );
    if (is_fragment) {
      var start2 = (
        /** @type {TemplateNode} */
        /* @__PURE__ */ get_first_child(clone2)
      );
      var end = (
        /** @type {TemplateNode} */
        clone2.lastChild
      );
      assign_nodes(start2, end);
    } else {
      assign_nodes(clone2, clone2);
    }
    return clone2;
  };
}
// @__NO_SIDE_EFFECTS__
function from_svg(content2, flags2) {
  return /* @__PURE__ */ from_namespace(content2, flags2, "svg");
}
function text(value = "") {
  {
    var t2 = create_text(value + "");
    assign_nodes(t2, t2);
    return t2;
  }
}
function comment$1() {
  var frag = document.createDocumentFragment();
  var start2 = document.createComment("");
  var anchor = create_text();
  frag.append(start2, anchor);
  assign_nodes(start2, anchor);
  return frag;
}
function append(anchor, dom) {
  if (anchor === null) {
    return;
  }
  anchor.before(
    /** @type {Node} */
    dom
  );
}
function is_capture_event(name2) {
  return name2.endsWith("capture") && name2 !== "gotpointercapture" && name2 !== "lostpointercapture";
}
const DELEGATED_EVENTS = [
  "beforeinput",
  "click",
  "change",
  "dblclick",
  "contextmenu",
  "focusin",
  "focusout",
  "input",
  "keydown",
  "keyup",
  "mousedown",
  "mousemove",
  "mouseout",
  "mouseover",
  "mouseup",
  "pointerdown",
  "pointermove",
  "pointerout",
  "pointerover",
  "pointerup",
  "touchend",
  "touchmove",
  "touchstart"
];
function is_delegated(event_name) {
  return DELEGATED_EVENTS.includes(event_name);
}
const ATTRIBUTE_ALIASES = {
  // no `class: 'className'` because we handle that separately
  formnovalidate: "formNoValidate",
  ismap: "isMap",
  nomodule: "noModule",
  playsinline: "playsInline",
  readonly: "readOnly",
  defaultvalue: "defaultValue",
  defaultchecked: "defaultChecked",
  srcobject: "srcObject",
  novalidate: "noValidate",
  allowfullscreen: "allowFullscreen",
  disablepictureinpicture: "disablePictureInPicture",
  disableremoteplayback: "disableRemotePlayback"
};
function normalize_attribute(name2) {
  var _a3;
  name2 = name2.toLowerCase();
  return (_a3 = ATTRIBUTE_ALIASES[name2]) != null ? _a3 : name2;
}
const PASSIVE_EVENTS = ["touchstart", "touchmove"];
function is_passive_event(name2) {
  return PASSIVE_EVENTS.includes(name2);
}
let should_intro = true;
function set_text(text2, value) {
  var _a3;
  var str = value == null ? "" : typeof value === "object" ? value + "" : value;
  if (str !== ((_a3 = text2.__t) != null ? _a3 : text2.__t = text2.nodeValue)) {
    text2.__t = str;
    text2.nodeValue = str + "";
  }
}
function mount(component2, options2) {
  return _mount(component2, options2);
}
const document_listeners = /* @__PURE__ */ new Map();
function _mount(Component, { target, anchor, props = {}, events, context, intro = true }) {
  init_operations();
  var registered_events = /* @__PURE__ */ new Set();
  var event_handle = (events2) => {
    for (var i = 0; i < events2.length; i++) {
      var event_name = events2[i];
      if (registered_events.has(event_name)) continue;
      registered_events.add(event_name);
      var passive = is_passive_event(event_name);
      target.addEventListener(event_name, handle_event_propagation, { passive });
      var n = document_listeners.get(event_name);
      if (n === void 0) {
        document.addEventListener(event_name, handle_event_propagation, { passive });
        document_listeners.set(event_name, 1);
      } else {
        document_listeners.set(event_name, n + 1);
      }
    }
  };
  event_handle(array_from(all_registered_events));
  root_event_handles.add(event_handle);
  var component2 = void 0;
  var unmount2 = component_root(() => {
    var anchor_node = anchor != null ? anchor : target.appendChild(create_text());
    boundary(
      /** @type {TemplateNode} */
      anchor_node,
      {
        pending: () => {
        }
      },
      (anchor_node2) => {
        if (context) {
          push({});
          var ctx = (
            /** @type {ComponentContext} */
            component_context
          );
          ctx.c = context;
        }
        if (events) {
          props.$$events = events;
        }
        should_intro = intro;
        component2 = Component(anchor_node2, props) || {};
        should_intro = true;
        if (context) {
          pop();
        }
      }
    );
    return () => {
      var _a3;
      for (var event_name of registered_events) {
        target.removeEventListener(event_name, handle_event_propagation);
        var n = (
          /** @type {number} */
          document_listeners.get(event_name)
        );
        if (--n === 0) {
          document.removeEventListener(event_name, handle_event_propagation);
          document_listeners.delete(event_name);
        } else {
          document_listeners.set(event_name, n);
        }
      }
      root_event_handles.delete(event_handle);
      if (anchor_node !== anchor) {
        (_a3 = anchor_node.parentNode) == null ? void 0 : _a3.removeChild(anchor_node);
      }
    };
  });
  mounted_components.set(component2, unmount2);
  return component2;
}
let mounted_components = /* @__PURE__ */ new WeakMap();
function unmount(component2, options2) {
  const fn = mounted_components.get(component2);
  if (fn) {
    mounted_components.delete(component2);
    return fn(options2);
  }
  if (DEV) {
    if (STATE_SYMBOL in component2) {
      state_proxy_unmount();
    } else {
      lifecycle_double_unmount();
    }
  }
  return Promise.resolve();
}
class BranchManager {
  /**
   * @param {TemplateNode} anchor
   * @param {boolean} transition
   */
  constructor(anchor, transition2 = true) {
    /** @type {TemplateNode} */
    __publicField(this, "anchor");
    /** @type {Map<Batch, Key>} */
    __privateAdd(this, _batches, /* @__PURE__ */ new Map());
    /** @type {Map<Key, Effect>} */
    __privateAdd(this, _onscreen, /* @__PURE__ */ new Map());
    /** @type {Map<Key, Branch>} */
    __privateAdd(this, _offscreen, /* @__PURE__ */ new Map());
    /**
     * Whether to pause (i.e. outro) on change, or destroy immediately.
     * This is necessary for `<svelte:element>`
     */
    __privateAdd(this, _transition, true);
    __privateAdd(this, _commit, () => {
      var batch = (
        /** @type {Batch} */
        current_batch
      );
      if (!__privateGet(this, _batches).has(batch)) return;
      var key2 = (
        /** @type {Key} */
        __privateGet(this, _batches).get(batch)
      );
      var onscreen = __privateGet(this, _onscreen).get(key2);
      if (onscreen) {
        resume_effect(onscreen);
      } else {
        var offscreen = __privateGet(this, _offscreen).get(key2);
        if (offscreen) {
          __privateGet(this, _onscreen).set(key2, offscreen.effect);
          __privateGet(this, _offscreen).delete(key2);
          offscreen.fragment.lastChild.remove();
          this.anchor.before(offscreen.fragment);
          onscreen = offscreen.effect;
        }
      }
      for (const [b2, k2] of __privateGet(this, _batches)) {
        __privateGet(this, _batches).delete(b2);
        if (b2 === batch) {
          break;
        }
        const offscreen2 = __privateGet(this, _offscreen).get(k2);
        if (offscreen2) {
          destroy_effect(offscreen2.effect);
          __privateGet(this, _offscreen).delete(k2);
        }
      }
      for (const [k2, effect2] of __privateGet(this, _onscreen)) {
        if (k2 === key2) continue;
        const on_destroy = () => {
          const keys = Array.from(__privateGet(this, _batches).values());
          if (keys.includes(k2)) {
            var fragment = document.createDocumentFragment();
            move_effect(effect2, fragment);
            fragment.append(create_text());
            __privateGet(this, _offscreen).set(k2, { effect: effect2, fragment });
          } else {
            destroy_effect(effect2);
          }
          __privateGet(this, _onscreen).delete(k2);
        };
        if (__privateGet(this, _transition) || !onscreen) {
          pause_effect(effect2, on_destroy, false);
        } else {
          on_destroy();
        }
      }
    });
    this.anchor = anchor;
    __privateSet(this, _transition, transition2);
  }
  /**
   *
   * @param {any} key
   * @param {null | ((target: TemplateNode) => void)} fn
   */
  ensure(key2, fn) {
    var batch = (
      /** @type {Batch} */
      current_batch
    );
    var defer = should_defer_append();
    if (fn && !__privateGet(this, _onscreen).has(key2) && !__privateGet(this, _offscreen).has(key2)) {
      if (defer) {
        var fragment = document.createDocumentFragment();
        var target = create_text();
        fragment.append(target);
        __privateGet(this, _offscreen).set(key2, {
          effect: branch(() => fn(target)),
          fragment
        });
      } else {
        __privateGet(this, _onscreen).set(
          key2,
          branch(() => fn(this.anchor))
        );
      }
    }
    __privateGet(this, _batches).set(batch, key2);
    if (defer) {
      for (const [k2, effect2] of __privateGet(this, _onscreen)) {
        if (k2 === key2) {
          batch.skipped_effects.delete(effect2);
        } else {
          batch.skipped_effects.add(effect2);
        }
      }
      for (const [k2, branch2] of __privateGet(this, _offscreen)) {
        if (k2 === key2) {
          batch.skipped_effects.delete(branch2.effect);
        } else {
          batch.skipped_effects.add(branch2.effect);
        }
      }
      batch.add_callback(__privateGet(this, _commit));
    } else {
      __privateGet(this, _commit).call(this);
    }
  }
}
_batches = new WeakMap();
_onscreen = new WeakMap();
_offscreen = new WeakMap();
_transition = new WeakMap();
_commit = new WeakMap();
function snippet(node, get_snippet, ...args) {
  var branches = new BranchManager(node);
  block$1(() => {
    var _a3;
    const snippet2 = (_a3 = get_snippet()) != null ? _a3 : null;
    if (DEV && snippet2 == null) {
      invalid_snippet();
    }
    branches.ensure(snippet2, snippet2 && ((anchor) => snippet2(anchor, ...args)));
  }, EFFECT_TRANSPARENT);
}
if (DEV) {
  let throw_rune_error = function(rune) {
    if (!(rune in globalThis)) {
      let value;
      Object.defineProperty(globalThis, rune, {
        configurable: true,
        // eslint-disable-next-line getter-return
        get: () => {
          if (value !== void 0) {
            return value;
          }
          rune_outside_svelte(rune);
        },
        set: (v2) => {
          value = v2;
        }
      });
    }
  };
  throw_rune_error("$state");
  throw_rune_error("$effect");
  throw_rune_error("$derived");
  throw_rune_error("$inspect");
  throw_rune_error("$props");
  throw_rune_error("$bindable");
}
function onMount(fn) {
  if (component_context === null) {
    lifecycle_outside_component("onMount");
  }
  {
    user_effect(() => {
      const cleanup = untrack(fn);
      if (typeof cleanup === "function") return (
        /** @type {() => void} */
        cleanup
      );
    });
  }
}
function onDestroy(fn) {
  if (component_context === null) {
    lifecycle_outside_component("onDestroy");
  }
  onMount(() => () => untrack(fn));
}
function create_custom_event(type, detail, { bubbles = false, cancelable = false } = {}) {
  return new CustomEvent(type, { detail, bubbles, cancelable });
}
function createEventDispatcher() {
  const active_component_context = component_context;
  if (active_component_context === null) {
    lifecycle_outside_component("createEventDispatcher");
  }
  return (type, detail, options2) => {
    var _a3;
    const events = (
      /** @type {Record<string, Function | Function[]>} */
      (_a3 = active_component_context.s.$$events) == null ? void 0 : _a3[
        /** @type {string} */
        type
      ]
    );
    if (events) {
      const callbacks = is_array(events) ? events.slice() : [events];
      const event2 = create_custom_event(
        /** @type {string} */
        type,
        detail,
        options2
      );
      for (const fn of callbacks) {
        fn.call(active_component_context.x, event2);
      }
      return !event2.defaultPrevented;
    }
    return true;
  };
}
function if_block(node, fn, elseif = false) {
  var branches = new BranchManager(node);
  var flags2 = elseif ? EFFECT_TRANSPARENT : 0;
  function update_branch(condition, fn2) {
    branches.ensure(condition, fn2);
  }
  block$1(() => {
    var has_branch = false;
    fn((fn2, flag = true) => {
      has_branch = true;
      update_branch(flag, fn2);
    });
    if (!has_branch) {
      update_branch(false, null);
    }
  }, flags2);
}
function key$1(node, get_key, render_fn) {
  var branches = new BranchManager(node);
  block$1(() => {
    var key2 = get_key();
    branches.ensure(key2, render_fn);
  });
}
function css_props(element, get_styles) {
  render_effect(() => {
    var styles = get_styles();
    for (var key2 in styles) {
      var value = styles[key2];
      if (value) {
        element.style.setProperty(key2, value);
      } else {
        element.style.removeProperty(key2);
      }
    }
  });
}
function index$1(_2, i) {
  return i;
}
function pause_effects(state2, items, controlled_anchor) {
  var items_map = state2.items;
  var transitions = [];
  var length = items.length;
  for (var i = 0; i < length; i++) {
    pause_children(items[i].e, transitions, true);
  }
  var is_controlled = length > 0 && transitions.length === 0 && controlled_anchor !== null;
  if (is_controlled) {
    var parent_node = (
      /** @type {Element} */
      /** @type {Element} */
      controlled_anchor.parentNode
    );
    clear_text_content(parent_node);
    parent_node.append(
      /** @type {Element} */
      controlled_anchor
    );
    items_map.clear();
    link(state2, items[0].prev, items[length - 1].next);
  }
  run_out_transitions(transitions, () => {
    for (var i2 = 0; i2 < length; i2++) {
      var item = items[i2];
      if (!is_controlled) {
        items_map.delete(item.k);
        link(state2, item.prev, item.next);
      }
      destroy_effect(item.e, !is_controlled);
    }
  });
}
function each(node, flags2, get_collection, get_key, render_fn, fallback_fn = null) {
  var anchor = node;
  var state2 = { flags: flags2, items: /* @__PURE__ */ new Map(), first: null };
  var is_controlled = (flags2 & EACH_IS_CONTROLLED) !== 0;
  if (is_controlled) {
    var parent_node = (
      /** @type {Element} */
      node
    );
    anchor = parent_node.appendChild(create_text());
  }
  var fallback2 = null;
  var was_empty = false;
  var offscreen_items = /* @__PURE__ */ new Map();
  var each_array = /* @__PURE__ */ derived_safe_equal(() => {
    var collection = get_collection();
    return is_array(collection) ? collection : collection == null ? [] : array_from(collection);
  });
  var array2;
  var each_effect;
  function commit() {
    reconcile(
      each_effect,
      array2,
      state2,
      offscreen_items,
      anchor,
      render_fn,
      flags2,
      get_key,
      get_collection
    );
    if (fallback_fn !== null) {
      if (array2.length === 0) {
        if (fallback2) {
          resume_effect(fallback2);
        } else {
          fallback2 = branch(() => fallback_fn(anchor));
        }
      } else if (fallback2 !== null) {
        pause_effect(fallback2, () => {
          fallback2 = null;
        });
      }
    }
  }
  block$1(() => {
    var _a3;
    each_effect != null ? each_effect : each_effect = /** @type {Effect} */
    active_effect;
    array2 = /** @type {V[]} */
    get$3(each_array);
    var length = array2.length;
    if (was_empty && length === 0) {
      return;
    }
    was_empty = length === 0;
    var item, i, value, key2;
    {
      if (should_defer_append()) {
        var keys = /* @__PURE__ */ new Set();
        var batch = (
          /** @type {Batch} */
          current_batch
        );
        for (i = 0; i < length; i += 1) {
          value = array2[i];
          key2 = get_key(value, i);
          var existing = (_a3 = state2.items.get(key2)) != null ? _a3 : offscreen_items.get(key2);
          if (existing) {
            if ((flags2 & (EACH_ITEM_REACTIVE | EACH_INDEX_REACTIVE)) !== 0) {
              update_item(existing, value, i, flags2);
            }
          } else {
            item = create_item(
              null,
              state2,
              null,
              null,
              value,
              key2,
              i,
              render_fn,
              flags2,
              get_collection,
              true
            );
            offscreen_items.set(key2, item);
          }
          keys.add(key2);
        }
        for (const [key3, item2] of state2.items) {
          if (!keys.has(key3)) {
            batch.skipped_effects.add(item2.e);
          }
        }
        batch.add_callback(commit);
      } else {
        commit();
      }
    }
    get$3(each_array);
  });
}
function reconcile(each_effect, array2, state2, offscreen_items, anchor, render_fn, flags2, get_key, get_collection) {
  var _a3, _b2, _c2, _d2;
  var is_animated = (flags2 & EACH_IS_ANIMATED) !== 0;
  var should_update = (flags2 & (EACH_ITEM_REACTIVE | EACH_INDEX_REACTIVE)) !== 0;
  var length = array2.length;
  var items = state2.items;
  var first = state2.first;
  var current = first;
  var seen;
  var prev = null;
  var to_animate;
  var matched = [];
  var stashed = [];
  var value;
  var key2;
  var item;
  var i;
  if (is_animated) {
    for (i = 0; i < length; i += 1) {
      value = array2[i];
      key2 = get_key(value, i);
      item = items.get(key2);
      if (item !== void 0) {
        (_a3 = item.a) == null ? void 0 : _a3.measure();
        (to_animate != null ? to_animate : to_animate = /* @__PURE__ */ new Set()).add(item);
      }
    }
  }
  for (i = 0; i < length; i += 1) {
    value = array2[i];
    key2 = get_key(value, i);
    item = items.get(key2);
    if (item === void 0) {
      var pending = offscreen_items.get(key2);
      if (pending !== void 0) {
        offscreen_items.delete(key2);
        items.set(key2, pending);
        var next = prev ? prev.next : current;
        link(state2, prev, pending);
        link(state2, pending, next);
        move(pending, next, anchor);
        prev = pending;
      } else {
        var child_anchor = current ? (
          /** @type {TemplateNode} */
          current.e.nodes_start
        ) : anchor;
        prev = create_item(
          child_anchor,
          state2,
          prev,
          prev === null ? state2.first : prev.next,
          value,
          key2,
          i,
          render_fn,
          flags2,
          get_collection
        );
      }
      items.set(key2, prev);
      matched = [];
      stashed = [];
      current = prev.next;
      continue;
    }
    if (should_update) {
      update_item(item, value, i, flags2);
    }
    if ((item.e.f & INERT) !== 0) {
      resume_effect(item.e);
      if (is_animated) {
        (_b2 = item.a) == null ? void 0 : _b2.unfix();
        (to_animate != null ? to_animate : to_animate = /* @__PURE__ */ new Set()).delete(item);
      }
    }
    if (item !== current) {
      if (seen !== void 0 && seen.has(item)) {
        if (matched.length < stashed.length) {
          var start2 = stashed[0];
          var j2;
          prev = start2.prev;
          var a = matched[0];
          var b2 = matched[matched.length - 1];
          for (j2 = 0; j2 < matched.length; j2 += 1) {
            move(matched[j2], start2, anchor);
          }
          for (j2 = 0; j2 < stashed.length; j2 += 1) {
            seen.delete(stashed[j2]);
          }
          link(state2, a.prev, b2.next);
          link(state2, prev, a);
          link(state2, b2, start2);
          current = start2;
          prev = b2;
          i -= 1;
          matched = [];
          stashed = [];
        } else {
          seen.delete(item);
          move(item, current, anchor);
          link(state2, item.prev, item.next);
          link(state2, item, prev === null ? state2.first : prev.next);
          link(state2, prev, item);
          prev = item;
        }
        continue;
      }
      matched = [];
      stashed = [];
      while (current !== null && current.k !== key2) {
        if ((current.e.f & INERT) === 0) {
          (seen != null ? seen : seen = /* @__PURE__ */ new Set()).add(current);
        }
        stashed.push(current);
        current = current.next;
      }
      if (current === null) {
        continue;
      }
      item = current;
    }
    matched.push(item);
    prev = item;
    current = item.next;
  }
  if (current !== null || seen !== void 0) {
    var to_destroy = seen === void 0 ? [] : array_from(seen);
    while (current !== null) {
      if ((current.e.f & INERT) === 0) {
        to_destroy.push(current);
      }
      current = current.next;
    }
    var destroy_length = to_destroy.length;
    if (destroy_length > 0) {
      var controlled_anchor = (flags2 & EACH_IS_CONTROLLED) !== 0 && length === 0 ? anchor : null;
      if (is_animated) {
        for (i = 0; i < destroy_length; i += 1) {
          (_c2 = to_destroy[i].a) == null ? void 0 : _c2.measure();
        }
        for (i = 0; i < destroy_length; i += 1) {
          (_d2 = to_destroy[i].a) == null ? void 0 : _d2.fix();
        }
      }
      pause_effects(state2, to_destroy, controlled_anchor);
    }
  }
  if (is_animated) {
    queue_micro_task(() => {
      var _a4;
      if (to_animate === void 0) return;
      for (item of to_animate) {
        (_a4 = item.a) == null ? void 0 : _a4.apply();
      }
    });
  }
  each_effect.first = state2.first && state2.first.e;
  each_effect.last = prev && prev.e;
  for (var unused of offscreen_items.values()) {
    destroy_effect(unused.e);
  }
  offscreen_items.clear();
}
function update_item(item, value, index2, type) {
  if ((type & EACH_ITEM_REACTIVE) !== 0) {
    internal_set(item.v, value);
  }
  if ((type & EACH_INDEX_REACTIVE) !== 0) {
    internal_set(
      /** @type {Value<number>} */
      item.i,
      index2
    );
  } else {
    item.i = index2;
  }
}
function create_item(anchor, state2, prev, next, value, key2, index2, render_fn, flags2, get_collection, deferred2) {
  var reactive = (flags2 & EACH_ITEM_REACTIVE) !== 0;
  var mutable = (flags2 & EACH_ITEM_IMMUTABLE) === 0;
  var v2 = reactive ? mutable ? /* @__PURE__ */ mutable_source(value, false, false) : source(value) : value;
  var i = (flags2 & EACH_INDEX_REACTIVE) === 0 ? index2 : source(index2);
  if (DEV && reactive) {
    v2.trace = () => {
      var collection_index = typeof i === "number" ? index2 : i.v;
      get_collection()[collection_index];
    };
  }
  var item = {
    i,
    v: v2,
    k: key2,
    a: null,
    // @ts-expect-error
    e: null,
    prev,
    next
  };
  try {
    if (anchor === null) {
      var fragment = document.createDocumentFragment();
      fragment.append(anchor = create_text());
    }
    item.e = branch(() => render_fn(
      /** @type {Node} */
      anchor,
      v2,
      i,
      get_collection
    ), hydrating);
    item.e.prev = prev && prev.e;
    item.e.next = next && next.e;
    if (prev === null) {
      if (!deferred2) {
        state2.first = item;
      }
    } else {
      prev.next = item;
      prev.e.next = item.e;
    }
    if (next !== null) {
      next.prev = item;
      next.e.prev = item.e;
    }
    return item;
  } finally {
  }
}
function move(item, next, anchor) {
  var end = item.next ? (
    /** @type {TemplateNode} */
    item.next.e.nodes_start
  ) : anchor;
  var dest = next ? (
    /** @type {TemplateNode} */
    next.e.nodes_start
  ) : anchor;
  var node = (
    /** @type {TemplateNode} */
    item.e.nodes_start
  );
  while (node !== null && node !== end) {
    var next_node = (
      /** @type {TemplateNode} */
      /* @__PURE__ */ get_next_sibling(node)
    );
    dest.before(node);
    node = next_node;
  }
}
function link(state2, prev, next) {
  if (prev === null) {
    state2.first = next;
  } else {
    prev.next = next;
    prev.e.next = next && next.e;
  }
  if (next !== null) {
    next.prev = prev;
    next.e.prev = prev && prev.e;
  }
}
function html(node, get_value, svg2 = false, mathml = false, skip_warning = false) {
  var anchor = node;
  var value = "";
  template_effect(() => {
    var _a3;
    var effect2 = (
      /** @type {Effect} */
      active_effect
    );
    if (value === (value = (_a3 = get_value()) != null ? _a3 : "")) {
      return;
    }
    if (effect2.nodes_start !== null) {
      remove_effect_dom(
        effect2.nodes_start,
        /** @type {TemplateNode} */
        effect2.nodes_end
      );
      effect2.nodes_start = effect2.nodes_end = null;
    }
    if (value === "") return;
    var html2 = value + "";
    if (svg2) html2 = `<svg>${html2}</svg>`;
    else if (mathml) html2 = `<math>${html2}</math>`;
    var node2 = create_fragment_from_html(html2);
    if (svg2 || mathml) {
      node2 = /** @type {Element} */
      /* @__PURE__ */ get_first_child(node2);
    }
    assign_nodes(
      /** @type {TemplateNode} */
      /* @__PURE__ */ get_first_child(node2),
      /** @type {TemplateNode} */
      node2.lastChild
    );
    if (svg2 || mathml) {
      while (/* @__PURE__ */ get_first_child(node2)) {
        anchor.before(
          /** @type {Node} */
          /* @__PURE__ */ get_first_child(node2)
        );
      }
    } else {
      anchor.before(node2);
    }
  });
}
function component(node, get_component, render_fn) {
  var branches = new BranchManager(node);
  block$1(() => {
    var _a3;
    var component2 = (_a3 = get_component()) != null ? _a3 : null;
    branches.ensure(component2, component2 && ((target) => render_fn(target, component2)));
  }, EFFECT_TRANSPARENT);
}
function action(dom, action2, get_value) {
  effect(() => {
    var payload = untrack(() => action2(dom, get_value == null ? void 0 : get_value()) || {});
    if (get_value && (payload == null ? void 0 : payload.update)) {
      var inited2 = false;
      var prev = (
        /** @type {any} */
        {}
      );
      render_effect(() => {
        var value = get_value();
        deep_read_state(value);
        if (inited2 && safe_not_equal(prev, value)) {
          prev = value;
          payload.update(value);
        }
      });
      inited2 = true;
    }
    if (payload == null ? void 0 : payload.destroy) {
      return () => (
        /** @type {Function} */
        payload.destroy()
      );
    }
  });
}
function attach(node, get_fn) {
  var fn = void 0;
  var e;
  block$1(() => {
    if (fn !== (fn = get_fn())) {
      if (e) {
        destroy_effect(e);
        e = null;
      }
      if (fn) {
        e = branch(() => {
          effect(() => (
            /** @type {(node: Element) => void} */
            fn(node)
          ));
        });
      }
    }
  });
}
function r(e) {
  var t2, f, n = "";
  if ("string" == typeof e || "number" == typeof e) n += e;
  else if ("object" == typeof e) if (Array.isArray(e)) {
    var o = e.length;
    for (t2 = 0; t2 < o; t2++) e[t2] && (f = r(e[t2])) && (n && (n += " "), n += f);
  } else for (f in e) e[f] && (n && (n += " "), n += f);
  return n;
}
function clsx$1() {
  for (var e, t2, f = 0, n = "", o = arguments.length; f < o; f++) (e = arguments[f]) && (t2 = r(e)) && (n && (n += " "), n += t2);
  return n;
}
function clsx(value) {
  if (typeof value === "object") {
    return clsx$1(value);
  } else {
    return value != null ? value : "";
  }
}
const whitespace = [..." 	\n\r\f \v\uFEFF"];
function to_class(value, hash, directives) {
  var classname = value == null ? "" : "" + value;
  if (hash) {
    classname = classname ? classname + " " + hash : hash;
  }
  if (directives) {
    for (var key2 in directives) {
      if (directives[key2]) {
        classname = classname ? classname + " " + key2 : key2;
      } else if (classname.length) {
        var len = key2.length;
        var a = 0;
        while ((a = classname.indexOf(key2, a)) >= 0) {
          var b2 = a + len;
          if ((a === 0 || whitespace.includes(classname[a - 1])) && (b2 === classname.length || whitespace.includes(classname[b2]))) {
            classname = (a === 0 ? "" : classname.substring(0, a)) + classname.substring(b2 + 1);
          } else {
            a = b2;
          }
        }
      }
    }
  }
  return classname === "" ? null : classname;
}
function append_styles(styles, important = false) {
  var separator2 = important ? " !important;" : ";";
  var css = "";
  for (var key2 in styles) {
    var value = styles[key2];
    if (value != null && value !== "") {
      css += " " + key2 + ": " + value + separator2;
    }
  }
  return css;
}
function to_css_name(name2) {
  if (name2[0] !== "-" || name2[1] !== "-") {
    return name2.toLowerCase();
  }
  return name2;
}
function to_style(value, styles) {
  if (styles) {
    var new_style = "";
    var normal_styles;
    var important_styles;
    if (Array.isArray(styles)) {
      normal_styles = styles[0];
      important_styles = styles[1];
    } else {
      normal_styles = styles;
    }
    if (value) {
      value = String(value).replaceAll(/\s*\/\*.*?\*\/\s*/g, "").trim();
      var in_str = false;
      var in_apo = 0;
      var in_comment = false;
      var reserved_names = [];
      if (normal_styles) {
        reserved_names.push(...Object.keys(normal_styles).map(to_css_name));
      }
      if (important_styles) {
        reserved_names.push(...Object.keys(important_styles).map(to_css_name));
      }
      var start_index = 0;
      var name_index = -1;
      const len = value.length;
      for (var i = 0; i < len; i++) {
        var c = value[i];
        if (in_comment) {
          if (c === "/" && value[i - 1] === "*") {
            in_comment = false;
          }
        } else if (in_str) {
          if (in_str === c) {
            in_str = false;
          }
        } else if (c === "/" && value[i + 1] === "*") {
          in_comment = true;
        } else if (c === '"' || c === "'") {
          in_str = c;
        } else if (c === "(") {
          in_apo++;
        } else if (c === ")") {
          in_apo--;
        }
        if (!in_comment && in_str === false && in_apo === 0) {
          if (c === ":" && name_index === -1) {
            name_index = i;
          } else if (c === ";" || i === len - 1) {
            if (name_index !== -1) {
              var name2 = to_css_name(value.substring(start_index, name_index).trim());
              if (!reserved_names.includes(name2)) {
                if (c !== ";") {
                  i++;
                }
                var property = value.substring(start_index, i).trim();
                new_style += " " + property + ";";
              }
            }
            start_index = i + 1;
            name_index = -1;
          }
        }
      }
    }
    if (normal_styles) {
      new_style += append_styles(normal_styles);
    }
    if (important_styles) {
      new_style += append_styles(important_styles, true);
    }
    new_style = new_style.trim();
    return new_style === "" ? null : new_style;
  }
  return value == null ? null : String(value);
}
function set_class(dom, is_html, value, hash, prev_classes, next_classes) {
  var prev = dom.__className;
  if (prev !== value || prev === void 0) {
    var next_class_name = to_class(value, hash, next_classes);
    {
      if (next_class_name == null) {
        dom.removeAttribute("class");
      } else if (is_html) {
        dom.className = next_class_name;
      } else {
        dom.setAttribute("class", next_class_name);
      }
    }
    dom.__className = value;
  } else if (next_classes && prev_classes !== next_classes) {
    for (var key2 in next_classes) {
      var is_present = !!next_classes[key2];
      if (prev_classes == null || is_present !== !!prev_classes[key2]) {
        dom.classList.toggle(key2, is_present);
      }
    }
  }
  return next_classes;
}
function update_styles(dom, prev = {}, next, priority) {
  for (var key2 in next) {
    var value = next[key2];
    if (prev[key2] !== value) {
      if (next[key2] == null) {
        dom.style.removeProperty(key2);
      } else {
        dom.style.setProperty(key2, value, priority);
      }
    }
  }
}
function set_style(dom, value, prev_styles, next_styles) {
  var prev = dom.__style;
  if (prev !== value) {
    var next_style_attr = to_style(value, next_styles);
    {
      if (next_style_attr == null) {
        dom.removeAttribute("style");
      } else {
        dom.style.cssText = next_style_attr;
      }
    }
    dom.__style = value;
  } else if (next_styles) {
    if (Array.isArray(next_styles)) {
      update_styles(dom, prev_styles == null ? void 0 : prev_styles[0], next_styles[0]);
      update_styles(dom, prev_styles == null ? void 0 : prev_styles[1], next_styles[1], "important");
    } else {
      update_styles(dom, prev_styles, next_styles);
    }
  }
  return next_styles;
}
function select_option(select2, value, mounting = false) {
  if (select2.multiple) {
    if (value == void 0) {
      return;
    }
    if (!is_array(value)) {
      return select_multiple_invalid_value();
    }
    for (var option of select2.options) {
      option.selected = value.includes(get_option_value(option));
    }
    return;
  }
  for (option of select2.options) {
    var option_value = get_option_value(option);
    if (is(option_value, value)) {
      option.selected = true;
      return;
    }
  }
  if (!mounting || value !== void 0) {
    select2.selectedIndex = -1;
  }
}
function init_select(select2) {
  var observer = new MutationObserver(() => {
    select_option(select2, select2.__value);
  });
  observer.observe(select2, {
    // Listen to option element changes
    childList: true,
    subtree: true,
    // because of <optgroup>
    // Listen to option element value attribute changes
    // (doesn't get notified of select value changes,
    // because that property is not reflected as an attribute)
    attributes: true,
    attributeFilter: ["value"]
  });
  teardown(() => {
    observer.disconnect();
  });
}
function get_option_value(option) {
  if ("__value" in option) {
    return option.__value;
  } else {
    return option.value;
  }
}
const CLASS = Symbol("class");
const STYLE = Symbol("style");
const IS_CUSTOM_ELEMENT = Symbol("is custom element");
const IS_HTML = Symbol("is html");
function set_value(element, value) {
  var attributes = get_attributes(element);
  if (attributes.value === (attributes.value = // treat null and undefined the same for the initial value
  value != null ? value : void 0) || // @ts-expect-error
  // `progress` elements always need their value set when it's `0`
  element.value === value && (value !== 0 || element.nodeName !== "PROGRESS")) {
    return;
  }
  element.value = value != null ? value : "";
}
function set_checked(element, checked) {
  var attributes = get_attributes(element);
  if (attributes.checked === (attributes.checked = // treat null and undefined the same for the initial value
  checked != null ? checked : void 0)) {
    return;
  }
  element.checked = checked;
}
function set_selected(element, selected) {
  if (selected) {
    if (!element.hasAttribute("selected")) {
      element.setAttribute("selected", "");
    }
  } else {
    element.removeAttribute("selected");
  }
}
function set_attribute(element, attribute, value, skip_warning) {
  var attributes = get_attributes(element);
  if (attributes[attribute] === (attributes[attribute] = value)) return;
  if (attribute === "loading") {
    element[LOADING_ATTR_SYMBOL] = value;
  }
  if (value == null) {
    element.removeAttribute(attribute);
  } else if (typeof value !== "string" && get_setters(element).includes(attribute)) {
    element[attribute] = value;
  } else {
    element.setAttribute(attribute, value);
  }
}
function set_attributes(element, prev, next, css_hash, should_remove_defaults = false, skip_warning = false) {
  var _a3;
  var attributes = get_attributes(element);
  var is_custom_element = attributes[IS_CUSTOM_ELEMENT];
  var preserve_attribute_case = !attributes[IS_HTML];
  var current = prev || {};
  var is_option_element = element.tagName === "OPTION";
  for (var key2 in prev) {
    if (!(key2 in next)) {
      next[key2] = null;
    }
  }
  if (next.class) {
    next.class = clsx(next.class);
  } else if (css_hash || next[CLASS]) {
    next.class = null;
  }
  if (next[STYLE]) {
    (_a3 = next.style) != null ? _a3 : next.style = null;
  }
  var setters = get_setters(element);
  for (const key3 in next) {
    let value = next[key3];
    if (is_option_element && key3 === "value" && value == null) {
      element.value = element.__value = "";
      current[key3] = value;
      continue;
    }
    if (key3 === "class") {
      var is_html = element.namespaceURI === "http://www.w3.org/1999/xhtml";
      set_class(element, is_html, value, css_hash, prev == null ? void 0 : prev[CLASS], next[CLASS]);
      current[key3] = value;
      current[CLASS] = next[CLASS];
      continue;
    }
    if (key3 === "style") {
      set_style(element, value, prev == null ? void 0 : prev[STYLE], next[STYLE]);
      current[key3] = value;
      current[STYLE] = next[STYLE];
      continue;
    }
    var prev_value = current[key3];
    if (value === prev_value && !(value === void 0 && element.hasAttribute(key3))) {
      continue;
    }
    current[key3] = value;
    var prefix = key3[0] + key3[1];
    if (prefix === "$$") continue;
    if (prefix === "on") {
      const opts = {};
      const event_handle_key = "$$" + key3;
      let event_name = key3.slice(2);
      var delegated = is_delegated(event_name);
      if (is_capture_event(event_name)) {
        event_name = event_name.slice(0, -7);
        opts.capture = true;
      }
      if (!delegated && prev_value) {
        if (value != null) continue;
        element.removeEventListener(event_name, current[event_handle_key], opts);
        current[event_handle_key] = null;
      }
      if (value != null) {
        if (!delegated) {
          let handle = function(evt) {
            current[key3].call(this, evt);
          };
          current[event_handle_key] = create_event(event_name, element, handle, opts);
        } else {
          element[`__${event_name}`] = value;
          delegate([event_name]);
        }
      } else if (delegated) {
        element[`__${event_name}`] = void 0;
      }
    } else if (key3 === "style") {
      set_attribute(element, key3, value);
    } else if (key3 === "autofocus") {
      autofocus(
        /** @type {HTMLElement} */
        element,
        Boolean(value)
      );
    } else if (!is_custom_element && (key3 === "__value" || key3 === "value" && value != null)) {
      element.value = element.__value = value;
    } else if (key3 === "selected" && is_option_element) {
      set_selected(
        /** @type {HTMLOptionElement} */
        element,
        value
      );
    } else {
      var name2 = key3;
      if (!preserve_attribute_case) {
        name2 = normalize_attribute(name2);
      }
      var is_default = name2 === "defaultValue" || name2 === "defaultChecked";
      if (value == null && !is_custom_element && !is_default) {
        attributes[key3] = null;
        if (name2 === "value" || name2 === "checked") {
          let input = (
            /** @type {HTMLInputElement} */
            element
          );
          const use_default = prev === void 0;
          if (name2 === "value") {
            let previous = input.defaultValue;
            input.removeAttribute(name2);
            input.defaultValue = previous;
            input.value = input.__value = use_default ? previous : null;
          } else {
            let previous = input.defaultChecked;
            input.removeAttribute(name2);
            input.defaultChecked = previous;
            input.checked = use_default ? previous : false;
          }
        } else {
          element.removeAttribute(key3);
        }
      } else if (is_default || setters.includes(name2) && (is_custom_element || typeof value !== "string")) {
        element[name2] = value;
        if (name2 in attributes) attributes[name2] = UNINITIALIZED;
      } else if (typeof value !== "function") {
        set_attribute(element, name2, value);
      }
    }
  }
  return current;
}
function attribute_effect(element, fn, sync = [], async = [], css_hash, should_remove_defaults = false, skip_warning = false) {
  flatten$1(sync, async, (values) => {
    var prev = void 0;
    var effects = {};
    var is_select = element.nodeName === "SELECT";
    var inited2 = false;
    block$1(() => {
      var next = fn(...values.map(get$3));
      var current = set_attributes(
        element,
        prev,
        next,
        css_hash,
        should_remove_defaults,
        skip_warning
      );
      if (inited2 && is_select && "value" in next) {
        select_option(
          /** @type {HTMLSelectElement} */
          element,
          next.value
        );
      }
      for (let symbol of Object.getOwnPropertySymbols(effects)) {
        if (!next[symbol]) destroy_effect(effects[symbol]);
      }
      for (let symbol of Object.getOwnPropertySymbols(next)) {
        var n = next[symbol];
        if (symbol.description === ATTACHMENT_KEY && (!prev || n !== prev[symbol])) {
          if (effects[symbol]) destroy_effect(effects[symbol]);
          effects[symbol] = branch(() => attach(element, () => n));
        }
        current[symbol] = n;
      }
      prev = current;
    });
    if (is_select) {
      var select2 = (
        /** @type {HTMLSelectElement} */
        element
      );
      effect(() => {
        select_option(
          select2,
          /** @type {Record<string | symbol, any>} */
          prev.value,
          true
        );
        init_select(select2);
      });
    }
    inited2 = true;
  });
}
function get_attributes(element) {
  var _a3;
  return (
    /** @type {Record<string | symbol, unknown>} **/
    // @ts-expect-error
    (_a3 = element.__attributes) != null ? _a3 : element.__attributes = {
      [IS_CUSTOM_ELEMENT]: element.nodeName.includes("-"),
      [IS_HTML]: element.namespaceURI === NAMESPACE_HTML
    }
  );
}
var setters_cache = /* @__PURE__ */ new Map();
function get_setters(element) {
  var cache_key = element.getAttribute("is") || element.nodeName;
  var setters = setters_cache.get(cache_key);
  if (setters) return setters;
  setters_cache.set(cache_key, setters = []);
  var descriptors;
  var proto = element;
  var element_proto = Element.prototype;
  while (element_proto !== proto) {
    descriptors = get_descriptors(proto);
    for (var key2 in descriptors) {
      if (descriptors[key2].set) {
        setters.push(key2);
      }
    }
    proto = get_prototype_of(proto);
  }
  return setters;
}
const now$1 = () => performance.now();
const raf = {
  // don't access requestAnimationFrame eagerly outside method
  // this allows basic testing of user code without JSDOM
  // bunder will eval and remove ternary when the user's app is built
  tick: (
    /** @param {any} _ */
    (_2) => requestAnimationFrame(_2)
  ),
  now: () => now$1(),
  tasks: /* @__PURE__ */ new Set()
};
function run_tasks() {
  const now2 = raf.now();
  raf.tasks.forEach((task) => {
    if (!task.c(now2)) {
      raf.tasks.delete(task);
      task.f();
    }
  });
  if (raf.tasks.size !== 0) {
    raf.tick(run_tasks);
  }
}
function loop(callback) {
  let task;
  if (raf.tasks.size === 0) {
    raf.tick(run_tasks);
  }
  return {
    promise: new Promise((fulfill) => {
      raf.tasks.add(task = { c: callback, f: fulfill });
    }),
    abort() {
      raf.tasks.delete(task);
    }
  };
}
function dispatch_event(element, type) {
  without_reactive_context(() => {
    element.dispatchEvent(new CustomEvent(type));
  });
}
function css_property_to_camelcase(style) {
  if (style === "float") return "cssFloat";
  if (style === "offset") return "cssOffset";
  if (style.startsWith("--")) return style;
  const parts = style.split("-");
  if (parts.length === 1) return parts[0];
  return parts[0] + parts.slice(1).map(
    /** @param {any} word */
    (word) => word[0].toUpperCase() + word.slice(1)
  ).join("");
}
function css_to_keyframe(css) {
  const keyframe = {};
  const parts = css.split(";");
  for (const part of parts) {
    const [property, value] = part.split(":");
    if (!property || value === void 0) break;
    const formatted_property = css_property_to_camelcase(property.trim());
    keyframe[formatted_property] = value.trim();
  }
  return keyframe;
}
const linear$1 = (t2) => t2;
function transition$1(flags2, element, get_fn, get_params) {
  var _a3;
  var is_global = (flags2 & TRANSITION_GLOBAL) !== 0;
  var direction = "both";
  var current_options;
  var inert = element.inert;
  var overflow = element.style.overflow;
  var intro;
  var outro;
  function get_options() {
    return without_reactive_context(() => {
      var _a4;
      return current_options != null ? current_options : current_options = get_fn()(element, (_a4 = get_params == null ? void 0 : get_params()) != null ? _a4 : (
        /** @type {P} */
        {}
      ), {
        direction
      });
    });
  }
  var transition2 = {
    is_global,
    in() {
      element.inert = inert;
      dispatch_event(element, "introstart");
      intro = animate(element, get_options(), outro, 1, () => {
        dispatch_event(element, "introend");
        intro == null ? void 0 : intro.abort();
        intro = current_options = void 0;
        element.style.overflow = overflow;
      });
    },
    out(fn) {
      element.inert = true;
      dispatch_event(element, "outrostart");
      outro = animate(element, get_options(), intro, 0, () => {
        dispatch_event(element, "outroend");
        fn == null ? void 0 : fn();
      });
    },
    stop: () => {
      intro == null ? void 0 : intro.abort();
      outro == null ? void 0 : outro.abort();
    }
  };
  var e = (
    /** @type {Effect} */
    active_effect
  );
  ((_a3 = e.transitions) != null ? _a3 : e.transitions = []).push(transition2);
  if (should_intro) {
    var run = is_global;
    if (!run) {
      var block2 = (
        /** @type {Effect | null} */
        e.parent
      );
      while (block2 && (block2.f & EFFECT_TRANSPARENT) !== 0) {
        while (block2 = block2.parent) {
          if ((block2.f & BLOCK_EFFECT) !== 0) break;
        }
      }
      run = !block2 || (block2.f & EFFECT_RAN) !== 0;
    }
    if (run) {
      effect(() => {
        untrack(() => transition2.in());
      });
    }
  }
}
function animate(element, options2, counterpart, t2, on_finish) {
  var is_intro = t2 === 1;
  if (is_function(options2)) {
    var a;
    var aborted = false;
    queue_micro_task(() => {
      if (aborted) return;
      var o = options2({ direction: is_intro ? "in" : "out" });
      a = animate(element, o, counterpart, t2, on_finish);
    });
    return {
      abort: () => {
        aborted = true;
        a == null ? void 0 : a.abort();
      },
      deactivate: () => a.deactivate(),
      reset: () => a.reset(),
      t: () => a.t()
    };
  }
  counterpart == null ? void 0 : counterpart.deactivate();
  if (!(options2 == null ? void 0 : options2.duration)) {
    on_finish();
    return {
      abort: noop$1,
      deactivate: noop$1,
      reset: noop$1,
      t: () => t2
    };
  }
  const { delay = 0, css, tick: tick2, easing = linear$1 } = options2;
  var keyframes = [];
  if (is_intro && counterpart === void 0) {
    if (tick2) {
      tick2(0, 1);
    }
    if (css) {
      var styles = css_to_keyframe(css(0, 1));
      keyframes.push(styles, styles);
    }
  }
  var get_t = () => 1 - t2;
  var animation = element.animate(keyframes, { duration: delay, fill: "forwards" });
  animation.onfinish = () => {
    var _a3;
    animation.cancel();
    var t1 = (_a3 = counterpart == null ? void 0 : counterpart.t()) != null ? _a3 : 1 - t2;
    counterpart == null ? void 0 : counterpart.abort();
    var delta = t2 - t1;
    var duration = (
      /** @type {number} */
      options2.duration * Math.abs(delta)
    );
    var keyframes2 = [];
    if (duration > 0) {
      var needs_overflow_hidden = false;
      if (css) {
        var n = Math.ceil(duration / (1e3 / 60));
        for (var i = 0; i <= n; i += 1) {
          var t3 = t1 + delta * easing(i / n);
          var styles2 = css_to_keyframe(css(t3, 1 - t3));
          keyframes2.push(styles2);
          needs_overflow_hidden || (needs_overflow_hidden = styles2.overflow === "hidden");
        }
      }
      if (needs_overflow_hidden) {
        element.style.overflow = "hidden";
      }
      get_t = () => {
        var time = (
          /** @type {number} */
          /** @type {globalThis.Animation} */
          animation.currentTime
        );
        return t1 + delta * easing(time / duration);
      };
      if (tick2) {
        loop(() => {
          if (animation.playState !== "running") return false;
          var t4 = get_t();
          tick2(t4, 1 - t4);
          return true;
        });
      }
    }
    animation = element.animate(keyframes2, { duration, fill: "forwards" });
    animation.onfinish = () => {
      get_t = () => t2;
      tick2 == null ? void 0 : tick2(t2, 1 - t2);
      on_finish();
    };
  };
  return {
    abort: () => {
      if (animation) {
        animation.cancel();
        animation.effect = null;
        animation.onfinish = noop$1;
      }
    },
    deactivate: () => {
      on_finish = noop$1;
    },
    reset: () => {
      if (t2 === 0) {
        tick2 == null ? void 0 : tick2(1, 0);
      }
    },
    t: () => get_t()
  };
}
function bind_value(input, get2, set2 = get2) {
  var batches2 = /* @__PURE__ */ new WeakSet();
  listen_to_event_and_reset_event(input, "input", (is_reset) => __async(null, null, function* () {
    if (DEV && input.type === "checkbox") {
      bind_invalid_checkbox_value();
    }
    var value = is_reset ? input.defaultValue : input.value;
    value = is_numberlike_input(input) ? to_number(value) : value;
    set2(value);
    if (current_batch !== null) {
      batches2.add(current_batch);
    }
    yield tick();
    if (value !== (value = get2())) {
      var start2 = input.selectionStart;
      var end = input.selectionEnd;
      var length = input.value.length;
      input.value = value != null ? value : "";
      if (end !== null) {
        var new_length = input.value.length;
        if (start2 === end && end === length && new_length > length) {
          input.selectionStart = new_length;
          input.selectionEnd = new_length;
        } else {
          input.selectionStart = start2;
          input.selectionEnd = Math.min(end, new_length);
        }
      }
    }
  }));
  if (
    // If we are hydrating and the value has since changed,
    // then use the updated value from the input instead.
    // If defaultValue is set, then value == defaultValue
    // TODO Svelte 6: remove input.value check and set to empty string?
    untrack(get2) == null && input.value
  ) {
    set2(is_numberlike_input(input) ? to_number(input.value) : input.value);
    if (current_batch !== null) {
      batches2.add(current_batch);
    }
  }
  render_effect(() => {
    if (DEV && input.type === "checkbox") {
      bind_invalid_checkbox_value();
    }
    var value = get2();
    if (input === document.activeElement) {
      var batch = (
        /** @type {Batch} */
        previous_batch != null ? previous_batch : current_batch
      );
      if (batches2.has(batch)) {
        return;
      }
    }
    if (is_numberlike_input(input) && value === to_number(input.value)) {
      return;
    }
    if (input.type === "date" && !value && !input.value) {
      return;
    }
    if (value !== input.value) {
      input.value = value != null ? value : "";
    }
  });
}
function is_numberlike_input(input) {
  var type = input.type;
  return type === "number" || type === "range";
}
function to_number(value) {
  return value === "" ? null : +value;
}
const _ResizeObserverSingleton = class _ResizeObserverSingleton {
  /** @param {ResizeObserverOptions} options */
  constructor(options2) {
    __privateAdd(this, _ResizeObserverSingleton_instances);
    /** */
    __privateAdd(this, _listeners, /* @__PURE__ */ new WeakMap());
    /** @type {ResizeObserver | undefined} */
    __privateAdd(this, _observer);
    /** @type {ResizeObserverOptions} */
    __privateAdd(this, _options);
    __privateSet(this, _options, options2);
  }
  /**
   * @param {Element} element
   * @param {(entry: ResizeObserverEntry) => any} listener
   */
  observe(element, listener) {
    var listeners = __privateGet(this, _listeners).get(element) || /* @__PURE__ */ new Set();
    listeners.add(listener);
    __privateGet(this, _listeners).set(element, listeners);
    __privateMethod(this, _ResizeObserverSingleton_instances, getObserver_fn).call(this).observe(element, __privateGet(this, _options));
    return () => {
      var listeners2 = __privateGet(this, _listeners).get(element);
      listeners2.delete(listener);
      if (listeners2.size === 0) {
        __privateGet(this, _listeners).delete(element);
        __privateGet(this, _observer).unobserve(element);
      }
    };
  }
};
_listeners = new WeakMap();
_observer = new WeakMap();
_options = new WeakMap();
_ResizeObserverSingleton_instances = new WeakSet();
getObserver_fn = function() {
  var _a3;
  return (_a3 = __privateGet(this, _observer)) != null ? _a3 : __privateSet(this, _observer, new ResizeObserver(
    /** @param {any} entries */
    (entries) => {
      for (var entry of entries) {
        _ResizeObserverSingleton.entries.set(entry.target, entry);
        for (var listener of __privateGet(this, _listeners).get(entry.target) || []) {
          listener(entry);
        }
      }
    }
  ));
};
/** @static */
__publicField(_ResizeObserverSingleton, "entries", /* @__PURE__ */ new WeakMap());
let ResizeObserverSingleton = _ResizeObserverSingleton;
var resize_observer_border_box = /* @__PURE__ */ new ResizeObserverSingleton({
  box: "border-box"
});
function bind_element_size(element, type, set2) {
  var unsub = resize_observer_border_box.observe(element, () => set2(element[type]));
  effect(() => {
    untrack(() => set2(element[type]));
    return unsub;
  });
}
function is_bound_this(bound_value, element_or_component) {
  return bound_value === element_or_component || (bound_value == null ? void 0 : bound_value[STATE_SYMBOL]) === element_or_component;
}
function bind_this(element_or_component = {}, update2, get_value, get_parts) {
  effect(() => {
    var old_parts;
    var parts;
    render_effect(() => {
      old_parts = parts;
      parts = [];
      untrack(() => {
        if (element_or_component !== get_value(...parts)) {
          update2(element_or_component, ...parts);
          if (old_parts && is_bound_this(get_value(...old_parts), element_or_component)) {
            update2(null, ...old_parts);
          }
        }
      });
    });
    return () => {
      queue_micro_task(() => {
        if (parts && is_bound_this(get_value(...parts), element_or_component)) {
          update2(null, ...parts);
        }
      });
    };
  });
  return element_or_component;
}
function subscribe_to_store(store, run, invalidate) {
  if (store == null) {
    run(void 0);
    if (invalidate) invalidate(void 0);
    return noop$1;
  }
  const unsub = untrack(
    () => store.subscribe(
      run,
      // @ts-expect-error
      invalidate
    )
  );
  return unsub.unsubscribe ? () => unsub.unsubscribe() : unsub;
}
const subscriber_queue = [];
function readable(value, start2) {
  return {
    subscribe: writable(value, start2).subscribe
  };
}
function writable(value, start2 = noop$1) {
  let stop = null;
  const subscribers = /* @__PURE__ */ new Set();
  function set2(new_value) {
    if (safe_not_equal(value, new_value)) {
      value = new_value;
      if (stop) {
        const run_queue = !subscriber_queue.length;
        for (const subscriber of subscribers) {
          subscriber[1]();
          subscriber_queue.push(subscriber, value);
        }
        if (run_queue) {
          for (let i = 0; i < subscriber_queue.length; i += 2) {
            subscriber_queue[i][0](subscriber_queue[i + 1]);
          }
          subscriber_queue.length = 0;
        }
      }
    }
  }
  function update2(fn) {
    set2(fn(
      /** @type {T} */
      value
    ));
  }
  function subscribe(run, invalidate = noop$1) {
    const subscriber = [run, invalidate];
    subscribers.add(subscriber);
    if (subscribers.size === 1) {
      stop = start2(set2, update2) || noop$1;
    }
    run(
      /** @type {T} */
      value
    );
    return () => {
      subscribers.delete(subscriber);
      if (subscribers.size === 0 && stop) {
        stop();
        stop = null;
      }
    };
  }
  return { set: set2, update: update2, subscribe };
}
function derived(stores, fn, initial_value) {
  const single = !Array.isArray(stores);
  const stores_array = single ? [stores] : stores;
  if (!stores_array.every(Boolean)) {
    throw new Error("derived() expects stores as input, got a falsy value");
  }
  const auto = fn.length < 2;
  return readable(initial_value, (set2, update2) => {
    let started = false;
    const values = [];
    let pending = 0;
    let cleanup = noop$1;
    const sync = () => {
      if (pending) {
        return;
      }
      cleanup();
      const result = fn(single ? values[0] : values, set2, update2);
      if (auto) {
        set2(result);
      } else {
        cleanup = typeof result === "function" ? result : noop$1;
      }
    };
    const unsubscribers = stores_array.map(
      (store, i) => subscribe_to_store(
        store,
        (value) => {
          values[i] = value;
          pending &= ~(1 << i);
          if (started) {
            sync();
          }
        },
        () => {
          pending |= 1 << i;
        }
      )
    );
    started = true;
    sync();
    return function stop() {
      run_all(unsubscribers);
      cleanup();
      started = false;
    };
  });
}
function get$2(store) {
  let value;
  subscribe_to_store(store, (_2) => value = _2)();
  return value;
}
let is_store_binding = false;
let IS_UNMOUNTED = Symbol();
function store_get(store, store_name, stores) {
  var _a3;
  const entry = (_a3 = stores[store_name]) != null ? _a3 : stores[store_name] = {
    store: null,
    source: /* @__PURE__ */ mutable_source(void 0),
    unsubscribe: noop$1
  };
  if (DEV) {
    entry.source.label = store_name;
  }
  if (entry.store !== store && !(IS_UNMOUNTED in stores)) {
    entry.unsubscribe();
    entry.store = store != null ? store : null;
    if (store == null) {
      entry.source.v = void 0;
      entry.unsubscribe = noop$1;
    } else {
      var is_synchronous_callback = true;
      entry.unsubscribe = subscribe_to_store(store, (v2) => {
        if (is_synchronous_callback) {
          entry.source.v = v2;
        } else {
          set$2(entry.source, v2);
        }
      });
      is_synchronous_callback = false;
    }
  }
  if (store && IS_UNMOUNTED in stores) {
    return get$2(store);
  }
  return get$3(entry.source);
}
function setup_stores() {
  const stores = {};
  function cleanup() {
    teardown(() => {
      for (var store_name in stores) {
        const ref = stores[store_name];
        ref.unsubscribe();
      }
      define_property(stores, IS_UNMOUNTED, {
        enumerable: false,
        value: true
      });
    });
  }
  return [stores, cleanup];
}
function store_mutate(store, expression, new_value) {
  store.set(new_value);
  return expression;
}
function capture_store_binding(fn) {
  var previous_is_store_binding = is_store_binding;
  try {
    is_store_binding = false;
    return [fn(), is_store_binding];
  } finally {
    is_store_binding = previous_is_store_binding;
  }
}
const rest_props_handler = {
  get(target, key2) {
    if (target.exclude.includes(key2)) return;
    return target.props[key2];
  },
  set(target, key2) {
    if (DEV) {
      props_rest_readonly(`${target.name}.${String(key2)}`);
    }
    return false;
  },
  getOwnPropertyDescriptor(target, key2) {
    if (target.exclude.includes(key2)) return;
    if (key2 in target.props) {
      return {
        enumerable: true,
        configurable: true,
        value: target.props[key2]
      };
    }
  },
  has(target, key2) {
    if (target.exclude.includes(key2)) return false;
    return key2 in target.props;
  },
  ownKeys(target) {
    return Reflect.ownKeys(target.props).filter((key2) => !target.exclude.includes(key2));
  }
};
// @__NO_SIDE_EFFECTS__
function rest_props(props, exclude, name2) {
  return new Proxy(
    DEV ? { props, exclude, name: name2, other: {}, to_proxy: [] } : { props, exclude },
    rest_props_handler
  );
}
const spread_props_handler = {
  get(target, key2) {
    let i = target.props.length;
    while (i--) {
      let p = target.props[i];
      if (is_function(p)) p = p();
      if (typeof p === "object" && p !== null && key2 in p) return p[key2];
    }
  },
  set(target, key2, value) {
    let i = target.props.length;
    while (i--) {
      let p = target.props[i];
      if (is_function(p)) p = p();
      const desc = get_descriptor(p, key2);
      if (desc && desc.set) {
        desc.set(value);
        return true;
      }
    }
    return false;
  },
  getOwnPropertyDescriptor(target, key2) {
    let i = target.props.length;
    while (i--) {
      let p = target.props[i];
      if (is_function(p)) p = p();
      if (typeof p === "object" && p !== null && key2 in p) {
        const descriptor = get_descriptor(p, key2);
        if (descriptor && !descriptor.configurable) {
          descriptor.configurable = true;
        }
        return descriptor;
      }
    }
  },
  has(target, key2) {
    if (key2 === STATE_SYMBOL || key2 === LEGACY_PROPS) return false;
    for (let p of target.props) {
      if (is_function(p)) p = p();
      if (p != null && key2 in p) return true;
    }
    return false;
  },
  ownKeys(target) {
    const keys = [];
    for (let p of target.props) {
      if (is_function(p)) p = p();
      if (!p) continue;
      for (const key2 in p) {
        if (!keys.includes(key2)) keys.push(key2);
      }
      for (const key2 of Object.getOwnPropertySymbols(p)) {
        if (!keys.includes(key2)) keys.push(key2);
      }
    }
    return keys;
  }
};
function spread_props(...props) {
  return new Proxy({ props }, spread_props_handler);
}
function prop(props, key2, flags2, fallback2) {
  var _a3, _b2;
  var bindable = (flags2 & PROPS_IS_BINDABLE) !== 0;
  var lazy = (flags2 & PROPS_IS_LAZY_INITIAL) !== 0;
  var fallback_value = (
    /** @type {V} */
    fallback2
  );
  var fallback_dirty = true;
  var get_fallback = () => {
    if (fallback_dirty) {
      fallback_dirty = false;
      fallback_value = lazy ? untrack(
        /** @type {() => V} */
        fallback2
      ) : (
        /** @type {V} */
        fallback2
      );
    }
    return fallback_value;
  };
  var setter;
  if (bindable) {
    var is_entry_props = STATE_SYMBOL in props || LEGACY_PROPS in props;
    setter = (_b2 = (_a3 = get_descriptor(props, key2)) == null ? void 0 : _a3.set) != null ? _b2 : is_entry_props && key2 in props ? (v2) => props[key2] = v2 : void 0;
  }
  var initial_value;
  var is_store_sub = false;
  if (bindable) {
    [initial_value, is_store_sub] = capture_store_binding(() => (
      /** @type {V} */
      props[key2]
    ));
  } else {
    initial_value = /** @type {V} */
    props[key2];
  }
  if (initial_value === void 0 && fallback2 !== void 0) {
    initial_value = get_fallback();
    if (setter) {
      props_invalid_value(key2);
      setter(initial_value);
    }
  }
  var getter;
  {
    getter = () => {
      var value = (
        /** @type {V} */
        props[key2]
      );
      if (value === void 0) return get_fallback();
      fallback_dirty = true;
      return value;
    };
  }
  if ((flags2 & PROPS_IS_UPDATED) === 0) {
    return getter;
  }
  if (setter) {
    var legacy_parent = props.$$legacy;
    return (
      /** @type {() => V} */
      (function(value, mutation) {
        if (arguments.length > 0) {
          if (!mutation || legacy_parent || is_store_sub) {
            setter(mutation ? getter() : value);
          }
          return value;
        }
        return getter();
      })
    );
  }
  var overridden = false;
  var d = ((flags2 & PROPS_IS_IMMUTABLE) !== 0 ? derived$1 : derived_safe_equal)(() => {
    overridden = false;
    return getter();
  });
  if (DEV) {
    d.label = key2;
  }
  if (bindable) get$3(d);
  var parent_effect = (
    /** @type {Effect} */
    active_effect
  );
  return (
    /** @type {() => V} */
    (function(value, mutation) {
      if (arguments.length > 0) {
        const new_value = mutation ? get$3(d) : bindable ? proxy(value) : value;
        set$2(d, new_value);
        overridden = true;
        if (fallback_value !== void 0) {
          fallback_value = new_value;
        }
        return value;
      }
      if (is_destroying_effect && overridden || (parent_effect.f & DESTROYED) !== 0) {
        return d.v;
      }
      return get$3(d);
    })
  );
}
var noop = { value: () => {
} };
function dispatch() {
  for (var i = 0, n = arguments.length, _2 = {}, t2; i < n; ++i) {
    if (!(t2 = arguments[i] + "") || t2 in _2 || /[\s.]/.test(t2)) throw new Error("illegal type: " + t2);
    _2[t2] = [];
  }
  return new Dispatch(_2);
}
function Dispatch(_2) {
  this._ = _2;
}
function parseTypenames$1(typenames, types2) {
  return typenames.trim().split(/^|\s+/).map(function(t2) {
    var name2 = "", i = t2.indexOf(".");
    if (i >= 0) name2 = t2.slice(i + 1), t2 = t2.slice(0, i);
    if (t2 && !types2.hasOwnProperty(t2)) throw new Error("unknown type: " + t2);
    return { type: t2, name: name2 };
  });
}
Dispatch.prototype = dispatch.prototype = {
  constructor: Dispatch,
  on: function(typename, callback) {
    var _2 = this._, T2 = parseTypenames$1(typename + "", _2), t2, i = -1, n = T2.length;
    if (arguments.length < 2) {
      while (++i < n) if ((t2 = (typename = T2[i]).type) && (t2 = get$1(_2[t2], typename.name))) return t2;
      return;
    }
    if (callback != null && typeof callback !== "function") throw new Error("invalid callback: " + callback);
    while (++i < n) {
      if (t2 = (typename = T2[i]).type) _2[t2] = set$1(_2[t2], typename.name, callback);
      else if (callback == null) for (t2 in _2) _2[t2] = set$1(_2[t2], typename.name, null);
    }
    return this;
  },
  copy: function() {
    var copy = {}, _2 = this._;
    for (var t2 in _2) copy[t2] = _2[t2].slice();
    return new Dispatch(copy);
  },
  call: function(type, that) {
    if ((n = arguments.length - 2) > 0) for (var args = new Array(n), i = 0, n, t2; i < n; ++i) args[i] = arguments[i + 2];
    if (!this._.hasOwnProperty(type)) throw new Error("unknown type: " + type);
    for (t2 = this._[type], i = 0, n = t2.length; i < n; ++i) t2[i].value.apply(that, args);
  },
  apply: function(type, that, args) {
    if (!this._.hasOwnProperty(type)) throw new Error("unknown type: " + type);
    for (var t2 = this._[type], i = 0, n = t2.length; i < n; ++i) t2[i].value.apply(that, args);
  }
};
function get$1(type, name2) {
  for (var i = 0, n = type.length, c; i < n; ++i) {
    if ((c = type[i]).name === name2) {
      return c.value;
    }
  }
}
function set$1(type, name2, callback) {
  for (var i = 0, n = type.length; i < n; ++i) {
    if (type[i].name === name2) {
      type[i] = noop, type = type.slice(0, i).concat(type.slice(i + 1));
      break;
    }
  }
  if (callback != null) type.push({ name: name2, value: callback });
  return type;
}
var xhtml = "http://www.w3.org/1999/xhtml";
const namespaces = {
  svg: "http://www.w3.org/2000/svg",
  xhtml,
  xlink: "http://www.w3.org/1999/xlink",
  xml: "http://www.w3.org/XML/1998/namespace",
  xmlns: "http://www.w3.org/2000/xmlns/"
};
function namespace(name2) {
  var prefix = name2 += "", i = prefix.indexOf(":");
  if (i >= 0 && (prefix = name2.slice(0, i)) !== "xmlns") name2 = name2.slice(i + 1);
  return namespaces.hasOwnProperty(prefix) ? { space: namespaces[prefix], local: name2 } : name2;
}
function creatorInherit(name2) {
  return function() {
    var document2 = this.ownerDocument, uri = this.namespaceURI;
    return uri === xhtml && document2.documentElement.namespaceURI === xhtml ? document2.createElement(name2) : document2.createElementNS(uri, name2);
  };
}
function creatorFixed(fullname) {
  return function() {
    return this.ownerDocument.createElementNS(fullname.space, fullname.local);
  };
}
function creator(name2) {
  var fullname = namespace(name2);
  return (fullname.local ? creatorFixed : creatorInherit)(fullname);
}
function none$2() {
}
function selector(selector2) {
  return selector2 == null ? none$2 : function() {
    return this.querySelector(selector2);
  };
}
function selection_select(select2) {
  if (typeof select2 !== "function") select2 = selector(select2);
  for (var groups = this._groups, m2 = groups.length, subgroups = new Array(m2), j2 = 0; j2 < m2; ++j2) {
    for (var group = groups[j2], n = group.length, subgroup = subgroups[j2] = new Array(n), node, subnode, i = 0; i < n; ++i) {
      if ((node = group[i]) && (subnode = select2.call(node, node.__data__, i, group))) {
        if ("__data__" in node) subnode.__data__ = node.__data__;
        subgroup[i] = subnode;
      }
    }
  }
  return new Selection$2(subgroups, this._parents);
}
function array(x2) {
  return x2 == null ? [] : Array.isArray(x2) ? x2 : Array.from(x2);
}
function empty() {
  return [];
}
function selectorAll(selector2) {
  return selector2 == null ? empty : function() {
    return this.querySelectorAll(selector2);
  };
}
function arrayAll(select2) {
  return function() {
    return array(select2.apply(this, arguments));
  };
}
function selection_selectAll(select2) {
  if (typeof select2 === "function") select2 = arrayAll(select2);
  else select2 = selectorAll(select2);
  for (var groups = this._groups, m2 = groups.length, subgroups = [], parents = [], j2 = 0; j2 < m2; ++j2) {
    for (var group = groups[j2], n = group.length, node, i = 0; i < n; ++i) {
      if (node = group[i]) {
        subgroups.push(select2.call(node, node.__data__, i, group));
        parents.push(node);
      }
    }
  }
  return new Selection$2(subgroups, parents);
}
function matcher(selector2) {
  return function() {
    return this.matches(selector2);
  };
}
function childMatcher(selector2) {
  return function(node) {
    return node.matches(selector2);
  };
}
var find$1 = Array.prototype.find;
function childFind(match) {
  return function() {
    return find$1.call(this.children, match);
  };
}
function childFirst() {
  return this.firstElementChild;
}
function selection_selectChild(match) {
  return this.select(match == null ? childFirst : childFind(typeof match === "function" ? match : childMatcher(match)));
}
var filter = Array.prototype.filter;
function children$2() {
  return Array.from(this.children);
}
function childrenFilter(match) {
  return function() {
    return filter.call(this.children, match);
  };
}
function selection_selectChildren(match) {
  return this.selectAll(match == null ? children$2 : childrenFilter(typeof match === "function" ? match : childMatcher(match)));
}
function selection_filter(match) {
  if (typeof match !== "function") match = matcher(match);
  for (var groups = this._groups, m2 = groups.length, subgroups = new Array(m2), j2 = 0; j2 < m2; ++j2) {
    for (var group = groups[j2], n = group.length, subgroup = subgroups[j2] = [], node, i = 0; i < n; ++i) {
      if ((node = group[i]) && match.call(node, node.__data__, i, group)) {
        subgroup.push(node);
      }
    }
  }
  return new Selection$2(subgroups, this._parents);
}
function sparse(update2) {
  return new Array(update2.length);
}
function selection_enter() {
  return new Selection$2(this._enter || this._groups.map(sparse), this._parents);
}
function EnterNode(parent, datum2) {
  this.ownerDocument = parent.ownerDocument;
  this.namespaceURI = parent.namespaceURI;
  this._next = null;
  this._parent = parent;
  this.__data__ = datum2;
}
EnterNode.prototype = {
  constructor: EnterNode,
  appendChild: function(child2) {
    return this._parent.insertBefore(child2, this._next);
  },
  insertBefore: function(child2, next) {
    return this._parent.insertBefore(child2, next);
  },
  querySelector: function(selector2) {
    return this._parent.querySelector(selector2);
  },
  querySelectorAll: function(selector2) {
    return this._parent.querySelectorAll(selector2);
  }
};
function constant$3(x2) {
  return function() {
    return x2;
  };
}
function bindIndex(parent, group, enter, update2, exit, data) {
  var i = 0, node, groupLength = group.length, dataLength = data.length;
  for (; i < dataLength; ++i) {
    if (node = group[i]) {
      node.__data__ = data[i];
      update2[i] = node;
    } else {
      enter[i] = new EnterNode(parent, data[i]);
    }
  }
  for (; i < groupLength; ++i) {
    if (node = group[i]) {
      exit[i] = node;
    }
  }
}
function bindKey(parent, group, enter, update2, exit, data, key2) {
  var i, node, nodeByKeyValue = /* @__PURE__ */ new Map(), groupLength = group.length, dataLength = data.length, keyValues = new Array(groupLength), keyValue;
  for (i = 0; i < groupLength; ++i) {
    if (node = group[i]) {
      keyValues[i] = keyValue = key2.call(node, node.__data__, i, group) + "";
      if (nodeByKeyValue.has(keyValue)) {
        exit[i] = node;
      } else {
        nodeByKeyValue.set(keyValue, node);
      }
    }
  }
  for (i = 0; i < dataLength; ++i) {
    keyValue = key2.call(parent, data[i], i, data) + "";
    if (node = nodeByKeyValue.get(keyValue)) {
      update2[i] = node;
      node.__data__ = data[i];
      nodeByKeyValue.delete(keyValue);
    } else {
      enter[i] = new EnterNode(parent, data[i]);
    }
  }
  for (i = 0; i < groupLength; ++i) {
    if ((node = group[i]) && nodeByKeyValue.get(keyValues[i]) === node) {
      exit[i] = node;
    }
  }
}
function datum(node) {
  return node.__data__;
}
function selection_data(value, key2) {
  if (!arguments.length) return Array.from(this, datum);
  var bind = key2 ? bindKey : bindIndex, parents = this._parents, groups = this._groups;
  if (typeof value !== "function") value = constant$3(value);
  for (var m2 = groups.length, update2 = new Array(m2), enter = new Array(m2), exit = new Array(m2), j2 = 0; j2 < m2; ++j2) {
    var parent = parents[j2], group = groups[j2], groupLength = group.length, data = arraylike(value.call(parent, parent && parent.__data__, j2, parents)), dataLength = data.length, enterGroup = enter[j2] = new Array(dataLength), updateGroup = update2[j2] = new Array(dataLength), exitGroup = exit[j2] = new Array(groupLength);
    bind(parent, group, enterGroup, updateGroup, exitGroup, data, key2);
    for (var i0 = 0, i1 = 0, previous, next; i0 < dataLength; ++i0) {
      if (previous = enterGroup[i0]) {
        if (i0 >= i1) i1 = i0 + 1;
        while (!(next = updateGroup[i1]) && ++i1 < dataLength) ;
        previous._next = next || null;
      }
    }
  }
  update2 = new Selection$2(update2, parents);
  update2._enter = enter;
  update2._exit = exit;
  return update2;
}
function arraylike(data) {
  return typeof data === "object" && "length" in data ? data : Array.from(data);
}
function selection_exit() {
  return new Selection$2(this._exit || this._groups.map(sparse), this._parents);
}
function selection_join(onenter, onupdate, onexit) {
  var enter = this.enter(), update2 = this, exit = this.exit();
  if (typeof onenter === "function") {
    enter = onenter(enter);
    if (enter) enter = enter.selection();
  } else {
    enter = enter.append(onenter + "");
  }
  if (onupdate != null) {
    update2 = onupdate(update2);
    if (update2) update2 = update2.selection();
  }
  if (onexit == null) exit.remove();
  else onexit(exit);
  return enter && update2 ? enter.merge(update2).order() : update2;
}
function selection_merge(context) {
  var selection2 = context.selection ? context.selection() : context;
  for (var groups0 = this._groups, groups1 = selection2._groups, m0 = groups0.length, m1 = groups1.length, m2 = Math.min(m0, m1), merges = new Array(m0), j2 = 0; j2 < m2; ++j2) {
    for (var group0 = groups0[j2], group1 = groups1[j2], n = group0.length, merge = merges[j2] = new Array(n), node, i = 0; i < n; ++i) {
      if (node = group0[i] || group1[i]) {
        merge[i] = node;
      }
    }
  }
  for (; j2 < m0; ++j2) {
    merges[j2] = groups0[j2];
  }
  return new Selection$2(merges, this._parents);
}
function selection_order() {
  for (var groups = this._groups, j2 = -1, m2 = groups.length; ++j2 < m2; ) {
    for (var group = groups[j2], i = group.length - 1, next = group[i], node; --i >= 0; ) {
      if (node = group[i]) {
        if (next && node.compareDocumentPosition(next) ^ 4) next.parentNode.insertBefore(node, next);
        next = node;
      }
    }
  }
  return this;
}
function selection_sort(compare2) {
  if (!compare2) compare2 = ascending;
  function compareNode(a, b2) {
    return a && b2 ? compare2(a.__data__, b2.__data__) : !a - !b2;
  }
  for (var groups = this._groups, m2 = groups.length, sortgroups = new Array(m2), j2 = 0; j2 < m2; ++j2) {
    for (var group = groups[j2], n = group.length, sortgroup = sortgroups[j2] = new Array(n), node, i = 0; i < n; ++i) {
      if (node = group[i]) {
        sortgroup[i] = node;
      }
    }
    sortgroup.sort(compareNode);
  }
  return new Selection$2(sortgroups, this._parents).order();
}
function ascending(a, b2) {
  return a < b2 ? -1 : a > b2 ? 1 : a >= b2 ? 0 : NaN;
}
function selection_call() {
  var callback = arguments[0];
  arguments[0] = this;
  callback.apply(null, arguments);
  return this;
}
function selection_nodes() {
  return Array.from(this);
}
function selection_node() {
  for (var groups = this._groups, j2 = 0, m2 = groups.length; j2 < m2; ++j2) {
    for (var group = groups[j2], i = 0, n = group.length; i < n; ++i) {
      var node = group[i];
      if (node) return node;
    }
  }
  return null;
}
function selection_size() {
  let size = 0;
  for (const node of this) ++size;
  return size;
}
function selection_empty() {
  return !this.node();
}
function selection_each(callback) {
  for (var groups = this._groups, j2 = 0, m2 = groups.length; j2 < m2; ++j2) {
    for (var group = groups[j2], i = 0, n = group.length, node; i < n; ++i) {
      if (node = group[i]) callback.call(node, node.__data__, i, group);
    }
  }
  return this;
}
function attrRemove$1(name2) {
  return function() {
    this.removeAttribute(name2);
  };
}
function attrRemoveNS$1(fullname) {
  return function() {
    this.removeAttributeNS(fullname.space, fullname.local);
  };
}
function attrConstant$1(name2, value) {
  return function() {
    this.setAttribute(name2, value);
  };
}
function attrConstantNS$1(fullname, value) {
  return function() {
    this.setAttributeNS(fullname.space, fullname.local, value);
  };
}
function attrFunction$1(name2, value) {
  return function() {
    var v2 = value.apply(this, arguments);
    if (v2 == null) this.removeAttribute(name2);
    else this.setAttribute(name2, v2);
  };
}
function attrFunctionNS$1(fullname, value) {
  return function() {
    var v2 = value.apply(this, arguments);
    if (v2 == null) this.removeAttributeNS(fullname.space, fullname.local);
    else this.setAttributeNS(fullname.space, fullname.local, v2);
  };
}
function selection_attr(name2, value) {
  var fullname = namespace(name2);
  if (arguments.length < 2) {
    var node = this.node();
    return fullname.local ? node.getAttributeNS(fullname.space, fullname.local) : node.getAttribute(fullname);
  }
  return this.each((value == null ? fullname.local ? attrRemoveNS$1 : attrRemove$1 : typeof value === "function" ? fullname.local ? attrFunctionNS$1 : attrFunction$1 : fullname.local ? attrConstantNS$1 : attrConstant$1)(fullname, value));
}
function defaultView(node) {
  return node.ownerDocument && node.ownerDocument.defaultView || node.document && node || node.defaultView;
}
function styleRemove$1(name2) {
  return function() {
    this.style.removeProperty(name2);
  };
}
function styleConstant$1(name2, value, priority) {
  return function() {
    this.style.setProperty(name2, value, priority);
  };
}
function styleFunction$1(name2, value, priority) {
  return function() {
    var v2 = value.apply(this, arguments);
    if (v2 == null) this.style.removeProperty(name2);
    else this.style.setProperty(name2, v2, priority);
  };
}
function selection_style(name2, value, priority) {
  return arguments.length > 1 ? this.each((value == null ? styleRemove$1 : typeof value === "function" ? styleFunction$1 : styleConstant$1)(name2, value, priority == null ? "" : priority)) : styleValue(this.node(), name2);
}
function styleValue(node, name2) {
  return node.style.getPropertyValue(name2) || defaultView(node).getComputedStyle(node, null).getPropertyValue(name2);
}
function propertyRemove(name2) {
  return function() {
    delete this[name2];
  };
}
function propertyConstant(name2, value) {
  return function() {
    this[name2] = value;
  };
}
function propertyFunction(name2, value) {
  return function() {
    var v2 = value.apply(this, arguments);
    if (v2 == null) delete this[name2];
    else this[name2] = v2;
  };
}
function selection_property(name2, value) {
  return arguments.length > 1 ? this.each((value == null ? propertyRemove : typeof value === "function" ? propertyFunction : propertyConstant)(name2, value)) : this.node()[name2];
}
function classArray(string2) {
  return string2.trim().split(/^|\s+/);
}
function classList(node) {
  return node.classList || new ClassList(node);
}
function ClassList(node) {
  this._node = node;
  this._names = classArray(node.getAttribute("class") || "");
}
ClassList.prototype = {
  add: function(name2) {
    var i = this._names.indexOf(name2);
    if (i < 0) {
      this._names.push(name2);
      this._node.setAttribute("class", this._names.join(" "));
    }
  },
  remove: function(name2) {
    var i = this._names.indexOf(name2);
    if (i >= 0) {
      this._names.splice(i, 1);
      this._node.setAttribute("class", this._names.join(" "));
    }
  },
  contains: function(name2) {
    return this._names.indexOf(name2) >= 0;
  }
};
function classedAdd(node, names) {
  var list = classList(node), i = -1, n = names.length;
  while (++i < n) list.add(names[i]);
}
function classedRemove(node, names) {
  var list = classList(node), i = -1, n = names.length;
  while (++i < n) list.remove(names[i]);
}
function classedTrue(names) {
  return function() {
    classedAdd(this, names);
  };
}
function classedFalse(names) {
  return function() {
    classedRemove(this, names);
  };
}
function classedFunction(names, value) {
  return function() {
    (value.apply(this, arguments) ? classedAdd : classedRemove)(this, names);
  };
}
function selection_classed(name2, value) {
  var names = classArray(name2 + "");
  if (arguments.length < 2) {
    var list = classList(this.node()), i = -1, n = names.length;
    while (++i < n) if (!list.contains(names[i])) return false;
    return true;
  }
  return this.each((typeof value === "function" ? classedFunction : value ? classedTrue : classedFalse)(names, value));
}
function textRemove() {
  this.textContent = "";
}
function textConstant$1(value) {
  return function() {
    this.textContent = value;
  };
}
function textFunction$1(value) {
  return function() {
    var v2 = value.apply(this, arguments);
    this.textContent = v2 == null ? "" : v2;
  };
}
function selection_text(value) {
  return arguments.length ? this.each(value == null ? textRemove : (typeof value === "function" ? textFunction$1 : textConstant$1)(value)) : this.node().textContent;
}
function htmlRemove() {
  this.innerHTML = "";
}
function htmlConstant(value) {
  return function() {
    this.innerHTML = value;
  };
}
function htmlFunction(value) {
  return function() {
    var v2 = value.apply(this, arguments);
    this.innerHTML = v2 == null ? "" : v2;
  };
}
function selection_html(value) {
  return arguments.length ? this.each(value == null ? htmlRemove : (typeof value === "function" ? htmlFunction : htmlConstant)(value)) : this.node().innerHTML;
}
function raise() {
  if (this.nextSibling) this.parentNode.appendChild(this);
}
function selection_raise() {
  return this.each(raise);
}
function lower() {
  if (this.previousSibling) this.parentNode.insertBefore(this, this.parentNode.firstChild);
}
function selection_lower() {
  return this.each(lower);
}
function selection_append(name2) {
  var create2 = typeof name2 === "function" ? name2 : creator(name2);
  return this.select(function() {
    return this.appendChild(create2.apply(this, arguments));
  });
}
function constantNull() {
  return null;
}
function selection_insert(name2, before) {
  var create2 = typeof name2 === "function" ? name2 : creator(name2), select2 = before == null ? constantNull : typeof before === "function" ? before : selector(before);
  return this.select(function() {
    return this.insertBefore(create2.apply(this, arguments), select2.apply(this, arguments) || null);
  });
}
function remove$2() {
  var parent = this.parentNode;
  if (parent) parent.removeChild(this);
}
function selection_remove() {
  return this.each(remove$2);
}
function selection_cloneShallow() {
  var clone2 = this.cloneNode(false), parent = this.parentNode;
  return parent ? parent.insertBefore(clone2, this.nextSibling) : clone2;
}
function selection_cloneDeep() {
  var clone2 = this.cloneNode(true), parent = this.parentNode;
  return parent ? parent.insertBefore(clone2, this.nextSibling) : clone2;
}
function selection_clone(deep) {
  return this.select(deep ? selection_cloneDeep : selection_cloneShallow);
}
function selection_datum(value) {
  return arguments.length ? this.property("__data__", value) : this.node().__data__;
}
function contextListener(listener) {
  return function(event2) {
    listener.call(this, event2, this.__data__);
  };
}
function parseTypenames(typenames) {
  return typenames.trim().split(/^|\s+/).map(function(t2) {
    var name2 = "", i = t2.indexOf(".");
    if (i >= 0) name2 = t2.slice(i + 1), t2 = t2.slice(0, i);
    return { type: t2, name: name2 };
  });
}
function onRemove(typename) {
  return function() {
    var on2 = this.__on;
    if (!on2) return;
    for (var j2 = 0, i = -1, m2 = on2.length, o; j2 < m2; ++j2) {
      if (o = on2[j2], (!typename.type || o.type === typename.type) && o.name === typename.name) {
        this.removeEventListener(o.type, o.listener, o.options);
      } else {
        on2[++i] = o;
      }
    }
    if (++i) on2.length = i;
    else delete this.__on;
  };
}
function onAdd(typename, value, options2) {
  return function() {
    var on2 = this.__on, o, listener = contextListener(value);
    if (on2) for (var j2 = 0, m2 = on2.length; j2 < m2; ++j2) {
      if ((o = on2[j2]).type === typename.type && o.name === typename.name) {
        this.removeEventListener(o.type, o.listener, o.options);
        this.addEventListener(o.type, o.listener = listener, o.options = options2);
        o.value = value;
        return;
      }
    }
    this.addEventListener(typename.type, listener, options2);
    o = { type: typename.type, name: typename.name, value, listener, options: options2 };
    if (!on2) this.__on = [o];
    else on2.push(o);
  };
}
function selection_on(typename, value, options2) {
  var typenames = parseTypenames(typename + ""), i, n = typenames.length, t2;
  if (arguments.length < 2) {
    var on2 = this.node().__on;
    if (on2) for (var j2 = 0, m2 = on2.length, o; j2 < m2; ++j2) {
      for (i = 0, o = on2[j2]; i < n; ++i) {
        if ((t2 = typenames[i]).type === o.type && t2.name === o.name) {
          return o.value;
        }
      }
    }
    return;
  }
  on2 = value ? onAdd : onRemove;
  for (i = 0; i < n; ++i) this.each(on2(typenames[i], value, options2));
  return this;
}
function dispatchEvent(node, type, params) {
  var window2 = defaultView(node), event2 = window2.CustomEvent;
  if (typeof event2 === "function") {
    event2 = new event2(type, params);
  } else {
    event2 = window2.document.createEvent("Event");
    if (params) event2.initEvent(type, params.bubbles, params.cancelable), event2.detail = params.detail;
    else event2.initEvent(type, false, false);
  }
  node.dispatchEvent(event2);
}
function dispatchConstant(type, params) {
  return function() {
    return dispatchEvent(this, type, params);
  };
}
function dispatchFunction(type, params) {
  return function() {
    return dispatchEvent(this, type, params.apply(this, arguments));
  };
}
function selection_dispatch(type, params) {
  return this.each((typeof params === "function" ? dispatchFunction : dispatchConstant)(type, params));
}
function* selection_iterator() {
  for (var groups = this._groups, j2 = 0, m2 = groups.length; j2 < m2; ++j2) {
    for (var group = groups[j2], i = 0, n = group.length, node; i < n; ++i) {
      if (node = group[i]) yield node;
    }
  }
}
var root$1g = [null];
function Selection$2(groups, parents) {
  this._groups = groups;
  this._parents = parents;
}
function selection$1() {
  return new Selection$2([[document.documentElement]], root$1g);
}
function selection_selection() {
  return this;
}
Selection$2.prototype = selection$1.prototype = {
  constructor: Selection$2,
  select: selection_select,
  selectAll: selection_selectAll,
  selectChild: selection_selectChild,
  selectChildren: selection_selectChildren,
  filter: selection_filter,
  data: selection_data,
  enter: selection_enter,
  exit: selection_exit,
  join: selection_join,
  merge: selection_merge,
  selection: selection_selection,
  order: selection_order,
  sort: selection_sort,
  call: selection_call,
  nodes: selection_nodes,
  node: selection_node,
  size: selection_size,
  empty: selection_empty,
  each: selection_each,
  attr: selection_attr,
  style: selection_style,
  property: selection_property,
  classed: selection_classed,
  text: selection_text,
  html: selection_html,
  raise: selection_raise,
  lower: selection_lower,
  append: selection_append,
  insert: selection_insert,
  remove: selection_remove,
  clone: selection_clone,
  datum: selection_datum,
  on: selection_on,
  dispatch: selection_dispatch,
  [Symbol.iterator]: selection_iterator
};
function select(selector2) {
  return typeof selector2 === "string" ? new Selection$2([[document.querySelector(selector2)]], [document.documentElement]) : new Selection$2([[selector2]], root$1g);
}
function sourceEvent(event2) {
  let sourceEvent2;
  while (sourceEvent2 = event2.sourceEvent) event2 = sourceEvent2;
  return event2;
}
function pointer(event2, node) {
  event2 = sourceEvent(event2);
  if (node === void 0) node = event2.currentTarget;
  if (node) {
    var svg2 = node.ownerSVGElement || node;
    if (svg2.createSVGPoint) {
      var point = svg2.createSVGPoint();
      point.x = event2.clientX, point.y = event2.clientY;
      point = point.matrixTransform(node.getScreenCTM().inverse());
      return [point.x, point.y];
    }
    if (node.getBoundingClientRect) {
      var rect = node.getBoundingClientRect();
      return [event2.clientX - rect.left - node.clientLeft, event2.clientY - rect.top - node.clientTop];
    }
  }
  return [event2.pageX, event2.pageY];
}
const nonpassive = { passive: false };
const nonpassivecapture = { capture: true, passive: false };
function nopropagation$1(event2) {
  event2.stopImmediatePropagation();
}
function noevent$1(event2) {
  event2.preventDefault();
  event2.stopImmediatePropagation();
}
function dragDisable(view) {
  var root2 = view.document.documentElement, selection2 = select(view).on("dragstart.drag", noevent$1, nonpassivecapture);
  if ("onselectstart" in root2) {
    selection2.on("selectstart.drag", noevent$1, nonpassivecapture);
  } else {
    root2.__noselect = root2.style.MozUserSelect;
    root2.style.MozUserSelect = "none";
  }
}
function yesdrag(view, noclick) {
  var root2 = view.document.documentElement, selection2 = select(view).on("dragstart.drag", null);
  if (noclick) {
    selection2.on("click.drag", noevent$1, nonpassivecapture);
    setTimeout(function() {
      selection2.on("click.drag", null);
    }, 0);
  }
  if ("onselectstart" in root2) {
    selection2.on("selectstart.drag", null);
  } else {
    root2.style.MozUserSelect = root2.__noselect;
    delete root2.__noselect;
  }
}
const constant$2 = (x2) => () => x2;
function DragEvent(type, {
  sourceEvent: sourceEvent2,
  subject,
  target,
  identifier,
  active,
  x: x2,
  y: y2,
  dx,
  dy,
  dispatch: dispatch2
}) {
  Object.defineProperties(this, {
    type: { value: type, enumerable: true, configurable: true },
    sourceEvent: { value: sourceEvent2, enumerable: true, configurable: true },
    subject: { value: subject, enumerable: true, configurable: true },
    target: { value: target, enumerable: true, configurable: true },
    identifier: { value: identifier, enumerable: true, configurable: true },
    active: { value: active, enumerable: true, configurable: true },
    x: { value: x2, enumerable: true, configurable: true },
    y: { value: y2, enumerable: true, configurable: true },
    dx: { value: dx, enumerable: true, configurable: true },
    dy: { value: dy, enumerable: true, configurable: true },
    _: { value: dispatch2 }
  });
}
DragEvent.prototype.on = function() {
  var value = this._.on.apply(this._, arguments);
  return value === this._ ? this : value;
};
function defaultFilter$1(event2) {
  return !event2.ctrlKey && !event2.button;
}
function defaultContainer() {
  return this.parentNode;
}
function defaultSubject(event2, d) {
  return d == null ? { x: event2.x, y: event2.y } : d;
}
function defaultTouchable$1() {
  return navigator.maxTouchPoints || "ontouchstart" in this;
}
function drag$1() {
  var filter2 = defaultFilter$1, container = defaultContainer, subject = defaultSubject, touchable = defaultTouchable$1, gestures = {}, listeners = dispatch("start", "drag", "end"), active = 0, mousedownx, mousedowny, mousemoving, touchending, clickDistance2 = 0;
  function drag2(selection2) {
    selection2.on("mousedown.drag", mousedowned).filter(touchable).on("touchstart.drag", touchstarted).on("touchmove.drag", touchmoved, nonpassive).on("touchend.drag touchcancel.drag", touchended).style("touch-action", "none").style("-webkit-tap-highlight-color", "rgba(0,0,0,0)");
  }
  function mousedowned(event2, d) {
    if (touchending || !filter2.call(this, event2, d)) return;
    var gesture = beforestart(this, container.call(this, event2, d), event2, d, "mouse");
    if (!gesture) return;
    select(event2.view).on("mousemove.drag", mousemoved, nonpassivecapture).on("mouseup.drag", mouseupped, nonpassivecapture);
    dragDisable(event2.view);
    nopropagation$1(event2);
    mousemoving = false;
    mousedownx = event2.clientX;
    mousedowny = event2.clientY;
    gesture("start", event2);
  }
  function mousemoved(event2) {
    noevent$1(event2);
    if (!mousemoving) {
      var dx = event2.clientX - mousedownx, dy = event2.clientY - mousedowny;
      mousemoving = dx * dx + dy * dy > clickDistance2;
    }
    gestures.mouse("drag", event2);
  }
  function mouseupped(event2) {
    select(event2.view).on("mousemove.drag mouseup.drag", null);
    yesdrag(event2.view, mousemoving);
    noevent$1(event2);
    gestures.mouse("end", event2);
  }
  function touchstarted(event2, d) {
    if (!filter2.call(this, event2, d)) return;
    var touches = event2.changedTouches, c = container.call(this, event2, d), n = touches.length, i, gesture;
    for (i = 0; i < n; ++i) {
      if (gesture = beforestart(this, c, event2, d, touches[i].identifier, touches[i])) {
        nopropagation$1(event2);
        gesture("start", event2, touches[i]);
      }
    }
  }
  function touchmoved(event2) {
    var touches = event2.changedTouches, n = touches.length, i, gesture;
    for (i = 0; i < n; ++i) {
      if (gesture = gestures[touches[i].identifier]) {
        noevent$1(event2);
        gesture("drag", event2, touches[i]);
      }
    }
  }
  function touchended(event2) {
    var touches = event2.changedTouches, n = touches.length, i, gesture;
    if (touchending) clearTimeout(touchending);
    touchending = setTimeout(function() {
      touchending = null;
    }, 500);
    for (i = 0; i < n; ++i) {
      if (gesture = gestures[touches[i].identifier]) {
        nopropagation$1(event2);
        gesture("end", event2, touches[i]);
      }
    }
  }
  function beforestart(that, container2, event2, d, identifier, touch) {
    var dispatch2 = listeners.copy(), p = pointer(touch || event2, container2), dx, dy, s;
    if ((s = subject.call(that, new DragEvent("beforestart", {
      sourceEvent: event2,
      target: drag2,
      identifier,
      active,
      x: p[0],
      y: p[1],
      dx: 0,
      dy: 0,
      dispatch: dispatch2
    }), d)) == null) return;
    dx = s.x - p[0] || 0;
    dy = s.y - p[1] || 0;
    return function gesture(type, event3, touch2) {
      var p0 = p, n;
      switch (type) {
        case "start":
          gestures[identifier] = gesture, n = active++;
          break;
        case "end":
          delete gestures[identifier], --active;
        // falls through
        case "drag":
          p = pointer(touch2 || event3, container2), n = active;
          break;
      }
      dispatch2.call(
        type,
        that,
        new DragEvent(type, {
          sourceEvent: event3,
          subject: s,
          target: drag2,
          identifier,
          active: n,
          x: p[0] + dx,
          y: p[1] + dy,
          dx: p[0] - p0[0],
          dy: p[1] - p0[1],
          dispatch: dispatch2
        }),
        d
      );
    };
  }
  drag2.filter = function(_2) {
    return arguments.length ? (filter2 = typeof _2 === "function" ? _2 : constant$2(!!_2), drag2) : filter2;
  };
  drag2.container = function(_2) {
    return arguments.length ? (container = typeof _2 === "function" ? _2 : constant$2(_2), drag2) : container;
  };
  drag2.subject = function(_2) {
    return arguments.length ? (subject = typeof _2 === "function" ? _2 : constant$2(_2), drag2) : subject;
  };
  drag2.touchable = function(_2) {
    return arguments.length ? (touchable = typeof _2 === "function" ? _2 : constant$2(!!_2), drag2) : touchable;
  };
  drag2.on = function() {
    var value = listeners.on.apply(listeners, arguments);
    return value === listeners ? drag2 : value;
  };
  drag2.clickDistance = function(_2) {
    return arguments.length ? (clickDistance2 = (_2 = +_2) * _2, drag2) : Math.sqrt(clickDistance2);
  };
  return drag2;
}
function define(constructor, factory, prototype) {
  constructor.prototype = factory.prototype = prototype;
  prototype.constructor = constructor;
}
function extend(parent, definition) {
  var prototype = Object.create(parent.prototype);
  for (var key2 in definition) prototype[key2] = definition[key2];
  return prototype;
}
function Color() {
}
var darker = 0.7;
var brighter = 1 / darker;
var reI = "\\s*([+-]?\\d+)\\s*", reN = "\\s*([+-]?(?:\\d*\\.)?\\d+(?:[eE][+-]?\\d+)?)\\s*", reP = "\\s*([+-]?(?:\\d*\\.)?\\d+(?:[eE][+-]?\\d+)?)%\\s*", reHex = /^#([0-9a-f]{3,8})$/, reRgbInteger = new RegExp(`^rgb\\(${reI},${reI},${reI}\\)$`), reRgbPercent = new RegExp(`^rgb\\(${reP},${reP},${reP}\\)$`), reRgbaInteger = new RegExp(`^rgba\\(${reI},${reI},${reI},${reN}\\)$`), reRgbaPercent = new RegExp(`^rgba\\(${reP},${reP},${reP},${reN}\\)$`), reHslPercent = new RegExp(`^hsl\\(${reN},${reP},${reP}\\)$`), reHslaPercent = new RegExp(`^hsla\\(${reN},${reP},${reP},${reN}\\)$`);
var named = {
  aliceblue: 15792383,
  antiquewhite: 16444375,
  aqua: 65535,
  aquamarine: 8388564,
  azure: 15794175,
  beige: 16119260,
  bisque: 16770244,
  black: 0,
  blanchedalmond: 16772045,
  blue: 255,
  blueviolet: 9055202,
  brown: 10824234,
  burlywood: 14596231,
  cadetblue: 6266528,
  chartreuse: 8388352,
  chocolate: 13789470,
  coral: 16744272,
  cornflowerblue: 6591981,
  cornsilk: 16775388,
  crimson: 14423100,
  cyan: 65535,
  darkblue: 139,
  darkcyan: 35723,
  darkgoldenrod: 12092939,
  darkgray: 11119017,
  darkgreen: 25600,
  darkgrey: 11119017,
  darkkhaki: 12433259,
  darkmagenta: 9109643,
  darkolivegreen: 5597999,
  darkorange: 16747520,
  darkorchid: 10040012,
  darkred: 9109504,
  darksalmon: 15308410,
  darkseagreen: 9419919,
  darkslateblue: 4734347,
  darkslategray: 3100495,
  darkslategrey: 3100495,
  darkturquoise: 52945,
  darkviolet: 9699539,
  deeppink: 16716947,
  deepskyblue: 49151,
  dimgray: 6908265,
  dimgrey: 6908265,
  dodgerblue: 2003199,
  firebrick: 11674146,
  floralwhite: 16775920,
  forestgreen: 2263842,
  fuchsia: 16711935,
  gainsboro: 14474460,
  ghostwhite: 16316671,
  gold: 16766720,
  goldenrod: 14329120,
  gray: 8421504,
  green: 32768,
  greenyellow: 11403055,
  grey: 8421504,
  honeydew: 15794160,
  hotpink: 16738740,
  indianred: 13458524,
  indigo: 4915330,
  ivory: 16777200,
  khaki: 15787660,
  lavender: 15132410,
  lavenderblush: 16773365,
  lawngreen: 8190976,
  lemonchiffon: 16775885,
  lightblue: 11393254,
  lightcoral: 15761536,
  lightcyan: 14745599,
  lightgoldenrodyellow: 16448210,
  lightgray: 13882323,
  lightgreen: 9498256,
  lightgrey: 13882323,
  lightpink: 16758465,
  lightsalmon: 16752762,
  lightseagreen: 2142890,
  lightskyblue: 8900346,
  lightslategray: 7833753,
  lightslategrey: 7833753,
  lightsteelblue: 11584734,
  lightyellow: 16777184,
  lime: 65280,
  limegreen: 3329330,
  linen: 16445670,
  magenta: 16711935,
  maroon: 8388608,
  mediumaquamarine: 6737322,
  mediumblue: 205,
  mediumorchid: 12211667,
  mediumpurple: 9662683,
  mediumseagreen: 3978097,
  mediumslateblue: 8087790,
  mediumspringgreen: 64154,
  mediumturquoise: 4772300,
  mediumvioletred: 13047173,
  midnightblue: 1644912,
  mintcream: 16121850,
  mistyrose: 16770273,
  moccasin: 16770229,
  navajowhite: 16768685,
  navy: 128,
  oldlace: 16643558,
  olive: 8421376,
  olivedrab: 7048739,
  orange: 16753920,
  orangered: 16729344,
  orchid: 14315734,
  palegoldenrod: 15657130,
  palegreen: 10025880,
  paleturquoise: 11529966,
  palevioletred: 14381203,
  papayawhip: 16773077,
  peachpuff: 16767673,
  peru: 13468991,
  pink: 16761035,
  plum: 14524637,
  powderblue: 11591910,
  purple: 8388736,
  rebeccapurple: 6697881,
  red: 16711680,
  rosybrown: 12357519,
  royalblue: 4286945,
  saddlebrown: 9127187,
  salmon: 16416882,
  sandybrown: 16032864,
  seagreen: 3050327,
  seashell: 16774638,
  sienna: 10506797,
  silver: 12632256,
  skyblue: 8900331,
  slateblue: 6970061,
  slategray: 7372944,
  slategrey: 7372944,
  snow: 16775930,
  springgreen: 65407,
  steelblue: 4620980,
  tan: 13808780,
  teal: 32896,
  thistle: 14204888,
  tomato: 16737095,
  turquoise: 4251856,
  violet: 15631086,
  wheat: 16113331,
  white: 16777215,
  whitesmoke: 16119285,
  yellow: 16776960,
  yellowgreen: 10145074
};
define(Color, color, {
  copy(channels) {
    return Object.assign(new this.constructor(), this, channels);
  },
  displayable() {
    return this.rgb().displayable();
  },
  hex: color_formatHex,
  // Deprecated! Use color.formatHex.
  formatHex: color_formatHex,
  formatHex8: color_formatHex8,
  formatHsl: color_formatHsl,
  formatRgb: color_formatRgb,
  toString: color_formatRgb
});
function color_formatHex() {
  return this.rgb().formatHex();
}
function color_formatHex8() {
  return this.rgb().formatHex8();
}
function color_formatHsl() {
  return hslConvert(this).formatHsl();
}
function color_formatRgb() {
  return this.rgb().formatRgb();
}
function color(format) {
  var m2, l;
  format = (format + "").trim().toLowerCase();
  return (m2 = reHex.exec(format)) ? (l = m2[1].length, m2 = parseInt(m2[1], 16), l === 6 ? rgbn(m2) : l === 3 ? new Rgb(m2 >> 8 & 15 | m2 >> 4 & 240, m2 >> 4 & 15 | m2 & 240, (m2 & 15) << 4 | m2 & 15, 1) : l === 8 ? rgba(m2 >> 24 & 255, m2 >> 16 & 255, m2 >> 8 & 255, (m2 & 255) / 255) : l === 4 ? rgba(m2 >> 12 & 15 | m2 >> 8 & 240, m2 >> 8 & 15 | m2 >> 4 & 240, m2 >> 4 & 15 | m2 & 240, ((m2 & 15) << 4 | m2 & 15) / 255) : null) : (m2 = reRgbInteger.exec(format)) ? new Rgb(m2[1], m2[2], m2[3], 1) : (m2 = reRgbPercent.exec(format)) ? new Rgb(m2[1] * 255 / 100, m2[2] * 255 / 100, m2[3] * 255 / 100, 1) : (m2 = reRgbaInteger.exec(format)) ? rgba(m2[1], m2[2], m2[3], m2[4]) : (m2 = reRgbaPercent.exec(format)) ? rgba(m2[1] * 255 / 100, m2[2] * 255 / 100, m2[3] * 255 / 100, m2[4]) : (m2 = reHslPercent.exec(format)) ? hsla(m2[1], m2[2] / 100, m2[3] / 100, 1) : (m2 = reHslaPercent.exec(format)) ? hsla(m2[1], m2[2] / 100, m2[3] / 100, m2[4]) : named.hasOwnProperty(format) ? rgbn(named[format]) : format === "transparent" ? new Rgb(NaN, NaN, NaN, 0) : null;
}
function rgbn(n) {
  return new Rgb(n >> 16 & 255, n >> 8 & 255, n & 255, 1);
}
function rgba(r2, g, b2, a) {
  if (a <= 0) r2 = g = b2 = NaN;
  return new Rgb(r2, g, b2, a);
}
function rgbConvert(o) {
  if (!(o instanceof Color)) o = color(o);
  if (!o) return new Rgb();
  o = o.rgb();
  return new Rgb(o.r, o.g, o.b, o.opacity);
}
function rgb(r2, g, b2, opacity) {
  return arguments.length === 1 ? rgbConvert(r2) : new Rgb(r2, g, b2, opacity == null ? 1 : opacity);
}
function Rgb(r2, g, b2, opacity) {
  this.r = +r2;
  this.g = +g;
  this.b = +b2;
  this.opacity = +opacity;
}
define(Rgb, rgb, extend(Color, {
  brighter(k2) {
    k2 = k2 == null ? brighter : Math.pow(brighter, k2);
    return new Rgb(this.r * k2, this.g * k2, this.b * k2, this.opacity);
  },
  darker(k2) {
    k2 = k2 == null ? darker : Math.pow(darker, k2);
    return new Rgb(this.r * k2, this.g * k2, this.b * k2, this.opacity);
  },
  rgb() {
    return this;
  },
  clamp() {
    return new Rgb(clampi(this.r), clampi(this.g), clampi(this.b), clampa(this.opacity));
  },
  displayable() {
    return -0.5 <= this.r && this.r < 255.5 && (-0.5 <= this.g && this.g < 255.5) && (-0.5 <= this.b && this.b < 255.5) && (0 <= this.opacity && this.opacity <= 1);
  },
  hex: rgb_formatHex,
  // Deprecated! Use color.formatHex.
  formatHex: rgb_formatHex,
  formatHex8: rgb_formatHex8,
  formatRgb: rgb_formatRgb,
  toString: rgb_formatRgb
}));
function rgb_formatHex() {
  return `#${hex(this.r)}${hex(this.g)}${hex(this.b)}`;
}
function rgb_formatHex8() {
  return `#${hex(this.r)}${hex(this.g)}${hex(this.b)}${hex((isNaN(this.opacity) ? 1 : this.opacity) * 255)}`;
}
function rgb_formatRgb() {
  const a = clampa(this.opacity);
  return `${a === 1 ? "rgb(" : "rgba("}${clampi(this.r)}, ${clampi(this.g)}, ${clampi(this.b)}${a === 1 ? ")" : `, ${a})`}`;
}
function clampa(opacity) {
  return isNaN(opacity) ? 1 : Math.max(0, Math.min(1, opacity));
}
function clampi(value) {
  return Math.max(0, Math.min(255, Math.round(value) || 0));
}
function hex(value) {
  value = clampi(value);
  return (value < 16 ? "0" : "") + value.toString(16);
}
function hsla(h2, s, l, a) {
  if (a <= 0) h2 = s = l = NaN;
  else if (l <= 0 || l >= 1) h2 = s = NaN;
  else if (s <= 0) h2 = NaN;
  return new Hsl(h2, s, l, a);
}
function hslConvert(o) {
  if (o instanceof Hsl) return new Hsl(o.h, o.s, o.l, o.opacity);
  if (!(o instanceof Color)) o = color(o);
  if (!o) return new Hsl();
  if (o instanceof Hsl) return o;
  o = o.rgb();
  var r2 = o.r / 255, g = o.g / 255, b2 = o.b / 255, min = Math.min(r2, g, b2), max = Math.max(r2, g, b2), h2 = NaN, s = max - min, l = (max + min) / 2;
  if (s) {
    if (r2 === max) h2 = (g - b2) / s + (g < b2) * 6;
    else if (g === max) h2 = (b2 - r2) / s + 2;
    else h2 = (r2 - g) / s + 4;
    s /= l < 0.5 ? max + min : 2 - max - min;
    h2 *= 60;
  } else {
    s = l > 0 && l < 1 ? 0 : h2;
  }
  return new Hsl(h2, s, l, o.opacity);
}
function hsl(h2, s, l, opacity) {
  return arguments.length === 1 ? hslConvert(h2) : new Hsl(h2, s, l, opacity == null ? 1 : opacity);
}
function Hsl(h2, s, l, opacity) {
  this.h = +h2;
  this.s = +s;
  this.l = +l;
  this.opacity = +opacity;
}
define(Hsl, hsl, extend(Color, {
  brighter(k2) {
    k2 = k2 == null ? brighter : Math.pow(brighter, k2);
    return new Hsl(this.h, this.s, this.l * k2, this.opacity);
  },
  darker(k2) {
    k2 = k2 == null ? darker : Math.pow(darker, k2);
    return new Hsl(this.h, this.s, this.l * k2, this.opacity);
  },
  rgb() {
    var h2 = this.h % 360 + (this.h < 0) * 360, s = isNaN(h2) || isNaN(this.s) ? 0 : this.s, l = this.l, m2 = l + (l < 0.5 ? l : 1 - l) * s, m1 = 2 * l - m2;
    return new Rgb(
      hsl2rgb(h2 >= 240 ? h2 - 240 : h2 + 120, m1, m2),
      hsl2rgb(h2, m1, m2),
      hsl2rgb(h2 < 120 ? h2 + 240 : h2 - 120, m1, m2),
      this.opacity
    );
  },
  clamp() {
    return new Hsl(clamph(this.h), clampt(this.s), clampt(this.l), clampa(this.opacity));
  },
  displayable() {
    return (0 <= this.s && this.s <= 1 || isNaN(this.s)) && (0 <= this.l && this.l <= 1) && (0 <= this.opacity && this.opacity <= 1);
  },
  formatHsl() {
    const a = clampa(this.opacity);
    return `${a === 1 ? "hsl(" : "hsla("}${clamph(this.h)}, ${clampt(this.s) * 100}%, ${clampt(this.l) * 100}%${a === 1 ? ")" : `, ${a})`}`;
  }
}));
function clamph(value) {
  value = (value || 0) % 360;
  return value < 0 ? value + 360 : value;
}
function clampt(value) {
  return Math.max(0, Math.min(1, value || 0));
}
function hsl2rgb(h2, m1, m2) {
  return (h2 < 60 ? m1 + (m2 - m1) * h2 / 60 : h2 < 180 ? m2 : h2 < 240 ? m1 + (m2 - m1) * (240 - h2) / 60 : m1) * 255;
}
const constant$1 = (x2) => () => x2;
function linear(a, d) {
  return function(t2) {
    return a + t2 * d;
  };
}
function exponential(a, b2, y2) {
  return a = Math.pow(a, y2), b2 = Math.pow(b2, y2) - a, y2 = 1 / y2, function(t2) {
    return Math.pow(a + t2 * b2, y2);
  };
}
function gamma(y2) {
  return (y2 = +y2) === 1 ? nogamma : function(a, b2) {
    return b2 - a ? exponential(a, b2, y2) : constant$1(isNaN(a) ? b2 : a);
  };
}
function nogamma(a, b2) {
  var d = b2 - a;
  return d ? linear(a, d) : constant$1(isNaN(a) ? b2 : a);
}
const interpolateRgb = (function rgbGamma(y2) {
  var color2 = gamma(y2);
  function rgb$1(start2, end) {
    var r2 = color2((start2 = rgb(start2)).r, (end = rgb(end)).r), g = color2(start2.g, end.g), b2 = color2(start2.b, end.b), opacity = nogamma(start2.opacity, end.opacity);
    return function(t2) {
      start2.r = r2(t2);
      start2.g = g(t2);
      start2.b = b2(t2);
      start2.opacity = opacity(t2);
      return start2 + "";
    };
  }
  rgb$1.gamma = rgbGamma;
  return rgb$1;
})(1);
function numberArray(a, b2) {
  if (!b2) b2 = [];
  var n = a ? Math.min(b2.length, a.length) : 0, c = b2.slice(), i;
  return function(t2) {
    for (i = 0; i < n; ++i) c[i] = a[i] * (1 - t2) + b2[i] * t2;
    return c;
  };
}
function isNumberArray(x2) {
  return ArrayBuffer.isView(x2) && !(x2 instanceof DataView);
}
function genericArray(a, b2) {
  var nb = b2 ? b2.length : 0, na = a ? Math.min(nb, a.length) : 0, x2 = new Array(na), c = new Array(nb), i;
  for (i = 0; i < na; ++i) x2[i] = interpolate$1(a[i], b2[i]);
  for (; i < nb; ++i) c[i] = b2[i];
  return function(t2) {
    for (i = 0; i < na; ++i) c[i] = x2[i](t2);
    return c;
  };
}
function date(a, b2) {
  var d = /* @__PURE__ */ new Date();
  return a = +a, b2 = +b2, function(t2) {
    return d.setTime(a * (1 - t2) + b2 * t2), d;
  };
}
function interpolateNumber(a, b2) {
  return a = +a, b2 = +b2, function(t2) {
    return a * (1 - t2) + b2 * t2;
  };
}
function object(a, b2) {
  var i = {}, c = {}, k2;
  if (a === null || typeof a !== "object") a = {};
  if (b2 === null || typeof b2 !== "object") b2 = {};
  for (k2 in b2) {
    if (k2 in a) {
      i[k2] = interpolate$1(a[k2], b2[k2]);
    } else {
      c[k2] = b2[k2];
    }
  }
  return function(t2) {
    for (k2 in i) c[k2] = i[k2](t2);
    return c;
  };
}
var reA = /[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g, reB = new RegExp(reA.source, "g");
function zero(b2) {
  return function() {
    return b2;
  };
}
function one(b2) {
  return function(t2) {
    return b2(t2) + "";
  };
}
function interpolateString(a, b2) {
  var bi = reA.lastIndex = reB.lastIndex = 0, am, bm, bs, i = -1, s = [], q2 = [];
  a = a + "", b2 = b2 + "";
  while ((am = reA.exec(a)) && (bm = reB.exec(b2))) {
    if ((bs = bm.index) > bi) {
      bs = b2.slice(bi, bs);
      if (s[i]) s[i] += bs;
      else s[++i] = bs;
    }
    if ((am = am[0]) === (bm = bm[0])) {
      if (s[i]) s[i] += bm;
      else s[++i] = bm;
    } else {
      s[++i] = null;
      q2.push({ i, x: interpolateNumber(am, bm) });
    }
    bi = reB.lastIndex;
  }
  if (bi < b2.length) {
    bs = b2.slice(bi);
    if (s[i]) s[i] += bs;
    else s[++i] = bs;
  }
  return s.length < 2 ? q2[0] ? one(q2[0].x) : zero(b2) : (b2 = q2.length, function(t2) {
    for (var i2 = 0, o; i2 < b2; ++i2) s[(o = q2[i2]).i] = o.x(t2);
    return s.join("");
  });
}
function interpolate$1(a, b2) {
  var t2 = typeof b2, c;
  return b2 == null || t2 === "boolean" ? constant$1(b2) : (t2 === "number" ? interpolateNumber : t2 === "string" ? (c = color(b2)) ? (b2 = c, interpolateRgb) : interpolateString : b2 instanceof color ? interpolateRgb : b2 instanceof Date ? date : isNumberArray(b2) ? numberArray : Array.isArray(b2) ? genericArray : typeof b2.valueOf !== "function" && typeof b2.toString !== "function" || isNaN(b2) ? object : interpolateNumber)(a, b2);
}
var degrees = 180 / Math.PI;
var identity$1 = {
  translateX: 0,
  translateY: 0,
  rotate: 0,
  skewX: 0,
  scaleX: 1,
  scaleY: 1
};
function decompose(a, b2, c, d, e, f) {
  var scaleX, scaleY, skewX;
  if (scaleX = Math.sqrt(a * a + b2 * b2)) a /= scaleX, b2 /= scaleX;
  if (skewX = a * c + b2 * d) c -= a * skewX, d -= b2 * skewX;
  if (scaleY = Math.sqrt(c * c + d * d)) c /= scaleY, d /= scaleY, skewX /= scaleY;
  if (a * d < b2 * c) a = -a, b2 = -b2, skewX = -skewX, scaleX = -scaleX;
  return {
    translateX: e,
    translateY: f,
    rotate: Math.atan2(b2, a) * degrees,
    skewX: Math.atan(skewX) * degrees,
    scaleX,
    scaleY
  };
}
var svgNode;
function parseCss(value) {
  const m2 = new (typeof DOMMatrix === "function" ? DOMMatrix : WebKitCSSMatrix)(value + "");
  return m2.isIdentity ? identity$1 : decompose(m2.a, m2.b, m2.c, m2.d, m2.e, m2.f);
}
function parseSvg(value) {
  if (value == null) return identity$1;
  if (!svgNode) svgNode = document.createElementNS("http://www.w3.org/2000/svg", "g");
  svgNode.setAttribute("transform", value);
  if (!(value = svgNode.transform.baseVal.consolidate())) return identity$1;
  value = value.matrix;
  return decompose(value.a, value.b, value.c, value.d, value.e, value.f);
}
function interpolateTransform(parse2, pxComma, pxParen, degParen) {
  function pop2(s) {
    return s.length ? s.pop() + " " : "";
  }
  function translate(xa, ya, xb, yb, s, q2) {
    if (xa !== xb || ya !== yb) {
      var i = s.push("translate(", null, pxComma, null, pxParen);
      q2.push({ i: i - 4, x: interpolateNumber(xa, xb) }, { i: i - 2, x: interpolateNumber(ya, yb) });
    } else if (xb || yb) {
      s.push("translate(" + xb + pxComma + yb + pxParen);
    }
  }
  function rotate(a, b2, s, q2) {
    if (a !== b2) {
      if (a - b2 > 180) b2 += 360;
      else if (b2 - a > 180) a += 360;
      q2.push({ i: s.push(pop2(s) + "rotate(", null, degParen) - 2, x: interpolateNumber(a, b2) });
    } else if (b2) {
      s.push(pop2(s) + "rotate(" + b2 + degParen);
    }
  }
  function skewX(a, b2, s, q2) {
    if (a !== b2) {
      q2.push({ i: s.push(pop2(s) + "skewX(", null, degParen) - 2, x: interpolateNumber(a, b2) });
    } else if (b2) {
      s.push(pop2(s) + "skewX(" + b2 + degParen);
    }
  }
  function scale(xa, ya, xb, yb, s, q2) {
    if (xa !== xb || ya !== yb) {
      var i = s.push(pop2(s) + "scale(", null, ",", null, ")");
      q2.push({ i: i - 4, x: interpolateNumber(xa, xb) }, { i: i - 2, x: interpolateNumber(ya, yb) });
    } else if (xb !== 1 || yb !== 1) {
      s.push(pop2(s) + "scale(" + xb + "," + yb + ")");
    }
  }
  return function(a, b2) {
    var s = [], q2 = [];
    a = parse2(a), b2 = parse2(b2);
    translate(a.translateX, a.translateY, b2.translateX, b2.translateY, s, q2);
    rotate(a.rotate, b2.rotate, s, q2);
    skewX(a.skewX, b2.skewX, s, q2);
    scale(a.scaleX, a.scaleY, b2.scaleX, b2.scaleY, s, q2);
    a = b2 = null;
    return function(t2) {
      var i = -1, n = q2.length, o;
      while (++i < n) s[(o = q2[i]).i] = o.x(t2);
      return s.join("");
    };
  };
}
var interpolateTransformCss = interpolateTransform(parseCss, "px, ", "px)", "deg)");
var interpolateTransformSvg = interpolateTransform(parseSvg, ", ", ")", ")");
var epsilon2 = 1e-12;
function cosh(x2) {
  return ((x2 = Math.exp(x2)) + 1 / x2) / 2;
}
function sinh(x2) {
  return ((x2 = Math.exp(x2)) - 1 / x2) / 2;
}
function tanh(x2) {
  return ((x2 = Math.exp(2 * x2)) - 1) / (x2 + 1);
}
const interpolateZoom = (function zoomRho(rho, rho2, rho4) {
  function zoom2(p0, p1) {
    var ux0 = p0[0], uy0 = p0[1], w0 = p0[2], ux1 = p1[0], uy1 = p1[1], w1 = p1[2], dx = ux1 - ux0, dy = uy1 - uy0, d2 = dx * dx + dy * dy, i, S2;
    if (d2 < epsilon2) {
      S2 = Math.log(w1 / w0) / rho;
      i = function(t2) {
        return [
          ux0 + t2 * dx,
          uy0 + t2 * dy,
          w0 * Math.exp(rho * t2 * S2)
        ];
      };
    } else {
      var d1 = Math.sqrt(d2), b0 = (w1 * w1 - w0 * w0 + rho4 * d2) / (2 * w0 * rho2 * d1), b1 = (w1 * w1 - w0 * w0 - rho4 * d2) / (2 * w1 * rho2 * d1), r0 = Math.log(Math.sqrt(b0 * b0 + 1) - b0), r1 = Math.log(Math.sqrt(b1 * b1 + 1) - b1);
      S2 = (r1 - r0) / rho;
      i = function(t2) {
        var s = t2 * S2, coshr0 = cosh(r0), u3 = w0 / (rho2 * d1) * (coshr0 * tanh(rho * s + r0) - sinh(r0));
        return [
          ux0 + u3 * dx,
          uy0 + u3 * dy,
          w0 * coshr0 / cosh(rho * s + r0)
        ];
      };
    }
    i.duration = S2 * 1e3 * rho / Math.SQRT2;
    return i;
  }
  zoom2.rho = function(_2) {
    var _1 = Math.max(1e-3, +_2), _22 = _1 * _1, _4 = _22 * _22;
    return zoomRho(_1, _22, _4);
  };
  return zoom2;
})(Math.SQRT2, 2, 4);
var frame = 0, timeout$1 = 0, interval = 0, pokeDelay = 1e3, taskHead, taskTail, clockLast = 0, clockNow = 0, clockSkew = 0, clock = typeof performance === "object" && performance.now ? performance : Date, setFrame = typeof window === "object" && window.requestAnimationFrame ? window.requestAnimationFrame.bind(window) : function(f) {
  setTimeout(f, 17);
};
function now() {
  return clockNow || (setFrame(clearNow), clockNow = clock.now() + clockSkew);
}
function clearNow() {
  clockNow = 0;
}
function Timer() {
  this._call = this._time = this._next = null;
}
Timer.prototype = timer.prototype = {
  constructor: Timer,
  restart: function(callback, delay, time) {
    if (typeof callback !== "function") throw new TypeError("callback is not a function");
    time = (time == null ? now() : +time) + (delay == null ? 0 : +delay);
    if (!this._next && taskTail !== this) {
      if (taskTail) taskTail._next = this;
      else taskHead = this;
      taskTail = this;
    }
    this._call = callback;
    this._time = time;
    sleep();
  },
  stop: function() {
    if (this._call) {
      this._call = null;
      this._time = Infinity;
      sleep();
    }
  }
};
function timer(callback, delay, time) {
  var t2 = new Timer();
  t2.restart(callback, delay, time);
  return t2;
}
function timerFlush() {
  now();
  ++frame;
  var t2 = taskHead, e;
  while (t2) {
    if ((e = clockNow - t2._time) >= 0) t2._call.call(void 0, e);
    t2 = t2._next;
  }
  --frame;
}
function wake() {
  clockNow = (clockLast = clock.now()) + clockSkew;
  frame = timeout$1 = 0;
  try {
    timerFlush();
  } finally {
    frame = 0;
    nap();
    clockNow = 0;
  }
}
function poke() {
  var now2 = clock.now(), delay = now2 - clockLast;
  if (delay > pokeDelay) clockSkew -= delay, clockLast = now2;
}
function nap() {
  var t0, t1 = taskHead, t2, time = Infinity;
  while (t1) {
    if (t1._call) {
      if (time > t1._time) time = t1._time;
      t0 = t1, t1 = t1._next;
    } else {
      t2 = t1._next, t1._next = null;
      t1 = t0 ? t0._next = t2 : taskHead = t2;
    }
  }
  taskTail = t0;
  sleep(time);
}
function sleep(time) {
  if (frame) return;
  if (timeout$1) timeout$1 = clearTimeout(timeout$1);
  var delay = time - clockNow;
  if (delay > 24) {
    if (time < Infinity) timeout$1 = setTimeout(wake, time - clock.now() - clockSkew);
    if (interval) interval = clearInterval(interval);
  } else {
    if (!interval) clockLast = clock.now(), interval = setInterval(poke, pokeDelay);
    frame = 1, setFrame(wake);
  }
}
function timeout(callback, delay, time) {
  var t2 = new Timer();
  delay = delay == null ? 0 : +delay;
  t2.restart((elapsed) => {
    t2.stop();
    callback(elapsed + delay);
  }, delay, time);
  return t2;
}
var emptyOn = dispatch("start", "end", "cancel", "interrupt");
var emptyTween = [];
var CREATED = 0;
var SCHEDULED = 1;
var STARTING = 2;
var STARTED = 3;
var RUNNING = 4;
var ENDING = 5;
var ENDED = 6;
function schedule(node, name2, id2, index2, group, timing) {
  var schedules = node.__transition;
  if (!schedules) node.__transition = {};
  else if (id2 in schedules) return;
  create(node, id2, {
    name: name2,
    index: index2,
    // For context during callback.
    group,
    // For context during callback.
    on: emptyOn,
    tween: emptyTween,
    time: timing.time,
    delay: timing.delay,
    duration: timing.duration,
    ease: timing.ease,
    timer: null,
    state: CREATED
  });
}
function init(node, id2) {
  var schedule2 = get(node, id2);
  if (schedule2.state > CREATED) throw new Error("too late; already scheduled");
  return schedule2;
}
function set(node, id2) {
  var schedule2 = get(node, id2);
  if (schedule2.state > STARTED) throw new Error("too late; already running");
  return schedule2;
}
function get(node, id2) {
  var schedule2 = node.__transition;
  if (!schedule2 || !(schedule2 = schedule2[id2])) throw new Error("transition not found");
  return schedule2;
}
function create(node, id2, self) {
  var schedules = node.__transition, tween;
  schedules[id2] = self;
  self.timer = timer(schedule2, 0, self.time);
  function schedule2(elapsed) {
    self.state = SCHEDULED;
    self.timer.restart(start2, self.delay, self.time);
    if (self.delay <= elapsed) start2(elapsed - self.delay);
  }
  function start2(elapsed) {
    var i, j2, n, o;
    if (self.state !== SCHEDULED) return stop();
    for (i in schedules) {
      o = schedules[i];
      if (o.name !== self.name) continue;
      if (o.state === STARTED) return timeout(start2);
      if (o.state === RUNNING) {
        o.state = ENDED;
        o.timer.stop();
        o.on.call("interrupt", node, node.__data__, o.index, o.group);
        delete schedules[i];
      } else if (+i < id2) {
        o.state = ENDED;
        o.timer.stop();
        o.on.call("cancel", node, node.__data__, o.index, o.group);
        delete schedules[i];
      }
    }
    timeout(function() {
      if (self.state === STARTED) {
        self.state = RUNNING;
        self.timer.restart(tick2, self.delay, self.time);
        tick2(elapsed);
      }
    });
    self.state = STARTING;
    self.on.call("start", node, node.__data__, self.index, self.group);
    if (self.state !== STARTING) return;
    self.state = STARTED;
    tween = new Array(n = self.tween.length);
    for (i = 0, j2 = -1; i < n; ++i) {
      if (o = self.tween[i].value.call(node, node.__data__, self.index, self.group)) {
        tween[++j2] = o;
      }
    }
    tween.length = j2 + 1;
  }
  function tick2(elapsed) {
    var t2 = elapsed < self.duration ? self.ease.call(null, elapsed / self.duration) : (self.timer.restart(stop), self.state = ENDING, 1), i = -1, n = tween.length;
    while (++i < n) {
      tween[i].call(node, t2);
    }
    if (self.state === ENDING) {
      self.on.call("end", node, node.__data__, self.index, self.group);
      stop();
    }
  }
  function stop() {
    self.state = ENDED;
    self.timer.stop();
    delete schedules[id2];
    for (var i in schedules) return;
    delete node.__transition;
  }
}
function interrupt(node, name2) {
  var schedules = node.__transition, schedule2, active, empty2 = true, i;
  if (!schedules) return;
  name2 = name2 == null ? null : name2 + "";
  for (i in schedules) {
    if ((schedule2 = schedules[i]).name !== name2) {
      empty2 = false;
      continue;
    }
    active = schedule2.state > STARTING && schedule2.state < ENDING;
    schedule2.state = ENDED;
    schedule2.timer.stop();
    schedule2.on.call(active ? "interrupt" : "cancel", node, node.__data__, schedule2.index, schedule2.group);
    delete schedules[i];
  }
  if (empty2) delete node.__transition;
}
function selection_interrupt(name2) {
  return this.each(function() {
    interrupt(this, name2);
  });
}
function tweenRemove(id2, name2) {
  var tween0, tween1;
  return function() {
    var schedule2 = set(this, id2), tween = schedule2.tween;
    if (tween !== tween0) {
      tween1 = tween0 = tween;
      for (var i = 0, n = tween1.length; i < n; ++i) {
        if (tween1[i].name === name2) {
          tween1 = tween1.slice();
          tween1.splice(i, 1);
          break;
        }
      }
    }
    schedule2.tween = tween1;
  };
}
function tweenFunction(id2, name2, value) {
  var tween0, tween1;
  if (typeof value !== "function") throw new Error();
  return function() {
    var schedule2 = set(this, id2), tween = schedule2.tween;
    if (tween !== tween0) {
      tween1 = (tween0 = tween).slice();
      for (var t2 = { name: name2, value }, i = 0, n = tween1.length; i < n; ++i) {
        if (tween1[i].name === name2) {
          tween1[i] = t2;
          break;
        }
      }
      if (i === n) tween1.push(t2);
    }
    schedule2.tween = tween1;
  };
}
function transition_tween(name2, value) {
  var id2 = this._id;
  name2 += "";
  if (arguments.length < 2) {
    var tween = get(this.node(), id2).tween;
    for (var i = 0, n = tween.length, t2; i < n; ++i) {
      if ((t2 = tween[i]).name === name2) {
        return t2.value;
      }
    }
    return null;
  }
  return this.each((value == null ? tweenRemove : tweenFunction)(id2, name2, value));
}
function tweenValue(transition2, name2, value) {
  var id2 = transition2._id;
  transition2.each(function() {
    var schedule2 = set(this, id2);
    (schedule2.value || (schedule2.value = {}))[name2] = value.apply(this, arguments);
  });
  return function(node) {
    return get(node, id2).value[name2];
  };
}
function interpolate(a, b2) {
  var c;
  return (typeof b2 === "number" ? interpolateNumber : b2 instanceof color ? interpolateRgb : (c = color(b2)) ? (b2 = c, interpolateRgb) : interpolateString)(a, b2);
}
function attrRemove(name2) {
  return function() {
    this.removeAttribute(name2);
  };
}
function attrRemoveNS(fullname) {
  return function() {
    this.removeAttributeNS(fullname.space, fullname.local);
  };
}
function attrConstant(name2, interpolate2, value1) {
  var string00, string1 = value1 + "", interpolate0;
  return function() {
    var string0 = this.getAttribute(name2);
    return string0 === string1 ? null : string0 === string00 ? interpolate0 : interpolate0 = interpolate2(string00 = string0, value1);
  };
}
function attrConstantNS(fullname, interpolate2, value1) {
  var string00, string1 = value1 + "", interpolate0;
  return function() {
    var string0 = this.getAttributeNS(fullname.space, fullname.local);
    return string0 === string1 ? null : string0 === string00 ? interpolate0 : interpolate0 = interpolate2(string00 = string0, value1);
  };
}
function attrFunction(name2, interpolate2, value) {
  var string00, string10, interpolate0;
  return function() {
    var string0, value1 = value(this), string1;
    if (value1 == null) return void this.removeAttribute(name2);
    string0 = this.getAttribute(name2);
    string1 = value1 + "";
    return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : (string10 = string1, interpolate0 = interpolate2(string00 = string0, value1));
  };
}
function attrFunctionNS(fullname, interpolate2, value) {
  var string00, string10, interpolate0;
  return function() {
    var string0, value1 = value(this), string1;
    if (value1 == null) return void this.removeAttributeNS(fullname.space, fullname.local);
    string0 = this.getAttributeNS(fullname.space, fullname.local);
    string1 = value1 + "";
    return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : (string10 = string1, interpolate0 = interpolate2(string00 = string0, value1));
  };
}
function transition_attr(name2, value) {
  var fullname = namespace(name2), i = fullname === "transform" ? interpolateTransformSvg : interpolate;
  return this.attrTween(name2, typeof value === "function" ? (fullname.local ? attrFunctionNS : attrFunction)(fullname, i, tweenValue(this, "attr." + name2, value)) : value == null ? (fullname.local ? attrRemoveNS : attrRemove)(fullname) : (fullname.local ? attrConstantNS : attrConstant)(fullname, i, value));
}
function attrInterpolate(name2, i) {
  return function(t2) {
    this.setAttribute(name2, i.call(this, t2));
  };
}
function attrInterpolateNS(fullname, i) {
  return function(t2) {
    this.setAttributeNS(fullname.space, fullname.local, i.call(this, t2));
  };
}
function attrTweenNS(fullname, value) {
  var t0, i0;
  function tween() {
    var i = value.apply(this, arguments);
    if (i !== i0) t0 = (i0 = i) && attrInterpolateNS(fullname, i);
    return t0;
  }
  tween._value = value;
  return tween;
}
function attrTween(name2, value) {
  var t0, i0;
  function tween() {
    var i = value.apply(this, arguments);
    if (i !== i0) t0 = (i0 = i) && attrInterpolate(name2, i);
    return t0;
  }
  tween._value = value;
  return tween;
}
function transition_attrTween(name2, value) {
  var key2 = "attr." + name2;
  if (arguments.length < 2) return (key2 = this.tween(key2)) && key2._value;
  if (value == null) return this.tween(key2, null);
  if (typeof value !== "function") throw new Error();
  var fullname = namespace(name2);
  return this.tween(key2, (fullname.local ? attrTweenNS : attrTween)(fullname, value));
}
function delayFunction(id2, value) {
  return function() {
    init(this, id2).delay = +value.apply(this, arguments);
  };
}
function delayConstant(id2, value) {
  return value = +value, function() {
    init(this, id2).delay = value;
  };
}
function transition_delay(value) {
  var id2 = this._id;
  return arguments.length ? this.each((typeof value === "function" ? delayFunction : delayConstant)(id2, value)) : get(this.node(), id2).delay;
}
function durationFunction(id2, value) {
  return function() {
    set(this, id2).duration = +value.apply(this, arguments);
  };
}
function durationConstant(id2, value) {
  return value = +value, function() {
    set(this, id2).duration = value;
  };
}
function transition_duration(value) {
  var id2 = this._id;
  return arguments.length ? this.each((typeof value === "function" ? durationFunction : durationConstant)(id2, value)) : get(this.node(), id2).duration;
}
function easeConstant(id2, value) {
  if (typeof value !== "function") throw new Error();
  return function() {
    set(this, id2).ease = value;
  };
}
function transition_ease(value) {
  var id2 = this._id;
  return arguments.length ? this.each(easeConstant(id2, value)) : get(this.node(), id2).ease;
}
function easeVarying(id2, value) {
  return function() {
    var v2 = value.apply(this, arguments);
    if (typeof v2 !== "function") throw new Error();
    set(this, id2).ease = v2;
  };
}
function transition_easeVarying(value) {
  if (typeof value !== "function") throw new Error();
  return this.each(easeVarying(this._id, value));
}
function transition_filter(match) {
  if (typeof match !== "function") match = matcher(match);
  for (var groups = this._groups, m2 = groups.length, subgroups = new Array(m2), j2 = 0; j2 < m2; ++j2) {
    for (var group = groups[j2], n = group.length, subgroup = subgroups[j2] = [], node, i = 0; i < n; ++i) {
      if ((node = group[i]) && match.call(node, node.__data__, i, group)) {
        subgroup.push(node);
      }
    }
  }
  return new Transition(subgroups, this._parents, this._name, this._id);
}
function transition_merge(transition2) {
  if (transition2._id !== this._id) throw new Error();
  for (var groups0 = this._groups, groups1 = transition2._groups, m0 = groups0.length, m1 = groups1.length, m2 = Math.min(m0, m1), merges = new Array(m0), j2 = 0; j2 < m2; ++j2) {
    for (var group0 = groups0[j2], group1 = groups1[j2], n = group0.length, merge = merges[j2] = new Array(n), node, i = 0; i < n; ++i) {
      if (node = group0[i] || group1[i]) {
        merge[i] = node;
      }
    }
  }
  for (; j2 < m0; ++j2) {
    merges[j2] = groups0[j2];
  }
  return new Transition(merges, this._parents, this._name, this._id);
}
function start(name2) {
  return (name2 + "").trim().split(/^|\s+/).every(function(t2) {
    var i = t2.indexOf(".");
    if (i >= 0) t2 = t2.slice(0, i);
    return !t2 || t2 === "start";
  });
}
function onFunction(id2, name2, listener) {
  var on0, on1, sit = start(name2) ? init : set;
  return function() {
    var schedule2 = sit(this, id2), on2 = schedule2.on;
    if (on2 !== on0) (on1 = (on0 = on2).copy()).on(name2, listener);
    schedule2.on = on1;
  };
}
function transition_on(name2, listener) {
  var id2 = this._id;
  return arguments.length < 2 ? get(this.node(), id2).on.on(name2) : this.each(onFunction(id2, name2, listener));
}
function removeFunction(id2) {
  return function() {
    var parent = this.parentNode;
    for (var i in this.__transition) if (+i !== id2) return;
    if (parent) parent.removeChild(this);
  };
}
function transition_remove() {
  return this.on("end.remove", removeFunction(this._id));
}
function transition_select(select2) {
  var name2 = this._name, id2 = this._id;
  if (typeof select2 !== "function") select2 = selector(select2);
  for (var groups = this._groups, m2 = groups.length, subgroups = new Array(m2), j2 = 0; j2 < m2; ++j2) {
    for (var group = groups[j2], n = group.length, subgroup = subgroups[j2] = new Array(n), node, subnode, i = 0; i < n; ++i) {
      if ((node = group[i]) && (subnode = select2.call(node, node.__data__, i, group))) {
        if ("__data__" in node) subnode.__data__ = node.__data__;
        subgroup[i] = subnode;
        schedule(subgroup[i], name2, id2, i, subgroup, get(node, id2));
      }
    }
  }
  return new Transition(subgroups, this._parents, name2, id2);
}
function transition_selectAll(select2) {
  var name2 = this._name, id2 = this._id;
  if (typeof select2 !== "function") select2 = selectorAll(select2);
  for (var groups = this._groups, m2 = groups.length, subgroups = [], parents = [], j2 = 0; j2 < m2; ++j2) {
    for (var group = groups[j2], n = group.length, node, i = 0; i < n; ++i) {
      if (node = group[i]) {
        for (var children2 = select2.call(node, node.__data__, i, group), child2, inherit2 = get(node, id2), k2 = 0, l = children2.length; k2 < l; ++k2) {
          if (child2 = children2[k2]) {
            schedule(child2, name2, id2, k2, children2, inherit2);
          }
        }
        subgroups.push(children2);
        parents.push(node);
      }
    }
  }
  return new Transition(subgroups, parents, name2, id2);
}
var Selection$1 = selection$1.prototype.constructor;
function transition_selection() {
  return new Selection$1(this._groups, this._parents);
}
function styleNull(name2, interpolate2) {
  var string00, string10, interpolate0;
  return function() {
    var string0 = styleValue(this, name2), string1 = (this.style.removeProperty(name2), styleValue(this, name2));
    return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : interpolate0 = interpolate2(string00 = string0, string10 = string1);
  };
}
function styleRemove(name2) {
  return function() {
    this.style.removeProperty(name2);
  };
}
function styleConstant(name2, interpolate2, value1) {
  var string00, string1 = value1 + "", interpolate0;
  return function() {
    var string0 = styleValue(this, name2);
    return string0 === string1 ? null : string0 === string00 ? interpolate0 : interpolate0 = interpolate2(string00 = string0, value1);
  };
}
function styleFunction(name2, interpolate2, value) {
  var string00, string10, interpolate0;
  return function() {
    var string0 = styleValue(this, name2), value1 = value(this), string1 = value1 + "";
    if (value1 == null) string1 = value1 = (this.style.removeProperty(name2), styleValue(this, name2));
    return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : (string10 = string1, interpolate0 = interpolate2(string00 = string0, value1));
  };
}
function styleMaybeRemove(id2, name2) {
  var on0, on1, listener0, key2 = "style." + name2, event2 = "end." + key2, remove2;
  return function() {
    var schedule2 = set(this, id2), on2 = schedule2.on, listener = schedule2.value[key2] == null ? remove2 || (remove2 = styleRemove(name2)) : void 0;
    if (on2 !== on0 || listener0 !== listener) (on1 = (on0 = on2).copy()).on(event2, listener0 = listener);
    schedule2.on = on1;
  };
}
function transition_style(name2, value, priority) {
  var i = (name2 += "") === "transform" ? interpolateTransformCss : interpolate;
  return value == null ? this.styleTween(name2, styleNull(name2, i)).on("end.style." + name2, styleRemove(name2)) : typeof value === "function" ? this.styleTween(name2, styleFunction(name2, i, tweenValue(this, "style." + name2, value))).each(styleMaybeRemove(this._id, name2)) : this.styleTween(name2, styleConstant(name2, i, value), priority).on("end.style." + name2, null);
}
function styleInterpolate(name2, i, priority) {
  return function(t2) {
    this.style.setProperty(name2, i.call(this, t2), priority);
  };
}
function styleTween(name2, value, priority) {
  var t2, i0;
  function tween() {
    var i = value.apply(this, arguments);
    if (i !== i0) t2 = (i0 = i) && styleInterpolate(name2, i, priority);
    return t2;
  }
  tween._value = value;
  return tween;
}
function transition_styleTween(name2, value, priority) {
  var key2 = "style." + (name2 += "");
  if (arguments.length < 2) return (key2 = this.tween(key2)) && key2._value;
  if (value == null) return this.tween(key2, null);
  if (typeof value !== "function") throw new Error();
  return this.tween(key2, styleTween(name2, value, priority == null ? "" : priority));
}
function textConstant(value) {
  return function() {
    this.textContent = value;
  };
}
function textFunction(value) {
  return function() {
    var value1 = value(this);
    this.textContent = value1 == null ? "" : value1;
  };
}
function transition_text(value) {
  return this.tween("text", typeof value === "function" ? textFunction(tweenValue(this, "text", value)) : textConstant(value == null ? "" : value + ""));
}
function textInterpolate(i) {
  return function(t2) {
    this.textContent = i.call(this, t2);
  };
}
function textTween(value) {
  var t0, i0;
  function tween() {
    var i = value.apply(this, arguments);
    if (i !== i0) t0 = (i0 = i) && textInterpolate(i);
    return t0;
  }
  tween._value = value;
  return tween;
}
function transition_textTween(value) {
  var key2 = "text";
  if (arguments.length < 1) return (key2 = this.tween(key2)) && key2._value;
  if (value == null) return this.tween(key2, null);
  if (typeof value !== "function") throw new Error();
  return this.tween(key2, textTween(value));
}
function transition_transition() {
  var name2 = this._name, id0 = this._id, id1 = newId();
  for (var groups = this._groups, m2 = groups.length, j2 = 0; j2 < m2; ++j2) {
    for (var group = groups[j2], n = group.length, node, i = 0; i < n; ++i) {
      if (node = group[i]) {
        var inherit2 = get(node, id0);
        schedule(node, name2, id1, i, group, {
          time: inherit2.time + inherit2.delay + inherit2.duration,
          delay: 0,
          duration: inherit2.duration,
          ease: inherit2.ease
        });
      }
    }
  }
  return new Transition(groups, this._parents, name2, id1);
}
function transition_end() {
  var on0, on1, that = this, id2 = that._id, size = that.size();
  return new Promise(function(resolve, reject) {
    var cancel = { value: reject }, end = { value: function() {
      if (--size === 0) resolve();
    } };
    that.each(function() {
      var schedule2 = set(this, id2), on2 = schedule2.on;
      if (on2 !== on0) {
        on1 = (on0 = on2).copy();
        on1._.cancel.push(cancel);
        on1._.interrupt.push(cancel);
        on1._.end.push(end);
      }
      schedule2.on = on1;
    });
    if (size === 0) resolve();
  });
}
var id = 0;
function Transition(groups, parents, name2, id2) {
  this._groups = groups;
  this._parents = parents;
  this._name = name2;
  this._id = id2;
}
function newId() {
  return ++id;
}
var selection_prototype = selection$1.prototype;
Transition.prototype = {
  constructor: Transition,
  select: transition_select,
  selectAll: transition_selectAll,
  selectChild: selection_prototype.selectChild,
  selectChildren: selection_prototype.selectChildren,
  filter: transition_filter,
  merge: transition_merge,
  selection: transition_selection,
  transition: transition_transition,
  call: selection_prototype.call,
  nodes: selection_prototype.nodes,
  node: selection_prototype.node,
  size: selection_prototype.size,
  empty: selection_prototype.empty,
  each: selection_prototype.each,
  on: transition_on,
  attr: transition_attr,
  attrTween: transition_attrTween,
  style: transition_style,
  styleTween: transition_styleTween,
  text: transition_text,
  textTween: transition_textTween,
  remove: transition_remove,
  tween: transition_tween,
  delay: transition_delay,
  duration: transition_duration,
  ease: transition_ease,
  easeVarying: transition_easeVarying,
  end: transition_end,
  [Symbol.iterator]: selection_prototype[Symbol.iterator]
};
function cubicInOut(t2) {
  return ((t2 *= 2) <= 1 ? t2 * t2 * t2 : (t2 -= 2) * t2 * t2 + 2) / 2;
}
var defaultTiming = {
  time: null,
  // Set on use.
  delay: 0,
  duration: 250,
  ease: cubicInOut
};
function inherit(node, id2) {
  var timing;
  while (!(timing = node.__transition) || !(timing = timing[id2])) {
    if (!(node = node.parentNode)) {
      throw new Error(`transition ${id2} not found`);
    }
  }
  return timing;
}
function selection_transition(name2) {
  var id2, timing;
  if (name2 instanceof Transition) {
    id2 = name2._id, name2 = name2._name;
  } else {
    id2 = newId(), (timing = defaultTiming).time = now(), name2 = name2 == null ? null : name2 + "";
  }
  for (var groups = this._groups, m2 = groups.length, j2 = 0; j2 < m2; ++j2) {
    for (var group = groups[j2], n = group.length, node, i = 0; i < n; ++i) {
      if (node = group[i]) {
        schedule(node, name2, id2, i, group, timing || inherit(node, id2));
      }
    }
  }
  return new Transition(groups, this._parents, name2, id2);
}
selection$1.prototype.interrupt = selection_interrupt;
selection$1.prototype.transition = selection_transition;
const constant = (x2) => () => x2;
function ZoomEvent(type, {
  sourceEvent: sourceEvent2,
  target,
  transform: transform2,
  dispatch: dispatch2
}) {
  Object.defineProperties(this, {
    type: { value: type, enumerable: true, configurable: true },
    sourceEvent: { value: sourceEvent2, enumerable: true, configurable: true },
    target: { value: target, enumerable: true, configurable: true },
    transform: { value: transform2, enumerable: true, configurable: true },
    _: { value: dispatch2 }
  });
}
function Transform(k2, x2, y2) {
  this.k = k2;
  this.x = x2;
  this.y = y2;
}
Transform.prototype = {
  constructor: Transform,
  scale: function(k2) {
    return k2 === 1 ? this : new Transform(this.k * k2, this.x, this.y);
  },
  translate: function(x2, y2) {
    return x2 === 0 & y2 === 0 ? this : new Transform(this.k, this.x + this.k * x2, this.y + this.k * y2);
  },
  apply: function(point) {
    return [point[0] * this.k + this.x, point[1] * this.k + this.y];
  },
  applyX: function(x2) {
    return x2 * this.k + this.x;
  },
  applyY: function(y2) {
    return y2 * this.k + this.y;
  },
  invert: function(location) {
    return [(location[0] - this.x) / this.k, (location[1] - this.y) / this.k];
  },
  invertX: function(x2) {
    return (x2 - this.x) / this.k;
  },
  invertY: function(y2) {
    return (y2 - this.y) / this.k;
  },
  rescaleX: function(x2) {
    return x2.copy().domain(x2.range().map(this.invertX, this).map(x2.invert, x2));
  },
  rescaleY: function(y2) {
    return y2.copy().domain(y2.range().map(this.invertY, this).map(y2.invert, y2));
  },
  toString: function() {
    return "translate(" + this.x + "," + this.y + ") scale(" + this.k + ")";
  }
};
var identity = new Transform(1, 0, 0);
transform.prototype = Transform.prototype;
function transform(node) {
  while (!node.__zoom) if (!(node = node.parentNode)) return identity;
  return node.__zoom;
}
function nopropagation(event2) {
  event2.stopImmediatePropagation();
}
function noevent(event2) {
  event2.preventDefault();
  event2.stopImmediatePropagation();
}
function defaultFilter(event2) {
  return (!event2.ctrlKey || event2.type === "wheel") && !event2.button;
}
function defaultExtent() {
  var e = this;
  if (e instanceof SVGElement) {
    e = e.ownerSVGElement || e;
    if (e.hasAttribute("viewBox")) {
      e = e.viewBox.baseVal;
      return [[e.x, e.y], [e.x + e.width, e.y + e.height]];
    }
    return [[0, 0], [e.width.baseVal.value, e.height.baseVal.value]];
  }
  return [[0, 0], [e.clientWidth, e.clientHeight]];
}
function defaultTransform() {
  return this.__zoom || identity;
}
function defaultWheelDelta(event2) {
  return -event2.deltaY * (event2.deltaMode === 1 ? 0.05 : event2.deltaMode ? 1 : 2e-3) * (event2.ctrlKey ? 10 : 1);
}
function defaultTouchable() {
  return navigator.maxTouchPoints || "ontouchstart" in this;
}
function defaultConstrain(transform2, extent, translateExtent) {
  var dx0 = transform2.invertX(extent[0][0]) - translateExtent[0][0], dx1 = transform2.invertX(extent[1][0]) - translateExtent[1][0], dy0 = transform2.invertY(extent[0][1]) - translateExtent[0][1], dy1 = transform2.invertY(extent[1][1]) - translateExtent[1][1];
  return transform2.translate(
    dx1 > dx0 ? (dx0 + dx1) / 2 : Math.min(0, dx0) || Math.max(0, dx1),
    dy1 > dy0 ? (dy0 + dy1) / 2 : Math.min(0, dy0) || Math.max(0, dy1)
  );
}
function zoom$1() {
  var filter2 = defaultFilter, extent = defaultExtent, constrain = defaultConstrain, wheelDelta2 = defaultWheelDelta, touchable = defaultTouchable, scaleExtent = [0, Infinity], translateExtent = [[-Infinity, -Infinity], [Infinity, Infinity]], duration = 250, interpolate2 = interpolateZoom, listeners = dispatch("start", "zoom", "end"), touchstarting, touchfirst, touchending, touchDelay = 500, wheelDelay = 150, clickDistance2 = 0, tapDistance = 10;
  function zoom2(selection2) {
    selection2.property("__zoom", defaultTransform).on("wheel.zoom", wheeled, { passive: false }).on("mousedown.zoom", mousedowned).on("dblclick.zoom", dblclicked).filter(touchable).on("touchstart.zoom", touchstarted).on("touchmove.zoom", touchmoved).on("touchend.zoom touchcancel.zoom", touchended).style("-webkit-tap-highlight-color", "rgba(0,0,0,0)");
  }
  zoom2.transform = function(collection, transform2, point, event2) {
    var selection2 = collection.selection ? collection.selection() : collection;
    selection2.property("__zoom", defaultTransform);
    if (collection !== selection2) {
      schedule2(collection, transform2, point, event2);
    } else {
      selection2.interrupt().each(function() {
        gesture(this, arguments).event(event2).start().zoom(null, typeof transform2 === "function" ? transform2.apply(this, arguments) : transform2).end();
      });
    }
  };
  zoom2.scaleBy = function(selection2, k2, p, event2) {
    zoom2.scaleTo(selection2, function() {
      var k0 = this.__zoom.k, k1 = typeof k2 === "function" ? k2.apply(this, arguments) : k2;
      return k0 * k1;
    }, p, event2);
  };
  zoom2.scaleTo = function(selection2, k2, p, event2) {
    zoom2.transform(selection2, function() {
      var e = extent.apply(this, arguments), t0 = this.__zoom, p0 = p == null ? centroid(e) : typeof p === "function" ? p.apply(this, arguments) : p, p1 = t0.invert(p0), k1 = typeof k2 === "function" ? k2.apply(this, arguments) : k2;
      return constrain(translate(scale(t0, k1), p0, p1), e, translateExtent);
    }, p, event2);
  };
  zoom2.translateBy = function(selection2, x2, y2, event2) {
    zoom2.transform(selection2, function() {
      return constrain(this.__zoom.translate(
        typeof x2 === "function" ? x2.apply(this, arguments) : x2,
        typeof y2 === "function" ? y2.apply(this, arguments) : y2
      ), extent.apply(this, arguments), translateExtent);
    }, null, event2);
  };
  zoom2.translateTo = function(selection2, x2, y2, p, event2) {
    zoom2.transform(selection2, function() {
      var e = extent.apply(this, arguments), t2 = this.__zoom, p0 = p == null ? centroid(e) : typeof p === "function" ? p.apply(this, arguments) : p;
      return constrain(identity.translate(p0[0], p0[1]).scale(t2.k).translate(
        typeof x2 === "function" ? -x2.apply(this, arguments) : -x2,
        typeof y2 === "function" ? -y2.apply(this, arguments) : -y2
      ), e, translateExtent);
    }, p, event2);
  };
  function scale(transform2, k2) {
    k2 = Math.max(scaleExtent[0], Math.min(scaleExtent[1], k2));
    return k2 === transform2.k ? transform2 : new Transform(k2, transform2.x, transform2.y);
  }
  function translate(transform2, p0, p1) {
    var x2 = p0[0] - p1[0] * transform2.k, y2 = p0[1] - p1[1] * transform2.k;
    return x2 === transform2.x && y2 === transform2.y ? transform2 : new Transform(transform2.k, x2, y2);
  }
  function centroid(extent2) {
    return [(+extent2[0][0] + +extent2[1][0]) / 2, (+extent2[0][1] + +extent2[1][1]) / 2];
  }
  function schedule2(transition2, transform2, point, event2) {
    transition2.on("start.zoom", function() {
      gesture(this, arguments).event(event2).start();
    }).on("interrupt.zoom end.zoom", function() {
      gesture(this, arguments).event(event2).end();
    }).tween("zoom", function() {
      var that = this, args = arguments, g = gesture(that, args).event(event2), e = extent.apply(that, args), p = point == null ? centroid(e) : typeof point === "function" ? point.apply(that, args) : point, w2 = Math.max(e[1][0] - e[0][0], e[1][1] - e[0][1]), a = that.__zoom, b2 = typeof transform2 === "function" ? transform2.apply(that, args) : transform2, i = interpolate2(a.invert(p).concat(w2 / a.k), b2.invert(p).concat(w2 / b2.k));
      return function(t2) {
        if (t2 === 1) t2 = b2;
        else {
          var l = i(t2), k2 = w2 / l[2];
          t2 = new Transform(k2, p[0] - l[0] * k2, p[1] - l[1] * k2);
        }
        g.zoom(null, t2);
      };
    });
  }
  function gesture(that, args, clean) {
    return !clean && that.__zooming || new Gesture(that, args);
  }
  function Gesture(that, args) {
    this.that = that;
    this.args = args;
    this.active = 0;
    this.sourceEvent = null;
    this.extent = extent.apply(that, args);
    this.taps = 0;
  }
  Gesture.prototype = {
    event: function(event2) {
      if (event2) this.sourceEvent = event2;
      return this;
    },
    start: function() {
      if (++this.active === 1) {
        this.that.__zooming = this;
        this.emit("start");
      }
      return this;
    },
    zoom: function(key2, transform2) {
      if (this.mouse && key2 !== "mouse") this.mouse[1] = transform2.invert(this.mouse[0]);
      if (this.touch0 && key2 !== "touch") this.touch0[1] = transform2.invert(this.touch0[0]);
      if (this.touch1 && key2 !== "touch") this.touch1[1] = transform2.invert(this.touch1[0]);
      this.that.__zoom = transform2;
      this.emit("zoom");
      return this;
    },
    end: function() {
      if (--this.active === 0) {
        delete this.that.__zooming;
        this.emit("end");
      }
      return this;
    },
    emit: function(type) {
      var d = select(this.that).datum();
      listeners.call(
        type,
        this.that,
        new ZoomEvent(type, {
          sourceEvent: this.sourceEvent,
          target: zoom2,
          transform: this.that.__zoom,
          dispatch: listeners
        }),
        d
      );
    }
  };
  function wheeled(event2, ...args) {
    if (!filter2.apply(this, arguments)) return;
    var g = gesture(this, args).event(event2), t2 = this.__zoom, k2 = Math.max(scaleExtent[0], Math.min(scaleExtent[1], t2.k * Math.pow(2, wheelDelta2.apply(this, arguments)))), p = pointer(event2);
    if (g.wheel) {
      if (g.mouse[0][0] !== p[0] || g.mouse[0][1] !== p[1]) {
        g.mouse[1] = t2.invert(g.mouse[0] = p);
      }
      clearTimeout(g.wheel);
    } else if (t2.k === k2) return;
    else {
      g.mouse = [p, t2.invert(p)];
      interrupt(this);
      g.start();
    }
    noevent(event2);
    g.wheel = setTimeout(wheelidled, wheelDelay);
    g.zoom("mouse", constrain(translate(scale(t2, k2), g.mouse[0], g.mouse[1]), g.extent, translateExtent));
    function wheelidled() {
      g.wheel = null;
      g.end();
    }
  }
  function mousedowned(event2, ...args) {
    if (touchending || !filter2.apply(this, arguments)) return;
    var currentTarget = event2.currentTarget, g = gesture(this, args, true).event(event2), v2 = select(event2.view).on("mousemove.zoom", mousemoved, true).on("mouseup.zoom", mouseupped, true), p = pointer(event2, currentTarget), x0 = event2.clientX, y0 = event2.clientY;
    dragDisable(event2.view);
    nopropagation(event2);
    g.mouse = [p, this.__zoom.invert(p)];
    interrupt(this);
    g.start();
    function mousemoved(event3) {
      noevent(event3);
      if (!g.moved) {
        var dx = event3.clientX - x0, dy = event3.clientY - y0;
        g.moved = dx * dx + dy * dy > clickDistance2;
      }
      g.event(event3).zoom("mouse", constrain(translate(g.that.__zoom, g.mouse[0] = pointer(event3, currentTarget), g.mouse[1]), g.extent, translateExtent));
    }
    function mouseupped(event3) {
      v2.on("mousemove.zoom mouseup.zoom", null);
      yesdrag(event3.view, g.moved);
      noevent(event3);
      g.event(event3).end();
    }
  }
  function dblclicked(event2, ...args) {
    if (!filter2.apply(this, arguments)) return;
    var t0 = this.__zoom, p0 = pointer(event2.changedTouches ? event2.changedTouches[0] : event2, this), p1 = t0.invert(p0), k1 = t0.k * (event2.shiftKey ? 0.5 : 2), t1 = constrain(translate(scale(t0, k1), p0, p1), extent.apply(this, args), translateExtent);
    noevent(event2);
    if (duration > 0) select(this).transition().duration(duration).call(schedule2, t1, p0, event2);
    else select(this).call(zoom2.transform, t1, p0, event2);
  }
  function touchstarted(event2, ...args) {
    if (!filter2.apply(this, arguments)) return;
    var touches = event2.touches, n = touches.length, g = gesture(this, args, event2.changedTouches.length === n).event(event2), started, i, t2, p;
    nopropagation(event2);
    for (i = 0; i < n; ++i) {
      t2 = touches[i], p = pointer(t2, this);
      p = [p, this.__zoom.invert(p), t2.identifier];
      if (!g.touch0) g.touch0 = p, started = true, g.taps = 1 + !!touchstarting;
      else if (!g.touch1 && g.touch0[2] !== p[2]) g.touch1 = p, g.taps = 0;
    }
    if (touchstarting) touchstarting = clearTimeout(touchstarting);
    if (started) {
      if (g.taps < 2) touchfirst = p[0], touchstarting = setTimeout(function() {
        touchstarting = null;
      }, touchDelay);
      interrupt(this);
      g.start();
    }
  }
  function touchmoved(event2, ...args) {
    if (!this.__zooming) return;
    var g = gesture(this, args).event(event2), touches = event2.changedTouches, n = touches.length, i, t2, p, l;
    noevent(event2);
    for (i = 0; i < n; ++i) {
      t2 = touches[i], p = pointer(t2, this);
      if (g.touch0 && g.touch0[2] === t2.identifier) g.touch0[0] = p;
      else if (g.touch1 && g.touch1[2] === t2.identifier) g.touch1[0] = p;
    }
    t2 = g.that.__zoom;
    if (g.touch1) {
      var p0 = g.touch0[0], l0 = g.touch0[1], p1 = g.touch1[0], l1 = g.touch1[1], dp = (dp = p1[0] - p0[0]) * dp + (dp = p1[1] - p0[1]) * dp, dl = (dl = l1[0] - l0[0]) * dl + (dl = l1[1] - l0[1]) * dl;
      t2 = scale(t2, Math.sqrt(dp / dl));
      p = [(p0[0] + p1[0]) / 2, (p0[1] + p1[1]) / 2];
      l = [(l0[0] + l1[0]) / 2, (l0[1] + l1[1]) / 2];
    } else if (g.touch0) p = g.touch0[0], l = g.touch0[1];
    else return;
    g.zoom("touch", constrain(translate(t2, p, l), g.extent, translateExtent));
  }
  function touchended(event2, ...args) {
    if (!this.__zooming) return;
    var g = gesture(this, args).event(event2), touches = event2.changedTouches, n = touches.length, i, t2;
    nopropagation(event2);
    if (touchending) clearTimeout(touchending);
    touchending = setTimeout(function() {
      touchending = null;
    }, touchDelay);
    for (i = 0; i < n; ++i) {
      t2 = touches[i];
      if (g.touch0 && g.touch0[2] === t2.identifier) delete g.touch0;
      else if (g.touch1 && g.touch1[2] === t2.identifier) delete g.touch1;
    }
    if (g.touch1 && !g.touch0) g.touch0 = g.touch1, delete g.touch1;
    if (g.touch0) g.touch0[1] = this.__zoom.invert(g.touch0[0]);
    else {
      g.end();
      if (g.taps === 2) {
        t2 = pointer(t2, this);
        if (Math.hypot(touchfirst[0] - t2[0], touchfirst[1] - t2[1]) < tapDistance) {
          var p = select(this).on("dblclick.zoom");
          if (p) p.apply(this, arguments);
        }
      }
    }
  }
  zoom2.wheelDelta = function(_2) {
    return arguments.length ? (wheelDelta2 = typeof _2 === "function" ? _2 : constant(+_2), zoom2) : wheelDelta2;
  };
  zoom2.filter = function(_2) {
    return arguments.length ? (filter2 = typeof _2 === "function" ? _2 : constant(!!_2), zoom2) : filter2;
  };
  zoom2.touchable = function(_2) {
    return arguments.length ? (touchable = typeof _2 === "function" ? _2 : constant(!!_2), zoom2) : touchable;
  };
  zoom2.extent = function(_2) {
    return arguments.length ? (extent = typeof _2 === "function" ? _2 : constant([[+_2[0][0], +_2[0][1]], [+_2[1][0], +_2[1][1]]]), zoom2) : extent;
  };
  zoom2.scaleExtent = function(_2) {
    return arguments.length ? (scaleExtent[0] = +_2[0], scaleExtent[1] = +_2[1], zoom2) : [scaleExtent[0], scaleExtent[1]];
  };
  zoom2.translateExtent = function(_2) {
    return arguments.length ? (translateExtent[0][0] = +_2[0][0], translateExtent[1][0] = +_2[1][0], translateExtent[0][1] = +_2[0][1], translateExtent[1][1] = +_2[1][1], zoom2) : [[translateExtent[0][0], translateExtent[0][1]], [translateExtent[1][0], translateExtent[1][1]]];
  };
  zoom2.constrain = function(_2) {
    return arguments.length ? (constrain = _2, zoom2) : constrain;
  };
  zoom2.duration = function(_2) {
    return arguments.length ? (duration = +_2, zoom2) : duration;
  };
  zoom2.interpolate = function(_2) {
    return arguments.length ? (interpolate2 = _2, zoom2) : interpolate2;
  };
  zoom2.on = function() {
    var value = listeners.on.apply(listeners, arguments);
    return value === listeners ? zoom2 : value;
  };
  zoom2.clickDistance = function(_2) {
    return arguments.length ? (clickDistance2 = (_2 = +_2) * _2, zoom2) : Math.sqrt(clickDistance2);
  };
  zoom2.tapDistance = function(_2) {
    return arguments.length ? (tapDistance = +_2, zoom2) : tapDistance;
  };
  return zoom2;
}
const errorMessages = {
  error001: () => "[React Flow]: Seems like you have not used zustand provider as an ancestor. Help: https://reactflow.dev/error#001",
  error002: () => "It looks like you've created a new nodeTypes or edgeTypes object. If this wasn't on purpose please define the nodeTypes/edgeTypes outside of the component or memoize them.",
  error003: (nodeType) => `Node type "${nodeType}" not found. Using fallback type "default".`,
  error004: () => "The React Flow parent container needs a width and a height to render the graph.",
  error005: () => "Only child nodes can use a parent extent.",
  error006: () => "Can't create edge. An edge needs a source and a target.",
  error007: (id2) => `The old edge with id=${id2} does not exist.`,
  error009: (type) => `Marker type "${type}" doesn't exist.`,
  error008: (handleType, { id: id2, sourceHandle, targetHandle }) => `Couldn't create edge for ${handleType} handle id: "${handleType === "source" ? sourceHandle : targetHandle}", edge id: ${id2}.`,
  error010: () => "Handle: No node id found. Make sure to only use a Handle inside a custom Node.",
  error011: (edgeType) => `Edge type "${edgeType}" not found. Using fallback type "default".`,
  error012: (id2) => `Node with id "${id2}" does not exist, it may have been removed. This can happen when a node is deleted before the "onNodeClick" handler is called.`,
  error013: (lib = "react") => `It seems that you haven't loaded the styles. Please import '@xyflow/${lib}/dist/style.css' or base.css to make sure everything is working properly.`,
  error014: () => "useNodeConnections: No node ID found. Call useNodeConnections inside a custom Node or provide a node ID.",
  error015: () => "It seems that you are trying to drag a node that is not initialized. Please use onNodesChange as explained in the docs."
};
const infiniteExtent = [
  [Number.NEGATIVE_INFINITY, Number.NEGATIVE_INFINITY],
  [Number.POSITIVE_INFINITY, Number.POSITIVE_INFINITY]
];
const elementSelectionKeys = ["Enter", " ", "Escape"];
const defaultAriaLabelConfig = {
  "node.a11yDescription.default": "Press enter or space to select a node. Press delete to remove it and escape to cancel.",
  "node.a11yDescription.keyboardDisabled": "Press enter or space to select a node. You can then use the arrow keys to move the node around. Press delete to remove it and escape to cancel.",
  "node.a11yDescription.ariaLiveMessage": ({ direction, x: x2, y: y2 }) => `Moved selected node ${direction}. New position, x: ${x2}, y: ${y2}`,
  "edge.a11yDescription.default": "Press enter or space to select an edge. You can then press delete to remove it or escape to cancel.",
  // Control elements
  "controls.ariaLabel": "Control Panel",
  "controls.zoomIn.ariaLabel": "Zoom In",
  "controls.zoomOut.ariaLabel": "Zoom Out",
  "controls.fitView.ariaLabel": "Fit View",
  "controls.interactive.ariaLabel": "Toggle Interactivity",
  // Mini map
  "minimap.ariaLabel": "Mini Map",
  // Handle
  "handle.ariaLabel": "Handle"
};
var ConnectionMode;
(function(ConnectionMode2) {
  ConnectionMode2["Strict"] = "strict";
  ConnectionMode2["Loose"] = "loose";
})(ConnectionMode || (ConnectionMode = {}));
var PanOnScrollMode;
(function(PanOnScrollMode2) {
  PanOnScrollMode2["Free"] = "free";
  PanOnScrollMode2["Vertical"] = "vertical";
  PanOnScrollMode2["Horizontal"] = "horizontal";
})(PanOnScrollMode || (PanOnScrollMode = {}));
var SelectionMode;
(function(SelectionMode2) {
  SelectionMode2["Partial"] = "partial";
  SelectionMode2["Full"] = "full";
})(SelectionMode || (SelectionMode = {}));
const initialConnection = {
  inProgress: false,
  isValid: null,
  from: null,
  fromHandle: null,
  fromPosition: null,
  fromNode: null,
  to: null,
  toHandle: null,
  toPosition: null,
  toNode: null
};
var ConnectionLineType;
(function(ConnectionLineType2) {
  ConnectionLineType2["Bezier"] = "default";
  ConnectionLineType2["Straight"] = "straight";
  ConnectionLineType2["Step"] = "step";
  ConnectionLineType2["SmoothStep"] = "smoothstep";
  ConnectionLineType2["SimpleBezier"] = "simplebezier";
})(ConnectionLineType || (ConnectionLineType = {}));
var MarkerType;
(function(MarkerType2) {
  MarkerType2["Arrow"] = "arrow";
  MarkerType2["ArrowClosed"] = "arrowclosed";
})(MarkerType || (MarkerType = {}));
var Position;
(function(Position2) {
  Position2["Left"] = "left";
  Position2["Top"] = "top";
  Position2["Right"] = "right";
  Position2["Bottom"] = "bottom";
})(Position || (Position = {}));
const oppositePosition = {
  [Position.Left]: Position.Right,
  [Position.Right]: Position.Left,
  [Position.Top]: Position.Bottom,
  [Position.Bottom]: Position.Top
};
function areConnectionMapsEqual(a, b2) {
  if (!a && !b2) {
    return true;
  }
  if (!a || !b2 || a.size !== b2.size) {
    return false;
  }
  if (!a.size && !b2.size) {
    return true;
  }
  for (const key2 of a.keys()) {
    if (!b2.has(key2)) {
      return false;
    }
  }
  return true;
}
function handleConnectionChange(a, b2, cb) {
  if (!cb) {
    return;
  }
  const diff = [];
  a.forEach((connection, key2) => {
    if (!(b2 == null ? void 0 : b2.has(key2))) {
      diff.push(connection);
    }
  });
  if (diff.length) {
    cb(diff);
  }
}
function getConnectionStatus(isValid) {
  return isValid === null ? null : isValid ? "valid" : "invalid";
}
const isEdgeBase = (element) => "id" in element && "source" in element && "target" in element;
const isNodeBase = (element) => "id" in element && "position" in element && !("source" in element) && !("target" in element);
const isInternalNodeBase = (element) => "id" in element && "internals" in element && !("source" in element) && !("target" in element);
const getNodePositionWithOrigin = (node, nodeOrigin = [0, 0]) => {
  var _a3;
  const { width, height } = getNodeDimensions(node);
  const origin = (_a3 = node.origin) != null ? _a3 : nodeOrigin;
  const offsetX = width * origin[0];
  const offsetY = height * origin[1];
  return {
    x: node.position.x - offsetX,
    y: node.position.y - offsetY
  };
};
const getNodesBounds = (nodes, params = { nodeOrigin: [0, 0] }) => {
  if (nodes.length === 0) {
    return { x: 0, y: 0, width: 0, height: 0 };
  }
  const box = nodes.reduce((currBox, nodeOrId) => {
    const isId = typeof nodeOrId === "string";
    let currentNode = !params.nodeLookup && !isId ? nodeOrId : void 0;
    if (params.nodeLookup) {
      currentNode = isId ? params.nodeLookup.get(nodeOrId) : !isInternalNodeBase(nodeOrId) ? params.nodeLookup.get(nodeOrId.id) : nodeOrId;
    }
    const nodeBox = currentNode ? nodeToBox(currentNode, params.nodeOrigin) : { x: 0, y: 0, x2: 0, y2: 0 };
    return getBoundsOfBoxes(currBox, nodeBox);
  }, { x: Infinity, y: Infinity, x2: -Infinity, y2: -Infinity });
  return boxToRect(box);
};
const getInternalNodesBounds = (nodeLookup, params = {}) => {
  if (nodeLookup.size === 0) {
    return { x: 0, y: 0, width: 0, height: 0 };
  }
  let box = { x: Infinity, y: Infinity, x2: -Infinity, y2: -Infinity };
  nodeLookup.forEach((node) => {
    if (params.filter === void 0 || params.filter(node)) {
      const nodeBox = nodeToBox(node);
      box = getBoundsOfBoxes(box, nodeBox);
    }
  });
  return boxToRect(box);
};
const getNodesInside = (nodes, rect, [tx, ty, tScale] = [0, 0, 1], partially = false, excludeNonSelectableNodes = false) => {
  var _a3, _b2, _c2, _d2, _e3, _f2;
  const paneRect = __spreadProps(__spreadValues({}, pointToRendererPoint(rect, [tx, ty, tScale])), {
    width: rect.width / tScale,
    height: rect.height / tScale
  });
  const visibleNodes = [];
  for (const node of nodes.values()) {
    const { measured, selectable = true, hidden = false } = node;
    if (excludeNonSelectableNodes && !selectable || hidden) {
      continue;
    }
    const width = (_c2 = (_b2 = (_a3 = measured.width) != null ? _a3 : node.width) != null ? _b2 : node.initialWidth) != null ? _c2 : null;
    const height = (_f2 = (_e3 = (_d2 = measured.height) != null ? _d2 : node.height) != null ? _e3 : node.initialHeight) != null ? _f2 : null;
    const overlappingArea = getOverlappingArea(paneRect, nodeToRect(node));
    const area = (width != null ? width : 0) * (height != null ? height : 0);
    const partiallyVisible = partially && overlappingArea > 0;
    const forceInitialRender = !node.internals.handleBounds;
    const isVisible = forceInitialRender || partiallyVisible || overlappingArea >= area;
    if (isVisible || node.dragging) {
      visibleNodes.push(node);
    }
  }
  return visibleNodes;
};
const getConnectedEdges = (nodes, edges) => {
  const nodeIds = /* @__PURE__ */ new Set();
  nodes.forEach((node) => {
    nodeIds.add(node.id);
  });
  return edges.filter((edge) => nodeIds.has(edge.source) || nodeIds.has(edge.target));
};
function getFitViewNodes(nodeLookup, options2) {
  const fitViewNodes = /* @__PURE__ */ new Map();
  const optionNodeIds = (options2 == null ? void 0 : options2.nodes) ? new Set(options2.nodes.map((node) => node.id)) : null;
  nodeLookup.forEach((n) => {
    const isVisible = n.measured.width && n.measured.height && ((options2 == null ? void 0 : options2.includeHiddenNodes) || !n.hidden);
    if (isVisible && (!optionNodeIds || optionNodeIds.has(n.id))) {
      fitViewNodes.set(n.id, n);
    }
  });
  return fitViewNodes;
}
function fitViewport(_0, _1) {
  return __async(this, arguments, function* ({ nodes, width, height, panZoom, minZoom, maxZoom }, options2) {
    var _a3, _b2, _c2;
    if (nodes.size === 0) {
      return Promise.resolve(true);
    }
    const nodesToFit = getFitViewNodes(nodes, options2);
    const bounds = getInternalNodesBounds(nodesToFit);
    const viewport = getViewportForBounds(bounds, width, height, (_a3 = options2 == null ? void 0 : options2.minZoom) != null ? _a3 : minZoom, (_b2 = options2 == null ? void 0 : options2.maxZoom) != null ? _b2 : maxZoom, (_c2 = options2 == null ? void 0 : options2.padding) != null ? _c2 : 0.1);
    yield panZoom.setViewport(viewport, {
      duration: options2 == null ? void 0 : options2.duration,
      ease: options2 == null ? void 0 : options2.ease,
      interpolate: options2 == null ? void 0 : options2.interpolate
    });
    return Promise.resolve(true);
  });
}
function calculateNodePosition({ nodeId, nextPosition, nodeLookup, nodeOrigin = [0, 0], nodeExtent, onError: onError2 }) {
  var _a3, _b2, _c2;
  const node = nodeLookup.get(nodeId);
  const parentNode = node.parentId ? nodeLookup.get(node.parentId) : void 0;
  const { x: parentX, y: parentY } = parentNode ? parentNode.internals.positionAbsolute : { x: 0, y: 0 };
  const origin = (_a3 = node.origin) != null ? _a3 : nodeOrigin;
  let extent = node.extent || nodeExtent;
  if (node.extent === "parent" && !node.expandParent) {
    if (!parentNode) {
      onError2 == null ? void 0 : onError2("005", errorMessages["error005"]());
    } else {
      const parentWidth = parentNode.measured.width;
      const parentHeight = parentNode.measured.height;
      if (parentWidth && parentHeight) {
        extent = [
          [parentX, parentY],
          [parentX + parentWidth, parentY + parentHeight]
        ];
      }
    }
  } else if (parentNode && isCoordinateExtent(node.extent)) {
    extent = [
      [node.extent[0][0] + parentX, node.extent[0][1] + parentY],
      [node.extent[1][0] + parentX, node.extent[1][1] + parentY]
    ];
  }
  const positionAbsolute = isCoordinateExtent(extent) ? clampPosition(nextPosition, extent, node.measured) : nextPosition;
  if (node.measured.width === void 0 || node.measured.height === void 0) {
    onError2 == null ? void 0 : onError2("015", errorMessages["error015"]());
  }
  return {
    position: {
      x: positionAbsolute.x - parentX + ((_b2 = node.measured.width) != null ? _b2 : 0) * origin[0],
      y: positionAbsolute.y - parentY + ((_c2 = node.measured.height) != null ? _c2 : 0) * origin[1]
    },
    positionAbsolute
  };
}
function getElementsToRemove(_0) {
  return __async(this, arguments, function* ({ nodesToRemove = [], edgesToRemove = [], nodes, edges, onBeforeDelete }) {
    const nodeIds = new Set(nodesToRemove.map((node) => node.id));
    const matchingNodes2 = [];
    for (const node of nodes) {
      if (node.deletable === false) {
        continue;
      }
      const isIncluded = nodeIds.has(node.id);
      const parentHit = !isIncluded && node.parentId && matchingNodes2.find((n) => n.id === node.parentId);
      if (isIncluded || parentHit) {
        matchingNodes2.push(node);
      }
    }
    const edgeIds = new Set(edgesToRemove.map((edge) => edge.id));
    const deletableEdges = edges.filter((edge) => edge.deletable !== false);
    const connectedEdges = getConnectedEdges(matchingNodes2, deletableEdges);
    const matchingEdges = connectedEdges;
    for (const edge of deletableEdges) {
      const isIncluded = edgeIds.has(edge.id);
      if (isIncluded && !matchingEdges.find((e) => e.id === edge.id)) {
        matchingEdges.push(edge);
      }
    }
    if (!onBeforeDelete) {
      return {
        edges: matchingEdges,
        nodes: matchingNodes2
      };
    }
    const onBeforeDeleteResult = yield onBeforeDelete({
      nodes: matchingNodes2,
      edges: matchingEdges
    });
    if (typeof onBeforeDeleteResult === "boolean") {
      return onBeforeDeleteResult ? { edges: matchingEdges, nodes: matchingNodes2 } : { edges: [], nodes: [] };
    }
    return onBeforeDeleteResult;
  });
}
const clamp = (val, min = 0, max = 1) => Math.min(Math.max(val, min), max);
const clampPosition = (position = { x: 0, y: 0 }, extent, dimensions) => {
  var _a3, _b2;
  return {
    x: clamp(position.x, extent[0][0], extent[1][0] - ((_a3 = dimensions == null ? void 0 : dimensions.width) != null ? _a3 : 0)),
    y: clamp(position.y, extent[0][1], extent[1][1] - ((_b2 = dimensions == null ? void 0 : dimensions.height) != null ? _b2 : 0))
  };
};
function clampPositionToParent(childPosition, childDimensions, parent) {
  const { width: parentWidth, height: parentHeight } = getNodeDimensions(parent);
  const { x: parentX, y: parentY } = parent.internals.positionAbsolute;
  return clampPosition(childPosition, [
    [parentX, parentY],
    [parentX + parentWidth, parentY + parentHeight]
  ], childDimensions);
}
const calcAutoPanVelocity = (value, min, max) => {
  if (value < min) {
    return clamp(Math.abs(value - min), 1, min) / min;
  } else if (value > max) {
    return -clamp(Math.abs(value - max), 1, min) / min;
  }
  return 0;
};
const calcAutoPan = (pos, bounds, speed = 15, distance2 = 40) => {
  const xMovement = calcAutoPanVelocity(pos.x, distance2, bounds.width - distance2) * speed;
  const yMovement = calcAutoPanVelocity(pos.y, distance2, bounds.height - distance2) * speed;
  return [xMovement, yMovement];
};
const getBoundsOfBoxes = (box1, box2) => ({
  x: Math.min(box1.x, box2.x),
  y: Math.min(box1.y, box2.y),
  x2: Math.max(box1.x2, box2.x2),
  y2: Math.max(box1.y2, box2.y2)
});
const rectToBox = ({ x: x2, y: y2, width, height }) => ({
  x: x2,
  y: y2,
  x2: x2 + width,
  y2: y2 + height
});
const boxToRect = ({ x: x2, y: y2, x2: x22, y2: y22 }) => ({
  x: x2,
  y: y2,
  width: x22 - x2,
  height: y22 - y2
});
const nodeToRect = (node, nodeOrigin = [0, 0]) => {
  var _a3, _b2, _c2, _d2, _e3, _f2, _g, _h;
  const { x: x2, y: y2 } = isInternalNodeBase(node) ? node.internals.positionAbsolute : getNodePositionWithOrigin(node, nodeOrigin);
  return {
    x: x2,
    y: y2,
    width: (_d2 = (_c2 = (_b2 = (_a3 = node.measured) == null ? void 0 : _a3.width) != null ? _b2 : node.width) != null ? _c2 : node.initialWidth) != null ? _d2 : 0,
    height: (_h = (_g = (_f2 = (_e3 = node.measured) == null ? void 0 : _e3.height) != null ? _f2 : node.height) != null ? _g : node.initialHeight) != null ? _h : 0
  };
};
const nodeToBox = (node, nodeOrigin = [0, 0]) => {
  var _a3, _b2, _c2, _d2, _e3, _f2, _g, _h;
  const { x: x2, y: y2 } = isInternalNodeBase(node) ? node.internals.positionAbsolute : getNodePositionWithOrigin(node, nodeOrigin);
  return {
    x: x2,
    y: y2,
    x2: x2 + ((_d2 = (_c2 = (_b2 = (_a3 = node.measured) == null ? void 0 : _a3.width) != null ? _b2 : node.width) != null ? _c2 : node.initialWidth) != null ? _d2 : 0),
    y2: y2 + ((_h = (_g = (_f2 = (_e3 = node.measured) == null ? void 0 : _e3.height) != null ? _f2 : node.height) != null ? _g : node.initialHeight) != null ? _h : 0)
  };
};
const getBoundsOfRects = (rect1, rect2) => boxToRect(getBoundsOfBoxes(rectToBox(rect1), rectToBox(rect2)));
const getOverlappingArea = (rectA, rectB) => {
  const xOverlap = Math.max(0, Math.min(rectA.x + rectA.width, rectB.x + rectB.width) - Math.max(rectA.x, rectB.x));
  const yOverlap = Math.max(0, Math.min(rectA.y + rectA.height, rectB.y + rectB.height) - Math.max(rectA.y, rectB.y));
  return Math.ceil(xOverlap * yOverlap);
};
const isRectObject = (obj) => isNumeric(obj.width) && isNumeric(obj.height) && isNumeric(obj.x) && isNumeric(obj.y);
const isNumeric = (n) => !isNaN(n) && isFinite(n);
const devWarn = (id2, message) => {
};
const snapPosition = (position, snapGrid = [1, 1]) => {
  return {
    x: snapGrid[0] * Math.round(position.x / snapGrid[0]),
    y: snapGrid[1] * Math.round(position.y / snapGrid[1])
  };
};
const pointToRendererPoint = ({ x: x2, y: y2 }, [tx, ty, tScale], snapToGrid = false, snapGrid = [1, 1]) => {
  const position = {
    x: (x2 - tx) / tScale,
    y: (y2 - ty) / tScale
  };
  return snapToGrid ? snapPosition(position, snapGrid) : position;
};
const rendererPointToPoint = ({ x: x2, y: y2 }, [tx, ty, tScale]) => {
  return {
    x: x2 * tScale + tx,
    y: y2 * tScale + ty
  };
};
function parsePadding(padding, viewport) {
  if (typeof padding === "number") {
    return Math.floor((viewport - viewport / (1 + padding)) * 0.5);
  }
  if (typeof padding === "string" && padding.endsWith("px")) {
    const paddingValue = parseFloat(padding);
    if (!Number.isNaN(paddingValue)) {
      return Math.floor(paddingValue);
    }
  }
  if (typeof padding === "string" && padding.endsWith("%")) {
    const paddingValue = parseFloat(padding);
    if (!Number.isNaN(paddingValue)) {
      return Math.floor(viewport * paddingValue * 0.01);
    }
  }
  console.error(`[React Flow] The padding value "${padding}" is invalid. Please provide a number or a string with a valid unit (px or %).`);
  return 0;
}
function parsePaddings(padding, width, height) {
  var _a3, _b2, _c2, _d2, _e3, _f2, _g, _h;
  if (typeof padding === "string" || typeof padding === "number") {
    const paddingY = parsePadding(padding, height);
    const paddingX = parsePadding(padding, width);
    return {
      top: paddingY,
      right: paddingX,
      bottom: paddingY,
      left: paddingX,
      x: paddingX * 2,
      y: paddingY * 2
    };
  }
  if (typeof padding === "object") {
    const top2 = parsePadding((_b2 = (_a3 = padding.top) != null ? _a3 : padding.y) != null ? _b2 : 0, height);
    const bottom = parsePadding((_d2 = (_c2 = padding.bottom) != null ? _c2 : padding.y) != null ? _d2 : 0, height);
    const left = parsePadding((_f2 = (_e3 = padding.left) != null ? _e3 : padding.x) != null ? _f2 : 0, width);
    const right = parsePadding((_h = (_g = padding.right) != null ? _g : padding.x) != null ? _h : 0, width);
    return { top: top2, right, bottom, left, x: left + right, y: top2 + bottom };
  }
  return { top: 0, right: 0, bottom: 0, left: 0, x: 0, y: 0 };
}
function calculateAppliedPaddings(bounds, x2, y2, zoom2, width, height) {
  const { x: left, y: top2 } = rendererPointToPoint(bounds, [x2, y2, zoom2]);
  const { x: boundRight, y: boundBottom } = rendererPointToPoint({ x: bounds.x + bounds.width, y: bounds.y + bounds.height }, [x2, y2, zoom2]);
  const right = width - boundRight;
  const bottom = height - boundBottom;
  return {
    left: Math.floor(left),
    top: Math.floor(top2),
    right: Math.floor(right),
    bottom: Math.floor(bottom)
  };
}
const getViewportForBounds = (bounds, width, height, minZoom, maxZoom, padding) => {
  const p = parsePaddings(padding, width, height);
  const xZoom = (width - p.x) / bounds.width;
  const yZoom = (height - p.y) / bounds.height;
  const zoom2 = Math.min(xZoom, yZoom);
  const clampedZoom = clamp(zoom2, minZoom, maxZoom);
  const boundsCenterX = bounds.x + bounds.width / 2;
  const boundsCenterY = bounds.y + bounds.height / 2;
  const x2 = width / 2 - boundsCenterX * clampedZoom;
  const y2 = height / 2 - boundsCenterY * clampedZoom;
  const newPadding = calculateAppliedPaddings(bounds, x2, y2, clampedZoom, width, height);
  const offset = {
    left: Math.min(newPadding.left - p.left, 0),
    top: Math.min(newPadding.top - p.top, 0),
    right: Math.min(newPadding.right - p.right, 0),
    bottom: Math.min(newPadding.bottom - p.bottom, 0)
  };
  return {
    x: x2 - offset.left + offset.right,
    y: y2 - offset.top + offset.bottom,
    zoom: clampedZoom
  };
};
const isMacOs = () => {
  var _a3;
  return typeof navigator !== "undefined" && ((_a3 = navigator == null ? void 0 : navigator.userAgent) == null ? void 0 : _a3.indexOf("Mac")) >= 0;
};
function isCoordinateExtent(extent) {
  return extent !== void 0 && extent !== null && extent !== "parent";
}
function getNodeDimensions(node) {
  var _a3, _b2, _c2, _d2, _e3, _f2, _g, _h;
  return {
    width: (_d2 = (_c2 = (_b2 = (_a3 = node.measured) == null ? void 0 : _a3.width) != null ? _b2 : node.width) != null ? _c2 : node.initialWidth) != null ? _d2 : 0,
    height: (_h = (_g = (_f2 = (_e3 = node.measured) == null ? void 0 : _e3.height) != null ? _f2 : node.height) != null ? _g : node.initialHeight) != null ? _h : 0
  };
}
function nodeHasDimensions(node) {
  var _a3, _b2, _c2, _d2, _e3, _f2;
  return ((_c2 = (_b2 = (_a3 = node.measured) == null ? void 0 : _a3.width) != null ? _b2 : node.width) != null ? _c2 : node.initialWidth) !== void 0 && ((_f2 = (_e3 = (_d2 = node.measured) == null ? void 0 : _d2.height) != null ? _e3 : node.height) != null ? _f2 : node.initialHeight) !== void 0;
}
function evaluateAbsolutePosition(position, dimensions = { width: 0, height: 0 }, parentId, nodeLookup, nodeOrigin) {
  var _a3, _b2;
  const positionAbsolute = __spreadValues({}, position);
  const parent = nodeLookup.get(parentId);
  if (parent) {
    const origin = parent.origin || nodeOrigin;
    positionAbsolute.x += parent.internals.positionAbsolute.x - ((_a3 = dimensions.width) != null ? _a3 : 0) * origin[0];
    positionAbsolute.y += parent.internals.positionAbsolute.y - ((_b2 = dimensions.height) != null ? _b2 : 0) * origin[1];
  }
  return positionAbsolute;
}
function mergeAriaLabelConfig(partial) {
  return __spreadValues(__spreadValues({}, defaultAriaLabelConfig), partial || {});
}
function getPointerPosition(event2, { snapGrid = [0, 0], snapToGrid = false, transform: transform2, containerBounds }) {
  var _a3, _b2;
  const { x: x2, y: y2 } = getEventPosition(event2);
  const pointerPos = pointToRendererPoint({ x: x2 - ((_a3 = containerBounds == null ? void 0 : containerBounds.left) != null ? _a3 : 0), y: y2 - ((_b2 = containerBounds == null ? void 0 : containerBounds.top) != null ? _b2 : 0) }, transform2);
  const { x: xSnapped, y: ySnapped } = snapToGrid ? snapPosition(pointerPos, snapGrid) : pointerPos;
  return __spreadValues({
    xSnapped,
    ySnapped
  }, pointerPos);
}
const getDimensions = (node) => ({
  width: node.offsetWidth,
  height: node.offsetHeight
});
const getHostForElement = (element) => {
  var _a3;
  return ((_a3 = element == null ? void 0 : element.getRootNode) == null ? void 0 : _a3.call(element)) || (window == null ? void 0 : window.document);
};
const inputTags = ["INPUT", "SELECT", "TEXTAREA"];
function isInputDOMNode(event2) {
  var _a3, _b2;
  const target = ((_b2 = (_a3 = event2.composedPath) == null ? void 0 : _a3.call(event2)) == null ? void 0 : _b2[0]) || event2.target;
  if ((target == null ? void 0 : target.nodeType) !== 1)
    return false;
  const isInput = inputTags.includes(target.nodeName) || target.hasAttribute("contenteditable");
  return isInput || !!target.closest(".nokey");
}
const isMouseEvent = (event2) => "clientX" in event2;
const getEventPosition = (event2, bounds) => {
  var _a3, _b2, _c2, _d2;
  const isMouse = isMouseEvent(event2);
  const evtX = isMouse ? event2.clientX : (_a3 = event2.touches) == null ? void 0 : _a3[0].clientX;
  const evtY = isMouse ? event2.clientY : (_b2 = event2.touches) == null ? void 0 : _b2[0].clientY;
  return {
    x: evtX - ((_c2 = bounds == null ? void 0 : bounds.left) != null ? _c2 : 0),
    y: evtY - ((_d2 = bounds == null ? void 0 : bounds.top) != null ? _d2 : 0)
  };
};
const getHandleBounds = (type, nodeElement, nodeBounds, zoom2, nodeId) => {
  const handles = nodeElement.querySelectorAll(`.${type}`);
  if (!handles || !handles.length) {
    return null;
  }
  return Array.from(handles).map((handle) => {
    const handleBounds = handle.getBoundingClientRect();
    return __spreadValues({
      id: handle.getAttribute("data-handleid"),
      type,
      nodeId,
      position: handle.getAttribute("data-handlepos"),
      x: (handleBounds.left - nodeBounds.left) / zoom2,
      y: (handleBounds.top - nodeBounds.top) / zoom2
    }, getDimensions(handle));
  });
};
function getBezierEdgeCenter({ sourceX, sourceY, targetX, targetY, sourceControlX, sourceControlY, targetControlX, targetControlY }) {
  const centerX = sourceX * 0.125 + sourceControlX * 0.375 + targetControlX * 0.375 + targetX * 0.125;
  const centerY = sourceY * 0.125 + sourceControlY * 0.375 + targetControlY * 0.375 + targetY * 0.125;
  const offsetX = Math.abs(centerX - sourceX);
  const offsetY = Math.abs(centerY - sourceY);
  return [centerX, centerY, offsetX, offsetY];
}
function calculateControlOffset(distance2, curvature) {
  if (distance2 >= 0) {
    return 0.5 * distance2;
  }
  return curvature * 25 * Math.sqrt(-distance2);
}
function getControlWithCurvature({ pos, x1, y1, x2, y2, c }) {
  switch (pos) {
    case Position.Left:
      return [x1 - calculateControlOffset(x1 - x2, c), y1];
    case Position.Right:
      return [x1 + calculateControlOffset(x2 - x1, c), y1];
    case Position.Top:
      return [x1, y1 - calculateControlOffset(y1 - y2, c)];
    case Position.Bottom:
      return [x1, y1 + calculateControlOffset(y2 - y1, c)];
  }
}
function getBezierPath({ sourceX, sourceY, sourcePosition = Position.Bottom, targetX, targetY, targetPosition = Position.Top, curvature = 0.25 }) {
  const [sourceControlX, sourceControlY] = getControlWithCurvature({
    pos: sourcePosition,
    x1: sourceX,
    y1: sourceY,
    x2: targetX,
    y2: targetY,
    c: curvature
  });
  const [targetControlX, targetControlY] = getControlWithCurvature({
    pos: targetPosition,
    x1: targetX,
    y1: targetY,
    x2: sourceX,
    y2: sourceY,
    c: curvature
  });
  const [labelX, labelY, offsetX, offsetY] = getBezierEdgeCenter({
    sourceX,
    sourceY,
    targetX,
    targetY,
    sourceControlX,
    sourceControlY,
    targetControlX,
    targetControlY
  });
  return [
    `M${sourceX},${sourceY} C${sourceControlX},${sourceControlY} ${targetControlX},${targetControlY} ${targetX},${targetY}`,
    labelX,
    labelY,
    offsetX,
    offsetY
  ];
}
function getEdgeCenter({ sourceX, sourceY, targetX, targetY }) {
  const xOffset = Math.abs(targetX - sourceX) / 2;
  const centerX = targetX < sourceX ? targetX + xOffset : targetX - xOffset;
  const yOffset = Math.abs(targetY - sourceY) / 2;
  const centerY = targetY < sourceY ? targetY + yOffset : targetY - yOffset;
  return [centerX, centerY, xOffset, yOffset];
}
function getElevatedEdgeZIndex({ sourceNode, targetNode, selected = false, zIndex, elevateOnSelect = false }) {
  if (zIndex !== void 0) {
    return zIndex;
  }
  const edgeZ = elevateOnSelect && selected ? 1e3 : 0;
  const nodeZ = Math.max(sourceNode.parentId ? sourceNode.internals.z : 0, targetNode.parentId ? targetNode.internals.z : 0);
  return edgeZ + nodeZ;
}
function isEdgeVisible({ sourceNode, targetNode, width, height, transform: transform2 }) {
  const edgeBox = getBoundsOfBoxes(nodeToBox(sourceNode), nodeToBox(targetNode));
  if (edgeBox.x === edgeBox.x2) {
    edgeBox.x2 += 1;
  }
  if (edgeBox.y === edgeBox.y2) {
    edgeBox.y2 += 1;
  }
  const viewRect = {
    x: -transform2[0] / transform2[2],
    y: -transform2[1] / transform2[2],
    width: width / transform2[2],
    height: height / transform2[2]
  };
  return getOverlappingArea(viewRect, boxToRect(edgeBox)) > 0;
}
const getEdgeId = ({ source: source2, sourceHandle, target, targetHandle }) => `xy-edge__${source2}${sourceHandle || ""}-${target}${targetHandle || ""}`;
const connectionExists = (edge, edges) => {
  return edges.some((el) => el.source === edge.source && el.target === edge.target && (el.sourceHandle === edge.sourceHandle || !el.sourceHandle && !edge.sourceHandle) && (el.targetHandle === edge.targetHandle || !el.targetHandle && !edge.targetHandle));
};
const addEdge = (edgeParams, edges) => {
  if (!edgeParams.source || !edgeParams.target) {
    return edges;
  }
  let edge;
  if (isEdgeBase(edgeParams)) {
    edge = __spreadValues({}, edgeParams);
  } else {
    edge = __spreadProps(__spreadValues({}, edgeParams), {
      id: getEdgeId(edgeParams)
    });
  }
  if (connectionExists(edge, edges)) {
    return edges;
  }
  if (edge.sourceHandle === null) {
    delete edge.sourceHandle;
  }
  if (edge.targetHandle === null) {
    delete edge.targetHandle;
  }
  return edges.concat(edge);
};
function getStraightPath({ sourceX, sourceY, targetX, targetY }) {
  const [labelX, labelY, offsetX, offsetY] = getEdgeCenter({
    sourceX,
    sourceY,
    targetX,
    targetY
  });
  return [`M ${sourceX},${sourceY}L ${targetX},${targetY}`, labelX, labelY, offsetX, offsetY];
}
const handleDirections = {
  [Position.Left]: { x: -1, y: 0 },
  [Position.Right]: { x: 1, y: 0 },
  [Position.Top]: { x: 0, y: -1 },
  [Position.Bottom]: { x: 0, y: 1 }
};
const getDirection = ({ source: source2, sourcePosition = Position.Bottom, target }) => {
  if (sourcePosition === Position.Left || sourcePosition === Position.Right) {
    return source2.x < target.x ? { x: 1, y: 0 } : { x: -1, y: 0 };
  }
  return source2.y < target.y ? { x: 0, y: 1 } : { x: 0, y: -1 };
};
const distance = (a, b2) => Math.sqrt(Math.pow(b2.x - a.x, 2) + Math.pow(b2.y - a.y, 2));
function getPoints({ source: source2, sourcePosition = Position.Bottom, target, targetPosition = Position.Top, center, offset, stepPosition }) {
  var _a3, _b2, _c2, _d2;
  const sourceDir = handleDirections[sourcePosition];
  const targetDir = handleDirections[targetPosition];
  const sourceGapped = { x: source2.x + sourceDir.x * offset, y: source2.y + sourceDir.y * offset };
  const targetGapped = { x: target.x + targetDir.x * offset, y: target.y + targetDir.y * offset };
  const dir = getDirection({
    source: sourceGapped,
    sourcePosition,
    target: targetGapped
  });
  const dirAccessor = dir.x !== 0 ? "x" : "y";
  const currDir = dir[dirAccessor];
  let points = [];
  let centerX, centerY;
  const sourceGapOffset = { x: 0, y: 0 };
  const targetGapOffset = { x: 0, y: 0 };
  const [, , defaultOffsetX, defaultOffsetY] = getEdgeCenter({
    sourceX: source2.x,
    sourceY: source2.y,
    targetX: target.x,
    targetY: target.y
  });
  if (sourceDir[dirAccessor] * targetDir[dirAccessor] === -1) {
    if (dirAccessor === "x") {
      centerX = (_a3 = center.x) != null ? _a3 : sourceGapped.x + (targetGapped.x - sourceGapped.x) * stepPosition;
      centerY = (_b2 = center.y) != null ? _b2 : (sourceGapped.y + targetGapped.y) / 2;
    } else {
      centerX = (_c2 = center.x) != null ? _c2 : (sourceGapped.x + targetGapped.x) / 2;
      centerY = (_d2 = center.y) != null ? _d2 : sourceGapped.y + (targetGapped.y - sourceGapped.y) * stepPosition;
    }
    const verticalSplit = [
      { x: centerX, y: sourceGapped.y },
      { x: centerX, y: targetGapped.y }
    ];
    const horizontalSplit = [
      { x: sourceGapped.x, y: centerY },
      { x: targetGapped.x, y: centerY }
    ];
    if (sourceDir[dirAccessor] === currDir) {
      points = dirAccessor === "x" ? verticalSplit : horizontalSplit;
    } else {
      points = dirAccessor === "x" ? horizontalSplit : verticalSplit;
    }
  } else {
    const sourceTarget = [{ x: sourceGapped.x, y: targetGapped.y }];
    const targetSource = [{ x: targetGapped.x, y: sourceGapped.y }];
    if (dirAccessor === "x") {
      points = sourceDir.x === currDir ? targetSource : sourceTarget;
    } else {
      points = sourceDir.y === currDir ? sourceTarget : targetSource;
    }
    if (sourcePosition === targetPosition) {
      const diff = Math.abs(source2[dirAccessor] - target[dirAccessor]);
      if (diff <= offset) {
        const gapOffset = Math.min(offset - 1, offset - diff);
        if (sourceDir[dirAccessor] === currDir) {
          sourceGapOffset[dirAccessor] = (sourceGapped[dirAccessor] > source2[dirAccessor] ? -1 : 1) * gapOffset;
        } else {
          targetGapOffset[dirAccessor] = (targetGapped[dirAccessor] > target[dirAccessor] ? -1 : 1) * gapOffset;
        }
      }
    }
    if (sourcePosition !== targetPosition) {
      const dirAccessorOpposite = dirAccessor === "x" ? "y" : "x";
      const isSameDir = sourceDir[dirAccessor] === targetDir[dirAccessorOpposite];
      const sourceGtTargetOppo = sourceGapped[dirAccessorOpposite] > targetGapped[dirAccessorOpposite];
      const sourceLtTargetOppo = sourceGapped[dirAccessorOpposite] < targetGapped[dirAccessorOpposite];
      const flipSourceTarget = sourceDir[dirAccessor] === 1 && (!isSameDir && sourceGtTargetOppo || isSameDir && sourceLtTargetOppo) || sourceDir[dirAccessor] !== 1 && (!isSameDir && sourceLtTargetOppo || isSameDir && sourceGtTargetOppo);
      if (flipSourceTarget) {
        points = dirAccessor === "x" ? sourceTarget : targetSource;
      }
    }
    const sourceGapPoint = { x: sourceGapped.x + sourceGapOffset.x, y: sourceGapped.y + sourceGapOffset.y };
    const targetGapPoint = { x: targetGapped.x + targetGapOffset.x, y: targetGapped.y + targetGapOffset.y };
    const maxXDistance = Math.max(Math.abs(sourceGapPoint.x - points[0].x), Math.abs(targetGapPoint.x - points[0].x));
    const maxYDistance = Math.max(Math.abs(sourceGapPoint.y - points[0].y), Math.abs(targetGapPoint.y - points[0].y));
    if (maxXDistance >= maxYDistance) {
      centerX = (sourceGapPoint.x + targetGapPoint.x) / 2;
      centerY = points[0].y;
    } else {
      centerX = points[0].x;
      centerY = (sourceGapPoint.y + targetGapPoint.y) / 2;
    }
  }
  const pathPoints = [
    source2,
    { x: sourceGapped.x + sourceGapOffset.x, y: sourceGapped.y + sourceGapOffset.y },
    ...points,
    { x: targetGapped.x + targetGapOffset.x, y: targetGapped.y + targetGapOffset.y },
    target
  ];
  return [pathPoints, centerX, centerY, defaultOffsetX, defaultOffsetY];
}
function getBend(a, b2, c, size) {
  const bendSize = Math.min(distance(a, b2) / 2, distance(b2, c) / 2, size);
  const { x: x2, y: y2 } = b2;
  if (a.x === x2 && x2 === c.x || a.y === y2 && y2 === c.y) {
    return `L${x2} ${y2}`;
  }
  if (a.y === y2) {
    const xDir2 = a.x < c.x ? -1 : 1;
    const yDir2 = a.y < c.y ? 1 : -1;
    return `L ${x2 + bendSize * xDir2},${y2}Q ${x2},${y2} ${x2},${y2 + bendSize * yDir2}`;
  }
  const xDir = a.x < c.x ? 1 : -1;
  const yDir = a.y < c.y ? -1 : 1;
  return `L ${x2},${y2 + bendSize * yDir}Q ${x2},${y2} ${x2 + bendSize * xDir},${y2}`;
}
function getSmoothStepPath({ sourceX, sourceY, sourcePosition = Position.Bottom, targetX, targetY, targetPosition = Position.Top, borderRadius = 5, centerX, centerY, offset = 20, stepPosition = 0.5 }) {
  const [points, labelX, labelY, offsetX, offsetY] = getPoints({
    source: { x: sourceX, y: sourceY },
    sourcePosition,
    target: { x: targetX, y: targetY },
    targetPosition,
    center: { x: centerX, y: centerY },
    offset,
    stepPosition
  });
  const path = points.reduce((res, p, i) => {
    let segment = "";
    if (i > 0 && i < points.length - 1) {
      segment = getBend(points[i - 1], p, points[i + 1], borderRadius);
    } else {
      segment = `${i === 0 ? "M" : "L"}${p.x} ${p.y}`;
    }
    res += segment;
    return res;
  }, "");
  return [path, labelX, labelY, offsetX, offsetY];
}
function isNodeInitialized(node) {
  var _a3;
  return node && !!(node.internals.handleBounds || ((_a3 = node.handles) == null ? void 0 : _a3.length)) && !!(node.measured.width || node.width || node.initialWidth);
}
function getEdgePosition(params) {
  var _a3, _b2, _c2, _d2, _e3;
  const { sourceNode, targetNode } = params;
  if (!isNodeInitialized(sourceNode) || !isNodeInitialized(targetNode)) {
    return null;
  }
  const sourceHandleBounds = sourceNode.internals.handleBounds || toHandleBounds(sourceNode.handles);
  const targetHandleBounds = targetNode.internals.handleBounds || toHandleBounds(targetNode.handles);
  const sourceHandle = getHandle$1((_a3 = sourceHandleBounds == null ? void 0 : sourceHandleBounds.source) != null ? _a3 : [], params.sourceHandle);
  const targetHandle = getHandle$1(
    // when connection type is loose we can define all handles as sources and connect source -> source
    params.connectionMode === ConnectionMode.Strict ? (_b2 = targetHandleBounds == null ? void 0 : targetHandleBounds.target) != null ? _b2 : [] : ((_c2 = targetHandleBounds == null ? void 0 : targetHandleBounds.target) != null ? _c2 : []).concat((_d2 = targetHandleBounds == null ? void 0 : targetHandleBounds.source) != null ? _d2 : []),
    params.targetHandle
  );
  if (!sourceHandle || !targetHandle) {
    (_e3 = params.onError) == null ? void 0 : _e3.call(params, "008", errorMessages["error008"](!sourceHandle ? "source" : "target", {
      id: params.id,
      sourceHandle: params.sourceHandle,
      targetHandle: params.targetHandle
    }));
    return null;
  }
  const sourcePosition = (sourceHandle == null ? void 0 : sourceHandle.position) || Position.Bottom;
  const targetPosition = (targetHandle == null ? void 0 : targetHandle.position) || Position.Top;
  const source2 = getHandlePosition(sourceNode, sourceHandle, sourcePosition);
  const target = getHandlePosition(targetNode, targetHandle, targetPosition);
  return {
    sourceX: source2.x,
    sourceY: source2.y,
    targetX: target.x,
    targetY: target.y,
    sourcePosition,
    targetPosition
  };
}
function toHandleBounds(handles) {
  var _a3, _b2;
  if (!handles) {
    return null;
  }
  const source2 = [];
  const target = [];
  for (const handle of handles) {
    handle.width = (_a3 = handle.width) != null ? _a3 : 1;
    handle.height = (_b2 = handle.height) != null ? _b2 : 1;
    if (handle.type === "source") {
      source2.push(handle);
    } else if (handle.type === "target") {
      target.push(handle);
    }
  }
  return {
    source: source2,
    target
  };
}
function getHandlePosition(node, handle, fallbackPosition = Position.Left, center = false) {
  var _a3, _b2, _c2;
  const x2 = ((_a3 = handle == null ? void 0 : handle.x) != null ? _a3 : 0) + node.internals.positionAbsolute.x;
  const y2 = ((_b2 = handle == null ? void 0 : handle.y) != null ? _b2 : 0) + node.internals.positionAbsolute.y;
  const { width, height } = handle != null ? handle : getNodeDimensions(node);
  if (center) {
    return { x: x2 + width / 2, y: y2 + height / 2 };
  }
  const position = (_c2 = handle == null ? void 0 : handle.position) != null ? _c2 : fallbackPosition;
  switch (position) {
    case Position.Top:
      return { x: x2 + width / 2, y: y2 };
    case Position.Right:
      return { x: x2 + width, y: y2 + height / 2 };
    case Position.Bottom:
      return { x: x2 + width / 2, y: y2 + height };
    case Position.Left:
      return { x: x2, y: y2 + height / 2 };
  }
}
function getHandle$1(bounds, handleId) {
  if (!bounds) {
    return null;
  }
  return (!handleId ? bounds[0] : bounds.find((d) => d.id === handleId)) || null;
}
function getMarkerId(marker, id2) {
  if (!marker) {
    return "";
  }
  if (typeof marker === "string") {
    return marker;
  }
  const idPrefix = id2 ? `${id2}__` : "";
  return `${idPrefix}${Object.keys(marker).sort().map((key2) => `${key2}=${marker[key2]}`).join("&")}`;
}
function createMarkerIds(edges, { id: id2, defaultColor, defaultMarkerStart, defaultMarkerEnd }) {
  const ids = /* @__PURE__ */ new Set();
  return edges.reduce((markers, edge) => {
    [edge.markerStart || defaultMarkerStart, edge.markerEnd || defaultMarkerEnd].forEach((marker) => {
      if (marker && typeof marker === "object") {
        const markerId = getMarkerId(marker, id2);
        if (!ids.has(markerId)) {
          markers.push(__spreadValues({ id: markerId, color: marker.color || defaultColor }, marker));
          ids.add(markerId);
        }
      }
    });
    return markers;
  }, []).sort((a, b2) => a.id.localeCompare(b2.id));
}
const defaultOptions = {
  nodeOrigin: [0, 0],
  nodeExtent: infiniteExtent,
  elevateNodesOnSelect: true,
  defaults: {}
};
const adoptUserNodesDefaultOptions = __spreadProps(__spreadValues({}, defaultOptions), {
  checkEquality: true
});
function mergeObjects(base2, incoming) {
  const result = __spreadValues({}, base2);
  for (const key2 in incoming) {
    if (incoming[key2] !== void 0) {
      result[key2] = incoming[key2];
    }
  }
  return result;
}
function updateAbsolutePositions(nodeLookup, parentLookup, options2) {
  const _options2 = mergeObjects(defaultOptions, options2);
  for (const node of nodeLookup.values()) {
    if (node.parentId) {
      updateChildNode(node, nodeLookup, parentLookup, _options2);
    } else {
      const positionWithOrigin = getNodePositionWithOrigin(node, _options2.nodeOrigin);
      const extent = isCoordinateExtent(node.extent) ? node.extent : _options2.nodeExtent;
      const clampedPosition = clampPosition(positionWithOrigin, extent, getNodeDimensions(node));
      node.internals.positionAbsolute = clampedPosition;
    }
  }
}
function adoptUserNodes(nodes, nodeLookup, parentLookup, options2) {
  var _a3, _b2;
  const _options2 = mergeObjects(adoptUserNodesDefaultOptions, options2);
  let nodesInitialized = nodes.length > 0;
  const tmpLookup = new Map(nodeLookup);
  const selectedNodeZ = (_options2 == null ? void 0 : _options2.elevateNodesOnSelect) ? 1e3 : 0;
  nodeLookup.clear();
  parentLookup.clear();
  for (const userNode of nodes) {
    let internalNode = tmpLookup.get(userNode.id);
    if (_options2.checkEquality && userNode === (internalNode == null ? void 0 : internalNode.internals.userNode)) {
      nodeLookup.set(userNode.id, internalNode);
    } else {
      const positionWithOrigin = getNodePositionWithOrigin(userNode, _options2.nodeOrigin);
      const extent = isCoordinateExtent(userNode.extent) ? userNode.extent : _options2.nodeExtent;
      const clampedPosition = clampPosition(positionWithOrigin, extent, getNodeDimensions(userNode));
      internalNode = __spreadProps(__spreadValues(__spreadValues({}, _options2.defaults), userNode), {
        measured: {
          width: (_a3 = userNode.measured) == null ? void 0 : _a3.width,
          height: (_b2 = userNode.measured) == null ? void 0 : _b2.height
        },
        internals: {
          positionAbsolute: clampedPosition,
          // if user re-initializes the node or removes `measured` for whatever reason, we reset the handleBounds so that the node gets re-measured
          handleBounds: !userNode.measured ? void 0 : internalNode == null ? void 0 : internalNode.internals.handleBounds,
          z: calculateZ(userNode, selectedNodeZ),
          userNode
        }
      });
      nodeLookup.set(userNode.id, internalNode);
    }
    if ((internalNode.measured === void 0 || internalNode.measured.width === void 0 || internalNode.measured.height === void 0) && !internalNode.hidden) {
      nodesInitialized = false;
    }
    if (userNode.parentId) {
      updateChildNode(internalNode, nodeLookup, parentLookup, options2);
    }
  }
  return nodesInitialized;
}
function updateParentLookup(node, parentLookup) {
  if (!node.parentId) {
    return;
  }
  const childNodes = parentLookup.get(node.parentId);
  if (childNodes) {
    childNodes.set(node.id, node);
  } else {
    parentLookup.set(node.parentId, /* @__PURE__ */ new Map([[node.id, node]]));
  }
}
function updateChildNode(node, nodeLookup, parentLookup, options2) {
  const { elevateNodesOnSelect, nodeOrigin, nodeExtent } = mergeObjects(defaultOptions, options2);
  const parentId = node.parentId;
  const parentNode = nodeLookup.get(parentId);
  if (!parentNode) {
    console.warn(`Parent node ${parentId} not found. Please make sure that parent nodes are in front of their child nodes in the nodes array.`);
    return;
  }
  updateParentLookup(node, parentLookup);
  const selectedNodeZ = elevateNodesOnSelect ? 1e3 : 0;
  const { x: x2, y: y2, z: z2 } = calculateChildXYZ(node, parentNode, nodeOrigin, nodeExtent, selectedNodeZ);
  const { positionAbsolute } = node.internals;
  const positionChanged = x2 !== positionAbsolute.x || y2 !== positionAbsolute.y;
  if (positionChanged || z2 !== node.internals.z) {
    nodeLookup.set(node.id, __spreadProps(__spreadValues({}, node), {
      internals: __spreadProps(__spreadValues({}, node.internals), {
        positionAbsolute: positionChanged ? { x: x2, y: y2 } : positionAbsolute,
        z: z2
      })
    }));
  }
}
function calculateZ(node, selectedNodeZ) {
  return (isNumeric(node.zIndex) ? node.zIndex : 0) + (node.selected ? selectedNodeZ : 0);
}
function calculateChildXYZ(childNode, parentNode, nodeOrigin, nodeExtent, selectedNodeZ) {
  var _a3;
  const { x: parentX, y: parentY } = parentNode.internals.positionAbsolute;
  const childDimensions = getNodeDimensions(childNode);
  const positionWithOrigin = getNodePositionWithOrigin(childNode, nodeOrigin);
  const clampedPosition = isCoordinateExtent(childNode.extent) ? clampPosition(positionWithOrigin, childNode.extent, childDimensions) : positionWithOrigin;
  let absolutePosition = clampPosition({ x: parentX + clampedPosition.x, y: parentY + clampedPosition.y }, nodeExtent, childDimensions);
  if (childNode.extent === "parent") {
    absolutePosition = clampPositionToParent(absolutePosition, childDimensions, parentNode);
  }
  const childZ = calculateZ(childNode, selectedNodeZ);
  const parentZ = (_a3 = parentNode.internals.z) != null ? _a3 : 0;
  return {
    x: absolutePosition.x,
    y: absolutePosition.y,
    z: parentZ >= childZ ? parentZ + 1 : childZ
  };
}
function handleExpandParent(children2, nodeLookup, parentLookup, nodeOrigin = [0, 0]) {
  var _a3, _b2;
  const changes = [];
  const parentExpansions = /* @__PURE__ */ new Map();
  for (const child2 of children2) {
    const parent = nodeLookup.get(child2.parentId);
    if (!parent) {
      continue;
    }
    const parentRect = (_b2 = (_a3 = parentExpansions.get(child2.parentId)) == null ? void 0 : _a3.expandedRect) != null ? _b2 : nodeToRect(parent);
    const expandedRect = getBoundsOfRects(parentRect, child2.rect);
    parentExpansions.set(child2.parentId, { expandedRect, parent });
  }
  if (parentExpansions.size > 0) {
    parentExpansions.forEach(({ expandedRect, parent }, parentId) => {
      var _a4, _b3;
      const positionAbsolute = parent.internals.positionAbsolute;
      const dimensions = getNodeDimensions(parent);
      const origin = (_a4 = parent.origin) != null ? _a4 : nodeOrigin;
      const xChange = expandedRect.x < positionAbsolute.x ? Math.round(Math.abs(positionAbsolute.x - expandedRect.x)) : 0;
      const yChange = expandedRect.y < positionAbsolute.y ? Math.round(Math.abs(positionAbsolute.y - expandedRect.y)) : 0;
      const newWidth = Math.max(dimensions.width, Math.round(expandedRect.width));
      const newHeight = Math.max(dimensions.height, Math.round(expandedRect.height));
      const widthChange = (newWidth - dimensions.width) * origin[0];
      const heightChange = (newHeight - dimensions.height) * origin[1];
      if (xChange > 0 || yChange > 0 || widthChange || heightChange) {
        changes.push({
          id: parentId,
          type: "position",
          position: {
            x: parent.position.x - xChange + widthChange,
            y: parent.position.y - yChange + heightChange
          }
        });
        (_b3 = parentLookup.get(parentId)) == null ? void 0 : _b3.forEach((childNode) => {
          if (!children2.some((child2) => child2.id === childNode.id)) {
            changes.push({
              id: childNode.id,
              type: "position",
              position: {
                x: childNode.position.x + xChange,
                y: childNode.position.y + yChange
              }
            });
          }
        });
      }
      if (dimensions.width < expandedRect.width || dimensions.height < expandedRect.height || xChange || yChange) {
        changes.push({
          id: parentId,
          type: "dimensions",
          setAttributes: true,
          dimensions: {
            width: newWidth + (xChange ? origin[0] * xChange - widthChange : 0),
            height: newHeight + (yChange ? origin[1] * yChange - heightChange : 0)
          }
        });
      }
    });
  }
  return changes;
}
function updateNodeInternals(updates, nodeLookup, parentLookup, domNode, nodeOrigin, nodeExtent) {
  const viewportNode = domNode == null ? void 0 : domNode.querySelector(".xyflow__viewport");
  let updatedInternals = false;
  if (!viewportNode) {
    return { changes: [], updatedInternals };
  }
  const changes = [];
  const style = window.getComputedStyle(viewportNode);
  const { m22: zoom2 } = new window.DOMMatrixReadOnly(style.transform);
  const parentExpandChildren = [];
  for (const update2 of updates.values()) {
    const node = nodeLookup.get(update2.id);
    if (!node) {
      continue;
    }
    if (node.hidden) {
      nodeLookup.set(node.id, __spreadProps(__spreadValues({}, node), {
        internals: __spreadProps(__spreadValues({}, node.internals), {
          handleBounds: void 0
        })
      }));
      updatedInternals = true;
      continue;
    }
    const dimensions = getDimensions(update2.nodeElement);
    const dimensionChanged = node.measured.width !== dimensions.width || node.measured.height !== dimensions.height;
    const doUpdate = !!(dimensions.width && dimensions.height && (dimensionChanged || !node.internals.handleBounds || update2.force));
    if (doUpdate) {
      const nodeBounds = update2.nodeElement.getBoundingClientRect();
      const extent = isCoordinateExtent(node.extent) ? node.extent : nodeExtent;
      let { positionAbsolute } = node.internals;
      if (node.parentId && node.extent === "parent") {
        positionAbsolute = clampPositionToParent(positionAbsolute, dimensions, nodeLookup.get(node.parentId));
      } else if (extent) {
        positionAbsolute = clampPosition(positionAbsolute, extent, dimensions);
      }
      const newNode = __spreadProps(__spreadValues({}, node), {
        measured: dimensions,
        internals: __spreadProps(__spreadValues({}, node.internals), {
          positionAbsolute,
          handleBounds: {
            source: getHandleBounds("source", update2.nodeElement, nodeBounds, zoom2, node.id),
            target: getHandleBounds("target", update2.nodeElement, nodeBounds, zoom2, node.id)
          }
        })
      });
      nodeLookup.set(node.id, newNode);
      if (node.parentId) {
        updateChildNode(newNode, nodeLookup, parentLookup, { nodeOrigin });
      }
      updatedInternals = true;
      if (dimensionChanged) {
        changes.push({
          id: node.id,
          type: "dimensions",
          dimensions
        });
        if (node.expandParent && node.parentId) {
          parentExpandChildren.push({
            id: node.id,
            parentId: node.parentId,
            rect: nodeToRect(newNode, nodeOrigin)
          });
        }
      }
    }
  }
  if (parentExpandChildren.length > 0) {
    const parentExpandChanges = handleExpandParent(parentExpandChildren, nodeLookup, parentLookup, nodeOrigin);
    changes.push(...parentExpandChanges);
  }
  return { changes, updatedInternals };
}
function panBy(_0) {
  return __async(this, arguments, function* ({ delta, panZoom, transform: transform2, translateExtent, width, height }) {
    if (!panZoom || !delta.x && !delta.y) {
      return Promise.resolve(false);
    }
    const nextViewport = yield panZoom.setViewportConstrained({
      x: transform2[0] + delta.x,
      y: transform2[1] + delta.y,
      zoom: transform2[2]
    }, [
      [0, 0],
      [width, height]
    ], translateExtent);
    const transformChanged = !!nextViewport && (nextViewport.x !== transform2[0] || nextViewport.y !== transform2[1] || nextViewport.k !== transform2[2]);
    return Promise.resolve(transformChanged);
  });
}
function addConnectionToLookup(type, connection, connectionKey, connectionLookup, nodeId, handleId) {
  let key2 = nodeId;
  const nodeMap = connectionLookup.get(key2) || /* @__PURE__ */ new Map();
  connectionLookup.set(key2, nodeMap.set(connectionKey, connection));
  key2 = `${nodeId}-${type}`;
  const typeMap = connectionLookup.get(key2) || /* @__PURE__ */ new Map();
  connectionLookup.set(key2, typeMap.set(connectionKey, connection));
  if (handleId) {
    key2 = `${nodeId}-${type}-${handleId}`;
    const handleMap = connectionLookup.get(key2) || /* @__PURE__ */ new Map();
    connectionLookup.set(key2, handleMap.set(connectionKey, connection));
  }
}
function updateConnectionLookup(connectionLookup, edgeLookup, edges) {
  connectionLookup.clear();
  edgeLookup.clear();
  for (const edge of edges) {
    const { source: sourceNode, target: targetNode, sourceHandle = null, targetHandle = null } = edge;
    const connection = { edgeId: edge.id, source: sourceNode, target: targetNode, sourceHandle, targetHandle };
    const sourceKey = `${sourceNode}-${sourceHandle}--${targetNode}-${targetHandle}`;
    const targetKey = `${targetNode}-${targetHandle}--${sourceNode}-${sourceHandle}`;
    addConnectionToLookup("source", connection, targetKey, connectionLookup, sourceNode, sourceHandle);
    addConnectionToLookup("target", connection, sourceKey, connectionLookup, targetNode, targetHandle);
    edgeLookup.set(edge.id, edge);
  }
}
function isParentSelected(node, nodeLookup) {
  if (!node.parentId) {
    return false;
  }
  const parentNode = nodeLookup.get(node.parentId);
  if (!parentNode) {
    return false;
  }
  if (parentNode.selected) {
    return true;
  }
  return isParentSelected(parentNode, nodeLookup);
}
function hasSelector(target, selector2, domNode) {
  var _a3;
  let current = target;
  do {
    if ((_a3 = current == null ? void 0 : current.matches) == null ? void 0 : _a3.call(current, selector2))
      return true;
    if (current === domNode)
      return false;
    current = current == null ? void 0 : current.parentElement;
  } while (current);
  return false;
}
function getDragItems(nodeLookup, nodesDraggable, mousePos, nodeId) {
  var _a3, _b2;
  const dragItems = /* @__PURE__ */ new Map();
  for (const [id2, node] of nodeLookup) {
    if ((node.selected || node.id === nodeId) && (!node.parentId || !isParentSelected(node, nodeLookup)) && (node.draggable || nodesDraggable && typeof node.draggable === "undefined")) {
      const internalNode = nodeLookup.get(id2);
      if (internalNode) {
        dragItems.set(id2, {
          id: id2,
          position: internalNode.position || { x: 0, y: 0 },
          distance: {
            x: mousePos.x - internalNode.internals.positionAbsolute.x,
            y: mousePos.y - internalNode.internals.positionAbsolute.y
          },
          extent: internalNode.extent,
          parentId: internalNode.parentId,
          origin: internalNode.origin,
          expandParent: internalNode.expandParent,
          internals: {
            positionAbsolute: internalNode.internals.positionAbsolute || { x: 0, y: 0 }
          },
          measured: {
            width: (_a3 = internalNode.measured.width) != null ? _a3 : 0,
            height: (_b2 = internalNode.measured.height) != null ? _b2 : 0
          }
        });
      }
    }
  }
  return dragItems;
}
function getEventHandlerParams({ nodeId, dragItems, nodeLookup, dragging = true }) {
  var _a3, _b2, _c2;
  const nodesFromDragItems = [];
  for (const [id2, dragItem] of dragItems) {
    const node2 = (_a3 = nodeLookup.get(id2)) == null ? void 0 : _a3.internals.userNode;
    if (node2) {
      nodesFromDragItems.push(__spreadProps(__spreadValues({}, node2), {
        position: dragItem.position,
        dragging
      }));
    }
  }
  if (!nodeId) {
    return [nodesFromDragItems[0], nodesFromDragItems];
  }
  const node = (_b2 = nodeLookup.get(nodeId)) == null ? void 0 : _b2.internals.userNode;
  return [
    !node ? nodesFromDragItems[0] : __spreadProps(__spreadValues({}, node), {
      position: ((_c2 = dragItems.get(nodeId)) == null ? void 0 : _c2.position) || node.position,
      dragging
    }),
    nodesFromDragItems
  ];
}
function calculateSnapOffset({ dragItems, snapGrid, x: x2, y: y2 }) {
  const refDragItem = dragItems.values().next().value;
  if (!refDragItem) {
    return null;
  }
  const refPos = {
    x: x2 - refDragItem.distance.x,
    y: y2 - refDragItem.distance.y
  };
  const refPosSnapped = snapPosition(refPos, snapGrid);
  return {
    x: refPosSnapped.x - refPos.x,
    y: refPosSnapped.y - refPos.y
  };
}
function XYDrag({ onNodeMouseDown, getStoreItems, onDragStart, onDrag, onDragStop }) {
  let lastPos = { x: null, y: null };
  let autoPanId = 0;
  let dragItems = /* @__PURE__ */ new Map();
  let autoPanStarted = false;
  let mousePosition = { x: 0, y: 0 };
  let containerBounds = null;
  let dragStarted = false;
  let d3Selection = null;
  let abortDrag = false;
  let nodePositionsChanged = false;
  let dragEvent = null;
  function update2({ noDragClassName, handleSelector, domNode, isSelectable, nodeId, nodeClickDistance = 0 }) {
    d3Selection = select(domNode);
    function updateNodes({ x: x2, y: y2 }) {
      const { nodeLookup, nodeExtent, snapGrid, snapToGrid, nodeOrigin, onNodeDrag, onSelectionDrag, onError: onError2, updateNodePositions } = getStoreItems();
      lastPos = { x: x2, y: y2 };
      let hasChange = false;
      const isMultiDrag = dragItems.size > 1;
      const nodesBox = isMultiDrag && nodeExtent ? rectToBox(getInternalNodesBounds(dragItems)) : null;
      const multiDragSnapOffset = isMultiDrag && snapToGrid ? calculateSnapOffset({
        dragItems,
        snapGrid,
        x: x2,
        y: y2
      }) : null;
      for (const [id2, dragItem] of dragItems) {
        if (!nodeLookup.has(id2)) {
          continue;
        }
        let nextPosition = { x: x2 - dragItem.distance.x, y: y2 - dragItem.distance.y };
        if (snapToGrid) {
          nextPosition = multiDragSnapOffset ? {
            x: Math.round(nextPosition.x + multiDragSnapOffset.x),
            y: Math.round(nextPosition.y + multiDragSnapOffset.y)
          } : snapPosition(nextPosition, snapGrid);
        }
        let adjustedNodeExtent = null;
        if (isMultiDrag && nodeExtent && !dragItem.extent && nodesBox) {
          const { positionAbsolute: positionAbsolute2 } = dragItem.internals;
          const x1 = positionAbsolute2.x - nodesBox.x + nodeExtent[0][0];
          const x22 = positionAbsolute2.x + dragItem.measured.width - nodesBox.x2 + nodeExtent[1][0];
          const y1 = positionAbsolute2.y - nodesBox.y + nodeExtent[0][1];
          const y22 = positionAbsolute2.y + dragItem.measured.height - nodesBox.y2 + nodeExtent[1][1];
          adjustedNodeExtent = [
            [x1, y1],
            [x22, y22]
          ];
        }
        const { position, positionAbsolute } = calculateNodePosition({
          nodeId: id2,
          nextPosition,
          nodeLookup,
          nodeExtent: adjustedNodeExtent ? adjustedNodeExtent : nodeExtent,
          nodeOrigin,
          onError: onError2
        });
        hasChange = hasChange || dragItem.position.x !== position.x || dragItem.position.y !== position.y;
        dragItem.position = position;
        dragItem.internals.positionAbsolute = positionAbsolute;
      }
      nodePositionsChanged = nodePositionsChanged || hasChange;
      if (!hasChange) {
        return;
      }
      updateNodePositions(dragItems, true);
      if (dragEvent && (onDrag || onNodeDrag || !nodeId && onSelectionDrag)) {
        const [currentNode, currentNodes] = getEventHandlerParams({
          nodeId,
          dragItems,
          nodeLookup
        });
        onDrag == null ? void 0 : onDrag(dragEvent, dragItems, currentNode, currentNodes);
        onNodeDrag == null ? void 0 : onNodeDrag(dragEvent, currentNode, currentNodes);
        if (!nodeId) {
          onSelectionDrag == null ? void 0 : onSelectionDrag(dragEvent, currentNodes);
        }
      }
    }
    function autoPan() {
      return __async(this, null, function* () {
        var _a3, _b2;
        if (!containerBounds) {
          return;
        }
        const { transform: transform2, panBy: panBy2, autoPanSpeed, autoPanOnNodeDrag } = getStoreItems();
        if (!autoPanOnNodeDrag) {
          autoPanStarted = false;
          cancelAnimationFrame(autoPanId);
          return;
        }
        const [xMovement, yMovement] = calcAutoPan(mousePosition, containerBounds, autoPanSpeed);
        if (xMovement !== 0 || yMovement !== 0) {
          lastPos.x = ((_a3 = lastPos.x) != null ? _a3 : 0) - xMovement / transform2[2];
          lastPos.y = ((_b2 = lastPos.y) != null ? _b2 : 0) - yMovement / transform2[2];
          if (yield panBy2({ x: xMovement, y: yMovement })) {
            updateNodes(lastPos);
          }
        }
        autoPanId = requestAnimationFrame(autoPan);
      });
    }
    function startDrag(event2) {
      var _a3;
      const { nodeLookup, multiSelectionActive, nodesDraggable, transform: transform2, snapGrid, snapToGrid, selectNodesOnDrag, onNodeDragStart, onSelectionDragStart, unselectNodesAndEdges } = getStoreItems();
      dragStarted = true;
      if ((!selectNodesOnDrag || !isSelectable) && !multiSelectionActive && nodeId) {
        if (!((_a3 = nodeLookup.get(nodeId)) == null ? void 0 : _a3.selected)) {
          unselectNodesAndEdges();
        }
      }
      if (isSelectable && selectNodesOnDrag && nodeId) {
        onNodeMouseDown == null ? void 0 : onNodeMouseDown(nodeId);
      }
      const pointerPos = getPointerPosition(event2.sourceEvent, { transform: transform2, snapGrid, snapToGrid, containerBounds });
      lastPos = pointerPos;
      dragItems = getDragItems(nodeLookup, nodesDraggable, pointerPos, nodeId);
      if (dragItems.size > 0 && (onDragStart || onNodeDragStart || !nodeId && onSelectionDragStart)) {
        const [currentNode, currentNodes] = getEventHandlerParams({
          nodeId,
          dragItems,
          nodeLookup
        });
        onDragStart == null ? void 0 : onDragStart(event2.sourceEvent, dragItems, currentNode, currentNodes);
        onNodeDragStart == null ? void 0 : onNodeDragStart(event2.sourceEvent, currentNode, currentNodes);
        if (!nodeId) {
          onSelectionDragStart == null ? void 0 : onSelectionDragStart(event2.sourceEvent, currentNodes);
        }
      }
    }
    const d3DragInstance = drag$1().clickDistance(nodeClickDistance).on("start", (event2) => {
      const { domNode: domNode2, nodeDragThreshold, transform: transform2, snapGrid, snapToGrid } = getStoreItems();
      containerBounds = (domNode2 == null ? void 0 : domNode2.getBoundingClientRect()) || null;
      abortDrag = false;
      nodePositionsChanged = false;
      dragEvent = event2.sourceEvent;
      if (nodeDragThreshold === 0) {
        startDrag(event2);
      }
      const pointerPos = getPointerPosition(event2.sourceEvent, { transform: transform2, snapGrid, snapToGrid, containerBounds });
      lastPos = pointerPos;
      mousePosition = getEventPosition(event2.sourceEvent, containerBounds);
    }).on("drag", (event2) => {
      var _a3, _b2;
      const { autoPanOnNodeDrag, transform: transform2, snapGrid, snapToGrid, nodeDragThreshold, nodeLookup } = getStoreItems();
      const pointerPos = getPointerPosition(event2.sourceEvent, { transform: transform2, snapGrid, snapToGrid, containerBounds });
      dragEvent = event2.sourceEvent;
      if (event2.sourceEvent.type === "touchmove" && event2.sourceEvent.touches.length > 1 || // if user deletes a node while dragging, we need to abort the drag to prevent errors
      nodeId && !nodeLookup.has(nodeId)) {
        abortDrag = true;
      }
      if (abortDrag) {
        return;
      }
      if (!autoPanStarted && autoPanOnNodeDrag && dragStarted) {
        autoPanStarted = true;
        autoPan();
      }
      if (!dragStarted) {
        const x2 = pointerPos.xSnapped - ((_a3 = lastPos.x) != null ? _a3 : 0);
        const y2 = pointerPos.ySnapped - ((_b2 = lastPos.y) != null ? _b2 : 0);
        const distance2 = Math.sqrt(x2 * x2 + y2 * y2);
        if (distance2 > nodeDragThreshold) {
          startDrag(event2);
        }
      }
      if ((lastPos.x !== pointerPos.xSnapped || lastPos.y !== pointerPos.ySnapped) && dragItems && dragStarted) {
        mousePosition = getEventPosition(event2.sourceEvent, containerBounds);
        updateNodes(pointerPos);
      }
    }).on("end", (event2) => {
      if (!dragStarted || abortDrag) {
        return;
      }
      autoPanStarted = false;
      dragStarted = false;
      cancelAnimationFrame(autoPanId);
      if (dragItems.size > 0) {
        const { nodeLookup, updateNodePositions, onNodeDragStop, onSelectionDragStop } = getStoreItems();
        if (nodePositionsChanged) {
          updateNodePositions(dragItems, false);
          nodePositionsChanged = false;
        }
        if (onDragStop || onNodeDragStop || !nodeId && onSelectionDragStop) {
          const [currentNode, currentNodes] = getEventHandlerParams({
            nodeId,
            dragItems,
            nodeLookup,
            dragging: false
          });
          onDragStop == null ? void 0 : onDragStop(event2.sourceEvent, dragItems, currentNode, currentNodes);
          onNodeDragStop == null ? void 0 : onNodeDragStop(event2.sourceEvent, currentNode, currentNodes);
          if (!nodeId) {
            onSelectionDragStop == null ? void 0 : onSelectionDragStop(event2.sourceEvent, currentNodes);
          }
        }
      }
    }).filter((event2) => {
      const target = event2.target;
      const isDraggable = !event2.button && (!noDragClassName || !hasSelector(target, `.${noDragClassName}`, domNode)) && (!handleSelector || hasSelector(target, handleSelector, domNode));
      return isDraggable;
    });
    d3Selection.call(d3DragInstance);
  }
  function destroy() {
    d3Selection == null ? void 0 : d3Selection.on(".drag", null);
  }
  return {
    update: update2,
    destroy
  };
}
function getNodesWithinDistance(position, nodeLookup, distance2) {
  const nodes = [];
  const rect = {
    x: position.x - distance2,
    y: position.y - distance2,
    width: distance2 * 2,
    height: distance2 * 2
  };
  for (const node of nodeLookup.values()) {
    if (getOverlappingArea(rect, nodeToRect(node)) > 0) {
      nodes.push(node);
    }
  }
  return nodes;
}
const ADDITIONAL_DISTANCE = 250;
function getClosestHandle(position, connectionRadius, nodeLookup, fromHandle) {
  var _a3, _b2, _c2, _d2, _e3;
  let closestHandles = [];
  let minDistance = Infinity;
  const closeNodes = getNodesWithinDistance(position, nodeLookup, connectionRadius + ADDITIONAL_DISTANCE);
  for (const node of closeNodes) {
    const allHandles = [...(_b2 = (_a3 = node.internals.handleBounds) == null ? void 0 : _a3.source) != null ? _b2 : [], ...(_d2 = (_c2 = node.internals.handleBounds) == null ? void 0 : _c2.target) != null ? _d2 : []];
    for (const handle of allHandles) {
      if (fromHandle.nodeId === handle.nodeId && fromHandle.type === handle.type && fromHandle.id === handle.id) {
        continue;
      }
      const { x: x2, y: y2 } = getHandlePosition(node, handle, handle.position, true);
      const distance2 = Math.sqrt(Math.pow(x2 - position.x, 2) + Math.pow(y2 - position.y, 2));
      if (distance2 > connectionRadius) {
        continue;
      }
      if (distance2 < minDistance) {
        closestHandles = [__spreadProps(__spreadValues({}, handle), { x: x2, y: y2 })];
        minDistance = distance2;
      } else if (distance2 === minDistance) {
        closestHandles.push(__spreadProps(__spreadValues({}, handle), { x: x2, y: y2 }));
      }
    }
  }
  if (!closestHandles.length) {
    return null;
  }
  if (closestHandles.length > 1) {
    const oppositeHandleType = fromHandle.type === "source" ? "target" : "source";
    return (_e3 = closestHandles.find((handle) => handle.type === oppositeHandleType)) != null ? _e3 : closestHandles[0];
  }
  return closestHandles[0];
}
function getHandle(nodeId, handleType, handleId, nodeLookup, connectionMode, withAbsolutePosition = false) {
  var _a3, _b2, _c2, _d2, _e3, _f2;
  const node = nodeLookup.get(nodeId);
  if (!node) {
    return null;
  }
  const handles = connectionMode === "strict" ? (_a3 = node.internals.handleBounds) == null ? void 0 : _a3[handleType] : [...(_c2 = (_b2 = node.internals.handleBounds) == null ? void 0 : _b2.source) != null ? _c2 : [], ...(_e3 = (_d2 = node.internals.handleBounds) == null ? void 0 : _d2.target) != null ? _e3 : []];
  const handle = (_f2 = handleId ? handles == null ? void 0 : handles.find((h2) => h2.id === handleId) : handles == null ? void 0 : handles[0]) != null ? _f2 : null;
  return handle && withAbsolutePosition ? __spreadValues(__spreadValues({}, handle), getHandlePosition(node, handle, handle.position, true)) : handle;
}
function getHandleType(edgeUpdaterType, handleDomNode) {
  if (edgeUpdaterType) {
    return edgeUpdaterType;
  } else if (handleDomNode == null ? void 0 : handleDomNode.classList.contains("target")) {
    return "target";
  } else if (handleDomNode == null ? void 0 : handleDomNode.classList.contains("source")) {
    return "source";
  }
  return null;
}
function isConnectionValid(isInsideConnectionRadius, isHandleValid) {
  let isValid = null;
  if (isHandleValid) {
    isValid = true;
  } else if (isInsideConnectionRadius && !isHandleValid) {
    isValid = false;
  }
  return isValid;
}
const alwaysValid = () => true;
function onPointerDown(event2, { connectionMode, connectionRadius, handleId, nodeId, edgeUpdaterType, isTarget, domNode, nodeLookup, lib, autoPanOnConnect, flowId, panBy: panBy2, cancelConnection, onConnectStart, onConnect, onConnectEnd, isValidConnection = alwaysValid, onReconnectEnd, updateConnection, getTransform, getFromHandle, autoPanSpeed, dragThreshold = 1, handleDomNode }) {
  const doc2 = getHostForElement(event2.target);
  let autoPanId = 0;
  let closestHandle;
  const { x: x2, y: y2 } = getEventPosition(event2);
  const handleType = getHandleType(edgeUpdaterType, handleDomNode);
  const containerBounds = domNode == null ? void 0 : domNode.getBoundingClientRect();
  let connectionStarted = false;
  if (!containerBounds || !handleType) {
    return;
  }
  const fromHandleInternal = getHandle(nodeId, handleType, handleId, nodeLookup, connectionMode);
  if (!fromHandleInternal) {
    return;
  }
  let position = getEventPosition(event2, containerBounds);
  let autoPanStarted = false;
  let connection = null;
  let isValid = false;
  let resultHandleDomNode = null;
  function autoPan() {
    if (!autoPanOnConnect || !containerBounds) {
      return;
    }
    const [x22, y22] = calcAutoPan(position, containerBounds, autoPanSpeed);
    panBy2({ x: x22, y: y22 });
    autoPanId = requestAnimationFrame(autoPan);
  }
  const fromHandle = __spreadProps(__spreadValues({}, fromHandleInternal), {
    nodeId,
    type: handleType,
    position: fromHandleInternal.position
  });
  const fromNodeInternal = nodeLookup.get(nodeId);
  const from = getHandlePosition(fromNodeInternal, fromHandle, Position.Left, true);
  let previousConnection = {
    inProgress: true,
    isValid: null,
    from,
    fromHandle,
    fromPosition: fromHandle.position,
    fromNode: fromNodeInternal,
    to: position,
    toHandle: null,
    toPosition: oppositePosition[fromHandle.position],
    toNode: null
  };
  function startConnection() {
    connectionStarted = true;
    updateConnection(previousConnection);
    onConnectStart == null ? void 0 : onConnectStart(event2, { nodeId, handleId, handleType });
  }
  if (dragThreshold === 0) {
    startConnection();
  }
  function onPointerMove(event22) {
    if (!connectionStarted) {
      const { x: evtX, y: evtY } = getEventPosition(event22);
      const dx = evtX - x2;
      const dy = evtY - y2;
      const nextConnectionStarted = dx * dx + dy * dy > dragThreshold * dragThreshold;
      if (!nextConnectionStarted) {
        return;
      }
      startConnection();
    }
    if (!getFromHandle() || !fromHandle) {
      onPointerUp(event22);
      return;
    }
    const transform2 = getTransform();
    position = getEventPosition(event22, containerBounds);
    closestHandle = getClosestHandle(pointToRendererPoint(position, transform2, false, [1, 1]), connectionRadius, nodeLookup, fromHandle);
    if (!autoPanStarted) {
      autoPan();
      autoPanStarted = true;
    }
    const result = isValidHandle(event22, {
      handle: closestHandle,
      connectionMode,
      fromNodeId: nodeId,
      fromHandleId: handleId,
      fromType: isTarget ? "target" : "source",
      isValidConnection,
      doc: doc2,
      lib,
      flowId,
      nodeLookup
    });
    resultHandleDomNode = result.handleDomNode;
    connection = result.connection;
    isValid = isConnectionValid(!!closestHandle, result.isValid);
    const newConnection = __spreadProps(__spreadValues({}, previousConnection), {
      isValid,
      to: result.toHandle && isValid ? rendererPointToPoint({ x: result.toHandle.x, y: result.toHandle.y }, transform2) : position,
      toHandle: result.toHandle,
      toPosition: isValid && result.toHandle ? result.toHandle.position : oppositePosition[fromHandle.position],
      toNode: result.toHandle ? nodeLookup.get(result.toHandle.nodeId) : null
    });
    if (isValid && closestHandle && previousConnection.toHandle && newConnection.toHandle && previousConnection.toHandle.type === newConnection.toHandle.type && previousConnection.toHandle.nodeId === newConnection.toHandle.nodeId && previousConnection.toHandle.id === newConnection.toHandle.id && previousConnection.to.x === newConnection.to.x && previousConnection.to.y === newConnection.to.y) {
      return;
    }
    updateConnection(newConnection);
    previousConnection = newConnection;
  }
  function onPointerUp(event22) {
    if (connectionStarted) {
      if ((closestHandle || resultHandleDomNode) && connection && isValid) {
        onConnect == null ? void 0 : onConnect(connection);
      }
      const _a3 = previousConnection, { inProgress } = _a3, connectionState = __objRest(_a3, ["inProgress"]);
      const finalConnectionState = __spreadProps(__spreadValues({}, connectionState), {
        toPosition: previousConnection.toHandle ? previousConnection.toPosition : null
      });
      onConnectEnd == null ? void 0 : onConnectEnd(event22, finalConnectionState);
      if (edgeUpdaterType) {
        onReconnectEnd == null ? void 0 : onReconnectEnd(event22, finalConnectionState);
      }
    }
    cancelConnection();
    cancelAnimationFrame(autoPanId);
    autoPanStarted = false;
    isValid = false;
    connection = null;
    resultHandleDomNode = null;
    doc2.removeEventListener("mousemove", onPointerMove);
    doc2.removeEventListener("mouseup", onPointerUp);
    doc2.removeEventListener("touchmove", onPointerMove);
    doc2.removeEventListener("touchend", onPointerUp);
  }
  doc2.addEventListener("mousemove", onPointerMove);
  doc2.addEventListener("mouseup", onPointerUp);
  doc2.addEventListener("touchmove", onPointerMove);
  doc2.addEventListener("touchend", onPointerUp);
}
function isValidHandle(event2, { handle, connectionMode, fromNodeId, fromHandleId, fromType, doc: doc2, lib, flowId, isValidConnection = alwaysValid, nodeLookup }) {
  const isTarget = fromType === "target";
  const handleDomNode = handle ? doc2.querySelector(`.${lib}-flow__handle[data-id="${flowId}-${handle == null ? void 0 : handle.nodeId}-${handle == null ? void 0 : handle.id}-${handle == null ? void 0 : handle.type}"]`) : null;
  const { x: x2, y: y2 } = getEventPosition(event2);
  const handleBelow = doc2.elementFromPoint(x2, y2);
  const handleToCheck = (handleBelow == null ? void 0 : handleBelow.classList.contains(`${lib}-flow__handle`)) ? handleBelow : handleDomNode;
  const result = {
    handleDomNode: handleToCheck,
    isValid: false,
    connection: null,
    toHandle: null
  };
  if (handleToCheck) {
    const handleType = getHandleType(void 0, handleToCheck);
    const handleNodeId = handleToCheck.getAttribute("data-nodeid");
    const handleId = handleToCheck.getAttribute("data-handleid");
    const connectable = handleToCheck.classList.contains("connectable");
    const connectableEnd = handleToCheck.classList.contains("connectableend");
    if (!handleNodeId || !handleType) {
      return result;
    }
    const connection = {
      source: isTarget ? handleNodeId : fromNodeId,
      sourceHandle: isTarget ? handleId : fromHandleId,
      target: isTarget ? fromNodeId : handleNodeId,
      targetHandle: isTarget ? fromHandleId : handleId
    };
    result.connection = connection;
    const isConnectable = connectable && connectableEnd;
    const isValid = isConnectable && (connectionMode === ConnectionMode.Strict ? isTarget && handleType === "source" || !isTarget && handleType === "target" : handleNodeId !== fromNodeId || handleId !== fromHandleId);
    result.isValid = isValid && isValidConnection(connection);
    result.toHandle = getHandle(handleNodeId, handleType, handleId, nodeLookup, connectionMode, true);
  }
  return result;
}
const XYHandle = {
  onPointerDown,
  isValid: isValidHandle
};
function XYMinimap({ domNode, panZoom, getTransform, getViewScale }) {
  const selection2 = select(domNode);
  function update2({ translateExtent, width, height, zoomStep = 1, pannable = true, zoomable = true, inversePan = false }) {
    const zoomHandler = (event2) => {
      if (event2.sourceEvent.type !== "wheel" || !panZoom) {
        return;
      }
      const transform2 = getTransform();
      const factor = event2.sourceEvent.ctrlKey && isMacOs() ? 10 : 1;
      const pinchDelta = -event2.sourceEvent.deltaY * (event2.sourceEvent.deltaMode === 1 ? 0.05 : event2.sourceEvent.deltaMode ? 1 : 2e-3) * zoomStep;
      const nextZoom = transform2[2] * Math.pow(2, pinchDelta * factor);
      panZoom.scaleTo(nextZoom);
    };
    let panStart = [0, 0];
    const panStartHandler = (event2) => {
      var _a3, _b2;
      if (event2.sourceEvent.type === "mousedown" || event2.sourceEvent.type === "touchstart") {
        panStart = [
          (_a3 = event2.sourceEvent.clientX) != null ? _a3 : event2.sourceEvent.touches[0].clientX,
          (_b2 = event2.sourceEvent.clientY) != null ? _b2 : event2.sourceEvent.touches[0].clientY
        ];
      }
    };
    const panHandler = (event2) => {
      var _a3, _b2;
      const transform2 = getTransform();
      if (event2.sourceEvent.type !== "mousemove" && event2.sourceEvent.type !== "touchmove" || !panZoom) {
        return;
      }
      const panCurrent = [
        (_a3 = event2.sourceEvent.clientX) != null ? _a3 : event2.sourceEvent.touches[0].clientX,
        (_b2 = event2.sourceEvent.clientY) != null ? _b2 : event2.sourceEvent.touches[0].clientY
      ];
      const panDelta = [panCurrent[0] - panStart[0], panCurrent[1] - panStart[1]];
      panStart = panCurrent;
      const moveScale = getViewScale() * Math.max(transform2[2], Math.log(transform2[2])) * (inversePan ? -1 : 1);
      const position = {
        x: transform2[0] - panDelta[0] * moveScale,
        y: transform2[1] - panDelta[1] * moveScale
      };
      const extent = [
        [0, 0],
        [width, height]
      ];
      panZoom.setViewportConstrained({
        x: position.x,
        y: position.y,
        zoom: transform2[2]
      }, extent, translateExtent);
    };
    const zoomAndPanHandler = zoom$1().on("start", panStartHandler).on("zoom", pannable ? panHandler : null).on("zoom.wheel", zoomable ? zoomHandler : null);
    selection2.call(zoomAndPanHandler, {});
  }
  function destroy() {
    selection2.on("zoom", null);
  }
  return {
    update: update2,
    destroy,
    pointer
  };
}
const viewChanged = (prevViewport, eventViewport) => prevViewport.x !== eventViewport.x || prevViewport.y !== eventViewport.y || prevViewport.zoom !== eventViewport.k;
const transformToViewport = (transform2) => ({
  x: transform2.x,
  y: transform2.y,
  zoom: transform2.k
});
const viewportToTransform = ({ x: x2, y: y2, zoom: zoom2 }) => identity.translate(x2, y2).scale(zoom2);
const isWrappedWithClass = (event2, className) => event2.target.closest(`.${className}`);
const isRightClickPan = (panOnDrag, usedButton) => usedButton === 2 && Array.isArray(panOnDrag) && panOnDrag.includes(2);
const defaultEase = (t2) => ((t2 *= 2) <= 1 ? t2 * t2 * t2 : (t2 -= 2) * t2 * t2 + 2) / 2;
const getD3Transition = (selection2, duration = 0, ease = defaultEase, onEnd = () => {
}) => {
  const hasDuration = typeof duration === "number" && duration > 0;
  if (!hasDuration) {
    onEnd();
  }
  return hasDuration ? selection2.transition().duration(duration).ease(ease).on("end", onEnd) : selection2;
};
const wheelDelta = (event2) => {
  const factor = event2.ctrlKey && isMacOs() ? 10 : 1;
  return -event2.deltaY * (event2.deltaMode === 1 ? 0.05 : event2.deltaMode ? 1 : 2e-3) * factor;
};
function createPanOnScrollHandler({ zoomPanValues, noWheelClassName, d3Selection, d3Zoom, panOnScrollMode, panOnScrollSpeed, zoomOnPinch, onPanZoomStart, onPanZoom, onPanZoomEnd }) {
  return (event2) => {
    if (isWrappedWithClass(event2, noWheelClassName)) {
      return false;
    }
    event2.preventDefault();
    event2.stopImmediatePropagation();
    const currentZoom = d3Selection.property("__zoom").k || 1;
    if (event2.ctrlKey && zoomOnPinch) {
      const point = pointer(event2);
      const pinchDelta = wheelDelta(event2);
      const zoom2 = currentZoom * Math.pow(2, pinchDelta);
      d3Zoom.scaleTo(d3Selection, zoom2, point, event2);
      return;
    }
    const deltaNormalize = event2.deltaMode === 1 ? 20 : 1;
    let deltaX = panOnScrollMode === PanOnScrollMode.Vertical ? 0 : event2.deltaX * deltaNormalize;
    let deltaY = panOnScrollMode === PanOnScrollMode.Horizontal ? 0 : event2.deltaY * deltaNormalize;
    if (!isMacOs() && event2.shiftKey && panOnScrollMode !== PanOnScrollMode.Vertical) {
      deltaX = event2.deltaY * deltaNormalize;
      deltaY = 0;
    }
    d3Zoom.translateBy(
      d3Selection,
      -(deltaX / currentZoom) * panOnScrollSpeed,
      -(deltaY / currentZoom) * panOnScrollSpeed,
      // @ts-ignore
      { internal: true }
    );
    const nextViewport = transformToViewport(d3Selection.property("__zoom"));
    clearTimeout(zoomPanValues.panScrollTimeout);
    if (!zoomPanValues.isPanScrolling) {
      zoomPanValues.isPanScrolling = true;
      onPanZoomStart == null ? void 0 : onPanZoomStart(event2, nextViewport);
    }
    if (zoomPanValues.isPanScrolling) {
      onPanZoom == null ? void 0 : onPanZoom(event2, nextViewport);
      zoomPanValues.panScrollTimeout = setTimeout(() => {
        onPanZoomEnd == null ? void 0 : onPanZoomEnd(event2, nextViewport);
        zoomPanValues.isPanScrolling = false;
      }, 150);
    }
  };
}
function createZoomOnScrollHandler({ noWheelClassName, preventScrolling, d3ZoomHandler }) {
  return function(event2, d) {
    const isWheel = event2.type === "wheel";
    const preventZoom = !preventScrolling && isWheel && !event2.ctrlKey;
    const hasNoWheelClass = isWrappedWithClass(event2, noWheelClassName);
    if (event2.ctrlKey && isWheel && hasNoWheelClass) {
      event2.preventDefault();
    }
    if (preventZoom || hasNoWheelClass) {
      return null;
    }
    event2.preventDefault();
    d3ZoomHandler.call(this, event2, d);
  };
}
function createPanZoomStartHandler({ zoomPanValues, onDraggingChange, onPanZoomStart }) {
  return (event2) => {
    var _a3, _b2, _c2;
    if ((_a3 = event2.sourceEvent) == null ? void 0 : _a3.internal) {
      return;
    }
    const viewport = transformToViewport(event2.transform);
    zoomPanValues.mouseButton = ((_b2 = event2.sourceEvent) == null ? void 0 : _b2.button) || 0;
    zoomPanValues.isZoomingOrPanning = true;
    zoomPanValues.prevViewport = viewport;
    if (((_c2 = event2.sourceEvent) == null ? void 0 : _c2.type) === "mousedown") {
      onDraggingChange(true);
    }
    if (onPanZoomStart) {
      onPanZoomStart == null ? void 0 : onPanZoomStart(event2.sourceEvent, viewport);
    }
  };
}
function createPanZoomHandler({ zoomPanValues, panOnDrag, onPaneContextMenu, onTransformChange, onPanZoom }) {
  return (event2) => {
    var _a3, _b2, _c2;
    zoomPanValues.usedRightMouseButton = !!(onPaneContextMenu && isRightClickPan(panOnDrag, (_a3 = zoomPanValues.mouseButton) != null ? _a3 : 0));
    if (!((_b2 = event2.sourceEvent) == null ? void 0 : _b2.sync)) {
      onTransformChange([event2.transform.x, event2.transform.y, event2.transform.k]);
    }
    if (onPanZoom && !((_c2 = event2.sourceEvent) == null ? void 0 : _c2.internal)) {
      onPanZoom == null ? void 0 : onPanZoom(event2.sourceEvent, transformToViewport(event2.transform));
    }
  };
}
function createPanZoomEndHandler({ zoomPanValues, panOnDrag, panOnScroll, onDraggingChange, onPanZoomEnd, onPaneContextMenu }) {
  return (event2) => {
    var _a3, _b2;
    if ((_a3 = event2.sourceEvent) == null ? void 0 : _a3.internal) {
      return;
    }
    zoomPanValues.isZoomingOrPanning = false;
    if (onPaneContextMenu && isRightClickPan(panOnDrag, (_b2 = zoomPanValues.mouseButton) != null ? _b2 : 0) && !zoomPanValues.usedRightMouseButton && event2.sourceEvent) {
      onPaneContextMenu(event2.sourceEvent);
    }
    zoomPanValues.usedRightMouseButton = false;
    onDraggingChange(false);
    if (onPanZoomEnd && viewChanged(zoomPanValues.prevViewport, event2.transform)) {
      const viewport = transformToViewport(event2.transform);
      zoomPanValues.prevViewport = viewport;
      clearTimeout(zoomPanValues.timerId);
      zoomPanValues.timerId = setTimeout(
        () => {
          onPanZoomEnd == null ? void 0 : onPanZoomEnd(event2.sourceEvent, viewport);
        },
        // we need a setTimeout for panOnScroll to supress multiple end events fired during scroll
        panOnScroll ? 150 : 0
      );
    }
  };
}
function createFilter({ zoomActivationKeyPressed, zoomOnScroll, zoomOnPinch, panOnDrag, panOnScroll, zoomOnDoubleClick, userSelectionActive, noWheelClassName, noPanClassName, lib }) {
  return (event2) => {
    var _a3;
    const zoomScroll = zoomActivationKeyPressed || zoomOnScroll;
    const pinchZoom = zoomOnPinch && event2.ctrlKey;
    if (event2.button === 1 && event2.type === "mousedown" && (isWrappedWithClass(event2, `${lib}-flow__node`) || isWrappedWithClass(event2, `${lib}-flow__edge`))) {
      return true;
    }
    if (!panOnDrag && !zoomScroll && !panOnScroll && !zoomOnDoubleClick && !zoomOnPinch) {
      return false;
    }
    if (userSelectionActive) {
      return false;
    }
    if (isWrappedWithClass(event2, noWheelClassName) && event2.type === "wheel") {
      return false;
    }
    if (isWrappedWithClass(event2, noPanClassName) && (event2.type !== "wheel" || panOnScroll && event2.type === "wheel" && !zoomActivationKeyPressed)) {
      return false;
    }
    if (!zoomOnPinch && event2.ctrlKey && event2.type === "wheel") {
      return false;
    }
    if (!zoomOnPinch && event2.type === "touchstart" && ((_a3 = event2.touches) == null ? void 0 : _a3.length) > 1) {
      event2.preventDefault();
      return false;
    }
    if (!zoomScroll && !panOnScroll && !pinchZoom && event2.type === "wheel") {
      return false;
    }
    if (!panOnDrag && (event2.type === "mousedown" || event2.type === "touchstart")) {
      return false;
    }
    if (Array.isArray(panOnDrag) && !panOnDrag.includes(event2.button) && event2.type === "mousedown") {
      return false;
    }
    const buttonAllowed = Array.isArray(panOnDrag) && panOnDrag.includes(event2.button) || !event2.button || event2.button <= 1;
    return (!event2.ctrlKey || event2.type === "wheel") && buttonAllowed;
  };
}
function XYPanZoom({ domNode, minZoom, maxZoom, paneClickDistance, translateExtent, viewport, onPanZoom, onPanZoomStart, onPanZoomEnd, onDraggingChange }) {
  const zoomPanValues = {
    isZoomingOrPanning: false,
    usedRightMouseButton: false,
    prevViewport: { x: 0, y: 0, zoom: 0 },
    mouseButton: 0,
    timerId: void 0,
    panScrollTimeout: void 0,
    isPanScrolling: false
  };
  const bbox = domNode.getBoundingClientRect();
  const d3ZoomInstance = zoom$1().clickDistance(!isNumeric(paneClickDistance) || paneClickDistance < 0 ? 0 : paneClickDistance).scaleExtent([minZoom, maxZoom]).translateExtent(translateExtent);
  const d3Selection = select(domNode).call(d3ZoomInstance);
  setViewportConstrained({
    x: viewport.x,
    y: viewport.y,
    zoom: clamp(viewport.zoom, minZoom, maxZoom)
  }, [
    [0, 0],
    [bbox.width, bbox.height]
  ], translateExtent);
  const d3ZoomHandler = d3Selection.on("wheel.zoom");
  const d3DblClickZoomHandler = d3Selection.on("dblclick.zoom");
  d3ZoomInstance.wheelDelta(wheelDelta);
  function setTransform(transform2, options2) {
    if (d3Selection) {
      return new Promise((resolve) => {
        d3ZoomInstance == null ? void 0 : d3ZoomInstance.interpolate((options2 == null ? void 0 : options2.interpolate) === "linear" ? interpolate$1 : interpolateZoom).transform(getD3Transition(d3Selection, options2 == null ? void 0 : options2.duration, options2 == null ? void 0 : options2.ease, () => resolve(true)), transform2);
      });
    }
    return Promise.resolve(false);
  }
  function update2({ noWheelClassName, noPanClassName, onPaneContextMenu, userSelectionActive, panOnScroll, panOnDrag, panOnScrollMode, panOnScrollSpeed, preventScrolling, zoomOnPinch, zoomOnScroll, zoomOnDoubleClick, zoomActivationKeyPressed, lib, onTransformChange }) {
    if (userSelectionActive && !zoomPanValues.isZoomingOrPanning) {
      destroy();
    }
    const isPanOnScroll = panOnScroll && !zoomActivationKeyPressed && !userSelectionActive;
    const wheelHandler = isPanOnScroll ? createPanOnScrollHandler({
      zoomPanValues,
      noWheelClassName,
      d3Selection,
      d3Zoom: d3ZoomInstance,
      panOnScrollMode,
      panOnScrollSpeed,
      zoomOnPinch,
      onPanZoomStart,
      onPanZoom,
      onPanZoomEnd
    }) : createZoomOnScrollHandler({
      noWheelClassName,
      preventScrolling,
      d3ZoomHandler
    });
    d3Selection.on("wheel.zoom", wheelHandler, { passive: false });
    if (!userSelectionActive) {
      const startHandler = createPanZoomStartHandler({
        zoomPanValues,
        onDraggingChange,
        onPanZoomStart
      });
      d3ZoomInstance.on("start", startHandler);
      const panZoomHandler = createPanZoomHandler({
        zoomPanValues,
        panOnDrag,
        onPaneContextMenu: !!onPaneContextMenu,
        onPanZoom,
        onTransformChange
      });
      d3ZoomInstance.on("zoom", panZoomHandler);
      const panZoomEndHandler = createPanZoomEndHandler({
        zoomPanValues,
        panOnDrag,
        panOnScroll,
        onPaneContextMenu,
        onPanZoomEnd,
        onDraggingChange
      });
      d3ZoomInstance.on("end", panZoomEndHandler);
    }
    const filter2 = createFilter({
      zoomActivationKeyPressed,
      panOnDrag,
      zoomOnScroll,
      panOnScroll,
      zoomOnDoubleClick,
      zoomOnPinch,
      userSelectionActive,
      noPanClassName,
      noWheelClassName,
      lib
    });
    d3ZoomInstance.filter(filter2);
    if (zoomOnDoubleClick) {
      d3Selection.on("dblclick.zoom", d3DblClickZoomHandler);
    } else {
      d3Selection.on("dblclick.zoom", null);
    }
  }
  function destroy() {
    d3ZoomInstance.on("zoom", null);
  }
  function setViewportConstrained(viewport2, extent, translateExtent2) {
    return __async(this, null, function* () {
      const nextTransform = viewportToTransform(viewport2);
      const contrainedTransform = d3ZoomInstance == null ? void 0 : d3ZoomInstance.constrain()(nextTransform, extent, translateExtent2);
      if (contrainedTransform) {
        yield setTransform(contrainedTransform);
      }
      return new Promise((resolve) => resolve(contrainedTransform));
    });
  }
  function setViewport(viewport2, options2) {
    return __async(this, null, function* () {
      const nextTransform = viewportToTransform(viewport2);
      yield setTransform(nextTransform, options2);
      return new Promise((resolve) => resolve(nextTransform));
    });
  }
  function syncViewport(viewport2) {
    if (d3Selection) {
      const nextTransform = viewportToTransform(viewport2);
      const currentTransform = d3Selection.property("__zoom");
      if (currentTransform.k !== viewport2.zoom || currentTransform.x !== viewport2.x || currentTransform.y !== viewport2.y) {
        d3ZoomInstance == null ? void 0 : d3ZoomInstance.transform(d3Selection, nextTransform, null, { sync: true });
      }
    }
  }
  function getViewport() {
    const transform$1 = d3Selection ? transform(d3Selection.node()) : { x: 0, y: 0, k: 1 };
    return { x: transform$1.x, y: transform$1.y, zoom: transform$1.k };
  }
  function scaleTo(zoom2, options2) {
    if (d3Selection) {
      return new Promise((resolve) => {
        d3ZoomInstance == null ? void 0 : d3ZoomInstance.interpolate((options2 == null ? void 0 : options2.interpolate) === "linear" ? interpolate$1 : interpolateZoom).scaleTo(getD3Transition(d3Selection, options2 == null ? void 0 : options2.duration, options2 == null ? void 0 : options2.ease, () => resolve(true)), zoom2);
      });
    }
    return Promise.resolve(false);
  }
  function scaleBy(factor, options2) {
    if (d3Selection) {
      return new Promise((resolve) => {
        d3ZoomInstance == null ? void 0 : d3ZoomInstance.interpolate((options2 == null ? void 0 : options2.interpolate) === "linear" ? interpolate$1 : interpolateZoom).scaleBy(getD3Transition(d3Selection, options2 == null ? void 0 : options2.duration, options2 == null ? void 0 : options2.ease, () => resolve(true)), factor);
      });
    }
    return Promise.resolve(false);
  }
  function setScaleExtent(scaleExtent) {
    d3ZoomInstance == null ? void 0 : d3ZoomInstance.scaleExtent(scaleExtent);
  }
  function setTranslateExtent(translateExtent2) {
    d3ZoomInstance == null ? void 0 : d3ZoomInstance.translateExtent(translateExtent2);
  }
  function setClickDistance(distance2) {
    const validDistance = !isNumeric(distance2) || distance2 < 0 ? 0 : distance2;
    d3ZoomInstance == null ? void 0 : d3ZoomInstance.clickDistance(validDistance);
  }
  return {
    update: update2,
    destroy,
    setViewport,
    setViewportConstrained,
    getViewport,
    scaleTo,
    scaleBy,
    setScaleExtent,
    setTranslateExtent,
    syncViewport,
    setClickDistance
  };
}
var ResizeControlVariant;
(function(ResizeControlVariant2) {
  ResizeControlVariant2["Line"] = "line";
  ResizeControlVariant2["Handle"] = "handle";
})(ResizeControlVariant || (ResizeControlVariant = {}));
var root$1f = /* @__PURE__ */ from_html(`<div><!></div>`);
function Handle($$anchor, $$props) {
  push($$props, true);
  let handleId = prop($$props, "id", 3, null), type = prop($$props, "type", 3, "source"), position = prop($$props, "position", 19, () => Position.Top), isConnectableStart = prop($$props, "isConnectableStart", 3, true), isConnectableEnd = prop($$props, "isConnectableEnd", 3, true), rest = /* @__PURE__ */ rest_props($$props, [
    "$$slots",
    "$$events",
    "$$legacy",
    "id",
    "type",
    "position",
    "style",
    "class",
    "isConnectable",
    "isConnectableStart",
    "isConnectableEnd",
    "isValidConnection",
    "onconnect",
    "ondisconnect",
    "children"
  ]);
  const nodeId = getContext("svelteflow__node_id");
  const isConnectableContext = getContext("svelteflow__node_connectable");
  let isTarget = /* @__PURE__ */ user_derived(() => type() === "target");
  let isConnectable = /* @__PURE__ */ user_derived(() => $$props.isConnectable !== void 0 ? $$props.isConnectable : isConnectableContext.value);
  let store = useStore();
  let ariaLabelConfig = /* @__PURE__ */ user_derived(() => store.ariaLabelConfig);
  let prevConnections = null;
  user_pre_effect(() => {
    if ($$props.onconnect || $$props.ondisconnect) {
      store.edges;
      let connections = store.connectionLookup.get(`${nodeId}-${type()}${handleId() ? `-${handleId()}` : ""}`);
      if (prevConnections && !areConnectionMapsEqual(connections, prevConnections)) {
        const _connections = connections != null ? connections : /* @__PURE__ */ new Map();
        handleConnectionChange(prevConnections, _connections, $$props.ondisconnect);
        handleConnectionChange(_connections, prevConnections, $$props.onconnect);
      }
      prevConnections = new Map(connections);
    }
  });
  let $$d = /* @__PURE__ */ user_derived(() => {
    if (!store.connection.inProgress) {
      return [false, false, false, false, null];
    }
    const { fromHandle, toHandle, isValid } = store.connection;
    const connectingFrom2 = fromHandle && fromHandle.nodeId === nodeId && fromHandle.type === type() && fromHandle.id === handleId();
    const connectingTo2 = toHandle && toHandle.nodeId === nodeId && toHandle.type === type() && toHandle.id === handleId();
    const isPossibleTargetHandle2 = store.connectionMode === ConnectionMode.Strict ? (fromHandle == null ? void 0 : fromHandle.type) !== type() : nodeId !== (fromHandle == null ? void 0 : fromHandle.nodeId) || handleId() !== (fromHandle == null ? void 0 : fromHandle.id);
    const valid2 = connectingTo2 && isValid;
    return [
      true,
      connectingFrom2,
      connectingTo2,
      isPossibleTargetHandle2,
      valid2
    ];
  }), $$array = /* @__PURE__ */ user_derived(() => to_array(get$3($$d), 5)), connectionInProgress = /* @__PURE__ */ user_derived(() => get$3($$array)[0]), connectingFrom = /* @__PURE__ */ user_derived(() => get$3($$array)[1]), connectingTo = /* @__PURE__ */ user_derived(() => get$3($$array)[2]), isPossibleTargetHandle = /* @__PURE__ */ user_derived(() => get$3($$array)[3]), valid = /* @__PURE__ */ user_derived(() => get$3($$array)[4]);
  function onConnectExtended(connection) {
    var _a3;
    const edge = store.onbeforeconnect ? store.onbeforeconnect(connection) : connection;
    if (!edge) {
      return;
    }
    store.addEdge(edge);
    (_a3 = store.onconnect) == null ? void 0 : _a3.call(store, connection);
  }
  function onpointerdown(event2) {
    var _a3;
    const isMouseTriggered = isMouseEvent(event2);
    if (event2.currentTarget && (isMouseTriggered && event2.button === 0 || !isMouseTriggered)) {
      XYHandle.onPointerDown(event2, {
        handleId: handleId(),
        nodeId,
        isTarget: get$3(isTarget),
        connectionRadius: store.connectionRadius,
        domNode: store.domNode,
        nodeLookup: store.nodeLookup,
        connectionMode: store.connectionMode,
        lib: "svelte",
        autoPanOnConnect: store.autoPanOnConnect,
        flowId: store.flowId,
        isValidConnection: (_a3 = $$props.isValidConnection) != null ? _a3 : store.isValidConnection,
        updateConnection: store.updateConnection,
        cancelConnection: store.cancelConnection,
        panBy: store.panBy,
        onConnect: onConnectExtended,
        onConnectStart: (event3, startParams) => {
          var _a4;
          (_a4 = store.onconnectstart) == null ? void 0 : _a4.call(store, event3, {
            nodeId: startParams.nodeId,
            handleId: startParams.handleId,
            handleType: startParams.handleType
          });
        },
        onConnectEnd: (event3, connectionState) => {
          var _a4;
          (_a4 = store.onconnectend) == null ? void 0 : _a4.call(store, event3, connectionState);
        },
        getTransform: () => [store.viewport.x, store.viewport.y, store.viewport.zoom],
        getFromHandle: () => store.connection.fromHandle,
        dragThreshold: store.connectionDragThreshold,
        handleDomNode: event2.currentTarget
      });
    }
  }
  function onclick2(event2) {
    var _a3, _b2, _c2, _d2;
    if (!nodeId || !store.clickConnectStartHandle && !isConnectableStart()) {
      return;
    }
    if (!store.clickConnectStartHandle) {
      (_a3 = store.onclickconnectstart) == null ? void 0 : _a3.call(store, event2, { nodeId, handleId: handleId(), handleType: type() });
      store.clickConnectStartHandle = { nodeId, type: type(), id: handleId() };
      return;
    }
    const doc2 = getHostForElement(event2.target);
    const isValidConnectionHandler = (_b2 = $$props.isValidConnection) != null ? _b2 : store.isValidConnection;
    const { connectionMode, clickConnectStartHandle, flowId, nodeLookup } = store;
    const { connection, isValid } = XYHandle.isValid(event2, {
      handle: { nodeId, id: handleId(), type: type() },
      connectionMode,
      fromNodeId: clickConnectStartHandle.nodeId,
      fromHandleId: (_c2 = clickConnectStartHandle.id) != null ? _c2 : null,
      fromType: clickConnectStartHandle.type,
      isValidConnection: isValidConnectionHandler,
      flowId,
      doc: doc2,
      lib: "svelte",
      nodeLookup
    });
    if (isValid && connection) {
      onConnectExtended(connection);
    }
    const connectionClone = structuredClone(snapshot(store.connection));
    delete connectionClone.inProgress;
    connectionClone.toPosition = connectionClone.toHandle ? connectionClone.toHandle.position : null;
    (_d2 = store.onclickconnectend) == null ? void 0 : _d2.call(store, event2, connectionClone);
    store.clickConnectStartHandle = null;
  }
  var div = root$1f();
  var event_handler = () => {
  };
  attribute_effect(
    div,
    ($0) => {
      var _a3, _b2, _c2, _d2;
      return __spreadProps(__spreadValues({
        "data-handleid": handleId(),
        "data-nodeid": nodeId,
        "data-handlepos": position(),
        "data-id": `${(_a3 = store.flowId) != null ? _a3 : ""}-${nodeId != null ? nodeId : ""}-${(_c2 = (_b2 = handleId()) != null ? _b2 : "null") != null ? _c2 : ""}-${(_d2 = type()) != null ? _d2 : ""}`,
        class: [
          "svelte-flow__handle",
          `svelte-flow__handle-${position()}`,
          store.noDragClass,
          store.noPanClass,
          position(),
          $$props.class
        ],
        onmousedown: onpointerdown,
        ontouchstart: onpointerdown,
        onclick: store.clickConnect ? onclick2 : void 0,
        onkeypress: event_handler,
        style: $$props.style,
        role: "button",
        "aria-label": get$3(ariaLabelConfig)[`handle.ariaLabel`],
        tabindex: "-1"
      }, rest), {
        [CLASS]: $0
      });
    },
    [
      () => ({
        valid: get$3(valid),
        connectingto: get$3(connectingTo),
        connectingfrom: get$3(connectingFrom),
        source: !get$3(isTarget),
        target: get$3(isTarget),
        connectablestart: isConnectableStart(),
        connectableend: isConnectableEnd(),
        connectable: get$3(isConnectable),
        connectionindicator: get$3(isConnectable) && (!get$3(connectionInProgress) || get$3(isPossibleTargetHandle)) && (get$3(connectionInProgress) || store.clickConnectStartHandle ? isConnectableEnd() : isConnectableStart())
      })
    ]
  );
  var node = child(div);
  snippet(node, () => {
    var _a3;
    return (_a3 = $$props.children) != null ? _a3 : noop$1;
  });
  append($$anchor, div);
  pop();
}
var root$1e = /* @__PURE__ */ from_html(`<!> <!>`, 1);
function DefaultNode($$anchor, $$props) {
  push($$props, true);
  let targetPosition = prop($$props, "targetPosition", 19, () => Position.Top), sourcePosition = prop($$props, "sourcePosition", 19, () => Position.Bottom);
  var fragment = root$1e();
  var node = first_child(fragment);
  Handle(node, {
    type: "target",
    get position() {
      return targetPosition();
    }
  });
  var text2 = sibling(node);
  var node_1 = sibling(text2);
  Handle(node_1, {
    type: "source",
    get position() {
      return sourcePosition();
    }
  });
  template_effect(() => {
    var _a3, _b2;
    return set_text(text2, ` ${(_b2 = (_a3 = $$props.data) == null ? void 0 : _a3.label) != null ? _b2 : ""} `);
  });
  append($$anchor, fragment);
  pop();
}
var root$1d = /* @__PURE__ */ from_html(` <!>`, 1);
function InputNode($$anchor, $$props) {
  push($$props, true);
  let data = prop($$props, "data", 19, () => ({ label: "Node" })), sourcePosition = prop($$props, "sourcePosition", 19, () => Position.Bottom);
  var fragment = root$1d();
  var text2 = first_child(fragment);
  var node = sibling(text2);
  Handle(node, {
    type: "source",
    get position() {
      return sourcePosition();
    }
  });
  template_effect(() => {
    var _a3, _b2;
    return set_text(text2, `${(_b2 = (_a3 = data()) == null ? void 0 : _a3.label) != null ? _b2 : ""} `);
  });
  append($$anchor, fragment);
  pop();
}
var root$1c = /* @__PURE__ */ from_html(` <!>`, 1);
function OutputNode($$anchor, $$props) {
  push($$props, true);
  let data = prop($$props, "data", 19, () => ({ label: "Node" })), targetPosition = prop($$props, "targetPosition", 19, () => Position.Top);
  var fragment = root$1c();
  var text2 = first_child(fragment);
  var node = sibling(text2);
  Handle(node, {
    type: "target",
    get position() {
      return targetPosition();
    }
  });
  template_effect(() => {
    var _a3, _b2;
    return set_text(text2, `${(_b2 = (_a3 = data()) == null ? void 0 : _a3.label) != null ? _b2 : ""} `);
  });
  append($$anchor, fragment);
  pop();
}
function GroupNode($$anchor, $$props) {
}
function tryToMount(node, domNode, target) {
  if (!target || !domNode) {
    return;
  }
  const targetEl = target === "root" ? domNode : domNode.querySelector(`.svelte-flow__${target}`);
  if (targetEl) {
    targetEl.appendChild(node);
  }
}
function portal(node, target) {
  const $$d = /* @__PURE__ */ user_derived(useStore), domNode = /* @__PURE__ */ user_derived(() => get$3($$d).domNode);
  let destroyEffect;
  if (get$3(domNode)) {
    tryToMount(node, get$3(domNode), target);
  } else {
    destroyEffect = effect_root(() => {
      user_effect(() => {
        tryToMount(node, get$3(domNode), target);
        destroyEffect == null ? void 0 : destroyEffect();
      });
    });
  }
  return {
    update(target2) {
      return __async(this, null, function* () {
        tryToMount(node, get$3(domNode), target2);
      });
    },
    destroy() {
      if (node.parentNode) {
        node.parentNode.removeChild(node);
      }
      destroyEffect == null ? void 0 : destroyEffect();
    }
  };
}
function hideOnSSR() {
  let hide = /* @__PURE__ */ state(typeof window === "undefined");
  if (get$3(hide)) {
    const destroyEffect = effect_root(() => {
      user_effect(() => {
        set$2(hide, false);
        destroyEffect == null ? void 0 : destroyEffect();
      });
    });
  }
  return {
    get value() {
      return get$3(hide);
    }
  };
}
const isNode = (element) => isNodeBase(element);
const isEdge = (element) => isEdgeBase(element);
function toPxString(value) {
  return value === void 0 ? void 0 : `${value}px`;
}
const arrowKeyDiffs = {
  ArrowUp: { x: 0, y: -1 },
  ArrowDown: { x: 0, y: 1 },
  ArrowLeft: { x: -1, y: 0 },
  ArrowRight: { x: 1, y: 0 }
};
var root$1b = /* @__PURE__ */ from_html(`<div><!></div>`);
function EdgeLabel($$anchor, $$props) {
  push($$props, true);
  let x2 = prop($$props, "x", 3, 0), y2 = prop($$props, "y", 3, 0), selectEdgeOnClick = prop($$props, "selectEdgeOnClick", 3, false), transparent = prop($$props, "transparent", 3, false), rest = /* @__PURE__ */ rest_props($$props, [
    "$$slots",
    "$$events",
    "$$legacy",
    "x",
    "y",
    "width",
    "height",
    "selectEdgeOnClick",
    "transparent",
    "class",
    "children"
  ]);
  const store = useStore();
  const id2 = getContext("svelteflow__edge_id");
  let z2 = /* @__PURE__ */ user_derived(() => {
    var _a3;
    return (_a3 = store.visible.edges.get(id2)) == null ? void 0 : _a3.zIndex;
  });
  var div = root$1b();
  var event_handler = () => {
    if (selectEdgeOnClick() && id2) store.handleEdgeSelection(id2);
  };
  attribute_effect(
    div,
    ($0) => __spreadProps(__spreadValues({
      class: [
        "svelte-flow__edge-label",
        { transparent: transparent() },
        $$props.class
      ],
      tabindex: "-1",
      onclick: event_handler
    }, rest), {
      [STYLE]: $0
    }),
    [
      () => {
        var _a3, _b2;
        return {
          display: hideOnSSR().value ? "none" : void 0,
          cursor: selectEdgeOnClick() ? "pointer" : void 0,
          transform: `translate(-50%, -50%) translate(${(_a3 = x2()) != null ? _a3 : ""}px,${(_b2 = y2()) != null ? _b2 : ""}px)`,
          "pointer-events": "all",
          width: toPxString($$props.width),
          height: toPxString($$props.height),
          "z-index": get$3(z2)
        };
      }
    ],
    void 0,
    "svelte-1wg91mu"
  );
  var node = child(div);
  snippet(node, () => {
    var _a3;
    return (_a3 = $$props.children) != null ? _a3 : noop$1;
  });
  action(div, ($$node, $$action_arg) => portal == null ? void 0 : portal($$node, $$action_arg), () => "edge-labels");
  append($$anchor, div);
  pop();
}
var root_1$K = /* @__PURE__ */ from_svg(`<path></path>`);
var root$1a = /* @__PURE__ */ from_svg(`<path fill="none"></path><!><!>`, 1);
function BaseEdge($$anchor, $$props) {
  let interactionWidth = prop($$props, "interactionWidth", 3, 20), rest = /* @__PURE__ */ rest_props($$props, [
    "$$slots",
    "$$events",
    "$$legacy",
    "id",
    "path",
    "label",
    "labelX",
    "labelY",
    "labelStyle",
    "markerStart",
    "markerEnd",
    "style",
    "interactionWidth",
    "class"
  ]);
  var fragment = root$1a();
  var path_1 = first_child(fragment);
  var node = sibling(path_1);
  {
    var consequent = ($$anchor2) => {
      var path_2 = root_1$K();
      attribute_effect(path_2, () => __spreadValues({
        d: $$props.path,
        "stroke-opacity": 0,
        "stroke-width": interactionWidth(),
        fill: "none",
        class: "svelte-flow__edge-interaction"
      }, rest));
      append($$anchor2, path_2);
    };
    if_block(node, ($$render) => {
      if (interactionWidth() > 0) $$render(consequent);
    });
  }
  var node_1 = sibling(node);
  {
    var consequent_1 = ($$anchor2) => {
      EdgeLabel($$anchor2, {
        get x() {
          return $$props.labelX;
        },
        get y() {
          return $$props.labelY;
        },
        get style() {
          return $$props.labelStyle;
        },
        selectEdgeOnClick: true,
        children: ($$anchor3, $$slotProps) => {
          var text$1 = text();
          template_effect(() => set_text(text$1, $$props.label));
          append($$anchor3, text$1);
        },
        $$slots: { default: true }
      });
    };
    if_block(node_1, ($$render) => {
      if ($$props.label) $$render(consequent_1);
    });
  }
  template_effect(() => {
    set_attribute(path_1, "id", $$props.id);
    set_attribute(path_1, "d", $$props.path);
    set_class(path_1, 0, clsx(["svelte-flow__edge-path", $$props.class]));
    set_attribute(path_1, "marker-start", $$props.markerStart);
    set_attribute(path_1, "marker-end", $$props.markerEnd);
    set_style(path_1, $$props.style);
  });
  append($$anchor, fragment);
}
function BezierEdge($$anchor, $$props) {
  push($$props, true);
  let $$d = /* @__PURE__ */ user_derived(() => {
    var _a3;
    return getBezierPath({
      sourceX: $$props.sourceX,
      sourceY: $$props.sourceY,
      targetX: $$props.targetX,
      targetY: $$props.targetY,
      sourcePosition: $$props.sourcePosition,
      targetPosition: $$props.targetPosition,
      curvature: (_a3 = $$props.pathOptions) == null ? void 0 : _a3.curvature
    });
  }), $$array = /* @__PURE__ */ user_derived(() => to_array(get$3($$d), 3)), path = /* @__PURE__ */ user_derived(() => get$3($$array)[0]), labelX = /* @__PURE__ */ user_derived(() => get$3($$array)[1]), labelY = /* @__PURE__ */ user_derived(() => get$3($$array)[2]);
  BaseEdge($$anchor, {
    get id() {
      return $$props.id;
    },
    get path() {
      return get$3(path);
    },
    get labelX() {
      return get$3(labelX);
    },
    get labelY() {
      return get$3(labelY);
    },
    get label() {
      return $$props.label;
    },
    get labelStyle() {
      return $$props.labelStyle;
    },
    get markerStart() {
      return $$props.markerStart;
    },
    get markerEnd() {
      return $$props.markerEnd;
    },
    get interactionWidth() {
      return $$props.interactionWidth;
    },
    get style() {
      return $$props.style;
    }
  });
  pop();
}
function SmoothStepEdgeInternal($$anchor, $$props) {
  push($$props, true);
  let $$d = /* @__PURE__ */ user_derived(() => getSmoothStepPath({
    sourceX: $$props.sourceX,
    sourceY: $$props.sourceY,
    targetX: $$props.targetX,
    targetY: $$props.targetY,
    sourcePosition: $$props.sourcePosition,
    targetPosition: $$props.targetPosition
  })), $$array = /* @__PURE__ */ user_derived(() => to_array(get$3($$d), 3)), path = /* @__PURE__ */ user_derived(() => get$3($$array)[0]), labelX = /* @__PURE__ */ user_derived(() => get$3($$array)[1]), labelY = /* @__PURE__ */ user_derived(() => get$3($$array)[2]);
  BaseEdge($$anchor, {
    get path() {
      return get$3(path);
    },
    get labelX() {
      return get$3(labelX);
    },
    get labelY() {
      return get$3(labelY);
    },
    get label() {
      return $$props.label;
    },
    get labelStyle() {
      return $$props.labelStyle;
    },
    get markerStart() {
      return $$props.markerStart;
    },
    get markerEnd() {
      return $$props.markerEnd;
    },
    get interactionWidth() {
      return $$props.interactionWidth;
    },
    get style() {
      return $$props.style;
    }
  });
  pop();
}
function StraightEdgeInternal($$anchor, $$props) {
  push($$props, true);
  let $$d = /* @__PURE__ */ user_derived(() => getStraightPath({
    sourceX: $$props.sourceX,
    sourceY: $$props.sourceY,
    targetX: $$props.targetX,
    targetY: $$props.targetY
  })), $$array = /* @__PURE__ */ user_derived(() => to_array(get$3($$d), 3)), path = /* @__PURE__ */ user_derived(() => get$3($$array)[0]), labelX = /* @__PURE__ */ user_derived(() => get$3($$array)[1]), labelY = /* @__PURE__ */ user_derived(() => get$3($$array)[2]);
  BaseEdge($$anchor, {
    get path() {
      return get$3(path);
    },
    get labelX() {
      return get$3(labelX);
    },
    get labelY() {
      return get$3(labelY);
    },
    get label() {
      return $$props.label;
    },
    get labelStyle() {
      return $$props.labelStyle;
    },
    get markerStart() {
      return $$props.markerStart;
    },
    get markerEnd() {
      return $$props.markerEnd;
    },
    get interactionWidth() {
      return $$props.interactionWidth;
    },
    get style() {
      return $$props.style;
    }
  });
  pop();
}
function StepEdgeInternal($$anchor, $$props) {
  push($$props, true);
  let $$d = /* @__PURE__ */ user_derived(() => getSmoothStepPath({
    sourceX: $$props.sourceX,
    sourceY: $$props.sourceY,
    targetX: $$props.targetX,
    targetY: $$props.targetY,
    sourcePosition: $$props.sourcePosition,
    targetPosition: $$props.targetPosition,
    borderRadius: 0
  })), $$array = /* @__PURE__ */ user_derived(() => to_array(get$3($$d), 3)), path = /* @__PURE__ */ user_derived(() => get$3($$array)[0]), labelX = /* @__PURE__ */ user_derived(() => get$3($$array)[1]), labelY = /* @__PURE__ */ user_derived(() => get$3($$array)[2]);
  BaseEdge($$anchor, {
    get path() {
      return get$3(path);
    },
    get labelX() {
      return get$3(labelX);
    },
    get labelY() {
      return get$3(labelY);
    },
    get label() {
      return $$props.label;
    },
    get labelStyle() {
      return $$props.labelStyle;
    },
    get markerStart() {
      return $$props.markerStart;
    },
    get markerEnd() {
      return $$props.markerEnd;
    },
    get interactionWidth() {
      return $$props.interactionWidth;
    },
    get style() {
      return $$props.style;
    }
  });
  pop();
}
var read_methods = ["forEach", "isDisjointFrom", "isSubsetOf", "isSupersetOf"];
var set_like_methods = ["difference", "intersection", "symmetricDifference", "union"];
var inited = false;
const _SvelteSet = class _SvelteSet extends Set {
  /**
   * @param {Iterable<T> | null | undefined} [value]
   */
  constructor(value) {
    super();
    __privateAdd(this, _SvelteSet_instances);
    /** @type {Map<T, Source<boolean>>} */
    __privateAdd(this, _sources, /* @__PURE__ */ new Map());
    __privateAdd(this, _version, /* @__PURE__ */ state(0));
    __privateAdd(this, _size, /* @__PURE__ */ state(0));
    __privateAdd(this, _update_version, update_version || -1);
    if (DEV) {
      value = new Set(value);
      tag(__privateGet(this, _version), "SvelteSet version");
      tag(__privateGet(this, _size), "SvelteSet.size");
    }
    if (value) {
      for (var element of value) {
        super.add(element);
      }
      __privateGet(this, _size).v = super.size;
    }
    if (!inited) __privateMethod(this, _SvelteSet_instances, init_fn).call(this);
  }
  /** @param {T} value */
  has(value) {
    var has = super.has(value);
    var sources = __privateGet(this, _sources);
    var s = sources.get(value);
    if (s === void 0) {
      if (!has) {
        get$3(__privateGet(this, _version));
        return false;
      }
      s = __privateMethod(this, _SvelteSet_instances, source_fn).call(this, true);
      if (DEV) {
        tag(s, `SvelteSet has(${label(value)})`);
      }
      sources.set(value, s);
    }
    get$3(s);
    return has;
  }
  /** @param {T} value */
  add(value) {
    if (!super.has(value)) {
      super.add(value);
      set$2(__privateGet(this, _size), super.size);
      increment(__privateGet(this, _version));
    }
    return this;
  }
  /** @param {T} value */
  delete(value) {
    var deleted = super.delete(value);
    var sources = __privateGet(this, _sources);
    var s = sources.get(value);
    if (s !== void 0) {
      sources.delete(value);
      set$2(s, false);
    }
    if (deleted) {
      set$2(__privateGet(this, _size), super.size);
      increment(__privateGet(this, _version));
    }
    return deleted;
  }
  clear() {
    if (super.size === 0) {
      return;
    }
    super.clear();
    var sources = __privateGet(this, _sources);
    for (var s of sources.values()) {
      set$2(s, false);
    }
    sources.clear();
    set$2(__privateGet(this, _size), 0);
    increment(__privateGet(this, _version));
  }
  keys() {
    return this.values();
  }
  values() {
    get$3(__privateGet(this, _version));
    return super.values();
  }
  entries() {
    get$3(__privateGet(this, _version));
    return super.entries();
  }
  [Symbol.iterator]() {
    return this.keys();
  }
  get size() {
    return get$3(__privateGet(this, _size));
  }
};
_sources = new WeakMap();
_version = new WeakMap();
_size = new WeakMap();
_update_version = new WeakMap();
_SvelteSet_instances = new WeakSet();
/**
 * If the source is being created inside the same reaction as the SvelteSet instance,
 * we use `state` so that it will not be a dependency of the reaction. Otherwise we
 * use `source` so it will be.
 *
 * @template T
 * @param {T} value
 * @returns {Source<T>}
 */
source_fn = function(value) {
  return update_version === __privateGet(this, _update_version) ? /* @__PURE__ */ state(value) : source(value);
};
// We init as part of the first instance so that we can treeshake this class
init_fn = function() {
  inited = true;
  var proto = _SvelteSet.prototype;
  var set_proto = Set.prototype;
  for (const method of read_methods) {
    proto[method] = function(...v2) {
      get$3(__privateGet(this, _version));
      return set_proto[method].apply(this, v2);
    };
  }
  for (const method of set_like_methods) {
    proto[method] = function(...v2) {
      get$3(__privateGet(this, _version));
      var set2 = (
        /** @type {Set<T>} */
        set_proto[method].apply(this, v2)
      );
      return new _SvelteSet(set2);
    };
  }
};
let SvelteSet = _SvelteSet;
class ReactiveValue {
  /**
   *
   * @param {() => T} fn
   * @param {(update: () => void) => void} onsubscribe
   */
  constructor(fn, onsubscribe) {
    __privateAdd(this, _fn);
    __privateAdd(this, _subscribe);
    __privateSet(this, _fn, fn);
    __privateSet(this, _subscribe, createSubscriber(onsubscribe));
  }
  get current() {
    __privateGet(this, _subscribe).call(this);
    return __privateGet(this, _fn).call(this);
  }
}
_fn = new WeakMap();
_subscribe = new WeakMap();
const parenthesis_regex = /\(.+\)/;
const non_parenthesized_keywords = /* @__PURE__ */ new Set(["all", "print", "screen", "and", "or", "not", "only"]);
class MediaQuery extends ReactiveValue {
  /**
   * @param {string} query A media query string
   * @param {boolean} [fallback] Fallback value for the server
   */
  constructor(query, fallback2) {
    let final_query = parenthesis_regex.test(query) || // we need to use `some` here because technically this `window.matchMedia('random,screen')` still returns true
    query.split(/[\s,]+/).some((keyword2) => non_parenthesized_keywords.has(keyword2.trim())) ? query : `(${query})`;
    const q2 = window.matchMedia(final_query);
    super(
      () => q2.matches,
      (update2) => on(q2, "change", update2)
    );
  }
}
function getVisibleNodes(nodeLookup, transform2, width, height) {
  const visibleNodes = /* @__PURE__ */ new Map();
  getNodesInside(nodeLookup, { x: 0, y: 0, width, height }, transform2, true).forEach((node) => {
    visibleNodes.set(node.id, node);
  });
  return visibleNodes;
}
function getLayoutedEdges(options2) {
  var _a3;
  const { edges, defaultEdgeOptions, nodeLookup, previousEdges, connectionMode, onerror, onlyRenderVisible, elevateEdgesOnSelect } = options2;
  const layoutedEdges = /* @__PURE__ */ new Map();
  for (const edge of edges) {
    const sourceNode = nodeLookup.get(edge.source);
    const targetNode = nodeLookup.get(edge.target);
    if (!sourceNode || !targetNode) {
      continue;
    }
    if (onlyRenderVisible) {
      const { visibleNodes, transform: transform2, width, height } = options2;
      if (isEdgeVisible({
        sourceNode,
        targetNode,
        width,
        height,
        transform: transform2
      })) {
        visibleNodes.set(sourceNode.id, sourceNode);
        visibleNodes.set(targetNode.id, targetNode);
      } else {
        continue;
      }
    }
    const previous = previousEdges.get(edge.id);
    if (previous && edge === previous.edge && sourceNode == previous.sourceNode && targetNode == previous.targetNode) {
      layoutedEdges.set(edge.id, previous);
      continue;
    }
    const edgePosition = getEdgePosition({
      id: edge.id,
      sourceNode,
      targetNode,
      sourceHandle: edge.sourceHandle || null,
      targetHandle: edge.targetHandle || null,
      connectionMode,
      onError: onerror
    });
    if (edgePosition) {
      layoutedEdges.set(edge.id, __spreadProps(__spreadValues(__spreadValues(__spreadValues({}, defaultEdgeOptions), edge), edgePosition), {
        zIndex: getElevatedEdgeZIndex({
          selected: edge.selected,
          zIndex: (_a3 = edge.zIndex) != null ? _a3 : defaultEdgeOptions.zIndex,
          sourceNode,
          targetNode,
          elevateOnSelect: elevateEdgesOnSelect
        }),
        sourceNode,
        targetNode,
        edge
      }));
    }
  }
  return layoutedEdges;
}
const initialNodeTypes = {
  input: InputNode,
  output: OutputNode,
  default: DefaultNode,
  group: GroupNode
};
const initialEdgeTypes = {
  straight: StraightEdgeInternal,
  smoothstep: SmoothStepEdgeInternal,
  default: BezierEdge,
  step: StepEdgeInternal
};
function getInitialViewport(_nodesInitialized, fitView, initialViewport, width, height, nodeLookup) {
  if (fitView && !initialViewport && width && height) {
    const bounds = getInternalNodesBounds(nodeLookup, {
      filter: (node) => !!((node.width || node.initialWidth) && (node.height || node.initialHeight))
    });
    return getViewportForBounds(bounds, width, height, 0.5, 2, 0.1);
  } else {
    return initialViewport != null ? initialViewport : { x: 0, y: 0, zoom: 1 };
  }
}
function getInitialStore(signals) {
  var _a3, _b2, _c2, _flowId, _domNode, _panZoom, _width, _height, _nodesInitialized, _viewportInitialized, __edges, _selectedNodes, _selectedEdges, _visible, _nodesDraggable, _nodesConnectable, _elementsSelectable, _nodesFocusable, _edgesFocusable, _disableKeyboardA11y, _minZoom, _maxZoom, _nodeOrigin, _nodeExtent, _translateExtent, _defaultEdgeOptions, _nodeDragThreshold, _autoPanOnNodeDrag, _autoPanOnConnect, _autoPanOnNodeFocus, _connectionDragThreshold, _snapGrid, _dragging, _selectionRect, _selectionKeyPressed, _multiselectionKeyPressed, _deleteKeyPressed, _panActivationKeyPressed, _zoomActivationKeyPressed, _selectionRectMode, _ariaLiveMessage, _selectionMode, _nodeTypes, _edgeTypes, _noPanClass, _noDragClass, _noWheelClass, _ariaLabelConfig, __viewport, __connection, _connection, _connectionMode, _connectionRadius, _isValidConnection, _selectNodesOnDrag, _defaultMarkerColor, _markers, _onlyRenderVisibleElements, _onerror, _ondelete, _onbeforedelete, _onbeforeconnect, _onconnect, _onconnectstart, _onconnectend, _onbeforereconnect, _onreconnect, _onreconnectstart, _onreconnectend, _clickConnect, _onclickconnectstart, _onclickconnectend, _clickConnectStartHandle, _onselectiondrag, _onselectiondragstart, _onselectiondragstop, _colorMode;
  class SvelteFlowStore {
    constructor() {
      __privateAdd(this, _flowId, /* @__PURE__ */ user_derived(() => {
        var _a4;
        return (_a4 = signals.props.id) != null ? _a4 : "1";
      }));
      __privateAdd(this, _domNode, /* @__PURE__ */ state(null));
      __privateAdd(this, _panZoom, /* @__PURE__ */ state(null));
      __privateAdd(this, _width, /* @__PURE__ */ state((_a3 = signals.width) != null ? _a3 : 0));
      __privateAdd(this, _height, /* @__PURE__ */ state((_b2 = signals.height) != null ? _b2 : 0));
      __privateAdd(this, _nodesInitialized, /* @__PURE__ */ user_derived(() => {
        var _a4, _b3;
        const nodesInitialized = adoptUserNodes(signals.nodes, this.nodeLookup, this.parentLookup, {
          nodeExtent: this.nodeExtent,
          nodeOrigin: this.nodeOrigin,
          elevateNodesOnSelect: (_a4 = signals.props.elevateNodesOnSelect) != null ? _a4 : true,
          checkEquality: true
        });
        if (this.fitViewQueued && nodesInitialized) {
          if ((_b3 = this.fitViewOptions) == null ? void 0 : _b3.duration) {
            this.resolveFitView();
          } else {
            queueMicrotask(() => {
              this.resolveFitView();
            });
          }
        }
        return nodesInitialized;
      }));
      __privateAdd(this, _viewportInitialized, /* @__PURE__ */ user_derived(() => this.panZoom !== null));
      __privateAdd(this, __edges, /* @__PURE__ */ user_derived(() => {
        updateConnectionLookup(this.connectionLookup, this.edgeLookup, signals.edges);
        return signals.edges;
      }));
      __publicField(this, "_prevSelectedNodes", []);
      __publicField(this, "_prevSelectedNodeIds", /* @__PURE__ */ new Set());
      __privateAdd(this, _selectedNodes, /* @__PURE__ */ user_derived(() => {
        const selectedNodesCount = this._prevSelectedNodeIds.size;
        const selectedNodeIds = /* @__PURE__ */ new Set();
        const selectedNodes = this.nodes.filter((node) => {
          if (node.selected) {
            selectedNodeIds.add(node.id);
            this._prevSelectedNodeIds.delete(node.id);
          }
          return node.selected;
        });
        if (selectedNodesCount !== selectedNodeIds.size || this._prevSelectedNodeIds.size > 0) {
          this._prevSelectedNodes = selectedNodes;
        }
        this._prevSelectedNodeIds = selectedNodeIds;
        return this._prevSelectedNodes;
      }));
      __publicField(this, "_prevSelectedEdges", []);
      __publicField(this, "_prevSelectedEdgeIds", /* @__PURE__ */ new Set());
      __privateAdd(this, _selectedEdges, /* @__PURE__ */ user_derived(() => {
        const selectedEdgesCount = this._prevSelectedEdgeIds.size;
        const selectedEdgeIds = /* @__PURE__ */ new Set();
        const selectedEdges = this.edges.filter((edge) => {
          if (edge.selected) {
            selectedEdgeIds.add(edge.id);
            this._prevSelectedEdgeIds.delete(edge.id);
          }
          return edge.selected;
        });
        if (selectedEdgesCount !== selectedEdgeIds.size || this._prevSelectedEdgeIds.size > 0) {
          this._prevSelectedEdges = selectedEdges;
        }
        this._prevSelectedEdgeIds = selectedEdgeIds;
        return this._prevSelectedEdges;
      }));
      __publicField(this, "selectionChangeHandlers", /* @__PURE__ */ new Map());
      __publicField(this, "nodeLookup", /* @__PURE__ */ new Map());
      __publicField(this, "parentLookup", /* @__PURE__ */ new Map());
      __publicField(this, "connectionLookup", /* @__PURE__ */ new Map());
      __publicField(this, "edgeLookup", /* @__PURE__ */ new Map());
      __publicField(this, "_prevVisibleEdges", /* @__PURE__ */ new Map());
      __privateAdd(this, _visible, /* @__PURE__ */ user_derived(() => {
        var _a4;
        const {
          // We need to access this._nodes to trigger on changes
          // eslint-disable-next-line @typescript-eslint/no-unused-vars
          nodes,
          _edges: edges,
          _prevVisibleEdges: previousEdges,
          nodeLookup,
          connectionMode,
          onerror,
          onlyRenderVisibleElements,
          defaultEdgeOptions
        } = this;
        let visibleNodes;
        let visibleEdges;
        const options2 = {
          edges,
          defaultEdgeOptions,
          previousEdges,
          nodeLookup,
          connectionMode,
          elevateEdgesOnSelect: (_a4 = signals.props.elevateEdgesOnSelect) != null ? _a4 : true,
          onerror
        };
        if (onlyRenderVisibleElements) {
          const { viewport, width, height } = this;
          const transform2 = [viewport.x, viewport.y, viewport.zoom];
          visibleNodes = getVisibleNodes(nodeLookup, transform2, width, height);
          visibleEdges = getLayoutedEdges(__spreadProps(__spreadValues({}, options2), {
            onlyRenderVisible: true,
            visibleNodes,
            transform: transform2,
            width,
            height
          }));
        } else {
          visibleNodes = this.nodeLookup;
          visibleEdges = getLayoutedEdges(options2);
        }
        return { nodes: visibleNodes, edges: visibleEdges };
      }));
      __privateAdd(this, _nodesDraggable, /* @__PURE__ */ user_derived(() => {
        var _a4;
        return (_a4 = signals.props.nodesDraggable) != null ? _a4 : true;
      }));
      __privateAdd(this, _nodesConnectable, /* @__PURE__ */ user_derived(() => {
        var _a4;
        return (_a4 = signals.props.nodesConnectable) != null ? _a4 : true;
      }));
      __privateAdd(this, _elementsSelectable, /* @__PURE__ */ user_derived(() => {
        var _a4;
        return (_a4 = signals.props.elementsSelectable) != null ? _a4 : true;
      }));
      __privateAdd(this, _nodesFocusable, /* @__PURE__ */ user_derived(() => {
        var _a4;
        return (_a4 = signals.props.nodesFocusable) != null ? _a4 : true;
      }));
      __privateAdd(this, _edgesFocusable, /* @__PURE__ */ user_derived(() => {
        var _a4;
        return (_a4 = signals.props.edgesFocusable) != null ? _a4 : true;
      }));
      __privateAdd(this, _disableKeyboardA11y, /* @__PURE__ */ user_derived(() => {
        var _a4;
        return (_a4 = signals.props.disableKeyboardA11y) != null ? _a4 : false;
      }));
      __privateAdd(this, _minZoom, /* @__PURE__ */ user_derived(() => {
        var _a4;
        return (_a4 = signals.props.minZoom) != null ? _a4 : 0.5;
      }));
      __privateAdd(this, _maxZoom, /* @__PURE__ */ user_derived(() => {
        var _a4;
        return (_a4 = signals.props.maxZoom) != null ? _a4 : 2;
      }));
      __privateAdd(this, _nodeOrigin, /* @__PURE__ */ user_derived(() => {
        var _a4;
        return (_a4 = signals.props.nodeOrigin) != null ? _a4 : [0, 0];
      }));
      __privateAdd(this, _nodeExtent, /* @__PURE__ */ user_derived(() => {
        var _a4;
        return (_a4 = signals.props.nodeExtent) != null ? _a4 : infiniteExtent;
      }));
      __privateAdd(this, _translateExtent, /* @__PURE__ */ user_derived(() => {
        var _a4;
        return (_a4 = signals.props.translateExtent) != null ? _a4 : infiniteExtent;
      }));
      __privateAdd(this, _defaultEdgeOptions, /* @__PURE__ */ user_derived(() => {
        var _a4;
        return (_a4 = signals.props.defaultEdgeOptions) != null ? _a4 : {};
      }));
      __privateAdd(this, _nodeDragThreshold, /* @__PURE__ */ user_derived(() => {
        var _a4;
        return (_a4 = signals.props.nodeDragThreshold) != null ? _a4 : 1;
      }));
      __privateAdd(this, _autoPanOnNodeDrag, /* @__PURE__ */ user_derived(() => {
        var _a4;
        return (_a4 = signals.props.autoPanOnNodeDrag) != null ? _a4 : true;
      }));
      __privateAdd(this, _autoPanOnConnect, /* @__PURE__ */ user_derived(() => {
        var _a4;
        return (_a4 = signals.props.autoPanOnConnect) != null ? _a4 : true;
      }));
      __privateAdd(this, _autoPanOnNodeFocus, /* @__PURE__ */ user_derived(() => {
        var _a4;
        return (_a4 = signals.props.autoPanOnNodeFocus) != null ? _a4 : true;
      }));
      __privateAdd(this, _connectionDragThreshold, /* @__PURE__ */ user_derived(() => {
        var _a4;
        return (_a4 = signals.props.connectionDragThreshold) != null ? _a4 : 1;
      }));
      __publicField(this, "fitViewQueued", (_c2 = signals.props.fitView) != null ? _c2 : false);
      __publicField(this, "fitViewOptions", signals.props.fitViewOptions);
      __publicField(this, "fitViewResolver", null);
      __privateAdd(this, _snapGrid, /* @__PURE__ */ user_derived(() => {
        var _a4;
        return (_a4 = signals.props.snapGrid) != null ? _a4 : null;
      }));
      __privateAdd(this, _dragging, /* @__PURE__ */ state(false));
      __privateAdd(this, _selectionRect, /* @__PURE__ */ state(null));
      __privateAdd(this, _selectionKeyPressed, /* @__PURE__ */ state(false));
      __privateAdd(this, _multiselectionKeyPressed, /* @__PURE__ */ state(false));
      __privateAdd(this, _deleteKeyPressed, /* @__PURE__ */ state(false));
      __privateAdd(this, _panActivationKeyPressed, /* @__PURE__ */ state(false));
      __privateAdd(this, _zoomActivationKeyPressed, /* @__PURE__ */ state(false));
      __privateAdd(this, _selectionRectMode, /* @__PURE__ */ state(null));
      __privateAdd(this, _ariaLiveMessage, /* @__PURE__ */ state(""));
      __privateAdd(this, _selectionMode, /* @__PURE__ */ user_derived(() => {
        var _a4;
        return (_a4 = signals.props.selectionMode) != null ? _a4 : SelectionMode.Partial;
      }));
      __privateAdd(this, _nodeTypes, /* @__PURE__ */ user_derived(() => __spreadValues(__spreadValues({}, initialNodeTypes), signals.props.nodeTypes)));
      __privateAdd(this, _edgeTypes, /* @__PURE__ */ user_derived(() => __spreadValues(__spreadValues({}, initialEdgeTypes), signals.props.edgeTypes)));
      __privateAdd(this, _noPanClass, /* @__PURE__ */ user_derived(() => {
        var _a4;
        return (_a4 = signals.props.noPanClass) != null ? _a4 : "nopan";
      }));
      __privateAdd(this, _noDragClass, /* @__PURE__ */ user_derived(() => {
        var _a4;
        return (_a4 = signals.props.noDragClass) != null ? _a4 : "nodrag";
      }));
      __privateAdd(this, _noWheelClass, /* @__PURE__ */ user_derived(() => {
        var _a4;
        return (_a4 = signals.props.noWheelClass) != null ? _a4 : "nowheel";
      }));
      __privateAdd(this, _ariaLabelConfig, /* @__PURE__ */ user_derived(() => mergeAriaLabelConfig(signals.props.ariaLabelConfig)));
      __privateAdd(this, __viewport, /* @__PURE__ */ state(getInitialViewport(this.nodesInitialized, signals.props.fitView, signals.props.initialViewport, this.width, this.height, this.nodeLookup)));
      __privateAdd(this, __connection, /* @__PURE__ */ state(
        // _connection is viewport independent and originating from XYHandle
        initialConnection
      ));
      __privateAdd(this, _connection, /* @__PURE__ */ user_derived(() => {
        if (!this._connection.inProgress) {
          return this._connection;
        }
        return __spreadProps(__spreadValues({}, this._connection), {
          to: pointToRendererPoint(this._connection.to, [this.viewport.x, this.viewport.y, this.viewport.zoom])
        });
      }));
      __privateAdd(this, _connectionMode, /* @__PURE__ */ user_derived(() => {
        var _a4;
        return (_a4 = signals.props.connectionMode) != null ? _a4 : ConnectionMode.Strict;
      }));
      __privateAdd(this, _connectionRadius, /* @__PURE__ */ user_derived(() => {
        var _a4;
        return (_a4 = signals.props.connectionRadius) != null ? _a4 : 20;
      }));
      __privateAdd(this, _isValidConnection, /* @__PURE__ */ user_derived(() => {
        var _a4;
        return (_a4 = signals.props.isValidConnection) != null ? _a4 : (() => true);
      }));
      __privateAdd(this, _selectNodesOnDrag, /* @__PURE__ */ user_derived(() => {
        var _a4;
        return (_a4 = signals.props.selectNodesOnDrag) != null ? _a4 : true;
      }));
      __privateAdd(this, _defaultMarkerColor, /* @__PURE__ */ user_derived(() => signals.props.defaultMarkerColor === void 0 ? "#b1b1b7" : signals.props.defaultMarkerColor));
      __privateAdd(this, _markers, /* @__PURE__ */ user_derived(() => {
        return createMarkerIds(signals.edges, {
          defaultColor: this.defaultMarkerColor,
          id: this.flowId,
          defaultMarkerStart: this.defaultEdgeOptions.markerStart,
          defaultMarkerEnd: this.defaultEdgeOptions.markerEnd
        });
      }));
      __privateAdd(this, _onlyRenderVisibleElements, /* @__PURE__ */ user_derived(() => {
        var _a4;
        return (_a4 = signals.props.onlyRenderVisibleElements) != null ? _a4 : false;
      }));
      __privateAdd(this, _onerror, /* @__PURE__ */ user_derived(() => {
        var _a4;
        return (_a4 = signals.props.onflowerror) != null ? _a4 : devWarn;
      }));
      __privateAdd(this, _ondelete, /* @__PURE__ */ user_derived(() => signals.props.ondelete));
      __privateAdd(this, _onbeforedelete, /* @__PURE__ */ user_derived(() => signals.props.onbeforedelete));
      __privateAdd(this, _onbeforeconnect, /* @__PURE__ */ user_derived(() => signals.props.onbeforeconnect));
      __privateAdd(this, _onconnect, /* @__PURE__ */ user_derived(() => signals.props.onconnect));
      __privateAdd(this, _onconnectstart, /* @__PURE__ */ user_derived(() => signals.props.onconnectstart));
      __privateAdd(this, _onconnectend, /* @__PURE__ */ user_derived(() => signals.props.onconnectend));
      __privateAdd(this, _onbeforereconnect, /* @__PURE__ */ user_derived(() => signals.props.onbeforereconnect));
      __privateAdd(this, _onreconnect, /* @__PURE__ */ user_derived(() => signals.props.onreconnect));
      __privateAdd(this, _onreconnectstart, /* @__PURE__ */ user_derived(() => signals.props.onreconnectstart));
      __privateAdd(this, _onreconnectend, /* @__PURE__ */ user_derived(() => signals.props.onreconnectend));
      __privateAdd(this, _clickConnect, /* @__PURE__ */ user_derived(() => {
        var _a4;
        return (_a4 = signals.props.clickConnect) != null ? _a4 : true;
      }));
      __privateAdd(this, _onclickconnectstart, /* @__PURE__ */ user_derived(() => signals.props.onclickconnectstart));
      __privateAdd(this, _onclickconnectend, /* @__PURE__ */ user_derived(() => signals.props.onclickconnectend));
      __privateAdd(this, _clickConnectStartHandle, /* @__PURE__ */ state(null));
      __privateAdd(this, _onselectiondrag, /* @__PURE__ */ user_derived(() => signals.props.onselectiondrag));
      __privateAdd(this, _onselectiondragstart, /* @__PURE__ */ user_derived(() => signals.props.onselectiondragstart));
      __privateAdd(this, _onselectiondragstop, /* @__PURE__ */ user_derived(() => signals.props.onselectiondragstop));
      __publicField(this, "resolveFitView", () => __async(this, null, function* () {
        var _a4;
        if (!this.panZoom) {
          return;
        }
        yield fitViewport(
          {
            nodes: this.nodeLookup,
            width: this.width,
            height: this.height,
            panZoom: this.panZoom,
            minZoom: this.minZoom,
            maxZoom: this.maxZoom
          },
          this.fitViewOptions
        );
        (_a4 = this.fitViewResolver) == null ? void 0 : _a4.resolve(true);
        this.fitViewQueued = false;
        this.fitViewOptions = void 0;
        this.fitViewResolver = null;
      }));
      __publicField(this, "_prefersDark", new MediaQuery("(prefers-color-scheme: dark)", signals.props.colorModeSSR === "dark"));
      __privateAdd(this, _colorMode, /* @__PURE__ */ user_derived(() => {
        var _a4;
        return signals.props.colorMode === "system" ? this._prefersDark.current ? "dark" : "light" : (_a4 = signals.props.colorMode) != null ? _a4 : "light";
      }));
    }
    get flowId() {
      return get$3(__privateGet(this, _flowId));
    }
    set flowId(value) {
      set$2(__privateGet(this, _flowId), value);
    }
    get domNode() {
      return get$3(__privateGet(this, _domNode));
    }
    set domNode(value) {
      set$2(__privateGet(this, _domNode), value);
    }
    get panZoom() {
      return get$3(__privateGet(this, _panZoom));
    }
    set panZoom(value) {
      set$2(__privateGet(this, _panZoom), value);
    }
    get width() {
      return get$3(__privateGet(this, _width));
    }
    set width(value) {
      set$2(__privateGet(this, _width), value);
    }
    get height() {
      return get$3(__privateGet(this, _height));
    }
    set height(value) {
      set$2(__privateGet(this, _height), value);
    }
    get nodesInitialized() {
      return get$3(__privateGet(this, _nodesInitialized));
    }
    set nodesInitialized(value) {
      set$2(__privateGet(this, _nodesInitialized), value);
    }
    get viewportInitialized() {
      return get$3(__privateGet(this, _viewportInitialized));
    }
    set viewportInitialized(value) {
      set$2(__privateGet(this, _viewportInitialized), value);
    }
    get _edges() {
      return get$3(__privateGet(this, __edges));
    }
    set _edges(value) {
      set$2(__privateGet(this, __edges), value);
    }
    get nodes() {
      this.nodesInitialized;
      return signals.nodes;
    }
    set nodes(nodes) {
      signals.nodes = nodes;
    }
    get edges() {
      return this._edges;
    }
    set edges(edges) {
      signals.edges = edges;
    }
    get selectedNodes() {
      return get$3(__privateGet(this, _selectedNodes));
    }
    set selectedNodes(value) {
      set$2(__privateGet(this, _selectedNodes), value);
    }
    get selectedEdges() {
      return get$3(__privateGet(this, _selectedEdges));
    }
    set selectedEdges(value) {
      set$2(__privateGet(this, _selectedEdges), value);
    }
    get visible() {
      return get$3(__privateGet(this, _visible));
    }
    set visible(value) {
      set$2(__privateGet(this, _visible), value);
    }
    get nodesDraggable() {
      return get$3(__privateGet(this, _nodesDraggable));
    }
    set nodesDraggable(value) {
      set$2(__privateGet(this, _nodesDraggable), value);
    }
    get nodesConnectable() {
      return get$3(__privateGet(this, _nodesConnectable));
    }
    set nodesConnectable(value) {
      set$2(__privateGet(this, _nodesConnectable), value);
    }
    get elementsSelectable() {
      return get$3(__privateGet(this, _elementsSelectable));
    }
    set elementsSelectable(value) {
      set$2(__privateGet(this, _elementsSelectable), value);
    }
    get nodesFocusable() {
      return get$3(__privateGet(this, _nodesFocusable));
    }
    set nodesFocusable(value) {
      set$2(__privateGet(this, _nodesFocusable), value);
    }
    get edgesFocusable() {
      return get$3(__privateGet(this, _edgesFocusable));
    }
    set edgesFocusable(value) {
      set$2(__privateGet(this, _edgesFocusable), value);
    }
    get disableKeyboardA11y() {
      return get$3(__privateGet(this, _disableKeyboardA11y));
    }
    set disableKeyboardA11y(value) {
      set$2(__privateGet(this, _disableKeyboardA11y), value);
    }
    get minZoom() {
      return get$3(__privateGet(this, _minZoom));
    }
    set minZoom(value) {
      set$2(__privateGet(this, _minZoom), value);
    }
    get maxZoom() {
      return get$3(__privateGet(this, _maxZoom));
    }
    set maxZoom(value) {
      set$2(__privateGet(this, _maxZoom), value);
    }
    get nodeOrigin() {
      return get$3(__privateGet(this, _nodeOrigin));
    }
    set nodeOrigin(value) {
      set$2(__privateGet(this, _nodeOrigin), value);
    }
    get nodeExtent() {
      return get$3(__privateGet(this, _nodeExtent));
    }
    set nodeExtent(value) {
      set$2(__privateGet(this, _nodeExtent), value);
    }
    get translateExtent() {
      return get$3(__privateGet(this, _translateExtent));
    }
    set translateExtent(value) {
      set$2(__privateGet(this, _translateExtent), value);
    }
    get defaultEdgeOptions() {
      return get$3(__privateGet(this, _defaultEdgeOptions));
    }
    set defaultEdgeOptions(value) {
      set$2(__privateGet(this, _defaultEdgeOptions), value);
    }
    get nodeDragThreshold() {
      return get$3(__privateGet(this, _nodeDragThreshold));
    }
    set nodeDragThreshold(value) {
      set$2(__privateGet(this, _nodeDragThreshold), value);
    }
    get autoPanOnNodeDrag() {
      return get$3(__privateGet(this, _autoPanOnNodeDrag));
    }
    set autoPanOnNodeDrag(value) {
      set$2(__privateGet(this, _autoPanOnNodeDrag), value);
    }
    get autoPanOnConnect() {
      return get$3(__privateGet(this, _autoPanOnConnect));
    }
    set autoPanOnConnect(value) {
      set$2(__privateGet(this, _autoPanOnConnect), value);
    }
    get autoPanOnNodeFocus() {
      return get$3(__privateGet(this, _autoPanOnNodeFocus));
    }
    set autoPanOnNodeFocus(value) {
      set$2(__privateGet(this, _autoPanOnNodeFocus), value);
    }
    get connectionDragThreshold() {
      return get$3(__privateGet(this, _connectionDragThreshold));
    }
    set connectionDragThreshold(value) {
      set$2(__privateGet(this, _connectionDragThreshold), value);
    }
    get snapGrid() {
      return get$3(__privateGet(this, _snapGrid));
    }
    set snapGrid(value) {
      set$2(__privateGet(this, _snapGrid), value);
    }
    get dragging() {
      return get$3(__privateGet(this, _dragging));
    }
    set dragging(value) {
      set$2(__privateGet(this, _dragging), value);
    }
    get selectionRect() {
      return get$3(__privateGet(this, _selectionRect));
    }
    set selectionRect(value) {
      set$2(__privateGet(this, _selectionRect), value);
    }
    get selectionKeyPressed() {
      return get$3(__privateGet(this, _selectionKeyPressed));
    }
    set selectionKeyPressed(value) {
      set$2(__privateGet(this, _selectionKeyPressed), value);
    }
    get multiselectionKeyPressed() {
      return get$3(__privateGet(this, _multiselectionKeyPressed));
    }
    set multiselectionKeyPressed(value) {
      set$2(__privateGet(this, _multiselectionKeyPressed), value);
    }
    get deleteKeyPressed() {
      return get$3(__privateGet(this, _deleteKeyPressed));
    }
    set deleteKeyPressed(value) {
      set$2(__privateGet(this, _deleteKeyPressed), value);
    }
    get panActivationKeyPressed() {
      return get$3(__privateGet(this, _panActivationKeyPressed));
    }
    set panActivationKeyPressed(value) {
      set$2(__privateGet(this, _panActivationKeyPressed), value);
    }
    get zoomActivationKeyPressed() {
      return get$3(__privateGet(this, _zoomActivationKeyPressed));
    }
    set zoomActivationKeyPressed(value) {
      set$2(__privateGet(this, _zoomActivationKeyPressed), value);
    }
    get selectionRectMode() {
      return get$3(__privateGet(this, _selectionRectMode));
    }
    set selectionRectMode(value) {
      set$2(__privateGet(this, _selectionRectMode), value);
    }
    get ariaLiveMessage() {
      return get$3(__privateGet(this, _ariaLiveMessage));
    }
    set ariaLiveMessage(value) {
      set$2(__privateGet(this, _ariaLiveMessage), value);
    }
    get selectionMode() {
      return get$3(__privateGet(this, _selectionMode));
    }
    set selectionMode(value) {
      set$2(__privateGet(this, _selectionMode), value);
    }
    get nodeTypes() {
      return get$3(__privateGet(this, _nodeTypes));
    }
    set nodeTypes(value) {
      set$2(__privateGet(this, _nodeTypes), value);
    }
    get edgeTypes() {
      return get$3(__privateGet(this, _edgeTypes));
    }
    set edgeTypes(value) {
      set$2(__privateGet(this, _edgeTypes), value);
    }
    get noPanClass() {
      return get$3(__privateGet(this, _noPanClass));
    }
    set noPanClass(value) {
      set$2(__privateGet(this, _noPanClass), value);
    }
    get noDragClass() {
      return get$3(__privateGet(this, _noDragClass));
    }
    set noDragClass(value) {
      set$2(__privateGet(this, _noDragClass), value);
    }
    get noWheelClass() {
      return get$3(__privateGet(this, _noWheelClass));
    }
    set noWheelClass(value) {
      set$2(__privateGet(this, _noWheelClass), value);
    }
    get ariaLabelConfig() {
      return get$3(__privateGet(this, _ariaLabelConfig));
    }
    set ariaLabelConfig(value) {
      set$2(__privateGet(this, _ariaLabelConfig), value);
    }
    get _viewport() {
      return get$3(__privateGet(this, __viewport));
    }
    set _viewport(value) {
      set$2(__privateGet(this, __viewport), value);
    }
    get viewport() {
      var _a4;
      return (_a4 = signals.viewport) != null ? _a4 : this._viewport;
    }
    set viewport(newViewport) {
      if (signals.viewport) {
        signals.viewport = newViewport;
      }
      this._viewport = newViewport;
    }
    get _connection() {
      return get$3(__privateGet(this, __connection));
    }
    set _connection(value) {
      set$2(__privateGet(this, __connection), value);
    }
    get connection() {
      return get$3(__privateGet(this, _connection));
    }
    set connection(value) {
      set$2(__privateGet(this, _connection), value);
    }
    get connectionMode() {
      return get$3(__privateGet(this, _connectionMode));
    }
    set connectionMode(value) {
      set$2(__privateGet(this, _connectionMode), value);
    }
    get connectionRadius() {
      return get$3(__privateGet(this, _connectionRadius));
    }
    set connectionRadius(value) {
      set$2(__privateGet(this, _connectionRadius), value);
    }
    get isValidConnection() {
      return get$3(__privateGet(this, _isValidConnection));
    }
    set isValidConnection(value) {
      set$2(__privateGet(this, _isValidConnection), value);
    }
    get selectNodesOnDrag() {
      return get$3(__privateGet(this, _selectNodesOnDrag));
    }
    set selectNodesOnDrag(value) {
      set$2(__privateGet(this, _selectNodesOnDrag), value);
    }
    get defaultMarkerColor() {
      return get$3(__privateGet(this, _defaultMarkerColor));
    }
    set defaultMarkerColor(value) {
      set$2(__privateGet(this, _defaultMarkerColor), value);
    }
    get markers() {
      return get$3(__privateGet(this, _markers));
    }
    set markers(value) {
      set$2(__privateGet(this, _markers), value);
    }
    get onlyRenderVisibleElements() {
      return get$3(__privateGet(this, _onlyRenderVisibleElements));
    }
    set onlyRenderVisibleElements(value) {
      set$2(__privateGet(this, _onlyRenderVisibleElements), value);
    }
    get onerror() {
      return get$3(__privateGet(this, _onerror));
    }
    set onerror(value) {
      set$2(__privateGet(this, _onerror), value);
    }
    get ondelete() {
      return get$3(__privateGet(this, _ondelete));
    }
    set ondelete(value) {
      set$2(__privateGet(this, _ondelete), value);
    }
    get onbeforedelete() {
      return get$3(__privateGet(this, _onbeforedelete));
    }
    set onbeforedelete(value) {
      set$2(__privateGet(this, _onbeforedelete), value);
    }
    get onbeforeconnect() {
      return get$3(__privateGet(this, _onbeforeconnect));
    }
    set onbeforeconnect(value) {
      set$2(__privateGet(this, _onbeforeconnect), value);
    }
    get onconnect() {
      return get$3(__privateGet(this, _onconnect));
    }
    set onconnect(value) {
      set$2(__privateGet(this, _onconnect), value);
    }
    get onconnectstart() {
      return get$3(__privateGet(this, _onconnectstart));
    }
    set onconnectstart(value) {
      set$2(__privateGet(this, _onconnectstart), value);
    }
    get onconnectend() {
      return get$3(__privateGet(this, _onconnectend));
    }
    set onconnectend(value) {
      set$2(__privateGet(this, _onconnectend), value);
    }
    get onbeforereconnect() {
      return get$3(__privateGet(this, _onbeforereconnect));
    }
    set onbeforereconnect(value) {
      set$2(__privateGet(this, _onbeforereconnect), value);
    }
    get onreconnect() {
      return get$3(__privateGet(this, _onreconnect));
    }
    set onreconnect(value) {
      set$2(__privateGet(this, _onreconnect), value);
    }
    get onreconnectstart() {
      return get$3(__privateGet(this, _onreconnectstart));
    }
    set onreconnectstart(value) {
      set$2(__privateGet(this, _onreconnectstart), value);
    }
    get onreconnectend() {
      return get$3(__privateGet(this, _onreconnectend));
    }
    set onreconnectend(value) {
      set$2(__privateGet(this, _onreconnectend), value);
    }
    get clickConnect() {
      return get$3(__privateGet(this, _clickConnect));
    }
    set clickConnect(value) {
      set$2(__privateGet(this, _clickConnect), value);
    }
    get onclickconnectstart() {
      return get$3(__privateGet(this, _onclickconnectstart));
    }
    set onclickconnectstart(value) {
      set$2(__privateGet(this, _onclickconnectstart), value);
    }
    get onclickconnectend() {
      return get$3(__privateGet(this, _onclickconnectend));
    }
    set onclickconnectend(value) {
      set$2(__privateGet(this, _onclickconnectend), value);
    }
    get clickConnectStartHandle() {
      return get$3(__privateGet(this, _clickConnectStartHandle));
    }
    set clickConnectStartHandle(value) {
      set$2(__privateGet(this, _clickConnectStartHandle), value);
    }
    get onselectiondrag() {
      return get$3(__privateGet(this, _onselectiondrag));
    }
    set onselectiondrag(value) {
      set$2(__privateGet(this, _onselectiondrag), value);
    }
    get onselectiondragstart() {
      return get$3(__privateGet(this, _onselectiondragstart));
    }
    set onselectiondragstart(value) {
      set$2(__privateGet(this, _onselectiondragstart), value);
    }
    get onselectiondragstop() {
      return get$3(__privateGet(this, _onselectiondragstop));
    }
    set onselectiondragstop(value) {
      set$2(__privateGet(this, _onselectiondragstop), value);
    }
    get colorMode() {
      return get$3(__privateGet(this, _colorMode));
    }
    set colorMode(value) {
      set$2(__privateGet(this, _colorMode), value);
    }
    resetStoreValues() {
      var _a4;
      this.dragging = false;
      this.selectionRect = null;
      this.selectionRectMode = null;
      this.selectionKeyPressed = false;
      this.multiselectionKeyPressed = false;
      this.deleteKeyPressed = false;
      this.panActivationKeyPressed = false;
      this.zoomActivationKeyPressed = false;
      this._connection = initialConnection;
      this.clickConnectStartHandle = null;
      this.viewport = (_a4 = signals.props.initialViewport) != null ? _a4 : { x: 0, y: 0, zoom: 1 };
      this.ariaLiveMessage = "";
    }
  }
  _flowId = new WeakMap();
  _domNode = new WeakMap();
  _panZoom = new WeakMap();
  _width = new WeakMap();
  _height = new WeakMap();
  _nodesInitialized = new WeakMap();
  _viewportInitialized = new WeakMap();
  __edges = new WeakMap();
  _selectedNodes = new WeakMap();
  _selectedEdges = new WeakMap();
  _visible = new WeakMap();
  _nodesDraggable = new WeakMap();
  _nodesConnectable = new WeakMap();
  _elementsSelectable = new WeakMap();
  _nodesFocusable = new WeakMap();
  _edgesFocusable = new WeakMap();
  _disableKeyboardA11y = new WeakMap();
  _minZoom = new WeakMap();
  _maxZoom = new WeakMap();
  _nodeOrigin = new WeakMap();
  _nodeExtent = new WeakMap();
  _translateExtent = new WeakMap();
  _defaultEdgeOptions = new WeakMap();
  _nodeDragThreshold = new WeakMap();
  _autoPanOnNodeDrag = new WeakMap();
  _autoPanOnConnect = new WeakMap();
  _autoPanOnNodeFocus = new WeakMap();
  _connectionDragThreshold = new WeakMap();
  _snapGrid = new WeakMap();
  _dragging = new WeakMap();
  _selectionRect = new WeakMap();
  _selectionKeyPressed = new WeakMap();
  _multiselectionKeyPressed = new WeakMap();
  _deleteKeyPressed = new WeakMap();
  _panActivationKeyPressed = new WeakMap();
  _zoomActivationKeyPressed = new WeakMap();
  _selectionRectMode = new WeakMap();
  _ariaLiveMessage = new WeakMap();
  _selectionMode = new WeakMap();
  _nodeTypes = new WeakMap();
  _edgeTypes = new WeakMap();
  _noPanClass = new WeakMap();
  _noDragClass = new WeakMap();
  _noWheelClass = new WeakMap();
  _ariaLabelConfig = new WeakMap();
  __viewport = new WeakMap();
  __connection = new WeakMap();
  _connection = new WeakMap();
  _connectionMode = new WeakMap();
  _connectionRadius = new WeakMap();
  _isValidConnection = new WeakMap();
  _selectNodesOnDrag = new WeakMap();
  _defaultMarkerColor = new WeakMap();
  _markers = new WeakMap();
  _onlyRenderVisibleElements = new WeakMap();
  _onerror = new WeakMap();
  _ondelete = new WeakMap();
  _onbeforedelete = new WeakMap();
  _onbeforeconnect = new WeakMap();
  _onconnect = new WeakMap();
  _onconnectstart = new WeakMap();
  _onconnectend = new WeakMap();
  _onbeforereconnect = new WeakMap();
  _onreconnect = new WeakMap();
  _onreconnectstart = new WeakMap();
  _onreconnectend = new WeakMap();
  _clickConnect = new WeakMap();
  _onclickconnectstart = new WeakMap();
  _onclickconnectend = new WeakMap();
  _clickConnectStartHandle = new WeakMap();
  _onselectiondrag = new WeakMap();
  _onselectiondragstart = new WeakMap();
  _onselectiondragstop = new WeakMap();
  _colorMode = new WeakMap();
  return new SvelteFlowStore();
}
function useStore() {
  const storeContext = getContext(key);
  if (!storeContext) {
    throw new Error("To call useStore outside of <SvelteFlow /> you need to wrap your component in a <SvelteFlowProvider />");
  }
  return storeContext.getStore();
}
const key = Symbol();
function createStore(signals) {
  const store = getInitialStore(signals);
  function setNodeTypes(nodeTypes) {
    store.nodeTypes = __spreadValues(__spreadValues({}, initialNodeTypes), nodeTypes);
  }
  function setEdgeTypes(edgeTypes) {
    store.edgeTypes = __spreadValues(__spreadValues({}, initialEdgeTypes), edgeTypes);
  }
  function addEdge$1(edgeParams) {
    store.edges = addEdge(edgeParams, store.edges);
  }
  const updateNodePositions = (nodeDragItems, dragging = false) => {
    store.nodes = store.nodes.map((node) => {
      const dragItem = nodeDragItems.get(node.id);
      return dragItem ? __spreadProps(__spreadValues({}, node), { position: dragItem.position, dragging }) : node;
    });
  };
  function updateNodeInternals$1(updates) {
    var _a3, _b2, _c2, _d2, _e3, _f2;
    const { changes, updatedInternals } = updateNodeInternals(updates, store.nodeLookup, store.parentLookup, store.domNode, store.nodeOrigin);
    if (!updatedInternals) {
      return;
    }
    updateAbsolutePositions(store.nodeLookup, store.parentLookup, {
      nodeOrigin: store.nodeOrigin,
      nodeExtent: store.nodeExtent
    });
    if (store.fitViewQueued) {
      store.resolveFitView();
    }
    const newNodes = /* @__PURE__ */ new Map();
    for (const change of changes) {
      const userNode = (_a3 = store.nodeLookup.get(change.id)) == null ? void 0 : _a3.internals.userNode;
      if (!userNode) {
        continue;
      }
      const node = __spreadValues({}, userNode);
      switch (change.type) {
        case "dimensions": {
          const measured = __spreadValues(__spreadValues({}, node.measured), change.dimensions);
          if (change.setAttributes) {
            node.width = (_c2 = (_b2 = change.dimensions) == null ? void 0 : _b2.width) != null ? _c2 : node.width;
            node.height = (_e3 = (_d2 = change.dimensions) == null ? void 0 : _d2.height) != null ? _e3 : node.height;
          }
          node.measured = measured;
          break;
        }
        case "position":
          node.position = (_f2 = change.position) != null ? _f2 : node.position;
          break;
      }
      newNodes.set(change.id, node);
    }
    store.nodes = store.nodes.map((node) => {
      var _a4;
      return (_a4 = newNodes.get(node.id)) != null ? _a4 : node;
    });
  }
  function fitView(options2) {
    var _a3;
    const fitViewResolver = (_a3 = store.fitViewResolver) != null ? _a3 : Promise.withResolvers();
    store.fitViewQueued = true;
    store.fitViewOptions = options2;
    store.fitViewResolver = fitViewResolver;
    store.nodes = [...store.nodes];
    return fitViewResolver.promise;
  }
  function setCenter(x2, y2, options2) {
    return __async(this, null, function* () {
      const nextZoom = typeof (options2 == null ? void 0 : options2.zoom) !== "undefined" ? options2.zoom : store.maxZoom;
      const currentPanZoom = store.panZoom;
      if (!currentPanZoom) {
        return Promise.resolve(false);
      }
      yield currentPanZoom.setViewport({
        x: store.width / 2 - x2 * nextZoom,
        y: store.height / 2 - y2 * nextZoom,
        zoom: nextZoom
      }, { duration: options2 == null ? void 0 : options2.duration, ease: options2 == null ? void 0 : options2.ease, interpolate: options2 == null ? void 0 : options2.interpolate });
      return Promise.resolve(true);
    });
  }
  function zoomBy(factor, options2) {
    const panZoom = store.panZoom;
    if (!panZoom) {
      return Promise.resolve(false);
    }
    return panZoom.scaleBy(factor, options2);
  }
  function zoomIn(options2) {
    return zoomBy(1.2, options2);
  }
  function zoomOut(options2) {
    return zoomBy(1 / 1.2, options2);
  }
  function setMinZoom(minZoom) {
    const panZoom = store.panZoom;
    if (panZoom) {
      panZoom.setScaleExtent([minZoom, store.maxZoom]);
      store.minZoom = minZoom;
    }
  }
  function setMaxZoom(maxZoom) {
    const panZoom = store.panZoom;
    if (panZoom) {
      panZoom.setScaleExtent([store.minZoom, maxZoom]);
      store.maxZoom = maxZoom;
    }
  }
  function setTranslateExtent(extent) {
    const panZoom = store.panZoom;
    if (panZoom) {
      panZoom.setTranslateExtent(extent);
      store.translateExtent = extent;
    }
  }
  function setPaneClickDistance(distance2) {
    var _a3;
    (_a3 = store.panZoom) == null ? void 0 : _a3.setClickDistance(distance2);
  }
  function deselect(elements, elementsToDeselect = null) {
    let deselected = false;
    const newElements = elements.map((element) => {
      const shouldDeselect = elementsToDeselect ? elementsToDeselect.has(element.id) : true;
      if (shouldDeselect && element.selected) {
        deselected = true;
        return __spreadProps(__spreadValues({}, element), { selected: false });
      }
      return element;
    });
    return [deselected, newElements];
  }
  function unselectNodesAndEdges(params) {
    const nodesToDeselect = (params == null ? void 0 : params.nodes) ? new Set(params.nodes.map((node) => node.id)) : null;
    const [nodesDeselected, newNodes] = deselect(store.nodes, nodesToDeselect);
    if (nodesDeselected) {
      store.nodes = newNodes;
    }
    const edgesToDeselect = (params == null ? void 0 : params.edges) ? new Set(params.edges.map((node) => node.id)) : null;
    const [edgesDeselected, newEdges] = deselect(store.edges, edgesToDeselect);
    if (edgesDeselected) {
      store.edges = newEdges;
    }
  }
  function addSelectedNodes(ids) {
    const isMultiSelection = store.multiselectionKeyPressed;
    store.nodes = store.nodes.map((node) => {
      const nodeWillBeSelected = ids.includes(node.id);
      const selected = isMultiSelection ? node.selected || nodeWillBeSelected : nodeWillBeSelected;
      if (node.selected !== selected) {
        const internalNode = store.nodeLookup.get(node.id);
        if (internalNode)
          internalNode.selected = selected;
        node.selected = selected;
        return __spreadValues({}, node);
      }
      return node;
    });
    if (!isMultiSelection) {
      unselectNodesAndEdges({ nodes: [] });
    }
  }
  function addSelectedEdges(ids) {
    const isMultiSelection = store.multiselectionKeyPressed;
    store.edges = store.edges.map((edge) => {
      const edgeWillBeSelected = ids.includes(edge.id);
      const selected = isMultiSelection ? edge.selected || edgeWillBeSelected : edgeWillBeSelected;
      if (edge.selected !== selected) {
        return __spreadProps(__spreadValues({}, edge), { selected });
      }
      return edge;
    });
    if (!isMultiSelection) {
      unselectNodesAndEdges({ edges: [] });
    }
  }
  function handleNodeSelection(id2, unselect, nodeRef) {
    const node = store.nodeLookup.get(id2);
    if (!node) {
      console.warn("012", errorMessages["error012"](id2));
      return;
    }
    store.selectionRect = null;
    store.selectionRectMode = null;
    if (!node.selected) {
      addSelectedNodes([id2]);
    } else if (unselect || node.selected && store.multiselectionKeyPressed) {
      unselectNodesAndEdges({ nodes: [node], edges: [] });
      requestAnimationFrame(() => nodeRef == null ? void 0 : nodeRef.blur());
    }
  }
  function handleEdgeSelection(id2) {
    const edge = store.edgeLookup.get(id2);
    if (!edge) {
      console.warn("012", errorMessages["error012"](id2));
      return;
    }
    const selectable = edge.selectable || store.elementsSelectable && typeof edge.selectable === "undefined";
    if (selectable) {
      store.selectionRect = null;
      store.selectionRectMode = null;
      if (!edge.selected) {
        addSelectedEdges([id2]);
      } else if (edge.selected && store.multiselectionKeyPressed) {
        unselectNodesAndEdges({ nodes: [], edges: [edge] });
      }
    }
  }
  function moveSelectedNodes(direction, factor) {
    var _a3, _b2;
    const { nodeExtent, snapGrid, nodeOrigin, nodeLookup, nodesDraggable, onerror } = store;
    const nodeUpdates = /* @__PURE__ */ new Map();
    const xVelo = (_a3 = snapGrid == null ? void 0 : snapGrid[0]) != null ? _a3 : 5;
    const yVelo = (_b2 = snapGrid == null ? void 0 : snapGrid[1]) != null ? _b2 : 5;
    const xDiff = direction.x * xVelo * factor;
    const yDiff = direction.y * yVelo * factor;
    for (const node of nodeLookup.values()) {
      const isSelected = node.selected && (node.draggable || nodesDraggable && typeof node.draggable === "undefined");
      if (!isSelected) {
        continue;
      }
      let nextPosition = {
        x: node.internals.positionAbsolute.x + xDiff,
        y: node.internals.positionAbsolute.y + yDiff
      };
      if (snapGrid) {
        nextPosition = snapPosition(nextPosition, snapGrid);
      }
      const { position, positionAbsolute } = calculateNodePosition({
        nodeId: node.id,
        nextPosition,
        nodeLookup,
        nodeExtent,
        nodeOrigin,
        onError: onerror
      });
      node.position = position;
      node.internals.positionAbsolute = positionAbsolute;
      nodeUpdates.set(node.id, node);
    }
    updateNodePositions(nodeUpdates);
  }
  function panBy$1(delta) {
    return panBy({
      delta,
      panZoom: store.panZoom,
      transform: [store.viewport.x, store.viewport.y, store.viewport.zoom],
      translateExtent: store.translateExtent,
      width: store.width,
      height: store.height
    });
  }
  const updateConnection = (newConnection) => {
    store._connection = __spreadValues({}, newConnection);
  };
  function cancelConnection() {
    store._connection = initialConnection;
  }
  function reset() {
    store.resetStoreValues();
    unselectNodesAndEdges();
  }
  const storeWithActions = Object.assign(store, {
    setNodeTypes,
    setEdgeTypes,
    addEdge: addEdge$1,
    updateNodePositions,
    updateNodeInternals: updateNodeInternals$1,
    zoomIn,
    zoomOut,
    fitView,
    setCenter,
    setMinZoom,
    setMaxZoom,
    setTranslateExtent,
    setPaneClickDistance,
    unselectNodesAndEdges,
    addSelectedNodes,
    addSelectedEdges,
    handleNodeSelection,
    handleEdgeSelection,
    moveSelectedNodes,
    panBy: panBy$1,
    updateConnection,
    cancelConnection,
    reset
  });
  return storeWithActions;
}
function zoom(domNode, params) {
  const { minZoom, maxZoom, initialViewport, onPanZoomStart, onPanZoom, onPanZoomEnd, translateExtent, paneClickDistance, setPanZoomInstance, onDraggingChange, onTransformChange } = params;
  const panZoomInstance = XYPanZoom({
    domNode,
    minZoom,
    maxZoom,
    translateExtent,
    viewport: initialViewport,
    paneClickDistance,
    onPanZoom,
    onPanZoomStart,
    onPanZoomEnd,
    onDraggingChange
  });
  const viewport = panZoomInstance.getViewport();
  if (initialViewport.x !== viewport.x || initialViewport.y !== viewport.y || initialViewport.zoom !== viewport.zoom) {
    onTransformChange([viewport.x, viewport.y, viewport.zoom]);
  }
  setPanZoomInstance(panZoomInstance);
  panZoomInstance.update(params);
  return {
    update(params2) {
      panZoomInstance.update(params2);
    }
  };
}
var root$19 = /* @__PURE__ */ from_html(`<div class="svelte-flow__zoom svelte-flow__container"><!></div>`);
function Zoom($$anchor, $$props) {
  push($$props, true);
  let store = prop($$props, "store", 15), panOnScrollMode = prop($$props, "panOnScrollMode", 19, () => PanOnScrollMode.Free), preventScrolling = prop($$props, "preventScrolling", 3, true), zoomOnScroll = prop($$props, "zoomOnScroll", 3, true), zoomOnDoubleClick = prop($$props, "zoomOnDoubleClick", 3, true), zoomOnPinch = prop($$props, "zoomOnPinch", 3, true), panOnDrag = prop($$props, "panOnDrag", 3, true), panOnScroll = prop($$props, "panOnScroll", 3, false), paneClickDistance = prop($$props, "paneClickDistance", 3, 1);
  let panOnDragActive = /* @__PURE__ */ user_derived(() => store().panActivationKeyPressed || panOnDrag());
  let panOnScrollActive = /* @__PURE__ */ user_derived(() => store().panActivationKeyPressed || panOnScroll());
  const { viewport: initialViewport } = store();
  let onInitCalled = false;
  user_effect(() => {
    var _a3;
    if (!onInitCalled && store().viewportInitialized) {
      (_a3 = $$props.oninit) == null ? void 0 : _a3.call($$props);
      onInitCalled = true;
    }
  });
  var div = root$19();
  var node = child(div);
  snippet(node, () => $$props.children);
  action(div, ($$node, $$action_arg) => zoom == null ? void 0 : zoom($$node, $$action_arg), () => ({
    viewport: store().viewport,
    minZoom: store().minZoom,
    maxZoom: store().maxZoom,
    initialViewport,
    onDraggingChange: (dragging) => {
      store(store().dragging = dragging, true);
    },
    setPanZoomInstance: (instance) => {
      store(store().panZoom = instance, true);
    },
    onPanZoomStart: $$props.onmovestart,
    onPanZoom: $$props.onmove,
    onPanZoomEnd: $$props.onmoveend,
    zoomOnScroll: zoomOnScroll(),
    zoomOnDoubleClick: zoomOnDoubleClick(),
    zoomOnPinch: zoomOnPinch(),
    panOnScroll: get$3(panOnScrollActive),
    panOnDrag: get$3(panOnDragActive),
    panOnScrollSpeed: 0.5,
    panOnScrollMode: panOnScrollMode() || PanOnScrollMode.Free,
    zoomActivationKeyPressed: store().zoomActivationKeyPressed,
    preventScrolling: typeof preventScrolling() === "boolean" ? preventScrolling() : true,
    noPanClassName: store().noPanClass,
    noWheelClassName: store().noWheelClass,
    userSelectionActive: !!store().selectionRect,
    translateExtent: store().translateExtent,
    lib: "svelte",
    paneClickDistance: paneClickDistance(),
    onTransformChange: (transform2) => {
      store(store().viewport = { x: transform2[0], y: transform2[1], zoom: transform2[2] }, true);
    }
  }));
  append($$anchor, div);
  pop();
}
function wrapHandler(handler, container) {
  return (event2) => {
    if (event2.target !== container) {
      return;
    }
    handler == null ? void 0 : handler(event2);
  };
}
function toggleSelected(ids) {
  return (item) => {
    const isSelected = ids.has(item.id);
    if (!!item.selected !== isSelected) {
      return __spreadProps(__spreadValues({}, item), { selected: isSelected });
    }
    return item;
  };
}
function isSetEqual(a, b2) {
  if (a.size !== b2.size) {
    return false;
  }
  for (const item of a) {
    if (!b2.has(item)) {
      return false;
    }
  }
  return true;
}
var root$18 = /* @__PURE__ */ from_html(`<div><!></div>`);
function Pane($$anchor, $$props) {
  push($$props, true);
  let store = prop($$props, "store", 15), panOnDrag = prop($$props, "panOnDrag", 3, true);
  let container;
  let containerBounds = null;
  let selectedNodeIds = /* @__PURE__ */ new Set();
  let selectedEdgeIds = /* @__PURE__ */ new Set();
  let panOnDragActive = /* @__PURE__ */ user_derived(() => store().panActivationKeyPressed || panOnDrag());
  let isSelecting = /* @__PURE__ */ user_derived(() => store().selectionKeyPressed || store().selectionRect || $$props.selectionOnDrag && get$3(panOnDragActive) !== true);
  let hasActiveSelection = /* @__PURE__ */ user_derived(() => store().elementsSelectable && (get$3(isSelecting) || store().selectionRectMode === "user"));
  let selectionInProgress = false;
  function onClick(event2) {
    var _a3;
    if (selectionInProgress || store().connection.inProgress) {
      selectionInProgress = false;
      return;
    }
    (_a3 = $$props.onpaneclick) == null ? void 0 : _a3.call($$props, { event: event2 });
    store().unselectNodesAndEdges();
    store(store().selectionRectMode = null, true);
  }
  function onPointerDown2(event2) {
    var _a3, _b2, _c2;
    containerBounds = container == null ? void 0 : container.getBoundingClientRect();
    if (!store().elementsSelectable || !get$3(isSelecting) || event2.button !== 0 || event2.target !== container || !containerBounds) {
      return;
    }
    (_b2 = (_a3 = event2.target) == null ? void 0 : _a3.setPointerCapture) == null ? void 0 : _b2.call(_a3, event2.pointerId);
    const { x: x2, y: y2 } = getEventPosition(event2, containerBounds);
    store().unselectNodesAndEdges();
    store(store().selectionRect = { width: 0, height: 0, startX: x2, startY: y2, x: x2, y: y2 }, true);
    (_c2 = $$props.onselectionstart) == null ? void 0 : _c2.call($$props, event2);
  }
  function onPointerMove(event2) {
    var _a3, _b2;
    if (!get$3(isSelecting) || !containerBounds || !store().selectionRect) {
      return;
    }
    selectionInProgress = true;
    const mousePos = getEventPosition(event2, containerBounds);
    const { startX = 0, startY = 0 } = store().selectionRect;
    const nextUserSelectRect = __spreadProps(__spreadValues({}, store().selectionRect), {
      x: mousePos.x < startX ? mousePos.x : startX,
      y: mousePos.y < startY ? mousePos.y : startY,
      width: Math.abs(mousePos.x - startX),
      height: Math.abs(mousePos.y - startY)
    });
    const prevSelectedNodeIds = selectedNodeIds;
    const prevSelectedEdgeIds = selectedEdgeIds;
    selectedNodeIds = new Set(getNodesInside(
      store().nodeLookup,
      nextUserSelectRect,
      [
        store().viewport.x,
        store().viewport.y,
        store().viewport.zoom
      ],
      store().selectionMode === SelectionMode.Partial,
      true
    ).map((n) => n.id));
    const edgesSelectable = (_a3 = store().defaultEdgeOptions.selectable) != null ? _a3 : true;
    selectedEdgeIds = /* @__PURE__ */ new Set();
    for (const nodeId of selectedNodeIds) {
      const connections = store().connectionLookup.get(nodeId);
      if (!connections) continue;
      for (const { edgeId } of connections.values()) {
        const edge = store().edgeLookup.get(edgeId);
        if (edge && ((_b2 = edge.selectable) != null ? _b2 : edgesSelectable)) {
          selectedEdgeIds.add(edgeId);
        }
      }
    }
    if (!isSetEqual(prevSelectedNodeIds, selectedNodeIds)) {
      store(store().nodes = store().nodes.map(toggleSelected(selectedNodeIds)), true);
    }
    if (!isSetEqual(prevSelectedEdgeIds, selectedEdgeIds)) {
      store(store().edges = store().edges.map(toggleSelected(selectedEdgeIds)), true);
    }
    store(store().selectionRectMode = "user", true);
    store(store().selectionRect = nextUserSelectRect, true);
  }
  function onPointerUp(event2) {
    var _a3, _b2, _c2;
    if (event2.button !== 0) {
      return;
    }
    (_b2 = (_a3 = event2.target) == null ? void 0 : _a3.releasePointerCapture) == null ? void 0 : _b2.call(_a3, event2.pointerId);
    if (!get$3(isSelecting) && store().selectionRectMode === "user" && event2.target === container) {
      onClick == null ? void 0 : onClick(event2);
    }
    store(store().selectionRect = null, true);
    if (selectedNodeIds.size > 0) {
      store(store().selectionRectMode = "nodes", true);
    }
    if (store().selectionKeyPressed) {
      selectionInProgress = false;
    }
    (_c2 = $$props.onselectionend) == null ? void 0 : _c2.call($$props, event2);
  }
  const onContextMenu = (event2) => {
    var _a3;
    if (Array.isArray(get$3(panOnDragActive)) && get$3(panOnDragActive).includes(2)) {
      event2.preventDefault();
      return;
    }
    (_a3 = $$props.onpanecontextmenu) == null ? void 0 : _a3.call($$props, { event: event2 });
  };
  var div = root$18();
  let classes;
  var event_handler = /* @__PURE__ */ user_derived(() => get$3(hasActiveSelection) ? void 0 : wrapHandler(onClick, container));
  div.__click = function(...$$args) {
    var _a3;
    (_a3 = get$3(event_handler)) == null ? void 0 : _a3.apply(this, $$args);
  };
  div.__pointerdown = function(...$$args) {
    var _a3;
    (_a3 = get$3(hasActiveSelection) ? onPointerDown2 : void 0) == null ? void 0 : _a3.apply(this, $$args);
  };
  div.__pointermove = function(...$$args) {
    var _a3;
    (_a3 = get$3(hasActiveSelection) ? onPointerMove : void 0) == null ? void 0 : _a3.apply(this, $$args);
  };
  div.__pointerup = function(...$$args) {
    var _a3;
    (_a3 = get$3(hasActiveSelection) ? onPointerUp : void 0) == null ? void 0 : _a3.apply(this, $$args);
  };
  var event_handler_1 = /* @__PURE__ */ user_derived(() => wrapHandler(onContextMenu, container));
  div.__contextmenu = function(...$$args) {
    var _a3;
    (_a3 = get$3(event_handler_1)) == null ? void 0 : _a3.apply(this, $$args);
  };
  var node = child(div);
  snippet(node, () => $$props.children);
  bind_this(div, ($$value) => container = $$value, () => container);
  template_effect(($0) => classes = set_class(div, 1, "svelte-flow__pane svelte-flow__container", null, classes, $0), [
    () => ({
      draggable: panOnDrag() === true || Array.isArray(panOnDrag()) && panOnDrag().includes(0),
      dragging: store().dragging,
      selection: get$3(isSelecting)
    })
  ]);
  append($$anchor, div);
  pop();
}
delegate([
  "click",
  "pointerdown",
  "pointermove",
  "pointerup",
  "contextmenu"
]);
var root$17 = /* @__PURE__ */ from_html(`<div class="svelte-flow__viewport xyflow__viewport svelte-flow__container"><!></div>`);
function Viewport$1($$anchor, $$props) {
  push($$props, true);
  var div = root$17();
  let styles;
  var node = child(div);
  snippet(node, () => $$props.children);
  template_effect(($0) => styles = set_style(div, "", styles, $0), [
    () => {
      var _a3, _b2, _c2;
      return {
        transform: `translate(${(_a3 = $$props.store.viewport.x) != null ? _a3 : ""}px, ${(_b2 = $$props.store.viewport.y) != null ? _b2 : ""}px) scale(${(_c2 = $$props.store.viewport.zoom) != null ? _c2 : ""})`
      };
    }
  ]);
  append($$anchor, div);
  pop();
}
function drag(domNode, params) {
  const { store, onDrag, onDragStart, onDragStop, onNodeMouseDown } = params;
  const dragInstance = XYDrag({
    onDrag,
    onDragStart,
    onDragStop,
    onNodeMouseDown,
    getStoreItems: () => {
      const { snapGrid, viewport } = store;
      return {
        nodes: store.nodes,
        nodeLookup: store.nodeLookup,
        edges: store.edges,
        nodeExtent: store.nodeExtent,
        snapGrid: snapGrid ? snapGrid : [0, 0],
        snapToGrid: !!snapGrid,
        nodeOrigin: store.nodeOrigin,
        multiSelectionActive: store.multiselectionKeyPressed,
        domNode: store.domNode,
        transform: [viewport.x, viewport.y, viewport.zoom],
        autoPanOnNodeDrag: store.autoPanOnNodeDrag,
        nodesDraggable: store.nodesDraggable,
        selectNodesOnDrag: store.selectNodesOnDrag,
        nodeDragThreshold: store.nodeDragThreshold,
        unselectNodesAndEdges: store.unselectNodesAndEdges,
        updateNodePositions: store.updateNodePositions,
        onSelectionDrag: store.onselectiondrag,
        onSelectionDragStart: store.onselectiondragstart,
        onSelectionDragStop: store.onselectiondragstop,
        panBy: store.panBy
      };
    }
  });
  function updateDrag(domNode2, params2) {
    if (params2.disabled) {
      dragInstance.destroy();
      return;
    }
    dragInstance.update({
      domNode: domNode2,
      noDragClassName: params2.noDragClass,
      handleSelector: params2.handleSelector,
      nodeId: params2.nodeId,
      isSelectable: params2.isSelectable,
      nodeClickDistance: params2.nodeClickDistance
    });
  }
  updateDrag(domNode, params);
  return {
    update(params2) {
      updateDrag(domNode, params2);
    },
    destroy() {
      dragInstance.destroy();
    }
  };
}
var root_1$J = /* @__PURE__ */ from_html(`<div aria-live="assertive" aria-atomic="true" class="a11y-live-msg svelte-13pq11u"> </div>`);
var root$16 = /* @__PURE__ */ from_html(`<div class="a11y-hidden svelte-13pq11u"> </div> <div class="a11y-hidden svelte-13pq11u"> </div> <!>`, 1);
function A11yDescriptions($$anchor, $$props) {
  push($$props, true);
  var fragment = root$16();
  var div = first_child(fragment);
  var text2 = child(div);
  var div_1 = sibling(div, 2);
  var text_1 = child(div_1);
  var node = sibling(div_1, 2);
  {
    var consequent = ($$anchor2) => {
      var div_2 = root_1$J();
      var text_2 = child(div_2);
      template_effect(() => {
        set_attribute(div_2, "id", `${ARIA_LIVE_MESSAGE}-${$$props.store.flowId}`);
        set_text(text_2, $$props.store.ariaLiveMessage);
      });
      append($$anchor2, div_2);
    };
    if_block(node, ($$render) => {
      if (!$$props.store.disableKeyboardA11y) $$render(consequent);
    });
  }
  template_effect(() => {
    set_attribute(div, "id", `${ARIA_NODE_DESC_KEY}-${$$props.store.flowId}`);
    set_text(text2, $$props.store.disableKeyboardA11y ? $$props.store.ariaLabelConfig["node.a11yDescription.default"] : $$props.store.ariaLabelConfig["node.a11yDescription.keyboardDisabled"]);
    set_attribute(div_1, "id", `${ARIA_EDGE_DESC_KEY}-${$$props.store.flowId}`);
    set_text(text_1, $$props.store.ariaLabelConfig["edge.a11yDescription.default"]);
  });
  append($$anchor, fragment);
  pop();
}
const ARIA_NODE_DESC_KEY = "svelte-flow__node-desc";
const ARIA_EDGE_DESC_KEY = "svelte-flow__edge-desc";
const ARIA_LIVE_MESSAGE = "svelte-flow__aria-live";
var root_1$I = /* @__PURE__ */ from_html(`<div><!></div>`);
function NodeWrapper($$anchor, $$props) {
  push($$props, true);
  let store = prop($$props, "store", 15);
  let data = /* @__PURE__ */ user_derived(() => fallback($$props.node.data, () => ({}), true)), selected = /* @__PURE__ */ user_derived(() => fallback($$props.node.selected, false)), _draggable = /* @__PURE__ */ user_derived(() => $$props.node.draggable), _selectable = /* @__PURE__ */ user_derived(() => $$props.node.selectable), deletable = /* @__PURE__ */ user_derived(() => fallback($$props.node.deletable, true)), _connectable = /* @__PURE__ */ user_derived(() => $$props.node.connectable), _focusable = /* @__PURE__ */ user_derived(() => $$props.node.focusable), hidden = /* @__PURE__ */ user_derived(() => fallback($$props.node.hidden, false)), dragging = /* @__PURE__ */ user_derived(() => fallback($$props.node.dragging, false)), style = /* @__PURE__ */ user_derived(() => fallback($$props.node.style, "")), className = /* @__PURE__ */ user_derived(() => $$props.node.class), type = /* @__PURE__ */ user_derived(() => fallback($$props.node.type, "default")), parentId = /* @__PURE__ */ user_derived(() => $$props.node.parentId), sourcePosition = /* @__PURE__ */ user_derived(() => $$props.node.sourcePosition), targetPosition = /* @__PURE__ */ user_derived(() => $$props.node.targetPosition), measuredWidth = /* @__PURE__ */ user_derived(() => fallback($$props.node.measured, () => ({ width: 0, height: 0 }), true).width), measuredHeight = /* @__PURE__ */ user_derived(() => fallback($$props.node.measured, () => ({ width: 0, height: 0 }), true).height), initialWidth = /* @__PURE__ */ user_derived(() => $$props.node.initialWidth), initialHeight = /* @__PURE__ */ user_derived(() => $$props.node.initialHeight), width = /* @__PURE__ */ user_derived(() => $$props.node.width), height = /* @__PURE__ */ user_derived(() => $$props.node.height), dragHandle = /* @__PURE__ */ user_derived(() => $$props.node.dragHandle), zIndex = /* @__PURE__ */ user_derived(() => fallback($$props.node.internals.z, 0)), positionX = /* @__PURE__ */ user_derived(() => $$props.node.internals.positionAbsolute.x), positionY = /* @__PURE__ */ user_derived(() => $$props.node.internals.positionAbsolute.y), userNode = /* @__PURE__ */ user_derived(() => $$props.node.internals.userNode);
  let { id: id2 } = $$props.node;
  let draggable = /* @__PURE__ */ user_derived(() => {
    var _a3;
    return (_a3 = get$3(_draggable)) != null ? _a3 : store().nodesDraggable;
  });
  let selectable = /* @__PURE__ */ user_derived(() => {
    var _a3;
    return (_a3 = get$3(_selectable)) != null ? _a3 : store().elementsSelectable;
  });
  let connectable = /* @__PURE__ */ user_derived(() => {
    var _a3;
    return (_a3 = get$3(_connectable)) != null ? _a3 : store().nodesConnectable;
  });
  let hasDimensions = /* @__PURE__ */ user_derived(() => nodeHasDimensions($$props.node));
  let hasHandleBounds = /* @__PURE__ */ user_derived(() => !!$$props.node.internals.handleBounds);
  let isInitialized = /* @__PURE__ */ user_derived(() => get$3(hasDimensions) && get$3(hasHandleBounds));
  let focusable = /* @__PURE__ */ user_derived(() => {
    var _a3;
    return (_a3 = get$3(_focusable)) != null ? _a3 : store().nodesFocusable;
  });
  function isInParentLookup(id22) {
    return store().parentLookup.has(id22);
  }
  let isParent2 = /* @__PURE__ */ user_derived(() => isInParentLookup(id2));
  let nodeRef = /* @__PURE__ */ state(null);
  let prevNodeRef = null;
  let prevType = get$3(type);
  let prevSourcePosition = get$3(sourcePosition);
  let prevTargetPosition = get$3(targetPosition);
  let NodeComponent = /* @__PURE__ */ user_derived(() => {
    var _a3;
    return (_a3 = store().nodeTypes[get$3(type)]) != null ? _a3 : DefaultNode;
  });
  let ariaLabelConfig = /* @__PURE__ */ user_derived(() => store().ariaLabelConfig);
  let connectableContext = {
    get value() {
      return get$3(connectable);
    }
  };
  setContext("svelteflow__node_connectable", connectableContext);
  setContext("svelteflow__node_id", id2);
  let nodeStyle = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    const w2 = get$3(measuredWidth) === void 0 ? (_a3 = get$3(width)) != null ? _a3 : get$3(initialWidth) : get$3(width);
    const h2 = get$3(measuredHeight) === void 0 ? (_b2 = get$3(height)) != null ? _b2 : get$3(initialHeight) : get$3(height);
    if (w2 === void 0 && h2 === void 0 && get$3(style) === void 0) {
      return void 0;
    }
    return `${get$3(style)};${w2 ? `width:${toPxString(w2)};` : ""}${h2 ? `height:${toPxString(h2)};` : ""}`;
  });
  user_effect(() => {
    const doUpdate = get$3(type) !== prevType || get$3(sourcePosition) !== prevSourcePosition || get$3(targetPosition) !== prevTargetPosition;
    if (doUpdate && get$3(nodeRef) !== null) {
      requestAnimationFrame(() => {
        if (get$3(nodeRef) !== null) {
          store().updateNodeInternals(/* @__PURE__ */ new Map([[id2, { id: id2, nodeElement: get$3(nodeRef), force: true }]]));
        }
      });
    }
    prevType = get$3(type);
    prevSourcePosition = get$3(sourcePosition);
    prevTargetPosition = get$3(targetPosition);
  });
  user_effect(() => {
    if ($$props.resizeObserver && (!get$3(isInitialized) || get$3(nodeRef) !== prevNodeRef)) {
      prevNodeRef && $$props.resizeObserver.unobserve(prevNodeRef);
      get$3(nodeRef) && $$props.resizeObserver.observe(get$3(nodeRef));
      prevNodeRef = get$3(nodeRef);
    }
  });
  onDestroy(() => {
    var _a3;
    if (prevNodeRef) {
      (_a3 = $$props.resizeObserver) == null ? void 0 : _a3.unobserve(prevNodeRef);
    }
  });
  function onSelectNodeHandler(event2) {
    var _a3;
    if (get$3(selectable) && (!store().selectNodesOnDrag || !get$3(draggable) || store().nodeDragThreshold > 0)) {
      store().handleNodeSelection(id2);
    }
    (_a3 = $$props.onnodeclick) == null ? void 0 : _a3.call($$props, { node: get$3(userNode), event: event2 });
  }
  function onKeyDown(event2) {
    if (isInputDOMNode(event2) || store().disableKeyboardA11y) {
      return;
    }
    if (elementSelectionKeys.includes(event2.key) && get$3(selectable)) {
      const unselect = event2.key === "Escape";
      store().handleNodeSelection(id2, unselect, get$3(nodeRef));
    } else if (get$3(draggable) && $$props.node.selected && Object.prototype.hasOwnProperty.call(arrowKeyDiffs, event2.key)) {
      event2.preventDefault();
      store(
        store().ariaLiveMessage = get$3(ariaLabelConfig)["node.a11yDescription.ariaLiveMessage"]({
          direction: event2.key.replace("Arrow", "").toLowerCase(),
          x: ~~$$props.node.internals.positionAbsolute.x,
          y: ~~$$props.node.internals.positionAbsolute.y
        }),
        true
      );
      store().moveSelectedNodes(arrowKeyDiffs[event2.key], event2.shiftKey ? 4 : 1);
    }
  }
  const onFocus = () => {
    var _a3, _b2, _c2;
    if (store().disableKeyboardA11y || !store().autoPanOnNodeFocus || !((_a3 = get$3(nodeRef)) == null ? void 0 : _a3.matches(":focus-visible"))) {
      return;
    }
    const { width: width2, height: height2, viewport } = store();
    const withinViewport = getNodesInside(/* @__PURE__ */ new Map([[id2, $$props.node]]), { x: 0, y: 0, width: width2, height: height2 }, [viewport.x, viewport.y, viewport.zoom], true).length > 0;
    if (!withinViewport) {
      store().setCenter($$props.node.position.x + ((_b2 = $$props.node.measured.width) != null ? _b2 : 0) / 2, $$props.node.position.y + ((_c2 = $$props.node.measured.height) != null ? _c2 : 0) / 2, { zoom: viewport.zoom });
    }
  };
  var fragment = comment$1();
  var node_1 = first_child(fragment);
  {
    var consequent = ($$anchor2) => {
      var div = root_1$I();
      attribute_effect(
        div,
        ($0, $1) => {
          var _a3;
          return __spreadProps(__spreadValues({
            "data-id": id2,
            class: [
              "svelte-flow__node",
              `svelte-flow__node-${get$3(type)}`,
              get$3(className)
            ],
            style: get$3(nodeStyle),
            onclick: onSelectNodeHandler,
            onpointerenter: $$props.onnodepointerenter ? (event2) => $$props.onnodepointerenter({ node: get$3(userNode), event: event2 }) : void 0,
            onpointerleave: $$props.onnodepointerleave ? (event2) => $$props.onnodepointerleave({ node: get$3(userNode), event: event2 }) : void 0,
            onpointermove: $$props.onnodepointermove ? (event2) => $$props.onnodepointermove({ node: get$3(userNode), event: event2 }) : void 0,
            oncontextmenu: $$props.onnodecontextmenu ? (event2) => $$props.onnodecontextmenu({ node: get$3(userNode), event: event2 }) : void 0,
            onkeydown: get$3(focusable) ? onKeyDown : void 0,
            onfocus: get$3(focusable) ? onFocus : void 0,
            tabIndex: get$3(focusable) ? 0 : void 0,
            role: (_a3 = $$props.node.ariaRole) != null ? _a3 : get$3(focusable) ? "group" : void 0,
            "aria-roledescription": "node",
            "aria-describedby": store().disableKeyboardA11y ? void 0 : `${ARIA_NODE_DESC_KEY}-${store().flowId}`
          }, $$props.node.domAttributes), {
            [CLASS]: $0,
            [STYLE]: $1
          });
        },
        [
          () => ({
            dragging: get$3(dragging),
            selected: get$3(selected),
            draggable: get$3(draggable),
            connectable: get$3(connectable),
            selectable: get$3(selectable),
            nopan: get$3(draggable),
            parent: get$3(isParent2)
          }),
          () => {
            var _a3, _b2;
            return {
              "z-index": get$3(zIndex),
              transform: `translate(${(_a3 = get$3(positionX)) != null ? _a3 : ""}px, ${(_b2 = get$3(positionY)) != null ? _b2 : ""}px)`,
              visibility: get$3(hasDimensions) ? "visible" : "hidden"
            };
          }
        ]
      );
      var node_2 = child(div);
      component(node_2, () => get$3(NodeComponent), ($$anchor3, NodeComponent_1) => {
        NodeComponent_1($$anchor3, {
          get data() {
            return get$3(data);
          },
          get id() {
            return id2;
          },
          get selected() {
            return get$3(selected);
          },
          get selectable() {
            return get$3(selectable);
          },
          get deletable() {
            return get$3(deletable);
          },
          get sourcePosition() {
            return get$3(sourcePosition);
          },
          get targetPosition() {
            return get$3(targetPosition);
          },
          get zIndex() {
            return get$3(zIndex);
          },
          get dragging() {
            return get$3(dragging);
          },
          get draggable() {
            return get$3(draggable);
          },
          get dragHandle() {
            return get$3(dragHandle);
          },
          get parentId() {
            return get$3(parentId);
          },
          get type() {
            return get$3(type);
          },
          get isConnectable() {
            return get$3(connectable);
          },
          get positionAbsoluteX() {
            return get$3(positionX);
          },
          get positionAbsoluteY() {
            return get$3(positionY);
          },
          get width() {
            return get$3(width);
          },
          get height() {
            return get$3(height);
          }
        });
      });
      action(div, ($$node, $$action_arg) => drag == null ? void 0 : drag($$node, $$action_arg), () => ({
        nodeId: id2,
        isSelectable: get$3(selectable),
        disabled: !get$3(draggable),
        handleSelector: get$3(dragHandle),
        noDragClass: store().noDragClass,
        nodeClickDistance: $$props.nodeClickDistance,
        onNodeMouseDown: store().handleNodeSelection,
        onDrag: (event2, _2, targetNode, nodes) => {
          var _a3;
          (_a3 = $$props.onnodedrag) == null ? void 0 : _a3.call($$props, { event: event2, targetNode, nodes });
        },
        onDragStart: (event2, _2, targetNode, nodes) => {
          var _a3;
          (_a3 = $$props.onnodedragstart) == null ? void 0 : _a3.call($$props, { event: event2, targetNode, nodes });
        },
        onDragStop: (event2, _2, targetNode, nodes) => {
          var _a3;
          (_a3 = $$props.onnodedragstop) == null ? void 0 : _a3.call($$props, { event: event2, targetNode, nodes });
        },
        store: store()
      }));
      bind_this(div, ($$value) => set$2(nodeRef, $$value), () => get$3(nodeRef));
      append($$anchor2, div);
    };
    if_block(node_1, ($$render) => {
      if (!get$3(hidden)) $$render(consequent);
    });
  }
  append($$anchor, fragment);
  pop();
}
var root$15 = /* @__PURE__ */ from_html(`<div class="svelte-flow__nodes"></div>`);
function NodeRenderer($$anchor, $$props) {
  push($$props, true);
  let store = prop($$props, "store", 15);
  const resizeObserver = typeof ResizeObserver === "undefined" ? null : new ResizeObserver((entries) => {
    const updates = /* @__PURE__ */ new Map();
    entries.forEach((entry) => {
      const id2 = entry.target.getAttribute("data-id");
      updates.set(id2, { id: id2, nodeElement: entry.target, force: true });
    });
    store().updateNodeInternals(updates);
  });
  onDestroy(() => {
    resizeObserver == null ? void 0 : resizeObserver.disconnect();
  });
  var div = root$15();
  each(div, 21, () => store().visible.nodes.values(), (node) => node.id, ($$anchor2, node) => {
    NodeWrapper($$anchor2, {
      get node() {
        return get$3(node);
      },
      get resizeObserver() {
        return resizeObserver;
      },
      get nodeClickDistance() {
        return $$props.nodeClickDistance;
      },
      get onnodeclick() {
        return $$props.onnodeclick;
      },
      get onnodepointerenter() {
        return $$props.onnodepointerenter;
      },
      get onnodepointermove() {
        return $$props.onnodepointermove;
      },
      get onnodepointerleave() {
        return $$props.onnodepointerleave;
      },
      get onnodedrag() {
        return $$props.onnodedrag;
      },
      get onnodedragstart() {
        return $$props.onnodedragstart;
      },
      get onnodedragstop() {
        return $$props.onnodedragstop;
      },
      get onnodecontextmenu() {
        return $$props.onnodecontextmenu;
      },
      get store() {
        return store();
      },
      set store($$value) {
        store($$value);
      }
    });
  });
  append($$anchor, div);
  pop();
}
var root_1$H = /* @__PURE__ */ from_svg(`<svg class="svelte-flow__edge-wrapper"><g><!></g></svg>`);
function EdgeWrapper($$anchor, $$props) {
  push($$props, true);
  let source2 = /* @__PURE__ */ user_derived(() => $$props.edge.source), target = /* @__PURE__ */ user_derived(() => $$props.edge.target), sourceX = /* @__PURE__ */ user_derived(() => $$props.edge.sourceX), sourceY = /* @__PURE__ */ user_derived(() => $$props.edge.sourceY), targetX = /* @__PURE__ */ user_derived(() => $$props.edge.targetX), targetY = /* @__PURE__ */ user_derived(() => $$props.edge.targetY), sourcePosition = /* @__PURE__ */ user_derived(() => $$props.edge.sourcePosition), targetPosition = /* @__PURE__ */ user_derived(() => $$props.edge.targetPosition), animated = /* @__PURE__ */ user_derived(() => fallback($$props.edge.animated, false)), selected = /* @__PURE__ */ user_derived(() => fallback($$props.edge.selected, false)), label2 = /* @__PURE__ */ user_derived(() => $$props.edge.label), labelStyle = /* @__PURE__ */ user_derived(() => $$props.edge.labelStyle), data = /* @__PURE__ */ user_derived(() => fallback($$props.edge.data, () => ({}), true)), style = /* @__PURE__ */ user_derived(() => $$props.edge.style), interactionWidth = /* @__PURE__ */ user_derived(() => $$props.edge.interactionWidth), type = /* @__PURE__ */ user_derived(() => fallback($$props.edge.type, "default")), sourceHandle = /* @__PURE__ */ user_derived(() => $$props.edge.sourceHandle), targetHandle = /* @__PURE__ */ user_derived(() => $$props.edge.targetHandle), markerStart = /* @__PURE__ */ user_derived(() => $$props.edge.markerStart), markerEnd = /* @__PURE__ */ user_derived(() => $$props.edge.markerEnd), _selectable = /* @__PURE__ */ user_derived(() => $$props.edge.selectable), _focusable = /* @__PURE__ */ user_derived(() => $$props.edge.focusable), deletable = /* @__PURE__ */ user_derived(() => fallback($$props.edge.deletable, true)), hidden = /* @__PURE__ */ user_derived(() => $$props.edge.hidden), zIndex = /* @__PURE__ */ user_derived(() => $$props.edge.zIndex), className = /* @__PURE__ */ user_derived(() => $$props.edge.class), ariaLabel = /* @__PURE__ */ user_derived(() => $$props.edge.ariaLabel);
  let edgeRef = null;
  const { id: id2 } = $$props.edge;
  setContext("svelteflow__edge_id", id2);
  let selectable = /* @__PURE__ */ user_derived(() => {
    var _a3;
    return (_a3 = get$3(_selectable)) != null ? _a3 : $$props.store.elementsSelectable;
  });
  let focusable = /* @__PURE__ */ user_derived(() => {
    var _a3;
    return (_a3 = get$3(_focusable)) != null ? _a3 : $$props.store.edgesFocusable;
  });
  let EdgeComponent = /* @__PURE__ */ user_derived(() => {
    var _a3;
    return (_a3 = $$props.store.edgeTypes[get$3(type)]) != null ? _a3 : BezierEdge;
  });
  let markerStartUrl = /* @__PURE__ */ user_derived(() => get$3(markerStart) ? `url('#${getMarkerId(get$3(markerStart), $$props.store.flowId)}')` : void 0);
  let markerEndUrl = /* @__PURE__ */ user_derived(() => get$3(markerEnd) ? `url('#${getMarkerId(get$3(markerEnd), $$props.store.flowId)}')` : void 0);
  function onclick2(event2) {
    var _a3;
    const edge = $$props.store.edgeLookup.get(id2);
    if (edge) {
      if (get$3(selectable)) $$props.store.handleEdgeSelection(id2);
      (_a3 = $$props.onedgeclick) == null ? void 0 : _a3.call($$props, { event: event2, edge });
    }
  }
  function onmouseevent(event2, callback) {
    const edge = $$props.store.edgeLookup.get(id2);
    if (edge) {
      callback({ event: event2, edge });
    }
  }
  function onkeydown(event2) {
    if (!$$props.store.disableKeyboardA11y && elementSelectionKeys.includes(event2.key) && get$3(selectable)) {
      const { unselectNodesAndEdges, addSelectedEdges } = $$props.store;
      const unselect = event2.key === "Escape";
      if (unselect) {
        edgeRef == null ? void 0 : edgeRef.blur();
        unselectNodesAndEdges({ edges: [$$props.edge] });
      } else {
        addSelectedEdges([id2]);
      }
    }
  }
  var fragment = comment$1();
  var node = first_child(fragment);
  {
    var consequent = ($$anchor2) => {
      var svg2 = root_1$H();
      let styles;
      var g = child(svg2);
      attribute_effect(
        g,
        ($0) => {
          var _a3;
          return __spreadProps(__spreadValues({
            class: ["svelte-flow__edge", get$3(className)],
            "data-id": id2,
            onclick: onclick2,
            oncontextmenu: $$props.onedgecontextmenu ? (e) => {
              onmouseevent(e, $$props.onedgecontextmenu);
            } : void 0,
            onpointerenter: $$props.onedgepointerenter ? (e) => {
              onmouseevent(e, $$props.onedgepointerenter);
            } : void 0,
            onpointerleave: $$props.onedgepointerleave ? (e) => {
              onmouseevent(e, $$props.onedgepointerleave);
            } : void 0,
            "aria-label": get$3(ariaLabel) === null ? void 0 : get$3(ariaLabel) ? get$3(ariaLabel) : `Edge from ${get$3(source2)} to ${get$3(target)}`,
            "aria-describedby": get$3(focusable) ? `${ARIA_EDGE_DESC_KEY}-${$$props.store.flowId}` : void 0,
            role: (_a3 = $$props.edge.ariaRole) != null ? _a3 : get$3(focusable) ? "group" : "img",
            "aria-roledescription": "edge",
            onkeydown: get$3(focusable) ? onkeydown : void 0,
            tabindex: get$3(focusable) ? 0 : void 0
          }, $$props.edge.domAttributes), {
            [CLASS]: $0
          });
        },
        [
          () => ({
            animated: get$3(animated),
            selected: get$3(selected),
            selectable: get$3(selectable)
          })
        ]
      );
      var node_1 = child(g);
      component(node_1, () => get$3(EdgeComponent), ($$anchor3, EdgeComponent_1) => {
        EdgeComponent_1($$anchor3, {
          get id() {
            return id2;
          },
          get source() {
            return get$3(source2);
          },
          get target() {
            return get$3(target);
          },
          get sourceX() {
            return get$3(sourceX);
          },
          get sourceY() {
            return get$3(sourceY);
          },
          get targetX() {
            return get$3(targetX);
          },
          get targetY() {
            return get$3(targetY);
          },
          get sourcePosition() {
            return get$3(sourcePosition);
          },
          get targetPosition() {
            return get$3(targetPosition);
          },
          get animated() {
            return get$3(animated);
          },
          get selected() {
            return get$3(selected);
          },
          get label() {
            return get$3(label2);
          },
          get labelStyle() {
            return get$3(labelStyle);
          },
          get data() {
            return get$3(data);
          },
          get style() {
            return get$3(style);
          },
          get interactionWidth() {
            return get$3(interactionWidth);
          },
          get selectable() {
            return get$3(selectable);
          },
          get deletable() {
            return get$3(deletable);
          },
          get type() {
            return get$3(type);
          },
          get sourceHandleId() {
            return get$3(sourceHandle);
          },
          get targetHandleId() {
            return get$3(targetHandle);
          },
          get markerStart() {
            return get$3(markerStartUrl);
          },
          get markerEnd() {
            return get$3(markerEndUrl);
          }
        });
      });
      bind_this(g, ($$value) => edgeRef = $$value, () => edgeRef);
      template_effect(($0) => styles = set_style(svg2, "", styles, $0), [() => ({ "z-index": get$3(zIndex) })]);
      append($$anchor2, svg2);
    };
    if_block(node, ($$render) => {
      if (!get$3(hidden)) $$render(consequent);
    });
  }
  append($$anchor, fragment);
  pop();
}
var root$14 = /* @__PURE__ */ from_svg(`<defs></defs>`);
function MarkerDefinition($$anchor, $$props) {
  push($$props, true);
  const store = useStore();
  var defs = root$14();
  each(defs, 21, () => store.markers, (marker) => marker.id, ($$anchor2, marker) => {
    Marker($$anchor2, spread_props(() => get$3(marker)));
  });
  append($$anchor, defs);
  pop();
}
var root_1$G = /* @__PURE__ */ from_svg(`<polyline class="arrow" fill="none" stroke-linecap="round" stroke-linejoin="round" points="-5,-4 0,0 -5,4"></polyline>`);
var root_3$q = /* @__PURE__ */ from_svg(`<polyline class="arrowclosed" stroke-linecap="round" stroke-linejoin="round" points="-5,-4 0,0 -5,4 -5,-4"></polyline>`);
var root$13 = /* @__PURE__ */ from_svg(`<marker class="svelte-flow__arrowhead" viewBox="-10 -10 20 20" refX="0" refY="0"><!></marker>`);
function Marker($$anchor, $$props) {
  push($$props, true);
  let width = prop($$props, "width", 3, 12.5), height = prop($$props, "height", 3, 12.5), markerUnits = prop($$props, "markerUnits", 3, "strokeWidth"), orient = prop($$props, "orient", 3, "auto-start-reverse"), color2 = prop($$props, "color", 3, "none");
  var marker = root$13();
  var node = child(marker);
  {
    var consequent = ($$anchor2) => {
      var polyline = root_1$G();
      let styles;
      template_effect(
        ($0) => {
          set_attribute(polyline, "stroke-width", $$props.strokeWidth);
          styles = set_style(polyline, "", styles, $0);
        },
        [() => ({ stroke: color2() })]
      );
      append($$anchor2, polyline);
    };
    var alternate = ($$anchor2) => {
      var fragment = comment$1();
      var node_1 = first_child(fragment);
      {
        var consequent_1 = ($$anchor3) => {
          var polyline_1 = root_3$q();
          let styles_1;
          template_effect(
            ($0) => {
              set_attribute(polyline_1, "stroke-width", $$props.strokeWidth);
              styles_1 = set_style(polyline_1, "", styles_1, $0);
            },
            [() => ({ stroke: color2(), fill: color2() })]
          );
          append($$anchor3, polyline_1);
        };
        if_block(
          node_1,
          ($$render) => {
            if ($$props.type === MarkerType.ArrowClosed) $$render(consequent_1);
          },
          true
        );
      }
      append($$anchor2, fragment);
    };
    if_block(node, ($$render) => {
      if ($$props.type === MarkerType.Arrow) $$render(consequent);
      else $$render(alternate, false);
    });
  }
  template_effect(() => {
    set_attribute(marker, "id", $$props.id);
    set_attribute(marker, "markerWidth", `${width()}`);
    set_attribute(marker, "markerHeight", `${height()}`);
    set_attribute(marker, "markerUnits", markerUnits());
    set_attribute(marker, "orient", orient());
  });
  append($$anchor, marker);
  pop();
}
var root$12 = /* @__PURE__ */ from_html(`<div class="svelte-flow__edges"><svg class="svelte-flow__marker"><!></svg> <!></div>`);
function EdgeRenderer($$anchor, $$props) {
  push($$props, true);
  let store = prop($$props, "store", 15);
  var div = root$12();
  var svg2 = child(div);
  var node = child(svg2);
  MarkerDefinition(node, {});
  var node_1 = sibling(svg2, 2);
  each(node_1, 17, () => store().visible.edges.values(), (edge) => edge.id, ($$anchor2, edge) => {
    EdgeWrapper($$anchor2, {
      get edge() {
        return get$3(edge);
      },
      get onedgeclick() {
        return $$props.onedgeclick;
      },
      get onedgecontextmenu() {
        return $$props.onedgecontextmenu;
      },
      get onedgepointerenter() {
        return $$props.onedgepointerenter;
      },
      get onedgepointerleave() {
        return $$props.onedgepointerleave;
      },
      get store() {
        return store();
      },
      set store($$value) {
        store($$value);
      }
    });
  });
  append($$anchor, div);
  pop();
}
var root_1$F = /* @__PURE__ */ from_html(`<div class="svelte-flow__selection svelte-1vr3gfi"></div>`);
function Selection($$anchor, $$props) {
  push($$props, true);
  let x2 = prop($$props, "x", 3, 0), y2 = prop($$props, "y", 3, 0), width = prop($$props, "width", 3, 0), height = prop($$props, "height", 3, 0), isVisible = prop($$props, "isVisible", 3, true);
  var fragment = comment$1();
  var node = first_child(fragment);
  {
    var consequent = ($$anchor2) => {
      var div = root_1$F();
      let styles;
      template_effect(($0) => styles = set_style(div, "", styles, $0), [
        () => ({
          width: typeof width() === "string" ? width() : toPxString(width()),
          height: typeof height() === "string" ? height() : toPxString(height()),
          transform: `translate(${x2()}px, ${y2()}px)`
        })
      ]);
      append($$anchor2, div);
    };
    if_block(node, ($$render) => {
      if (isVisible()) $$render(consequent);
    });
  }
  append($$anchor, fragment);
  pop();
}
function oncontextmenu(event2, $$props) {
  var _a3;
  const selectedNodes = $$props.store.nodes.filter((n) => n.selected);
  (_a3 = $$props.onselectioncontextmenu) == null ? void 0 : _a3.call($$props, { nodes: selectedNodes, event: event2 });
}
function onclick(event2, $$props) {
  var _a3;
  const selectedNodes = $$props.store.nodes.filter((n) => n.selected);
  (_a3 = $$props.onselectionclick) == null ? void 0 : _a3.call($$props, { nodes: selectedNodes, event: event2 });
}
var root_1$E = /* @__PURE__ */ from_html(`<div><!></div>`);
function NodeSelection($$anchor, $$props) {
  push($$props, true);
  let ref = /* @__PURE__ */ state(void 0);
  user_effect(() => {
    var _a3;
    if (!$$props.store.disableKeyboardA11y) {
      (_a3 = get$3(ref)) == null ? void 0 : _a3.focus({ preventScroll: true });
    }
  });
  let bounds = /* @__PURE__ */ user_derived(() => {
    if ($$props.store.selectionRectMode === "nodes") {
      $$props.store.nodes;
      return getInternalNodesBounds($$props.store.nodeLookup, { filter: (node) => !!node.selected });
    }
    return null;
  });
  function onkeydown(event2) {
    if (Object.prototype.hasOwnProperty.call(arrowKeyDiffs, event2.key)) {
      event2.preventDefault();
      $$props.store.moveSelectedNodes(arrowKeyDiffs[event2.key], event2.shiftKey ? 4 : 1);
    }
  }
  var fragment = comment$1();
  var node_1 = first_child(fragment);
  {
    var consequent = ($$anchor2) => {
      var div = root_1$E();
      div.__contextmenu = [oncontextmenu, $$props];
      div.__click = [onclick, $$props];
      div.__keydown = function(...$$args) {
        var _a3;
        (_a3 = $$props.store.disableKeyboardA11y ? void 0 : onkeydown) == null ? void 0 : _a3.apply(this, $$args);
      };
      let styles;
      var node_2 = child(div);
      Selection(node_2, { width: "100%", height: "100%", x: 0, y: 0 });
      action(div, ($$node, $$action_arg) => drag == null ? void 0 : drag($$node, $$action_arg), () => ({
        disabled: false,
        store: $$props.store,
        onDrag: (event2, _2, __, nodes) => {
          var _a3;
          (_a3 = $$props.onnodedrag) == null ? void 0 : _a3.call($$props, { event: event2, targetNode: null, nodes });
        },
        onDragStart: (event2, _2, __, nodes) => {
          var _a3;
          (_a3 = $$props.onnodedragstart) == null ? void 0 : _a3.call($$props, { event: event2, targetNode: null, nodes });
        },
        onDragStop: (event2, _2, __, nodes) => {
          var _a3;
          (_a3 = $$props.onnodedragstop) == null ? void 0 : _a3.call($$props, { event: event2, targetNode: null, nodes });
        }
      }));
      bind_this(div, ($$value) => set$2(ref, $$value), () => get$3(ref));
      template_effect(
        ($0) => {
          set_class(div, 1, clsx(["svelte-flow__selection-wrapper", $$props.store.noPanClass]), "svelte-sf2y5e");
          set_attribute(div, "role", $$props.store.disableKeyboardA11y ? void 0 : "button");
          set_attribute(div, "tabindex", $$props.store.disableKeyboardA11y ? void 0 : -1);
          styles = set_style(div, "", styles, $0);
        },
        [
          () => {
            var _a3, _b2;
            return {
              width: toPxString(get$3(bounds).width),
              height: toPxString(get$3(bounds).height),
              transform: `translate(${(_a3 = get$3(bounds).x) != null ? _a3 : ""}px, ${(_b2 = get$3(bounds).y) != null ? _b2 : ""}px)`
            };
          }
        ]
      );
      append($$anchor2, div);
    };
    if_block(node_1, ($$render) => {
      if ($$props.store.selectionRectMode === "nodes" && get$3(bounds) && isNumeric(get$3(bounds).x) && isNumeric(get$3(bounds).y)) $$render(consequent);
    });
  }
  append($$anchor, fragment);
  pop();
}
delegate(["contextmenu", "click", "keydown"]);
function mapModifierToBitMask(def) {
  switch (def) {
    case "ctrl":
      return 8;
    case "shift":
      return 4;
    case "alt":
      return 2;
    case "meta":
      return 1;
  }
}
function shortcut(node, param) {
  let { enabled = true, trigger, type = "keydown" } = param;
  function handler(event2) {
    var _a3;
    const normalizedTriggers = Array.isArray(trigger) ? trigger : [trigger];
    const modifierMask = [event2.metaKey, event2.altKey, event2.shiftKey, event2.ctrlKey].reduce(
      (acc, value, index2) => {
        if (value) {
          return acc | 1 << index2;
        }
        return acc;
      },
      0
    );
    for (const trigger2 of normalizedTriggers) {
      const mergedTrigger = __spreadValues({
        preventDefault: false,
        enabled: true
      }, trigger2);
      const { modifier, key: key2, callback, preventDefault, enabled: triggerEnabled } = mergedTrigger;
      if (triggerEnabled) {
        if (event2.key !== key2) continue;
        if (modifier === null || modifier === false) {
          if (modifierMask !== 0) continue;
        } else if (modifier !== void 0 && ((_a3 = modifier == null ? void 0 : modifier[0]) == null ? void 0 : _a3.length) > 0) {
          const orDefs = Array.isArray(modifier) ? modifier : [modifier];
          let modified = false;
          for (const orDef of orDefs) {
            const mask = (Array.isArray(orDef) ? orDef : [orDef]).reduce(
              (acc, def) => acc | mapModifierToBitMask(def),
              0
            );
            if (mask === modifierMask) {
              modified = true;
              break;
            }
          }
          if (!modified) continue;
        }
        if (preventDefault) event2.preventDefault();
        const detail = {
          node,
          trigger: mergedTrigger,
          originalEvent: event2
        };
        node.dispatchEvent(new CustomEvent("shortcut", { detail }));
        callback == null ? void 0 : callback(detail);
      }
    }
  }
  let off;
  if (enabled) {
    off = on(node, type, handler);
  }
  return {
    update: (update2) => {
      const { enabled: newEnabled = true, type: newType = "keydown" } = update2;
      if (enabled && (!newEnabled || type !== newType)) {
        off == null ? void 0 : off();
      } else if (!enabled && newEnabled) {
        off = on(node, newType, handler);
      }
      enabled = newEnabled;
      type = newType;
      trigger = update2.trigger;
    },
    destroy: () => {
      off == null ? void 0 : off();
    }
  };
}
function useSvelteFlow() {
  const store = /* @__PURE__ */ user_derived(useStore);
  const getNodeRect = (node) => {
    var _a3, _b2, _c2, _d2;
    const nodeToUse = isNode(node) ? node : get$3(store).nodeLookup.get(node.id);
    const position = nodeToUse.parentId ? evaluateAbsolutePosition(nodeToUse.position, nodeToUse.measured, nodeToUse.parentId, get$3(store).nodeLookup, get$3(store).nodeOrigin) : nodeToUse.position;
    const nodeWithPosition = __spreadProps(__spreadValues({}, nodeToUse), {
      position,
      width: (_b2 = (_a3 = nodeToUse.measured) == null ? void 0 : _a3.width) != null ? _b2 : nodeToUse.width,
      height: (_d2 = (_c2 = nodeToUse.measured) == null ? void 0 : _c2.height) != null ? _d2 : nodeToUse.height
    });
    return nodeToRect(nodeWithPosition);
  };
  function updateNode(id2, nodeUpdate, options2 = { replace: false }) {
    get$3(store).nodes = untrack(() => get$3(store).nodes).map((node) => {
      if (node.id === id2) {
        const nextNode = typeof nodeUpdate === "function" ? nodeUpdate(node) : nodeUpdate;
        return (options2 == null ? void 0 : options2.replace) && isNode(nextNode) ? nextNode : __spreadValues(__spreadValues({}, node), nextNode);
      }
      return node;
    });
  }
  function updateEdge(id2, edgeUpdate, options2 = { replace: false }) {
    get$3(store).edges = untrack(() => get$3(store).edges).map((edge) => {
      if (edge.id === id2) {
        const nextEdge = typeof edgeUpdate === "function" ? edgeUpdate(edge) : edgeUpdate;
        return options2.replace && isEdge(nextEdge) ? nextEdge : __spreadValues(__spreadValues({}, edge), nextEdge);
      }
      return edge;
    });
  }
  const getInternalNode = (id2) => get$3(store).nodeLookup.get(id2);
  return {
    zoomIn: get$3(store).zoomIn,
    zoomOut: get$3(store).zoomOut,
    getInternalNode,
    getNode: (id2) => {
      var _a3;
      return (_a3 = getInternalNode(id2)) == null ? void 0 : _a3.internals.userNode;
    },
    getNodes: (ids) => ids === void 0 ? get$3(store).nodes : getElements(get$3(store).nodeLookup, ids),
    getEdge: (id2) => get$3(store).edgeLookup.get(id2),
    getEdges: (ids) => ids === void 0 ? get$3(store).edges : getElements(get$3(store).edgeLookup, ids),
    setZoom: (zoomLevel, options2) => {
      const panZoom = get$3(store).panZoom;
      return panZoom ? panZoom.scaleTo(zoomLevel, { duration: options2 == null ? void 0 : options2.duration }) : Promise.resolve(false);
    },
    getZoom: () => get$3(store).viewport.zoom,
    setViewport: (nextViewport, options2) => __async(null, null, function* () {
      var _a3, _b2, _c2;
      const currentViewport = get$3(store).viewport;
      if (!get$3(store).panZoom) {
        return Promise.resolve(false);
      }
      yield get$3(store).panZoom.setViewport(
        {
          x: (_a3 = nextViewport.x) != null ? _a3 : currentViewport.x,
          y: (_b2 = nextViewport.y) != null ? _b2 : currentViewport.y,
          zoom: (_c2 = nextViewport.zoom) != null ? _c2 : currentViewport.zoom
        },
        options2
      );
      return Promise.resolve(true);
    }),
    getViewport: () => snapshot(get$3(store).viewport),
    setCenter: (x2, y2, options2) => __async(null, null, function* () {
      return get$3(store).setCenter(x2, y2, options2);
    }),
    fitView: (options2) => get$3(store).fitView(options2),
    fitBounds: (bounds, options2) => __async(null, null, function* () {
      var _a3;
      if (!get$3(store).panZoom) {
        return Promise.resolve(false);
      }
      const viewport = getViewportForBounds(bounds, get$3(store).width, get$3(store).height, get$3(store).minZoom, get$3(store).maxZoom, (_a3 = options2 == null ? void 0 : options2.padding) != null ? _a3 : 0.1);
      yield get$3(store).panZoom.setViewport(viewport, {
        duration: options2 == null ? void 0 : options2.duration,
        ease: options2 == null ? void 0 : options2.ease,
        interpolate: options2 == null ? void 0 : options2.interpolate
      });
      return Promise.resolve(true);
    }),
    getIntersectingNodes: (nodeOrRect, partially = true, nodesToIntersect) => {
      const isRect = isRectObject(nodeOrRect);
      const nodeRect = isRect ? nodeOrRect : getNodeRect(nodeOrRect);
      if (!nodeRect) {
        return [];
      }
      return (nodesToIntersect || get$3(store).nodes).filter((n) => {
        const internalNode = get$3(store).nodeLookup.get(n.id);
        if (!internalNode || !isRect && n.id === nodeOrRect.id) {
          return false;
        }
        const currNodeRect = nodeToRect(internalNode);
        const overlappingArea = getOverlappingArea(currNodeRect, nodeRect);
        const partiallyVisible = partially && overlappingArea > 0;
        return partiallyVisible || overlappingArea >= currNodeRect.width * currNodeRect.height || overlappingArea >= nodeRect.width * nodeRect.height;
      });
    },
    isNodeIntersecting: (nodeOrRect, area, partially = true) => {
      const isRect = isRectObject(nodeOrRect);
      const nodeRect = isRect ? nodeOrRect : getNodeRect(nodeOrRect);
      if (!nodeRect) {
        return false;
      }
      const overlappingArea = getOverlappingArea(nodeRect, area);
      const partiallyVisible = partially && overlappingArea > 0;
      return partiallyVisible || overlappingArea >= nodeRect.width * nodeRect.height;
    },
    deleteElements: (_0) => __async(null, [_0], function* ({ nodes: nodesToRemove = [], edges: edgesToRemove = [] }) {
      var _a3, _b2;
      const { nodes: matchingNodes2, edges: matchingEdges } = yield getElementsToRemove({
        nodesToRemove,
        edgesToRemove,
        nodes: get$3(store).nodes,
        edges: get$3(store).edges,
        onBeforeDelete: get$3(store).onbeforedelete
      });
      if (matchingNodes2) {
        get$3(store).nodes = untrack(() => get$3(store).nodes).filter((node) => !matchingNodes2.some(({ id: id2 }) => id2 === node.id));
      }
      if (matchingEdges) {
        get$3(store).edges = untrack(() => get$3(store).edges).filter((edge) => !matchingEdges.some(({ id: id2 }) => id2 === edge.id));
      }
      if (matchingNodes2.length > 0 || matchingEdges.length > 0) {
        (_b2 = (_a3 = get$3(store)).ondelete) == null ? void 0 : _b2.call(_a3, { nodes: matchingNodes2, edges: matchingEdges });
      }
      return { deletedNodes: matchingNodes2, deletedEdges: matchingEdges };
    }),
    screenToFlowPosition: (position, options2 = { snapToGrid: true }) => {
      if (!get$3(store).domNode) {
        return position;
      }
      const _snapGrid = options2.snapToGrid ? get$3(store).snapGrid : false;
      const { x: x2, y: y2, zoom: zoom2 } = get$3(store).viewport;
      const { x: domX, y: domY } = get$3(store).domNode.getBoundingClientRect();
      const correctedPosition = { x: position.x - domX, y: position.y - domY };
      return pointToRendererPoint(correctedPosition, [x2, y2, zoom2], _snapGrid !== null, _snapGrid || [1, 1]);
    },
    /**
     *
     * @param position
     * @returns
     */
    flowToScreenPosition: (position) => {
      if (!get$3(store).domNode) {
        return position;
      }
      const { x: x2, y: y2, zoom: zoom2 } = get$3(store).viewport;
      const { x: domX, y: domY } = get$3(store).domNode.getBoundingClientRect();
      const rendererPosition = rendererPointToPoint(position, [x2, y2, zoom2]);
      return { x: rendererPosition.x + domX, y: rendererPosition.y + domY };
    },
    toObject: () => {
      return structuredClone({
        nodes: [...get$3(store).nodes],
        edges: [...get$3(store).edges],
        viewport: __spreadValues({}, get$3(store).viewport)
      });
    },
    updateNode,
    updateNodeData: (id2, dataUpdate, options2) => {
      var _a3;
      const node = (_a3 = get$3(store).nodeLookup.get(id2)) == null ? void 0 : _a3.internals.userNode;
      if (!node) {
        return;
      }
      const nextData = typeof dataUpdate === "function" ? dataUpdate(node) : dataUpdate;
      updateNode(id2, (node2) => __spreadProps(__spreadValues({}, node2), {
        data: (options2 == null ? void 0 : options2.replace) ? nextData : __spreadValues(__spreadValues({}, node2.data), nextData)
      }));
    },
    updateEdge,
    getNodesBounds: (nodes) => {
      return getNodesBounds(nodes, {
        nodeLookup: get$3(store).nodeLookup,
        nodeOrigin: get$3(store).nodeOrigin
      });
    },
    getHandleConnections: ({ type, id: id2, nodeId }) => {
      var _a3, _b2;
      return Array.from((_b2 = (_a3 = get$3(store).connectionLookup.get(`${nodeId}-${type}-${id2 != null ? id2 : null}`)) == null ? void 0 : _a3.values()) != null ? _b2 : []);
    }
  };
}
function getElements(lookup, ids) {
  var _a3;
  const result = [];
  for (const id2 of ids) {
    const item = lookup.get(id2);
    if (item) {
      const element = "internals" in item ? (_a3 = item.internals) == null ? void 0 : _a3.userNode : item;
      result.push(element);
    }
  }
  return result;
}
function KeyHandler($$anchor, $$props) {
  push($$props, true);
  let store = prop($$props, "store", 15), selectionKey = prop($$props, "selectionKey", 3, "Shift"), multiSelectionKey = prop($$props, "multiSelectionKey", 19, () => isMacOs() ? "Meta" : "Control"), deleteKey = prop($$props, "deleteKey", 3, "Backspace"), panActivationKey = prop($$props, "panActivationKey", 3, " "), zoomActivationKey = prop($$props, "zoomActivationKey", 19, () => isMacOs() ? "Meta" : "Control");
  let { deleteElements } = useSvelteFlow();
  function isKeyObject(key2) {
    return key2 !== null && typeof key2 === "object";
  }
  function getModifier(key2) {
    return isKeyObject(key2) ? key2.modifier || [] : [];
  }
  function getKeyString(key2) {
    if (key2 === null || key2 === void 0) {
      return "";
    }
    return isKeyObject(key2) ? key2.key : key2;
  }
  function getShortcutTrigger(key2, callback) {
    const keys = Array.isArray(key2) ? key2 : [key2];
    return keys.map((_key) => {
      const keyString = getKeyString(_key);
      return {
        key: keyString,
        modifier: getModifier(_key),
        enabled: keyString !== null,
        callback
      };
    });
  }
  function resetKeysAndSelection() {
    store(store().selectionRect = null, true);
    store(store().selectionKeyPressed = false, true);
    store(store().multiselectionKeyPressed = false, true);
    store(store().deleteKeyPressed = false, true);
    store(store().panActivationKeyPressed = false, true);
    store(store().zoomActivationKeyPressed = false, true);
  }
  function handleDelete() {
    const selectedNodes = store().nodes.filter((node) => node.selected);
    const selectedEdges = store().edges.filter((edge) => edge.selected);
    deleteElements({ nodes: selectedNodes, edges: selectedEdges });
  }
  event("blur", $window, resetKeysAndSelection);
  event("contextmenu", $window, resetKeysAndSelection);
  action($window, ($$node, $$action_arg) => shortcut == null ? void 0 : shortcut($$node, $$action_arg), () => ({
    trigger: getShortcutTrigger(selectionKey(), () => store(store().selectionKeyPressed = true, true)),
    type: "keydown"
  }));
  action($window, ($$node, $$action_arg) => shortcut == null ? void 0 : shortcut($$node, $$action_arg), () => ({
    trigger: getShortcutTrigger(selectionKey(), () => store(store().selectionKeyPressed = false, true)),
    type: "keyup"
  }));
  action($window, ($$node, $$action_arg) => shortcut == null ? void 0 : shortcut($$node, $$action_arg), () => ({
    trigger: getShortcutTrigger(multiSelectionKey(), () => {
      store(store().multiselectionKeyPressed = true, true);
    }),
    type: "keydown"
  }));
  action($window, ($$node, $$action_arg) => shortcut == null ? void 0 : shortcut($$node, $$action_arg), () => ({
    trigger: getShortcutTrigger(multiSelectionKey(), () => store(store().multiselectionKeyPressed = false, true)),
    type: "keyup"
  }));
  action($window, ($$node, $$action_arg) => shortcut == null ? void 0 : shortcut($$node, $$action_arg), () => ({
    trigger: getShortcutTrigger(deleteKey(), (detail) => {
      const isModifierKey = detail.originalEvent.ctrlKey || detail.originalEvent.metaKey || detail.originalEvent.shiftKey;
      if (!isModifierKey && !isInputDOMNode(detail.originalEvent)) {
        store(store().deleteKeyPressed = true, true);
        handleDelete();
      }
    }),
    type: "keydown"
  }));
  action($window, ($$node, $$action_arg) => shortcut == null ? void 0 : shortcut($$node, $$action_arg), () => ({
    trigger: getShortcutTrigger(deleteKey(), () => store(store().deleteKeyPressed = false, true)),
    type: "keyup"
  }));
  action($window, ($$node, $$action_arg) => shortcut == null ? void 0 : shortcut($$node, $$action_arg), () => ({
    trigger: getShortcutTrigger(panActivationKey(), () => store(store().panActivationKeyPressed = true, true)),
    type: "keydown"
  }));
  action($window, ($$node, $$action_arg) => shortcut == null ? void 0 : shortcut($$node, $$action_arg), () => ({
    trigger: getShortcutTrigger(panActivationKey(), () => store(store().panActivationKeyPressed = false, true)),
    type: "keyup"
  }));
  action($window, ($$node, $$action_arg) => shortcut == null ? void 0 : shortcut($$node, $$action_arg), () => ({
    trigger: getShortcutTrigger(zoomActivationKey(), () => store(store().zoomActivationKeyPressed = true, true)),
    type: "keydown"
  }));
  action($window, ($$node, $$action_arg) => shortcut == null ? void 0 : shortcut($$node, $$action_arg), () => ({
    trigger: getShortcutTrigger(zoomActivationKey(), () => store(store().zoomActivationKeyPressed = false, true)),
    type: "keyup"
  }));
  pop();
}
var root_3$p = /* @__PURE__ */ from_svg(`<path fill="none" class="svelte-flow__connection-path"></path>`);
var root_1$D = /* @__PURE__ */ from_svg(`<svg class="svelte-flow__connectionline"><g><!></g></svg>`);
function ConnectionLine$1($$anchor, $$props) {
  push($$props, true);
  let path = /* @__PURE__ */ user_derived(() => {
    if (!$$props.store.connection.inProgress) {
      return "";
    }
    const pathParams = {
      sourceX: $$props.store.connection.from.x,
      sourceY: $$props.store.connection.from.y,
      sourcePosition: $$props.store.connection.fromPosition,
      targetX: $$props.store.connection.to.x,
      targetY: $$props.store.connection.to.y,
      targetPosition: $$props.store.connection.toPosition
    };
    switch ($$props.type) {
      case ConnectionLineType.Bezier: {
        const [path2] = getBezierPath(pathParams);
        return path2;
      }
      case ConnectionLineType.Straight: {
        const [path2] = getStraightPath(pathParams);
        return path2;
      }
      case ConnectionLineType.Step:
      case ConnectionLineType.SmoothStep: {
        const [path2] = getSmoothStepPath(__spreadProps(__spreadValues({}, pathParams), {
          borderRadius: $$props.type === ConnectionLineType.Step ? 0 : void 0
        }));
        return path2;
      }
    }
  });
  var fragment = comment$1();
  var node = first_child(fragment);
  {
    var consequent_1 = ($$anchor2) => {
      var svg2 = root_1$D();
      var g = child(svg2);
      var node_1 = child(g);
      {
        var consequent = ($$anchor3) => {
          var fragment_1 = comment$1();
          var node_2 = first_child(fragment_1);
          component(node_2, () => $$props.LineComponent, ($$anchor4, LineComponent_1) => {
            LineComponent_1($$anchor4, {});
          });
          append($$anchor3, fragment_1);
        };
        var alternate = ($$anchor3) => {
          var path_1 = root_3$p();
          template_effect(() => {
            set_attribute(path_1, "d", get$3(path));
            set_style(path_1, $$props.style);
          });
          append($$anchor3, path_1);
        };
        if_block(node_1, ($$render) => {
          if ($$props.LineComponent) $$render(consequent);
          else $$render(alternate, false);
        });
      }
      template_effect(
        ($0) => {
          set_attribute(svg2, "width", $$props.store.width);
          set_attribute(svg2, "height", $$props.store.height);
          set_style(svg2, $$props.containerStyle);
          set_class(g, 0, $0);
        },
        [
          () => clsx([
            "svelte-flow__connection",
            getConnectionStatus($$props.store.connection.isValid)
          ])
        ]
      );
      append($$anchor2, svg2);
    };
    if_block(node, ($$render) => {
      if ($$props.store.connection.inProgress) $$render(consequent_1);
    });
  }
  append($$anchor, fragment);
  pop();
}
var root$11 = /* @__PURE__ */ from_html(`<div><!></div>`);
function Panel($$anchor, $$props) {
  push($$props, true);
  let position = prop($$props, "position", 3, "top-right"), rest = /* @__PURE__ */ rest_props($$props, [
    "$$slots",
    "$$events",
    "$$legacy",
    "position",
    "style",
    "class",
    "children"
  ]);
  let positionClasses = /* @__PURE__ */ user_derived(() => `${position()}`.split("-"));
  var div = root$11();
  attribute_effect(div, ($0) => __spreadValues({ class: $0, style: $$props.style }, rest), [
    () => [
      "svelte-flow__panel",
      $$props.class,
      ...get$3(positionClasses)
    ]
  ]);
  var node = child(div);
  snippet(node, () => {
    var _a3;
    return (_a3 = $$props.children) != null ? _a3 : noop$1;
  });
  append($$anchor, div);
  pop();
}
var root_2$r = /* @__PURE__ */ from_html(`<a href="https://svelteflow.dev" target="_blank" rel="noopener noreferrer" aria-label="Svelte Flow attribution">Svelte Flow</a>`);
function Attribution($$anchor, $$props) {
  push($$props, true);
  let position = prop($$props, "position", 3, "bottom-right");
  var fragment = comment$1();
  var node = first_child(fragment);
  {
    var consequent = ($$anchor2) => {
      Panel($$anchor2, {
        get position() {
          return position();
        },
        class: "svelte-flow__attribution",
        "data-message": "Feel free to remove the attribution or check out how you could support us: https://svelteflow.dev/support-us",
        children: ($$anchor3, $$slotProps) => {
          var a = root_2$r();
          append($$anchor3, a);
        },
        $$slots: { default: true }
      });
    };
    if_block(node, ($$render) => {
      var _a3;
      if (!((_a3 = $$props.proOptions) == null ? void 0 : _a3.hideAttribution)) $$render(consequent);
    });
  }
  append($$anchor, fragment);
  pop();
}
var root$10 = /* @__PURE__ */ from_html(`<div><!></div>`);
function Wrapper($$anchor, $$props) {
  push($$props, true);
  let domNode = prop($$props, "domNode", 15), clientWidth = prop($$props, "clientWidth", 15), clientHeight = prop($$props, "clientHeight", 15);
  let className = /* @__PURE__ */ user_derived(() => $$props.rest.class), divAttributes = /* @__PURE__ */ user_derived(() => exclude_from_object($$props.rest, [
    "id",
    "class",
    "nodeTypes",
    "edgeTypes",
    "colorMode",
    "isValidConnection",
    "onmove",
    "onmovestart",
    "onmoveend",
    "onflowerror",
    "ondelete",
    "onbeforedelete",
    "onbeforeconnect",
    "onconnect",
    "onconnectstart",
    "onconnectend",
    "onbeforereconnect",
    "onreconnect",
    "onreconnectstart",
    "onreconnectend",
    "onclickconnectstart",
    "onclickconnectend",
    "oninit",
    "onselectionchange",
    "onselectiondragstart",
    "onselectiondrag",
    "onselectiondragstop",
    "onselectionstart",
    "onselectionend",
    "clickConnect",
    "fitView",
    "fitViewOptions",
    "nodeOrigin",
    "nodeDragThreshold",
    "connectionDragThreshold",
    "minZoom",
    "maxZoom",
    "initialViewport",
    "connectionRadius",
    "connectionMode",
    "selectionMode",
    "selectNodesOnDrag",
    "snapGrid",
    "defaultMarkerColor",
    "translateExtent",
    "nodeExtent",
    "onlyRenderVisibleElements",
    "autoPanOnConnect",
    "autoPanOnNodeDrag",
    "colorModeSSR",
    "style",
    "defaultEdgeOptions",
    "elevateNodesOnSelect",
    "elevateEdgesOnSelect",
    "nodesDraggable",
    "autoPanOnNodeFocus",
    "nodesConnectable",
    "elementsSelectable",
    "nodesFocusable",
    "edgesFocusable",
    "disableKeyboardA11y",
    "noDragClass",
    "noPanClass",
    "noWheelClass",
    "ariaLabelConfig"
  ]));
  function wrapperOnScroll(e) {
    e.currentTarget.scrollTo({ top: 0, left: 0, behavior: "auto" });
    if ($$props.rest.onscroll) {
      $$props.rest.onscroll(e);
    }
  }
  var div = root$10();
  attribute_effect(
    div,
    ($0) => __spreadProps(__spreadValues({
      class: [
        "svelte-flow",
        "svelte-flow__container",
        get$3(className),
        $$props.colorMode
      ],
      "data-testid": "svelte-flow__wrapper",
      role: "application",
      onscroll: wrapperOnScroll
    }, get$3(divAttributes)), {
      [STYLE]: $0
    }),
    [
      () => ({
        width: toPxString($$props.width),
        height: toPxString($$props.height)
      })
    ],
    void 0,
    "svelte-mkap6j"
  );
  var node = child(div);
  snippet(node, () => {
    var _a3;
    return (_a3 = $$props.children) != null ? _a3 : noop$1;
  });
  bind_this(div, ($$value) => domNode($$value), () => domNode());
  bind_element_size(div, "clientHeight", clientHeight);
  bind_element_size(div, "clientWidth", clientWidth);
  append($$anchor, div);
  pop();
}
var root_4$h = /* @__PURE__ */ from_html(`<div class="svelte-flow__viewport-back svelte-flow__container"></div> <!> <div class="svelte-flow__edge-labels svelte-flow__container"></div> <!> <!> <!> <div class="svelte-flow__viewport-front svelte-flow__container"></div>`, 1);
var root_3$o = /* @__PURE__ */ from_html(`<!> <!>`, 1);
var root_1$C = /* @__PURE__ */ from_html(`<!> <!> <!> <!> <!>`, 1);
function SvelteFlow($$anchor, $$props) {
  push($$props, true);
  let paneClickDistance = prop($$props, "paneClickDistance", 3, 1), nodeClickDistance = prop($$props, "nodeClickDistance", 3, 1), panOnScrollMode = prop($$props, "panOnScrollMode", 19, () => PanOnScrollMode.Free), preventScrolling = prop($$props, "preventScrolling", 3, true), zoomOnScroll = prop($$props, "zoomOnScroll", 3, true), zoomOnDoubleClick = prop($$props, "zoomOnDoubleClick", 3, true), zoomOnPinch = prop($$props, "zoomOnPinch", 3, true), panOnScroll = prop($$props, "panOnScroll", 3, false), panOnDrag = prop($$props, "panOnDrag", 3, true), selectionOnDrag = prop($$props, "selectionOnDrag", 3, true), connectionLineType = prop($$props, "connectionLineType", 19, () => ConnectionLineType.Bezier), nodes = prop($$props, "nodes", 31, () => proxy([])), edges = prop($$props, "edges", 31, () => proxy([])), viewport = prop($$props, "viewport", 15, void 0), props = /* @__PURE__ */ rest_props($$props, [
    "$$slots",
    "$$events",
    "$$legacy",
    "width",
    "height",
    "proOptions",
    "selectionKey",
    "deleteKey",
    "panActivationKey",
    "multiSelectionKey",
    "zoomActivationKey",
    "paneClickDistance",
    "nodeClickDistance",
    "onmovestart",
    "onmoveend",
    "onmove",
    "oninit",
    "onnodeclick",
    "onnodecontextmenu",
    "onnodedrag",
    "onnodedragstart",
    "onnodedragstop",
    "onnodepointerenter",
    "onnodepointermove",
    "onnodepointerleave",
    "onselectionclick",
    "onselectioncontextmenu",
    "onselectionstart",
    "onselectionend",
    "onedgeclick",
    "onedgecontextmenu",
    "onedgepointerenter",
    "onedgepointerleave",
    "onpaneclick",
    "onpanecontextmenu",
    "panOnScrollMode",
    "preventScrolling",
    "zoomOnScroll",
    "zoomOnDoubleClick",
    "zoomOnPinch",
    "panOnScroll",
    "panOnDrag",
    "selectionOnDrag",
    "connectionLineComponent",
    "connectionLineStyle",
    "connectionLineContainerStyle",
    "connectionLineType",
    "attributionPosition",
    "children",
    "nodes",
    "edges",
    "viewport"
  ]);
  let store = createStore({
    props,
    width: $$props.width,
    height: $$props.height,
    get nodes() {
      return nodes();
    },
    set nodes(newNodes) {
      nodes(newNodes);
    },
    get edges() {
      return edges();
    },
    set edges(newEdges) {
      edges(newEdges);
    },
    get viewport() {
      return viewport();
    },
    set viewport(newViewport) {
      viewport(newViewport);
    }
  });
  const providerContext = getContext(key);
  if (providerContext && providerContext.setStore) {
    providerContext.setStore(store);
  }
  setContext(key, {
    provider: false,
    getStore() {
      return store;
    }
  });
  user_effect(() => {
    var _a3;
    const params = { nodes: store.selectedNodes, edges: store.selectedEdges };
    (_a3 = untrack(() => $$props.onselectionchange)) == null ? void 0 : _a3(params);
    for (const handler of store.selectionChangeHandlers.values()) {
      handler(params);
    }
  });
  onDestroy(() => {
    store.reset();
  });
  Wrapper($$anchor, {
    get colorMode() {
      return store.colorMode;
    },
    get width() {
      return $$props.width;
    },
    get height() {
      return $$props.height;
    },
    get rest() {
      return props;
    },
    get domNode() {
      return store.domNode;
    },
    set domNode($$value) {
      store.domNode = $$value;
    },
    get clientWidth() {
      return store.width;
    },
    set clientWidth($$value) {
      store.width = $$value;
    },
    get clientHeight() {
      return store.height;
    },
    set clientHeight($$value) {
      store.height = $$value;
    },
    children: ($$anchor2, $$slotProps) => {
      var fragment_1 = root_1$C();
      var node = first_child(fragment_1);
      KeyHandler(node, {
        get selectionKey() {
          return $$props.selectionKey;
        },
        get deleteKey() {
          return $$props.deleteKey;
        },
        get panActivationKey() {
          return $$props.panActivationKey;
        },
        get multiSelectionKey() {
          return $$props.multiSelectionKey;
        },
        get zoomActivationKey() {
          return $$props.zoomActivationKey;
        },
        get store() {
          return store;
        },
        set store($$value) {
          store = $$value;
        }
      });
      var node_1 = sibling(node, 2);
      Zoom(node_1, {
        get panOnScrollMode() {
          return panOnScrollMode();
        },
        get preventScrolling() {
          return preventScrolling();
        },
        get zoomOnScroll() {
          return zoomOnScroll();
        },
        get zoomOnDoubleClick() {
          return zoomOnDoubleClick();
        },
        get zoomOnPinch() {
          return zoomOnPinch();
        },
        get panOnScroll() {
          return panOnScroll();
        },
        get panOnDrag() {
          return panOnDrag();
        },
        get paneClickDistance() {
          return paneClickDistance();
        },
        get onmovestart() {
          return $$props.onmovestart;
        },
        get onmove() {
          return $$props.onmove;
        },
        get onmoveend() {
          return $$props.onmoveend;
        },
        get oninit() {
          return $$props.oninit;
        },
        get store() {
          return store;
        },
        set store($$value) {
          store = $$value;
        },
        children: ($$anchor3, $$slotProps2) => {
          Pane($$anchor3, {
            get onpaneclick() {
              return $$props.onpaneclick;
            },
            get onpanecontextmenu() {
              return $$props.onpanecontextmenu;
            },
            get onselectionstart() {
              return $$props.onselectionstart;
            },
            get onselectionend() {
              return $$props.onselectionend;
            },
            get panOnDrag() {
              return panOnDrag();
            },
            get selectionOnDrag() {
              return selectionOnDrag();
            },
            get store() {
              return store;
            },
            set store($$value) {
              store = $$value;
            },
            children: ($$anchor4, $$slotProps3) => {
              var fragment_3 = root_3$o();
              var node_2 = first_child(fragment_3);
              Viewport$1(node_2, {
                get store() {
                  return store;
                },
                set store($$value) {
                  store = $$value;
                },
                children: ($$anchor5, $$slotProps4) => {
                  var fragment_4 = root_4$h();
                  var node_3 = sibling(first_child(fragment_4), 2);
                  EdgeRenderer(node_3, {
                    get onedgeclick() {
                      return $$props.onedgeclick;
                    },
                    get onedgecontextmenu() {
                      return $$props.onedgecontextmenu;
                    },
                    get onedgepointerenter() {
                      return $$props.onedgepointerenter;
                    },
                    get onedgepointerleave() {
                      return $$props.onedgepointerleave;
                    },
                    get store() {
                      return store;
                    },
                    set store($$value) {
                      store = $$value;
                    }
                  });
                  var node_4 = sibling(node_3, 4);
                  ConnectionLine$1(node_4, {
                    get type() {
                      return connectionLineType();
                    },
                    get LineComponent() {
                      return $$props.connectionLineComponent;
                    },
                    get containerStyle() {
                      return $$props.connectionLineContainerStyle;
                    },
                    get style() {
                      return $$props.connectionLineStyle;
                    },
                    get store() {
                      return store;
                    },
                    set store($$value) {
                      store = $$value;
                    }
                  });
                  var node_5 = sibling(node_4, 2);
                  NodeRenderer(node_5, {
                    get nodeClickDistance() {
                      return nodeClickDistance();
                    },
                    get onnodeclick() {
                      return $$props.onnodeclick;
                    },
                    get onnodecontextmenu() {
                      return $$props.onnodecontextmenu;
                    },
                    get onnodepointerenter() {
                      return $$props.onnodepointerenter;
                    },
                    get onnodepointermove() {
                      return $$props.onnodepointermove;
                    },
                    get onnodepointerleave() {
                      return $$props.onnodepointerleave;
                    },
                    get onnodedrag() {
                      return $$props.onnodedrag;
                    },
                    get onnodedragstart() {
                      return $$props.onnodedragstart;
                    },
                    get onnodedragstop() {
                      return $$props.onnodedragstop;
                    },
                    get store() {
                      return store;
                    },
                    set store($$value) {
                      store = $$value;
                    }
                  });
                  var node_6 = sibling(node_5, 2);
                  NodeSelection(node_6, {
                    get onselectionclick() {
                      return $$props.onselectionclick;
                    },
                    get onselectioncontextmenu() {
                      return $$props.onselectioncontextmenu;
                    },
                    get onnodedrag() {
                      return $$props.onnodedrag;
                    },
                    get onnodedragstart() {
                      return $$props.onnodedragstart;
                    },
                    get onnodedragstop() {
                      return $$props.onnodedragstop;
                    },
                    get store() {
                      return store;
                    },
                    set store($$value) {
                      store = $$value;
                    }
                  });
                  append($$anchor5, fragment_4);
                },
                $$slots: { default: true }
              });
              var node_7 = sibling(node_2, 2);
              {
                let $0 = /* @__PURE__ */ user_derived(() => !!(store.selectionRect && store.selectionRectMode === "user"));
                let $1 = /* @__PURE__ */ user_derived(() => {
                  var _a3;
                  return (_a3 = store.selectionRect) == null ? void 0 : _a3.width;
                });
                let $2 = /* @__PURE__ */ user_derived(() => {
                  var _a3;
                  return (_a3 = store.selectionRect) == null ? void 0 : _a3.height;
                });
                let $3 = /* @__PURE__ */ user_derived(() => {
                  var _a3;
                  return (_a3 = store.selectionRect) == null ? void 0 : _a3.x;
                });
                let $4 = /* @__PURE__ */ user_derived(() => {
                  var _a3;
                  return (_a3 = store.selectionRect) == null ? void 0 : _a3.y;
                });
                Selection(node_7, {
                  get isVisible() {
                    return get$3($0);
                  },
                  get width() {
                    return get$3($1);
                  },
                  get height() {
                    return get$3($2);
                  },
                  get x() {
                    return get$3($3);
                  },
                  get y() {
                    return get$3($4);
                  }
                });
              }
              append($$anchor4, fragment_3);
            },
            $$slots: { default: true }
          });
        },
        $$slots: { default: true }
      });
      var node_8 = sibling(node_1, 2);
      Attribution(node_8, {
        get proOptions() {
          return $$props.proOptions;
        },
        get position() {
          return $$props.attributionPosition;
        }
      });
      var node_9 = sibling(node_8, 2);
      A11yDescriptions(node_9, {
        get store() {
          return store;
        }
      });
      var node_10 = sibling(node_9, 2);
      snippet(node_10, () => {
        var _a3;
        return (_a3 = $$props.children) != null ? _a3 : noop$1;
      });
      append($$anchor2, fragment_1);
    },
    $$slots: { default: true }
  });
  pop();
}
function SvelteFlowProvider($$anchor, $$props) {
  push($$props, true);
  let store = /* @__PURE__ */ state(createStore({ props: {}, nodes: [], edges: [] }));
  setContext(key, {
    provider: true,
    getStore() {
      return get$3(store);
    },
    setStore: (newStore) => {
      set$2(store, newStore);
    }
  });
  onDestroy(() => {
    get$3(store).reset();
  });
  var fragment = comment$1();
  var node = first_child(fragment);
  snippet(node, () => {
    var _a3;
    return (_a3 = $$props.children) != null ? _a3 : noop$1;
  });
  append($$anchor, fragment);
  pop();
}
var root$$ = /* @__PURE__ */ from_html(`<button><!></button>`);
function ControlButton($$anchor, $$props) {
  let restProps = /* @__PURE__ */ rest_props($$props, [
    "$$slots",
    "$$events",
    "$$legacy",
    "class",
    "bgColor",
    "bgColorHover",
    "color",
    "colorHover",
    "borderColor",
    "onclick",
    "children"
  ]);
  var button = root$$();
  attribute_effect(
    button,
    ($0) => __spreadProps(__spreadValues({
      type: "button",
      onclick: $$props.onclick,
      class: ["svelte-flow__controls-button", $$props.class]
    }, restProps), {
      [STYLE]: $0
    }),
    [
      () => ({
        "--xy-controls-button-background-color-props": $$props.bgColor,
        "--xy-controls-button-background-color-hover-props": $$props.bgColorHover,
        "--xy-controls-button-color-props": $$props.color,
        "--xy-controls-button-color-hover-props": $$props.colorHover,
        "--xy-controls-button-border-color-props": $$props.borderColor
      })
    ]
  );
  var node = child(button);
  snippet(node, () => {
    var _a3;
    return (_a3 = $$props.children) != null ? _a3 : noop$1;
  });
  append($$anchor, button);
}
var root$_ = /* @__PURE__ */ from_svg(`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32"><path d="M32 18.133H18.133V32h-4.266V18.133H0v-4.266h13.867V0h4.266v13.867H32z"></path></svg>`);
function Plus($$anchor) {
  var svg2 = root$_();
  append($$anchor, svg2);
}
var root$Z = /* @__PURE__ */ from_svg(`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 5"><path d="M0 0h32v4.2H0z"></path></svg>`);
function Minus($$anchor) {
  var svg2 = root$Z();
  append($$anchor, svg2);
}
var root$Y = /* @__PURE__ */ from_svg(`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 30"><path d="M3.692 4.63c0-.53.4-.938.939-.938h5.215V0H4.708C2.13 0 0 2.054 0 4.63v5.216h3.692V4.631zM27.354 0h-5.2v3.692h5.17c.53 0 .984.4.984.939v5.215H32V4.631A4.624 4.624 0 0027.354 0zm.954 24.83c0 .532-.4.94-.939.94h-5.215v3.768h5.215c2.577 0 4.631-2.13 4.631-4.707v-5.139h-3.692v5.139zm-23.677.94c-.531 0-.939-.4-.939-.94v-5.138H0v5.139c0 2.577 2.13 4.707 4.708 4.707h5.138V25.77H4.631z"></path></svg>`);
function Fit($$anchor) {
  var svg2 = root$Y();
  append($$anchor, svg2);
}
var root$X = /* @__PURE__ */ from_svg(`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 32"><path d="M21.333 10.667H19.81V7.619C19.81 3.429 16.38 0 12.19 0 8 0 4.571 3.429 4.571 7.619v3.048H3.048A3.056 3.056 0 000 13.714v15.238A3.056 3.056 0 003.048 32h18.285a3.056 3.056 0 003.048-3.048V13.714a3.056 3.056 0 00-3.048-3.047zM12.19 24.533a3.056 3.056 0 01-3.047-3.047 3.056 3.056 0 013.047-3.048 3.056 3.056 0 013.048 3.048 3.056 3.056 0 01-3.048 3.047zm4.724-13.866H7.467V7.619c0-2.59 2.133-4.724 4.723-4.724 2.591 0 4.724 2.133 4.724 4.724v3.048z"></path></svg>`);
function Lock($$anchor) {
  var svg2 = root$X();
  append($$anchor, svg2);
}
var root$W = /* @__PURE__ */ from_svg(`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 32"><path d="M21.333 10.667H19.81V7.619C19.81 3.429 16.38 0 12.19 0c-4.114 1.828-1.37 2.133.305 2.438 1.676.305 4.42 2.59 4.42 5.181v3.048H3.047A3.056 3.056 0 000 13.714v15.238A3.056 3.056 0 003.048 32h18.285a3.056 3.056 0 003.048-3.048V13.714a3.056 3.056 0 00-3.048-3.047zM12.19 24.533a3.056 3.056 0 01-3.047-3.047 3.056 3.056 0 013.047-3.048 3.056 3.056 0 013.048 3.048 3.056 3.056 0 01-3.048 3.047z"></path></svg>`);
function Unlock($$anchor) {
  var svg2 = root$W();
  append($$anchor, svg2);
}
var root_3$n = /* @__PURE__ */ from_html(`<!> <!>`, 1);
var root_1$B = /* @__PURE__ */ from_html(`<!> <!> <!> <!> <!> <!>`, 1);
function Controls($$anchor, $$props) {
  push($$props, true);
  let position = prop($$props, "position", 3, "bottom-left"), orientation = prop($$props, "orientation", 3, "vertical"), showZoom = prop($$props, "showZoom", 3, true), showFitView = prop($$props, "showFitView", 3, true), showLock = prop($$props, "showLock", 3, true), rest = /* @__PURE__ */ rest_props($$props, [
    "$$slots",
    "$$events",
    "$$legacy",
    "position",
    "orientation",
    "showZoom",
    "showFitView",
    "showLock",
    "style",
    "class",
    "buttonBgColor",
    "buttonBgColorHover",
    "buttonColor",
    "buttonColorHover",
    "buttonBorderColor",
    "fitViewOptions",
    "children",
    "before",
    "after"
  ]);
  let store = /* @__PURE__ */ user_derived(useStore);
  const buttonProps = {
    bgColor: $$props.buttonBgColor,
    bgColorHover: $$props.buttonBgColorHover,
    color: $$props.buttonColor,
    colorHover: $$props.buttonColorHover,
    borderColor: $$props.buttonBorderColor
  };
  let isInteractive = /* @__PURE__ */ user_derived(() => get$3(store).nodesDraggable || get$3(store).nodesConnectable || get$3(store).elementsSelectable);
  let minZoomReached = /* @__PURE__ */ user_derived(() => get$3(store).viewport.zoom <= get$3(store).minZoom);
  let maxZoomReached = /* @__PURE__ */ user_derived(() => get$3(store).viewport.zoom >= get$3(store).maxZoom);
  let ariaLabelConfig = /* @__PURE__ */ user_derived(() => get$3(store).ariaLabelConfig);
  let orientationClass = /* @__PURE__ */ user_derived(() => orientation() === "horizontal" ? "horizontal" : "vertical");
  const onZoomInHandler = () => {
    get$3(store).zoomIn();
  };
  const onZoomOutHandler = () => {
    get$3(store).zoomOut();
  };
  const onFitViewHandler = () => {
    get$3(store).fitView($$props.fitViewOptions);
  };
  const onToggleInteractivity = () => {
    let interactive2 = !get$3(isInteractive);
    get$3(store).nodesDraggable = interactive2;
    get$3(store).nodesConnectable = interactive2;
    get$3(store).elementsSelectable = interactive2;
  };
  {
    let $0 = /* @__PURE__ */ user_derived(() => [
      "svelte-flow__controls",
      get$3(orientationClass),
      $$props.class
    ]);
    Panel($$anchor, spread_props(
      {
        get class() {
          return get$3($0);
        },
        get position() {
          return position();
        },
        "data-testid": "svelte-flow__controls",
        get "aria-label"() {
          return get$3(ariaLabelConfig)["controls.ariaLabel"];
        },
        get style() {
          return $$props.style;
        }
      },
      () => rest,
      {
        children: ($$anchor2, $$slotProps) => {
          var fragment_1 = root_1$B();
          var node = first_child(fragment_1);
          {
            var consequent = ($$anchor3) => {
              var fragment_2 = comment$1();
              var node_1 = first_child(fragment_2);
              snippet(node_1, () => $$props.before);
              append($$anchor3, fragment_2);
            };
            if_block(node, ($$render) => {
              if ($$props.before) $$render(consequent);
            });
          }
          var node_2 = sibling(node, 2);
          {
            var consequent_1 = ($$anchor3) => {
              var fragment_3 = root_3$n();
              var node_3 = first_child(fragment_3);
              ControlButton(node_3, spread_props(
                {
                  onclick: onZoomInHandler,
                  class: "svelte-flow__controls-zoomin",
                  get title() {
                    return get$3(ariaLabelConfig)["controls.zoomIn.ariaLabel"];
                  },
                  get "aria-label"() {
                    return get$3(ariaLabelConfig)["controls.zoomIn.ariaLabel"];
                  },
                  get disabled() {
                    return get$3(maxZoomReached);
                  }
                },
                () => buttonProps,
                {
                  children: ($$anchor4, $$slotProps2) => {
                    Plus($$anchor4);
                  },
                  $$slots: { default: true }
                }
              ));
              var node_4 = sibling(node_3, 2);
              ControlButton(node_4, spread_props(
                {
                  onclick: onZoomOutHandler,
                  class: "svelte-flow__controls-zoomout",
                  get title() {
                    return get$3(ariaLabelConfig)["controls.zoomOut.ariaLabel"];
                  },
                  get "aria-label"() {
                    return get$3(ariaLabelConfig)["controls.zoomOut.ariaLabel"];
                  },
                  get disabled() {
                    return get$3(minZoomReached);
                  }
                },
                () => buttonProps,
                {
                  children: ($$anchor4, $$slotProps2) => {
                    Minus($$anchor4);
                  },
                  $$slots: { default: true }
                }
              ));
              append($$anchor3, fragment_3);
            };
            if_block(node_2, ($$render) => {
              if (showZoom()) $$render(consequent_1);
            });
          }
          var node_5 = sibling(node_2, 2);
          {
            var consequent_2 = ($$anchor3) => {
              ControlButton($$anchor3, spread_props(
                {
                  class: "svelte-flow__controls-fitview",
                  onclick: onFitViewHandler,
                  get title() {
                    return get$3(ariaLabelConfig)["controls.fitView.ariaLabel"];
                  },
                  get "aria-label"() {
                    return get$3(ariaLabelConfig)["controls.fitView.ariaLabel"];
                  }
                },
                () => buttonProps,
                {
                  children: ($$anchor4, $$slotProps2) => {
                    Fit($$anchor4);
                  },
                  $$slots: { default: true }
                }
              ));
            };
            if_block(node_5, ($$render) => {
              if (showFitView()) $$render(consequent_2);
            });
          }
          var node_6 = sibling(node_5, 2);
          {
            var consequent_4 = ($$anchor3) => {
              ControlButton($$anchor3, spread_props(
                {
                  class: "svelte-flow__controls-interactive",
                  onclick: onToggleInteractivity,
                  get title() {
                    return get$3(ariaLabelConfig)["controls.interactive.ariaLabel"];
                  },
                  get "aria-label"() {
                    return get$3(ariaLabelConfig)["controls.interactive.ariaLabel"];
                  }
                },
                () => buttonProps,
                {
                  children: ($$anchor4, $$slotProps2) => {
                    var fragment_9 = comment$1();
                    var node_7 = first_child(fragment_9);
                    {
                      var consequent_3 = ($$anchor5) => {
                        Unlock($$anchor5);
                      };
                      var alternate = ($$anchor5) => {
                        Lock($$anchor5);
                      };
                      if_block(node_7, ($$render) => {
                        if (get$3(isInteractive)) $$render(consequent_3);
                        else $$render(alternate, false);
                      });
                    }
                    append($$anchor4, fragment_9);
                  },
                  $$slots: { default: true }
                }
              ));
            };
            if_block(node_6, ($$render) => {
              if (showLock()) $$render(consequent_4);
            });
          }
          var node_8 = sibling(node_6, 2);
          {
            var consequent_5 = ($$anchor3) => {
              var fragment_12 = comment$1();
              var node_9 = first_child(fragment_12);
              snippet(node_9, () => $$props.children);
              append($$anchor3, fragment_12);
            };
            if_block(node_8, ($$render) => {
              if ($$props.children) $$render(consequent_5);
            });
          }
          var node_10 = sibling(node_8, 2);
          {
            var consequent_6 = ($$anchor3) => {
              var fragment_13 = comment$1();
              var node_11 = first_child(fragment_13);
              snippet(node_11, () => $$props.after);
              append($$anchor3, fragment_13);
            };
            if_block(node_10, ($$render) => {
              if ($$props.after) $$render(consequent_6);
            });
          }
          append($$anchor2, fragment_1);
        },
        $$slots: { default: true }
      }
    ));
  }
  pop();
}
var BackgroundVariant;
(function(BackgroundVariant2) {
  BackgroundVariant2["Lines"] = "lines";
  BackgroundVariant2["Dots"] = "dots";
  BackgroundVariant2["Cross"] = "cross";
})(BackgroundVariant || (BackgroundVariant = {}));
var root$V = /* @__PURE__ */ from_svg(`<circle></circle>`);
function DotPattern($$anchor, $$props) {
  var circle = root$V();
  template_effect(() => {
    set_attribute(circle, "cx", $$props.radius);
    set_attribute(circle, "cy", $$props.radius);
    set_attribute(circle, "r", $$props.radius);
    set_class(circle, 0, clsx(["svelte-flow__background-pattern", "dots", $$props.class]));
  });
  append($$anchor, circle);
}
var root$U = /* @__PURE__ */ from_svg(`<path></path>`);
function LinePattern($$anchor, $$props) {
  push($$props, true);
  var path = root$U();
  template_effect(() => {
    set_attribute(path, "stroke-width", $$props.lineWidth);
    set_attribute(path, "d", `M${$$props.dimensions[0] / 2} 0 V${$$props.dimensions[1]} M0 ${$$props.dimensions[1] / 2} H${$$props.dimensions[0]}`);
    set_class(path, 0, clsx([
      "svelte-flow__background-pattern",
      $$props.variant,
      $$props.class
    ]));
  });
  append($$anchor, path);
  pop();
}
const defaultSize = {
  [BackgroundVariant.Dots]: 1,
  [BackgroundVariant.Lines]: 1,
  [BackgroundVariant.Cross]: 6
};
var root$T = /* @__PURE__ */ from_svg(`<svg data-testid="svelte-flow__background"><pattern patternUnits="userSpaceOnUse"><!></pattern><rect x="0" y="0" width="100%" height="100%"></rect></svg>`);
function Background($$anchor, $$props) {
  push($$props, true);
  let variant = prop($$props, "variant", 19, () => BackgroundVariant.Dots), gap = prop($$props, "gap", 3, 20), lineWidth = prop($$props, "lineWidth", 3, 1);
  let store = /* @__PURE__ */ user_derived(useStore);
  let isDots = /* @__PURE__ */ user_derived(() => variant() === BackgroundVariant.Dots);
  let isCross = /* @__PURE__ */ user_derived(() => variant() === BackgroundVariant.Cross);
  let gapXY = /* @__PURE__ */ user_derived(() => Array.isArray(gap()) ? gap() : [gap(), gap()]);
  let patternId = /* @__PURE__ */ user_derived(() => {
    var _a3;
    return `background-pattern-${get$3(store).flowId}-${(_a3 = $$props.id) != null ? _a3 : ""}`;
  });
  let scaledGap = /* @__PURE__ */ user_derived(() => [
    get$3(gapXY)[0] * get$3(store).viewport.zoom || 1,
    get$3(gapXY)[1] * get$3(store).viewport.zoom || 1
  ]);
  let scaledSize = /* @__PURE__ */ user_derived(() => {
    var _a3;
    return ((_a3 = $$props.size) != null ? _a3 : defaultSize[variant()]) * get$3(store).viewport.zoom;
  });
  let patternDimensions = /* @__PURE__ */ user_derived(() => get$3(isCross) ? [get$3(scaledSize), get$3(scaledSize)] : get$3(scaledGap));
  let patternOffset = /* @__PURE__ */ user_derived(() => get$3(isDots) ? [get$3(scaledSize) / 2, get$3(scaledSize) / 2] : [
    get$3(patternDimensions)[0] / 2,
    get$3(patternDimensions)[1] / 2
  ]);
  var svg2 = root$T();
  let styles;
  var pattern = child(svg2);
  var node = child(pattern);
  {
    var consequent = ($$anchor2) => {
      {
        let $0 = /* @__PURE__ */ user_derived(() => get$3(scaledSize) / 2);
        DotPattern($$anchor2, {
          get radius() {
            return get$3($0);
          },
          get class() {
            return $$props.patternClass;
          }
        });
      }
    };
    var alternate = ($$anchor2) => {
      LinePattern($$anchor2, {
        get dimensions() {
          return get$3(patternDimensions);
        },
        get variant() {
          return variant();
        },
        get lineWidth() {
          return lineWidth();
        },
        get class() {
          return $$props.patternClass;
        }
      });
    };
    if_block(node, ($$render) => {
      if (get$3(isDots)) $$render(consequent);
      else $$render(alternate, false);
    });
  }
  var rect = sibling(pattern);
  template_effect(
    ($0) => {
      set_class(svg2, 0, clsx([
        "svelte-flow__background",
        "svelte-flow__container",
        $$props.class
      ]));
      styles = set_style(svg2, "", styles, $0);
      set_attribute(pattern, "id", get$3(patternId));
      set_attribute(pattern, "x", get$3(store).viewport.x % get$3(scaledGap)[0]);
      set_attribute(pattern, "y", get$3(store).viewport.y % get$3(scaledGap)[1]);
      set_attribute(pattern, "width", get$3(scaledGap)[0]);
      set_attribute(pattern, "height", get$3(scaledGap)[1]);
      set_attribute(pattern, "patternTransform", `translate(-${get$3(patternOffset)[0]},-${get$3(patternOffset)[1]})`);
      set_attribute(rect, "fill", `url(#${get$3(patternId)})`);
    },
    [
      () => ({
        "--xy-background-color-props": $$props.bgColor,
        "--xy-background-pattern-color-props": $$props.patternColor
      })
    ]
  );
  append($$anchor, svg2);
  pop();
}
var root$S = /* @__PURE__ */ from_svg(`<rect></rect>`);
function MinimapNode($$anchor, $$props) {
  let borderRadius = prop($$props, "borderRadius", 3, 5), strokeWidth = prop($$props, "strokeWidth", 3, 2);
  var rect = root$S();
  let classes;
  let styles;
  template_effect(
    ($0, $1) => {
      classes = set_class(rect, 0, clsx(["svelte-flow__minimap-node", $$props.class]), null, classes, $0);
      set_attribute(rect, "x", $$props.x);
      set_attribute(rect, "y", $$props.y);
      set_attribute(rect, "rx", borderRadius());
      set_attribute(rect, "ry", borderRadius());
      set_attribute(rect, "width", $$props.width);
      set_attribute(rect, "height", $$props.height);
      set_attribute(rect, "shape-rendering", $$props.shapeRendering);
      styles = set_style(rect, "", styles, $1);
    },
    [
      () => ({ selected: $$props.selected }),
      () => ({
        fill: $$props.color,
        stroke: $$props.strokeColor,
        "stroke-width": strokeWidth()
      })
    ]
  );
  append($$anchor, rect);
}
function interactive(domNode, params) {
  const minimap = XYMinimap({
    domNode,
    panZoom: params.panZoom,
    getTransform: () => {
      const { viewport } = params.store;
      return [viewport.x, viewport.y, viewport.zoom];
    },
    getViewScale: params.getViewScale
  });
  minimap.update({
    translateExtent: params.translateExtent,
    width: params.width,
    height: params.height,
    inversePan: params.inversePan,
    zoomStep: params.zoomStep,
    pannable: params.pannable,
    zoomable: params.zoomable
  });
  function update2(params2) {
    minimap.update({
      translateExtent: params2.translateExtent,
      width: params2.width,
      height: params2.height,
      inversePan: params2.inversePan,
      zoomStep: params2.zoomStep,
      pannable: params2.pannable,
      zoomable: params2.zoomable
    });
  }
  return {
    update: update2,
    destroy() {
      minimap.destroy();
    }
  };
}
const getAttrFunction = (func) => func instanceof Function ? func : () => func;
var root_3$m = /* @__PURE__ */ from_svg(`<title> </title>`);
var root_2$q = /* @__PURE__ */ from_svg(`<svg class="svelte-flow__minimap-svg" role="img"><!><!><path class="svelte-flow__minimap-mask" fill-rule="evenodd" pointer-events="none"></path></svg>`);
var root$R = /* @__PURE__ */ from_html(`<svelte-css-wrapper style="display: contents"><!></svelte-css-wrapper>`, 1);
function Minimap($$anchor, $$props) {
  push($$props, true);
  let position = prop($$props, "position", 3, "bottom-right"), nodeStrokeColor = prop($$props, "nodeStrokeColor", 3, "transparent"), nodeClass = prop($$props, "nodeClass", 3, ""), nodeBorderRadius = prop($$props, "nodeBorderRadius", 3, 5), nodeStrokeWidth = prop($$props, "nodeStrokeWidth", 3, 2), width = prop($$props, "width", 3, 200), height = prop($$props, "height", 3, 150), pannable = prop($$props, "pannable", 3, true), zoomable = prop($$props, "zoomable", 3, true), rest = /* @__PURE__ */ rest_props($$props, [
    "$$slots",
    "$$events",
    "$$legacy",
    "position",
    "ariaLabel",
    "nodeStrokeColor",
    "nodeColor",
    "nodeClass",
    "nodeBorderRadius",
    "nodeStrokeWidth",
    "bgColor",
    "maskColor",
    "maskStrokeColor",
    "maskStrokeWidth",
    "width",
    "height",
    "pannable",
    "zoomable",
    "inversePan",
    "zoomStep",
    "class"
  ]);
  let store = /* @__PURE__ */ user_derived(useStore);
  let ariaLabelConfig = /* @__PURE__ */ user_derived(() => get$3(store).ariaLabelConfig);
  const nodeColorFunc = $$props.nodeColor === void 0 ? void 0 : getAttrFunction($$props.nodeColor);
  const nodeStrokeColorFunc = getAttrFunction(nodeStrokeColor());
  const nodeClassFunc = getAttrFunction(nodeClass());
  const shapeRendering = (
    // @ts-expect-error - TS doesn't know about chrome
    typeof window === "undefined" || !!window.chrome ? "crispEdges" : "geometricPrecision"
  );
  let labelledBy = /* @__PURE__ */ user_derived(() => `svelte-flow__minimap-desc-${get$3(store).flowId}`);
  let viewBB = /* @__PURE__ */ user_derived(() => ({
    x: -get$3(store).viewport.x / get$3(store).viewport.zoom,
    y: -get$3(store).viewport.y / get$3(store).viewport.zoom,
    width: get$3(store).width / get$3(store).viewport.zoom,
    height: get$3(store).height / get$3(store).viewport.zoom
  }));
  let boundingRect = /* @__PURE__ */ user_derived(() => get$3(store).nodeLookup.size > 0 ? getBoundsOfRects(getInternalNodesBounds(get$3(store).nodeLookup, { filter: (n) => !n.hidden }), get$3(viewBB)) : get$3(viewBB));
  let scaledWidth = /* @__PURE__ */ user_derived(() => get$3(boundingRect).width / width());
  let scaledHeight = /* @__PURE__ */ user_derived(() => get$3(boundingRect).height / height());
  let viewScale = /* @__PURE__ */ user_derived(() => Math.max(get$3(scaledWidth), get$3(scaledHeight)));
  let viewWidth = /* @__PURE__ */ user_derived(() => get$3(viewScale) * width());
  let viewHeight = /* @__PURE__ */ user_derived(() => get$3(viewScale) * height());
  let offset = /* @__PURE__ */ user_derived(() => 5 * get$3(viewScale));
  let x2 = /* @__PURE__ */ user_derived(() => get$3(boundingRect).x - (get$3(viewWidth) - get$3(boundingRect).width) / 2 - get$3(offset));
  let y2 = /* @__PURE__ */ user_derived(() => get$3(boundingRect).y - (get$3(viewHeight) - get$3(boundingRect).height) / 2 - get$3(offset));
  let viewboxWidth = /* @__PURE__ */ user_derived(() => get$3(viewWidth) + get$3(offset) * 2);
  let viewboxHeight = /* @__PURE__ */ user_derived(() => get$3(viewHeight) + get$3(offset) * 2);
  const getViewScale = () => get$3(viewScale);
  var fragment = root$R();
  var node_1 = first_child(fragment);
  {
    let $0 = /* @__PURE__ */ user_derived(() => ["svelte-flow__minimap", $$props.class]);
    css_props(node_1, () => ({ "--xy-minimap-background-color-props": $$props.bgColor }));
    Panel(node_1.lastChild, spread_props(
      {
        get position() {
          return position();
        },
        get class() {
          return get$3($0);
        },
        "data-testid": "svelte-flow__minimap"
      },
      () => rest,
      {
        children: ($$anchor2, $$slotProps) => {
          var fragment_1 = comment$1();
          var node_2 = first_child(fragment_1);
          {
            var consequent_2 = ($$anchor3) => {
              var svg2 = root_2$q();
              let styles;
              var node_3 = child(svg2);
              {
                var consequent = ($$anchor4) => {
                  var title = root_3$m();
                  var text2 = child(title);
                  template_effect(() => {
                    var _a3;
                    set_attribute(title, "id", get$3(labelledBy));
                    set_text(text2, (_a3 = $$props.ariaLabel) != null ? _a3 : get$3(ariaLabelConfig)["minimap.ariaLabel"]);
                  });
                  append($$anchor4, title);
                };
                if_block(node_3, ($$render) => {
                  var _a3;
                  if ((_a3 = $$props.ariaLabel) != null ? _a3 : get$3(ariaLabelConfig)["minimap.ariaLabel"]) $$render(consequent);
                });
              }
              var node_4 = sibling(node_3);
              each(node_4, 17, () => get$3(store).nodes, (userNode) => userNode.id, ($$anchor4, userNode) => {
                const node = /* @__PURE__ */ user_derived(() => get$3(store).nodeLookup.get(get$3(userNode).id));
                var fragment_2 = comment$1();
                var node_5 = first_child(fragment_2);
                {
                  var consequent_1 = ($$anchor5) => {
                    const nodeDimesions = /* @__PURE__ */ user_derived(() => getNodeDimensions(get$3(node)));
                    {
                      let $02 = /* @__PURE__ */ user_derived(() => nodeColorFunc == null ? void 0 : nodeColorFunc(get$3(node)));
                      let $1 = /* @__PURE__ */ user_derived(() => nodeStrokeColorFunc(get$3(node)));
                      let $2 = /* @__PURE__ */ user_derived(() => nodeClassFunc(get$3(node)));
                      MinimapNode($$anchor5, spread_props(
                        {
                          get x() {
                            return get$3(node).internals.positionAbsolute.x;
                          },
                          get y() {
                            return get$3(node).internals.positionAbsolute.y;
                          }
                        },
                        () => get$3(nodeDimesions),
                        {
                          get selected() {
                            return get$3(node).selected;
                          },
                          get color() {
                            return get$3($02);
                          },
                          get borderRadius() {
                            return nodeBorderRadius();
                          },
                          get strokeColor() {
                            return get$3($1);
                          },
                          get strokeWidth() {
                            return nodeStrokeWidth();
                          },
                          get shapeRendering() {
                            return shapeRendering;
                          },
                          get class() {
                            return get$3($2);
                          }
                        }
                      ));
                    }
                  };
                  if_block(node_5, ($$render) => {
                    if (get$3(node) && nodeHasDimensions(get$3(node))) $$render(consequent_1);
                  });
                }
                append($$anchor4, fragment_2);
              });
              var path = sibling(node_4);
              action(svg2, ($$node, $$action_arg) => interactive == null ? void 0 : interactive($$node, $$action_arg), () => ({
                store: get$3(store),
                panZoom: get$3(store).panZoom,
                getViewScale,
                translateExtent: get$3(store).translateExtent,
                width: get$3(store).width,
                height: get$3(store).height,
                inversePan: $$props.inversePan,
                zoomStep: $$props.zoomStep,
                pannable: pannable(),
                zoomable: zoomable()
              }));
              template_effect(
                ($02) => {
                  var _a3, _b2, _c2, _d2, _e3, _f2, _g, _h;
                  set_attribute(svg2, "width", width());
                  set_attribute(svg2, "height", height());
                  set_attribute(svg2, "viewBox", `${(_a3 = get$3(x2)) != null ? _a3 : ""} ${(_b2 = get$3(y2)) != null ? _b2 : ""} ${(_c2 = get$3(viewboxWidth)) != null ? _c2 : ""} ${(_d2 = get$3(viewboxHeight)) != null ? _d2 : ""}`);
                  set_attribute(svg2, "aria-labelledby", get$3(labelledBy));
                  styles = set_style(svg2, "", styles, $02);
                  set_attribute(path, "d", `M${get$3(x2) - get$3(offset)},${get$3(y2) - get$3(offset)}h${get$3(viewboxWidth) + get$3(offset) * 2}v${get$3(viewboxHeight) + get$3(offset) * 2}h${-get$3(viewboxWidth) - get$3(offset) * 2}z
      M${(_e3 = get$3(viewBB).x) != null ? _e3 : ""},${(_f2 = get$3(viewBB).y) != null ? _f2 : ""}h${(_g = get$3(viewBB).width) != null ? _g : ""}v${(_h = get$3(viewBB).height) != null ? _h : ""}h${-get$3(viewBB).width}z`);
                },
                [
                  () => ({
                    "--xy-minimap-mask-background-color-props": $$props.maskColor,
                    "--xy-minimap-mask-stroke-color-props": $$props.maskStrokeColor,
                    "--xy-minimap-mask-stroke-width-props": $$props.maskStrokeWidth ? $$props.maskStrokeWidth * get$3(viewScale) : void 0
                  })
                ]
              );
              append($$anchor3, svg2);
            };
            if_block(node_2, ($$render) => {
              if (get$3(store).panZoom) $$render(consequent_2);
            });
          }
          append($$anchor2, fragment_1);
        },
        $$slots: { default: true }
      }
    ));
  }
  append($$anchor, fragment);
  pop();
}
function useUpdateNodeInternals() {
  const $$d = /* @__PURE__ */ user_derived(useStore), domNode = /* @__PURE__ */ user_derived(() => get$3($$d).domNode), updateNodeInternals2 = /* @__PURE__ */ user_derived(() => get$3($$d).updateNodeInternals);
  const nodeId = getContext("svelteflow__node_id");
  const updateInternals = (id2) => {
    if (!id2 && !nodeId) {
      throw new Error("When using outside of a node, you must provide an id.");
    }
    const updateIds = id2 ? Array.isArray(id2) ? id2 : [id2] : [nodeId];
    const updates = /* @__PURE__ */ new Map();
    updateIds.forEach((updateId) => {
      var _a3;
      const nodeElement = (_a3 = get$3(domNode)) == null ? void 0 : _a3.querySelector(`.svelte-flow__node[data-id="${updateId}"]`);
      if (nodeElement) {
        updates.set(updateId, { id: updateId, nodeElement, force: true });
      }
    });
    requestAnimationFrame(() => get$3(updateNodeInternals2)(updates));
  };
  return updateInternals;
}
function useConnection() {
  const $$d = /* @__PURE__ */ user_derived(useStore), connection = /* @__PURE__ */ user_derived(() => get$3($$d).connection);
  return {
    get current() {
      return get$3(connection);
    }
  };
}
function dynamicPortToNodePort(port, portType) {
  var _a3;
  return {
    id: port.name,
    name: port.label,
    type: portType,
    dataType: port.dataType,
    required: (_a3 = port.required) != null ? _a3 : false,
    description: port.description
  };
}
const matchIconName = /^[a-z0-9]+(-[a-z0-9]+)*$/;
const stringToIcon = (value, validate, allowSimpleName, provider = "") => {
  const colonSeparated = value.split(":");
  if (value.slice(0, 1) === "@") {
    if (colonSeparated.length < 2 || colonSeparated.length > 3) return null;
    provider = colonSeparated.shift().slice(1);
  }
  if (colonSeparated.length > 3 || !colonSeparated.length) return null;
  if (colonSeparated.length > 1) {
    const name$1 = colonSeparated.pop();
    const prefix = colonSeparated.pop();
    const result = {
      provider: colonSeparated.length > 0 ? colonSeparated[0] : provider,
      prefix,
      name: name$1
    };
    return validate && !validateIconName(result) ? null : result;
  }
  const name2 = colonSeparated[0];
  const dashSeparated = name2.split("-");
  if (dashSeparated.length > 1) {
    const result = {
      provider,
      prefix: dashSeparated.shift(),
      name: dashSeparated.join("-")
    };
    return validate && !validateIconName(result) ? null : result;
  }
  if (allowSimpleName && provider === "") {
    const result = {
      provider,
      prefix: "",
      name: name2
    };
    return validate && !validateIconName(result, allowSimpleName) ? null : result;
  }
  return null;
};
const validateIconName = (icon, allowSimpleName) => {
  if (!icon) return false;
  return !!((allowSimpleName && icon.prefix === "" || !!icon.prefix) && !!icon.name);
};
function getIconsTree(data, names) {
  const icons = data.icons;
  const aliases = data.aliases || /* @__PURE__ */ Object.create(null);
  const resolved = /* @__PURE__ */ Object.create(null);
  function resolve(name2) {
    if (icons[name2]) return resolved[name2] = [];
    if (!(name2 in resolved)) {
      resolved[name2] = null;
      const parent = aliases[name2] && aliases[name2].parent;
      const value = parent && resolve(parent);
      if (value) resolved[name2] = [parent].concat(value);
    }
    return resolved[name2];
  }
  Object.keys(icons).concat(Object.keys(aliases)).forEach(resolve);
  return resolved;
}
const defaultIconDimensions = Object.freeze({
  left: 0,
  top: 0,
  width: 16,
  height: 16
});
const defaultIconTransformations = Object.freeze({
  rotate: 0,
  vFlip: false,
  hFlip: false
});
const defaultIconProps = Object.freeze(__spreadValues(__spreadValues({}, defaultIconDimensions), defaultIconTransformations));
const defaultExtendedIconProps = Object.freeze(__spreadProps(__spreadValues({}, defaultIconProps), {
  body: "",
  hidden: false
}));
function mergeIconTransformations(obj1, obj2) {
  const result = {};
  if (!obj1.hFlip !== !obj2.hFlip) result.hFlip = true;
  if (!obj1.vFlip !== !obj2.vFlip) result.vFlip = true;
  const rotate = ((obj1.rotate || 0) + (obj2.rotate || 0)) % 4;
  if (rotate) result.rotate = rotate;
  return result;
}
function mergeIconData(parent, child2) {
  const result = mergeIconTransformations(parent, child2);
  for (const key2 in defaultExtendedIconProps) if (key2 in defaultIconTransformations) {
    if (key2 in parent && !(key2 in result)) result[key2] = defaultIconTransformations[key2];
  } else if (key2 in child2) result[key2] = child2[key2];
  else if (key2 in parent) result[key2] = parent[key2];
  return result;
}
function internalGetIconData(data, name2, tree) {
  const icons = data.icons;
  const aliases = data.aliases || /* @__PURE__ */ Object.create(null);
  let currentProps = {};
  function parse2(name$1) {
    currentProps = mergeIconData(icons[name$1] || aliases[name$1], currentProps);
  }
  parse2(name2);
  tree.forEach(parse2);
  return mergeIconData(data, currentProps);
}
function parseIconSet(data, callback) {
  const names = [];
  if (typeof data !== "object" || typeof data.icons !== "object") return names;
  if (data.not_found instanceof Array) data.not_found.forEach((name2) => {
    callback(name2, null);
    names.push(name2);
  });
  const tree = getIconsTree(data);
  for (const name2 in tree) {
    const item = tree[name2];
    if (item) {
      callback(name2, internalGetIconData(data, name2, item));
      names.push(name2);
    }
  }
  return names;
}
const optionalPropertyDefaults = __spreadValues({
  provider: "",
  aliases: {},
  not_found: {}
}, defaultIconDimensions);
function checkOptionalProps(item, defaults2) {
  for (const prop2 in defaults2) if (prop2 in item && typeof item[prop2] !== typeof defaults2[prop2]) return false;
  return true;
}
function quicklyValidateIconSet(obj) {
  if (typeof obj !== "object" || obj === null) return null;
  const data = obj;
  if (typeof data.prefix !== "string" || !obj.icons || typeof obj.icons !== "object") return null;
  if (!checkOptionalProps(obj, optionalPropertyDefaults)) return null;
  const icons = data.icons;
  for (const name2 in icons) {
    const icon = icons[name2];
    if (!name2 || typeof icon.body !== "string" || !checkOptionalProps(icon, defaultExtendedIconProps)) return null;
  }
  const aliases = data.aliases || /* @__PURE__ */ Object.create(null);
  for (const name2 in aliases) {
    const icon = aliases[name2];
    const parent = icon.parent;
    if (!name2 || typeof parent !== "string" || !icons[parent] && !aliases[parent] || !checkOptionalProps(icon, defaultExtendedIconProps)) return null;
  }
  return data;
}
const dataStorage = /* @__PURE__ */ Object.create(null);
function newStorage(provider, prefix) {
  return {
    provider,
    prefix,
    icons: /* @__PURE__ */ Object.create(null),
    missing: /* @__PURE__ */ new Set()
  };
}
function getStorage(provider, prefix) {
  const providerStorage = dataStorage[provider] || (dataStorage[provider] = /* @__PURE__ */ Object.create(null));
  return providerStorage[prefix] || (providerStorage[prefix] = newStorage(provider, prefix));
}
function addIconSet(storage2, data) {
  if (!quicklyValidateIconSet(data)) return [];
  return parseIconSet(data, (name2, icon) => {
    if (icon) storage2.icons[name2] = icon;
    else storage2.missing.add(name2);
  });
}
function addIconToStorage(storage2, name2, icon) {
  try {
    if (typeof icon.body === "string") {
      storage2.icons[name2] = __spreadValues({}, icon);
      return true;
    }
  } catch (err) {
  }
  return false;
}
let simpleNames = false;
function allowSimpleNames(allow) {
  if (typeof allow === "boolean") simpleNames = allow;
  return simpleNames;
}
function getIconData(name2) {
  const icon = typeof name2 === "string" ? stringToIcon(name2, true, simpleNames) : name2;
  if (icon) {
    const storage2 = getStorage(icon.provider, icon.prefix);
    const iconName = icon.name;
    return storage2.icons[iconName] || (storage2.missing.has(iconName) ? null : void 0);
  }
}
function addIcon(name2, data) {
  const icon = stringToIcon(name2, true, simpleNames);
  if (!icon) return false;
  const storage2 = getStorage(icon.provider, icon.prefix);
  if (data) return addIconToStorage(storage2, icon.name, data);
  else {
    storage2.missing.add(icon.name);
    return true;
  }
}
function addCollection(data, provider) {
  if (typeof data !== "object") return false;
  if (typeof provider !== "string") provider = data.provider || "";
  if (simpleNames && !provider && !data.prefix) {
    let added = false;
    if (quicklyValidateIconSet(data)) {
      data.prefix = "";
      parseIconSet(data, (name2, icon) => {
        if (addIcon(name2, icon)) added = true;
      });
    }
    return added;
  }
  const prefix = data.prefix;
  if (!validateIconName({
    prefix,
    name: "a"
  })) return false;
  return !!addIconSet(getStorage(provider, prefix), data);
}
const defaultIconSizeCustomisations = Object.freeze({
  width: null,
  height: null
});
const defaultIconCustomisations = Object.freeze(__spreadValues(__spreadValues({}, defaultIconSizeCustomisations), defaultIconTransformations));
const unitsSplit = /(-?[0-9.]*[0-9]+[0-9.]*)/g;
const unitsTest = /^-?[0-9.]*[0-9]+[0-9.]*$/g;
function calculateSize(size, ratio, precision) {
  if (ratio === 1) return size;
  precision = precision || 100;
  if (typeof size === "number") return Math.ceil(size * ratio * precision) / precision;
  if (typeof size !== "string") return size;
  const oldParts = size.split(unitsSplit);
  if (oldParts === null || !oldParts.length) return size;
  const newParts = [];
  let code = oldParts.shift();
  let isNumber = unitsTest.test(code);
  while (true) {
    if (isNumber) {
      const num = parseFloat(code);
      if (isNaN(num)) newParts.push(code);
      else newParts.push(Math.ceil(num * ratio * precision) / precision);
    } else newParts.push(code);
    code = oldParts.shift();
    if (code === void 0) return newParts.join("");
    isNumber = !isNumber;
  }
}
function splitSVGDefs(content2, tag2 = "defs") {
  let defs = "";
  const index2 = content2.indexOf("<" + tag2);
  while (index2 >= 0) {
    const start2 = content2.indexOf(">", index2);
    const end = content2.indexOf("</" + tag2);
    if (start2 === -1 || end === -1) break;
    const endEnd = content2.indexOf(">", end);
    if (endEnd === -1) break;
    defs += content2.slice(start2 + 1, end).trim();
    content2 = content2.slice(0, index2).trim() + content2.slice(endEnd + 1);
  }
  return {
    defs,
    content: content2
  };
}
function mergeDefsAndContent(defs, content2) {
  return defs ? "<defs>" + defs + "</defs>" + content2 : content2;
}
function wrapSVGContent(body, start2, end) {
  const split = splitSVGDefs(body);
  return mergeDefsAndContent(split.defs, start2 + split.content + end);
}
const isUnsetKeyword = (value) => value === "unset" || value === "undefined" || value === "none";
function iconToSVG(icon, customisations) {
  const fullIcon = __spreadValues(__spreadValues({}, defaultIconProps), icon);
  const fullCustomisations = __spreadValues(__spreadValues({}, defaultIconCustomisations), customisations);
  const box = {
    left: fullIcon.left,
    top: fullIcon.top,
    width: fullIcon.width,
    height: fullIcon.height
  };
  let body = fullIcon.body;
  [fullIcon, fullCustomisations].forEach((props) => {
    const transformations = [];
    const hFlip = props.hFlip;
    const vFlip = props.vFlip;
    let rotation = props.rotate;
    if (hFlip) if (vFlip) rotation += 2;
    else {
      transformations.push("translate(" + (box.width + box.left).toString() + " " + (0 - box.top).toString() + ")");
      transformations.push("scale(-1 1)");
      box.top = box.left = 0;
    }
    else if (vFlip) {
      transformations.push("translate(" + (0 - box.left).toString() + " " + (box.height + box.top).toString() + ")");
      transformations.push("scale(1 -1)");
      box.top = box.left = 0;
    }
    let tempValue;
    if (rotation < 0) rotation -= Math.floor(rotation / 4) * 4;
    rotation = rotation % 4;
    switch (rotation) {
      case 1:
        tempValue = box.height / 2 + box.top;
        transformations.unshift("rotate(90 " + tempValue.toString() + " " + tempValue.toString() + ")");
        break;
      case 2:
        transformations.unshift("rotate(180 " + (box.width / 2 + box.left).toString() + " " + (box.height / 2 + box.top).toString() + ")");
        break;
      case 3:
        tempValue = box.width / 2 + box.left;
        transformations.unshift("rotate(-90 " + tempValue.toString() + " " + tempValue.toString() + ")");
        break;
    }
    if (rotation % 2 === 1) {
      if (box.left !== box.top) {
        tempValue = box.left;
        box.left = box.top;
        box.top = tempValue;
      }
      if (box.width !== box.height) {
        tempValue = box.width;
        box.width = box.height;
        box.height = tempValue;
      }
    }
    if (transformations.length) body = wrapSVGContent(body, '<g transform="' + transformations.join(" ") + '">', "</g>");
  });
  const customisationsWidth = fullCustomisations.width;
  const customisationsHeight = fullCustomisations.height;
  const boxWidth = box.width;
  const boxHeight = box.height;
  let width;
  let height;
  if (customisationsWidth === null) {
    height = customisationsHeight === null ? "1em" : customisationsHeight === "auto" ? boxHeight : customisationsHeight;
    width = calculateSize(height, boxWidth / boxHeight);
  } else {
    width = customisationsWidth === "auto" ? boxWidth : customisationsWidth;
    height = customisationsHeight === null ? calculateSize(width, boxHeight / boxWidth) : customisationsHeight === "auto" ? boxHeight : customisationsHeight;
  }
  const attributes = {};
  const setAttr = (prop2, value) => {
    if (!isUnsetKeyword(value)) attributes[prop2] = value.toString();
  };
  setAttr("width", width);
  setAttr("height", height);
  const viewBox = [
    box.left,
    box.top,
    boxWidth,
    boxHeight
  ];
  attributes.viewBox = viewBox.join(" ");
  return {
    attributes,
    viewBox,
    body
  };
}
const regex = /\sid="(\S+)"/g;
const counters = /* @__PURE__ */ new Map();
function nextID$1(id2) {
  id2 = id2.replace(/[0-9]+$/, "") || "a";
  const count = counters.get(id2) || 0;
  counters.set(id2, count + 1);
  return count ? `${id2}${count}` : id2;
}
function replaceIDs(body) {
  const ids = [];
  let match;
  while (match = regex.exec(body)) ids.push(match[1]);
  if (!ids.length) return body;
  const suffix = "suffix" + (Math.random() * 16777216 | Date.now()).toString(16);
  ids.forEach((id2) => {
    const newID = nextID$1(id2);
    const escapedID = id2.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
    body = body.replace(new RegExp('([#;"])(' + escapedID + ')([")]|\\.[a-z])', "g"), "$1" + newID + suffix + "$3");
  });
  body = body.replace(new RegExp(suffix, "g"), "");
  return body;
}
const storage = /* @__PURE__ */ Object.create(null);
function setAPIModule(provider, item) {
  storage[provider] = item;
}
function getAPIModule(provider) {
  return storage[provider] || storage[""];
}
function createAPIConfig(source2) {
  let resources;
  if (typeof source2.resources === "string") resources = [source2.resources];
  else {
    resources = source2.resources;
    if (!(resources instanceof Array) || !resources.length) return null;
  }
  return {
    resources,
    path: source2.path || "/",
    maxURL: source2.maxURL || 500,
    rotate: source2.rotate || 750,
    timeout: source2.timeout || 5e3,
    random: source2.random === true,
    index: source2.index || 0,
    dataAfterTimeout: source2.dataAfterTimeout !== false
  };
}
const configStorage = /* @__PURE__ */ Object.create(null);
const fallBackAPISources = ["https://api.simplesvg.com", "https://api.unisvg.com"];
const fallBackAPI = [];
while (fallBackAPISources.length > 0) if (fallBackAPISources.length === 1) fallBackAPI.push(fallBackAPISources.shift());
else if (Math.random() > 0.5) fallBackAPI.push(fallBackAPISources.shift());
else fallBackAPI.push(fallBackAPISources.pop());
configStorage[""] = createAPIConfig({ resources: ["https://api.iconify.design"].concat(fallBackAPI) });
function addAPIProvider(provider, customConfig) {
  const config = createAPIConfig(customConfig);
  if (config === null) return false;
  configStorage[provider] = config;
  return true;
}
function getAPIConfig(provider) {
  return configStorage[provider];
}
const detectFetch = () => {
  let callback;
  try {
    callback = fetch;
    if (typeof callback === "function") return callback;
  } catch (err) {
  }
};
let fetchModule = detectFetch();
function calculateMaxLength(provider, prefix) {
  const config = getAPIConfig(provider);
  if (!config) return 0;
  let result;
  if (!config.maxURL) result = 0;
  else {
    let maxHostLength = 0;
    config.resources.forEach((item) => {
      const host = item;
      maxHostLength = Math.max(maxHostLength, host.length);
    });
    const url = prefix + ".json?icons=";
    result = config.maxURL - maxHostLength - config.path.length - url.length;
  }
  return result;
}
function shouldAbort(status) {
  return status === 404;
}
const prepare = (provider, prefix, icons) => {
  const results = [];
  const maxLength = calculateMaxLength(provider, prefix);
  const type = "icons";
  let item = {
    type,
    provider,
    prefix,
    icons: []
  };
  let length = 0;
  icons.forEach((name2, index2) => {
    length += name2.length + 1;
    if (length >= maxLength && index2 > 0) {
      results.push(item);
      item = {
        type,
        provider,
        prefix,
        icons: []
      };
      length = name2.length;
    }
    item.icons.push(name2);
  });
  results.push(item);
  return results;
};
function getPath(provider) {
  if (typeof provider === "string") {
    const config = getAPIConfig(provider);
    if (config) return config.path;
  }
  return "/";
}
const send = (host, params, callback) => {
  if (!fetchModule) {
    callback("abort", 424);
    return;
  }
  let path = getPath(params.provider);
  switch (params.type) {
    case "icons": {
      const prefix = params.prefix;
      const iconsList = params.icons.join(",");
      const urlParams = new URLSearchParams({ icons: iconsList });
      path += prefix + ".json?" + urlParams.toString();
      break;
    }
    case "custom": {
      const uri = params.uri;
      path += uri.slice(0, 1) === "/" ? uri.slice(1) : uri;
      break;
    }
    default:
      callback("abort", 400);
      return;
  }
  let defaultError = 503;
  fetchModule(host + path).then((response) => {
    const status = response.status;
    if (status !== 200) {
      setTimeout(() => {
        callback(shouldAbort(status) ? "abort" : "next", status);
      });
      return;
    }
    defaultError = 501;
    return response.json();
  }).then((data) => {
    if (typeof data !== "object" || data === null) {
      setTimeout(() => {
        if (data === 404) callback("abort", data);
        else callback("next", defaultError);
      });
      return;
    }
    setTimeout(() => {
      callback("success", data);
    });
  }).catch(() => {
    callback("next", defaultError);
  });
};
const fetchAPIModule = {
  prepare,
  send
};
function removeCallback(storages, id2) {
  storages.forEach((storage2) => {
    const items = storage2.loaderCallbacks;
    if (items) storage2.loaderCallbacks = items.filter((row) => row.id !== id2);
  });
}
function updateCallbacks(storage2) {
  if (!storage2.pendingCallbacksFlag) {
    storage2.pendingCallbacksFlag = true;
    setTimeout(() => {
      storage2.pendingCallbacksFlag = false;
      const items = storage2.loaderCallbacks ? storage2.loaderCallbacks.slice(0) : [];
      if (!items.length) return;
      let hasPending = false;
      const provider = storage2.provider;
      const prefix = storage2.prefix;
      items.forEach((item) => {
        const icons = item.icons;
        const oldLength = icons.pending.length;
        icons.pending = icons.pending.filter((icon) => {
          if (icon.prefix !== prefix) return true;
          const name2 = icon.name;
          if (storage2.icons[name2]) icons.loaded.push({
            provider,
            prefix,
            name: name2
          });
          else if (storage2.missing.has(name2)) icons.missing.push({
            provider,
            prefix,
            name: name2
          });
          else {
            hasPending = true;
            return true;
          }
          return false;
        });
        if (icons.pending.length !== oldLength) {
          if (!hasPending) removeCallback([storage2], item.id);
          item.callback(icons.loaded.slice(0), icons.missing.slice(0), icons.pending.slice(0), item.abort);
        }
      });
    });
  }
}
let idCounter = 0;
function storeCallback(callback, icons, pendingSources) {
  const id2 = idCounter++;
  const abort = removeCallback.bind(null, pendingSources, id2);
  if (!icons.pending.length) return abort;
  const item = {
    id: id2,
    icons,
    callback,
    abort
  };
  pendingSources.forEach((storage2) => {
    (storage2.loaderCallbacks || (storage2.loaderCallbacks = [])).push(item);
  });
  return abort;
}
function sortIcons(icons) {
  const result = {
    loaded: [],
    missing: [],
    pending: []
  };
  const storage2 = /* @__PURE__ */ Object.create(null);
  icons.sort((a, b2) => {
    if (a.provider !== b2.provider) return a.provider.localeCompare(b2.provider);
    if (a.prefix !== b2.prefix) return a.prefix.localeCompare(b2.prefix);
    return a.name.localeCompare(b2.name);
  });
  let lastIcon = {
    provider: "",
    prefix: "",
    name: ""
  };
  icons.forEach((icon) => {
    if (lastIcon.name === icon.name && lastIcon.prefix === icon.prefix && lastIcon.provider === icon.provider) return;
    lastIcon = icon;
    const provider = icon.provider;
    const prefix = icon.prefix;
    const name2 = icon.name;
    const providerStorage = storage2[provider] || (storage2[provider] = /* @__PURE__ */ Object.create(null));
    const localStorage2 = providerStorage[prefix] || (providerStorage[prefix] = getStorage(provider, prefix));
    let list;
    if (name2 in localStorage2.icons) list = result.loaded;
    else if (prefix === "" || localStorage2.missing.has(name2)) list = result.missing;
    else list = result.pending;
    const item = {
      provider,
      prefix,
      name: name2
    };
    list.push(item);
  });
  return result;
}
function listToIcons(list, validate = true, simpleNames2 = false) {
  const result = [];
  list.forEach((item) => {
    const icon = typeof item === "string" ? stringToIcon(item, validate, simpleNames2) : item;
    if (icon) result.push(icon);
  });
  return result;
}
const defaultConfig = {
  resources: [],
  index: 0,
  timeout: 2e3,
  rotate: 750,
  random: false,
  dataAfterTimeout: false
};
function sendQuery(config, payload, query, done) {
  const resourcesCount = config.resources.length;
  const startIndex = config.random ? Math.floor(Math.random() * resourcesCount) : config.index;
  let resources;
  if (config.random) {
    let list = config.resources.slice(0);
    resources = [];
    while (list.length > 1) {
      const nextIndex = Math.floor(Math.random() * list.length);
      resources.push(list[nextIndex]);
      list = list.slice(0, nextIndex).concat(list.slice(nextIndex + 1));
    }
    resources = resources.concat(list);
  } else resources = config.resources.slice(startIndex).concat(config.resources.slice(0, startIndex));
  const startTime = Date.now();
  let status = "pending";
  let queriesSent = 0;
  let lastError;
  let timer2 = null;
  let queue = [];
  let doneCallbacks = [];
  if (typeof done === "function") doneCallbacks.push(done);
  function resetTimer() {
    if (timer2) {
      clearTimeout(timer2);
      timer2 = null;
    }
  }
  function abort() {
    if (status === "pending") status = "aborted";
    resetTimer();
    queue.forEach((item) => {
      if (item.status === "pending") item.status = "aborted";
    });
    queue = [];
  }
  function subscribe(callback, overwrite) {
    if (overwrite) doneCallbacks = [];
    if (typeof callback === "function") doneCallbacks.push(callback);
  }
  function getQueryStatus() {
    return {
      startTime,
      payload,
      status,
      queriesSent,
      queriesPending: queue.length,
      subscribe,
      abort
    };
  }
  function failQuery() {
    status = "failed";
    doneCallbacks.forEach((callback) => {
      callback(void 0, lastError);
    });
  }
  function clearQueue() {
    queue.forEach((item) => {
      if (item.status === "pending") item.status = "aborted";
    });
    queue = [];
  }
  function moduleResponse(item, response, data) {
    const isError = response !== "success";
    queue = queue.filter((queued) => queued !== item);
    switch (status) {
      case "pending":
        break;
      case "failed":
        if (isError || !config.dataAfterTimeout) return;
        break;
      default:
        return;
    }
    if (response === "abort") {
      lastError = data;
      failQuery();
      return;
    }
    if (isError) {
      lastError = data;
      if (!queue.length) if (!resources.length) failQuery();
      else execNext();
      return;
    }
    resetTimer();
    clearQueue();
    if (!config.random) {
      const index2 = config.resources.indexOf(item.resource);
      if (index2 !== -1 && index2 !== config.index) config.index = index2;
    }
    status = "completed";
    doneCallbacks.forEach((callback) => {
      callback(data);
    });
  }
  function execNext() {
    if (status !== "pending") return;
    resetTimer();
    const resource = resources.shift();
    if (resource === void 0) {
      if (queue.length) {
        timer2 = setTimeout(() => {
          resetTimer();
          if (status === "pending") {
            clearQueue();
            failQuery();
          }
        }, config.timeout);
        return;
      }
      failQuery();
      return;
    }
    const item = {
      status: "pending",
      resource,
      callback: (status$1, data) => {
        moduleResponse(item, status$1, data);
      }
    };
    queue.push(item);
    queriesSent++;
    timer2 = setTimeout(execNext, config.rotate);
    query(resource, payload, item.callback);
  }
  setTimeout(execNext);
  return getQueryStatus;
}
function initRedundancy(cfg) {
  const config = __spreadValues(__spreadValues({}, defaultConfig), cfg);
  let queries = [];
  function cleanup() {
    queries = queries.filter((item) => item().status === "pending");
  }
  function query(payload, queryCallback, doneCallback) {
    const query$1 = sendQuery(config, payload, queryCallback, (data, error2) => {
      cleanup();
      if (doneCallback) doneCallback(data, error2);
    });
    queries.push(query$1);
    return query$1;
  }
  function find2(callback) {
    return queries.find((value) => {
      return callback(value);
    }) || null;
  }
  return {
    query,
    find: find2,
    setIndex: (index2) => {
      config.index = index2;
    },
    getIndex: () => config.index,
    cleanup
  };
}
function emptyCallback$1() {
}
const redundancyCache = /* @__PURE__ */ Object.create(null);
function getRedundancyCache(provider) {
  if (!redundancyCache[provider]) {
    const config = getAPIConfig(provider);
    if (!config) return;
    redundancyCache[provider] = {
      config,
      redundancy: initRedundancy(config)
    };
  }
  return redundancyCache[provider];
}
function sendAPIQuery(target, query, callback) {
  let redundancy;
  let send2;
  if (typeof target === "string") {
    const api2 = getAPIModule(target);
    if (!api2) {
      callback(void 0, 424);
      return emptyCallback$1;
    }
    send2 = api2.send;
    const cached = getRedundancyCache(target);
    if (cached) redundancy = cached.redundancy;
  } else {
    const config = createAPIConfig(target);
    if (config) {
      redundancy = initRedundancy(config);
      const api2 = getAPIModule(target.resources ? target.resources[0] : "");
      if (api2) send2 = api2.send;
    }
  }
  if (!redundancy || !send2) {
    callback(void 0, 424);
    return emptyCallback$1;
  }
  return redundancy.query(query, send2, callback)().abort;
}
function emptyCallback() {
}
function loadedNewIcons(storage2) {
  if (!storage2.iconsLoaderFlag) {
    storage2.iconsLoaderFlag = true;
    setTimeout(() => {
      storage2.iconsLoaderFlag = false;
      updateCallbacks(storage2);
    });
  }
}
function checkIconNamesForAPI(icons) {
  const valid = [];
  const invalid2 = [];
  icons.forEach((name2) => {
    (name2.match(matchIconName) ? valid : invalid2).push(name2);
  });
  return {
    valid,
    invalid: invalid2
  };
}
function parseLoaderResponse(storage2, icons, data) {
  function checkMissing() {
    const pending = storage2.pendingIcons;
    icons.forEach((name2) => {
      if (pending) pending.delete(name2);
      if (!storage2.icons[name2]) storage2.missing.add(name2);
    });
  }
  if (data && typeof data === "object") try {
    if (!addIconSet(storage2, data).length) {
      checkMissing();
      return;
    }
  } catch (err) {
    console.error(err);
  }
  checkMissing();
  loadedNewIcons(storage2);
}
function parsePossiblyAsyncResponse(response, callback) {
  if (response instanceof Promise) response.then((data) => {
    callback(data);
  }).catch(() => {
    callback(null);
  });
  else callback(response);
}
function loadNewIcons(storage2, icons) {
  if (!storage2.iconsToLoad) storage2.iconsToLoad = icons;
  else storage2.iconsToLoad = storage2.iconsToLoad.concat(icons).sort();
  if (!storage2.iconsQueueFlag) {
    storage2.iconsQueueFlag = true;
    setTimeout(() => {
      storage2.iconsQueueFlag = false;
      const { provider, prefix } = storage2;
      const icons$1 = storage2.iconsToLoad;
      delete storage2.iconsToLoad;
      if (!icons$1 || !icons$1.length) return;
      const customIconLoader = storage2.loadIcon;
      if (storage2.loadIcons && (icons$1.length > 1 || !customIconLoader)) {
        parsePossiblyAsyncResponse(storage2.loadIcons(icons$1, prefix, provider), (data) => {
          parseLoaderResponse(storage2, icons$1, data);
        });
        return;
      }
      if (customIconLoader) {
        icons$1.forEach((name2) => {
          parsePossiblyAsyncResponse(customIconLoader(name2, prefix, provider), (data) => {
            parseLoaderResponse(storage2, [name2], data ? {
              prefix,
              icons: { [name2]: data }
            } : null);
          });
        });
        return;
      }
      const { valid, invalid: invalid2 } = checkIconNamesForAPI(icons$1);
      if (invalid2.length) parseLoaderResponse(storage2, invalid2, null);
      if (!valid.length) return;
      const api2 = prefix.match(matchIconName) ? getAPIModule(provider) : null;
      if (!api2) {
        parseLoaderResponse(storage2, valid, null);
        return;
      }
      api2.prepare(provider, prefix, valid).forEach((item) => {
        sendAPIQuery(provider, item, (data) => {
          parseLoaderResponse(storage2, item.icons, data);
        });
      });
    });
  }
}
const loadIcons = (icons, callback) => {
  const sortedIcons = sortIcons(listToIcons(icons, true, allowSimpleNames()));
  if (!sortedIcons.pending.length) {
    let callCallback = true;
    if (callback) setTimeout(() => {
      if (callCallback) callback(sortedIcons.loaded, sortedIcons.missing, sortedIcons.pending, emptyCallback);
    });
    return () => {
      callCallback = false;
    };
  }
  const newIcons = /* @__PURE__ */ Object.create(null);
  const sources = [];
  let lastProvider, lastPrefix;
  sortedIcons.pending.forEach((icon) => {
    const { provider, prefix } = icon;
    if (prefix === lastPrefix && provider === lastProvider) return;
    lastProvider = provider;
    lastPrefix = prefix;
    sources.push(getStorage(provider, prefix));
    const providerNewIcons = newIcons[provider] || (newIcons[provider] = /* @__PURE__ */ Object.create(null));
    if (!providerNewIcons[prefix]) providerNewIcons[prefix] = [];
  });
  sortedIcons.pending.forEach((icon) => {
    const { provider, prefix, name: name2 } = icon;
    const storage2 = getStorage(provider, prefix);
    const pendingQueue = storage2.pendingIcons || (storage2.pendingIcons = /* @__PURE__ */ new Set());
    if (!pendingQueue.has(name2)) {
      pendingQueue.add(name2);
      newIcons[provider][prefix].push(name2);
    }
  });
  sources.forEach((storage2) => {
    const list = newIcons[storage2.provider][storage2.prefix];
    if (list.length) loadNewIcons(storage2, list);
  });
  return callback ? storeCallback(callback, sortedIcons, sources) : emptyCallback;
};
function mergeCustomisations(defaults2, item) {
  const result = __spreadValues({}, defaults2);
  for (const key2 in item) {
    const value = item[key2];
    const valueType = typeof value;
    if (key2 in defaultIconSizeCustomisations) {
      if (value === null || value && (valueType === "string" || valueType === "number")) result[key2] = value;
    } else if (valueType === typeof result[key2]) result[key2] = key2 === "rotate" ? value % 4 : value;
  }
  return result;
}
const separator = /[\s,]+/;
function flipFromString(custom, flip) {
  flip.split(separator).forEach((str) => {
    switch (str.trim()) {
      case "horizontal":
        custom.hFlip = true;
        break;
      case "vertical":
        custom.vFlip = true;
        break;
    }
  });
}
function rotateFromString(value, defaultValue = 0) {
  const units = value.replace(/^-?[0-9.]*/, "");
  function cleanup(value$1) {
    while (value$1 < 0) value$1 += 4;
    return value$1 % 4;
  }
  if (units === "") {
    const num = parseInt(value);
    return isNaN(num) ? 0 : cleanup(num);
  } else if (units !== value) {
    let split = 0;
    switch (units) {
      case "%":
        split = 25;
        break;
      case "deg":
        split = 90;
    }
    if (split) {
      let num = parseFloat(value.slice(0, value.length - units.length));
      if (isNaN(num)) return 0;
      num = num / split;
      return num % 1 === 0 ? cleanup(num) : 0;
    }
  }
  return defaultValue;
}
function iconToHTML(body, attributes) {
  let renderAttribsHTML = body.indexOf("xlink:") === -1 ? "" : ' xmlns:xlink="http://www.w3.org/1999/xlink"';
  for (const attr in attributes) renderAttribsHTML += " " + attr + '="' + attributes[attr] + '"';
  return '<svg xmlns="http://www.w3.org/2000/svg"' + renderAttribsHTML + ">" + body + "</svg>";
}
function encodeSVGforURL(svg2) {
  return svg2.replace(/"/g, "'").replace(/%/g, "%25").replace(/#/g, "%23").replace(/</g, "%3C").replace(/>/g, "%3E").replace(/\s+/g, " ");
}
function svgToData(svg2) {
  return "data:image/svg+xml," + encodeSVGforURL(svg2);
}
function svgToURL(svg2) {
  return 'url("' + svgToData(svg2) + '")';
}
const defaultExtendedIconCustomisations = __spreadProps(__spreadValues({}, defaultIconCustomisations), {
  inline: false
});
const svgDefaults = {
  "xmlns": "http://www.w3.org/2000/svg",
  "xmlns:xlink": "http://www.w3.org/1999/xlink",
  "aria-hidden": true,
  "role": "img"
};
const commonProps = {
  display: "inline-block"
};
const monotoneProps = {
  "background-color": "currentColor"
};
const coloredProps = {
  "background-color": "transparent"
};
const propsToAdd = {
  image: "var(--svg)",
  repeat: "no-repeat",
  size: "100% 100%"
};
const propsToAddTo = {
  "-webkit-mask": monotoneProps,
  "mask": monotoneProps,
  "background": coloredProps
};
for (const prefix in propsToAddTo) {
  const list = propsToAddTo[prefix];
  for (const prop2 in propsToAdd) {
    list[prefix + "-" + prop2] = propsToAdd[prop2];
  }
}
function fixSize(value) {
  return value + (value.match(/^[-0-9.]+$/) ? "px" : "");
}
function render(icon, props) {
  const customisations = mergeCustomisations(defaultExtendedIconCustomisations, props);
  const mode = props.mode || "svg";
  const componentProps = mode === "svg" ? __spreadValues({}, svgDefaults) : {};
  if (icon.body.indexOf("xlink:") === -1) {
    delete componentProps["xmlns:xlink"];
  }
  let style = typeof props.style === "string" ? props.style : "";
  for (let key2 in props) {
    const value = props[key2];
    if (value === void 0) {
      continue;
    }
    switch (key2) {
      // Properties to ignore
      case "icon":
      case "style":
      case "onLoad":
      case "mode":
      case "ssr":
        break;
      // Boolean attributes
      case "inline":
      case "hFlip":
      case "vFlip":
        customisations[key2] = value === true || value === "true" || value === 1;
        break;
      // Flip as string: 'horizontal,vertical'
      case "flip":
        if (typeof value === "string") {
          flipFromString(customisations, value);
        }
        break;
      // Color: copy to style, add extra ';' in case style is missing it
      case "color":
        style = style + (style.length > 0 && style.trim().slice(-1) !== ";" ? ";" : "") + "color: " + value + "; ";
        break;
      // Rotation as string
      case "rotate":
        if (typeof value === "string") {
          customisations[key2] = rotateFromString(value);
        } else if (typeof value === "number") {
          customisations[key2] = value;
        }
        break;
      // Remove aria-hidden
      case "ariaHidden":
      case "aria-hidden":
        if (value !== true && value !== "true") {
          delete componentProps["aria-hidden"];
        }
        break;
      default:
        if (key2.slice(0, 3) === "on:") {
          break;
        }
        if (defaultExtendedIconCustomisations[key2] === void 0) {
          componentProps[key2] = value;
        }
    }
  }
  const item = iconToSVG(icon, customisations);
  const renderAttribs = item.attributes;
  if (customisations.inline) {
    style = "vertical-align: -0.125em; " + style;
  }
  if (mode === "svg") {
    Object.assign(componentProps, renderAttribs);
    if (style !== "") {
      componentProps.style = style;
    }
    return {
      svg: true,
      attributes: componentProps,
      body: replaceIDs(item.body)
    };
  }
  const { body, width, height } = icon;
  const useMask = mode === "mask" || (mode === "bg" ? false : body.indexOf("currentColor") !== -1);
  const html2 = iconToHTML(body, __spreadProps(__spreadValues({}, renderAttribs), {
    width: width + "",
    height: height + ""
  }));
  const url = svgToURL(html2);
  const styles = {
    "--svg": url
  };
  const size = (prop2) => {
    const value = renderAttribs[prop2];
    if (value) {
      styles[prop2] = fixSize(value);
    }
  };
  size("width");
  size("height");
  Object.assign(styles, commonProps, useMask ? monotoneProps : coloredProps);
  let customStyle = "";
  for (const key2 in styles) {
    customStyle += key2 + ": " + styles[key2] + ";";
  }
  componentProps.style = customStyle + style;
  return {
    svg: false,
    attributes: componentProps
  };
}
allowSimpleNames(true);
setAPIModule("", fetchAPIModule);
if (typeof document !== "undefined" && typeof window !== "undefined") {
  const _window = window;
  if (_window.IconifyPreload !== void 0) {
    const preload = _window.IconifyPreload;
    const err = "Invalid IconifyPreload syntax.";
    if (typeof preload === "object" && preload !== null) {
      (preload instanceof Array ? preload : [preload]).forEach((item) => {
        try {
          if (
            // Check if item is an object and not null/array
            typeof item !== "object" || item === null || item instanceof Array || // Check for 'icons' and 'prefix'
            typeof item.icons !== "object" || typeof item.prefix !== "string" || // Add icon set
            !addCollection(item)
          ) {
            console.error(err);
          }
        } catch (e) {
          console.error(err);
        }
      });
    }
  }
  if (_window.IconifyProviders !== void 0) {
    const providers = _window.IconifyProviders;
    if (typeof providers === "object" && providers !== null) {
      for (let key2 in providers) {
        const err = "IconifyProviders[" + key2 + "] is invalid.";
        try {
          const value = providers[key2];
          if (typeof value !== "object" || !value || value.resources === void 0) {
            continue;
          }
          if (!addAPIProvider(key2, value)) {
            console.error(err);
          }
        } catch (e) {
          console.error(err);
        }
      }
    }
  }
}
function isSSR() {
  try {
    return typeof window !== "object";
  } catch (err) {
    return true;
  }
}
function checkIconState(icon, state2, callback, onload) {
  function abortLoading() {
    if (state2.loading) {
      state2.loading.abort();
      state2.loading = null;
    }
  }
  if (typeof icon === "object" && icon !== null && typeof icon.body === "string") {
    state2.name = "";
    abortLoading();
    return { data: __spreadValues(__spreadValues({}, defaultIconProps), icon) };
  }
  let iconName;
  if (typeof icon !== "string" || (iconName = stringToIcon(icon, false, true)) === null) {
    abortLoading();
    return null;
  }
  const data = getIconData(iconName);
  if (!data) {
    if (!isSSR() && (!state2.loading || state2.loading.name !== icon)) {
      abortLoading();
      state2.name = "";
      state2.loading = {
        name: icon,
        abort: loadIcons([iconName], callback)
      };
    }
    return null;
  }
  abortLoading();
  if (state2.name !== icon) {
    state2.name = icon;
    if (onload && !state2.destroyed) {
      setTimeout(() => {
        onload(icon);
      });
    }
  }
  const classes = ["iconify"];
  if (iconName.prefix !== "") {
    classes.push("iconify--" + iconName.prefix);
  }
  if (iconName.provider !== "") {
    classes.push("iconify--" + iconName.provider);
  }
  return { data, classes };
}
function generateIcon(icon, props) {
  return icon ? render(__spreadValues(__spreadValues({}, defaultIconProps), icon), props) : null;
}
var root_2$p = /* @__PURE__ */ from_svg(`<svg><!></svg>`);
var root_3$l = /* @__PURE__ */ from_html(`<span></span>`);
function Icon($$anchor, $$props) {
  push($$props, true);
  const iconState = {
    // Last icon name
    name: "",
    // Loading status
    loading: null,
    // Destroyed status
    destroyed: false
  };
  const props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]);
  let counter = /* @__PURE__ */ state(0);
  let iconData = /* @__PURE__ */ user_derived(() => {
    get$3(counter);
    return checkIconState($$props.icon, iconState, loaded, $$props.onload);
  });
  let data = /* @__PURE__ */ user_derived(() => {
    const generatedData = get$3(iconData) ? generateIcon(get$3(iconData).data, props) : null;
    if (generatedData && get$3(iconData).classes) {
      generatedData.attributes["class"] = (typeof props["class"] === "string" ? props["class"] + " " : "") + get$3(iconData).classes.join(" ");
    }
    return generatedData;
  });
  function loaded() {
    update$1(counter);
  }
  onDestroy(() => {
    iconState.destroyed = true;
    if (iconState.loading) {
      iconState.loading.abort();
      iconState.loading = null;
    }
  });
  var fragment = comment$1();
  var node = first_child(fragment);
  {
    var consequent_1 = ($$anchor2) => {
      var fragment_1 = comment$1();
      var node_1 = first_child(fragment_1);
      {
        var consequent = ($$anchor3) => {
          var svg2 = root_2$p();
          attribute_effect(svg2, () => __spreadValues({}, get$3(data).attributes));
          var node_2 = child(svg2);
          html(node_2, () => get$3(data).body, true);
          append($$anchor3, svg2);
        };
        var alternate = ($$anchor3) => {
          var span = root_3$l();
          attribute_effect(span, () => __spreadValues({}, get$3(data).attributes));
          append($$anchor3, span);
        };
        if_block(node_1, ($$render) => {
          if (get$3(data).svg) $$render(consequent);
          else $$render(alternate, false);
        });
      }
      append($$anchor2, fragment_1);
    };
    if_block(node, ($$render) => {
      if (get$3(data)) $$render(consequent_1);
    });
  }
  append($$anchor, fragment);
  pop();
}
const workflowStore = writable(null);
const isDirtyStore = writable(false);
let savedSnapshot = null;
let onDirtyStateChangeCallback = null;
let onWorkflowChangeCallback = null;
function setOnDirtyStateChange(callback) {
  onDirtyStateChangeCallback = callback;
}
function setOnWorkflowChange(callback) {
  onWorkflowChangeCallback = callback;
}
function createSnapshot(workflow) {
  if (!workflow)
    return null;
  const toSnapshot = {
    name: workflow.name,
    description: workflow.description,
    nodes: workflow.nodes.map((n) => ({
      id: n.id,
      position: n.position,
      data: {
        label: n.data.label,
        config: n.data.config
      }
    })),
    edges: workflow.edges.map((e) => ({
      id: e.id,
      source: e.source,
      target: e.target,
      sourceHandle: e.sourceHandle,
      targetHandle: e.targetHandle
    }))
  };
  return JSON.stringify(toSnapshot);
}
function updateDirtyState() {
  const currentWorkflow2 = get$2(workflowStore);
  const currentSnapshot = createSnapshot(currentWorkflow2);
  const isDirty2 = currentSnapshot !== savedSnapshot;
  const previousDirty = get$2(isDirtyStore);
  if (isDirty2 !== previousDirty) {
    isDirtyStore.set(isDirty2);
    if (onDirtyStateChangeCallback) {
      onDirtyStateChangeCallback(isDirty2);
    }
  }
}
function notifyWorkflowChange(changeType) {
  const workflow = get$2(workflowStore);
  if (workflow && onWorkflowChangeCallback) {
    onWorkflowChangeCallback(workflow, changeType);
  }
  updateDirtyState();
}
function markAsSaved() {
  const currentWorkflow2 = get$2(workflowStore);
  savedSnapshot = createSnapshot(currentWorkflow2);
  isDirtyStore.set(false);
  if (onDirtyStateChangeCallback) {
    onDirtyStateChangeCallback(false);
  }
}
function isDirty() {
  return get$2(isDirtyStore);
}
function getWorkflow$1() {
  return get$2(workflowStore);
}
const workflowId = derived(workflowStore, ($workflow) => {
  var _a3;
  return (_a3 = $workflow == null ? void 0 : $workflow.id) != null ? _a3 : null;
});
const workflowName = derived(workflowStore, ($workflow) => {
  var _a3;
  return (_a3 = $workflow == null ? void 0 : $workflow.name) != null ? _a3 : "Untitled Workflow";
});
const workflowNodes = derived(workflowStore, ($workflow) => {
  var _a3;
  return (_a3 = $workflow == null ? void 0 : $workflow.nodes) != null ? _a3 : [];
});
const workflowEdges = derived(workflowStore, ($workflow) => {
  var _a3;
  return (_a3 = $workflow == null ? void 0 : $workflow.edges) != null ? _a3 : [];
});
const workflowMetadata = derived(workflowStore, ($workflow) => {
  var _a3;
  return (_a3 = $workflow == null ? void 0 : $workflow.metadata) != null ? _a3 : {
    version: "1.0.0",
    createdAt: (/* @__PURE__ */ new Date()).toISOString(),
    updatedAt: (/* @__PURE__ */ new Date()).toISOString(),
    versionId: `${Date.now()}-${Math.random().toString(36).substr(2, 9)}`,
    updateNumber: 0
  };
});
function hasWorkflowDataChanged(currentWorkflow2, newNodes, newEdges) {
  if (!currentWorkflow2)
    return true;
  if (currentWorkflow2.nodes.length !== newNodes.length)
    return true;
  for (let i = 0; i < newNodes.length; i++) {
    const currentNode = currentWorkflow2.nodes[i];
    const newNode = newNodes[i];
    if (!currentNode || !newNode)
      return true;
    if (currentNode.id !== newNode.id)
      return true;
    if (currentNode.position.x !== newNode.position.x || currentNode.position.y !== newNode.position.y)
      return true;
    if (JSON.stringify(currentNode.data) !== JSON.stringify(newNode.data))
      return true;
  }
  if (currentWorkflow2.edges.length !== newEdges.length)
    return true;
  for (let i = 0; i < newEdges.length; i++) {
    const currentEdge = currentWorkflow2.edges[i];
    const newEdge = newEdges[i];
    if (!currentEdge || !newEdge)
      return true;
    if (currentEdge.id !== newEdge.id)
      return true;
    if (currentEdge.source !== newEdge.source || currentEdge.target !== newEdge.target)
      return true;
  }
  return false;
}
const workflowActions = {
  /**
   * Initialize workflow (from load or new)
   *
   * This sets the initial saved snapshot and clears dirty state.
   */
  initialize: (workflow) => {
    workflowStore.set(workflow);
    savedSnapshot = createSnapshot(workflow);
    isDirtyStore.set(false);
    if (onDirtyStateChangeCallback) {
      onDirtyStateChangeCallback(false);
    }
  },
  /**
   * Update the entire workflow
   */
  updateWorkflow: (workflow) => {
    workflowStore.set(workflow);
    notifyWorkflowChange("metadata");
  },
  /**
   * Update nodes
   */
  updateNodes: (nodes) => {
    workflowStore.update(($workflow) => {
      var _a3, _b2;
      if (!$workflow)
        return null;
      if (!hasWorkflowDataChanged($workflow, nodes, $workflow.edges)) {
        return $workflow;
      }
      const versionId = `${Date.now()}-${Math.random().toString(36).substr(2, 9)}`;
      return __spreadProps(__spreadValues({}, $workflow), {
        nodes,
        metadata: __spreadProps(__spreadValues({}, $workflow.metadata), {
          updatedAt: (/* @__PURE__ */ new Date()).toISOString(),
          versionId,
          updateNumber: ((_b2 = (_a3 = $workflow.metadata) == null ? void 0 : _a3.updateNumber) != null ? _b2 : 0) + 1
        })
      });
    });
    notifyWorkflowChange("node_move");
  },
  /**
   * Update edges
   */
  updateEdges: (edges) => {
    workflowStore.update(($workflow) => {
      var _a3, _b2;
      if (!$workflow)
        return null;
      if (!hasWorkflowDataChanged($workflow, $workflow.nodes, edges)) {
        return $workflow;
      }
      const versionId = `${Date.now()}-${Math.random().toString(36).substr(2, 9)}`;
      return __spreadProps(__spreadValues({}, $workflow), {
        edges,
        metadata: __spreadProps(__spreadValues({}, $workflow.metadata), {
          updatedAt: (/* @__PURE__ */ new Date()).toISOString(),
          versionId,
          updateNumber: ((_b2 = (_a3 = $workflow.metadata) == null ? void 0 : _a3.updateNumber) != null ? _b2 : 0) + 1
        })
      });
    });
    notifyWorkflowChange("edge_add");
  },
  /**
   * Update workflow name
   */
  updateName: (name2) => {
    workflowStore.update(($workflow) => {
      if (!$workflow)
        return null;
      return __spreadProps(__spreadValues({}, $workflow), {
        name: name2,
        metadata: __spreadProps(__spreadValues({}, $workflow.metadata), {
          updatedAt: (/* @__PURE__ */ new Date()).toISOString()
        })
      });
    });
    notifyWorkflowChange("name");
  },
  /**
   * Add a node
   */
  addNode: (node) => {
    workflowStore.update(($workflow) => {
      if (!$workflow)
        return null;
      return __spreadProps(__spreadValues({}, $workflow), {
        nodes: [...$workflow.nodes, node],
        metadata: __spreadProps(__spreadValues({}, $workflow.metadata), {
          updatedAt: (/* @__PURE__ */ new Date()).toISOString()
        })
      });
    });
    notifyWorkflowChange("node_add");
  },
  /**
   * Remove a node
   */
  removeNode: (nodeId) => {
    workflowStore.update(($workflow) => {
      if (!$workflow)
        return null;
      return __spreadProps(__spreadValues({}, $workflow), {
        nodes: $workflow.nodes.filter((node) => node.id !== nodeId),
        edges: $workflow.edges.filter((edge) => edge.source !== nodeId && edge.target !== nodeId),
        metadata: __spreadProps(__spreadValues({}, $workflow.metadata), {
          updatedAt: (/* @__PURE__ */ new Date()).toISOString()
        })
      });
    });
    notifyWorkflowChange("node_remove");
  },
  /**
   * Add an edge
   */
  addEdge: (edge) => {
    workflowStore.update(($workflow) => {
      if (!$workflow)
        return null;
      return __spreadProps(__spreadValues({}, $workflow), {
        edges: [...$workflow.edges, edge],
        metadata: __spreadProps(__spreadValues({}, $workflow.metadata), {
          updatedAt: (/* @__PURE__ */ new Date()).toISOString()
        })
      });
    });
    notifyWorkflowChange("edge_add");
  },
  /**
   * Remove an edge
   */
  removeEdge: (edgeId) => {
    workflowStore.update(($workflow) => {
      if (!$workflow)
        return null;
      return __spreadProps(__spreadValues({}, $workflow), {
        edges: $workflow.edges.filter((edge) => edge.id !== edgeId),
        metadata: __spreadProps(__spreadValues({}, $workflow.metadata), {
          updatedAt: (/* @__PURE__ */ new Date()).toISOString()
        })
      });
    });
    notifyWorkflowChange("edge_remove");
  },
  /**
   * Update a specific node
   */
  updateNode: (nodeId, updates) => {
    workflowStore.update(($workflow) => {
      if (!$workflow)
        return null;
      return __spreadProps(__spreadValues({}, $workflow), {
        nodes: $workflow.nodes.map((node) => node.id === nodeId ? __spreadValues(__spreadValues({}, node), updates) : node),
        metadata: __spreadProps(__spreadValues({}, $workflow.metadata), {
          updatedAt: (/* @__PURE__ */ new Date()).toISOString()
        })
      });
    });
    notifyWorkflowChange("node_config");
  },
  /**
   * Clear the workflow
   */
  clear: () => {
    workflowStore.set(null);
    savedSnapshot = null;
    isDirtyStore.set(false);
    if (onDirtyStateChangeCallback) {
      onDirtyStateChangeCallback(false);
    }
  },
  /**
   * Update workflow metadata
   */
  updateMetadata: (metadata) => {
    workflowStore.update(($workflow) => {
      if (!$workflow)
        return null;
      return __spreadProps(__spreadValues({}, $workflow), {
        metadata: __spreadProps(__spreadValues(__spreadValues({}, $workflow.metadata), metadata), {
          updatedAt: (/* @__PURE__ */ new Date()).toISOString()
        })
      });
    });
    notifyWorkflowChange("metadata");
  },
  /**
   * Batch update nodes and edges
   *
   * Useful for complex operations that update multiple things at once.
   */
  batchUpdate: (updates) => {
    workflowStore.update(($workflow) => {
      if (!$workflow)
        return null;
      return __spreadProps(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues({}, $workflow), updates.nodes && { nodes: updates.nodes }), updates.edges && { edges: updates.edges }), updates.name && { name: updates.name }), updates.description !== void 0 && { description: updates.description }), {
        metadata: __spreadProps(__spreadValues(__spreadValues({}, $workflow.metadata), updates.metadata && __spreadValues({}, updates.metadata)), {
          updatedAt: (/* @__PURE__ */ new Date()).toISOString()
        })
      });
    });
    notifyWorkflowChange("metadata");
  }
};
const workflowChanged = derived([workflowNodes, workflowEdges, workflowName], ([nodes, edges, name2]) => ({ nodes, edges, name: name2 }));
const workflowValidation = derived([workflowNodes, workflowEdges], ([nodes, edges]) => ({
  hasNodes: nodes.length > 0,
  hasEdges: edges.length > 0,
  nodeCount: nodes.length,
  edgeCount: edges.length,
  isValid: nodes.length > 0 && edges.length >= 0
}));
const workflowMetadataChanged = derived(workflowMetadata, (metadata) => {
  var _a3;
  return {
    createdAt: metadata.createdAt,
    updatedAt: metadata.updatedAt,
    version: (_a3 = metadata.version) != null ? _a3 : "1.0.0"
  };
});
const connectedHandles = derived(workflowEdges, (edges) => {
  const handles = /* @__PURE__ */ new Set();
  edges.forEach((edge) => {
    if (edge.sourceHandle) {
      handles.add(edge.sourceHandle);
    }
    if (edge.targetHandle) {
      handles.add(edge.targetHandle);
    }
  });
  return handles;
});
function handleNodeClick() {
}
var on_mouseup = (
  /**
  * Handle double-click to open config
  */
  /**
   * Handle configuration sidebar - now using global ConfigSidebar
   */
  // Create a WorkflowNodeType-like object for the global ConfigSidebar
  (_2, isHandleInteraction) => {
    set$2(isHandleInteraction, false);
  }
);
var on_keydown$5 = (e, handleDoubleClick2) => {
  if (e.key === "Enter" || e.key === " ") {
    e.preventDefault();
    handleDoubleClick2();
  }
};
var root_3$k = /* @__PURE__ */ from_html(`<span class="flowdrop-badge flowdrop-badge--error flowdrop-badge--sm svelte-1apklbw">Required</span>`);
var root_4$g = /* @__PURE__ */ from_html(`<p class="flowdrop-text--xs flowdrop-text--gray flowdrop-truncate svelte-1apklbw"> </p>`);
var root_2$o = /* @__PURE__ */ from_html(`<div class="flowdrop-workflow-node__port svelte-1apklbw"><!> <div class="flowdrop-flex--1 flowdrop-min-w--0 svelte-1apklbw"><div class="flowdrop-flex flowdrop-gap--2 svelte-1apklbw"><span class="flowdrop-text--xs flowdrop-font--medium svelte-1apklbw"> </span> <span class="flowdrop-badge flowdrop-badge--sm svelte-1apklbw"> </span> <!></div> <!></div></div>`);
var root_1$A = /* @__PURE__ */ from_html(`<div class="flowdrop-workflow-node__ports svelte-1apklbw"><div class="flowdrop-workflow-node__ports-header svelte-1apklbw"><h5 class="flowdrop-workflow-node__ports-title svelte-1apklbw">Inputs</h5></div> <div class="flowdrop-workflow-node__ports-list svelte-1apklbw"></div></div>`);
var root_7$c = /* @__PURE__ */ from_html(`<p class="flowdrop-text--xs flowdrop-text--gray flowdrop-truncate svelte-1apklbw"> </p>`);
var root_6$f = /* @__PURE__ */ from_html(`<div class="flowdrop-workflow-node__port svelte-1apklbw"><div class="flowdrop-flex--1 flowdrop-min-w--0 flowdrop-text--right svelte-1apklbw"><div class="flowdrop-flex flowdrop-gap--2 flowdrop-justify--end svelte-1apklbw"><span class="flowdrop-text--xs flowdrop-font--medium svelte-1apklbw"> </span> <span class="flowdrop-badge flowdrop-badge--sm svelte-1apklbw"> </span></div> <!></div> <!></div>`);
var root_5$e = /* @__PURE__ */ from_html(`<div class="flowdrop-workflow-node__ports svelte-1apklbw"><div class="flowdrop-workflow-node__ports-header svelte-1apklbw"><h5 class="flowdrop-workflow-node__ports-title svelte-1apklbw">Outputs</h5></div> <div class="flowdrop-workflow-node__ports-list svelte-1apklbw"></div></div>`);
var root$Q = /* @__PURE__ */ from_html(`<div role="button" tabindex="0"><div class="flowdrop-workflow-node__header svelte-1apklbw"><div class="flowdrop-flex flowdrop-gap--3 flowdrop-items--center svelte-1apklbw"><div class="flowdrop-workflow-node__icon svelte-1apklbw"><!></div> <h3 class="flowdrop-text--sm flowdrop-font--medium flowdrop-truncate flowdrop-flex--1 svelte-1apklbw"> </h3> <div class="flowdrop-flex flowdrop-gap--2 flowdrop-items--center svelte-1apklbw"></div></div> <p class="flowdrop-text--xs flowdrop-text--gray flowdrop-truncate flowdrop-mt--1 svelte-1apklbw"> </p></div> <!> <!> <button class="flowdrop-workflow-node__config-btn svelte-1apklbw" title="Configure node"><!></button></div>`);
function WorkflowNode($$anchor, $$props) {
  push($$props, true);
  const $connectedHandles = () => store_get(connectedHandles, "$connectedHandles", $$stores);
  const [$$stores, $$cleanup] = setup_stores();
  let isHandleInteraction = /* @__PURE__ */ state(false);
  const displayTitle = /* @__PURE__ */ user_derived(() => {
    var _a3;
    return ((_a3 = $$props.data.config) == null ? void 0 : _a3.instanceTitle) || $$props.data.label;
  });
  const displayDescription = /* @__PURE__ */ user_derived(() => {
    var _a3;
    return ((_a3 = $$props.data.config) == null ? void 0 : _a3.instanceDescription) || $$props.data.metadata.description;
  });
  const hideUnconnectedHandles = /* @__PURE__ */ user_derived(() => () => {
    var _a3, _b2, _c2, _d2, _e3, _f2;
    const typeDefault = (_d2 = (_c2 = (_b2 = (_a3 = $$props.data.metadata) == null ? void 0 : _a3.extensions) == null ? void 0 : _b2.ui) == null ? void 0 : _c2.hideUnconnectedHandles) != null ? _d2 : false;
    const instanceOverride = (_f2 = (_e3 = $$props.data.extensions) == null ? void 0 : _e3.ui) == null ? void 0 : _f2.hideUnconnectedHandles;
    return instanceOverride != null ? instanceOverride : typeDefault;
  });
  const dynamicInputs = /* @__PURE__ */ user_derived(() => {
    var _a3;
    return (((_a3 = $$props.data.config) == null ? void 0 : _a3.dynamicInputs) || []).map((port) => dynamicPortToNodePort(port, "input"));
  });
  const dynamicOutputs = /* @__PURE__ */ user_derived(() => {
    var _a3;
    return (((_a3 = $$props.data.config) == null ? void 0 : _a3.dynamicOutputs) || []).map((port) => dynamicPortToNodePort(port, "output"));
  });
  const allInputPorts = /* @__PURE__ */ user_derived(() => [...$$props.data.metadata.inputs, ...get$3(dynamicInputs)]);
  const allOutputPorts = /* @__PURE__ */ user_derived(() => [...$$props.data.metadata.outputs, ...get$3(dynamicOutputs)]);
  function isPortVisible(port, type) {
    if (!get$3(hideUnconnectedHandles)()) {
      return true;
    }
    if (port.required) {
      return true;
    }
    const handleId = `${$$props.data.nodeId}-${type}-${port.id}`;
    return $connectedHandles().has(handleId);
  }
  const visibleInputPorts = /* @__PURE__ */ user_derived(() => get$3(allInputPorts).filter((port) => isPortVisible(port, "input")));
  const visibleOutputPorts = /* @__PURE__ */ user_derived(() => get$3(allOutputPorts).filter((port) => isPortVisible(port, "output")));
  function handleDoubleClick2() {
    openConfigSidebar();
  }
  function openConfigSidebar() {
    if ($$props.data.onConfigOpen) {
      const nodeForConfig = {
        id: $$props.data.nodeId || "unknown",
        type: "workflowNode",
        data: $$props.data
      };
      $$props.data.onConfigOpen(nodeForConfig);
    }
  }
  var div = root$Q();
  let classes;
  div.__click = [handleNodeClick];
  div.__dblclick = handleDoubleClick2;
  div.__mouseup = [on_mouseup, isHandleInteraction];
  div.__keydown = [on_keydown$5, handleDoubleClick2];
  var div_1 = child(div);
  var div_2 = child(div_1);
  var div_3 = child(div_2);
  var node = child(div_3);
  {
    let $0 = /* @__PURE__ */ user_derived(() => getNodeIcon($$props.data.metadata.icon, $$props.data.metadata.category));
    Icon(node, {
      get icon() {
        return get$3($0);
      }
    });
  }
  var h3 = sibling(div_3, 2);
  var text2 = child(h3);
  var p = sibling(div_2, 2);
  var text_1 = child(p);
  var node_1 = sibling(div_1, 2);
  {
    var consequent_2 = ($$anchor2) => {
      var div_4 = root_1$A();
      var div_5 = sibling(child(div_4), 2);
      each(div_5, 21, () => get$3(visibleInputPorts), (port) => port.id, ($$anchor3, port) => {
        var div_6 = root_2$o();
        var node_2 = child(div_6);
        {
          let $0 = /* @__PURE__ */ user_derived(() => `${$$props.data.nodeId}-input-${get$3(port).id}`);
          let $1 = /* @__PURE__ */ user_derived(() => getDataTypeColorToken(get$3(port).dataType));
          Handle(node_2, {
            type: "target",
            get position() {
              return Position.Left;
            },
            get id() {
              return get$3($0);
            },
            class: "flowdrop-workflow-node__handle",
            get style() {
              var _a3;
              return `top: 50%; transform: translateY(-50%); margin-left: -32px; background-color: ${(_a3 = get$3($1)) != null ? _a3 : ""}; border-color: '#ffffff';`;
            },
            role: "button",
            tabindex: 0,
            get "aria-label"() {
              var _a3;
              return `Connect to ${(_a3 = get$3(port).name) != null ? _a3 : ""} input port`;
            }
          });
        }
        var div_7 = sibling(node_2, 2);
        var div_8 = child(div_7);
        var span = child(div_8);
        var text_2 = child(span);
        var span_1 = sibling(span, 2);
        var text_3 = child(span_1);
        var node_3 = sibling(span_1, 2);
        {
          var consequent = ($$anchor4) => {
            var span_2 = root_3$k();
            append($$anchor4, span_2);
          };
          if_block(node_3, ($$render) => {
            if (get$3(port).required) $$render(consequent);
          });
        }
        var node_4 = sibling(div_8, 2);
        {
          var consequent_1 = ($$anchor4) => {
            var p_1 = root_4$g();
            var text_4 = child(p_1);
            template_effect(() => set_text(text_4, get$3(port).description));
            append($$anchor4, p_1);
          };
          if_block(node_4, ($$render) => {
            if (get$3(port).description) $$render(consequent_1);
          });
        }
        template_effect(
          ($0) => {
            set_text(text_2, get$3(port).name);
            set_style(span_1, `background-color: ${$0 != null ? $0 : ""}; color: #fff;`);
            set_text(text_3, get$3(port).dataType);
          },
          [() => getDataTypeColorToken(get$3(port).dataType)]
        );
        append($$anchor3, div_6);
      });
      append($$anchor2, div_4);
    };
    if_block(node_1, ($$render) => {
      if (get$3(visibleInputPorts).length > 0) $$render(consequent_2);
    });
  }
  var node_5 = sibling(node_1, 2);
  {
    var consequent_4 = ($$anchor2) => {
      var div_9 = root_5$e();
      var div_10 = sibling(child(div_9), 2);
      each(div_10, 21, () => get$3(visibleOutputPorts), (port) => port.id, ($$anchor3, port) => {
        var div_11 = root_6$f();
        var div_12 = child(div_11);
        var div_13 = child(div_12);
        var span_3 = child(div_13);
        var text_5 = child(span_3);
        var span_4 = sibling(span_3, 2);
        var text_6 = child(span_4);
        var node_6 = sibling(div_13, 2);
        {
          var consequent_3 = ($$anchor4) => {
            var p_2 = root_7$c();
            var text_7 = child(p_2);
            template_effect(() => set_text(text_7, get$3(port).description));
            append($$anchor4, p_2);
          };
          if_block(node_6, ($$render) => {
            if (get$3(port).description) $$render(consequent_3);
          });
        }
        var node_7 = sibling(div_12, 2);
        {
          let $0 = /* @__PURE__ */ user_derived(() => `${$$props.data.nodeId}-output-${get$3(port).id}`);
          let $1 = /* @__PURE__ */ user_derived(() => getDataTypeColorToken(get$3(port).dataType));
          Handle(node_7, {
            type: "source",
            get position() {
              return Position.Right;
            },
            get id() {
              return get$3($0);
            },
            class: "flowdrop-workflow-node__handle",
            get style() {
              var _a3;
              return `top: 50%; transform: translateY(-50%); margin-right: -32px; background-color: ${(_a3 = get$3($1)) != null ? _a3 : ""}; border-color: '#ffffff';`;
            },
            role: "button",
            tabindex: 0,
            get "aria-label"() {
              var _a3;
              return `Connect from ${(_a3 = get$3(port).name) != null ? _a3 : ""} output port`;
            }
          });
        }
        template_effect(
          ($0) => {
            set_text(text_5, get$3(port).name);
            set_style(span_4, `background-color: ${$0 != null ? $0 : ""}; color: #fff;`);
            set_text(text_6, get$3(port).dataType);
          },
          [() => getDataTypeColorToken(get$3(port).dataType)]
        );
        append($$anchor3, div_11);
      });
      append($$anchor2, div_9);
    };
    if_block(node_5, ($$render) => {
      if (get$3(visibleOutputPorts).length > 0) $$render(consequent_4);
    });
  }
  var button = sibling(node_5, 2);
  button.__click = openConfigSidebar;
  var node_8 = child(button);
  Icon(node_8, { icon: "mdi:cog" });
  template_effect(
    ($0, $1) => {
      var _a3, _b2, _c2;
      classes = set_class(div, 1, "flowdrop-workflow-node svelte-1apklbw", null, classes, $0);
      set_attribute(div, "data-handle-interaction", get$3(isHandleInteraction));
      set_attribute(div, "aria-label", `Workflow node: ${(_a3 = $$props.data.metadata.name) != null ? _a3 : ""}`);
      set_attribute(div, "aria-describedby", `node-description-${(_b2 = $$props.data.nodeId || "unknown") != null ? _b2 : ""}`);
      set_style(div_3, `background-color: ${$1 != null ? $1 : ""}`);
      set_text(text2, get$3(displayTitle));
      set_attribute(p, "id", `node-description-${(_c2 = $$props.data.nodeId || "unknown") != null ? _c2 : ""}`);
      set_text(text_1, get$3(displayDescription));
    },
    [
      () => ({ "flowdrop-workflow-node--selected": $$props.selected }),
      () => getCategoryColorToken($$props.data.metadata.category)
    ]
  );
  append($$anchor, div);
  pop();
  $$cleanup();
}
delegate(["click", "dblclick", "mouseup", "keydown"]);
function handleClick$4() {
}
function handleKeydown$a(event2, handleDoubleClick2) {
  if (event2.key === "Enter" || event2.key === " ") {
    event2.preventDefault();
    handleDoubleClick2();
  }
}
var root_2$n = /* @__PURE__ */ from_html(`<div class="flowdrop-simple-node__processing svelte-qs70ux"><div class="flowdrop-simple-node__spinner svelte-qs70ux"></div></div>`);
var root_3$j = /* @__PURE__ */ from_html(`<div class="flowdrop-simple-node__error svelte-qs70ux"><!></div>`);
var root$P = /* @__PURE__ */ from_html(`<!> <div role="button" tabindex="0"><div class="flowdrop-simple-node__header svelte-qs70ux"><div class="flowdrop-simple-node__header-content svelte-qs70ux"><div class="flowdrop-simple-node__icon-container svelte-qs70ux"><!></div> <h3 class="flowdrop-simple-node__title svelte-qs70ux"> </h3></div> <p class="flowdrop-simple-node__description svelte-qs70ux"> </p></div> <!> <!> <button class="flowdrop-simple-node__config-btn svelte-qs70ux" title="Configure node"><!></button></div> <!>`, 1);
function SimpleNode($$anchor, $$props) {
  push($$props, true);
  const $connectedHandles = () => store_get(connectedHandles, "$connectedHandles", $$stores);
  const [$$stores, $$cleanup] = setup_stores();
  const hideUnconnectedHandles = /* @__PURE__ */ user_derived(() => () => {
    var _a3, _b2, _c2, _d2, _e3, _f2;
    const typeDefault = (_d2 = (_c2 = (_b2 = (_a3 = $$props.data.metadata) == null ? void 0 : _a3.extensions) == null ? void 0 : _b2.ui) == null ? void 0 : _c2.hideUnconnectedHandles) != null ? _d2 : false;
    const instanceOverride = (_f2 = (_e3 = $$props.data.extensions) == null ? void 0 : _e3.ui) == null ? void 0 : _f2.hideUnconnectedHandles;
    return instanceOverride != null ? instanceOverride : typeDefault;
  });
  let nodeIcon = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return ((_a3 = $$props.data.metadata) == null ? void 0 : _a3.icon) || ((_b2 = $$props.data.config) == null ? void 0 : _b2.icon) || "mdi:square";
  });
  let nodeColor = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return ((_a3 = $$props.data.metadata) == null ? void 0 : _a3.color) || ((_b2 = $$props.data.config) == null ? void 0 : _b2.color) || "#6366f1";
  });
  const displayTitle = /* @__PURE__ */ user_derived(() => {
    var _a3;
    return ((_a3 = $$props.data.config) == null ? void 0 : _a3.instanceTitle) || $$props.data.label;
  });
  const displayDescription = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return ((_a3 = $$props.data.config) == null ? void 0 : _a3.instanceDescription) || ((_b2 = $$props.data.metadata) == null ? void 0 : _b2.description) || "A configurable simple node";
  });
  function openConfigSidebar() {
    if ($$props.data.onConfigOpen) {
      const nodeForConfig = {
        id: $$props.data.nodeId || "unknown",
        type: "simple",
        data: $$props.data
      };
      $$props.data.onConfigOpen(nodeForConfig);
    }
  }
  function handleDoubleClick2() {
    openConfigSidebar();
  }
  function isPortConnected(portId, type) {
    const handleId = `${$$props.data.nodeId}-${type}-${portId}`;
    return $connectedHandles().has(handleId);
  }
  function shouldShowTriggerPort(portId, type) {
    if (!get$3(hideUnconnectedHandles)()) {
      return true;
    }
    return isPortConnected(portId, type);
  }
  let triggerInputPort = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return (_b2 = (_a3 = $$props.data.metadata) == null ? void 0 : _a3.inputs) == null ? void 0 : _b2.find((port) => port.dataType === "trigger");
  });
  let triggerOutputPort = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return (_b2 = (_a3 = $$props.data.metadata) == null ? void 0 : _a3.outputs) == null ? void 0 : _b2.find((port) => port.dataType === "trigger");
  });
  let firstConnectedDataInputPort = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return (_b2 = (_a3 = $$props.data.metadata) == null ? void 0 : _a3.inputs) == null ? void 0 : _b2.find((port) => port.dataType !== "trigger" && isPortConnected(port.id, "input"));
  });
  let firstDataInputPort = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return (_b2 = (_a3 = $$props.data.metadata) == null ? void 0 : _a3.inputs) == null ? void 0 : _b2.find((port) => port.dataType !== "trigger");
  });
  let firstConnectedDataOutputPort = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return (_b2 = (_a3 = $$props.data.metadata) == null ? void 0 : _a3.outputs) == null ? void 0 : _b2.find((port) => port.dataType !== "trigger" && isPortConnected(port.id, "output"));
  });
  let firstDataOutputPort = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return (_b2 = (_a3 = $$props.data.metadata) == null ? void 0 : _a3.outputs) == null ? void 0 : _b2.find((port) => port.dataType !== "trigger");
  });
  let inputPorts = /* @__PURE__ */ user_derived(() => {
    return [
      ...get$3(firstConnectedDataInputPort) ? [get$3(firstConnectedDataInputPort)] : get$3(firstDataInputPort) ? [get$3(firstDataInputPort)] : [],
      ...get$3(triggerInputPort) && shouldShowTriggerPort(get$3(triggerInputPort).id, "input") ? [get$3(triggerInputPort)] : []
    ];
  });
  let outputPorts = /* @__PURE__ */ user_derived(() => {
    return [
      ...get$3(firstConnectedDataOutputPort) ? [get$3(firstConnectedDataOutputPort)] : get$3(firstDataOutputPort) ? [get$3(firstDataOutputPort)] : [],
      ...get$3(triggerOutputPort) && shouldShowTriggerPort(get$3(triggerOutputPort).id, "output") ? [get$3(triggerOutputPort)] : []
    ];
  });
  var fragment = root$P();
  var node = first_child(fragment);
  each(node, 17, () => get$3(inputPorts), index$1, ($$anchor2, port, index2) => {
    {
      let $0 = /* @__PURE__ */ user_derived(() => getDataTypeColor(get$3(port).dataType));
      let $1 = /* @__PURE__ */ user_derived(() => get$3(inputPorts).length > 1 ? index2 === 0 ? "25%" : "75%" : "50%");
      let $2 = /* @__PURE__ */ user_derived(() => `${$$props.data.nodeId}-input-${get$3(port).id}`);
      Handle($$anchor2, {
        type: "target",
        get position() {
          return Position.Left;
        },
        get style() {
          var _a3, _b2;
          return `background-color: ${(_a3 = get$3($0)) != null ? _a3 : ""}; border-color: '#ffffff'; top: ${(_b2 = get$3($1)) != null ? _b2 : ""}; z-index: 30;`;
        },
        get id() {
          return get$3($2);
        }
      });
    }
  });
  var div = sibling(node, 2);
  let classes;
  div.__click = [handleClick$4];
  div.__dblclick = handleDoubleClick2;
  div.__keydown = [handleKeydown$a, handleDoubleClick2];
  var div_1 = child(div);
  var div_2 = child(div_1);
  var div_3 = child(div_2);
  var node_1 = child(div_3);
  Icon(node_1, {
    get icon() {
      return get$3(nodeIcon);
    },
    class: "flowdrop-simple-node__icon"
  });
  var h3 = sibling(div_3, 2);
  var text2 = child(h3);
  var p = sibling(div_2, 2);
  var text_1 = child(p);
  var node_2 = sibling(div_1, 2);
  {
    var consequent = ($$anchor2) => {
      var div_4 = root_2$n();
      append($$anchor2, div_4);
    };
    if_block(node_2, ($$render) => {
      if ($$props.isProcessing) $$render(consequent);
    });
  }
  var node_3 = sibling(node_2, 2);
  {
    var consequent_1 = ($$anchor2) => {
      var div_5 = root_3$j();
      var node_4 = child(div_5);
      Icon(node_4, {
        icon: "mdi:alert-circle",
        class: "flowdrop-simple-node__error-icon"
      });
      append($$anchor2, div_5);
    };
    if_block(node_3, ($$render) => {
      if ($$props.isError) $$render(consequent_1);
    });
  }
  var button = sibling(node_3, 2);
  button.__click = openConfigSidebar;
  var node_5 = child(button);
  Icon(node_5, { icon: "mdi:cog" });
  var node_6 = sibling(div, 2);
  each(node_6, 17, () => get$3(outputPorts), index$1, ($$anchor2, port, index2) => {
    {
      let $0 = /* @__PURE__ */ user_derived(() => getDataTypeColor(get$3(port).dataType));
      let $1 = /* @__PURE__ */ user_derived(() => get$3(outputPorts).length > 1 ? index2 === 0 ? "25%" : "75%" : "50%");
      let $2 = /* @__PURE__ */ user_derived(() => `${$$props.data.nodeId}-output-${get$3(port).id}`);
      Handle($$anchor2, {
        type: "source",
        get position() {
          return Position.Right;
        },
        get style() {
          var _a3, _b2;
          return `background-color: ${(_a3 = get$3($0)) != null ? _a3 : ""}; border-color: '#ffffff'; top: ${(_b2 = get$3($1)) != null ? _b2 : ""}; z-index: 30;`;
        },
        get id() {
          return get$3($2);
        }
      });
    }
  });
  template_effect(
    ($0) => {
      var _a3;
      classes = set_class(div, 1, "flowdrop-simple-node flowdrop-simple-node--normal svelte-qs70ux", null, classes, $0);
      set_style(div_3, `background-color: ${(_a3 = get$3(nodeColor)) != null ? _a3 : ""}`);
      set_text(text2, get$3(displayTitle));
      set_text(text_1, get$3(displayDescription));
    },
    [
      () => ({
        "flowdrop-simple-node--selected": $$props.selected,
        "flowdrop-simple-node--processing": $$props.isProcessing,
        "flowdrop-simple-node--error": $$props.isError
      })
    ]
  );
  append($$anchor, fragment);
  pop();
  $$cleanup();
}
delegate(["click", "dblclick", "keydown"]);
function handleDoubleClick(_2, openConfigSidebar) {
  openConfigSidebar();
}
function handleClick$3(__1, openConfigSidebar) {
  openConfigSidebar();
}
function handleKeydown$9(event2, openConfigSidebar) {
  if (event2.key === "Enter" || event2.key === " ") {
    event2.preventDefault();
    openConfigSidebar();
  }
}
var root_2$m = /* @__PURE__ */ from_html(`<div class="flowdrop-square-node__processing svelte-uc5kkq"><div class="flowdrop-square-node__spinner svelte-uc5kkq"></div></div>`);
var root_3$i = /* @__PURE__ */ from_html(`<div class="flowdrop-square-node__error svelte-uc5kkq"><!></div>`);
var root$O = /* @__PURE__ */ from_html(`<!> <div role="button" tabindex="0"><div class="flowdrop-square-node__compact-content svelte-uc5kkq"><!></div> <!> <!> <button class="flowdrop-square-node__config-btn svelte-uc5kkq" title="Configure node"><!></button></div> <!>`, 1);
function SquareNode($$anchor, $$props) {
  push($$props, true);
  const $connectedHandles = () => store_get(connectedHandles, "$connectedHandles", $$stores);
  const [$$stores, $$cleanup] = setup_stores();
  const hideUnconnectedHandles = /* @__PURE__ */ user_derived(() => () => {
    var _a3, _b2, _c2, _d2, _e3, _f2;
    const typeDefault = (_d2 = (_c2 = (_b2 = (_a3 = $$props.data.metadata) == null ? void 0 : _a3.extensions) == null ? void 0 : _b2.ui) == null ? void 0 : _c2.hideUnconnectedHandles) != null ? _d2 : false;
    const instanceOverride = (_f2 = (_e3 = $$props.data.extensions) == null ? void 0 : _e3.ui) == null ? void 0 : _f2.hideUnconnectedHandles;
    return instanceOverride != null ? instanceOverride : typeDefault;
  });
  let squareIcon = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return ((_a3 = $$props.data.metadata) == null ? void 0 : _a3.icon) || ((_b2 = $$props.data.config) == null ? void 0 : _b2.icon) || "mdi:square";
  });
  let squareColor = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return ((_a3 = $$props.data.metadata) == null ? void 0 : _a3.color) || ((_b2 = $$props.data.config) == null ? void 0 : _b2.color) || "#6366f1";
  });
  const currentLayout = {
    iconSize: "2rem"
  };
  function openConfigSidebar() {
    if ($$props.data.onConfigOpen) {
      const nodeForConfig = {
        id: $$props.data.nodeId || "unknown",
        type: "square",
        data: $$props.data
      };
      $$props.data.onConfigOpen(nodeForConfig);
    }
  }
  function isPortConnected(portId, type) {
    const handleId = `${$$props.data.nodeId}-${type}-${portId}`;
    return $connectedHandles().has(handleId);
  }
  function shouldShowTriggerPort(portId, type) {
    if (!get$3(hideUnconnectedHandles)()) {
      return true;
    }
    return isPortConnected(portId, type);
  }
  let triggerInputPort = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return (_b2 = (_a3 = $$props.data.metadata) == null ? void 0 : _a3.inputs) == null ? void 0 : _b2.find((port) => port.dataType === "trigger");
  });
  let triggerOutputPort = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return (_b2 = (_a3 = $$props.data.metadata) == null ? void 0 : _a3.outputs) == null ? void 0 : _b2.find((port) => port.dataType === "trigger");
  });
  let firstConnectedDataInputPort = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return (_b2 = (_a3 = $$props.data.metadata) == null ? void 0 : _a3.inputs) == null ? void 0 : _b2.find((port) => port.dataType !== "trigger" && isPortConnected(port.id, "input"));
  });
  let firstDataInputPort = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return (_b2 = (_a3 = $$props.data.metadata) == null ? void 0 : _a3.inputs) == null ? void 0 : _b2.find((port) => port.dataType !== "trigger");
  });
  let firstConnectedDataOutputPort = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return (_b2 = (_a3 = $$props.data.metadata) == null ? void 0 : _a3.outputs) == null ? void 0 : _b2.find((port) => port.dataType !== "trigger" && isPortConnected(port.id, "output"));
  });
  let firstDataOutputPort = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return (_b2 = (_a3 = $$props.data.metadata) == null ? void 0 : _a3.outputs) == null ? void 0 : _b2.find((port) => port.dataType !== "trigger");
  });
  let inputPorts = /* @__PURE__ */ user_derived(() => {
    return [
      ...get$3(firstConnectedDataInputPort) ? [get$3(firstConnectedDataInputPort)] : get$3(firstDataInputPort) ? [get$3(firstDataInputPort)] : [],
      ...get$3(triggerInputPort) && shouldShowTriggerPort(get$3(triggerInputPort).id, "input") ? [get$3(triggerInputPort)] : []
    ];
  });
  let outputPorts = /* @__PURE__ */ user_derived(() => {
    return [
      ...get$3(firstConnectedDataOutputPort) ? [get$3(firstConnectedDataOutputPort)] : get$3(firstDataOutputPort) ? [get$3(firstDataOutputPort)] : [],
      ...get$3(triggerOutputPort) && shouldShowTriggerPort(get$3(triggerOutputPort).id, "output") ? [get$3(triggerOutputPort)] : []
    ];
  });
  var fragment = root$O();
  var node = first_child(fragment);
  each(node, 17, () => get$3(inputPorts), index$1, ($$anchor2, port, index2) => {
    {
      let $0 = /* @__PURE__ */ user_derived(() => getDataTypeColor(get$3(port).dataType));
      let $1 = /* @__PURE__ */ user_derived(() => get$3(inputPorts).length > 1 ? index2 === 0 ? "25%" : "75%" : "50%");
      let $2 = /* @__PURE__ */ user_derived(() => `${$$props.data.nodeId}-input-${get$3(port).id}`);
      Handle($$anchor2, {
        type: "target",
        get position() {
          return Position.Left;
        },
        get style() {
          var _a3, _b2;
          return `background-color: ${(_a3 = get$3($0)) != null ? _a3 : ""}; border-color: '#ffffff'; top: ${(_b2 = get$3($1)) != null ? _b2 : ""}; z-index: 30;`;
        },
        get id() {
          return get$3($2);
        }
      });
    }
  });
  var div = sibling(node, 2);
  let classes;
  div.__click = [handleClick$3, openConfigSidebar];
  div.__dblclick = [handleDoubleClick, openConfigSidebar];
  div.__keydown = [handleKeydown$9, openConfigSidebar];
  var div_1 = child(div);
  var node_1 = child(div_1);
  Icon(node_1, {
    get icon() {
      return get$3(squareIcon);
    },
    class: "flowdrop-square-node__compact-icon",
    get style() {
      var _a3;
      return `color: ${(_a3 = get$3(squareColor)) != null ? _a3 : ""}; font-size: ${currentLayout.iconSize};`;
    }
  });
  var node_2 = sibling(div_1, 2);
  {
    var consequent = ($$anchor2) => {
      var div_2 = root_2$m();
      append($$anchor2, div_2);
    };
    if_block(node_2, ($$render) => {
      if ($$props.isProcessing) $$render(consequent);
    });
  }
  var node_3 = sibling(node_2, 2);
  {
    var consequent_1 = ($$anchor2) => {
      var div_3 = root_3$i();
      var node_4 = child(div_3);
      Icon(node_4, {
        icon: "mdi:alert-circle",
        class: "flowdrop-square-node__error-icon"
      });
      append($$anchor2, div_3);
    };
    if_block(node_3, ($$render) => {
      if ($$props.isError) $$render(consequent_1);
    });
  }
  var button = sibling(node_3, 2);
  button.__click = openConfigSidebar;
  var node_5 = child(button);
  Icon(node_5, { icon: "mdi:cog" });
  var node_6 = sibling(div, 2);
  each(node_6, 17, () => get$3(outputPorts), index$1, ($$anchor2, port, index2) => {
    {
      let $0 = /* @__PURE__ */ user_derived(() => getDataTypeColor(get$3(port).dataType));
      let $1 = /* @__PURE__ */ user_derived(() => get$3(outputPorts).length > 1 ? index2 === 0 ? "25%" : "75%" : "50%");
      let $2 = /* @__PURE__ */ user_derived(() => `${$$props.data.nodeId}-output-${get$3(port).id}`);
      Handle($$anchor2, {
        type: "source",
        get position() {
          return Position.Right;
        },
        get style() {
          var _a3, _b2;
          return `background-color: ${(_a3 = get$3($0)) != null ? _a3 : ""}; border-color: '#ffffff'; top: ${(_b2 = get$3($1)) != null ? _b2 : ""}; z-index: 30;`;
        },
        get id() {
          return get$3($2);
        }
      });
    }
  });
  template_effect(($0) => classes = set_class(div, 1, "flowdrop-square-node flowdrop-square-node--compact svelte-uc5kkq", null, classes, $0), [
    () => ({
      "flowdrop-square-node--selected": $$props.selected,
      "flowdrop-square-node--processing": $$props.isProcessing,
      "flowdrop-square-node--error": $$props.isError
    })
  ]);
  append($$anchor, fragment);
  pop();
  $$cleanup();
}
delegate(["click", "dblclick", "keydown"]);
function handleClick$2() {
}
function handleKeydown$8(event2, handleDoubleClick2) {
  if (event2.key === "Enter" || event2.key === " ") {
    event2.preventDefault();
    handleDoubleClick2();
  }
}
var root_2$l = /* @__PURE__ */ from_html(`<div class="flowdrop-tool-node__processing svelte-3lmrox"><div class="flowdrop-tool-node__spinner svelte-3lmrox"></div></div>`);
var root_3$h = /* @__PURE__ */ from_html(`<div class="flowdrop-tool-node__error svelte-3lmrox"><!></div>`);
var root$N = /* @__PURE__ */ from_html(`<!> <div role="button" tabindex="0"><div class="flowdrop-tool-node__header svelte-3lmrox"><div class="flowdrop-tool-node__header-content svelte-3lmrox"><div class="flowdrop-tool-node__icon-container svelte-3lmrox"><!></div> <div class="flowdrop-tool-node__info svelte-3lmrox"><h3 class="flowdrop-tool-node__title svelte-3lmrox"> </h3> <div class="flowdrop-tool-node__version svelte-3lmrox"> </div></div> <div class="flowdrop-tool-node__badge svelte-3lmrox">TOOL</div></div> <p class="flowdrop-tool-node__description svelte-3lmrox"> </p></div> <!> <!> <button class="flowdrop-tool-node__config-btn svelte-3lmrox" title="Configure tool"><!></button></div> <!>`, 1);
function ToolNode($$anchor, $$props) {
  push($$props, true);
  let toolIcon = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return ((_a3 = $$props.data.metadata) == null ? void 0 : _a3.icon) || ((_b2 = $$props.data.config) == null ? void 0 : _b2.icon) || "mdi:tools";
  });
  let toolColor = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return ((_a3 = $$props.data.metadata) == null ? void 0 : _a3.color) || ((_b2 = $$props.data.config) == null ? void 0 : _b2.color) || "#f59e0b";
  });
  const displayTitle = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2, _c2;
    return ((_a3 = $$props.data.config) == null ? void 0 : _a3.instanceTitle) || ((_b2 = $$props.data.metadata) == null ? void 0 : _b2.name) || ((_c2 = $$props.data.config) == null ? void 0 : _c2.toolName) || $$props.data.label || "Tool";
  });
  const displayDescription = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2, _c2;
    return ((_a3 = $$props.data.config) == null ? void 0 : _a3.instanceDescription) || ((_b2 = $$props.data.metadata) == null ? void 0 : _b2.description) || ((_c2 = $$props.data.config) == null ? void 0 : _c2.toolDescription) || "A configurable tool for agents";
  });
  let toolVersion = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return ((_a3 = $$props.data.metadata) == null ? void 0 : _a3.version) || ((_b2 = $$props.data.config) == null ? void 0 : _b2.toolVersion) || "1.0.0";
  });
  let colorVariants = /* @__PURE__ */ user_derived(() => getColorVariants(get$3(toolColor)));
  let nodeStyle = /* @__PURE__ */ user_derived(() => [
    `--flowdrop-tool-node-color: ${get$3(colorVariants).base}`,
    `--flowdrop-tool-node-color-light: ${get$3(colorVariants).light}`,
    `--flowdrop-tool-node-color-border: ${get$3(colorVariants).border}`
  ].join("; "));
  let hasToolInputPort = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return ((_b2 = (_a3 = $$props.data.metadata) == null ? void 0 : _a3.inputs) == null ? void 0 : _b2.some((port) => port.dataType === "tool")) || false;
  });
  let hasToolOutputPort = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return ((_b2 = (_a3 = $$props.data.metadata) == null ? void 0 : _a3.outputs) == null ? void 0 : _b2.some((port) => port.dataType === "tool")) || false;
  });
  let toolInputPort = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return (_b2 = (_a3 = $$props.data.metadata) == null ? void 0 : _a3.inputs) == null ? void 0 : _b2.find((port) => port.dataType === "tool");
  });
  let toolOutputPort = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return (_b2 = (_a3 = $$props.data.metadata) == null ? void 0 : _a3.outputs) == null ? void 0 : _b2.find((port) => port.dataType === "tool");
  });
  function openConfigSidebar() {
    if ($$props.data.onConfigOpen) {
      const nodeForConfig = {
        id: $$props.data.nodeId || "unknown",
        type: "tool",
        data: $$props.data
      };
      $$props.data.onConfigOpen(nodeForConfig);
    }
  }
  function handleDoubleClick2() {
    openConfigSidebar();
  }
  var fragment = root$N();
  var node = first_child(fragment);
  {
    var consequent = ($$anchor2) => {
      {
        let $0 = /* @__PURE__ */ user_derived(() => `${$$props.data.nodeId}-input-${get$3(toolInputPort).id}`);
        let $1 = /* @__PURE__ */ user_derived(() => getDataTypeColor("tool"));
        Handle($$anchor2, {
          type: "target",
          get position() {
            return Position.Left;
          },
          get id() {
            return get$3($0);
          },
          get style() {
            var _a3;
            return `background-color: ${(_a3 = get$3($1)) != null ? _a3 : ""}; border-color: '#ffffff';`;
          }
        });
      }
    };
    if_block(node, ($$render) => {
      if (get$3(hasToolInputPort) && get$3(toolInputPort)) $$render(consequent);
    });
  }
  var div = sibling(node, 2);
  let classes;
  div.__click = [handleClick$2];
  div.__dblclick = handleDoubleClick2;
  div.__keydown = [handleKeydown$8, handleDoubleClick2];
  var div_1 = child(div);
  var div_2 = child(div_1);
  var div_3 = child(div_2);
  var node_1 = child(div_3);
  Icon(node_1, {
    get icon() {
      return get$3(toolIcon);
    },
    class: "flowdrop-tool-node__icon"
  });
  var div_4 = sibling(div_3, 2);
  var h3 = child(div_4);
  var text2 = child(h3);
  var div_5 = sibling(h3, 2);
  var text_1 = child(div_5);
  var p = sibling(div_2, 2);
  var text_2 = child(p);
  var node_2 = sibling(div_1, 2);
  {
    var consequent_1 = ($$anchor2) => {
      var div_6 = root_2$l();
      append($$anchor2, div_6);
    };
    if_block(node_2, ($$render) => {
      if ($$props.isProcessing) $$render(consequent_1);
    });
  }
  var node_3 = sibling(node_2, 2);
  {
    var consequent_2 = ($$anchor2) => {
      var div_7 = root_3$h();
      var node_4 = child(div_7);
      Icon(node_4, {
        icon: "mdi:alert-circle",
        class: "flowdrop-tool-node__error-icon"
      });
      append($$anchor2, div_7);
    };
    if_block(node_3, ($$render) => {
      if ($$props.isError) $$render(consequent_2);
    });
  }
  var button = sibling(node_3, 2);
  button.__click = openConfigSidebar;
  var node_5 = child(button);
  Icon(node_5, { icon: "mdi:cog" });
  var node_6 = sibling(div, 2);
  {
    var consequent_3 = ($$anchor2) => {
      {
        let $0 = /* @__PURE__ */ user_derived(() => `${$$props.data.nodeId}-output-${get$3(toolOutputPort).id}`);
        let $1 = /* @__PURE__ */ user_derived(() => getDataTypeColor("tool"));
        Handle($$anchor2, {
          type: "source",
          get position() {
            return Position.Right;
          },
          get id() {
            return get$3($0);
          },
          get style() {
            var _a3;
            return `background-color: ${(_a3 = get$3($1)) != null ? _a3 : ""}; border-color: '#ffffff';`;
          }
        });
      }
    };
    if_block(node_6, ($$render) => {
      if (get$3(hasToolOutputPort) && get$3(toolOutputPort)) $$render(consequent_3);
    });
  }
  template_effect(
    ($0) => {
      var _a3;
      classes = set_class(div, 1, "flowdrop-tool-node svelte-3lmrox", null, classes, $0);
      set_style(div, get$3(nodeStyle));
      set_text(text2, get$3(displayTitle));
      set_text(text_1, `v${(_a3 = get$3(toolVersion)) != null ? _a3 : ""}`);
      set_text(text_2, get$3(displayDescription));
    },
    [
      () => ({
        "flowdrop-tool-node--selected": $$props.selected,
        "flowdrop-tool-node--processing": $$props.isProcessing,
        "flowdrop-tool-node--error": $$props.isError
      })
    ]
  );
  append($$anchor, fragment);
  pop();
}
delegate(["click", "dblclick", "keydown"]);
function handleNodeDoubleClick(_2, props, $$props) {
  if ($$props.data.onConfigOpen) {
    $$props.data.onConfigOpen({
      id: $$props.data.nodeId || "",
      type: "gateway",
      data: $$props.data
    });
  }
}
function handleKeydown$7(event2, handleNodeClick2) {
  if (event2.key === "Enter" || event2.key === " ") {
    event2.preventDefault();
    handleNodeClick2();
  }
}
var root_3$g = /* @__PURE__ */ from_html(`<span class="flowdrop-badge flowdrop-badge--error flowdrop-badge--sm svelte-1f7e5pt">Required</span>`);
var root_4$f = /* @__PURE__ */ from_html(`<p class="flowdrop-text--xs flowdrop-text--gray flowdrop-truncate svelte-1f7e5pt"> </p>`);
var root_2$k = /* @__PURE__ */ from_html(`<div class="flowdrop-workflow-node__port svelte-1f7e5pt"><!> <div class="flowdrop-flex--1 flowdrop-min-w--0 svelte-1f7e5pt"><div class="flowdrop-flex flowdrop-gap--2 svelte-1f7e5pt"><span class="flowdrop-text--xs flowdrop-font--medium svelte-1f7e5pt"> </span> <span class="flowdrop-badge flowdrop-badge--sm svelte-1f7e5pt"> </span> <!></div> <!></div></div>`);
var root_1$z = /* @__PURE__ */ from_html(`<div class="flowdrop-workflow-node__ports svelte-1f7e5pt"><div class="flowdrop-workflow-node__ports-header svelte-1f7e5pt"><h5 class="flowdrop-workflow-node__ports-title svelte-1f7e5pt">Inputs</h5></div> <div class="flowdrop-workflow-node__ports-list svelte-1f7e5pt"></div></div>`);
var root_7$b = /* @__PURE__ */ from_html(`<span><!></span>`);
var root_6$e = /* @__PURE__ */ from_html(`<div class="flowdrop-workflow-node__port svelte-1f7e5pt"><div class="flowdrop-flex--1 flowdrop-min-w--0 flowdrop-text--right svelte-1f7e5pt"><div class="flowdrop-flex flowdrop-gap--2 flowdrop-justify--end flowdrop-items--center svelte-1f7e5pt"><!> <span> </span> <span class="flowdrop-badge flowdrop-badge--sm svelte-1f7e5pt">trigger</span></div></div> <!></div>`);
var root_5$d = /* @__PURE__ */ from_html(`<div class="flowdrop-workflow-node__ports svelte-1f7e5pt"><div class="flowdrop-workflow-node__ports-header svelte-1f7e5pt"><h5 class="flowdrop-workflow-node__ports-title svelte-1f7e5pt"><!> <span> </span></h5></div> <div class="flowdrop-workflow-node__ports-list svelte-1f7e5pt"></div></div>`);
var root_9$5 = /* @__PURE__ */ from_html(`<div class="flowdrop-workflow-node__ports svelte-1f7e5pt"><div class="workflow-node__no-branches svelte-1f7e5pt"><!> <span>No branches configured</span></div></div>`);
var root$M = /* @__PURE__ */ from_html(`<div role="button" tabindex="0"><div class="flowdrop-workflow-node__header svelte-1f7e5pt"><div class="flowdrop-flex flowdrop-gap--3 flowdrop-items--center svelte-1f7e5pt"><div class="flowdrop-workflow-node__icon svelte-1f7e5pt"><!></div> <h3 class="flowdrop-text--sm flowdrop-font--medium flowdrop-truncate flowdrop-flex--1 svelte-1f7e5pt"> </h3></div> <p class="flowdrop-text--xs flowdrop-text--gray flowdrop-truncate flowdrop-mt--1 svelte-1f7e5pt"> </p></div> <!> <!>  <button class="flowdrop-workflow-node__config-btn svelte-1f7e5pt" title="Configure node"><!></button></div>`);
function GatewayNode($$anchor, $$props) {
  push($$props, true);
  const $connectedHandles = () => store_get(connectedHandles, "$connectedHandles", $$stores);
  const [$$stores, $$cleanup] = setup_stores();
  let props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]);
  const displayTitle = /* @__PURE__ */ user_derived(() => {
    var _a3;
    return ((_a3 = $$props.data.config) == null ? void 0 : _a3.instanceTitle) || $$props.data.label;
  });
  const displayDescription = /* @__PURE__ */ user_derived(() => {
    var _a3;
    return ((_a3 = $$props.data.config) == null ? void 0 : _a3.instanceDescription) || $$props.data.metadata.description;
  });
  const hideUnconnectedHandles = /* @__PURE__ */ user_derived(() => () => {
    var _a3, _b2, _c2, _d2, _e3, _f2;
    const typeDefault = (_d2 = (_c2 = (_b2 = (_a3 = $$props.data.metadata) == null ? void 0 : _a3.extensions) == null ? void 0 : _b2.ui) == null ? void 0 : _c2.hideUnconnectedHandles) != null ? _d2 : false;
    const instanceOverride = (_f2 = (_e3 = $$props.data.extensions) == null ? void 0 : _e3.ui) == null ? void 0 : _f2.hideUnconnectedHandles;
    return instanceOverride != null ? instanceOverride : typeDefault;
  });
  function isPortVisible(port, type) {
    if (!get$3(hideUnconnectedHandles)()) {
      return true;
    }
    if (port.required) {
      return true;
    }
    const handleId = `${$$props.data.nodeId}-${type}-${port.id}`;
    return $connectedHandles().has(handleId);
  }
  const visibleInputPorts = /* @__PURE__ */ user_derived(() => $$props.data.metadata.inputs.filter((port) => isPortVisible(port, "input")));
  function isBranchVisible(branchName) {
    if (!get$3(hideUnconnectedHandles)()) {
      return true;
    }
    const handleId = `${$$props.data.nodeId}-output-${branchName}`;
    return $connectedHandles().has(handleId);
  }
  let branches = /* @__PURE__ */ user_derived(() => {
    var _a3;
    return ((_a3 = $$props.data.config) == null ? void 0 : _a3.branches) || [];
  });
  let activeBranches = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return ((_b2 = (_a3 = $$props.data.executionInfo) == null ? void 0 : _a3.output) == null ? void 0 : _b2.active_branches) || [];
  });
  const visibleBranches = /* @__PURE__ */ user_derived(() => get$3(branches).filter((branch2) => isBranchVisible(branch2.name)));
  function handleNodeClick2() {
  }
  function isBranchActive(branchName) {
    return get$3(activeBranches).includes(branchName);
  }
  var div = root$M();
  let classes;
  div.__click = handleNodeClick2;
  div.__dblclick = [handleNodeDoubleClick, props, $$props];
  div.__keydown = [handleKeydown$7, handleNodeClick2];
  var div_1 = child(div);
  var div_2 = child(div_1);
  var div_3 = child(div_2);
  var node = child(div_3);
  {
    let $0 = /* @__PURE__ */ user_derived(() => getNodeIcon($$props.data.metadata.icon, $$props.data.metadata.category));
    Icon(node, {
      get icon() {
        return get$3($0);
      }
    });
  }
  var h3 = sibling(div_3, 2);
  var text2 = child(h3);
  var p = sibling(div_2, 2);
  var text_1 = child(p);
  var node_1 = sibling(div_1, 2);
  {
    var consequent_2 = ($$anchor2) => {
      var div_4 = root_1$z();
      var div_5 = sibling(child(div_4), 2);
      each(div_5, 21, () => get$3(visibleInputPorts), (port) => port.id, ($$anchor3, port) => {
        var div_6 = root_2$k();
        var node_2 = child(div_6);
        {
          let $0 = /* @__PURE__ */ user_derived(() => `${$$props.data.nodeId}-input-${get$3(port).id}`);
          let $1 = /* @__PURE__ */ user_derived(() => getDataTypeColorToken(get$3(port).dataType));
          Handle(node_2, {
            type: "target",
            get position() {
              return Position.Left;
            },
            get id() {
              return get$3($0);
            },
            class: "flowdrop-workflow-node__handle",
            get style() {
              var _a3;
              return `top: 50%; transform: translateY(-50%); margin-left: -32px; background-color: ${(_a3 = get$3($1)) != null ? _a3 : ""}; border-color: '#ffffff';`;
            },
            role: "button",
            tabindex: 0,
            get "aria-label"() {
              var _a3;
              return `Connect to ${(_a3 = get$3(port).name) != null ? _a3 : ""} input port`;
            }
          });
        }
        var div_7 = sibling(node_2, 2);
        var div_8 = child(div_7);
        var span = child(div_8);
        var text_2 = child(span);
        var span_1 = sibling(span, 2);
        var text_3 = child(span_1);
        var node_3 = sibling(span_1, 2);
        {
          var consequent = ($$anchor4) => {
            var span_2 = root_3$g();
            append($$anchor4, span_2);
          };
          if_block(node_3, ($$render) => {
            if (get$3(port).required) $$render(consequent);
          });
        }
        var node_4 = sibling(div_8, 2);
        {
          var consequent_1 = ($$anchor4) => {
            var p_1 = root_4$f();
            var text_4 = child(p_1);
            template_effect(() => set_text(text_4, get$3(port).description));
            append($$anchor4, p_1);
          };
          if_block(node_4, ($$render) => {
            if (get$3(port).description) $$render(consequent_1);
          });
        }
        template_effect(
          ($0) => {
            set_text(text_2, get$3(port).name);
            set_style(span_1, `background-color: ${$0 != null ? $0 : ""}; color: #fff;`);
            set_text(text_3, get$3(port).dataType);
          },
          [() => getDataTypeColorToken(get$3(port).dataType)]
        );
        append($$anchor3, div_6);
      });
      append($$anchor2, div_4);
    };
    if_block(node_1, ($$render) => {
      if (get$3(visibleInputPorts).length > 0) $$render(consequent_2);
    });
  }
  var node_5 = sibling(node_1, 2);
  {
    var consequent_4 = ($$anchor2) => {
      var div_9 = root_5$d();
      var div_10 = child(div_9);
      var h5 = child(div_10);
      var node_6 = child(h5);
      Icon(node_6, { icon: "mdi:source-branch" });
      var span_3 = sibling(node_6, 2);
      var text_5 = child(span_3);
      var div_11 = sibling(div_10, 2);
      each(div_11, 21, () => get$3(visibleBranches), (branch2) => branch2.name, ($$anchor3, branch2) => {
        const isActive = /* @__PURE__ */ user_derived(() => isBranchActive(get$3(branch2).name));
        var div_12 = root_6$e();
        var div_13 = child(div_12);
        var div_14 = child(div_13);
        var node_7 = child(div_14);
        {
          var consequent_3 = ($$anchor4) => {
            var span_4 = root_7$b();
            var node_8 = child(span_4);
            Icon(node_8, { icon: "mdi:check-circle" });
            template_effect(($0) => set_style(span_4, `color: ${$0 != null ? $0 : ""};`), [() => getDataTypeColorToken("trigger")]);
            append($$anchor4, span_4);
          };
          if_block(node_7, ($$render) => {
            if (get$3(isActive)) $$render(consequent_3);
          });
        }
        var span_5 = sibling(node_7, 2);
        let classes_1;
        var text_6 = child(span_5);
        var span_6 = sibling(span_5, 2);
        var node_9 = sibling(div_13, 2);
        {
          let $0 = /* @__PURE__ */ user_derived(() => `${$$props.data.nodeId}-output-${get$3(branch2).name}`);
          let $1 = /* @__PURE__ */ user_derived(() => `flowdrop-workflow-node__handle ${get$3(isActive) ? "flowdrop-workflow-node__handle--active" : ""}`);
          let $2 = /* @__PURE__ */ user_derived(() => get$3(isActive) ? getDataTypeColorToken("trigger") : getDataTypeColorToken("trigger"));
          Handle(node_9, {
            type: "source",
            get position() {
              return Position.Right;
            },
            get id() {
              return get$3($0);
            },
            get class() {
              return get$3($1);
            },
            get style() {
              var _a3;
              return `top: 50%; transform: translateY(-50%); margin-right: -32px; background-color: ${(_a3 = get$3($2)) != null ? _a3 : ""}; border-color: '#ffffff';`;
            },
            role: "button",
            tabindex: 0,
            get "aria-label"() {
              var _a3;
              return `Connect from ${(_a3 = get$3(branch2).name) != null ? _a3 : ""} branch`;
            }
          });
        }
        template_effect(
          ($0, $1) => {
            classes_1 = set_class(span_5, 1, "flowdrop-text--xs flowdrop-font--medium svelte-1f7e5pt", null, classes_1, $0);
            set_text(text_6, get$3(branch2).label || get$3(branch2).name);
            set_style(span_6, `background-color: ${$1 != null ? $1 : ""}; color: #fff;`);
          },
          [
            () => ({ "flowdrop-text--active": get$3(isActive) }),
            () => getDataTypeColorToken("trigger")
          ]
        );
        append($$anchor3, div_12);
      });
      template_effect(() => {
        var _a3;
        return set_text(text_5, `Branches (${(_a3 = get$3(visibleBranches).length) != null ? _a3 : ""})`);
      });
      append($$anchor2, div_9);
    };
    var alternate = ($$anchor2) => {
      var fragment = comment$1();
      var node_10 = first_child(fragment);
      {
        var consequent_5 = ($$anchor3) => {
          var div_15 = root_9$5();
          var div_16 = child(div_15);
          var node_11 = child(div_16);
          Icon(node_11, { icon: "mdi:alert-circle-outline" });
          append($$anchor3, div_15);
        };
        if_block(
          node_10,
          ($$render) => {
            if (get$3(branches).length === 0) $$render(consequent_5);
          },
          true
        );
      }
      append($$anchor2, fragment);
    };
    if_block(node_5, ($$render) => {
      if (get$3(visibleBranches).length > 0) $$render(consequent_4);
      else $$render(alternate, false);
    });
  }
  var button = sibling(node_5, 2);
  button.__click = [handleNodeDoubleClick, props, $$props];
  var node_12 = child(button);
  Icon(node_12, { icon: "mdi:cog" });
  template_effect(
    ($0, $1) => {
      var _a3, _b2, _c2;
      classes = set_class(div, 1, "flowdrop-workflow-node flowdrop-workflow-node--gateway svelte-1f7e5pt", null, classes, $0);
      set_attribute(div, "aria-label", `Gateway node: ${(_a3 = get$3(displayTitle)) != null ? _a3 : ""}`);
      set_attribute(div, "aria-describedby", `node-description-${(_b2 = $$props.data.nodeId || "unknown") != null ? _b2 : ""}`);
      set_style(div_3, `background-color: ${$1 != null ? $1 : ""}`);
      set_text(text2, get$3(displayTitle));
      set_attribute(p, "id", `node-description-${(_c2 = $$props.data.nodeId || "unknown") != null ? _c2 : ""}`);
      set_text(text_1, get$3(displayDescription));
    },
    [
      () => ({ "flowdrop-workflow-node--selected": $$props.selected }),
      () => getCategoryColorToken($$props.data.metadata.category)
    ]
  );
  append($$anchor, div);
  pop();
  $$cleanup();
}
delegate(["click", "dblclick", "keydown"]);
function L() {
  return { async: false, breaks: false, extensions: null, gfm: true, hooks: null, pedantic: false, renderer: null, silent: false, tokenizer: null, walkTokens: null };
}
var T = L();
function G(u3) {
  T = u3;
}
var I = { exec: () => null };
function h(u3, e = "") {
  let t2 = typeof u3 == "string" ? u3 : u3.source, n = { replace: (r2, i) => {
    let s = typeof i == "string" ? i : i.source;
    return s = s.replace(m.caret, "$1"), t2 = t2.replace(r2, s), n;
  }, getRegex: () => new RegExp(t2, e) };
  return n;
}
var m = { codeRemoveIndent: /^(?: {1,4}| {0,3}\t)/gm, outputLinkReplace: /\\([\[\]])/g, indentCodeCompensation: /^(\s+)(?:```)/, beginningSpace: /^\s+/, endingHash: /#$/, startingSpaceChar: /^ /, endingSpaceChar: / $/, nonSpaceChar: /[^ ]/, newLineCharGlobal: /\n/g, tabCharGlobal: /\t/g, multipleSpaceGlobal: /\s+/g, blankLine: /^[ \t]*$/, doubleBlankLine: /\n[ \t]*\n[ \t]*$/, blockquoteStart: /^ {0,3}>/, blockquoteSetextReplace: /\n {0,3}((?:=+|-+) *)(?=\n|$)/g, blockquoteSetextReplace2: /^ {0,3}>[ \t]?/gm, listReplaceTabs: /^\t+/, listReplaceNesting: /^ {1,4}(?=( {4})*[^ ])/g, listIsTask: /^\[[ xX]\] /, listReplaceTask: /^\[[ xX]\] +/, anyLine: /\n.*\n/, hrefBrackets: /^<(.*)>$/, tableDelimiter: /[:|]/, tableAlignChars: /^\||\| *$/g, tableRowBlankLine: /\n[ \t]*$/, tableAlignRight: /^ *-+: *$/, tableAlignCenter: /^ *:-+: *$/, tableAlignLeft: /^ *:-+ *$/, startATag: /^<a /i, endATag: /^<\/a>/i, startPreScriptTag: /^<(pre|code|kbd|script)(\s|>)/i, endPreScriptTag: /^<\/(pre|code|kbd|script)(\s|>)/i, startAngleBracket: /^</, endAngleBracket: />$/, pedanticHrefTitle: /^([^'"]*[^\s])\s+(['"])(.*)\2/, unicodeAlphaNumeric: /[\p{L}\p{N}]/u, escapeTest: /[&<>"']/, escapeReplace: /[&<>"']/g, escapeTestNoEncode: /[<>"']|&(?!(#\d{1,7}|#[Xx][a-fA-F0-9]{1,6}|\w+);)/, escapeReplaceNoEncode: /[<>"']|&(?!(#\d{1,7}|#[Xx][a-fA-F0-9]{1,6}|\w+);)/g, unescapeTest: /&(#(?:\d+)|(?:#x[0-9A-Fa-f]+)|(?:\w+));?/ig, caret: /(^|[^\[])\^/g, percentDecode: /%25/g, findPipe: /\|/g, splitPipe: / \|/, slashPipe: /\\\|/g, carriageReturn: /\r\n|\r/g, spaceLine: /^ +$/gm, notSpaceStart: /^\S*/, endingNewline: /\n$/, listItemRegex: (u3) => new RegExp(`^( {0,3}${u3})((?:[	 ][^\\n]*)?(?:\\n|$))`), nextBulletRegex: (u3) => new RegExp(`^ {0,${Math.min(3, u3 - 1)}}(?:[*+-]|\\d{1,9}[.)])((?:[ 	][^\\n]*)?(?:\\n|$))`), hrRegex: (u3) => new RegExp(`^ {0,${Math.min(3, u3 - 1)}}((?:- *){3,}|(?:_ *){3,}|(?:\\* *){3,})(?:\\n+|$)`), fencesBeginRegex: (u3) => new RegExp(`^ {0,${Math.min(3, u3 - 1)}}(?:\`\`\`|~~~)`), headingBeginRegex: (u3) => new RegExp(`^ {0,${Math.min(3, u3 - 1)}}#`), htmlBeginRegex: (u3) => new RegExp(`^ {0,${Math.min(3, u3 - 1)}}<(?:[a-z].*>|!--)`, "i") }, be = /^(?:[ \t]*(?:\n|$))+/, Re = /^((?: {4}| {0,3}\t)[^\n]+(?:\n(?:[ \t]*(?:\n|$))*)?)+/, Te = /^ {0,3}(`{3,}(?=[^`\n]*(?:\n|$))|~{3,})([^\n]*)(?:\n|$)(?:|([\s\S]*?)(?:\n|$))(?: {0,3}\1[~`]* *(?=\n|$)|$)/, E = /^ {0,3}((?:-[\t ]*){3,}|(?:_[ \t]*){3,}|(?:\*[ \t]*){3,})(?:\n+|$)/, Oe = /^ {0,3}(#{1,6})(?=\s|$)(.*)(?:\n+|$)/, F = /(?:[*+-]|\d{1,9}[.)])/, ie$2 = /^(?!bull |blockCode|fences|blockquote|heading|html|table)((?:.|\n(?!\s*?\n|bull |blockCode|fences|blockquote|heading|html|table))+?)\n {0,3}(=+|-+) *(?:\n+|$)/, oe = h(ie$2).replace(/bull/g, F).replace(/blockCode/g, /(?: {4}| {0,3}\t)/).replace(/fences/g, / {0,3}(?:`{3,}|~{3,})/).replace(/blockquote/g, / {0,3}>/).replace(/heading/g, / {0,3}#{1,6}/).replace(/html/g, / {0,3}<[^\n>]+>\n/).replace(/\|table/g, "").getRegex(), we = h(ie$2).replace(/bull/g, F).replace(/blockCode/g, /(?: {4}| {0,3}\t)/).replace(/fences/g, / {0,3}(?:`{3,}|~{3,})/).replace(/blockquote/g, / {0,3}>/).replace(/heading/g, / {0,3}#{1,6}/).replace(/html/g, / {0,3}<[^\n>]+>\n/).replace(/table/g, / {0,3}\|?(?:[:\- ]*\|)+[\:\- ]*\n/).getRegex(), j = /^([^\n]+(?:\n(?!hr|heading|lheading|blockquote|fences|list|html|table| +\n)[^\n]+)*)/, ye = /^[^\n]+/, Q = /(?!\s*\])(?:\\[\s\S]|[^\[\]\\])+/, Pe = h(/^ {0,3}\[(label)\]: *(?:\n[ \t]*)?([^<\s][^\s]*|<.*?>)(?:(?: +(?:\n[ \t]*)?| *\n[ \t]*)(title))? *(?:\n+|$)/).replace("label", Q).replace("title", /(?:"(?:\\"?|[^"\\])*"|'[^'\n]*(?:\n[^'\n]+)*\n?'|\([^()]*\))/).getRegex(), Se = h(/^( {0,3}bull)([ \t][^\n]+?)?(?:\n|$)/).replace(/bull/g, F).getRegex(), v = "address|article|aside|base|basefont|blockquote|body|caption|center|col|colgroup|dd|details|dialog|dir|div|dl|dt|fieldset|figcaption|figure|footer|form|frame|frameset|h[1-6]|head|header|hr|html|iframe|legend|li|link|main|menu|menuitem|meta|nav|noframes|ol|optgroup|option|p|param|search|section|summary|table|tbody|td|tfoot|th|thead|title|tr|track|ul", U = /<!--(?:-?>|[\s\S]*?(?:-->|$))/, $e = h("^ {0,3}(?:<(script|pre|style|textarea)[\\s>][\\s\\S]*?(?:</\\1>[^\\n]*\\n+|$)|comment[^\\n]*(\\n+|$)|<\\?[\\s\\S]*?(?:\\?>\\n*|$)|<![A-Z][\\s\\S]*?(?:>\\n*|$)|<!\\[CDATA\\[[\\s\\S]*?(?:\\]\\]>\\n*|$)|</?(tag)(?: +|\\n|/?>)[\\s\\S]*?(?:(?:\\n[ 	]*)+\\n|$)|<(?!script|pre|style|textarea)([a-z][\\w-]*)(?:attribute)*? */?>(?=[ \\t]*(?:\\n|$))[\\s\\S]*?(?:(?:\\n[ 	]*)+\\n|$)|</(?!script|pre|style|textarea)[a-z][\\w-]*\\s*>(?=[ \\t]*(?:\\n|$))[\\s\\S]*?(?:(?:\\n[ 	]*)+\\n|$))", "i").replace("comment", U).replace("tag", v).replace("attribute", / +[a-zA-Z:_][\w.:-]*(?: *= *"[^"\n]*"| *= *'[^'\n]*'| *= *[^\s"'=<>`]+)?/).getRegex(), ae = h(j).replace("hr", E).replace("heading", " {0,3}#{1,6}(?:\\s|$)").replace("|lheading", "").replace("|table", "").replace("blockquote", " {0,3}>").replace("fences", " {0,3}(?:`{3,}(?=[^`\\n]*\\n)|~{3,})[^\\n]*\\n").replace("list", " {0,3}(?:[*+-]|1[.)]) ").replace("html", "</?(?:tag)(?: +|\\n|/?>)|<(?:script|pre|style|textarea|!--)").replace("tag", v).getRegex(), _e = h(/^( {0,3}> ?(paragraph|[^\n]*)(?:\n|$))+/).replace("paragraph", ae).getRegex(), K = { blockquote: _e, code: Re, def: Pe, fences: Te, heading: Oe, hr: E, html: $e, lheading: oe, list: Se, newline: be, paragraph: ae, table: I, text: ye }, re = h("^ *([^\\n ].*)\\n {0,3}((?:\\| *)?:?-+:? *(?:\\| *:?-+:? *)*(?:\\| *)?)(?:\\n((?:(?! *\\n|hr|heading|blockquote|code|fences|list|html).*(?:\\n|$))*)\\n*|$)").replace("hr", E).replace("heading", " {0,3}#{1,6}(?:\\s|$)").replace("blockquote", " {0,3}>").replace("code", "(?: {4}| {0,3}	)[^\\n]").replace("fences", " {0,3}(?:`{3,}(?=[^`\\n]*\\n)|~{3,})[^\\n]*\\n").replace("list", " {0,3}(?:[*+-]|1[.)]) ").replace("html", "</?(?:tag)(?: +|\\n|/?>)|<(?:script|pre|style|textarea|!--)").replace("tag", v).getRegex(), Le = __spreadProps(__spreadValues({}, K), { lheading: we, table: re, paragraph: h(j).replace("hr", E).replace("heading", " {0,3}#{1,6}(?:\\s|$)").replace("|lheading", "").replace("table", re).replace("blockquote", " {0,3}>").replace("fences", " {0,3}(?:`{3,}(?=[^`\\n]*\\n)|~{3,})[^\\n]*\\n").replace("list", " {0,3}(?:[*+-]|1[.)]) ").replace("html", "</?(?:tag)(?: +|\\n|/?>)|<(?:script|pre|style|textarea|!--)").replace("tag", v).getRegex() }), Me = __spreadProps(__spreadValues({}, K), { html: h(`^ *(?:comment *(?:\\n|\\s*$)|<(tag)[\\s\\S]+?</\\1> *(?:\\n{2,}|\\s*$)|<tag(?:"[^"]*"|'[^']*'|\\s[^'"/>\\s]*)*?/?> *(?:\\n{2,}|\\s*$))`).replace("comment", U).replace(/tag/g, "(?!(?:a|em|strong|small|s|cite|q|dfn|abbr|data|time|code|var|samp|kbd|sub|sup|i|b|u|mark|ruby|rt|rp|bdi|bdo|span|br|wbr|ins|del|img)\\b)\\w+(?!:|[^\\w\\s@]*@)\\b").getRegex(), def: /^ *\[([^\]]+)\]: *<?([^\s>]+)>?(?: +(["(][^\n]+[")]))? *(?:\n+|$)/, heading: /^(#{1,6})(.*)(?:\n+|$)/, fences: I, lheading: /^(.+?)\n {0,3}(=+|-+) *(?:\n+|$)/, paragraph: h(j).replace("hr", E).replace("heading", ` *#{1,6} *[^
]`).replace("lheading", oe).replace("|table", "").replace("blockquote", " {0,3}>").replace("|fences", "").replace("|list", "").replace("|html", "").replace("|tag", "").getRegex() }), ze = /^\\([!"#$%&'()*+,\-./:;<=>?@\[\]\\^_`{|}~])/, Ae = /^(`+)([^`]|[^`][\s\S]*?[^`])\1(?!`)/, le = /^( {2,}|\\)\n(?!\s*$)/, Ie = /^(`+|[^`])(?:(?= {2,}\n)|[\s\S]*?(?:(?=[\\<!\[`*_]|\b_|$)|[^ ](?= {2,}\n)))/, D = /[\p{P}\p{S}]/u, W = /[\s\p{P}\p{S}]/u, ue = /[^\s\p{P}\p{S}]/u, Ee = h(/^((?![*_])punctSpace)/, "u").replace(/punctSpace/g, W).getRegex(), pe = /(?!~)[\p{P}\p{S}]/u, Ce = /(?!~)[\s\p{P}\p{S}]/u, Be = /(?:[^\s\p{P}\p{S}]|~)/u, qe = h(/link|code|html/, "g").replace("link", new RegExp("\\[(?:[^\\[\\]`]|(?<!`)(?<a>`+)[^`]+\\k<a>(?!`))*?\\]\\((?:\\\\[\\s\\S]|[^\\\\\\(\\)]|\\((?:\\\\[\\s\\S]|[^\\\\\\(\\)])*\\))*\\)")).replace("code", new RegExp("(?<!`)(?<b>`+)[^`]+\\k<b>(?!`)")).replace("html", /<(?! )[^<>]*?>/).getRegex(), ce = /^(?:\*+(?:((?!\*)punct)|[^\s*]))|^_+(?:((?!_)punct)|([^\s_]))/, ve = h(ce, "u").replace(/punct/g, D).getRegex(), De = h(ce, "u").replace(/punct/g, pe).getRegex(), he = "^[^_*]*?__[^_*]*?\\*[^_*]*?(?=__)|[^*]+(?=[^*])|(?!\\*)punct(\\*+)(?=[\\s]|$)|notPunctSpace(\\*+)(?!\\*)(?=punctSpace|$)|(?!\\*)punctSpace(\\*+)(?=notPunctSpace)|[\\s](\\*+)(?!\\*)(?=punct)|(?!\\*)punct(\\*+)(?!\\*)(?=punct)|notPunctSpace(\\*+)(?=notPunctSpace)", He = h(he, "gu").replace(/notPunctSpace/g, ue).replace(/punctSpace/g, W).replace(/punct/g, D).getRegex(), Ze = h(he, "gu").replace(/notPunctSpace/g, Be).replace(/punctSpace/g, Ce).replace(/punct/g, pe).getRegex(), Ge = h("^[^_*]*?\\*\\*[^_*]*?_[^_*]*?(?=\\*\\*)|[^_]+(?=[^_])|(?!_)punct(_+)(?=[\\s]|$)|notPunctSpace(_+)(?!_)(?=punctSpace|$)|(?!_)punctSpace(_+)(?=notPunctSpace)|[\\s](_+)(?!_)(?=punct)|(?!_)punct(_+)(?!_)(?=punct)", "gu").replace(/notPunctSpace/g, ue).replace(/punctSpace/g, W).replace(/punct/g, D).getRegex(), Ne = h(/\\(punct)/, "gu").replace(/punct/g, D).getRegex(), Fe = h(/^<(scheme:[^\s\x00-\x1f<>]*|email)>/).replace("scheme", /[a-zA-Z][a-zA-Z0-9+.-]{1,31}/).replace("email", /[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+(@)[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)+(?![-_])/).getRegex(), je = h(U).replace("(?:-->|$)", "-->").getRegex(), Qe = h("^comment|^</[a-zA-Z][\\w:-]*\\s*>|^<[a-zA-Z][\\w-]*(?:attribute)*?\\s*/?>|^<\\?[\\s\\S]*?\\?>|^<![a-zA-Z]+\\s[\\s\\S]*?>|^<!\\[CDATA\\[[\\s\\S]*?\\]\\]>").replace("comment", je).replace("attribute", /\s+[a-zA-Z:_][\w.:-]*(?:\s*=\s*"[^"]*"|\s*=\s*'[^']*'|\s*=\s*[^\s"'=<>`]+)?/).getRegex(), q = /(?:\[(?:\\[\s\S]|[^\[\]\\])*\]|\\[\s\S]|`+[^`]*?`+(?!`)|[^\[\]\\`])*?/, Ue = h(/^!?\[(label)\]\(\s*(href)(?:(?:[ \t]*(?:\n[ \t]*)?)(title))?\s*\)/).replace("label", q).replace("href", /<(?:\\.|[^\n<>\\])+>|[^ \t\n\x00-\x1f]*/).replace("title", /"(?:\\"?|[^"\\])*"|'(?:\\'?|[^'\\])*'|\((?:\\\)?|[^)\\])*\)/).getRegex(), de = h(/^!?\[(label)\]\[(ref)\]/).replace("label", q).replace("ref", Q).getRegex(), ke = h(/^!?\[(ref)\](?:\[\])?/).replace("ref", Q).getRegex(), Ke = h("reflink|nolink(?!\\()", "g").replace("reflink", de).replace("nolink", ke).getRegex(), se = /[hH][tT][tT][pP][sS]?|[fF][tT][pP]/, X = { _backpedal: I, anyPunctuation: Ne, autolink: Fe, blockSkip: qe, br: le, code: Ae, del: I, emStrongLDelim: ve, emStrongRDelimAst: He, emStrongRDelimUnd: Ge, escape: ze, link: Ue, nolink: ke, punctuation: Ee, reflink: de, reflinkSearch: Ke, tag: Qe, text: Ie, url: I }, We = __spreadProps(__spreadValues({}, X), { link: h(/^!?\[(label)\]\((.*?)\)/).replace("label", q).getRegex(), reflink: h(/^!?\[(label)\]\s*\[([^\]]*)\]/).replace("label", q).getRegex() }), N = __spreadProps(__spreadValues({}, X), { emStrongRDelimAst: Ze, emStrongLDelim: De, url: h(/^((?:protocol):\/\/|www\.)(?:[a-zA-Z0-9\-]+\.?)+[^\s<]*|^email/).replace("protocol", se).replace("email", /[A-Za-z0-9._+-]+(@)[a-zA-Z0-9-_]+(?:\.[a-zA-Z0-9-_]*[a-zA-Z0-9])+(?![-_])/).getRegex(), _backpedal: /(?:[^?!.,:;*_'"~()&]+|\([^)]*\)|&(?![a-zA-Z0-9]+;$)|[?!.,:;*_'"~)]+(?!$))+/, del: /^(~~?)(?=[^\s~])((?:\\[\s\S]|[^\\])*?(?:\\[\s\S]|[^\s~\\]))\1(?=[^~]|$)/, text: h(/^([`~]+|[^`~])(?:(?= {2,}\n)|(?=[a-zA-Z0-9.!#$%&'*+\/=?_`{\|}~-]+@)|[\s\S]*?(?:(?=[\\<!\[`*~_]|\b_|protocol:\/\/|www\.|$)|[^ ](?= {2,}\n)|[^a-zA-Z0-9.!#$%&'*+\/=?_`{\|}~-](?=[a-zA-Z0-9.!#$%&'*+\/=?_`{\|}~-]+@)))/).replace("protocol", se).getRegex() }), Xe = __spreadProps(__spreadValues({}, N), { br: h(le).replace("{2,}", "*").getRegex(), text: h(N.text).replace("\\b_", "\\b_| {2,}\\n").replace(/\{2,\}/g, "*").getRegex() }), C$1 = { normal: K, gfm: Le, pedantic: Me }, M = { normal: X, gfm: N, breaks: Xe, pedantic: We };
var Je = { "&": "&amp;", "<": "&lt;", ">": "&gt;", '"': "&quot;", "'": "&#39;" }, ge = (u3) => Je[u3];
function w(u3, e) {
  if (e) {
    if (m.escapeTest.test(u3)) return u3.replace(m.escapeReplace, ge);
  } else if (m.escapeTestNoEncode.test(u3)) return u3.replace(m.escapeReplaceNoEncode, ge);
  return u3;
}
function J(u3) {
  try {
    u3 = encodeURI(u3).replace(m.percentDecode, "%");
  } catch (e) {
    return null;
  }
  return u3;
}
function V(u3, e) {
  var _a3;
  let t2 = u3.replace(m.findPipe, (i, s, o) => {
    let a = false, l = s;
    for (; --l >= 0 && o[l] === "\\"; ) a = !a;
    return a ? "|" : " |";
  }), n = t2.split(m.splitPipe), r2 = 0;
  if (n[0].trim() || n.shift(), n.length > 0 && !((_a3 = n.at(-1)) == null ? void 0 : _a3.trim()) && n.pop(), e) if (n.length > e) n.splice(e);
  else for (; n.length < e; ) n.push("");
  for (; r2 < n.length; r2++) n[r2] = n[r2].trim().replace(m.slashPipe, "|");
  return n;
}
function z(u3, e, t2) {
  let n = u3.length;
  if (n === 0) return "";
  let r2 = 0;
  for (; r2 < n; ) {
    let i = u3.charAt(n - r2 - 1);
    if (i === e && true) r2++;
    else break;
  }
  return u3.slice(0, n - r2);
}
function fe(u3, e) {
  if (u3.indexOf(e[1]) === -1) return -1;
  let t2 = 0;
  for (let n = 0; n < u3.length; n++) if (u3[n] === "\\") n++;
  else if (u3[n] === e[0]) t2++;
  else if (u3[n] === e[1] && (t2--, t2 < 0)) return n;
  return t2 > 0 ? -2 : -1;
}
function me(u3, e, t2, n, r2) {
  let i = e.href, s = e.title || null, o = u3[1].replace(r2.other.outputLinkReplace, "$1");
  n.state.inLink = true;
  let a = { type: u3[0].charAt(0) === "!" ? "image" : "link", raw: t2, href: i, title: s, text: o, tokens: n.inlineTokens(o) };
  return n.state.inLink = false, a;
}
function Ve(u3, e, t2) {
  let n = u3.match(t2.other.indentCodeCompensation);
  if (n === null) return e;
  let r2 = n[1];
  return e.split(`
`).map((i) => {
    let s = i.match(t2.other.beginningSpace);
    if (s === null) return i;
    let [o] = s;
    return o.length >= r2.length ? i.slice(r2.length) : i;
  }).join(`
`);
}
var y = class {
  constructor(e) {
    __publicField(this, "options");
    __publicField(this, "rules");
    __publicField(this, "lexer");
    this.options = e || T;
  }
  space(e) {
    let t2 = this.rules.block.newline.exec(e);
    if (t2 && t2[0].length > 0) return { type: "space", raw: t2[0] };
  }
  code(e) {
    let t2 = this.rules.block.code.exec(e);
    if (t2) {
      let n = t2[0].replace(this.rules.other.codeRemoveIndent, "");
      return { type: "code", raw: t2[0], codeBlockStyle: "indented", text: this.options.pedantic ? n : z(n, `
`) };
    }
  }
  fences(e) {
    let t2 = this.rules.block.fences.exec(e);
    if (t2) {
      let n = t2[0], r2 = Ve(n, t2[3] || "", this.rules);
      return { type: "code", raw: n, lang: t2[2] ? t2[2].trim().replace(this.rules.inline.anyPunctuation, "$1") : t2[2], text: r2 };
    }
  }
  heading(e) {
    let t2 = this.rules.block.heading.exec(e);
    if (t2) {
      let n = t2[2].trim();
      if (this.rules.other.endingHash.test(n)) {
        let r2 = z(n, "#");
        (this.options.pedantic || !r2 || this.rules.other.endingSpaceChar.test(r2)) && (n = r2.trim());
      }
      return { type: "heading", raw: t2[0], depth: t2[1].length, text: n, tokens: this.lexer.inline(n) };
    }
  }
  hr(e) {
    let t2 = this.rules.block.hr.exec(e);
    if (t2) return { type: "hr", raw: z(t2[0], `
`) };
  }
  blockquote(e) {
    let t2 = this.rules.block.blockquote.exec(e);
    if (t2) {
      let n = z(t2[0], `
`).split(`
`), r2 = "", i = "", s = [];
      for (; n.length > 0; ) {
        let o = false, a = [], l;
        for (l = 0; l < n.length; l++) if (this.rules.other.blockquoteStart.test(n[l])) a.push(n[l]), o = true;
        else if (!o) a.push(n[l]);
        else break;
        n = n.slice(l);
        let c = a.join(`
`), p = c.replace(this.rules.other.blockquoteSetextReplace, `
    $1`).replace(this.rules.other.blockquoteSetextReplace2, "");
        r2 = r2 ? `${r2}
${c}` : c, i = i ? `${i}
${p}` : p;
        let g = this.lexer.state.top;
        if (this.lexer.state.top = true, this.lexer.blockTokens(p, s, true), this.lexer.state.top = g, n.length === 0) break;
        let d = s.at(-1);
        if ((d == null ? void 0 : d.type) === "code") break;
        if ((d == null ? void 0 : d.type) === "blockquote") {
          let R = d, f = R.raw + `
` + n.join(`
`), O = this.blockquote(f);
          s[s.length - 1] = O, r2 = r2.substring(0, r2.length - R.raw.length) + O.raw, i = i.substring(0, i.length - R.text.length) + O.text;
          break;
        } else if ((d == null ? void 0 : d.type) === "list") {
          let R = d, f = R.raw + `
` + n.join(`
`), O = this.list(f);
          s[s.length - 1] = O, r2 = r2.substring(0, r2.length - d.raw.length) + O.raw, i = i.substring(0, i.length - R.raw.length) + O.raw, n = f.substring(s.at(-1).raw.length).split(`
`);
          continue;
        }
      }
      return { type: "blockquote", raw: r2, tokens: s, text: i };
    }
  }
  list(e) {
    let t2 = this.rules.block.list.exec(e);
    if (t2) {
      let n = t2[1].trim(), r2 = n.length > 1, i = { type: "list", raw: "", ordered: r2, start: r2 ? +n.slice(0, -1) : "", loose: false, items: [] };
      n = r2 ? `\\d{1,9}\\${n.slice(-1)}` : `\\${n}`, this.options.pedantic && (n = r2 ? n : "[*+-]");
      let s = this.rules.other.listItemRegex(n), o = false;
      for (; e; ) {
        let l = false, c = "", p = "";
        if (!(t2 = s.exec(e)) || this.rules.block.hr.test(e)) break;
        c = t2[0], e = e.substring(c.length);
        let g = t2[2].split(`
`, 1)[0].replace(this.rules.other.listReplaceTabs, (H) => " ".repeat(3 * H.length)), d = e.split(`
`, 1)[0], R = !g.trim(), f = 0;
        if (this.options.pedantic ? (f = 2, p = g.trimStart()) : R ? f = t2[1].length + 1 : (f = t2[2].search(this.rules.other.nonSpaceChar), f = f > 4 ? 1 : f, p = g.slice(f), f += t2[1].length), R && this.rules.other.blankLine.test(d) && (c += d + `
`, e = e.substring(d.length + 1), l = true), !l) {
          let H = this.rules.other.nextBulletRegex(f), ee = this.rules.other.hrRegex(f), te = this.rules.other.fencesBeginRegex(f), ne = this.rules.other.headingBeginRegex(f), xe = this.rules.other.htmlBeginRegex(f);
          for (; e; ) {
            let Z = e.split(`
`, 1)[0], A;
            if (d = Z, this.options.pedantic ? (d = d.replace(this.rules.other.listReplaceNesting, "  "), A = d) : A = d.replace(this.rules.other.tabCharGlobal, "    "), te.test(d) || ne.test(d) || xe.test(d) || H.test(d) || ee.test(d)) break;
            if (A.search(this.rules.other.nonSpaceChar) >= f || !d.trim()) p += `
` + A.slice(f);
            else {
              if (R || g.replace(this.rules.other.tabCharGlobal, "    ").search(this.rules.other.nonSpaceChar) >= 4 || te.test(g) || ne.test(g) || ee.test(g)) break;
              p += `
` + d;
            }
            !R && !d.trim() && (R = true), c += Z + `
`, e = e.substring(Z.length + 1), g = A.slice(f);
          }
        }
        i.loose || (o ? i.loose = true : this.rules.other.doubleBlankLine.test(c) && (o = true));
        let O = null, Y;
        this.options.gfm && (O = this.rules.other.listIsTask.exec(p), O && (Y = O[0] !== "[ ] ", p = p.replace(this.rules.other.listReplaceTask, ""))), i.items.push({ type: "list_item", raw: c, task: !!O, checked: Y, loose: false, text: p, tokens: [] }), i.raw += c;
      }
      let a = i.items.at(-1);
      if (a) a.raw = a.raw.trimEnd(), a.text = a.text.trimEnd();
      else return;
      i.raw = i.raw.trimEnd();
      for (let l = 0; l < i.items.length; l++) if (this.lexer.state.top = false, i.items[l].tokens = this.lexer.blockTokens(i.items[l].text, []), !i.loose) {
        let c = i.items[l].tokens.filter((g) => g.type === "space"), p = c.length > 0 && c.some((g) => this.rules.other.anyLine.test(g.raw));
        i.loose = p;
      }
      if (i.loose) for (let l = 0; l < i.items.length; l++) i.items[l].loose = true;
      return i;
    }
  }
  html(e) {
    let t2 = this.rules.block.html.exec(e);
    if (t2) return { type: "html", block: true, raw: t2[0], pre: t2[1] === "pre" || t2[1] === "script" || t2[1] === "style", text: t2[0] };
  }
  def(e) {
    let t2 = this.rules.block.def.exec(e);
    if (t2) {
      let n = t2[1].toLowerCase().replace(this.rules.other.multipleSpaceGlobal, " "), r2 = t2[2] ? t2[2].replace(this.rules.other.hrefBrackets, "$1").replace(this.rules.inline.anyPunctuation, "$1") : "", i = t2[3] ? t2[3].substring(1, t2[3].length - 1).replace(this.rules.inline.anyPunctuation, "$1") : t2[3];
      return { type: "def", tag: n, raw: t2[0], href: r2, title: i };
    }
  }
  table(e) {
    var _a3;
    let t2 = this.rules.block.table.exec(e);
    if (!t2 || !this.rules.other.tableDelimiter.test(t2[2])) return;
    let n = V(t2[1]), r2 = t2[2].replace(this.rules.other.tableAlignChars, "").split("|"), i = ((_a3 = t2[3]) == null ? void 0 : _a3.trim()) ? t2[3].replace(this.rules.other.tableRowBlankLine, "").split(`
`) : [], s = { type: "table", raw: t2[0], header: [], align: [], rows: [] };
    if (n.length === r2.length) {
      for (let o of r2) this.rules.other.tableAlignRight.test(o) ? s.align.push("right") : this.rules.other.tableAlignCenter.test(o) ? s.align.push("center") : this.rules.other.tableAlignLeft.test(o) ? s.align.push("left") : s.align.push(null);
      for (let o = 0; o < n.length; o++) s.header.push({ text: n[o], tokens: this.lexer.inline(n[o]), header: true, align: s.align[o] });
      for (let o of i) s.rows.push(V(o, s.header.length).map((a, l) => ({ text: a, tokens: this.lexer.inline(a), header: false, align: s.align[l] })));
      return s;
    }
  }
  lheading(e) {
    let t2 = this.rules.block.lheading.exec(e);
    if (t2) return { type: "heading", raw: t2[0], depth: t2[2].charAt(0) === "=" ? 1 : 2, text: t2[1], tokens: this.lexer.inline(t2[1]) };
  }
  paragraph(e) {
    let t2 = this.rules.block.paragraph.exec(e);
    if (t2) {
      let n = t2[1].charAt(t2[1].length - 1) === `
` ? t2[1].slice(0, -1) : t2[1];
      return { type: "paragraph", raw: t2[0], text: n, tokens: this.lexer.inline(n) };
    }
  }
  text(e) {
    let t2 = this.rules.block.text.exec(e);
    if (t2) return { type: "text", raw: t2[0], text: t2[0], tokens: this.lexer.inline(t2[0]) };
  }
  escape(e) {
    let t2 = this.rules.inline.escape.exec(e);
    if (t2) return { type: "escape", raw: t2[0], text: t2[1] };
  }
  tag(e) {
    let t2 = this.rules.inline.tag.exec(e);
    if (t2) return !this.lexer.state.inLink && this.rules.other.startATag.test(t2[0]) ? this.lexer.state.inLink = true : this.lexer.state.inLink && this.rules.other.endATag.test(t2[0]) && (this.lexer.state.inLink = false), !this.lexer.state.inRawBlock && this.rules.other.startPreScriptTag.test(t2[0]) ? this.lexer.state.inRawBlock = true : this.lexer.state.inRawBlock && this.rules.other.endPreScriptTag.test(t2[0]) && (this.lexer.state.inRawBlock = false), { type: "html", raw: t2[0], inLink: this.lexer.state.inLink, inRawBlock: this.lexer.state.inRawBlock, block: false, text: t2[0] };
  }
  link(e) {
    let t2 = this.rules.inline.link.exec(e);
    if (t2) {
      let n = t2[2].trim();
      if (!this.options.pedantic && this.rules.other.startAngleBracket.test(n)) {
        if (!this.rules.other.endAngleBracket.test(n)) return;
        let s = z(n.slice(0, -1), "\\");
        if ((n.length - s.length) % 2 === 0) return;
      } else {
        let s = fe(t2[2], "()");
        if (s === -2) return;
        if (s > -1) {
          let a = (t2[0].indexOf("!") === 0 ? 5 : 4) + t2[1].length + s;
          t2[2] = t2[2].substring(0, s), t2[0] = t2[0].substring(0, a).trim(), t2[3] = "";
        }
      }
      let r2 = t2[2], i = "";
      if (this.options.pedantic) {
        let s = this.rules.other.pedanticHrefTitle.exec(r2);
        s && (r2 = s[1], i = s[3]);
      } else i = t2[3] ? t2[3].slice(1, -1) : "";
      return r2 = r2.trim(), this.rules.other.startAngleBracket.test(r2) && (this.options.pedantic && !this.rules.other.endAngleBracket.test(n) ? r2 = r2.slice(1) : r2 = r2.slice(1, -1)), me(t2, { href: r2 && r2.replace(this.rules.inline.anyPunctuation, "$1"), title: i && i.replace(this.rules.inline.anyPunctuation, "$1") }, t2[0], this.lexer, this.rules);
    }
  }
  reflink(e, t2) {
    let n;
    if ((n = this.rules.inline.reflink.exec(e)) || (n = this.rules.inline.nolink.exec(e))) {
      let r2 = (n[2] || n[1]).replace(this.rules.other.multipleSpaceGlobal, " "), i = t2[r2.toLowerCase()];
      if (!i) {
        let s = n[0].charAt(0);
        return { type: "text", raw: s, text: s };
      }
      return me(n, i, n[0], this.lexer, this.rules);
    }
  }
  emStrong(e, t2, n = "") {
    let r2 = this.rules.inline.emStrongLDelim.exec(e);
    if (!r2 || r2[3] && n.match(this.rules.other.unicodeAlphaNumeric)) return;
    if (!(r2[1] || r2[2] || "") || !n || this.rules.inline.punctuation.exec(n)) {
      let s = [...r2[0]].length - 1, o, a, l = s, c = 0, p = r2[0][0] === "*" ? this.rules.inline.emStrongRDelimAst : this.rules.inline.emStrongRDelimUnd;
      for (p.lastIndex = 0, t2 = t2.slice(-1 * e.length + s); (r2 = p.exec(t2)) != null; ) {
        if (o = r2[1] || r2[2] || r2[3] || r2[4] || r2[5] || r2[6], !o) continue;
        if (a = [...o].length, r2[3] || r2[4]) {
          l += a;
          continue;
        } else if ((r2[5] || r2[6]) && s % 3 && !((s + a) % 3)) {
          c += a;
          continue;
        }
        if (l -= a, l > 0) continue;
        a = Math.min(a, a + l + c);
        let g = [...r2[0]][0].length, d = e.slice(0, s + r2.index + g + a);
        if (Math.min(s, a) % 2) {
          let f = d.slice(1, -1);
          return { type: "em", raw: d, text: f, tokens: this.lexer.inlineTokens(f) };
        }
        let R = d.slice(2, -2);
        return { type: "strong", raw: d, text: R, tokens: this.lexer.inlineTokens(R) };
      }
    }
  }
  codespan(e) {
    let t2 = this.rules.inline.code.exec(e);
    if (t2) {
      let n = t2[2].replace(this.rules.other.newLineCharGlobal, " "), r2 = this.rules.other.nonSpaceChar.test(n), i = this.rules.other.startingSpaceChar.test(n) && this.rules.other.endingSpaceChar.test(n);
      return r2 && i && (n = n.substring(1, n.length - 1)), { type: "codespan", raw: t2[0], text: n };
    }
  }
  br(e) {
    let t2 = this.rules.inline.br.exec(e);
    if (t2) return { type: "br", raw: t2[0] };
  }
  del(e) {
    let t2 = this.rules.inline.del.exec(e);
    if (t2) return { type: "del", raw: t2[0], text: t2[2], tokens: this.lexer.inlineTokens(t2[2]) };
  }
  autolink(e) {
    let t2 = this.rules.inline.autolink.exec(e);
    if (t2) {
      let n, r2;
      return t2[2] === "@" ? (n = t2[1], r2 = "mailto:" + n) : (n = t2[1], r2 = n), { type: "link", raw: t2[0], text: n, href: r2, tokens: [{ type: "text", raw: n, text: n }] };
    }
  }
  url(e) {
    var _a3, _b2;
    let t2;
    if (t2 = this.rules.inline.url.exec(e)) {
      let n, r2;
      if (t2[2] === "@") n = t2[0], r2 = "mailto:" + n;
      else {
        let i;
        do
          i = t2[0], t2[0] = (_b2 = (_a3 = this.rules.inline._backpedal.exec(t2[0])) == null ? void 0 : _a3[0]) != null ? _b2 : "";
        while (i !== t2[0]);
        n = t2[0], t2[1] === "www." ? r2 = "http://" + t2[0] : r2 = t2[0];
      }
      return { type: "link", raw: t2[0], text: n, href: r2, tokens: [{ type: "text", raw: n, text: n }] };
    }
  }
  inlineText(e) {
    let t2 = this.rules.inline.text.exec(e);
    if (t2) {
      let n = this.lexer.state.inRawBlock;
      return { type: "text", raw: t2[0], text: t2[0], escaped: n };
    }
  }
};
var x = class u {
  constructor(e) {
    __publicField(this, "tokens");
    __publicField(this, "options");
    __publicField(this, "state");
    __publicField(this, "tokenizer");
    __publicField(this, "inlineQueue");
    this.tokens = [], this.tokens.links = /* @__PURE__ */ Object.create(null), this.options = e || T, this.options.tokenizer = this.options.tokenizer || new y(), this.tokenizer = this.options.tokenizer, this.tokenizer.options = this.options, this.tokenizer.lexer = this, this.inlineQueue = [], this.state = { inLink: false, inRawBlock: false, top: true };
    let t2 = { other: m, block: C$1.normal, inline: M.normal };
    this.options.pedantic ? (t2.block = C$1.pedantic, t2.inline = M.pedantic) : this.options.gfm && (t2.block = C$1.gfm, this.options.breaks ? t2.inline = M.breaks : t2.inline = M.gfm), this.tokenizer.rules = t2;
  }
  static get rules() {
    return { block: C$1, inline: M };
  }
  static lex(e, t2) {
    return new u(t2).lex(e);
  }
  static lexInline(e, t2) {
    return new u(t2).inlineTokens(e);
  }
  lex(e) {
    e = e.replace(m.carriageReturn, `
`), this.blockTokens(e, this.tokens);
    for (let t2 = 0; t2 < this.inlineQueue.length; t2++) {
      let n = this.inlineQueue[t2];
      this.inlineTokens(n.src, n.tokens);
    }
    return this.inlineQueue = [], this.tokens;
  }
  blockTokens(e, t2 = [], n = false) {
    var _a3, _b2, _c2;
    for (this.options.pedantic && (e = e.replace(m.tabCharGlobal, "    ").replace(m.spaceLine, "")); e; ) {
      let r2;
      if ((_b2 = (_a3 = this.options.extensions) == null ? void 0 : _a3.block) == null ? void 0 : _b2.some((s) => (r2 = s.call({ lexer: this }, e, t2)) ? (e = e.substring(r2.raw.length), t2.push(r2), true) : false)) continue;
      if (r2 = this.tokenizer.space(e)) {
        e = e.substring(r2.raw.length);
        let s = t2.at(-1);
        r2.raw.length === 1 && s !== void 0 ? s.raw += `
` : t2.push(r2);
        continue;
      }
      if (r2 = this.tokenizer.code(e)) {
        e = e.substring(r2.raw.length);
        let s = t2.at(-1);
        (s == null ? void 0 : s.type) === "paragraph" || (s == null ? void 0 : s.type) === "text" ? (s.raw += (s.raw.endsWith(`
`) ? "" : `
`) + r2.raw, s.text += `
` + r2.text, this.inlineQueue.at(-1).src = s.text) : t2.push(r2);
        continue;
      }
      if (r2 = this.tokenizer.fences(e)) {
        e = e.substring(r2.raw.length), t2.push(r2);
        continue;
      }
      if (r2 = this.tokenizer.heading(e)) {
        e = e.substring(r2.raw.length), t2.push(r2);
        continue;
      }
      if (r2 = this.tokenizer.hr(e)) {
        e = e.substring(r2.raw.length), t2.push(r2);
        continue;
      }
      if (r2 = this.tokenizer.blockquote(e)) {
        e = e.substring(r2.raw.length), t2.push(r2);
        continue;
      }
      if (r2 = this.tokenizer.list(e)) {
        e = e.substring(r2.raw.length), t2.push(r2);
        continue;
      }
      if (r2 = this.tokenizer.html(e)) {
        e = e.substring(r2.raw.length), t2.push(r2);
        continue;
      }
      if (r2 = this.tokenizer.def(e)) {
        e = e.substring(r2.raw.length);
        let s = t2.at(-1);
        (s == null ? void 0 : s.type) === "paragraph" || (s == null ? void 0 : s.type) === "text" ? (s.raw += (s.raw.endsWith(`
`) ? "" : `
`) + r2.raw, s.text += `
` + r2.raw, this.inlineQueue.at(-1).src = s.text) : this.tokens.links[r2.tag] || (this.tokens.links[r2.tag] = { href: r2.href, title: r2.title }, t2.push(r2));
        continue;
      }
      if (r2 = this.tokenizer.table(e)) {
        e = e.substring(r2.raw.length), t2.push(r2);
        continue;
      }
      if (r2 = this.tokenizer.lheading(e)) {
        e = e.substring(r2.raw.length), t2.push(r2);
        continue;
      }
      let i = e;
      if ((_c2 = this.options.extensions) == null ? void 0 : _c2.startBlock) {
        let s = 1 / 0, o = e.slice(1), a;
        this.options.extensions.startBlock.forEach((l) => {
          a = l.call({ lexer: this }, o), typeof a == "number" && a >= 0 && (s = Math.min(s, a));
        }), s < 1 / 0 && s >= 0 && (i = e.substring(0, s + 1));
      }
      if (this.state.top && (r2 = this.tokenizer.paragraph(i))) {
        let s = t2.at(-1);
        n && (s == null ? void 0 : s.type) === "paragraph" ? (s.raw += (s.raw.endsWith(`
`) ? "" : `
`) + r2.raw, s.text += `
` + r2.text, this.inlineQueue.pop(), this.inlineQueue.at(-1).src = s.text) : t2.push(r2), n = i.length !== e.length, e = e.substring(r2.raw.length);
        continue;
      }
      if (r2 = this.tokenizer.text(e)) {
        e = e.substring(r2.raw.length);
        let s = t2.at(-1);
        (s == null ? void 0 : s.type) === "text" ? (s.raw += (s.raw.endsWith(`
`) ? "" : `
`) + r2.raw, s.text += `
` + r2.text, this.inlineQueue.pop(), this.inlineQueue.at(-1).src = s.text) : t2.push(r2);
        continue;
      }
      if (e) {
        let s = "Infinite loop on byte: " + e.charCodeAt(0);
        if (this.options.silent) {
          console.error(s);
          break;
        } else throw new Error(s);
      }
    }
    return this.state.top = true, t2;
  }
  inline(e, t2 = []) {
    return this.inlineQueue.push({ src: e, tokens: t2 }), t2;
  }
  inlineTokens(e, t2 = []) {
    var _a3, _b2, _c2, _d2, _e3, _f2;
    let n = e, r2 = null;
    if (this.tokens.links) {
      let o = Object.keys(this.tokens.links);
      if (o.length > 0) for (; (r2 = this.tokenizer.rules.inline.reflinkSearch.exec(n)) != null; ) o.includes(r2[0].slice(r2[0].lastIndexOf("[") + 1, -1)) && (n = n.slice(0, r2.index) + "[" + "a".repeat(r2[0].length - 2) + "]" + n.slice(this.tokenizer.rules.inline.reflinkSearch.lastIndex));
    }
    for (; (r2 = this.tokenizer.rules.inline.anyPunctuation.exec(n)) != null; ) n = n.slice(0, r2.index) + "++" + n.slice(this.tokenizer.rules.inline.anyPunctuation.lastIndex);
    for (; (r2 = this.tokenizer.rules.inline.blockSkip.exec(n)) != null; ) n = n.slice(0, r2.index) + "[" + "a".repeat(r2[0].length - 2) + "]" + n.slice(this.tokenizer.rules.inline.blockSkip.lastIndex);
    n = (_c2 = (_b2 = (_a3 = this.options.hooks) == null ? void 0 : _a3.emStrongMask) == null ? void 0 : _b2.call({ lexer: this }, n)) != null ? _c2 : n;
    let i = false, s = "";
    for (; e; ) {
      i || (s = ""), i = false;
      let o;
      if ((_e3 = (_d2 = this.options.extensions) == null ? void 0 : _d2.inline) == null ? void 0 : _e3.some((l) => (o = l.call({ lexer: this }, e, t2)) ? (e = e.substring(o.raw.length), t2.push(o), true) : false)) continue;
      if (o = this.tokenizer.escape(e)) {
        e = e.substring(o.raw.length), t2.push(o);
        continue;
      }
      if (o = this.tokenizer.tag(e)) {
        e = e.substring(o.raw.length), t2.push(o);
        continue;
      }
      if (o = this.tokenizer.link(e)) {
        e = e.substring(o.raw.length), t2.push(o);
        continue;
      }
      if (o = this.tokenizer.reflink(e, this.tokens.links)) {
        e = e.substring(o.raw.length);
        let l = t2.at(-1);
        o.type === "text" && (l == null ? void 0 : l.type) === "text" ? (l.raw += o.raw, l.text += o.text) : t2.push(o);
        continue;
      }
      if (o = this.tokenizer.emStrong(e, n, s)) {
        e = e.substring(o.raw.length), t2.push(o);
        continue;
      }
      if (o = this.tokenizer.codespan(e)) {
        e = e.substring(o.raw.length), t2.push(o);
        continue;
      }
      if (o = this.tokenizer.br(e)) {
        e = e.substring(o.raw.length), t2.push(o);
        continue;
      }
      if (o = this.tokenizer.del(e)) {
        e = e.substring(o.raw.length), t2.push(o);
        continue;
      }
      if (o = this.tokenizer.autolink(e)) {
        e = e.substring(o.raw.length), t2.push(o);
        continue;
      }
      if (!this.state.inLink && (o = this.tokenizer.url(e))) {
        e = e.substring(o.raw.length), t2.push(o);
        continue;
      }
      let a = e;
      if ((_f2 = this.options.extensions) == null ? void 0 : _f2.startInline) {
        let l = 1 / 0, c = e.slice(1), p;
        this.options.extensions.startInline.forEach((g) => {
          p = g.call({ lexer: this }, c), typeof p == "number" && p >= 0 && (l = Math.min(l, p));
        }), l < 1 / 0 && l >= 0 && (a = e.substring(0, l + 1));
      }
      if (o = this.tokenizer.inlineText(a)) {
        e = e.substring(o.raw.length), o.raw.slice(-1) !== "_" && (s = o.raw.slice(-1)), i = true;
        let l = t2.at(-1);
        (l == null ? void 0 : l.type) === "text" ? (l.raw += o.raw, l.text += o.text) : t2.push(o);
        continue;
      }
      if (e) {
        let l = "Infinite loop on byte: " + e.charCodeAt(0);
        if (this.options.silent) {
          console.error(l);
          break;
        } else throw new Error(l);
      }
    }
    return t2;
  }
};
var P = class {
  constructor(e) {
    __publicField(this, "options");
    __publicField(this, "parser");
    this.options = e || T;
  }
  space(e) {
    return "";
  }
  code({ text: e, lang: t2, escaped: n }) {
    var _a3;
    let r2 = (_a3 = (t2 || "").match(m.notSpaceStart)) == null ? void 0 : _a3[0], i = e.replace(m.endingNewline, "") + `
`;
    return r2 ? '<pre><code class="language-' + w(r2) + '">' + (n ? i : w(i, true)) + `</code></pre>
` : "<pre><code>" + (n ? i : w(i, true)) + `</code></pre>
`;
  }
  blockquote({ tokens: e }) {
    return `<blockquote>
${this.parser.parse(e)}</blockquote>
`;
  }
  html({ text: e }) {
    return e;
  }
  def(e) {
    return "";
  }
  heading({ tokens: e, depth: t2 }) {
    return `<h${t2}>${this.parser.parseInline(e)}</h${t2}>
`;
  }
  hr(e) {
    return `<hr>
`;
  }
  list(e) {
    let t2 = e.ordered, n = e.start, r2 = "";
    for (let o = 0; o < e.items.length; o++) {
      let a = e.items[o];
      r2 += this.listitem(a);
    }
    let i = t2 ? "ol" : "ul", s = t2 && n !== 1 ? ' start="' + n + '"' : "";
    return "<" + i + s + `>
` + r2 + "</" + i + `>
`;
  }
  listitem(e) {
    var _a3;
    let t2 = "";
    if (e.task) {
      let n = this.checkbox({ checked: !!e.checked });
      e.loose ? ((_a3 = e.tokens[0]) == null ? void 0 : _a3.type) === "paragraph" ? (e.tokens[0].text = n + " " + e.tokens[0].text, e.tokens[0].tokens && e.tokens[0].tokens.length > 0 && e.tokens[0].tokens[0].type === "text" && (e.tokens[0].tokens[0].text = n + " " + w(e.tokens[0].tokens[0].text), e.tokens[0].tokens[0].escaped = true)) : e.tokens.unshift({ type: "text", raw: n + " ", text: n + " ", escaped: true }) : t2 += n + " ";
    }
    return t2 += this.parser.parse(e.tokens, !!e.loose), `<li>${t2}</li>
`;
  }
  checkbox({ checked: e }) {
    return "<input " + (e ? 'checked="" ' : "") + 'disabled="" type="checkbox">';
  }
  paragraph({ tokens: e }) {
    return `<p>${this.parser.parseInline(e)}</p>
`;
  }
  table(e) {
    let t2 = "", n = "";
    for (let i = 0; i < e.header.length; i++) n += this.tablecell(e.header[i]);
    t2 += this.tablerow({ text: n });
    let r2 = "";
    for (let i = 0; i < e.rows.length; i++) {
      let s = e.rows[i];
      n = "";
      for (let o = 0; o < s.length; o++) n += this.tablecell(s[o]);
      r2 += this.tablerow({ text: n });
    }
    return r2 && (r2 = `<tbody>${r2}</tbody>`), `<table>
<thead>
` + t2 + `</thead>
` + r2 + `</table>
`;
  }
  tablerow({ text: e }) {
    return `<tr>
${e}</tr>
`;
  }
  tablecell(e) {
    let t2 = this.parser.parseInline(e.tokens), n = e.header ? "th" : "td";
    return (e.align ? `<${n} align="${e.align}">` : `<${n}>`) + t2 + `</${n}>
`;
  }
  strong({ tokens: e }) {
    return `<strong>${this.parser.parseInline(e)}</strong>`;
  }
  em({ tokens: e }) {
    return `<em>${this.parser.parseInline(e)}</em>`;
  }
  codespan({ text: e }) {
    return `<code>${w(e, true)}</code>`;
  }
  br(e) {
    return "<br>";
  }
  del({ tokens: e }) {
    return `<del>${this.parser.parseInline(e)}</del>`;
  }
  link({ href: e, title: t2, tokens: n }) {
    let r2 = this.parser.parseInline(n), i = J(e);
    if (i === null) return r2;
    e = i;
    let s = '<a href="' + e + '"';
    return t2 && (s += ' title="' + w(t2) + '"'), s += ">" + r2 + "</a>", s;
  }
  image({ href: e, title: t2, text: n, tokens: r2 }) {
    r2 && (n = this.parser.parseInline(r2, this.parser.textRenderer));
    let i = J(e);
    if (i === null) return w(n);
    e = i;
    let s = `<img src="${e}" alt="${n}"`;
    return t2 && (s += ` title="${w(t2)}"`), s += ">", s;
  }
  text(e) {
    return "tokens" in e && e.tokens ? this.parser.parseInline(e.tokens) : "escaped" in e && e.escaped ? e.text : w(e.text);
  }
};
var $ = class {
  strong({ text: e }) {
    return e;
  }
  em({ text: e }) {
    return e;
  }
  codespan({ text: e }) {
    return e;
  }
  del({ text: e }) {
    return e;
  }
  html({ text: e }) {
    return e;
  }
  text({ text: e }) {
    return e;
  }
  link({ text: e }) {
    return "" + e;
  }
  image({ text: e }) {
    return "" + e;
  }
  br() {
    return "";
  }
};
var b = class u2 {
  constructor(e) {
    __publicField(this, "options");
    __publicField(this, "renderer");
    __publicField(this, "textRenderer");
    this.options = e || T, this.options.renderer = this.options.renderer || new P(), this.renderer = this.options.renderer, this.renderer.options = this.options, this.renderer.parser = this, this.textRenderer = new $();
  }
  static parse(e, t2) {
    return new u2(t2).parse(e);
  }
  static parseInline(e, t2) {
    return new u2(t2).parseInline(e);
  }
  parse(e, t2 = true) {
    var _a3, _b2;
    let n = "";
    for (let r2 = 0; r2 < e.length; r2++) {
      let i = e[r2];
      if ((_b2 = (_a3 = this.options.extensions) == null ? void 0 : _a3.renderers) == null ? void 0 : _b2[i.type]) {
        let o = i, a = this.options.extensions.renderers[o.type].call({ parser: this }, o);
        if (a !== false || !["space", "hr", "heading", "code", "table", "blockquote", "list", "html", "def", "paragraph", "text"].includes(o.type)) {
          n += a || "";
          continue;
        }
      }
      let s = i;
      switch (s.type) {
        case "space": {
          n += this.renderer.space(s);
          continue;
        }
        case "hr": {
          n += this.renderer.hr(s);
          continue;
        }
        case "heading": {
          n += this.renderer.heading(s);
          continue;
        }
        case "code": {
          n += this.renderer.code(s);
          continue;
        }
        case "table": {
          n += this.renderer.table(s);
          continue;
        }
        case "blockquote": {
          n += this.renderer.blockquote(s);
          continue;
        }
        case "list": {
          n += this.renderer.list(s);
          continue;
        }
        case "html": {
          n += this.renderer.html(s);
          continue;
        }
        case "def": {
          n += this.renderer.def(s);
          continue;
        }
        case "paragraph": {
          n += this.renderer.paragraph(s);
          continue;
        }
        case "text": {
          let o = s, a = this.renderer.text(o);
          for (; r2 + 1 < e.length && e[r2 + 1].type === "text"; ) o = e[++r2], a += `
` + this.renderer.text(o);
          t2 ? n += this.renderer.paragraph({ type: "paragraph", raw: a, text: a, tokens: [{ type: "text", raw: a, text: a, escaped: true }] }) : n += a;
          continue;
        }
        default: {
          let o = 'Token with "' + s.type + '" type was not found.';
          if (this.options.silent) return console.error(o), "";
          throw new Error(o);
        }
      }
    }
    return n;
  }
  parseInline(e, t2 = this.renderer) {
    var _a3, _b2;
    let n = "";
    for (let r2 = 0; r2 < e.length; r2++) {
      let i = e[r2];
      if ((_b2 = (_a3 = this.options.extensions) == null ? void 0 : _a3.renderers) == null ? void 0 : _b2[i.type]) {
        let o = this.options.extensions.renderers[i.type].call({ parser: this }, i);
        if (o !== false || !["escape", "html", "link", "image", "strong", "em", "codespan", "br", "del", "text"].includes(i.type)) {
          n += o || "";
          continue;
        }
      }
      let s = i;
      switch (s.type) {
        case "escape": {
          n += t2.text(s);
          break;
        }
        case "html": {
          n += t2.html(s);
          break;
        }
        case "link": {
          n += t2.link(s);
          break;
        }
        case "image": {
          n += t2.image(s);
          break;
        }
        case "strong": {
          n += t2.strong(s);
          break;
        }
        case "em": {
          n += t2.em(s);
          break;
        }
        case "codespan": {
          n += t2.codespan(s);
          break;
        }
        case "br": {
          n += t2.br(s);
          break;
        }
        case "del": {
          n += t2.del(s);
          break;
        }
        case "text": {
          n += t2.text(s);
          break;
        }
        default: {
          let o = 'Token with "' + s.type + '" type was not found.';
          if (this.options.silent) return console.error(o), "";
          throw new Error(o);
        }
      }
    }
    return n;
  }
};
var S = (_f = class {
  constructor(e) {
    __publicField(this, "options");
    __publicField(this, "block");
    this.options = e || T;
  }
  preprocess(e) {
    return e;
  }
  postprocess(e) {
    return e;
  }
  processAllTokens(e) {
    return e;
  }
  emStrongMask(e) {
    return e;
  }
  provideLexer() {
    return this.block ? x.lex : x.lexInline;
  }
  provideParser() {
    return this.block ? b.parse : b.parseInline;
  }
}, __publicField(_f, "passThroughHooks", /* @__PURE__ */ new Set(["preprocess", "postprocess", "processAllTokens", "emStrongMask"])), __publicField(_f, "passThroughHooksRespectAsync", /* @__PURE__ */ new Set(["preprocess", "postprocess", "processAllTokens"])), _f);
var B = class {
  constructor(...e) {
    __publicField(this, "defaults", L());
    __publicField(this, "options", this.setOptions);
    __publicField(this, "parse", this.parseMarkdown(true));
    __publicField(this, "parseInline", this.parseMarkdown(false));
    __publicField(this, "Parser", b);
    __publicField(this, "Renderer", P);
    __publicField(this, "TextRenderer", $);
    __publicField(this, "Lexer", x);
    __publicField(this, "Tokenizer", y);
    __publicField(this, "Hooks", S);
    this.use(...e);
  }
  walkTokens(e, t2) {
    var _a3, _b2;
    let n = [];
    for (let r2 of e) switch (n = n.concat(t2.call(this, r2)), r2.type) {
      case "table": {
        let i = r2;
        for (let s of i.header) n = n.concat(this.walkTokens(s.tokens, t2));
        for (let s of i.rows) for (let o of s) n = n.concat(this.walkTokens(o.tokens, t2));
        break;
      }
      case "list": {
        let i = r2;
        n = n.concat(this.walkTokens(i.items, t2));
        break;
      }
      default: {
        let i = r2;
        ((_b2 = (_a3 = this.defaults.extensions) == null ? void 0 : _a3.childTokens) == null ? void 0 : _b2[i.type]) ? this.defaults.extensions.childTokens[i.type].forEach((s) => {
          let o = i[s].flat(1 / 0);
          n = n.concat(this.walkTokens(o, t2));
        }) : i.tokens && (n = n.concat(this.walkTokens(i.tokens, t2)));
      }
    }
    return n;
  }
  use(...e) {
    let t2 = this.defaults.extensions || { renderers: {}, childTokens: {} };
    return e.forEach((n) => {
      let r2 = __spreadValues({}, n);
      if (r2.async = this.defaults.async || r2.async || false, n.extensions && (n.extensions.forEach((i) => {
        if (!i.name) throw new Error("extension name required");
        if ("renderer" in i) {
          let s = t2.renderers[i.name];
          s ? t2.renderers[i.name] = function(...o) {
            let a = i.renderer.apply(this, o);
            return a === false && (a = s.apply(this, o)), a;
          } : t2.renderers[i.name] = i.renderer;
        }
        if ("tokenizer" in i) {
          if (!i.level || i.level !== "block" && i.level !== "inline") throw new Error("extension level must be 'block' or 'inline'");
          let s = t2[i.level];
          s ? s.unshift(i.tokenizer) : t2[i.level] = [i.tokenizer], i.start && (i.level === "block" ? t2.startBlock ? t2.startBlock.push(i.start) : t2.startBlock = [i.start] : i.level === "inline" && (t2.startInline ? t2.startInline.push(i.start) : t2.startInline = [i.start]));
        }
        "childTokens" in i && i.childTokens && (t2.childTokens[i.name] = i.childTokens);
      }), r2.extensions = t2), n.renderer) {
        let i = this.defaults.renderer || new P(this.defaults);
        for (let s in n.renderer) {
          if (!(s in i)) throw new Error(`renderer '${s}' does not exist`);
          if (["options", "parser"].includes(s)) continue;
          let o = s, a = n.renderer[o], l = i[o];
          i[o] = (...c) => {
            let p = a.apply(i, c);
            return p === false && (p = l.apply(i, c)), p || "";
          };
        }
        r2.renderer = i;
      }
      if (n.tokenizer) {
        let i = this.defaults.tokenizer || new y(this.defaults);
        for (let s in n.tokenizer) {
          if (!(s in i)) throw new Error(`tokenizer '${s}' does not exist`);
          if (["options", "rules", "lexer"].includes(s)) continue;
          let o = s, a = n.tokenizer[o], l = i[o];
          i[o] = (...c) => {
            let p = a.apply(i, c);
            return p === false && (p = l.apply(i, c)), p;
          };
        }
        r2.tokenizer = i;
      }
      if (n.hooks) {
        let i = this.defaults.hooks || new S();
        for (let s in n.hooks) {
          if (!(s in i)) throw new Error(`hook '${s}' does not exist`);
          if (["options", "block"].includes(s)) continue;
          let o = s, a = n.hooks[o], l = i[o];
          S.passThroughHooks.has(s) ? i[o] = (c) => {
            if (this.defaults.async && S.passThroughHooksRespectAsync.has(s)) return (() => __async(this, null, function* () {
              let g = yield a.call(i, c);
              return l.call(i, g);
            }))();
            let p = a.call(i, c);
            return l.call(i, p);
          } : i[o] = (...c) => {
            if (this.defaults.async) return (() => __async(this, null, function* () {
              let g = yield a.apply(i, c);
              return g === false && (g = yield l.apply(i, c)), g;
            }))();
            let p = a.apply(i, c);
            return p === false && (p = l.apply(i, c)), p;
          };
        }
        r2.hooks = i;
      }
      if (n.walkTokens) {
        let i = this.defaults.walkTokens, s = n.walkTokens;
        r2.walkTokens = function(o) {
          let a = [];
          return a.push(s.call(this, o)), i && (a = a.concat(i.call(this, o))), a;
        };
      }
      this.defaults = __spreadValues(__spreadValues({}, this.defaults), r2);
    }), this;
  }
  setOptions(e) {
    return this.defaults = __spreadValues(__spreadValues({}, this.defaults), e), this;
  }
  lexer(e, t2) {
    return x.lex(e, t2 != null ? t2 : this.defaults);
  }
  parser(e, t2) {
    return b.parse(e, t2 != null ? t2 : this.defaults);
  }
  parseMarkdown(e) {
    return (n, r2) => {
      let i = __spreadValues({}, r2), s = __spreadValues(__spreadValues({}, this.defaults), i), o = this.onError(!!s.silent, !!s.async);
      if (this.defaults.async === true && i.async === false) return o(new Error("marked(): The async option was set to true by an extension. Remove async: false from the parse options object to return a Promise."));
      if (typeof n > "u" || n === null) return o(new Error("marked(): input parameter is undefined or null"));
      if (typeof n != "string") return o(new Error("marked(): input parameter is of type " + Object.prototype.toString.call(n) + ", string expected"));
      if (s.hooks && (s.hooks.options = s, s.hooks.block = e), s.async) return (() => __async(this, null, function* () {
        let a = s.hooks ? yield s.hooks.preprocess(n) : n, c = yield (s.hooks ? yield s.hooks.provideLexer() : e ? x.lex : x.lexInline)(a, s), p = s.hooks ? yield s.hooks.processAllTokens(c) : c;
        s.walkTokens && (yield Promise.all(this.walkTokens(p, s.walkTokens)));
        let d = yield (s.hooks ? yield s.hooks.provideParser() : e ? b.parse : b.parseInline)(p, s);
        return s.hooks ? yield s.hooks.postprocess(d) : d;
      }))().catch(o);
      try {
        s.hooks && (n = s.hooks.preprocess(n));
        let l = (s.hooks ? s.hooks.provideLexer() : e ? x.lex : x.lexInline)(n, s);
        s.hooks && (l = s.hooks.processAllTokens(l)), s.walkTokens && this.walkTokens(l, s.walkTokens);
        let p = (s.hooks ? s.hooks.provideParser() : e ? b.parse : b.parseInline)(l, s);
        return s.hooks && (p = s.hooks.postprocess(p)), p;
      } catch (a) {
        return o(a);
      }
    };
  }
  onError(e, t2) {
    return (n) => {
      if (n.message += `
Please report this to https://github.com/markedjs/marked.`, e) {
        let r2 = "<p>An error occurred:</p><pre>" + w(n.message + "", true) + "</pre>";
        return t2 ? Promise.resolve(r2) : r2;
      }
      if (t2) return Promise.reject(n);
      throw n;
    };
  }
};
var _ = new B();
function k(u3, e) {
  return _.parse(u3, e);
}
k.options = k.setOptions = function(u3) {
  return _.setOptions(u3), k.defaults = _.defaults, G(k.defaults), k;
};
k.getDefaults = L;
k.defaults = T;
k.use = function(...u3) {
  return _.use(...u3), k.defaults = _.defaults, G(k.defaults), k;
};
k.walkTokens = function(u3, e) {
  return _.walkTokens(u3, e);
};
k.parseInline = _.parseInline;
k.Parser = b;
k.parser = b.parse;
k.Renderer = P;
k.TextRenderer = $;
k.Lexer = x;
k.lexer = x.lex;
k.Tokenizer = y;
k.Hooks = S;
k.parse = k;
k.options;
k.setOptions;
k.use;
k.walkTokens;
k.parseInline;
b.parse;
x.lex;
var root$L = /* @__PURE__ */ from_html(`<div><!></div>`);
function MarkdownDisplay($$anchor, $$props) {
  push($$props, true);
  let renderedContent = /* @__PURE__ */ user_derived(() => k.parse($$props.content || ""));
  let displayClass = /* @__PURE__ */ user_derived(() => $$props.className || "markdown-display");
  var div = root$L();
  var node = child(div);
  html(node, () => get$3(renderedContent));
  template_effect(() => set_class(div, 1, clsx(get$3(displayClass))));
  append($$anchor, div);
  pop();
}
function handleKeydown$6(event2, handleDoubleClick2) {
  if (event2.key === "Enter" || event2.key === " ") {
    event2.preventDefault();
    handleDoubleClick2();
  }
}
var root_1$y = /* @__PURE__ */ from_html(`<div class="flowdrop-notes-node__processing svelte-1lv2n5m"><div class="flowdrop-notes-node__spinner svelte-1lv2n5m"></div> <span>Processing...</span></div>`);
var root_2$j = /* @__PURE__ */ from_html(`<div class="flowdrop-notes-node__error svelte-1lv2n5m"><!> <span>Error occurred</span></div>`);
var root$K = /* @__PURE__ */ from_html(`<div role="button" tabindex="0"><div><div class="flowdrop-notes-node__header svelte-1lv2n5m"><div class="flowdrop-notes-node__header-left svelte-1lv2n5m"><!> <span class="flowdrop-notes-node__type svelte-1lv2n5m"> </span></div></div> <div class="flowdrop-notes-node__body svelte-1lv2n5m"><!></div> <!> <!></div> <button class="flowdrop-notes-node__config-btn svelte-1lv2n5m" title="Configure note"><!></button></div>`);
function NotesNode($$anchor, $$props) {
  push($$props, true);
  const noteContent = /* @__PURE__ */ user_derived(() => {
    var _a3;
    return ((_a3 = $$props.data.config) == null ? void 0 : _a3.content) || "Add your notes here...";
  });
  const noteType = /* @__PURE__ */ user_derived(() => {
    var _a3;
    return ((_a3 = $$props.data.config) == null ? void 0 : _a3.noteType) || "info";
  });
  const noteTypes = {
    info: {
      name: "Info",
      bgColor: "bg-blue-50",
      borderColor: "border-blue-200",
      textColor: "text-blue-800",
      iconColor: "text-blue-500",
      icon: "mdi:information"
    },
    warning: {
      name: "Warning",
      bgColor: "bg-yellow-50",
      borderColor: "border-yellow-200",
      textColor: "text-yellow-800",
      iconColor: "text-yellow-500",
      icon: "mdi:alert"
    },
    success: {
      name: "Success",
      bgColor: "bg-green-50",
      borderColor: "border-green-200",
      textColor: "text-green-800",
      iconColor: "text-green-500",
      icon: "mdi:check-circle"
    },
    error: {
      name: "Error",
      bgColor: "bg-red-50",
      borderColor: "border-red-200",
      textColor: "text-red-800",
      iconColor: "text-red-500",
      icon: "mdi:close-circle"
    },
    note: {
      name: "Note",
      bgColor: "bg-gray-50",
      borderColor: "border-gray-200",
      textColor: "text-gray-800",
      iconColor: "text-gray-500",
      icon: "mdi:note-text"
    }
  };
  const currentType = /* @__PURE__ */ user_derived(() => noteTypes[get$3(noteType)] || noteTypes.info);
  function openConfigSidebar() {
    if ($$props.data.onConfigOpen) {
      const nodeForConfig = {
        id: $$props.data.nodeId || "unknown",
        type: "note",
        data: $$props.data
      };
      $$props.data.onConfigOpen(nodeForConfig);
    }
  }
  function handleDoubleClick2() {
    openConfigSidebar();
  }
  var div = root$K();
  let classes;
  div.__dblclick = /**
  * Handles keyboard events for accessibility
  * @param event - The keyboard event
  */
  handleDoubleClick2;
  div.__keydown = [handleKeydown$6, handleDoubleClick2];
  var div_1 = child(div);
  var div_2 = child(div_1);
  var div_3 = child(div_2);
  var node = child(div_3);
  Icon(node, {
    get icon() {
      return get$3(currentType).icon;
    },
    get class() {
      var _a3;
      return `flowdrop-notes-node__icon ${(_a3 = get$3(currentType).iconColor) != null ? _a3 : ""}`;
    }
  });
  var span = sibling(node, 2);
  var text2 = child(span);
  var div_4 = sibling(div_2, 2);
  var node_1 = child(div_4);
  MarkdownDisplay(node_1, {
    get content() {
      return get$3(noteContent);
    },
    className: "flowdrop-notes-node__markdown"
  });
  var node_2 = sibling(div_4, 2);
  {
    var consequent = ($$anchor2) => {
      var div_5 = root_1$y();
      append($$anchor2, div_5);
    };
    if_block(node_2, ($$render) => {
      if ($$props.isProcessing) $$render(consequent);
    });
  }
  var node_3 = sibling(node_2, 2);
  {
    var consequent_1 = ($$anchor2) => {
      var div_6 = root_2$j();
      var node_4 = child(div_6);
      Icon(node_4, {
        icon: "mdi:alert-circle",
        class: "flowdrop-notes-node__error-icon"
      });
      append($$anchor2, div_6);
    };
    if_block(node_3, ($$render) => {
      if ($$props.isError) $$render(consequent_1);
    });
  }
  var button = sibling(div_1, 2);
  button.__click = openConfigSidebar;
  var node_5 = child(button);
  Icon(node_5, { icon: "mdi:cog" });
  template_effect(
    ($0) => {
      var _a3, _b2, _c2;
      classes = set_class(div, 1, `flowdrop-notes-node ${(_a3 = get$3(currentType).bgColor) != null ? _a3 : ""}`, "svelte-1lv2n5m", classes, $0);
      set_class(div_1, 1, `flowdrop-notes-node__content ${(_b2 = get$3(currentType).borderColor) != null ? _b2 : ""} ${(_c2 = get$3(currentType).textColor) != null ? _c2 : ""}`, "svelte-1lv2n5m");
      set_text(text2, get$3(currentType).name);
    },
    [
      () => ({
        "flowdrop-notes-node--selected": $$props.selected,
        "flowdrop-notes-node--processing": $$props.isProcessing,
        "flowdrop-notes-node--error": $$props.isError
      })
    ]
  );
  append($$anchor, div);
  pop();
}
delegate(["dblclick", "keydown", "click"]);
function handleClick$1() {
}
function handleKeydown$5(event2, handleDoubleClick2) {
  if (event2.key === "Enter" || event2.key === " ") {
    event2.preventDefault();
    handleDoubleClick2();
  }
}
var root_5$c = /* @__PURE__ */ from_html(`<div class="flowdrop-terminal-node__description svelte-kphwfn"> </div>`);
var root_6$d = /* @__PURE__ */ from_html(`<div class="flowdrop-terminal-node__processing svelte-kphwfn"><div class="flowdrop-terminal-node__spinner svelte-kphwfn"></div></div>`);
var root_7$a = /* @__PURE__ */ from_html(`<div class="flowdrop-terminal-node__error svelte-kphwfn"><!></div>`);
var root$J = /* @__PURE__ */ from_html(`<div role="button" tabindex="0"><button class="flowdrop-terminal-node__config-btn svelte-kphwfn" title="Configure node"><!></button> <div class="flowdrop-terminal-node__circle-wrapper svelte-kphwfn"><!> <div class="flowdrop-terminal-node__content svelte-kphwfn"><!></div> <!></div> <div class="flowdrop-terminal-node__label-container svelte-kphwfn"><div class="flowdrop-terminal-node__label svelte-kphwfn"> </div> <!></div> <!> <!></div>`);
function TerminalNode($$anchor, $$props) {
  push($$props, true);
  const VARIANT_CONFIGS = {
    start: {
      icon: "mdi:play-circle",
      color: "#10b981",
      label: "Start",
      hasInputs: false,
      hasOutputs: true
    },
    end: {
      icon: "mdi:stop-circle",
      color: "#6b7280",
      label: "End",
      hasInputs: true,
      hasOutputs: false
    },
    exit: {
      icon: "mdi:close-circle",
      color: "#ef4444",
      label: "Exit",
      hasInputs: true,
      hasOutputs: false
    }
  };
  function getVariant() {
    var _a3, _b2, _c2, _d2;
    const configVariant = (_a3 = $$props.data.config) == null ? void 0 : _a3.variant;
    if (configVariant && configVariant in VARIANT_CONFIGS) {
      return configVariant;
    }
    const tags2 = ((_b2 = $$props.data.metadata) == null ? void 0 : _b2.tags) || [];
    if (tags2.includes("start") || tags2.includes("entry")) {
      return "start";
    }
    if (tags2.includes("exit") || tags2.includes("abort") || tags2.includes("error")) {
      return "exit";
    }
    if (tags2.includes("end") || tags2.includes("finish") || tags2.includes("complete")) {
      return "end";
    }
    const idLower = (((_c2 = $$props.data.metadata) == null ? void 0 : _c2.id) || "").toLowerCase();
    const nameLower = (((_d2 = $$props.data.metadata) == null ? void 0 : _d2.name) || "").toLowerCase();
    if (idLower.includes("start") || nameLower.includes("start")) {
      return "start";
    }
    if (idLower.includes("exit") || idLower.includes("abort") || nameLower.includes("exit") || nameLower.includes("abort")) {
      return "exit";
    }
    if (idLower.includes("end") || nameLower.includes("end")) {
      return "end";
    }
    return "start";
  }
  let variant = /* @__PURE__ */ user_derived(getVariant);
  let variantConfig = /* @__PURE__ */ user_derived(() => VARIANT_CONFIGS[get$3(variant)]);
  let terminalIcon = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return ((_a3 = $$props.data.metadata) == null ? void 0 : _a3.icon) || ((_b2 = $$props.data.config) == null ? void 0 : _b2.icon) || get$3(variantConfig).icon;
  });
  let terminalColor = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return ((_a3 = $$props.data.metadata) == null ? void 0 : _a3.color) || ((_b2 = $$props.data.config) == null ? void 0 : _b2.color) || get$3(variantConfig).color;
  });
  const displayTitle = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return ((_a3 = $$props.data.config) == null ? void 0 : _a3.instanceTitle) || $$props.data.label || ((_b2 = $$props.data.metadata) == null ? void 0 : _b2.name) || get$3(variantConfig).label;
  });
  const displayDescription = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return ((_a3 = $$props.data.config) == null ? void 0 : _a3.instanceDescription) || ((_b2 = $$props.data.metadata) == null ? void 0 : _b2.description) || "";
  });
  let hasExplicitInputs = /* @__PURE__ */ user_derived(() => {
    var _a3;
    return Array.isArray((_a3 = $$props.data.metadata) == null ? void 0 : _a3.inputs);
  });
  let hasExplicitOutputs = /* @__PURE__ */ user_derived(() => {
    var _a3;
    return Array.isArray((_a3 = $$props.data.metadata) == null ? void 0 : _a3.outputs);
  });
  const DEFAULT_INPUT_PORT = {
    id: "trigger",
    name: "Trigger",
    type: "input",
    dataType: "trigger",
    description: "Workflow trigger input"
  };
  const DEFAULT_OUTPUT_PORT = {
    id: "trigger",
    name: "Trigger",
    type: "output",
    dataType: "trigger",
    description: "Workflow trigger output"
  };
  let inputPorts = /* @__PURE__ */ user_derived(() => get$3(hasExplicitInputs) ? $$props.data.metadata.inputs : get$3(variantConfig).hasInputs ? [DEFAULT_INPUT_PORT] : []);
  let outputPorts = /* @__PURE__ */ user_derived(() => get$3(hasExplicitOutputs) ? $$props.data.metadata.outputs : get$3(variantConfig).hasOutputs ? [DEFAULT_OUTPUT_PORT] : []);
  let showInputs = /* @__PURE__ */ user_derived(() => get$3(inputPorts).length > 0);
  let showOutputs = /* @__PURE__ */ user_derived(() => get$3(outputPorts).length > 0);
  function openConfigSidebar() {
    if ($$props.data.onConfigOpen) {
      const nodeForConfig = {
        id: $$props.data.nodeId || "unknown",
        type: "terminal",
        data: $$props.data
      };
      $$props.data.onConfigOpen(nodeForConfig);
    }
  }
  function handleDoubleClick2() {
    openConfigSidebar();
  }
  var div = root$J();
  let classes;
  div.__click = [
    /**
     * Handle single click - only handle selection
     */
    // Node selection is handled by Svelte Flow
    /**
     * Handle keyboard events for accessibility
     */
    handleClick$1
  ];
  div.__dblclick = handleDoubleClick2;
  div.__keydown = [handleKeydown$5, handleDoubleClick2];
  var button = child(div);
  button.__click = openConfigSidebar;
  var node = child(button);
  Icon(node, { icon: "mdi:cog" });
  var div_1 = sibling(button, 2);
  var node_1 = child(div_1);
  {
    var consequent = ($$anchor2) => {
      var fragment = comment$1();
      var node_2 = first_child(fragment);
      each(node_2, 17, () => get$3(inputPorts), (port) => port.id, ($$anchor3, port) => {
        {
          let $0 = /* @__PURE__ */ user_derived(() => getDataTypeColor(get$3(port).dataType));
          let $1 = /* @__PURE__ */ user_derived(() => `${$$props.data.nodeId}-input-${get$3(port).id}`);
          Handle($$anchor3, {
            type: "target",
            get position() {
              return Position.Left;
            },
            get style() {
              var _a3;
              return `background-color: ${(_a3 = get$3($0)) != null ? _a3 : ""}; border-color: #ffffff; top: 50%; transform: translateY(-50%); z-index: 30;`;
            },
            get id() {
              return get$3($1);
            }
          });
        }
      });
      append($$anchor2, fragment);
    };
    if_block(node_1, ($$render) => {
      if (get$3(showInputs)) $$render(consequent);
    });
  }
  var div_2 = sibling(node_1, 2);
  var node_3 = child(div_2);
  Icon(node_3, {
    get icon() {
      return get$3(terminalIcon);
    },
    class: "flowdrop-terminal-node__icon",
    get style() {
      var _a3;
      return `color: ${(_a3 = get$3(terminalColor)) != null ? _a3 : ""}; font-size: 2.5rem;`;
    }
  });
  var node_4 = sibling(div_2, 2);
  {
    var consequent_1 = ($$anchor2) => {
      var fragment_2 = comment$1();
      var node_5 = first_child(fragment_2);
      each(node_5, 17, () => get$3(outputPorts), (port) => port.id, ($$anchor3, port) => {
        {
          let $0 = /* @__PURE__ */ user_derived(() => `${$$props.data.nodeId}-output-${get$3(port).id}`);
          let $1 = /* @__PURE__ */ user_derived(() => getDataTypeColor(get$3(port).dataType));
          Handle($$anchor3, {
            type: "source",
            get position() {
              return Position.Right;
            },
            get id() {
              return get$3($0);
            },
            get style() {
              var _a3;
              return `background-color: ${(_a3 = get$3($1)) != null ? _a3 : ""}; border-color: #ffffff; top: 50%; transform: translateY(-50%); z-index: 30;`;
            }
          });
        }
      });
      append($$anchor2, fragment_2);
    };
    if_block(node_4, ($$render) => {
      if (get$3(showOutputs)) $$render(consequent_1);
    });
  }
  var div_3 = sibling(div_1, 2);
  var div_4 = child(div_3);
  var text2 = child(div_4);
  var node_6 = sibling(div_4, 2);
  {
    var consequent_2 = ($$anchor2) => {
      var div_5 = root_5$c();
      var text_1 = child(div_5);
      template_effect(() => set_text(text_1, get$3(displayDescription)));
      append($$anchor2, div_5);
    };
    if_block(node_6, ($$render) => {
      if (get$3(displayDescription)) $$render(consequent_2);
    });
  }
  var node_7 = sibling(div_3, 2);
  {
    var consequent_3 = ($$anchor2) => {
      var div_6 = root_6$d();
      append($$anchor2, div_6);
    };
    if_block(node_7, ($$render) => {
      if ($$props.isProcessing) $$render(consequent_3);
    });
  }
  var node_8 = sibling(node_7, 2);
  {
    var consequent_4 = ($$anchor2) => {
      var div_7 = root_7$a();
      var node_9 = child(div_7);
      Icon(node_9, {
        icon: "mdi:alert-circle",
        class: "flowdrop-terminal-node__error-icon"
      });
      append($$anchor2, div_7);
    };
    if_block(node_8, ($$render) => {
      if ($$props.isError) $$render(consequent_4);
    });
  }
  template_effect(
    ($0) => {
      var _a3, _b2, _c2;
      classes = set_class(div, 1, "flowdrop-terminal-node svelte-kphwfn", null, classes, $0);
      set_style(div, `--terminal-color: ${(_a3 = get$3(terminalColor)) != null ? _a3 : ""};`);
      set_attribute(div, "aria-label", `${(_b2 = get$3(variant)) != null ? _b2 : ""} node: ${(_c2 = get$3(displayTitle)) != null ? _c2 : ""}`);
      set_text(text2, get$3(displayTitle));
    },
    [
      () => ({
        "flowdrop-terminal-node--selected": $$props.selected,
        "flowdrop-terminal-node--processing": $$props.isProcessing,
        "flowdrop-terminal-node--error": $$props.isError,
        "flowdrop-terminal-node--start": get$3(variant) === "start",
        "flowdrop-terminal-node--end": get$3(variant) === "end",
        "flowdrop-terminal-node--exit": get$3(variant) === "exit"
      })
    ]
  );
  append($$anchor, div);
  pop();
}
delegate(["click", "dblclick", "keydown"]);
function handleClick() {
}
function handleKeydown$4(event2, handleDoubleClick2) {
  if (event2.key === "Enter" || event2.key === " ") {
    event2.preventDefault();
    handleDoubleClick2();
  }
}
var root_3$f = /* @__PURE__ */ from_html(`<div class="flowdrop-idea-node__processing svelte-116yzim"><div class="flowdrop-idea-node__spinner svelte-116yzim"></div> <span>Processing...</span></div>`);
var root_4$e = /* @__PURE__ */ from_html(`<div class="flowdrop-idea-node__error svelte-116yzim"><!> <span>Error</span></div>`);
var root$I = /* @__PURE__ */ from_html(`<div role="button" tabindex="0"><!> <!> <div class="flowdrop-idea-node__card svelte-116yzim"><div class="flowdrop-idea-node__accent-bar svelte-116yzim"></div> <div class="flowdrop-idea-node__header svelte-116yzim"><div class="flowdrop-idea-node__icon-wrapper svelte-116yzim"><!></div> <h3 class="flowdrop-idea-node__title svelte-116yzim"> </h3></div> <div class="flowdrop-idea-node__body svelte-116yzim"><p class="flowdrop-idea-node__description svelte-116yzim"> </p></div> <!> <!></div> <button class="flowdrop-idea-node__config-btn svelte-116yzim" title="Configure idea"><!></button> <!> <!></div>`);
function IdeaNode($$anchor, $$props) {
  push($$props, true);
  const displayTitle = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2, _c2;
    return ((_a3 = $$props.data.config) == null ? void 0 : _a3.instanceTitle) || ((_b2 = $$props.data.config) == null ? void 0 : _b2.title) || $$props.data.label || ((_c2 = $$props.data.metadata) == null ? void 0 : _c2.name) || "New Idea";
  });
  const displayDescription = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2, _c2;
    return ((_a3 = $$props.data.config) == null ? void 0 : _a3.instanceDescription) || ((_b2 = $$props.data.config) == null ? void 0 : _b2.description) || ((_c2 = $$props.data.metadata) == null ? void 0 : _c2.description) || "Click to add description...";
  });
  const ideaIcon = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return ((_a3 = $$props.data.config) == null ? void 0 : _a3.icon) || ((_b2 = $$props.data.metadata) == null ? void 0 : _b2.icon) || "mdi:lightbulb-outline";
  });
  const ideaColor = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return ((_a3 = $$props.data.config) == null ? void 0 : _a3.color) || ((_b2 = $$props.data.metadata) == null ? void 0 : _b2.color) || "#6366f1";
  });
  const enableLeftPort = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return (_b2 = (_a3 = $$props.data.config) == null ? void 0 : _a3.enableLeftPort) != null ? _b2 : true;
  });
  const enableRightPort = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return (_b2 = (_a3 = $$props.data.config) == null ? void 0 : _a3.enableRightPort) != null ? _b2 : true;
  });
  const enableTopPort = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return (_b2 = (_a3 = $$props.data.config) == null ? void 0 : _a3.enableTopPort) != null ? _b2 : false;
  });
  const enableBottomPort = /* @__PURE__ */ user_derived(() => {
    var _a3, _b2;
    return (_b2 = (_a3 = $$props.data.config) == null ? void 0 : _a3.enableBottomPort) != null ? _b2 : false;
  });
  const IDEA_DATA_TYPE = "idea";
  function openConfigSidebar() {
    if ($$props.data.onConfigOpen) {
      const nodeForConfig = {
        id: $$props.data.nodeId || "unknown",
        type: "idea",
        data: $$props.data
      };
      $$props.data.onConfigOpen(nodeForConfig);
    }
  }
  function handleDoubleClick2() {
    openConfigSidebar();
  }
  var div = root$I();
  let classes;
  div.__click = [
    /**
     * Handle single click - selection handled by SvelteFlow
     */
    // Node selection is handled by Svelte Flow
    /**
     * Handles keyboard events for accessibility
     * @param event - The keyboard event
     */
    handleClick
  ];
  div.__dblclick = handleDoubleClick2;
  div.__keydown = [handleKeydown$4, handleDoubleClick2];
  var node = child(div);
  {
    var consequent = ($$anchor2) => {
      {
        let $0 = /* @__PURE__ */ user_derived(() => getDataTypeColor(IDEA_DATA_TYPE));
        let $1 = /* @__PURE__ */ user_derived(() => `${$$props.data.nodeId}-input-left`);
        Handle($$anchor2, {
          type: "target",
          get position() {
            return Position.Left;
          },
          get style() {
            var _a3;
            return `background-color: ${(_a3 = get$3($0)) != null ? _a3 : ""}; border-color: #ffffff; top: 50%; transform: translateY(-50%); z-index: 30;`;
          },
          get id() {
            return get$3($1);
          }
        });
      }
    };
    if_block(node, ($$render) => {
      if (get$3(enableLeftPort)) $$render(consequent);
    });
  }
  var node_1 = sibling(node, 2);
  {
    var consequent_1 = ($$anchor2) => {
      {
        let $0 = /* @__PURE__ */ user_derived(() => getDataTypeColor(IDEA_DATA_TYPE));
        let $1 = /* @__PURE__ */ user_derived(() => `${$$props.data.nodeId}-input-top`);
        Handle($$anchor2, {
          type: "target",
          get position() {
            return Position.Top;
          },
          get style() {
            var _a3;
            return `background-color: ${(_a3 = get$3($0)) != null ? _a3 : ""}; border-color: #ffffff; left: 50%; transform: translateX(-50%); z-index: 30;`;
          },
          get id() {
            return get$3($1);
          }
        });
      }
    };
    if_block(node_1, ($$render) => {
      if (get$3(enableTopPort)) $$render(consequent_1);
    });
  }
  var div_1 = sibling(node_1, 2);
  var div_2 = sibling(child(div_1), 2);
  var div_3 = child(div_2);
  var node_2 = child(div_3);
  Icon(node_2, {
    get icon() {
      return get$3(ideaIcon);
    },
    class: "flowdrop-idea-node__icon"
  });
  var h3 = sibling(div_3, 2);
  var text2 = child(h3);
  var div_4 = sibling(div_2, 2);
  var p = child(div_4);
  var text_1 = child(p);
  var node_3 = sibling(div_4, 2);
  {
    var consequent_2 = ($$anchor2) => {
      var div_5 = root_3$f();
      append($$anchor2, div_5);
    };
    if_block(node_3, ($$render) => {
      if ($$props.isProcessing) $$render(consequent_2);
    });
  }
  var node_4 = sibling(node_3, 2);
  {
    var consequent_3 = ($$anchor2) => {
      var div_6 = root_4$e();
      var node_5 = child(div_6);
      Icon(node_5, {
        icon: "mdi:alert-circle",
        class: "flowdrop-idea-node__error-icon"
      });
      append($$anchor2, div_6);
    };
    if_block(node_4, ($$render) => {
      if ($$props.isError) $$render(consequent_3);
    });
  }
  var button = sibling(div_1, 2);
  button.__click = openConfigSidebar;
  var node_6 = child(button);
  Icon(node_6, { icon: "mdi:cog" });
  var node_7 = sibling(button, 2);
  {
    var consequent_4 = ($$anchor2) => {
      {
        let $0 = /* @__PURE__ */ user_derived(() => getDataTypeColor(IDEA_DATA_TYPE));
        let $1 = /* @__PURE__ */ user_derived(() => `${$$props.data.nodeId}-output-right`);
        Handle($$anchor2, {
          type: "source",
          get position() {
            return Position.Right;
          },
          get style() {
            var _a3;
            return `background-color: ${(_a3 = get$3($0)) != null ? _a3 : ""}; border-color: #ffffff; top: 50%; transform: translateY(-50%); z-index: 30;`;
          },
          get id() {
            return get$3($1);
          }
        });
      }
    };
    if_block(node_7, ($$render) => {
      if (get$3(enableRightPort)) $$render(consequent_4);
    });
  }
  var node_8 = sibling(node_7, 2);
  {
    var consequent_5 = ($$anchor2) => {
      {
        let $0 = /* @__PURE__ */ user_derived(() => getDataTypeColor(IDEA_DATA_TYPE));
        let $1 = /* @__PURE__ */ user_derived(() => `${$$props.data.nodeId}-output-bottom`);
        Handle($$anchor2, {
          type: "source",
          get position() {
            return Position.Bottom;
          },
          get style() {
            var _a3;
            return `background-color: ${(_a3 = get$3($0)) != null ? _a3 : ""}; border-color: #ffffff; left: 50%; transform: translateX(-50%); z-index: 30;`;
          },
          get id() {
            return get$3($1);
          }
        });
      }
    };
    if_block(node_8, ($$render) => {
      if (get$3(enableBottomPort)) $$render(consequent_5);
    });
  }
  template_effect(
    ($0) => {
      var _a3, _b2;
      classes = set_class(div, 1, "flowdrop-idea-node svelte-116yzim", null, classes, $0);
      set_style(div, `--idea-accent-color: ${(_a3 = get$3(ideaColor)) != null ? _a3 : ""};`);
      set_attribute(div, "aria-label", `Idea node: ${(_b2 = get$3(displayTitle)) != null ? _b2 : ""}`);
      set_text(text2, get$3(displayTitle));
      set_text(text_1, get$3(displayDescription));
    },
    [
      () => ({
        "flowdrop-idea-node--selected": $$props.selected,
        "flowdrop-idea-node--processing": $$props.isProcessing,
        "flowdrop-idea-node--error": $$props.isError
      })
    ]
  );
  append($$anchor, div);
  pop();
}
delegate(["click", "dblclick", "keydown"]);
const FLOWDROP_SOURCE = "flowdrop";
const BUILTIN_NODE_COMPONENTS = [
  {
    type: "workflowNode",
    displayName: "Default (Standard Workflow Node)",
    description: "Full-featured workflow node with inputs/outputs display",
    component: WorkflowNode,
    icon: "mdi:vector-square",
    category: "visual",
    source: FLOWDROP_SOURCE,
    statusPosition: "top-right",
    statusSize: "md"
  },
  {
    type: "simple",
    displayName: "Simple (Compact Layout)",
    description: "Compact node with header, icon, and description",
    component: SimpleNode,
    icon: "mdi:card-outline",
    category: "visual",
    source: FLOWDROP_SOURCE,
    statusPosition: "top-right",
    statusSize: "md"
  },
  {
    type: "square",
    displayName: "Square (Minimal Icon)",
    description: "Minimal square node showing only an icon",
    component: SquareNode,
    icon: "mdi:square",
    category: "visual",
    source: FLOWDROP_SOURCE,
    statusPosition: "top-right",
    statusSize: "sm"
  },
  {
    type: "tool",
    displayName: "Tool (Agent Tool)",
    description: "Specialized node for agent tools with tool metadata",
    component: ToolNode,
    icon: "mdi:tools",
    category: "functional",
    source: FLOWDROP_SOURCE,
    statusPosition: "top-left",
    statusSize: "sm"
  },
  {
    type: "gateway",
    displayName: "Gateway (Branching)",
    description: "Branching control flow node with multiple output branches",
    component: GatewayNode,
    icon: "mdi:source-branch",
    category: "functional",
    source: FLOWDROP_SOURCE,
    statusPosition: "top-right",
    statusSize: "md"
  },
  {
    type: "note",
    displayName: "Note (Sticky Note)",
    description: "Documentation note with markdown support",
    component: NotesNode,
    icon: "mdi:note-text",
    category: "layout",
    source: FLOWDROP_SOURCE,
    statusPosition: "bottom-right",
    statusSize: "sm"
  },
  {
    type: "terminal",
    displayName: "Terminal (Start/End/Exit)",
    description: "Circular terminal node for workflow start, end, or exit points",
    component: TerminalNode,
    icon: "mdi:circle-double",
    category: "functional",
    source: FLOWDROP_SOURCE,
    statusPosition: "top-right",
    statusSize: "sm"
  },
  {
    type: "idea",
    displayName: "Idea (Conceptual Flow)",
    description: "Conceptual idea node for BPMN-like flow diagrams",
    component: IdeaNode,
    icon: "mdi:lightbulb-outline",
    category: "layout",
    source: FLOWDROP_SOURCE,
    statusPosition: "top-right",
    statusSize: "sm"
  }
];
const BUILTIN_TYPE_ALIASES = {
  default: "workflowNode"
};
let builtinsRegistered = false;
function registerBuiltinNodes() {
  if (builtinsRegistered) {
    return;
  }
  nodeComponentRegistry.registerAll(BUILTIN_NODE_COMPONENTS, true);
  nodeComponentRegistry.setDefaultType("workflowNode");
  builtinsRegistered = true;
}
function areBuiltinsRegistered() {
  return builtinsRegistered;
}
function resolveBuiltinAlias(type) {
  var _a3;
  return (_a3 = BUILTIN_TYPE_ALIASES[type]) != null ? _a3 : type;
}
function isBuiltinType(type) {
  const canonicalType = resolveBuiltinAlias(type);
  return BUILTIN_NODE_COMPONENTS.some((reg) => reg.type === canonicalType);
}
function getBuiltinTypes() {
  return BUILTIN_NODE_COMPONENTS.map((reg) => reg.type);
}
const BUILTIN_NODE_TYPES = [
  "workflowNode",
  "simple",
  "square",
  "tool",
  "gateway",
  "note",
  "terminal",
  "idea"
];
registerBuiltinNodes();
const TYPE_DISPLAY_NAMES = {
  note: "Note (sticky note style)",
  simple: "Simple (compact layout)",
  square: "Square (geometric layout)",
  tool: "Tool (specialized for agent tools)",
  gateway: "Gateway (branching control flow)",
  terminal: "Terminal (start/end/exit)",
  default: "Default (standard workflow node)"
};
function getComponentNameForNodeType(nodeType) {
  const resolvedType = resolveBuiltinAlias(nodeType);
  if (nodeComponentRegistry.has(resolvedType)) {
    return resolvedType;
  }
  return "workflowNode";
}
function getAvailableNodeTypes(metadata) {
  if (metadata.supportedTypes && metadata.supportedTypes.length > 0) {
    return metadata.supportedTypes;
  }
  if (metadata.type) {
    return [metadata.type];
  }
  return ["default"];
}
function getPrimaryNodeType(metadata) {
  const availableTypes = getAvailableNodeTypes(metadata);
  return availableTypes[0];
}
function resolveNodeType(metadata, configNodeType) {
  const availableTypes = getAvailableNodeTypes(metadata);
  if (configNodeType) {
    const resolvedConfig = resolveBuiltinAlias(configNodeType);
    if (availableTypes.includes(configNodeType) || availableTypes.includes(resolvedConfig)) {
      return configNodeType;
    }
    if (nodeComponentRegistry.has(configNodeType) || nodeComponentRegistry.has(resolvedConfig)) {
      return configNodeType;
    }
  }
  return getPrimaryNodeType(metadata);
}
function resolveComponentName(metadata, configNodeType) {
  const nodeType = resolveNodeType(metadata, configNodeType);
  return getComponentNameForNodeType(nodeType);
}
function isNodeTypeSupported(metadata, nodeType) {
  const availableTypes = getAvailableNodeTypes(metadata);
  if (availableTypes.includes(nodeType)) {
    return true;
  }
  const resolvedType = resolveBuiltinAlias(nodeType);
  if (availableTypes.includes(resolvedType)) {
    return true;
  }
  if (nodeComponentRegistry.has(nodeType)) {
    return availableTypes.some((t2) => t2 === nodeType || resolveBuiltinAlias(t2) === nodeType);
  }
  return false;
}
function getNodeTypeEnumOptions(metadata, includeCustomTypes = false) {
  const availableTypes = getAvailableNodeTypes(metadata);
  const enumValues = [];
  const enumNames = [];
  for (const type of availableTypes) {
    enumValues.push(type);
    const registration = nodeComponentRegistry.get(type);
    if (registration) {
      enumNames.push(registration.displayName);
    } else if (type in TYPE_DISPLAY_NAMES) {
      enumNames.push(TYPE_DISPLAY_NAMES[type]);
    } else {
      enumNames.push(formatTypeName(type));
    }
  }
  if (includeCustomTypes) {
    const registrations = nodeComponentRegistry.filter({
      predicate: (reg) => !isBuiltinType(reg.type) && !enumValues.includes(reg.type)
    });
    for (const reg of registrations) {
      enumValues.push(reg.type);
      enumNames.push(reg.displayName);
    }
  }
  return { enum: enumValues, enumNames };
}
function createNodeTypeConfigProperty(metadata, defaultType) {
  const { enum: enumValues, enumNames } = getNodeTypeEnumOptions(metadata);
  const primaryType = defaultType != null ? defaultType : getPrimaryNodeType(metadata);
  return {
    type: "string",
    title: "Node Type",
    description: "Choose the visual representation for this node",
    default: primaryType,
    enum: enumValues,
    enumNames
  };
}
function isValidNodeType(type) {
  return isBuiltinType(type) || nodeComponentRegistry.has(type);
}
function getAllNodeTypes() {
  return nodeComponentRegistry.getTypes();
}
function formatTypeName(type) {
  if (type.includes(":")) {
    const [namespace2, name2] = type.split(":");
    return `${capitalize(namespace2)}: ${capitalize(name2)}`;
  }
  return capitalize(type.replace(/([A-Z])/g, " $1").trim());
}
function capitalize(str) {
  return str.charAt(0).toUpperCase() + str.slice(1);
}
function isFieldOptionArray(options2) {
  return options2.length > 0 && typeof options2[0] === "object" && "value" in options2[0];
}
function normalizeOptions(options2) {
  if (!options2 || options2.length === 0) {
    return [];
  }
  if (isFieldOptionArray(options2)) {
    return options2;
  }
  return options2.map((opt) => ({
    value: String(opt),
    label: String(opt)
  }));
}
const DEFAULT_PORT_CONFIG = {
  version: "1.0.0",
  defaultDataType: "string",
  dataTypes: [
    // Text and basic types
    {
      id: "trigger",
      name: "Trigger",
      description: "Control flow of the workflow",
      color: "var(--color-ref-purple-500)",
      category: "basic",
      enabled: true
    },
    // Text and basic types
    {
      id: "string",
      name: "String",
      description: "Text data",
      color: "var(--color-ref-emerald-500)",
      category: "basic",
      enabled: true
    },
    // Numeric types
    {
      id: "number",
      name: "Number",
      description: "Numeric data",
      color: "var(--color-ref-blue-600)",
      category: "numeric",
      enabled: true
    },
    // Boolean types
    {
      id: "boolean",
      name: "Boolean",
      description: "True/false values",
      color: "var(--color-ref-purple-600)",
      category: "logical",
      enabled: true
    },
    // Collection types
    {
      id: "array",
      name: "Array",
      description: "Ordered list of items",
      color: "var(--color-ref-amber-500)",
      category: "collection",
      enabled: true
    },
    // Typed arrays
    {
      id: "string[]",
      name: "String Array",
      description: "Array of strings",
      color: "var(--color-ref-emerald-400)",
      category: "collection",
      enabled: true
    },
    {
      id: "number[]",
      name: "Number Array",
      description: "Array of numbers",
      color: "var(--color-ref-blue-400)",
      category: "collection",
      enabled: true
    },
    {
      id: "boolean[]",
      name: "Boolean Array",
      description: "Array of true/false values",
      color: "var(--color-ref-purple-400)",
      category: "collection",
      enabled: true
    },
    {
      id: "json[]",
      name: "JSON Array",
      description: "Array of JSON objects",
      color: "var(--color-ref-orange-400)",
      category: "collection",
      enabled: true
    },
    {
      id: "file[]",
      name: "File Array",
      description: "Array of files",
      color: "var(--color-ref-red-400)",
      category: "collection",
      enabled: true
    },
    {
      id: "image[]",
      name: "Image Array",
      description: "Array of images",
      color: "var(--color-ref-pink-400)",
      category: "collection",
      enabled: true
    },
    // Complex types
    {
      id: "json",
      name: "JSON",
      description: "JSON structured data",
      color: "var(--color-ref-orange-500)",
      category: "complex",
      enabled: true
    },
    // File types
    {
      id: "file",
      name: "File",
      description: "File data",
      color: "var(--color-ref-red-500)",
      category: "file",
      enabled: true
    },
    // Media types
    {
      id: "image",
      name: "Image",
      description: "Image data",
      color: "var(--color-ref-pink-500)",
      category: "media",
      enabled: true
    },
    {
      id: "audio",
      name: "Audio",
      description: "Audio data",
      color: "var(--color-ref-indigo-500)",
      category: "media",
      enabled: true
    },
    {
      id: "video",
      name: "Video",
      description: "Video data",
      color: "var(--color-ref-teal-500)",
      category: "media",
      enabled: true
    },
    // Special types
    {
      id: "url",
      name: "URL",
      description: "Web address",
      color: "var(--color-ref-cyan-500)",
      category: "special",
      enabled: true
    },
    {
      id: "email",
      name: "Email",
      description: "Email address",
      color: "var(--color-ref-cyan-500)",
      category: "special",
      enabled: true
    },
    {
      id: "date",
      name: "Date",
      description: "Date value",
      color: "var(--color-ref-lime-500)",
      category: "temporal",
      enabled: true
    },
    {
      id: "datetime",
      name: "DateTime",
      description: "Date and time value",
      color: "var(--color-ref-lime-500)",
      category: "temporal",
      enabled: true
    },
    {
      id: "time",
      name: "Time",
      description: "Time value",
      color: "var(--color-ref-lime-500)",
      category: "temporal",
      enabled: true
    }
  ],
  compatibilityRules: [
    // Pure same-type compatibility: string connects to string, number to number, etc.
    // No additional rules needed - the system handles same-type connections automatically
  ]
};
const byteToHex = [];
for (let i = 0; i < 256; ++i) {
  byteToHex.push((i + 256).toString(16).slice(1));
}
function unsafeStringify(arr, offset = 0) {
  return (byteToHex[arr[offset + 0]] + byteToHex[arr[offset + 1]] + byteToHex[arr[offset + 2]] + byteToHex[arr[offset + 3]] + "-" + byteToHex[arr[offset + 4]] + byteToHex[arr[offset + 5]] + "-" + byteToHex[arr[offset + 6]] + byteToHex[arr[offset + 7]] + "-" + byteToHex[arr[offset + 8]] + byteToHex[arr[offset + 9]] + "-" + byteToHex[arr[offset + 10]] + byteToHex[arr[offset + 11]] + byteToHex[arr[offset + 12]] + byteToHex[arr[offset + 13]] + byteToHex[arr[offset + 14]] + byteToHex[arr[offset + 15]]).toLowerCase();
}
let getRandomValues;
const rnds8 = new Uint8Array(16);
function rng() {
  if (!getRandomValues) {
    if (typeof crypto === "undefined" || !crypto.getRandomValues) {
      throw new Error("crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported");
    }
    getRandomValues = crypto.getRandomValues.bind(crypto);
  }
  return getRandomValues(rnds8);
}
const randomUUID = typeof crypto !== "undefined" && crypto.randomUUID && crypto.randomUUID.bind(crypto);
const native = { randomUUID };
function v4(options2, buf, offset) {
  var _a3, _b2, _c2;
  if (native.randomUUID && !buf && !options2) {
    return native.randomUUID();
  }
  options2 = options2 || {};
  const rnds = (_c2 = (_b2 = options2.random) != null ? _b2 : (_a3 = options2.rng) == null ? void 0 : _a3.call(options2)) != null ? _c2 : rng();
  if (rnds.length < 16) {
    throw new Error("Random bytes length must be >= 16");
  }
  rnds[6] = rnds[6] & 15 | 64;
  rnds[8] = rnds[8] & 63 | 128;
  if (buf) {
    offset = offset || 0;
    if (offset < 0 || offset + 16 > buf.length) {
      throw new RangeError(`UUID byte range ${offset}:${offset + 15} is out of buffer bounds`);
    }
    for (let i = 0; i < 16; ++i) {
      buf[offset + i] = rnds[i];
    }
    return buf;
  }
  return unsafeStringify(rnds);
}
const index = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  v4
}, Symbol.toStringTag, { value: "Module" }));
function generateStandardNodeId(nodeTypeId, existingNodes) {
  const existingNodeIds = existingNodes.filter((node) => {
    var _a3, _b2;
    return ((_b2 = (_a3 = node.data) == null ? void 0 : _a3.metadata) == null ? void 0 : _b2.id) === nodeTypeId;
  }).map((node) => node.id);
  const existingNumbers = existingNodeIds.map((id2) => {
    const match = id2.match(new RegExp(`^${nodeTypeId}\\.(\\d+)$`));
    return match ? parseInt(match[1], 10) : 0;
  }).filter((num) => num > 0);
  const nextNumber = existingNumbers.length > 0 ? Math.max(...existingNumbers) + 1 : 1;
  return `${nodeTypeId}.${nextNumber}`;
}
class WorkflowAdapter {
  constructor(nodeTypes = []) {
    __publicField(this, "nodeTypes", []);
    this.nodeTypes = nodeTypes;
  }
  /**
   * Create a new workflow
   */
  createWorkflow(name2, description) {
    return {
      id: v4(),
      name: name2,
      description,
      nodes: [],
      edges: [],
      metadata: {
        version: "1.0.0",
        createdAt: (/* @__PURE__ */ new Date()).toISOString(),
        updatedAt: (/* @__PURE__ */ new Date()).toISOString()
      }
    };
  }
  /**
   * Add a node to a workflow
   */
  addNode(workflow, nodeType, position, config) {
    const metadata = this.nodeTypes.find((nt) => nt.id === nodeType);
    if (!metadata) {
      throw new Error(`Node type '${nodeType}' not found`);
    }
    const nodeId = generateStandardNodeId(nodeType, workflow.nodes);
    const node = {
      id: nodeId,
      type: nodeType,
      position,
      data: {
        label: metadata.name,
        config: config || {},
        metadata
      }
    };
    workflow.nodes.push(node);
    workflow.metadata.updatedAt = (/* @__PURE__ */ new Date()).toISOString();
    return node;
  }
  /**
   * Remove a node from a workflow
   */
  removeNode(workflow, nodeId) {
    const nodeIndex = workflow.nodes.findIndex((n) => n.id === nodeId);
    if (nodeIndex === -1)
      return false;
    workflow.nodes.splice(nodeIndex, 1);
    workflow.edges = workflow.edges.filter((edge) => edge.source !== nodeId && edge.target !== nodeId);
    workflow.metadata.updatedAt = (/* @__PURE__ */ new Date()).toISOString();
    return true;
  }
  /**
   * Update node position
   */
  updateNodePosition(workflow, nodeId, position) {
    const node = workflow.nodes.find((n) => n.id === nodeId);
    if (!node)
      return false;
    node.position = position;
    workflow.metadata.updatedAt = (/* @__PURE__ */ new Date()).toISOString();
    return true;
  }
  /**
   * Update node configuration
   */
  updateNodeConfig(workflow, nodeId, config) {
    const node = workflow.nodes.find((n) => n.id === nodeId);
    if (!node)
      return false;
    node.data.config = __spreadValues(__spreadValues({}, node.data.config), config);
    workflow.metadata.updatedAt = (/* @__PURE__ */ new Date()).toISOString();
    return true;
  }
  /**
   * Add an edge between nodes
   */
  addEdge(workflow, sourceNodeId, targetNodeId, sourceHandle, targetHandle) {
    const edge = {
      id: v4(),
      source: sourceNodeId,
      target: targetNodeId,
      sourceHandle,
      targetHandle
    };
    workflow.edges.push(edge);
    workflow.metadata.updatedAt = (/* @__PURE__ */ new Date()).toISOString();
    return edge;
  }
  /**
   * Remove an edge from a workflow
   */
  removeEdge(workflow, edgeId) {
    const edgeIndex = workflow.edges.findIndex((e) => e.id === edgeId);
    if (edgeIndex === -1)
      return false;
    workflow.edges.splice(edgeIndex, 1);
    workflow.metadata.updatedAt = (/* @__PURE__ */ new Date()).toISOString();
    return true;
  }
  /**
   * Get all nodes of a specific type
   */
  getNodesByType(workflow, nodeType) {
    return workflow.nodes.filter((node) => node.type === nodeType);
  }
  /**
   * Get all edges connected to a node
   */
  getNodeEdges(workflow, nodeId) {
    return workflow.edges.filter((edge) => edge.source === nodeId || edge.target === nodeId);
  }
  /**
   * Get connected nodes (both incoming and outgoing)
   */
  getConnectedNodes(workflow, nodeId) {
    const connectedNodeIds = /* @__PURE__ */ new Set();
    workflow.edges.forEach((edge) => {
      if (edge.source === nodeId) {
        connectedNodeIds.add(edge.target);
      } else if (edge.target === nodeId) {
        connectedNodeIds.add(edge.source);
      }
    });
    return workflow.nodes.filter((node) => connectedNodeIds.has(node.id));
  }
  /**
   * Validate workflow structure
   */
  validateWorkflow(workflow) {
    const errors = [];
    const warnings = [];
    if (workflow.nodes.length === 0) {
      warnings.push("Workflow has no nodes");
    }
    const nodeIds = new Set(workflow.nodes.map((n) => n.id));
    workflow.edges.forEach((edge) => {
      if (!nodeIds.has(edge.source)) {
        errors.push(`Edge ${edge.id} references non-existent source node ${edge.source}`);
      }
      if (!nodeIds.has(edge.target)) {
        errors.push(`Edge ${edge.id} references non-existent target node ${edge.target}`);
      }
    });
    workflow.edges.forEach((edge) => {
      if (edge.source === edge.target) {
        errors.push(`Node ${edge.source} cannot connect to itself`);
      }
    });
    const nodeIdCounts = /* @__PURE__ */ new Map();
    workflow.nodes.forEach((node) => {
      nodeIdCounts.set(node.id, (nodeIdCounts.get(node.id) || 0) + 1);
    });
    nodeIdCounts.forEach((count, id2) => {
      if (count > 1) {
        errors.push(`Duplicate node ID: ${id2}`);
      }
    });
    const edgeIdCounts = /* @__PURE__ */ new Map();
    workflow.edges.forEach((edge) => {
      edgeIdCounts.set(edge.id, (edgeIdCounts.get(edge.id) || 0) + 1);
    });
    edgeIdCounts.forEach((count, id2) => {
      if (count > 1) {
        errors.push(`Duplicate edge ID: ${id2}`);
      }
    });
    return {
      valid: errors.length === 0,
      errors,
      warnings
    };
  }
  /**
   * Export workflow to JSON
   */
  exportWorkflow(workflow) {
    return JSON.stringify(workflow, null, 2);
  }
  /**
   * Import workflow from JSON
   */
  importWorkflow(json2) {
    var _a3, _b2, _c2, _d2;
    try {
      const workflow = JSON.parse(json2);
      const validation = this.validateWorkflow(workflow);
      if (!validation.valid) {
        throw new Error(`Invalid workflow: ${validation.errors.join(", ")}`);
      }
      workflow.metadata = {
        version: ((_a3 = workflow.metadata) == null ? void 0 : _a3.version) || "1.0.0",
        createdAt: ((_b2 = workflow.metadata) == null ? void 0 : _b2.createdAt) || (/* @__PURE__ */ new Date()).toISOString(),
        updatedAt: (/* @__PURE__ */ new Date()).toISOString(),
        author: (_c2 = workflow.metadata) == null ? void 0 : _c2.author,
        tags: (_d2 = workflow.metadata) == null ? void 0 : _d2.tags
      };
      return workflow;
    } catch (error2) {
      throw new Error(`Failed to import workflow: ${error2 instanceof Error ? error2.message : "Unknown error"}`);
    }
  }
  /**
   * Convert SvelteFlow workflow to standard format
   */
  fromSvelteFlow(svelteFlowWorkflow) {
    return {
      id: svelteFlowWorkflow.id,
      name: svelteFlowWorkflow.name,
      description: svelteFlowWorkflow.description,
      nodes: svelteFlowWorkflow.nodes.map((node) => ({
        id: node.id,
        type: node.data.metadata.id,
        position: node.position,
        data: {
          label: node.data.label,
          config: node.data.config,
          metadata: node.data.metadata
        }
      })),
      edges: svelteFlowWorkflow.edges.map((edge) => ({
        id: edge.id,
        source: edge.source,
        target: edge.target,
        sourceHandle: edge.sourceHandle,
        targetHandle: edge.targetHandle
      })),
      metadata: svelteFlowWorkflow.metadata
    };
  }
  /**
   * Convert standard workflow to SvelteFlow format
   */
  toSvelteFlow(workflow) {
    return {
      id: workflow.id,
      name: workflow.name,
      description: workflow.description,
      nodes: workflow.nodes.map((node) => ({
        id: node.id,
        type: "workflowNode",
        position: node.position,
        deletable: true,
        data: {
          label: node.data.label,
          config: node.data.config,
          metadata: node.data.metadata,
          nodeId: node.id
        }
      })),
      edges: workflow.edges.map((edge) => ({
        id: edge.id,
        source: edge.source,
        target: edge.target,
        sourceHandle: edge.sourceHandle,
        targetHandle: edge.targetHandle
      })),
      metadata: workflow.metadata
    };
  }
  /**
   * Get workflow statistics
   */
  getWorkflowStats(workflow) {
    var _a3;
    const nodeTypeCounts = /* @__PURE__ */ new Map();
    workflow.nodes.forEach((node) => {
      nodeTypeCounts.set(node.type, (nodeTypeCounts.get(node.type) || 0) + 1);
    });
    return {
      totalNodes: workflow.nodes.length,
      totalEdges: workflow.edges.length,
      nodeTypeCounts: Object.fromEntries(nodeTypeCounts),
      lastModified: (_a3 = workflow.metadata) == null ? void 0 : _a3.updatedAt
    };
  }
  /**
   * Clone a workflow
   */
  cloneWorkflow(workflow, newName) {
    var _a3, _b2, _c2;
    const cloned = JSON.parse(JSON.stringify(workflow));
    const idMapping = /* @__PURE__ */ new Map();
    const nodeTypeCounts = /* @__PURE__ */ new Map();
    cloned.nodes.forEach((node) => {
      const oldId = node.id;
      const nodeTypeId = node.data.metadata.id;
      const currentCount = nodeTypeCounts.get(nodeTypeId) || 0;
      const newCount = currentCount + 1;
      nodeTypeCounts.set(nodeTypeId, newCount);
      node.id = `${nodeTypeId}.${newCount}`;
      idMapping.set(oldId, node.id);
    });
    cloned.edges.forEach((edge) => {
      edge.id = v4();
      edge.source = idMapping.get(edge.source) || edge.source;
      edge.target = idMapping.get(edge.target) || edge.target;
    });
    cloned.id = v4();
    cloned.name = newName || `${workflow.name} (Copy)`;
    cloned.metadata = {
      version: ((_a3 = cloned.metadata) == null ? void 0 : _a3.version) || "1.0.0",
      createdAt: (/* @__PURE__ */ new Date()).toISOString(),
      updatedAt: (/* @__PURE__ */ new Date()).toISOString(),
      author: (_b2 = cloned.metadata) == null ? void 0 : _b2.author,
      tags: (_c2 = cloned.metadata) == null ? void 0 : _c2.tags
    };
    return cloned;
  }
}
var root_1$x = /* @__PURE__ */ from_html(`<span class="form-field__required svelte-1kbqzj" aria-label="required">*</span>`);
var root_2$i = /* @__PURE__ */ from_html(`<p class="form-field__description svelte-1kbqzj"> </p>`);
var root$H = /* @__PURE__ */ from_html(`<div class="form-field svelte-1kbqzj"><label class="form-field__label svelte-1kbqzj"><span class="form-field__label-text svelte-1kbqzj"> </span> <!></label> <div class="form-field__input-wrapper svelte-1kbqzj"><!></div> <!></div>`);
function FormFieldWrapper($$anchor, $$props) {
  let required = prop($$props, "required", 3, false), animationDelay = prop($$props, "animationDelay", 3, 0);
  const descriptionId = /* @__PURE__ */ user_derived(() => $$props.description ? `${$$props.id}-description` : void 0);
  var div = root$H();
  var label_1 = child(div);
  var span = child(label_1);
  var text2 = child(span);
  var node = sibling(span, 2);
  {
    var consequent = ($$anchor2) => {
      var span_1 = root_1$x();
      append($$anchor2, span_1);
    };
    if_block(node, ($$render) => {
      if (required()) $$render(consequent);
    });
  }
  var div_1 = sibling(label_1, 2);
  var node_1 = child(div_1);
  snippet(node_1, () => $$props.children);
  var node_2 = sibling(div_1, 2);
  {
    var consequent_1 = ($$anchor2) => {
      var p = root_2$i();
      var text_1 = child(p);
      template_effect(() => {
        set_attribute(p, "id", get$3(descriptionId));
        set_text(text_1, $$props.description);
      });
      append($$anchor2, p);
    };
    if_block(node_2, ($$render) => {
      if ($$props.description) $$render(consequent_1);
    });
  }
  template_effect(() => {
    var _a3;
    set_style(div, `animation-delay: ${(_a3 = animationDelay()) != null ? _a3 : ""}ms`);
    set_attribute(label_1, "for", $$props.id);
    set_text(text2, $$props.label);
  });
  append($$anchor, div);
}
function handleInput$5(event2, $$props) {
  const target = event2.currentTarget;
  $$props.onChange(target.value);
}
var root$G = /* @__PURE__ */ from_html(`<input type="text" class="form-text-field svelte-1bbv9xb"/>`);
function FormTextField($$anchor, $$props) {
  push($$props, true);
  let value = prop($$props, "value", 3, ""), placeholder2 = prop($$props, "placeholder", 3, ""), required = prop($$props, "required", 3, false);
  var input = root$G();
  input.__input = [
    /**
     * Handle input changes
     */
    handleInput$5,
    $$props
  ];
  template_effect(() => {
    var _a3;
    set_attribute(input, "id", $$props.id);
    set_value(input, (_a3 = value()) != null ? _a3 : "");
    set_attribute(input, "placeholder", placeholder2());
    set_attribute(input, "aria-describedby", $$props.ariaDescribedBy);
    set_attribute(input, "aria-required", required());
  });
  append($$anchor, input);
  pop();
}
delegate(["input"]);
function handleInput$4(event2, $$props) {
  const target = event2.currentTarget;
  $$props.onChange(target.value);
}
var root$F = /* @__PURE__ */ from_html(`<textarea class="form-textarea svelte-1ldveaa"></textarea>`);
function FormTextarea($$anchor, $$props) {
  push($$props, true);
  let value = prop($$props, "value", 3, ""), placeholder2 = prop($$props, "placeholder", 3, ""), rows = prop($$props, "rows", 3, 4), required = prop($$props, "required", 3, false);
  var textarea = root$F();
  textarea.__input = [
    /**
     * Handle textarea changes
     */
    handleInput$4,
    $$props
  ];
  template_effect(() => {
    var _a3;
    set_attribute(textarea, "id", $$props.id);
    set_value(textarea, (_a3 = value()) != null ? _a3 : "");
    set_attribute(textarea, "placeholder", placeholder2());
    set_attribute(textarea, "rows", rows());
    set_attribute(textarea, "aria-describedby", $$props.ariaDescribedBy);
    set_attribute(textarea, "aria-required", required());
  });
  append($$anchor, textarea);
  pop();
}
delegate(["input"]);
function handleInput$3(event2, $$props) {
  const target = event2.currentTarget;
  const inputValue = target.value;
  if (inputValue === "") {
    $$props.onChange("");
  } else {
    const numValue = Number(inputValue);
    $$props.onChange(isNaN(numValue) ? inputValue : numValue);
  }
}
var root$E = /* @__PURE__ */ from_html(`<input type="number" class="form-number-field svelte-1s98uq1"/>`);
function FormNumberField($$anchor, $$props) {
  push($$props, true);
  let value = prop($$props, "value", 3, ""), placeholder2 = prop($$props, "placeholder", 3, ""), required = prop($$props, "required", 3, false);
  var input = root$E();
  input.__input = [
    /**
     * Handle input changes
     * Returns the value as a number if valid, otherwise as string
     */
    handleInput$3,
    $$props
  ];
  template_effect(() => {
    var _a3;
    set_attribute(input, "id", $$props.id);
    set_value(input, (_a3 = value()) != null ? _a3 : "");
    set_attribute(input, "placeholder", placeholder2());
    set_attribute(input, "min", $$props.min);
    set_attribute(input, "max", $$props.max);
    set_attribute(input, "step", $$props.step);
    set_attribute(input, "aria-describedby", $$props.ariaDescribedBy);
    set_attribute(input, "aria-required", required());
  });
  append($$anchor, input);
  pop();
}
delegate(["input"]);
function handleInput$2(event2, $$props) {
  const target = event2.currentTarget;
  const numValue = Number(target.value);
  $$props.onChange(numValue);
}
var root$D = /* @__PURE__ */ from_html(`<div class="form-range-container svelte-1kxr5xj"><div class="form-range-slider svelte-1kxr5xj"><input type="range" class="form-range-field svelte-1kxr5xj"/></div> <div class="form-range-values svelte-1kxr5xj"><span class="form-range-min svelte-1kxr5xj"> </span> <span class="form-range-current svelte-1kxr5xj"> </span> <span class="form-range-max svelte-1kxr5xj"> </span></div></div>`);
function FormRangeField($$anchor, $$props) {
  push($$props, true);
  let value = prop($$props, "value", 3, 0), min = prop($$props, "min", 3, 0), max = prop($$props, "max", 3, 100), step = prop($$props, "step", 3, 1);
  prop($$props, "required", 3, false);
  const numericValue = /* @__PURE__ */ user_derived(() => {
    if (typeof value() === "number") {
      return value();
    }
    const parsed = Number(value());
    return isNaN(parsed) ? min() : parsed;
  });
  const progressPercentage = /* @__PURE__ */ user_derived(() => {
    const range = max() - min();
    if (range === 0) return 0;
    return (get$3(numericValue) - min()) / range * 100;
  });
  var div = root$D();
  var div_1 = child(div);
  var input = child(div_1);
  input.__input = [
    /**
     * Handle input changes
     * Converts the value to a number and triggers onChange
     */
    handleInput$2,
    $$props
  ];
  var div_2 = sibling(div_1, 2);
  var span = child(div_2);
  var text2 = child(span);
  var span_1 = sibling(span, 2);
  var text_1 = child(span_1);
  var span_2 = sibling(span_1, 2);
  var text_2 = child(span_2);
  template_effect(() => {
    var _a3;
    set_attribute(input, "id", $$props.id);
    set_value(input, get$3(numericValue));
    set_attribute(input, "min", min());
    set_attribute(input, "max", max());
    set_attribute(input, "step", step());
    set_attribute(input, "aria-describedby", $$props.ariaDescribedBy);
    set_attribute(input, "aria-valuemin", min());
    set_attribute(input, "aria-valuemax", max());
    set_attribute(input, "aria-valuenow", get$3(numericValue));
    set_style(input, `--progress: ${(_a3 = get$3(progressPercentage)) != null ? _a3 : ""}%`);
    set_text(text2, min());
    set_text(text_1, get$3(numericValue));
    set_text(text_2, max());
  });
  append($$anchor, div);
  pop();
}
delegate(["input"]);
function handleChange$1(event2, $$props) {
  const target = event2.currentTarget;
  $$props.onChange(target.checked);
}
var root$C = /* @__PURE__ */ from_html(`<label class="form-toggle svelte-zwcce4"><input type="checkbox" class="form-toggle__input svelte-zwcce4"/> <span class="form-toggle__track svelte-zwcce4"><span class="form-toggle__thumb svelte-zwcce4"></span></span> <span class="form-toggle__label svelte-zwcce4"> </span></label>`);
function FormToggle($$anchor, $$props) {
  push($$props, true);
  let value = prop($$props, "value", 3, false), onLabel = prop($$props, "onLabel", 3, "Enabled"), offLabel = prop($$props, "offLabel", 3, "Disabled");
  var label2 = root$C();
  var input = child(label2);
  input.__change = [
    /**
     * Handle toggle changes
     */
    handleChange$1,
    $$props
  ];
  var span = sibling(input, 4);
  var text2 = child(span);
  template_effect(() => {
    set_attribute(input, "id", $$props.id);
    set_checked(input, value());
    set_attribute(input, "aria-describedby", $$props.ariaDescribedBy);
    set_text(text2, value() ? onLabel() : offLabel());
  });
  append($$anchor, label2);
  pop();
}
delegate(["change"]);
function handleChange(event2, $$props) {
  const target = event2.currentTarget;
  $$props.onChange(target.value);
}
var root_1$w = /* @__PURE__ */ from_html(`<option> </option>`);
var root$B = /* @__PURE__ */ from_html(`<div class="form-select-wrapper svelte-1se89nw"><select class="form-select svelte-1se89nw"></select> <span class="form-select__icon svelte-1se89nw" aria-hidden="true"><!></span></div>`);
function FormSelect($$anchor, $$props) {
  push($$props, true);
  let value = prop($$props, "value", 3, ""), options2 = prop($$props, "options", 19, () => []), required = prop($$props, "required", 3, false);
  const normalizedOptions = /* @__PURE__ */ user_derived(() => normalizeOptions(options2()));
  var div = root$B();
  var select2 = child(div);
  select2.__change = [
    /**
     * Handle select changes
     */
    handleChange,
    $$props
  ];
  each(select2, 21, () => get$3(normalizedOptions), (option) => option.value, ($$anchor2, option) => {
    var option_1 = root_1$w();
    var text2 = child(option_1);
    var option_1_value = {};
    template_effect(() => {
      var _a3;
      set_text(text2, get$3(option).label);
      if (option_1_value !== (option_1_value = get$3(option).value)) {
        option_1.value = (_a3 = option_1.__value = get$3(option).value) != null ? _a3 : "";
      }
    });
    append($$anchor2, option_1);
  });
  var select_value;
  init_select(select2);
  var span = sibling(select2, 2);
  var node = child(span);
  Icon(node, { icon: "heroicons:chevron-down" });
  template_effect(() => {
    var _a3, _b2, _c2, _d2;
    set_attribute(select2, "id", $$props.id);
    set_attribute(select2, "aria-describedby", $$props.ariaDescribedBy);
    set_attribute(select2, "aria-required", required());
    if (select_value !== (select_value = (_a3 = value()) != null ? _a3 : "")) {
      select2.value = (_c2 = select2.__value = (_b2 = value()) != null ? _b2 : "") != null ? _c2 : "", select_option(select2, (_d2 = value()) != null ? _d2 : "");
    }
  });
  append($$anchor, div);
  pop();
}
delegate(["change"]);
var on_change$2 = (e, handleCheckboxChange, option) => handleCheckboxChange(option, e.currentTarget.checked);
var root_1$v = /* @__PURE__ */ from_html(`<label class="form-checkbox-item svelte-ldajv8"><input type="checkbox" class="form-checkbox__input svelte-ldajv8"/> <span class="form-checkbox__custom svelte-ldajv8" aria-hidden="true"><!></span> <span class="form-checkbox__label svelte-ldajv8"> </span></label>`);
var root$A = /* @__PURE__ */ from_html(`<div class="form-checkbox-group svelte-ldajv8" role="group"></div>`);
function FormCheckboxGroup($$anchor, $$props) {
  push($$props, true);
  let value = prop($$props, "value", 19, () => []), options2 = prop($$props, "options", 19, () => []);
  function handleCheckboxChange(option, checked) {
    const currentValues = Array.isArray(value()) ? [...value()] : [];
    if (checked) {
      if (!currentValues.includes(option)) {
        $$props.onChange([...currentValues, option]);
      }
    } else {
      $$props.onChange(currentValues.filter((v2) => v2 !== option));
    }
  }
  var div = root$A();
  each(div, 20, options2, (option) => option, ($$anchor2, option) => {
    const isChecked = /* @__PURE__ */ user_derived(() => Array.isArray(value()) && value().includes(option));
    var label2 = root_1$v();
    var input = child(label2);
    input.__change = [on_change$2, handleCheckboxChange, option];
    var span = sibling(input, 2);
    var node = child(span);
    Icon(node, { icon: "heroicons:check" });
    var span_1 = sibling(span, 2);
    var text2 = child(span_1);
    template_effect(() => {
      set_value(input, option);
      set_checked(input, get$3(isChecked));
      set_text(text2, option);
    });
    append($$anchor2, label2);
  });
  template_effect(() => {
    var _a3;
    set_attribute(div, "aria-labelledby", `${(_a3 = $$props.id) != null ? _a3 : ""}-label`);
    set_attribute(div, "aria-describedby", $$props.ariaDescribedBy);
  });
  append($$anchor, div);
  pop();
}
delegate(["change"]);
function addItem(__1, canAddItem, disabled, items, getDefaultValue, $$props) {
  if (!get$3(canAddItem) || disabled()) return;
  const newValue = [...get$3(items), getDefaultValue()];
  $$props.onChange(newValue);
}
var root_3$e = /* @__PURE__ */ from_html(`<button type="button" class="form-array__item-toggle svelte-1bjt05f"><!> <span class="form-array__item-label svelte-1bjt05f"> </span></button>`);
var root_4$d = /* @__PURE__ */ from_html(`<span class="form-array__item-number svelte-1bjt05f"></span>`);
var root_7$9 = /* @__PURE__ */ from_html(`<textarea class="form-array__input form-array__textarea svelte-1bjt05f"></textarea>`);
var root_8$6 = /* @__PURE__ */ from_html(`<input type="text" class="form-array__input svelte-1bjt05f"/>`);
var root_10$9 = /* @__PURE__ */ from_html(`<input type="number" class="form-array__input form-array__input--number svelte-1bjt05f"/>`);
var root_12$5 = /* @__PURE__ */ from_html(`<label class="form-array__toggle-wrapper svelte-1bjt05f"><input type="checkbox" class="form-array__checkbox-input svelte-1bjt05f"/> <span class="form-array__toggle-track svelte-1bjt05f"><span class="form-array__toggle-thumb svelte-1bjt05f"></span></span> <span class="form-array__toggle-label svelte-1bjt05f"> </span></label>`);
var root_15$3 = /* @__PURE__ */ from_html(`<option> </option>`);
var root_14$3 = /* @__PURE__ */ from_html(`<select class="form-array__select svelte-1bjt05f"></select>`);
var root_16$2 = /* @__PURE__ */ from_html(`<input type="text" class="form-array__input svelte-1bjt05f"/>`);
var root_21$1 = /* @__PURE__ */ from_html(`<span class="form-array__required svelte-1bjt05f">*</span>`);
var root_23$1 = /* @__PURE__ */ from_html(`<option> </option>`);
var root_22 = /* @__PURE__ */ from_html(`<select class="form-array__select svelte-1bjt05f"></select>`);
var root_25 = /* @__PURE__ */ from_html(`<textarea class="form-array__input form-array__textarea svelte-1bjt05f"></textarea>`);
var root_27 = /* @__PURE__ */ from_html(`<input type="text" class="form-array__input svelte-1bjt05f"/>`);
var root_29 = /* @__PURE__ */ from_html(`<input type="number" class="form-array__input form-array__input--number svelte-1bjt05f"/>`);
var root_31 = /* @__PURE__ */ from_html(`<label class="form-array__toggle-wrapper svelte-1bjt05f"><input type="checkbox" class="form-array__checkbox-input svelte-1bjt05f"/> <span class="form-array__toggle-track svelte-1bjt05f"><span class="form-array__toggle-thumb svelte-1bjt05f"></span></span> <span class="form-array__toggle-label svelte-1bjt05f"> </span></label>`);
var root_32 = /* @__PURE__ */ from_html(`<input type="text" class="form-array__input svelte-1bjt05f"/>`);
var root_33 = /* @__PURE__ */ from_html(`<p class="form-array__subform-description svelte-1bjt05f"> </p>`);
var root_20$1 = /* @__PURE__ */ from_html(`<div class="form-array__subform-field svelte-1bjt05f"><label class="form-array__subform-label svelte-1bjt05f"><span class="form-array__subform-label-text svelte-1bjt05f"> </span> <!></label> <div class="form-array__subform-input"><!></div> <!></div>`);
var root_19$1 = /* @__PURE__ */ from_html(`<div class="form-array__subform svelte-1bjt05f"></div>`);
var root_34 = /* @__PURE__ */ from_html(`<div class="form-array__unsupported svelte-1bjt05f"><p class="svelte-1bjt05f"> </p></div>`);
var root_2$h = /* @__PURE__ */ from_html(`<div><div class="form-array__item-header svelte-1bjt05f"><!> <div class="form-array__actions svelte-1bjt05f"><button type="button" class="form-array__action-btn form-array__action-btn--move svelte-1bjt05f" title="Move up"><!></button> <button type="button" class="form-array__action-btn form-array__action-btn--move svelte-1bjt05f" title="Move down"><!></button> <button type="button" class="form-array__action-btn form-array__action-btn--delete svelte-1bjt05f" title="Delete item"><!></button></div></div> <div><!></div></div>`);
var root_1$u = /* @__PURE__ */ from_html(`<div class="form-array__items svelte-1bjt05f"></div>`);
var root_35 = /* @__PURE__ */ from_html(`<div class="form-array__empty svelte-1bjt05f"><!> <p class="form-array__empty-text svelte-1bjt05f">No items yet</p></div>`);
var root_37 = /* @__PURE__ */ from_html(`<span class="form-array__limit svelte-1bjt05f"> </span>`);
var root_38 = /* @__PURE__ */ from_html(`<span class="form-array__limit svelte-1bjt05f"> </span>`);
var root_36 = /* @__PURE__ */ from_html(`<div class="form-array__info svelte-1bjt05f"><span class="form-array__count svelte-1bjt05f"> </span> <!> <!></div>`);
var root$z = /* @__PURE__ */ from_html(`<div><!> <button type="button" class="form-array__add-btn svelte-1bjt05f"><!> <span> </span></button> <!></div>`);
function FormArray($$anchor, $$props) {
  push($$props, true);
  let value = prop($$props, "value", 19, () => []), minItems = prop($$props, "minItems", 3, 0), addLabel = prop($$props, "addLabel", 3, "Add Item"), disabled = prop($$props, "disabled", 3, false);
  const items = /* @__PURE__ */ user_derived(() => Array.isArray(value()) ? value() : []);
  const canAddItem = /* @__PURE__ */ user_derived(() => $$props.maxItems === void 0 || get$3(items).length < $$props.maxItems);
  const canRemoveItem = /* @__PURE__ */ user_derived(() => get$3(items).length > minItems());
  const isSimpleType = /* @__PURE__ */ user_derived(() => $$props.itemSchema.type === "string" || $$props.itemSchema.type === "number" || $$props.itemSchema.type === "integer" || $$props.itemSchema.type === "boolean");
  function getDefaultValue() {
    if ($$props.itemSchema.default !== void 0) {
      return $$props.itemSchema.default;
    }
    switch ($$props.itemSchema.type) {
      case "string":
        return "";
      case "number":
      case "integer":
        return 0;
      case "boolean":
        return false;
      case "object":
        if ($$props.itemSchema.properties) {
          const defaultObj = {};
          Object.entries($$props.itemSchema.properties).forEach(([key2, propSchema]) => {
            if (propSchema.default !== void 0) {
              defaultObj[key2] = propSchema.default;
            } else {
              defaultObj[key2] = getDefaultForType(propSchema.type);
            }
          });
          return defaultObj;
        }
        return {};
      case "array":
        return [];
      default:
        return "";
    }
  }
  function getDefaultForType(type) {
    switch (type) {
      case "string":
        return "";
      case "number":
      case "integer":
        return 0;
      case "boolean":
        return false;
      case "object":
        return {};
      case "array":
        return [];
      default:
        return "";
    }
  }
  function removeItem(index2) {
    if (!get$3(canRemoveItem) || disabled()) return;
    const newValue = get$3(items).filter((_2, i) => i !== index2);
    $$props.onChange(newValue);
  }
  function updateItem(index2, newItemValue) {
    const newValue = get$3(items).map((item, i) => i === index2 ? newItemValue : item);
    $$props.onChange(newValue);
  }
  function updateObjectProperty(index2, propertyKey, propertyValue) {
    const currentItem = get$3(items)[index2];
    const updatedItem = __spreadProps(__spreadValues({}, currentItem), { [propertyKey]: propertyValue });
    updateItem(index2, updatedItem);
  }
  function moveItemUp(index2) {
    if (index2 === 0 || disabled()) return;
    const newValue = [...get$3(items)];
    [newValue[index2 - 1], newValue[index2]] = [newValue[index2], newValue[index2 - 1]];
    $$props.onChange(newValue);
  }
  function moveItemDown(index2) {
    if (index2 === get$3(items).length - 1 || disabled()) return;
    const newValue = [...get$3(items)];
    [newValue[index2], newValue[index2 + 1]] = [newValue[index2 + 1], newValue[index2]];
    $$props.onChange(newValue);
  }
  function getItemLabel(index2, item) {
    if (get$3(isSimpleType)) {
      const itemStr = String(item);
      return itemStr.length > 30 ? `${itemStr.substring(0, 30)}...` : itemStr || `Item ${index2 + 1}`;
    }
    if (typeof item === "object" && item !== null) {
      const obj = item;
      const labelKey = Object.keys(obj).find((k2) => ["name", "label", "title", "id"].includes(k2.toLowerCase()));
      if (labelKey && obj[labelKey]) {
        return String(obj[labelKey]);
      }
    }
    return `Item ${index2 + 1}`;
  }
  let collapsedItems = /* @__PURE__ */ state(proxy(/* @__PURE__ */ new Set()));
  function toggleCollapse(index2) {
    const newCollapsed = new Set(get$3(collapsedItems));
    if (newCollapsed.has(index2)) {
      newCollapsed.delete(index2);
    } else {
      newCollapsed.add(index2);
    }
    set$2(collapsedItems, newCollapsed, true);
  }
  function isCollapsed(index2) {
    return get$3(collapsedItems).has(index2);
  }
  var div = root$z();
  let classes;
  var node = child(div);
  {
    var consequent_16 = ($$anchor2) => {
      var div_1 = root_1$u();
      each(div_1, 21, () => get$3(items), index$1, ($$anchor3, item, index2) => {
        var div_2 = root_2$h();
        let classes_1;
        set_style(div_2, `animation-delay: ${index2 * 50}ms`);
        var div_3 = child(div_2);
        var node_1 = child(div_3);
        {
          var consequent = ($$anchor4) => {
            var button = root_3$e();
            button.__click = () => toggleCollapse(index2);
            var node_2 = child(button);
            {
              let $0 = /* @__PURE__ */ user_derived(() => isCollapsed(index2) ? "heroicons:chevron-right" : "heroicons:chevron-down");
              Icon(node_2, {
                get icon() {
                  return get$3($0);
                },
                class: "form-array__toggle-icon"
              });
            }
            var span = sibling(node_2, 2);
            var text2 = child(span);
            template_effect(
              ($0, $1, $2) => {
                set_attribute(button, "aria-expanded", $0);
                set_attribute(button, "aria-label", $1);
                set_text(text2, $2);
              },
              [
                () => !isCollapsed(index2),
                () => isCollapsed(index2) ? "Expand item" : "Collapse item",
                () => getItemLabel(index2, get$3(item))
              ]
            );
            append($$anchor4, button);
          };
          var alternate = ($$anchor4) => {
            var span_1 = root_4$d();
            span_1.textContent = `#${index2 + 1}`;
            append($$anchor4, span_1);
          };
          if_block(node_1, ($$render) => {
            if (!get$3(isSimpleType)) $$render(consequent);
            else $$render(alternate, false);
          });
        }
        var div_4 = sibling(node_1, 2);
        var button_1 = child(div_4);
        button_1.__click = () => moveItemUp(index2);
        set_attribute(button_1, "aria-label", `Move item ${index2 + 1} up`);
        var node_3 = child(button_1);
        Icon(node_3, { icon: "heroicons:arrow-up" });
        var button_2 = sibling(button_1, 2);
        button_2.__click = () => moveItemDown(index2);
        set_attribute(button_2, "aria-label", `Move item ${index2 + 1} down`);
        var node_4 = child(button_2);
        Icon(node_4, { icon: "heroicons:arrow-down" });
        var button_3 = sibling(button_2, 2);
        button_3.__click = () => removeItem(index2);
        set_attribute(button_3, "aria-label", `Delete item ${index2 + 1}`);
        var node_5 = child(button_3);
        Icon(node_5, { icon: "heroicons:trash" });
        var div_5 = sibling(div_3, 2);
        let classes_2;
        var node_6 = child(div_5);
        {
          var consequent_6 = ($$anchor4) => {
            var fragment = comment$1();
            var node_7 = first_child(fragment);
            {
              var consequent_2 = ($$anchor5) => {
                var fragment_1 = comment$1();
                var node_8 = first_child(fragment_1);
                {
                  var consequent_1 = ($$anchor6) => {
                    var textarea = root_7$9();
                    set_attribute(textarea, "rows", 3);
                    textarea.__input = (e) => updateItem(index2, e.currentTarget.value);
                    template_effect(
                      ($0) => {
                        var _a3;
                        set_value(textarea, $0);
                        set_attribute(textarea, "placeholder", (_a3 = $$props.itemSchema.placeholder) != null ? _a3 : "");
                        textarea.disabled = disabled();
                      },
                      [() => {
                        var _a3;
                        return String((_a3 = get$3(item)) != null ? _a3 : "");
                      }]
                    );
                    append($$anchor6, textarea);
                  };
                  var alternate_1 = ($$anchor6) => {
                    var input = root_8$6();
                    input.__input = (e) => updateItem(index2, e.currentTarget.value);
                    template_effect(
                      ($0) => {
                        var _a3;
                        set_value(input, $0);
                        set_attribute(input, "placeholder", (_a3 = $$props.itemSchema.placeholder) != null ? _a3 : "");
                        input.disabled = disabled();
                      },
                      [() => {
                        var _a3;
                        return String((_a3 = get$3(item)) != null ? _a3 : "");
                      }]
                    );
                    append($$anchor6, input);
                  };
                  if_block(node_8, ($$render) => {
                    if ($$props.itemSchema.format === "multiline") $$render(consequent_1);
                    else $$render(alternate_1, false);
                  });
                }
                append($$anchor5, fragment_1);
              };
              var alternate_5 = ($$anchor5) => {
                var fragment_2 = comment$1();
                var node_9 = first_child(fragment_2);
                {
                  var consequent_3 = ($$anchor6) => {
                    var input_1 = root_10$9();
                    input_1.__input = (e) => {
                      const val = e.currentTarget.value;
                      updateItem(index2, val === "" ? "" : Number(val));
                    };
                    template_effect(() => {
                      var _a3;
                      set_value(input_1, get$3(item));
                      set_attribute(input_1, "placeholder", (_a3 = $$props.itemSchema.placeholder) != null ? _a3 : "");
                      set_attribute(input_1, "min", $$props.itemSchema.minimum);
                      set_attribute(input_1, "max", $$props.itemSchema.maximum);
                      input_1.disabled = disabled();
                    });
                    append($$anchor6, input_1);
                  };
                  var alternate_4 = ($$anchor6) => {
                    var fragment_3 = comment$1();
                    var node_10 = first_child(fragment_3);
                    {
                      var consequent_4 = ($$anchor7) => {
                        var label2 = root_12$5();
                        var input_2 = child(label2);
                        input_2.__change = (e) => updateItem(index2, e.currentTarget.checked);
                        var span_2 = sibling(input_2, 4);
                        var text_1 = child(span_2);
                        template_effect(
                          ($0) => {
                            set_checked(input_2, $0);
                            input_2.disabled = disabled();
                            set_text(text_1, get$3(item) ? "Yes" : "No");
                          },
                          [() => Boolean(get$3(item))]
                        );
                        append($$anchor7, label2);
                      };
                      var alternate_3 = ($$anchor7) => {
                        var fragment_4 = comment$1();
                        var node_11 = first_child(fragment_4);
                        {
                          var consequent_5 = ($$anchor8) => {
                            var select2 = root_14$3();
                            select2.__change = (e) => updateItem(index2, e.currentTarget.value);
                            each(select2, 21, () => $$props.itemSchema.enum, index$1, ($$anchor9, option) => {
                              var option_1 = root_15$3();
                              var text_2 = child(option_1);
                              var option_1_value = {};
                              template_effect(
                                ($0, $1) => {
                                  var _a3;
                                  set_text(text_2, $0);
                                  if (option_1_value !== (option_1_value = $1)) {
                                    option_1.value = (_a3 = option_1.__value = $1) != null ? _a3 : "";
                                  }
                                },
                                [() => String(get$3(option)), () => String(get$3(option))]
                              );
                              append($$anchor9, option_1);
                            });
                            var select_value;
                            init_select(select2);
                            template_effect(
                              ($0) => {
                                var _a3;
                                select2.disabled = disabled();
                                if (select_value !== (select_value = $0)) {
                                  select2.value = (_a3 = select2.__value = $0) != null ? _a3 : "", select_option(select2, $0);
                                }
                              },
                              [() => {
                                var _a3;
                                return String((_a3 = get$3(item)) != null ? _a3 : "");
                              }]
                            );
                            append($$anchor8, select2);
                          };
                          var alternate_2 = ($$anchor8) => {
                            var input_3 = root_16$2();
                            input_3.__input = (e) => updateItem(index2, e.currentTarget.value);
                            template_effect(
                              ($0) => {
                                var _a3;
                                set_value(input_3, $0);
                                set_attribute(input_3, "placeholder", (_a3 = $$props.itemSchema.placeholder) != null ? _a3 : "");
                                input_3.disabled = disabled();
                              },
                              [() => {
                                var _a3;
                                return String((_a3 = get$3(item)) != null ? _a3 : "");
                              }]
                            );
                            append($$anchor8, input_3);
                          };
                          if_block(
                            node_11,
                            ($$render) => {
                              if ($$props.itemSchema.enum) $$render(consequent_5);
                              else $$render(alternate_2, false);
                            },
                            true
                          );
                        }
                        append($$anchor7, fragment_4);
                      };
                      if_block(
                        node_10,
                        ($$render) => {
                          if ($$props.itemSchema.type === "boolean") $$render(consequent_4);
                          else $$render(alternate_3, false);
                        },
                        true
                      );
                    }
                    append($$anchor6, fragment_3);
                  };
                  if_block(
                    node_9,
                    ($$render) => {
                      if ($$props.itemSchema.type === "number" || $$props.itemSchema.type === "integer") $$render(consequent_3);
                      else $$render(alternate_4, false);
                    },
                    true
                  );
                }
                append($$anchor5, fragment_2);
              };
              if_block(node_7, ($$render) => {
                if ($$props.itemSchema.type === "string") $$render(consequent_2);
                else $$render(alternate_5, false);
              });
            }
            append($$anchor4, fragment);
          };
          var alternate_12 = ($$anchor4) => {
            var fragment_5 = comment$1();
            var node_12 = first_child(fragment_5);
            {
              var consequent_15 = ($$anchor5) => {
                var fragment_6 = comment$1();
                var node_13 = first_child(fragment_6);
                {
                  var consequent_14 = ($$anchor6) => {
                    var div_6 = root_19$1();
                    each(div_6, 23, () => Object.entries($$props.itemSchema.properties), ([propKey, propSchema]) => propKey, ($$anchor7, $$item, propIndex) => {
                      var $$array_2 = /* @__PURE__ */ user_derived(() => to_array(get$3($$item), 2));
                      let propKey = () => get$3($$array_2)[0];
                      let propSchema = () => get$3($$array_2)[1];
                      const propValue = /* @__PURE__ */ user_derived(() => {
                        var _a3;
                        return (_a3 = get$3(item)) == null ? void 0 : _a3[propKey()];
                      });
                      const isRequired = /* @__PURE__ */ user_derived(() => {
                        var _a3, _b2;
                        return (_b2 = (_a3 = $$props.itemSchema.required) == null ? void 0 : _a3.includes(propKey())) != null ? _b2 : false;
                      });
                      const propFieldSchema = /* @__PURE__ */ user_derived(propSchema);
                      var div_7 = root_20$1();
                      var label_1 = child(div_7);
                      var span_3 = child(label_1);
                      var text_3 = child(span_3);
                      var node_14 = sibling(span_3, 2);
                      {
                        var consequent_7 = ($$anchor8) => {
                          var span_4 = root_21$1();
                          append($$anchor8, span_4);
                        };
                        if_block(node_14, ($$render) => {
                          if (get$3(isRequired)) $$render(consequent_7);
                        });
                      }
                      var div_8 = sibling(label_1, 2);
                      var node_15 = child(div_8);
                      {
                        var consequent_8 = ($$anchor8) => {
                          var select_1 = root_22();
                          select_1.__change = (e) => updateObjectProperty(index2, propKey(), e.currentTarget.value);
                          each(select_1, 21, () => get$3(propFieldSchema).enum, index$1, ($$anchor9, option) => {
                            var option_2 = root_23$1();
                            var text_4 = child(option_2);
                            var option_2_value = {};
                            template_effect(
                              ($0, $1) => {
                                var _a3;
                                set_text(text_4, $0);
                                if (option_2_value !== (option_2_value = $1)) {
                                  option_2.value = (_a3 = option_2.__value = $1) != null ? _a3 : "";
                                }
                              },
                              [() => String(get$3(option)), () => String(get$3(option))]
                            );
                            append($$anchor9, option_2);
                          });
                          var select_1_value;
                          init_select(select_1);
                          template_effect(
                            ($0) => {
                              var _a3, _b2, _c2;
                              set_attribute(select_1, "id", `${(_a3 = $$props.id) != null ? _a3 : ""}-${index2}-${(_b2 = propKey()) != null ? _b2 : ""}`);
                              select_1.disabled = disabled();
                              if (select_1_value !== (select_1_value = $0)) {
                                select_1.value = (_c2 = select_1.__value = $0) != null ? _c2 : "", select_option(select_1, $0);
                              }
                            },
                            [() => {
                              var _a3;
                              return String((_a3 = get$3(propValue)) != null ? _a3 : "");
                            }]
                          );
                          append($$anchor8, select_1);
                        };
                        var alternate_10 = ($$anchor8) => {
                          var fragment_7 = comment$1();
                          var node_16 = first_child(fragment_7);
                          {
                            var consequent_9 = ($$anchor9) => {
                              var textarea_1 = root_25();
                              set_attribute(textarea_1, "rows", 3);
                              textarea_1.__input = (e) => updateObjectProperty(index2, propKey(), e.currentTarget.value);
                              template_effect(
                                ($0) => {
                                  var _a3, _b2, _c2;
                                  set_attribute(textarea_1, "id", `${(_a3 = $$props.id) != null ? _a3 : ""}-${index2}-${(_b2 = propKey()) != null ? _b2 : ""}`);
                                  set_value(textarea_1, $0);
                                  set_attribute(textarea_1, "placeholder", (_c2 = get$3(propFieldSchema).placeholder) != null ? _c2 : "");
                                  textarea_1.disabled = disabled();
                                },
                                [() => {
                                  var _a3;
                                  return String((_a3 = get$3(propValue)) != null ? _a3 : "");
                                }]
                              );
                              append($$anchor9, textarea_1);
                            };
                            var alternate_9 = ($$anchor9) => {
                              var fragment_8 = comment$1();
                              var node_17 = first_child(fragment_8);
                              {
                                var consequent_10 = ($$anchor10) => {
                                  var input_4 = root_27();
                                  input_4.__input = (e) => updateObjectProperty(index2, propKey(), e.currentTarget.value);
                                  template_effect(
                                    ($0) => {
                                      var _a3, _b2, _c2;
                                      set_attribute(input_4, "id", `${(_a3 = $$props.id) != null ? _a3 : ""}-${index2}-${(_b2 = propKey()) != null ? _b2 : ""}`);
                                      set_value(input_4, $0);
                                      set_attribute(input_4, "placeholder", (_c2 = get$3(propFieldSchema).placeholder) != null ? _c2 : "");
                                      input_4.disabled = disabled();
                                    },
                                    [() => {
                                      var _a3;
                                      return String((_a3 = get$3(propValue)) != null ? _a3 : "");
                                    }]
                                  );
                                  append($$anchor10, input_4);
                                };
                                var alternate_8 = ($$anchor10) => {
                                  var fragment_9 = comment$1();
                                  var node_18 = first_child(fragment_9);
                                  {
                                    var consequent_11 = ($$anchor11) => {
                                      var input_5 = root_29();
                                      input_5.__input = (e) => {
                                        const val = e.currentTarget.value;
                                        updateObjectProperty(index2, propKey(), val === "" ? "" : Number(val));
                                      };
                                      template_effect(() => {
                                        var _a3, _b2, _c2;
                                        set_attribute(input_5, "id", `${(_a3 = $$props.id) != null ? _a3 : ""}-${index2}-${(_b2 = propKey()) != null ? _b2 : ""}`);
                                        set_value(input_5, get$3(propValue));
                                        set_attribute(input_5, "placeholder", (_c2 = get$3(propFieldSchema).placeholder) != null ? _c2 : "");
                                        set_attribute(input_5, "min", get$3(propFieldSchema).minimum);
                                        set_attribute(input_5, "max", get$3(propFieldSchema).maximum);
                                        input_5.disabled = disabled();
                                      });
                                      append($$anchor11, input_5);
                                    };
                                    var alternate_7 = ($$anchor11) => {
                                      var fragment_10 = comment$1();
                                      var node_19 = first_child(fragment_10);
                                      {
                                        var consequent_12 = ($$anchor12) => {
                                          var label_2 = root_31();
                                          var input_6 = child(label_2);
                                          input_6.__change = (e) => updateObjectProperty(index2, propKey(), e.currentTarget.checked);
                                          var span_5 = sibling(input_6, 4);
                                          var text_5 = child(span_5);
                                          template_effect(
                                            ($0) => {
                                              var _a3, _b2;
                                              set_attribute(input_6, "id", `${(_a3 = $$props.id) != null ? _a3 : ""}-${index2}-${(_b2 = propKey()) != null ? _b2 : ""}`);
                                              set_checked(input_6, $0);
                                              input_6.disabled = disabled();
                                              set_text(text_5, get$3(propValue) ? "Yes" : "No");
                                            },
                                            [() => Boolean(get$3(propValue))]
                                          );
                                          append($$anchor12, label_2);
                                        };
                                        var alternate_6 = ($$anchor12) => {
                                          var input_7 = root_32();
                                          input_7.__input = (e) => updateObjectProperty(index2, propKey(), e.currentTarget.value);
                                          template_effect(
                                            ($0) => {
                                              var _a3, _b2, _c2;
                                              set_attribute(input_7, "id", `${(_a3 = $$props.id) != null ? _a3 : ""}-${index2}-${(_b2 = propKey()) != null ? _b2 : ""}`);
                                              set_value(input_7, $0);
                                              set_attribute(input_7, "placeholder", (_c2 = get$3(propFieldSchema).placeholder) != null ? _c2 : "");
                                              input_7.disabled = disabled();
                                            },
                                            [() => {
                                              var _a3;
                                              return String((_a3 = get$3(propValue)) != null ? _a3 : "");
                                            }]
                                          );
                                          append($$anchor12, input_7);
                                        };
                                        if_block(
                                          node_19,
                                          ($$render) => {
                                            if (get$3(propFieldSchema).type === "boolean") $$render(consequent_12);
                                            else $$render(alternate_6, false);
                                          },
                                          true
                                        );
                                      }
                                      append($$anchor11, fragment_10);
                                    };
                                    if_block(
                                      node_18,
                                      ($$render) => {
                                        if (get$3(propFieldSchema).type === "number" || get$3(propFieldSchema).type === "integer") $$render(consequent_11);
                                        else $$render(alternate_7, false);
                                      },
                                      true
                                    );
                                  }
                                  append($$anchor10, fragment_9);
                                };
                                if_block(
                                  node_17,
                                  ($$render) => {
                                    if (get$3(propFieldSchema).type === "string") $$render(consequent_10);
                                    else $$render(alternate_8, false);
                                  },
                                  true
                                );
                              }
                              append($$anchor9, fragment_8);
                            };
                            if_block(
                              node_16,
                              ($$render) => {
                                if (get$3(propFieldSchema).type === "string" && get$3(propFieldSchema).format === "multiline") $$render(consequent_9);
                                else $$render(alternate_9, false);
                              },
                              true
                            );
                          }
                          append($$anchor8, fragment_7);
                        };
                        if_block(node_15, ($$render) => {
                          if (get$3(propFieldSchema).enum) $$render(consequent_8);
                          else $$render(alternate_10, false);
                        });
                      }
                      var node_20 = sibling(div_8, 2);
                      {
                        var consequent_13 = ($$anchor8) => {
                          var p = root_33();
                          var text_6 = child(p);
                          template_effect(() => set_text(text_6, get$3(propFieldSchema).description));
                          append($$anchor8, p);
                        };
                        if_block(node_20, ($$render) => {
                          if (get$3(propFieldSchema).description && get$3(propFieldSchema).title) $$render(consequent_13);
                        });
                      }
                      template_effect(() => {
                        var _a3, _b2, _c2;
                        set_style(div_7, `animation-delay: ${get$3(propIndex) * 20}ms`);
                        set_attribute(label_1, "for", `${(_a3 = $$props.id) != null ? _a3 : ""}-${index2}-${(_b2 = propKey()) != null ? _b2 : ""}`);
                        set_text(text_3, (_c2 = get$3(propFieldSchema).title) != null ? _c2 : propKey());
                      });
                      append($$anchor7, div_7);
                    });
                    append($$anchor6, div_6);
                  };
                  if_block(node_13, ($$render) => {
                    if (!isCollapsed(index2)) $$render(consequent_14);
                  });
                }
                append($$anchor5, fragment_6);
              };
              var alternate_11 = ($$anchor5) => {
                var div_9 = root_34();
                var p_1 = child(div_9);
                var text_7 = child(p_1);
                template_effect(() => {
                  var _a3;
                  return set_text(text_7, `Complex item type "${(_a3 = $$props.itemSchema.type) != null ? _a3 : ""}" is not fully supported.`);
                });
                append($$anchor5, div_9);
              };
              if_block(
                node_12,
                ($$render) => {
                  if ($$props.itemSchema.type === "object" && $$props.itemSchema.properties) $$render(consequent_15);
                  else $$render(alternate_11, false);
                },
                true
              );
            }
            append($$anchor4, fragment_5);
          };
          if_block(node_6, ($$render) => {
            if (get$3(isSimpleType)) $$render(consequent_6);
            else $$render(alternate_12, false);
          });
        }
        template_effect(
          ($0, $1) => {
            classes_1 = set_class(div_2, 1, "form-array__item svelte-1bjt05f", null, classes_1, $0);
            button_1.disabled = index2 === 0 || disabled();
            button_2.disabled = index2 === get$3(items).length - 1 || disabled();
            button_3.disabled = !get$3(canRemoveItem) || disabled();
            classes_2 = set_class(div_5, 1, "form-array__item-content svelte-1bjt05f", null, classes_2, $1);
          },
          [
            () => ({
              "form-array__item--simple": get$3(isSimpleType),
              "form-array__item--complex": !get$3(isSimpleType)
            }),
            () => ({
              "form-array__item-content--collapsed": !get$3(isSimpleType) && isCollapsed(index2)
            })
          ]
        );
        append($$anchor3, div_2);
      });
      append($$anchor2, div_1);
    };
    var alternate_13 = ($$anchor2) => {
      var div_10 = root_35();
      var node_21 = child(div_10);
      Icon(node_21, {
        icon: "heroicons:squares-plus",
        class: "form-array__empty-icon"
      });
      append($$anchor2, div_10);
    };
    if_block(node, ($$render) => {
      if (get$3(items).length > 0) $$render(consequent_16);
      else $$render(alternate_13, false);
    });
  }
  var button_4 = sibling(node, 2);
  button_4.__click = [
    addItem,
    canAddItem,
    disabled,
    items,
    getDefaultValue,
    $$props
  ];
  var node_22 = child(button_4);
  Icon(node_22, { icon: "heroicons:plus" });
  var span_6 = sibling(node_22, 2);
  var text_8 = child(span_6);
  var node_23 = sibling(button_4, 2);
  {
    var consequent_19 = ($$anchor2) => {
      var div_11 = root_36();
      var span_7 = child(div_11);
      var text_9 = child(span_7);
      var node_24 = sibling(span_7, 2);
      {
        var consequent_17 = ($$anchor3) => {
          var span_8 = root_37();
          var text_10 = child(span_8);
          template_effect(() => {
            var _a3;
            return set_text(text_10, `Min: ${(_a3 = minItems()) != null ? _a3 : ""}`);
          });
          append($$anchor3, span_8);
        };
        if_block(node_24, ($$render) => {
          if (minItems() > 0) $$render(consequent_17);
        });
      }
      var node_25 = sibling(node_24, 2);
      {
        var consequent_18 = ($$anchor3) => {
          var span_9 = root_38();
          var text_11 = child(span_9);
          template_effect(() => {
            var _a3;
            return set_text(text_11, `Max: ${(_a3 = $$props.maxItems) != null ? _a3 : ""}`);
          });
          append($$anchor3, span_9);
        };
        if_block(node_25, ($$render) => {
          if ($$props.maxItems !== void 0) $$render(consequent_18);
        });
      }
      template_effect(() => {
        var _a3;
        return set_text(text_9, `${(_a3 = get$3(items).length) != null ? _a3 : ""} item${get$3(items).length !== 1 ? "s" : ""}`);
      });
      append($$anchor2, div_11);
    };
    if_block(node_23, ($$render) => {
      if (minItems() > 0 || $$props.maxItems !== void 0) $$render(consequent_19);
    });
  }
  template_effect(
    ($0) => {
      classes = set_class(div, 1, "form-array svelte-1bjt05f", null, classes, $0);
      button_4.disabled = !get$3(canAddItem) || disabled();
      set_attribute(button_4, "aria-label", addLabel());
      set_text(text_8, addLabel());
    },
    [() => ({ "form-array--disabled": disabled() })]
  );
  append($$anchor, div);
  pop();
}
delegate(["click", "input", "change"]);
let rangeFrom = [], rangeTo = [];
(() => {
  let numbers = "lc,34,7n,7,7b,19,,,,2,,2,,,20,b,1c,l,g,,2t,7,2,6,2,2,,4,z,,u,r,2j,b,1m,9,9,,o,4,,9,,3,,5,17,3,3b,f,,w,1j,,,,4,8,4,,3,7,a,2,t,,1m,,,,2,4,8,,9,,a,2,q,,2,2,1l,,4,2,4,2,2,3,3,,u,2,3,,b,2,1l,,4,5,,2,4,,k,2,m,6,,,1m,,,2,,4,8,,7,3,a,2,u,,1n,,,,c,,9,,14,,3,,1l,3,5,3,,4,7,2,b,2,t,,1m,,2,,2,,3,,5,2,7,2,b,2,s,2,1l,2,,,2,4,8,,9,,a,2,t,,20,,4,,2,3,,,8,,29,,2,7,c,8,2q,,2,9,b,6,22,2,r,,,,,,1j,e,,5,,2,5,b,,10,9,,2u,4,,6,,2,2,2,p,2,4,3,g,4,d,,2,2,6,,f,,jj,3,qa,3,t,3,t,2,u,2,1s,2,,7,8,,2,b,9,,19,3,3b,2,y,,3a,3,4,2,9,,6,3,63,2,2,,1m,,,7,,,,,2,8,6,a,2,,1c,h,1r,4,1c,7,,,5,,14,9,c,2,w,4,2,2,,3,1k,,,2,3,,,3,1m,8,2,2,48,3,,d,,7,4,,6,,3,2,5i,1m,,5,ek,,5f,x,2da,3,3x,,2o,w,fe,6,2x,2,n9w,4,,a,w,2,28,2,7k,,3,,4,,p,2,5,,47,2,q,i,d,,12,8,p,b,1a,3,1c,,2,4,2,2,13,,1v,6,2,2,2,2,c,,8,,1b,,1f,,,3,2,2,5,2,,,16,2,8,,6m,,2,,4,,fn4,,kh,g,g,g,a6,2,gt,,6a,,45,5,1ae,3,,2,5,4,14,3,4,,4l,2,fx,4,ar,2,49,b,4w,,1i,f,1k,3,1d,4,2,2,1x,3,10,5,,8,1q,,c,2,1g,9,a,4,2,,2n,3,2,,,2,6,,4g,,3,8,l,2,1l,2,,,,,m,,e,7,3,5,5f,8,2,3,,,n,,29,,2,6,,,2,,,2,,2,6j,,2,4,6,2,,2,r,2,2d,8,2,,,2,2y,,,,2,6,,,2t,3,2,4,,5,77,9,,2,6t,,a,2,,,4,,40,4,2,2,4,,w,a,14,6,2,4,8,,9,6,2,3,1a,d,,2,ba,7,,6,,,2a,m,2,7,,2,,2,3e,6,3,,,2,,7,,,20,2,3,,,,9n,2,f0b,5,1n,7,t4,,1r,4,29,,f5k,2,43q,,,3,4,5,8,8,2,7,u,4,44,3,1iz,1j,4,1e,8,,e,,m,5,,f,11s,7,,h,2,7,,2,,5,79,7,c5,4,15s,7,31,7,240,5,gx7k,2o,3k,6o".split(",").map((s) => s ? parseInt(s, 36) : 1);
  for (let i = 0, n = 0; i < numbers.length; i++)
    (i % 2 ? rangeTo : rangeFrom).push(n = n + numbers[i]);
})();
function isExtendingChar(code) {
  if (code < 768) return false;
  for (let from = 0, to = rangeFrom.length; ; ) {
    let mid = from + to >> 1;
    if (code < rangeFrom[mid]) to = mid;
    else if (code >= rangeTo[mid]) from = mid + 1;
    else return true;
    if (from == to) return false;
  }
}
function isRegionalIndicator(code) {
  return code >= 127462 && code <= 127487;
}
const ZWJ = 8205;
function findClusterBreak$1(str, pos, forward = true, includeExtending = true) {
  return (forward ? nextClusterBreak : prevClusterBreak)(str, pos, includeExtending);
}
function nextClusterBreak(str, pos, includeExtending) {
  if (pos == str.length) return pos;
  if (pos && surrogateLow$1(str.charCodeAt(pos)) && surrogateHigh$1(str.charCodeAt(pos - 1))) pos--;
  let prev = codePointAt$1(str, pos);
  pos += codePointSize$1(prev);
  while (pos < str.length) {
    let next = codePointAt$1(str, pos);
    if (prev == ZWJ || next == ZWJ || includeExtending && isExtendingChar(next)) {
      pos += codePointSize$1(next);
      prev = next;
    } else if (isRegionalIndicator(next)) {
      let countBefore = 0, i = pos - 2;
      while (i >= 0 && isRegionalIndicator(codePointAt$1(str, i))) {
        countBefore++;
        i -= 2;
      }
      if (countBefore % 2 == 0) break;
      else pos += 2;
    } else {
      break;
    }
  }
  return pos;
}
function prevClusterBreak(str, pos, includeExtending) {
  while (pos > 0) {
    let found = nextClusterBreak(str, pos - 2, includeExtending);
    if (found < pos) return found;
    pos--;
  }
  return 0;
}
function codePointAt$1(str, pos) {
  let code0 = str.charCodeAt(pos);
  if (!surrogateHigh$1(code0) || pos + 1 == str.length) return code0;
  let code1 = str.charCodeAt(pos + 1);
  if (!surrogateLow$1(code1)) return code0;
  return (code0 - 55296 << 10) + (code1 - 56320) + 65536;
}
function surrogateLow$1(ch) {
  return ch >= 56320 && ch < 57344;
}
function surrogateHigh$1(ch) {
  return ch >= 55296 && ch < 56320;
}
function codePointSize$1(code) {
  return code < 65536 ? 1 : 2;
}
let Text$1 = class Text2 {
  /**
  Get the line description around the given position.
  */
  lineAt(pos) {
    if (pos < 0 || pos > this.length)
      throw new RangeError(`Invalid position ${pos} in document of length ${this.length}`);
    return this.lineInner(pos, false, 1, 0);
  }
  /**
  Get the description for the given (1-based) line number.
  */
  line(n) {
    if (n < 1 || n > this.lines)
      throw new RangeError(`Invalid line number ${n} in ${this.lines}-line document`);
    return this.lineInner(n, true, 1, 0);
  }
  /**
  Replace a range of the text with the given content.
  */
  replace(from, to, text2) {
    [from, to] = clip(this, from, to);
    let parts = [];
    this.decompose(
      0,
      from,
      parts,
      2
      /* Open.To */
    );
    if (text2.length)
      text2.decompose(
        0,
        text2.length,
        parts,
        1 | 2
        /* Open.To */
      );
    this.decompose(
      to,
      this.length,
      parts,
      1
      /* Open.From */
    );
    return TextNode.from(parts, this.length - (to - from) + text2.length);
  }
  /**
  Append another document to this one.
  */
  append(other) {
    return this.replace(this.length, this.length, other);
  }
  /**
  Retrieve the text between the given points.
  */
  slice(from, to = this.length) {
    [from, to] = clip(this, from, to);
    let parts = [];
    this.decompose(from, to, parts, 0);
    return TextNode.from(parts, to - from);
  }
  /**
  Test whether this text is equal to another instance.
  */
  eq(other) {
    if (other == this)
      return true;
    if (other.length != this.length || other.lines != this.lines)
      return false;
    let start2 = this.scanIdentical(other, 1), end = this.length - this.scanIdentical(other, -1);
    let a = new RawTextCursor(this), b2 = new RawTextCursor(other);
    for (let skip = start2, pos = start2; ; ) {
      a.next(skip);
      b2.next(skip);
      skip = 0;
      if (a.lineBreak != b2.lineBreak || a.done != b2.done || a.value != b2.value)
        return false;
      pos += a.value.length;
      if (a.done || pos >= end)
        return true;
    }
  }
  /**
  Iterate over the text. When `dir` is `-1`, iteration happens
  from end to start. This will return lines and the breaks between
  them as separate strings.
  */
  iter(dir = 1) {
    return new RawTextCursor(this, dir);
  }
  /**
  Iterate over a range of the text. When `from` > `to`, the
  iterator will run in reverse.
  */
  iterRange(from, to = this.length) {
    return new PartialTextCursor(this, from, to);
  }
  /**
  Return a cursor that iterates over the given range of lines,
  _without_ returning the line breaks between, and yielding empty
  strings for empty lines.
  
  When `from` and `to` are given, they should be 1-based line numbers.
  */
  iterLines(from, to) {
    let inner;
    if (from == null) {
      inner = this.iter();
    } else {
      if (to == null)
        to = this.lines + 1;
      let start2 = this.line(from).from;
      inner = this.iterRange(start2, Math.max(start2, to == this.lines + 1 ? this.length : to <= 1 ? 0 : this.line(to - 1).to));
    }
    return new LineCursor(inner);
  }
  /**
  Return the document as a string, using newline characters to
  separate lines.
  */
  toString() {
    return this.sliceString(0);
  }
  /**
  Convert the document to an array of lines (which can be
  deserialized again via [`Text.of`](https://codemirror.net/6/docs/ref/#state.Text^of)).
  */
  toJSON() {
    let lines = [];
    this.flatten(lines);
    return lines;
  }
  /**
  @internal
  */
  constructor() {
  }
  /**
  Create a `Text` instance for the given array of lines.
  */
  static of(text2) {
    if (text2.length == 0)
      throw new RangeError("A document must have at least one line");
    if (text2.length == 1 && !text2[0])
      return Text2.empty;
    return text2.length <= 32 ? new TextLeaf(text2) : TextNode.from(TextLeaf.split(text2, []));
  }
};
class TextLeaf extends Text$1 {
  constructor(text2, length = textLength(text2)) {
    super();
    this.text = text2;
    this.length = length;
  }
  get lines() {
    return this.text.length;
  }
  get children() {
    return null;
  }
  lineInner(target, isLine, line, offset) {
    for (let i = 0; ; i++) {
      let string2 = this.text[i], end = offset + string2.length;
      if ((isLine ? line : end) >= target)
        return new Line(offset, end, line, string2);
      offset = end + 1;
      line++;
    }
  }
  decompose(from, to, target, open) {
    let text2 = from <= 0 && to >= this.length ? this : new TextLeaf(sliceText(this.text, from, to), Math.min(to, this.length) - Math.max(0, from));
    if (open & 1) {
      let prev = target.pop();
      let joined = appendText(text2.text, prev.text.slice(), 0, text2.length);
      if (joined.length <= 32) {
        target.push(new TextLeaf(joined, prev.length + text2.length));
      } else {
        let mid = joined.length >> 1;
        target.push(new TextLeaf(joined.slice(0, mid)), new TextLeaf(joined.slice(mid)));
      }
    } else {
      target.push(text2);
    }
  }
  replace(from, to, text2) {
    if (!(text2 instanceof TextLeaf))
      return super.replace(from, to, text2);
    [from, to] = clip(this, from, to);
    let lines = appendText(this.text, appendText(text2.text, sliceText(this.text, 0, from)), to);
    let newLen = this.length + text2.length - (to - from);
    if (lines.length <= 32)
      return new TextLeaf(lines, newLen);
    return TextNode.from(TextLeaf.split(lines, []), newLen);
  }
  sliceString(from, to = this.length, lineSep = "\n") {
    [from, to] = clip(this, from, to);
    let result = "";
    for (let pos = 0, i = 0; pos <= to && i < this.text.length; i++) {
      let line = this.text[i], end = pos + line.length;
      if (pos > from && i)
        result += lineSep;
      if (from < end && to > pos)
        result += line.slice(Math.max(0, from - pos), to - pos);
      pos = end + 1;
    }
    return result;
  }
  flatten(target) {
    for (let line of this.text)
      target.push(line);
  }
  scanIdentical() {
    return 0;
  }
  static split(text2, target) {
    let part = [], len = -1;
    for (let line of text2) {
      part.push(line);
      len += line.length + 1;
      if (part.length == 32) {
        target.push(new TextLeaf(part, len));
        part = [];
        len = -1;
      }
    }
    if (len > -1)
      target.push(new TextLeaf(part, len));
    return target;
  }
}
class TextNode extends Text$1 {
  constructor(children2, length) {
    super();
    this.children = children2;
    this.length = length;
    this.lines = 0;
    for (let child2 of children2)
      this.lines += child2.lines;
  }
  lineInner(target, isLine, line, offset) {
    for (let i = 0; ; i++) {
      let child2 = this.children[i], end = offset + child2.length, endLine = line + child2.lines - 1;
      if ((isLine ? endLine : end) >= target)
        return child2.lineInner(target, isLine, line, offset);
      offset = end + 1;
      line = endLine + 1;
    }
  }
  decompose(from, to, target, open) {
    for (let i = 0, pos = 0; pos <= to && i < this.children.length; i++) {
      let child2 = this.children[i], end = pos + child2.length;
      if (from <= end && to >= pos) {
        let childOpen = open & ((pos <= from ? 1 : 0) | (end >= to ? 2 : 0));
        if (pos >= from && end <= to && !childOpen)
          target.push(child2);
        else
          child2.decompose(from - pos, to - pos, target, childOpen);
      }
      pos = end + 1;
    }
  }
  replace(from, to, text2) {
    [from, to] = clip(this, from, to);
    if (text2.lines < this.lines)
      for (let i = 0, pos = 0; i < this.children.length; i++) {
        let child2 = this.children[i], end = pos + child2.length;
        if (from >= pos && to <= end) {
          let updated = child2.replace(from - pos, to - pos, text2);
          let totalLines = this.lines - child2.lines + updated.lines;
          if (updated.lines < totalLines >> 5 - 1 && updated.lines > totalLines >> 5 + 1) {
            let copy = this.children.slice();
            copy[i] = updated;
            return new TextNode(copy, this.length - (to - from) + text2.length);
          }
          return super.replace(pos, end, updated);
        }
        pos = end + 1;
      }
    return super.replace(from, to, text2);
  }
  sliceString(from, to = this.length, lineSep = "\n") {
    [from, to] = clip(this, from, to);
    let result = "";
    for (let i = 0, pos = 0; i < this.children.length && pos <= to; i++) {
      let child2 = this.children[i], end = pos + child2.length;
      if (pos > from && i)
        result += lineSep;
      if (from < end && to > pos)
        result += child2.sliceString(from - pos, to - pos, lineSep);
      pos = end + 1;
    }
    return result;
  }
  flatten(target) {
    for (let child2 of this.children)
      child2.flatten(target);
  }
  scanIdentical(other, dir) {
    if (!(other instanceof TextNode))
      return 0;
    let length = 0;
    let [iA, iB, eA, eB] = dir > 0 ? [0, 0, this.children.length, other.children.length] : [this.children.length - 1, other.children.length - 1, -1, -1];
    for (; ; iA += dir, iB += dir) {
      if (iA == eA || iB == eB)
        return length;
      let chA = this.children[iA], chB = other.children[iB];
      if (chA != chB)
        return length + chA.scanIdentical(chB, dir);
      length += chA.length + 1;
    }
  }
  static from(children2, length = children2.reduce((l, ch) => l + ch.length + 1, -1)) {
    let lines = 0;
    for (let ch of children2)
      lines += ch.lines;
    if (lines < 32) {
      let flat = [];
      for (let ch of children2)
        ch.flatten(flat);
      return new TextLeaf(flat, length);
    }
    let chunk = Math.max(
      32,
      lines >> 5
      /* Tree.BranchShift */
    ), maxChunk = chunk << 1, minChunk = chunk >> 1;
    let chunked = [], currentLines = 0, currentLen = -1, currentChunk = [];
    function add2(child2) {
      let last;
      if (child2.lines > maxChunk && child2 instanceof TextNode) {
        for (let node of child2.children)
          add2(node);
      } else if (child2.lines > minChunk && (currentLines > minChunk || !currentLines)) {
        flush();
        chunked.push(child2);
      } else if (child2 instanceof TextLeaf && currentLines && (last = currentChunk[currentChunk.length - 1]) instanceof TextLeaf && child2.lines + last.lines <= 32) {
        currentLines += child2.lines;
        currentLen += child2.length + 1;
        currentChunk[currentChunk.length - 1] = new TextLeaf(last.text.concat(child2.text), last.length + 1 + child2.length);
      } else {
        if (currentLines + child2.lines > chunk)
          flush();
        currentLines += child2.lines;
        currentLen += child2.length + 1;
        currentChunk.push(child2);
      }
    }
    function flush() {
      if (currentLines == 0)
        return;
      chunked.push(currentChunk.length == 1 ? currentChunk[0] : TextNode.from(currentChunk, currentLen));
      currentLen = -1;
      currentLines = currentChunk.length = 0;
    }
    for (let child2 of children2)
      add2(child2);
    flush();
    return chunked.length == 1 ? chunked[0] : new TextNode(chunked, length);
  }
}
Text$1.empty = /* @__PURE__ */ new TextLeaf([""], 0);
function textLength(text2) {
  let length = -1;
  for (let line of text2)
    length += line.length + 1;
  return length;
}
function appendText(text2, target, from = 0, to = 1e9) {
  for (let pos = 0, i = 0, first = true; i < text2.length && pos <= to; i++) {
    let line = text2[i], end = pos + line.length;
    if (end >= from) {
      if (end > to)
        line = line.slice(0, to - pos);
      if (pos < from)
        line = line.slice(from - pos);
      if (first) {
        target[target.length - 1] += line;
        first = false;
      } else
        target.push(line);
    }
    pos = end + 1;
  }
  return target;
}
function sliceText(text2, from, to) {
  return appendText(text2, [""], from, to);
}
class RawTextCursor {
  constructor(text2, dir = 1) {
    this.dir = dir;
    this.done = false;
    this.lineBreak = false;
    this.value = "";
    this.nodes = [text2];
    this.offsets = [dir > 0 ? 1 : (text2 instanceof TextLeaf ? text2.text.length : text2.children.length) << 1];
  }
  nextInner(skip, dir) {
    this.done = this.lineBreak = false;
    for (; ; ) {
      let last = this.nodes.length - 1;
      let top2 = this.nodes[last], offsetValue = this.offsets[last], offset = offsetValue >> 1;
      let size = top2 instanceof TextLeaf ? top2.text.length : top2.children.length;
      if (offset == (dir > 0 ? size : 0)) {
        if (last == 0) {
          this.done = true;
          this.value = "";
          return this;
        }
        if (dir > 0)
          this.offsets[last - 1]++;
        this.nodes.pop();
        this.offsets.pop();
      } else if ((offsetValue & 1) == (dir > 0 ? 0 : 1)) {
        this.offsets[last] += dir;
        if (skip == 0) {
          this.lineBreak = true;
          this.value = "\n";
          return this;
        }
        skip--;
      } else if (top2 instanceof TextLeaf) {
        let next = top2.text[offset + (dir < 0 ? -1 : 0)];
        this.offsets[last] += dir;
        if (next.length > Math.max(0, skip)) {
          this.value = skip == 0 ? next : dir > 0 ? next.slice(skip) : next.slice(0, next.length - skip);
          return this;
        }
        skip -= next.length;
      } else {
        let next = top2.children[offset + (dir < 0 ? -1 : 0)];
        if (skip > next.length) {
          skip -= next.length;
          this.offsets[last] += dir;
        } else {
          if (dir < 0)
            this.offsets[last]--;
          this.nodes.push(next);
          this.offsets.push(dir > 0 ? 1 : (next instanceof TextLeaf ? next.text.length : next.children.length) << 1);
        }
      }
    }
  }
  next(skip = 0) {
    if (skip < 0) {
      this.nextInner(-skip, -this.dir);
      skip = this.value.length;
    }
    return this.nextInner(skip, this.dir);
  }
}
class PartialTextCursor {
  constructor(text2, start2, end) {
    this.value = "";
    this.done = false;
    this.cursor = new RawTextCursor(text2, start2 > end ? -1 : 1);
    this.pos = start2 > end ? text2.length : 0;
    this.from = Math.min(start2, end);
    this.to = Math.max(start2, end);
  }
  nextInner(skip, dir) {
    if (dir < 0 ? this.pos <= this.from : this.pos >= this.to) {
      this.value = "";
      this.done = true;
      return this;
    }
    skip += Math.max(0, dir < 0 ? this.pos - this.to : this.from - this.pos);
    let limit = dir < 0 ? this.pos - this.from : this.to - this.pos;
    if (skip > limit)
      skip = limit;
    limit -= skip;
    let { value } = this.cursor.next(skip);
    this.pos += (value.length + skip) * dir;
    this.value = value.length <= limit ? value : dir < 0 ? value.slice(value.length - limit) : value.slice(0, limit);
    this.done = !this.value;
    return this;
  }
  next(skip = 0) {
    if (skip < 0)
      skip = Math.max(skip, this.from - this.pos);
    else if (skip > 0)
      skip = Math.min(skip, this.to - this.pos);
    return this.nextInner(skip, this.cursor.dir);
  }
  get lineBreak() {
    return this.cursor.lineBreak && this.value != "";
  }
}
class LineCursor {
  constructor(inner) {
    this.inner = inner;
    this.afterBreak = true;
    this.value = "";
    this.done = false;
  }
  next(skip = 0) {
    let { done, lineBreak, value } = this.inner.next(skip);
    if (done && this.afterBreak) {
      this.value = "";
      this.afterBreak = false;
    } else if (done) {
      this.done = true;
      this.value = "";
    } else if (lineBreak) {
      if (this.afterBreak) {
        this.value = "";
      } else {
        this.afterBreak = true;
        this.next();
      }
    } else {
      this.value = value;
      this.afterBreak = false;
    }
    return this;
  }
  get lineBreak() {
    return false;
  }
}
if (typeof Symbol != "undefined") {
  Text$1.prototype[Symbol.iterator] = function() {
    return this.iter();
  };
  RawTextCursor.prototype[Symbol.iterator] = PartialTextCursor.prototype[Symbol.iterator] = LineCursor.prototype[Symbol.iterator] = function() {
    return this;
  };
}
class Line {
  /**
  @internal
  */
  constructor(from, to, number2, text2) {
    this.from = from;
    this.to = to;
    this.number = number2;
    this.text = text2;
  }
  /**
  The length of the line (not including any line break after it).
  */
  get length() {
    return this.to - this.from;
  }
}
function clip(text2, from, to) {
  from = Math.max(0, Math.min(text2.length, from));
  return [from, Math.max(from, Math.min(text2.length, to))];
}
function findClusterBreak(str, pos, forward = true, includeExtending = true) {
  return findClusterBreak$1(str, pos, forward, includeExtending);
}
function surrogateLow(ch) {
  return ch >= 56320 && ch < 57344;
}
function surrogateHigh(ch) {
  return ch >= 55296 && ch < 56320;
}
function codePointAt(str, pos) {
  let code0 = str.charCodeAt(pos);
  if (!surrogateHigh(code0) || pos + 1 == str.length)
    return code0;
  let code1 = str.charCodeAt(pos + 1);
  if (!surrogateLow(code1))
    return code0;
  return (code0 - 55296 << 10) + (code1 - 56320) + 65536;
}
function codePointSize(code) {
  return code < 65536 ? 1 : 2;
}
const DefaultSplit = /\r\n?|\n/;
var MapMode = /* @__PURE__ */ (function(MapMode2) {
  MapMode2[MapMode2["Simple"] = 0] = "Simple";
  MapMode2[MapMode2["TrackDel"] = 1] = "TrackDel";
  MapMode2[MapMode2["TrackBefore"] = 2] = "TrackBefore";
  MapMode2[MapMode2["TrackAfter"] = 3] = "TrackAfter";
  return MapMode2;
})(MapMode || (MapMode = {}));
class ChangeDesc {
  // Sections are encoded as pairs of integers. The first is the
  // length in the current document, and the second is -1 for
  // unaffected sections, and the length of the replacement content
  // otherwise. So an insertion would be (0, n>0), a deletion (n>0,
  // 0), and a replacement two positive numbers.
  /**
  @internal
  */
  constructor(sections) {
    this.sections = sections;
  }
  /**
  The length of the document before the change.
  */
  get length() {
    let result = 0;
    for (let i = 0; i < this.sections.length; i += 2)
      result += this.sections[i];
    return result;
  }
  /**
  The length of the document after the change.
  */
  get newLength() {
    let result = 0;
    for (let i = 0; i < this.sections.length; i += 2) {
      let ins = this.sections[i + 1];
      result += ins < 0 ? this.sections[i] : ins;
    }
    return result;
  }
  /**
  False when there are actual changes in this set.
  */
  get empty() {
    return this.sections.length == 0 || this.sections.length == 2 && this.sections[1] < 0;
  }
  /**
  Iterate over the unchanged parts left by these changes. `posA`
  provides the position of the range in the old document, `posB`
  the new position in the changed document.
  */
  iterGaps(f) {
    for (let i = 0, posA = 0, posB = 0; i < this.sections.length; ) {
      let len = this.sections[i++], ins = this.sections[i++];
      if (ins < 0) {
        f(posA, posB, len);
        posB += len;
      } else {
        posB += ins;
      }
      posA += len;
    }
  }
  /**
  Iterate over the ranges changed by these changes. (See
  [`ChangeSet.iterChanges`](https://codemirror.net/6/docs/ref/#state.ChangeSet.iterChanges) for a
  variant that also provides you with the inserted text.)
  `fromA`/`toA` provides the extent of the change in the starting
  document, `fromB`/`toB` the extent of the replacement in the
  changed document.
  
  When `individual` is true, adjacent changes (which are kept
  separate for [position mapping](https://codemirror.net/6/docs/ref/#state.ChangeDesc.mapPos)) are
  reported separately.
  */
  iterChangedRanges(f, individual = false) {
    iterChanges(this, f, individual);
  }
  /**
  Get a description of the inverted form of these changes.
  */
  get invertedDesc() {
    let sections = [];
    for (let i = 0; i < this.sections.length; ) {
      let len = this.sections[i++], ins = this.sections[i++];
      if (ins < 0)
        sections.push(len, ins);
      else
        sections.push(ins, len);
    }
    return new ChangeDesc(sections);
  }
  /**
  Compute the combined effect of applying another set of changes
  after this one. The length of the document after this set should
  match the length before `other`.
  */
  composeDesc(other) {
    return this.empty ? other : other.empty ? this : composeSets(this, other);
  }
  /**
  Map this description, which should start with the same document
  as `other`, over another set of changes, so that it can be
  applied after it. When `before` is true, map as if the changes
  in `this` happened before the ones in `other`.
  */
  mapDesc(other, before = false) {
    return other.empty ? this : mapSet(this, other, before);
  }
  mapPos(pos, assoc = -1, mode = MapMode.Simple) {
    let posA = 0, posB = 0;
    for (let i = 0; i < this.sections.length; ) {
      let len = this.sections[i++], ins = this.sections[i++], endA = posA + len;
      if (ins < 0) {
        if (endA > pos)
          return posB + (pos - posA);
        posB += len;
      } else {
        if (mode != MapMode.Simple && endA >= pos && (mode == MapMode.TrackDel && posA < pos && endA > pos || mode == MapMode.TrackBefore && posA < pos || mode == MapMode.TrackAfter && endA > pos))
          return null;
        if (endA > pos || endA == pos && assoc < 0 && !len)
          return pos == posA || assoc < 0 ? posB : posB + ins;
        posB += ins;
      }
      posA = endA;
    }
    if (pos > posA)
      throw new RangeError(`Position ${pos} is out of range for changeset of length ${posA}`);
    return posB;
  }
  /**
  Check whether these changes touch a given range. When one of the
  changes entirely covers the range, the string `"cover"` is
  returned.
  */
  touchesRange(from, to = from) {
    for (let i = 0, pos = 0; i < this.sections.length && pos <= to; ) {
      let len = this.sections[i++], ins = this.sections[i++], end = pos + len;
      if (ins >= 0 && pos <= to && end >= from)
        return pos < from && end > to ? "cover" : true;
      pos = end;
    }
    return false;
  }
  /**
  @internal
  */
  toString() {
    let result = "";
    for (let i = 0; i < this.sections.length; ) {
      let len = this.sections[i++], ins = this.sections[i++];
      result += (result ? " " : "") + len + (ins >= 0 ? ":" + ins : "");
    }
    return result;
  }
  /**
  Serialize this change desc to a JSON-representable value.
  */
  toJSON() {
    return this.sections;
  }
  /**
  Create a change desc from its JSON representation (as produced
  by [`toJSON`](https://codemirror.net/6/docs/ref/#state.ChangeDesc.toJSON).
  */
  static fromJSON(json2) {
    if (!Array.isArray(json2) || json2.length % 2 || json2.some((a) => typeof a != "number"))
      throw new RangeError("Invalid JSON representation of ChangeDesc");
    return new ChangeDesc(json2);
  }
  /**
  @internal
  */
  static create(sections) {
    return new ChangeDesc(sections);
  }
}
class ChangeSet extends ChangeDesc {
  constructor(sections, inserted) {
    super(sections);
    this.inserted = inserted;
  }
  /**
  Apply the changes to a document, returning the modified
  document.
  */
  apply(doc2) {
    if (this.length != doc2.length)
      throw new RangeError("Applying change set to a document with the wrong length");
    iterChanges(this, (fromA, toA, fromB, _toB, text2) => doc2 = doc2.replace(fromB, fromB + (toA - fromA), text2), false);
    return doc2;
  }
  mapDesc(other, before = false) {
    return mapSet(this, other, before, true);
  }
  /**
  Given the document as it existed _before_ the changes, return a
  change set that represents the inverse of this set, which could
  be used to go from the document created by the changes back to
  the document as it existed before the changes.
  */
  invert(doc2) {
    let sections = this.sections.slice(), inserted = [];
    for (let i = 0, pos = 0; i < sections.length; i += 2) {
      let len = sections[i], ins = sections[i + 1];
      if (ins >= 0) {
        sections[i] = ins;
        sections[i + 1] = len;
        let index2 = i >> 1;
        while (inserted.length < index2)
          inserted.push(Text$1.empty);
        inserted.push(len ? doc2.slice(pos, pos + len) : Text$1.empty);
      }
      pos += len;
    }
    return new ChangeSet(sections, inserted);
  }
  /**
  Combine two subsequent change sets into a single set. `other`
  must start in the document produced by `this`. If `this` goes
  `docA` → `docB` and `other` represents `docB` → `docC`, the
  returned value will represent the change `docA` → `docC`.
  */
  compose(other) {
    return this.empty ? other : other.empty ? this : composeSets(this, other, true);
  }
  /**
  Given another change set starting in the same document, maps this
  change set over the other, producing a new change set that can be
  applied to the document produced by applying `other`. When
  `before` is `true`, order changes as if `this` comes before
  `other`, otherwise (the default) treat `other` as coming first.
  
  Given two changes `A` and `B`, `A.compose(B.map(A))` and
  `B.compose(A.map(B, true))` will produce the same document. This
  provides a basic form of [operational
  transformation](https://en.wikipedia.org/wiki/Operational_transformation),
  and can be used for collaborative editing.
  */
  map(other, before = false) {
    return other.empty ? this : mapSet(this, other, before, true);
  }
  /**
  Iterate over the changed ranges in the document, calling `f` for
  each, with the range in the original document (`fromA`-`toA`)
  and the range that replaces it in the new document
  (`fromB`-`toB`).
  
  When `individual` is true, adjacent changes are reported
  separately.
  */
  iterChanges(f, individual = false) {
    iterChanges(this, f, individual);
  }
  /**
  Get a [change description](https://codemirror.net/6/docs/ref/#state.ChangeDesc) for this change
  set.
  */
  get desc() {
    return ChangeDesc.create(this.sections);
  }
  /**
  @internal
  */
  filter(ranges) {
    let resultSections = [], resultInserted = [], filteredSections = [];
    let iter = new SectionIter(this);
    done: for (let i = 0, pos = 0; ; ) {
      let next = i == ranges.length ? 1e9 : ranges[i++];
      while (pos < next || pos == next && iter.len == 0) {
        if (iter.done)
          break done;
        let len = Math.min(iter.len, next - pos);
        addSection(filteredSections, len, -1);
        let ins = iter.ins == -1 ? -1 : iter.off == 0 ? iter.ins : 0;
        addSection(resultSections, len, ins);
        if (ins > 0)
          addInsert(resultInserted, resultSections, iter.text);
        iter.forward(len);
        pos += len;
      }
      let end = ranges[i++];
      while (pos < end) {
        if (iter.done)
          break done;
        let len = Math.min(iter.len, end - pos);
        addSection(resultSections, len, -1);
        addSection(filteredSections, len, iter.ins == -1 ? -1 : iter.off == 0 ? iter.ins : 0);
        iter.forward(len);
        pos += len;
      }
    }
    return {
      changes: new ChangeSet(resultSections, resultInserted),
      filtered: ChangeDesc.create(filteredSections)
    };
  }
  /**
  Serialize this change set to a JSON-representable value.
  */
  toJSON() {
    let parts = [];
    for (let i = 0; i < this.sections.length; i += 2) {
      let len = this.sections[i], ins = this.sections[i + 1];
      if (ins < 0)
        parts.push(len);
      else if (ins == 0)
        parts.push([len]);
      else
        parts.push([len].concat(this.inserted[i >> 1].toJSON()));
    }
    return parts;
  }
  /**
  Create a change set for the given changes, for a document of the
  given length, using `lineSep` as line separator.
  */
  static of(changes, length, lineSep) {
    let sections = [], inserted = [], pos = 0;
    let total = null;
    function flush(force = false) {
      if (!force && !sections.length)
        return;
      if (pos < length)
        addSection(sections, length - pos, -1);
      let set2 = new ChangeSet(sections, inserted);
      total = total ? total.compose(set2.map(total)) : set2;
      sections = [];
      inserted = [];
      pos = 0;
    }
    function process2(spec) {
      if (Array.isArray(spec)) {
        for (let sub of spec)
          process2(sub);
      } else if (spec instanceof ChangeSet) {
        if (spec.length != length)
          throw new RangeError(`Mismatched change set length (got ${spec.length}, expected ${length})`);
        flush();
        total = total ? total.compose(spec.map(total)) : spec;
      } else {
        let { from, to = from, insert: insert2 } = spec;
        if (from > to || from < 0 || to > length)
          throw new RangeError(`Invalid change range ${from} to ${to} (in doc of length ${length})`);
        let insText = !insert2 ? Text$1.empty : typeof insert2 == "string" ? Text$1.of(insert2.split(lineSep || DefaultSplit)) : insert2;
        let insLen = insText.length;
        if (from == to && insLen == 0)
          return;
        if (from < pos)
          flush();
        if (from > pos)
          addSection(sections, from - pos, -1);
        addSection(sections, to - from, insLen);
        addInsert(inserted, sections, insText);
        pos = to;
      }
    }
    process2(changes);
    flush(!total);
    return total;
  }
  /**
  Create an empty changeset of the given length.
  */
  static empty(length) {
    return new ChangeSet(length ? [length, -1] : [], []);
  }
  /**
  Create a changeset from its JSON representation (as produced by
  [`toJSON`](https://codemirror.net/6/docs/ref/#state.ChangeSet.toJSON).
  */
  static fromJSON(json2) {
    if (!Array.isArray(json2))
      throw new RangeError("Invalid JSON representation of ChangeSet");
    let sections = [], inserted = [];
    for (let i = 0; i < json2.length; i++) {
      let part = json2[i];
      if (typeof part == "number") {
        sections.push(part, -1);
      } else if (!Array.isArray(part) || typeof part[0] != "number" || part.some((e, i2) => i2 && typeof e != "string")) {
        throw new RangeError("Invalid JSON representation of ChangeSet");
      } else if (part.length == 1) {
        sections.push(part[0], 0);
      } else {
        while (inserted.length < i)
          inserted.push(Text$1.empty);
        inserted[i] = Text$1.of(part.slice(1));
        sections.push(part[0], inserted[i].length);
      }
    }
    return new ChangeSet(sections, inserted);
  }
  /**
  @internal
  */
  static createSet(sections, inserted) {
    return new ChangeSet(sections, inserted);
  }
}
function addSection(sections, len, ins, forceJoin = false) {
  if (len == 0 && ins <= 0)
    return;
  let last = sections.length - 2;
  if (last >= 0 && ins <= 0 && ins == sections[last + 1])
    sections[last] += len;
  else if (last >= 0 && len == 0 && sections[last] == 0)
    sections[last + 1] += ins;
  else if (forceJoin) {
    sections[last] += len;
    sections[last + 1] += ins;
  } else
    sections.push(len, ins);
}
function addInsert(values, sections, value) {
  if (value.length == 0)
    return;
  let index2 = sections.length - 2 >> 1;
  if (index2 < values.length) {
    values[values.length - 1] = values[values.length - 1].append(value);
  } else {
    while (values.length < index2)
      values.push(Text$1.empty);
    values.push(value);
  }
}
function iterChanges(desc, f, individual) {
  let inserted = desc.inserted;
  for (let posA = 0, posB = 0, i = 0; i < desc.sections.length; ) {
    let len = desc.sections[i++], ins = desc.sections[i++];
    if (ins < 0) {
      posA += len;
      posB += len;
    } else {
      let endA = posA, endB = posB, text2 = Text$1.empty;
      for (; ; ) {
        endA += len;
        endB += ins;
        if (ins && inserted)
          text2 = text2.append(inserted[i - 2 >> 1]);
        if (individual || i == desc.sections.length || desc.sections[i + 1] < 0)
          break;
        len = desc.sections[i++];
        ins = desc.sections[i++];
      }
      f(posA, endA, posB, endB, text2);
      posA = endA;
      posB = endB;
    }
  }
}
function mapSet(setA, setB, before, mkSet = false) {
  let sections = [], insert2 = mkSet ? [] : null;
  let a = new SectionIter(setA), b2 = new SectionIter(setB);
  for (let inserted = -1; ; ) {
    if (a.done && b2.len || b2.done && a.len) {
      throw new Error("Mismatched change set lengths");
    } else if (a.ins == -1 && b2.ins == -1) {
      let len = Math.min(a.len, b2.len);
      addSection(sections, len, -1);
      a.forward(len);
      b2.forward(len);
    } else if (b2.ins >= 0 && (a.ins < 0 || inserted == a.i || a.off == 0 && (b2.len < a.len || b2.len == a.len && !before))) {
      let len = b2.len;
      addSection(sections, b2.ins, -1);
      while (len) {
        let piece = Math.min(a.len, len);
        if (a.ins >= 0 && inserted < a.i && a.len <= piece) {
          addSection(sections, 0, a.ins);
          if (insert2)
            addInsert(insert2, sections, a.text);
          inserted = a.i;
        }
        a.forward(piece);
        len -= piece;
      }
      b2.next();
    } else if (a.ins >= 0) {
      let len = 0, left = a.len;
      while (left) {
        if (b2.ins == -1) {
          let piece = Math.min(left, b2.len);
          len += piece;
          left -= piece;
          b2.forward(piece);
        } else if (b2.ins == 0 && b2.len < left) {
          left -= b2.len;
          b2.next();
        } else {
          break;
        }
      }
      addSection(sections, len, inserted < a.i ? a.ins : 0);
      if (insert2 && inserted < a.i)
        addInsert(insert2, sections, a.text);
      inserted = a.i;
      a.forward(a.len - left);
    } else if (a.done && b2.done) {
      return insert2 ? ChangeSet.createSet(sections, insert2) : ChangeDesc.create(sections);
    } else {
      throw new Error("Mismatched change set lengths");
    }
  }
}
function composeSets(setA, setB, mkSet = false) {
  let sections = [];
  let insert2 = mkSet ? [] : null;
  let a = new SectionIter(setA), b2 = new SectionIter(setB);
  for (let open = false; ; ) {
    if (a.done && b2.done) {
      return insert2 ? ChangeSet.createSet(sections, insert2) : ChangeDesc.create(sections);
    } else if (a.ins == 0) {
      addSection(sections, a.len, 0, open);
      a.next();
    } else if (b2.len == 0 && !b2.done) {
      addSection(sections, 0, b2.ins, open);
      if (insert2)
        addInsert(insert2, sections, b2.text);
      b2.next();
    } else if (a.done || b2.done) {
      throw new Error("Mismatched change set lengths");
    } else {
      let len = Math.min(a.len2, b2.len), sectionLen = sections.length;
      if (a.ins == -1) {
        let insB = b2.ins == -1 ? -1 : b2.off ? 0 : b2.ins;
        addSection(sections, len, insB, open);
        if (insert2 && insB)
          addInsert(insert2, sections, b2.text);
      } else if (b2.ins == -1) {
        addSection(sections, a.off ? 0 : a.len, len, open);
        if (insert2)
          addInsert(insert2, sections, a.textBit(len));
      } else {
        addSection(sections, a.off ? 0 : a.len, b2.off ? 0 : b2.ins, open);
        if (insert2 && !b2.off)
          addInsert(insert2, sections, b2.text);
      }
      open = (a.ins > len || b2.ins >= 0 && b2.len > len) && (open || sections.length > sectionLen);
      a.forward2(len);
      b2.forward(len);
    }
  }
}
class SectionIter {
  constructor(set2) {
    this.set = set2;
    this.i = 0;
    this.next();
  }
  next() {
    let { sections } = this.set;
    if (this.i < sections.length) {
      this.len = sections[this.i++];
      this.ins = sections[this.i++];
    } else {
      this.len = 0;
      this.ins = -2;
    }
    this.off = 0;
  }
  get done() {
    return this.ins == -2;
  }
  get len2() {
    return this.ins < 0 ? this.len : this.ins;
  }
  get text() {
    let { inserted } = this.set, index2 = this.i - 2 >> 1;
    return index2 >= inserted.length ? Text$1.empty : inserted[index2];
  }
  textBit(len) {
    let { inserted } = this.set, index2 = this.i - 2 >> 1;
    return index2 >= inserted.length && !len ? Text$1.empty : inserted[index2].slice(this.off, len == null ? void 0 : this.off + len);
  }
  forward(len) {
    if (len == this.len)
      this.next();
    else {
      this.len -= len;
      this.off += len;
    }
  }
  forward2(len) {
    if (this.ins == -1)
      this.forward(len);
    else if (len == this.ins)
      this.next();
    else {
      this.ins -= len;
      this.off += len;
    }
  }
}
class SelectionRange {
  constructor(from, to, flags2) {
    this.from = from;
    this.to = to;
    this.flags = flags2;
  }
  /**
  The anchor of the range—the side that doesn't move when you
  extend it.
  */
  get anchor() {
    return this.flags & 32 ? this.to : this.from;
  }
  /**
  The head of the range, which is moved when the range is
  [extended](https://codemirror.net/6/docs/ref/#state.SelectionRange.extend).
  */
  get head() {
    return this.flags & 32 ? this.from : this.to;
  }
  /**
  True when `anchor` and `head` are at the same position.
  */
  get empty() {
    return this.from == this.to;
  }
  /**
  If this is a cursor that is explicitly associated with the
  character on one of its sides, this returns the side. -1 means
  the character before its position, 1 the character after, and 0
  means no association.
  */
  get assoc() {
    return this.flags & 8 ? -1 : this.flags & 16 ? 1 : 0;
  }
  /**
  The bidirectional text level associated with this cursor, if
  any.
  */
  get bidiLevel() {
    let level = this.flags & 7;
    return level == 7 ? null : level;
  }
  /**
  The goal column (stored vertical offset) associated with a
  cursor. This is used to preserve the vertical position when
  [moving](https://codemirror.net/6/docs/ref/#view.EditorView.moveVertically) across
  lines of different length.
  */
  get goalColumn() {
    let value = this.flags >> 6;
    return value == 16777215 ? void 0 : value;
  }
  /**
  Map this range through a change, producing a valid range in the
  updated document.
  */
  map(change, assoc = -1) {
    let from, to;
    if (this.empty) {
      from = to = change.mapPos(this.from, assoc);
    } else {
      from = change.mapPos(this.from, 1);
      to = change.mapPos(this.to, -1);
    }
    return from == this.from && to == this.to ? this : new SelectionRange(from, to, this.flags);
  }
  /**
  Extend this range to cover at least `from` to `to`.
  */
  extend(from, to = from) {
    if (from <= this.anchor && to >= this.anchor)
      return EditorSelection.range(from, to);
    let head2 = Math.abs(from - this.anchor) > Math.abs(to - this.anchor) ? from : to;
    return EditorSelection.range(this.anchor, head2);
  }
  /**
  Compare this range to another range.
  */
  eq(other, includeAssoc = false) {
    return this.anchor == other.anchor && this.head == other.head && (!includeAssoc || !this.empty || this.assoc == other.assoc);
  }
  /**
  Return a JSON-serializable object representing the range.
  */
  toJSON() {
    return { anchor: this.anchor, head: this.head };
  }
  /**
  Convert a JSON representation of a range to a `SelectionRange`
  instance.
  */
  static fromJSON(json2) {
    if (!json2 || typeof json2.anchor != "number" || typeof json2.head != "number")
      throw new RangeError("Invalid JSON representation for SelectionRange");
    return EditorSelection.range(json2.anchor, json2.head);
  }
  /**
  @internal
  */
  static create(from, to, flags2) {
    return new SelectionRange(from, to, flags2);
  }
}
class EditorSelection {
  constructor(ranges, mainIndex) {
    this.ranges = ranges;
    this.mainIndex = mainIndex;
  }
  /**
  Map a selection through a change. Used to adjust the selection
  position for changes.
  */
  map(change, assoc = -1) {
    if (change.empty)
      return this;
    return EditorSelection.create(this.ranges.map((r2) => r2.map(change, assoc)), this.mainIndex);
  }
  /**
  Compare this selection to another selection. By default, ranges
  are compared only by position. When `includeAssoc` is true,
  cursor ranges must also have the same
  [`assoc`](https://codemirror.net/6/docs/ref/#state.SelectionRange.assoc) value.
  */
  eq(other, includeAssoc = false) {
    if (this.ranges.length != other.ranges.length || this.mainIndex != other.mainIndex)
      return false;
    for (let i = 0; i < this.ranges.length; i++)
      if (!this.ranges[i].eq(other.ranges[i], includeAssoc))
        return false;
    return true;
  }
  /**
  Get the primary selection range. Usually, you should make sure
  your code applies to _all_ ranges, by using methods like
  [`changeByRange`](https://codemirror.net/6/docs/ref/#state.EditorState.changeByRange).
  */
  get main() {
    return this.ranges[this.mainIndex];
  }
  /**
  Make sure the selection only has one range. Returns a selection
  holding only the main range from this selection.
  */
  asSingle() {
    return this.ranges.length == 1 ? this : new EditorSelection([this.main], 0);
  }
  /**
  Extend this selection with an extra range.
  */
  addRange(range, main = true) {
    return EditorSelection.create([range].concat(this.ranges), main ? 0 : this.mainIndex + 1);
  }
  /**
  Replace a given range with another range, and then normalize the
  selection to merge and sort ranges if necessary.
  */
  replaceRange(range, which = this.mainIndex) {
    let ranges = this.ranges.slice();
    ranges[which] = range;
    return EditorSelection.create(ranges, this.mainIndex);
  }
  /**
  Convert this selection to an object that can be serialized to
  JSON.
  */
  toJSON() {
    return { ranges: this.ranges.map((r2) => r2.toJSON()), main: this.mainIndex };
  }
  /**
  Create a selection from a JSON representation.
  */
  static fromJSON(json2) {
    if (!json2 || !Array.isArray(json2.ranges) || typeof json2.main != "number" || json2.main >= json2.ranges.length)
      throw new RangeError("Invalid JSON representation for EditorSelection");
    return new EditorSelection(json2.ranges.map((r2) => SelectionRange.fromJSON(r2)), json2.main);
  }
  /**
  Create a selection holding a single range.
  */
  static single(anchor, head2 = anchor) {
    return new EditorSelection([EditorSelection.range(anchor, head2)], 0);
  }
  /**
  Sort and merge the given set of ranges, creating a valid
  selection.
  */
  static create(ranges, mainIndex = 0) {
    if (ranges.length == 0)
      throw new RangeError("A selection needs at least one range");
    for (let pos = 0, i = 0; i < ranges.length; i++) {
      let range = ranges[i];
      if (range.empty ? range.from <= pos : range.from < pos)
        return EditorSelection.normalized(ranges.slice(), mainIndex);
      pos = range.to;
    }
    return new EditorSelection(ranges, mainIndex);
  }
  /**
  Create a cursor selection range at the given position. You can
  safely ignore the optional arguments in most situations.
  */
  static cursor(pos, assoc = 0, bidiLevel, goalColumn) {
    return SelectionRange.create(pos, pos, (assoc == 0 ? 0 : assoc < 0 ? 8 : 16) | (bidiLevel == null ? 7 : Math.min(6, bidiLevel)) | (goalColumn !== null && goalColumn !== void 0 ? goalColumn : 16777215) << 6);
  }
  /**
  Create a selection range.
  */
  static range(anchor, head2, goalColumn, bidiLevel) {
    let flags2 = (goalColumn !== null && goalColumn !== void 0 ? goalColumn : 16777215) << 6 | (bidiLevel == null ? 7 : Math.min(6, bidiLevel));
    return head2 < anchor ? SelectionRange.create(head2, anchor, 32 | 16 | flags2) : SelectionRange.create(anchor, head2, (head2 > anchor ? 8 : 0) | flags2);
  }
  /**
  @internal
  */
  static normalized(ranges, mainIndex = 0) {
    let main = ranges[mainIndex];
    ranges.sort((a, b2) => a.from - b2.from);
    mainIndex = ranges.indexOf(main);
    for (let i = 1; i < ranges.length; i++) {
      let range = ranges[i], prev = ranges[i - 1];
      if (range.empty ? range.from <= prev.to : range.from < prev.to) {
        let from = prev.from, to = Math.max(range.to, prev.to);
        if (i <= mainIndex)
          mainIndex--;
        ranges.splice(--i, 2, range.anchor > range.head ? EditorSelection.range(to, from) : EditorSelection.range(from, to));
      }
    }
    return new EditorSelection(ranges, mainIndex);
  }
}
function checkSelection(selection2, docLength) {
  for (let range of selection2.ranges)
    if (range.to > docLength)
      throw new RangeError("Selection points outside of document");
}
let nextID = 0;
class Facet {
  constructor(combine, compareInput, compare2, isStatic, enables) {
    this.combine = combine;
    this.compareInput = compareInput;
    this.compare = compare2;
    this.isStatic = isStatic;
    this.id = nextID++;
    this.default = combine([]);
    this.extensions = typeof enables == "function" ? enables(this) : enables;
  }
  /**
  Returns a facet reader for this facet, which can be used to
  [read](https://codemirror.net/6/docs/ref/#state.EditorState.facet) it but not to define values for it.
  */
  get reader() {
    return this;
  }
  /**
  Define a new facet.
  */
  static define(config = {}) {
    return new Facet(config.combine || ((a) => a), config.compareInput || ((a, b2) => a === b2), config.compare || (!config.combine ? sameArray$1 : (a, b2) => a === b2), !!config.static, config.enables);
  }
  /**
  Returns an extension that adds the given value to this facet.
  */
  of(value) {
    return new FacetProvider([], this, 0, value);
  }
  /**
  Create an extension that computes a value for the facet from a
  state. You must take care to declare the parts of the state that
  this value depends on, since your function is only called again
  for a new state when one of those parts changed.
  
  In cases where your value depends only on a single field, you'll
  want to use the [`from`](https://codemirror.net/6/docs/ref/#state.Facet.from) method instead.
  */
  compute(deps, get2) {
    if (this.isStatic)
      throw new Error("Can't compute a static facet");
    return new FacetProvider(deps, this, 1, get2);
  }
  /**
  Create an extension that computes zero or more values for this
  facet from a state.
  */
  computeN(deps, get2) {
    if (this.isStatic)
      throw new Error("Can't compute a static facet");
    return new FacetProvider(deps, this, 2, get2);
  }
  from(field, get2) {
    if (!get2)
      get2 = (x2) => x2;
    return this.compute([field], (state2) => get2(state2.field(field)));
  }
}
function sameArray$1(a, b2) {
  return a == b2 || a.length == b2.length && a.every((e, i) => e === b2[i]);
}
class FacetProvider {
  constructor(dependencies, facet, type, value) {
    this.dependencies = dependencies;
    this.facet = facet;
    this.type = type;
    this.value = value;
    this.id = nextID++;
  }
  dynamicSlot(addresses) {
    var _a3;
    let getter = this.value;
    let compare2 = this.facet.compareInput;
    let id2 = this.id, idx = addresses[id2] >> 1, multi = this.type == 2;
    let depDoc = false, depSel = false, depAddrs = [];
    for (let dep of this.dependencies) {
      if (dep == "doc")
        depDoc = true;
      else if (dep == "selection")
        depSel = true;
      else if ((((_a3 = addresses[dep.id]) !== null && _a3 !== void 0 ? _a3 : 1) & 1) == 0)
        depAddrs.push(addresses[dep.id]);
    }
    return {
      create(state2) {
        state2.values[idx] = getter(state2);
        return 1;
      },
      update(state2, tr) {
        if (depDoc && tr.docChanged || depSel && (tr.docChanged || tr.selection) || ensureAll(state2, depAddrs)) {
          let newVal = getter(state2);
          if (multi ? !compareArray(newVal, state2.values[idx], compare2) : !compare2(newVal, state2.values[idx])) {
            state2.values[idx] = newVal;
            return 1;
          }
        }
        return 0;
      },
      reconfigure: (state2, oldState) => {
        let newVal, oldAddr = oldState.config.address[id2];
        if (oldAddr != null) {
          let oldVal = getAddr(oldState, oldAddr);
          if (this.dependencies.every((dep) => {
            return dep instanceof Facet ? oldState.facet(dep) === state2.facet(dep) : dep instanceof StateField ? oldState.field(dep, false) == state2.field(dep, false) : true;
          }) || (multi ? compareArray(newVal = getter(state2), oldVal, compare2) : compare2(newVal = getter(state2), oldVal))) {
            state2.values[idx] = oldVal;
            return 0;
          }
        } else {
          newVal = getter(state2);
        }
        state2.values[idx] = newVal;
        return 1;
      }
    };
  }
}
function compareArray(a, b2, compare2) {
  if (a.length != b2.length)
    return false;
  for (let i = 0; i < a.length; i++)
    if (!compare2(a[i], b2[i]))
      return false;
  return true;
}
function ensureAll(state2, addrs) {
  let changed = false;
  for (let addr of addrs)
    if (ensureAddr(state2, addr) & 1)
      changed = true;
  return changed;
}
function dynamicFacetSlot(addresses, facet, providers) {
  let providerAddrs = providers.map((p) => addresses[p.id]);
  let providerTypes = providers.map((p) => p.type);
  let dynamic = providerAddrs.filter((p) => !(p & 1));
  let idx = addresses[facet.id] >> 1;
  function get2(state2) {
    let values = [];
    for (let i = 0; i < providerAddrs.length; i++) {
      let value = getAddr(state2, providerAddrs[i]);
      if (providerTypes[i] == 2)
        for (let val of value)
          values.push(val);
      else
        values.push(value);
    }
    return facet.combine(values);
  }
  return {
    create(state2) {
      for (let addr of providerAddrs)
        ensureAddr(state2, addr);
      state2.values[idx] = get2(state2);
      return 1;
    },
    update(state2, tr) {
      if (!ensureAll(state2, dynamic))
        return 0;
      let value = get2(state2);
      if (facet.compare(value, state2.values[idx]))
        return 0;
      state2.values[idx] = value;
      return 1;
    },
    reconfigure(state2, oldState) {
      let depChanged = ensureAll(state2, providerAddrs);
      let oldProviders = oldState.config.facets[facet.id], oldValue = oldState.facet(facet);
      if (oldProviders && !depChanged && sameArray$1(providers, oldProviders)) {
        state2.values[idx] = oldValue;
        return 0;
      }
      let value = get2(state2);
      if (facet.compare(value, oldValue)) {
        state2.values[idx] = oldValue;
        return 0;
      }
      state2.values[idx] = value;
      return 1;
    }
  };
}
const initField = /* @__PURE__ */ Facet.define({ static: true });
class StateField {
  constructor(id2, createF, updateF, compareF, spec) {
    this.id = id2;
    this.createF = createF;
    this.updateF = updateF;
    this.compareF = compareF;
    this.spec = spec;
    this.provides = void 0;
  }
  /**
  Define a state field.
  */
  static define(config) {
    let field = new StateField(nextID++, config.create, config.update, config.compare || ((a, b2) => a === b2), config);
    if (config.provide)
      field.provides = config.provide(field);
    return field;
  }
  create(state2) {
    let init2 = state2.facet(initField).find((i) => i.field == this);
    return ((init2 === null || init2 === void 0 ? void 0 : init2.create) || this.createF)(state2);
  }
  /**
  @internal
  */
  slot(addresses) {
    let idx = addresses[this.id] >> 1;
    return {
      create: (state2) => {
        state2.values[idx] = this.create(state2);
        return 1;
      },
      update: (state2, tr) => {
        let oldVal = state2.values[idx];
        let value = this.updateF(oldVal, tr);
        if (this.compareF(oldVal, value))
          return 0;
        state2.values[idx] = value;
        return 1;
      },
      reconfigure: (state2, oldState) => {
        let init2 = state2.facet(initField), oldInit = oldState.facet(initField), reInit;
        if ((reInit = init2.find((i) => i.field == this)) && reInit != oldInit.find((i) => i.field == this)) {
          state2.values[idx] = reInit.create(state2);
          return 1;
        }
        if (oldState.config.address[this.id] != null) {
          state2.values[idx] = oldState.field(this);
          return 0;
        }
        state2.values[idx] = this.create(state2);
        return 1;
      }
    };
  }
  /**
  Returns an extension that enables this field and overrides the
  way it is initialized. Can be useful when you need to provide a
  non-default starting value for the field.
  */
  init(create2) {
    return [this, initField.of({ field: this, create: create2 })];
  }
  /**
  State field instances can be used as
  [`Extension`](https://codemirror.net/6/docs/ref/#state.Extension) values to enable the field in a
  given state.
  */
  get extension() {
    return this;
  }
}
const Prec_ = { lowest: 4, low: 3, default: 2, high: 1, highest: 0 };
function prec(value) {
  return (ext) => new PrecExtension(ext, value);
}
const Prec = {
  /**
  The highest precedence level, for extensions that should end up
  near the start of the precedence ordering.
  */
  highest: /* @__PURE__ */ prec(Prec_.highest),
  /**
  A higher-than-default precedence, for extensions that should
  come before those with default precedence.
  */
  high: /* @__PURE__ */ prec(Prec_.high),
  /**
  The default precedence, which is also used for extensions
  without an explicit precedence.
  */
  default: /* @__PURE__ */ prec(Prec_.default),
  /**
  A lower-than-default precedence.
  */
  low: /* @__PURE__ */ prec(Prec_.low),
  /**
  The lowest precedence level. Meant for things that should end up
  near the end of the extension order.
  */
  lowest: /* @__PURE__ */ prec(Prec_.lowest)
};
class PrecExtension {
  constructor(inner, prec2) {
    this.inner = inner;
    this.prec = prec2;
  }
}
class Compartment {
  /**
  Create an instance of this compartment to add to your [state
  configuration](https://codemirror.net/6/docs/ref/#state.EditorStateConfig.extensions).
  */
  of(ext) {
    return new CompartmentInstance(this, ext);
  }
  /**
  Create an [effect](https://codemirror.net/6/docs/ref/#state.TransactionSpec.effects) that
  reconfigures this compartment.
  */
  reconfigure(content2) {
    return Compartment.reconfigure.of({ compartment: this, extension: content2 });
  }
  /**
  Get the current content of the compartment in the state, or
  `undefined` if it isn't present.
  */
  get(state2) {
    return state2.config.compartments.get(this);
  }
}
class CompartmentInstance {
  constructor(compartment, inner) {
    this.compartment = compartment;
    this.inner = inner;
  }
}
class Configuration {
  constructor(base2, compartments, dynamicSlots, address, staticValues, facets) {
    this.base = base2;
    this.compartments = compartments;
    this.dynamicSlots = dynamicSlots;
    this.address = address;
    this.staticValues = staticValues;
    this.facets = facets;
    this.statusTemplate = [];
    while (this.statusTemplate.length < dynamicSlots.length)
      this.statusTemplate.push(
        0
        /* SlotStatus.Unresolved */
      );
  }
  staticFacet(facet) {
    let addr = this.address[facet.id];
    return addr == null ? facet.default : this.staticValues[addr >> 1];
  }
  static resolve(base2, compartments, oldState) {
    let fields = [];
    let facets = /* @__PURE__ */ Object.create(null);
    let newCompartments = /* @__PURE__ */ new Map();
    for (let ext of flatten(base2, compartments, newCompartments)) {
      if (ext instanceof StateField)
        fields.push(ext);
      else
        (facets[ext.facet.id] || (facets[ext.facet.id] = [])).push(ext);
    }
    let address = /* @__PURE__ */ Object.create(null);
    let staticValues = [];
    let dynamicSlots = [];
    for (let field of fields) {
      address[field.id] = dynamicSlots.length << 1;
      dynamicSlots.push((a) => field.slot(a));
    }
    let oldFacets = oldState === null || oldState === void 0 ? void 0 : oldState.config.facets;
    for (let id2 in facets) {
      let providers = facets[id2], facet = providers[0].facet;
      let oldProviders = oldFacets && oldFacets[id2] || [];
      if (providers.every(
        (p) => p.type == 0
        /* Provider.Static */
      )) {
        address[facet.id] = staticValues.length << 1 | 1;
        if (sameArray$1(oldProviders, providers)) {
          staticValues.push(oldState.facet(facet));
        } else {
          let value = facet.combine(providers.map((p) => p.value));
          staticValues.push(oldState && facet.compare(value, oldState.facet(facet)) ? oldState.facet(facet) : value);
        }
      } else {
        for (let p of providers) {
          if (p.type == 0) {
            address[p.id] = staticValues.length << 1 | 1;
            staticValues.push(p.value);
          } else {
            address[p.id] = dynamicSlots.length << 1;
            dynamicSlots.push((a) => p.dynamicSlot(a));
          }
        }
        address[facet.id] = dynamicSlots.length << 1;
        dynamicSlots.push((a) => dynamicFacetSlot(a, facet, providers));
      }
    }
    let dynamic = dynamicSlots.map((f) => f(address));
    return new Configuration(base2, newCompartments, dynamic, address, staticValues, facets);
  }
}
function flatten(extension, compartments, newCompartments) {
  let result = [[], [], [], [], []];
  let seen = /* @__PURE__ */ new Map();
  function inner(ext, prec2) {
    let known = seen.get(ext);
    if (known != null) {
      if (known <= prec2)
        return;
      let found = result[known].indexOf(ext);
      if (found > -1)
        result[known].splice(found, 1);
      if (ext instanceof CompartmentInstance)
        newCompartments.delete(ext.compartment);
    }
    seen.set(ext, prec2);
    if (Array.isArray(ext)) {
      for (let e of ext)
        inner(e, prec2);
    } else if (ext instanceof CompartmentInstance) {
      if (newCompartments.has(ext.compartment))
        throw new RangeError(`Duplicate use of compartment in extensions`);
      let content2 = compartments.get(ext.compartment) || ext.inner;
      newCompartments.set(ext.compartment, content2);
      inner(content2, prec2);
    } else if (ext instanceof PrecExtension) {
      inner(ext.inner, ext.prec);
    } else if (ext instanceof StateField) {
      result[prec2].push(ext);
      if (ext.provides)
        inner(ext.provides, prec2);
    } else if (ext instanceof FacetProvider) {
      result[prec2].push(ext);
      if (ext.facet.extensions)
        inner(ext.facet.extensions, Prec_.default);
    } else {
      let content2 = ext.extension;
      if (!content2)
        throw new Error(`Unrecognized extension value in extension set (${ext}). This sometimes happens because multiple instances of @codemirror/state are loaded, breaking instanceof checks.`);
      inner(content2, prec2);
    }
  }
  inner(extension, Prec_.default);
  return result.reduce((a, b2) => a.concat(b2));
}
function ensureAddr(state2, addr) {
  if (addr & 1)
    return 2;
  let idx = addr >> 1;
  let status = state2.status[idx];
  if (status == 4)
    throw new Error("Cyclic dependency between fields and/or facets");
  if (status & 2)
    return status;
  state2.status[idx] = 4;
  let changed = state2.computeSlot(state2, state2.config.dynamicSlots[idx]);
  return state2.status[idx] = 2 | changed;
}
function getAddr(state2, addr) {
  return addr & 1 ? state2.config.staticValues[addr >> 1] : state2.values[addr >> 1];
}
const languageData = /* @__PURE__ */ Facet.define();
const allowMultipleSelections = /* @__PURE__ */ Facet.define({
  combine: (values) => values.some((v2) => v2),
  static: true
});
const lineSeparator = /* @__PURE__ */ Facet.define({
  combine: (values) => values.length ? values[0] : void 0,
  static: true
});
const changeFilter = /* @__PURE__ */ Facet.define();
const transactionFilter = /* @__PURE__ */ Facet.define();
const transactionExtender = /* @__PURE__ */ Facet.define();
const readOnly = /* @__PURE__ */ Facet.define({
  combine: (values) => values.length ? values[0] : false
});
class Annotation {
  /**
  @internal
  */
  constructor(type, value) {
    this.type = type;
    this.value = value;
  }
  /**
  Define a new type of annotation.
  */
  static define() {
    return new AnnotationType();
  }
}
class AnnotationType {
  /**
  Create an instance of this annotation.
  */
  of(value) {
    return new Annotation(this, value);
  }
}
class StateEffectType {
  /**
  @internal
  */
  constructor(map) {
    this.map = map;
  }
  /**
  Create a [state effect](https://codemirror.net/6/docs/ref/#state.StateEffect) instance of this
  type.
  */
  of(value) {
    return new StateEffect(this, value);
  }
}
class StateEffect {
  /**
  @internal
  */
  constructor(type, value) {
    this.type = type;
    this.value = value;
  }
  /**
  Map this effect through a position mapping. Will return
  `undefined` when that ends up deleting the effect.
  */
  map(mapping) {
    let mapped = this.type.map(this.value, mapping);
    return mapped === void 0 ? void 0 : mapped == this.value ? this : new StateEffect(this.type, mapped);
  }
  /**
  Tells you whether this effect object is of a given
  [type](https://codemirror.net/6/docs/ref/#state.StateEffectType).
  */
  is(type) {
    return this.type == type;
  }
  /**
  Define a new effect type. The type parameter indicates the type
  of values that his effect holds. It should be a type that
  doesn't include `undefined`, since that is used in
  [mapping](https://codemirror.net/6/docs/ref/#state.StateEffect.map) to indicate that an effect is
  removed.
  */
  static define(spec = {}) {
    return new StateEffectType(spec.map || ((v2) => v2));
  }
  /**
  Map an array of effects through a change set.
  */
  static mapEffects(effects, mapping) {
    if (!effects.length)
      return effects;
    let result = [];
    for (let effect2 of effects) {
      let mapped = effect2.map(mapping);
      if (mapped)
        result.push(mapped);
    }
    return result;
  }
}
StateEffect.reconfigure = /* @__PURE__ */ StateEffect.define();
StateEffect.appendConfig = /* @__PURE__ */ StateEffect.define();
class Transaction {
  constructor(startState, changes, selection2, effects, annotations, scrollIntoView2) {
    this.startState = startState;
    this.changes = changes;
    this.selection = selection2;
    this.effects = effects;
    this.annotations = annotations;
    this.scrollIntoView = scrollIntoView2;
    this._doc = null;
    this._state = null;
    if (selection2)
      checkSelection(selection2, changes.newLength);
    if (!annotations.some((a) => a.type == Transaction.time))
      this.annotations = annotations.concat(Transaction.time.of(Date.now()));
  }
  /**
  @internal
  */
  static create(startState, changes, selection2, effects, annotations, scrollIntoView2) {
    return new Transaction(startState, changes, selection2, effects, annotations, scrollIntoView2);
  }
  /**
  The new document produced by the transaction. Contrary to
  [`.state`](https://codemirror.net/6/docs/ref/#state.Transaction.state)`.doc`, accessing this won't
  force the entire new state to be computed right away, so it is
  recommended that [transaction
  filters](https://codemirror.net/6/docs/ref/#state.EditorState^transactionFilter) use this getter
  when they need to look at the new document.
  */
  get newDoc() {
    return this._doc || (this._doc = this.changes.apply(this.startState.doc));
  }
  /**
  The new selection produced by the transaction. If
  [`this.selection`](https://codemirror.net/6/docs/ref/#state.Transaction.selection) is undefined,
  this will [map](https://codemirror.net/6/docs/ref/#state.EditorSelection.map) the start state's
  current selection through the changes made by the transaction.
  */
  get newSelection() {
    return this.selection || this.startState.selection.map(this.changes);
  }
  /**
  The new state created by the transaction. Computed on demand
  (but retained for subsequent access), so it is recommended not to
  access it in [transaction
  filters](https://codemirror.net/6/docs/ref/#state.EditorState^transactionFilter) when possible.
  */
  get state() {
    if (!this._state)
      this.startState.applyTransaction(this);
    return this._state;
  }
  /**
  Get the value of the given annotation type, if any.
  */
  annotation(type) {
    for (let ann of this.annotations)
      if (ann.type == type)
        return ann.value;
    return void 0;
  }
  /**
  Indicates whether the transaction changed the document.
  */
  get docChanged() {
    return !this.changes.empty;
  }
  /**
  Indicates whether this transaction reconfigures the state
  (through a [configuration compartment](https://codemirror.net/6/docs/ref/#state.Compartment) or
  with a top-level configuration
  [effect](https://codemirror.net/6/docs/ref/#state.StateEffect^reconfigure).
  */
  get reconfigured() {
    return this.startState.config != this.state.config;
  }
  /**
  Returns true if the transaction has a [user
  event](https://codemirror.net/6/docs/ref/#state.Transaction^userEvent) annotation that is equal to
  or more specific than `event`. For example, if the transaction
  has `"select.pointer"` as user event, `"select"` and
  `"select.pointer"` will match it.
  */
  isUserEvent(event2) {
    let e = this.annotation(Transaction.userEvent);
    return !!(e && (e == event2 || e.length > event2.length && e.slice(0, event2.length) == event2 && e[event2.length] == "."));
  }
}
Transaction.time = /* @__PURE__ */ Annotation.define();
Transaction.userEvent = /* @__PURE__ */ Annotation.define();
Transaction.addToHistory = /* @__PURE__ */ Annotation.define();
Transaction.remote = /* @__PURE__ */ Annotation.define();
function joinRanges(a, b2) {
  let result = [];
  for (let iA = 0, iB = 0; ; ) {
    let from, to;
    if (iA < a.length && (iB == b2.length || b2[iB] >= a[iA])) {
      from = a[iA++];
      to = a[iA++];
    } else if (iB < b2.length) {
      from = b2[iB++];
      to = b2[iB++];
    } else
      return result;
    if (!result.length || result[result.length - 1] < from)
      result.push(from, to);
    else if (result[result.length - 1] < to)
      result[result.length - 1] = to;
  }
}
function mergeTransaction(a, b2, sequential) {
  var _a3;
  let mapForA, mapForB, changes;
  if (sequential) {
    mapForA = b2.changes;
    mapForB = ChangeSet.empty(b2.changes.length);
    changes = a.changes.compose(b2.changes);
  } else {
    mapForA = b2.changes.map(a.changes);
    mapForB = a.changes.mapDesc(b2.changes, true);
    changes = a.changes.compose(mapForA);
  }
  return {
    changes,
    selection: b2.selection ? b2.selection.map(mapForB) : (_a3 = a.selection) === null || _a3 === void 0 ? void 0 : _a3.map(mapForA),
    effects: StateEffect.mapEffects(a.effects, mapForA).concat(StateEffect.mapEffects(b2.effects, mapForB)),
    annotations: a.annotations.length ? a.annotations.concat(b2.annotations) : b2.annotations,
    scrollIntoView: a.scrollIntoView || b2.scrollIntoView
  };
}
function resolveTransactionInner(state2, spec, docSize) {
  let sel = spec.selection, annotations = asArray$1(spec.annotations);
  if (spec.userEvent)
    annotations = annotations.concat(Transaction.userEvent.of(spec.userEvent));
  return {
    changes: spec.changes instanceof ChangeSet ? spec.changes : ChangeSet.of(spec.changes || [], docSize, state2.facet(lineSeparator)),
    selection: sel && (sel instanceof EditorSelection ? sel : EditorSelection.single(sel.anchor, sel.head)),
    effects: asArray$1(spec.effects),
    annotations,
    scrollIntoView: !!spec.scrollIntoView
  };
}
function resolveTransaction(state2, specs, filter2) {
  let s = resolveTransactionInner(state2, specs.length ? specs[0] : {}, state2.doc.length);
  if (specs.length && specs[0].filter === false)
    filter2 = false;
  for (let i = 1; i < specs.length; i++) {
    if (specs[i].filter === false)
      filter2 = false;
    let seq = !!specs[i].sequential;
    s = mergeTransaction(s, resolveTransactionInner(state2, specs[i], seq ? s.changes.newLength : state2.doc.length), seq);
  }
  let tr = Transaction.create(state2, s.changes, s.selection, s.effects, s.annotations, s.scrollIntoView);
  return extendTransaction(filter2 ? filterTransaction(tr) : tr);
}
function filterTransaction(tr) {
  let state2 = tr.startState;
  let result = true;
  for (let filter2 of state2.facet(changeFilter)) {
    let value = filter2(tr);
    if (value === false) {
      result = false;
      break;
    }
    if (Array.isArray(value))
      result = result === true ? value : joinRanges(result, value);
  }
  if (result !== true) {
    let changes, back;
    if (result === false) {
      back = tr.changes.invertedDesc;
      changes = ChangeSet.empty(state2.doc.length);
    } else {
      let filtered = tr.changes.filter(result);
      changes = filtered.changes;
      back = filtered.filtered.mapDesc(filtered.changes).invertedDesc;
    }
    tr = Transaction.create(state2, changes, tr.selection && tr.selection.map(back), StateEffect.mapEffects(tr.effects, back), tr.annotations, tr.scrollIntoView);
  }
  let filters = state2.facet(transactionFilter);
  for (let i = filters.length - 1; i >= 0; i--) {
    let filtered = filters[i](tr);
    if (filtered instanceof Transaction)
      tr = filtered;
    else if (Array.isArray(filtered) && filtered.length == 1 && filtered[0] instanceof Transaction)
      tr = filtered[0];
    else
      tr = resolveTransaction(state2, asArray$1(filtered), false);
  }
  return tr;
}
function extendTransaction(tr) {
  let state2 = tr.startState, extenders = state2.facet(transactionExtender), spec = tr;
  for (let i = extenders.length - 1; i >= 0; i--) {
    let extension = extenders[i](tr);
    if (extension && Object.keys(extension).length)
      spec = mergeTransaction(spec, resolveTransactionInner(state2, extension, tr.changes.newLength), true);
  }
  return spec == tr ? tr : Transaction.create(state2, tr.changes, tr.selection, spec.effects, spec.annotations, spec.scrollIntoView);
}
const none$1 = [];
function asArray$1(value) {
  return value == null ? none$1 : Array.isArray(value) ? value : [value];
}
var CharCategory = /* @__PURE__ */ (function(CharCategory2) {
  CharCategory2[CharCategory2["Word"] = 0] = "Word";
  CharCategory2[CharCategory2["Space"] = 1] = "Space";
  CharCategory2[CharCategory2["Other"] = 2] = "Other";
  return CharCategory2;
})(CharCategory || (CharCategory = {}));
const nonASCIISingleCaseWordChar = /[\u00df\u0587\u0590-\u05f4\u0600-\u06ff\u3040-\u309f\u30a0-\u30ff\u3400-\u4db5\u4e00-\u9fcc\uac00-\ud7af]/;
let wordChar;
try {
  wordChar = /* @__PURE__ */ new RegExp("[\\p{Alphabetic}\\p{Number}_]", "u");
} catch (_2) {
}
function hasWordChar(str) {
  if (wordChar)
    return wordChar.test(str);
  for (let i = 0; i < str.length; i++) {
    let ch = str[i];
    if (/\w/.test(ch) || ch > "" && (ch.toUpperCase() != ch.toLowerCase() || nonASCIISingleCaseWordChar.test(ch)))
      return true;
  }
  return false;
}
function makeCategorizer(wordChars) {
  return (char) => {
    if (!/\S/.test(char))
      return CharCategory.Space;
    if (hasWordChar(char))
      return CharCategory.Word;
    for (let i = 0; i < wordChars.length; i++)
      if (char.indexOf(wordChars[i]) > -1)
        return CharCategory.Word;
    return CharCategory.Other;
  };
}
class EditorState {
  constructor(config, doc2, selection2, values, computeSlot, tr) {
    this.config = config;
    this.doc = doc2;
    this.selection = selection2;
    this.values = values;
    this.status = config.statusTemplate.slice();
    this.computeSlot = computeSlot;
    if (tr)
      tr._state = this;
    for (let i = 0; i < this.config.dynamicSlots.length; i++)
      ensureAddr(this, i << 1);
    this.computeSlot = null;
  }
  field(field, require2 = true) {
    let addr = this.config.address[field.id];
    if (addr == null) {
      if (require2)
        throw new RangeError("Field is not present in this state");
      return void 0;
    }
    ensureAddr(this, addr);
    return getAddr(this, addr);
  }
  /**
  Create a [transaction](https://codemirror.net/6/docs/ref/#state.Transaction) that updates this
  state. Any number of [transaction specs](https://codemirror.net/6/docs/ref/#state.TransactionSpec)
  can be passed. Unless
  [`sequential`](https://codemirror.net/6/docs/ref/#state.TransactionSpec.sequential) is set, the
  [changes](https://codemirror.net/6/docs/ref/#state.TransactionSpec.changes) (if any) of each spec
  are assumed to start in the _current_ document (not the document
  produced by previous specs), and its
  [selection](https://codemirror.net/6/docs/ref/#state.TransactionSpec.selection) and
  [effects](https://codemirror.net/6/docs/ref/#state.TransactionSpec.effects) are assumed to refer
  to the document created by its _own_ changes. The resulting
  transaction contains the combined effect of all the different
  specs. For [selection](https://codemirror.net/6/docs/ref/#state.TransactionSpec.selection), later
  specs take precedence over earlier ones.
  */
  update(...specs) {
    return resolveTransaction(this, specs, true);
  }
  /**
  @internal
  */
  applyTransaction(tr) {
    let conf = this.config, { base: base2, compartments } = conf;
    for (let effect2 of tr.effects) {
      if (effect2.is(Compartment.reconfigure)) {
        if (conf) {
          compartments = /* @__PURE__ */ new Map();
          conf.compartments.forEach((val, key2) => compartments.set(key2, val));
          conf = null;
        }
        compartments.set(effect2.value.compartment, effect2.value.extension);
      } else if (effect2.is(StateEffect.reconfigure)) {
        conf = null;
        base2 = effect2.value;
      } else if (effect2.is(StateEffect.appendConfig)) {
        conf = null;
        base2 = asArray$1(base2).concat(effect2.value);
      }
    }
    let startValues;
    if (!conf) {
      conf = Configuration.resolve(base2, compartments, this);
      let intermediateState = new EditorState(conf, this.doc, this.selection, conf.dynamicSlots.map(() => null), (state2, slot) => slot.reconfigure(state2, this), null);
      startValues = intermediateState.values;
    } else {
      startValues = tr.startState.values.slice();
    }
    let selection2 = tr.startState.facet(allowMultipleSelections) ? tr.newSelection : tr.newSelection.asSingle();
    new EditorState(conf, tr.newDoc, selection2, startValues, (state2, slot) => slot.update(state2, tr), tr);
  }
  /**
  Create a [transaction spec](https://codemirror.net/6/docs/ref/#state.TransactionSpec) that
  replaces every selection range with the given content.
  */
  replaceSelection(text2) {
    if (typeof text2 == "string")
      text2 = this.toText(text2);
    return this.changeByRange((range) => ({
      changes: { from: range.from, to: range.to, insert: text2 },
      range: EditorSelection.cursor(range.from + text2.length)
    }));
  }
  /**
  Create a set of changes and a new selection by running the given
  function for each range in the active selection. The function
  can return an optional set of changes (in the coordinate space
  of the start document), plus an updated range (in the coordinate
  space of the document produced by the call's own changes). This
  method will merge all the changes and ranges into a single
  changeset and selection, and return it as a [transaction
  spec](https://codemirror.net/6/docs/ref/#state.TransactionSpec), which can be passed to
  [`update`](https://codemirror.net/6/docs/ref/#state.EditorState.update).
  */
  changeByRange(f) {
    let sel = this.selection;
    let result1 = f(sel.ranges[0]);
    let changes = this.changes(result1.changes), ranges = [result1.range];
    let effects = asArray$1(result1.effects);
    for (let i = 1; i < sel.ranges.length; i++) {
      let result = f(sel.ranges[i]);
      let newChanges = this.changes(result.changes), newMapped = newChanges.map(changes);
      for (let j2 = 0; j2 < i; j2++)
        ranges[j2] = ranges[j2].map(newMapped);
      let mapBy = changes.mapDesc(newChanges, true);
      ranges.push(result.range.map(mapBy));
      changes = changes.compose(newMapped);
      effects = StateEffect.mapEffects(effects, newMapped).concat(StateEffect.mapEffects(asArray$1(result.effects), mapBy));
    }
    return {
      changes,
      selection: EditorSelection.create(ranges, sel.mainIndex),
      effects
    };
  }
  /**
  Create a [change set](https://codemirror.net/6/docs/ref/#state.ChangeSet) from the given change
  description, taking the state's document length and line
  separator into account.
  */
  changes(spec = []) {
    if (spec instanceof ChangeSet)
      return spec;
    return ChangeSet.of(spec, this.doc.length, this.facet(EditorState.lineSeparator));
  }
  /**
  Using the state's [line
  separator](https://codemirror.net/6/docs/ref/#state.EditorState^lineSeparator), create a
  [`Text`](https://codemirror.net/6/docs/ref/#state.Text) instance from the given string.
  */
  toText(string2) {
    return Text$1.of(string2.split(this.facet(EditorState.lineSeparator) || DefaultSplit));
  }
  /**
  Return the given range of the document as a string.
  */
  sliceDoc(from = 0, to = this.doc.length) {
    return this.doc.sliceString(from, to, this.lineBreak);
  }
  /**
  Get the value of a state [facet](https://codemirror.net/6/docs/ref/#state.Facet).
  */
  facet(facet) {
    let addr = this.config.address[facet.id];
    if (addr == null)
      return facet.default;
    ensureAddr(this, addr);
    return getAddr(this, addr);
  }
  /**
  Convert this state to a JSON-serializable object. When custom
  fields should be serialized, you can pass them in as an object
  mapping property names (in the resulting object, which should
  not use `doc` or `selection`) to fields.
  */
  toJSON(fields) {
    let result = {
      doc: this.sliceDoc(),
      selection: this.selection.toJSON()
    };
    if (fields)
      for (let prop2 in fields) {
        let value = fields[prop2];
        if (value instanceof StateField && this.config.address[value.id] != null)
          result[prop2] = value.spec.toJSON(this.field(fields[prop2]), this);
      }
    return result;
  }
  /**
  Deserialize a state from its JSON representation. When custom
  fields should be deserialized, pass the same object you passed
  to [`toJSON`](https://codemirror.net/6/docs/ref/#state.EditorState.toJSON) when serializing as
  third argument.
  */
  static fromJSON(json2, config = {}, fields) {
    if (!json2 || typeof json2.doc != "string")
      throw new RangeError("Invalid JSON representation for EditorState");
    let fieldInit = [];
    if (fields)
      for (let prop2 in fields) {
        if (Object.prototype.hasOwnProperty.call(json2, prop2)) {
          let field = fields[prop2], value = json2[prop2];
          fieldInit.push(field.init((state2) => field.spec.fromJSON(value, state2)));
        }
      }
    return EditorState.create({
      doc: json2.doc,
      selection: EditorSelection.fromJSON(json2.selection),
      extensions: config.extensions ? fieldInit.concat([config.extensions]) : fieldInit
    });
  }
  /**
  Create a new state. You'll usually only need this when
  initializing an editor—updated states are created by applying
  transactions.
  */
  static create(config = {}) {
    let configuration = Configuration.resolve(config.extensions || [], /* @__PURE__ */ new Map());
    let doc2 = config.doc instanceof Text$1 ? config.doc : Text$1.of((config.doc || "").split(configuration.staticFacet(EditorState.lineSeparator) || DefaultSplit));
    let selection2 = !config.selection ? EditorSelection.single(0) : config.selection instanceof EditorSelection ? config.selection : EditorSelection.single(config.selection.anchor, config.selection.head);
    checkSelection(selection2, doc2.length);
    if (!configuration.staticFacet(allowMultipleSelections))
      selection2 = selection2.asSingle();
    return new EditorState(configuration, doc2, selection2, configuration.dynamicSlots.map(() => null), (state2, slot) => slot.create(state2), null);
  }
  /**
  The size (in columns) of a tab in the document, determined by
  the [`tabSize`](https://codemirror.net/6/docs/ref/#state.EditorState^tabSize) facet.
  */
  get tabSize() {
    return this.facet(EditorState.tabSize);
  }
  /**
  Get the proper [line-break](https://codemirror.net/6/docs/ref/#state.EditorState^lineSeparator)
  string for this state.
  */
  get lineBreak() {
    return this.facet(EditorState.lineSeparator) || "\n";
  }
  /**
  Returns true when the editor is
  [configured](https://codemirror.net/6/docs/ref/#state.EditorState^readOnly) to be read-only.
  */
  get readOnly() {
    return this.facet(readOnly);
  }
  /**
  Look up a translation for the given phrase (via the
  [`phrases`](https://codemirror.net/6/docs/ref/#state.EditorState^phrases) facet), or return the
  original string if no translation is found.
  
  If additional arguments are passed, they will be inserted in
  place of markers like `$1` (for the first value) and `$2`, etc.
  A single `$` is equivalent to `$1`, and `$$` will produce a
  literal dollar sign.
  */
  phrase(phrase, ...insert2) {
    for (let map of this.facet(EditorState.phrases))
      if (Object.prototype.hasOwnProperty.call(map, phrase)) {
        phrase = map[phrase];
        break;
      }
    if (insert2.length)
      phrase = phrase.replace(/\$(\$|\d*)/g, (m2, i) => {
        if (i == "$")
          return "$";
        let n = +(i || 1);
        return !n || n > insert2.length ? m2 : insert2[n - 1];
      });
    return phrase;
  }
  /**
  Find the values for a given language data field, provided by the
  the [`languageData`](https://codemirror.net/6/docs/ref/#state.EditorState^languageData) facet.
  
  Examples of language data fields are...
  
  - [`"commentTokens"`](https://codemirror.net/6/docs/ref/#commands.CommentTokens) for specifying
    comment syntax.
  - [`"autocomplete"`](https://codemirror.net/6/docs/ref/#autocomplete.autocompletion^config.override)
    for providing language-specific completion sources.
  - [`"wordChars"`](https://codemirror.net/6/docs/ref/#state.EditorState.charCategorizer) for adding
    characters that should be considered part of words in this
    language.
  - [`"closeBrackets"`](https://codemirror.net/6/docs/ref/#autocomplete.CloseBracketConfig) controls
    bracket closing behavior.
  */
  languageDataAt(name2, pos, side = -1) {
    let values = [];
    for (let provider of this.facet(languageData)) {
      for (let result of provider(this, pos, side)) {
        if (Object.prototype.hasOwnProperty.call(result, name2))
          values.push(result[name2]);
      }
    }
    return values;
  }
  /**
  Return a function that can categorize strings (expected to
  represent a single [grapheme cluster](https://codemirror.net/6/docs/ref/#state.findClusterBreak))
  into one of:
  
   - Word (contains an alphanumeric character or a character
     explicitly listed in the local language's `"wordChars"`
     language data, which should be a string)
   - Space (contains only whitespace)
   - Other (anything else)
  */
  charCategorizer(at) {
    let chars = this.languageDataAt("wordChars", at);
    return makeCategorizer(chars.length ? chars[0] : "");
  }
  /**
  Find the word at the given position, meaning the range
  containing all [word](https://codemirror.net/6/docs/ref/#state.CharCategory.Word) characters
  around it. If no word characters are adjacent to the position,
  this returns null.
  */
  wordAt(pos) {
    let { text: text2, from, length } = this.doc.lineAt(pos);
    let cat = this.charCategorizer(pos);
    let start2 = pos - from, end = pos - from;
    while (start2 > 0) {
      let prev = findClusterBreak(text2, start2, false);
      if (cat(text2.slice(prev, start2)) != CharCategory.Word)
        break;
      start2 = prev;
    }
    while (end < length) {
      let next = findClusterBreak(text2, end);
      if (cat(text2.slice(end, next)) != CharCategory.Word)
        break;
      end = next;
    }
    return start2 == end ? null : EditorSelection.range(start2 + from, end + from);
  }
}
EditorState.allowMultipleSelections = allowMultipleSelections;
EditorState.tabSize = /* @__PURE__ */ Facet.define({
  combine: (values) => values.length ? values[0] : 4
});
EditorState.lineSeparator = lineSeparator;
EditorState.readOnly = readOnly;
EditorState.phrases = /* @__PURE__ */ Facet.define({
  compare(a, b2) {
    let kA = Object.keys(a), kB = Object.keys(b2);
    return kA.length == kB.length && kA.every((k2) => a[k2] == b2[k2]);
  }
});
EditorState.languageData = languageData;
EditorState.changeFilter = changeFilter;
EditorState.transactionFilter = transactionFilter;
EditorState.transactionExtender = transactionExtender;
Compartment.reconfigure = /* @__PURE__ */ StateEffect.define();
function combineConfig(configs, defaults2, combine = {}) {
  let result = {};
  for (let config of configs)
    for (let key2 of Object.keys(config)) {
      let value = config[key2], current = result[key2];
      if (current === void 0)
        result[key2] = value;
      else if (current === value || value === void 0) ;
      else if (Object.hasOwnProperty.call(combine, key2))
        result[key2] = combine[key2](current, value);
      else
        throw new Error("Config merge conflict for field " + key2);
    }
  for (let key2 in defaults2)
    if (result[key2] === void 0)
      result[key2] = defaults2[key2];
  return result;
}
class RangeValue {
  /**
  Compare this value with another value. Used when comparing
  rangesets. The default implementation compares by identity.
  Unless you are only creating a fixed number of unique instances
  of your value type, it is a good idea to implement this
  properly.
  */
  eq(other) {
    return this == other;
  }
  /**
  Create a [range](https://codemirror.net/6/docs/ref/#state.Range) with this value.
  */
  range(from, to = from) {
    return Range$1.create(from, to, this);
  }
}
RangeValue.prototype.startSide = RangeValue.prototype.endSide = 0;
RangeValue.prototype.point = false;
RangeValue.prototype.mapMode = MapMode.TrackDel;
function cmpVal(a, b2) {
  return a == b2 || a.constructor == b2.constructor && a.eq(b2);
}
let Range$1 = class Range {
  constructor(from, to, value) {
    this.from = from;
    this.to = to;
    this.value = value;
  }
  /**
  @internal
  */
  static create(from, to, value) {
    return new Range(from, to, value);
  }
};
function cmpRange(a, b2) {
  return a.from - b2.from || a.value.startSide - b2.value.startSide;
}
class Chunk {
  constructor(from, to, value, maxPoint) {
    this.from = from;
    this.to = to;
    this.value = value;
    this.maxPoint = maxPoint;
  }
  get length() {
    return this.to[this.to.length - 1];
  }
  // Find the index of the given position and side. Use the ranges'
  // `from` pos when `end == false`, `to` when `end == true`.
  findIndex(pos, side, end, startAt = 0) {
    let arr = end ? this.to : this.from;
    for (let lo = startAt, hi = arr.length; ; ) {
      if (lo == hi)
        return lo;
      let mid = lo + hi >> 1;
      let diff = arr[mid] - pos || (end ? this.value[mid].endSide : this.value[mid].startSide) - side;
      if (mid == lo)
        return diff >= 0 ? lo : hi;
      if (diff >= 0)
        hi = mid;
      else
        lo = mid + 1;
    }
  }
  between(offset, from, to, f) {
    for (let i = this.findIndex(from, -1e9, true), e = this.findIndex(to, 1e9, false, i); i < e; i++)
      if (f(this.from[i] + offset, this.to[i] + offset, this.value[i]) === false)
        return false;
  }
  map(offset, changes) {
    let value = [], from = [], to = [], newPos = -1, maxPoint = -1;
    for (let i = 0; i < this.value.length; i++) {
      let val = this.value[i], curFrom = this.from[i] + offset, curTo = this.to[i] + offset, newFrom, newTo;
      if (curFrom == curTo) {
        let mapped = changes.mapPos(curFrom, val.startSide, val.mapMode);
        if (mapped == null)
          continue;
        newFrom = newTo = mapped;
        if (val.startSide != val.endSide) {
          newTo = changes.mapPos(curFrom, val.endSide);
          if (newTo < newFrom)
            continue;
        }
      } else {
        newFrom = changes.mapPos(curFrom, val.startSide);
        newTo = changes.mapPos(curTo, val.endSide);
        if (newFrom > newTo || newFrom == newTo && val.startSide > 0 && val.endSide <= 0)
          continue;
      }
      if ((newTo - newFrom || val.endSide - val.startSide) < 0)
        continue;
      if (newPos < 0)
        newPos = newFrom;
      if (val.point)
        maxPoint = Math.max(maxPoint, newTo - newFrom);
      value.push(val);
      from.push(newFrom - newPos);
      to.push(newTo - newPos);
    }
    return { mapped: value.length ? new Chunk(from, to, value, maxPoint) : null, pos: newPos };
  }
}
class RangeSet {
  constructor(chunkPos, chunk, nextLayer, maxPoint) {
    this.chunkPos = chunkPos;
    this.chunk = chunk;
    this.nextLayer = nextLayer;
    this.maxPoint = maxPoint;
  }
  /**
  @internal
  */
  static create(chunkPos, chunk, nextLayer, maxPoint) {
    return new RangeSet(chunkPos, chunk, nextLayer, maxPoint);
  }
  /**
  @internal
  */
  get length() {
    let last = this.chunk.length - 1;
    return last < 0 ? 0 : Math.max(this.chunkEnd(last), this.nextLayer.length);
  }
  /**
  The number of ranges in the set.
  */
  get size() {
    if (this.isEmpty)
      return 0;
    let size = this.nextLayer.size;
    for (let chunk of this.chunk)
      size += chunk.value.length;
    return size;
  }
  /**
  @internal
  */
  chunkEnd(index2) {
    return this.chunkPos[index2] + this.chunk[index2].length;
  }
  /**
  Update the range set, optionally adding new ranges or filtering
  out existing ones.
  
  (Note: The type parameter is just there as a kludge to work
  around TypeScript variance issues that prevented `RangeSet<X>`
  from being a subtype of `RangeSet<Y>` when `X` is a subtype of
  `Y`.)
  */
  update(updateSpec) {
    let { add: add2 = [], sort = false, filterFrom = 0, filterTo = this.length } = updateSpec;
    let filter2 = updateSpec.filter;
    if (add2.length == 0 && !filter2)
      return this;
    if (sort)
      add2 = add2.slice().sort(cmpRange);
    if (this.isEmpty)
      return add2.length ? RangeSet.of(add2) : this;
    let cur = new LayerCursor(this, null, -1).goto(0), i = 0, spill = [];
    let builder = new RangeSetBuilder();
    while (cur.value || i < add2.length) {
      if (i < add2.length && (cur.from - add2[i].from || cur.startSide - add2[i].value.startSide) >= 0) {
        let range = add2[i++];
        if (!builder.addInner(range.from, range.to, range.value))
          spill.push(range);
      } else if (cur.rangeIndex == 1 && cur.chunkIndex < this.chunk.length && (i == add2.length || this.chunkEnd(cur.chunkIndex) < add2[i].from) && (!filter2 || filterFrom > this.chunkEnd(cur.chunkIndex) || filterTo < this.chunkPos[cur.chunkIndex]) && builder.addChunk(this.chunkPos[cur.chunkIndex], this.chunk[cur.chunkIndex])) {
        cur.nextChunk();
      } else {
        if (!filter2 || filterFrom > cur.to || filterTo < cur.from || filter2(cur.from, cur.to, cur.value)) {
          if (!builder.addInner(cur.from, cur.to, cur.value))
            spill.push(Range$1.create(cur.from, cur.to, cur.value));
        }
        cur.next();
      }
    }
    return builder.finishInner(this.nextLayer.isEmpty && !spill.length ? RangeSet.empty : this.nextLayer.update({ add: spill, filter: filter2, filterFrom, filterTo }));
  }
  /**
  Map this range set through a set of changes, return the new set.
  */
  map(changes) {
    if (changes.empty || this.isEmpty)
      return this;
    let chunks = [], chunkPos = [], maxPoint = -1;
    for (let i = 0; i < this.chunk.length; i++) {
      let start2 = this.chunkPos[i], chunk = this.chunk[i];
      let touch = changes.touchesRange(start2, start2 + chunk.length);
      if (touch === false) {
        maxPoint = Math.max(maxPoint, chunk.maxPoint);
        chunks.push(chunk);
        chunkPos.push(changes.mapPos(start2));
      } else if (touch === true) {
        let { mapped, pos } = chunk.map(start2, changes);
        if (mapped) {
          maxPoint = Math.max(maxPoint, mapped.maxPoint);
          chunks.push(mapped);
          chunkPos.push(pos);
        }
      }
    }
    let next = this.nextLayer.map(changes);
    return chunks.length == 0 ? next : new RangeSet(chunkPos, chunks, next || RangeSet.empty, maxPoint);
  }
  /**
  Iterate over the ranges that touch the region `from` to `to`,
  calling `f` for each. There is no guarantee that the ranges will
  be reported in any specific order. When the callback returns
  `false`, iteration stops.
  */
  between(from, to, f) {
    if (this.isEmpty)
      return;
    for (let i = 0; i < this.chunk.length; i++) {
      let start2 = this.chunkPos[i], chunk = this.chunk[i];
      if (to >= start2 && from <= start2 + chunk.length && chunk.between(start2, from - start2, to - start2, f) === false)
        return;
    }
    this.nextLayer.between(from, to, f);
  }
  /**
  Iterate over the ranges in this set, in order, including all
  ranges that end at or after `from`.
  */
  iter(from = 0) {
    return HeapCursor.from([this]).goto(from);
  }
  /**
  @internal
  */
  get isEmpty() {
    return this.nextLayer == this;
  }
  /**
  Iterate over the ranges in a collection of sets, in order,
  starting from `from`.
  */
  static iter(sets, from = 0) {
    return HeapCursor.from(sets).goto(from);
  }
  /**
  Iterate over two groups of sets, calling methods on `comparator`
  to notify it of possible differences.
  */
  static compare(oldSets, newSets, textDiff, comparator, minPointSize = -1) {
    let a = oldSets.filter((set2) => set2.maxPoint > 0 || !set2.isEmpty && set2.maxPoint >= minPointSize);
    let b2 = newSets.filter((set2) => set2.maxPoint > 0 || !set2.isEmpty && set2.maxPoint >= minPointSize);
    let sharedChunks = findSharedChunks(a, b2, textDiff);
    let sideA = new SpanCursor(a, sharedChunks, minPointSize);
    let sideB = new SpanCursor(b2, sharedChunks, minPointSize);
    textDiff.iterGaps((fromA, fromB, length) => compare(sideA, fromA, sideB, fromB, length, comparator));
    if (textDiff.empty && textDiff.length == 0)
      compare(sideA, 0, sideB, 0, 0, comparator);
  }
  /**
  Compare the contents of two groups of range sets, returning true
  if they are equivalent in the given range.
  */
  static eq(oldSets, newSets, from = 0, to) {
    if (to == null)
      to = 1e9 - 1;
    let a = oldSets.filter((set2) => !set2.isEmpty && newSets.indexOf(set2) < 0);
    let b2 = newSets.filter((set2) => !set2.isEmpty && oldSets.indexOf(set2) < 0);
    if (a.length != b2.length)
      return false;
    if (!a.length)
      return true;
    let sharedChunks = findSharedChunks(a, b2);
    let sideA = new SpanCursor(a, sharedChunks, 0).goto(from), sideB = new SpanCursor(b2, sharedChunks, 0).goto(from);
    for (; ; ) {
      if (sideA.to != sideB.to || !sameValues(sideA.active, sideB.active) || sideA.point && (!sideB.point || !cmpVal(sideA.point, sideB.point)))
        return false;
      if (sideA.to > to)
        return true;
      sideA.next();
      sideB.next();
    }
  }
  /**
  Iterate over a group of range sets at the same time, notifying
  the iterator about the ranges covering every given piece of
  content. Returns the open count (see
  [`SpanIterator.span`](https://codemirror.net/6/docs/ref/#state.SpanIterator.span)) at the end
  of the iteration.
  */
  static spans(sets, from, to, iterator, minPointSize = -1) {
    let cursor2 = new SpanCursor(sets, null, minPointSize).goto(from), pos = from;
    let openRanges = cursor2.openStart;
    for (; ; ) {
      let curTo = Math.min(cursor2.to, to);
      if (cursor2.point) {
        let active = cursor2.activeForPoint(cursor2.to);
        let openCount = cursor2.pointFrom < from ? active.length + 1 : cursor2.point.startSide < 0 ? active.length : Math.min(active.length, openRanges);
        iterator.point(pos, curTo, cursor2.point, active, openCount, cursor2.pointRank);
        openRanges = Math.min(cursor2.openEnd(curTo), active.length);
      } else if (curTo > pos) {
        iterator.span(pos, curTo, cursor2.active, openRanges);
        openRanges = cursor2.openEnd(curTo);
      }
      if (cursor2.to > to)
        return openRanges + (cursor2.point && cursor2.to > to ? 1 : 0);
      pos = cursor2.to;
      cursor2.next();
    }
  }
  /**
  Create a range set for the given range or array of ranges. By
  default, this expects the ranges to be _sorted_ (by start
  position and, if two start at the same position,
  `value.startSide`). You can pass `true` as second argument to
  cause the method to sort them.
  */
  static of(ranges, sort = false) {
    let build = new RangeSetBuilder();
    for (let range of ranges instanceof Range$1 ? [ranges] : sort ? lazySort(ranges) : ranges)
      build.add(range.from, range.to, range.value);
    return build.finish();
  }
  /**
  Join an array of range sets into a single set.
  */
  static join(sets) {
    if (!sets.length)
      return RangeSet.empty;
    let result = sets[sets.length - 1];
    for (let i = sets.length - 2; i >= 0; i--) {
      for (let layer2 = sets[i]; layer2 != RangeSet.empty; layer2 = layer2.nextLayer)
        result = new RangeSet(layer2.chunkPos, layer2.chunk, result, Math.max(layer2.maxPoint, result.maxPoint));
    }
    return result;
  }
}
RangeSet.empty = /* @__PURE__ */ new RangeSet([], [], null, -1);
function lazySort(ranges) {
  if (ranges.length > 1)
    for (let prev = ranges[0], i = 1; i < ranges.length; i++) {
      let cur = ranges[i];
      if (cmpRange(prev, cur) > 0)
        return ranges.slice().sort(cmpRange);
      prev = cur;
    }
  return ranges;
}
RangeSet.empty.nextLayer = RangeSet.empty;
class RangeSetBuilder {
  finishChunk(newArrays) {
    this.chunks.push(new Chunk(this.from, this.to, this.value, this.maxPoint));
    this.chunkPos.push(this.chunkStart);
    this.chunkStart = -1;
    this.setMaxPoint = Math.max(this.setMaxPoint, this.maxPoint);
    this.maxPoint = -1;
    if (newArrays) {
      this.from = [];
      this.to = [];
      this.value = [];
    }
  }
  /**
  Create an empty builder.
  */
  constructor() {
    this.chunks = [];
    this.chunkPos = [];
    this.chunkStart = -1;
    this.last = null;
    this.lastFrom = -1e9;
    this.lastTo = -1e9;
    this.from = [];
    this.to = [];
    this.value = [];
    this.maxPoint = -1;
    this.setMaxPoint = -1;
    this.nextLayer = null;
  }
  /**
  Add a range. Ranges should be added in sorted (by `from` and
  `value.startSide`) order.
  */
  add(from, to, value) {
    if (!this.addInner(from, to, value))
      (this.nextLayer || (this.nextLayer = new RangeSetBuilder())).add(from, to, value);
  }
  /**
  @internal
  */
  addInner(from, to, value) {
    let diff = from - this.lastTo || value.startSide - this.last.endSide;
    if (diff <= 0 && (from - this.lastFrom || value.startSide - this.last.startSide) < 0)
      throw new Error("Ranges must be added sorted by `from` position and `startSide`");
    if (diff < 0)
      return false;
    if (this.from.length == 250)
      this.finishChunk(true);
    if (this.chunkStart < 0)
      this.chunkStart = from;
    this.from.push(from - this.chunkStart);
    this.to.push(to - this.chunkStart);
    this.last = value;
    this.lastFrom = from;
    this.lastTo = to;
    this.value.push(value);
    if (value.point)
      this.maxPoint = Math.max(this.maxPoint, to - from);
    return true;
  }
  /**
  @internal
  */
  addChunk(from, chunk) {
    if ((from - this.lastTo || chunk.value[0].startSide - this.last.endSide) < 0)
      return false;
    if (this.from.length)
      this.finishChunk(true);
    this.setMaxPoint = Math.max(this.setMaxPoint, chunk.maxPoint);
    this.chunks.push(chunk);
    this.chunkPos.push(from);
    let last = chunk.value.length - 1;
    this.last = chunk.value[last];
    this.lastFrom = chunk.from[last] + from;
    this.lastTo = chunk.to[last] + from;
    return true;
  }
  /**
  Finish the range set. Returns the new set. The builder can't be
  used anymore after this has been called.
  */
  finish() {
    return this.finishInner(RangeSet.empty);
  }
  /**
  @internal
  */
  finishInner(next) {
    if (this.from.length)
      this.finishChunk(false);
    if (this.chunks.length == 0)
      return next;
    let result = RangeSet.create(this.chunkPos, this.chunks, this.nextLayer ? this.nextLayer.finishInner(next) : next, this.setMaxPoint);
    this.from = null;
    return result;
  }
}
function findSharedChunks(a, b2, textDiff) {
  let inA = /* @__PURE__ */ new Map();
  for (let set2 of a)
    for (let i = 0; i < set2.chunk.length; i++)
      if (set2.chunk[i].maxPoint <= 0)
        inA.set(set2.chunk[i], set2.chunkPos[i]);
  let shared = /* @__PURE__ */ new Set();
  for (let set2 of b2)
    for (let i = 0; i < set2.chunk.length; i++) {
      let known = inA.get(set2.chunk[i]);
      if (known != null && (textDiff ? textDiff.mapPos(known) : known) == set2.chunkPos[i] && !(textDiff === null || textDiff === void 0 ? void 0 : textDiff.touchesRange(known, known + set2.chunk[i].length)))
        shared.add(set2.chunk[i]);
    }
  return shared;
}
class LayerCursor {
  constructor(layer2, skip, minPoint, rank = 0) {
    this.layer = layer2;
    this.skip = skip;
    this.minPoint = minPoint;
    this.rank = rank;
  }
  get startSide() {
    return this.value ? this.value.startSide : 0;
  }
  get endSide() {
    return this.value ? this.value.endSide : 0;
  }
  goto(pos, side = -1e9) {
    this.chunkIndex = this.rangeIndex = 0;
    this.gotoInner(pos, side, false);
    return this;
  }
  gotoInner(pos, side, forward) {
    while (this.chunkIndex < this.layer.chunk.length) {
      let next = this.layer.chunk[this.chunkIndex];
      if (!(this.skip && this.skip.has(next) || this.layer.chunkEnd(this.chunkIndex) < pos || next.maxPoint < this.minPoint))
        break;
      this.chunkIndex++;
      forward = false;
    }
    if (this.chunkIndex < this.layer.chunk.length) {
      let rangeIndex = this.layer.chunk[this.chunkIndex].findIndex(pos - this.layer.chunkPos[this.chunkIndex], side, true);
      if (!forward || this.rangeIndex < rangeIndex)
        this.setRangeIndex(rangeIndex);
    }
    this.next();
  }
  forward(pos, side) {
    if ((this.to - pos || this.endSide - side) < 0)
      this.gotoInner(pos, side, true);
  }
  next() {
    for (; ; ) {
      if (this.chunkIndex == this.layer.chunk.length) {
        this.from = this.to = 1e9;
        this.value = null;
        break;
      } else {
        let chunkPos = this.layer.chunkPos[this.chunkIndex], chunk = this.layer.chunk[this.chunkIndex];
        let from = chunkPos + chunk.from[this.rangeIndex];
        this.from = from;
        this.to = chunkPos + chunk.to[this.rangeIndex];
        this.value = chunk.value[this.rangeIndex];
        this.setRangeIndex(this.rangeIndex + 1);
        if (this.minPoint < 0 || this.value.point && this.to - this.from >= this.minPoint)
          break;
      }
    }
  }
  setRangeIndex(index2) {
    if (index2 == this.layer.chunk[this.chunkIndex].value.length) {
      this.chunkIndex++;
      if (this.skip) {
        while (this.chunkIndex < this.layer.chunk.length && this.skip.has(this.layer.chunk[this.chunkIndex]))
          this.chunkIndex++;
      }
      this.rangeIndex = 0;
    } else {
      this.rangeIndex = index2;
    }
  }
  nextChunk() {
    this.chunkIndex++;
    this.rangeIndex = 0;
    this.next();
  }
  compare(other) {
    return this.from - other.from || this.startSide - other.startSide || this.rank - other.rank || this.to - other.to || this.endSide - other.endSide;
  }
}
class HeapCursor {
  constructor(heap) {
    this.heap = heap;
  }
  static from(sets, skip = null, minPoint = -1) {
    let heap = [];
    for (let i = 0; i < sets.length; i++) {
      for (let cur = sets[i]; !cur.isEmpty; cur = cur.nextLayer) {
        if (cur.maxPoint >= minPoint)
          heap.push(new LayerCursor(cur, skip, minPoint, i));
      }
    }
    return heap.length == 1 ? heap[0] : new HeapCursor(heap);
  }
  get startSide() {
    return this.value ? this.value.startSide : 0;
  }
  goto(pos, side = -1e9) {
    for (let cur of this.heap)
      cur.goto(pos, side);
    for (let i = this.heap.length >> 1; i >= 0; i--)
      heapBubble(this.heap, i);
    this.next();
    return this;
  }
  forward(pos, side) {
    for (let cur of this.heap)
      cur.forward(pos, side);
    for (let i = this.heap.length >> 1; i >= 0; i--)
      heapBubble(this.heap, i);
    if ((this.to - pos || this.value.endSide - side) < 0)
      this.next();
  }
  next() {
    if (this.heap.length == 0) {
      this.from = this.to = 1e9;
      this.value = null;
      this.rank = -1;
    } else {
      let top2 = this.heap[0];
      this.from = top2.from;
      this.to = top2.to;
      this.value = top2.value;
      this.rank = top2.rank;
      if (top2.value)
        top2.next();
      heapBubble(this.heap, 0);
    }
  }
}
function heapBubble(heap, index2) {
  for (let cur = heap[index2]; ; ) {
    let childIndex = (index2 << 1) + 1;
    if (childIndex >= heap.length)
      break;
    let child2 = heap[childIndex];
    if (childIndex + 1 < heap.length && child2.compare(heap[childIndex + 1]) >= 0) {
      child2 = heap[childIndex + 1];
      childIndex++;
    }
    if (cur.compare(child2) < 0)
      break;
    heap[childIndex] = cur;
    heap[index2] = child2;
    index2 = childIndex;
  }
}
class SpanCursor {
  constructor(sets, skip, minPoint) {
    this.minPoint = minPoint;
    this.active = [];
    this.activeTo = [];
    this.activeRank = [];
    this.minActive = -1;
    this.point = null;
    this.pointFrom = 0;
    this.pointRank = 0;
    this.to = -1e9;
    this.endSide = 0;
    this.openStart = -1;
    this.cursor = HeapCursor.from(sets, skip, minPoint);
  }
  goto(pos, side = -1e9) {
    this.cursor.goto(pos, side);
    this.active.length = this.activeTo.length = this.activeRank.length = 0;
    this.minActive = -1;
    this.to = pos;
    this.endSide = side;
    this.openStart = -1;
    this.next();
    return this;
  }
  forward(pos, side) {
    while (this.minActive > -1 && (this.activeTo[this.minActive] - pos || this.active[this.minActive].endSide - side) < 0)
      this.removeActive(this.minActive);
    this.cursor.forward(pos, side);
  }
  removeActive(index2) {
    remove$1(this.active, index2);
    remove$1(this.activeTo, index2);
    remove$1(this.activeRank, index2);
    this.minActive = findMinIndex(this.active, this.activeTo);
  }
  addActive(trackOpen) {
    let i = 0, { value, to, rank } = this.cursor;
    while (i < this.activeRank.length && (rank - this.activeRank[i] || to - this.activeTo[i]) > 0)
      i++;
    insert(this.active, i, value);
    insert(this.activeTo, i, to);
    insert(this.activeRank, i, rank);
    if (trackOpen)
      insert(trackOpen, i, this.cursor.from);
    this.minActive = findMinIndex(this.active, this.activeTo);
  }
  // After calling this, if `this.point` != null, the next range is a
  // point. Otherwise, it's a regular range, covered by `this.active`.
  next() {
    let from = this.to, wasPoint = this.point;
    this.point = null;
    let trackOpen = this.openStart < 0 ? [] : null;
    for (; ; ) {
      let a = this.minActive;
      if (a > -1 && (this.activeTo[a] - this.cursor.from || this.active[a].endSide - this.cursor.startSide) < 0) {
        if (this.activeTo[a] > from) {
          this.to = this.activeTo[a];
          this.endSide = this.active[a].endSide;
          break;
        }
        this.removeActive(a);
        if (trackOpen)
          remove$1(trackOpen, a);
      } else if (!this.cursor.value) {
        this.to = this.endSide = 1e9;
        break;
      } else if (this.cursor.from > from) {
        this.to = this.cursor.from;
        this.endSide = this.cursor.startSide;
        break;
      } else {
        let nextVal = this.cursor.value;
        if (!nextVal.point) {
          this.addActive(trackOpen);
          this.cursor.next();
        } else if (wasPoint && this.cursor.to == this.to && this.cursor.from < this.cursor.to) {
          this.cursor.next();
        } else {
          this.point = nextVal;
          this.pointFrom = this.cursor.from;
          this.pointRank = this.cursor.rank;
          this.to = this.cursor.to;
          this.endSide = nextVal.endSide;
          this.cursor.next();
          this.forward(this.to, this.endSide);
          break;
        }
      }
    }
    if (trackOpen) {
      this.openStart = 0;
      for (let i = trackOpen.length - 1; i >= 0 && trackOpen[i] < from; i--)
        this.openStart++;
    }
  }
  activeForPoint(to) {
    if (!this.active.length)
      return this.active;
    let active = [];
    for (let i = this.active.length - 1; i >= 0; i--) {
      if (this.activeRank[i] < this.pointRank)
        break;
      if (this.activeTo[i] > to || this.activeTo[i] == to && this.active[i].endSide >= this.point.endSide)
        active.push(this.active[i]);
    }
    return active.reverse();
  }
  openEnd(to) {
    let open = 0;
    for (let i = this.activeTo.length - 1; i >= 0 && this.activeTo[i] > to; i--)
      open++;
    return open;
  }
}
function compare(a, startA, b2, startB, length, comparator) {
  a.goto(startA);
  b2.goto(startB);
  let endB = startB + length;
  let pos = startB, dPos = startB - startA;
  let bounds = !!comparator.boundChange;
  for (let boundChange = false; ; ) {
    let dEnd = a.to + dPos - b2.to, diff = dEnd || a.endSide - b2.endSide;
    let end = diff < 0 ? a.to + dPos : b2.to, clipEnd = Math.min(end, endB);
    let point = a.point || b2.point;
    if (point) {
      if (!(a.point && b2.point && cmpVal(a.point, b2.point) && sameValues(a.activeForPoint(a.to), b2.activeForPoint(b2.to))))
        comparator.comparePoint(pos, clipEnd, a.point, b2.point);
      boundChange = false;
    } else {
      if (boundChange)
        comparator.boundChange(pos);
      if (clipEnd > pos && !sameValues(a.active, b2.active))
        comparator.compareRange(pos, clipEnd, a.active, b2.active);
      if (bounds && clipEnd < endB && (dEnd || a.openEnd(end) != b2.openEnd(end)))
        boundChange = true;
    }
    if (end > endB)
      break;
    pos = end;
    if (diff <= 0)
      a.next();
    if (diff >= 0)
      b2.next();
  }
}
function sameValues(a, b2) {
  if (a.length != b2.length)
    return false;
  for (let i = 0; i < a.length; i++)
    if (a[i] != b2[i] && !cmpVal(a[i], b2[i]))
      return false;
  return true;
}
function remove$1(array2, index2) {
  for (let i = index2, e = array2.length - 1; i < e; i++)
    array2[i] = array2[i + 1];
  array2.pop();
}
function insert(array2, index2, value) {
  for (let i = array2.length - 1; i >= index2; i--)
    array2[i + 1] = array2[i];
  array2[index2] = value;
}
function findMinIndex(value, array2) {
  let found = -1, foundPos = 1e9;
  for (let i = 0; i < array2.length; i++)
    if ((array2[i] - foundPos || value[i].endSide - value[found].endSide) < 0) {
      found = i;
      foundPos = array2[i];
    }
  return found;
}
function countColumn(string2, tabSize, to = string2.length) {
  let n = 0;
  for (let i = 0; i < to && i < string2.length; ) {
    if (string2.charCodeAt(i) == 9) {
      n += tabSize - n % tabSize;
      i++;
    } else {
      n++;
      i = findClusterBreak(string2, i);
    }
  }
  return n;
}
function findColumn(string2, col, tabSize, strict) {
  for (let i = 0, n = 0; ; ) {
    if (n >= col)
      return i;
    if (i == string2.length)
      break;
    n += string2.charCodeAt(i) == 9 ? tabSize - n % tabSize : 1;
    i = findClusterBreak(string2, i);
  }
  return string2.length;
}
const C = "ͼ";
const COUNT = typeof Symbol == "undefined" ? "__" + C : Symbol.for(C);
const SET = typeof Symbol == "undefined" ? "__styleSet" + Math.floor(Math.random() * 1e8) : Symbol("styleSet");
const top = typeof globalThis != "undefined" ? globalThis : typeof window != "undefined" ? window : {};
class StyleModule {
  // :: (Object<Style>, ?{finish: ?(string) → string})
  // Create a style module from the given spec.
  //
  // When `finish` is given, it is called on regular (non-`@`)
  // selectors (after `&` expansion) to compute the final selector.
  constructor(spec, options2) {
    this.rules = [];
    let { finish } = options2 || {};
    function splitSelector(selector2) {
      return /^@/.test(selector2) ? [selector2] : selector2.split(/,\s*/);
    }
    function render2(selectors, spec2, target, isKeyframes) {
      let local = [], isAt = /^@(\w+)\b/.exec(selectors[0]), keyframes = isAt && isAt[1] == "keyframes";
      if (isAt && spec2 == null) return target.push(selectors[0] + ";");
      for (let prop2 in spec2) {
        let value = spec2[prop2];
        if (/&/.test(prop2)) {
          render2(
            prop2.split(/,\s*/).map((part) => selectors.map((sel) => part.replace(/&/, sel))).reduce((a, b2) => a.concat(b2)),
            value,
            target
          );
        } else if (value && typeof value == "object") {
          if (!isAt) throw new RangeError("The value of a property (" + prop2 + ") should be a primitive value.");
          render2(splitSelector(prop2), value, local, keyframes);
        } else if (value != null) {
          local.push(prop2.replace(/_.*/, "").replace(/[A-Z]/g, (l) => "-" + l.toLowerCase()) + ": " + value + ";");
        }
      }
      if (local.length || keyframes) {
        target.push((finish && !isAt && !isKeyframes ? selectors.map(finish) : selectors).join(", ") + " {" + local.join(" ") + "}");
      }
    }
    for (let prop2 in spec) render2(splitSelector(prop2), spec[prop2], this.rules);
  }
  // :: () → string
  // Returns a string containing the module's CSS rules.
  getRules() {
    return this.rules.join("\n");
  }
  // :: () → string
  // Generate a new unique CSS class name.
  static newName() {
    let id2 = top[COUNT] || 1;
    top[COUNT] = id2 + 1;
    return C + id2.toString(36);
  }
  // :: (union<Document, ShadowRoot>, union<[StyleModule], StyleModule>, ?{nonce: ?string})
  //
  // Mount the given set of modules in the given DOM root, which ensures
  // that the CSS rules defined by the module are available in that
  // context.
  //
  // Rules are only added to the document once per root.
  //
  // Rule order will follow the order of the modules, so that rules from
  // modules later in the array take precedence of those from earlier
  // modules. If you call this function multiple times for the same root
  // in a way that changes the order of already mounted modules, the old
  // order will be changed.
  //
  // If a Content Security Policy nonce is provided, it is added to
  // the `<style>` tag generated by the library.
  static mount(root2, modules, options2) {
    let set2 = root2[SET], nonce = options2 && options2.nonce;
    if (!set2) set2 = new StyleSet(root2, nonce);
    else if (nonce) set2.setNonce(nonce);
    set2.mount(Array.isArray(modules) ? modules : [modules], root2);
  }
}
let adoptedSet = /* @__PURE__ */ new Map();
class StyleSet {
  constructor(root2, nonce) {
    let doc2 = root2.ownerDocument || root2, win = doc2.defaultView;
    if (!root2.head && root2.adoptedStyleSheets && win.CSSStyleSheet) {
      let adopted = adoptedSet.get(doc2);
      if (adopted) return root2[SET] = adopted;
      this.sheet = new win.CSSStyleSheet();
      adoptedSet.set(doc2, this);
    } else {
      this.styleTag = doc2.createElement("style");
      if (nonce) this.styleTag.setAttribute("nonce", nonce);
    }
    this.modules = [];
    root2[SET] = this;
  }
  mount(modules, root2) {
    let sheet = this.sheet;
    let pos = 0, j2 = 0;
    for (let i = 0; i < modules.length; i++) {
      let mod = modules[i], index2 = this.modules.indexOf(mod);
      if (index2 < j2 && index2 > -1) {
        this.modules.splice(index2, 1);
        j2--;
        index2 = -1;
      }
      if (index2 == -1) {
        this.modules.splice(j2++, 0, mod);
        if (sheet) for (let k2 = 0; k2 < mod.rules.length; k2++)
          sheet.insertRule(mod.rules[k2], pos++);
      } else {
        while (j2 < index2) pos += this.modules[j2++].rules.length;
        pos += mod.rules.length;
        j2++;
      }
    }
    if (sheet) {
      if (root2.adoptedStyleSheets.indexOf(this.sheet) < 0)
        root2.adoptedStyleSheets = [this.sheet, ...root2.adoptedStyleSheets];
    } else {
      let text2 = "";
      for (let i = 0; i < this.modules.length; i++)
        text2 += this.modules[i].getRules() + "\n";
      this.styleTag.textContent = text2;
      let target = root2.head || root2;
      if (this.styleTag.parentNode != target)
        target.insertBefore(this.styleTag, target.firstChild);
    }
  }
  setNonce(nonce) {
    if (this.styleTag && this.styleTag.getAttribute("nonce") != nonce)
      this.styleTag.setAttribute("nonce", nonce);
  }
}
var base = {
  8: "Backspace",
  9: "Tab",
  10: "Enter",
  12: "NumLock",
  13: "Enter",
  16: "Shift",
  17: "Control",
  18: "Alt",
  20: "CapsLock",
  27: "Escape",
  32: " ",
  33: "PageUp",
  34: "PageDown",
  35: "End",
  36: "Home",
  37: "ArrowLeft",
  38: "ArrowUp",
  39: "ArrowRight",
  40: "ArrowDown",
  44: "PrintScreen",
  45: "Insert",
  46: "Delete",
  59: ";",
  61: "=",
  91: "Meta",
  92: "Meta",
  106: "*",
  107: "+",
  108: ",",
  109: "-",
  110: ".",
  111: "/",
  144: "NumLock",
  145: "ScrollLock",
  160: "Shift",
  161: "Shift",
  162: "Control",
  163: "Control",
  164: "Alt",
  165: "Alt",
  173: "-",
  186: ";",
  187: "=",
  188: ",",
  189: "-",
  190: ".",
  191: "/",
  192: "`",
  219: "[",
  220: "\\",
  221: "]",
  222: "'"
};
var shift = {
  48: ")",
  49: "!",
  50: "@",
  51: "#",
  52: "$",
  53: "%",
  54: "^",
  55: "&",
  56: "*",
  57: "(",
  59: ":",
  61: "+",
  173: "_",
  186: ":",
  187: "+",
  188: "<",
  189: "_",
  190: ">",
  191: "?",
  192: "~",
  219: "{",
  220: "|",
  221: "}",
  222: '"'
};
var mac = typeof navigator != "undefined" && /Mac/.test(navigator.platform);
var ie$1 = typeof navigator != "undefined" && /MSIE \d|Trident\/(?:[7-9]|\d{2,})\..*rv:(\d+)/.exec(navigator.userAgent);
for (var i = 0; i < 10; i++) base[48 + i] = base[96 + i] = String(i);
for (var i = 1; i <= 24; i++) base[i + 111] = "F" + i;
for (var i = 65; i <= 90; i++) {
  base[i] = String.fromCharCode(i + 32);
  shift[i] = String.fromCharCode(i);
}
for (var code in base) if (!shift.hasOwnProperty(code)) shift[code] = base[code];
function keyName(event2) {
  var ignoreKey = mac && event2.metaKey && event2.shiftKey && !event2.ctrlKey && !event2.altKey || ie$1 && event2.shiftKey && event2.key && event2.key.length == 1 || event2.key == "Unidentified";
  var name2 = !ignoreKey && event2.key || (event2.shiftKey ? shift : base)[event2.keyCode] || event2.key || "Unidentified";
  if (name2 == "Esc") name2 = "Escape";
  if (name2 == "Del") name2 = "Delete";
  if (name2 == "Left") name2 = "ArrowLeft";
  if (name2 == "Up") name2 = "ArrowUp";
  if (name2 == "Right") name2 = "ArrowRight";
  if (name2 == "Down") name2 = "ArrowDown";
  return name2;
}
function crelt() {
  var elt = arguments[0];
  if (typeof elt == "string") elt = document.createElement(elt);
  var i = 1, next = arguments[1];
  if (next && typeof next == "object" && next.nodeType == null && !Array.isArray(next)) {
    for (var name2 in next) if (Object.prototype.hasOwnProperty.call(next, name2)) {
      var value = next[name2];
      if (typeof value == "string") elt.setAttribute(name2, value);
      else if (value != null) elt[name2] = value;
    }
    i++;
  }
  for (; i < arguments.length; i++) add$1(elt, arguments[i]);
  return elt;
}
function add$1(elt, child2) {
  if (typeof child2 == "string") {
    elt.appendChild(document.createTextNode(child2));
  } else if (child2 == null) ;
  else if (child2.nodeType != null) {
    elt.appendChild(child2);
  } else if (Array.isArray(child2)) {
    for (var i = 0; i < child2.length; i++) add$1(elt, child2[i]);
  } else {
    throw new RangeError("Unsupported child node: " + child2);
  }
}
let nav = typeof navigator != "undefined" ? navigator : { userAgent: "", vendor: "", platform: "" };
let doc = typeof document != "undefined" ? document : { documentElement: { style: {} } };
const ie_edge = /* @__PURE__ */ /Edge\/(\d+)/.exec(nav.userAgent);
const ie_upto10 = /* @__PURE__ */ /MSIE \d/.test(nav.userAgent);
const ie_11up = /* @__PURE__ */ /Trident\/(?:[7-9]|\d{2,})\..*rv:(\d+)/.exec(nav.userAgent);
const ie = !!(ie_upto10 || ie_11up || ie_edge);
const gecko = !ie && /* @__PURE__ */ /gecko\/(\d+)/i.test(nav.userAgent);
const chrome = !ie && /* @__PURE__ */ /Chrome\/(\d+)/.exec(nav.userAgent);
const webkit = "webkitFontSmoothing" in doc.documentElement.style;
const safari = !ie && /* @__PURE__ */ /Apple Computer/.test(nav.vendor);
const ios = safari && (/* @__PURE__ */ /Mobile\/\w+/.test(nav.userAgent) || nav.maxTouchPoints > 2);
var browser$1 = {
  mac: ios || /* @__PURE__ */ /Mac/.test(nav.platform),
  windows: /* @__PURE__ */ /Win/.test(nav.platform),
  linux: /* @__PURE__ */ /Linux|X11/.test(nav.platform),
  ie,
  ie_version: ie_upto10 ? doc.documentMode || 6 : ie_11up ? +ie_11up[1] : ie_edge ? +ie_edge[1] : 0,
  gecko,
  gecko_version: gecko ? +(/* @__PURE__ */ /Firefox\/(\d+)/.exec(nav.userAgent) || [0, 0])[1] : 0,
  chrome: !!chrome,
  chrome_version: chrome ? +chrome[1] : 0,
  ios,
  android: /* @__PURE__ */ /Android\b/.test(nav.userAgent),
  webkit_version: webkit ? +(/* @__PURE__ */ /\bAppleWebKit\/(\d+)/.exec(nav.userAgent) || [0, 0])[1] : 0,
  safari,
  safari_version: safari ? +(/* @__PURE__ */ /\bVersion\/(\d+(\.\d+)?)/.exec(nav.userAgent) || [0, 0])[1] : 0,
  tabSize: doc.documentElement.style.tabSize != null ? "tab-size" : "-moz-tab-size"
};
function combineAttrs(source2, target) {
  for (let name2 in source2) {
    if (name2 == "class" && target.class)
      target.class += " " + source2.class;
    else if (name2 == "style" && target.style)
      target.style += ";" + source2.style;
    else
      target[name2] = source2[name2];
  }
  return target;
}
const noAttrs = /* @__PURE__ */ Object.create(null);
function attrsEq(a, b2, ignore) {
  if (a == b2)
    return true;
  if (!a)
    a = noAttrs;
  if (!b2)
    b2 = noAttrs;
  let keysA = Object.keys(a), keysB = Object.keys(b2);
  if (keysA.length - 0 != keysB.length - 0)
    return false;
  for (let key2 of keysA) {
    if (key2 != ignore && (keysB.indexOf(key2) == -1 || a[key2] !== b2[key2]))
      return false;
  }
  return true;
}
function setAttrs(dom, attrs) {
  for (let i = dom.attributes.length - 1; i >= 0; i--) {
    let name2 = dom.attributes[i].name;
    if (attrs[name2] == null)
      dom.removeAttribute(name2);
  }
  for (let name2 in attrs) {
    let value = attrs[name2];
    if (name2 == "style")
      dom.style.cssText = value;
    else if (dom.getAttribute(name2) != value)
      dom.setAttribute(name2, value);
  }
}
function updateAttrs(dom, prev, attrs) {
  let changed = false;
  if (prev) {
    for (let name2 in prev)
      if (!(attrs && name2 in attrs)) {
        changed = true;
        if (name2 == "style")
          dom.style.cssText = "";
        else
          dom.removeAttribute(name2);
      }
  }
  if (attrs) {
    for (let name2 in attrs)
      if (!(prev && prev[name2] == attrs[name2])) {
        changed = true;
        if (name2 == "style")
          dom.style.cssText = attrs[name2];
        else
          dom.setAttribute(name2, attrs[name2]);
      }
  }
  return changed;
}
function getAttrs(dom) {
  let attrs = /* @__PURE__ */ Object.create(null);
  for (let i = 0; i < dom.attributes.length; i++) {
    let attr = dom.attributes[i];
    attrs[attr.name] = attr.value;
  }
  return attrs;
}
class WidgetType {
  /**
  Compare this instance to another instance of the same type.
  (TypeScript can't express this, but only instances of the same
  specific class will be passed to this method.) This is used to
  avoid redrawing widgets when they are replaced by a new
  decoration of the same type. The default implementation just
  returns `false`, which will cause new instances of the widget to
  always be redrawn.
  */
  eq(widget) {
    return false;
  }
  /**
  Update a DOM element created by a widget of the same type (but
  different, non-`eq` content) to reflect this widget. May return
  true to indicate that it could update, false to indicate it
  couldn't (in which case the widget will be redrawn). The default
  implementation just returns false.
  */
  updateDOM(dom, view) {
    return false;
  }
  /**
  @internal
  */
  compare(other) {
    return this == other || this.constructor == other.constructor && this.eq(other);
  }
  /**
  The estimated height this widget will have, to be used when
  estimating the height of content that hasn't been drawn. May
  return -1 to indicate you don't know. The default implementation
  returns -1.
  */
  get estimatedHeight() {
    return -1;
  }
  /**
  For inline widgets that are displayed inline (as opposed to
  `inline-block`) and introduce line breaks (through `<br>` tags
  or textual newlines), this must indicate the amount of line
  breaks they introduce. Defaults to 0.
  */
  get lineBreaks() {
    return 0;
  }
  /**
  Can be used to configure which kinds of events inside the widget
  should be ignored by the editor. The default is to ignore all
  events.
  */
  ignoreEvent(event2) {
    return true;
  }
  /**
  Override the way screen coordinates for positions at/in the
  widget are found. `pos` will be the offset into the widget, and
  `side` the side of the position that is being queried—less than
  zero for before, greater than zero for after, and zero for
  directly at that position.
  */
  coordsAt(dom, pos, side) {
    return null;
  }
  /**
  @internal
  */
  get isHidden() {
    return false;
  }
  /**
  @internal
  */
  get editable() {
    return false;
  }
  /**
  This is called when the an instance of the widget is removed
  from the editor view.
  */
  destroy(dom) {
  }
}
var BlockType = /* @__PURE__ */ (function(BlockType2) {
  BlockType2[BlockType2["Text"] = 0] = "Text";
  BlockType2[BlockType2["WidgetBefore"] = 1] = "WidgetBefore";
  BlockType2[BlockType2["WidgetAfter"] = 2] = "WidgetAfter";
  BlockType2[BlockType2["WidgetRange"] = 3] = "WidgetRange";
  return BlockType2;
})(BlockType || (BlockType = {}));
class Decoration extends RangeValue {
  constructor(startSide, endSide, widget, spec) {
    super();
    this.startSide = startSide;
    this.endSide = endSide;
    this.widget = widget;
    this.spec = spec;
  }
  /**
  @internal
  */
  get heightRelevant() {
    return false;
  }
  /**
  Create a mark decoration, which influences the styling of the
  content in its range. Nested mark decorations will cause nested
  DOM elements to be created. Nesting order is determined by
  precedence of the [facet](https://codemirror.net/6/docs/ref/#view.EditorView^decorations), with
  the higher-precedence decorations creating the inner DOM nodes.
  Such elements are split on line boundaries and on the boundaries
  of lower-precedence decorations.
  */
  static mark(spec) {
    return new MarkDecoration(spec);
  }
  /**
  Create a widget decoration, which displays a DOM element at the
  given position.
  */
  static widget(spec) {
    let side = Math.max(-1e4, Math.min(1e4, spec.side || 0)), block2 = !!spec.block;
    side += block2 && !spec.inlineOrder ? side > 0 ? 3e8 : -4e8 : side > 0 ? 1e8 : -1e8;
    return new PointDecoration(spec, side, side, block2, spec.widget || null, false);
  }
  /**
  Create a replace decoration which replaces the given range with
  a widget, or simply hides it.
  */
  static replace(spec) {
    let block2 = !!spec.block, startSide, endSide;
    if (spec.isBlockGap) {
      startSide = -5e8;
      endSide = 4e8;
    } else {
      let { start: start2, end } = getInclusive(spec, block2);
      startSide = (start2 ? block2 ? -3e8 : -1 : 5e8) - 1;
      endSide = (end ? block2 ? 2e8 : 1 : -6e8) + 1;
    }
    return new PointDecoration(spec, startSide, endSide, block2, spec.widget || null, true);
  }
  /**
  Create a line decoration, which can add DOM attributes to the
  line starting at the given position.
  */
  static line(spec) {
    return new LineDecoration(spec);
  }
  /**
  Build a [`DecorationSet`](https://codemirror.net/6/docs/ref/#view.DecorationSet) from the given
  decorated range or ranges. If the ranges aren't already sorted,
  pass `true` for `sort` to make the library sort them for you.
  */
  static set(of, sort = false) {
    return RangeSet.of(of, sort);
  }
  /**
  @internal
  */
  hasHeight() {
    return this.widget ? this.widget.estimatedHeight > -1 : false;
  }
}
Decoration.none = RangeSet.empty;
class MarkDecoration extends Decoration {
  constructor(spec) {
    let { start: start2, end } = getInclusive(spec);
    super(start2 ? -1 : 5e8, end ? 1 : -6e8, null, spec);
    this.tagName = spec.tagName || "span";
    this.attrs = spec.class && spec.attributes ? combineAttrs(spec.attributes, { class: spec.class }) : spec.class ? { class: spec.class } : spec.attributes || noAttrs;
  }
  eq(other) {
    return this == other || other instanceof MarkDecoration && this.tagName == other.tagName && attrsEq(this.attrs, other.attrs);
  }
  range(from, to = from) {
    if (from >= to)
      throw new RangeError("Mark decorations may not be empty");
    return super.range(from, to);
  }
}
MarkDecoration.prototype.point = false;
class LineDecoration extends Decoration {
  constructor(spec) {
    super(-2e8, -2e8, null, spec);
  }
  eq(other) {
    return other instanceof LineDecoration && this.spec.class == other.spec.class && attrsEq(this.spec.attributes, other.spec.attributes);
  }
  range(from, to = from) {
    if (to != from)
      throw new RangeError("Line decoration ranges must be zero-length");
    return super.range(from, to);
  }
}
LineDecoration.prototype.mapMode = MapMode.TrackBefore;
LineDecoration.prototype.point = true;
class PointDecoration extends Decoration {
  constructor(spec, startSide, endSide, block2, widget, isReplace) {
    super(startSide, endSide, widget, spec);
    this.block = block2;
    this.isReplace = isReplace;
    this.mapMode = !block2 ? MapMode.TrackDel : startSide <= 0 ? MapMode.TrackBefore : MapMode.TrackAfter;
  }
  // Only relevant when this.block == true
  get type() {
    return this.startSide != this.endSide ? BlockType.WidgetRange : this.startSide <= 0 ? BlockType.WidgetBefore : BlockType.WidgetAfter;
  }
  get heightRelevant() {
    return this.block || !!this.widget && (this.widget.estimatedHeight >= 5 || this.widget.lineBreaks > 0);
  }
  eq(other) {
    return other instanceof PointDecoration && widgetsEq(this.widget, other.widget) && this.block == other.block && this.startSide == other.startSide && this.endSide == other.endSide;
  }
  range(from, to = from) {
    if (this.isReplace && (from > to || from == to && this.startSide > 0 && this.endSide <= 0))
      throw new RangeError("Invalid range for replacement decoration");
    if (!this.isReplace && to != from)
      throw new RangeError("Widget decorations can only have zero-length ranges");
    return super.range(from, to);
  }
}
PointDecoration.prototype.point = true;
function getInclusive(spec, block2 = false) {
  let { inclusiveStart: start2, inclusiveEnd: end } = spec;
  if (start2 == null)
    start2 = spec.inclusive;
  if (end == null)
    end = spec.inclusive;
  return { start: start2 !== null && start2 !== void 0 ? sta