# FlowDrop UI Agents

This module provides a visual editor for AI Agents using FlowDrop UI and Modeler
API. It enables drag-and-drop design of AI agent workflows with bidirectional
conversion between FlowDrop workflow format and AI Agent configuration entities.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/flowdrop_ui_agents).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/flowdrop_ui_agents).


## Table of contents

- Requirements
- Installation
- Configuration
- Features
- Maintainers


## Requirements

This module requires the following modules:

- **AI** (ai:ai) - Provides core AI functionality for Drupal
- **AI Agents** (ai_agents:ai_agents) - Provides AI agent capabilities
- **Modeler API** (modeler_api:modeler_api) - Provides API for workflow modeling
- **FlowDrop UI** (flowdrop:flowdrop_ui) - Provides the FlowDrop visual editor
  framework


## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).


## Configuration

1. Enable the module at Administration > Extend.
2. Configure AI providers at Administration > Configuration > AI.
3. Create or edit AI Agents to access the FlowDrop visual editor.
4. The editor appears when creating or editing agents with the FlowDrop modeler
   enabled via the Modeler API.

## Features

- **Visual Workflow Editor**: Drag-and-drop interface for AI agent workflows
  using FlowDrop UI components
- **Bidirectional Conversion**: Converts between AI Agent config entities and
  FlowDrop workflow format (nodes/edges)
- **Tool Management**: Visual configuration of tools available to agents from
  function call plugins
- **Agent Configuration**: Configure system prompts, max loops, orchestration,
  and triage settings
- **REST API Endpoints**: Provides API for fetching available tools, agents, and
  node metadata for the editor sidebar
- **Node Positioning**: Saves and restores node positions in the visual editor

## API Endpoints

The module provides REST endpoints for the FlowDrop editor sidebar:

| Endpoint | Purpose |
|----------|---------|
| `GET /api/flowdrop-agents/nodes` | Flat list of all nodes (tools + agents). **Used by sidebar.** |
| `GET /api/flowdrop-agents/nodes/by-category` | Nodes grouped by category |
| `GET /api/flowdrop-agents/nodes/{id}/metadata` | Metadata for a specific node |
| `GET /api/flowdrop-agents/port-config` | Port/connection configuration |
| `GET /api/flowdrop-agents/workflow/{agent_id}` | Workflow data for an agent |
| `POST /api/flowdrop-agents/assistant/{id}/save` | Save assistant workflow |

### Sidebar Data Flow

The FlowDrop sidebar component calls `/api/flowdrop-agents/nodes` (the flat list)
and groups nodes by category client-side. Each node includes:

- `category`: Category name for grouping (e.g., "Sub-Agent Tools", "Entity Tools")
- `categoryWeight`: Sort weight for category ordering (lower = first)

Category weights:
- `-100`: Agents (Sub-Agent Tools)
- `-90`: Chatbots
- `-80`: Search/RAG tools
- `0`: Standard tools (default)
- `100`: Other/uncategorized

## Known Issues

### Sidebar Category Ordering

The `categoryWeight` feature requires a patch to FlowDrop UI. Without the patch,
the sidebar will sort categories alphabetically instead of by weight.

**Status**: Patch submitted upstream to FlowDrop
([#XXXXXXX](https://www.drupal.org/project/flowdrop/issues/XXXXXXX)).

**Workaround**: Apply the patch from `patches/flowdrop/category-weight-sorting.patch`:

```bash
cd web/modules/contrib/flowdrop
patch -p1 < /path/to/flowdrop_ui_agents/patches/flowdrop/category-weight-sorting.patch
```

Or add to your project's `composer.json` using
[cweagans/composer-patches](https://github.com/cweagans/composer-patches):

```json
{
    "extra": {
        "patches": {
            "drupal/flowdrop": {
                "Category weight sorting": "https://www.drupal.org/files/issues/XXXX-flowdrop-category-weight.patch"
            }
        }
    }
}
```

Once FlowDrop merges this upstream, the patch will no longer be needed.


## Maintainers

- David Galeano - [gxleano](https://www.drupal.org/u/gxleano)
- James Abrahams - [yautja_cetanu](https://www.drupal.org/u/yautja_cetanu)
