# Patches

This directory contains patches for dependencies that are required for full
functionality but have not yet been merged upstream.

## flowdrop/category-weight-sorting.patch

**Affects**: drupal/flowdrop
**Status**: Pending upstream merge

### What it does

Enables the FlowDrop sidebar to sort categories by `categoryWeight` instead of
alphabetically. This allows "Sub-Agent Tools" to appear first in the sidebar.

### How to apply

#### Option 1: Manual patch

```bash
cd web/modules/contrib/flowdrop
patch -p1 < /path/to/flowdrop_ui_agents/patches/flowdrop/category-weight-sorting.patch
```

#### Option 2: Composer patches

Add to your project's `composer.json`:

```json
{
    "extra": {
        "patches": {
            "drupal/flowdrop": {
                "Category weight sorting for sidebar": "web/modules/contrib/flowdrop_ui_agents/patches/flowdrop/category-weight-sorting.patch"
            }
        }
    }
}
```

Then run `composer install`.

### When to remove

Once FlowDrop merges this feature upstream (see issue link in module README),
update FlowDrop and remove the patch.
