<?php

declare(strict_types=1);

namespace Drupal\flowdrop_ui_agents\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Path\CurrentPathStack;

/**
 * Page attachment hooks for FlowDrop UI Agents.
 */
class PageAttachments {

  /**
   * Constructs the PageAttachments hook handler.
   *
   * @param \Drupal\Core\Path\CurrentPathStack $currentPath
   *   The current path service.
   */
  public function __construct(
    protected CurrentPathStack $currentPath,
  ) {
  }

  /**
   * Implements hook_page_attachments().
   *
   * Attaches the messages library to display stored success messages
   * on AI agent and assistant admin pages.
   *
   * @param array<string, mixed> $attachments
   *   The page attachments array.
   */
  #[Hook('page_attachments')]
  public function pageAttachments(array &$attachments): void {
    $currentPath = $this->currentPath->getPath();

    // Attach on all AI agents and AI assistant admin pages.
    if (str_starts_with($currentPath, '/admin/config/ai/agents') ||
        str_starts_with($currentPath, '/admin/config/ai/ai-assistant')) {
      $attachments['#attached']['library'][] = 'flowdrop_ui_agents/messages';
    }
  }

}
