<?php

declare(strict_types=1);

namespace Drupal\flowdrop_ui_agents;

/**
 * Defines constants for FlowDrop node types.
 *
 * These constants are used throughout the module to identify different
 * node types in FlowDrop workflows. Using constants ensures consistency
 * and makes refactoring easier.
 */
final class NodeType {

  /**
   * Agent node type - represents an AI Agent.
   */
  public const AGENT = 'agent';

  /**
   * Collapsed agent node type - a sub-agent shown as a single node.
   */
  public const AGENT_COLLAPSED = 'agent-collapsed';

  /**
   * Tool node type - represents a tool/function call.
   */
  public const TOOL = 'tool';

  /**
   * Assistant node type - represents an AI Assistant.
   */
  public const ASSISTANT = 'assistant';

  /**
   * Chatbot node type - represents a DeepChat chatbot block.
   */
  public const CHATBOT = 'chatbot';

  /**
   * Group node type - a visual container for grouping nodes.
   */
  public const GROUP = 'group';

  /**
   * Universal node type - the React Flow node component type.
   */
  public const UNIVERSAL_NODE = 'universalNode';

  /**
   * Unknown node type - fallback for unrecognized types.
   */
  public const UNKNOWN = 'unknown';

}
