<?php

declare(strict_types=1);

namespace Drupal\Tests\flowdrop_ui_agents\Kernel;

use Drupal\modeler_api\Api;
use PHPUnit\Framework\Attributes\Group;

/**
 * Tests WorkflowParser save behavior for tool overrides.
 */
#[Group('flowdrop_ui_agents')]
final class WorkflowParserTest extends FlowdropAgentsTestBase {

  /**
   * Ensures property_description_override is emitted on save.
   */
  public function testToolPropertyDescriptionOverrideIsSaved(): void {
    /** @var \Drupal\Component\Plugin\PluginManagerInterface $ownerManager */
    $ownerManager = $this->container->get('plugin.manager.modeler_api.model_owner');
    /** @var \Drupal\modeler_api\Plugin\ModelerApiModelOwner\ModelOwnerInterface $owner */
    $owner = $ownerManager->createInstance('ai_agents_agent');

    $parser = $this->container->get('flowdrop_ui_agents.workflow_parser');
    $parser->setOwner($owner);

    $workflowData = $this->buildWorkflowData(
      nodes: [
        $this->createAgentNode('legacy_override_agent'),
        [
          'id' => 'tool_node_override',
          'type' => 'tool',
          'position' => ['x' => 200, 'y' => 100],
          'data' => [
            'nodeType' => 'tool',
            'toolId' => 'ai_agent:get_content_type_info',
            'config' => [
              'tool_id' => 'ai_agent:get_content_type_info',
              'prop_node_type_restriction' => 'Only allow certain values',
              'prop_node_type_values' => 'node',
              'prop_node_type_override_desc_enabled' => TRUE,
              'prop_node_type_override_desc' => 'cheese2',
            ],
            'metadata' => [
              'tool_id' => 'ai_agent:get_content_type_info',
            ],
          ],
        ],
      ],
      edges: [
        $this->createEdge('agent_legacy_override_agent', 'tool_node_override'),
      ],
      metadata: []
    );

    $workflowData['id'] = 'legacy_override_agent';

    $components = $parser->toComponents($workflowData);
    $toolComponent = NULL;
    foreach ($components as $component) {
      if ($component->getType() !== Api::COMPONENT_TYPE_ELEMENT) {
        continue;
      }
      if ($component->getPluginId() === 'ai_agent:get_content_type_info') {
        $toolComponent = $component;
        break;
      }
    }

    $this->assertNotNull($toolComponent, 'Expected tool component for get_content_type_info.');
    $config = $toolComponent->getConfiguration();
    $this->assertArrayHasKey('property_description_override', $config);
    $this->assertSame('cheese2', $config['property_description_override']['node_type'] ?? '');
  }

}
