# Fluid UI - Infusion

Updated: **02/16/2024**

This module integrates the [fluidproject.org Infusion](https://fluidproject.org/infusion) accessibility framework,
which allows visitors to customize site appearance, including font size, line
height, site contrast, generate a table of contents from the `<h1>-<h6>` tags, and
underlining and bolding links.

The module adds a "+ show display preferences" tab to the top right of the page,
which toggles the UI Options. The framework uses cookies to save user
preferences.

The module includes a precompiled framework JS file from the source but you can
compile a new file using the [source code](https://github.com/fluid-project/infusion)

For a full description of the module, visit the
[project page](https://www.drupal.org/project/fluidui).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/fluidui).

## About the new D10/D11 Module (02/16/2026)

A lot of things changed in the [Infusion Library](https://github.com/fluid-project/infusion), it doesn't use Grunt (of course) to compile the library, now it uses [NPM](https://www.npmjs.com/package/infusion) to download and compile the library, below I'll list the updated instructions for compiling your version of the infusion library if you want, although the module has a freshly-compiled infusion library for you

## Table of contents

- Requirements
- Installation
- Configuration
- Customization
- Running PHPUnit Functional / FunctionalJavascript tests

## Requirements

This module requires the following library:

[FluidUI Infusion Library](https://github.com/fluid-project/infusion) 


## Installation

- Download the [source code](https://github.com/fluid-project/infusion) 

- From the project root directory, run:

  `npm install`

  For installing/updating the project dependencies

- Also from the project root directory, run:

  `npm run build:pkg:custom  -- --exclude=jquery --include="fluid-ui-options"`

  For building the **fluid-ui-options"** package from the source files

  - On the "/libraries" directory from your site's document root (probably /web), create the "infusion" directory.

  - Copy "build/src/" from the project root directory to your Drupal **/libraries/infusion** directory (it should have these directories inside: **components, framework, lib, module**).

  - In the infusion directory, copy all the files *.js and *.map files from the dist/ project root directory to your Drupal
    **web/libraries/infusion/** directory, it should have these files:
    - infusion-all.js
    - infusion-all.js.map
    - infusion-all-no-jquery.js
    - infusion-all-no-jquery.js.map
    - infusion-framework.js
    - infusion-framework.js.map
    - ...
We use **infusion-all-no-jquery.js** in our project but can experiment with the other javascript files and see if there huge changes performance-wise.

Then install the module as usual with composer:

`composer require 'drupal/fluidui:^2.0'`

## Configuration

Once installed, the widget will appear in the top bar of your page, but can control where to put the widget as a block by going to **/admin/config/fluidui/**adminsettings and check the option **Enable the FluidUI widget as a Block**, check this option if you want to enable the FluidUI widget as a Block to be placed everywhere instead of being fixed in the page top.
You can control the list of pages where the toolbox will not be displayed and also if you
want the toolbox to be displayed on admin pages (such as /admin/content, /admin/structure, etc.).
The configuration form is found on **/admin/config/fluidui/adminsettings**

Don't forget to clear cache after enabling the widget as a block.

## Customization

- Style customization
  Use the module's **css/fluid.css** file to customize the appearance and placement
  of the "+ show display preferences" tab.

## Multilingual support
  
Given that the infusion [https://docs.fluidproject.org/infusion/development/LocalizationInThePreferencesFramework#specifying-a-localization](documentation) is somewhat crappy that lacks real examples, I couldn't figure it out how to read the correct json files for each language (For example, `prefsEditor_es.json`), you will need to follow these manual steps but the advantage is that you won't lose translations after module upgrades:

1. In your `sites/default/files` create the directory `fluidui-translations`
2. In the the module directory, go to messages, copy a language directory (`es` for example) to the newly created directory in the step above.
3. You will find a few files with `es` in their filename, for example:

`letterSpace_es.json captions_es.json`

Change these files and replace `es` with the language code that Drupal assigns for each language (For example, `de` for german)

4. Apply the desired translations in each of these new language files as needed.

5. For each new language file, replace the `en` and the file without language extension with the new language example, for example:

`$ cp contrast_es.json contrast_en.json`
`$ cp contrast_es.json contrast.json`

I am sorry for this annoying step, but the official docs are ultra crap and I couldn't figure it out any good out of it.

## Running PHPUnit Functional / FunctionalJavascript tests

If you want to run the module tests (located at the directory `tests/src`), don't forget to set up PHPUnit to work in your local environment (DDEV / Lando), [https://www.drupal.org/docs/develop/automated-testing/phpunit-in-drupal/running-phpunit-tests](please follow these instructions) to configure PHPUnit in your local environment, I am using DDEV, so [https://www.drupal.org/docs/develop/automated-testing/phpunit-in-drupal/running-phpunit-tests#s-example-values-for-ddev](you might need to do) some additional configuration in the `phpunit.xml` file.

If you want to run the FunctionalJavascript tests, [https://www.drupal.org/docs/develop/automated-testing/phpunit-in-drupal/running-phpunit-javascript-tests](please follow these instructions) to set up [https://github.com/ddev/ddev-selenium-standalone-chrome](ddev selenium standalone chrome), once you have PHPUnit up and working, you can run the tests:

 ```
daniel@wweb:/var/www/html$ ./vendor/bin/phpunit -c html/core/phpunit.xml ./html/modules/contrib/fluidui/tests/src/Functional
Functional/           FunctionalJavascript/ 
daniel@wxt61x-web:/var/www/html$ ./vendor/bin/phpunit -c html/core/phpunit.xml ./html/modules/contrib/fluidui/tests/src/Functional/FluidUIAdminPagesTest.php 
PHPUnit 10.5.45 by Sebastian Bergmann and contributors.

Runtime:       PHP 8.3.14
Configuration: /var/www/html/html/core/phpunit.xml

..                                                                  2 / 2 (100%)

HTML output was generated.
http://wxt61x.ddev.site/sites/simpletest/browser_output/Drupal_Tests_fluidui_Functional_FluidUIAdminPagesTest-1-39871407.html
http://wxt61x.ddev.site/sites/simpletest/browser_output/Drupal_Tests_fluidui_Functional_FluidUIAdminPagesTest-2-39871407.html
http://wxt61x.ddev.site/sites/simpletest/browser_output/Drupal_Tests_fluidui_Functional_FluidUIAdminPagesTest-3-39871407.html
http://wxt61x.ddev.site/sites/simpletest/browser_output/Drupal_Tests_fluidui_Functional_FluidUIAdminPagesTest-4-39871407.html
http://wxt61x.ddev.site/sites/simpletest/browser_output/Drupal_Tests_fluidui_Functional_FluidUIAdminPagesTest-5-86002840.html
http://wxt61x.ddev.site/sites/simpletest/browser_output/Drupal_Tests_fluidui_Functional_FluidUIAdminPagesTest-6-86002840.html
http://wxt61x.ddev.site/sites/simpletest/browser_output/Drupal_Tests_fluidui_Functional_FluidUIAdminPagesTest-7-86002840.html
http://wxt61x.ddev.site/sites/simpletest/browser_output/Drupal_Tests_fluidui_Functional_FluidUIAdminPagesTest-8-86002840.html
http://wxt61x.ddev.site/sites/simpletest/browser_output/Drupal_Tests_fluidui_Functional_FluidUIAdminPagesTest-9-86002840.html


Time: 00:11.371, Memory: 6.00 MB

OK (2 tests, 8 assertions)
 ```
 
 All the Functional tests passed, you can open in your browser any of these URLs to see the results of the test

 ### Running FunctionalJavascript tests

 The procedure to run the Javascript tests is the same, provided that you followed the steps below:

 ```
 daniel@wxt61x-web:/var/www/html$ ./vendor/bin/phpunit -c html/core/phpunit.xml ./html/modules/contrib/fluidui/tests/src/FunctionalJavascript/FluidUIDisplayWidgetTest.php
PHPUnit 10.5.45 by Sebastian Bergmann and contributors.

Runtime:       PHP 8.3.14
Configuration: /var/www/html/html/core/phpunit.xml

..                                                                  2 / 2 (100%)

HTML output was generated.
http://wxt61x.ddev.site/sites/simpletest/browser_output/Drupal_Tests_fluidui_FunctionalJavascript_FluidUIDisplayWidgetTest-45-48249400.html
http://wxt61x.ddev.site/sites/simpletest/browser_output/Drupal_Tests_fluidui_FunctionalJavascript_FluidUIDisplayWidgetTest-46-48249400.html
http://wxt61x.ddev.site/sites/simpletest/browser_output/Drupal_Tests_fluidui_FunctionalJavascript_FluidUIDisplayWidgetTest-47-63378143.html
http://wxt61x.ddev.site/sites/simpletest/browser_output/Drupal_Tests_fluidui_FunctionalJavascript_FluidUIDisplayWidgetTest-48-63378143.html
http://wxt61x.ddev.site/sites/simpletest/browser_output/Drupal_Tests_fluidui_FunctionalJavascript_FluidUIDisplayWidgetTest-49-63378143.html
http://wxt61x.ddev.site/sites/simpletest/browser_output/Drupal_Tests_fluidui_FunctionalJavascript_FluidUIDisplayWidgetTest-50-63378143.html


Time: 00:23.316, Memory: 6.00 MB

OK (2 tests, 14 assertions)

 ```
 
