let renderCounter = 0;

(function ($, Drupal, once) {
  Drupal.behaviors.fluid = {
    attach:(context) => {
      if (!renderCounter) {
        const modulePath = drupalSettings.modulePath;

        const langCode = drupalSettings.path.currentLanguage;

        const translationsDir = drupalSettings.translationsDirectory;

        if (translationsDir !== "") {
          fluid.uiOptions(".flc-prefsEditor-separatedPanel", {
            auxiliarySchema: {
              terms: {
                "templatePrefix": modulePath + "/infusion/src/framework/preferences/html",
                "messagePrefix": translationsDir + langCode,
              },
              "fluid.prefs.tableOfContents": {
                enactor: {
                  "tocTemplate": modulePath + "/infusion/src/components/tableOfContents/html/TableOfContents.html",
                  "tocMessage": modulePath + "/infusion/src/framework/preferences/messages/tableOfContents-enactor.json",
                  ignoreForToC: {
                    "overviewPanel": ".flc-overviewPanel"
                  }
                }
              }
            },
            prefsEditorLoader: {
              lazyLoad: true
            }
          });
        } else {
          fluid.uiOptions(".flc-prefsEditor-separatedPanel", {
            auxiliarySchema: {
              terms: {
                "templatePrefix": modulePath + "/infusion/src/framework/preferences/html",
                "messagePrefix": modulePath + "/infusion/src/framework/preferences/messages/" + langCode,
              },
              "fluid.prefs.tableOfContents": {
                enactor: {
                  "tocTemplate": modulePath + "/infusion/src/components/tableOfContents/html/TableOfContents.html",
                  "tocMessage": modulePath + "/infusion/src/framework/preferences/messages/tableOfContents-enactor.json",
                  ignoreForToC: {
                    "overviewPanel": ".flc-overviewPanel"
                  }
                }
              }
            },
            prefsEditorLoader: {
              lazyLoad: true
            }
          });
        }

        renderCounter++;
      }
    },
  }
})(jQuery, Drupal, once);
