<?php

namespace Drupal\fluidui\Plugin\Block;

use Drupal\Core\Block\BlockBase;
use Drupal\Core\Cache\Cache;

/**
 * Provides a 'FluidUI' Block.
 *
 * @Block(
 *   id = "fluidui_block",
 *   admin_label = @Translation("FluidUI Block")
 * )
 */
class FluidUIBlock extends BlockBase {

  /**
   * {@inheritdoc}
   */
  public function build() {
    return [
      '#theme' => 'fluid_ui_block',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getCacheContexts() {
    return Cache::mergeContexts(parent::getCacheContexts(), ['ip']);
  }

  /**
   * {@inheritdoc}
   */
  public function getCacheTags() {
    return Cache::mergeTags(parent::getCacheTags(), ["node_list"]);
  }

}
