<?php

namespace Drupal\Tests\flysystem\Unit\Plugin;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\Routing\UrlGenerator;
use Drupal\flysystem\Plugin\FlysystemUrlTrait;
use Drupal\Tests\UnitTestCase;

/**
 * @coversDefaultClass \Drupal\flysystem\Plugin\FlysystemUrlTrait
 * @group flysystem
 */
class FlysystemUrlTraitTest extends UnitTestCase {

  // @codingStandardsIgnoreStart
  /**
   * Create an anonymous class for the provided trait.
   *
   * @param trait-string $traitName Name of the trait to create a mock for.
   */
  public function createMockForTrait(string $traitName) {
    return eval('return new class { use ' . $traitName . '; };');
  }
  // @codingStandardsIgnoreEnd

  /**
   * @covers ::getExternalUrl
   * @covers ::getScheme
   * @covers ::getTarget
   */
  public function testGetExternalUrl() {
    $trait = $this->createMockForTrait(FlysystemUrlTrait::class);

    $url_generator = $this->prophesize(UrlGenerator::class);
    $url_generator->generateFromRoute(
      'flysystem.serve',
      ['scheme' => 'test_scheme', 'filepath' => 'dir/file.txt'],
      ['absolute' => TRUE],
      FALSE)
      ->willReturn('download');

    $container = new ContainerBuilder();
    $container->set('url_generator', $url_generator->reveal());

    \Drupal::setContainer($container);

    $this->assertSame('download', $trait->getExternalUrl('test_scheme://dir\file.txt'));
  }

}
