<?php

namespace Drupal\Tests\flysystem\Unit;

use Drupal\Core\Site\Settings;
use Drupal\flysystem\FlysystemFactory;
use Drupal\Tests\UnitTestCase;
use Symfony\Component\DependencyInjection\ContainerBuilder;

/**
 * Tests flysystem.install functions.
 *
 * @group flysystem
 */
class InstallFunctionsTest extends UnitTestCase {

  /**
   * The Flysystem factory prophecy object.
   *
   * @var \Prophecy\Prophecy\ObjectProphecy
   */
  protected $factory;

  /**
   * {@inheritdoc}
   */
  public function setUp(): void {
    parent::setUp();

    if (!defined('REQUIREMENT_ERROR')) {
      define('REQUIREMENT_ERROR', 2);
    }

    require_once dirname(dirname(dirname(__DIR__))) . '/flysystem.install';

    $this->factory = $this->prophesize(FlysystemFactory::class);

    $container = new ContainerBuilder();
    $container->set('flysystem_factory', $this->factory->reveal());
    $container->set('string_translation', $this->getStringTranslationStub());

    \Drupal::setContainer($container);
  }

  /**
   * Tests flysystem_requirements() detects invalid schemes.
   */
  public function testFlysystemRequirementsHandlesInvalidSchemes() {
    new Settings(['flysystem' => ['test_scheme' => []]]);
    $requirements = flysystem_requirements('update');

    $this->assertTrue(isset($requirements['flysystem_invalid_scheme']));
  }

  /**
   * Tests flysystem_install() calls ensure().
   */
  public function testFlysystemInstallCallsEnsure() {
    $this->factory->ensure()->shouldBeCalled();
    flysystem_install();
  }

}
