<?php

namespace Drupal\Tests\flysystem\Unit\PathProcessor;

use Drupal\Core\Site\Settings;
use Drupal\flysystem\PathProcessor\LocalPathProcessor;
use Drupal\Tests\UnitTestCase;
use Symfony\Component\HttpFoundation\Request;

/**
 * @coversDefaultClass \Drupal\flysystem\PathProcessor\LocalPathProcessor
 * @group flysystem
 */
class LocalPathProcessorTest extends UnitTestCase {

  /**
   * Inbound Path processor.
   *
   * @var \Drupal\Core\PathProcessor\InboundPathProcessorInterface
   */
  protected $processor;

  /**
   * {@inheritdoc}
   */
  public function setUp(): void {
    parent::setUp();
    new Settings(
      [
        'flysystem' => [
          'test_scheme' => [
            'driver' => 'local',
            'config' => ['root' => 'sites/default/files/flysystem'],
          ],
        ],
      ]);
    $this->processor = new LocalPathProcessor('test_scheme');
  }

  /**
   * @covers ::processInbound
   * @covers ::__construct
   */
  public function testProcessInboundIgnoresInvalidPaths() {
    $this->assertSame('beep', $this->processor->processInbound('beep', new Request()));
  }

  /**
   * @covers ::processInbound
   */
  public function testProcessInboundHandlesImageStyles() {
    $request = new Request();

    $this->assertSame('/sites/default/files/flysystem/styles/test_scheme/small', $this->processor->processInbound('/sites/default/files/flysystem/styles/test_scheme/small/image.jpg', $request));
    $this->assertSame($request->query->get('file'), 'image.jpg');

    $this->assertSame('/sites/default/files/flysystem/styles/test_scheme/small', $this->processor->processInbound('/sites/default/files/flysystem/styles/test_scheme/small/dir/image.jpg', $request));
    $this->assertSame($request->query->get('file'), 'dir/image.jpg');
  }

  /**
   * @covers ::processInbound
   */
  public function testProcessInboundHandlesSystemDownload() {
    $request = new Request();

    $this->assertSame('/sites/default/files/flysystem', $this->processor->processInbound('/sites/default/files/flysystem/file.txt', $request));
    $this->assertSame('file.txt', $request->query->get('file'));

    $this->assertSame('/sites/default/files/flysystem', $this->processor->processInbound('/sites/default/files/flysystem/a/b/c/file.txt', $request));
    $this->assertSame('a/b/c/file.txt', $request->query->get('file'));
  }

}
