<?php

/**
 * Implements hook_views_data_alter().
 */
function fmm_views_edit_link_views_data_alter(array &$data) {
  // Add the form mode edit link field to all entity types
  foreach ($data as $table_name => $table_data) {
    if (isset($table_data['table']['entity type'])) {
      $entity_type = $table_data['table']['entity type'];

      $data[$table_name]['form_mode_edit_link'] = [
        'title' => t('Link to edit with form mode'),
        'help' => t('Provide a link to edit the entity using a specific form mode.'),
        'field' => [
          'id' => 'form_mode_edit_link',
        ],
        'real field' => $table_data['table']['base']['field'] ?? 'id',
      ];
    }
  }
}
