<?php

namespace Drupal\fontawesome_ui\Constants;

/**
 * Defines constants for the FontAwesome UI module.
 */
class FontAwesomeConstants {
  /**
   * The latest version of Font Awesome.
   */
  const LATEST_VERSION = '7.0.0';

  /**
   * The Font Awesome download url.
   */
  const DOWNLOAD_LINK = 'https://use.fontawesome.com/releases/v7.0.0/fontawesome-free-7.0.0-web.zip';

  /**
   * Supported major versions.
   */
  const SUPPORTED_VERSIONS = [
    5 => '5.x',
    6 => '6.x',
    7 => '7.x',
  ];

  /**
   * Valid license types.
   */
  const VALID_LICENSES = [
    'free' => 'Free',
    'pro' => 'Professional',
  ];

}
