## INTRODUCTION

**Form Messages** provides a new form element type (`#type = form_messages`) that allows developers to display inline messages (status, warning, error) directly inside forms.

This is useful when you want to provide form-specific guidance, warnings, or errors without relying on Drupal’s global messenger service.

## REQUIREMENTS

No specific requirements.

## INSTALLATION

Install as you would normally install a contributed Drupal module.
See: https://www.drupal.org/node/895232 for further information.

## USAGE
To use the Form Messages element in your form, add it to your form array like this:

```php
$form['warnings'] = [
  '#type' => 'form_messages',
  '#message_type' => 'warning',
  '#messages' => [
    t('First warning message.'),
    t('Second warning message.'),
  ],
];

$form['info'] = [
  '#type' => 'form_messages',
  '#message_type' => 'status',
  '#messages' => [
    t('Your profile is 80% complete.'),
  ],
];
```

## MAINTAINERS

Current maintainers:

- Azz-eddine BERRAMOU (berramou) - https://www.drupal.org/u/berramou
