<?php

namespace Drupal\form_messages\Element;

use Drupal\Core\Messenger\MessengerInterface;
use Drupal\Core\Render\Attribute\FormElement;
use Drupal\Core\Render\Element\FormElementBase;

/**
 * Provides a 'form_messages' form element.
 *
 * Usage example:
 *
 * @code
 * $form['warnings'] = [
 *   '#type' => 'form_messages',
 *   '#message_type' => 'warning',
 *   '#messages' => [
 *     t('First warning'),
 *     t('Second warning'),
 *   ],
 * ];
 * @endcode
 */
#[FormElement('form_messages')]
class FormMessages extends FormElementBase {

  /**
   * {@inheritdoc}
   */
  public function getInfo(): array {
    return [
      '#input' => FALSE,
    // 'status', 'warning', 'error'
      '#message_type' => MessengerInterface::TYPE_STATUS,
      '#messages' => [],
      '#pre_render' => [
        [static::class, 'preRenderMessages'],
      ],
    ];
  }

  /**
   * Pre-render callback.
   */
  public static function preRenderMessages(array $element): array {
    $message_type = $element['#message_type'] ?? MessengerInterface::TYPE_STATUS;
    $messages = $element['#messages'] ?? [];

    // Wrap in the array format expected by status_messages theme.
    $message_list = [
      $message_type => $messages,
    ];

    return [
      '#theme' => 'status_messages',
      '#message_list' => $message_list,
      '#status_headings' => [
        'status' => t('Status message'),
        'warning' => t('Warning message'),
        'error' => t('Error message'),
      ],
    ];
  }

}
