<?php

namespace Drupal\formatage_models\Plugin\Layout\Sections;

use Drupal\bootstrap_styles\StylesGroup\StylesGroupManager;
use Drupal\formatage_models\FormatageModelsThemes;

/**
 * A very advanced custom layout.
 *
 * @Layout(
 *   id = "formatage_models_hero_saint_gobain",
 *   label = @Translation(" Hero saint gobain "),
 *   category = @Translation(" Formatage Models"),
 *   path = "layouts/sections",
 *   template = "formatage-models-hero-saint-gobain",
 *   library = "formatage_models/formatage-models-hero-saint-gobain",
 *   default_region = "description",
 *   regions = {
 *     "button" = {
 *       "label" = @Translation("button "),
 *     },
 *     "title" = {
 *       "label" = @Translation("title")
 *     },
 *     "subtitle" = {
 *       "label" = @Translation("Sous title")
 *     },
 *     "description" = {
 *       "label" = @Translation("Description")
 *     },
 *     "imagebg" = {
 *       "label" = @Translation(" Image bg right "),
 *     },
 *     "imagebg2" = {
 *       "label" = @Translation(" Image bg left "),
 *     },
 *   }
 * )
 */
class FormatageModelsHeroSaintGobain extends FormatageModelsSection {

  /**
   *
   * {@inheritdoc}
   * @see \Drupal\formatage_models\Plugin\Layout\FormatageModels::__construct()
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition, StylesGroupManager $styles_group_manager) {
    // TODO Auto-generated method stub
    parent::__construct($configuration, $plugin_id, $plugin_definition, $styles_group_manager);
    $this->pluginDefinition->set('icon', $this->pathResolver->getPath('module', 'formatage_models') . "/icones/sections/formatage-models-hero-saint-gobain.png");
  }

  /**
   *
   * {@inheritdoc}
   * @see \Drupal\formatage_models\Plugin\Layout\FormatageModels::build()
   */
  public function build(array $regions) {
    // TODO Auto-generated method stub
    $build = parent::build($regions);
    FormatageModelsThemes::formatSettingValues($build);
    return $build;
  }

  function defaultConfiguration() {
    return [
      'load_libray' => false,
      "derivate" => [
        'value' => 'simple',
        'options' => [
          'simple' => 'simple',
          'cover-bg' => 'Cover background'
        ]
      ],
      'infos' => [
        'builder-form' => true,
        'info' => [
          'title' => 'Texte information',
          'loader' => 'static'
        ],
        'fields' => [
          'title' => [
            'text_html' => [
              'value' => " Votre site internet clé en main en seulement 7 jours ",
              'label' => ' Titre '
            ]
          ],
          'subtitle' => [
            'text_html' => [
              'value' => " Sans engagement / Vous n'avez rien à faire ",
              'label' => ' Sous titre '
            ]
          ],
          'button' => [
            'url' => [
              'label' => "button",
              "value" => [
                "link" => "#",
                "text" => "Ça m'intéresse",
                "class" => "btn d-block btn-primary"
              ]
            ]
          ],
          'imagebg' => [
            'img_bg' => [
              'label' => " Image Bg right",
              'fids' => []
            ]
          ],
          'imagebg2' => [
            'img_bg' => [
              'label' => " Image Bg left",
              'fids' => []
            ]
          ],
          'description' => [
            'text_html' => [
              'label' => 'Titre',
              'value' => '
                  <div class="grille-bloc">
                        <span class="grille-bloc__svg">
                              <svg width="41" height="42" viewBox="0 0 42 40" fill="none">
                                    <path d="M38.5613 6H3.43871C2.09247 6 1 7.09247 1 8.43871V31.1312C1 32.4774 2.09247 33.5699 3.43871 33.5699H38.5613C39.9075 33.5699 41 32.4774 41 31.1312V8.43871C41 7.09247 39.9075 6 38.5613 6ZM2.29032 8.43871C2.29032 7.80645 2.80645 7.29032 3.43871 7.29032H38.5613C39.1935 7.29032 39.7097 7.80645 39.7097 8.43871V11.0624H2.29032V8.43871ZM39.7097 31.1312C39.7097 31.7634 39.1935 32.2796 38.5613 32.2796H3.43871C2.80645 32.2796 2.29032 31.7634 2.29032 31.1312V12.3527H39.7097V31.1312Z" stroke-width="0.5"></path>
                                    <path d="M4.69466 8.58496C4.34628 8.58496 4.05811 8.87313 4.05811 9.22152C4.05811 9.56991 4.34628 9.85808 4.69466 9.85808C5.04305 9.85808 5.33122 9.56991 5.33122 9.22152C5.33122 8.86883 5.04735 8.58496 4.69466 8.58496Z" stroke-width="0.5"></path>
                                    <path d="M6.98275 9.85808C7.33431 9.85808 7.61931 9.57308 7.61931 9.22152C7.61931 8.86996 7.33431 8.58496 6.98275 8.58496C6.63119 8.58496 6.34619 8.86996 6.34619 9.22152C6.34619 9.57308 6.63119 9.85808 6.98275 9.85808Z" stroke-width="0.5"></path>
                                    <path d="M9.26693 9.85808C9.61849 9.85808 9.90349 9.57308 9.90349 9.22152C9.90349 8.86996 9.61849 8.58496 9.26693 8.58496C8.91537 8.58496 8.63037 8.86996 8.63037 9.22152C8.63037 9.57308 8.91537 9.85808 9.26693 9.85808Z" stroke-width="0.5"></path>
                                    <path d="M20.8497 21.5183C20.7722 21.5183 20.6991 21.5355 20.6303 21.5613C20.6131 21.5656 20.5959 21.5742 20.5787 21.5828C20.5099 21.6129 20.4454 21.6516 20.3894 21.7076C20.3335 21.7635 20.2948 21.828 20.2647 21.8968C20.2561 21.914 20.2475 21.9312 20.2432 21.9484C20.2174 22.0172 20.2002 22.0904 20.2002 22.1635V22.1678C20.2002 22.2237 20.2088 22.2753 20.2217 22.3312L21.9593 28.8129C22.0368 29.1011 22.2991 29.2904 22.583 29.2904C22.6389 29.2904 22.6948 29.2818 22.7507 29.2689C23.0948 29.1785 23.297 28.8215 23.2066 28.4775L22.0927 24.3226L27.1421 29.3721C27.2669 29.4968 27.4346 29.5613 27.598 29.5613C27.7615 29.5613 27.9292 29.4968 28.054 29.3721C28.3077 29.1183 28.3077 28.7097 28.054 28.4602L23.0045 23.4108L27.1593 24.5248C27.5034 24.6194 27.8561 24.4129 27.9507 24.0688C28.0411 23.7248 27.8389 23.3721 27.4948 23.2775L21.0131 21.5398C20.9615 21.5269 20.9056 21.5183 20.8497 21.5183Z" stroke-width="0.5"></path>
                                    <path d="M20.8454 18.5893C21.2023 18.5893 21.4905 18.3012 21.4905 17.9442V15.7162C21.4905 15.3592 21.2023 15.071 20.8454 15.071C20.4884 15.071 20.2002 15.3592 20.2002 15.7162V17.9442C20.2002 18.3012 20.4884 18.5893 20.8454 18.5893Z" stroke-width="0.5"></path>
                                    <path d="M14.3976 22.8086H16.6256C16.9825 22.8086 17.2707 22.5205 17.2707 22.1635C17.2707 21.8065 16.9825 21.5183 16.6256 21.5183H14.3976C14.0406 21.5183 13.7524 21.8065 13.7524 22.1635C13.7524 22.5205 14.0449 22.8086 14.3976 22.8086Z" stroke-width="0.5"></path>
                                    <path d="M17.4086 24.6881L15.8344 26.2623C15.5806 26.516 15.5806 26.9246 15.8344 27.1741C15.9591 27.2988 16.1268 27.3633 16.2903 27.3633C16.4537 27.3633 16.6215 27.2988 16.7462 27.1741L18.3204 25.5999C18.5742 25.3461 18.5742 24.9375 18.3204 24.6881C18.0666 24.4386 17.658 24.4386 17.4086 24.6881Z" stroke-width="0.5"></path>
                                    <path d="M23.8303 19.828C23.9938 19.828 24.1615 19.7635 24.2862 19.6387L25.8604 18.0646C26.1142 17.8108 26.1142 17.4022 25.8604 17.1527C25.6067 16.899 25.1981 16.899 24.9486 17.1527L23.3744 18.7269C23.1206 18.9807 23.1206 19.3893 23.3744 19.6387C23.4991 19.7635 23.6626 19.828 23.8303 19.828Z" stroke-width="0.5"></path>
                                    <path d="M17.4086 19.6387C17.5333 19.7635 17.701 19.828 17.8645 19.828C18.0279 19.828 18.1957 19.7635 18.3204 19.6387C18.5742 19.385 18.5742 18.9764 18.3204 18.7269L16.7462 17.1527C16.4924 16.899 16.0838 16.899 15.8344 17.1527C15.5806 17.4065 15.5806 17.8151 15.8344 18.0646L17.4086 19.6387Z" stroke-width="0.5"></path>
                              </svg>
                        </span>
                        <p class="grille-bloc__p">Un site référencé</p>
                        <div class="grille-bloc__titre">sur Google</div>
                  </div>
                  <div class="grille-bloc">
                        <span class="grille-bloc__svg">
                              <svg width="41" height="42" viewBox="0 0 40 29" fill="none">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M25.7322 0C17.8634 0 11.4644 6.40251 11.4644 14.2713C11.4644 22.1401 17.8634 28.5391 25.7322 28.5391C33.601 28.5391 40 22.1401 40 14.2713C40 6.40251 33.601 0 25.7322 0ZM25.7322 1.90519C32.5716 1.90519 38.0948 7.43191 38.0948 14.2713C38.0948 21.1107 32.5716 26.6339 25.7322 26.6339C18.8927 26.6339 13.3695 21.1107 13.3695 14.2713C13.3695 7.43191 18.8927 1.90519 25.7322 1.90519Z">
                                    </path>
                                    <path d="M0.952599 13.301C0.699954 13.301 0.457657 13.4014 0.27901 13.58C0.100363 13.7587 0 14.001 0 14.2536C0 14.5063 0.100363 14.7486 0.27901 14.9272C0.457657 15.1058 0.699954 15.2062 0.952599 15.2062H9.52242C9.77507 15.2062 10.0174 15.1058 10.196 14.9272C10.3747 14.7486 10.475 14.5063 10.475 14.2536C10.475 14.001 10.3747 13.7587 10.196 13.58C10.0174 13.4014 9.77507 13.301 9.52242 13.301H0.952599Z">
                                    </path>function defaultConfiguration() {
    return [
                                    <path d="M2.8569 7.58569C2.60425 7.58569 2.36195 7.68606 2.18331 7.8647C2.00466 8.04335 1.9043 8.28564 1.9043 8.53829C1.9043 8.79093 2.00466 9.03322 2.18331 9.21187C2.36195 9.39052 2.60425 9.49088 2.8569 9.49088H10.4741C10.7268 9.49088 10.9691 9.39052 11.1477 9.21187C11.3264 9.03322 11.4267 8.79093 11.4267 8.53829C11.4267 8.28564 11.3264 8.04335 11.1477 7.8647C10.9691 7.68606 10.7268 7.58569 10.4741 7.58569H2.8569Z">
                                    </path>
                                    <path d="M5.71139 19.0132C5.45874 19.0132 5.21645 19.1135 5.0378 19.2922C4.85915 19.4708 4.75879 19.7131 4.75879 19.9658C4.75879 20.2184 4.85915 20.4607 5.0378 20.6394C5.21645 20.818 5.45874 20.9184 5.71139 20.9184H10.4744C10.727 20.9184 10.9693 20.818 11.1479 20.6394C11.3266 20.4607 11.427 20.2184 11.427 19.9658C11.427 19.7131 11.3266 19.4708 11.1479 19.2922C10.9693 19.1135 10.727 19.0132 10.4744 19.0132H5.71139Z">
                                    </path>
                                    <path d="M9.5234 1.87012C9.27076 1.87012 9.02846 1.97048 8.84981 2.14913C8.67116 2.32778 8.5708 2.57007 8.5708 2.82271C8.5708 3.07536 8.67116 3.31765 8.84981 3.49629C9.02846 3.67494 9.27076 3.7753 9.5234 3.7753H14.2864C14.539 3.7753 14.7813 3.67494 14.96 3.49629C15.1386 3.31765 15.239 3.07536 15.239 2.82271C15.239 2.57007 15.1386 2.32778 14.96 2.14913C14.7813 1.97048 14.539 1.87012 14.2864 1.87012H9.5234Z">
                                    </path>
                                    <path d="M6.66549 24.729C6.41285 24.729 6.17055 24.8294 5.9919 25.008C5.81325 25.1867 5.71289 25.429 5.71289 25.6816C5.71289 25.9342 5.81325 26.1765 5.9919 26.3552C6.17055 26.5338 6.41285 26.6342 6.66549 26.6342H14.2862C14.5389 26.6342 14.7812 26.5338 14.9598 26.3552C15.1385 26.1765 15.2388 25.9342 15.2388 25.6816C15.2388 25.429 15.1385 25.1867 14.9598 25.008C14.7812 24.8294 14.5389 24.729 14.2862 24.729H6.66549Z">
                                    </path>
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M3.80901 19.9665C3.80902 20.0916 3.78438 20.2154 3.73652 20.331C3.68866 20.4465 3.61851 20.5515 3.53008 20.64C3.44164 20.7284 3.33666 20.7985 3.22111 20.8464C3.10556 20.8943 2.98172 20.9189 2.85666 20.9189C2.73159 20.9189 2.60775 20.8943 2.4922 20.8464C2.37666 20.7985 2.27167 20.7284 2.18323 20.64C2.0948 20.5515 2.02465 20.4465 1.97679 20.331C1.92893 20.2154 1.9043 20.0916 1.9043 19.9665C1.9043 19.714 2.00464 19.4717 2.18324 19.2931C2.36184 19.1145 2.60408 19.0142 2.85666 19.0142C3.10924 19.0142 3.35147 19.1145 3.53007 19.2931C3.70867 19.4717 3.80901 19.714 3.80901 19.9665Z">
                                    </path>
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M7.61761 2.82396C7.61761 2.94902 7.59298 3.07283 7.54512 3.18837C7.49726 3.30392 7.42711 3.40894 7.33867 3.49737C7.25024 3.58581 7.14525 3.65597 7.0297 3.70383C6.91416 3.75169 6.79032 3.77627 6.66525 3.77627C6.54018 3.77627 6.41634 3.75169 6.3008 3.70383C6.18525 3.65597 6.08026 3.58581 5.99183 3.49737C5.90339 3.40894 5.83324 3.30392 5.78538 3.18837C5.73752 3.07283 5.71289 2.94902 5.71289 2.82396C5.71289 2.57138 5.81323 2.32914 5.99183 2.15054C6.17044 1.97194 6.41267 1.87158 6.66525 1.87158C6.91783 1.87158 7.16006 1.97194 7.33866 2.15054C7.51727 2.32914 7.6176 2.57138 7.61761 2.82396Z">
                                    </path>
                                    <path d="M25.7004 4.71373C25.5753 4.71554 25.4517 4.74199 25.3368 4.79156C25.222 4.84112 25.118 4.91286 25.0308 5.00263C24.9437 5.0924 24.875 5.19846 24.8289 5.31476C24.7827 5.43105 24.7599 5.55528 24.7618 5.68038V14.2537C24.762 14.5054 24.8619 14.7468 25.0395 14.9251L30.7551 20.6407C30.8424 20.7338 30.9476 20.8083 31.0643 20.86C31.181 20.9116 31.3069 20.9393 31.4345 20.9413C31.5621 20.9434 31.6889 20.9197 31.8072 20.8718C31.9255 20.8239 32.0329 20.7527 32.1232 20.6625C32.2134 20.5722 32.2846 20.4648 32.3325 20.3464C32.3804 20.2281 32.4041 20.1014 32.402 19.9738C32.4 19.8462 32.3723 19.7203 32.3207 19.6035C32.269 19.4868 32.1944 19.3817 32.1014 19.2944L26.667 13.8565V5.68038C26.6689 5.55291 26.6452 5.42637 26.5973 5.30822C26.5494 5.19008 26.4783 5.08272 26.3882 4.99258C26.298 4.90243 26.1907 4.83133 26.0725 4.78343C25.9544 4.73553 25.8278 4.71182 25.7004 4.71373Z">
                                    </path>
                              </svg>
                        </span>
                        <p class="grille-bloc__p">Votre site de A à Z</p>
                        <div class="grille-bloc__titre">En 7jours</div>
                  </div>
                  <div class="grille-bloc">
                        <span class="grille-bloc__svg">
                              <svg width="41" height="42" viewBox="0 0 41 42" fill="none">
                                    <path d="M6.15364 19.6221C6.24328 19.6221 6.37773 19.5773 6.46737 19.5324L33.4923 4.78751L32.1478 9.35889C32.0581 9.71743 32.2374 10.076 32.5959 10.2104C32.6408 10.2104 32.7304 10.2552 32.7752 10.2552C33.0441 10.2552 33.313 10.076 33.4026 9.76224L35.1953 3.66707C35.1953 3.62225 35.1953 3.57744 35.2402 3.53262V3.4878C35.2402 3.44298 35.2402 3.44298 35.2402 3.39817C35.2402 3.35335 35.2402 3.35335 35.2402 3.30853V3.26371C35.1953 3.17408 35.1505 3.08444 35.1057 3.03963L35.0609 2.99481L35.0161 2.94999L34.9713 2.90517C34.9713 2.90517 34.9264 2.90517 34.9264 2.86036C34.8816 2.86036 34.8368 2.81554 34.792 2.81554L28.6968 1.02284C28.3383 0.933207 27.9797 1.11248 27.8453 1.47102C27.7557 1.82956 27.9349 2.1881 28.2935 2.32255L32.8648 3.66707L5.83992 18.3672C5.5262 18.5465 5.39175 18.9498 5.57102 19.2635C5.66065 19.4876 5.88474 19.6221 6.15364 19.6221Z">
                                    </path>
                                    <path d="M39.05 39.6557H34.9716V12.6308C34.9716 12.2722 34.6579 11.9585 34.2994 11.9585H28.0697C27.7112 11.9585 27.3975 12.2722 27.3975 12.6308V39.6557H24.1258V20.6531C24.1258 20.2945 23.8121 19.9808 23.4535 19.9808H17.2687C16.9102 19.9808 16.5965 20.2945 16.5965 20.6531V39.6557H13.3248V27.2412C13.3248 26.8827 13.0111 26.569 12.6525 26.569H6.42291C6.06437 26.569 5.75065 26.8827 5.75065 27.2412V39.6557H1.67226C1.31372 39.6557 1 39.9694 1 40.3279C1 40.6865 1.31372 41.0002 1.67226 41.0002H6.42291H12.6525H17.2687H23.4984H28.1146H34.3442H39.0948C39.4534 41.0002 39.7671 40.6865 39.7671 40.3279C39.7671 39.9694 39.4085 39.6557 39.05 39.6557ZM11.9803 39.6557H7.09517V27.9135H11.9803V39.6557V39.6557ZM22.7813 39.6557H17.941V21.3253H22.8261V39.6557H22.7813ZM33.6271 39.6557H28.742V13.303H33.6271V39.6557V39.6557Z">
                                    </path>
                              </svg>
                        </span>
                        <p class="grille-bloc__p">Augmentez votre</p>
                        <div class="grille-bloc__titre">clientèle</div>
                  </div>
                  <div class="grille-bloc">
                        <span class="grille-bloc__svg">
                              <svg width="41" height="42" viewBox="0 0 40 37" fill="none">
                                    <path d="M4.94244 15.0031C5.16537 13.9738 5.47843 12.9634 5.88635 11.9911C5.83892 12.1049 5.79148 12.2187 5.74405 12.3326C6.06659 11.5689 6.44605 10.829 6.87769 10.1222C7.0864 9.77596 7.30933 9.43919 7.5465 9.1119C7.60342 9.03126 7.66033 8.95063 7.71725 8.87474C7.7552 8.82256 7.97339 8.53796 7.80263 8.75615C7.63187 8.97909 7.85007 8.69449 7.89275 8.64231C7.95916 8.55694 8.03031 8.47156 8.10146 8.39092C8.63271 7.75058 9.21613 7.15293 9.8375 6.60271C9.98454 6.46989 10.1363 6.34183 10.2881 6.2185C10.364 6.15684 10.4399 6.09517 10.5205 6.03351C10.5632 6.00031 10.6059 5.96236 10.6486 5.92916C10.5869 5.97659 10.5253 6.02402 10.4636 6.07146C10.4968 6.043 10.5348 6.01928 10.568 5.99082C10.8953 5.74417 11.232 5.51175 11.5783 5.28882C12.3799 4.7718 13.2289 4.33067 14.1065 3.95596C13.9926 4.00339 13.8788 4.05082 13.7649 4.09825C15.1452 3.51957 16.5919 3.13063 18.0718 2.93141C17.9438 2.95038 17.8204 2.96461 17.6924 2.98358C19.158 2.79385 20.6379 2.79385 22.0989 2.98833C21.9708 2.96935 21.8475 2.95512 21.7194 2.93615C23.1851 3.13537 24.6176 3.5338 25.9836 4.10774C25.8698 4.06031 25.7559 4.01288 25.6421 3.96544C26.4058 4.29273 27.141 4.66745 27.8477 5.10383C28.1892 5.31253 28.526 5.53547 28.8533 5.77263C29.0098 5.88173 29.1616 6.00031 29.3134 6.11415C28.9007 5.80583 29.2375 6.05723 29.3276 6.12838C29.4083 6.19478 29.4936 6.26119 29.5743 6.33234C30.2099 6.86833 30.8075 7.44701 31.3578 8.06838C31.4858 8.21068 31.6091 8.35772 31.7325 8.5095C31.7989 8.59014 31.87 8.67552 31.9364 8.7609C31.9649 8.7941 31.9886 8.8273 32.0171 8.86051C31.8653 8.66603 31.8273 8.61385 31.8937 8.69923C31.9127 8.72295 31.9317 8.75141 31.9507 8.77513C32.1973 9.10241 32.4297 9.43919 32.6527 9.7807C33.1744 10.5918 33.6203 11.4456 33.995 12.3278C33.9476 12.214 33.9002 12.1002 33.8527 11.9863C34.2322 12.9018 34.5358 13.8457 34.7539 14.8086C34.92 15.5343 35.7975 16.0323 36.5042 15.8047C37.2679 15.558 37.6758 14.8323 37.5003 14.0544C36.7935 10.9333 35.2378 8.03043 33.0511 5.69674C30.9356 3.43894 28.2177 1.75507 25.2721 0.820648C22.208 -0.151724 18.8972 -0.246589 15.7713 0.464902C12.5933 1.19062 9.6288 2.81757 7.28562 5.08486C5.00884 7.28574 3.32498 10.1127 2.45696 13.1627C2.35261 13.5231 2.26723 13.8884 2.18659 14.2536C2.03006 14.9793 2.40004 15.8284 3.18268 16.0039C3.9084 16.1604 4.77642 15.7809 4.94244 15.0031Z">
                                    </path>
                                    <path d="M37.192 7.13384C36.4852 9.15448 35.7785 11.1799 35.0717 13.2005C34.9721 13.4851 34.8725 13.7697 34.7729 14.059C35.3563 13.727 35.9398 13.395 36.5232 13.0629C34.5025 12.3562 32.4772 11.6494 30.4565 10.9427C30.1719 10.8431 29.8873 10.7435 29.598 10.6439C28.896 10.3972 28.009 10.9237 27.8477 11.64C27.6675 12.4321 28.0896 13.1293 28.8438 13.3902C30.8644 14.097 32.8898 14.8037 34.9105 15.5105C35.1951 15.6101 35.4797 15.7097 35.769 15.8093C36.0915 15.9231 36.5801 15.8472 36.8647 15.667C37.1872 15.4583 37.3912 15.1832 37.5193 14.818C38.226 12.7973 38.9328 10.7719 39.6395 8.7513C39.7391 8.4667 39.8387 8.1821 39.9383 7.89276C40.185 7.19076 39.6585 6.30377 38.9422 6.14249C38.1501 5.96225 37.4576 6.3844 37.192 7.13384Z">
                                    </path>
                                    <path d="M35.0575 20.9987C34.8346 22.028 34.5215 23.0383 34.1136 24.0107C34.1611 23.8968 34.2085 23.783 34.2559 23.6692C33.9334 24.4328 33.5539 25.1728 33.1223 25.8795C32.9136 26.2258 32.6906 26.5626 32.4535 26.8898C32.3966 26.9705 32.3396 27.0511 32.2827 27.127C32.2448 27.1792 32.0266 27.4638 32.1973 27.2456C32.3681 27.0227 32.1499 27.3073 32.1072 27.3594C32.0408 27.4448 31.9697 27.5302 31.8985 27.6108C31.3673 28.2512 30.7838 28.8488 30.1625 29.399C30.0154 29.5319 29.8636 29.6599 29.7119 29.7832C29.636 29.8449 29.5601 29.9066 29.4794 29.9682C29.4367 30.0014 29.3941 30.0394 29.3514 30.0726C29.413 30.0252 29.4747 29.9777 29.5364 29.9303C29.5032 29.9587 29.4652 29.9825 29.432 30.0109C29.1047 30.2576 28.7679 30.49 28.4217 30.7129C27.6201 31.2299 26.771 31.6711 25.8935 32.0458C26.0074 31.9984 26.1212 31.9509 26.235 31.9035C24.8547 32.4822 23.408 32.8711 21.9281 33.0703C22.0562 33.0514 22.1795 33.0371 22.3076 33.0182C20.8419 33.2079 19.362 33.2079 17.9011 33.0134C18.0292 33.0324 18.1525 33.0466 18.2806 33.0656C16.8149 32.8664 15.3824 32.4679 14.0163 31.894C14.1302 31.9414 14.244 31.9889 14.3579 32.0363C13.5942 31.709 12.859 31.3343 12.1522 30.8979C11.8107 30.6892 11.4739 30.4663 11.1467 30.2291C10.9901 30.12 10.8383 30.0014 10.6866 29.8876C11.0992 30.1959 10.7625 29.9445 10.6723 29.8734C10.5917 29.807 10.5063 29.7406 10.4257 29.6694C9.79008 29.1334 9.19243 28.5547 8.64221 27.9334C8.51414 27.7911 8.39082 27.644 8.26749 27.4922C8.20109 27.4116 8.12994 27.3262 8.06353 27.2408C8.03507 27.2076 8.01135 27.1744 7.98289 27.1412C8.13468 27.3357 8.17263 27.3879 8.10622 27.3025C8.08725 27.2788 8.06827 27.2503 8.0493 27.2266C7.80265 26.8993 7.57023 26.5626 7.3473 26.221C6.82554 25.4099 6.37967 24.5562 6.00495 23.6739C6.05238 23.7877 6.09981 23.9016 6.14725 24.0154C5.76778 23.1 5.46421 22.1561 5.24602 21.1932C5.08001 20.4674 4.2025 19.9694 3.49575 20.1971C2.73209 20.4437 2.32416 21.1695 2.49966 21.9473C3.20641 25.0684 4.76221 27.9713 6.94886 30.305C9.06436 32.5628 11.7823 34.2467 14.7278 35.1811C17.792 36.1535 21.1028 36.2483 24.2286 35.5368C27.4066 34.8111 30.3712 33.1842 32.7144 30.9169C34.9911 28.716 36.675 25.889 37.543 22.8391C37.6474 22.4786 37.7327 22.1134 37.8134 21.7481C37.9699 21.0224 37.5999 20.1734 36.8173 19.9979C36.0916 19.8413 35.2235 20.2208 35.0575 20.9987Z">
                                    </path>
                                    <path d="M2.80798 28.8679C3.51473 26.8473 4.22148 24.8219 4.92823 22.8013C5.02784 22.5167 5.12745 22.2321 5.22706 21.9427C4.64363 22.2748 4.06021 22.6068 3.47679 22.9388C5.49742 23.6456 7.5228 24.3523 9.54344 25.0591C9.82804 25.1587 10.1126 25.2583 10.402 25.3579C11.104 25.6046 11.991 25.0781 12.1522 24.3618C12.3325 23.5697 11.9103 22.8724 11.1562 22.6115C9.13552 21.9048 7.11014 21.1981 5.0895 20.4913C4.80491 20.3917 4.52031 20.2921 4.23097 20.1925C3.90843 20.0786 3.41987 20.1545 3.13527 20.3348C2.81273 20.5435 2.60877 20.8186 2.4807 21.1838C1.77395 23.2045 1.0672 25.2298 0.360452 27.2505C0.260844 27.5351 0.161235 27.8197 0.0616261 28.109C-0.185024 28.811 0.341479 29.698 1.05771 29.8593C1.85459 30.0443 2.5471 29.6221 2.80798 28.8679Z">
                                    </path>
                              </svg>
                        </span>
                        <p class="grille-bloc__p">Maintenance </p>
                        <div class="grille-bloc__titre">incluse</div>
                  </div>'
            ]
          ]
        ]
      ]
    ] + parent::defaultConfiguration();
  }
}
