<?php

namespace Drupal\formatage_models\Plugin\Layout\Sections;

use Drupal\bootstrap_styles\StylesGroup\StylesGroupManager;
use Drupal\formatage_models\FormatageModelsThemes;
use Drupal\Core\Form\FormStateInterface;

/**
 * A very advanced custom layout.
 *
 * @Layout(
 *   id = "formatage_models_simple_block",
 *   label = @Translation(" One column custom "),
 *   category = @Translation("Formatage Models"),
 *   path = "layouts/sections",
 *   template = "formatage-models-simple-block",
 *   default_region = "main",
 *   regions = {
 *     "main" = {
 *       "label" = @Translation("Main"),
 *     },
 *     "block_2" = {
 *       "label" = @Translation("Block 2"),
 *     },
 *     "block_3" = {
 *       "label" = @Translation("Block 3"),
 *     },
 *     "block_4" = {
 *       "label" = @Translation("Block 4"),
 *     },
 *     "block_5" = {
 *       "label" = @Translation("Block 5"),
 *     },
 *     "block_6" = {
 *       "label" = @Translation("Block 6"),
 *     },
 *     "image_bg" = {
 *       "label" = @Translation("Image bg")
 *     },
 *    "teasers_container" = {
 *       "label" = @Translation("Content for many elements"),
 *    },
 *   }
 * )
 */
class FormatageModelsSimpleBlock extends FormatageModelsSection {
  
  /**
   *
   * {@inheritdoc}
   * @see \Drupal\formatage_models\Plugin\Layout\FormatageModels::__construct()
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition, StylesGroupManager $styles_group_manager) {
    // TODO Auto-generated method stub
    parent::__construct($configuration, $plugin_id, $plugin_definition, $styles_group_manager);
    $this->pluginDefinition->set('icon', $this->pathResolver->getPath('module', 'formatage_models') . "/icones/sections/formatage-models-simple-block.png");
  }
  
  /**
   *
   * {@inheritdoc}
   * @see \Drupal\formatage_models\Plugin\Layout\FormatageModels::build()
   */
  public function build(array $regions) {
    // TODO Auto-generated method stub
    $build = parent::build($regions);
    FormatageModelsThemes::formatSettingValues($build);
    
    return $build;
  }
  
  /**
   *
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $form = parent::buildConfigurationForm($form, $form_state);
    
    $form['class_row'] = [
      '#type' => 'textfield',
      '#title' => 'Class row',
      '#default_value' => $this->configuration['class_row']
    ];
    return $form;
  }
  
  /**
   *
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
    parent::submitConfigurationForm($form, $form_state);
    // $this->configuration['layoutrestrictions'] =
    // $form_state->getValue('layoutrestrictions');
    $this->configuration['class_row'] = $form_state->getValue('class_row');
  }
  
  /**
   *
   * {@inheritdoc}
   * @see \Drupal\formatage_models\Plugin\Layout\Sections\FormatageModelsSection::defaultConfiguration()
   */
  public function defaultConfiguration() {
    return [
      'css' => '',
      'region_tag_main' => 'div',
      'config_section' => [
        'type_container' => '',
        'container_class' => ''
      ],
      'sf' => [
        'builder-form' => true,
        'info' => [
          'title' => ' Contenu ',
          'loader' => 'static'
        ],
        'fields' => [
          'main' => [
            'text_html' => [
              'label' => 'Description',
              'value' => ""
            ]
          ],
          'teasers_container' => [
            'text_html' => [
              'label' => 'Container pour Teaser',
              'value' => ""
            ]
          ],
          'image_bg' => [
            'img_bg' => [
              'label' => 'image',
              'fids' => []
            ]
          ]
        ]
      ]
    ] + parent::defaultConfiguration();
  }
}
