<?php

namespace Drupal\formfactorykits\Services;

use Drupal\formfactorykits\Kits;
use Drupal\formfactorykits\Kits\Button\ButtonKit;
use Drupal\formfactorykits\Kits\Button\ImageButtonKit;
use Drupal\formfactorykits\Kits\Button\SubmitButtonKit;
use Drupal\formfactorykits\Kits\Container\ContainerKit;
use Drupal\formfactorykits\Kits\Container\DetailsKit;
use Drupal\formfactorykits\Kits\Container\Table\TableKit;
use Drupal\formfactorykits\Kits\Container\Table\TableRowKit;
use Drupal\formfactorykits\Kits\Container\Tabs\VerticalTabsKit;
use Drupal\formfactorykits\Kits\Field\Checkboxes\CheckboxesKit;
use Drupal\formfactorykits\Kits\Field\Checkboxes\CheckboxKit;
use Drupal\formfactorykits\Kits\Field\Color\ColorKit;
use Drupal\formfactorykits\Kits\Field\Date\DateKit;
use Drupal\formfactorykits\Kits\Field\Date\DateListKit;
use Drupal\formfactorykits\Kits\Field\Date\DateTimeKit;
use Drupal\formfactorykits\Kits\Field\Entity\NodeAutoCompleteKit;
use Drupal\formfactorykits\Kits\Field\Entity\TaxonomyTermAutoCompleteKit;
use Drupal\formfactorykits\Kits\Field\Entity\TaxonomyTermSelectKit;
use Drupal\formfactorykits\Kits\Field\Entity\UserAutoCompleteKit;
use Drupal\formfactorykits\Kits\Field\HiddenKit;
use Drupal\formfactorykits\Kits\Field\Media\FileKit as MediaFileKit;
use Drupal\formfactorykits\Kits\Field\Media\ManagedFile\FileKit as ManagedFileKit;
use Drupal\formfactorykits\Kits\Field\Media\ManagedFile\ImageKit;
use Drupal\formfactorykits\Kits\Field\Media\ManagedFile\UploadValidators\UploadValidatorKit;
use Drupal\formfactorykits\Kits\Field\Radios\RadiosKit;
use Drupal\formfactorykits\Kits\Field\Select\SelectKit;
use Drupal\formfactorykits\Kits\Field\Table\TableSelectKit;
use Drupal\formfactorykits\Kits\Field\Text\EmailKit;
use Drupal\formfactorykits\Kits\Field\Text\Number\NumberKit;
use Drupal\formfactorykits\Kits\Field\Text\Number\RangeKit;
use Drupal\formfactorykits\Kits\Field\Text\Number\TelephoneKit;
use Drupal\formfactorykits\Kits\Field\Text\PasswordConfirmKit;
use Drupal\formfactorykits\Kits\Field\Text\PasswordKit;
use Drupal\formfactorykits\Kits\Field\Text\PathKit;
use Drupal\formfactorykits\Kits\Field\Text\SearchKit;
use Drupal\formfactorykits\Kits\Field\Text\TextAreaKit;
use Drupal\formfactorykits\Kits\Field\Text\TextFieldKit;
use Drupal\formfactorykits\Kits\Field\Text\UrlKit;
use Drupal\formfactorykits\Kits\Field\ValueKit;
use Drupal\formfactorykits\Kits\Markup\ExampleKit;
use Drupal\formfactorykits\Kits\Markup\HeadingKit;
use Drupal\formfactorykits\Kits\Markup\ItemKit;
use Drupal\formfactorykits\Kits\Markup\MarkupKit;
use Drupal\formfactorykits\Kits\Markup\TemplateKit;
use Drupal\formfactorykits\Kits\Markup\TextKit;
use Drupal\kits\Services\KitsService;

/**
 * Interface FormFactoryKitsInterface
 *
 * @package Drupal\formfactorykits\Kits
 */
class FormFactoryKitsService extends KitsService implements FormFactoryKitsInterface {
    public function button(?string $id = NULL, array $parameters = [], array|string $context = []): ButtonKit
    {
        return ButtonKit::create($this, $id, $parameters, $context);
    }

    public function checkbox(?string $id = NULL, array $parameters = [], array $context = []): CheckboxKit
    {
        return CheckboxKit::create($this, $id, $parameters, $context);
    }

    public function checkboxes(?string $id = NULL, array $parameters = [], array $context = []): CheckboxesKit
    {
        return CheckboxesKit::create($this, $id, $parameters, $context);
    }

    public function color(?string $id = NULL, array $parameters = [], array $context = []): ColorKit
    {
        return ColorKit::create($this, $id, $parameters, $context);
    }

    public function container(?string $id = NULL, array $parameters = [], array $context = []): ContainerKit
    {
        return ContainerKit::create($this, $id, $parameters, $context);
    }

    public function date(?string $id = NULL, array $parameters = [], array $context = []): DateKit
    {
        return DateKit::create($this, $id, $parameters, $context);
    }

    public function dateList(?string $id = NULL, array $parameters = [], array $context = []): DateListKit
    {
        return DateListKit::create($this, $id, $parameters, $context);
    }

    public function dateTime(?string $id = NULL, array $parameters = [], array $context = []): DateTimeKit
    {
        return DateTimeKit::create($this, $id, $parameters, $context);
    }

    public function details(?string $id = NULL, array $parameters = [], array $context = []): DetailsKit
    {
        return DetailsKit::create($this, $id, $parameters, $context);
    }

    public function email(?string $id = NULL, array $parameters = [], array $context = []): EmailKit
    {
        return EmailKit::create($this, $id, $parameters, $context);
    }

    public function example(?string $id = NULL, array $parameters = [], array $context = []): ExampleKit
    {
        return ExampleKit::create($this, $id, $parameters, $context);
    }

    public function file(?string $id = NULL, array $parameters = [], array $context = []): ManagedFileKit
    {
        return FileKit::create($this, $id, $parameters, $context);
    }

    public function fileUnmanaged(?string $id = NULL, array $parameters = [], array $context = []): MediaFileKit
    {
        return MediaFileKit::create($this, $id, $parameters, $context);
    }

    public function heading(?string $id = NULL, array $parameters = [], array $context = []): HeadingKit
    {
        return HeadingKit::create($this, $id, $parameters, $context);
    }

    public function hidden(?string $id = NULL, array $parameters = [], array $context = []): HiddenKit
    {
        return HiddenKit::create($this, $id, $parameters, $context);
    }

    public function image(?string $id = NULL, array $parameters = [], array $context = []): ImageKit
    {
        return ImageKit::create($this, $id, $parameters, $context);
    }

    public function imageButton(?string $id = NULL, array $parameters = [], array $context = []): ImageButtonKit
    {
        return ImageButtonKit::create($this, $id, $parameters, $context);
    }

    public function item(?string $id = NULL, array $parameters = [], array $context = []): ItemKit
    {
        return ItemKit::create($this, $id, $parameters, $context);
    }

    public function markup(?string $id = NULL, array $parameters = [], array $context = []): MarkupKit
    {
        return MarkupKit::create($this, $id, $parameters, $context);
    }

    public function nodeAutoComplete(?string $id = NULL, array $parameters = [], array $context = []): NodeAutoCompleteKit
    {
        return NodeAutoCompleteKit::create($this, $id, $parameters, $context);
    }

    public function number(?string $id = NULL, array $parameters = [], array $context = []): NumberKit
    {
        return NumberKit::create($this, $id, $parameters, $context);
    }

    public function password(?string $id = NULL, array $parameters = [], array $context = []): PasswordKit
    {
        return PasswordKit::create($this, $id, $parameters, $context);
    }

    public function passwordConfirm(?string $id = NULL, array $parameters = [], array $context = []): PasswordConfirmKit
    {
        return PasswordConfirmKit::create($this, $id, $parameters, $context);
    }

    public function path(?string $id = NULL, array $parameters = [], array $context = []): PathKit
    {
        return PathKit::create($this, $id, $parameters, $context);
    }

    public function radios(?string $id = NULL, array $parameters = [], array $context = []): RadiosKit
    {
        return RadiosKit::create($this, $id, $parameters, $context);
    }

    public function range(?string $id = NULL, array $parameters = [], array $context = []): RangeKit
    {
        return RangeKit::create($this, $id, $parameters, $context);
    }

    public function search(?string $id = NULL, array $parameters = [], array $context = []): SearchKit
    {
        return SearchKit::create($this, $id, $parameters, $context);
    }

    public function select(?string $id = NULL, array $parameters = [], array $context = []): SelectKit
    {
        return SelectKit::create($this, $id, $parameters, $context);
    }

    public function submit(?string $id = NULL, array $parameters = [], array $context = []): SubmitButtonKit
    {
        return SubmitButtonKit::create($this, $id, $parameters, $context);
    }

    public function table(?string $id = NULL, array $parameters = [], array $context = []): TableKit
    {
        return TableKit::create($this, $id, $parameters, $context);
    }

    public function tableRow(?string $id = NULL, array $parameters = [], array $context = []): TableRowKit
    {
        return TableRowKit::create($this, $id, $parameters, $context);
    }

    public function tableSelect(?string $id = NULL, array $parameters = [], array $context = []): TableSelectKit
    {
        return TableSelectKit::create($this, $id, $parameters, $context);
    }

    public function telephone(?string $id = NULL, array $parameters = [], array $context = []): TelephoneKit
    {
        return TelephoneKit::create($this, $id, $parameters, $context);
    }

    public function template(?string $id = NULL, array $parameters = [], array $context = []): TemplateKit
    {
        return TemplateKit::create($this, $id, $parameters, $context);
    }

    public function taxonomyTermSelect(?string $id = NULL, array $parameters = [], array $context = []): TaxonomyTermSelectKit
    {
        return TaxonomyTermSelectKit::create($this, $id, $parameters, $context);
    }

    public function taxonomyTermAutoComplete(?string $id = NULL, array $parameters = [], array $context = []): TaxonomyTermAutoCompleteKit
    {
        return TaxonomyTermAutoCompleteKit::create($this, $id, $parameters, $context);
    }

    public function text(?string $id = NULL, array $parameters = [], array $context = []): TextKit
    {
        return TextKit::create($this, $id, $parameters, $context);
    }

    public function textField(?string $id = NULL, array $parameters = [], array $context = []): TextFieldKit
    {
        return TextFieldKit::create($this, $id, $parameters, $context);
    }

    public function textArea(?string $id = NULL, array $parameters = [], array $context = []): TextAreaKit
    {
        return TextAreaKit::create($this, $id, $parameters, $context);
    }

    public function userAutoComplete(?string $id = NULL, array $parameters = [], array $context = []): UserAutoCompleteKit
    {
        return UserAutoCompleteKit::create($this, $id, $parameters, $context);
    }

    public function url(?string $id = NULL, array $parameters = [], array $context = []): UrlKit
    {
        return UrlKit::create($this, $id, $parameters, $context);
    }

    public function value(?string $id = NULL, array $parameters = [], array $context = []): ValueKit
    {
        return ValueKit::create($this, $id, $parameters, $context);
    }

    public function verticalTabs(?string $id = NULL, array $parameters = [], array $context = []): VerticalTabsKit
    {
        return VerticalTabsKit::create($this, $id, $parameters, $context);
    }

    public function uploadValidator($id = NULL, $parameters = [], $context = []): UploadValidatorKit
    {
        return UploadValidatorKit::create($this, $id, $parameters, $context);
    }
}
