<?php

namespace Drupal\formfactorykits\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\formfactory\Services\FormFactoryInterface;
use Drupal\formfactorykits\Services\FormFactoryKitsInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

abstract class FormObjectBase extends FormBase implements FormObjectInterface {

    /**
     * @var FormFactoryInterface
     *  The form factory service.
     */
    protected FormFactoryInterface $formFactory;

    /**
     * @var FormFactoryKitsInterface
     *  The form factory kits service.
     */
    protected FormFactoryKitsInterface $kits;

    /**
      * {@inheritdoc}
      */
    public function __construct(
      FormFactoryInterface $formFactory,
      FormFactoryKitsInterface $kits,
    ) {
      $this->formFactory = $formFactory;
      $this->kits = $kits;
    }

    /**
     * {@inheritdoc}
     */
    public static function create(ContainerInterface $container) {
      return new static(
        $container->get('formfactory'),
        $container->get('formfactorykits'),
      );
    }

    private function getFactory(array $form, FormStateInterface $form_state): FormFactoryInterface
    {
        return $this->formFactory->load($form, $form_state);
    }

    public function buildForm(array $form, FormStateInterface $form_state)
    {
        $form_factory = $this->getFactory($form, $form_state);
        $this->buildFormObject($form_factory, $this->kits);
        return $form_factory->getForm();
    }

    public function validateForm(array &$form, FormStateInterface $form_state)
    {
        if (method_exists($this, 'validateFormObject')) {
            $form_factory = $this->getFactory($form, $form_state);
            $this->validateFormObject($form_factory, $this->kits);
            return $form_factory->getForm();
        }
    }

    public function submitForm(array &$form, FormStateInterface $form_state)
    {
        if (method_exists($this, 'submitFormObject')) {
            $form_factory = $this->getFactory($form, $form_state);
            $this->submitFormObject($form_factory, $this->kits);
            return $form_factory->getForm();
        }
    }
}
