# Fox module

The module adds drush command: fox:console (fox). Command allow you to
obtain data at entity (context) levels. Context: entity_type.bundle.
The module can be useful during migrations or in cases where there
is only console access.

Console is a looped interactive command (like FoxPro command window).
The module keeps command history (by arrows up/down) and
autocomplete (by tab).

Fox commands:

  - USE
    Select context, for example node.page (node entity type, page bundle).
    Usage: USE [context]. USE without context cleared existing context.
  - GO
    Set context record.
    Usage: GO {TOP|BOTTOM|PREV [number]|NEXT [number]|number}
  - SEEK
    Seek context record by entity ID.
    Usage: SEEK id
  - BROWSE
    Browse fields for context record.
    Usage: BROWSE [*|fields] --vertical, --json").

  - APPEND
    Append record with fields.
    Usage: APPEND [uField1 WITH eExpr1 [, uField2 WITH eExpr2]
  - CLONE
    Clone context record.
    Usage: CLONE
  - REPLACE
    Replace fields for context record.
    Usage: REPLACE uField1 WITH eExpr1 [, uField2 WITH eExpr2] [LOOP @variable]
  - DELETE
    Delete context record.
    Usage: DELETE [LOOP @variable]

  - SET
    Set variables.
    Usage: SET var1 TO eExpr1 [, var2 TO eExpr2].
    Delete variable: SET var1 TO
  - PRINT
    Print variable.
    Usage: PRINT @var

  - LOAD
    Load file with fox commands.
    Usage: LOAD file
  - DRUSH
    Call an external Drush command.
    Usage: DRUSH command [JSON args] [JSON options])

  - INFO
    List entities,bundles or fields list for entity,bundle.
    Usage: INFO [entity_id.[bundle]]
  - LIST
    List Fox commands.
    Usage: LIST
  - SQL
    Execute SELECT SQL
    Usage: SQL expressions [INTO variable]
  - FILE
    File information
    Usage: File uri [INTO variable]

Usage examples:

  - # Block user with uid = 1
    SELECT status FROM user WHERE uid = 1 INTO data
    IF @data.0.status = 1 THEN REPLACE status WITH 0

  - # Clone entity Node Page
    SELECT title, body FROM node.page INTO data
    SET new_title TO 'new @data.0.title'
    APPEND title WITH '@new_title', body WITH '@data.0.body'

  - # Get node nid by referenced tag's name
    SET tagname TO 'test'
    SELECT tid FROM taxonomy_term WHERE vid = 'tags'
      AND name = @tagname INTO data
    SELECT nid FROM node.article WHERE field_tags = @data.0.tid

  - # Create menu and menu item
    USE menu
    APPEND id WITH test, label WITH Test, description WITH Test description
    USE menu_link_content.menu_link_content
    APPEND menu_name WITH test, title with Test title,
      link WITH internal:/mytest/example, description WITH Test menu item
    DRUSH cr

  - # Create taxonomy vocabulary and taxonomy term
    USE taxonomy_vocabulary
    SELECT vid WHERE vid = test
    IF @count <> 0 THEN QUIT
    APPEND vid WITH test, name WITH Test,
      description WITH Test taxonomy, status WITH 1, weight WITH 0
    USE taxonomy_term.test
    APPEND name WITH test tags, description WITH Test tag,
      status WITH 1, weight WITH 0
    PRINT Terms were created (count = @count)

  - # Delete orphaned nodes
    SQL UNIX_TIMESTAMP(DATE_SUB(NOW(), INTERVAL 1 MONTH))
      AS last_month INTO data
    PRINT Month ago timestamp: @data.0.last_month
    SELECT nid FROM node WHERE status = 0 AND
      changed < @data.0.last_month INTO nodes
    DELETE LOOP @nodes

Parameters:

## Table of contents

- Requirements
- Installation
- Configuration
- Maintainers

## Requirements

  - Install drush/drush
  - Install greenlion/php-sql-parser

## Installation

Install as you would normally install a contributed Drupal module. For further information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Configuration

  Drush command:
    fox:console (fox)
      --mode=[default]|debug
      --input="commands split ; or filename"
      --output[= filename]
    Run fox commands and query.

## Maintainers

- Serhii Klietsov - [goodboy](https://drupal.org/user/222910)
