<?php

namespace Drupal\fox\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * The FoxCommand attribute.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class FoxCommand extends Plugin {

  /**
   * Constructs a FoxCommand attribute.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $label
   *   The plugin label.
   */
  public function __construct(
    public readonly string $id,
    public readonly TranslatableMarkup $label,
  ) {}

}
