<?php

namespace Drupal\fox\Plugin\FoxCommand;

/**
 * CLONE fox command.
 *
 * @FoxCommand(
 *   id = "clone",
 *   label = @Translation("Entity clone. Usage: CLONE")
 * )
 */
class FoxCommandClone extends FoxCommandBaseClass {

  /**
   * {@inheritdoc}
   */
  public function execute(array $params, array $variables, array $options): array {
    $helper = $this->foxCommandsHelper();
    $entity = $helper->getEntity($variables);
    if (is_array($entity) and isset($entity['error'])) {
      return $entity;
    }
    if (empty($entity)) {
      return $this->errorReturn($this->t('Empty entity'));
    }
    if (!method_exists($entity, 'createDuplicate')) {
      return $this->errorReturn($this->t('The entity does not support createDublicate method'));
    }

    try {
      $duplicate = $entity->createDuplicate();
      $duplicate->save();
      $id = $duplicate->id();
    }
    catch (\Exception $e) {
      return $this->errorReturn($e->getMessage());
    }

    return [
      'message' => $this->t('The entity was cloned. New ID is @id.', [
        '@id' => $id,
      ]),
      'variables' => [
        'count' => $variables['count'] + 1,
      ],
    ];
  }

}
