<?php

namespace Drupal\fox\Plugin\FoxCommand;

/**
 * PRINT fox command.
 *
 * @FoxCommand(
 *   id = "print",
 *   label = @Translation("Print variable. Usage: PRINT {variables}")
 * )
 */
class FoxCommandPrint extends FoxCommandBaseClass {

  /**
   * {@inheritdoc}
   */
  public function execute(array $params, array $variables, array $options): array {
    if (empty($params)) {
      return $this->errorReturn($this->t('Empty command parameter.'));
    }

    $helper = $this->foxCommandsHelper();

    $message = [];
    $var = implode(' ', $params);
    $value = $helper->stringRender($var, $variables);
    if (is_array($value) || is_object($value)) {
      $value = print_r($value, TRUE);
    }
    $message[] = $value;

    return [
      'message' => $message,
      'hide_variables' => TRUE,
    ];
  }

}
