<?php

namespace Drupal\fox\Plugin\FoxCommand;

use Drupal\fox\FoxCommandsHelper as Helper;

/**
 * LOAD fox command.
 *
 * @FoxCommand(
 *   id = "load",
 *   label = @Translation("Load file. Usage: LOAD FILE")
 * )
 */
class FoxCommandLoad extends FoxCommandBaseClass {

  /**
   * {@inheritdoc}
   */
  public function execute(array $params, array $variables, array $options): array {
    if (empty($params)) {
      return $this->errorReturn($this->t('Empty command parameter.'));
    }

    $filename = reset($params);
    $file = Helper::getFilePath($filename);
    if (file_exists($file)) {
      $rows = Helper::loadFile($file);
    }
    else {
      return $this->errorReturn($this->t("File @file doesn't exist.", ['@file' => $file]));
    }

    return [
      'message' => $this->t('File @file was loaded', ['@file' => $file]),
      'commands' => $rows,
    ];
  }

}
