<?php

namespace Drupal\Tests\fragments\Functional;

use Drupal\Tests\BrowserTestBase;
use Drupal\Tests\fragments\Traits\FragmentTypeCreationTrait;

/**
 * Tests whether the auto entity label tab shows up.
 *
 * @group fragments
 */
class AutoEntitylabelTest extends BrowserTestBase {

  use FragmentTypeCreationTrait;

  /**
   * Fragment type.
   *
   * @var \Drupal\fragments\Entity\FragmentType
   */
  protected $fragmentType;

  /**
   * User variable.
   *
   * @var bool|\Drupal\user\Entity\User|false
   */
  protected $user;

  /**
   * Modules to enable.
   *
   * @var array
   */
  protected static $modules = [
    'fragments',
    'block',
    'system',
    'user',
    'auto_entitylabel',
  ];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->user = $this->drupalCreateUser([], '', TRUE);
    $this->drupalLogin($this->user);

    $this->fragmentType = $this->createFragmentType(['id' => 'tip']);
    $this->drupalPlaceBlock('local_tasks_block');
  }

  /**
   * Tests that prefilled option works correctly when adding node.
   */
  public function testAutoEntityLabel() {
    $webAssert = $this->assertSession();
    $this->drupalGet('/admin/structure/fragment-types/tip/edit');

    $webAssert->linkExists('Automatic label', 0, 'Local task for automatic entity label should exist.');
  }

}
