<?php

namespace Drupal\friendship;

use Drupal\user\UserInterface;

/**
 * Defines friendship interface.
 */
interface FriendshipInterface {

  /**
   * Follow user.
   *
   * @param \Drupal\user\UserInterface $target_user
   *   User object.
   */
  public function follow(UserInterface $target_user): void;

  /**
   * Unfollow user.
   *
   * @param \Drupal\user\UserInterface $target_user
   *   User object.
   */
  public function unfollow(UserInterface $target_user): void;

  /**
   * Accept friend request.
   *
   * @param \Drupal\user\UserInterface $target_user
   *   User object.
   */
  public function accept(UserInterface $target_user): void;

  /**
   * Remove from friend.
   *
   * @param \Drupal\user\UserInterface $target_user
   *   User object.
   */
  public function removeFriend(UserInterface $target_user): void;

  /**
   * Decline request.
   *
   * @param \Drupal\user\UserInterface $target_user
   *   User object.
   */
  public function decline(UserInterface $target_user): void;

  /**
   * Check if the request is already sent.
   *
   * @param \Drupal\user\UserInterface $target_user
   *   Target user.
   *
   * @return bool
   *   Indicates if the request was sent.
   */
  public function isRequestSend(UserInterface $target_user): bool;

  /**
   * Check if current user my friend.
   *
   * @param \Drupal\user\UserInterface $target_user
   *   Target user.
   *
   * @return bool
   *   Indicates if user is a friend.
   */
  public function isFriend(UserInterface $target_user): bool;

  /**
   * Check if the user already has some relationship.
   *
   * @param \Drupal\user\UserInterface $target_user
   *   Target user.
   *
   * @return bool
   *   Indicates if user has relationship.
   */
  public function isHasRelationship(UserInterface $target_user): bool;

  /**
   * Check if the target user is followed you.
   *
   * @param \Drupal\user\UserInterface $target_user
   *   Target user.
   *
   * @return bool
   *   Indicates if the user is followed.
   */
  public function isFollowedYou(UserInterface $target_user): bool;

}
