<?php

namespace Drupal\friendship\Plugin\views\field;

use Drupal\friendship\FriendshipInterface;
use Drupal\views\ResultRow;
use Drupal\views\Plugin\views\field\FieldPluginBase;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Field handler to flag the node type.
 *
 * @ingroup views_field_handlers
 *
 * @ViewsField("friendship_process_link")
 */
class ProcessFriendLink extends FieldPluginBase {

  /**
   * {@inheritdoc}
   */
  public function __construct(
    array $configuration,
    $plugin_id,
    $plugin_definition,
    protected FriendshipInterface $friendshipService,
  ) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('friendship.friendship_service'),
    );
  }

  /**
   * {@inheritdoc}
   */
  public function render(ResultRow $values) {
    /** @var \Drupal\user\Entity\User $target_user */
    $target_user = $values->_entity;

    return $this->friendshipService->getProcessLink($target_user);
  }

  /**
   * {@inheritdoc}
   */
  public function query() {
    // Leave empty to avoid a query in this field.
  }

}
