<?php

namespace Drupal\friendship\Plugin\views\field;

use Drupal\Core\Database\Connection;
use Drupal\views\ResultRow;
use Drupal\views\Plugin\views\field\FieldPluginBase;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Field handler to flag the node type.
 *
 * @ingroup views_field_handlers
 *
 * @ViewsField("total_followers_number")
 */
class TotalFollowersNumber extends FieldPluginBase {

  /**
   * {@inheritdoc}
   */
  public function __construct(
    array $configuration,
    $plugin_id,
    $plugin_definition,
    protected Connection $database,
  ) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('database'),
    );
  }

  /**
   * {@inheritdoc}
   */
  public function render(ResultRow $values) {
    /** @var \Drupal\user\Entity\User $target_user */
    $target_user = $values->_entity;

    $total_followers_count = $this->database->select('friendship', 'fr')
      ->condition('fr.uid', $target_user->id())
      ->condition('fr.status', -1)
      ->countQuery()
      ->execute()
      ->fetchField();

    return [
      '#type' => 'html_tag',
      '#tag' => 'div',
      '#value' => $total_followers_count,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function query() {
    // Leave empty to avoid a query in this field.
  }

}
