<?php

namespace Drupal\friendship\Plugin\views\field;

use Drupal\views\ResultRow;

/**
 * Field handler to show the total number of followings.
 *
 * @ingroup views_field_handlers
 *
 * @ViewsField("total_following_number")
 */
class TotalFollowingNumber extends TotalFollowersNumber {

  /**
   * {@inheritdoc}
   */
  public function render(ResultRow $values) {
    /** @var \Drupal\user\Entity\User $target_user */
    $target_user = $values->_entity;

    $total_following_count = $this->database->select('friendship', 'fr')
      ->condition('fr.uid', $target_user->id())
      ->condition('fr.status', 0)
      ->countQuery()
      ->execute()
      ->fetchField();

    return [
      '#type' => 'html_tag',
      '#tag' => 'div',
      '#value' => $total_following_count,
    ];
  }

}
