<?php

namespace Drupal\friendship\Plugin\views\field;

use Drupal\views\ResultRow;

/**
 * Field handler to friend number field.
 *
 * @ingroup views_field_handlers
 *
 * @ViewsField("total_friends_number")
 */
class TotalFriendsNumber extends TotalFollowersNumber {

  /**
   * {@inheritdoc}
   */
  public function render(ResultRow $values) {
    /** @var \Drupal\user\Entity\User $target_user */
    $target_user = $values->_entity;

    $total_friends_count = $this->database->select('friendship', 'fr')
      ->condition('fr.uid', $target_user->id())
      ->condition('fr.status', 1)
      ->countQuery()
      ->execute()
      ->fetchField();

    return [
      '#type' => 'html_tag',
      '#tag' => 'div',
      '#value' => $total_friends_count,
    ];
  }

}
