<?php

namespace Drupal\frontend_editing\Event;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\FieldableEntityInterface;

/**
 * Defines the entity reference delete access event.
 *
 * @package Drupal\frontend_editing\Event
 */
class EntityReferenceDeleteAccess extends EntityReferenceOperationsAccessBase {

  /**
   * The entity to delete.
   *
   * @var \Drupal\Core\Entity\EntityInterface
   */
  protected $entity;

  /**
   * EntityReferenceDeleteAccess constructor.
   *
   * @param \Drupal\Core\Entity\FieldableEntityInterface $parentEntity
   *   The parent entity.
   * @param string $fieldName
   *   The field name.
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The bundle.
   */
  public function __construct(FieldableEntityInterface $parentEntity, $fieldName, EntityInterface $entity) {
    parent::__construct($parentEntity, $fieldName);
    $this->entity = $entity;
  }

  /**
   * Gets the entity to move.
   *
   * @return \Drupal\Core\Entity\EntityInterface
   *   The entity to move.
   */
  public function getEntity() {
    return $this->entity;
  }

}
