<?php

namespace Drupal\frontend_editing\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\Core\Access\AccessResult;
use Drupal\Core\Entity\FieldableEntityInterface;

/**
 * Defines the entity reference operations access base event.
 *
 * @package Drupal\frontend_editing\Event
 */
class EntityReferenceOperationsAccessBase extends Event {

  use AccessResultTrait;

  /**
   * The parent entity.
   *
   * @var \Drupal\Core\Entity\FieldableEntityInterface
   */
  protected $parentEntity;

  /**
   * The field name.
   *
   * @var string
   */
  protected $fieldName;

  /**
   * EntityReferenceOperationsAccessBase constructor.
   *
   * @param \Drupal\Core\Entity\FieldableEntityInterface $parentEntity
   *   The parent entity.
   * @param string $fieldName
   *   The field name.
   */
  public function __construct(FieldableEntityInterface $parentEntity, $fieldName) {
    $this->parentEntity = $parentEntity;
    $this->fieldName = $fieldName;
    // By default, we allow the operation.
    $this->accessResult = AccessResult::allowed();
  }

  /**
   * Gets the parent entity.
   *
   * @return \Drupal\Core\Entity\FieldableEntityInterface
   *   The parent entity.
   */
  public function getParentEntity() {
    return $this->parentEntity;
  }

  /**
   * Gets the field name.
   *
   * @return string
   *   The field name.
   */
  public function getFieldName() {
    return $this->fieldName;
  }

}
