<?php

namespace Drupal\frontend_editing\Event;

/**
 * Defines events for the Frontend Editing module.
 */
final class FrontendEditingEvents {

  /**
   * Allows modules to alter the access result for entity reference move action.
   *
   * @Event
   *
   * @see \Drupal\frontend_editing\Event\EntityReferenceMoveAccess
   */
  const FE_ENTITY_REFERENCE_MOVE_ACCESS = EntityReferenceMoveAccess::class;

  /**
   * Allows modules to alter the access result for entity reference add action.
   *
   * @Event
   *
   * @see \Drupal\frontend_editing\Event\EntityReferenceAddAccess
   */
  const FE_ENTITY_REFERENCE_ADD_ACCESS = EntityReferenceAddAccess::class;

  /**
   * Allows modules to alter the access result for entity reference delete.
   *
   * @Event
   *
   * @see \Drupal\frontend_editing\Event\EntityReferenceDeleteAccess
   */
  const FE_ENTITY_REFERENCE_DELETE_ACCESS = EntityReferenceDeleteAccess::class;

}
