<?php

namespace Drupal\frontend_editing\Event;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\FieldableEntityInterface;

/**
 * Defines the entity reference move access event.
 *
 * @package Drupal\frontend_editing\Event
 */
class EntityReferenceMoveAccess extends EntityReferenceOperationsAccessBase {

  /**
   * The entity to move.
   *
   * @var \Drupal\Core\Entity\EntityInterface
   */
  protected $entity;

  /**
   * The operation.
   *
   * @var string
   */
  protected $operation;

  /**
   * EntityReferenceMoveAccess constructor.
   *
   * @param \Drupal\Core\Entity\FieldableEntityInterface $parentEntity
   *   The parent entity.
   * @param string $fieldName
   *   The field name.
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The entity to move.
   * @param string $operation
   *   The operation.
   */
  public function __construct(FieldableEntityInterface $parentEntity, $fieldName, EntityInterface $entity, $operation) {
    parent::__construct($parentEntity, $fieldName);
    $this->entity = $entity;
    $this->operation = $operation;
  }

  /**
   * Gets the entity to move.
   *
   * @return \Drupal\Core\Entity\EntityInterface
   *   The entity to move.
   */
  public function getEntity() {
    return $this->entity;
  }

  /**
   * Gets the operation up or down.
   *
   * @return string
   *   The operation to be performed.
   */
  public function getOperation() {
    return $this->operation;
  }

}
