/**
 * Implements preview.
 */
(function (Drupal, $, once) {
  Drupal.behaviors.feDetachEditor = {
    attach(context, settings) {
      once('detachEditor', '.frontend-editing-detach-editor', context).forEach(
        function (element) {
          if (window.name !== 'frontend-edit-detached') {
            $(element).on('click', function () {
              let url = window.location;
              const uuid = $(this).data('uuid');
              if (uuid) {
                const urlObject = new URL(url);
                urlObject.searchParams.set('uuid', uuid);
                url = urlObject.href;
              }
              window.open(
                url,
                'frontend-edit-detached',
                `popup,menubar=1,resizable=1,toolbar=1,scrollbars=1,left=100,top=100,width=${
                  window.screen.availWidth * 0.8
                },height=${window.screen.availHeight * 0.8}`,
              );
              return false;
            });
          } else {
            window.opener.parent.document.getElementById(
              'editing-container',
            ).style.display = 'none';
            $(window).on('beforeunload', function () {
              if (
                typeof window.opener !== 'undefined' &&
                typeof window.opener.parent !== 'undefined' &&
                typeof window.opener.parent.document !== 'undefined' &&
                typeof window.opener.parent.document.getElementById(
                  'editing-container',
                ) !== 'undefined'
              ) {
                window.opener.location = window.location;
                window.opener.parent.document
                  .getElementById('editing-container')
                  .classList.add('editing-container--loading');
                window.opener.parent.document.getElementById(
                  'editing-container',
                ).style.display = '';
              }
            });
            // @TODO re-attaching currently doesn't pass on the changes.
            $(element)
              .on('click', function () {
                window.close();
              })
              .attr('value', Drupal.t('Re-attach editor'));
          }
        },
      );
    },
  };
})(Drupal, jQuery, once);
