<?php

namespace Drupal\frontend_editing;

/**
 * Helper class for field reference.
 */
interface FieldReferenceHelperInterface {

  /**
   * Checks if the user is allowed to add a new reference to entity field.
   *
   * @param string $parent_type
   *   The parent entity type.
   * @param int $parent
   *   The parent entity ID.
   * @param string $parent_field_name
   *   The field name.
   *
   * @return \Drupal\Core\Access\AccessResult
   *   The access result.
   */
  public function accessAdd($parent_type, $parent, $parent_field_name);

  /**
   * Checks if the user is allowed to add a new reference to entity field.
   *
   * @param string $bundle
   *   The bundle.
   * @param string $parent_type
   *   The parent entity type.
   * @param int $parent
   *   The parent entity ID.
   * @param string $parent_field_name
   *   The field name.
   *
   * @return \Drupal\Core\Access\AccessResult
   *   The access result.
   */
  public function accessAddType($bundle, $parent_type, $parent, $parent_field_name);

  /**
   * Checks if the user is allowed to move a reference to entity field.
   *
   * @param string $parent_type
   *   The parent entity type.
   * @param int $parent
   *   The parent entity ID.
   * @param string $parent_field_name
   *   The field name.
   * @param int $current_item
   *   The current item ID.
   * @param string $operation
   *   The operation.
   *
   * @return \Drupal\Core\Access\AccessResult
   *   The access result.
   */
  public function accessMove($parent_type, $parent, $parent_field_name, $current_item, $operation);

  /**
   * Adds add item buttons.
   *
   * @param array $build
   *   The build array.
   *
   * @return array
   *   The build array.
   */
  public function addAddItemButtons(array $build);

  /**
   * Adds move buttons.
   *
   * @param array $build
   *   The build array.
   *
   * @return array
   *   The build array.
   */
  public function addMoveButtons(array $build);

  /**
   * Adds ajax content update.
   *
   * @param array $build
   *   The build array.
   *
   * @return array
   *   The build array.
   */
  public function addAjaxContentUpdate(array $build);

  /**
   * Moves the item.
   *
   * @param string $parent_type
   *   The parent entity type.
   * @param int $parent
   *   The parent entity ID.
   * @param string $parent_field_name
   *   The field name.
   * @param int $current_item
   *   The current item ID.
   * @param string $operation
   *   The operation.
   *
   * @return bool
   *   TRUE if the item was moved, FALSE otherwise.
   */
  public function move($parent_type, $parent, $parent_field_name, $current_item, $operation);

}
