<?php

namespace Drupal\frontend_editing_paragraphs;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityRepositoryInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Extension\ExtensionList;
use Drupal\Core\Routing\RedirectDestinationInterface;
use Drupal\Core\Session\AccountProxyInterface;
use Drupal\frontend_editing\FieldReferenceHelper;
use Drupal\frontend_editing\FieldReferenceHelperInterface;
use Drupal\paragraphs\ParagraphInterface;
use Drupal\paragraphs_edit\ParagraphLineageInspector;
use Drupal\paragraphs_edit\ParagraphLineageRevisioner;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;

/**
 * Class ParagraphsReferenceHelper decorates FieldReferenceHelper.
 */
class ParagraphsReferenceHelper extends FieldReferenceHelper {

  /**
   * The decorated service.
   *
   * @var \Drupal\frontend_editing\FieldReferenceHelperInterface
   */
  protected $inner;

  /**
   * The lineage inspector.
   *
   * @var \Drupal\paragraphs_edit\ParagraphLineageInspector
   */
  protected $lineageInspector;

  /**
   * The lineage revisioner.
   *
   * @var \Drupal\paragraphs_edit\ParagraphLineageRevisioner
   */
  protected $lineageRevisioner;

  /**
   * Constructs a new FieldReferenceHelper object.
   *
   * @param \Drupal\frontend_editing\FieldReferenceHelperInterface $inner
   *   The inner service.
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The config factory.
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entity_type_manager
   *   The entity type manager.
   * @param \Drupal\Core\Session\AccountProxyInterface $current_user
   *   The current user.
   * @param \Drupal\Core\Entity\EntityRepositoryInterface $entity_repository
   *   The entity repository.
   * @param \Symfony\Component\EventDispatcher\EventDispatcherInterface $event_dispatcher
   *   The event dispatcher.
   * @param \Drupal\Core\Routing\RedirectDestinationInterface $redirect_destination
   *   The redirect destination.
   * @param \Drupal\Core\Extension\ExtensionList $extension_list
   *   The module list.
   * @param \Drupal\paragraphs_edit\ParagraphLineageInspector $paragraph_lineage_inspector
   *   The lineage inspector.
   * @param \Drupal\paragraphs_edit\ParagraphLineageRevisioner $paragraph_lineage_revisioner
   *   The lineage revisioner.
   */
  public function __construct(FieldReferenceHelperInterface $inner, ConfigFactoryInterface $config_factory, EntityTypeManagerInterface $entity_type_manager, AccountProxyInterface $current_user, EntityRepositoryInterface $entity_repository, EventDispatcherInterface $event_dispatcher, RedirectDestinationInterface $redirect_destination, ExtensionList $extension_list, ParagraphLineageInspector $paragraph_lineage_inspector, ParagraphLineageRevisioner $paragraph_lineage_revisioner) {
    parent::__construct($config_factory, $entity_type_manager, $current_user, $entity_repository, $event_dispatcher, $redirect_destination, $extension_list);
    $this->inner = $inner;
    $this->lineageInspector = $paragraph_lineage_inspector;
    $this->lineageRevisioner = $paragraph_lineage_revisioner;
  }

  /**
   * {@inheritDoc}
   */
  public function saveParentEntity(ContentEntityInterface $parent_entity, ContentEntityInterface $entity) {
    if ($entity instanceof ParagraphInterface) {
      $root_parent = $this->lineageInspector->getRootParent($entity);
      if ($this->lineageRevisioner->shouldCreateNewRevision($root_parent)) {
        $this->lineageRevisioner->saveNewRevision($parent_entity);
      }
      else {
        $parent_entity->save();
      }
    }
    else {
      $this->inner->saveParentEntity($parent_entity, $entity);
    }
  }

}
