<?php

namespace Drupal\frontend_editing\Event;

use Drupal\Core\Entity\FieldableEntityInterface;

/**
 * Defines the entity reference add access event.
 *
 * @package Drupal\frontend_editing\Event
 */
class EntityReferenceAddAccess extends EntityReferenceOperationsAccessBase {

  /**
   * The bundle.
   *
   * @var string
   */
  protected $bundle;

  /**
   * EntityReferenceAddAccess constructor.
   *
   * @param \Drupal\Core\Entity\FieldableEntityInterface $parentEntity
   *   The parent entity.
   * @param string $fieldName
   *   The field name.
   * @param string $bundle
   *   The bundle.
   */
  public function __construct(FieldableEntityInterface $parentEntity, $fieldName, $bundle) {
    parent::__construct($parentEntity, $fieldName);
    $this->bundle = $bundle;
  }

  /**
   * Gets the bundle.
   *
   * @return string
   *   The bundle.
   */
  public function getBundle() {
    return $this->bundle;
  }

}
