<?php

namespace Drupal\frontend_editing;

use Drupal\Core\Entity\ContentEntityInterface;

/**
 * Interface for FrontendEditingFormBuilder.
 */
interface FrontendEditingFormBuilderInterface {

  /**
   * Gets the form for given entity, operation and form display.
   *
   * @param \Drupal\Core\Entity\ContentEntityInterface $entity
   *   The given entity.
   * @param string $operation
   *   The operation.
   * @param string $display
   *   The display name.
   *
   * @return array
   *   The entity form.
   */
  public function buildForm(ContentEntityInterface $entity, $operation = 'edit', $display = 'default');

}
