<?php

namespace Drupal\Tests\frontify_assets\Unit\Plugin\media\Source;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Entity\EntityFieldManagerInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Field\FieldTypePluginManagerInterface;
use Drupal\Core\Render\RendererInterface;
use Drupal\frontify_assets\Plugin\media\Source\FrontifyAssets;
use Drupal\media\MediaTypeInterface;
use Drupal\Tests\UnitTestCase;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * @coversDefaultClass \Drupal\frontify_assets\Plugin\media\Source\FrontifyAssets
 *
 * @group frontify_assets
 */
class FrontifyAssetsTest extends UnitTestCase {

  /**
   * @covers ::create
   */
  public function testCreate(): void {
    $container = $this->createMock(ContainerInterface::class);

    $entityTypeManager = $this->createMock(EntityTypeManagerInterface::class);
    $entityFieldManager = $this->createMock(EntityFieldManagerInterface::class);
    $fieldTypeManager = $this->createMock(FieldTypePluginManagerInterface::class);
    $configFactory = $this->createMock(ConfigFactoryInterface::class);
    $renderer = $this->createMock(RendererInterface::class);
  
    // Use willReturnMap instead of withConsecutive.
    $container->method('get')->willReturnMap([
      ['entity_type.manager', $entityTypeManager],
      ['entity_field.manager', $entityFieldManager],
      ['plugin.manager.field.field_type', $fieldTypeManager],
      ['config.factory', $configFactory],
      ['renderer', $renderer],
    ]);
  
    $plugin = FrontifyAssets::create($container, [], 'frontify_assets', []);
  
    $this->assertInstanceOf(FrontifyAssets::class, $plugin);
    }

  /**
   * @covers ::getMetadataAttributes
   */
  public function testGetMetadataAttributes(): void {
    $plugin = new FrontifyAssets([], 'frontify_assets', [], $this->createMock(EntityTypeManagerInterface::class), $this->createMock(EntityFieldManagerInterface::class), $this->createMock(FieldTypePluginManagerInterface::class), $this->createMock(ConfigFactoryInterface::class), $this->createMock(RendererInterface::class));
    $this->assertNull($plugin->getMetadataAttributes());
  }

  /**
   * @covers ::getSourceFieldConstraints
   */
  public function testGetSourceFieldConstraints(): void {
    $plugin = new FrontifyAssets([], 'frontify_assets', [], $this->createMock(EntityTypeManagerInterface::class), $this->createMock(EntityFieldManagerInterface::class), $this->createMock(FieldTypePluginManagerInterface::class), $this->createMock(ConfigFactoryInterface::class), $this->createMock(RendererInterface::class));
    $this->assertSame([], $plugin->getSourceFieldConstraints());
  }

  /**
   * @covers ::createSourceField
   */
  public function testCreateSourceField(): void {
    $plugin = $this->getMockBuilder(FrontifyAssets::class)
      ->setConstructorArgs([
        [], 'frontify_assets', [],
        $this->createMock(EntityTypeManagerInterface::class),
        $this->createMock(EntityFieldManagerInterface::class),
        $this->createMock(FieldTypePluginManagerInterface::class),
        $this->createMock(ConfigFactoryInterface::class),
        $this->createMock(RendererInterface::class),
      ])
      ->onlyMethods(['createSourceField'])
      ->getMock();

    $mediaType = $this->createMock(MediaTypeInterface::class);

    // Fake field definition with a "label" property.
    $fieldDefinition = new class {
      protected $properties = [];
      public function set($key, $value) {
        $this->properties[$key] = $value;
        return $this;
      }
      public function getLabel() {
        return $this->properties['label'] ?? NULL;
      }
    };

    $plugin->expects($this->once())
      ->method('createSourceField')
      ->with($mediaType)
      ->willReturn($fieldDefinition->set('label', 'Frontify Image'));

    $result = $plugin->createSourceField($mediaType);
    $this->assertEquals('Frontify Image', $result->getLabel());
  }

}
