The **Full Screen Mode** module for Drupal allows you to provide users with
a distraction-free, full-screen experience on your website. This module
enables the site to toggle between normal and full-screen mode with a
simple button, offering a smooth user interface that helps users engage
with content without distractions.

Table of Contents
-----------------

*   Requirements
    

*   Installation

*   Configuration

*   Troubleshooting & FAQ

Requirements
------------

*   Drupal 10 or higher
    
*   A modern browser that supports Fullscreen API (most major browsers
support it)
    

Installation
------------

1.  Download the **Full Screen Mode** module.
    
2.  Install the module using Composer or the Drupal admin interface:
    
    Using Composer:
    

`composer require drupal/full_screen_mode`

Alternatively, you can manually download and install it as a standard
Drupal module. See the [Drupal documentation](https://www.drupal.org/docs/8/extending-drupal-8/installing-modules)

*   for installation instructions.
    
*   Enable the module via the **Extend** menu or by using Drush:
    

1.  `drush en full_screen_mode`
    
2.  Place the **Full Screen Mode** block in the desired region of your theme.
    

Configuration
-------------

### Configure the Full Screen Mode Button

1.  Navigate to **Block Layout** and find the **Full Screen Mode** block.
    
2.  Place the block in the region you want the fullscreen toggle button
to appear.
    
3.  Configure the button's position and appearance by editing the block's
settings.
    

### Button Settings

*   **Position**: Choose where the fullscreen button appears on the page
(Top Right, Top Left, Bottom Right, Bottom Left).
    
*   **Top, Bottom, Left, Right**: Fine-tune the position of the button
relative to the page edges.
    
*   **Button Width**: Set the width of the fullscreen button.
    
*   **Measurement Unit**: Choose the measurement unit for positioning
(px, em, rem, or %).
    
*   **Stroke Color**: Set the stroke color of the fullscreen button.
    
*   **Stroke Width**: Set the stroke width of the button.
    
*   **Active**: Enable or disable the fullscreen functionality.
*   **Hide on Mobile**: Check this option to hide the fullscreen
button on mobile devices (responsive CSS will be applied automatically).
Note: The Hide on Mobile option adds a CSS class to the button
(hide-on-mobile) and hides it on screens smaller than 768px.


Troubleshooting & FAQ
---------------------

If you encounter any issues, here are some common troubleshooting steps:

*   **Button not visible?**: Ensure the **Full Screen Mode** block is
enabled and placed in a visible region.
    
*   **Fullscreen not toggling?**: Verify that your browser supports
*   **Button hidden on mobile?**: 
If the “Hide on Mobile” checkbox is enabled, the button will not
appear on small screens (width < 768px).
    

For additional questions or issues, feel free to open an issue on the module's [Drupal page](https://www.drupal.org/project/full_screen_mode).

Maintainers
-----------
This module is maintained by Sujan Shrestha - [sujan-shrestha](https://www.drupal.org/u/sujan-shrestha)
