(function ($, Drupal, drupalSettings) {
  Drupal.behaviors.analog_behavior = {
    attach(context, settings) {
      // $(once('full_screen_mode', 'body')).each(function (element) {
      once('full_screen_mode', '.js-full-screen-mode-btn', context).forEach(
        function (fullscreenElement) {
          const toggleBtn = $(fullscreenElement);
          if (document.fullscreenEnabled || document.webkitFullscreenEnabled) {
            // On button click, toggle fullscreen mode and update the button's visual state
            toggleBtn.on('click', function () {
              // Toggle fullscreen based on the current state
              if (document.fullscreenElement) {
                document.exitFullscreen();
              } else if (document.webkitFullscreenElement) {
                document.webkitCancelFullScreen();
              } else if (document.documentElement.requestFullscreen) {
                document.documentElement.requestFullscreen();
              } else if (document.documentElement.webkitRequestFullScreen) {
                document.documentElement.webkitRequestFullScreen();
              }

              // Toggle 'on' class only for the clicked button
              $(this).toggleClass('on');

              // Update the aria-label for the clicked button
              if ($(this).hasClass('on')) {
                $(this).attr('aria-label', 'Exit fullscreen mode');
              } else {
                $(this).attr('aria-label', 'Enter fullscreen mode');
              }
            });
          }

          let isActive = true;
          let timeout;

          function dimElement() {
            if (isActive) {
              toggleBtn.addClass('dim');
              isActive = false;
            }
          }

          function resetElement() {
            if (!isActive) {
              toggleBtn.removeClass('dim');
              isActive = true;
            }
          }

          $(document).mousemove(function () {
            clearTimeout(timeout);
            resetElement();

            timeout = setTimeout(dimElement, 3000);
          });

          timeout = setTimeout(dimElement, 3000);
        },
      );
    },
  };
})(jQuery, Drupal, drupalSettings);
