INTRODUCTION
------------

This module integrates the 'FullscreenX.js' library:
- https://github.com/mahyarsbt/FullscreenX

FullscreenX is a zero-dependency, promise-based fullscreen library
for modern browsers with a simple, yet powerful API.

It works with any HTML element and provides cross-browser compatibility
with automatic vendor prefix resolution, event management, and more.


FEATURES
--------

'FullscreenX' plugin is:

- Zero dependencies

- Tiny footprint (3.70KB minified)

- Promise-based API

- Cross-browser compatible

- Smart vendor prefix detection

- Event management system

- TypeScript support


REQUIREMENTS
------------

Download 'FullscreenX.js' Library:
- https://github.com/mahyarsbt/FullscreenX/archive/refs/tags/v1.0.0.tar.gz


INSTALLATION
------------

1. Download 'Fullscreen' module archive
  - https://www.drupal.org/project/fullscreen

2. Extract and place it in the root modules directory i.e.
   /modules/fullscreen or /modules/contrib/fullscreen

3. Create a libraries directory in the root, if not already there i.e.
   /libraries

4. Create a 'FullscreenX' directory inside it i.e.
   /libraries/FullscreenX

5. Download 'FullscreenX' library
  - https://github.com/mahyarsbt/FullscreenX/archive/refs/tags/v1.0.0.tar.gz

6. Extract and place it in the /libraries/FullscreenX directory ensuring
   the file exists at:
   /libraries/FullscreenX/dist/fullscreenx.min.js

7. Now, enable 'Fullscreen' module.


USAGE
-----

Here is a FullscreenX example:

```javascript
  // Enter fullscreen for entire page.
  FullscreenX.request().then(() => {
    console.log('Entered fullscreen!');
  });

  // Enter fullscreen for specific element.
  FullscreenX.request('#video-player');

  // Exit fullscreen.
  FullscreenX.exit();

  // Toggle fullscreen state.
  FullscreenX.toggle('#content');

  // Listen to fullscreen events.
  FullscreenX.on('enter', () => console.log('Entered fullscreen'));
  FullscreenX.on('exit', () => console.log('Exited fullscreen'));

  // Check if fullscreen is supported.
  if (FullscreenX.isEnabled()) {
    // Fullscreen API is available.
  }
```

Check official FullscreenX documentation for more information:
- https://github.com/mahyarsbt/FullscreenX#readme


CDN USAGE
---------

If the library is not installed locally, the module will automatically
load FullscreenX.js from jsDelivr CDN:
- https://cdn.jsdelivr.net/npm/fullscreenx@1.0.0/dist/fullscreenx.min.js

For best performance and reliability, we recommend installing the library
locally as described in the INSTALLATION section above.


How does it Work?
=================

1. Download FullscreenX.js library, Follow INSTALLATION above.

2. Enable "Fullscreen" module, Follow INSTALLATION above.

3. Add script to your theme/module JS file, Follow USAGE above.

4. Enjoy fullscreen functionality!


BROWSER SUPPORT
---------------

| Browser | Version | Notes                    |
|---------|---------|--------------------------|
| Chrome  | 71+     | Full support             |
| Firefox | 64+     | Full support             |
| Safari  | 12.1+   | Limited options support |
| Edge    | 79+     | Full support             |
| Opera   | 58+     | Full support             |


MAINTAINERS
-----------

Current maintainer:

* Mahyar Sabeti - https://www.drupal.org/u/mahyarsbt

DEMO
----
https://mahyarsbt.github.io/FullscreenX/demo/
